<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Installieren von %%name%% unter %%path%%...',
    'aps-install.queueNoPath' => 'Installieren von %%name%%...',
    'aps-install.done' => '%%name%% wurde erfolgreich unter %%path%% installiert. Sie können Ihre Zugangsdaten für die Anmeldung bei der Anwendung unten einsehen. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% wurde erfolgreich installiert. Sie können Ihre Zugangsdaten für die Anmeldung bei der Anwendung unten einsehen. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% wurde erfolgreich unter %%path%% installiert. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% wurde erfolgreich installiert. %%additionalMessage%%',
    'aps-install.error' => 'Die Installation von %%name%% unter %%path%% ist fehlgeschlagen. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Die Installation von %%name%% ist fehlgeschlagen. %%errorMessage%%',

    'aps-update.queueDownload' => 'Lade %%packageName%% herunter...',
    'aps-update.errorDownload' => 'Der Download von %%packageName%% ist fehlgeschlagen:',
    'aps-update.queueInstall' => 'Aktualisiere eine Installation von %%name%% für %%domainName%%...',
    'aps-update.doneInstall' => 'Die Installation von %%name%% für %%domainName%% wurde erfolgreich aktualisiert.',
    'aps-update.errorInstall' => 'Das Update einer Installation von %%name%% für %%domainName%% ist fehlgeschlagen:',
    'aps-update.queueInstallMulti' => 'Aktualisiere %%instances%% Installationen von %%name%%...',
    'aps-update.doneInstallMulti' => '%%successes%% Installationen von %%name%% wurden erfolgreich aktualisiert.',
    'aps-update.errorInstallMulti' => 'Das Update von %%failures%% Installationen von %%name%% ist fehlgeschlagen:',
    'aps-update.incorrectUpdateInformation' => 'Die Update-Informationen sind nicht korrekt.',

    'common.hideCompletedTasks' => 'Abgeschlossene ausblenden',
    'common.progressBarHide' => 'Ausblenden',
    'common.progressBarShow' => 'Anzeigen',
    'common.close' => 'Schließen',
    'common.refresh' => 'Seite aktualisieren',
    'common.taskInProgress' => '%%count%% Aufgaben werden bearbeitet...',
    'common.percentCompleted' => '%%percent%%% abgeschlossen',
    'common.allTasksCompleted' => 'Alle Aufgaben (%%num%%) wurden erfolgreich fertiggestellt.',
    'common.minimize' => 'Minimieren',
    'common.statusDone' => 'Fertig',
    'common.statusError' => 'Fehlgeschlagen',
    'common.statusNotStarted' => 'In Warteschlange',
    'common.statusCanceled' => 'Abgebrochen',
    'common.progressDialogLink' => 'Details',

    'database-check.queue' => 'Überprüfe %%database%% Datenbanktabellen...',
    'database-check.done' => 'Keine Fehler in der Datenbank %%database%% feststellbar.',
    'database-check.error' => 'Die Datenbank %%database%% kann nicht auf Fehler überprüft werden.',
    'database-check.done-with-errors' => "Die Datenbank %%database%% weist %%number%% Probleme auf. \n %%link%%",
    'database-check.info-link-title' => 'Einzelheiten ansehen und lösen',

    'database-download.queue' => 'Bereite ein Abbild von %%database%% zum Exportieren vor...',
    'database-download.done' => 'Das Abbild von %%database%% ist fertig. Sie können es %%downloadLink%%.',
    'database-download.downloadLink' => 'herunterladen',
    'database-download.error' => 'Das Abbild von %%database%% kann nicht exportiert werden:',

    'database-repair.queue' => 'Repariere %%database%% Datenbanktabellen...',
    'database-repair.done' => 'Keine Fehler in der Datenbank %%database%% feststellbar.',
    'database-repair.error' => 'Die Datenbank %%database%% konnte nicht repariert werden.',
    'database-repair.done-with-errors' => "Die Datenbank %%database%% weist %%number%% Probleme auf. \n %%link%%",
    'database-repair.info-link-title' => 'Einzelheiten ansehen',

    'database-upload.queue' => 'Importiere ein Abbild von %%database%%...',
    'database-upload.done' => 'Das Abbild von %%database%% wurde importiert.',
    'database-upload.error' => 'Das Abbild von %%database%% konnte nicht importiert werden:',
    'database-upload.done-with-errors' => "Das Abbild von %%database%% wurde importiert, jedoch traten Fehler auf.",
    'database-upload.orphanedUsersSuccess' => 'Die Datenbank %%database%% wurde erfolgreich importiert. Jedoch sind einige Benutzer verwaist (sie haben keine verknüpften Anmeldedaten auf dem Datenbankserver). Um auf Ihre Datenbanken zugreifen zu können, müssen Sie diesen Benutzern Anmeldedaten zuweisen. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Folgende Benutzer werden verwaist sein (sie haben keine verknüpften Anmeldedaten auf dem Datenbankserver): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Sehen Sie sich die Benutzer an',

    'domain-app-scan.queue' => 'Suche nach Anwendungen...',
    'domain-app-scan.done' => 'Die Suche nach Anwendungen wurde abgeschlossen.',
    'domain-app-scan.error' => 'Die Suche nach Anwendungen wurde mit Fehlern abgeschlossen.',

    'domain-move.queue' => '%%domainName%% wird nach %%webspaceName%% verschoben',
    'domain-move.done' => '%%domainName%% wurde nach %%webspaceName%% verschoben',
    'domain-move.error' => '%%domainName%% wurde nicht nach %%webspaceName%% verschoben',

    'domain-split.queue' => '%%domainName%% wird in ein neues Abonnement verschoben',
    'domain-split.done' => '%%domainName%% wurde in ein neues Abonnement verschoben',
    'domain-split.error' => '%%domainName%% wurde nicht in ein neues Abonnement verschoben',

    'file-manager-import-file.done' => 'Die Datei %%fileName%% wurde in den <a href="%%listUrl%%">Ordner %%fileDir%%</a> importiert.',
    'file-manager-import-file.error' => 'Die Datei %%fileName%% konnte nicht importiert werden: %%errorMessage%%.<br><a href="%%url%%">Auf meinen Computer herunterladen</a>',
    'file-manager-import-file.queue' => 'Die Datei %%fileName%% wird von %%host%% importiert.',
    'file-manager-import-file.progress' => 'Die Datei %%fileName%% wird von %%host%% importiert (%%value%% MB).',
    'file-manager-import-file.errors.auth' => 'Ein Authentifizierungsfehler ist aufgetreten. Stellen Sie sicher, dass Sie den richtigen Benutzernamen und das entsprechende Passwort eingegeben haben.',
    'file-manager-import-file.errors.resolve' => 'Der Hostname %%host%% konnte nicht aufgelöst werden. Vergewissern Sie sich, die richtige URL angegeben zu haben.',
    'file-manager-import-file.errors.connect' => 'Keine Verbindung mit dem Server %%host%% möglich. Vergewissern Sie sich, die richtige URL angegeben zu haben.',
    'file-manager-import-file.errors.notFound' => 'Die Remote-Datei wurde nicht gefunden oder der Zugriff ist nicht möglich. Vergewissern Sie sich, dass Sie die richtige URL angegeben haben und dass auf die Datei zugegriffen werden kann.',
    'file-manager-import-file.errors.maxSize' => 'Das Speicherplatzlimit oder der verfügbare freie Speicherplatz %%diskSpaceLimit%% wurde überschritten',
    'file-manager-import-file.errors.lowSpeedTime' => 'Die Datei konnte nicht importiert werden, weil die Übertragungsgeschwindigkeit zu niedrig war: Während der letzten %%lowSpeedTime%% Sekunden wurden weniger als %%lowSpeedLimit%% Bytes übertragen. Die Website, auf der die Datei gehostet wird, verzeichnet derzeit möglicherweise viele Zugriffe. Versuchen Sie später erneut, die Datei zu importieren.',
    'file-manager-import-file.errors.certificate' => 'Die Datei konnte nicht importiert werden, weil das SSL/TLS-Zertifikat des Servers %%host%% nicht vertrauenswürdig ist. Vergewissern Sie sich, dass die Website, auf der die Datei gehostet wird, mit einem vertrauenswürdigen Zertifikat geschützt ist.',
    'file-manager-import-file.errors.redirects' => 'Die maximale Anzahl von Umleitungen (%%maxRedirects%%) wurde überschritten. Vergewissern Sie sich, dass der Server %%host%% richtig funktioniert.',

    'force-log-rotation.queue' => 'Globale Einstellungen für die Protokollrotation werden angewendet',
    'force-log-rotation.done' => 'Die globalen Einstellungen für die Protokollrotation wurden angewendet.',
    'force-log-rotation.error' => 'Fehler beim Anwenden der globalen Einstellungen für die Protokollrotation',
    'force-log-rotation.systemLogRotationError' => 'Systemprotokolle: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Service-Paket %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Domain %%name%%: %%error%%',

    'initial-setup.queue' => 'Plesk wird initialisiert...',
    'initial-setup.done' => 'Plesk wurde initialisiert.',
    'initial-setup.doneWithErrors' => 'Fehler beim Initialisieren von Plesk.',
    'initial-setup.error' => 'Plesk konnte nicht initialisiert werden.',
    'initial-setup.step.setupPanel' => 'Plesk Panel einrichten',
    'initial-setup.step.requestLicense' => 'Lizenz anfordern',
    'initial-setup.step.configureServer' => 'Webserver konfigurieren',
    'initial-setup.step.secureServer' => 'Server schützen',

    'ip-update.queue' => 'IP-Adresse aktualisieren',
    'ip-update.done' => 'IP-Adresse aktualisiert.',
    'ip-update.error' => 'Fehler beim Aktualisieren der IP-Adresse',
    'ip-update.updating' => 'IP-Adresse aktualisieren',
    'ip-update.updatingWebServer' => 'IP-Adresse aktualisieren: Webserver aktualisieren',
    'ip-update.updatingFtpServer' => 'IP-Adresse aktualisieren: FTP-Server aktualisieren',
    'ip-update.updatingDnsZones' => 'IP-Adresse aktualisieren: DNS-Zonen aktualisieren',
    'ip-update.restartingDnsService' => 'IP-Adresse aktualisieren: DNS-Server neu starten',

    'ip-reload-public.queue' => 'Aktualisieren öffentlicher IP-Adressen mithilfe von Cloud-Metadaten',
    'ip-reload-public.done' => 'Öffentliche IP-Adressen wurden aktualisiert',

    'logrotate_anonymize_ips.queue' => 'IP-Adressen in Protokollen anonymisieren',
    'logrotate_anonymize_ips.queueRevert' => 'Anonymisierung von IP-Adressen in Protokollen aufheben',
    'logrotate_anonymize_ips.done' => 'IP-Adressen wurden anonymisiert.',
    'logrotate_anonymize_ips.doneRevert' => 'Anonymisierung der IP-Adressen wurde aufgehoben.',
    'logrotate_anonymize_ips.error' => 'Fehler beim Anonymisieren von IP-Adressen',
    'logrotate_anonymize_ips.errorRevert' => 'Fehler beim Aufheben der Anonymisierung von IP-Adressen',

    'panel-components-install.queue' => 'Installieren der ausgewählten Komponenten',
    'panel-components-install.done' => 'Die ausgewählten Komponenten wurden erfolgreich installiert.',
    'panel-components-install.error' => 'Die Komponenten können nicht installiert werden. Die Benachrichtigung mit Fehlerbeschreibung wurde an Ihre E-Mail-Adresse gesendet.',

    'panel-update.queue' => 'In Plesk werden gerade Updates installiert. Dies kann einige Zeit dauern. %%warning%%',
    'panel-update.warning' => 'Bitte führen Sie keine Verwaltungsvorgänge in Plesk aus, solange das Update läuft.',
    'panel-update.done' => 'Plesk wurde aktualisiert. Weitere Informationen finden Sie im %%changelog%%.',
    'panel-update.changelog' => 'Änderungsprotokoll von Plesk',
    'panel-update.error' => 'Fehler beim Aktualisieren von Plesk. %%errorDetails%%',
    'panel-update.support' => 'Senden Sie das Update-Protokoll an den Plesk Support, um das Problem zu beheben. %%failedLog%% Kopieren Sie das Protokoll auf Ihren Computer, bevor Sie diese Nachricht schließen.',
    'panel-update.failedLog' => 'Update-Protokoll von %%date%% anzeigen.',

    'pum-update-packages.queue' => 'Aktualisieren von %%count%% Paket(en)...',
    'pum-update-packages.done' => '%%count%% Pakete wurden erfolgreich aktualisiert.',
    'pum-update-packages.error' => 'Fehler beim Update',

    'scheduler-run-task.queue' => 'Führe Aufgabe "%%task%%" aus...',
    'scheduler-run-task.done' => 'Die Aufgabe "%%task%%" wurde erfolgreich in %%seconds%% Sekunden abgeschlossen.',
    'scheduler-run-task.error' => 'Die Aufgabe "%%task%%" wurde in %%seconds%% Sekunden abgeschlossen, jedoch traten Fehler auf.',
    'scheduler-run-task.popupSeeDetails' => 'Einzelheiten ansehen',
    'scheduler-run-task.popupTitle' => 'Geplante Aufgabe ausführen',
    'scheduler-run-task.popupDone' => 'Die Aufgabe "%%task%%" wurde erfolgreich in %%seconds%% Sekunden abgeschlossen',
    'scheduler-run-task.popupError' => 'Die Aufgabe "%%task%%" wurde in %%seconds%% Sekunden abgeschlossen, jedoch traten Fehler auf',
    'scheduler-run-task.popupClose' => 'Schließen',

    'sdk.queue' => 'Die Aufgabe "%%name%%" wird verarbeitet...',
    'sdk.error' => 'Die Aufgabe "%%name%%" ist fehlgeschlagen.',
    'sdk.done' => 'Die Aufgabe "%%name%%" wurde abgeschlossen.',
    'sdk.canceled' => 'Die Aufgabe "%%name%%" wurde abgebrochen.',

    'sync-php-settings.queue' => 'Globale PHP-Einstellungen (Version %%version%%) werden auf Domains angewendet',
    'sync-php-settings.done' => 'Die globalen PHP-Einstellungen (Version %%version%%) wurden auf die Domains angewendet',
    'sync-php-settings.error' => 'Fehler beim Anwenden der globalen PHP-Einstellungen (Version %%version%%) auf die Domains',

    'sync-service-plan.queue' => 'Synchronisierung von Service-Paket %%name%% mit Abonnements',
    'sync-service-plan.done' => 'Service-Paket %%name%% wurde mit Abonnements synchronisiert',
    'sync-service-plan.doneWithErrors' => 'Die Synchronisierung des Service-Pakets %%name%% wurde abgeschlossen. Einige Abonnements wurden nicht mit dem Paket synchronisiert.',
    'sync-service-plan.error' => 'Fehler beim Synchronisieren des Service-Pakets %%name%% mit Abonnements',

    'domain-create.queue' => 'Domain %%domainName%% wird erstellt',
    'domain-create.done' => 'Domain %%domainName%% erstellt',
    'domain-create.error' => 'Erstellung der Domain %%domainName%% fehlgeschlagen',
    'domain-create.warning' => 'Folgende Probleme sind beim Erstellen der Domain %%domainName%% aufgetreten:<br> %%problems%%',
    'domain-create.refreshUrl' => 'Anzeigen',
    'domain-create.steps.createCustomer' => 'Kunden erstellen',
    'domain-create.steps.createSubscription' => 'Abonnement erstellen',
    'domain-create.steps.createDomain' => 'Domain hinzufügen',
    'domain-create.steps.configureDns' => 'DNS-Zone konfigurieren',
    'domain-create.steps.createHosting' => 'Physikalisches Hosting erstellen',
    'domain-create.steps.configurePhp' => 'PHP konfigurieren',
    'domain-create.steps.configureMail' => 'E-Mail konfigurieren',

    'domain-delete.queue' => 'Löschung der Domain wird verarbeitet',
    'domain-delete.done' => 'Domains gelöscht',
    'domain-delete.error' => 'Domainlöschung fehlgeschlagen',
    'domain-delete.step.domains' => 'Domains werden gelöscht …',

    'domain-resolve-checking.warning' => 'Probleme beim Auflösen der Domain %%domainName%% erkannt: <br> %%errors%%',

    'customer-create.queue' => 'Kunde %%customerName%% wird erstellt',
    'customer-create.done' => 'Kunde %%customerName%% wurde erstellt',
    'customer-create.error' => 'Erstellung des Kunden %%customerName%% fehlgeschlagen',
    'customer-create.warning' => 'Folgende Probleme sind beim Erstellen des Kunden %%customerName%% aufgetreten:<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Sie können die Synchronisierung manuell durchführen.',

    'customer-delete.queue' => 'Löschung der Kunden wird durchgeführt',
    'customer-delete.done' => 'Kunden wurden gellöscht',
    'customer-delete.error' => 'Löschung der Kunden fehlgeschlagen',

    'reseller-delete.queue' => 'Löschung der Reseller wird durchgeführt',
    'reseller-delete.done' => 'Reseller gelöscht',
    'reseller-delete.error' => 'Löschung der Reseller gescheitert',

    'subscription-create.queue' => 'Abonnement %%subscriptionName%% wird erstellt',
    'subscription-create.done' => 'Abonnement %%subscriptionName%% wurde erstellt',
    'subscription-create.error' => 'Erstellung des Abonnements %%subscriptionName%% fehlgeschlagen',
    'subscription-create.warning' => 'Folgende Probleme sind beim Erstellen des Abonnements %%subscriptionName%% aufgetreten:<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Sie können die Synchronisierung manuell durchführen.',

    'subscription-delete.queue' => 'Löschung von Abonnements wird durchgeführt',
    'subscription-delete.done' => 'Abonnements gelöscht',
    'subscription-delete.error' => 'Löschung der Abonnements gescheitert',

    'websites-diagnostic.queue' => 'Diagnose der Websites wird ausgeführt',
    'websites-diagnostic.done' => 'Diagnose der Websites wurde abgeschlossen',
    'websites-diagnostic.error' => 'Bei der Diagnose der Websites sind Fehler aufgetreten',

    'install-php-extension.queue' => 'Installation des Pakets %%extensionName%% für den PHP-Handler %%phpHandlerName%%',
    'install-php-extension.done' => 'Das Paket %%extensionName%% wurde auf dem PHP-Handler %%phpHandlerName%% installiert',
    'install-php-extension.error' => 'Die Installation des Pakets %%extensionName%% auf dem PHP-Handler %%phpHandlerName%% ist fehlgeschlagen',
    'install-php-extension.step.validate' => 'Überprüfen der Anforderungen',
    'install-php-extension.step.dependencies' => 'Abhängigkeiten werden aufgelöst',
    'install-php-extension.step.process' => 'Paket wird installiert',
    'install-php-extension.step.enable' => 'Erweiterung wird aktiviert',
    'install-php-extension.step.sync' => 'Seiten werden synchronisiert',
    'install-php-extension.errorReason' => 'Die Liste der verfügbaren Pakete wird von PECL bereitgestellt. Die häufigsten Gründe für eine fehlgeschlagene Installation sind die folgenden:',
    'install-php-extension.errorReasonDependencies' => '- Das Paket hat externe Abhängigkeiten von zusätzlichen Bibliotheken.',
    'install-php-extension.errorReasonRequirements' => '- Das Paket entspricht nicht den Installationsanforderungen (Betriebssystem, PHP-Version, usw.).',
    'install-php-extension.errorReasonOutdated' => '- Das Paket ist veraltet.',
    'install-php-extension.errorOutput' => 'Um den Grund für die fehlgeschlagene Installation zu ermitteln, untersuchen Sie die Ausgabe des Dienstprogramms.',

    'uninstall-php-extension.queue' => 'Deinstallation des Pakets %%extensionName%% aus dem PHP-Handler %%phpHandlerName%%',
    'uninstall-php-extension.done' => 'Das Paket %%extensionName%% wurde von dem PHP-Handler %%phpHandlerName%% deinstalliert',
    'uninstall-php-extension.error' => 'Deinstallation des Pakets %%extensionName%% aus dem PHP-Handler %%phpHandlerName%% fehlgeschlagen',
    'uninstall-php-extension.step.validate' => 'Überprüfen der Anforderungen',
    'uninstall-php-extension.step.process' => 'Paket wird deinstalliert',
    'uninstall-php-extension.step.sync' => 'Websites werden synchronisiert',

    'upgrade-database-server.queue' => 'Upgrade des Datenbankservers',
    'upgrade-database-server.error' => 'Upgrade des Datenbankservers konnte nicht abgeschlossen werden',
    'upgrade-database-server.done' => 'Upgrade des Datenbankservers abgeschlossen',
    'upgrade-database-server.step.validate' => 'System wird überprüft',
    'upgrade-database-server.step.dump' => 'Erstelle einen Datenbankauszug',
    'upgrade-database-server.step.disableService' => 'Service für altes System deaktivieren',
    'upgrade-database-server.step.configureRepo' => 'Neues Repository konfigurieren',
    'upgrade-database-server.step.upgradePackages' => 'Upgrade des Datenbankservers',
    'upgrade-database-server.step.updateConfiguration' => 'Serverkonfiguration wird aktualisiert',
    'upgrade-database-server.step.startService' => 'Service für neues System starten',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Verbessere die Struktur aller Tabellen',
    'upgrade-database-server.step.sync' => 'Synchronisiere Systemkomponenten',
    'upgrade-database-server.step.validateInstallation' => 'Installation validieren',

    'update-spam-filter-individual-settings.queue' => 'Einstellungen für Spamfilter aktualisieren',
    'update-spam-filter-individual-settings.done' => 'Die Einstellungen für den Spamfilter wurden aktualisiert',
    'update-spam-filter-individual-settings.error' => 'Die Einstellungen für den Spamfilter konnten nicht aktualisiert werden',
    'update-spam-filter-individual-settings.mailNameError' => 'E-Mail-Adresse %%name%%: %%error%%',

    'update-default-cert.queue' => 'Standardzertifikat aktualisieren',
    'update-default-cert.done' => 'Das Standardzertifikat wurde aktualisiert.',
    'update-default-cert.error' => 'Beim Aktualisieren des Standardzertifikats sind Fehler aufgetreten.',
    'update-default-cert.step.updating' => 'Standardzertifikat wird aktualisiert…',
];