<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Hvis nettstedet ditt hostes på en dedikert IP-adresse (ikke delt med andre brukere eller nettsteder), kan du sette opp en mappe på nettstedet der andre brukere vil kunne laste filer opp eller ned anonymt over FTP. Når anonym FTP er slått på, vil brukere kunne logge på mappen på en adresse lignende ftp://ftp.ditt-domene.com med brukernavnet "anonymous" og et hvilket som helst passord.',
    'anonymous-ftp.displayLogin' => 'Vis innloggingsmelding.',
    'anonymous-ftp.loginText' => 'Meldingstekst',
    'anonymous-ftp.incomingDir' => 'Tillat opplasting til den innkommende arbeidsmappen',
    'anonymous-ftp.incomingSubDir' => 'Tillat opprettelse av mapper i den innkommende arbeidsmappen',
    'anonymous-ftp.incomingReadable' => 'Tillat nedlasting fra den innkommende arbeidsmappen',
    'anonymous-ftp.quota' => 'Begrens diskplass i den innkommende mappen',
    'anonymous-ftp.maxConnections' => 'Begrense antallet samtidige tilkoblinger',
    'anonymous-ftp.bandwidth' => 'Begrens nedlastingsbåndbredde for dette virtuelle FTP-domenet',
    'anonymous-ftp.unlimited' => 'Ubegrenset',

    'aps.catalog.loading' => 'Laster inn...',
    'aps.catalog.searchName' => 'Program',
    'aps.catalog.searchVendor' => 'Leverandør',
    'aps.catalog.searchPackager' => 'Innpakking',
    'aps.catalog.searchLicenseType' => 'Lisenstype',
    'aps.catalog.searchLicenseTypeAny' => 'Hvilken som helst',
    'aps.catalog.searchLicenseTypeFreeware' => 'Ledig',
    'aps.catalog.searchLicenseTypeCommercial' => 'Kommersielt',
    'aps.catalog.showSearch' => 'Vis Søk',
    'aps.catalog.hideSearch' => 'Skjul søk',
    'aps.catalog.buttonSearch' => 'Søk',
    'aps.catalog.buttonResetSearch' => 'Tilbakestill søk',
    'aps.catalog.showCategories' => 'Velg en kategori under eller søk etter apper ved hjelp av søkeruten',
    'aps.catalog.searchResults' => 'Søkeresultater',
    'aps.catalog.buttonInstall' => 'Installer',
    'aps.catalog.buttonInstallTooltip' => 'Installer raskt siste versjon av appen med optimale standardparametere.',
    'aps.catalog.buttonAdvancedInstall' => 'Installer (brukerdefinert)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Installer siste versjon av appen og tilpass alle parametere.',
    'aps.catalog.buttonInstallOldVersion' => 'Installer versjon',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Installer valgt versjon av appen og tilpass alle parametere.',
    'aps.catalog.buttonInstallDescription' => 'Installer appen på et nettsted dersom du allerede har en aktiveringskode, eller bare vil prøve den.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Installer denne gratis-appen på et område.',
    'aps.catalog.version' => 'Versjon',
    'aps.catalog.moreVersions' => 'Flere versjoner',
    'aps.catalog.release' => 'Frigi',
    'aps.catalog.overview' => 'Oversikt',
    'aps.catalog.noApplicationsInCategory' => 'Ingen programmer er tilgjengelige i denne kategorien. Velg en annen kategori.',
    'aps.catalog.noCategoriesSelected' => 'Velg en kategori for å bla gjennom alle programmer som er tilgjengelige i denne kategorien.',
    'aps.catalog.noSearchResults' => 'Ditt søk traff ikke noen applikasjoner.',
    'aps.catalog.connectionFailed' => 'Tilkobling til Programkatalogen mislyktes. %%retryLink%%.',
    'aps.catalog.retry' => 'Prøv på nytt',
    'aps.catalog.categoriesError' => 'Liste over kategorier kan ikke lastes for øyeblikket.',
    'aps.catalog.applicationsError' => 'Liste over applikasjoner som ikke kan lastes for øyeblikket.',
    'aps.catalog.detailsError' => 'Programdetaljer kan ikke lastes for øyeblikket.',
    'aps.catalog.searchError' => 'Søkeresultatene kunne ikke lastes inn for øyeblikket.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Versjon %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Endringshistorikk',
    'aps.catalog.officialApplicationSite' => 'Leverandør info',
    'aps.catalog.returnToCategories' => '<< Tilbake til programlisten',
    'aps.catalog.buttonUninstall' => 'Fjern',
    'aps.catalog.gotoHome' => 'Hjem',
    'aps.catalog.all' => 'Alle',
    'aps.catalog.buttonDetails' => 'Lær mer',
    'aps.catalog.buttonBuy' => 'Kjøp nå',
    'aps.catalog.buttonBuyTooltip' => 'Kjøpe appen',
    'aps.catalog.buttonBuyDescription' => 'Besøk vår butikk for å kjøpe en aktiveringskode for appen.',
    'aps.catalog.buttonDownload' => 'Last ned',
    'aps.catalog.buttonDownloadDescription' => 'Last ned appen dersom du allerede har en aktiveringskode, eller bare vil prøve den.',
    'aps.catalog.marketplaceMoreInfo' => 'For mer informasjon, se %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'app-leverandørens nettsted',

    'aps.configure.installedAt' => "Installert",
    'aps.configure.otherSettings' => "Annet",
    'aps.configure.globalSettings' => 'Pakkeinnstillinger',
    'aps.configure.passwordConfirmation' => 'Bekfreft passord',
    'aps.configure.databaseParams' => 'Databaseparametere',
    'aps.configure.noInstallationUrlAvailable' => 'Ingen (ekstern app)',
    'aps.configure.updateSettingsSection' => 'Oppdater innstillinger',
    'aps.configure.forceUpdates' => 'Oppdater denne applikasjonen automatisk når oppdateringer er tilgjengelige',
    'aps.configure.forceUpdatesHint' => 'Appen vil motta automatiske oppdateringer til nyere versjoner. Advarsel: Bruk denne innstillingen forsiktig fordi oppdateringer kan påvirke app-funksjonaliteten betydelig. For eksempel kan app-utvidelser slutte å virke med en annen versjon av appen.',

    'aps.install.showAllSettings' => 'Vis alle innstillingene',
    'aps.install.showLessSettings' => 'Vis minimumsinnstillinger',
    'aps.install.install' => 'Installer',
    'aps.install.otherSettings' => 'Andre alternativer',
    'aps.install.globalSettings' => 'Pakkeinnstillinger',
    'aps.install.passwordConfirmation' => 'Bekfreft passord',
    'aps.install.provisionsSectionLabel' => 'Installasjonsbane',
    'aps.install.context' => 'Spesifiser lokasjonen der dette webprogrammet skal installeres',
    'aps.install.registerAsWebmailSection' => 'Webmail registrering',
    'aps.install.registerAsWebmailDescription' => "Velg dette alternativet hvis appen er en webmail-klient. Dette vil gjøre at appen vises blant de tilgjengelige eposttjenestene i epostinnstillinger for abonnementer og tjenesteplaner. Administratoren kan konfigurere den offentlige URL-adressen for webmail i serveradministrasjon > innstillinger. > Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Registrer som en eposttjeneste',
    'aps.install.addItem' => 'Legg til',
    'aps.install.removeItem' => 'Fjern',
    'aps.install.updateSettingsSection' => 'Oppdater innstillinger',
    'aps.install.forceUpdates' => 'Oppdater denne applikasjonen automatisk når oppdateringer er tilgjengelige',
    'aps.install.forceUpdatesHint' => 'Appen vil motta automatiske oppdateringer til nyere versjoner. Advarsel: Bruk denne innstillingen forsiktig fordi oppdateringer kan påvirke app-funksjonaliteten betydelig. For eksempel kan app-utvidelser slutte å virke med en annen versjon av appen.',

    'aps.invalid-requirements.requirementsLegend' => 'Krav',
    'aps.invalid-requirements.domainLegend' => 'Nettsted',
    'aps.invalid-requirements.context' => 'Velg et annet nettsted',
    'aps.invalid-requirements.backToApplicationList' => 'Tilbake til programlisten',

    'aps.license.title' => 'Installasjon av %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'For å installere dette programmet må du lese lisensavtalen for sluttbrukere og godta vilkårene i den.',
    'aps.license.licenseAgree' => 'Jeg godtar vilkårene i lisensavtalen',

    'aps.services-list-customization.settings' => 'Innstillinger',

    'asp-dot-net.change-version.title' => 'Valg av ASP.NET-versjon',
    'asp-dot-net.change-version.frameworkVersion' => 'Versjon av ASP.NET-rammeverk',
    'asp-dot-net.change-version.success' => 'ASP.NET-versjonen ble endret.',

    'asp-dot-net.settings.casSettingsSection' => "Kodetilgangssikkerhet",
    'asp-dot-net.settings.clientScriptsSection' => "Innstillinger for skriptbibliotek",
    'asp-dot-net.settings.connStringsSection' => "Tilkoblingsstrengbehandling",
    'asp-dot-net.settings.customErrorsSection' => "Innstillinger for egendefinerte feilmeldinger",
    'asp-dot-net.settings.frameworkVersionSection' => "Framework-versjon",
    'asp-dot-net.settings.globalizationSection' => "Globaliseringsinnstillinger",
    'asp-dot-net.settings.otherSection' => "Øktinnstillinger",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Kompilering og debugging",
    'asp-dot-net.settings.authMode' => "Godkjenningsmodus",
    'asp-dot-net.settings.connStrings' => "Tilkoblingsstrenger",
    'asp-dot-net.settings.connStringsInvalid' => "Noen påkrevede felt er tomme eller inneholder en gal verdi",
    'asp-dot-net.settings.connStringName' => "Navn",
    'asp-dot-net.settings.connStringValue' => "Tilkoblingsparametere",
    'asp-dot-net.settings.connStringsDescription' => "Navn/tilkoblingsparametere",
    'asp-dot-net.settings.culture' => "Kultur",
    'asp-dot-net.settings.customErrMode' => "Modus for egendefinert feilmelding",
    'asp-dot-net.settings.customErrorRedirect' => "Omdiriger URL",
    'asp-dot-net.settings.customErrorStatus' => "Statuskode",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Statuskoden må være en integer.",
    'asp-dot-net.settings.customErrors' => "Egendefinerte feilmeldinger",
    'asp-dot-net.settings.customErrorsDescription' => "Statuskode/omdirigerings-URL",
    'asp-dot-net.settings.customErrorsInvalid' => "Noen påkrevede felt er tomme eller inneholder en gal verdi",
    'asp-dot-net.settings.debugMode' => "Skru på debugging",
    'asp-dot-net.settings.defLanguage' => "Standard nettside språk",
    'asp-dot-net.settings.tempDirectory' => "Midlertidig mappe",
    'asp-dot-net.settings.fileEnc' => "Filkoding",
    'asp-dot-net.settings.fileEncInvalid' => "Angitt verdi for filens kodingsparameter er ugyldig.",
    'asp-dot-net.settings.pathToLib' => "Bane til Microsoft skriptbiblioteket",
    'asp-dot-net.settings.pathToLibInstall' => "Installer",
    'asp-dot-net.settings.reqEnc' => "Forespørselskoding",
    'asp-dot-net.settings.reqEncInvalid' => "Angitt verdi for forespørselens kodingsparameter er ugyldig.",
    'asp-dot-net.settings.resEnc' => "Svarkoding",
    'asp-dot-net.settings.resEncInvalid' => "Angitt verdi for responsens kodingsparameter er ugyldig.",
    'asp-dot-net.settings.sessTimeout' => "Tidsavbrudd for økt (minutter)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Angitt verdi for øktens tidsavbruddparameter er ugyldig. Angi et positivt heltall som er større enn eller lik %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Tilkoblingsnavnet er allerede i bruk.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Statuskoden må være mellom 100 og 999",
    'asp-dot-net.settings.customErrorDuplicate' => "Statuskoden er allerede i bruk.",
    'asp-dot-net.settings.trustLevel' => "CAS klareringsnivå",
    'asp-dot-net.settings.uiCulture' => "Brukergrensesnittkultur",
    'asp-dot-net.settings.version' => "Versjon",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Tillat overstyring av CAS-klareringsnivå på nettstedet',
    'asp-dot-net.settings.updateSuccess' => 'Oppdatering fullført',

    'database.clone.formDescription' => 'Kopier innholdet av databasen til en ny eller eksisterende database. Ved kopiering til en eksisterende database, vil tabellene i kildedatabasen legges til listen over tabeller i måldatabasen. Advarsel: Hvis tabellnavn sammenfaller, vil tabellen fra kilden erstatte tabellen i måldatabasen.',
    'database.clone.copyData' => 'Lager en fullstendig kopi',
    'database.clone.copyDataHint' => 'Hvis dette velges, vil hele databasen (inkludert struktur og data) bli kopiert. Hvis fjernet, vil bare tabellstrukturen bli kopiert.',
    'database.clone.server' => 'Måldatabaseservere',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Annet...',
    'database.clone.database' => 'Måldatabase',
    'database.clone.newDatabase' => 'Opprett database med navn',
    'database.clone.existingDatabase' => 'Kopier til eksisterende database',
    'database.clone.externalDbHost' => 'Vertsnavn eller IP-adresse',
    'database.clone.externalDbLogin' => 'Brukernavn',
    'database.clone.externalDbPassword' => 'Passord',
    'database.clone.subscription' => 'Målabonnement',
    'database.clone.subscription_powerUser' => 'Mål-webområde',
    'database.clone.cloneInProgress' => 'Kloning av database %%source%% til database %%destination%%. Du vil bli varslet om fremdriften i e-post (%%email%%).',
    'database.clone.unableToClone' => 'Kunne ikke kopiere databasen "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Kunne ikke opprette en database "%%destination%%" på den spesifiserte serveren.',
    'database.clone.databaseCloned' => 'Databasen "%%source%%" ble kopiert.',
    'database.clone.emailSubjSuccess' => 'Databasen "%%sourceDatabase%%" ble kopiert.',
    'database.clone.emailSubjFailure' => 'Kopiering av database "%%sourceDatabase%%" mislyktes.',
    'database.clone.emailBodySuccess' => 'Databasen "%%sourceDatabase%%" (%%sourceHost%%) kopieres til databasen "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Kan ikke kopiere databasen "%%sourceDatabase%%" (%%sourceHost%%) til databasen "%%destDatabase%%" (%%destHost%%). Kopieringsprosedyren gikk galt.',
    'database.clone.localServer' => 'Lokal server',

    'database.repair-orphaned.formDescription' => 'Denne brukeren mistet tilknytning etter gjenopprettingen. Angi et passord for denne brukeren for å fikse dette problemet. Hvis denne brukeren skal være en systembruker uten passord, kjør reparasjonsprogrammet med tomt passordfelt.',
    'database.repair-orphaned.login' => 'Databasebrukernavn',
    'database.repair-orphaned.pass' => 'Passord',
    'database.repair-orphaned.pass2' => 'Bekfreft passord',
    'database.repair-orphaned.users' => 'Noen brukere ønsker din oppmerksomhet. Det finnes mange overgitte brukere som må repareres for å virke ordentlig.',
    'database.repair-orphaned.orphaned' => 'Brukeren er overgitt. %%gui begin:link%%Reparer nå%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Reparer',

    'database.repair.fixSelected' => 'Reparer valgte',
    'database.repair.fix' => 'Reparer',

    'database.user.password' => 'Passord',
    'database.user.passwordConfirmation' => 'Bekfreft passord',
    'database.user.server' => 'Databaseserver',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Database',
    'database.user.anyDatabase' => 'Hvilken som helst',
    'database.user.dataAccess' => 'Datatilgang',
    'database.user.structureAccess' => 'Strukturtilgang',
    'database.user.globalAccess' => 'Globale rettigheter',
    'database.user.globalAccessHint' => 'Globale rettigheter fungerer for alle databaser i denne hostingkontoen.',
    'database.user.aclRadio' => 'Tilgangskontroll',
    'database.user.aclLocalhost' => 'Tillat bare lokale tilkoblinger',
    'database.user.aclAny' => 'Tillat eksterne tilkoblinger fra en vert',
    'database.user.aclCustom' => 'Tillat eksterne tilkoblinger fra',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDe spesifiserte vertene har tilgang til databasen på vegne av denne brukeren.",
    'database.user.remoteAccess' => 'Ekstern tilgang',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDe spesifiserte IP-adressene har tilgang til databaseserveren via en brannmurregel. Endringene dine i denne listen vil bli forhåndsmoderert av hostingleverandøren din.",
    'database.user.example' => "For eksempel:\n%%example%%",
    'database.user.denied' => 'Bruk systemets brannmurregler',
    'database.user.allowed' => 'Tillat eksterne tilkoblinger fra',
    'database.user.default' => 'Bruk denne brukerens påloggingsdetaljer som standard for å gå inn i %%webadmin%%',
    'database.user.remoteAccessHint' => 'Vennligst ta kontakt med hostingleverandøren din og pass på at alternativet du spesifiserte over vil være i samsvar med gjeldende brannmurregler for innkommende tilgang til MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'webadmin',
    'database.user.role' => 'Rolle',
    'database.user.roleReadWrite' => 'Les og skriv',
    'database.user.roleWriteOnly' => 'Lesebeskyttet',
    'database.user.roleReadOnly' => 'Skrivebeskyttet',
    'database.user.roleCustom' => 'Egendefinert',

    'database.generalSection' => 'Generelt',
    'database.name' => 'Databasenavn',
    'database.server' => 'Databaseserver',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Tilhørende område',
    'database.noDomainRelations' => 'Ingen tilhørende områder',
    'database.userSection' => 'Brukere',
    'database.userSectionDescription' => 'Opprett en standard databasebruker. Plesk vil få tilgang til databasen på vegne av denne brukeren. Hvis ingen databasebrukere er tilordnet til databasen, er den ikke tilgjengelig.',
    'database.createUser' => 'Opprett en databasebruker',
    'database.username' => 'Databasebrukernavn',
    'database.password' => 'Passord',
    'database.passwordConfirmation' => 'Bekfreft passord',
    'database.allDbAccess' => 'Brukeren har tilgang til alle databaser i det valgte abonnementet',
    'database.aclRadio' => 'Tilgangskontroll',
    'database.aclLocalhost' => 'Tillat bare lokale tilkoblinger',
    'database.aclAny' => 'Tillat eksterne tilkoblinger fra en vert',
    'database.aclCustom' => 'Tillat eksterne tilkoblinger fra',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDe spesifiserte vertene har tilgang til databasen på vegne av denne brukeren.",
    'database.remoteAccess' => 'Ekstern tilgang',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDe spesifiserte IP-adressene har tilgang til databaseserveren via en brannmurregel. Endringene dine i denne listen vil bli forhåndsmoderert av hostingleverandøren din.",
    'database.example' => "For eksempel:\n%%example%%",
    'database.denied' => 'Bruk systemets brannmurregler',
    'database.allowed' => 'Tillat eksterne tilkoblinger fra',

    'deployment-section.deploymentDisabledHint' => 'Last opp filer fra et Git-repositorie',
    'deployment-section.deploymentEnabledHint' => 'Aktiver støtte for Git',
    'deployment-section.deploymentSectionLegend' => 'Filene dine som skal kopieres til hosting',
    'deployment-section.deploymentSectionDescriptionHint' => 'Hvis du lar Git-støtten være deaktivert, vil rotkatalogene (nettsteds-/applikasjonsrot og dokumentrot) være tomme når de opprettes og nettstedet vil vise standardsiden i nettleseren. Du vil ikke måtte laste opp filene fra nettstedet til dokumentroten ved hjelp av FTP eller File Manager. Alternativt, kan du aktivere Git nå eller senere (under Nettsteder og domener) og laste opp filene fra et Git-repositorie.',

    'dns-zone.add-acl-record.description' => 'Legg til en IP-adresse for en DNS-server som har tillatelse til å motta en kopi av DNS-sonen.',
    'dns-zone.add-acl-record.ipAddress' => 'IP-adresse',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP adresse/maske',

    'dns-zone.record.add-title' => "Legg til ressursoppføring til sone malen",
    'dns-zone.record.add-ns-title' => "Legg til navnetjener",
    'dns-zone.record.edit-title' => "Rediger ressursoppføring",
    'dns-zone.record.edit-success' => "DNS-oppføringen ble oppdatert.",
    'dns-zone.record.add-success' => "DNS-oppføringen ble opprettet.",
    'dns-zone.record.type' => "Oppføringstype",
    'dns-zone.record.domainName' => "Domenenavn",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Navneserver",
    'dns-zone.record.optionOff' => 'Av',
    'dns-zone.record.optionOn' => 'På',
    'dns-zone.record.protocol' => "Protokoll",
    'dns-zone.record.priority' => "Prioritet",
    'dns-zone.record.priorityLow' => "lav (%%priority%%)",
    'dns-zone.record.priorityHigh' => "svært høy (%%priority%%)",
    'dns-zone.record.weightLow' => "lav (%%weight%%)",
    'dns-zone.record.weightHigh' => "svært høy (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP-adresse",
    'dns-zone.record.ipAddressDescription' => "For eksempel, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "For eksempel <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6 adresse",
    'dns-zone.record.ipAddressV6Description' => "For eksempel, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "For eksempel <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "For eksempel, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "For eksempel <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "For eksempel, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Kanonisk navn",
    'dns-zone.record.mailDomain' => "Epostdomene",
    'dns-zone.record.mxServer' => "Postutvekslingsserver",
    'dns-zone.record.mxServerPriority' => "Angi prioritet for postutvekslingsserver",
    'dns-zone.record.txtRecord' => "TXT oppføring",
    'dns-zone.record.txtRecordString' => "Skriv inn oppføringsstrengen.",
    'dns-zone.record.txtSpfSyntax' => "SPF oppføring",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Feil verdier for TXT-oppføring ble spesifisert.",
    'dns-zone.record.quotedTxtRecord' => "TXT-oppføringsverdien må være en enkeltstreng uten anførselstegn.",
    'dns-zone.record.dsRecord' => "DS-oppføring",
    'dns-zone.record.dsRecordDescription' => "For eksempel: 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "En feil verdi for DS-oppføringen ble spesifisert.",
    'dns-zone.record.serviceName' => "Tjenestenavn",
    'dns-zone.record.serviceNameDescription' => 'For eksempel SIP (uten understrek).',
    'dns-zone.record.protocolNameDescription' => 'For eksempel tcp (uten understrek).',
    'dns-zone.record.portDescription' => 'For eksempel 25 (uten understrek).',
    'dns-zone.record.srvWeight' => "Relativ vekt for oppføringer med samme prioritet",
    'dns-zone.record.targetHost' => "Målvert",
    'dns-zone.record.targetHostDescription' => "For eksempel: eksempel.com",
    'dns-zone.record.targetPort' => "Målport",
    'dns-zone.record.targetPortDescription' => 'For eksempel, 8443.',
    'dns-zone.record.retrieveDataError' => "Oppføringsdata ikke funnet.",
    'dns-zone.record.unknownTypeError' => "Ukjent DNS-oppføringstype.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Kan ikke sette opp NULL MX oppføringen mens en annen MX oppføring er tilstede.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Kan ikke sette opp ikke-NULL MX oppføringen mens NULL MX oppføringen er tilstede',
    'dns-zone.record.masterShouldBeRemote' => "Du må ha to forskjellige autoritative navneservere på separate verter.",
    'dns-zone.record.caaTag' => "Tagg",
    'dns-zone.record.caaRecord' => "Verdi",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protokoll',
    'dns-zone.record.tlsaUsage' => 'Bruk',
    'dns-zone.record.tlsaSelector' => 'Selektor',
    'dns-zone.record.tlsaMatching' => 'Matchingstype',
    'dns-zone.record.tlsaCertData' => 'Assosieringsdata for sertifikat',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Se %%link%% for ytterligere info',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, avsnitt 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, avsnitt 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, avsnitt 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, avsnitt 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "alias (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'For eksempel eksempel.com. En tom verdi betyr at verten er lik domenenavnet.',
    'dns-zone.record.httpsProtocols' => 'Protokoller',
    'dns-zone.record.httpsProtocolsDescription' => 'En kommaseparert liste over protokoller som støttes av målet. For eksempel h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Tving kun bruk av spesifiserte protokoller. Protokollisten ovenfor kan ikke være tom.',
    'dns-zone.record.httpsIpv4hint' => 'Hint for IPv4-adresser',
    'dns-zone.record.httpsIpv4hintDescription' => 'En kommaseparert liste med IPv4-adresser som kan bli brukt av en klient for å nå tjenesten.',
    'dns-zone.record.httpsIpv6hint' => 'Hint for IPv6-adresser',
    'dns-zone.record.httpsIpv6hintDescription' => 'En kommaseparert liste med IPv6-adresser som kan bli brukt av en klient for å nå tjenesten.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "sekunder",
    'dns-zone.record.invalidValue' => 'Verdien er ugyldig. Den kan være fra 1 sekund til 2147483647 sekunder.',
    'dns-zone.record.ttlDefaultValue' => 'Standardverdi: %%value%% sekunder',
    'dns-zone.record.invalidTTL' => 'Den angitte TTL-verdien er ugyldig.',
    'dns-zone.record.invalidIpAddress' => 'Den spesifiserte IP-adressen er ugyldig.',
    'dns-zone.record.invalidIpMaskPair' => 'Det angitte IP-adresse-/nettmaskeparet er ugyldig.',
    'dns-zone.record.invalidCName' => 'Det angitte kanoniske navnet er ugyldig.',
    'dns-zone.record.invalidPort' => 'Den angitte porten er ugyldig.',
    'dns-zone.record.invalidTLSACertData' => 'Angitt assosieringsdata for sertifikat er ugyldig.',
    'dns-zone.record.invalidTLSAProtocol' => 'Den angitte protokollen er ugyldig.',
    'dns-zone.record.invalidTLSAUsage' => 'Den angitte bruken er ugyldig.',
    'dns-zone.record.invalidTLSASelector' => 'Den angitte selektoren er ugyldig.',
    'dns-zone.record.invalidTLSAMatching' => 'Den angitte matchingtypen er ugyldig.',

    'dns-zone.restore-default.formHint' => "Her kan du gjenopprette den originale sonekonfigurasjonen i samsvar med standardinnstillinger for DNS-mal som benyttes på serveren. Velg IP-adresser som skal brukes for å gjenopprette sonen og spesifiser om et www-alias kreves for domenet.",
    'dns-zone.restore-default.ipv4' => "IPv4-adresse",
    'dns-zone.restore-default.ipv4Hint' => "For eksempel, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6 adresse",
    'dns-zone.restore-default.ipv6Hint' => "For eksempel, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Den spesifiserte IP-adressen er ugyldig.',
    'dns-zone.restore-default.customIpHint' => "Oppføringer med denne IP-adressen vil bli ansett som modifisert av brukeren, og vil ikke synkroniseres med den globale DNS-malen.",
    'dns-zone.restore-default.wwwPrefix' => "WWW prefiks",
    'dns-zone.restore-default.previewRecords' => "Gjenopprett poster som brukes til forhåndsvisning av område",

    'dns-zone.soa-record.soaMnameSection' => 'Primær navneserver',
    'dns-zone.soa-record.soaMname' => 'Navneserver',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Automatisk valg)',
    'dns-zone.soa-record.soaRecordSection' => 'SOA oppføring',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Oppdater',
    'dns-zone.soa-record.retry' => 'Prøv på nytt',
    'dns-zone.soa-record.expire' => 'Utløper',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'E-post (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'E-postadressen til personen som er ansvarlig for domenets DNS-sone. Returnert fra DNS-serveren som svar på SOA-forespørsler.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Nettstedeierens e-postadresse',
    'dns-zone.soa-record.rnameTypeDomain' => 'E-postadresse for domenet',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Skriv kun inn den lokale delen (før @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Ekstern e-postadresse',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Forby endring av RNAME e-post adressen på en per domene-basis',
    'dns-zone.soa-record.invalidValue' => 'Verdien er ugyldig. Den kan være fra 1 sekund til 68 år.',
    'dns-zone.soa-record.advancedSection' => 'Avanserte DNS-funksjoner',
    'dns-zone.soa-record.serialNumberFormat' => 'Bruk serienummerformatet som anbefales av IETF og RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Velg altnerativet hvis domenet ditt har problemer med å bestå SOA-kontroller i registraren. Mange domeneregistrarer krever dette serienummerformatet.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Bruk standardinnstillinger',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Sonestandarder',
    'dns-zone.soa-record.unitSeconds' => 'sekunder',
    'dns-zone.soa-record.unitMinutes' => 'minutter',
    'dns-zone.soa-record.unitHours' => 'timer',
    'dns-zone.soa-record.unitDays' => 'dager',
    'dns-zone.soa-record.unitWeeks' => 'uker',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Oppdateringsinteravallet er mindre enn én time, noe som kan øke servertrafikk og ressursbruk til et kritisk punkt.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Innstilling av minimum TTL-verdi som er mer enn 3 timer kan gjøre domenene dine utilgjengelige for noen av domeneadministratorene. Det anbefales å sette denne verdien kun hvis domenenamnregistratoren insisterer på dette.',
    'dns-zone.soa-record.success' => 'Egenskaper for SOA-oppføringen er oppdatert.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Standard SOA-oppføring ble gjenopprettet.',

    'domain-info-section.domainName' => 'Domenenavn',
    'domain-info-section.emptyDomainName' => 'Vennligst angi et domenenavn.',
    'domain-info-section.ipAddress' => 'IP-adresse',
    'domain-info-section.shared' => 'delt',
    'domain-info-section.exclusive' => 'dedikert',
    'domain-info-section.ipAddressHint' => "IP-adressen som nettstedet hostes på er en nettverksadresse for nettstedets virtuelle host. Denne IP-adressen vil bli benyttet for alle nettsteder som opprettes for abonnementet.",
    'domain-info-section.ipAddressHint_powerUser' => "IP-adressen som nettstedet hostes på er en nettverksadresse for nettstedets virtuelle host.  IP-adresse brukes for nettsted opprettet med webområde.",
    'domain-info-section.userName' => 'Brukernavn',
    'domain-info-section.userNameHint' => 'Systembrukerkontoer tilknyttet nettområdet, brukes for å få tilgang til filer som er hostet over FTP og SSH.',
    'domain-info-section.emptyLogin' => 'Vennligst angi et brukernavn.',
    'domain-info-section.password' => 'Passord',
    'domain-info-section.emptyPassword' => 'Vennligst angi et passord.',
    'domain-info-section.passwordConfirmation' => 'Gjenta passord',

    'email-address.generalTab' => 'Generelt',
    'email-address.generalHint' => 'If this email account is associated with an additional user (Access to the Customer Panel is enabled), the changes you make on this page affect this user\'s settings. Legg særlig merke til at hvis du endrer e-postadressen og passordet, vil brukernavnet og passordet til den ekstra brukeren også endres til de nye verdiene.',
    'email-address.redirectTab' => 'Videresending',
    'email-address.redirectHint' => 'Konfigurer videresending av e-postmeldinger til en eller flere e-postadresser.',
    'email-address.aliasesTab' => 'E-postaliaser',
    'email-address.autoResponderTab' => 'Autosvar',
    'email-address.antispamTab' => 'Filter for søppelpost',
    'email-address.autoResponderHint' => 'Sett opp et automatisk svar til alle e-postmelding som kommer til din e-postadresse. Autosvar er en standard måte å varsle de som skriver til deg om at du er ute av kontoret eller på ferie.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'E-postadresse',
    'email-address.externalEmail' => 'Ekstern e-postadresse',
    'email-address.externalEmailHint' => 'Vil brukes for å tilbakestille ditt passord om du mister tilgang til den primære e-post adressen.',
    'email-address.user' => 'Tilordnet til',
    'email-address.password' => 'Passord',
    'email-address.passwordConfirmation' => 'Bekfreft passord',
    'email-address.responderEnable' => 'Slå på autosvar',
    'email-address.responderSubject' => 'Autosvar meldingstittel',
    'email-address.responderContentType' => 'Meldingsformat',
    'email-address.responderContentTypeHint' => 'Rent tekstformat støttes av alle epostklienter, derfor vil alle mottakere se meldingen på samme måte som du ser den. HTML-meldinger ser bedre ut fordi de lar deg formatere tekst med forskjellige skriftstiler. Men noen e-postklienter støtter ikke HTML-meldinger, og noen mottaker vil kanskje ikke kunne se den formaterte teksten.',
    'email-address.responderContentTypeTextPlain' => 'Ren tekst',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Koding',
    'email-address.responderCodepageHint' => 'Koding definerer hvordan teksttegnene fremvises. Den anbefalte kodingen er UTF-8.',
    'email-address.responderReplyTo' => 'Videresend til',
    'email-address.responderReplyToHint' => 'Når automatisk svar er sendt, vil originalmeldingen bli videresender til angitt e-postadresse.',
    'email-address.responderForwardAddress' => 'Videresend til',
    'email-address.responderForwardAddressHint' => 'Når automatisk svar er sendt, vil originalmeldingen bli videresender til angitt e-postadresse.',
    'email-address.responderMessage' => 'Autosvar meldingstekst',
    'email-address.responderReplyToEqualsEmail' => 'Den angitte videresendingsadressen er den samme som denne e-postadressen.',
    'email-address.responderForwardAddressEqualsEmail' => 'Den angitte videresendingsadressen er den samme som denne e-postadressen.',
    'email-address.responderReplyLimit' => 'Send et automatisk svar til en unik e-postadresse, ikke mer enn (ganger om dagen)',
    'email-address.buttonAddResponderAttachment' => 'Legg til vedlegg',
    'email-address.buttonRemoveResponderAttachment' => 'Fjern',
    'email-address.responderAttachment' => 'Legg ved en fil',
    'email-address.redirectEnable' => 'Slå på videresending av e-post',
    'email-address.redirectRemoveEnable' => 'Ikke lever kopier av videresendte e-poster til Plesk-innboksen',
    'email-address.redirectAddress' => 'Videresend innkommende meldinger til følgende e-postadresse',
    'email-address.redirectAddressHint' => 'Angi e-postadresser. Du kan skrive hver adresse på en ny linje, eller skille adresser med mellomrom, komma eller semikolon.',
    'email-address.role' => 'Brukerrolle',
    'email-address.roleHint' => 'Brukerroller gir brukere administrative privilegier og tilgang til programmene du valgte for rollen.',
    'email-address.errorRedirectAddress' => 'Oppgitt e-postadresse er ugyldig: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Opggitte e-postadresser er ugyldige: %value%.',
    'email-address.mailAlias' => "E-postalias",
    'email-address.mailAliasNone' => 'Ingen',
    'email-address.mailAliasHint' => "E-postaliaser er alternative e-postadresser tilknyttet en primær e-postadresse. Alle e-post sendt til e-postaliaser vil bli mottatt av den primære e-postadressen.",
    'email-address.buttonAddMailAlias' => 'Legg til e-postalias',
    'email-address.buttonRemoveMailAlias' => 'Fjern',
    'email-address.emptyEmail' => 'Angi e-postadresser som innkommende meldinger skal videresendes til.',
    'email-address.emailsIsEqual' => 'Den eksterne e-post adressen stemmer overens med den primære. Spesifiser en annen ekstern e-post adresse.',
    'email-address.emptyPassword' => 'Du må angi et passord.',
    'email-address.emptyPasswordConfirmation' => 'Du må bekrefte passordet.',
    'email-address.emptyAlias' => "Angi e-postalias for denne e-postadressen.",
    'email-address.aliasEqualsEmail' => 'Det angitte e-postalias er det samme som e-postadressen.',
    'email-address.passwordHint' => 'Vil brukes for å aksessere postkassen og for å logge inn på Plesk (dersom det tilsvarende alternativet er aktivert).',
    'email-address.cyclicRedirect' => 'E-postadresse kan ikke settes opp til å videresende e-postmeldinger til seg selv.',
    'email-address.errorMailnameReserved' => 'Den angitte e-post-adressen er allerede i bruk.',
    'email-address.antivirusEnable' => 'Slå på antivirusbeskyttelse for denne e-postadressen',
    'email-address.antivirusHint' => 'Antivirustjenesten blokkerer epostmeldinger som inneholder virus og varsler både senderen og mottakeren om dette.',
    'email-address.antivirusSettings' => 'Sjekk for virus',
    'email-address.antivirusSettingOnlyIncomingMail' => 'bare innkommende e-post',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'bare utgående e-post',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'innkommende og utgående e-post',
    'email-address.antispamHint' => 'Spamfiltreringstjeneste detekterer spammeldinger som sendes til epostadressen. Du kan sette spamfilter til å slett søppelposten, merke dem som søppelpost ved å endre emnet, eller flytte dem til den spesielle spammappen som er tilgjengelig i e-post klienter over IMAP. Spamfilter bruker et bredt utvalg av lokale og nettverkstester for å identifisere spam-signaturer.',
    'email-address.antispamEnable' => 'Slå på spamfiltrering for denne e-postadressen',
    'email-address.antispamSettings' => 'Hva som skal gjøres med meldinger klassifisert som spam',
    'email-address.antispamSettingsMark' => 'Merk spammeldinger ved å legge til følgende tekst i emnet',
    'email-address.antispamSettingsMarkHint' => 'La dette feltet være blankt hvis du ikke vil legge til noen tekst. Skriv _SCORE_ hvis du vil inkludere resultatet i meldingsemnet.',
    'email-address.antispamReportTextHint' => 'Skriv inn teksten som du vil legge til i meldingsteksten i søppelposten.',
    'email-address.antispamSettingsDelete' => 'Slett alle spammeldinger',
    'email-address.antispamSettingsDeleteHint' => 'Søppelpost vil bli slettet fra din postboks.',
    'email-address.antispamSettingsMove' => 'Flytt søppelpost til Spam-mappen',
    'email-address.antispamSettingsMoveHint' => 'Flytt spammelding til mappen kalt Spam. Denne mappen er tilgjengelig fra epostklient eller eposttjeneste. Hvis du bruker en IMAP e-postkonto, deretter kan du bruke Spammappen for å trene spamfilteret.',
    'email-address.antispamSettingsMoveWarning' => '"Flytt søppelpost til søppelpostmappen" virker ikke med mindre du deaktiverer alternativet "Ikke lever kopier av videresendte e-postmeldinger" i fanen "Videresending".',
    'email-address.antispamSettingsMoveJunk' => 'Flytt søppelpost til mappen Søppelpost',
    'email-address.antispamSettingsMoveJunkHint' => 'Flytt all søppelpost til mappen ved navn Søppelpost. Denne mappen er tilgjengelig fra epostklient eller eposttjeneste. Hvis du bruker en IMAP e-postkonto, deretter kan du bruke mappen "Useriøs e-post" for å trene spamfilteret.',
    'email-address.antispamShowAdvancedSection' => 'Vis avanserte innstillinger.',
    'email-address.antispamHideAdvancedSection' => 'Skjul avanserte innstillinger.',
    'email-address.antispamLearnMore' => 'Lær å trene spamfilter.',
    'email-address.antispamFilterScoreTitle' => 'Filter-følsomhet',
    'email-address.antispamFilterScoreHint' => 'Spamfilter utfører et antall av forskjellig tester på innhold og emnelinje for hver melding. Som et resultat, scorer hver melding et antall poeng. Jo høyere antall, jo mer sannsynlig at meldingen er spam. Som standard er filtersensitiviteten slått på slik at alle meldinger som får 7 eller flere poeng er klassifisert som Spam. Dersom du mottar mye spam med gjeldende innstillinger, kan du prøve å gjøre filteret mer følsomt, ved å sette en lavere innstilling, for eksempel 6. Hvis du går glipp av e-post fordi spamfilteret tror de er søppel, kan du prøve å redusere følsomheten til filteret ved å sette en høyere verdi, for eksempel 8.',
    'email-address.antispamFilterScore' => 'Spamfilter-følsomhet',
    'email-address.antispamWhiteListTitle' => 'Hviteliste',
    'email-address.antispamWhiteListHint' => 'E-postmeldinger som kommer fra avsendere i hvitelisten er ikke kontrollert av spamfilteret.',
    'email-address.antispamWhiteListField' => 'Hviteliste',
    'email-address.antispamWhiteListFieldHint' => 'Skriv inn domenenavn, ett domenenavn pr linje. Adresser kan inneholde jokertegnene "*" og "?", for eksempel *@domene.com, bruker?@*.com.',
    'email-address.antispamBlackListTitle' => 'Svarteliste',
    'email-address.antispamBlackListHint' => 'E-postmeldinger som kommer fra avsendere i svartelisten klassifiseres som søppelpost.',
    'email-address.antispamBlackListField' => 'Svarteliste',
    'email-address.antispamBlackListFieldHint' => 'Skiv inn domenenavn, ett domene pr linje. Adresser kan inneholde jokertegnene "*" og "?", for eksempel *@domene.com, bruker?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Klarerte språk',
    'email-address.antispamTrustedLanguagesHint' => 'E-postmeldinger skrevet på disse språkene vil alltid slippe gjennom filteret.',
    'email-address.antispamTrustedLocalesTitle' => 'Sikre nasjonale innstillinger',
    'email-address.antispamTrustedLocalesHint' => 'E-postmeldinger som bruker de oppgitte nasjonale innstillingene vil alltid slippe gjennom filteret. Grupper av nasjonale innstillinger inkluderer de mest utbredte tegnsettene. For eksempel, Western tegnsettet inkluderer kodinger for bokstaver som benyttes i engelske og vest-europeiske språk.',
    'email-address.antispamTrustedNetworksTitle' => 'Klarerte nettverk',
    'email-address.antispamTrustedNetworksHint' => 'Videresendings vertsmaskiner i klarerte nettverk betraktes som at de ikke kjøres av spammere, og de er ikke åpne videresendingsmaskiner eller åpne proxy\'er.',
    'email-address.antispamIpAddressesField' => 'IP-adresser',
    'email-address.antispamIpAddressesFieldHint' => 'Angi nettverk IP adresse og maske.',
    'email-address.mailBoxQuotaDomainDefault' => 'Standardstørrelse (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Standardstørrelse',
    'email-address.mailBoxOutgoingMessages' => 'Maksimalt antall utgående e-postmeldinger',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Standard (%%domainOutgoingMessages%% meldinger pr time)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Egendefinert verdi for postboksen',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'meldinger',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Standard',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Standardstørrelse',
    'email-address.mailBoxQuotaDomainSpecific' => 'En annen størrelse',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Postboksstørrelse',
    'email-address.mailBoxQuotaUnlimited' => 'Ubegrenset',
    'email-address.mailBoxLimitReached' => 'Grensen for antall e-postbokser ble nådd.',
    'email-address.postboxEnabled' => 'Postboks',
    'email-address.postboxEnabledYes' => 'På',
    'email-address.postboxEnabledNo' => 'Av',
    'email-address.description' => 'Beskrivelse i Plesk',
    'email-address.descriptionHint' => 'Beskrivelsen er synlig for alle som har tilgang til denne e-postkontoen.',
    'email-address.longDescription' => 'Den angitte beskrivelsen er for lang. Den kan ikke være lenger enn %%max%% tegn.',
    'email-address.loginAsUser' => 'Kan brukes for innlogging til Plesk.',
    'email-address.loginAsUserDescription' => '(brukernavn: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Postkasse størrelsen kan ikke overskride standars størrelsen.',
    'email-address.endDateEnable' => 'Slå av autosvar',

    'failed-request.enable-tracing.description' => 'Sporing av mislykkede forespørsler er en ressurskrevende operasjon. Sporingen vil stoppes automatisk om %%days%% dager. Du kan slå den av manuelt når som helst.',
    'failed-request.enable-tracing.statusCodes' => 'Statuskoder',
    'failed-request.enable-tracing.statusCodesDescription' => 'For eksempel: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Leverandør',

    'file-manager.show.buttonReload' => 'Last inn på nytt',
    'file-manager.show.buttonSave' => 'Lagre',
    'file-manager.show.buttonSaveAs' => 'Lagre som',
    'file-manager.show.buttonReset' => 'Tilbakestill',
    'file-manager.show.buttonTextCodeEditor' => 'Rediger i koderedigering',
    'file-manager.show.buttonTextEdit' => 'Rediger i tekstredigeringsprogram',
    'file-manager.show.buttonWysiwygEdit' => 'Rediger i HTML-redigeringsprogram',
    'file-manager.show.eolLabel' => 'Linjeskift type:',
    'file-manager.show.saveAs' => 'Lagre som:',
    'file-manager.show.saveCodepage' => 'Spar i den følgende kodingen:',
    'file-manager.show.loadCodepage' => 'Se den originale filen i den følgende kodingen:',
    'file-manager.show.loadCodepageHint' => 'Advarsel: Endringer som ikke er lagret vil gå tapt ved ny innlasting av filen.',
    'file-manager.show.fileExists' => "Filen eller mappen %%fileName%% finnes allerede. Du kan ikke ha en mappe og en fil med det samme navnet.",
    'file-manager.show.popupTitle' => 'Lagre som',
    'file-manager.show.popupFilename' => 'Filnavn:',

    'file-manager.permissions.filePermissions' => 'Filtillatelser',
    'file-manager.permissions.directoryPermissions' => 'Mappetillatelser',
    'file-manager.permissions.buttonSubmit' => 'Lagre',
    'file-manager.permissions.buttonApply' => 'Lagre og fortsett',
    'file-manager.permissions.buttonCancel' => 'Avbryt',
    'file-manager.permissions.buttonAdvanced' => 'Avansert',

    'file-manager.unix-file-permissions.group' => 'Gruppe',
    'file-manager.unix-file-permissions.owner' => 'Eier',
    'file-manager.unix-file-permissions.others' => 'Andre',
    'file-manager.unix-file-permissions.readMode' => 'Les',
    'file-manager.unix-file-permissions.writeMode' => 'Skriv',
    'file-manager.unix-file-permissions.execMode' => 'Kjør/søk',
    'file-manager.unix-file-permissions.changeRecursive' => 'Endre tillatelser rekursivt',

    'file-manager.windows-permissions.allow' => 'Tillat',
    'file-manager.windows-permissions.deny' => 'Nekt',
    'file-manager.windows-permissions.inheritFromParent' => 'Tillat at arvbare tillatelser videreføres til dette objektet og alle underordnede objekter. Inkluder disse sammen med oppføringene som eksplisitt er definert her',
    'file-manager.windows-permissions.replaceOnChildren' => 'Erstatter tillatelsesoppføringene på alle underordnede objekter med oppføringene som er vist her',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avansert',
    'file-manager.windows-permissions.applyTo' => 'Bruk på:',
    'file-manager.windows-permissions.folderOnly' => 'Bare denne mappen',
    'file-manager.windows-permissions.subfolderOnly' => 'Bare undermapper',
    'file-manager.windows-permissions.filesOnly' => 'Bare filer',
    'file-manager.windows-permissions.permissionsFor' => 'Tillatelser for',
    'file-manager.windows-permissions.applyOnto1' => 'Bare denne mappen',
    'file-manager.windows-permissions.applyOnto2' => 'Bare undermapper',
    'file-manager.windows-permissions.applyOnto3' => 'Denne mappen og undermapper',
    'file-manager.windows-permissions.applyOnto4' => 'Bare filer',
    'file-manager.windows-permissions.applyOnto5' => 'Denne mappen og filer',
    'file-manager.windows-permissions.applyOnto6' => 'Bare undermapper og filer',
    'file-manager.windows-permissions.applyOnto7' => 'Denne mappen, undermapper og filer',
    'file-manager.windows-permissions.notInherited' => '<ikke arvet>',

    'file-manager.editor.titleTextEditor' => 'Tekstredigering',
    'file-manager.editor.titleCodeEditor' => 'Koderedigering',
    'file-manager.editor.titleCodeViewer' => 'Vis',
    'file-manager.editor.buttonSubmit' => 'Lagre',
    'file-manager.editor.buttonApply' => 'Lagre og fortsett',
    'file-manager.editor.buttonSaveAs' => 'Lagre som …',
    'file-manager.editor.buttonCancel' => 'Avbryt',
    'file-manager.editor.exitConfirmationYes' => 'Ja',
    'file-manager.editor.exitConfirmationNo' => 'Nei',
    'file-manager.editor.fileOverwrite' => 'Filen finnes allerede.',
    'file-manager.editor.fileOverwriteDescription' => 'Det finnes allerede en fil med det samme navnet. Vil du overskrive den?',
    'file-manager.editor.exitConfirmation' => 'Er du sikker på at du vil lukke filen og forkaste endringene som ikke er lagret?',
    'file-manager.editor.buttonCodeEditor' => 'Rediger i koderedigering',
    'file-manager.editor.buttonTextEditor' => 'Rediger i tekstredigeringsprogram',
    'file-manager.editor.buttonHtmlEditor' => 'Rediger i HTML-redigeringsprogram',

    'file-manager.import-file.buttonSubmit' => 'Importerer',
    'file-manager.import-file.fieldUrl' => 'Nettadresse for filen',
    'file-manager.import-file.fieldUrlDescription' => 'Spesifiser kildens nettadresse, f.eks. «https://example.com/example.tgz».',
    'file-manager.import-file.fieldUrlFullDescription' => 'Det fullstendige nettadressemønstret er følgende: «https://user:password@example.com/example.tgz». Brukernavn og passord er valgfritt. De støttede protokollene er http, https, ftp og ftps. Bruk URL-kodingen for URL-deler som inneholder spesialtegn eller mellomrom.',
    'file-manager.import-file.failure' => 'Kan ikke importere filen.',

    'file-manager.rotation-settings.title' => 'Rotasjonsinnstillinger for papirkurv',
    'file-manager.rotation-settings.rotationBySize' => 'Rotasjon etter størrelse',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Alternativet sletter nye filer så lenge den spesifiserte grensen for papirkurven er overskredet.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotasjon etter dato',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Dager',
    'file-manager.rotation-settings.rotationByDateHint' => 'Dette alternativet sletter filer som har vært lagret i papirkurven i mer enn et spesifisert antall dager.',
    'file-manager.rotation-settings.save' => 'Lagre',
    'file-manager.rotation-settings.cancel' => 'Avbryt',

    'ftp-user.description' => 'Hvis du arbeider på nettstedet ditt sammen med noen andre, eller hoster underdomener for andre brukere, har du kanskje lyst til å opprette separate FTP-kontoer for dem.',
    'ftp-user.generalSection' => 'Generelt',
    'ftp-user.login' => 'Navn på FTP-konto:',
    'ftp-user.home' => 'Hjemmemappe',
    'ftp-user.systemArea' => 'Opprett en FTP-konto som skal ha tilgang til filer utenfor hjem-mappen.',
    'ftp-user.password' => 'Passord',
    'ftp-user.passwordConfirmation' => 'Bekfreft passord',
    'ftp-user.hardQuotaSection' => 'Harddisk kvote',
    'ftp-user.hardQuota' => 'Harddisk kvote',
    'ftp-user.hardQuotaUnlimited' => 'Ubegrenset',
    'ftp-user.permissionsSection' => 'Tillatelser',
    'ftp-user.permissionRead' => 'Lesetillatelse',
    'ftp-user.permissionWrite' => 'Skrive-tilgang',
    'ftp-user.popupTitle' => 'Velg mappe',
    'ftp-user.limitMbUnits' => 'MB',

    'mail-list.listName' => 'Adresseliste adresse',
    'mail-list.enabled' => 'Slått på',
    'mail-list.administratorEmail' => 'Adresseliste administratorens e-post',
    'mail-list.password' => 'Passord',
    'mail-list.passwordConfirmation' => 'Bekfreft passord',
    'mail-list.subscribers' => 'Abonnenter',
    'mail-list.subscribersHint' => 'Angi e-postadresser. Du kan skrive hver adresse på en ny linje, eller skille adresser med mellomrom, komma eller semikolon.',
    'mail-list.notify' => 'Varsle administrator opprettelsen av adresselisten',
    'mail-list.emptyPassword' => 'Angi et passord.',
    'mail-list.emptyPasswordConfirmation' => 'Bekreft passordet.',
    'mail-list.errorSubscribers' => 'Ugyldige e-postadresser: %value%.',
    'mail-list.errorMaillistReserved' => 'Den angitte adresseliste-adressen er allerede i bruk.',

    'mail-settings.copyToClipboard' => 'Kopier DNS-oppføringen til utklippstavlen.',
    'mail-settings.copySuccess' => 'DNS-oppføringen ble kopiert til utklippstavlen.',
    'mail-settings.hint' => 'Her kan du endre innstillinger for e-posttjenesten for dette domenet.',
    'mail-settings.service' => 'E-posttjeneste på dette domenet',
    'mail-settings.nonExist' => 'Hva skal gjøres med e-post til ikke-eksisterende brukere',
    'mail-settings.nonExistBounceWithMessage' => 'Returner med melding',
    'mail-settings.nonExistBounce' => 'Returner',
    'mail-settings.nonExistCatch' => 'Videresend til adresse',
    'mail-settings.nonExistCatchDescription' => 'E-postadressen må tilhøre det valgte domenet. Bare administratoren kan spesifisere en ekstern adresse eller én adresse for flere domener.',
    'mail-settings.nonExistExternal' => 'Omdiriger til en ekstern e-postserver med IP-adresse',
    'mail-settings.nonExistReject' => 'Avvis',
    'mail-settings.nonExistDiscard' => 'Avvis',
    'mail-settings.webmail' => 'Webmail',
    'mail-settings.webmailNone' => 'Ingen',
    'mail-settings.webmailComponentNotInstalled' => 'Webmail-komponenten ble ikke installert.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Det finnes et underdomene med navnet %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'SSL/TLS-sertifikat for webmail',
    'mail-settings.webmailCertificateNone' => 'Ikke avmerket',
    'mail-settings.mailCertificate' => 'SSL/TLS-sertifikat for e-post',
    'mail-settings.mailCertificateNone' => 'Ikke avmerket',
    'mail-settings.serverCertificateNotSelected' => 'Sertifikatet ble tilordnet, men e-post for domenet ble ikke sikret. For å fullføre sikring av e-post for domenet, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'Sikre e-post serveren',
    'mail-settings.mailLists' => 'Aktiver adresseliste',
    'mail-settings.mailAutodiscovery' => 'Aktiver e-post autosøk',
    'mail-settings.mailAutodiscoveryDescription' => 'Se hvordan dette fungerer i %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'kunnskapsbase',
    'mail-settings.domainKeys' => 'Bruk DKIM spambeskyttelsessystem til å signere utgående e-postmeldinger.',
    'mail-settings.activeDkimSelector' => 'Aktiv DKIM-selektor',
    'mail-settings.defaultDkimSelector' => ' (Plesk standard)',
    'mail-settings.dkimSelectorName' => 'Selektornavn',
    'mail-settings.buttonCreateSelector' => 'Opprett ny DKIM-velger',
    'mail-settings.createSelectorDialogTitle' => 'Opprett DKIM-velger',
    'mail-settings.removeSelectorDialogTitle' => 'Fjern DKIM-selektor',
    'mail-settings.removeSelectorConfirmation' => "Vil du fjerne velgeren '%%selector%%' og tilhørende nøkler og DNS-oppføringer?",
    'mail-settings.buttonConfirm' => 'OK',
    'mail-settings.buttonCreate' => 'Opprett',
    'mail-settings.buttonCancel' => 'Avbryt',
    'mail-settings.labelRemoveSelector' => 'Fjern',
    'mail-settings.labelActiveSelector' => 'Aktiv',
    'mail-settings.greyListing' => 'Slå på spambeskyttelse med grålisting for alle epostkontoer under dette domenet',
    'mail-settings.howToConfigureExternalDns' => 'Slik konfigurerer du ekstern DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'For å aktivere DKIM-signering når du bruker en ekstern DNS-server må du selv konfigurere DKIM DNS-registrering på DNS-serveren.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'For å gjøre det, bruk DKIM DNS-registrene nedenfor:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Hvis du har domenealiaser du bruker til å sende e-post, legg også DKIM DNS-registrene til dem. Bruk de samme registrene for hoveddomenet, men med domene-aliasnavnet.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'For å se DKIM DNS-registrene du må konfigurere, velg %%option%%, bruk det og åpne dette vinduet igjen.',
    'mail-settings.mailServiceDisabled' => 'Deaktivert',
    'mail-settings.mailServiceDisabledIncoming' => 'Deaktivert for innkommende e-post',
    'mail-settings.mailServiceDisabledHint' => 'Plesk leverer ingen e-posttjenester på dette domenet.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Dette domenet kan kun sende e-post, og kun med Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Aktivert',
    'mail-settings.mailServiceEnabledHint' => 'Dette domenet kan sende og motta e-post.',
    'mail-settings.mailServiceNotConfigured' => 'Ikke konfigurert',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk leverer ingen e-posttjenester på dette domenet.',
    'mail-settings.warning' => 'Dette fjerner domenets mailbokser for godt, med alle mottatte og sendte e-poster.',
    'mail-settings.show.title' => 'Fjern alle mailbokser og e-poster på %%domain%%',
    'mail-settings.show.checkbox' => 'Fjern alle mailbokser på <b>%%domain%%</b> for godt, inkludert mottatte og sendte e-poster.',

    'role.roleSection' => 'Generelt',
    'role.name' => 'Brukerrollenavn',
    'role.description' => 'Beskrivelse',
    'role.generalPermissionsSection' => 'Tilgang til tjenester i Plesk',
    'role.applicationsAccessSection' => 'Tilgang til programmer',
    'role.permissionAllow' => 'Tillatt',
    'role.permissionDeny' => 'Nektet',
    'role.emptyRoleName' => 'Oppgi et rollenavn.',
    'role.installedAt' => 'Installert',
    'role.noInstallationUrlAvailable' => 'Ekstern app',
    'role.invalidRoleName' => 'Det angitte brukerrollenavnet er ikke gyldig.. Spørsmålstegn og anførselstegn kan ikke brukes i rollenavn.',
    'role.longRoleName' => 'Det angitte brukerrollenavnet er for langt.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Noen operasjoner er kanskje ikke tilgjengelige av følgende årsaker: tillatelse for operasjonen er ikke gitt med det valgte abonnementet, eller antall tildelte ressurser er ikke nok til å utføre en operasjon.',
    'role.servicesPermissionsDescription' => 'Definer tilgang til installerte programmer eller tjenester i Plesk for alle brukere med denne rollen. Hvis du gir en bruker tilgang til en app, vil appen bli tilgjengelig for dem i Kundepanel.',
    'role.emailActivation' => 'Aktiver kontoene til denne rollen via e-post',

    'service.admin-access.adminAccess' => 'Administrativ tilgang',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Denne påloggingsinformasjonen vil bli brukt for administrativ tilgang til dette programmet.',
    'service.admin-access.login' => 'Administrativt brukernavn',
    'service.admin-access.password' => 'Administrativt passord',
    'service.admin-access.passwordConfirmation' => 'Bekfreft passord',

    'service.info.service-entry-point.availableAt' => 'Tilgjengelig ved',
    'service.info.service-entry-point.customize' => 'Tilpass snarvei',
    'service.info.service-entry-point.displayNameLabel' => 'Navn på snarvei',
    'service.info.service-entry-point.displayNameDescription' => 'Skriv inn et navn på denne snarveien. Navnet er vist under snarvei ikonet. Snarveier plasseres på Mine tjenester-siden til brukere som gis tilgang til dette programmet.',
    'service.info.service-entry-point.descriptionLabel' => 'Beskrivelse av snarvei',
    'service.info.service-entry-point.descriptionDescription' => 'Gi en beskrivelse av denne snarveien. Beskrivelsen er vist som et verktøytips når kursoren svever over snarveien.',
    'service.info.service-entry-point.iconLabel' => 'Klikk for å velge snarveiikonet',
    'service.info.service-entry-point.iconCurrent' => 'Gjeldende ikon',
    'service.info.service-entry-point.errorEmptyName' => 'Du må angi navn på snarvei',
    'service.info.service-entry-point.errorLongName' => 'Snarvei navnet skal være mellom 1 og 255 tegn.',
    'service.info.service-entry-point.errorLongDescription' => 'Snarvei beskrivelsen skal være mellom 0 og 255 tegn.',
    'service.info.service-entry-point.hiddenLabel' => 'Skjul snarvei',
    'service.info.service-entry-point.hiddenDescription' => 'Ikke vis frem denne snarveien til brukere.',

    'service.info.service-permission.assignedUser' => "Tildel administratortilgang til denne brukeren",
    'service.info.service-permission.assignedUserNone' => 'Ingen bruker tilordnet',

    'shared-ssl.master-ssl.switchedOn' => 'Skru på delt SSL/TLS',
    'shared-ssl.master-ssl.domainName' => 'Domenenavn for et nettsted med et SSL/TLS-sertifikat som skal deles med andre nettsteder',
    'shared-ssl.master-ssl.none' => 'Ingen',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Delt SSL/TLS kan ikke slås på fordi det ikke finnes noen domener med SSL/TLS-støtte aktivert.',

    'user.email.email' => 'E-postadresse',
    'user.email.emptyEmail' => 'Du må angi e-postadresse.',
    'user.email.internalEmailHint' => 'Skap en ny e-post adresse i Plesk eller bruk en ekstern e-post adresse.',
    'user.email.longInternalEmail' => 'E-postadresse er for lang.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Brukernavndelen av e-postadressen er for lang for denne e-postserveren. Oppgi et brukernavn som består av maksimalt %%max%% tegn.',
    'user.email.longInternalEmailFullAddressMailServer' => 'E-postadressen er for lang for denne e-postserveren. Oppgi en e-postadresse som består av maksimalt %%max%% tegn.',
    'user.email.externalEmail' => 'Ekstern e-postadresse',
    'user.email.externalEmailHint' => 'Vil brukes for å tilbakestille ditt passord om du mister tilgang til den primære e-post adressen.',
    'user.email.emailsIsEqual' => 'Den eksterne e-post adressen stemmer overens med den primære. Spesifiser en annen ekstern e-post adresse.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Spesifiser enten en intern eller ekstern e-postadresse.',

    'user.profileSection' => 'Generell informasjon',
    'user.contactName' => 'Kontaktnavn',
    'user.email' => 'E-postadresse',
    'user.role' => 'Brukerrolle',
    'user.accountSection' => 'Plesk preferanser',
    'user.login' => 'Brukernavn',
    'user.password' => 'Passord',
    'user.oldPassword' => 'Gammelt passord',
    'user.buttonBack' => 'Tilbake',
    'user.generalTab' => 'Generelt',
    'user.applicationsAccessSection' => 'Tjenester',
    'user.generalPermissionsSection' => 'Rettigheter',
    'user.contactsTab' => 'Kontaktdetaljer',
    'user.passwordConfirmation' => 'Bekfreft passord',
    'user.internalEmailPasswordChanged' => 'Hvis du endrer passordet, endres også passordet til den interne e-postadressen.',
    'user.emailName' => 'E-postadresse',
    'user.emailType' => 'E-posttype',
    'user.companyName' => 'Firmanavn',
    'user.phone' => 'Telefonnummer',
    'user.imNumber' => 'Instant Messenger',
    'user.fax' => 'Faksnummer',
    'user.address' => 'Adresse',
    'user.city' => 'Poststed',
    'user.state' => 'Delstat/område',
    'user.zip' => 'Postnummer',
    'user.country' => 'Land',
    'user.additionalInfo' => 'Tileggsinformasjon',
    'user.additionalInfoHint' => 'Kun enkel tekst: Alle HTML tags vil bli ignorert.',
    'user.language' => 'Plesk språk',
    'user.buttonChangePassword' => 'Endre passord',
    'user.permissionAllow' => 'Tillatt',
    'user.permissionDeny' => 'Nektet',
    'user.permissionInherited' => 'Definert etter rolle',
    'user.emptyContactName' => 'Du må angi et kontaktnavn.',
    'user.emptyLogin' => 'Du må angi et brukernavn.',
    'user.emptyPassword' => 'Du må angi et passord.',
    'user.emptyPasswordConfirmation' => 'Du må bekrefte passordet.',
    'user.oldPasswordIsIncorrect' => 'Det gamle passordet er feil. Prøv på nytt.',
    'user.chooseDomainBoxTitle' => 'Velg et annet domene:',
    'user.userIsActive' => 'Brukeren er aktiv',
    'user.userIsActiveHint' => 'Aktive brukere kan få tilgang til Plesk.',
    'user.emailActivation' => 'Aktiver konto via e-post',
    'user.emailHint' => 'For å gi brukeren en e-postadresse som er hostet på denne serveren, gå til E-post-fanen, opprett den angitte e-postadressen, og tilknytt den til brukeren.',
    'user.emailContactHint' => 'Ta kontakt med tjenesteleverandør hvis du ønsker å bruke en epostadresse som er hostet på denne serveren.',
    'user.personalEmailHint' => "Denne brukerens e-postadresse kan endre under fanen e-post.",
    'user.externalMailRedirectHint' => 'Videresending kan aktiveres bare på for e-postadresser som er hostet på denne serveren. For å opprette e-postadressen, gå til e-postfanen.',
    'user.externalMailRedirectHint2' => 'Videresending kan aktiveres bare på for e-postadresser som er hostet på denne serveren.',
    'user.externalMailAutoResponderHint' => 'Autosvar kan aktiveres bare på for e-postadresser som er hostet på denne serveren. For å opprette e-postadressen, gå til e-postfanen.',
    'user.externalMailAutoResponderHint2' => 'Autosvar kan aktiveres bare på for e-postadresser som er hostet på denne serveren.',
    'user.roleHint' => 'Brukerroller gir brukere administrative privilegier og tilgang til programmene du valgte for rollen.',
    'user.cannotManageMail' => "Du har ikke tillatelse til å administrere epostinnstillinger og tjenester.",
    'user.longCompanyName' => 'Det angitte navnet på firmaet er for langt.',
    'user.longPhone' => 'Det angitte telefonnummeret er for langt.',
    'user.longFax' => 'Det angitte navnet på faxnummeret er for langt.',
    'user.longAddress' => 'Den angitte adressen er for lang.',
    'user.longCity' => 'Det angitte navnet på byen er for langt.',
    'user.phoneRegexNotMatch' => 'Det angitte telefonnummeret er ikke gyldig.',
    'user.faxRegexNotMatch' => 'Det angitte faxnummeret er ikke gyldig.',
    'user.shortCity' => 'Det angitte navnet på byen er for kort.',
    'user.limitSubscription' => 'Tilgang til abonnementer',
    'user.limitSubscriptionHint' => 'Gi kun brukerne tilgang til et bestemt abonnement. Verdien "Alle" gir dem tilgang til alle abonnementer i hostingkontoen din.',
    'user.limitSubscriptionAll' => 'Alle',
    'user.deletedSubscription' => 'Fjernet abonnement',

    'web.add-domain-alias.title' => 'Legg til et domenealias',
    'web.add-domain-alias.createdSuccessfully' => "Domenealias %%name%% ble opprettet.",
    'web.add-domain-alias.domainAliasName' => 'Navn på domenealias',
    'web.add-domain-alias.domainAliasNameHint' => 'For eksempel: eksempel.net',
    'web.add-domain-alias.forDomain' => 'for domenet',
    'web.add-domain-alias.settingsSectionLegend' => 'Innstillinger',
    'web.add-domain-alias.settingsDns' => 'Synkroniser DNS-sone med primærdomenet',
    'web.add-domain-alias.settingsMail' => 'Posttjeneste',
    'web.add-domain-alias.settingsWeb' => 'Webtjeneste',
    'web.add-domain-alias.settingsSeoRedirect' => 'Omdiriger med HTTP 301 koden',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Når besøkende åpner aliasets URL, vil de bli omdirigert til URL for primærdomenet. Plesk bruker den søkemotorvennlige omdirigeringen HTTP 301, noe som betyr at rangering i søkemotoren ikke vil bli delt mellom URL-adresser.',
    'web.add-domain-alias.settingsTomcat' => 'Java webprogrammer',
    'web.add-domain-alias.invalidDomainGuid' => 'Ugyldig domene',

    'web.add-domain.formTitle' => 'Slik legger du til et nytt domene',
    'web.add-domain.portalLink' => 'Tjenesteportal',
    'web.add-domain.domainName' => 'Domenenavn',
    'web.add-domain.domainNameHint' => "For eksempel: eksempel.com",
    'web.add-domain.assignToCustomer' => 'Tilordne dette domenet til en kunde',
    'web.add-domain.customer' => 'Velg kunde',
    'web.add-domain.createNewCustomer' => 'Opprett en ny kunde',
    'web.add-domain.selectExistingCustomer' => 'Velg en eksisterende kunde:',
    'web.add-domain.customerContactInfoHint' => 'Legg inn kundens kontaktinformasjon. Du kan angi all annen informasjon, som telefonnumre og adresse, på et senere tidspunkt.',
    'web.add-domain.customerLoginInfoHint' => 'Legitimasjon for kundepanelet',
    'web.add-domain.target' => 'Webplass',
    'web.add-domain.createNewTarget' => 'Opprett et nytt abonnement',
    'web.add-domain.createNewTarget_powerUser' => 'Opprett et nytt webområde',
    'web.add-domain.selectExistingTarget' => 'Velg et eksisterende abonnement:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Velg et eksisterende nettområde:',
    'web.add-domain.dns' => 'Aktiver DNS-tjenesten',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Aktiver e-posttjeneste',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Fungerer hvis abonnementets innstillinger tillater administrering av e-posttillatelser pr. domene. Hvis de ikke gjør det, vil den faktiske tjenestestatusen for e-post tas fra abonnementet.',
    'web.add-domain.hostingManagementOptions' => 'Hosting-type',
    'web.add-domain.websiteHosting' => 'Nettstedet hosting',
    'web.add-domain.websiteForwarding' => 'Videresending',
    'web.add-domain.websiteNoHosting' => 'Ingen hosting',
    'web.add-domain.hostingSettingsSectionLegend' => 'Hostinginnstillinger',
    'web.add-domain.domainCreatedSuccessfully' => 'Domenet %%domainName%% ble opprettet.',
    'web.add-domain.webspaceLegend' => 'Nettsted innstillinger',
    'web.add-domain.addWhmWebsiteTitle' => 'Legge til et nytt nettsted',
    'web.add-domain.addWhmWebsiteHint' => "Du kan velge å hoste et nettsted på denne serveren.",
    'web.add-domain.selectWhmDomain' => 'Velg domene',
    'web.add-domain.customerLegend' => 'Kundeinformasjon',
    'web.add-domain.credentials' => 'Systembrukerbevis',
    'web.add-domain.credentialsHint' => 'for adgang til filer hostet over FTP og SSH',
    'web.add-domain.credentialsHintWin' => 'for å få tilgang til hostede filer over FTP og RDP',
    'web.add-domain.buttonAddDomain' => 'Legge til domene',

    'web.add-subdomain.formTitle' => 'Legg til et underdomene',
    'web.add-subdomain.formGeneralHint' => 'Underdomener er internettadresser for forskjellige deler av ditt nettsted. Det bruker hoveddomenenavnet ditt og et prefiks. For eksempel, hvis domenet ditt er domene.com, kan et underdomene være butikk.domene.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Du kan også opprettelse jokertegn underdomener ved å skrive inn symbolet * istedenfor navnet. Besøkende til området vil bli omdirigert til dette underdomenet uansett hvilket underdomenenavn de skriver i nettleseren.',
    'web.add-subdomain.subdomainName' => 'Underdomene-navn',
    'web.add-subdomain.subdomainNameHint' => 'Skriv * for å opprette jokertegn-underdomene.',
    'web.add-subdomain.forDomain' => 'Overordnet domene',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Underdomenet ble opprettet.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Hostinginnstillinger',

    'web.setupService.formTitle' => 'Installasjonstjeneste: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Tjenesten \'%%serviceReference%%\' ble oppdatert.',

    'web.site-copy.subdomainsGroup' => '%%siteName%% underdomener:',
    'web.site-copy.destinationTypeSection' => 'Kopier bestemmelsessted',
    'web.site-copy.destinationType' => 'Velg hvor områdefilene skal kopieres til',
    'web.site-copy.destinationTypeSite' => 'Nettsted i Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Kopier områdefilene til et annet av dine områder som er hostet under denne kontoen. Hvis du har FTP-tilgang til en annen konto på denne serveren, bruk FTP Storage-alternativet.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Kopier områdefiler til et annet område hostet på denne serveren.',
    'web.site-copy.destinationTypeSiteSelect' => 'Områdenavn',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Filer på området %%source%% kan ikke kopieres til %%destination%% fordi %%destination%% også er en del av de filene - dokumentroten er en undermappe av %%source%% dokumentroten.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Filer på området %%destination%% kan ikke fjernes fordi %%source%% filene er en del av dem -- %%source%% dokumentroten er en undermappe av %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'FTP lager',
    'web.site-copy.destinationTypeFtpDescription' => 'Kopier nettstedsfiler til FTP-konto på denne eller en ekstern server.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Kopier nettstedsfiler til FTP-konto på en ekstern server.',
    'web.site-copy.destinationTypeFtpHost' => "Serverens vertsnavn",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Mappe',
    'web.site-copy.destinationTypeFtpUser' => 'Brukernavn',
    'web.site-copy.destinationTypeFtpPassword' => 'Passord',
    'web.site-copy.destinationTypeFtpMode' => 'FTP tilkoblingstype',
    'web.site-copy.destinationTypeFtpModeActive' => 'Aktivt modus',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'In aktiv modus, sender Plesk dets IP-adresse og portnummer hvor den vil lytte til en ekstern server, og serveren initierer TCP-tilkoblingen. Denne modusen er anbefalt når Plesk-serveren er ikke beskyttet av en brannmur.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Passivt modus',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Passiv modus kan brukes når Plesk-serveren er bak en brannmur og ikke kan godta innkommende TCP-tilkoblinger.',
    'web.site-copy.existingFiles' => 'Hva som skal gjøres med eksisterende filer',
    'web.site-copy.existingFilesKeep' => 'Behold eksisterende filer på målområdet',
    'web.site-copy.existingFilesKeepDescription' => 'Vil du overskrive eksisterende filer med tilsvarende filnavn på målområdet?',
    'web.site-copy.existingFilesDelete' => 'Slett alle eksisterende filer',
    'web.site-copy.existingFilesDeleteDescription' => 'Slett alle filer på målområdet før kopiering.',
    'web.site-copy.emptyLogin' => 'Angi FTP-konto brukernavn',
    'web.site-copy.emptyHost' => 'Spesifiser serververtsnavn.',
    'web.site-copy.emptyPort' => 'Spesifiser serververtport.',
    'web.site-copy.copyInProgress' => 'Kopiere webområdet %%sourceName%% til %%destinationName%%. Du vil bli varslet om fremdriften i e-post (%%email%%).',
    'web.site-copy.unableToCopy' => 'Kopiering av nettstedsfilene mislyktes.',
    'web.site-copy.siteCopied' => 'Nettstedsfilene ble kopiert.',
    'web.site-copy.emailSubjSuccess' => 'Nettstedets "%%source%%" filer ble kopiert.',
    'web.site-copy.emailSubjFailure' => 'Kopiering av nettstedets "%%source%%" filer mislyktes.',
    'web.site-copy.emailBodySuccess' => 'Nettstedets "%%source%%" file ble kopiert til "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Kopiering av nettstedets "%%source%%" filer til "%%destination%%" mislyktes: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Videresendingsinnstillinger',
    'web._shared.forwardDestination' => 'Måladresse',
    'web._shared.forwardDestinationHint' => 'URL-adresse for målnettsted.',
    'web._shared.forwardingTypeOptions' => 'Videresending type',
    'web._shared.forwardingFrame' => 'Ramme videresending',
    'web._shared.forwardingFrameHint' => 'Viderekoble besøk på nettsted til et annet område, men ikke vis dem måladressen, slik at de ikke vet om viderekoblingen.',
    'web._shared.forwardingHttpCode301' => 'Permanent flyttet (kode 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Viderekoble besøkende på nettstedet til et annet område og vis dem måladressen. En slik omdirigering vil beholde områdets søkemotor-rangering.',
    'web._shared.forwardingHttpCode302' => 'Temporært flyttet (kode 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Viderekoble besøkende til en midlertidig områdekopi når du ikke vil at søkemotorer skal indeksere dette midlertidige området.',
    'web._shared.documentRoot' => 'Dokumentrot',
    'web._shared.documentRootHint' => 'Banen til nettstedets hjemmemappe.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Det er umulig å endre rottilgang for dokumentet fordi det finnes webprogrammer installert på dette nettstedet.',
    'web._shared.ipAddress' => 'IP-adresse',
    'web._shared.shared' => 'delt',
    'web._shared.exclusive' => 'dedikert',
    'web._shared.ipAddressHint' => "IP-adressen som nettstedet hostes på er en nettverksadresse for nettstedets virtuelle host.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (annet lager)',
    'web._shared.certificate' => 'Sertifikat',
    'web._shared.sameCertificatesHint' => 'Det valgte sertifikat vil brukes for alle områder hostet på samme reserverte IP-adresse.',
    'web._shared.differentCertificatesHint' => 'Dette abonnementet er knyttet til to dedikerte IP-adresser med to forskjellige sertifikater. Det valgte sertifikatet erstatter alle sertifikater installert på områder som hostes på disse to IP-adressene.',
    'web._shared.differentIpTypesCertificateHint' => 'Dette abonnementet er knyttet til én delt og én dedikert IP-adresse. Det valgte sertifikatet brukes også for alle andre områder hostet på den reserverte IP-adressen.',
    'web._shared.certificateNotSelected' => 'Ikke avmerket',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Det er ingen SSL/TLS-sertifikater i ditt depot. Får å legge til et sertifikat, gå til %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'Denne siden',
    'web._shared.seoRedirectDirection' => 'Foretrukket domene',
    'web._shared.seoRedirectDirectionHint' => 'Velg en URL (med eller uten prefikset www.) som besøkende til siden skal omdirigeres til via SEO-sikker HTTP 301 omdirigering.',
    'web._shared.seoRedirectDirectionNone' => 'Ingen',
    'web._shared.limitMbUnits' => 'MB',

    'web-user.settings.allowScripts' => 'Tillat webbruker å bruke skript',

    'web-user.name' => 'Brukernavn for å koble til serveren over FTP',
    'web-user.longName' => 'Dette brukernavnet er for langt (maksimum %max% tegn er tillatt).',
    'web-user.password' => 'Passord',
    'web-user.passwordConfirmation' => 'Bekfreft passord',
    'web-user.hardDiskQuota' => 'Harddisk kvote',
    'web-user.hardDiskQuotaUnlimited' => 'Ubegrenset',
    'web-user.hardDiskQuotaIsNotSupported' => '(harddiskkvote er ikke støttet på grunn av konfigurasjonen av serverfilsystemet.)',
    'web-user.megabytes' => 'MB',

    'web-user.__asp_win_support' => 'Microsoft ASP støtte',
    'web-user.__asp_dot_net_support' => 'Microsoft ASP.NET støtte',
    'web-user.__ssi_support' => 'SSI-støtte',
    'web-user.__php_support' => 'støtte for PHP',
    'web-user.__cgi_support' => 'CGI støtte',
    'web-user.__perl_unix_support' => 'Støtte for Perl',
    'web-user.__perl_win_support' => 'Støtte for Perl',
    'web-user.__python_unix_support' => 'støtte for Python',
    'web-user.__python_win_support' => 'støtte for Python',
    'web-user.__fastcgi_unix_support' => 'FastCGI-støtte',
    'web-user.__webstat_support' => 'Web statistikk',
    'web-user.__apache_errdocs' => 'Brukerdefinerte feildokumenter',
    'web-user.__hosting_write_modify' => 'Ekstra skrive/modifiseringstillatelser',
    'web-user.__hosting_webdeploy' => 'Web Deploy-publisering',


    'requiredFields' => 'Obligatoriske felt',
];