<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Hvis dit websted hostes på en dedikeret IP-adresse (ikke delt med andre brugere eller websteder), kan du opsætte en mappe på webstedet hvor andre bruger anonymt vil kunne uploade eller downloade filer via FTP.  Når anonym FTP er aktiveret, vil brugerne kunne logge på mappen vha. en adresse som f.eks. ftp://ftp.dit-domæne.com med brugernavnet "anonymous" og en vilkårlig adgangskode.',
    'anonymous-ftp.displayLogin' => 'Vis login-meddelelse',
    'anonymous-ftp.loginText' => 'Beskedtekst',
    'anonymous-ftp.incomingDir' => 'Tillad upload til den indgående mappe',
    'anonymous-ftp.incomingSubDir' => 'Tillad oprettelse af mapper i den indgående mappe',
    'anonymous-ftp.incomingReadable' => 'Tillad download fra den indgående mappe',
    'anonymous-ftp.quota' => 'Begræns diskpladsen i mappe til indkommende mail',
    'anonymous-ftp.maxConnections' => 'Begræns antallet af samtidige forbindelser',
    'anonymous-ftp.bandwidth' => 'Begræns download-båndbredden for dette virtuelle FTP-domæne',
    'anonymous-ftp.unlimited' => 'Ubegrænset',

    'aps.catalog.loading' => 'Indlæser…',
    'aps.catalog.searchName' => 'Applikation',
    'aps.catalog.searchVendor' => 'Leverandør',
    'aps.catalog.searchPackager' => 'Objektpakning',
    'aps.catalog.searchLicenseType' => 'Licenstype',
    'aps.catalog.searchLicenseTypeAny' => 'Alle',
    'aps.catalog.searchLicenseTypeFreeware' => 'Gratis',
    'aps.catalog.searchLicenseTypeCommercial' => 'Kommerciel',
    'aps.catalog.showSearch' => 'Vis søgning',
    'aps.catalog.hideSearch' => 'Skjul søgning',
    'aps.catalog.buttonSearch' => 'Søg',
    'aps.catalog.buttonResetSearch' => 'Nulstil søgning',
    'aps.catalog.showCategories' => 'Vælg en kategori herunder eller søg efter apps vha. søgeboksen',
    'aps.catalog.searchResults' => 'Søgeresultater',
    'aps.catalog.buttonInstall' => 'Installer',
    'aps.catalog.buttonInstallTooltip' => 'Installér hurtigt den seneste version af app\'en med optimale standardparametre.',
    'aps.catalog.buttonAdvancedInstall' => 'Installér (brugerdefineret)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Installér den seneste version af app\'en, og tilpas alle parametre.',
    'aps.catalog.buttonInstallOldVersion' => 'Installer version',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Installér den valgte version af app\'en, og tilpas alle parametre.',
    'aps.catalog.buttonInstallDescription' => 'Installér programmet på et websted, hvis du allerede har en aktiveringskode eller blot ønsker at prøve det.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Installér dette gratis program på et websted.',
    'aps.catalog.version' => 'Version',
    'aps.catalog.moreVersions' => 'Flere versioner',
    'aps.catalog.release' => 'Frigiv',
    'aps.catalog.overview' => 'Oversigt',
    'aps.catalog.noApplicationsInCategory' => 'Der er for øjeblikket ingen tilgængelige programmer i denne kategori. Vælg en anden kategori',
    'aps.catalog.noCategoriesSelected' => 'Vælg den kategori du vil gennemse for tilgængelige programmer.',
    'aps.catalog.noSearchResults' => 'Din søgning gav ingen resultater.',
    'aps.catalog.connectionFailed' => 'Tilslutning til Programkataloget mislykkedes. %%retryLink%%.',
    'aps.catalog.retry' => 'Prøv igen',
    'aps.catalog.categoriesError' => 'Liste med kategorier der ikke kunne indlæses i øjeblikket.',
    'aps.catalog.applicationsError' => 'Liste med programmer der ikke kunne indlæses i øjeblikket.',
    'aps.catalog.detailsError' => 'Programinformation kunne ikke indlæses i øjeblikket.',
    'aps.catalog.searchError' => 'Søgeresultaterne kunne ikke indlæses i øjeblikket.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Udgave %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Ændringshistorik',
    'aps.catalog.officialApplicationSite' => 'Leverandørinfo',
    'aps.catalog.returnToCategories' => '<< Tilbage til liste over programmer',
    'aps.catalog.buttonUninstall' => 'Fjern',
    'aps.catalog.gotoHome' => 'Forside',
    'aps.catalog.all' => 'Alle',
    'aps.catalog.buttonDetails' => 'Få flere oplysninger',
    'aps.catalog.buttonBuy' => 'Køb nu',
    'aps.catalog.buttonBuyTooltip' => 'Køb programmet',
    'aps.catalog.buttonBuyDescription' => 'Besøg vor onlinebutik for at købe en aktiveringskode til programmet.',
    'aps.catalog.buttonDownload' => 'Download',
    'aps.catalog.buttonDownloadDescription' => 'Download programmet, hvis du allerede har en aktiveringskode eller blot ønsker at prøve det.',
    'aps.catalog.marketplaceMoreInfo' => 'For yderligere information, besøg %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'programleverandørens websted',

    'aps.configure.installedAt' => "Installeret på",
    'aps.configure.otherSettings' => "Andet",
    'aps.configure.globalSettings' => 'Pakkeindstillinger',
    'aps.configure.passwordConfirmation' => 'Bekræft adgangskode',
    'aps.configure.databaseParams' => 'Parametre for database',
    'aps.configure.noInstallationUrlAvailable' => 'Ingen (eksternt program)',
    'aps.configure.updateSettingsSection' => 'Opdatereringsindstillinger',
    'aps.configure.forceUpdates' => 'Opdatér automatisk dette program når opdateringer er til rådighed',
    'aps.configure.forceUpdatesHint' => 'Programmet vil automatisk modtage opdateringer til nyere versioner. Advarsel: Brug denne funktion med forsigtighed, da opdateringer kan påvirke programmernes funktionalitet væsentligt. Eksempelvis kan programudvidelser stoppe med at fungere med andre versioner af programmet.',

    'aps.install.showAllSettings' => 'Vis alle indstillinger',
    'aps.install.showLessSettings' => 'Vis minimumindstillinger',
    'aps.install.install' => 'Installer',
    'aps.install.otherSettings' => 'Andre indstillinger',
    'aps.install.globalSettings' => 'Pakkeindstillinger',
    'aps.install.passwordConfirmation' => 'Bekræft adgangskode',
    'aps.install.provisionsSectionLabel' => 'Installationssti',
    'aps.install.context' => 'Angiv hvor dette webprogram skal installeres',
    'aps.install.registerAsWebmailSection' => 'Webmail-registrering',
    'aps.install.registerAsWebmailDescription' => "Vælg denne indstilling hvis programmet er en webmail-klient. Dette vil få programmet til at blive vist mellem de webmailservices der er til rådighed i E-mail indstillingerne for abonnementer og serviceplaner. Administratoren kan konfigurere URL til offentlige adgang til webmail i Serveradministration > Indstillinger > Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Registrér som en webmail-service',
    'aps.install.addItem' => 'Tilføj',
    'aps.install.removeItem' => 'Fjern',
    'aps.install.updateSettingsSection' => 'Opdatereringsindstillinger',
    'aps.install.forceUpdates' => 'Opdatér automatisk dette program når opdateringer er til rådighed',
    'aps.install.forceUpdatesHint' => 'Programmet vil automatisk modtage opdateringer til nyere versioner. Advarsel: Brug denne funktion med forsigtighed, da opdateringer kan påvirke programmernes funktionalitet væsentligt. Eksempelvis kan programudvidelser stoppe med at fungere med andre versioner af programmet.',

    'aps.invalid-requirements.requirementsLegend' => 'Krav',
    'aps.invalid-requirements.domainLegend' => 'Websted',
    'aps.invalid-requirements.context' => 'Vælg et andet websted',
    'aps.invalid-requirements.backToApplicationList' => 'Tilbage til liste over programmer',

    'aps.license.title' => 'Installation af %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'For at kunne installere dette program skal du læse slutbrugerlicensaftalen og erklære dig enig i vilkårene i denne.',
    'aps.license.licenseAgree' => 'Jeg accepterer betingelserne i licensaftalen',

    'aps.services-list-customization.settings' => 'Indstillinger',

    'asp-dot-net.change-version.title' => 'Valg af ASP.NET-version',
    'asp-dot-net.change-version.frameworkVersion' => 'ASP.NET framework-version',
    'asp-dot-net.change-version.success' => 'ASP.NET-versionen blev ændret.',

    'asp-dot-net.settings.casSettingsSection' => "Kodeadgangssikkerhed",
    'asp-dot-net.settings.clientScriptsSection' => "Indstillinger for scriptbibliotek",
    'asp-dot-net.settings.connStringsSection' => "Administration af forbindelsesstrenge",
    'asp-dot-net.settings.customErrorsSection' => "Brugerdefinerede fejlindstillinger",
    'asp-dot-net.settings.frameworkVersionSection' => "Framework-version",
    'asp-dot-net.settings.globalizationSection' => "Globaliseringsindstillinger",
    'asp-dot-net.settings.otherSection' => "Indstillinger for session",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Kompilering og debugging",
    'asp-dot-net.settings.authMode' => "Godkendelsestilstand",
    'asp-dot-net.settings.connStrings' => "Forbindelsesstrenge",
    'asp-dot-net.settings.connStringsInvalid' => "Nogle felter er tomme, eller indeholder en ugyldig værdi.",
    'asp-dot-net.settings.connStringName' => "Navn",
    'asp-dot-net.settings.connStringValue' => "Forbindelsesparametre",
    'asp-dot-net.settings.connStringsDescription' => "Navn/forbindelsesparametre",
    'asp-dot-net.settings.culture' => "Kultur",
    'asp-dot-net.settings.customErrMode' => "Tilstand for brugerdefinerede fejl",
    'asp-dot-net.settings.customErrorRedirect' => "Omdirigerings-URL",
    'asp-dot-net.settings.customErrorStatus' => "Statuskode",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Statuskode skal være et heltal.",
    'asp-dot-net.settings.customErrors' => "Brugerdefinerede fejl",
    'asp-dot-net.settings.customErrorsDescription' => "Statuskode/URL-adresse til omdirigering",
    'asp-dot-net.settings.customErrorsInvalid' => "Nogle felter er tomme, eller indeholder en ugyldig værdi.",
    'asp-dot-net.settings.debugMode' => "Aktivér debugging",
    'asp-dot-net.settings.defLanguage' => "Standard websidesprog",
    'asp-dot-net.settings.tempDirectory' => "Midlertidigt bibliotek",
    'asp-dot-net.settings.fileEnc' => "Filkodning",
    'asp-dot-net.settings.fileEncInvalid' => "Den specificerede værdi for filkodningsparameter er ugyldig.",
    'asp-dot-net.settings.pathToLib' => "Sti til Microsoft script-bibliotek",
    'asp-dot-net.settings.pathToLibInstall' => "Installer",
    'asp-dot-net.settings.reqEnc' => "Anmod om kodning",
    'asp-dot-net.settings.reqEncInvalid' => "Den specificerede værdi for anmodningskodningsparameter er ugyldig.",
    'asp-dot-net.settings.resEnc' => "Kodning af svar",
    'asp-dot-net.settings.resEncInvalid' => "Den specificerede værdi for responskodningsparameter er ugyldig.",
    'asp-dot-net.settings.sessTimeout' => "Sessionstimeout (minutter):",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Den specificerede værdi for parameteret Session timeout parameter er ugyldig. Angiv et positivt heltal, der er mindre end eller lig med %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Navnet på forbindelsesstrengen er allerede i brug.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Statuskoden skal være mellem 100 og 999",
    'asp-dot-net.settings.customErrorDuplicate' => "Statuskoden er allerede i brug.",
    'asp-dot-net.settings.trustLevel' => "CAS-tillidsniveau",
    'asp-dot-net.settings.uiCulture' => "Brugergrænsefladekultur",
    'asp-dot-net.settings.version' => "Version",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Tillad tilsidesættelse af CAS trust-niveau på et websted',
    'asp-dot-net.settings.updateSuccess' => 'Opdateringen lykkedes',

    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.cloneInProgress' => 'Kloner databasen %%source%% til databasen %%destination%%. Du bliver adviseret om installationsforløbet via e-mail (%%email%%).',
    'database.clone.unableToClone' => 'Kunne ikke kopiere databasen "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Der kan ikke oprettes en database "%%destination%%" på den angivne server.',
    'database.clone.databaseCloned' => 'Databasen "%%source%%" blev kopieret.',
    'database.clone.emailSubjSuccess' => 'Databasen "%%sourceDatabase%%" blev kopieret.',
    'database.clone.emailSubjFailure' => 'Kopiering af databasen "%%sourceDatabase%%" mislykkedes.',
    'database.clone.emailBodySuccess' => 'Databasen "%%sourceDatabase%%" (%%sourceHost%%) blev kopieret til databasen "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Kunne ikke kopiere databasen "%%sourceDatabase%%" (%%sourceHost%%) til databasen "%%destDatabase%%" (%%destHost%%). Kopieringsproceduren mislykkedes.',
    'database.clone.localServer' => 'lokal server',

    'database.repair-orphaned.formDescription' => 'Denne bruger blev uafhængig efter gendannelsesprocessen. Indtast en adgangskode for denne bruger for at rette problemet. Hvis denne bruger påregnes at være en sys-bruger uden adgangskode, skal reparationsværktøjet køres med tomt adgangskodefelt.',
    'database.repair-orphaned.login' => 'Database-brugernavn',
    'database.repair-orphaned.pass' => 'Adgangskode',
    'database.repair-orphaned.pass2' => 'Bekræft adgangskode',
    'database.repair-orphaned.users' => 'Nogle brugere kræver din opmærksomhed. Der er flere uafhængige brugere, der skal repareres, for at kunne fungere korrekt.',
    'database.repair-orphaned.orphaned' => 'Brugeren er uafhængig. %%gui begin:link%%Reparér1 nu%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Reparer',

    'database.repair.fixSelected' => 'Reparer valgte',
    'database.repair.fix' => 'Reparer',

    'database.user.username' => 'Database brugernavn',
    'database.user.password' => 'Adgangskode',
    'database.user.passwordConfirmation' => 'Bekræft adgangskode',
    'database.user.server' => 'Databaseserver',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Database',
    'database.user.anyDatabase' => 'Alle',
    'database.user.dataAccess' => 'Data-adgang',
    'database.user.structureAccess' => 'Strukturadgang',
    'database.user.globalAccess' => 'Globale privilegier',
    'database.user.globalAccessHint' => 'Globale privilegier fungerer for alle databaser på denne hostingkonto.',
    'database.user.aclRadio' => 'Adgangskontrol',
    'database.user.aclLocalhost' => 'Tillad kun lokale forbindelser',
    'database.user.aclAny' => 'Tillad eksterne forbindelser fra enhver host',
    'database.user.aclCustom' => 'Tillad eksterne forbindelser fra',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\n De angivne hosts må tilgå databasen på vegne af denne bruger.",
    'database.user.remoteAccess' => 'Ekstern adgang',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDe angivne IP-adresser har adgang til databaseserveren via en firewallregel. Dine ændringer på denne liste vil blive modereret på forhånd af din hostingudbyder.",
    'database.user.example' => "F.eks.:\n%%example%%",
    'database.user.denied' => 'Brug systemets firewall-regler',
    'database.user.allowed' => 'Tillad eksterne forbindelser fra',
    'database.user.default' => 'Anvend denne brugers akkreditiver som standard til adgang til %%webadmin%%',
    'database.user.remoteAccessHint' => 'Kontakt din hostingudbyder og sørg for, at ovenstående valg er i overensstemmelse med de aktuelle firewall-regler for indgående adgang til MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Web administrator',
    'database.user.role' => 'Rolle',
    'database.user.roleReadWrite' => 'Læse og skrive',
    'database.user.roleWriteOnly' => 'Læsebeskyttet',
    'database.user.roleReadOnly' => 'Skrivebeskyttet',
    'database.user.roleCustom' => 'Valgfri',

    'database.versionCut' => 'v%%version%%',

    'deployment-section.deploymentDisabledHint' => 'Upload filer fra et Git-opbevaringsområde',
    'deployment-section.deploymentEnabledHint' => 'Aktiver Git-understøttelse',
    'deployment-section.deploymentSectionLegend' => 'Dine filer der skal kopieres til Hosting',
    'deployment-section.deploymentSectionDescriptionHint' => 'Hvis du ikke aktiverer Gitunderstøttelse, bliver rodmapperne (websted/applikationsod og dokumentrod) oprettet tomme, og webstedet vil vise standardsiden i  browseren. Du vil så skulle uploade webstedets filer til dokumentroden vha. FTP eller Filadministrator. Alternativt kan du aktivere Git nu eller senere (under Websteder og domæner) og uploade filerne fra et Git-opbevaringsområde.',

    'dns-zone.add-acl-record.description' => 'Tilføj en IP-adresse til en DNS-server der må modtage en kopi af DNS-zonen.',
    'dns-zone.add-acl-record.ipAddress' => 'IP-adresse',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP-adresse/maske',

    'dns-zone.record.add-title' => "Føj ressourcepost til zoneskabelonen.",
    'dns-zone.record.add-ns-title' => "Tilføj navneserver",
    'dns-zone.record.edit-title' => "Redigér ressource-post",
    'dns-zone.record.edit-success' => "DNS-posten blev opdateret.",
    'dns-zone.record.add-success' => "DNS-posten blev oprettet.",
    'dns-zone.record.type' => "Post-type",
    'dns-zone.record.domainName' => "Domænenavn",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Navneserver",
    'dns-zone.record.optionOff' => 'Deaktiveret',
    'dns-zone.record.optionOn' => 'Aktiveret',
    'dns-zone.record.protocol' => "Protokol",
    'dns-zone.record.priority' => "Prioritet",
    'dns-zone.record.priorityLow' => "lav (%%priority%%)",
    'dns-zone.record.priorityHigh' => "meget høj (%%priority%%)",
    'dns-zone.record.weightLow' => "lav (%%weight%%)",
    'dns-zone.record.weightHigh' => "meget høj (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP-adresse",
    'dns-zone.record.ipAddressDescription' => "For eksempel 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "For eksempel <ip> 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6 adresse",
    'dns-zone.record.ipAddressV6Description' => "F.eks. 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "For eksempel <ipv6> 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "F.eks. 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "For eksempel <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "F.eks. 002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Kanonisk navn",
    'dns-zone.record.mailDomain' => "E-mail-domæne",
    'dns-zone.record.mxServer' => "E-mail udvekslingsserver",
    'dns-zone.record.mxServerPriority' => "Angiv mail-exchange serverens prioritet",
    'dns-zone.record.txtRecord' => "TXT-post:",
    'dns-zone.record.txtRecordString' => "Angiv poststreng.",
    'dns-zone.record.txtSpfSyntax' => "SPF-post:",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Forkerte værdier for TXT-post blev specificeret.",
    'dns-zone.record.quotedTxtRecord' => "Værdien af TXT-posten skal bestå af en enkelt streng og må ikke indeholde anførselstegn.",
    'dns-zone.record.dsRecord' => "DS-post",
    'dns-zone.record.dsRecordDescription' => "For eksempel, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "En forkert værdi for DS-post blev specificeret.",
    'dns-zone.record.serviceName' => "Servicenavn",
    'dns-zone.record.serviceNameDescription' => 'Eksempel: SIP (uden understregningstegnet).',
    'dns-zone.record.protocolNameDescription' => 'Eksempel: tcp (uden understregningstegnet).',
    'dns-zone.record.portDescription' => 'Eksempel: 25 (uden understregningstegnet).',
    'dns-zone.record.srvWeight' => "Relativ vægt for poster med samme prioritet",
    'dns-zone.record.targetHost' => "Mål-host",
    'dns-zone.record.targetHostDescription' => "For eksempel eksempel.com",
    'dns-zone.record.targetPort' => "Destinationsport:",
    'dns-zone.record.targetPortDescription' => 'For eksempel 8443.',
    'dns-zone.record.retrieveDataError' => "Postdata blev ikke fundet.",
    'dns-zone.record.unknownTypeError' => "Ukendt DNS-posttype.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Kan ikke opsætte NULL MX-post mens anden MX-post er til stede',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Kan ikke opsætte ikke-NULL MX-post mens NULL MX-post er tilstede',
    'dns-zone.record.masterShouldBeRemote' => "Du skal have to autoritative name servers på separate værter.",
    'dns-zone.record.caaTag' => "Mærke",
    'dns-zone.record.caaRecord' => "Værdi",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protokol',
    'dns-zone.record.tlsaUsage' => 'Forbrug',
    'dns-zone.record.tlsaSelector' => 'Selektor',
    'dns-zone.record.tlsaMatching' => 'Matchingtype',
    'dns-zone.record.tlsaCertData' => 'Certifikattilknytningsdata',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Se %%link%% for yderligere oplysninger',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, afsnit 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, afsnit 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, afsnit 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, afsnit 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "alias (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'For eksempel example.com. En tom værdi betyder, at værten er den samme som domænenavnet.',
    'dns-zone.record.httpsProtocols' => 'Protokoller',
    'dns-zone.record.httpsProtocolsDescription' => 'En kommasepareret liste over protokoller, der understøttes af målet. For eksempel h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Gennemtving eksklusiv brug af de angivne protokoller. Listen over protokoller ovenfor må ikke være tom.',
    'dns-zone.record.httpsIpv4hint' => 'Forslag til IPv4-adresser',
    'dns-zone.record.httpsIpv4hintDescription' => 'En kommasepareret liste over IPv4-adresser, der kan bruges af en klient til at få adgang til tjenesten.',
    'dns-zone.record.httpsIpv6hint' => 'Forslag til IPv6-adresser',
    'dns-zone.record.httpsIpv6hintDescription' => 'En kommasepareret liste over IPv6-adresser, der kan bruges af en klient til at få adgang til tjenesten.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Sekunder",
    'dns-zone.record.invalidValue' => 'Værdien er ugyldig. Den kan være mellem 1 sekund og 2147483647 sekunder.',
    'dns-zone.record.ttlDefaultValue' => 'Standardværdi: %%value%% sekunder',
    'dns-zone.record.invalidTTL' => 'Den angivne TTL-værdi er ugyldig.',
    'dns-zone.record.invalidIpAddress' => 'Den angivne IP-adresse er ugyldig.',
    'dns-zone.record.invalidIpMaskPair' => 'Det angivne IP-adresse/netmaske-par er ugyldigt.',
    'dns-zone.record.invalidCName' => 'Det angivne kanoniske navn er ugyldigt.',
    'dns-zone.record.invalidPort' => 'Den angivne port er ugyldig.',
    'dns-zone.record.invalidTLSACertData' => 'De angivne certifikattilknytningsdata er ugyldige.',
    'dns-zone.record.invalidTLSAProtocol' => 'Den angivne protokol er ugyldig.',
    'dns-zone.record.invalidTLSAUsage' => 'Den angivne anvendelse er ikke gyldig.',
    'dns-zone.record.invalidTLSASelector' => 'Den angivne selektor er ugyldig.',
    'dns-zone.record.invalidTLSAMatching' => 'Den angivne matchningstype er ugyldig.',

    'dns-zone.restore-default.formHint' => "Her kan du gendanne den originale zonekonfiguration i overensstemmelse med standard DNS-skabelonindstillingerne der anvendes på serveren.  Vælg de IP-adresser der skal bruges til gendannelse af zonen og angiv om et www-alias kræves til domænet.",
    'dns-zone.restore-default.ipv4' => "IPv4-adresse",
    'dns-zone.restore-default.ipv4Hint' => "For eksempel 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6 adresse",
    'dns-zone.restore-default.ipv6Hint' => "F.eks. 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Den angivne IP-adresse er ugyldig.',
    'dns-zone.restore-default.customIpHint' => "Poster med denne IP-adresse betragtes som bruger-modificerede, og de vil ikke blive synkroniserede med den overordnede server-DNS-skabelon.",
    'dns-zone.restore-default.wwwPrefix' => "www præfiks",
    'dns-zone.restore-default.previewRecords' => "Gendan de poster, der anvendes til eksempelvisning",

    'dns-zone.soa-record.soaMnameSection' => 'Primær navneserver',
    'dns-zone.soa-record.soaMname' => 'Navneserver',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Autovælg)',
    'dns-zone.soa-record.soaRecordSection' => 'SOA-post',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Opdater',
    'dns-zone.soa-record.retry' => 'Prøv igen',
    'dns-zone.soa-record.expire' => 'Udløber',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'E-mail (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'E-mailadressen på den person, der har ansvaret for domænets DNS-zone. Returneres af DNS-serveren som respons på SOA-forespørgsler.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Webstedsejerens e-mail adresse.',
    'dns-zone.soa-record.rnameTypeDomain' => 'Domæne email-adresser',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Angiv kun den lokale del (før @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Ekstern email-adresse',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Forbyd ændring af RNAME email-adresse på en pr. domæne-basis',
    'dns-zone.soa-record.invalidValue' => 'Værdien er ugyldig Den kan være fra 1 sekund til 68 år.',
    'dns-zone.soa-record.advancedSection' => 'Avancerede DNS-funktioner',
    'dns-zone.soa-record.serialNumberFormat' => 'Brug det serienummerformat, der anbefales af IETF og RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Vælg indstillingen, hvis dit domæne har problemer med at få registratoren godkendt af SOA-kontrollen. Mange domæneregistratorer kræver dette serienummerformat.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Brug standardindstillingerne',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Zone-standard',
    'dns-zone.soa-record.unitSeconds' => 'sekunder',
    'dns-zone.soa-record.unitMinutes' => 'minutter',
    'dns-zone.soa-record.unitHours' => 'timer',
    'dns-zone.soa-record.unitDays' => 'dage',
    'dns-zone.soa-record.unitWeeks' => 'uger',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Opdateringsværdien Interval er mindre end en time, hvilket kan forøge servertrafikken og ressourceforbruget kritisk.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Indstilling af Minimum TTL-værdien til mere end 3 timer kan gøre dine domæner utilgængelige for nogle af domæneadministratorerne. Det anbefales kun at indstille en sådan værdi, hvis din domænenavns-registrator insisterer på det.',
    'dns-zone.soa-record.success' => 'Egenskaberne for SOA-posten blev opdateret.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Standard SOA-posten blev genoprettet.',

    'domain-info-section.domainName' => 'Domænenavn',
    'domain-info-section.emptyDomainName' => 'Angiv et domænenavn.',
    'domain-info-section.ipAddress' => 'IP-adresse',
    'domain-info-section.shared' => 'delt',
    'domain-info-section.exclusive' => 'dedikeret',
    'domain-info-section.ipAddressHint' => "IP-adressen hvorpå webstedet hostes er netværksadressen på webstedets virtuelle mappe. Denne IP-adresse vil blive anvendt til alle websteder der oprettes i dette abonnement.",
    'domain-info-section.ipAddressHint_powerUser' => "IP-adressen hvorpå webstedet hostes er netværksadressen på webstedets virtuelle mappe. Denne IP-adresse vil blive anvendt til alle websteder der oprettes på denne webspace.",
    'domain-info-section.userName' => 'Brugernavn',
    'domain-info-section.userNameHint' => 'Systembrugerkonto, der er knyttet sammen med webspace\'n, som bruges til at få adgang til filer via FTP og SSH.',
    'domain-info-section.emptyLogin' => 'Angiv et brugernavn',
    'domain-info-section.password' => 'Adgangskode',
    'domain-info-section.emptyPassword' => 'Angiv en adgangskode.',
    'domain-info-section.passwordConfirmation' => 'Gentag adgangskode',

    'email-address.generalTab' => 'Generelt',
    'email-address.generalHint' => 'Hvis denne e-mail konto er knyttet til en hjælpebruger (Adgang til Kundepanelet er aktiveret), kan de foretagne ændringer på denne side påvirke denne brugers indstillinger. I særdeleshed - hvis du ændrer e-mailadressen og adgangskoden vil hjælpebrugerens login og adgangskode også blive ændret til de nye værdier.',
    'email-address.redirectTab' => 'Videresender',
    'email-address.redirectHint' => 'Konfigurer videresendelse af e-mail-meddelelser til en eller flere e-mailadresser.',
    'email-address.aliasesTab' => 'E-mail aliasser',
    'email-address.autoResponderTab' => 'Autosvar',
    'email-address.antispamTab' => 'Spamfilter',
    'email-address.autoResponderHint' => 'Opsæt en automatisk respons til alle e-mails der kommer til din e-mailadresse. Autosvar er en standardmetode til advisering af dine korrespondenter om, at du ikke er på kontoret eller holder ferie.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'E-mailadresse',
    'email-address.externalEmail' => 'Ekstern email-adresse',
    'email-address.externalEmailHint' => 'Vil blive anvendt til nulstilling af adgangskoden, hvis du mister adgangen til den primære email-adresse.',
    'email-address.user' => 'Knyttet til',
    'email-address.password' => 'Adgangskode',
    'email-address.passwordConfirmation' => 'Bekræft adgangskode',
    'email-address.clientConfigurationLink' => 'Link til e-mailkonfigurator',
    'email-address.responderEnable' => 'Aktivér autosvar',
    'email-address.responderSubject' => 'Autosvar-meddelelsesemne',
    'email-address.responderContentType' => 'Meddelelsesformat',
    'email-address.responderContentTypeHint' => 'Almindeligt tekstformat understøttes af alle e-mail klientprogrammer. Derfor vil alle modtagere kunne se meddelelser på samme måde som du ser dem. HTML-meddelelser ser bedre ud, fordi de lader dig indsætte formateret tekst med forskellige skrifttyper. Nogle e-mail klienter understøtter imidlertid ikke HTML-meddelelser, og nogle af modtagerne kan muligvis ikke se den formaterede tekst.',
    'email-address.responderContentTypeTextPlain' => 'Almindelig tekst',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Kodning',
    'email-address.responderCodepageHint' => 'Kodningen definerer hvordan tekst-tegn bliver vist. Den anbefalede kodning er UTF-8.',
    'email-address.responderReplyTo' => 'Videresend til',
    'email-address.responderReplyToHint' => 'Når den automatiske respons er sendt, vil den originale meddelelse blive videresendt til den specificerede e-mailadresse.',
    'email-address.responderForwardAddress' => 'Videresend til',
    'email-address.responderForwardAddressHint' => 'Når den automatiske respons er sendt, vil den originale meddelelse blive videresendt til den specificerede e-mailadresse.',
    'email-address.responderMessage' => 'Autosvar meddelelsestekst',
    'email-address.responderReplyToEqualsEmail' => 'Den angivne e-mail videresendelsesadresse er det samme som denne e-mailadresse.',
    'email-address.responderForwardAddressEqualsEmail' => 'Den angivne e-mail videresendelsesadresse er det samme som denne e-mailadresse.',
    'email-address.responderReplyLimit' => 'Send højst en automatisk respons til en unik e-mailadresse x gange dagligt',
    'email-address.buttonAddResponderAttachment' => 'Tilføj en vedhæftet fil',
    'email-address.buttonRemoveResponderAttachment' => 'Fjern',
    'email-address.responderAttachment' => 'Vedhæft en fil',
    'email-address.redirectEnable' => 'Aktivér e-mail videresendelse',
    'email-address.redirectRemoveEnable' => 'Levér ikke kopier af videresendte e-mails til Plesk-mailbokse',
    'email-address.redirectAddress' => 'Videresend indkommende meddelelser til følgende e-mailadresse',
    'email-address.redirectAddressHint' => 'Angiv e-mailadresser Du kan enten skrive hver adresse på en ny linje eller adskille adresserne med mellemrum, kommaer eller semikolon.',
    'email-address.role' => 'Brugerrolle',
    'email-address.roleHint' => 'Brugerroller giver brugere administrative tilladelser og adgang til programmer, som du har valgt til rollen.',
    'email-address.errorRedirectAddress' => 'Du angav en ugyldig email-adresse: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Du angav ugyldige email.adresser: %value%.',
    'email-address.mailAlias' => "E-mail alias",
    'email-address.mailAliasNone' => 'Ingen',
    'email-address.mailAliasHint' => "E-mail aliasser er alternative e-mailadresser der er knyttet sammen med den primære e-mailadresse. Al e-mail der sendes til e-mail aliasser vil blive modtaget af den primære e-mailadresse.",
    'email-address.buttonAddMailAlias' => 'Tilføj e-mail alias',
    'email-address.buttonRemoveMailAlias' => 'Fjern',
    'email-address.emptyEmail' => 'Angiv e-mailadresse hvortil alle indkommende meddelelser skal videresendes.',
    'email-address.emailsIsEqual' => 'Den eksterne email-adresse matcher den primære. Angiv en anden ekstern  email-adresse.',
    'email-address.emptyPassword' => 'Du skal angive en adgangskode.',
    'email-address.emptyPasswordConfirmation' => 'Du skal bekræfte adgangskoden.',
    'email-address.emptyAlias' => "Angiv e-mail alias for denne e-mailadresse.",
    'email-address.aliasEqualsEmail' => 'Det angivne e-mail alias er det samme som e-mailadressen.',
    'email-address.passwordHint' => 'Vil blive brugt til tilgang til mailboksen og indlogning i Plesk (hvis den korresponderende indstilling er aktiveret).',
    'email-address.cyclicRedirect' => 'En e-mailadresse kan ikke opsættes til at videresende e-mail meddelelser til sig selv.',
    'email-address.errorMailnameReserved' => 'Den angivne e-mailadresse er allerede i brug.',
    'email-address.antivirusEnable' => 'Aktivér spamfiltrering for denne e-mailadresse',
    'email-address.antivirusHint' => 'Antivirus-service blokerer e-mail meddelelser der indeholder vira og adviserer både sender og modtager om dette.',
    'email-address.antivirusSettings' => 'Kontroller om der er vira',
    'email-address.antivirusSettingOnlyIncomingMail' => 'kun indkommende e-mails',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'Kun udgående e-mails',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'indkommende og udgående e-mail',
    'email-address.antispamHint' => 'Spamfiltreringsservice detekterer spammeddelelser der sendes til e-mailadressen. Du kan indstille spamfiltret til at slette spammeddelelserne, til at markere dem som spam ved at ændre deres emne, eller flytte dem til en speciel spam-mappe, som e-mail klienter kan tilgå via IMAP. Spamfiltret bruger en lang række lokale og netværkstests til identifikation af spamsignaturer.',
    'email-address.antispamEnable' => 'Aktivér spamfiltrering for denne e-mailadresse',
    'email-address.antispamSettings' => 'Hvad skal der gøres med meddelelser, der klassificeres som spam',
    'email-address.antispamSettingsMark' => 'Vælg spam-meddelelser ved at tilføje følgende tekst til meddelelsens emne',
    'email-address.antispamSettingsMarkHint' => 'Lad dette felt være tomt, hvis du ikke vil tilføje tekst. Indtast _SCORE_ hvis du vil inkludere score i meddelelsens emne.',
    'email-address.antispamReportTextHint' => 'Indtast den tekst, du vil føje til spam-e-mail meddelelsens brødtekst.',
    'email-address.antispamSettingsDelete' => 'Slet alle spam-meddelelser',
    'email-address.antispamSettingsDeleteHint' => 'Spam-meddelelser bliver slettet fra din mailboks.',
    'email-address.antispamSettingsMove' => 'Flyt spam til mappen Spam',
    'email-address.antispamSettingsMoveHint' => 'Flyt alle spam-meddelelser til mappen ved navn Spam. Denne mappe kan tilgås fra dit e-mail klientprogram eller fra webmail. Hvis du bruger en MAP e-mail konto kan du bruge mappen Spam til træning af spamfiltret.',
    'email-address.antispamSettingsMoveWarning' => '"Flyt spam til spam-mappen" fungerer ikke, medmindre du deaktiverer indstillingen "Levér ikke kopier af videresendte e-mails" under fanen "Videresendelse".',
    'email-address.antispamSettingsMoveJunk' => 'Flyt spam til mappen Spam',
    'email-address.antispamSettingsMoveJunkHint' => 'Flyt alle spam-meddelelser til mappen ved navn Spam. Denne mappe kan tilgås fra dit e-mail klientprogram eller fra webmail. Hvis du bruger en MAP e-mail konto kan du bruge mappen "Uønsket e-mail" til træning af spamfiltret.',
    'email-address.antispamShowAdvancedSection' => 'Vis avancerede indstillinger',
    'email-address.antispamHideAdvancedSection' => 'Skjul avancerede indstillinger',
    'email-address.antispamLearnMore' => 'Lær hvordan du træner spamfiltret.',
    'email-address.antispamFilterScoreTitle' => 'Filterfølsomhed',
    'email-address.antispamFilterScoreHint' => 'Spamfiltret udfører et antal forskellige tests på indhold og emnelinje for hver meddelelse. Som resultat heraf får hver meddelelse et antal point. Jo højere pointtal, jo større er sandsynligheden for at meddelelsen er spam. Som standard er filtret følsomhed indstillet, så alle meddelelser der får 7 eller flere point klassificeres som spam. Hvis du modtager masser af spammeddelelser med den nuværende indstilling, kan du gøre filtret mere sensitivt ved at indtaste en lavere værdi, f.eks. 6. Hvis du mangler e-mails fordi dit spamfilter tror de er spam, kan du prøve at reducere filterfølsomheden ved at bruge en højere værdi, f.eks. 8.',
    'email-address.antispamFilterScore' => 'Spamfilter-følsomhed',
    'email-address.antispamWhiteListTitle' => 'Hvidliste',
    'email-address.antispamWhiteListHint' => 'E-mails fra afsendere på hvidlisten bliver ikke tjekket af spamfiltret.',
    'email-address.antispamWhiteListField' => 'Hvidliste',
    'email-address.antispamWhiteListFieldHint' => 'Indtast domænenavne, ét domæne pr. linje. Adresser kan indeholde "*" og "?" jokertegn (f.eks. *@domæne.com, bruger?@*.com).',
    'email-address.antispamBlackListTitle' => 'Sortlist',
    'email-address.antispamBlackListHint' => 'E-mails fra afsendere på sortlisten klassificeres som spam.',
    'email-address.antispamBlackListField' => 'Sortlist',
    'email-address.antispamBlackListFieldHint' => 'Indtast domænenavne, ét domæne pr. linje. Adresser kan indeholde "*" og "?" jokertegn (f.eks. *@domæne.com, bruger?@*.com).',
    'email-address.antispamTrustedLanguagesTitle' => 'Sprog der er tillid til',
    'email-address.antispamTrustedLanguagesHint' => 'E-mail meddelelser der er skrevet på disse sprog vil altid passere gennem filtret.',
    'email-address.antispamTrustedLocalesTitle' => 'Localer der er tillid til',
    'email-address.antispamTrustedLocalesHint' => 'E-mail meddelelser der anvender de angivne locale-grupper vil altid passere gennem filtret. Locale-grupper inkluderer de mest anvendte tegnsæt. Eksempelvis inkluderer tegnsættet Western kodninger for bogstaver der bruges på Dansk og vesteuropæiske sprog.',
    'email-address.antispamTrustedNetworksTitle' => 'Netværk der er tillid til',
    'email-address.antispamTrustedNetworksHint' => 'Relæer der hostes på netværk der er tillid til betragtes ikke som potentielt værende drevet af spammere, og de er ikke åbne relæer eller åbne proxies.',
    'email-address.antispamIpAddressesField' => 'IP-adresser',
    'email-address.antispamIpAddressesFieldHint' => 'Angiv netværkets IP-adresse og maske.',
    'email-address.mailBoxQuotaDomainDefault' => 'Standardstørrelse (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Standardstørrelse',
    'email-address.mailBoxOutgoingMessages' => 'Det maksimale antal udgående e-mail meddelelser',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Standard (%%domainOutgoingMessages%% meddelelser pr. time)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Brugerdefineret værdi for mailboksen',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'beskeder',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Standard',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Standardstørrelse',
    'email-address.mailBoxQuotaDomainSpecific' => 'Anden størrelse',
    'email-address.mailBoxQuotaDomainSpecificValue' => 'Anden størrelsesværdi',
    'email-address.mailBoxQuotaDomainSpecificMultiplier' => 'Størrelsesenheder',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Størrelse på mailboks:',
    'email-address.mailBoxQuotaUnlimited' => 'Ubegrænset',
    'email-address.mailBoxLimitReached' => 'Grænsen for antallet af mailbokse blev nået.',
    'email-address.postboxEnabled' => 'Mailboks',
    'email-address.postboxEnabledYes' => 'Aktiveret',
    'email-address.postboxEnabledNo' => 'Deaktiveret',
    'email-address.description' => 'Beskrivelse i Plesk',
    'email-address.descriptionHint' => 'Beskrivelsen kan ses af alle, der har adgang til denne e-mail konto.',
    'email-address.longDescription' => 'Den angivne beskrivelse er for lang. Den kan ikke være længere end %%max%% symboler.',
    'email-address.loginAsUser' => 'Kan bruges til indlogning i Plesk',
    'email-address.loginAsUserDescription' => '(brugernavn: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Mailboksstørrelsen kan ikke overstige standardstørrelsen.',
    'email-address.endDateEnable' => 'Sluk for autosvar',

    'failed-request.enable-tracing.description' => 'Sporing af mislykkede anmodninger er en ressource-intensiv operation. Sporingen stoppes automatisk om %%days%% dage. Du kan til enhver tid manuelt deaktivere den.',
    'failed-request.enable-tracing.statusCodes' => 'Statuskoder',
    'failed-request.enable-tracing.statusCodesDescription' => 'Eksempelvis: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Udbyder',

    'file-manager.permissions.filePermissions' => 'Filtilladelser',
    'file-manager.permissions.directoryPermissions' => 'Bibliotekstilladelser',
    'file-manager.permissions.buttonSubmit' => 'Gem',
    'file-manager.permissions.buttonApply' => 'Gem og genoptag',
    'file-manager.permissions.buttonCancel' => 'Annuller',
    'file-manager.permissions.buttonAdvanced' => 'Avanceret',

    'file-manager.unix-file-permissions.group' => 'Gruppe',
    'file-manager.unix-file-permissions.owner' => 'Ejer',
    'file-manager.unix-file-permissions.others' => 'Andre',
    'file-manager.unix-file-permissions.readMode' => 'Læs',
    'file-manager.unix-file-permissions.writeMode' => 'Skriv',
    'file-manager.unix-file-permissions.execMode' => 'Udfør/søg',
    'file-manager.unix-file-permissions.changeRecursive' => 'Opdater tilladelser rekursivt',

    'file-manager.windows-permissions.allow' => 'Tillad',
    'file-manager.windows-permissions.deny' => 'Afvis',
    'file-manager.windows-permissions.inheritFromParent' => 'Tillad, at tilladelser, der kan nedarves, overføres fra det overordnede objekt til dette objekt og alle underordnede objekter Inkludér disse med de poster, der eksplicit er defineret her',
    'file-manager.windows-permissions.replaceOnChildren' => 'Erstat tilladelsesposter på alle underordnede objekter med de poster, der er vist her',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avanceret',
    'file-manager.windows-permissions.applyTo' => 'Anvend på:',
    'file-manager.windows-permissions.folderOnly' => 'Kun denne mappe',
    'file-manager.windows-permissions.subfolderOnly' => 'Kun undermapper',
    'file-manager.windows-permissions.filesOnly' => 'Kun filer',
    'file-manager.windows-permissions.permissionsFor' => 'Tilladelser for',
    'file-manager.windows-permissions.applyOnto1' => 'Kun denne mappe',
    'file-manager.windows-permissions.applyOnto2' => 'Kun undermapper',
    'file-manager.windows-permissions.applyOnto3' => 'Denne mappe og undermapper',
    'file-manager.windows-permissions.applyOnto4' => 'Kun filer',
    'file-manager.windows-permissions.applyOnto5' => 'Denne mappe og filer',
    'file-manager.windows-permissions.applyOnto6' => 'Kun filer og undermapper',
    'file-manager.windows-permissions.applyOnto7' => 'Denne mappe, undermapper, og filer',
    'file-manager.windows-permissions.notInherited' => '<ikke nedarvet>',

    'file-manager.editor.titleTextEditor' => 'Teksteditor',
    'file-manager.editor.titleCodeEditor' => 'Code Editor',
    'file-manager.editor.titleHtmlEditor' => 'HTML-editor',
    'file-manager.editor.titleCodeViewer' => 'Vis',
    'file-manager.editor.buttonSubmit' => 'Gem',
    'file-manager.editor.buttonApply' => 'Gem og genoptag',
    'file-manager.editor.buttonSaveAs' => 'Gem som...',
    'file-manager.editor.buttonCancel' => 'Annuller',
    'file-manager.editor.exitConfirmationYes' => 'Ja',
    'file-manager.editor.exitConfirmationNo' => 'Nej',
    'file-manager.editor.fileOverwrite' => 'Filen findes allerede.',
    'file-manager.editor.fileOverwriteDescription' => 'Der findes allerede en fil med det samme navn. Vil du overskrive den?',
    'file-manager.editor.exitConfirmation' => 'Er du sikker på, at du vil låse filen og kassere ikke-gemte ændringer?',
    'file-manager.editor.buttonCodeEditor' => 'Rediger i Code Editor',
    'file-manager.editor.buttonTextEditor' => 'Rediger i Text Editor',

    'file-manager.html-editor.toolbar.textStyle' => 'Tekststil',
    'file-manager.html-editor.toolbar.textStyleDesc' => 'Tekststil',
    'file-manager.html-editor.toolbar.insert' => 'Indsæt',
    'file-manager.html-editor.toolbar.insertDesc' => 'Tilføj billeder, videoer, links eller tabeller',

    'file-manager.import-file.buttonSubmit' => 'Importer',
    'file-manager.import-file.fieldUrl' => 'URL til filen',
    'file-manager.import-file.fieldUrlDescription' => 'Angiv kilde-URL, f.eks., \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Det fulde URL-mønster er det følgende: \'https://user:password@example.com/example.tgz\'. Brugernavn og adgangskode er valgfri. De understøttede protokoller we http, https, ftp, ftps. Brug URL-kodning til URL-dele, der indeholder specialtegn eller mellemrum.',
    'file-manager.import-file.failure' => 'Kan ikke importere filen.',

    'file-manager.rotation-settings.title' => 'Rotationsindstillinger for papirkurv',
    'file-manager.rotation-settings.rotationBySize' => 'Rotation efter størrelse',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Indstillingen sletter nye filer, hvis den angivne grænse for papirkurven overskrides.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotation efter dato',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Dage',
    'file-manager.rotation-settings.rotationByDateHint' => 'Indstillingen sletter de filer, der ligger i papirkurven i mere end et angivet antal dage.',
    'file-manager.rotation-settings.save' => 'Gem',
    'file-manager.rotation-settings.cancel' => 'Annuller',

    'ftp-user.description' => 'Hvis du arbejder på dit websted sammen med en anden, eller du er vært for underdomæner for andre brugere, kan du have brug for at oprette separate FTP-konti for disse.',
    'ftp-user.generalSection' => 'Generelt',
    'ftp-user.login' => 'FTP-kontonavn',
    'ftp-user.home' => 'Hjemmebibliotek',
    'ftp-user.systemArea' => 'Opret en FTP-konto med adgang til filer udenfor hjemmemappen',
    'ftp-user.password' => 'Adgangskode',
    'ftp-user.passwordConfirmation' => 'Bekræft adgangskode',
    'ftp-user.hardQuotaSection' => 'Harddiskkvote',
    'ftp-user.hardQuota' => 'Harddiskkvote',
    'ftp-user.hardQuotaUnlimited' => 'Ubegrænset',
    'ftp-user.permissionsSection' => 'Rettigheder',
    'ftp-user.permissionRead' => 'Læserettigheder',
    'ftp-user.permissionWrite' => 'Skrivetilladelse',
    'ftp-user.selectButtonLabel' => 'Vælg bibliotek',
    'ftp-user.popupTitle' => 'Vælg bibliotek',
    'ftp-user.limitMbUnits' => 'MB',

    'mail-list.listName' => 'Maillisteadresse',
    'mail-list.enabled' => 'Aktiveret',
    'mail-list.administratorEmail' => 'Mailingliste-administrators e-mail',
    'mail-list.password' => 'Adgangskode',
    'mail-list.passwordConfirmation' => 'Bekræft adgangskode',
    'mail-list.subscribers' => 'Abonnenter',
    'mail-list.subscribersHint' => 'Angiv e-mailadresser  Du kan skrive hver adresse på en ny linje, eller adskille adresserne med mellemrum, komma eller semikolon.',
    'mail-list.notify' => 'Advisér administrator ved oprettelse af mailingliste',
    'mail-list.emptyPassword' => 'Angiv en adgangskode.',
    'mail-list.emptyPasswordConfirmation' => 'Bekræft adgangskoden.',
    'mail-list.errorSubscribers' => 'Ugyldige e-mail adresser: %value%.',
    'mail-list.errorMaillistReserved' => 'Den angivne mailinglisteadresse er allerede i brug.',

    'mail-settings.copyToClipboard' => 'Kopiér DNS-posten til udklipsholderen.',
    'mail-settings.copySuccess' => 'DNS-posten blev kopieret til udklipsholderen.',
    'mail-settings.hint' => 'Her kan du ændre mailservice indstillingerne for dette domæne.',
    'mail-settings.service' => 'Mailservice på dette domæne',
    'mail-settings.nonExist' => 'Hvad skal der gøres ved e-mails to ikke-eksisterende brugere?',
    'mail-settings.nonExistBounceWithMessage' => 'Bounce med meddelelse',
    'mail-settings.nonExistBounce' => 'Bounce',
    'mail-settings.nonExistCatch' => 'Videresend til-adresse',
    'mail-settings.nonExistCatchDescription' => 'E-mail adressen skal tilhøre det valgte domæne. Kun administratoren kan specificere en ekstern adresse eller en adresse til flere domæner.',
    'mail-settings.nonExistExternal' => 'Omdirigér til en ekstern mailserver med IP-adressen',
    'mail-settings.nonExistReject' => 'Afvis',
    'mail-settings.nonExistDiscard' => 'Afvis',
    'mail-settings.webmail' => 'Webmail',
    'mail-settings.webmailNone' => 'Ingen',
    'mail-settings.webmailComponentNotInstalled' => 'Webmail-komponenten var ikke installeret.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Der er et underdomæne med navnet %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'SSL/TLS-certifikater til webmail',
    'mail-settings.webmailCertificateNone' => 'Ikke valgt',
    'mail-settings.mailCertificate' => 'SSL/TLS-certifikat til mail',
    'mail-settings.mailCertificateNone' => 'Ikke valgt',
    'mail-settings.serverCertificateNotSelected' => 'Certifikatet blev tilknyttet, men mail til domænet blev ikke sikret. Færdiggør sikring af mail til domænet, ved hjælp af %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'sikre mailserveren',
    'mail-settings.mailLists' => 'Aktivér mailinglister',
    'mail-settings.mailAutodiscovery' => 'Aktiver e-mail autoopdagelse',
    'mail-settings.mailAutodiscoveryDescription' => 'Se hvordan det fungerer i %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'videnbase',
    'mail-settings.domainKeys' => 'Brug DKIM spambeskyttelsessystem til signering af udgående e-mails',
    'mail-settings.activeDkimSelector' => 'Aktiv DKIM-selektor',
    'mail-settings.defaultDkimSelector' => ' (Plesk som standard)',
    'mail-settings.dkimSelectorName' => 'Selektornavn',
    'mail-settings.buttonCreateSelector' => 'Opret ny DKIM-selektor',
    'mail-settings.createSelectorDialogTitle' => 'Opret DKIM-selektor',
    'mail-settings.removeSelectorDialogTitle' => 'Fjern DKIM-selektoren',
    'mail-settings.removeSelectorConfirmation' => "Vil du fjerne selectoren '%%selector%%' sammen med dens tilknyttede nøgler og DNS-poster?",
    'mail-settings.buttonConfirm' => 'OK',
    'mail-settings.buttonCreate' => 'Opret',
    'mail-settings.buttonCancel' => 'Annuller',
    'mail-settings.labelRemoveSelector' => 'Fjern',
    'mail-settings.labelActiveSelector' => 'Aktiv',
    'mail-settings.greyListing' => 'Aktivér gråliste spambeskyttelse for alle e-mailkonti under dette domæne',
    'mail-settings.howToConfigureExternalDns' => 'Sådan konfigureres ekstern DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Du kan aktivere DKIM-signering, hvis du bruger en ekstern DNS-server, skal du selv konfigurere DKIM DNS-posterne på DNS-serveren.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Det kan du gøre ved at bruge nedenstående DKIM DNS-poster:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Hvis du har domænealiasser, som du bruger til afsendelse af email, skal du også tilføje DKIM DNS-poster for disse. Brug de samme poster som til hoveddomænet, men med domænealias-navnet.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Hvis du vil se de DKIM DNS-poster, du skal konfigurere, skal du sætte kryds i afkrydsningsfeltet "%%option%%", anvende det og åbne denne pop-up igen.',
    'mail-settings.mailServiceDisabled' => 'Deaktiveret',
    'mail-settings.mailServiceDisabledIncoming' => 'Deaktiveret for indkommende e-mails',
    'mail-settings.mailServiceDisabledHint' => 'Plesk leverer ikke e-mail-tjenester på dette domæne.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Dette domæne kan kun sende e-mail, og kun ved hjælp af Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Aktiveret',
    'mail-settings.mailServiceEnabledHint' => 'Dette domæne kan sende og modtage mail.',
    'mail-settings.mailServiceNotConfigured' => 'Ikke konfigureret',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk leverer ikke e-mail-tjenester på dette domæne.',
    'mail-settings.warning' => 'Dette vil permanent fjerne domænets mailbokse med alle modtagne og sendte e-mails.',
    'mail-settings.show.title' => 'Fjern alle mailbokse og e-mails fra %%domain%%',
    'mail-settings.show.checkbox' => 'Fjern permanent alle mailbokse fra %%domain%%, herunder modtagne og sendte e-mails.',

    'role.roleSection' => 'Generelt',
    'role.name' => 'Brugerrollenavn',
    'role.description' => 'Beskrivelse',
    'role.generalPermissionsSection' => 'Adgang til Pleskservices',
    'role.applicationsAccessSection' => 'Adgang til programmer',
    'role.permissionAllow' => 'Bevilget',
    'role.permissionDeny' => 'Nægtet',
    'role.emptyRoleName' => 'Angiv et rollenavn.',
    'role.installedAt' => 'Installeret på',
    'role.noInstallationUrlAvailable' => 'Eksternt program',
    'role.invalidRoleName' => 'Det angivne rollenavn er ikke gyldigt. Spørgsmålstegn og citationstegn kan ikke bruges i et rollenavn.',
    'role.longRoleName' => 'Det angivne rollenavn er for langt.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Nogle handlinger er muligvis ikke til rådighed af følgende grunde: en tilladelse til handlingen er ikke givet med det nuværende valgte abonnement, eller mængden af reserverede ressourcer er ikke stor nok til udførelse af en handling.',
    'role.servicesPermissionsDescription' => 'Definér adgang til installerede programmer eller Pleskservices for alle brugere med denne rolle. Hvis du giver en bruger adgang til et program, vil programmet være til rådighed for vedkommende i Kundepanelet.',
    'role.emailActivation' => 'Aktiver denne rolles konti vha. e-mail',

    'service.admin-access.adminAccess' => 'Administrativ adgang',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Disse akkreditiver vil blive brug til administrativ adgang til dette program.',
    'service.admin-access.login' => 'Administrativt brugernavn',
    'service.admin-access.password' => 'Administrativ adgangskode',
    'service.admin-access.passwordConfirmation' => 'Bekræft adgangskode',

    'service.info.service-entry-point.availableAt' => 'Tilgængelig på',
    'service.info.service-entry-point.customize' => 'Tilpas genvej',
    'service.info.service-entry-point.displayNameLabel' => 'Navn på genvej',
    'service.info.service-entry-point.displayNameDescription' => 'Skriv et navn til denne genvej: Navnet vises under genvejsikonen. Genveje indsættes på Mine services-siderne hos brugere der har fået adgang til dette program.',
    'service.info.service-entry-point.descriptionLabel' => 'Beskrivelse af genvej',
    'service.info.service-entry-point.descriptionDescription' => 'Giv en beskrivelse af denne genvej. Beskrivelsen vises som et værktøjstip, når mus-markøren bevæges hen over genvejen.',
    'service.info.service-entry-point.iconLabel' => 'Klik for at vælge genvejsikonen.',
    'service.info.service-entry-point.iconCurrent' => 'Nuværende ikon:',
    'service.info.service-entry-point.errorEmptyName' => 'Du skal indtaste et genvejsnavn.',
    'service.info.service-entry-point.errorLongName' => 'Genvejsnavnet skal være på mellem 1 og 255 tegn.',
    'service.info.service-entry-point.errorLongDescription' => 'Genvejsbeskrivelsen skal være på mellem 0 og 255 tegn.',
    'service.info.service-entry-point.hiddenLabel' => 'Skjul genvej',
    'service.info.service-entry-point.hiddenDescription' => 'Vis ikke denne genvej for brugere.',

    'service.info.service-permission.assignedUser' => "Giv administrativ adgang til denne bruger",
    'service.info.service-permission.assignedUserNone' => 'Ingen bruger tilknyttet',

    'shared-ssl.master-ssl.switchedOn' => 'Aktivér delt SSL/TLS',
    'shared-ssl.master-ssl.domainName' => 'Domænenavne for et websted hvis SSL/TLS-certifikat vil blive delt mellem andre websteder',
    'shared-ssl.master-ssl.none' => 'Ingen',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Delt SSL/TLS  kan ikke aktiveres, da der ikke er nogen domæner med aktiveret SSL/TLS-understøttelse.',

    'user.email.email' => 'E-mailadresse',
    'user.email.emptyEmail' => 'Du skal angive en e-mailadresse.',
    'user.email.internalEmailHint' => 'Opret en ny email-adresse i Plesk, eller brug en ekstern email-adresse.',
    'user.email.longInternalEmail' => 'E-mailadressen er for lang.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Brugernavnsdelen af emailadressen er for lang til denne mailserver. Angiv et brugernavn på højst %%max%% tegn.',
    'user.email.longInternalEmailFullAddressMailServer' => 'E-mailadressen er for lang til denne mailserver. Angiv en adresse på højst %%max%% tegn.',
    'user.email.externalEmail' => 'Ekstern email-adresse',
    'user.email.externalEmailHint' => 'Vil blive anvendt til nulstilling af adgangskoden, hvis du mister adgangen til den primære email-adresse.',
    'user.email.emailsIsEqual' => 'Den eksterne email-adresse matcher den primære. Angiv en anden ekstern  email-adresse.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Angiv enten intern eller ekstern e-mailadresse.',

    'user.profileSection' => 'Generel information',
    'user.contactName' => 'Kontakt navn',
    'user.email' => 'E-mailadresse',
    'user.role' => 'Brugerrolle',
    'user.accountSection' => 'Plesk-indstillinger',
    'user.login' => 'Brugernavn',
    'user.password' => 'Adgangskode',
    'user.oldPassword' => 'Gammel adgangskode',
    'user.buttonBack' => 'Tilbage',
    'user.generalTab' => 'Generelt',
    'user.applicationsAccessSection' => 'Tjenester',
    'user.generalPermissionsSection' => 'Privilegier',
    'user.contactsTab' => 'Oplysninger om kontakter',
    'user.passwordConfirmation' => 'Bekræft adgangskode',
    'user.internalEmailPasswordChanged' => 'Hvis du ændrer adgangskoden, ændres den interne adgangskode til e-mailadressen også.',
    'user.emailName' => 'E-mailadresse',
    'user.emailType' => 'E-mail-type',
    'user.companyName' => 'Firmanavn',
    'user.phone' => 'Telefonnummer',
    'user.imNumber' => 'Instant messenger',
    'user.imType' => 'Instant messenger-program',
    'user.fax' => 'Faxnummer:',
    'user.address' => 'Adresse',
    'user.city' => 'By',
    'user.state' => 'Område eller provins',
    'user.zip' => 'Postnummer.',
    'user.country' => 'Land',
    'user.additionalInfo' => 'Flere oplysninger',
    'user.additionalInfoHint' => 'Kun almindelig tekst. Eventuelle HTML-koder udelades.',
    'user.language' => 'Plesk-sprog',
    'user.buttonChangePassword' => 'Skift adgangskode',
    'user.permissionAllow' => 'Bevilget',
    'user.permissionDeny' => 'Nægtet',
    'user.permissionInherited' => 'Definér efter rolle',
    'user.emptyContactName' => 'Du skal indtaste et kontaktnavn.',
    'user.emptyLogin' => 'Du skal angive et brugernavn',
    'user.emptyPassword' => 'Du skal angive en adgangskode.',
    'user.emptyPasswordConfirmation' => 'Du skal bekræfte adgangskoden.',
    'user.oldPasswordIsIncorrect' => 'Den gamle adgangskode er forkert. Prøv igen.',
    'user.chooseDomainBoxTitle' => 'Vælg et andet domæne:',
    'user.userIsActive' => 'Brugeren er aktiv',
    'user.userIsActiveHint' => 'Aktive brugere har adgang til Plesk.',
    'user.emailActivation' => 'Aktiver konto vha. e-mail',
    'user.emailHint' => 'Hvis du vil give brugeren en e-mailadresse der hostes på denne server, skal du åbne fanen E-mail, oprette den ønskede e-mailadresse og knytte den til denne bruger.',
    'user.emailContactHint' => 'Kontakt din serviceudbyder, hvis du vil bruge en e-mailadresse der hostes på denne server.',
    'user.personalEmailHint' => "Denne brugers e-mailadresse kan ændres under fanen E-mail tab.",
    'user.externalMailRedirectHint' => 'Videresendelse kan kun aktiveres for e-mailadresser der hostes på denne server. Skift til fanen E-mail for at oprette en e-mailadresse.',
    'user.externalMailRedirectHint2' => 'Videresendelse kan kun aktiveres for e-mailadresser der hostes på denne server.',
    'user.externalMailAutoResponderHint' => 'Autosvar kan kun aktiveres for e-mailadresser der hostes på denne server. Skift til fanen E-mail for at oprette en e-mailadresse.',
    'user.externalMailAutoResponderHint2' => 'Autosvar kan kun aktiveres for e-mailadresser der hostes på denne server.',
    'user.roleHint' => 'Brugerroller giver brugere administrative tilladelser og adgang til programmer, som du har valgt til rollen.',
    'user.cannotManageMail' => "Du har ikke tilladelse til at administrere e-mail indstillinger og services.",
    'user.longCompanyName' => 'Det angivne firmanavn er for langt.',
    'user.longPhone' => 'Det angivne telefonnummer er for langt.',
    'user.longFax' => 'Det angivne faxnummer er for langt.',
    'user.longAddress' => 'Den angivne adresse er for lang.',
    'user.longCity' => 'Det angivne bynavn er for langt.',
    'user.phoneRegexNotMatch' => 'Det angivne telefonnummer er ikke gyldigt.',
    'user.faxRegexNotMatch' => 'Det angivne faxnummer er ikke gyldigt.',
    'user.shortCity' => 'Det angivne bynavn er for kort.',
    'user.limitSubscription' => 'Adgang til abonnementer',
    'user.limitSubscriptionHint' => 'Tillad kun brugere adgang til et bestemt abonnement. Værdien "Alle" giver brugerne adgang til alle abonnementer på din hosting-konto.',
    'user.limitSubscriptionAll' => 'Alle',
    'user.deletedSubscription' => 'Fjernet abonnement',

    'web.add-domain-alias.title' => 'Tilføje et domænealias',
    'web.add-domain-alias.createdSuccessfully' => "Domæne-aliaset %%name%% blev oprettet.",
    'web.add-domain-alias.domainAliasName' => 'Domænets aliasnavn',
    'web.add-domain-alias.domainAliasNameHint' => 'For eksempel eksempel.net',
    'web.add-domain-alias.forDomain' => 'for domænet',
    'web.add-domain-alias.settingsSectionLegend' => 'Indstillinger',
    'web.add-domain-alias.settingsDns' => 'Synkroniser DNS-zone med det primære domæne',
    'web.add-domain-alias.settingsMail' => 'Posttjeneste',
    'web.add-domain-alias.settingsWeb' => 'Webtjeneste',
    'web.add-domain-alias.settingsSeoRedirect' => 'Omdirigér med HTTP-kode 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Når besøgende åbner aliasets URL, bliver de omdirigeret til det primære domænes URL. Plesk bruger den søgemaskinevenlige HTTP 301-omdirigering, hvilket betyder, at søgemaskine-ranking ikke vil blive delt mellem URL\'erne.',
    'web.add-domain-alias.settingsTomcat' => 'Java-webprogrammer',
    'web.add-domain-alias.invalidDomainGuid' => 'Ugyldigt domæne',

    'web.add-domain.formTitle' => 'Tilføjer nyt domæne',
    'web.add-domain.portalLink' => 'Services-portal',
    'web.add-domain.domainName' => 'Domænenavn',
    'web.add-domain.domainNameHint' => "For eksempel eksempel.com",
    'web.add-domain.assignToCustomer' => 'Knyt denne database til en kunde',
    'web.add-domain.customer' => 'Vælg en kunde',
    'web.add-domain.createNewCustomer' => 'Opret en ny kunde',
    'web.add-domain.selectExistingCustomer' => 'Vælg en eksisterende kunde:',
    'web.add-domain.customerContactInfoHint' => 'Indtast kundens kontaktinformation. Du kan angive alle andre oplysninger om f.eks. telefonnummer og adresse senere.',
    'web.add-domain.customerLoginInfoHint' => 'Akkreditiver for kundepanel',
    'web.add-domain.target' => 'Webspace',
    'web.add-domain.createNewTarget' => 'Opret et nyt abonnement',
    'web.add-domain.createNewTarget_powerUser' => 'Opret ny webs pace',
    'web.add-domain.selectExistingTarget' => 'Vælg en eksisterende abonnement:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Vælg et eksisterende webspace:',
    'web.add-domain.dns' => 'Aktivér DNS-service',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Aktiver e-mail service',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Fungerer, hvis abonnementets indstillinger tillader administration af email-tilladelser pr. domæne. Hvis dette ikke er tilfældet, vil den faktiske emailservice status blive hentet fra abonnementet.',
    'web.add-domain.hostingManagementOptions' => 'Hostingtype',
    'web.add-domain.websiteHosting' => 'Webstedshosting',
    'web.add-domain.websiteForwarding' => 'Videresender',
    'web.add-domain.websiteNoHosting' => 'Ingen hosting',
    'web.add-domain.hostingSettingsSectionLegend' => 'Hosting-indstillinger',
    'web.add-domain.domainCreatedSuccessfully' => 'Domænet %%domainName%% blev korrekt oprettet.',
    'web.add-domain.webspaceLegend' => 'Webspace-indstillinger',
    'web.add-domain.addWhmWebsiteTitle' => 'Tilføjer nyt websted',
    'web.add-domain.addWhmWebsiteHint' => "Du kan vælge at være host for et websted på serveren.",
    'web.add-domain.selectWhmDomain' => 'Vælg domæne',
    'web.add-domain.customerLegend' => 'Kunde-info',
    'web.add-domain.credentials' => 'Systembruger-akkreditiver',
    'web.add-domain.credentialsHint' => 'for adgang til hostede filer over FTP og SSH',
    'web.add-domain.credentialsHintWin' => 'for at få adgang til hostede filer via FTP og RDP',
    'web.add-domain.buttonAddDomain' => 'Tilføj domæne',

    'web.add-subdomain.formTitle' => 'Tilføj et underdomæne',
    'web.add-subdomain.formGeneralHint' => 'Underdomæner er Internet-adresser til forskellige sektioner på dit websted. De bruger dit hoveddomænenavn og et præfiks. Hvis dit domæne f.eks. hedder domæne.com, kan underdomænet hedde butik.domæne.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Du kan også oprette et jokertegn-underdomæne ved at indsætte symbolet * i stedet for navnet. Webstedsbesøgende omdirigeres til dette underdomæne, uanset hvilket underdomænenavn de indtaster i en browser.',
    'web.add-subdomain.subdomainName' => 'Underdomænenavn',
    'web.add-subdomain.subdomainNameHint' => 'Indtast * for at oprette et jokertegn-underdomæne.',
    'web.add-subdomain.forDomain' => 'Overordnet domæne',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Underdomænet blev oprettet.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Hosting-indstillinger',

    'web.setupService.formTitle' => 'Opsæt servicen: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => '\'%%serviceReference%%\' servicen blev korrekt opdateret.',

    'web.site-copy.subdomainsGroup' => '%%siteName%% underdomæner:',
    'web.site-copy.destinationTypeSection' => 'Kopi-destination',
    'web.site-copy.destinationType' => 'Vælg hvor webstedsfilerne skal kopieres til',
    'web.site-copy.destinationTypeSite' => 'Websted i Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Kopiér webstedsfilerne til et andet af dine websteder, der hostes under denne konto. Hvis du har FTP-adgang til en anden konto på denne server, skal du bruge FTP-lagringsmuligheden.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Kopiér webstedsfilerne til et andet websted, der hostes under denne konto.',
    'web.site-copy.destinationTypeSiteSelect' => 'Webstedsnavn',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Filer på webstedet %%source%% kan ikke kopieres til %%destination%% da %%destination%% også er en del af disse filer -- dets dokumentrod er en undermappe af %%source%% dokumentroden.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Filer på webstedet %%destination%% kan ikke fjernes, da %%source%% filerne er en del af dem -- %%source%% dokumentroden er en undermappe af %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'FTP-lagring',
    'web.site-copy.destinationTypeFtpDescription' => 'Kopiér webstedsfiler til en FTP-konto på en ekstern server.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Kopiér webstedsfiler til en FTP-konto på en ekstern server.',
    'web.site-copy.destinationTypeFtpHost' => "Server-hostnavn",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Bibliotek',
    'web.site-copy.destinationTypeFtpUser' => 'Brugernavn',
    'web.site-copy.destinationTypeFtpPassword' => 'Adgangskode',
    'web.site-copy.destinationTypeFtpMode' => 'FTP-forbindelsesmetode',
    'web.site-copy.destinationTypeFtpModeActive' => 'Aktiv tilstand',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'I aktiv tilstand sender Plesk sin IP-adresse og det portnummer hvorpå det vil lytte efter en ekstern server, og serveren iværksætter TCP-forbindelsen. Denne tilstand anbefales når den Plesk-administrerede server ikke er beskyttet af en firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Passiv tilstand',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Den passive tilstand kan bruges når den Plesk-administrerede server er bag en firewall og ikke kan acceptere indkommende TCP-forbindelser.',
    'web.site-copy.existingFiles' => 'Hvad skal der ske med eksisterende filer',
    'web.site-copy.existingFilesKeep' => 'Bevar eksisterende filer på destinations-webstedet',
    'web.site-copy.existingFilesKeepDescription' => 'Overskriv eksisterende filer med samme filnavne på destinations-webstedet.',
    'web.site-copy.existingFilesDelete' => 'Slet alle eksisterende filer',
    'web.site-copy.existingFilesDeleteDescription' => 'Slet alle filer på destinations-webstedet inden kopiering.',
    'web.site-copy.emptyLogin' => 'Angiv et FTP-konto brugernavn.',
    'web.site-copy.emptyHost' => 'Angiv et server-hostnavn.',
    'web.site-copy.emptyPort' => 'Angiv en server-host port.',
    'web.site-copy.copyInProgress' => 'Kopierer webstedet %%sourceName%% til %%destinationName%%. Du bliver adviseret om installationsforløbet via e-mail (%%email%%).',
    'web.site-copy.unableToCopy' => 'Kopiering af webstedets filer mislykkedes',
    'web.site-copy.siteCopied' => 'Webstedets filer blev kopieret.',
    'web.site-copy.emailSubjSuccess' => 'Webstedet "%%source%%\'s" filer blev kopieret.',
    'web.site-copy.emailSubjFailure' => 'Kopiering af webstedet "%%source%%\'s" filer mislykkedes',
    'web.site-copy.emailBodySuccess' => 'Webstedet "%%source%%\'s" filer blev kopieret til "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Kopiering af webstedet "%%source%%\'s" filer til "%%destination%%" mislykkedes: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Indstillinger for viderestilling',
    'web._shared.forwardDestination' => 'Destinationsadresse',
    'web._shared.forwardDestinationHint' => 'URL til mål-webstedet.',
    'web._shared.forwardingTypeOptions' => 'Videresendelsestype',
    'web._shared.forwardingFrame' => 'Frame-videresendelse',
    'web._shared.forwardingFrameHint' => 'Omdirigér webstedsbesøgende til et andet websted, men vis dem ikke destinationsadressen, så de er uvidende om omdirigeringen.',
    'web._shared.forwardingHttpCode301' => 'Flyttet permanent (kode 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Omdirigér webstedsbesøgende til et andet websted og vis dem destinationsadressen. En sådan omdirigering vil bevare webstedets søgemaskine-placering.',
    'web._shared.forwardingHttpCode302' => 'Flyttet midlertidigt (kode 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Omdirigér webstedsbesøgende til et midlertidig websted, når du ikke ønsker at søgemaskiner skal indeksere dette midlertidige websted.',
    'web._shared.documentRoot' => 'Dokumentrod',
    'web._shared.documentRootHint' => 'Stien til webstedets startmappe.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Det er umuligt at ændre dokumentroden, da der er installeret webprogrammer på dette websted.',
    'web._shared.ipAddress' => 'IP-adresse',
    'web._shared.shared' => 'delt',
    'web._shared.exclusive' => 'dedikeret',
    'web._shared.ipAddressHint' => "IP-adressen hvorpå webstedet hostes er en netværksadresse til webstedets virtuelle host.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (andet opbevaringsområde)',
    'web._shared.certificate' => 'Certifikat',
    'web._shared.sameCertificatesHint' => 'Det valgte certifikat vil også blive anvendt til alle andre websteder der hostes på den samme dedikerede IP-adresse.',
    'web._shared.differentCertificatesHint' => 'Dette abonnement er tilknyttet to dedikerede IP-adresser med to forskellige certifikater. Det valgte certifikat vil erstatte de certifikater, der er installeret på websteder, der hostes på disse to IP-adresser.',
    'web._shared.differentIpTypesCertificateHint' => 'Dette abonnement er knyttet til én delt og én dedikeret IP-adresse. Det valgte certifikat vil også blive anvendt til alle andre websteder der hostes på den dedikerede IP-adresse.',
    'web._shared.certificateNotSelected' => 'Ikke valgt',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Der er ingen SSL/TLS-certifikater i dit opbevaringsområde. Du kan tilføje et certifikat ved at gå til %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'denne side',
    'web._shared.seoRedirectDirection' => 'Foretrukket domæne',
    'web._shared.seoRedirectDirectionHint' => 'Vælg den URL (enten med eller uden præfikset www.), som besøgende på webstedet vil blive omdirigeret til via en SEO-sikker HTTP 301-omdirigering.',
    'web._shared.seoRedirectDirectionNone' => 'Ingen',
    'web._shared.limitMbUnits' => 'MB',

    'web-user.settings.allowScripts' => 'Tillad webbrugere at anvende scripts',

    'web-user.name' => 'Brugernavn til tilslutning til serveren over FTP',
    'web-user.longName' => 'Dette brugernavn er for langt (maksimalt %max% tegn er tilladt).',
    'web-user.password' => 'Adgangskode',
    'web-user.passwordConfirmation' => 'Bekræft adgangskode',
    'web-user.hardDiskQuota' => 'Harddiskkvote',
    'web-user.hardDiskQuotaUnlimited' => 'Ubegrænset',
    'web-user.hardDiskQuotaIsNotSupported' => '(harddiskkvote understøttes ikke på grund af konfigurationen af server-filsystemet)',
    'web-user.megabytes' => 'MB',

    'web-user.__asp_win_support' => 'Microsoft ASP-understøttelse',
    'web-user.__asp_dot_net_support' => 'Microsoft ASP.NET-understøttelse',
    'web-user.__ssi_support' => 'SSI-understøttelse',
    'web-user.__php_support' => 'PHP-understøttelse',
    'web-user.__cgi_support' => 'CGI-understøttelse',
    'web-user.__perl_unix_support' => 'Perl-understøttelse',
    'web-user.__perl_win_support' => 'Perl-understøttelse',
    'web-user.__python_unix_support' => 'Python-understøttelse',
    'web-user.__python_win_support' => 'Python-understøttelse',
    'web-user.__fastcgi_unix_support' => 'FastCGI-understøttelse',
    'web-user.__webstat_support' => 'Webstatistik',
    'web-user.__apache_errdocs' => 'Brugerdefinerede fejldokumenter',
    'web-user.__hosting_write_modify' => 'Yderligere skrive/ændringstilladelser',
    'web-user.__hosting_webdeploy' => 'Webdeployeringspublicering',


    'requiredFields' => 'Obligatoriske felter',
];