<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Installation de %%name%% sous %%path%%...',
    'aps-install.queueNoPath' => 'Installation de %%name%%...',
    'aps-install.done' => '%%name%% a bien été installé sous %%path%%. Vous pouvez voir vos identifiants d\'accès pour la connexion à l\'application ci-dessous. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% a bien été installé. Vous pouvez voir vos identifiants d\'accès pour la connexion à l\'application ci-dessous. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% a bien été installé sous %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% a bien été installé. %%additionalMessage%%',
    'aps-install.error' => 'L\'installation de %%name%% sous %%path%% a échoué. %%errorMessage%%',
    'aps-install.errorNoPath' => 'L\'installation de %%name%% a échoué. %%errorMessage%%',

    'aps-update.queueDownload' => 'Téléchargement de %%packageName%%...',
    'aps-update.errorDownload' => 'Échec du téléchargement de %%packageName%% :',
    'aps-update.queueInstall' => 'Mise à jour d\'une installation de %%name%% pour %%domainName%% en cours...',
    'aps-update.doneInstall' => 'L\'installation de %%name%% pour %%domainName%% a bien été mise à jour.',
    'aps-update.errorInstall' => 'Échec de la mise à jour de l\'installation de %%name%% pour %%domainName%% :',
    'aps-update.queueInstallMulti' => 'Mise à jour de %%instances%% installations de %%name%% en cours...',
    'aps-update.doneInstallMulti' => '%%successes%% installations de  %%name%% ont bien été mises à jour.',
    'aps-update.errorInstallMulti' => 'Échec de la mise à jour de %%failures%% installations de %%name%% :',
    'aps-update.incorrectUpdateInformation' => 'Les informations relatives à la mise à jour sont incorrectes.',

    'common.hideCompletedTasks' => 'Masquer les tâches terminées',
    'common.progressBarHide' => 'Masquer',
    'common.progressBarShow' => 'Afficher',
    'common.close' => 'Fermer',
    'common.refresh' => 'Actualiser la page',
    'common.taskInProgress' => '%%count%% tâches en cours...',
    'common.percentCompleted' => '%%percent%%% terminés',
    'common.allTasksCompleted' => 'Les %%num%% tâches ont bien été terminées.',
    'common.minimize' => 'Réduire',
    'common.statusDone' => 'Terminé',
    'common.statusError' => 'Échec',
    'common.statusNotStarted' => 'En file d\'attente',
    'common.statusCanceled' => 'Annulé',
    'common.progressDialogLink' => 'progression détaillée',

    'database-check.queue' => 'Vérification des tables de bases de données %%database%%...',
    'database-check.done' => 'La base de données %%database%% n\'a aucune erreur.',
    'database-check.error' => 'Impossible de vérifier les erreurs de la base de données %%database%%.',
    'database-check.done-with-errors' => "La base de données %%database%% a %%number%% problèmes. \n %%link%%",
    'database-check.info-link-title' => 'Voir les détails et résoudre les problèmes',

    'database-download.queue' => 'Préparation d\'un dump de %%database%% pour l\'export...',
    'database-download.done' => 'Le dump de %%database%% est prêt. Vous pouvez le %%downloadLink%%.',
    'database-download.downloadLink' => 'télécharger',
    'database-download.error' => 'Impossible d\'exporter le dump de %%database%% :',

    'database-repair.queue' => 'Réparation des tables de bases de données %%database%%...',
    'database-repair.done' => 'La base de données %%database%% n\'a aucune erreur.',
    'database-repair.error' => 'Impossible de réparer la base de données %%database%%.',
    'database-repair.done-with-errors' => "La base de données %%database%% a %%number%% problèmes. \n %%link%%",
    'database-repair.info-link-title' => 'Voir les détails',

    'database-upload.queue' => 'Importation d\'un dump de %%database%%...',
    'database-upload.done' => 'Le dump de %%database%% a été importé.',
    'database-upload.error' => 'Impossible d\'importer le dump de %%database%% :',
    'database-upload.done-with-errors' => "Le dump de %%database%% a été importé avec des erreurs.",
    'database-upload.orphanedUsersSuccess' => 'La base de données %%database%% a bien été importée. Toutefois, certains utilisateurs sont devenus orphelins (ils n\'ont pas de logins associés sur le serveur de base de données). Pour accéder à vos bases de données, affectez des noms d\'utilisateurs à ces utilisateurs. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Toutefois, certains utilisateurs sont devenus orphelins (ils n\'ont pas de noms d\'utilisateurs associés sur le serveur de base de données) : %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Afficher les utilisateurs',

    'domain-app-scan.queue' => 'Analyse des applications en cours...',
    'domain-app-scan.done' => 'Analyse des applications terminée.',
    'domain-app-scan.error' => 'Analyse des applications terminée avec des erreurs.',

    'domain-move.queue' => 'Déplacement de %%domainName%% vers %%webspaceName%%',
    'domain-move.done' => '%%domainName%% a été déplacé vers %%webspaceName%%',
    'domain-move.error' => '%%domainName%% n\'a pas été déplacé vers %%webspaceName%%',

    'domain-split.queue' => 'Déplacement de %%domainName%% vers un nouvel abonnement',
    'domain-split.done' => '%%domainName%% a été déplacé vers un nouvel abonnement',
    'domain-split.error' => '%%domainName%% n\'a pas été déplacé vers un nouvel abonnement',

    'file-manager-import-file.done' => 'The %%fileName%% file has been imported to <a href="%%listUrl%%">the %%fileDir%% folder</a>.',
    'file-manager-import-file.error' => 'Impossible d\'importer le fichier %%fileName%% : %%errorMessage%%.<br><a href="%%url%%">Télécharger sur mon ordinateur</a>.',
    'file-manager-import-file.queue' => 'Importation du fichier %%fileName%% depuis %%host%%.',
    'file-manager-import-file.progress' => 'Importation du fichier %%fileName%% depuis %%host%% (%%value%% Mo).',
    'file-manager-import-file.errors.auth' => 'Une erreur d\'authentification s\'est produite. Vérifiez si votre identifiant et votre mot de passe sont exacts.',
    'file-manager-import-file.errors.resolve' => 'Impossible de résoudre le nom d\'hôte %%host%%. Vérifiez si vous avez fourni l\'URL correcte.',
    'file-manager-import-file.errors.connect' => 'Impossible de se connecter au serveur %%host%%. Vérifiez si vous avez fourni l\'URL correcte.',
    'file-manager-import-file.errors.notFound' => 'Le fichier distant n\'a pas été trouvé ou n\'est pas accessible. Vérifiez si vous avez fourni l\'URL correcte et si le fichier est accessible.',
    'file-manager-import-file.errors.maxSize' => 'La limite de l\'espace disque ou l\'espace libre %%diskSpaceLimit%% a été dépassé.',
    'file-manager-import-file.errors.lowSpeedTime' => 'Impossible d\'importer le fichier. La vitesse de transfert était trop lente : moins de %%lowSpeedLimit%% octets ont été transférés lors des dernières %%lowSpeedTime%% secondes. Le site web sur lequel ce fichier est hébergé semble surchargé pour le moment. Essayez à nouveau ultérieurement.',
    'file-manager-import-file.errors.certificate' => 'Impossible d\'importer le fichier. Le certificat SSL/TLS sur le serveur %%host%% n\'est pas fiable. Vérifiez si le site Web sur lequel le fichier est hébergé est sécurisé par un certificat de confiance.',
    'file-manager-import-file.errors.redirects' => 'Le nombre maximum de redirections (%%maxRedirects%%) a été dépassé. Vérifiez si le serveur %%host%% fonctionne correctement.',

    'force-log-rotation.queue' => 'L\'application de la rotation globale des logs s\'est terminée avec des erreurs.',
    'force-log-rotation.done' => 'Les paramètres de la rotation globale des logs ont été changés.',
    'force-log-rotation.error' => 'L\'application de la rotation globale des logs s\'est terminée avec des erreurs.',
    'force-log-rotation.systemLogRotationError' => 'Logs système : %%error%%',
    'force-log-rotation.planLogRotationError' => 'Packs de services %%name%% : %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Domaine %%name%% : %%error%%',

    'initial-setup.queue' => 'Initialisation de Plesk...',
    'initial-setup.done' => 'Plesk a été initialisé.',
    'initial-setup.doneWithErrors' => 'Une erreur s\'est produite pendant l\'initialisation de Plesk.',
    'initial-setup.error' => 'L\'initialisation de Plesk a échoué.',
    'initial-setup.step.setupPanel' => 'Configuration de Plesk Panel',
    'initial-setup.step.requestLicense' => 'Demander la licence',
    'initial-setup.step.configureServer' => 'Configuration du serveur Web',
    'initial-setup.step.secureServer' => 'Sécurisation du serveur',

    'ip-update.queue' => 'Mise à jour de l\'adresse IP en cours',
    'ip-update.done' => 'L\'adresse IP est mise à jour.',
    'ip-update.error' => 'La mise à jour des adresses IP a terminé avec des erreurs.',
    'ip-update.updating' => 'Mise à jour de l\'adresse IP en cours',
    'ip-update.updatingWebServer' => 'Mise à jour de l\'adresse IP : mise à jour du serveur Web',
    'ip-update.updatingFtpServer' => 'Mise à jour de l\'adresse IP : mise à jour du serveur FTP',
    'ip-update.updatingDnsZones' => 'Mise à jour de l\'adresse IP : mise à jour des zones DNS',
    'ip-update.restartingDnsService' => 'Mise à jour de l\'adresse IP : redémarrage du serveur DNS',

    'logrotate_anonymize_ips.queue' => 'Rendre les adresses IP anonymes dans les fichiers de logs',
    'logrotate_anonymize_ips.queueRevert' => 'Désanonymiser les adresses IP dans les logs',
    'logrotate_anonymize_ips.done' => 'Les adresses IP ont été rendues anonymes.',
    'logrotate_anonymize_ips.doneRevert' => 'Les adresses IP ne sont plus anonymes.',
    'logrotate_anonymize_ips.error' => 'Le processus pour rendre les adresses IP anonymes s\'est terminé avec des erreurs.',
    'logrotate_anonymize_ips.errorRevert' => 'Le processus de désanonymisation des adresses IP s\'est terminé avec des erreurs.',

    'panel-components-install.queue' => 'Installation des composants sélectionnés',
    'panel-components-install.done' => 'Les composants sélectionnés ont été installés avec succès.',
    'panel-components-install.error' => 'Impossible d\'installer les composants. La notification ainsi que la description de l\'erreur vous ont été envoyés à votre adresse mail.',

    'panel-update.queue' => 'Plesk installe les mises à jour. Cela risque de prendre quelques minutes. %%warning%%',
    'panel-update.warning' => 'Ne procédez à aucune opération de gestion dans Plesk jusqu\'à la fin de la mise à jour.',
    'panel-update.done' => 'La mise à jour de Plesk est terminée. Pour en savoir plus : %%changelog%%.',
    'panel-update.changelog' => 'Log de modifications de Plesk',
    'panel-update.error' => 'Impossible de mettre Plesk à jour. %%errorDetails%%',
    'panel-update.support' => 'Vous pouvez envoyer le log de mise à jour à l\'assistance Plesk pour essayer de résoudre le problème. %%failedLog%% Copiez les logs sur votre ordinateur avant de fermer ce message.',
    'panel-update.failedLog' => 'Consultez le log de mise à jour à partir du %%date%%.',

    'pum-update-packages.queue' => 'Mise à jour de %%count%% pack(s)...',
    'pum-update-packages.done' => '%%count%% packs ont bien été mis à jour.',
    'pum-update-packages.error' => 'Échec de la mise à jour.',

    'scheduler-run-task.queue' => 'Exécution de la tâche "%%task%%"...',
    'scheduler-run-task.done' => 'La tâche "%%task%%" s\'est bien exécutée en %%seconds%% secondes.',
    'scheduler-run-task.error' => 'La tâche "%%task%%" a terminé avec une erreur en %%seconds%% secondes.',
    'scheduler-run-task.popupSeeDetails' => 'Voir les détails',
    'scheduler-run-task.popupTitle' => 'Exécuter la tâche planifiée',
    'scheduler-run-task.popupDone' => 'La tâche "%%task%%" s\'est bien exécutée en %%seconds%% secondes, résultat :',
    'scheduler-run-task.popupError' => 'La tâche "%%task%%" a terminé avec une erreur en %%seconds%% secondes, résultat :',
    'scheduler-run-task.popupClose' => 'Fermer',

    'sdk.queue' => 'La tâche "%%name%%" est en cours d\'exécution.',
    'sdk.error' => 'La tâche "%%name%%" a échoué.',
    'sdk.done' => 'La tâche "%%name%%" est finie.',
    'sdk.canceled' => 'La tâche "%%name%%" a été annulée.',

    'sync-php-settings.queue' => 'Application des paramètres PHP globaux aux domaines...',
    'sync-php-settings.done' => 'Les paramètres PHP globaux ont bien été appliqués aux domaines.',
    'sync-php-settings.error' => 'Une erreur s\'est produite lors de l\'application de paramètres PHP globaux aux domaines.',

    'domain-create.queue' => 'Création du domaine %%domainName%%',
    'domain-create.done' => 'Domaine %%domainName%% créé',
    'domain-create.error' => 'Échec de la création du domaine %%domainName%%',
    'domain-create.warning' => 'Le domaine %%domainName%% a été créé mais rencontre quelques problèmes :<br> %%problems%%',
    'domain-create.refreshUrl' => 'Afficher',
    'domain-create.steps.createCustomer' => 'Création du client',
    'domain-create.steps.createSubscription' => 'Création d\'un abonnement',
    'domain-create.steps.createDomain' => 'Ajout d\'un domaine',
    'domain-create.steps.configureDns' => 'Configuration de la zone DNS',
    'domain-create.steps.createHosting' => 'Création d\'un hébergement physique',
    'domain-create.steps.configurePhp' => 'Configuration PHP',
    'domain-create.steps.configureMail' => 'Configuring mail',

    'domain-resolve-checking.warning' => 'Domain %%domainName%% resolve problems detected: <br> %%errors%%',

    'customer-create.queue' => 'Création du client %%customerName%% en cours',
    'customer-create.done' => 'Client %%customerName%% créé',
    'customer-create.error' => 'Échec de la création du client %%customerName%%',
    'customer-create.warning' => 'Le client %%customerName%% a été créé mais rencontre quelques problèmes :<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Vous pouvez essayer de le synchroniser manuellement.',

    'subscription-create.queue' => 'Création de l\'abonnement %%subscriptionName%% en cours',
    'subscription-create.done' => 'Abonnement %%subscriptionName%% créé',
    'subscription-create.error' => 'Échec de la création de l\'abonnement %%subscriptionName%%',
    'subscription-create.warning' => 'L\'abonnement %%subscriptionName%% été créé mais rencontre quelques problèmes :<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Vous pouvez essayer de le synchroniser manuellement.',
];