<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => '子网或 IP 地址',
    'access-network.subnetOrIpAddressHint' => '例如，2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => '时事通讯',
    'admin.announcement-settings.getConsentLoading' => '正在检索有关时事通讯的信息...',
    'admin.announcement-settings.getConsentWarning' => '无法检索您的订阅状态。',
    'admin.announcement-settings.sendAnnounceConsent' => '我想要接收来自 Plesk 的时事通讯。这些讯息可能包括安全相关的、技术和常规产品方面的信息。我同意并授权 Plesk 根据现行适用的数据保护法收集、处理和使用我的个人数据（邮箱），包括跨境处理，直接或通过第三方服务给我发送时事通讯。取消勾选该复选框则表示撤销同意并令 Plesk 停止向我发送邮件以及从其系统中永久移除我的个人数据。',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => '是，我同意接收个性化的 Plesk 通讯。Plesk International GmbH 和其附属公司可以根据 %%privacyPolicy%% 以提供通讯为目的而存储和处理我提供的数据。为了定制其消息和向我提供的帮助提示，Plesk 还可以使用用于分析的其它信息，例如使用和行为数据。我可以随时取消订阅邮件列表。',
    'admin.announcement-settings.privacyPolicy' => 'Plesk 隐私策略',
    'admin.announcement-settings.noConsent' => '取消订阅 Plesk 通讯。',
    'admin.announcement-settings.reportConsentError' => '无法保存您从 Plesk 接收信息的设置：%%error%%。',
    'admin.announcement-settings.profileUpdateError' => '很抱歉，我们目前无法更新您的个人资料。请稍后再试。',
    'admin.announcement-settings.invalidConsentType' => "未知同意类型：'%%type%%'",
    'admin.announcement-settings.retry' => '重新尝试',
    'admin.announcement-settings.consentGivenInfo' => '我们希望您一直喜欢我们的 Plesk 通用通讯。我们现在可以为您提供更为完善的方案，能够根据您的需要来提供有用信息和帮助提示，更具个性化。欲接收个性化的 Plesk 通讯，请选择下面的第一条声明，然后点击“确定”。',
    'admin.announcement-settings.consentNotGivenInfo' => '似乎您尚未订阅我们的通用通讯。我们可以为您提供更为完善的方案，即个性化的通讯，能够根据您的需要来提供有用信息和帮助提示。',

    'admin.personal-info.title' => '编辑管理员信息',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk 设置',
    'admin.personal-info.settingsSectionLegend' => '设置',

    'admin-alias.login' => '用户名',
    'admin-alias.password' => '密码',
    'admin-alias.passwordConfirmation' => '确认密码',
    'admin-alias.email' => '邮件地址',
    'admin-alias.contact' => '联系名称',
    'admin-alias.comments' => '备注',
    'admin-alias.emptyLogin' => '请提供一个用户名。',
    'admin-alias.loginTooLong' => '该用户名的长度超过了 20 个字符。',
    'admin-alias.emptyEmail' => '请提供一个邮件地址。',
    'admin-alias.emptyContactName' => '请提供一个联系名称。',
    'admin-alias.contactNameTooLong' => '此联系名称的长度超过了 255 个字符。',
    'admin-alias.emptyPassword' => '请提供一个密码。',
    'admin-alias.commentsTooLong' => '该备注的长度超过了 255 个字符。',
    'admin-alias.emailActivation' => '通过电子邮件激活账户',
    'admin-alias.simplePanel' => '启用限制模式',
    'admin-alias.simplePanelHint' => '选择此选项来限制其它管理员可以在Plesk中采取操作的次数。若要更改可用的操作，请点击%%link%%。',
    'admin-alias.simplePanelLink' => '工具 & 设置> 限制模式设置',
    'admin-alias.lockPowerUser' => '为其他管理员提供高级用户试图',
    'admin-alias.lockPowerUserHint' => '限制查看其它Plesk管理员的能力（无法访问客户、经销商和服务计划）。',

    'admin-info.plesk-settings.multiplyLogin' => '允许在该帐户下进行多个会话',
    'admin-info.plesk-settings.adminLanguage' => '管理员的界面语言',
    'admin-info.plesk-settings.password' => '密码',
    'admin-info.plesk-settings.passwordConfirmation' => '确认密码',

    'admin-panel.form.contact-info.contactName' => '联系人姓名',
    'admin-panel.form.contact-info.emptyContactName' => '请提供联系人姓名。',
    'admin-panel.form.contact-info.contactNameTooLong' => '联系人姓名太长 (最大允许%max%)。',
    'admin-panel.form.contact-info.email' => '电子邮件地址',
    'admin-panel.form.contact-info.emptyEmail' => '请提供电子邮件地址。',
    'admin-panel.form.contact-info.companyName' => '公司名称',
    'admin-panel.form.contact-info.longCompanyName' => '公司名太长(最长%max%。',
    'admin-panel.form.contact-info.phone' => '电话号码',
    'admin-panel.form.contact-info.longPhone' => '电话号码太长(最长%max%)。',
    'admin-panel.form.contact-info.fax' => '传真号码',
    'admin-panel.form.contact-info.imNumber' => '即时通讯',
    'admin-panel.form.contact-info.longFax' => '传真号太长(最长%max%',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => '指定的电话号码无效。',
    'admin-panel.form.contact-info.faxRegexNotMatch' => '该传真号不正确。',
    'admin-panel.form.contact-info.address' => '地址',
    'admin-panel.form.contact-info.longAddress' => '地址太长(最长%max%)。',
    'admin-panel.form.contact-info.city' => '城市',
    'admin-panel.form.contact-info.longCity' => '城市名太长。',
    'admin-panel.form.contact-info.shortCity' => '此城市名称太短。',
    'admin-panel.form.contact-info.state' => '省/市/自治区',
    'admin-panel.form.contact-info.postalCode' => '邮政编码',
    'admin-panel.form.contact-info.country' => '国家/地区',
    'admin-panel.form.contact-info.additionalInfo' => '其他信息',
    'admin-panel.form.contact-info.additionalInfoHint' => '仅纯文本：将忽略所有 HTML 标记。',
    'admin-panel.form.contact-info.duplicateEmail' => '系统中已存在带有相同电子邮件地址的用户。',

    'admin-panel.form.domain-info-section.domainInfoSection' => '订阅',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => '网站属性',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => '网站属性',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => '网站属性',
    'admin-panel.form.domain-info-section.createSubscription' => '为客户创建订阅',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => '如果您此刻不想为客户创建主机服务订阅或设置网站请清空该复选框。没有订阅，客户将无法登录到客户面板。',
    'admin-panel.form.domain-info-section.domainName' => '域名',
    'admin-panel.form.domain-info-section.emptyDomainName' => '您必须提供一个域名。',
    'admin-panel.form.domain-info-section.shared' => '共享',
    'admin-panel.form.domain-info-section.exclusive' => '独立',
    'admin-panel.form.domain-info-section.userName' => '用户名',
    'admin-panel.form.domain-info-section.userNameHint' => '用于管理在订阅内创建的网站文件和文件夹的系统用户帐户。',
    'admin-panel.form.domain-info-section.emptyLogin' => '您必须提供一个用户名。',
    'admin-panel.form.domain-info-section.password' => '密码',
    'admin-panel.form.domain-info-section.emptyPassword' => '您必须提供一个密码。',
    'admin-panel.form.domain-info-section.passwordConfirmation' => '确认密码',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "托管网站的 IP 地址是网站的虚拟主机的网络地址。",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4 地址',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "托管网站的 IP 地址是网站的虚拟主机的网络地址。",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6 地址',
    'admin-panel.form.domain-info-section.noIpAddressHint' => '无',
    'admin-panel.form.domain-info-section.subscriptionSettings' => '其它的订阅设置',
    'admin-panel.form.domain-info-section.credentials' => '系统用户验证凭据',
    'admin-panel.form.domain-info-section.credentialsHint' => '通过 FTP 和 SSH 访问托管的文件',
    'admin-panel.form.domain-info-section.credentialsHintWin' => '以通过 FTP 和 RDP 访问托管的文件',

    'admin-panel.form.login-info.userName' => '用户名',
    'admin-panel.form.login-info.emptyUserName' => '请提供用户名。',
    'admin-panel.form.login-info.password' => '密码',
    'admin-panel.form.login-info.emptyPassword' => '请提供密码。',
    'admin-panel.form.login-info.passwordConfirmation' => '重复密码',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => '更改密码也将更改内部电子邮件地址密码',
    'admin-panel.form.login-info.emailActivation' => '通过电子邮件激活账户',
    'admin-panel.form.login-info.emailActivationHint' => '除非用户通过电子邮件中所发送的链接激活账户，或管理员手动激活该账户，创建的账号便会处于非活动状态。',

    'admin-panel.form.subscription-info-section.subscription' => '订阅',
    'admin-panel.form.subscription-info-section.servicePlan' => '服务方案',
    'admin-panel.form.subscription-info-section.oldServicePlan' => '当前服务方案',
    'admin-panel.form.subscription-info-section.newServicePlan' => '新服务方案',
    'admin-panel.form.subscription-info-section.adminPlan' => '简单方案',
    'admin-panel.form.subscription-info-section.none' => '无',
    'admin-panel.form.subscription-info-section.addonPlans' => '附加方案',
    'admin-panel.form.subscription-info-section.customizeSubscription' => '方案关联性更改后，继续自定义订阅参数。注意，执行此操作会锁定订阅而不能同步。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => '创建后继续自定义订阅参数。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "创建客户后继续自定义订阅参数。",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => '创建后，继续自定义订阅参数。注意，执行此操作会锁定订阅而不能同步。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => '注意执行此操作将锁定订阅不能同步。',
    'admin-panel.form.subscription-info-section.buttonOk' => '添加订阅',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => '无法将订阅与服务方案同步。订阅的下列设置与服务方案冲突：%%problems%%。',

    'app.configure.otherSettings' => '其他',
    'app.configure.passwordConfirmation' => '确认密码',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => '强制更新所有安装的应用程序',
    'app.update-settings.forceUpdatesHint' => '允许客户的应用程序在更新发行时自动接收更新。客户将无法关闭应用程序的自动更新。警告：谨慎使用此选项，因为更新对应用程序功能影响很大。例如，应用程序扩展可能无法用于该应用程序的其它版本。',
    'app.update-settings.suggestUpdates' => '默认打开选项“自动更新该应用程序”',
    'app.update-settings.suggestUpdatesHint' => '对于新安装的应用程序，将会打开应用程序设置中的“自动更新该应用程序”选项。',

    'backup.server-settings.rotation' => '可以进行存储的完整备份文件的最大数量（包括计划和手动备份）',
    'backup.server-settings.rotationDescription' => '用户可以在服务器存储中存储这么多完整的备份。如果存储中完整备份的数量已超出限制，仅能保存最近的备份。增量备份不受影响。',
    'backup.server-settings.maxProcesses' => '同时运行计划备份进程的最大数量',
    'backup.server-settings.niceScheduled' => '运行低优先级的计划备份进程',
    'backup.server-settings.niceScheduledPriority' => '优先级',
    'backup.server-settings.niceScheduledPriorityDescription' => '输入 1 到 19 之间的值，数值越高优先级越低。',
    'backup.server-settings.niceScheduledIoPriority' => 'IO 优先级',
    'backup.server-settings.niceScheduledIoPriorityDescription' => '输入 0 到 7 之间的值，数值越高优先级越低。',
    'backup.server-settings.niceAlways' => '运行所有低优先级的备份进程',
    'backup.server-settings.niceAlwaysPriority' => '优先级',
    'backup.server-settings.niceAlwaysPriorityDescription' => '输入 1 到 19 之间的值，数值越高优先级越低。',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO 优先级',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => '输入 0 到 7 之间的值，数值越高优先级越低。',
    'backup.server-settings.noCompression' => '不要压缩备份文件',
    'backup.server-settings.freeSpaceRequired' => '只有您的服务器有指定容量的可用磁盘空间才开始备份（以 MB 为单位）',
    'backup.server-settings.checkBackupDiskSpace' => '仅在您的服务器有足够的可用磁盘空间容量时启动备份',
    'backup.server-settings.mssqlNativeBackupEnabled' => '请使用本地 MS SQL 备份功能（对于远程数据库，请确保您已在 工具与设置> 数据库服务器 中配置了远程 MS SQL 服务器的备份设置）',
    'backup.server-settings.localFtpRestriction' => '允许在本地服务器上设置 FTP 备份存储',
    'backup.server-settings.backupSecuritySettings' => '备份安全设置',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => '如果上传到远程存储失败请把备份保存在服务器存储中',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => '将要进行远程存储的手动和计划备份如果上传到远程存储失败则将被保存在本地服务器存储中。用户必须有在服务器存储中存储备份的权限。',

    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupLabel' => '管理员的客户',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupDescription' => '所有属于 Plesk 之前版本管理员的帐户被转换为管理员拥有的客户帐户：(1) 客户原有的资源仍然保留（可以在客户订阅列表顶部的\'我的资源\'标签里找到），转换成功后这些资源将被移除；(2) 所有的域名都被转换为订阅（每个域名对应一个新订阅）；(3) 域名管理者转换为客户的用户，只能访问包含自己域名的订阅。',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupSettingsLabel' => '原客户状态',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupNumberLabel' => '客户号',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupMethodLabel' => '转换方案',
    'business-model-upgrade.bunch.t1s1-settingsDescription' => '一个域名；禁止调整限额。',
    'business-model-upgrade.bunch.t1s1-solutionDescription' => '新的订阅资源等同于原客户最小量或域名上限。',
    'business-model-upgrade.bunch.t1s1-apply' => '转换这些客户',
    'business-model-upgrade.bunch.t1s2-settingsDescription' => '一个域名；允许调整限额。',
    'business-model-upgrade.bunch.t1s2-solutionDescription' => '新订阅的资源等同于原客户资源上限。',
    'business-model-upgrade.bunch.t1s2-apply' => '转换这些客户',
    'business-model-upgrade.bunch.t1s3-settingsDescription' => '多个域名；禁止域名创建和限额调整。',
    'business-model-upgrade.bunch.t1s3-solutionDescription' => '新订阅的资源从原域名继承，等同于其上限。',
    'business-model-upgrade.bunch.t1s3-apply' => '转换这些客户',
    'business-model-upgrade.bunch.t1s6-settingsDescription' => '多个域名；允许域名创建和限额调整。',
    'business-model-upgrade.bunch.t1s6-solutionDescription' => '转换为：',
    'business-model-upgrade.bunch.t1s6r-solutionDescription' => '代理商，原客户升级为代理商。原客户的资源上限演变成现在的代理商订阅资源。如果之前域名的域名管理员帐户已启用，管理员帐户将升级为客户帐户，并与相应的订阅关联。否则，订阅将直接属于代理商。',
    'business-model-upgrade.bunch.t1s6c-solutionDescription' => '客户。原客户仍然称为客户。原客户资源平均分配到各个订阅当中。',
    'business-model-upgrade.bunch.t1s6r-solutionName' => '代理商',
    'business-model-upgrade.bunch.t1s6c-solutionName' => '客户',
    'business-model-upgrade.bunch.t1s6-apply' => '转换这些客户为',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupLabel' => '代理商的客户',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupDescription' => '在 Plesk 9 版本里所有属于代理商的客户帐户都转换为各自代理商所有的客户帐户：(1) 每个原客户的旧有资源已被保留（可在客户订阅列表顶部的 \'我的资源\' 标签下找到），转换一旦完成就会把原客户移除；(2) 其所有的域名都会被转换为订阅（每个订阅转换为一个新订阅）； (3) 域名管理员被转换为客户用户，他们只能访问包含其域名的订阅。',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupSettingsLabel' => '原客户状态。',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupNumberLabel' => '客户号',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupMethodLabel' => '转换方案',
    'business-model-upgrade.bunch.t2s1-settingsDescription' => '一个域名；禁止限额调整。',
    'business-model-upgrade.bunch.t2s1-solutionDescription' => '新的订阅资源等同于原客户最小量或域名上限。',
    'business-model-upgrade.bunch.t2s1-apply' => '转换这些客户。',
    'business-model-upgrade.bunch.t2s2-settingsDescription' => '一个域名；禁止限额调整。',
    'business-model-upgrade.bunch.t2s2-solutionDescription' => '新的订阅资源等同于原客户的资源上限。',
    'business-model-upgrade.bunch.t2s2-apply' => '转换这些客户。',
    'business-model-upgrade.bunch.t2s3-settingsDescription' => '多个域名；禁止域名创建和限额调整。',
    'business-model-upgrade.bunch.t2s3-solutionDescription' => '新的订阅资源继承于原客户的域名资源，且等同于其上限。',
    'business-model-upgrade.bunch.t2s3-apply' => '转换这些客户',
    'business-model-upgrade.bunch.t2s6-settingsDescription' => '多个域名；允许域名创建和限额调整。',
    'business-model-upgrade.bunch.t2s6-solutionDescription' => '原客户的资源平均分配给他们的订阅。',
    'business-model-upgrade.bunch.t2s6-apply' => '转换这些客户',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupLabel' => '管理员的订阅',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupDescription' => 'Plesk 旧版本中属于 admin 的所有域名都被转换为 admin 的订阅。域名管理员被转换为客户面板用户且只能访问包含其域名的订阅。使用推荐的操作转换订阅，或在 \'选择性订阅转换\' 标签为每个订阅选择一个自定义转换方案。',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupSettingsLabel' => '先前域名状态',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupNumberLabel' => '订阅号',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupMethodLabel' => '转换方案',
    'business-model-upgrade.bunch.subscriptionAdministrator-settingsDescription' => '属于管理者的域名；域名管理员帐号已启用。',
    'business-model-upgrade.bunch.subscriptionAdministrator-solutionDescription' => '原域名管理者升级为客户并成为订户，也就是说订阅已分配给他们。',
    'business-model-upgrade.bunch.subscriptionAdministrator-apply' => '转换这些订阅',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupLabel' => '代理商的订阅',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupDescription' => 'Plesk 以前版本中属于代理商的所有域名转换代理商自己的订阅，保留所有权。域名管理员被转换为客户面板用户且只能访问包含其域名的订阅。使用推荐的操作转换订阅，或在 \'选择性订阅转换\' 标签为每个订阅选择一个自定义转换方案。',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupSettingsLabel' => '原域名状态',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupNumberLabel' => '服务号',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupMethodLabel' => '转换方案',
    'business-model-upgrade.bunch.subscriptionReseller-settingsDescription' => '属于代理商的域名；域名管理员帐号已启用。',
    'business-model-upgrade.bunch.subscriptionReseller-solutionDescription' => '原域名管理者升级为客户并成为订户，也就是说订阅已分配给他们。',
    'business-model-upgrade.bunch.subscriptionReseller-apply' => '转换这些订阅',
    'business-model-upgrade.bunch.thereWereSomeErrors' => '某些选定的客户和订阅未能转换。',

    'change-current-subscription.hint' => '您可以在此处更改订阅服务方案的关联性。注意，选择"无"作为新服务方案将从服务方案取消绑定订阅，并设置成"自定义"。',
    'change-current-subscription.subscriptionNotSynchronized' => '无法将订阅与服务方案同步。订阅的下列设置与服务方案冲突：%%problems%%。',

    'change-password.oldPassword' => '旧密码',
    'change-password.password' => '新密码',
    'change-password.passwordConfirmation' => '确认密码',
    'change-password.oldPasswordIsIncorrect' => '旧密码不正确。请重试。',
    'change-password.unableToFindAdditionalAdminAccount' => '无法找到其它管理员帐户。',
    'change-password.warningAboutAdminPasswordSyntax' => "该密码应介于 %%min%% - %%max%% 之间且不得包含用户名。密码中不得使用引号、空格以及国家字母字符。",
    'change-password.warningAboutWinAdminPasswordSyntax' => "密码中不得使用引号、空格、分号以及国家字母字符。该密码应介于 %%min%% 和 %%max%% 之间且不得包含用户名。",

    'change-reseller-oversell-policy.oversellPolicy' => '超额销售策略',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => '允许超额销售',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => '超额销售允许代理商超额出售通过方案分配给他们的资源。若允许超额销售，代理商则可支配实际使用的资源而不是初始分配的资源。',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => '不允许超额销售',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => '若不允许超额销售，不管实际使用的资源是多少，代理商都只能出售通过方案初始分配给他们的资源。',

    'change-reseller-subscription.hint' => '您可以在此处更改与代理商订阅关联的服务方案。注意，选择"无"作为新服务方案会将订阅从服务方案取消绑定，并设置为"自定义"。',
    'change-reseller-subscription.subscriptionNotSynchronized' => '无法将订阅与服务方案同步。订阅的下列设置与服务方案冲突：%%problems%%。',
    'change-reseller-subscription.servicePlan' => '新方案',
    'change-reseller-subscription.oldSubscription' => '当前方案',
    'change-reseller-subscription.none' => '无',
    'change-reseller-subscription.infoSubscriptionChanged' => '订阅相关服务方案已更新。',
    'change-reseller-subscription.customizeSubscription' => '与服务方案的关联更新后，继续自定义订阅参数。注意，执行此操作会锁定订阅而不能同步。',

    'change-subscription.hint' => '您可在此更改所选订阅与服务方案的相关性。',
    'change-subscription.selectPlanLegend' => '服务方案',
    'change-subscription.selectPlanDescription' => '若要切换到其它服务方案，请从列表中选择新方案。注意，若选择\'无\'则取消订阅和服务方案的绑定，使其成为\'自定义\'订阅。',
    'change-subscription.servicePlan' => '新服务方案',
    'change-subscription.selectAddonPlansLegend' => '附加方案',
    'change-subscription.selectAddonPlansDescription' => '添加或移除附加方案。',
    'change-subscription.noChange' => '无变更',
    'change-subscription.none' => '无',
    'change-subscription.add' => '添加',
    'change-subscription.del' => '移除',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => '子网或 IP 地址',
    'control-panel-access.network.subnetOrIpAddressHint' => '例如，2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => '使用管理员权限访问 Plesk',
    'control-panel-access.settings.policyAllow' => '允许，列表中的网络除外。',
    'control-panel-access.settings.policyDeny' => '拒绝不在列表中的网络。',

    'create-subscription.title' => '添加一个订阅',
    'create-subscription.titleOwn' => '创建自己的订阅',
    'create-subscription.poolIsEmpty' => '无法创建订阅因为没有共享 IP 地址且 Plesk 中没有可用的独立 IP 地址。',
    'create-subscription.infoNewSubscriptionCreated' => '已创建订阅%%name%%。',
    'create-subscription.createBeforeAppInstall' => '您需要有一个订阅来安装应用程序。',

    'customer.hint' => '您可在此新增客户并为其订阅主机服务。首先在 Plesk 中创建客户帐户然后订阅主机方案以及附加方案。订阅也可以不与任何方案绑定，提供自定义的资源和服务 — 具体操作是选择服务方案旁边的\'无\'。',
    'customer.contactInfoSection' => '联系信息',
    'customer.additionalInfoSection' => '其它的客户信息',
    'customer.accessToPanelSection' => '访问 Plesk',
    'customer.contactInfoSectionHint' => '输入客户联系信息。',
    'customer.accessToPanelSectionHint' => '客户将用于访问其客户面板的验证凭据。',
    'customer.unableCreateSubscription' => '无法创建订阅: %%reason%%',
    'customer.poolIsEmpty' => 'IP池为空',
    'customer.buttonOk' => '添加客户',

    'database-settings.dbPrefixRadio' => '添加前缀和下划线到数据库名称的开头',
    'database-settings.dbPrefixNone' => '无',
    'database-settings.dbPrefixUsername' => '用户名',
    'database-settings.dbPrefixExternalId' => '订阅的外部 ID',
    'database-settings.dbUserPrefix' => '添加用户名和下划线到数据库用户名称的开头',
    'database-settings.dbUserPrefixHint' => '数据库用户名称如：<plesk_username>_<database_user_name>。因数据库用户名长度的限制，<plesk_username> 可能被缩写。',
    'database-settings.grantAlterDatabase' => '授予所有 Microsoft SQL Server 数据库用户修改数据库的权限',
    'database-settings.grantAlterDatabaseHint' => '新的和现有的用户都将被授予该权限',
    'database-settings.enableBackupOperator' => '使所有 Microsoft SQL 服务器数据库用户拥有 db_backupoperator 角色成员身份。',
    'database-settings.enableBackupOperatorHint' => '新的和现有的用户都将成为该角色的成员。',
    'database-settings.aclRadio' => '数据库用户远程访问权限的默认设置',
    'database-settings.aclLocalhost' => '仅允许本地连接',
    'database-settings.aclAny' => '允许来自任何主机的远程连接',
    'database-settings.aclCustom' => '允许远程连接来自',
    'database-settings.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\n允许指定的主机代表该用户访问数据库。",
    'database-settings.aclDescription' => '该设置仅修改用户的权限。要启用远程访问本地 MySQL 服务器，请选择<a href="/server/db_server_edit.php?db_server_id=%d">本地 MySQL 设置</a>中相应的选项。',
    'database-settings.example' => "例如：\n%%example%%",

    'dns.template.synchronize-done' => '已成功应用该 DNS 区域模板。',
    'dns.template.synchronize-error' => '该 DNS 区域模板未应用至一些 DNS 区域。',
    'dns.template.synchronize-progress' => '应用该 DNS 区域模板。',

    'domain-restriction.name' => '域名',
    'domain-restriction.nameDescription' => '您可以使用星号 (*) 指定一个通配符模式。例如，*.example.com',
    'domain-restriction.domainAlreadyExists' => '列表中已存在指定的域名。',

    'event-handler.eventLabel' => '事件',
    'event-handler.priorityLabel' => '优先级',
    'event-handler.userLabel' => '用户',
    'event-handler.commandLabel' => '命令',
    'event-handler.commandHint' => '为了获取最佳结果，请在 \'命令\' 字段中输入脚本文件的完整路径。不建议输入系统命令，因为可能无效。例如，带有输出重定向操作符 /&gt; or &lt; 的命令可能无效。',
    'event-handler.priorityHighestText' => '低',
    'event-handler.priorityHighText' => '最高',
    'event-handler.priorityNormalText' => '自定义',
    'event-handler.priorityLowText' => '低',
    'event-handler.priorityLowestText' => '正常',
    'event-handler.priorityCustomText' => '自定义',
    'event-handler.priorityHighestOption' => '最高 (%%value%%)',
    'event-handler.priorityHighOption' => '高 (%%value%%)',
    'event-handler.priorityNormalOption' => '正常 (%%value%%)',
    'event-handler.priorityLowOption' => '低 (%%value%%)',
    'event-handler.priorityLowestOption' => '最低 (%%value%%)',

    'extension.upload.fileUpload' => '进入扩展程序包文件的路径',

    'external-webmail.hint' => '您在 Plesk 中注册了其它的 web 邮箱后，该 web 邮箱即会以一个选项的形式在主机方案和订阅的 \'邮件\' 属性中出现，从而供客户使用。该 web 邮箱名称将会在 web 邮箱选项列表中显示，点击 客户面板 中邮箱旁边的 web 邮箱图标即会打开其 URL。',
    'external-webmail.name' => 'web 邮箱服务名称',
    'external-webmail.url' => 'web 邮箱服务URL',
    'external-webmail.enabled' => '可用',

    'ftp-settings.generalSection' => '常规',
    'ftp-settings.portRange' => '适用于被动FTP模式连接的端口或端口范围',
    'ftp-settings.hintPortRange' => '（默认值：%%defaultPortRange%%）',

    'health.upload.hint' => '上传健康服务器监控配置。上传后，即会应用配置。',
    'health.upload.selectFile' => '配置文件',

    'install-local-package.selectUploadType' => '选择下面的一项：',
    'install-local-package.uploadAsFile' => '上传一个 APS 包',
    'install-local-package.downloadFromCatalog' => '从应用程序目录选择应用程序',
    'install-local-package.formInfo' => "通过上传新的应用程序或从应用程序目录添加应用程序以扩展可用应用程序列表。",
    'install-local-package.invalidFileExtension' => '上传的应用程序必须是 ZIP 压缩文件，扩展名为.zip。',
    'install-local-package.packagesNotSelected' => '未选定软件包。',
    'install-local-package.visible' => '设置客户可用',
    'install-local-package.isCommercial' => '该应用程序为商业应用程序需要购买许可证密钥。',
    'install-local-package.visibleDescription' => '设置客户可安装此应用程序。',

    'ip-address.generalSection' => '通用',
    'ip-address.interface' => '接口',
    'ip-address.addressAndSubnetPrefixLength' => 'IP 地址与子网掩码',
    'ip-address.publicIp' => '公共 IP 地址',
    'ip-address.hintPublicIp' => '如果您的 Plesk 服务器部署在 NAT 后则可使用公共 IP 地址',
    'ip-address.distributionType' => '该 IP 地址被分配为',
    'ip-address.distributionTypeShared' => '共享',
    'ip-address.distributionTypeExclusive' => '独立',
    'ip-address.certificate' => 'SSL/TLS 证书',
    'ip-address.defaultSite' => '默认网站',
    'ip-address.ftpOverSslNotSupportedByServer' => '已安装的 FTP 服务器不支持 FTPS。',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => '安装的 FTP 服务器不支持 IPv6 地址',
    'ip-address.interfaceDHCPEnabled' => '无法添加 IP 地址。该网络接口会自动获取 IP 地址。',
    'ip-address.accessDomainOnAnyDomainWinWarning' => '注意：为所有未知的域名启用了自定义 Plesk URL；将会在 "https://%%ip%%/" 上显示 Plesk 界面而不是默认的站点',

    'ip-ban.filter.name' => '名称',
    'ip-ban.filter.content' => '内容',
    'ip-ban.filter.filterExistsError' => '相同名称的过滤器已经存在。',

    'ip-ban.jail.name' => '名称',
    'ip-ban.jail.filter' => '过滤器',
    'ip-ban.jail.filterDescription' => '选择过滤器。',
    'ip-ban.jail.action' => '操作',
    'ip-ban.jail.actionDescription' => '在此处选择一项操作并点击按钮以添加该操作。',
    'ip-ban.jail.logPath' => '日志路径',
    'ip-ban.jail.banTime' => 'IP 地址禁止时段',
    'ip-ban.jail.maxRetry' => '登录尝试失败最多次数。',
    'ip-ban.jail.timeUnit' => '秒',
    'ip-ban.jail.addAction' => '添加',
    'ip-ban.jail.chooseAction' => '选择：',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache 验证失败（当登录到文件时）',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache 验证失败（任何日志记录）',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache 验证失败（当登录到系统日志时）',
    'ip-ban.jail.apache-badbots-filter-description' => '垃圾邮件机器人程序和恶劣的网络爬虫',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP 和 POP3 验证失败',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP、POP3 和 Sieve 验证失败',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP、POP3 和 Sieve 验证失败（主动模式）',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde web 邮箱验证失败',
    'ip-ban.jail.plesk-modsecurity-filter-description' => '违反 Web 应用程序防火墙 (ModSecurity) 安全和访问控制',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk 验证失败',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP 验证失败',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube web 邮箱验证失败',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress 验证失败',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP 客户端错误（包括 RBL）',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP 客户端错误、验证失败和 DDoS 攻击',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP 和 SASL 验证失败',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS 攻击',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP 客户端错误和验证失败',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP 客户端错误（包括 RBL）',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP 客户端错误（仅 RBL）',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD 登录失败',
    'ip-ban.jail.recidive-filter-description' => 'Fail2Ban 禁止重复托管',
    'ip-ban.jail.sshd-filter-description' => 'SSH 登录失败',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH 登录失败、协商失败和 DDoS 攻击',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH 登录失败和 DDoS 攻击',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH 登录和协商失败',
    'ip-ban.jail.firewallcmd-allports-action-description' => '通过 firewalld 防火墙禁止，在所有端口上',
    'ip-ban.jail.firewallcmd-multiport-action-description' => '通过 firewalld 防火墙禁止，在多个端口上',
    'ip-ban.jail.firewallcmd-new-action-description' => '通过 firewalld 防火墙禁止，在一个端口上',
    'ip-ban.jail.iptables-action-description' => '通过 iptables 防火墙禁止，在单个端口上',
    'ip-ban.jail.iptables-allports-action-description' => '通过 iptables 防火墙禁止，在所有端口上',
    'ip-ban.jail.iptables-multiport-action-description' => '通过 iptables 防火墙禁止，在多个端口上',
    'ip-ban.jail.sendmail-action-description' => '通过 sendmail 发送邮件通知',
    'ip-ban.jail.jailExistsError' => '相同名称的 jail 已经存在。',
    'ip-ban.jail.invalidInteger' => '指定的值无效。请指定一个整数。',

    'ip-ban.settings.pageHint' => '您可在此设置禁止 IP 地址以保护您的服务器和托管的网站免受恶意流量的入侵。',
    'ip-ban.settings.detectionEnabled' => '启用入侵检测',
    'ip-ban.settings.banPeriod' => 'IP 地址禁止时段',
    'ip-ban.settings.banTimeWindow' => '检测后续攻击的时间间隔',
    'ip-ban.settings.maxRetries' => '禁止 IP 地址前失败的次数',
    'ip-ban.settings.timeUnit' => '秒',
    'ip-ban.settings.invalidInteger' => '提供的值无效。请提供一个正整数。',

    'ip-ban.trusted-ip.ipAddress' => 'IP 地址',
    'ip-ban.trusted-ip.hintIpAddress' => '提供一个 IP 地址、一个 CIDR 掩码或一个 DNS 主机名',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => '提供的 IP 地址、网络地址或主机名无效。',

    'login-info.hint' => '在此处您可以修改客户用于访问其客户面板的用户名和密码。',
    'login-info.resellerHint' => '在此处您可以修改代理商用于访问其 Plesk 的用户名和/或密码。',
    'login-info.myProfileHint' => '您可在此修改用于访问 Plesk 的密码。',

    'mail.lists-server-settings.email' => "邮件列表管理员的邮件地址",
    'mail.lists-server-settings.emptyEmail' => '请提供电子邮件地址。',
    'mail.lists-server-settings.newPassword' => '新密码',
    'mail.lists-server-settings.emptyPassword' => '请提供一个密码。',
    'mail.lists-server-settings.passwordConfirmation' => '确认密码',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => '已配置邮件列表软件。',

    'mail.outgoing-messages.hint' => '在此处您可以指定一个邮箱的传出信息的限制。',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => '传出邮件信息的最大数量',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => '默认（每小时 %%domainOutgoingMessages%% 条信息）',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => '该邮箱的自定义值',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => '条信息（每小时）',

    'mail-gate-settings.host' => '主机名称或 IP 地址',
    'mail-gate-settings.port' => '端口',
    'mail-gate-settings.login' => '用户名',
    'mail-gate-settings.password' => '密码',
    'mail-gate-settings.encryption' => 'SMTP 服务器需要加密连接',
    'mail-gate-settings.allowUsers' => '允许用户脚本通过该 SMTP 服务器 （使用指定的用户名和密码）发送邮件。',
    'mail-gate-settings.useDefaultSettings' => '使用与 Plesk 一起安装的邮件服务器和 Plesk 创建的默认邮件帐户',

    'mail-gate.hint' => '您可在此指定当未安装 Plesk 邮件服务器或 Plesk 邮件服务器被禁止外发邮件时该使用的 SMTP 服务器。该服务器将被 Plesk 用作 SMTP 中继以及用于发送如邮件通知之类等外发邮件的用户脚本。',
    'mail-gate.enableMailGate' => '允许 Plesk 通过该 SMTP 服务器发送邮件通知',
    'mail-gate.notifications' => '由外部 SMTP 服务器发送的邮件通知',
    'mail-gate.smtpSettings' => '外部的 SMTP 服务器设置',

    'optimization-settings.apacheModulesSection' => 'Apache 模块',
    'optimization-settings.apacheSettingsSection' => '通用设置',
    'optimization-settings.additionalPageHint' => '只有在您完全了解所做操作带来的后果影响后再切换模块。注意某些修改可能会降低 Apache 的性能或甚至会导致其无法正常运行。',
    'optimization-settings.pageHint' => '在此处您可以通过关闭未使用的 Apache 模块优化 Plesk。该优化会提升内存利用率而能够让您服务更多主机客户。注意，一些模块是相互依附的，只有关闭（启用）其依附的模块才能关闭（启用）该模块。',
    'optimization-settings.advancedUsersOnlyWarning' => '该功能仅适用于高级用户。',
    'optimization-settings.apacheRestartInterval' => 'Apache 重启间隔（秒）',
    'optimization-settings.apacheRestartIntervalHint' => 'Plesk 会对域名和子域名所做的修改在指定的间隔时间内检查一次。如果有些修改需要重启 web 服务器，Plesk 会重启 Apache。',
    'optimization-settings.gracefulRestart' => 'Apache 平滑重启',
    'optimization-settings.gracefulRestartHint' => '选中此复选框以避免每次更改主机设置时服务器上托管的所有网站出现停机情况。',
    'optimization-settings.pipedLog' => '管道日志',
    'optimization-settings.mpmMode' => 'MPM 模式',
    'optimization-settings.moduleDeprecated' => '（已弃用）',

    'personal-info.contactInfoSection' => '联系信息',
    'personal-info.hint' => '您可以在此处编辑用户联系信息。',
    'personal-info.hintMyProfile' => '您可以在此处编辑联系信息。',

    'php-handler.ini.formHint' => '该 php.ini 文件仅被该处理程序使用。',
    'php-handler.ini.formHintSharedIni' => '该 php.ini 文件还被以下 PHP 处理程序使用：%%handlers%%。该设置应用到使用这些处理程序的所有网站。',
    'php-handler.ini.incorrectTextForIniFile' => "指定的设置不正确且无法被保存到 php.ini 文件。错误：%%message%%。",

    'php-handler.modules.formHint' => '这些 PHP 扩展设置仅针对该处理程序。',
    'php-handler.modules.formHintSharedModules' => '这些设置通用于以下 PHP 处理程序：%%handlers%%。该设置应用到使用这些处理程序的所有网站。',

    'plan-item-custom.planItemName' => '服务名称',
    'plan-item-custom.buttonLabel' => '此名称还将用作自定义按钮的标签',
    'plan-item-custom.planItemDescription' => '服务订阅',
    'plan-item-custom.buttonTooltip' => '此文本还将用作自定义按钮的工具提示',
    'plan-item-custom.url' => '连接到自定义按钮的 URL',
    'plan-item-custom.backgroundImage' => '自定义按钮的背景图片',
    'plan-item-custom.emptyItemName' => '请提供服务标签。',
    'plan-item-custom.emptyItemDescription' => '请提供用于服务工具提示的文本。',
    'plan-item-custom.emptyUrl' => '请指定一个URL。',
    'plan-item-custom.longItemName' => '此服务标签太长。允许的最大长度为 %max% 符号。',
    'plan-item-custom.longItemDescription' => '此服务文本太长。允许的最大长度为 %max% 符号。',
    'plan-item-custom.longUrl' => '此 URL 太长。允许的最大长度为 %max% 符号。',
    'plan-item-custom.useCustomButton' => '使用自定义按钮',
    'plan-item-custom.useCustomButtonHint' => '将自定义按钮置于用户的首页与网站页面。',
    'plan-item-custom.openCustomButtonInSameWindow' => '在 Plesk 中打开 URL',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => '指定是否在 Plesk 页面上或新的浏览器窗口中打开 URL。',
    'plan-item-custom.openCustomButtonWithoutFrame' => '不要使用帧',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => '若您添加一个自定义按钮，通过该按钮能够进入客户面板中的 Plesk 扩展或某个应用程序，则可以指定显示该扩展/应用程序的方式：在帧中或作为 Plesk GUI 的一部分显示。',
    'plan-item-custom.includeDomId' => '包含订阅 ID',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => '包含主域名',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => '包含 FTP 用户名',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => '包含 FTP 密码',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => '包含客户ID',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "包含客户的公司名称",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "包含客户的联系名称",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "包含客户的电子邮箱",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => '选择如何预览网站',
    'preview-domain-settings.previewQuick' => '默认的快速预览',
    'preview-domain-settings.previewDisabled' => '禁用快速预览',
    'preview-domain-settings.previewQuickDescription' => '即刻预览，推荐此选项。',
    'preview-domain-settings.previewZoneTypeInternal' => '在 Plesk 中的一个域名上快速预览',
    'preview-domain-settings.previewZoneDomainIdDescription' => '选择一个 Plesk 网站用于预览。',
    'preview-domain-settings.previewZoneDomainCreate' => '若要使用该功能，至少%%link%%一个域名。',
    'preview-domain-settings.subscriptionCreateLink' => '创建',
    'preview-domain-settings.previewZoneTypeExternal' => '在一个外部域名上快速预览',
    'preview-domain-settings.previewZoneDomainNameDescription' => '使用外部域名（DNS 区域）。如果您使用该选项，添加以下 DNS 记录（A 类型）至外部域名区域： *.<Plesk_IP>.external.dom。此处的 <Plesk_IP> 是 Plesk 服务器 IP，其中代表 IPv4 的点号（.）或代表 IPv6 的冒号（:）都由破折号（-）代替。如，*.192-0-2-12.external.dom。如果 Plesk 有多个注册的 IP 地址，请为每一个地址添加一个记录。',
    'preview-domain-settings.sitePreviewProtection' => '需要验证',
    'preview-domain-settings.sitePreviewProtectionDescription' => '需要 FTP 登录名和密码才能预览。',
    'preview-domain-settings.nginxNotInstalled' => '无法进行默认的快速预览因为未安装 nginx web 服务器。',
    'preview-domain-settings.nginxDisabled' => '无法进行默认的快速预览因为 nginx web 服务器已被禁用。',

    'reseller-preferences.settingsSection' => '设置',
    'reseller-preferences.multiLogin' => '允许多个会话',
    'reseller-preferences.language' => '界面语言',
    'reseller-preferences.interfaceView' => '选择界面',
    'reseller-preferences.serviceProviderView' => '服务提供商视图',
    'reseller-preferences.serviceProviderViewHint' => '该视图面向有客户的代理商。代理商可以在该视图中管理客户和自己的网站以及主机服务。',
    'reseller-preferences.powerUserView' => '高级用户视图',
    'reseller-preferences.powerUserViewHint' => '该视图会给代理商提供一个简单的界面，帮助他们管理自己的网站、邮件帐户和其它主机服务。代理商无法在该视图中管理客户。',

    'reseller.hint' => '您可在此新增代理商并为其订阅主机服务。',
    'reseller.contactInfoSection' => '联系信息',
    'reseller.contactInfoSectionHint' => '输入代理商联系信息。',
    'reseller.accessToPanelSection' => '访问 Plesk',
    'reseller.accessToPanelSectionHint' => '代理商将用于访问 Plesk 管理其注册的服务的验证凭据。',
    'reseller.subscription' => '订阅',
    'reseller.subscriptionSectionHint' => '选择代理商要订阅的服务方案。',
    'reseller.servicePlan' => '服务方案',
    'reseller.none' => '无',
    'reseller.customizeSubscription' => '创建代理商后，继续自定义订阅参数。注意，执行此操作会锁定订阅而不能同步。',
    'reseller.subscriptionNotSynchronized' => '无法将订阅与服务方案同步。订阅的下列设置与服务方案冲突：%%problems%%。',

    'security-policy.encryptionSection' => '增强安全模式',
    'security-policy.encryptionSectionHint' => '增强安全模式引入了对 Plesk 中敏感数据的增强保护。在这种模式下，Plesk 采用了多个安全机制，这些机制对 Plesk 用户来说是绝对透明的。为了提升 Plesk 的安全度，我们建议您打开该模式。',
    'security-policy.encryptionEnable' => '增强安全模式',
    'security-policy.securePassword' => '增强安全模式',
    'security-policy.strengthSection' => '密码强度',
    'security-policy.strengthSectionHint' => '当用户在系统中设置新密码（创建新的或更改现有的）时，需要根据此页面上指定的最小强度要求调整密码。密码的强度是根据其总体长度和复杂性（使用数字、大小写字母和特殊字符）来计算的。我们建议您强制您的用户使用较强密码。',
    'security-policy.passwordStrength' => '最小密码强度',
    'security-policy.passwordStrengthVeryWeakHint' => '这些密码通常很简短，只使用一类字符（小写或大写字符或数字）。例如：password此安全级别防止最简单的密码猜测攻击。',
    'security-policy.passwordStrengthWeakHint' => '这些密码通常比较简短，并且主要使用一类字符（小写或大写字符或数字）外加其它一类的多个字符。例如：password12这些密码对密码猜测提供了基本的保护。',
    'security-policy.passwordStrengthMediocreHint' => '这些密码通常比较简短并且至少包含两类字符（小写或大写字符、数字或特殊字符）。例如：Password12此类密码针对密码捕获攻击提供可靠的保护。',
    'security-policy.passwordStrengthStrongHint' => '这些密码长度至少为 8 个字符，至少包含一个大小写字符、数字和特殊字符。例如：P@ssw0rd12此类密码提供了强有力的保护免受暴力攻击。',
    'security-policy.passwordStrengthStrongerHint' => '这些密码长度至少为 16 个字符，包含多个大小写字符、数字和特殊字符组合。例如：~!my_P@$$w0rD123此类密码虽然难记，但是能够提供最好的保护。',
    'security-policy.secureFtpSection' => '安全 FTP',
    'security-policy.ftpOverSsl' => 'FTPS 使用策略',
    'security-policy.ftpOverSslHint' => 'FTPS 用于使用 SSL/TLS 协议保护 FTP 服务器与外部 FTP 客户端之间的通信安全。您可在此选择允许哪种连接。',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS 用于使用 SSL/TLS 协议保护 FTP 服务器与外部 FTP 客户端之间的通信安全。您可在此选择允许哪种连接。选定的选项将应用到服务器上所有的 IP 地址。若要按每 IP 地址使用自定义设置，请选择相应的选项，然后在 工具与设置> IP 地址 中更改 FTPS 策略。',
    'security-policy.ftpOverSslCustomHint' => 'FTPS 用于使用 SSL/TLS 协议保护 FTP 服务器与外部 FTP 客户端之间的通信安全。',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS 用于使用 SSL/TLS 协议保护 FTP 服务器与外部 FTP 客户端之间的通信安全。如果要按每 IP 地址调整 FTPS 设置，请首先进入 工具与设置 > 安全策略 > 安全 FTP 中选择选项 "按每 IP 地址使用自定义 FTPS 设置"。',
    'security-policy.ftpOverSslOptionRequired' => '仅允许安全 FTPS 连接',
    'security-policy.ftpOverSslOptionEnabled' => '允许安全 FTPS 和非安全 FTP 连接',
    'security-policy.ftpOverSslOptionDisabled' => '仅允许非安全 FTP 连接。不使用 FTPS',
    'security-policy.ftpOverSslOptionCustom' => '每 IP 地址使用自定义 FTPS 策略',
    'security-policy.prohibitWebConfigHandlersSection' => '自定义处理程序策略',
    'security-policy.prohibitWebConfigHandlersSectionHint' => '启用此选项以禁止客户通过 web.config 文件覆盖在服务器级别定义的 IIS 处理程序。',
    'security-policy.prohibitWebConfigHandlers' => '禁止通过 web.config 覆盖处理程序',

    'service-instance.setup-instance.resourcesSection' => '服务资源',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => '已安装',
    'service-instance.setup-instance.requirementsSection' => '需要的服务',
    'service-instance.setup-instance.requiredServiceNotSelected' => '未选择',

    'service-node.ipAddress' => '服务节点 IP 地址',
    'service-node.ipAddressLocal' => '本地服务节点',
    'service-node.description' => '服务节点描述',
    'service-node.accessKey' => '密码',
    'service-node.useAccessKey' => '使用验证',
    'service-node.useAccessKeyDescription' => '关于使用验证的提示。',
    'service-node.oldAccessKey' => '旧密码',
    'service-node.newAccessKey' => '新密码',
    'service-node.noAccessKeySpecified' => '未指定密码',

    'service-plan.admin-plan.subscription_section' => '通用',
    'service-plan.admin-plan.tools_section' => '工具与资源',
    'service-plan.admin-plan.apps_section' => '应用程序与数据库',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk 外观',
    'service-plan.admin-plan.statistics_section' => '统计',
    'service-plan.admin-plan.general_section' => '常用',
    'service-plan.admin-plan.mail_section' => '邮件',
    'service-plan.admin-plan.server_section' => '服务器',
    'service-plan.admin-plan.modules_section' => '扩展',
    'service-plan.admin-plan.simplePanel' => '限制模式',
    'service-plan.admin-plan.enabled' => '启用限制模式',
    'service-plan.admin-plan.enabledDescription' => '选择此选项来限制管理员可以在Plesk中采取操作的次数。',
    'service-plan.admin-plan.aliasEnabledDescription' => '选择此选项来限制其它管理员可以在Plesk中采取操作的次数。',

    'service-plan.applications-subscription.useFilterLabel' => '只提供我选择的应用程序',
    'service-plan.applications-subscription.useFilterDescription' => '使用该选项选择订户可用的应用程序。',
    'service-plan.applications-subscription.applications' => '应用程序',
    'service-plan.applications-subscription.isCommercial' => '该应用程序为商业应用程序需要购买许可证密钥。',

    'service-plan.applications.useFilterLabel' => '只提供我选择的应用程序',
    'service-plan.applications.useFilterDescription' => '使用该选项选择订户可用的应用程序。',
    'service-plan.applications.applications' => '应用程序',
    'service-plan.applications.isCommercial' => '该应用程序为商业应用程序需要购买许可证密钥。',

    'service-plan.dns.dnsZoneType' => '域名 DNS 区域',
    'service-plan.dns.dnsZoneTypeMaster' => '主控',
    'service-plan.dns.dnsZoneTypeSlave' => '从属',

    'service-plan.extras.groupOtherServices' => '其它服务',
    'service-plan.extras.none' => '无',

    'service-plan.hosting.enablePhysicalHosting' => '启用主机',
    'service-plan.hosting.sectionCoreHosting' => '常规属性',
    'service-plan.hosting.sectionScripting' => '脚本',
    'service-plan.hosting.defaultDatabaseServer' => '默认的数据库服务器',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => '高级',
    'service-plan.hosting.phpSettingsHelpLink' => '了解如何选择最适合的PHP设置',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => '订阅被挂起时网站的状态',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => '已被挂起订阅中的网站状态',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => '当订阅被挂起（例如，订阅到期）时选定的状态将被应用到方案订阅下的所有网站。',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => '当订阅被挂起（例如，订阅到期）时选定的状态将被应用到网站。',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => '禁用',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => '网站访客将被重定向至 web 服务器的默认页面。',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => '挂起',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => '网站访客将会被重定向至自定义的错误文档页面（带有搜索引擎友好 503 HTTP 代码）。',
    'service-plan.hosting.unpaidWebsiteStatusActive' => '活动',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => '将继续可以通过互联网访问网站。',

    'service-plan.ip.sharedIpAddresses' => '分配共享 IP 地址',
    'service-plan.ip.allocateExclusiveIp' => '分配独立 IP 地址',
    'service-plan.ip.allocateExclusiveIpV4' => '分配独立 IPv4 地址',
    'service-plan.ip.allocateExclusiveIpV6' => '分配独立 IPv6 地址',

    'service-plan.mail.mailService' => '启用邮件服务',
    'service-plan.mail.webMail' => 'Web 邮箱',
    'service-plan.mail.mailingLists' => '启用邮件列表',
    'service-plan.mail.mailToNonExistentUser' => '关于不存在的用户的邮件策略',
    'service-plan.mail.mailToNonExistentUserBounce' => '退信通知',
    'service-plan.mail.mailToNonExistentUserRedirect' => '转发到地址',
    'service-plan.mail.mailToNonExistentUserReject' => '拒绝',
    'service-plan.mail.mailAutodiscovery' => '启用邮件 autodiscover',
    'service-plan.mail.mailAutodiscoveryDescription' => '请在 <a href="%%link%%" target="_blank">knowledge base</a> 中查看该功能是如何运行的',
    'service-plan.mail.bounceMessage' => '此地址不再接收邮件。',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => '重定向到该 IP 地址的外部邮件服务器：',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - 禁用',

    'service-plan.misc.retainEnabled' => '保留网站和流量统计',
    'service-plan.misc.logRotation' => '日志循环',
    'service-plan.misc.logRotationCondition' => '日志循环条件',
    'service-plan.misc.logRotationBySize' => '按大小',
    'service-plan.misc.logRotationByTime' => '按时间',
    'service-plan.misc.logRotationDaily' => '每日',
    'service-plan.misc.logRotationWeekly' => '每周',
    'service-plan.misc.logRotationMonthly' => '每月',
    'service-plan.misc.logRotationSizeDescription' => '大小值必须在 %%min%% 与 %%max%% kB 之间。',
    'service-plan.misc.maximumNumberOfFiles' => '日志文件最大数量',
    'service-plan.misc.compress' => '压缩日志文件',
    'service-plan.misc.sendLogToEmail' => 'Plesk 从 web 和 FTP 服务器的日志文件检索数据后，会通过邮件发送日志到该地址',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => '个月',
    'service-plan.misc.logRotationPeriodGreater' => '日誌輪轉週期不能比伺服器範圍內的限制%%max%%長。',

    'service-plan.performance.iisAppPoolAddonsHint' => '如未启用，订阅的所有网站都会使用专用于该订阅的同一 IIS 应用程序池。',

    'service-plan.permissions-subscription.permissionsTabDescription' => '选择订阅的服务及权限。',
    'service-plan.permissions-subscription.showMorePermissions' => '显示更多可用权限',
    'service-plan.permissions-subscription.hideMorePermissions' => '显示较少权限',
    'service-plan.permissions-subscription.noShellManagement' => '不允许',
    'service-plan.permissions-subscription.systemAccessLabel' => '管理通过SSH访问服务器',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => '允许客户为其系统用户启用 SSH。设置 "通过 SSH 在订阅的系统用户的名下访问服务器 shell" 主机参数作为预设参数。',

    'service-plan.permissions.permissionsTabDescription' => '选择方案提供的服务和权限。',
    'service-plan.permissions.permissionsAddonTabDescription' => '选择将作为附加方案而添加到订阅的服务及权限。注意，在附加方案中未选的权限不会影响到订阅参数。',
    'service-plan.permissions.permissionsBehaviorDescription' => '权限能够让客户更改其订阅的特定设置。当创建了一个订阅时，Plesk 会将方案的预设值应用到客户可以更改的设置。之后，更新方案或应用附加方案不会覆盖客户所做的更改。',
    'service-plan.permissions.showMorePermissions' => '显示更多可用权限',
    'service-plan.permissions.hideMorePermissions' => '显示较少权限',
    'service-plan.permissions.noShellManagement' => '不允许',
    'service-plan.permissions.systemAccessLabel' => '管理通过SSH访问服务器',
    'service-plan.permissions.systemAccessLabel_hint' => '设置主机参数 “通过 SSH 在订阅的系统用户的名下访问服务器 shell” 为预设参数。',

    'service-plan.resources-subscription.overusePolicy' => '超额使用策略',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => '不允许超额使用',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => '阻止超额使用资源。如果资源使用超过了上限值，订阅会自动被挂起。',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => '允许超额使用磁盘空间与流量',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => '允许超额使用磁盘空间与流量。不允许超额使用其他资源。',
    'service-plan.resources-subscription.overusePolicyAllowed' => '允许超额使用（不建议）',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => '允许订户超额使用订阅资源。',
    'service-plan.resources-subscription.overuseNotify' => '超额使用时通过邮件通知我。',
    'service-plan.resources-subscription.oversellPolicy' => '超额销售策略',
    'service-plan.resources-subscription.oversellPolicyAllowed' => '允许超额销售',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => '超额销售允许代理商超额出售通过订阅分配给他们的资源。若允许超额销售，代理商则可支配实际使用的资源而不是初始分配的资源。',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => '不允许超额销售',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => '若不允许超额销售，不管实际使用的资源是多少，代理商都只能出售通过订阅初始分配给他们的资源。',
    'service-plan.resources-subscription.mainGroupTitle' => '定义订阅的资源使用限制。',
    'service-plan.resources-subscription.additionalGroupTitle' => '显示更多可用资源',
    'service-plan.resources-subscription.hideMoreResources' => '显示较少资源',

    'service-plan.resources.overusePolicy' => '超额使用策略',
    'service-plan.resources.overusePolicyNotAllowed' => '不允许超额使用',
    'service-plan.resources.overusePolicyNotAllowedHint' => '阻止超额使用资源。如果资源使用超过上限值，订阅会自动挂起。',
    'service-plan.resources.overusePolicySoftAllowed' => '允许超额使用磁盘空间与流量',
    'service-plan.resources.overusePolicySoftAllowedHint' => '允许超额使用磁盘空间与流量。不允许超额使用其他资源。',
    'service-plan.resources.overusePolicyAllowed' => '允许超额使用（不建议）',
    'service-plan.resources.overusePolicyAllowedHint' => '允许客户使用比初始分配给方案的更多的资源。',
    'service-plan.resources.overuseNotify' => '超额使用时通过邮件通知我。',
    'service-plan.resources.oversellPolicy' => '超额销售策略',
    'service-plan.resources.oversellPolicyAllowed' => '允许超额销售',
    'service-plan.resources.oversellPolicyAllowedHint' => '超额销售允许代理商超额出售通过方案分配给他们的资源。若允许超额销售，代理商则可支配实际使用的资源而不是初始分配的资源。',
    'service-plan.resources.oversellPolicyNotAllowed' => '不允许超额销售',
    'service-plan.resources.oversellPolicyNotAllowedHint' => '若不允许超额销售，不管实际使用的资源是多少，代理商都只能出售通过方案初始分配给他们的资源。',
    'service-plan.resources.mainGroupTitle' => '定义方案的资源。',
    'service-plan.resources.additionalGroupTitle' => '显示更多可用资源',
    'service-plan.resources.hideMoreResources' => '显示较少资源',
    'service-plan.resources.allowSitebuilderUpsell' => '允许客户创建试用的 Presence Builder 网站。',
    'service-plan.resources.allowSitebuilderUpsellDescription' => '此设置允许客户创建比服务方案提供的更多的 Presence Builder 网站。客户需购买这些网站才能发布。',

    'service-plan.servicePlanName' => '服务方案名称',
    'service-plan.resellerPlanName' => '代理商方案名称',
    'service-plan.addonPlanName' => '附加方案名称',
    'service-plan.adminPlanPermissionsTab' => '管理工具',
    'service-plan.adminPlanPermissionsTabDescription' => '选项当启用了限制模式时，管理员可以使用的功能。',
    'service-plan.hostingPermissionsTab' => '主机工具',
    'service-plan.hostingPermissionsTabDescription' => '选择当启用了限制模式时，高级用户视图中的管理员可以使用的web主机工具和设置。',
    'service-plan.resourcesTab' => '资源',
    'service-plan.resourcesTabDescription' => '定义方案资源以及资源使用策略。',
    'service-plan.subscriptionResourcesTabDescription' => '定义订阅资源以及资源使用策略。',
    'service-plan.hostingTab' => '主机参数',
    'service-plan.hostingTabDescription' => '指定主机服务的参数。注意在附加方案中指定的主机设置不会应用到通过服务方案或附加方案授以“主机设置管理”权限的订阅。',
    'service-plan.secureSettingsDescription' => '如果您希望提供的主机是最安全的，请%%link%%。如果订户享有某些权限，则可以更改这些设置。请%%helpLink%%。',
    'service-plan.secureSettingsLink' => '应用预设的安全设置',
    'service-plan.secureSettingsHelpLink' => '了解安全主机设置',
    'service-plan.mailTab' => '邮件',
    'service-plan.mailTabDescription' => '指定方案的邮件服务参数。',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => '指定方案的 DNS 服务参数。',
    'service-plan.performanceTab' => '性能',
    'service-plan.performanceTabDescription' => '请指定影响方案所有服务性能的系统参数。',
    'service-plan.permissionsTab' => '权限',
    'service-plan.miscTab' => '日志与统计',
    'service-plan.miscTabDescription' => '指定如何存储方案订阅的统计及日志。注意这些设置在订阅中不同步。',
    'service-plan.miscTabAdminPlanDescription' => '请指定如何存储订阅的统计和日志。',
    'service-plan.extrasTab' => '其它服务',
    'service-plan.extrasTabDescription' => '选择除了主机、DNS与邮件服务外的包含在方案里的其它服务。',
    'service-plan.ipTab' => 'IP地址',
    'service-plan.ipTabDescription' => '定义方案的 IP 资源的参数。',
    'service-plan.applicationsTab' => '应用程序',
    'service-plan.applicationsTabDescription' => '为方案选择可供使用的应用程序。您可选择应用程序目录中所有的应用程序，外加您上传到服务器中的应用程序，或者手动选择应用程序。如果您要选择所有可用的应用程序，则不必在此标签上做任何操作，只需进入 权限 标签选择 访问应用程序目录 选项即可。如果您想要手动选择应用程序，您可在此标签上操作。',
    'service-plan.applicationsTabDescription-addon' => '选择可用作附加方案的应用程序',
    'service-plan.applicationsTabDescription-subscription' => '为订阅选择可供使用的应用程序。您可选择应用程序目录中所有的应用程序，外加您上传到服务器中的应用程序，或者手动选择应用程序。如果您要选择所有可用的应用程序，则不必在此标签上做任何操作，只需进入 权限 标签选择 访问应用程序目录 选项即可。如果您想要手动选择应用程序，您可在此标签上操作。',
    'service-plan.planSyncSubsriptionWarning' => '部分订阅未与方案同步。在订阅列表中标志为"未同步"。若要重试同步，转到订阅概要页，并单击同步按钮。',
    'service-plan.planSyncResellerWarning' => '部分代理商未与方案同步。代理商列表中都标记为"未同步"。若要重新尝试同步，转到代理商概要页，并单击同步按钮。',
    'service-plan.planSyncAdminWarning' => '无法应用更改到订阅因为 Plesk 不提供这些更改所影响的某些服务或资源。原因：%%reason%%',
    'service-plan.duplicateName' => '相同名称的方案已经存在。',
    'service-plan.phpSettingsTab' => 'PHP 设置',
    'service-plan.phpSettingsTabDescription' => '您可在此为每个订阅指定 PHP 设置，覆盖服务器级的 php.ini 文件定义的设置。例如，当您想要限制客户 PHP 脚本占用的系统资源时，可进行此设置。客户（如果允许）可使用其为每个域名自行调整的配置覆盖此 PHP 配置。当您设置一个参数为默认值时，PHP 将会使用来自服务器级的 PHP 配置的参数值。注意支持使用以下占位符：{DOCROOT} 和 {WEBSPACEROOT} 代表获取自定义 PHP 配置的某个域名的文档根目录和某个订阅的根目录；{TMP} 代表存储临时文件的目录。',
    'service-plan.phpSettingsTabDescriptionAddon' => '您可在此为每个订阅指定 PHP 设置，覆盖主要服务方案定义的设置。例如，当您想要移除在主要服务方案中设置的一些 PHP 限制时，可进行此设置。当您设置一个参数为默认值时，PHP 将会使用来自服务方案 PHP 配置的参数值。注意支持使用以下占位符：{DOCROOT} 和 {WEBSPACEROOT} 代表获取自定义 PHP 配置的某个域名的文档根目录和某个订阅的根目录；{TMP} 代表存储临时文件的目录。',
    'service-plan.phpSettingsPhpVersion' => '您目前 PHP 版本是 %%version%%。',
    'service-plan.phpSettingsTabAdminPlanDescription' => '您可在此为每个订阅指定 PHP 设置，覆盖服务器级的 php.ini 文件定义的设置。当您设置一个参数为默认值时，PHP 将会使用来自服务器级的 PHP 配置的参数值。',
    'service-plan.webServerSettingsTab' => 'Web 服务器',
    'service-plan.webServerSettingsTabDescription' => '在此处您可以指定该服务方案的 Apache web 服务器设置。如果 Apache正在使用 nginx 作为前端服务器。您也可在该页面上指定 nginx 设置。所有新创建的域名将会接收指定的设置。但是，当您更改这些设置时，现有域名将不会接收修改。',
    'service-plan.servicesTab' => '服务',
    'service-plan.servicesTabDescription' => '在此处您可以指定分配给服务方案的服务。',
    'service-plan.servicePropertiesTab' => '%%serviceName%% 属性',
    'service-plan.servicePropertiesTabDescription' => '在此处您可以指定分配给服务方案的 %%serviceName%% 服务的属性。',
    'service-plan.longTaskWarning' => '在该方案上您有 %%subscriptionsCount%% 个订阅。注意同步任务可能需要大量时间而将要在后台执行。',
    'service-plan.hostingParametersTab' => '主机参数',
    'service-plan.adminInfoSection' => '管理员的信息',
    'service-plan.descriptionInPanel' => '描述',
    'service-plan.longDescription' => '指定的描述太长。',
    'service-plan.conflictPermissions' => '无法授予以下权限因为它们与代理商方案相冲突：%%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => '启动类型',
    'services.change-startup-type.autoStartupTypeLabel' => '自动',
    'services.change-startup-type.manualStartupTypeLabel' => '手动',
    'services.change-startup-type.disabledStartupTypeLabel' => '禁用',
    'services.change-startup-type.autoActionError' => '无法设置启动类型为 \'自动\'：%%error%%',
    'services.change-startup-type.manualActionError' => '无法设置启动类型为 \'手动\'：%%error%%',
    'services.change-startup-type.disableActionError' => '无法设置启动类型为 \'禁用\'：%%error%%',

    'sessions.settings.restoreDefaultButton' => '重设为默认值',
    'sessions.settings.restoreDefaultButtonDescription' => '恢复会话参数为默认值。',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => '会话参数有默认值。',
    'sessions.settings.idleTime' => '会话闲置时间',
    'sessions.settings.disableCheckSessionIp' => '允许在单个会话期间更改 IP 地址',
    'sessions.settings.minuteShortTitle' => '分钟',

    'settings-ui.controls.title' => '控件',

    'settings-ui.interface-views.description' => "有多个产品 UI 视图供您使用。因您使用视图的不同，各个功能与设置所处的位置会不同，甚至启用/禁用的状态也会不同。不同的视图适合不同类型的用户。",
    'settings-ui.interface-views.panelSimpleLink' => '工具 & 设置> 限制模式设置',
    'settings-ui.interface-views.useCustomView' => '启用限制模式',
    'settings-ui.interface-views.useCustomViewHint' => '选择此选项来限制管理员可以在Plesk面板中采取操作的次数。若要更改操作的可用性，请转到%%customViewSettingsLink%%。',
    'settings-ui.interface-views.powerUserViewHint' => "此视图面向服务器管理员，配置一个简单界面，供服务器管理员管理自己的网站、邮件帐户和其它服务。",
    'settings-ui.interface-views.selectUiModeTitle' => "选择界面",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "高级用户视图",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "服务提供商视图",
    'settings-ui.interface-views.uiModeHintServiceProvider' => "此视图有供服务器管理员、代理商与主机最终用户使用的界面。",

    'sitebuilder.trial.description' => '您可在此配置 试用后购买 方案。通过此方案客户能够使用 Presence Builder 里所有可用的功能创建网站。但是他们若要发布试用网站，则必须购买主机服务方案或附加方案。现有客户也可通过一个主机方案或一个附加方案享用 试用后购买 模式。%%link%%',
    'sitebuilder.trial.descriptionLink' => '参阅文档了解更多信息。',
    'sitebuilder.trial.lifetimeLabel' => '试用网站期限',
    'sitebuilder.trial.lifetimeUnits' => '天',
    'sitebuilder.trial.lifetimeDescription' => '在这显示这些未购买的试用网站多长时间将从服务器上移除。',
    'sitebuilder.trial.signupLabel' => '启用公共访问试用模式',
    'sitebuilder.trial.signupDescription' => '如果您想要通过推广配置有 Presence Builder 的主机或通过提供 Presence Builder 演示来吸引客户，则可以启用公共访问试用模式，在您的网站上发布访问试用模式的 URL。',
    'sitebuilder.trial.signupLinkLabel' => '访问试用模式的 URL',
    'sitebuilder.trial.signupLinkDescription' => '此 URL 将在试用模式里打开 Presence Builder。在您的网站上发布URL 以吸引客户。',
    'sitebuilder.trial.promotionLabel' => '在 Presence Builder 编辑器里显示试用模式提示',
    'sitebuilder.trial.promotionDescription' => '如果您想要显示有关 Presence Builder 试用模式的其它通知可使用该选项。',

    'update-settings.policyHintForPum' => '您可以在此设置自动安装更新。当有可进行手动安装的更新或更新已被自动安装时发送通知邮件。',
    'update-settings.policyHint' => '当有可进行手动安装的更新或更新已被自动安装时发送通知邮件。',
    'update-settings.branchDisabledDescription' => '不要通知我有关升级版的信息',
    'update-settings.automaticPatchesInstallation' => '自动安装 Plesk 更新（推荐）',
    'update-settings.automaticPatchesInstallationHint' => '总是会自动安装关键的安全更新。',
    'update-settings.automaticPatchesThirdParty' => '自动为 Plesk 附带的第三方组件安装更新',
    'update-settings.automaticSystemPackageUpdates' => '自动安装系统程序包更新',
    'update-settings.automaticSystemPackageUpdatesHint' => '注意这将自动为 Plesk 附带的第三方组件安装更新',
    'update-settings.automaticPatchesNotification' => '通知有关可用的和已安装的系统包更新的信息',
    'update-settings.systemPackageUpdatesNotificationsEmail' => '电子邮件地址',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => '通知邮件频率',
    'update-settings.daily' => '每天',
    'update-settings.weekly' => '每周',
    'update-settings.generalSection' => '常规',
    'update-settings.notificationsSection' => '通知',
    'update-settings.safeUpdatesSection' => '安全更新',
    'update-settings.safeUpdatesSectionHint' => 'Plesk 保证了会从初始安装系统包的相同 repository 安装系统包更新。此类更新比较安全。如果您禁用了安全更新，您的系统包管理器可能会从系统中的任一 repository 安装更新。',
    'update-settings.safeUpdatesSectionWarn' => '我们建议您保留启用安全更新，除非您是高级用户。从其它任意 repositories 更新系统包可能会对您的服务器的正常运行产生不利影响。',
    'update-settings.allowSafeUpdates' => '启用安全更新系统包',

    'requiredFields' => '必填字段',
];