<!-- BEGIN DYNAMIC BLOCK: readonly -->
<div class="formArea">
    <fieldset>
        <legend>{SYSTEM_TIME_TITLE}</legend>
        <table class="formFields" cellspacing="0" width="100%">
            <tr>
                <td class="name">{DATE_TEXT}</td>
                <td>{DATE_VALUE}</td>
            </tr>
            <tr>
                <td class="name">{TIME_TEXT}</td>
                <td>{TIME_VALUE}</td>
            </tr>
        </table>
    </fieldset>

    <fieldset>
        <legend>{TIMEZONE_TITLE}</legend>
        <table class="formFields" cellspacing="0" width="100%">
            <tr>
                <td class="name">{TIMEZONE_TEXT}</td>
                <td>{TIMEZONE_VALUE}</td>
            </tr>
            <tr>
                <td colspan="2">
                    <input type="checkbox" class="checkbox" name="daylight" id="fid-daylight" value="true" {DAYLIGHT_CHECKED} DISABLED>
                    <label class="name" for="fid-daylight">{DAYLIGHT_TEXT}</label>
                </td>
            </tr>
        </table>
    </fieldset>
</div>
<!-- END DYNAMIC BLOCK: readonly -->

<!-- BEGIN DYNAMIC BLOCK: editable -->
<script>
    <!--

    function ntp_enabled_oC(f) {
        if (!f.ntp_enabled.checked) {
            f.ntp_server.disabled = true;
        } else {
            f.ntp_server.disabled = false;
            f.ntp_server.focus();
        }
        return true;
    }

    //-->
</script>

<div class="formArea">
    <fieldset>
        <legend>{SYSTEM_TIME_TITLE}</legend>
        <table width="100%" class="twoColsLayout" cellspacing="0">
            <tr>
                <td width="50%">
                    <table class="formFields" cellspacing="0" width="100%">
                        <tr {YEAR_ERROR}>
                            <td class="name"><label for="fid-year">{YEAR_TEXT}</label></td>
                            <td><input type="text" name="year" id="fid-year" value="{YEAR_VALUE}" maxlength="4" size="5"></td>
                        </tr>
                        <tr {MON_ERROR}>
                            <td class="name"><label for="fid-mon">{MON_TEXT}</label></td>
                            <td><input type="text" name="mon" id="fid-mon" value="{MON_VALUE}" maxlength="4" size="5"></td>
                        </tr>
                        <tr {MDAY_ERROR}>
                            <td class="name"><label for="fid-mday">{MDAY_TEXT}</label></td>
                            <td><input type="text" name="mday" id="fid-mday" value="{MDAY_VALUE}" maxlength="4" size="5"></td>
                        </tr>
                    </table>
                </td>
                <td width="50%">
                    <table class="formFields" cellspacing="0" width="100%">
                        <tr {HOURS_ERROR}>
                            <td class="name"><label for="fid-hours">{HOURS_TEXT}</label></td>
                            <td><input type="text" name="hours" id="fid-hours" value="{HOURS_VALUE}" maxlength="4" size="5"></td>
                        </tr>
                        <tr {MINUTES_ERROR}>
                            <td class="name"><label for="fid-minutes">{MINUTES_TEXT}</label></td>
                            <td><input type="text" name="minutes" id="fid-minutes" value="{MINUTES_VALUE}" maxlength="4" size="5"></td>
                        </tr>
                        <tr {SECONDS_ERROR}>
                            <td class="name"><label for="fid-seconds">{SECONDS_TEXT}</label></td>
                            <td><input type="text" name="seconds" id="fid-seconds" value="{SECONDS_VALUE}" maxlength="4" size="5"></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <div class="formButtons">
            {SET_TIME_BUTTON}
        </div>
    </fieldset>

    <fieldset>
        <legend>{TIMEZONE_TITLE}</legend>
        <table class="formFields" cellspacing="0" width="100%">
            <tr {TIMEZONE_ERROR}>
                <td class="name"><label for="fid-timezone">{TIMEZONE_TEXT}</label></td>
                <td>{TIMEZONE_SELECT}</td>
            </tr>
            <tr>
                <td colspan="2">
                    <input type="checkbox" class="checkbox" name="daylight" id="fid-daylight" value="true" {DAYLIGHT_CHECKED} {DAYLIGHT_DISABLED}>
                    <label class="name" for="fid-daylight">{DAYLIGHT_TEXT}</label>
                </td>
            </tr>
        </table>
        <div class="formButtons">
            {SET_TIMEZONE_BUTTON}
        </div>
    </fieldset>

    <fieldset>
        <legend>
            <input type="checkbox" class="checkbox" name="ntp_enabled" id="fid-ntp_enabled" value="true" {NTP_ENABLED_CHECKED} onClick="return ntp_enabled_oC(this.form);">
            <label for="fid-ntp_enabled">{NTP_ENABLED_TEXT}</label>
        </legend>
        <table class="formFields" cellspacing="0" width="100%">
            <tr {NTP_SERVER_ERROR}>
                <td class="name"><label for="fid-ntp_server">{NTP_SERVER_TEXT}</label></td>
                <td><input type="text" name="ntp_server" id="fid-ntp_server" value="{NTP_SERVER_VALUE}" maxlength="254" size="20" {NTP_SERVER_DISABLED}></td>
            </tr>
        </table>
        <div class="formButtons">
            {SET_NTP_BUTTON}
        </div>
    </fieldset>
    <!-- END DYNAMIC BLOCK: editable -->
</div>
