<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Se o site estiver alojado num endereço IP dedicado (não compartilhado com outros utilizadores ou sites), é possível criar um diretório onde outros utilizadores poderão realizar o carregamento ou a transferência de ficheiros anonimamente por FTP. Quando o FTP Anónimo for ligado, os utilizadores poderão aceder ao diretório num endereço similar a ftp://ftp.your-domain.com com o nome de utilizador "anonymous" e qualquer senha.',
    'anonymous-ftp.displayLogin' => 'Apresentar mensagem de entrada',
    'anonymous-ftp.loginText' => 'Texto da mensagem',
    'anonymous-ftp.incomingDir' => 'Permitir o carregamento para o diretório de entrada',
    'anonymous-ftp.incomingSubDir' => 'Permitir a criação de diretórios no diretório de entrada',
    'anonymous-ftp.incomingReadable' => 'Permitir a transferência a partir do diretório de entrada',
    'anonymous-ftp.quota' => 'Limitar o espaço de disco no diretório de entrada',
    'anonymous-ftp.maxConnections' => 'Limitar o número de ligações simultâneas',
    'anonymous-ftp.bandwidth' => 'Limitar a largura de banda de transferência para este domínio FTP virtual',
    'anonymous-ftp.unlimited' => 'Ilimitado',

    'aps.catalog.loading' => 'A carregar',
    'aps.catalog.searchName' => 'Aplicações',
    'aps.catalog.searchVendor' => 'Vendedor',
    'aps.catalog.searchPackager' => 'Empacotador',
    'aps.catalog.searchLicenseType' => 'Tipo de licença',
    'aps.catalog.searchLicenseTypeAny' => 'Qualquer',
    'aps.catalog.searchLicenseTypeFreeware' => 'Livre',
    'aps.catalog.searchLicenseTypeCommercial' => 'Comercial',
    'aps.catalog.showSearch' => 'Exibir Procura',
    'aps.catalog.hideSearch' => 'Ocultar Procura',
    'aps.catalog.buttonSearch' => 'Pesquisar',
    'aps.catalog.buttonResetSearch' => 'Reiniciar pesquisa',
    'aps.catalog.showCategories' => 'Selecione uma das categorias seguintes ou pesquise aplicações utilizando a caixa de pesquisa.',
    'aps.catalog.searchResults' => 'Resultados da procura',
    'aps.catalog.buttonInstall' => 'Instalar',
    'aps.catalog.buttonInstallTooltip' => 'Instale rapidamente a versão mais recente da aplicação com parâmetros predefinidos ideais.',
    'aps.catalog.buttonAdvancedInstall' => 'Instalação (Padrão)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Instale a versão mais recente da aplicação, personalizando todos os parâmetros.',
    'aps.catalog.buttonInstallOldVersion' => 'Versão da Instalação',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Instale a versão selecionada da aplicação, personalizando todos os parâmetros.',
    'aps.catalog.buttonInstallDescription' => 'Instalar a app num site se já tiver um código de ativação, ou caso queira testá-la.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Instalar esta app gratuita num site.',
    'aps.catalog.version' => 'Versão',
    'aps.catalog.moreVersions' => 'Mais versões',
    'aps.catalog.release' => 'Revisão',
    'aps.catalog.overview' => 'Visão Geral',
    'aps.catalog.noApplicationsInCategory' => 'Não há aplicações disponíveis nesta categoria. Selecione outra categoria.',
    'aps.catalog.noCategoriesSelected' => 'Selecione uma categoria para pesquisas todas as aplicações disponíveis nesta categoria.',
    'aps.catalog.noSearchResults' => 'Sem resultados para a sua pesquisa por apps.',
    'aps.catalog.connectionFailed' => 'Falha ao ligar ao Catálogo de Aplicações. %%retryLink%%.',
    'aps.catalog.retry' => 'Repetir',
    'aps.catalog.categoriesError' => 'Lista de categorias não pode ser carregada no momento.',
    'aps.catalog.applicationsError' => 'Lista de aplicações não pode ser carregada no momento.',
    'aps.catalog.detailsError' => 'Detalhes de aplicação não podem ser carregados no momento.',
    'aps.catalog.searchError' => 'Resultados das pesquisas não podem ser carregados no momento.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Lançamento %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Histórico das modificações',
    'aps.catalog.officialApplicationSite' => 'Informações do Vendedor',
    'aps.catalog.returnToCategories' => '<< Retornar para a lista de aplicações',
    'aps.catalog.buttonUninstall' => 'Eliminar',
    'aps.catalog.gotoHome' => 'Início',
    'aps.catalog.all' => 'Todas',
    'aps.catalog.buttonDetails' => 'Aprender mais',
    'aps.catalog.buttonBuy' => 'Compre agora',
    'aps.catalog.buttonBuyTooltip' => 'Compre a app',
    'aps.catalog.buttonBuyDescription' => 'Visite nossa loja para comprar um código de ativação para a app.',
    'aps.catalog.buttonDownload' => 'Descarregar',
    'aps.catalog.buttonDownloadDescription' => 'Descarregar a app se já tiver um código de ativação, ou caso queira testá-la.',
    'aps.catalog.marketplaceMoreInfo' => 'Para mais informações, visite %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'o site do vendedor da app.',

    'aps.configure.installedAt' => "Instalado em",
    'aps.configure.otherSettings' => "Outros",
    'aps.configure.globalSettings' => 'Definições de pacote',
    'aps.configure.passwordConfirmation' => 'Confirmar a palavra-passe',
    'aps.configure.databaseParams' => 'Parâmetros da base de dados',
    'aps.configure.noInstallationUrlAvailable' => 'Nenhum (app externo)',
    'aps.configure.updateSettingsSection' => 'Definições de Atualização',
    'aps.configure.forceUpdates' => 'Atualizar automaticamente esta app quando atualizações estiverem disponíveis',
    'aps.configure.forceUpdatesHint' => 'A app receberá atualizações automáticas para novas versões. Atenção: Utilize esta opção com cuidado, pois atualizações podem afetar a funcionalidade da app de forma significativa. Por exemplo, extensões da app podem parar de funcionar com outra versão da mesma.',

    'aps.install.showAllSettings' => 'Mostrar Todas as Definições',
    'aps.install.showLessSettings' => 'Mostrar Poucas Definições',
    'aps.install.install' => 'Instalar',
    'aps.install.otherSettings' => 'Outras definições',
    'aps.install.globalSettings' => 'Definições de pacote',
    'aps.install.passwordConfirmation' => 'Confirmar a palavra-passe',
    'aps.install.provisionsSectionLabel' => 'Caminho para instalação',
    'aps.install.context' => 'Especificar o local onde esta aplicação da web deverá ser instalada',
    'aps.install.registerAsWebmailSection' => 'Registo do webmail',
    'aps.install.registerAsWebmailDescription' => "Selecione esta opção se a app for um cliente de webmail. Isto fará com que a app apareça entre os serviços de webmail disponíveis nas definições de Correio das assinaturas e planos de serviços. O administrador pode configurar a URL de acesso público do webmail em Gestão do Servidor > Definições >Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Registar como um serviço de webmail',
    'aps.install.addItem' => 'Adicionar',
    'aps.install.removeItem' => 'Eliminar',
    'aps.install.updateSettingsSection' => 'Definições de Atualização',
    'aps.install.forceUpdates' => 'Atualizar automaticamente esta app quando atualizações estiverem disponíveis',
    'aps.install.forceUpdatesHint' => 'A app receberá atualizações automáticas para novas versões. Atenção: Utilize esta opção com cuidado, pois atualizações podem afetar a funcionalidade da app de forma significativa. Por exemplo, extensões de app podem parar de funcionar com outra versão da mesma.',

    'aps.invalid-requirements.requirementsLegend' => 'Requisitos',
    'aps.invalid-requirements.domainLegend' => 'Página web',
    'aps.invalid-requirements.context' => 'Escolher outro site',
    'aps.invalid-requirements.backToApplicationList' => 'Retornar para a lista de aplicações',

    'aps.license.title' => 'Instalação do %%%packageName%%%',
    'aps.license.doYouAcceptLicense' => 'Para instalar esta aplicação, leia o contrato de licença do utilizador final e concorde com seus termos.',
    'aps.license.licenseAgree' => 'Eu aceito os temos do Contrato de Licença.',

    'aps.services-list-customization.settings' => 'Configurações',

    'asp-dot-net.change-version.frameworkVersion' => 'Versão do ASP.NET framework',

    'asp-dot-net.settings.casSettingsSection' => "Segurança de acesso ao código",
    'asp-dot-net.settings.clientScriptsSection' => "Configurações da biblioteca de script",
    'asp-dot-net.settings.connStringsSection' => "Administrador da string de ligação",
    'asp-dot-net.settings.customErrorsSection' => "Configurações personalizadas de erro",
    'asp-dot-net.settings.frameworkVersionSection' => "Versão do Framework",
    'asp-dot-net.settings.globalizationSection' => "Configurações globais",
    'asp-dot-net.settings.otherSection' => "Configurações da sessão",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Compilação e debugging",
    'asp-dot-net.settings.authMode' => "Modo de autenticação",
    'asp-dot-net.settings.connStrings' => "String de ligação",
    'asp-dot-net.settings.connStringsInvalid' => "Alguns campos estão vazios ou contêm valores impróprios.",
    'asp-dot-net.settings.connStringName' => "Nome",
    'asp-dot-net.settings.connStringValue' => "Parâmetros de ligação",
    'asp-dot-net.settings.culture' => "Cultura",
    'asp-dot-net.settings.customErrMode' => "Modo de erro personalizado",
    'asp-dot-net.settings.customErrorRedirect' => "Redirecionar o URL",
    'asp-dot-net.settings.customErrorStatus' => "Código do Estado",
    'asp-dot-net.settings.customErrorStatusInvalid' => "O código de estado deve ser um número inteiro.",
    'asp-dot-net.settings.customErrors' => "Erros personalizados",
    'asp-dot-net.settings.customErrorsInvalid' => "Alguns campos estão vazios ou contêm valores impróprios.",
    'asp-dot-net.settings.debugMode' => "Ligar debugging",
    'asp-dot-net.settings.defLanguage' => "Linguagem predefinida da página",
    'asp-dot-net.settings.tempDirectory' => "Diretório temporário",
    'asp-dot-net.settings.fileEnc' => "Codificação de ficheiro",
    'asp-dot-net.settings.fileEncInvalid' => "O valor especificado para o parâmetro de codificação do Ficheiro é inválido.",
    'asp-dot-net.settings.pathToLib' => "Atalho para a biblioteca de script da Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Instalar",
    'asp-dot-net.settings.reqEnc' => "Codificação do pedido",
    'asp-dot-net.settings.reqEncInvalid' => "O valor especificado para o parâmetro de codificação do Pedido é inválido.",
    'asp-dot-net.settings.resEnc' => "Codificação da resposta",
    'asp-dot-net.settings.resEncInvalid' => "O valor especificado para o parâmetro de codificação da Resposta é inválido.",
    'asp-dot-net.settings.sessTimeout' => "Tempo limite da sessão (minutos)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "O valor especificado para o parâmetro de tempo limite da Sessão é inválido. Insira um número inteiro positivo menor ou igual a %%max%%.",
    'asp-dot-net.settings.trustLevel' => "Nível de confiança CAS",
    'asp-dot-net.settings.uiCulture' => "Cultura UI",
    'asp-dot-net.settings.version' => "Versão",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Permitir a substituição do nível de confiança CAS no site',
    'asp-dot-net.settings.addConnStrings' => 'Adicionar string de ligação',
    'asp-dot-net.settings.addCustomErrors' => 'Adicionar erro personalizado',
    'asp-dot-net.settings.buttonRemove' => 'Eliminar',

    'database.clone.formDescription' => 'Copiar conteúdos da base de dados para uma base de dados nova ou existente. Quando forem copiadas para uma base de dados existente, as tabelas da base de dados existente são adicionadas à lista de tabelas da base de dados de destino. Aviso: Se os nomes das tabelas coincidirem, a tabela fonte irá substituir a tabela no destino.',
    'database.clone.copyData' => 'Criar uma cópia completa',
    'database.clone.copyDataHint' => 'Se estiver selecionada, a base de dados será inteiramente copiada (incluindo a estrutura e dados). Se estiver desmarcada, somente a estrutura das tabelas serão copiadas.',
    'database.clone.server' => 'Servidor da base de dados de destino',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Outros...',
    'database.clone.database' => 'Destino da base de dados',
    'database.clone.newDatabase' => 'Criar base de dados com nome',
    'database.clone.existingDatabase' => 'Copiar para base de dados existente',
    'database.clone.externalDbHost' => 'Nome de Host ou endereço IP',
    'database.clone.externalDbLogin' => 'Nome de utilizador',
    'database.clone.externalDbPassword' => 'Palavra-passe',
    'database.clone.subscription' => 'Assinatura de destino',
    'database.clone.subscription_powerUser' => 'Espaço na rede de destino',
    'database.clone.cloneInProgress' => 'A replicar a %%source%% base de dados para a %%destination%% base de dados. Será notificado do progresso através de e-mail (%%email%%).',
    'database.clone.unableToClone' => 'Impossível copiar a base de dados "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Impossível criar uma base de dados "%%destination%%" no servidor especificado.',
    'database.clone.databaseCloned' => 'A base de dados "%%source%%" foi copiada.',
    'database.clone.emailSubjSuccess' => 'A base de dados "%%sourceDatabase%%" foi copiada.',
    'database.clone.emailSubjFailure' => 'Falha ao copiar a base de dados "%%sourceDatabase%%".',
    'database.clone.emailBodySuccess' => 'A base de dados "%%sourceDatabase%%" (%%sourceHost%%) foi copiada para a base de dados "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Impossível copiar a base de dados "%%sourceDatabase%%" (%%sourceHost%%) para a base de dados "%%destDatabase%%" (%%destHost%%). Falha ao copiar.',
    'database.clone.localServer' => 'servidor local',

    'database.repair-orphaned.formDescription' => 'Este utilizador ficou órfão após o processo de reposição. Por favor, forneça a senha para este utilizador de modo a resolver o problema. Se este utilizador tiver que ser um utilizador do sistema sem palavra-passe, execute o utilitário de reparação com o campo de palavra-passe vazio.',
    'database.repair-orphaned.login' => 'Nome de utilizador da base de dados',
    'database.repair-orphaned.pass' => 'Palavra-passe',
    'database.repair-orphaned.pass2' => 'Confirmar palavra-passe',
    'database.repair-orphaned.users' => 'Alguns utilizadores necessitam da sua atenção. Existem alguns utilizadores órfãos que devem ser reparados para funcionar convenientemente.',
    'database.repair-orphaned.orphaned' => 'O utilizador está órfão. %%gui begin:link%%Reparar agora%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Reparar',

    'database.repair.fixSelected' => 'Reparar seleção',
    'database.repair.fix' => 'Reparar',

    'database.user.password' => 'Palavra-passe',
    'database.user.passwordConfirmation' => 'Confirmar a palavra-passe',
    'database.user.server' => 'Servidor da base de dados',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Base de dados',
    'database.user.anyDatabase' => 'Qualquer',
    'database.user.dataAccess' => 'Acesso a dados',
    'database.user.structureAccess' => 'Acesso de estrutura',
    'database.user.globalAccess' => 'Privilégios globais',
    'database.user.globalAccessHint' => 'Os privilégios globais servem para todas as bases de dados nesta conta de alojamento.',
    'database.user.aclRadio' => 'Controle de acesso',
    'database.user.aclLocalhost' => 'Permitir apenas ligações locais',
    'database.user.aclAny' => 'Permitir ligações remotas de qualquer host',
    'database.user.aclCustom' => 'Permitir ligações remotas de',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOs hosts especificados podem aceder a base de dados para este utilizador.",
    'database.user.remoteAccess' => 'Acesso remoto',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nOs endereços IP especificados podem aceder à base de dados para este utilizador. As alterações realizadas nesta lista serão pré-moderadas pelo seu fornecedor do alojamento.",
    'database.user.example' => "Por exemplo:\n%%example%%",
    'database.user.denied' => 'Utilizar as regras da firewall do sistema',
    'database.user.allowed' => 'Permitir ligações remotas de',
    'database.user.default' => 'Utilizar as credenciais deste utilizador como pré-definição para acesso a %%webadmin%%',
    'database.user.remoteAccessHint' => 'Contacte o fornecedor do alojamento e certifique-se de que a opção especificada acima está de acordo com as regras atuais da firewall para solicitações de acesso ao MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.myLittleAdmin' => 'myLittleAdmin',
    'database.user.webAdmin' => 'Admin Web',
    'database.user.role' => 'Função',
    'database.user.roleReadWrite' => 'Ler e gravar',
    'database.user.roleWriteOnly' => 'Unicamente gravação',
    'database.user.roleReadOnly' => 'Só de leitura',
    'database.user.roleCustom' => 'Personalizado',

    'database.generalSection' => 'Geral',
    'database.name' => 'Nome da base de dados',
    'database.server' => 'Servidor da base de dados',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Sítio relacionado',
    'database.noDomainRelations' => 'Sem sítios relacionados',
    'database.userSection' => 'Utilizadores',
    'database.userSectionDescription' => 'Criar um utilizador padrão da base de dados. O Plesk acederá à base de dados para este utilizador. Caso nenhum utilizador tenha sido atribuído a esta base de dados, ela não está acessível.',
    'database.createUser' => 'Criar um utilizador da base de dados',
    'database.username' => 'Nome do utilizador de base de dados',
    'database.password' => 'Palavra-passe',
    'database.passwordConfirmation' => 'Confirmar a palavra-passe',
    'database.allDbAccess' => 'O utilizador possui acesso a todas as bases de dados na subscrição selecionada',
    'database.aclRadio' => 'Controle de acesso',
    'database.aclLocalhost' => 'Permitir apenas ligações locais',
    'database.aclAny' => 'Permitir ligações remotas de qualquer host',
    'database.aclCustom' => 'Permitir ligações remotas de',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOs hosts especificados podem aceder à base de dados para este utilizador.",
    'database.remoteAccess' => 'Acesso remoto',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nOs endereços IP especificados podem aceder à base de dados para este utilizador. As alterações realizadas a esta lista serão pré-moderadas por seu provedor de alojamento.",
    'database.example' => "Por exemplo:\n%%example%%",
    'database.denied' => 'Utilizar as regras da firewall do sistema',
    'database.allowed' => 'Permitir ligações remotas de',

    'deployment-section.deploymentDisabledHint' => 'Carregar ficheiros a partir do repositório Git',
    'deployment-section.deploymentEnabledHint' => 'Ativar o suporte Git',
    'deployment-section.deploymentSectionLegend' => 'Os seus ficheiros a copiar para o alojamento.',
    'deployment-section.deploymentSectionDescriptionHint' => 'Se deixar o suporte Git desativado, os diretórios de raiz (sítio de rede/raiz de aplicação e de documentos) serão criados vazios e os site apresentará a página predefinida no navegador. Terá de carregar os ficheiros do seu site para a raiz de documentos utilizando o FTP ou Gestor de Ficheiros. Em alternativa, ative o Git agora ou mais tarde (em sítios de rede e domínios) e carregue os ficheiros de um repositório Git.',

    'dns-zone.acl-record.addIpHint' => 'Adicionar um endereço IP de um servidor DNS que pode receber uma cópia da zona DNS.',
    'dns-zone.acl-record.ipAddress' => 'Endereço IP',
    'dns-zone.acl-record.ipAddressWithMask' => 'Endereço/máscara IP',
    'dns-zone.acl-record.ipAddressDescription' => "Por exemplo, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.acl-record.ipAddressWithMaskDescription' => "Por exemplo, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.acl-record.addIpButton' => 'Adicionar Endereço IP',

    'dns-zone.record.type' => "Tipo de registo",
    'dns-zone.record.domainName' => "Nome de domínio",
    'dns-zone.record.nameServer' => "Servidor de nome",
    'dns-zone.record.protocol' => "Protocolo",
    'dns-zone.record.priority' => "Prioridade",
    'dns-zone.record.priorityLow' => "baixa (%%priority%%)",
    'dns-zone.record.priorityHigh' => "muito alta (%%priority%%)",
    'dns-zone.record.weightLow' => "baixo (%%weight%%)",
    'dns-zone.record.weightHigh' => "muito alto (%%weight%%)",
    'dns-zone.record.ipAddress' => "Endereço IP",
    'dns-zone.record.ipAddressDescription' => "Por exemplo, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Endereço IPv6",
    'dns-zone.record.ipAddressV6Description' => "Por exemplo, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Por exemplo, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Por exemplo, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Insira um nome canónico",
    'dns-zone.record.mailDomain' => "Domínio do e-mail",
    'dns-zone.record.mxServer' => "Servidor exchange de e-mail",
    'dns-zone.record.mxServerPriority' => "Especifique a prioridade do servidor de troca de e-mail",
    'dns-zone.record.txtRecord' => "Insira um registo TXT",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Valores incorretos especificados para o registo TXT.",
    'dns-zone.record.dsRecord' => "Registo DS",
    'dns-zone.record.dsRecordDescription' => "Por exemplo, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "Foi definido um valor incorreto para o registo DS.",
    'dns-zone.record.serviceName' => "Nome do serviço",
    'dns-zone.record.serviceNameDescription' => "Exemplo: SIP",
    'dns-zone.record.srvWeight' => "Peso relativo para registos com a mesma prioridade",
    'dns-zone.record.targetHost' => "Host alvo",
    'dns-zone.record.targetHostDescription' => "Exemplo: exemplo.com",
    'dns-zone.record.targetPort' => "Porta alvo",
    'dns-zone.record.retrieveDataError' => "Os dados do registo não foram encontrados.",
    'dns-zone.record.unknownTypeError' => "Tipo de registo DNS desconhecido.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Não é possível configurar o registo MX NULL enquanto outros registos MX estiverem presentes.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Não é possível configurar o registo MX não-NULL enquanto o registo NULL MX estiver presente.',
    'dns-zone.record.masterShouldBeRemote' => "Deve ter dois servidores de nomes oficiais diferentes em anfitriões separados.",
    'dns-zone.record.caaTag' => "Etiqueta",
    'dns-zone.record.caaRecord' => "Valor",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.invalidValue' => 'O valor é inválido. Pode ser entre 1 segundo e 2147483647 segundos.',
    'dns-zone.record.ttlDefaultValue' => 'Valor predefinido: %%value%% segundos',

    'dns-zone.restore-default.formHint' => "Aqui é possível restaurar a configuração da zona original de acordo com as configurações predefinidas do modelo de DNS utilizado no servidor. Selecione os endereços IP a serem utilizados para restaurar a zona e especificar se o prefixo www é necessário para o domínio.",
    'dns-zone.restore-default.ipv4' => "Endereço IPv4",
    'dns-zone.restore-default.ipv4Hint' => "Por exemplo, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Endereço IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Por exemplo, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'O endereço IP especificado é inválido.',
    'dns-zone.restore-default.customIpHint' => "Registos com este endereço IP serão considerados como alterados pelo cliente e não serão sincronizados com o modelo de DNS do servidor.",
    'dns-zone.restore-default.wwwPrefix' => "Prefixo WWW",
    'dns-zone.restore-default.previewRecords' => "Restaurar os registos utilizados na pré-visualização de sítio",

    'dns-zone.soa-record.soaMnameSection' => 'Nome do servidor principal',
    'dns-zone.soa-record.soaMname' => 'Servidor do nome',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Seleção automática)',
    'dns-zone.soa-record.soaRecordSection' => 'Registo SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Atualizar',
    'dns-zone.soa-record.retry' => 'Repetir',
    'dns-zone.soa-record.expire' => 'Expira',
    'dns-zone.soa-record.minimum' => 'Mínimo',
    'dns-zone.soa-record.invalidValue' => 'O valor é inválido. Pode ser de 1 segundo a 68 anos.',
    'dns-zone.soa-record.serialNumberFormatSection' => 'Formato do número de série da zona DNS',
    'dns-zone.soa-record.serialNumberFormatText' => 'A utilização do formato do número de série recomendado pela IETF e RIPE pode resolver situações de recusa do registo e é obrigatório em muitos domínios registados em zonas DNS de alto nível.',
    'dns-zone.soa-record.serialNumberFormat' => 'Utilizar o formato do numero de série recomendado pela IETF e RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Utilizar diferentes formatos do número de série pode provocar um atraso na atualização da zona DNS',
    'dns-zone.soa-record.restoreDefaultButton' => 'Utilizar as Configurações Predefinidas',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Predefinições de zona',

    'domain-info-section.domainName' => 'Nome do domínio',
    'domain-info-section.emptyDomainName' => 'Por favor, introduza um domínio.',
    'domain-info-section.ipAddress' => 'Endereço IP',
    'domain-info-section.shared' => 'partilhado',
    'domain-info-section.exclusive' => 'dedicado',
    'domain-info-section.ipAddressHint' => "O endereço IP no qual o site está hospedado é um endereço de rede do host virtual do site. O endereço IP será utilizado para todos os sites criados numa assinatura.",
    'domain-info-section.ipAddressHint_powerUser' => "O endereço IP no qual o site está hospedado é um endereço de rede do host virtual do site. O endereço IP será utilizado para todos os sites criados no espaço na rede.",
    'domain-info-section.userName' => 'Nome de utilizador',
    'domain-info-section.userNameHint' => 'Conta de utilizador do sistema associada ao espaço de rede usada para aceder a ficheiros alojados através de FTP e SSH.',
    'domain-info-section.emptyLogin' => 'Por favor, introduza um nome de utilizador.',
    'domain-info-section.password' => 'Palavra-passe',
    'domain-info-section.emptyPassword' => 'Por favor, introduza uma palavra-passe.',
    'domain-info-section.passwordConfirmation' => 'Repetir a palavra-passe',

    'email-address.generalTab' => 'Geral',
    'email-address.generalHint' => 'Se esta conta de e-mail estiver associada a um utilizador adicional (acesso ativado ao Painel de Cliente) as alterações que realizar nesta página afetarão as definições deste utilizador. Em particular, se alterar o endereço de email e a palavra-chave, o registo e a palavra-chave do utilizador adicional será igualmente alterado para os novos valores.',
    'email-address.redirectTab' => 'Redirecionamento',
    'email-address.redirectHint' => 'Configure o reencaminhamento de mensagens de e-mail para um ou mais endereços de e-mail.',
    'email-address.aliasesTab' => 'Nomes alternativos de E-mail',
    'email-address.autoResponderTab' => 'Resposta automática',
    'email-address.antispamTab' => 'Filtro de Spam',
    'email-address.autoResponderHint' => 'Defina uma resposta automática para qualquer mensagem enviada pelo seu endereço de e-mail. A resposta automática é uma maneira padrão de notificar seus correspondentes de que você está fora do escritório ou está de férias.',
    'email-address.antivirusTab' => 'Antivírus',
    'email-address.name' => 'Endereço de e-mail',
    'email-address.externalEmail' => 'Endereço de e-mail externo',
    'email-address.externalEmailHint' => 'Será utilizada para redefinir a sua palavra-passe se perder o acesso ao endereço de e-mail principal.',
    'email-address.user' => 'Atribuído a',
    'email-address.password' => 'Palavra-passe',
    'email-address.passwordConfirmation' => 'Confirmar a palavra-passe',
    'email-address.responderEnable' => 'Ativar a resposta automática',
    'email-address.responderSubject' => 'Assunto da mensagem de resposta automática',
    'email-address.responderContentType' => 'Formato da mensagem',
    'email-address.responderContentTypeHint' => 'O formato de texto simples tem suporte em todos os programas de cliente de correio, e todos os destinatários visualizarão a mesma mensagem da mesma forma que você. As mensagens em HTML são visualmente melhores porque você permite que textos formatos com estilos de fontes diferentes sejam utilizados. No entanto, alguns clientes de e-mail não suportam mensagens de HTML e alguns destinatários podem não visualizar o texto formatado.',
    'email-address.responderContentTypeTextPlain' => 'Texto',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Codificação',
    'email-address.responderCodepageHint' => 'A codificação define como os carateres de texto serão exibidos. A codificação recomendada é UTF-8.',
    'email-address.responderReplyTo' => 'Enviar para',
    'email-address.responderReplyToHint' => 'Quando a resposta automática é enviada, a mensagem original será encaminhada para o endereço de e-mail especificado.',
    'email-address.responderForwardAddress' => 'Enviar para',
    'email-address.responderForwardAddressHint' => 'Quando a resposta automática é enviada, a mensagem original será encaminhada para o endereço de e-mail especificado.',
    'email-address.responderMessage' => 'Texto da mensagem de resposta automática',
    'email-address.responderReplyToEqualsEmail' => 'O endereço de encaminhamento especificado é igual ao endereço de e-mail.',
    'email-address.responderForwardAddressEqualsEmail' => 'O endereço de encaminhamento especificado é igual ao endereço de e-mail.',
    'email-address.responderReplyLimit' => 'Enviar uma resposta automática para um endereço de e-mail exclusivo não mais do que (vezes por dia)',
    'email-address.buttonAddResponderAttachment' => 'Adicionar anexo',
    'email-address.buttonRemoveResponderAttachment' => 'Eliminar',
    'email-address.responderAttachment' => 'Anexar um ficheiro',
    'email-address.redirectEnable' => 'Ativar o encaminhamento de e-mail',
    'email-address.redirectRemoveEnable' => 'Não entregar cópias de e-mails reencaminhados na caixa de correio do Plesk',
    'email-address.redirectAddress' => 'Mensagens encaminhadas para o endereço de e-mail a seguir',
    'email-address.redirectAddressHint' => 'Especificar endereços de e-mail. Pode digitar cada endereço numa nova linha ou separar endereços por espaços em branco, vírgulas ou ponto e vírgula.',
    'email-address.role' => 'Função do utilizador',
    'email-address.roleHint' => 'As funções de utilizador garantem privilégios administrativos aos utilizadores e acessos a aplicações que você selecionou para a função.',
    'email-address.errorRedirectAddress' => 'Especificou um endereço de email inválido: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Especificou endereços de email inválidos: %value%.',
    'email-address.mailAlias' => "Nomes alternativos de e-mail",
    'email-address.mailAliasNone' => 'Nenhum',
    'email-address.mailAliasHint' => "Nomes alternativos de e-mail são endereços de e-mail alternativos associados a um endereço de e-mail primário. Todo o conteúdo enviado para nomes alternativos de e-mail será recebido pelo endereço de e-mail primário.",
    'email-address.buttonAddMailAlias' => 'Adicionar nome alternativo de e-mail',
    'email-address.buttonRemoveMailAlias' => 'Eliminar',
    'email-address.emptyEmail' => 'Especificar o endereço de e-mail para o qual todas as mensagens recebidas deverão ser encaminhadas.',
    'email-address.emailsIsEqual' => 'O endereço de e-mail externo corresponde ao principal. Especifique um endereço de e-mail externo diferente.',
    'email-address.emptyPassword' => 'É necessário fornecer uma palavra-passe.',
    'email-address.emptyPasswordConfirmation' => 'É necessário confirmar a palavra-passe.',
    'email-address.emptyAlias' => "Especificar nome alternativo de e-mail para este endereço de e-mail.",
    'email-address.aliasEqualsEmail' => 'O nome alternativo do e-mail especificado é igual ao endereço de e-mail.',
    'email-address.passwordHint' => 'Será utilizada para aceder à caixa de correio e para entrar no Plesk (se a respetiva opção estiver ativada).',
    'email-address.cyclicRedirect' => 'O endereço de e-mail não pode ser definido para encaminhar mensagens para si mesmo.',
    'email-address.errorMailnameReserved' => 'O endereço de e-mail especificado já está a ser utilizado.',
    'email-address.antivirusEnable' => 'Ativar a proteção antivírus para este endereço de e-mail',
    'email-address.antivirusHint' => 'O serviço de antivírus bloqueia as mensagens de e-mail que contêm vírus e notifica o remetente e destinatário da mensagem.',
    'email-address.antivirusSettings' => 'Verificar vírus',
    'email-address.antivirusSettingOnlyIncomingMail' => 'só correio a entrar',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'só correio a sair',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'correio a entrar e a sair',
    'email-address.antispamHint' => 'O serviço de filtragem de spam exclui mensagens enviadas para o endereço de e-mail. Você pode definir o filtro de spam para excluir mensagens, marcá-las como spam alterando o seu assunto, ou movê-las para uma pasta de spam específica e acessível para clientes de correio através do IMAP. O filtro de spam utiliza um ampla variedade de testes de rede e locais para identificar assinaturas de spam.',
    'email-address.antispamEnable' => 'Ativar a filtragem de spam para este endereço de e-mail',
    'email-address.antispamSettings' => 'O que fazer com mensagens classificadas como spam',
    'email-address.antispamSettingsMark' => 'Marque mensagens como sendo spam adicionando o texto seguinte ao assunto da mensagem',
    'email-address.antispamSettingsMarkHint' => 'Deixe este campo em branco se não quiser adicionar texto. Insira _SCORE_ se quiser incluir a avaliação no assunto da mensagem.',
    'email-address.antispamReportTextHint' => 'Digite o texto que quer adicionar aos corpos de mensagem de e-mail de spam.',
    'email-address.antispamSettingsDelete' => 'Excluir todas as mensagens de spam',
    'email-address.antispamSettingsDeleteHint' => 'Mensagens de spam serão excluídas da sua caixa de correio.',
    'email-address.antispamSettingsMove' => 'Mova o spam para a pasta Spam',
    'email-address.antispamSettingsMoveHint' => 'Mova todas as mensagens de spam para a pasta chamada Spam. Esta pasta é acessível a partir do seu cliente de correio ou webmail. Se estiver a utilizar uma conta de correio IMPA, você pode utilizar a pasta de Spam para fazer testes com o filtro de spam.',
    'email-address.antispamSettingsMoveWarning' => '"Mover o spam para a pasta de Spam" não funciona a menos que desative a opção "Não entregar cópias de e-mails reencaminhados" no separador "Reencaminhamento".',
    'email-address.antispamSettingsMoveJunk' => 'Mover spam para a pasta "Lixo eletrónico"',
    'email-address.antispamSettingsMoveJunkHint' => 'Mover todas as mensagens de spam para a pasta "Lixo eletrónico"Esta pasta é acessível a partir do seu cliente de correio ou webmail. Se estiver a utilizar uma conta de e-mail IMAP, pode utilizar a pasta "Lixo Eletrónico" para treino do filtro de spam.',
    'email-address.antispamShowAdvancedSection' => 'Exibir Definições Avançadas',
    'email-address.antispamHideAdvancedSection' => 'Ocultar Definições Avançadas',
    'email-address.antispamLearnMore' => 'Aprenda como ajustar o filtro de spam.',
    'email-address.antispamFilterScoreTitle' => 'Sensibilidade do Filtro',
    'email-address.antispamFilterScoreHint' => 'O filtro spam faz diversos testes em conteúdo e linha de assunto de cada mensagem. O resultado atribui um número de pontos para cada mensagem. Quanto maior o número, maior a probabilidade de a mensagem ser um spam. Por padrão, a sensibilidade do filtro é definida para que todas as mensagens com 7 ou mais pontos sejam classificadas como spam. Se receber muitas mensagens de spam com a definição atual e queira deixar o filtro mais sensível, tente definir um valor menor, como 6. Se não estiver a receber e-mails porque o filtro de spam pensa que eles são spam, tenter reduzir a sensibilidade para um valor superior, como 8.',
    'email-address.antispamFilterScore' => 'Sensibilidade do filtro spam',
    'email-address.antispamWhiteListTitle' => 'Lista Branca',
    'email-address.antispamWhiteListHint' => 'Os e-mails de remetentes na lista branca não são verificados pelo filtro de spam.',
    'email-address.antispamWhiteListField' => 'Lista branca',
    'email-address.antispamWhiteListFieldHint' => 'Digite nomes de domínio, um nome de domínio por linha. Os endereços podem conter "*" e "?" como carateres universais (ex. *@dominio.com, utilizador? @*.com.',
    'email-address.antispamBlackListTitle' => 'Lista Negra',
    'email-address.antispamBlackListHint' => 'Os e-mails de remetentes na lista negra são classificados como spam.',
    'email-address.antispamBlackListField' => 'Lista negra',
    'email-address.antispamBlackListFieldHint' => 'Digite nomes de domínio, um domínio por linha. Os endereços podem conter "*" e "?" como carateres universais (ex. *@dominio.com, utilizador? @*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Idiomas de Confiança',
    'email-address.antispamTrustedLanguagesHint' => 'Mensagens de e-mail escritas nestes idiomas sempre passarão pelo filtro.',
    'email-address.antispamTrustedLocalesTitle' => 'Locales de Confiança',
    'email-address.antispamTrustedLocalesHint' => 'Mensagens de e-mail que utilizam os grupos locales especificados passarão sempre pelo filtro. Grupos locales incluem conjuntos para a maioria dos carateres utilizados. Por exemplo, um conjunto de carateres ocidentais inclui codificações para e-mails em inglês e em idiomas da Europa Ocidental.',
    'email-address.antispamTrustedNetworksTitle' => 'Redes de confiança',
    'email-address.antispamTrustedNetworksHint' => 'Os hosts de relay em redes confiáveis são considerados para não serem potencialmente operados por spammers, e não são relays abertos ou proxies abertos.',
    'email-address.antispamIpAddressesField' => 'Endereços IP',
    'email-address.antispamIpAddressesFieldHint' => 'Especificar endereço IP e máscara de rede.',
    'email-address.mailBoxQuotaDomainDefault' => 'Tamanho padrão (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Tamanho padrão',
    'email-address.mailBoxOutgoingMessages' => 'Número máximo de mensagens de e-mail enviadas',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Padrão (%%domainOutgoingMessages%% mensagens por hora)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Valor personalizado para a caixa de correio',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'mensagens',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Padrão',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Tamanho padrão',
    'email-address.mailBoxQuotaDomainSpecific' => 'Outro tamanho',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Tamanho da caixa de correio',
    'email-address.mailBoxQuotaUnlimited' => 'Ilimitado',
    'email-address.mailBoxLimitReached' => 'Foi alcançado o limite máximo de caixas de correio.',
    'email-address.postboxEnabled' => 'Caixa de Correio',
    'email-address.postboxEnabledYes' => 'Ligada',
    'email-address.postboxEnabledNo' => 'Desligada',
    'email-address.description' => 'Descrição no Plesk',
    'email-address.descriptionHint' => 'A descrição é visível para todos com acesso a essa conta de e-mail.',
    'email-address.longDescription' => 'A descrição especificada é muito longa. Não pode ser maior que %%max%% símbolos.',
    'email-address.loginAsUser' => 'Pode ser usado para iniciar sessão no Plesk',
    'email-address.loginAsUserDescription' => '(nome de utilizador: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'O tamanho da caixa de correio não pode exceder o tamanho padrão.',
    'email-address.endDateEnable' => 'Desativar resposta automática em',

    'failed-request.enable-tracing.description' => 'O rastreio das solicitações falhadas é uma operação intensiva a nível de recursos. O rastreio será interrompido automaticamente em %%days%% dias. Pode desativá-la manualmente a qualquer momento.',
    'failed-request.enable-tracing.statusCodes' => 'Códigos de estado',
    'failed-request.enable-tracing.statusCodesDescription' => 'Exemplo: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Fornecedor',

    'file-manager.show.buttonReload' => 'Recarregar',
    'file-manager.show.buttonSave' => 'Guardar',
    'file-manager.show.buttonSaveAs' => 'Guardar Como',
    'file-manager.show.buttonReset' => 'Reiniciar',
    'file-manager.show.buttonTextCodeEditor' => 'Editar no Editor de código',
    'file-manager.show.buttonTextEdit' => 'Editar no Editor de Texto',
    'file-manager.show.buttonWysiwygEdit' => 'Editar no Editor de HTML',
    'file-manager.show.eolLabel' => 'Tipo de quebra de linha:',
    'file-manager.show.saveAs' => 'Guardar como:',
    'file-manager.show.saveCodepage' => 'Guardar no seguinte código:',
    'file-manager.show.loadCodepage' => 'Ver o ficheiro original na seguinte codificação:',
    'file-manager.show.loadCodepageHint' => 'Atenção: As modificações que não forem guardadas serão perdidas ao recarregar o ficheiro.',
    'file-manager.show.fileExists' => "O ficheiro ou pasta %%fileName%% já existe. Não é possível gravar uma pasta ou ficheiro com o mesmo nome.",
    'file-manager.show.popupTitle' => 'Guardar Como',
    'file-manager.show.popupFilename' => 'Nome do ficheiro:',

    'file-manager.permissions.filePermissions' => 'Permissões dos ficheiros',
    'file-manager.permissions.directoryPermissions' => 'Permissões dos diretórios',
    'file-manager.permissions.buttonSubmit' => 'Gravar',
    'file-manager.permissions.buttonApply' => 'Guardar e retomar',
    'file-manager.permissions.buttonCancel' => 'Cancelar',
    'file-manager.permissions.buttonAdvanced' => 'Avançado',

    'file-manager.unix-file-permissions.group' => 'Grupo',
    'file-manager.unix-file-permissions.owner' => 'Proprietário',
    'file-manager.unix-file-permissions.others' => 'Outros',
    'file-manager.unix-file-permissions.readMode' => 'Ler',
    'file-manager.unix-file-permissions.writeMode' => 'Escrever',
    'file-manager.unix-file-permissions.execMode' => 'Executar/pesquisar',
    'file-manager.unix-file-permissions.changeRecursive' => 'Alterar permissões recursivamente',

    'file-manager.windows-permissions.allow' => 'Permitir',
    'file-manager.windows-permissions.deny' => 'Negar',
    'file-manager.windows-permissions.inheritFromParent' => 'Permitir autorizações hereditárias do principal para propagar a este objeto e todos os objetos secundários. Incluir estes com as entradas claramente definidas aqui',
    'file-manager.windows-permissions.replaceOnChildren' => 'Substituir entradas de autorização em todos sub-objectos pelas entradas exibidas aqui.',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avançado',
    'file-manager.windows-permissions.applyTo' => 'Aplicar a:',
    'file-manager.windows-permissions.folderOnly' => 'Só nesta pasta',
    'file-manager.windows-permissions.subfolderOnly' => 'Só subpasta',
    'file-manager.windows-permissions.filesOnly' => 'Só ficheiros',
    'file-manager.windows-permissions.permissionsFor' => 'Permissões para',
    'file-manager.windows-permissions.applyOnto1' => 'Só nesta pasta',
    'file-manager.windows-permissions.applyOnto2' => 'Só subpasta',
    'file-manager.windows-permissions.applyOnto3' => 'Esta pasta e sub-pastas',
    'file-manager.windows-permissions.applyOnto4' => 'Só ficheiros',
    'file-manager.windows-permissions.applyOnto5' => 'Esta pasta e ficheiros',
    'file-manager.windows-permissions.applyOnto6' => 'Só sub-pasta e ficheiros',
    'file-manager.windows-permissions.applyOnto7' => 'Esta pasta, sub-pastas, e ficheiros',
    'file-manager.windows-permissions.notInherited' => '<não foi herdado>',

    'file-manager.editor.titleTextEditor' => 'Editor de texto',
    'file-manager.editor.titleCodeEditor' => 'Editor de código',
    'file-manager.editor.titleCodeViewer' => 'Ver',
    'file-manager.editor.buttonSubmit' => 'Gravar',
    'file-manager.editor.buttonApply' => 'Guardar e retomar',
    'file-manager.editor.buttonSaveAs' => 'Guardar como ...',
    'file-manager.editor.buttonCancel' => 'Cancelar',
    'file-manager.editor.exitConfirmationYes' => 'Sim',
    'file-manager.editor.exitConfirmationNo' => 'Não',
    'file-manager.editor.fileOverwrite' => 'O ficheiro já existe.',
    'file-manager.editor.fileOverwriteDescription' => 'Já existe um ficheiro com o mesmo nome.Quer atualizar?',
    'file-manager.editor.exitConfirmation' => 'Tem a certeza de que pretende encerrar o ficheiro e ignorar as alterações não guardadas?',
    'file-manager.editor.buttonCodeEditor' => 'Editar no Editor de código',
    'file-manager.editor.buttonTextEditor' => 'Editar no Editor de Texto',
    'file-manager.editor.buttonHtmlEditor' => 'Editar no Editor de HTML',

    'file-manager.import-file.buttonSubmit' => 'Importar',
    'file-manager.import-file.fieldUrl' => 'URL para o ficheiro',
    'file-manager.import-file.fieldUrlDescription' => 'Especifique o URL de origem, por exemplo, \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'O padrão completo do URL é o seguinte: \'https://user:password@example.com/example.tgz\'. O nome de utilizador e a palavra-passe são opcionais. Os protocolos suportados são http, https, ftp, ftps. Utilize a codificação do URL para as partes do URL que contêm carateres especiais ou espaços.',
    'file-manager.import-file.failure' => 'Não é possível importar o ficheiro.',

    'file-manager.rotation-settings.title' => 'Definições de rotação da Reciclagem',
    'file-manager.rotation-settings.rotationBySize' => 'Rotação por tamanho',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'A opção elimina novos ficheiros desde que o limite especificado para a reciclagem seja excedido.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotação por data',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Dias',
    'file-manager.rotation-settings.rotationByDateHint' => 'A opção apaga ficheiro armazenados na reciclagem durante mais do que um número especificado de dias.',

    'ftp-user.description' => 'Caso esteja a trabalhar no site em conjunto com outra pessoa ou caso esteja a alojar subdomínios para outros utilizadores, é desejável criar contas de FTP separadas.',
    'ftp-user.generalSection' => 'Geral',
    'ftp-user.login' => 'Nome da subconta do FTP',
    'ftp-user.home' => 'Diretório inicial',
    'ftp-user.systemArea' => 'Criar uma conta de FTP com acesso a ficheiros fora do diretório inicial',
    'ftp-user.password' => 'Palavra-passe',
    'ftp-user.passwordConfirmation' => 'Confirmar a palavra-chave',
    'ftp-user.hardQuotaSection' => 'Quota de disco rígido',
    'ftp-user.hardQuota' => 'Quota de disco rígido',
    'ftp-user.hardQuotaUnlimited' => 'Ilimitado',
    'ftp-user.permissionsSection' => 'Autorizações',
    'ftp-user.permissionRead' => 'Autorização de leitura',
    'ftp-user.permissionWrite' => 'Autorização de escrita',
    'ftp-user.popupTitle' => 'Selecionar diretório',

    'mail-list.listName' => 'Endereço da lista de envio',
    'mail-list.enabled' => 'Ligada',
    'mail-list.administratorEmail' => 'E-mail do administrador da lista de envio',
    'mail-list.password' => 'Palavra-passe',
    'mail-list.passwordConfirmation' => 'Confirmar a palavra-passe',
    'mail-list.subscribers' => 'Assinantes',
    'mail-list.subscribersHint' => 'Especificar endereços de e-mail. Pode digitar cada endereço numa nova linha ou separar endereços pelos símbolos de espaço, vírgula ou ponto e vírgula.',
    'mail-list.notify' => 'Notificar o administrador da criação da lista de envio',
    'mail-list.emptyPassword' => 'Especificar uma senha.',
    'mail-list.emptyPasswordConfirmation' => 'Confirme a senha.',
    'mail-list.errorSubscribers' => 'Endereços de e-mail inválidos: %value%.',
    'mail-list.errorMaillistReserved' => 'O endereço da lista de envio especificado já está a ser utilizado.',

    'mail-settings.hint' => 'Aqui é onde altera as definições do serviço de correio para domínios.',
    'mail-settings.service' => 'Ativar o serviço de correio neste domínio',
    'mail-settings.nonExist' => 'E-mail para utilizador inexistente',
    'mail-settings.nonExistBounceWithMessage' => 'Devolver incluindo mensagem',
    'mail-settings.nonExistBounce' => 'Devoluções',
    'mail-settings.nonExistCatch' => 'Enviar para endereço determinado',
    'mail-settings.nonExistCatchDescription' => 'O endereço deve pertencer ao domínio selecionado. Apenas o administrador pode especificar um endereço externo ou um endereço para vários domínios.',
    'mail-settings.nonExistExternal' => 'Redirecionar para um servidor de correio externo com o endereço IP',
    'mail-settings.nonExistReject' => 'Rejeitar',
    'mail-settings.nonExistDiscard' => 'Rejeitar',
    'mail-settings.webmail' => 'Correio',
    'mail-settings.webmailNone' => 'Nenhum',
    'mail-settings.webmailComponentNotInstalled' => 'A componente de webmail não foi instalada.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Existe um subdomínio com o nome %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Certificado SSL/TLS para correio de rede',
    'mail-settings.webmailCertificateNone' => 'Não selecionado',
    'mail-settings.mailCertificate' => 'Certificado SSL/TLS para correio',
    'mail-settings.mailCertificateNone' => 'Não selecionado',
    'mail-settings.serverCertificateNotSelected' => 'O certificado foi atribuído, mas o correio do domínio não foi protegido. Para concluir a proteção de email para o domínio, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'proteger o servidor de correio',
    'mail-settings.mailLists' => 'Listas de envio disponíveis',
    'mail-settings.mailAutodiscovery' => 'Ativar deteção automática de e-mail.',
    'mail-settings.mailAutodiscoveryDescription' => 'Veja como funciona em %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'base de conhecimento',
    'mail-settings.domainKeys' => 'Utilize o sistema de proteção contra spam DKIM para assinar mensagens de e-mail enviadas',
    'mail-settings.greyListing' => 'Ligar a proteção de spam greylisting para todas as contas de correio neste domínio',
    'mail-settings.howToConfigureExternalDns' => 'Como configurar o DNS externo',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Para permitir iniciar sessão no DKIM se utilizar um servidor DNS externo, tem de configurar os registos DNS do DKIM no servidor DNS.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Para fazê-lo, utilize os registos DNS do DKIM abaixo:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Se tiver pseudónimos de domínio que utiliza para enviar e-mails, adicione também os registos DNS do DKIM para os mesmos. Utilize os mesmos registos que para o domínio principal, mas com o nome de pseudónimo de domínio.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Para ver os DNS do DKIM que tem de configurar, selecione a caixa de verificação "%%option%%", aplique-a e abra novamente este pop-up.',

    'role.roleSection' => 'Geral',
    'role.name' => 'Nome de função do utilizador',
    'role.description' => 'Descrição',
    'role.generalPermissionsSection' => 'Acesso aos serviços do Plesk',
    'role.applicationsAccessSection' => 'Acesso às apps',
    'role.permissionAllow' => 'Permitido',
    'role.permissionDeny' => 'Negado',
    'role.emptyRoleName' => 'Por favor, introduza um nome de função.',
    'role.installedAt' => 'Instalado em',
    'role.noInstallationUrlAvailable' => 'App externa',
    'role.invalidRoleName' => 'O nome de função do utilizador especificado não é válido. Pontos de interrogação e aspas não podem ser utilizados no nome de função.',
    'role.longRoleName' => 'O nome de função do utilizador especificado é muito longo.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Algumas operações podem não estar disponíveis pelos motivos seguintes: uma permissão para operação não é permitida para a assinatura atualmente selecionada, ou a quantidade de recursos alocados não é suficiente para realizar a operação.',
    'role.servicesPermissionsDescription' => 'Definir o acesso às aplicações ou aos serviços do Plesk instalados para todos os utilizadores com esta função. Se permitir que um utilizador tenha acesso a uma aplicação, ela estará disponível no Painel de Cliente.',
    'role.emailActivation' => 'Ativar as contas desta função por e-mail',

    'service.admin-access.adminAccess' => 'Acesso administrativo',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Estas credenciais serão utilizadas para acesso administrativo para esta aplicação.',
    'service.admin-access.login' => 'Nome de utilizador administrativo',
    'service.admin-access.password' => 'Palavra-passe administrativa',
    'service.admin-access.passwordConfirmation' => 'Confirmar a palavra-passe',

    'service.info.service-entry-point.availableAt' => 'Disponível em',
    'service.info.service-entry-point.customize' => 'Personalizar atalho',
    'service.info.service-entry-point.displayNameLabel' => 'Nome do atalho',
    'service.info.service-entry-point.displayNameDescription' => 'Fornecer um nome para este atalho. O nome é exibido abaixo do ícone de atalho. Atalhos são colocados nas páginas de Meus Serviços dos utilizadores que tem acesso permitido a esta aplicação.',
    'service.info.service-entry-point.descriptionLabel' => 'Descrição do atalho',
    'service.info.service-entry-point.descriptionDescription' => 'Fornecer uma descrição para este atalho. A descrição é exibida como uma dica de ferramenta quando o cursor do rato passa sobre o atalho.',
    'service.info.service-entry-point.iconLabel' => 'Clique para selecionar o ícone de atalho',
    'service.info.service-entry-point.iconCurrent' => 'Ícone atual',
    'service.info.service-entry-point.errorEmptyName' => 'É necessário fornecer um nome de atalho',
    'service.info.service-entry-point.errorLongName' => 'O nome do atalho deve ter entre 1 e 255 carateres.',
    'service.info.service-entry-point.errorLongDescription' => 'A descrição do atalho deve estar entre 0 e 255 carateres.',
    'service.info.service-entry-point.hiddenLabel' => 'Ocultar atalho',
    'service.info.service-entry-point.hiddenDescription' => 'Não exibir este atalho para utilizadores.',

    'service.info.service-permission.assignedUser' => "Permitir acesso do administrador a este utilizador",
    'service.info.service-permission.assignedUserNone' => 'Nenhum utilizador atribuído',

    'shared-ssl.master-ssl.switchedOn' => 'Ligar a partilha de SSL/TLS',
    'shared-ssl.master-ssl.domainName' => 'Nome de domínio de um site cujo certificado SSL/TLS será partilhado com outros sites',
    'shared-ssl.master-ssl.none' => 'Nenhum',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'O SSL/TLS partilhado não pode ser ligado porque não existem domínios com suporte SSL/TLS ativado.',

    'user.email.email' => 'Endereço de e-mail',
    'user.email.emptyEmail' => 'É necessário fornecer um endereço de e-mail.',
    'user.email.internalEmailHint' => 'Crie um novo endereço de e-mail no Plesk ou use um endereço de e-mail externo.',
    'user.email.longInternalEmail' => 'O endereço de e-mail é muito longo.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'A secção de nome de utilizador do endereço de correio eletrónico é demasiado longa para este servidor de correio eletrónico. Por favor indique um nome de utilizador com um limite de %%max%% símbolos.',
    'user.email.longInternalEmailFullAddressMailServer' => 'O endereço de correio eletrónico é demasiado longo para este servidor de correio eletrónico. Por favor indique um endereço com um limite de %%max%% símbolos.',
    'user.email.externalEmail' => 'Endereço de e-mail externo',
    'user.email.externalEmailHint' => 'Será utilizada para redefinir a sua palavra-passe se perder o acesso ao endereço de e-mail principal.',
    'user.email.emailsIsEqual' => 'O endereço de e-mail externo corresponde ao principal. Especifique um endereço de e-mail externo diferente.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Especifique um endereço de e-mail interno ou externo.',

    'user.profileSection' => 'Informações Gerais',
    'user.contactName' => 'Nome de contacto',
    'user.email' => 'Endereço de e-mail',
    'user.role' => 'Papel do utilizador',
    'user.accountSection' => 'Preferências do Plesk',
    'user.login' => 'Nome de utilizador',
    'user.password' => 'Palavra-passe',
    'user.buttonBack' => 'Anterior',
    'user.generalTab' => 'Geral',
    'user.applicationsAccessSection' => 'Serviços',
    'user.generalPermissionsSection' => 'Privilégios',
    'user.contactsTab' => 'Detalhes de Contacto',
    'user.passwordConfirmation' => 'Confirmar a palavra-passe',
    'user.internalEmailPasswordChanged' => 'Alterar a palavra-passe também irá alterar a palavra-passe do endereço de e-mail interno.',
    'user.emailName' => 'Endereço de e-mail',
    'user.emailType' => 'Tipo de e-mail',
    'user.companyName' => 'Nome da empresa',
    'user.phone' => 'Número de telefone',
    'user.imNumber' => 'Mensagens Instantâneas',
    'user.fax' => 'Número de fax',
    'user.address' => 'Morada',
    'user.city' => 'Cidade',
    'user.state' => 'Estado ou província',
    'user.zip' => 'Código Postal ou CEP',
    'user.country' => 'País',
    'user.additionalInfo' => 'Informação adicional',
    'user.additionalInfoHint' => 'Unicamente em texto: todas as etiquetas HTML serão ignoradas.',
    'user.language' => 'Língua do Plesk',
    'user.buttonChangePassword' => 'Alterar Palavra-passe',
    'user.permissionAllow' => 'Permitido',
    'user.permissionDeny' => 'Negado',
    'user.permissionInherited' => 'Definido pela função',
    'user.emptyContactName' => 'É necessário fornecer um nome de contacto.',
    'user.emptyLogin' => 'É necessário fornecer um nome de utilizador.',
    'user.emptyPassword' => 'É necessário fornecer uma palavra-passe.',
    'user.emptyPasswordConfirmation' => 'É necessário confirmar a palavra-passe.',
    'user.chooseDomainBoxTitle' => 'Selecione outro domínio:',
    'user.userIsActive' => 'Utilizador está ativo.',
    'user.userIsActiveHint' => 'os utilizadores ativos podem aceder ao Plesk.',
    'user.emailActivation' => 'Ativar conta por e-mail',
    'user.emailHint' => 'Para fornecer um endereço de e-mail alojado neste servidor para o utilizador, vá até ao separador Correio, crie um endereço de e-mail específico e associe-o a este utilizador.',
    'user.emailContactHint' => 'Contacte o seu fornecedor de serviços se quiser utilizar um endereço de e-mail alojado neste servidor.',
    'user.personalEmailHint' => "O endereço de e-mail do utilizador pode ser alterado no separador Correio.",
    'user.externalMailRedirectHint' => 'Encaminhamentos só podem ser ativados para endereços de e-mail alojados neste servidor. Para criar um endereço de e-mail, vá até ao separador Correio.',
    'user.externalMailRedirectHint2' => 'Encaminhamentos só podem ser ativados para endereços de e-mail alojados neste servidor.',
    'user.externalMailAutoResponderHint' => 'Respostas automáticas só podem ser ativadas para endereços de e-mail alojados neste servidor. Para criar um endereço de e-mail, vá até ao separador Correio.',
    'user.externalMailAutoResponderHint2' => 'Respostas automáticas só podem ser ativadas para endereços de e-mail alojados neste servidor.',
    'user.roleHint' => 'As funções de utilizador garantem privilégios administrativos aos utilizadores e acessos a aplicações que você selecionou para a função.',
    'user.cannotManageMail' => "Você não tem a permissão para gerir as configurações de correio e serviços.",
    'user.longCompanyName' => 'O nome da empresa especificado é muito longo.',
    'user.longPhone' => 'O número de telefone especificado é muito longo.',
    'user.longFax' => 'O número de fax especificado é muito longo.',
    'user.longAddress' => 'O endereço especificado é muito longo.',
    'user.longCity' => 'O nome da cidade especificado é muito longo.',
    'user.phoneRegexNotMatch' => 'O número de telefone especificado não é válido.',
    'user.faxRegexNotMatch' => 'O número de fax especificado não é válido.',
    'user.shortCity' => 'O nome da cidade especificado é muito curto.',
    'user.limitSubscription' => 'Acesso a assinaturas',
    'user.limitSubscriptionHint' => 'Permitir que utilizadores acedam apenas a uma assinatura específica. O valor "Todas" permite que acedam a todas as assinaturas na sua conta de alojamento.',
    'user.limitSubscriptionAll' => 'Todas',
    'user.deletedSubscription' => 'Assinatura removida',

    'web.add-domain-alias.title' => 'Adicionar um Nome alternativo de Domínio',
    'web.add-domain-alias.createdSuccessfully' => "Foi criado o nome alternativo de domínio %%name%%.",
    'web.add-domain-alias.domainAliasName' => 'Nome do nome alternativo de domínio',
    'web.add-domain-alias.domainAliasNameHint' => 'Por exemplo, example.net',
    'web.add-domain-alias.forDomain' => 'para o domínio',
    'web.add-domain-alias.settingsSectionLegend' => 'Configurações',
    'web.add-domain-alias.settingsDns' => 'Sincronizar a zona DNS com o domínio principal',
    'web.add-domain-alias.settingsMail' => 'Serviço de correio',
    'web.add-domain-alias.settingsWeb' => 'Serviço de rede',
    'web.add-domain-alias.settingsSeoRedirect' => 'Redirecionar com o código HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Ao abrir o URL do pseudónimo, os visitantes serão redirecionados para o URL do domínio principal. O Plesk utiliza o redirecionamento compatível HTTP 301, compatível com motores de pesquisa, o que significa que a classificação do motor de pesquisa não será dividida entre os URLs',
    'web.add-domain-alias.settingsTomcat' => 'Aplicações Java web',
    'web.add-domain-alias.invalidDomainGuid' => 'Domínio inválido',

    'web.add-domain.formTitle' => 'Adicionar Novo Domínio',
    'web.add-domain.formRegistrationHint' => 'Pode registar um novo nome de domínio no %%link%%.',
    'web.add-domain.portalLink' => 'Portal de serviços',
    'web.add-domain.domainName' => 'Nome do domínio',
    'web.add-domain.domainNameHint' => "Por exemplo, example.com",
    'web.add-domain.assignToCustomer' => 'Atribuir este domínio a um cliente',
    'web.add-domain.customer' => 'Selecionar um cliente',
    'web.add-domain.createNewCustomer' => 'Criar um novo cliente',
    'web.add-domain.selectExistingCustomer' => 'Selecione um cliente existente:',
    'web.add-domain.customerContactInfoHint' => 'Insira as informações de contato do cliente. É possível especificar posteriormente todas as outras informações, como número de telefone e endereço.',
    'web.add-domain.customerLoginInfoHint' => 'Credenciais para o painel do cliente',
    'web.add-domain.target' => 'Espaço na rede',
    'web.add-domain.createNewTarget' => 'Criar uma nova assinatura',
    'web.add-domain.createNewTarget_powerUser' => 'Criar um novo espaço na Web',
    'web.add-domain.selectExistingTarget' => 'Selecionar uma assinatura existente:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Selecione um espaço da web existente:',
    'web.add-domain.dns' => 'Ativar o serviço DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Ativar o serviço de correio',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Funciona se as configurações da assinatura permitirem administrar a permissão de e-mail por domínio. Se não permitirem, o estado real do serviço de email será obtido da assinatura.',
    'web.add-domain.hostingManagementOptions' => 'Tipo de alojamento',
    'web.add-domain.websiteHosting' => 'Alojamento da página Web',
    'web.add-domain.websiteForwarding' => 'Redirecionamento',
    'web.add-domain.websiteNoHosting' => 'Sem alojamento',
    'web.add-domain.hostingSettingsSectionLegend' => 'Definições de alojamento',
    'web.add-domain.domainCreatedSuccessfully' => 'O nome %%domainName%% foi criado com sucesso.',
    'web.add-domain.webspaceLegend' => 'Configurações do espaço de rede',
    'web.add-domain.addWhmWebsiteTitle' => 'Adicionando Novo Website',
    'web.add-domain.addWhmWebsiteHint' => "É possível alojar um website no servidor.",
    'web.add-domain.selectWhmDomain' => 'Selecione o domínio',
    'web.add-domain.customerLegend' => 'Informação de cliente',
    'web.add-domain.credentials' => 'Credenciais de sistema do utilizador',
    'web.add-domain.credentialsHint' => 'para aceder a ficheiros armazenados através de FTP e SSH',
    'web.add-domain.credentialsHintWin' => 'para aceder a ficheiros armazenados através de FTP e RDP',
    'web.add-domain.buttonAddDomain' => 'Adicionar um domínio',

    'web.add-subdomain.formTitle' => 'Adicionar um subdomínio',
    'web.add-subdomain.formGeneralHint' => 'Os subdomínios são endereços de internet para diferentes secções do seu website e utilizam o seu nome de domínio principal e um prefixo. Por exemplo, se o seu domínio é domain.com, um subdomínio poderá ser store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Poderá igualmente criar um subdomínio universal, introduzindo o símbolo * em vez do nome. Os visitantes do website serão redirecionados para este subdomínio, independentemente do nome do subdomínio introduzido no navegador.',
    'web.add-subdomain.subdomainName' => 'Nome de subdomínio',
    'web.add-subdomain.subdomainNameHint' => 'Introduzir * para criar um subdomínio universal.',
    'web.add-subdomain.forDomain' => 'Domínio principal',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'O subdomínio foi criado.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Definições de alojamento',

    'web.change-hosting.formGeneralHint' => 'Você pode escolher entre alojar um site no servidor (Alojamento de site), definir o encaminhamento web para outro site (Encaminhamento) ou utilizar a zona de DNS do domínio para que as caixas de correio fiquem sob o nome do domínio (Sem alojamento).',
    'web.change-hosting.changed' => 'O tipo de alojamento para %%domainName%% foi alterado com sucesso.',
    'web.change-hosting.hostingManagementOptions' => 'Tipo de alojamento',
    'web.change-hosting.websiteHosting' => 'Alojamento da página Web',
    'web.change-hosting.websiteForwarding' => 'Redirecionamento',
    'web.change-hosting.websiteNoHosting' => 'Sem alojamento web',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Definições de alojamento',
    'web.change-hosting.userName' => 'Nome de utilizador',
    'web.change-hosting.userNameHint' => 'Utilizador do sistema para gestão de ficheiros e pastas na assinatura.',
    'web.change-hosting.userNameHint_powerUser' => 'Utilizador do sistema para gestão de ficheiros e pastas no espaço na rede.',
    'web.change-hosting.emptyLogin' => 'É necessário especificar um nome de utilizador.',
    'web.change-hosting.password' => 'Palavra-passe',
    'web.change-hosting.emptyPassword' => 'É necessário especificar uma palavra-passe.',
    'web.change-hosting.passwordConfirmation' => 'Confirmar a palavra-passe',
    'web.change-hosting.warningInstalledApplications' => 'Aplicações da web estão instaladas no site. Se alterar o tipo de alojamento, elas não serão mais acessíveis.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'Atenção: O conteúdo do site será excluído.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'Gostaria de alterar o tipo de alojamento para o seu site?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'As seguintes pastas e todo o conteúdo serão eliminados:',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'Todo o conteúdo da pasta de raiz do espaço web será eliminado.',

    'web.change-status.changed' => 'O estado de site para %%domainName%% foi alterado com sucesso.',
    'web.change-status.statusManagementOptions' => 'O estado do site',
    'web.change-status.statusDisabled' => 'Desativado (anteriormente Suspenso)',
    'web.change-status.statusSuspended' => 'Suspenso',
    'web.change-status.statusActive' => 'Ativo',
    'web.change-status.statusDisabledHint' => 'O site não será mais alojado no servidor e estará indisponível, exceto pelos clientes FTP e a Gestão de Ficheiros. Visitantes visualizarão a página padrão do servidor da web. O serviço de correio está indisponível.',
    'web.change-status.statusSuspendedHint' => 'O site continuará alojado no servidor, mas os visitantes serão redirecionados com o código HTTP 503 para a página do documento de erro personalizada. O serviço de correio continuará indisponível. Aqui você pode %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'Visitantes serão redirecionados com o código de pesquisa fácil 503 HTTP para a página do documento de erro personalizada, mesmo que o site continue alojado no servidor. O serviço de correio continuará indisponível.',
    'web.change-status.error503PageLink' => 'editar o documento de erro personalizado',
    'web.change-status.statusActiveHint' => 'O site irá operar como usual.',
    'web.change-status.notActivatedSuspended' => 'O domínio ou site %%domainName%% não pode ser ativado porque foi suspenso pelo fornecedor do alojamento.',
    'web.change-status.notActivatedDisabled' => 'O domínio ou site %%domainName%% não pode ser ativado porque foi desativado pelo fornecedor do alojamento.',

    'web.edit.formTitle' => 'Acesso de hospedagem de rede para %%name%%',
    'web.edit.formGeneralHint' => 'Aqui você pode visualizar os endereços EP associados à sua assinatura e alterar o nome de utilizador e palavra-passe do seu utilizador de sistema.',
    'web.edit.formGeneralHint_powerUser' => 'Aqui você pode visualizar os endereços EP associados a este espaço na rede e alterar o nome de utilizador e palavra-passe do seu utilizador de sistema.',
    'web.edit.ipAddressesLegend' => 'Endereços IP',
    'web.edit.ipAddresses' => 'Endereços IP',
    'web.edit.certificateLegend' => 'Certificado',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (obtido por outro utilizador)',
    'web.edit.userAccountLegend' => 'Utilizador do sistema',
    'web.edit.systemUserHint' => 'Aqui pode especificar um utilizador de sistema operativo para a gestão de ficheiros e pastas na assinatura através do FTP ou da Gestão de Ficheiros. O utilizador do sistema também é utilizado para aceder ao Plesk através do SSH (no Linux) ou RDP (no Windows) caso as autorizações correspondentes estejam atribuídas.',
    'web.edit.systemUserHint_powerUser' => 'Aqui pode especificar um utilizador de sistema operativo para a gestão de ficheiros e pastas no espaço na rede através do FTP ou da Gestão de Ficheiros. O utilizador do sistema também é utilizado para aceder ao Plesk através do SSH (no Linux) ou RDP (no Windows) caso as autorizações correspondentes estejam atribuídas.',
    'web.edit.login' => 'Nome de utilizador',
    'web.edit.emptyLogin' => 'Por favor, introduza um nome de utilizador.',
    'web.edit.password' => 'Palavra-passe',
    'web.edit.passwordConfirmation' => 'Confirmar a palavra-passe',
    'web.edit.emptyPassword' => 'Por favor, introduza uma palavra-passe.',
    'web.edit.emptyPasswordConfirmation' => 'Por favor, confirme a palavra-passe.',
    'web.edit.shellUnix' => "Acesso ao servidor através do SSH",
    'web.edit.shellHintUnix' => "Acesso ao servidor através do SSH com as credenciais do utilizador do sistema.",
    'web.edit.shellWin' => 'Acesso ao servidor através do Remote Desktop',
    'web.edit.shellHintWin' => "Acesso ao servidor através do Remote Desktop com as credenciais do utilizador do sistema.",
    'web.edit.diskQuotaLegend' => 'Quota do disco rígido',
    'web.edit.diskQuotaHint' => 'A quota do disco rígido é o limite da quantidade de espaço em disco que pode ser utilizado. Se a quota for definida e todo o espaço em disco for utilizado, nenhuma operação em ficheiro algum poderá ser realizada.',
    'web.edit.diskQuota' => 'Quota do disco rígido',
    'web.edit.diskQuotaUnlimited' => 'Ilimitado',
    'web.edit.diskQuotaLimited' => 'MB %%limit%%',
    'web.edit.diskQuotaNotSupported' => 'Ilimitado. A quota do disco rígido não é suportada devido á configuração do sistema de ficheiros do servidor.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'As definições de alojamento foram atualizadas com sucesso.',
    'web.edit.affectedDomainsLegend' => 'Websites aos quais estas configurações serão aplicadas',
    'web.edit.affectedDomainsHint' => 'Os seguintes websites estão associados ao utilizador atual do sistema. Alterações às configurações de acesso ao alojamento de websites realizadas nesta página serão aplicadas a todos estes websites.',

    'web.mobile.create.formTitle' => 'Criar Site Móvel',
    'web.mobile.create.formGeneralHint' => 'Especifique um nome de site móvel - uma URL pela qual o site móvel será acedido. Geralmente, prefixos como "m", "mob", "mobi", "mobile", "móvel", entre outros, são utilizados, por exemplo: mobile.example.com. Você pode utilizar este URL num link como "Versão móvel/mobile" no seu site normal, dessa forma, os visitantes poderão alterar entre as duas versões.',
    'web.mobile.create.prefix' => 'Nome do site',
    'web.mobile.create.emptySiteName' => 'O nome do site móvel não pode ser faltante, isto pode gerar conflito com o site normal.',

    'web.security-section.securitySectionLegend' => 'Segurança',
    'web.security-section.securitySectionHint' => 'Para proteger as transações com o seu site, utilize o protocolo SSL/TLS, que encripta todos os dados e transfere-os numa ligação segura. Para empregar SSL/TLS, mova este site para um endereço IP dedicado, instale um certificado SSL/TLS no site e, em seguida, selecione-o abaixo.',
    'web.security-section.securitySectionSniHint' => 'Para proteger as transações com o seu site, utilize o protocolo SSL/TLS, que encripta todos os dados e transfere-os numa ligação segura. Para empregar SSL/TLS, instale um certificado SSL/TLS no site e, em seguida, selecione-o abaixo.',
    'web.security-section.enableSslSupport' => 'Suporte SSL/TLS',
    'web.security-section.enableSslRedirect' => 'Redirecionamento permanente seguro para SEO 301 de HTTP para HTTPS',

    'web.seo-settings.seoRedirectDirection' => 'Domínio preferido',
    'web.seo-settings.seoRedirectDirectionHint' => 'Selecionar a URL (com ou sem o prefixo www.) para a qual os visitantes do site serão redirecionados através de um redirecionamento seguro SEO HTTP 301.',
    'web.seo-settings.seoRedirectDirectionNone' => 'Nenhum',

    'web.settings.formGeneralHint' => 'Aqui você configura as definições de alojamento do site e seleciona os recursos disponíveis para o seu site.',
    'web.settings.hostingType' => 'Tipo de alojamento',
    'web.settings.websiteHosting' => 'Página web',
    'web.settings.forwardingHosting' => 'Redirecionamento',
    'web.settings.noHosting' => 'Sem alojamento',
    'web.settings.changeHosting' => 'Alterar',
    'web.settings.websiteStatus' => 'O estado do site',
    'web.settings.changeStatus' => 'Alterar',
    'web.settings.active' => 'Ativo',
    'web.settings.suspended' => 'Suspenso',
    'web.settings.disabled' => 'Desativado',
    'web.settings.webScriptingSectionLegend' => 'Scripts e Estatísticas de Web',
    'web.settings.webScriptingSectionHint' => 'Especifique quais das programações e idiomas de script abaixo devem ser interpretados, executados ou processados pelo servidor de rede.',
    'web.settings.__asp_win_support' => 'Suporte para Microsoft ASP',
    'web.settings.__asp_dot_net_support' => 'Suporte para Microsoft ASP.NET',
    'web.settings.__asp_dot_net_version' => 'Versão',
    'web.settings.__asp_dot_net_version_readonly' => 'versão %%value%%',
    'web.settings.__ssi_support' => 'Suporte para SSI',
    'web.settings.__ssi_with_html' => 'Utilização adicional de SSI para *.htm, *.html',
    'web.settings.__php_support' => 'Suporte para PHP',
    'web.settings.__php_run_as' => 'executar PHP como',
    'web.settings.__php_served_by_apache' => 'servido por Apache',
    'web.settings.__php_served_by_nginx' => 'servido por nginx',
    'web.settings.__cgi_support' => 'Suporte para CGI',
    'web.settings.__cgi_bin_mode' => 'o diretório cgi-bin está localizado em',
    'web.settings.__cgi_bin_mode_webspace' => 'o diretório raiz do espaço na rede',
    'web.settings.__cgi_bin_mode_www_root' => 'o documento raiz deste domínio',
    'web.settings.__cgi_bin_mode_old_style' => 'a raiz anterior deste domínio',
    'web.settings.__cgi_bin_mode_readonly' => 'o diretório cgi-bin está localizado em %%value%%',
    'web.settings.__perl_unix_support' => 'Suporte para Perl',
    'web.settings.__perl_win_support' => 'Suporte para Perl',
    'web.settings.__python_unix_support' => 'Suporte para Python',
    'web.settings.__python_win_support' => 'Suporte para Python',
    'web.settings.__fastcgi_unix_support' => 'Suporte FastCGI',
    'web.settings.__webstat_support' => 'Estatísticas de rede',
    'web.settings.__plesk_stat_protect' => 'Proteger o acesso às suas estatísticas da web com o seu nome de utilizador e palavra-passe FTP',
    'web.settings.__plesk_stat_protected' => 'O acesso às suas estatísticas da rede está protegido com o seu nome de utilizador e palavra-passe FTP',
    'web.settings.__apache_errdocs' => 'Documentos de erro personalizados',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'Aplicação FasCGI',
    'web.settings.__php_cgi_handler' => 'Aplicação CGI',
    'web.settings.__php_isapi_handler' => 'Extensão ISAPI',
    'web.settings.__php_version' => 'Versão de PHP',
    'web.settings.__hosting_write_modify' => 'Permissões adicionais de escrita/modificação',
    'web.settings.__hosting_webdeploy' => 'Publicação do Web Deploy',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'Nenhum',
    'web.settings.activate' => 'Ativar',
    'web.settings.deactivate' => 'Suspender',
    'web.settings.__php_support_readonly' => 'versão: %%version%%; manipulador: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'não está registado',
    'web.settings.domainName' => 'Nome do domínio',
    'web.settings.domainNameHint' => "Por exemplo, example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Modo de compatibilidade para a opção de legado "Separar conteúdo SSL/TLS e não SSL/TLS"',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Deixe o site a funcionar no modo de compatibilidade para a opção de legado "Separar conteúdo SSL/TLS e não SSL/TLS"',
    'web.settings.sameSslCompatibilityHint' => 'Visualiza esta secção porque utilizou a opção "Separar conteúdo SSL/TLS e não SSL/TLS" antes de atualizar. Esta opção não é mais utilizada no Plesk 11. Todos os sites criados no Plesk 11 utilizam o mesmo diretório para armazenar o conteúdo disponível nas ligações HTTP e HTTPS. Isto significa que o site ainda está a operar no modo de compatibilidade, mas não pode gerá-lo através do Plesk. É altamente recomendável que mova todos os seus dados do diretório httpsdocs/ para o httpsdocs/ e que posteriormente desative o modo de compatibilidade. Depois de desativar o modo de compatibilidade, não poderá ativá-lo novamente e esta secção deixará de ser exibida. Se instalar aplicações no diretório httpsdocs/ quando o modo de compatibilidade estiver ativado, as aplicações não serão acessíveis pela internet. Se desejar instalar aplicações no httpsdocs/, desative o modo de compatibilidade.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'As configurações do site serão aplicadas em %%restartInterval%% minutos.',
    'web.settings.phpSettingsDescription' => 'Esta página exibe a configuração do PHP para o site. Estas configurações são específicas para o site e não afetam outros sites da assinatura. É possível alterar a configuração do PHP se o fornecedor de hospedagem conceder a permissão correspondente. A configuração personalizada do PHP pode ser utilizada, por exemplo, para limitar o consumo de recursos do sistema por parte de scripts do PHP ou para atender aos requisitos de uma determinada aplicação da web. Ao definir um parâmetro para o valor Padrão, o PHP utilizará este valor a partir das configurações PHP em todo o servidor.',
    'web.settings.phpSettingsAvailableVariables' => 'Você pode utilizar os seguintes marcadores de posição nos valores de parâmetro:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} para o diretório raiz do documento deste site. O valor atual é %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'O diretório raiz de documentos HTTPS é o mesmo que para http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'O diretório raiz de documentos HTTPS é %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} para o diretório raiz do documento do site primário da assinatura.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} para o diretório que aloja ficheiros temporários.',
    'web.settings.phpSettingsPhpVersion' => 'Sua versão do PHP é %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'O PHP está desativado.',
    'web.settings.phpHandlerTypeHint' => 'Repare que alterar o tipo de manipulador PHP pode interromper a funcionalidade de scripts PHP existentes neste site.',
    'web.settings.fpmDedicatedHandlerHint' => 'Utilizar este handler aumenta a estabilidade de um website, mas também provoca o consumo adicional de memória.',
    'web.settings.phpHandlerChangeHint' => 'Alterou as definições do processador de PHP. Se guardar estas alterações, os scripts PHP no seu website podem parar durante %%interval%% segundos devido à configuração do seu servidor.',
    'web.settings.phpHandlerTypeHelpLink' => 'Saiba como escolher as configurações PHP adequadas',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'O suporte a PHP não pode ser ativado porque a configuração atual de alojamento não inclui qualquer versão do PHP disponível para este domínio.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Descubra como ativar outras versões do PHP.',
    'web.settings.phpHandlerBroken' => 'O manipulador do PHP atualmente selecionado está corrompido. Selecione um manipulador diferente.',
    'web.settings.phpHandlerOutdated' => '(Desatualizado)',
    'web.settings.phpHandlerDeprecated' => '(Descontinuado)',

    'web.setupService.formTitle' => 'Serviço de configuração: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'O serviço \'%%serviceReference%%\' foi atualizado com sucesso.',

    'web.site-copy.subdomainsGroup' => 'Subdomínios %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Copiar Destino',
    'web.site-copy.destinationType' => 'Selecione onde os ficheiros do site deverão ser copiados',
    'web.site-copy.destinationTypeSite' => 'Website no Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Copiar os ficheiros de site para outro site caso o seu seja alojado nesta conta. Se obtiver um acesso FTP para outra conta neste servidor, utilize a opção Armazenamento FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Copiar os ficheiros de site para outro site alojado neste servidor.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nome do site',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Ficheiros neste site %%source%% não podem ser copiados para %%destination%% porque %%destination%% também faz parte destes ficheiros - a sua raiz de documento é um sub-diretório da raiz do documento %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Ficheiros do %%destination%% site não podem ser excluídos porque os ficheiros %%source%% fazem parte dele - a raiz de documento %%source%% é um sub-diretório de %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Armazenamento FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Copiar ficheiros de site para um conta de FTP neste servidor ou num externo.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Copiar ficheiros de site para um conta de FTP num servidor externo.',
    'web.site-copy.destinationTypeFtpHost' => "Nome de host do Servidor",
    'web.site-copy.destinationTypeFtpPort' => "Porta",
    'web.site-copy.destinationTypeFtpFolder' => 'Diretório',
    'web.site-copy.destinationTypeFtpUser' => 'Nome de utilizador',
    'web.site-copy.destinationTypeFtpPassword' => 'Palavra-passe',
    'web.site-copy.destinationTypeFtpMode' => 'Método de ligação FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Modo ativo',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'No modo ativo, o Plesk envia os seus endereços IP e o número de porta que obedecerão a um servidor externo e o servidor inicia a ligação TCP. Este modo é recomendado quando o servidor gerido pelo Plesk não estiver protegido por uma firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Modo passivo',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'O modo passivo pode ser utilizado quando o servidor gerido pelo Plesk estiver protegido por uma firewall e não puder aceitar ligações TCP.',
    'web.site-copy.existingFiles' => 'O que fazer com ficheiros existentes',
    'web.site-copy.existingFilesKeep' => 'Manter os ficheiros existentes no site de destino',
    'web.site-copy.existingFilesKeepDescription' => 'Substituir ficheiros existentes com nomes de ficheiro repetidos no site de destino.',
    'web.site-copy.existingFilesDelete' => 'Excluir todos os ficheiros existentes',
    'web.site-copy.existingFilesDeleteDescription' => 'Excluir todos os ficheiros no site de destino antes de copiar.',
    'web.site-copy.emptyLogin' => 'Especificar um nome de utilizador de conta FTP.',
    'web.site-copy.emptyHost' => 'Especificar um nome de alojamento de servidor.',
    'web.site-copy.emptyPort' => 'Especificar uma porta de alojamento de servidor.',
    'web.site-copy.copyInProgress' => 'Cópia do website %%sourceName%% para %%destinationName%%. Será notificado do progresso através de e-mail (%%email%%).',
    'web.site-copy.unableToCopy' => 'Falha ao copiar ficheiros de site.',
    'web.site-copy.siteCopied' => 'Os ficheiros de site foram copiados.',
    'web.site-copy.emailSubjSuccess' => 'Os ficheiros "%%source%%" de site foram copiados.',
    'web.site-copy.emailSubjFailure' => 'Falha ao copiar ficheiros "%%source%%" de site.',
    'web.site-copy.emailBodySuccess' => 'Os ficheiros "%%source%%" de site foram copiados para "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Falha ao copiar ficheiros "%%source%%" de site para "%%destination%%": %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Definições de Re-endereçamento',
    'web._shared.forwardDestination' => 'Endereço de destino',
    'web._shared.forwardDestinationHint' => 'URL do site alvo.',
    'web._shared.forwardingTypeOptions' => 'Tipo de re-endereçamento',
    'web._shared.forwardingFrame' => 'Re-endereçamento em Janela',
    'web._shared.forwardingFrameHint' => 'Redirecionar as visitas do web site para outro site e não exibir o endereço de destino, de modo a que não se apercebam do redirecionamento.',
    'web._shared.forwardingHttpCode301' => 'Movido permanentemente (código 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Redirecionar as visitas do web site para outro site e exibir o endereço de destino. Tal redirecionamento manterá as classificações de pesquisa dos sites.',
    'web._shared.forwardingHttpCode302' => 'Movido temporariamente (código 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Redirecione os visitantes do site para uma cópia temporária do site se não quiser que os motores de busca indexem este site temporário.',
    'web._shared.documentRoot' => 'Raiz do documento',
    'web._shared.documentRootHint' => 'O caminho para o diretório inicial do website.',
    'web._shared.documentRootHintDisabledDueApplications' => 'É impossível mudar a raiz do documento porque há aplicações da web instaladas neste site.',
    'web._shared.ipAddress' => 'Endereço IP',
    'web._shared.shared' => 'partilhado',
    'web._shared.exclusive' => 'dedicado',
    'web._shared.ipAddressHint' => "O endereço IP no qual o site está hospedado é um endereço de rede do host virtual do site.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (outro repositório)',
    'web._shared.certificate' => 'Certificado',
    'web._shared.sameCertificatesHint' => 'O certificado selecionado será utilizado para todos os sites alojados no endereço IP dedicado.',
    'web._shared.differentCertificatesHint' => 'Esta assinatura está associada a dois endereços IP dedicados com dois certificados diferentes. O certificado selecionado substituirá quaisquer outros instalados em sites alojados nestes dois endereços IP.',
    'web._shared.differentIpTypesCertificateHint' => 'Esta assinatura está associada a uma partilhada com um endereço IP dedicado. O certificado selecionado também será utilizado para todos os outros sites alojados no endereço IP dedicado.',
    'web._shared.certificateNotSelected' => 'Não selecionado',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Não existem certificados SSL/TLS no seu repositório. Para adicionar um certificado, vá até %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'esta página',

    'web-user.settings.allowScripts' => 'Permitir a utilização de scripts aos utilizadores Web',

    'web-user.name' => 'Nome de utilizador para ligar o servidor através do FTP',
    'web-user.longName' => 'O nome de utilizador é muito longo (máximo de %max% símbolos são permitidos).',
    'web-user.password' => 'Palavra-passe',
    'web-user.passwordConfirmation' => 'Confirmar a palavra-passe',
    'web-user.hardDiskQuota' => 'Quota de disco rígido',
    'web-user.hardDiskQuotaUnlimited' => 'Ilimitado',
    'web-user.hardDiskQuotaIsNotSupported' => '(a quota do disco rígido não é suportada devido á configuração do sistema de ficheiros do servidor)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Campos obrigatórios',
];