<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'admin-info.adminInfoSection' => 'Yönetici için bilgiler',
    'admin-info.descriptionAdmin' => 'Yöneticinin açıklaması',
    'admin-info.descriptionReseller' => 'Satıcının açıklaması',
    'admin-info.descriptionOwner' => 'Sahibinin açıklaması',
    'admin-info.description' => 'Tanım',
    'admin-info.descriptionSuccess' => 'Açıklama güncellendi.',
    'admin-info.longDescription' => 'Belirtilen açıklama çok uzun. %%max%% simgeden uzun olamaz.',
    'admin-info.add' => 'Açıklama ekle',
    'admin-info.edit' => 'Düzenle',
    'admin-info.remove' => 'Sil',
    'admin-info.confirmOnRemove' => 'Bu açıklamayı kaldırmak istiyor musunuz?',
    'admin-info.popupTitleCustomer' => '%%descriptionType%% / müşteri %%name%%',
    'admin-info.popupTitleReseller' => '%%descriptionType%% / satıcı %%name%%',
    'admin-info.popupTitleSubscription' => '%%descriptionType%% / abonelik %%name%%',
    'admin-info.popupTitleSite' => '%%descriptionType%% / %%name%%',
    'admin-info.popupHintAdmin' => 'Bu açıklama sadece yönetici için görünür.',
    'admin-info.popupHintReseller' => 'Bu açıklama, satıcı ve yönetici için görünür.',
    'admin-info.popupHintOwner' => 'Bu açıklama, yazarı ve yazarının barındırma sağlayıcısı için görünür.',
    'admin-info.customerDescriptionHint' => 'Müşteriler bu açıklamayı göremez.',
    'admin-info.subscriptionDescriptionHint' => "Bu bilgiler sadece barındırma sağlayıcısı (Plesk yöneticisi veya satıcısı) için görünür.",

    'apache-settings.formGeneralHint' => 'Burada bu web sitesi için Apache web sunucusu ayarlarını belirtebilirsiniz.  Özel Apache yapılandırması, örneğin web sitenizdeki yeni tip indeks dosyalarını kullanmak veya belli bir MIME tipini belli dosya adı uzantılarıyla ilişkilendirmek istediğinizde yararlı olur.  Varsayılan değer, Apache\'nin sunucu çapındaki yapılandırmasından ilgili direktifi kullanacağı anlamına geliyor.  Apache, bir ön uç sunucusu olarak nginx ile çalışıyorsa, bu sayfadaki nginx ayarlarını da belirtebilirsiniz.',
    'apache-settings.general' => 'Ortak Apache ayarları',
    'apache-settings.example' => "Örneğin:\n %%example%%",
    'apache-settings.settingOn' => 'Açık',
    'apache-settings.settingOff' => 'Kapalı (Varsayılan)',
    'apache-settings.settingDefault' => 'Varsayılan',
    'apache-settings.settingCustom' => 'Özel değeri girin',
    'apache-settings.mimeTypes' => 'MIME türleri',
    'apache-settings.mimeTypesExample' => "metin/düz .txt\n image/jpeg .jpeg \n\n MIME tipleri, dosya uzantılarını dosya tipleriyle ilişkilendirir.  Bu genellikle ortak dosya tipleri için bir özel dosya uzantısı oluşturmak için kullanılır.",
    'apache-settings.handlers' => 'İşleyiciler',
    'apache-settings.handlersExample' => "php-script .php\n cgi-komut dosyası .cgi \n\n Apache işleyicileri, web sunucusunun belli uzantıları olan dosyalar istendiğinde bunları nasıl işlediğini tanımlar.  Örneğin 'php-script .script' dizesi, Apache'nin .script dosyalarını php komut dosyaları olarak işleyeceği anlamına gelir.",
    'apache-settings.deny' => 'Siteye erişimi reddedin',
    'apache-settings.allow' => 'Dışta Tutulan',
    'apache-settings.denyExample' => "10.1.0.0/16\n 192.168.1.110\n\n Belirtilen ana bilgisayar ve ağların siteye erişimi yasaktır.  Tüm bağlantıları reddetmek için '*' kullanın.",
    'apache-settings.allowExample' => "192.168.0.0/16\n 10.1.1.21\n\n Belirtilen ana bilgisayar ve ağların siteye erişimine izin verilir.",
    'apache-settings.directoryIndex' => 'İndeks dosyaları',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl \n\n Sitenin indeks sayfası istendiğinde, Apache belirtilen dosyaları arar.",
    'apache-settings.expires' => 'Expires (Süre Sonu)',
    'apache-settings.expiresStaticOnly' => 'sadece statik dosyalar için Süre Sonu başlıklarıyla yanıtlayın',
    'apache-settings.expiresDescription' => 'Web sunucusu web sayfalarına "Süre Sonu" yanıt başlıklarını ekler. Süre sonu zaman damgası, web sayfasının istendiği zamanın üstünde belirtilen süre eklenerek bulunur.',
    'apache-settings.expiresStaticOnlyDescription' => '"Süre Sonu" başlığı sadece statik dosyalara eklenir. Hangi dosyaların statik olarak işlendiği, "Akıllı statik dosyaları işleme" ve "Statik dosyalara doğrudan nginx ile servis sağlayın" seçenekleriyle yönetilir.',
    'apache-settings.expiresUnitDays' => 'gün',
    'apache-settings.expiresUnitHours' => 'saat',
    'apache-settings.expiresUnitMinutes' => 'dakika',
    'apache-settings.expiresUnitSeconds' => 'saniye',
    'apache-settings.headers' => 'Ek üst bilgiler',
    'apache-settings.headersExample' => "Cache-Control: public \nStrict-Transport-Security: max-age=63072000 \nX-Frame-Options: DENY \n\nWeb sunucusu, belirtilen HTTP yanıt başlıklarını ekler.",
    'apache-settings.restrictFollowSymLinks' => 'Sembolik bağlantıları izleme yeteneğini kısıtlayın',
    'apache-settings.restrictFollowSymLinksDescription' => "Kullanıcıların .htaccess'teki FollowSymLink direktifini kullanmasını engellemek ve sunucu güvenliğini iyileştirmek için bu seçeneği seçin.",
    'apache-settings.nginx' => 'nginx ayarları',
    'apache-settings.nginxProxyMode' => 'Vekil Modu',
    'apache-settings.nginxProxyModeDescription' => 'Apache üzerinde Nginx proxy\'leri talepleri. Apache kullanmayı durdurmak için kapatın.',
    'apache-settings.nginxTransparentMode' => 'Akıllı statik dosyaları işleme',
    'apache-settings.nginxTransparentModeDescription' => 'Kapandığında, Apache tüm statik dosya taleplerini işler. nginx, talep ve yanıtları sadece bildirimsiz olarak geçirir.  Bu seçeneği sadece sorun giderme için kapatın.',
    'apache-settings.nginxServeStatic' => 'Statik dosyalara doğrudan nginx ile servis sağlayın',
    'apache-settings.nginxStaticExtensions' => 'Boşluklar veya "|" simgesiyle ayrılan dosya uzantılarını belirtin.  Bu dosyaların talepleri nginx tarafından işlenir ve hiçbir zaman Apache\'ye ulaşmaz.  Dikkat: Apache yeniden yazma kuralları uygulanmaz.',
    'apache-settings.nginxServePhp' => 'nginx ile PHP\'yi işleyin',
    'apache-settings.nginxServePhpDescription' => 'PHP dosyaları (.php), nginx ve PHP-FPM tarafından işlenecek.  Kapandığında, PHP dosyaları Apache tarafından işlenir.',
    'apache-settings.nginxCacheEnabled' => 'nginx önbelleğe almayı etkinleştir',
    'apache-settings.nginxCacheEnabledDescription' => 'Önbelleğe alma, web sitesinin yanıt süresini ve sunucu yükünü azaltabilir, ancak dikkatli kullanılmalıdır.',
    'apache-settings.nginxCacheSize' => 'Önbellek boyutu',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Önbellek zaman aşımı',
    'apache-settings.nginxCacheTimeoutDays' => 'gün',
    'apache-settings.nginxCacheTimeoutHours' => 'saat',
    'apache-settings.nginxCacheTimeoutMinutes' => 'dakika',
    'apache-settings.nginxCacheTimeoutSeconds' => 'saniye',
    'apache-settings.nginxCacheKey' => 'Önbellek tuşu',
    'apache-settings.nginxCacheCookies' => 'Talepleri çerezlerle önbelleğe al',
    'apache-settings.nginxCacheBypassLocations' => 'Konumlar için önbelleğe almayı devre dışı bırak',
    'apache-settings.nginxCacheBypass' => 'Aşağıdaki durumlarda önbelleği baypas edin',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'Talepte HTTP no-cache başlıkları alındığında',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'Talepte HTTP yetkilendirme başlıkları alındığında',
    'apache-settings.nginxCacheBypassGetNocache' => 'Talepte GET nocache parametresi alındığında',
    'apache-settings.nginxCacheUseStale' => 'Önbelleğe alınan eski kayıtları geri döndür',
    'apache-settings.nginxCacheUseStale5xx' => 'Yukarı, 5xx sunucu hatasını verir',
    'apache-settings.nginxCacheUseStale4xx' => 'Yukarı, 4xx istemci hatasını verir',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Önbellek güncelleniyor',
    'apache-settings.additional' => 'Ek Apache direktifleri',
    'apache-settings.additionalSettingsDescription' => 'Özel ayarlar bulamıyorsanız, bunları aşağıdaki alanlar ekleyin.  Bu ayarlar, sunucu çapındaki Apache direktiflerini geçersiz kılar.  İlk alandaki direktifler, bir ziyaretçi siteye HTTP üzerinden eriştiğinde kullanılır.  İkinci alan, HTTPS direktiflerini içerir.  Genellikle direktifleri her iki alana da eklemeniz gerekir.  httpd.include için kullandığınızla aynı sözdizimini kullanın.  Örneğin özel bir hata sayfası ayarlamak istiyorsanız, satırı ekleyin: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'http için ek direktifler',
    'apache-settings.additionalSslSettings' => 'HTTPS için ek direktifler',
    'apache-settings.additionalSettingsError' => 'Geçersiz Apache yapılandırması: %%error%%',
    'apache-settings.rollbackFailed' => 'Geçersiz yapılandırma içerdiğinden, geçerli Apache yapılandırma dosyası kullanılamıyor ve dosyanın bir önceki sürümüne geri dönülemiyor.',
    'apache-settings.additionalNginx' => 'Ek nginx direktifleri',
    'apache-settings.additionalNginxSettingsDescription' => 'Burada Apache\'nin önünde çalışan nginx ters vekil sunucusunun ayarlarını belirtebilirsiniz.  Direktifleriniz, sunucu çapında nginx yapılandırmasını geçersiz kılar.  Örneğin bağlantı zamanaşımını değiştirmek veya gzip ile talepleri paketlemek isteyebilirsiniz.  nginx.conf için kullandığınızla aynı sözdizimini kullanın.  Örneğin gzip ile vekille yapılan tüm talepleri paketlemek istiyorsanız, bu satırı ekleyin: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Ek nginx direktifleri',
    'apache-settings.additionalNginxSettingsError' => 'Geçersiz nginx yapılandırması: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Her ikisi de geçersiz yapılandırma içerdiğinden, geçerli nginx yapılandırma dosyası kullanılamıyor ve dosyanın bir önceki sürümüne geri dönülemiyor.',

    'backup.backup-password-protection.securitySettingsSection' => 'Yedekleme güvenlik ayarları',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Uzak depolama ayarlarından parolayı alın',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Şifreyi manuel olarak girin',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Şifreyi verin',
    'backup.backup-password-protection.backupPassword' => 'Şifre',
    'backup.backup-password-protection.inputPasswordType' => 'Şifre tipi',
    'backup.backup-password-protection.confirmBackupPassword' => 'Şifreyi tekrarlayın',
    'backup.backup-password-protection.backupPasswordHint' => 'Şifrenizi unuttuğunuzda bu seçenekteki işareti kaldırın. Bu durumda bazı hassas verilerin düzgün bir biçimde geri yüklenmeyeceğini unutmayın. Örneğin kullanıcı şifreleri rastgele şifrelerle değiştirilir, zaten yüklü APS uygulamaları hakkındaki bilgiler kaybolur ve saire.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Bu yedekleme için şifre koruması kullandıysanız, şifreyi aşağıdaki alanlara girin. Yanlış bir şifre girdiğinizde, Plesk\'in yedeklemeyi geri yüklemeyeceğini unutmayın. Onun yerine yedekleme, yerel depoya kopyalanır.',

    'backup.conflict-database.dbMappingLegend' => 'Veritabanı sunucusu eşlemesi',
    'backup.conflict-database.serverType' => 'Sunucu Tipi',
    'backup.conflict-database.hostName' => 'Host adı',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Hedef veritabanı sunucusu',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Veritabanı geri yüklenemiyor: Uygun veritabanı sunucusu yok.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'IP Eşleme Dosyasını Yükleyin',
    'backup.conflict-ip.ipMappingLegend' => 'IP eşleme',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Geçerli IP Eşlemesini Dosyaya Kaydedin',
    'backup.conflict-ip.ipAddressNotFound' => 'Bu tipte hiçbir boş IP adresi yok.',
    'backup.conflict-ip.sharedIp' => 'paylaşılan',
    'backup.conflict-ip.dedicatedIp' => 'atanmış',
    'backup.conflict-ip.fileNotFound' => 'Dosya boş olmamalı.',
    'backup.conflict-ip.invalidIpToMap' => 'Eski bir IP adresi için geçersiz bir değer: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Yeni bir IP adresi için geçersiz bir değer: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'IP adresi %%ip%% veritabanında bulunmadı.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'IP eşleme dosyasını karşıya yükle',
    'backup.conflict-ip.ipMappingFileHint' => 'Bir IP eşleme dosyası, bir düz metin dosyasıdır. Bu dosyanın her satırı, aşağıdaki biçimde IP eşlemesi içerir: <eski IP adresi> <yeni IP adresi>',
    'backup.conflict-ip.oldIp' => 'Eski IP adresleri',
    'backup.conflict-ip.newIp' => 'Yeni IP adresleri',

    'backup.copy-to-server.ignoreBackupSign' => 'Geçerli imzası olmayan yedekleme dosyalarını karşıya yükleyin',
    'backup.copy-to-server.wrongPassword' => 'Belirtilen şifre yanlış. Yedekleme kurtarması sırasında Plesk sizden şifreyi tekrar girmenizi isteyecektir.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Karşıya yüklenen yedekleme dosyası %%fileName%% değiştirilmiş, bozulmuş veya başka bir sunucuda ya da yedeklemelerin imzalanmasını desteklemeyen daha eski bir Plesk sürümünde oluşturulmuş. Bu yedekleme dosyasından verileri geri yüklemeden önce, bu dosyanın kaynağına güvenebileceğinizden emin olun.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Yedekleme dosyası %%fileName%% yüklenemiyor. Dosya ya değiştirilmiş veya bozulmuş veri içeriyor, ya da başka bir sunucuda veya daha eski bir Plesk sürümünde oluşturulmuş. Bu dosyadaki verileri geri yüklemek için, barındırma sağlayıcınızla irtibata geçin.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Yedekleme dosyası %%fileName%% yüklenemiyor. Dosya değiştirilmiş, bozulmuş veya başka bir sunucuda ya da yedeklemelerin imzalanmasını desteklemeyen daha eski bir Plesk sürümünde oluşturulmuş. Bu yedeklemeye güveniyorsanız, "Geçerli imzaları olmayan yedekleme dosyalarını karşıya yükleyin" seçeneğini seçin ve karşıya yüklemeyi tekrarlayın.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Seçilen yedekleme %%fileName%%, sunucu deposuna taşınamıyor. Hata: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Artan yedeklemenin aşağıdaki parçaları kopyalanmadı:%%endl%%%%missedParts%%%%endl%%Lütfen eksik parçaları kopyalayın.",

    'backup.ftp-settings.isActive' => 'FTP(S) depolamasını kullan',
    'backup.ftp-settings.host' => 'FTP sunucusu ana bilgisayar adı veya IP\'si',
    'backup.ftp-settings.directory' => 'Yedekleme dosyaları depolama dizini',
    'backup.ftp-settings.directoryHint' => 'Örneğin /klasörüm/yedeklemelerim/',
    'backup.ftp-settings.ftpLogin' => 'FTP kullanıcı adı',
    'backup.ftp-settings.ftpPassword' => 'FTP şifresi',
    'backup.ftp-settings.usePassiveMode' => 'Pasif modu kullanın',
    'backup.ftp-settings.useFtps' => 'FTPS kullanın',
    'backup.ftp-settings.errorHostIsLocal' => 'Yerel Plesk\'in FTP sunucusunu bir uzak depo olarak kullanmak yasaktır. Lütfen bir uzak konum belirtin.',
    'backup.ftp-settings.warningHostIsLocal' => 'FTP(S) depolama ayarları, yedeklemeleri abonelik dosyalarınızın bulunduğu sunucuda depolamak üzere yapılandırılmıştır. Veri kaybı ve disk alanının fazla kullanılması riskinden dolayı bu yapılandırma önerilmez.',
    'backup.ftp-settings.enterFtpLogin' => 'Doğru bir kullanıcı adı girin.',
    'backup.ftp-settings.enterFtpPassword' => 'Doğru bir parola girin.',

    'backup.remote-settings.isActive' => 'Depolamayı kullan',
    'backup.remote-settings.initError' => '%%extName%% ayarları sayfası başlatılamıyor: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Yedekleme güvenlik ayarları',

    'backup.restore.detailsSection' => 'Detaylar',
    'backup.restore.contentInfoSection' => 'Yedekleme içeriği',
    'backup.restore.restorationOptionsSection' => 'Geri yükleme seçenekleri',
    'backup.restore.emailNotification' => 'Kurtarma tamamlandığında, buraya bir bildirim gönderin:',
    'backup.restore.comments' => 'Yorumlar',
    'backup.restore.creationDate' => 'Oluşturulma tarihi',
    'backup.restore.systemNotes' => 'Sistem notları',
    'backup.restore.ownerAdmin' => 'Yönetici tarafından oluşturuldu.',
    'backup.restore.ownerReseller' => 'Bir satıcı tarafından oluşturuldu.',
    'backup.restore.ownerCustomer' => 'Bir müşteri tarafından oluşturuldu.',
    'backup.restore.ownerServiceUser' => 'Ek bir kullanıcı tarafından oluşturuldu.',
    'backup.restore.partOfParentBackup' => '%%type%% yedeklemesinin parçası.',
    'backup.restore.server' => 'sunucu',
    'backup.restore.reseller' => 'satıcı',
    'backup.restore.client' => 'müşteri',
    'backup.restore.incremental' => 'Artımlı.',
    'backup.restore.multiVolume' => 'Çok hacimli.',
    'backup.restore.backupSize' => 'Yedekleme boyutu',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (bu ekleme) + %%base%% (ilk yedekleme) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (bu ekleme) + %%prev%% (önceki eklemeler) + %%base%% (ilk yedekleme) = %%total%%',
    'backup.restore.download' => 'Yükle',
    'backup.restore.downloadHint' => 'Yedekleme dosyasını yerel bilgisayarınıza indirin.',
    'backup.restore.downloadDisabled' => 'Yedekleme dosyaları geçici olarak indirilemiyor. Lütfen daha sonra yeniden deneyin veya servis sağlayıcınızla irtibata geçin.',
    'backup.restore.copy' => 'Sunucu Deposuna Kopyala',
    'backup.restore.copyHint' => 'Seçilen yedekleme dosyalarını sunucu deposuna kopyalayın.',
    'backup.restore.contentInfo' => 'Yedekleme içeriği',
    'backup.restore.restoreButton' => 'Gerikur',
    'backup.restore.mail' => 'Posta',
    'backup.restore.domainConfiguration' => 'Alan adı yapılandırması',
    'backup.restore.virtualHost' => 'Sanal ana bilgisayar içeriği',
    'backup.restore.database' => 'Veritabanları',
    'backup.restore.serverConfiguration' => 'Sunucu ayarları',
    'backup.restore.serverConfigurationLicense' => 'Lisans',
    'backup.restore.serverPersonalConfiguration' => 'Yönetici hesabı yapılandırması',
    'backup.restore.serverPersonalDomains' => 'Yöneticinin alan adları',
    'backup.restore.serverPersonalClients' => 'Yöneticinin müşterileri',
    'backup.restore.resellers' => 'Satıcılar',
    'backup.restore.resellerPersonalConfiguration' => 'Satıcı hesabı yapılandırması',
    'backup.restore.resellerPersonalDomains' => 'Satıcının alan adları',
    'backup.restore.resellerPersonalClients' => 'Satıcı müşterileri',
    'backup.restore.clientPersonalConfiguration' => 'Müşteri hesabı yapılandırması',
    'backup.restore.clientPersonalDomains' => 'Müşteri alan adları',
    'backup.restore.restoreModifiedSection' => 'Yedekleme dosyasını bozuk bir imzaya rağmen geri yükleyin',
    'backup.restore.restoreModifiedDump' => 'Geçerli bir imzası olmamasına rağmen bu yedeklemeyi geri yükleyin',
    'backup.restore.resolutionPolicy' => 'Çözünürlük ilkesi',
    'backup.restore.resolutionPolicyDescription' => 'Zamanlama çakışmaları ya geri yüklenen nesne sistemde daha güncel değişiklik tarihiyle zaten varsa veya geri yüklenen nesne sistemde şu an yoksa görülür.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Belirtilen şifre yanlış. Yedekleme dosyası, sunucunun yerel deposuna kopyalanır.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Yedekleme geri yüklenemiyor. Belirtilen şifre yanlış.',
    'backup.restore.serverContentAndConfiguration' => 'Sunucu yapılandırması ve içeriği',
    'backup.restore.serverConfigurationOnly' => 'Sunucu Ayarları',
    'backup.restore.resellerContentAndConfiguration' => 'Satıcı hesabı yapılandırması ve içeriği',
    'backup.restore.resellerConfigurationOnly' => 'Satıcı hesabı yapılandırması',
    'backup.restore.clientContentAndConfiguration' => 'Müşteri hesabı yapılandırması ve içeriği',
    'backup.restore.clientConfigurationOnly' => 'Müşteri hesabı yapılandırması',
    'backup.restore.domainContentAndConfiguration' => 'Alan adı yapılandırması ve içeriği',
    'backup.restore.domainConfigurationOnly' => 'Alan adı yapılandırması',
    'backup.restore.restoreType' => 'Neyi geri yüklemek istiyorsunuz?',
    'backup.restore.restoreTypeFull' => 'Tüm nesneler (bütün sistem)',
    'backup.restore.restoreTypeGranular' => 'Seçilen nesneler',
    'backup.restore.restoreObjectType' => 'Geri yüklenecek nesne tipi',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Abonelik',
    'backup.restore.restoreObjectTypeCustomers' => 'Müşteri',
    'backup.restore.restoreObjectTypeResellers' => 'Satıcı',
    'backup.restore.restoreObjectTypeMailUsers' => 'Posta hesabı',
    'backup.restore.restoreObjectTypeDatabases' => 'Veritabanı',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS sertifikaları',
    'backup.restore.restoreObjectTypeSites' => 'Konumlar',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS bölgesi',
    'backup.restore.restoreObjectTypeMailLists' => 'Postalama listeleri',
    'backup.restore.restoreObjectTypeWebContent' => 'Alan adlarının dosyaları',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Seçilen dosyalar',
    'backup.restore.restoreSubscriptionLookup' => 'Abonelik',
    'backup.restore.restoreComponents' => 'Geri yüklenecek bileşenler',
    'backup.restore.errorLog' => 'Günlükleri',
    'backup.restore.backupDetailsLogDoesntExist' => 'Yedekleme günlüğü kullanılamaz.',
    'backup.restore.dumpFailedSection' => 'Günlükleri',
    'backup.restore.dumpFailed' => 'Veriler geri yüklenemiyor: Yedekleme dosyası geçersiz.',
    'backup.restore.granularNotSupported' => 'Plesk 12.0 veya üstüyle oluşturulan yedeklemelerden geri yükleme yaptığınızda sadece geri yüklenecek nesneleri seçebilirsiniz.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Satıcı İleri Kullanıcı görünümünde yedeklemelerdeki tüm verileri kurtarma desteklenmiyor. Geri yüklenecek nesneleri seçin. %%interfaceLink%% altındaki arayüz görünümünüzü değiştirebilirsiniz',
    'backup.restore.interfaceLink' => 'Arayüz Tercihleri',
    'backup.restore.contentRestoreType' => 'Gerikur',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Sadece seçilen nesnelerin yapılandırması',
    'backup.restore.contentRestoreTypeFull' => 'Seçilen nesnelerin yapılandırması ve içindekileri',
    'backup.restore.errorWrongFormat' => 'Yedekleme geri yüklenemiyor: dosya, yanlış biçimlendirme içeriyor.',
    'backup.restore.errorContentError' => 'Tüm veriler geri yüklenemeyebilir: Yedekte içerik hataları mevcut.',
    'backup.restore.warningSignError' => 'Yedekleme imzası doğrulanamıyor. Yedekleme dosyası değiştirilmiş, bozulmuş veya başka bir sunucuda ya da daha eski bir Plesk sürümünde oluşturulmuş olabilir.',
    'backup.restore.warningSignErrorNotAdmin' => 'Bu yedekleme ancak Plesk yöneticisi tarafından geri yüklenebilir.',
    'backup.restore.warningPartial' => "Artan yedeklemenin aşağıdaki parçaları bulunamadı:%%endl%%%%missedParts%%%%endl%%Tüm dosyalar geri yüklenemez. Eksik parçaları karşıya yükleyin ve geri yüklemeyi tekrar deneyin.",
    'backup.restore.warningDeprecatedBackupVersion' => 'Geri yüklemeye çalıştığınız yedek, desteklenmeyen bir Plesk sürümünde oluşturuldu ve geri yüklenemiyor. Eski Plesk sürümlerindeki verilerinizi aktarmak için Plesk Migrator uzantısını kullanın.',
    'backup.restore.encryptionKeyError' => 'Bu yedeklemedeki bir veya daha fazla hesabın şifreleri geri yüklenemiyor ve sıfırlanacak. Bu yedekleme büyük olasılık farklı bir Plesk sunucusunda oluşturulmuş ve onun şifreleme anahtarıyla şifrelenmiş.',
    'backup.restore.errorCorruptedContent' => 'Şu dosyalar bulunamadı ya da bozulmuş: ',
    'backup.restore.statusSection' => 'Yedekleme durumu',
    'backup.restore.statusDetails' => 'Durum ayrıntıları',
    'backup.restore.restoreBlocked' => 'Yedekleme geri yüklenemez.',
    'backup.restore.restoreBlockedDescription' => '%%backupType%% tipi yedekleme şimdi geri yüklenemiyor. Onu geri yüklemek için, yedeklemenin sahibi olarak oturum açın ve Yedekleme Yöneticisinde bu yedekleme adını tıklatın.',

    'backup.schedule.scheduleSection' => 'Çizelge',
    'backup.schedule.backupEnable' => 'Bu yedekleme görevini etkinleştirin',
    'backup.schedule.backupPeriod' => 'Bu yedekleme görevini çalıştır',
    'backup.schedule.on' => 'açık',
    'backup.schedule.at' => 'alır',
    'backup.schedule.useIncremental' => 'Artan Yedekleme Kullan',
    'backup.schedule.fullBackupPeriod' => 'Tam yedekleme gerçekleştir',
    'backup.schedule.daily' => 'Günlük',
    'backup.schedule.weekly' => 'Haftalık',
    'backup.schedule.monthly' => 'Aylık',
    'backup.schedule.yearly' => 'Yıllık',
    'backup.schedule.days' => 'gün',
    'backup.schedule.weeks' => 'haftalar',
    'backup.schedule.months' => 'aylar',
    'backup.schedule.years' => 'yıllar',
    'backup.schedule.backupTimeDescription' => 'Saat dilimi: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Varsayılan sistem saat dilimi',
    'backup.schedule.first' => 'birinci',
    'backup.schedule.last' => 'sonuncu',
    'backup.schedule.dayOfMonth' => 'Gün',
    'backup.schedule.email' => 'Bu yedekleme görevini yürütme sırasında hatalar görüldüğünde, buraya bir bildirim e-postası gönderin',
    'backup.schedule.invalidFields' => 'Bazı alanlar boş veya geçersiz değer içeriyor: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Saklanacak maksimum tam yedekleme dosyası sayısı (planlı ve manuel yedeklemeler de dahil)',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Dolu yedeklemeleri otomatik olarak kaldırmak istemiyorsanız, bu alanı boş bırakın.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Sunucu depolaması için barındırma sağlayıcısının belirttiği sınır, %%max%% şeklindedir. O sınırınızın %%max%% değerinden küçük veya ona eşit olması gerekir.',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Planlanmış abonelik yedeklemelerini uzaktaki bir bulut depolamasında saklamak, Plesk Çevrimiçi Mağazasından satın alabileceğiniz bir premium özelliğidir.',

    'backup.secure-backup.hint' => 'Plesk veri tabanında bulunan kullanıcıların şifrelerini şifrelemek için bir şifre kullanabilirsiniz. Parolayı vermeden parolayla korunmuş bir yedeklemeyi geri yüklemenin, Plesk\'in rastgele kullanıcı parolaları oluşturmasını sağlayacağını unutmayın.',
    'backup.secure-backup.hintAdmin' => 'Yedeklerde bulunan Plesk veri tabanı şifrelerini Plesk şifreleme anahtarıyla veya bir parola ile şifreleyebilirsiniz. Anahtar her Plesk kurulumuna özeldir. Anahtarla şifrelenen yedeklemeler yalnızca oluşturuldukları Plesk kurulumunda geri yüklenebilir, başka bir Plesk kurulumunda geri yüklenemez. Plesk\'in yedek içindeki tüm hassas verileri korumadığını unutmayın. Yedekleri uzak bulut depolama alanında depolamanızı ve bulut depolama tarafında yedekleme şifrelemesini etkinleştirmenizi öneririz.',
    'backup.secure-backup.usePasswordProtection' => 'Parola koruması kullanın (önerilir)',
    'backup.secure-backup.backupPasswordSource' => 'Şifre tipi',
    'backup.secure-backup.pleskKey' => 'Plesk\'in şifreleme anahtarı',
    'backup.secure-backup.userPassword' => 'Belirtilen şifre',
    'backup.secure-backup.password' => 'Şifre',
    'backup.secure-backup.passwordConfirmation' => 'Şifreyi tekrarlayın',

    'backup.subform.settingsSection' => 'Yedekleme ayarları',
    'backup.subform.prefix' => 'Yedekleme adına bir önek ekleyin',
    'backup.subform.comment' => 'Yorumlar',
    'backup.subform.splitSize' => 'Hacim boyutu (MB) olan çok birimli bir yedekleme oluştur',
    'backup.subform.repository' => 'Burada depola',
    'backup.subform.repositoryDescription' => 'FTP(S) depo ayarları belirtilmedi. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Hem sunucu depolaması, hem de %%name%%',
    'backup.subform.remoteRepository' => 'uzak depolama birimi',
    'backup.subform.remoteRepositoryText' => 'Uzak bulut depolamasını seçin',
    'backup.subform.configureRemoteRepositories' => 'Yedeklemelerinizi bulutta tutmak için, <a href="%%url%%">uzak depolamalarınızı yapılandırabilirsiniz</a>',
    'backup.subform.configureFtpRepository' => 'Yedeklemelerinizi orada tutmak için, <a href="%%url%%">FTP depolamasını yapılandırabilirsiniz</a>',
    'backup.subform.repositoryConfigure' => 'Yapılandırma',
    'backup.subform.email' => 'Yedekleme görevi tamamlandığında, buraya bildirim e-postası gönderin',
    'backup.subform.contentSection' => 'Yedekleme içeriği',
    'backup.subform.domainConfiguration' => 'Yapılandırma',
    'backup.subform.domainConfigurationVhost' => 'Kullanıcı dosyaları ve veritabanları',
    'backup.subform.domainConfigurationMail' => 'Posta mesajları',
    'backup.subform.content' => 'Yedekleyin',
    'backup.subform.backupAll' => 'Tüm yapılandırma ve içerik',
    'backup.subform.backupConfiguration' => 'Yalnızca yapılandırma',
    'backup.subform.backupVhost' => 'Posta mesajları hariç, tüm yapılandırma ve içerik',
    'backup.subform.backupMail' => 'Yalnızca yapılandırma ve posta mesajları',
    'backup.subform.mssqlNativeBackup' => 'Mümkünse, doğal MS SQL yedekleme işlevselliğini kullan',
    'backup.subform.mssqlNativeBackupAdmin' => 'Doğal MS SQL yedekleme işlevselliğini kullanın (Uzak veritabanları için, Araçlar ve Ayarlar> Veritabanı Sunucuları altından uzak MS SQL sunucusunun yedekleme ayarlarını yapılandırdığınızdan emin olun)',
    'backup.subform.localRepository' => 'Sunucu deposu',
    'backup.subform.localRepositoryPath' => '%%path%% yolundaki sunucu deposu',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => '%%uri%% adresindeki FTP(S) depolaması <a href="%%link%%">Ayarları değiştir</a>',
    'backup.subform.ftpRepositoryText' => '%%uri%% adresindeki FTP(S) depolaması',
    'backup.subform.type' => 'Tür',
    'backup.subform.typeFullBackup' => 'Dolu',
    'backup.subform.typeIncremental' => 'Artımlı',
    'backup.subform.typeIncrementalDescription' => 'Son yedeklemeden sonra değişen web ve posta barındırma verilerini yedekleyin (veritabanları her zaman tam yedeklenir).',
    'backup.subform.incrementalNotAvailable' => 'Artan yedeklemeler oluşturmak için, önce tam bir yedekleme oluşturun.',
    'backup.subform.excludeLogs' => 'Günlük dosyalarını hariç tut',
    'backup.subform.excludeFiles' => 'Belirli dosyaları yedeklemeden hariç tut',
    'backup.subform.excludeFilesDescription' => 'Sadece web alanlarındaki dosyaları hariç tutabilirsiniz. Yolu veya yolları web alanı köküne göre, bireysel dosyaları virgülle ayırarak belirtin. Maske simgesi kullanılabilir (örneğin /somedir/log*).',

    'backup.upload.uploadHint' => 'Burada yedekleme dosyalarını Plesk deposuna yükleyebilirsiniz. Maksimum dosya boyutu, iki gigabaytla sınırlıdır.',
    'backup.upload.backupFile' => 'Yedekleme dosyası',
    'backup.upload.removeLink' => 'Sil',
    'backup.upload.addFileLink' => 'Daha fazla dosya yükleyin',
    'backup.upload.backupSecuritySettings' => 'Yedekleme güvenlik ayarları',
    'backup.upload.signatureHint' => 'Plesk, yedekleme dosyalarını geçerli bir yapı ve imza için kontrol eder. Değiştirilen, bozulan veya başka bir sunucuda oluşturulan dosyalara güvenilmez.  Aşağıdaki seçenek, bu dosyalardaki verileri geri yüklemenizi sağlıyor. Bu seçeneği ancak yedekleme kaynağına güveniyorsanız seçin, çünkü böyle bir dosyayı karşıya yüklemek, güvenliği tehlikeye sokabilir veya sunucunun çalışmasını kesintiye uğratabilir. Not: İmzaları bulunmadığından, 11.5 öncesi Plesk sürümlerinde yapılan yedekleme dosyaları güvenilmez kabul edilir. Kaynaklarına güveniyorsanız, bu dosyaları geri yüklediğinizden emin olun.',
    'backup.upload.ignoreSign' => 'Geçerli imzası olmayan yedekleme dosyalarını karşıya yükleyin',
    'backup.upload.passwordHint' => 'Bu yedekleme için şifre koruması kullandıysanız, şifreyi aşağıdaki alanlara girin. Yanlış bir şifre girdiğinizde, Plesk\'in sizi uyaracağını, ancak yedeklemeyi yine de sunucuya yükleyeceğini unutmayın. Yedekleme kurtarması sırasında sizden şifreyi tekrar girmeniz istenecektir.',
    'backup.upload.alreadyExistsWarning' => 'Yedekleme dosyası %%fileName%%, sunucunun yerel deposunda zaten var.',
    'backup.upload.incorrectPasswordWarning' => 'Belirtilen şifre yanlış. Yedekleme kurtarması sırasında Plesk sizden şifreyi tekrar girmenizi isteyecektir.',
    'backup.upload.deprecatedDumpError' => 'Karşıya yüklemeye çalıştığınız yedek, desteklenmeyen bir Plesk sürümünde oluşturuldu ve içeri alınamıyor. Eski Plesk sürümlerindeki verilerinizi aktarmak için Plesk Migrator uzantısını kullanın.',
    'backup.upload.mailFormatWarning' => 'Yedekleme dosyası %%fileName%%, dosyaya karşıya yüklendi. Önemli: Yedekleme dosyası %%fileName%%, biçimini desteklenmediğinden dolayı geri yüklenmeyecek olan posta içeriği içeriyor (Panel 8.3 - 8.6). Bu posta içeriğini geri yükleyebilmek için, Plesk Yedekleme aracını kullanarak onu yedekleyin ve döküm, herhangi bir posta sunucusuna geri yüklenmiş olarak, Posta kutularının içeriğini yedekleyin seçeneğini seçin.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Karşıya yüklenen yedekleme dosyası (%%fileName%%) değiştirilmiş, bozulmuş veya başka bir sunucuda ya da yedeklemelerin imzalanmasını desteklemeyen daha eski bir Plesk sürümünde oluşturulmuş. Bu yedekleme dosyasından verileri geri yüklemeden önce, bu dosyanın kaynağına güvenebileceğinizden emin olun.',
    'backup.upload.corruptedSignatureAdminError' => 'Yedekleme dosyası (%%fileName%%) yüklenemiyor. Dosya değiştirilmiş, bozulmuş veya başka bir sunucuda ya da yedeklemelerin imzalanmasını desteklemeyen daha eski bir Plesk sürümünde oluşturulmuş. Bu yedeklemeye güveniyorsanız, "Geçerli imzaları olmayan yedekleme dosyalarını karşıya yükleyin" seçeneğini seçin ve karşıya yüklemeyi tekrarlayın.',
    'backup.upload.corruptedSignatureUserWarning' => 'Karşıya yüklenen yedekleme dosyası (%%fileName%%) ya değiştirilmiş veya bozulmuş veri içeriyor, ya da başka bir sunucuda veya daha eski bir Plesk sürümünde oluşturulmuş.',
    'backup.upload.corruptedSignatureUserError' => 'Yedekleme dosyası (%%fileName%%) yüklenemiyor. Dosya ya değiştirilmiş veya bozulmuş veri içeriyor, ya da başka bir sunucuda veya daha eski bir Plesk sürümünde oluşturulmuş. Bu dosyadaki verileri geri yüklemek için, barındırma sağlayıcınızla irtibata geçin.',
    'backup.upload.uploadError' => '%%fileName%%, sunucu deposuna karşıya yüklenemiyor: %%error%%',
    'backup.upload.fileNotSelected' => 'Karşıya yüklenecek hiçbir dosya seçilmedi. En az bir dosya seçin.',
    'backup.upload.missedPartsWarning' => "Artan yedeklemenin aşağıdaki parçaları karşıya yüklenmedi:%%endl%%%%missedParts%%%%endl%%Lütfen eksik parçaları karşıya yükleyin.",
    'backup.upload.unknownType' => 'Bilinmeyen nesne türü',
    'backup.upload.storageLink' => 'başka bir depolama',
    'backup.upload.anotherStorage' => 'Döküm, %%storageLink%% üzerine karşıya yüklendi.',
    'backup.upload.resellerNotFound' => '%%name%% satıcısı bulunamadı. Karşıya yüklenen dökümü geri yüklemek için, önce onu oluşturun.',
    'backup.upload.clientNotFound' => '%%name%% müşterisi bulunamadı. Karşıya yüklenen dökümü geri yüklemek için, önce onu oluşturun.',
    'backup.upload.domainNotFound' => 'Alan adı %%name%% bulunamadı. Karşıya yüklenen dökümü geri yüklemek için, önce onu oluşturun.',

    'backup.web-content-dynamic.addButtonTitle' => 'Dosya Ekle',
    'backup.web-content-dynamic.noItems' => 'Hiçbir dosya seçilmedi',
    'backup.web-content-dynamic.hint' => 'Dosya ve klasörleri seçmek için onay kutularını kullanın.',
    'backup.web-content-dynamic.title' => 'Dosyaları Seç',
    'backup.web-content-dynamic.columnName' => 'Adı',
    'backup.web-content-dynamic.columnChangeDate' => 'Değiştirildi',
    'backup.web-content-dynamic.columnSize' => 'Boyut',
    'backup.web-content-dynamic.columnPermissions' => 'Yetkiler',
    'backup.web-content-dynamic.columnUser' => 'Kullanıcı',
    'backup.web-content-dynamic.columnGroup' => 'Grup',
    'backup.web-content-dynamic.waitButtonTitle' => 'Bekleyin',
    'backup.web-content-dynamic.loadingTitle' => 'Lütfen bekleyin. Notiek iel',

    'backup.invalidFields' => 'Bazı alanlar boş veya geçersiz değer içeriyor.',
    'backup.notEnoughDiskSpace' => 'Yedek oluşturmak için %%path%% konumunda yeterli disk alanı yok. En az %%required%% GB boş alan gerekir (%%available%% GB mevcut)',

    'cgroups-settings.cgroupsSettingsTab' => 'Bellek, işlemci, Disk G/Ç',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Bir abonelikle sistem kaynakları tüketimi üzerindeki sınırları ayarlayın. Plesk, sınırların aşılmamasını sağlamak için, kontrol grupları (cgroups) adında bir Linux çekirdeği özelliğini kullanır.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Bireysel abonelikleri, belirtilen miktarda işlemci kullanımıyla sınırlayın.',
    'cgroups-settings.cpuPeriodLimit' => 'İşlemci kullanımını kontrol etme dönemi',
    'cgroups-settings.percentUsageDescription' => 'Toplam işlemci saati miktarı, sunucunuz için %%total%%%%units%% birimine eşittir',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Bireysel abonelikleri, belirtilen miktarda bellek kullanımıyla sınırlayın. Bir abonelik bu sınırı aştığında, en fazla tüketen işlemin durdurulacağını unutmayın.',
    'cgroups-settings.ramPeriodLimit' => 'Bellek kullanımını kontrol etme dönemi',
    'cgroups-settings.diskSettings' => 'Disk G/Ç',
    'cgroups-settings.diskReadSettings' => 'Disk Okuma',
    'cgroups-settings.diskReadSettingsDescription' => 'Bireysel aboneliklerin, disk okuma bant genişliğini sadece belirtilen sınırda kullanmasına izin verin.',
    'cgroups-settings.diskReadPeriodLimit' => 'Disk Okuma kullanımını kontrol etme dönemi',
    'cgroups-settings.diskWriteSettings' => 'Disk Yazma',
    'cgroups-settings.diskWriteSettingsDescription' => 'Bireysel aboneliklerin, disk yazma bant genişliğini sadece belirtilen sınırda kullanmasına izin verin.',
    'cgroups-settings.diskWritePeriodLimit' => 'Disk Yazma kullanımını kontrol etme dönemi',
    'cgroups-settings.limit' => 'Sınır',
    'cgroups-settings.threshold' => 'Aşıldığında bildirin',
    'cgroups-settings.limitNotificationEnabled' => 'Bildirim etkinleştirildi',
    'cgroups-settings.periodFiveMinutes' => '5 dakika',
    'cgroups-settings.periodHour' => '1 saat',
    'cgroups-settings.periodDay' => '1 gün (24 saat)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/sn',

    'custom-button.privateLabel' => 'Sadece bana gösterin',
    'custom-button.textLabel' => 'Buton metni',
    'custom-button.tooltipLabel' => 'Araç ipucu metni',
    'custom-button.iconLabel' => 'Fon resmi',
    'custom-button.priorityLabel' => 'Öncelik',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Parametreleri URL\'ye ekle',
    'custom-button.placeLabel' => 'Konum',
    'custom-button.internalLabel' => 'URL\'yi Plesk\'te açın',
    'custom-button.internalDescription' => 'URL\'yi bir Plesk sayfasında mı, yoksa yeni bir tarayıcı penceresinde mi açacağını belirtin.',
    'custom-button.noFrameLabel' => 'Çerçeveleri kullanmayın',
    'custom-button.noFrameDescription' => 'Bir Plesk uzantısına veya Müşteri Paneli bir uygulamaya götüren özel bir düğme eklediğinizde, bu uzantının/uygulamanın nasıl görüntüleneceğini belirtebilirsiniz: bir çerçevede veya Plesk GUI\'sinin bir parçası olarak.',
    'custom-button.urlParamLabel_dom_id' => 'Abonelik kimliğini, alan adı kimliğini ve alan adı takma adı kimliğini dahil edin',
    'custom-button.urlParamLabel_dom_name' => 'Birincil Alan adını dahil edin',
    'custom-button.urlParamLabel_ftp_user' => 'FTP kullanıcı adını dahil edin',
    'custom-button.urlParamLabel_ftp_pass' => 'FTP şifresini dahil edin',
    'custom-button.urlParamLabel_cl_id' => 'Müşteri kimliğini dahil edin',
    'custom-button.urlParamLabel_cname' => 'Müşterinin şirket adını dahil edin',
    'custom-button.urlParamLabel_pname' => 'Müşterinin kişi adını dahil edin',
    'custom-button.urlParamLabel_email' => 'Müşterinin e-postasını dahil edin',
    'custom-button.buttonPlace_navigation' => 'Ortak Erişim',
    'custom-button.buttonPlace_admin' => 'Yöneticinin Başlangıç sayfası',
    'custom-button.buttonPlace_admin-settings' => 'Yöneticinin Araçlar ve Ayarlar sayfası',
    'custom-button.buttonPlace_reseller' => "Satıcının Başlangıç sayfası",
    'custom-button.buttonPlace_reseller-settings' => 'Satıcının Araçlar ve Yardımcı Programlar sayfası',
    'custom-button.buttonPlace_client' => 'Müşterinin Başlangıç sayfası',
    'custom-button.buttonPlace_domain' => "Aboneliğin Web Siteleri ve Alan Adları sayfası",
    'custom-button.buttonPlace_domain_powerUser' => "Web Alanının Web Siteleri ve Alan Adları sayfası",
    'custom-button.buttonPlace_domain-properties' => 'Web Sitesi Araçları',

    'domain.connection-info.title' => 'Bağlantı bilgisi',
    'domain.connection-info.systemUserCredentials' => 'Sistem kullanıcı bilgileri',
    'domain.connection-info.systemUserCredentialsHint' => 'FTP ile erişime her zaman izin verilir, SSH ya da Uzaktan Masaüstüyle erişim sağlayın. Yalnızca %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'izin verildi',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'SSH ya da Uzaktan Masaüstü erişiminiz etkin ve bu durumu değiştiremezsiniz.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'SSH ya da Uzaktan Masaüstü erişiminiz devre dışı ve bu durumu değiştiremezsiniz.',
    'domain.connection-info.ipAddress' => 'IP Adresi',
    'domain.connection-info.copyToClipboard' => 'Panoya kopyala',
    'domain.connection-info.username' => 'Kullanıcı adı',
    'domain.connection-info.password' => 'Şifre',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Sistem kullanıcı şifre değişimi',
    'domain.connection-info.changePasswordTooltip' => 'Şifreyi değiştirin',
    'domain.connection-info.newPassword' => 'Yeni şifre',
    'domain.connection-info.manageAccess' => 'Erişimi yönet',
    'domain.connection-info.additionalFtpAccounts' => 'Ek FTP hesapları',
    'domain.connection-info.database' => 'Veritabanı',
    'domain.connection-info.databaseHint' => 'Aboneliğe ait %%number%% veri tabanından 1\'i.',
    'domain.connection-info.databaseNotCreatedHint' => 'Veri tabanı oluşturulmadı.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Sunucusu',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Host',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Veritabanı adı',
    'domain.connection-info.addDatabase' => 'Veri tabanı ekle',
    'domain.connection-info.manageDatabases' => 'Veritabanlarını yönetin',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.myLittleAdmin' => 'myLittleAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Veri tabanı kullanıcı şifresi değişimi',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Uygulamanızın yapılandırma dosyalarındaki şifreyi buradan değiştirdikten sonra güncellemeyi unutmayınız.',
    'domain.connection-info.buttonSave' => 'Kaydet',
    'domain.connection-info.buttonSaving' => 'Kaydediliyor...',
    'domain.connection-info.buttonCancel' => 'İptal',

    'domain.move.title' => '%%name%% alan adını taşı',
    'domain.move.hint' => 'Alan adı içeriği, yapılandırma dosyaları, günlük dosyaları ve APS uygulamalarıyla yeni bir aboneliğe taşınacaktır.',
    'domain.move.hintMain' => 'Alan adı içeriği, yapılandırma dosyaları, günlük dosyaları, veritabanları, veritabanı kullanıcıları, ek FTP kullanıcıları, planlanmış görevleri, smb (kobi) kullanıcıları ve APS uygulamalarıyla yeni bir aboneliğe taşınacaktır.',
    'domain.move.hintSubdomains' => 'Alt alan ad(lar)ı %%subdomains%%, üst alan adıyla birlikte taşınır.',
    'domain.move.hintAliases' => 'Alan takma ad(lar)ı %%aliases%%, üst alan adıyla birlikte taşınır.',
    'domain.move.hintSubdomainsAndAliases' => 'Alan takma ad(lar)ı %%subdomains%% ve alan takma ad(lar)ı %%aliases%%, üst alan adıyla birlikte taşınır.',
    'domain.move.labelDatabases' => 'Alan adını taşıdıktan sonra, ilişkili veritabanlarını da taşımak için "Veritabanları" sekmesini açın.',
    'domain.move.hintDatabases' => 'Gerekirse, veritabanlarını ayrı olarak taşıyın.',

    'domain.move.Form.submitButton' => 'Taşı',
    'domain.move.Form.cancelButton' => 'İptal',

    'domain.move.selectTarget' => 'Kullanılabilir abonelikler',
    'domain.move.nothingFound' => 'Hiçbir şey bulunamadı',
    'domain.move.targetIsRequred' => 'Alan adını taşımak istediğiniz aboneliği seçin.',
    'domain.move.selectNewSubscription' => 'Yeni Bir Abonelik Oluşturun',
    'domain.move.ipv4Address' => 'IPv4 adresi',
    'domain.move.ipv4AddressHint' => 'Web sitesinin üzerinde barındığı IP adresi, web sitesinin sanal ana bilgisayarının bir ağ adresidir.',
    'domain.move.ipv6Address' => 'IPv6 adresi',
    'domain.move.ipv6AddressHint' => 'Web sitesinin üzerinde barındığı IP adresi, web sitesinin sanal ana bilgisayarının bir ağ adresidir.',
    'domain.move.ipAddressIsNotSelected' => 'En az bir IP adresinin seçilmesi gerekir.',
    'domain.move.username' => 'Kullanıcı adı',
    'domain.move.usernameHint' => 'Web alanıyla ilişkili sistem kullanıcı hesabı. FTP ve SSH üzerinden barındırılan dosyalara erişmek için kullanılır.',
    'domain.move.usernameIsRequred' => 'Bir kullanıcı adı belirtmeniz gerekir.',
    'domain.move.password' => 'Şifre',
    'domain.move.passwordIsRequred' => 'Bir şifre vermeniz gerekir.',
    'domain.move.noAvailableSubscriptions' => 'Kullanılabilir abonelik yok',
    'domain.move.noWebHosting' => 'Alan adının web barındırması olmadığından, şu an hiçbir sistem kullanıcısı oluşturulmaz.',

    'domain.rename.title' => 'Alan adını değiştir',
    'domain.rename.titleAlias' => 'Takma alan adını değiştir',
    'domain.rename.hint' => '%%domainName%% alan adını değiştiriyorsunuz',
    'domain.rename.hintAlias' => '%%domainName%% takma alan adı değiştiriyorsunuz',
    'domain.rename.name' => 'Yeni alan adı',
    'domain.rename.nameAlias' => 'Yeni takma alan adı',
    'domain.rename.domainNameIsRequired' => 'Bu gerekli alan boş.  Bir değer belirtmeniz gerekiyor.',
    'domain.rename.submitButton' => 'Değiştir',
    'domain.rename.submitButtonProgress' => 'Değiştiriliyor',
    'domain.rename.successMessage' => '%%oldName%% alan adı %%newName%% olarak değiştirildi.',
    'domain.rename.successMessageAlias' => '%%oldName%% takma alan adı %%newName%% olarak değiştirildi.',

    'domain.rename.Form.cancelButton' => 'İptal',

    'domain.outgoing-messages.hint' => 'Burada, bu alan adı için giden mesaj sayısının sınırını değiştirebilirsiniz. Belirtilen sınırdan daha fazla mesaj göndermek mümkün olmaz.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Varsayılan (saatte %%domainOutgoingMessages%% mesaj)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'saatteki mesaj sayısı',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Giden mesajların sınırı',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Bu alan adı için özel değer',

    'domain.tech-domain-name.title' => 'Alan adınızı seçin',
    'domain.tech-domain-name.techDomainTitle' => 'Geçici alan adı',
    'domain.tech-domain-name.customDomainTitle' => 'Kayıtlı alan adı',
    'domain.tech-domain-name.techDomainText' => 'Henüz kayıtlı bir alan adım yok',
    'domain.tech-domain-name.customDomainText' => 'Zaten kayıtlı bir alan adım var',
    'domain.tech-domain-name.techDomain' => 'Geçici alan adınız',
    'domain.tech-domain-name.customDomain' => 'Kayıtlı alan adı',
    'domain.tech-domain-name.domainName' => 'Alan adı',
    'domain.tech-domain-name.techDomainDesc' => 'Geçici alan adları, kaydolup kurallara uygun bir alan adı satın almadan önce siteye erişiminizi sağlamak için kullanılır. Aşağıdaki şartlarla ücretsiz sağlanır:',
    'domain.tech-domain-name.techDomainRandom' => 'Adlar rastgele üretilir',
    'domain.tech-domain-name.techDomainDns' => '.plesk.page DNS bölgesinde barındırılırsa',
    'domain.tech-domain-name.techDomainMail' => 'Geçici alan adına sahip posta kullanamazsınız',
    'domain.tech-domain-name.techDomainSwitch' => 'Alan adı ayarlarından alan adınızı yeniden ayarlayarak kayıtlı bir alan adına geçebilirsiniz.',
    'domain.tech-domain-name.error' => 'Beklenmeyen bir hata meydana geldi.',
    'domain.tech-domain-name.errorNoIpAddress' => 'IP adresini seçmelisiniz.',
    'domain.tech-domain-name.generating' => 'Üretiliyor...',

    'get-password.label' => 'Parolayı sıfırla',
    'get-password.text' => 'Plesk\'te kayıtlı olan e-posta adresinizi ya da kullanıcı adınızı girdiğinizde size bir parola sıfırlama e-postası göndereceğiz.',
    'get-password.emailLabel' => 'E-posta adresi',
    'get-password.loginLabel' => 'Kullanıcı adı',
    'get-password.send' => 'Gönder',
    'get-password.cancel' => 'İptal',
    'get-password.errorInvalidEmail' => 'E-posta adresi kabul edilmedi. Lütfen iki defa kontrol edin ve yeniden deneyin.',
    'get-password.messageSend' => "Şifre sıfırlama e-postası ilgili e-posta adresine gönderildi.\nE-posta ulaşmazsa lütfen Plesk yöneticinizle iletişime geçin.",

    'iis-settings.formGeneralHint' => 'Burada varsayılan değerleri değiştirerek, web siteniz için IIS web sunucusu ayarlarını belirtebilirsiniz.  Özel IIS yapılandırması, örneğin web sitenizdeki yeni tip indeks dosyalarını kullanmak veya belli bir MIME tipini belli dosya adı uzantılarıyla ilişkilendirmek istediğinizde yararlı olur.  Varsayılan değerler, barındırma sağlayıcınız tarafından tanımlanır.',
    'iis-settings.formGeneralHint_powerUser' => 'Burada bu web sitesi için IIS web sunucusu ayarlarını belirtebilirsiniz. Özel IIS yapılandırması, örneğin web sitenizdeki yeni tip indeks dosyalarını kullanmak veya belli bir MIME tipini belli dosya adı uzantılarıyla ilişkilendirmek istediğinizde yararlı olur.  Varsayılan değerler, IIS\'in varsayılan yapılandırmasından ilgili direktifleri kullanacağı anlamına geliyor.',
    'iis-settings.virtualDirectoryLoadError' => 'Belirtilen sanal dizinin özellikleri alınamıyor: %%errorMessage%%',
    'iis-settings.general' => 'Ortak ayarlar',
    'iis-settings.example' => "Örneğin:\n%%example%%",
    'iis-settings.settingOn' => 'Açık',
    'iis-settings.settingOff' => 'Kapalı (Varsayılan)',
    'iis-settings.settingDefault' => 'Varsayılan',
    'iis-settings.settingCustom' => 'Özel değeri girin',
    'iis-settings.mimeTypes' => 'MIME türleri',
    'iis-settings.mimeTypesExample' => "metin/düz .mytxt\n image/jpeg .myjpeg \n\nMIME tipleri, dosya uzantılarını dosya tipleriyle ilişkilendirir. Bu genellikle ortak dosya tipleri için bir özel dosya uzantısı oluşturmak için kullanılır.",
    'iis-settings.documents' => 'Varsayılan belgeler',
    'iis-settings.documentsOff' => 'Devre Dışı Bırakıldı',
    'iis-settings.documentsCustom' => 'Değerleri girin',
    'iis-settings.documentsExample' => "Index.html\n Index.htm\n Index.cfm \n\n Tarayıcılar, sitenizdeki bir belgenin adını vermiyorsa, IIS belirtilen varsayılan belgeleri arar ve ilk bulduğuna servis sağlar.  Varsayılan belgeleri belirtmez, ancak Dizin görüntülemeyi açarsanız, dizin listesi indeks sayfası yerine tarayıcıda görüntülenir.",
    'iis-settings.expires' => 'Süre Sonu',
    'iis-settings.expiresDescription' => 'Web sunucusu web sayfalarına "Süre Sonu" yanıt başlıklarını ekler. Süre sonu zaman damgası, web sayfasının istendiği zamanın üstünde belirtilen süre eklenerek bulunur.',
    'iis-settings.expiresUnitDays' => 'gün',
    'iis-settings.expiresUnitHours' => 'saat',
    'iis-settings.expiresUnitMinutes' => 'dakika',
    'iis-settings.expiresUnitSeconds' => 'saniye',
    'iis-settings.headers' => 'Ek üst bilgiler',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY\n\nWeb sunucusu, belirtilen HTTP yanıt üst bilgilerini ekler.",
    'iis-settings.directoryBrowsing' => 'Dizin görüntüleme',
    'iis-settings.directoryBrowsingDescription' => 'Kullanıcıların, örneğin varsayılan indeks sayfası olmadığında sitenin dizin listesini web tarayıcılarında görmesine izin verir.',
    'iis-settings.securityTabDirectory' => 'Dizin güvenlik ayarları',
    'iis-settings.allowAnonymous' => 'Anonim doğrulaması',
    'iis-settings.allowAnonymousDescription' => 'Anonim doğrulama, kullanıcıların sitenizin genel içeriğine erişmesine izin verir. Sitenizin şifre korumalı içeriği ve bir dosya sistemi seviyesinde korunmuş içerik, anonim kullanıcılar tarafından kullanılamaz.',
    'iis-settings.allowWindows' => 'Windows doğrulaması',
    'iis-settings.allowWindowsDescription' => 'Windows doğrulaması (eski adıyla NTLM), sitenizin içeriğini bir dosya sistemsi seviyesinde korur.',
    'iis-settings.requireSsl' => 'SSL/TLS iste',
    'iis-settings.requireSslDescription' => 'Siteniz için SSL/TLS desteğini etkinleştirdiğinizde, bu seçenek web istemcilerini (tarayıcılarını) sadece güvenli HTTPS bağlantıları kullanmaya zorlar.',
    'iis-settings.securityTabIpDeny' => 'Erişimi sınırlama ayarları',
    'iis-settings.deny' => 'Siteye erişimi reddedin',
    'iis-settings.denyOff' => 'Varsayılan',
    'iis-settings.denyCustom' => 'Özel değeri girin',
    'iis-settings.allow' => 'Dışta Tutulan',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nBelirtilen ana bilgisayar ve ağların siteye erişimi yasaktır. Tüm bağlantıları reddetmek için '*' kullanın.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n Belirtilen ana bilgisayar ve ağların siteye erişimine izin verilir.",
    'iis-settings.dynamicIpSecurity' => 'IIS dinamik IP sınırlamasıyla DoS saldırılarını önleme',
    'iis-settings.isDenyByConcurrentRequests' => 'IP adreslerini benzersiz bir IP adresinden gelen eşzamanlı istek sayısına göre reddet',
    'iis-settings.maxConcurrentRequests' => 'Maksimum eşzamanlı istek sayısı',
    'iis-settings.isDenyByRequestRate' => 'IP adreslerini belli bir sürede gelen istek sayısına göre reddet',
    'iis-settings.maxRequests' => 'Maksimum istek sayısı',
    'iis-settings.requestInterval' => 'Zaman dönemi (milisaniye olarak)',

    'ip-addresses-selector.ipAddress' => 'IP Adresi',
    'ip-addresses-selector.ipv4Address' => 'IPv4 adresi',
    'ip-addresses-selector.ipv4AddressHint' => "Web sitesinin üzerinde barındığı IP adresi, web sitesinin sanal ana bilgisayarının bir ağ adresidir.",
    'ip-addresses-selector.ipv6Address' => 'IPv6 adresi',
    'ip-addresses-selector.ipv6AddressHint' => "Web sitesinin üzerinde barındığı IP adresi, web sitesinin sanal ana bilgisayarının bir ağ adresidir.",
    'ip-addresses-selector.noIpAddressHint' => 'Hiçbiri',
    'ip-addresses-selector.shared' => 'paylaşılan',
    'ip-addresses-selector.exclusive' => 'atanmış',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP sunucusu IPv6\'yı desteklemiyor. En az bir IPv4 adresi ayırın, aksi takdirde kullanıcı sunucuya FTP üzerinden dosya yükleyemeyecek.',

    'log-rotation.customLogsDescription' => 'Özel günlükleriniz döndürülmediğini unutmayın.',
    'log-rotation.logRotation' => 'Günlük döndürmesi',
    'log-rotation.logRotationCondition' => 'log dönüşüm periyodu',
    'log-rotation.logRotationBySize' => 'Boyutuna göre',
    'log-rotation.logRotationByTime' => 'Zamana göre',
    'log-rotation.logRotationDaily' => 'Günlük',
    'log-rotation.logRotationWeekly' => 'Haftalık',
    'log-rotation.logRotationMonthly' => 'Aylık',
    'log-rotation.logRotationSizeDescription' => 'Boyut değerinin %%min%% ile %%max%% kB arasında olması gerekir.',
    'log-rotation.maximumNumberOfFiles' => 'Maksimum log dosyası sayısı',
    'log-rotation.compress' => 'Log dosyalarını sıkıştır',
    'log-rotation.sendLogToEmail' => 'Plesk web ve FTP sunucularının günlük dosyalarından veri aldıktan sonra, günlükleri e-postayla bu adrese gönderin',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'Dönem, sunucu çapında %%max%% sınırını aşamaz.',

    'login.loginLabel' => 'Kullanıcıadı',
    'login.passwdLabel' => 'Şifre',
    'login.localeLabel' => 'Arayz dili',
    'login.defaultLocale' => 'Varsayılan',
    'login.loginButtonLabel' => 'Oturum aç',
    'login.enterLoginAndPasswd' => 'Kullanıcı adınızı ve şifrenizi girin.',
    'login.whatUsernamePassword' => 'Hangi kullanıcı adı ve şifre kullanılsın?',
    'login.forgotPasswordLabel' => 'Şifrenizi mi unuttunuz?',
    'login.cookies' => 'Plesk çerez politikası',
    'login.avoidSSLWarningsMsg' => 'Plesk\'te oturum açarken SSL hatalarından kaçınmak için %%link%% kullanın',
    'login.digitalOceanMsg' => 'DigitalOcean\'da Plesk\'e yeni misiniz? Giriş yapmak için "root" ve bu damlacığı oluştururken girilen parolayı kullanın. %%link%%',
    'login.amazonLightsailMsg' => 'Lightsail\'de Plesk\'e yeni misiniz? Plesk\'e giriş yapmak için SSH ile sunucuya erişin ve "plesk login" komutunu kullanın. %%link%%',
    'login.readGuide' => 'Kılavuzu tamamen okuyun.',

    'panel-access.title' => 'Plesk URL\'si özelleştiriliyor',
    'panel-access.hint' => 'Plesk\'e giriş yapmak için özel URL\'leri seçin. Bu, Plesk\'e %%httpsPort%% portu ile giriş yapma ihtimalini kaldırmaz. %%link%%',
    'panel-access.details' => 'Daha fazla ayrıntı',
    'panel-access.proxyEnabled' => 'Sunucu IP adresine çözümlenen ancak barındırma için kullanılmayan tüm alan adları ve alt alan adları',
    'panel-access.proxyDomain' => 'Sunucu IP adresine çözümlenen ancak barındırma için kullanılmayan bazı alan adları ve alt alan adları',
    'panel-access.proxyDisabled' => 'Özel URL yok. Yalnızca https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Kaydet',
    'panel-access.Form.cancelButton' => 'İptal',

    'panel-access.domainNameIsRequired' => 'Bir alan adı sağlamalısınız.',
    'panel-access.successMessage' => 'Seçilen oturum açma yöntemi uygulandı.',
    'panel-access.notSupported' => 'Plesk\'iniz seçilen oturum açma yöntemini desteklemiyor.',
    'panel-access.notViaDomainName' => 'Bu şekilde giriş yapmak için ilk seçeneği seçin (" Tüm alan adları ve alt alan adları...") Plesk\'te https://%%domainName%% yoluyla oturum açın ve sonra ikinci seçeneği seçin.',
    'panel-access.notViaPort' => 'Bu şekilde giriş yapmak için Plesk\'te https:// yoluyla oturum açın<server-IP-or-hostname>Önce :%%httpsPort%%.',

    'php-settings.performance' => 'Performans ve güvenlik ayarları',
    'php-settings.settings' => 'Ortak ayarlar',
    'php-settings.fastCgiSettings' => 'FastCGI ayarları',
    'php-settings.fpmSettings' => 'PHP-FPM ayarları',
    'php-settings.enableFastcgi' => 'FastCGI ayarlarını etkinleştir',
    'php-settings.plainTextEditing' => 'Ek direktifler',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Aşağıdaki alana girerek, herhangi bir PHP parametresini tanımlayabilirsiniz. Direktifler, PHP yapılandırmasına dahil edilir. php.ini için kullanacağınız aynı sözdizimini kullanın. Örneğin mSQL uzantısını otomatik olarak yüklemek için, şu satırı ekleyin: uzantı=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Özel PHP parametrelerini bulamıyorsanız, bunları aşağıdaki alana ekleyin.  Bu ek direktifler, ana servis planının direktifleriyle birleştirilir. php.ini için kullandığınızla aynı sözdizimini kullanın. Örneğin mSQL uzantısını otomatik olarak yüklemek istiyorsanız, satırı ekleyin: uzantı=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Aşağıdaki alana girerek, herhangi bir PHP parametresini tanımlayabilirsiniz. Direktifler, PHP yapılandırmasına dahil edilir. php.ini için kullanacağınız aynı sözdizimini kullanın. Örneğin mSQL uzantısını otomatik olarak yüklemek için, şu satırı ekleyin: uzantı=msql.so. PHP-FPM havuzu ayarlarını özelleştirmek için, [php-fpm-pool-settings] ayırıcıyı ekleyin ve istenilen ayarları aşağıya girin.',
    'php-settings.additionalConfigurationDirectives' => 'Ek yapılandırma direktifleri',
    'php-settings.defaultValue' => 'Varsayılan',
    'php-settings.predefinedValue' => 'Değer seç',
    'php-settings.customValue' => 'Özel değeri girin',
    'php-settings.phpSettingDescription_memory_limit' => 'Bir komut dosyasının ayırmasına izin verilen (bayt cinsinden) maksimum bellek miktarı.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Bir komut dosyasının sona erdirilmeden önce çalışmasına izin verildiği (saniye cinsinden) maksimum süre.',
    'php-settings.phpSettingDescription_max_input_time' => 'Bir komut dosyasının giriş verilerini ayrıştırmasına izin verildiği (saniye cinsinden) maksimum süre.',
    'php-settings.phpSettingDescription_post_max_size' => 'POST yöntemiyle yayınlanabilecek verilerin (bayt cinsinden ) maksimum boyutu. Genellikle upload_max_filesize öğesinden daha büyük ve memory_limit öğesinden daha küçük olacaktır.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Karşıya yüklenen bir dosyanın (bayt cinsinden) maksimum boyutu.',
    'php-settings.phpSettingDescription_safe_mode' => 'PHP güvenli modu, büyük ölçüde güvenlik nedenlerinden ötürü komut dosyalarını yürütme üzerinde bir dizi sınırlama getirir.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'safe_mode direktifi devredeyken, belirtilen dizindeki dosyalara PHP komut dosyalarıyla erişilebilir. Dizinin ayrıca include_path altında da olması gerekir.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'safe_mode direktifi devredeyken, belirtilen dizindeki programlar PHP komut dosyalarıyla yürütülebilir.',
    'php-settings.phpSettingDescription_include_path' => 'Komut dosyalarının dosyaları aradığı dizinlerin listesi (sistemin PATH değişkenine benzer). Dizinleri ayırmak için, Linux\'ta iki nokta üst üste (:), Windows\'taysa noktalı virgül (;) kullanın.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'PHP\'nin oturum dosyalarının depolanacağı dizin.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Posta göndermek için kullanılan mail ().',
    'php-settings.phpSettingDescription_register_globals' => 'EGPCS (Ortam, GET, POST, Cookie, Sunucu) değişkenlerinin içeriğini küresel değişkenler olarak kaydedin.',
    'php-settings.phpSettingDescription_open_basedir' => 'Belirtilen dizinlerdeki dosyalara PHP komut dosyalarıyla erişilebilir. Dizinleri ayırmak için, Linux\'ta iki nokta üst üste (:), Windows\'taysa noktalı virgül (;) kullanın.',
    'php-settings.phpSettingDescription_error_reporting' => 'Hata raporlama seviyesi.',
    'php-settings.phpSettingDescription_display_errors' => 'Hataların, çıkışın bir parçası olarak görüntülenip görüntülenmeyeceğini belirler.',
    'php-settings.phpSettingDescription_log_errors' => 'PHP hatalarının kaydını etkinleştirin.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'PHP dosya işlevlerinin FTP veya http ile uzak konumlardan veri almasına izin verir.',
    'php-settings.phpSettingDescription_file_uploads' => 'Dosyaları http üzerinden karşıya yüklemeye izin verir.',
    'php-settings.phpSettingDescription_short_open_tag' => 'PHP\'nin açık etiketinin kısa şekline ( ) izin verir.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'GPC (Alın/Gönder/Çerez) işlemleri için magic_quotes durumunu ayarlar. magic_quotes açık olduğunda, tüm tek tırnak, çift tırnak, ters eğik çizgi ve NULL özel karakterleri, ters eğik çizgi ile otomatik olarak geçersiz kılınır.',
    'php-settings.phpSettingDescription_disable_functions' => 'Bu direktif, belli işlevleri devre dışı bırakmanıza izin verir. Virgülle ayrılmış bir işlevi adları listesi alır',
    'php-settings.phpSupport' => 'PHP desteği',
    'php-settings.phpRunAs' => 'PHP\'yi farklı çalıştır',
    'php-settings.phpVersion' => 'PHP versiyonu',
    'php-settings.phpHandlerOutdated' => '(Eskimiş)',
    'php-settings.phpHandlerDeprecated' => '(Kaldırılmış)',
    'php-settings.phpServedByApache' => 'Apache tarafından sunulur',
    'php-settings.phpServedByNginx' => 'ngnix tarafından sunulur',
    'php-settings.phpSettingsPhpVersion' => 'PHP sürümünüz %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP kapanır.',
    'php-settings.phpHandlerTypeHint' => 'Aşağıda, web sitesinin PHP yapılandırmasının ayrıntıları verilmiştir. Barındırma sağlayıcısı size ilgili izinleri veriyorsa, PHP yapılandırmasını değiştirebilirsiniz.',
    'php-settings.fpmDedicatedHandlerHint' => 'Bu işleyiciyi kullanmak bir internet sitesinin kararlılığını artırırken ekstra hafıza tüketimine sebep olur.',
    'php-settings.phpHandlerChangeHint' => 'PHP işleyici ayarlarını değiştirdin. Bu ayarları kaydedersen, sunucu yapılandırmasından dolayı internet sitenizdeki PHP komutları %%interval%% saniye boyunca durabilir.',
    'php-settings.phpHandlerTypeHelpLink' => 'En uygun PHP ayarlarını nasıl seçebileceğinizi öğrenin',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'Geçerli barındırma yapılandırması bu alan adı için kullanılabilir herhangi bir PHP sürümü içermediğinden, PHP desteği etkinleştirilemiyor.',
    'php-settings.phpHandlersNotAvailableHint' => 'Geçerli Plesk yapılandırması kullanılabilir herhangi bir PHP sürümü içermediğinden, PHP desteği etkinleştirilemiyor.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Diğer PHP sürümlerinin nasıl etkinleştirileceğini öğrenin.',
    'php-settings.phpSupportEditable' => '(%%version%% PHP sürümü, PHP\'yi %%handler%% olarak çalıştır) %%link%%',
    'php-settings.phpSupportReadonly' => '(sürüm: %%version%%; işleyicisi: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(kayıtlı değil) %%link%%',
    'php-settings.showPhpInfo' => 'phpinfo() sayfasını görüntüle',
    'php-settings.phpSettingsFormError' => 'Gerekli veriler eksik olduğundan, PHP ayarları alınamıyor.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Bu işleyici bozuktur, PHP ayarları alınamıyor.',
    'php-settings.showPhpInfoTitle' => 'phpinfo() görüntüle',
    'php-settings.showPhpInfoDescription' => 'PHP ayarlarınızın bazıları değiştirildi, ancak değişiklikler henüz kaydedilmedi. phpinfo() sayfasındaki yeni değerleri görmek için lütfen önce değişiklikleri uygulayın. Aksi takdirde güncel değerleri görürsünüz.',
    'php-settings.showPhpInfoButton' => 'phpinfo() görüntüle',
    'php-settings.onState' => 'Açık',
    'php-settings.offState' => 'Kapalı',

    'pmm.agent.sync.check' => 'Migration & Transfer Agent güncellemeleri kontrol ediyor.',
    'pmm.agent.sync.updating' => 'Migration & Transfer Agent senkronize etme ve indirme',
    'pmm.agent.sync.done' => 'Migration & Transfer Agent başarıyla senkronize edildi.',
    'pmm.agent.sync.downloadLink' => 'Göç başlatılmadan önce kaynak ana bilgisayarına yüklenmesi gereken Migration & Transfer Agent dosyasını indirmek için tıklatın.',
    'pmm.agent.sync.error' => 'Migration & Transfer Agent güncellemeleri alamadı. Lütfen daha sonra yeniden deneyin.',

    'restore-password.title' => 'Şifrenizi Değiştirin',
    'restore-password.passwordLabel' => 'Yeni şifre',
    'restore-password.buttonRestore' => 'Kaydet',
    'restore-password.buttonCancel' => 'İptal',
    'restore-password.isEmpty' => 'Gerekli alan boş. Bir değer belirtmeniz gerekiyor.',
    'restore-password.errorInvalidSecret' => 'Geçersiz gizli kod',
    'restore-password.errorNotFoundSecret' => 'Lütfen yeni bir gizli kod isteyin',
    'restore-password.restoreSuccess' => 'Parolanız güncellendi. Plesk\'te veya e-posta adresinizde oturum açmak için yeni parolayı kullanın.',

    'scheduler.settings.schedulerNotification' => 'Planlayıcı bildirimi',
    'scheduler.settings.notificationOff' => "Kapalı",
    'scheduler.settings.notificationDefault' => "Varsayılan e-postaya gönderin (%%email%%)",
    'scheduler.settings.notificationCustom' => "Belirttiğim e-postaya gönderin",
    'scheduler.settings.crontabSecureShell' => 'Crontab kabuğu',
    'scheduler.settings.schedulerTimezoneSelector' => 'Bir saat dilimini kullanarak, görev planını göster',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Sistemin varsayılan saat dilimini kullan (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Sistemin varsayılan saat dilimini kullan',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Saat dilimi I kullanın, belirtin',

    'scheduler.task.active' => 'Etkin',
    'scheduler.task.subscription' => 'Abonelik',
    'scheduler.task.subscription_powerUser' => 'Web alanı',
    'scheduler.task.type' => 'Görev tipi',
    'scheduler.task.typeCommand' => 'Bir komutu çalıştır',
    'scheduler.task.typeUrl' => 'Bir URL Getir',
    'scheduler.task.typeScript' => 'Bir PHP komut dosyasını çalıştır',
    'scheduler.task.command' => 'Komut',
    'scheduler.task.arguments' => 'bağımsız değişkenli',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Bir mutlak URL belirtin, örneğin http://example.com. Yanıt durum kodu 2xx veya 3xx olduğunda, görevin başarıyla yürütüldüğü kabul edilir.',
    'scheduler.task.script' => 'Komut satırı yolu',
    'scheduler.task.scriptRelativePathDescription' => 'Örnek: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Komut dosyasının tam yolunu belirtin. Örnek: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'PHP sürümünü kullan',
    'scheduler.task.scriptPathPopupTitle' => 'Komut satırı yolu',
    'scheduler.task.run' => 'Çalıştır',
    'scheduler.task.on' => 'açık',
    'scheduler.task.at' => 'alır',
    'scheduler.task.sysUser' => 'Sistem kullanıcısı',
    'scheduler.task.hourly' => 'Saatlik',
    'scheduler.task.daily' => 'Günlük',
    'scheduler.task.weekly' => 'Haftalık',
    'scheduler.task.monthly' => 'Aylık',
    'scheduler.task.yearly' => 'Yıllık',
    'scheduler.task.cronStyle' => 'Cron stili',
    'scheduler.task.cronStyleError' => 'Geçersiz crontab sözdizimi.',
    'scheduler.task.cronStyleErrorWin' => 'Taksim (/) ve çizgi (-) kullanılması yasaktır.',
    'scheduler.task.cronStyleHint' => 'UNIX crontab "dakika saat ayın-günü ay haftanın-günü" biçimini kullanın. Örnek "0 22 * * 1-5". Plesk, görevi gerçekleştirmek için varsayılan sistem saat dilimini kullanır.',
    'scheduler.task.cronStyleWinHint' => '"dakika saat ayın-günü ay haftanın-günü" biçimi kullanın, örneğin "0 22 * * 6,7". Plesk, görevi gerçekleştirmek için varsayılan sistem saat dilimini kullanır.',
    'scheduler.task.notify' => 'Uyarı',
    'scheduler.task.notifyIgnore' => 'Bilgilendirme',
    'scheduler.task.notifyErrors' => 'Yalnızca hatalar',
    'scheduler.task.notifyAlways' => 'Her zaman',
    'scheduler.task.notifyErrorsHint' => 'Bildirimler, komutun standart hata akışını içerir. Akış boşsa hiçbir bildirim gönderilmez.',
    'scheduler.task.notifyErrorsHintWin' => 'Bildirimler, komut çıkışını içerir ve sadece çıkış kodu sıfır olmadığında gönderilir.',
    'scheduler.task.notifyAlwaysHint' => 'Bildirimler, komut çıkışını içerir. Çıkış boşsa hiçbir bildirim gönderilmez.',
    'scheduler.task.notifyAlwaysHintWin' => 'Bildirimler, komut çıkışını içerir ve çıkış kodu komutu ne olursa olsun, gönderilir.',
    'scheduler.task.emailType' => 'Bildirimleri buraya gönder',
    'scheduler.task.emailTypeDefault' => 'Varsayılan sistem kullanıcısı (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Aboneliğin sahibi (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Yönetici (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Diğer kullanıcılar',
    'scheduler.task.emailTypeCustomDescription' => 'Virgülle ayırarak birden fazla adres belirtebilirsiniz.',
    'scheduler.task.minute' => 'dakika',
    'scheduler.task.shortMinute' => 'Min',
    'scheduler.task.dayOfMonth' => 'Gün',
    'scheduler.task.description' => 'Tanım',
    'scheduler.task.scheduleTimezoneHint' => 'Görevin çalıştırılacağı saat dilimi: %%timezone%%',
    'scheduler.task.runTaskNow' => 'Şimdi Çalıştır',
    'scheduler.task.runningTask' => '"%%task%%" görevi çalıştırılıyor...',

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Varsayılan sunucu çapındaki değer (saatte %%default%% mesaj)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Plan için özel değer',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Abonelik için özel değer',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'mesajlar',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Bir posta kutusundan giden mesajlar (saatte)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Bir alan adından giden mesajlar (saatte)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Bir abonelikten giden mesajlar (saatte)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Bir sonraki saatte gönderilecek olan, saatteki sınırı aşan mesajların yüzdesi',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Bir posta kutusundan giden e-posta mesajlarının sınırı saatte 100, yüzdesiyse %10 ise, o zaman kullanıcının saatte 110 mesaj göndermesine izin verilir; 100 mesaj, bir saat içinde gönderilir, 10 mesajsa posta sırasına konur ve bir sonraki saat içinde gönderilmeleri planlanır.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail kullanım ilkesi',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Varsayılan sunucu çapındaki ayarlar (Sendmail\'e izin verilir)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Varsayılan sunucu çapındaki ayarlar (Sendmail\'e izin verilmez)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Plan için özel ayarlar',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Abonelik için özel ayarlar',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Komut dosyaları ve bu abonelikteki kullanıcılar için Sendmail kullanmaya izin ver',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Komut dosyaları ve kullanıcılar, Sendmail kullanarak, bir posta kutusu ve alan adı sınırları aşıldığında bile (aboneliğin sistem kullanıcısı adına) Eposta mesajları gönderebilecektir. Sendmail ile gönderilebilecek maksimum mesaj sayısı, bütün bir aboneliğin sınırıyla tanımlanır.',

    'setup.hint' => 'Sunucunuzu yönetmenize yardımcı olan bir kontrol paneli olan Plesk\'e hoş geldiniz. Plesk, kodlama için hazır bir ortam sağlar ve size, web sitesi ve uygulama geliştirmenize yardımcı olacak güçlü bir uzantılar seti sunar. Plesk\'i kullanmaya başlamak için, kurulum işlemini tamamlayın (sadece bir dakika sürer).',
    'setup.contactInfoSection' => 'Kişi Bilgileri',
    'setup.contactInfoSectionHint' => 'Kendinizi sunucunun sahibi olarak tanıtmak ve sunucuyla ilgili önemli bildirimleri almak için adınızı ve e-posta adresinizi girin. Kurumsal bir sunucunun yöneticisiyseniz, kişisel adınızı veya e-posta adresinizi girmeyin. Veri koruma hukukunun ihlal edilme olasılığını önlemek için, onun yerine iş unvanınızı ve kurumsal e-posta adresinizi kullanın.',
    'setup.contactName' => 'Kişi Adınız',
    'setup.emptyContactName' => 'Lütfen bir kişi adı girin.',
    'setup.contactNameTooLong' => 'İrtibat adı çok uzun (maksimum %max% simgeye izin verilir).',
    'setup.email' => 'E-posta',
    'setup.emptyEmail' => 'Lütfen bir e-posta adresi verin.',
    'setup.passwordSection' => 'Şifre',
    'setup.passwordSectionHint' => 'Plesk\'te bir sonraki oturumunuzda, \'admin\' kullanıcı adını ve aşağıya girilen parolayı kullanın.',
    'setup.password' => 'Şifre',
    'setup.licenseSection' => 'Lisans',
    'setup.licenseSectionHint' => 'Plesk\'i kullanmaya başlamak için bir lisans kurmanız gerekir.',
    'setup.licenseType' => 'Lisans tipinizi seçin',
    'setup.licenseTypePaid' => 'Ödenmiş bir lisansla devam edin',
    'setup.onlineStoreLink' => 'Çevrimiçi Mağaza',
    'setup.licenseTypeTrial' => 'Tam özellikli bir deneme lisansıyla devam edin',
    'setup.activationCodeHint' => 'Zaten bir Plesk lisansı satın aldıysanız, aldığınız etkinleştirme kodunu buraya yapıştırın. Yoksa, %%onlineStoreLink%% üzerinden yeni bir lisans satın alabilirsiniz.',
    'setup.privacyPolicyLink' => 'Plesk Gizlilik İlkesi',
    'setup.trialLicenseAgreement' => 'Plesk International GmbH, dahili sistemlerinde bulunan ve %%privacyPolicyLink%% doğrultusunda verilen bilgileri, bir deneme lisansı vermek için kullanacak ve işlemden geçirecektir.',
    'setup.eulaAgreementLabel' => '%%link%%\'yı okuyup kabul ettiğimi on aylarım',
    'setup.eula' => 'Son Kullanıcı Lisans Sözleşmesi',
    'setup.invalidEulaAgreementValue' => 'Son Kullanıcının Lisans Sözleşmesini kabul etmeniz gerekir',
    'setup.sendButton' => 'Plesk\'e Gir >>',

    'ssl-certificate.add.name' => 'Sertifika adı',
    'ssl-certificate.add.longName' => 'Belirtilen sertifika adı çok uzun (maksimum %max% simgeye izin verilir).',
    'ssl-certificate.add.certificateNameUsed' => '%%name%% adına bir sertifika zaten var.',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS sertifikası verildi. Çalışmasını sağlamak için, sertifikayı güvenli bir alan adına, postaya veya web postasına atayın.',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS sertifikası başarıyla güncellendi.',
    'ssl-certificate.add.settings' => 'Ayarlar',
    'ssl-certificate.add.settingsHint' => 'Bir sertifika isteği oluşturmak, sağlayıcınızdan bir sertifika satın almak veya kendiliğinden imzalı bir sertifika oluşturmak için bu formu kullanın.',
    'ssl-certificate.add.settingsHint2' => 'Bir istek, formda belirttiğiniz alan adınız hakkında bilgi içeren bir CSR dosyasıdır. Sizin için bir sertifika vermesi için isteği bir sertifika yetkilisine gönderebilirsiniz. Sonra aşağıdaki Karşıya Yükleme formlarından birini kullanarak onu karşıya yüklersiniz.',
    'ssl-certificate.add.settingsHint3' => 'Kendiliğinden imzalı bir sertifika, onu oluşturan kişinin kendisi tarafından imzalanan bir kimlik sertifikasıdır. Böyle bir sertifika kullanıyorsanız, sitelerinizin kimliğini kendiniz doğruluyorsunuzdur. Kendiliğinden imzalı sertifikalar, SSL/TLS kullanılmasına izin vermesine rağmen, bunlar daha az güvenilir ve daha az güvenli kabul edilirler.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'Ülke',
    'ssl-certificate.add.state' => 'İl/İlçe',
    'ssl-certificate.add.longState' => 'Belirtilen eyalet veya il adı çok uzun.',
    'ssl-certificate.add.city' => 'Konum (şehir)',
    'ssl-certificate.add.longCity' => 'Belirtilen şehir adı çok uzun.',
    'ssl-certificate.add.shortCity' => 'Belirtilen şehir adı çok kısa.',
    'ssl-certificate.add.companyName' => 'Organizasyon adı(firma)',
    'ssl-certificate.add.longCompanyName' => 'Belirtilen şirket adı çok uzun.',
    'ssl-certificate.add.companyUnitName' => 'Organizasyon departmanı veya bölüm adı',
    'ssl-certificate.add.longCompanyUnitName' => 'Belirtilen organizasyon departmanı adı çok uzun (maksimum %max% simgeye izin verilir).',
    'ssl-certificate.add.domainName' => 'Alan adı',
    'ssl-certificate.add.email' => 'E-posta',
    'ssl-certificate.add.request' => 'Talep et',
    'ssl-certificate.add.buyCertificate' => 'SSL/TLS sertifikası satın alın',
    'ssl-certificate.add.selfSigned' => 'Self signed',
    'ssl-certificate.add.invalidCertificateParams' => 'Bazı alanlar boş veya uygun olmayan değerler içeriyor. Değerlerin 64 karakterle sınırlandırılması gerekir. Uluslararası bir alan adını kullanıyorsanız, ASCII biçimine dönüştürüldüğünde noktalar arasındaki alan adının hiçbir kısmının 63 simgeyi geçmemesini sağlayın. Alanları kontrol edin:',
    'ssl-certificate.add.unableCreateCsr' => 'Bir CSR oluşturulamıyor: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Kendiliğinden imzalı bir sertifika oluşturulamıyor: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Sertifika verileri ayarlanamıyor: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Sertifika veritabanına kaydedilemiyor: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Sertifika dosyalarını karşıya yükle',
    'ssl-certificate.add.uploadFilesHint' => 'Bu formu, bir sertifikanın bileşenlerini bileşen dosyaları olarak karşıya yüklemek için kullanın.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Özel anahtarı (*.key)",
    'ssl-certificate.add.certificate' => "Sertifikası (*.crt)",
    'ssl-certificate.add.caCertificate' => "CA sertifikası (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Sertifikayı Karşıya Yükle",
    'ssl-certificate.add.fileNotUploaded' => 'Sertifika dosyası karşıya yüklenemiyor: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Özel anahtar ayarlanamıyor: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Sertifika ayarlanamıyor: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'CA sertifikası ayarlanamıyor: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'CA sertifikasının sertifikayı imzalayıp imzalamadığı kontrol edilemiyor: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Sil',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'CA sertifikasını kaldırmak istiyor musunuz?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'CA sertifikası silinemiyor: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'Sertifikanın CA kısmı kaldırılmış.',
    'ssl-certificate.add.rename' => 'Tekrar Adlandır',
    'ssl-certificate.add.unableRenameCertificate' => 'Sertifika yeniden adlandırılamıyor: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Sertifika, %%name%% olarak yeniden adlandırıldı.',
    'ssl-certificate.add.uploadText' => "Sertifikayı metin olarak karşıya yükle",
    'ssl-certificate.add.uploadTextHint' => 'Bu formu, bir sertifikanın bileşenlerini metin olarak karşıya yüklemek için kullanın. Bir dosyanın içeriğini kopyalayın ve ilgili alana yapıştırın.',
    'ssl-certificate.add.sendText' => "Sertifikayı Karşıya Yükle",
    'ssl-certificate.add.componentIsMissing' => 'Bileşen eksik.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Sertifikayı buraya yükle',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Bu sunucuda bir sertifikayı imzalama isteği oluşturdu ve sertifika dosyasını aldıysanız, onu burada karşıya yükleyin. Farklı bir sunucuda oluşturulan bir sertifikayı ve özel anahtar çiftini karşıya yüklemek veya kendi imzaladığınız bir sertifika oluşturmak istiyorsanız, <b>SSL/TLS  Sertifikasını Ekle\'yi tıklatın</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Bir alan adına bir SSL/TLS sertifikasını ekledikten sonra, SSL/TLS desteğini etkinleştirmeniz ve web sitesini barındırma ayarlarında o sertifikayı seçmeniz gerekir: <b>Web Siteleri ve Alan Adları</b>> <b> Bu alan adının </b>Barındırma Ayarları</> <b>Güvenlik</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Sertifikası (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Sertifikayı Karşıya Yükle',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Sertifika dosyası karşıya yüklenemiyor.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Geçersiz sertifika biçimi.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Sertifika için uygun özel anahtar bulunamıyor.',

    'ssl-certificate.secure.certificate' => 'Sertifikayı Seç',
    'ssl-certificate.secure.serverPool' => 'sunucu havuzu',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'web-app-firewall.pageHint' => 'Web uygulaması güvenlik duvarı, kullanıcının tanımladığı kurallara göre gelen HTTP taleplerini kontrol ederek ve filtreleyerek web uygulamalarını saldırılardan korur.',
    'web-app-firewall.webSitePageHint' => 'Burada, web uygulamasının güvenlik duvarını (ModSecurity) yapılandırabilirsiniz.',
    'web-app-firewall.ruleEngine' => 'Web uygulamasının güvenlik duvarı modu',
    'web-app-firewall.ruleEngineOn' => 'Açık',
    'web-app-firewall.ruleEngineOnDescription' => 'Her gelen HTTP talebi ve ilgili yanıt bir kural dizisiyle kontrol edilir. Kontrol başarılı olursa HTTP talebi, internet sitesi içeriğine geçer. Kontrol başarısız olursa etkinlik kaydedilir, bir bildirim gönderilir ve bir hata koduyla HTTP yanıtı sağlanır.',
    'web-app-firewall.ruleEngineOff' => 'Kapalı',
    'web-app-firewall.ruleEngineOffDescription' => 'Gelen HTTP istekleri ve ilgili yanıtlar kontrol edilmez.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Sadece saptama',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Her gelen HTTP talebi ve ilgili yanıt bir kural dizisiyle kontrol edilir. Kontrol başarılı olursa HTTP talebi, internet sitesi içeriğine geçer. Kontrol başarısız olursa etkinlik kaydedilir ve ModSecurity başka eylem gerçekleştirmez. Kontrolü başarısız olan HTTP talepleri üzerinde diğer hizmetler (örneğin: Fail2ban) kendi eylemlerini yine gerçekleştirebilir.',
    'web-app-firewall.ruleSetsSection' => 'Kural kümeleri',
    'web-app-firewall.ruleSetsSectionHint' => 'Gelen HTTP isteklerini kontrol etmek için hangi kural setinin (Güvenlik kurallarını içeren dosya paketi) kullanılacağını seçin.',
    'web-app-firewall.ruleSet' => 'Kural kümesi',
    'web-app-firewall.ruleSetCrs' => 'OWASP (ücretsiz)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Çekirdek Kural Seti çok kısıtlayıcıdır ve bazı işlevleri (örneğin dosya paylaşma, web postası) ve web uygulamalarının bazı özelliklerini (örneğin WordPress eklentilerini) engelleyebilir.',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Değişiklikleri uygula?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'OWASP kuralları çok kısıtlayıcı olabilir ve böylece Dosya Paylaşma, web postası ve bazı web uygulamaları gibi bazı işlevleri bloke edebilir.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (ücretsiz, Atomic Advanced\'e yükseltilebilir)',
    'web-app-firewall.ruleSetTortixDescription' => 'Atomicorp\'in ModSecurity Kurallarının bir başlangıç sürümü. Bunlar temel koruma sunar ve aylık temelde güncellenir.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Bu kural setini Atomic Advanced\'e yükseltmek için:',
    'web-app-firewall.ruleSetTortixBuy' => 'Plesk web sitesinden ve %%linkDocumentation%%\'den %%linkPleskStore%%\'i satın alın.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Atomicorp\'un Gelişmiş ModSecurity Kuralları',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'satın alınan ek lisans anahtarını yükleyin',
    'web-app-firewall.ruleSetTortixSelect' => 'Bu kural setini seçtiğinizde, adı "Atomic Advanced (Plesk\'ten satın alınmıştır)" olarak değişir',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (Plesk\'ten satın alınmıştır)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Atomicorp\'un Gelişmiş ModSecurity Kuralları, Atomic Standart kurallarla bir dizi gelişmiş özelliği kapsar.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (Atomicorp\'tan satın alınmıştır)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Atomicorp\'un Gelişmiş ModSecurity Kuralları, Atomic Standart kurallarla bir dizi gelişmiş özelliği kapsar.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Başka bir Atomicorp hesabına geçin.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Kural kümesi etkinleştirildi.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Satın aldığınız Atomic Advanced kurallarıyla Atomicorp hesabınız zaten varsa, bu kural setini etkinleştirmek için hesabın kimlik bilgilerini aşağıya girin.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Zaten Atomicorp Gelişmiş kuralları satın aldığınız Atomicorp hesabınız varsa, hesabı değiştirmek için hesap bilgilerini girin.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Kullanıcıadı',
    'web-app-firewall.ruleSetAtomicPassword' => 'Şifre',
    'web-app-firewall.ruleSetComodo' => 'Comodo (ücretsiz abonelik)',
    'web-app-firewall.ruleSetComodoDescription' => 'Comodo\'dan Ücretsiz ModSecurity Kuralları. Bunlar temel koruma sunar.',
    'web-app-firewall.ruleSetComodoInstall' => 'Başka bir Atomicorp hesabına geçin.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Kural kümesi etkinleştirildi.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Bu kural kümesini etkinleştirmek için:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Başka bir hesaba geçmek için:',
    'web-app-firewall.ruleSetComodoRegister' => 'Comodo web sitesine kaydolun.',
    'web-app-firewall.ruleSetComodoCredentials' => 'O web sitesinden kullanıcı adınızı ve parolanızı girin.',
    'web-app-firewall.ruleSetComodoLogin' => 'Kullanıcıadı',
    'web-app-firewall.ruleSetComodoPassword' => 'Şifre',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (ücretsiz)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Comodo\'dan Ücretsiz ModSecurity Kuralları. Bunlar temel koruma sunar.',
    'web-app-firewall.ruleSetCustom' => 'Özel kural kümesi',
    'web-app-firewall.ruleSetCustomDescription' => 'Özel bir web uygulamasının güvenlik duvarı kural kümesini karşıya yükleyin. Desteklenen biçimler: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Başka Bir Dosya Seçin',
    'web-app-firewall.ruleSetError' => 'ModSecurity kural kümesi yüklenemedi: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'OWASP kural seti eksik. Plesk kurucuyu kullanarak ModSecurity\'i tekrar kurun.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Özel kural seti kayıp. Kural setini tekrar kurun.',
    'web-app-firewall.ruleSetAuthError' => 'Belirtilen kullanıcı adı veya şifre geçersiz.',
    'web-app-firewall.ruleSetInvalid' => 'Seçilen kural seti %%webServer%% üzerinden yürütülemez.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Seçilen kural seti, seçili web sunucusu üzerinden yürütülemez.',
    'web-app-firewall.webServer' => 'Kuralları çalıştır',
    'web-app-firewall.webServerHint' => 'Uyumlu kural setlerini görmek için web sunucusunun ve ModSecurity sürümünün istenen kombinasyonunu seçin.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Ters Vekil Sunucu (nginx) kapatıldı ve işlem talepleri için kullanılamaz. <a href="%%serverUrl%%">Başka bir web sunucusu</a> seçin veya <a href="%%servicesUrl%%">Servis Yönetim sayfası</a> üzerinden ters vekil sunucuyu açın.',
    'web-app-firewall.nginxIsIncompatible' => 'Farklı bir ModSecurity sürümünü seçtiğinizde bazı ayarların geçerliliğini yitirdiğini görebilirsiniz (örneğin, ModSecurity 3 ile düzenli ifadeleri kullanarak güvenlik kurallarını kapatamazsınız). Değişiklikleri uyguladıktan sonra ayarlarınızın beklendiği çalıştığından emin olun. Başka bir seçenek olarak da, güvenlik kurallarını varsayılan değerlere getiren ayarları sıfırlayabilirsiniz.',
    'web-app-firewall.nginxResetCustomizations' => 'Güvenlik kurallarını değiştirerek varsayılan değerlere getiren sunucu ve alan adı ayarlarını sıfırlayın.',
    'web-app-firewall.ruleSetUpdate' => 'Kural kümelerini güncelle',
    'web-app-firewall.ruleSetUpdateDaily' => 'Günlük',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Haftalık',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Aylık',
    'web-app-firewall.currentRuleSet' => 'Kural kümesi',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%%, %%webServer%% üzerinde çalışıyor',
    'web-app-firewall.changeRuleSetLink' => 'Kural Kümesini Değiştir',
    'web-app-firewall.ruleSetRollbackFailed' => 'Geçerli ModSecurity kural seti kullanılamıyor ve geçersiz kuralları olduğundan, bir önceki sürümüne geri dönülemiyor.',
    'web-app-firewall.configurationSection' => 'Yapılandırma',
    'web-app-firewall.configurationSectionHint' => 'Web uygulaması güvenlik durumunu önceden tanımlamış parametre setiyle veya özel ModSecurity direktiflerinizle yapılandırın.',
    'web-app-firewall.configPreset' => 'Önceden tanımlı değer kümesi',
    'web-app-firewall.configPresetFast' => 'Hızlı',
    'web-app-firewall.configPresetFastDescription' => 'HTTP isteği URI\'si ve başlığının bazı kısımları analiz edilir.',
    'web-app-firewall.configPresetTradeOff' => 'Taviz',
    'web-app-firewall.configPresetTradeOffDescription' => 'HTTP isteği URI\'si, başlıkları ve istek POST verileri analiz edilir.',
    'web-app-firewall.configPresetThrough' => 'Tam',
    'web-app-firewall.configPresetThroughDescription' => 'Tam HTTP isteği başlıkları, istek POST verileri ve HTTP yanıt gövdesinin içeriği analiz edilir.',
    'web-app-firewall.configCustom' => 'Özel direktifler',
    'web-app-firewall.configCustomDescription' => "Buraya bir ModSecurity direktifi girin. Daha önce belirtilen direktifleri (kural kümeleri, özel kurallar, önceden tanımlı değer kümesi ve saire) geçersiz kılar.\nÖrneğin: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Geçersiz ModSecurity yapılandırması: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Geçersiz yapılandırma içerdiğinden, geçerli ModSecurity yapılandırma dosyası kullanılamıyor ve dosyanın bir önceki sürümüne geri dönülemiyor.',
    'web-app-firewall.rulesSection' => 'Güvenlik kurallarını kapatın',
    'web-app-firewall.rulesSectionHint' => 'Buradan güvenlik kurallarını kapatabilirsiniz. Bazı internet siteleri için güvenlik kuralları çok sıkıysa, bu seçenek kullanışlıdır. Güvenlik kurallarını devre dışı bırakmak için kimliklerini (örneğin, 340003 veya 34005-34007), etiketlerini (örneğin, CVE-2011-4898) veya kural mesajlarındaki düzenli ifadeleri (örneğin, XSS) belirtin.',
    'web-app-firewall.rulesSectionNginxHint' => 'Buradan güvenlik kurallarını kapatabilirsiniz. Bazı internet siteleri için güvenlik kuralları çok sıkıysa, bu seçenek kullanışlıdır. Güvenlik kurallarını devre dışı bırakmak için kimliklerini (örneğin, 340003 veya 34005-34007), etiketlerini (örneğin, CVE-2011-4898) veya kural mesajlarını (örneğin, Güvenlik tarayıcısıyla ilgili Kullanıcı Aracısı bulundu) belirtin.',
    'web-app-firewall.filterById' => 'Güvenlik kuralı kimlikleri',
    'web-app-firewall.filterByIdInvalid' => 'Şu değerler geçerli değildir: %%values%%. Kural kimliği, 913100, 913105-913107 gibi rakamlardan veya rakam aralıklarından oluşmalıdır.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Şu aralıklar geçerli değil: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Etiketler',
    'web-app-firewall.filterByTagActive' => 'Etkin:',
    'web-app-firewall.filterByTagDeactivated' => 'Devre dışı bırakıldı:',
    'web-app-firewall.filterByTagInvalid' => 'Aşağıdaki seçilen değerler geçerli değil %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Kural mesajlarında düzenli ifadeler',
    'web-app-firewall.filterByRegexpInvalid' => '%%values%% değerleri geçerli değil. Herhangi bir \'," karakter içermemelidir.',
    'web-app-firewall.filterByRegexpNginx' => 'Kural mesajları',
    'web-app-firewall.filterByRegexpNginxHint' => 'Yalnızca kısıtlı eşleşmeler desteklenir.',
    'web-app-firewall.filterByRegexpNginxInvalid' => '%%values%% değerleri geçerli değil. Kural mesajı harf, sayı, boşluk veya -:;.,!?#&$%*()/ gibi karakterler barındırmalıdır.',
    'web-app-firewall.auditLogSection' => 'ModSecurity denetim günlüğü',
    'web-app-firewall.auditLogHint1' => 'ModSecurity denetim günlüğü dosyası, sistemdeki en önemli bilgi parçasıdır. ModSecurity, herhangi bir olay oluştuğunu algıladığında, denetim günlük dosyasında bir giriş oluşturur.',
    'web-app-firewall.auditLogHint2' => 'Web uygulamasının güvenlik duvarı modunu Kapalı veya Sadece saptama ayarından Açık ayarına değiştirdiğinizde, bir web sitesinin beklendiği şekilde çalışması durabilir. Bu durumda, ne olduğunu anlamak için ModSecurity denetim günlüğünü analiz edin. Aşırı kısıtlayıcı güvenlik kurallarını kapatabilir veya web sitesini ayarlayabilirsiniz.',
    'web-app-firewall.auditLogHint3' => 'Bir HTTP isteğinin bir web sitesi için neden tamamlanamadığını öğrenmek için:',
    'web-app-firewall.auditLogPoint1' => 'Aşağıdaki ModSecurity Günlük Dosyası bağlantısını tıklatın ve denetim günlüğünü yeni bir tarayıcı penceresinde açın.',
    'web-app-firewall.auditLogPoint2' => 'Sorun yaşadığınız web sitesi (alan adı) olaylarını bulmak için Ara (çoğu web tarayıcısında Ctrl+F) özelliğini kullanın. Örneğin alan_adınız.tld. Tarayıcı, ANA BİLGİSAYAR (HOST) gibi girişleri vurgular: alan_adınız.tld.',
    'web-app-firewall.auditLogPoint3' => 'Vurgulanan girişinin üç satır üstünde --eece5138-B-- benzeri bir dize bulun. Çizgilerin arasındaki sekiz simge (örneğimizde eece5138), HTTP isteğiyle tetiklenen olayın kimliğidir.',
    'web-app-firewall.auditLogPoint4' => 'Aynı olay kimliğine sahip diğer girişleri aramaya devam edin. Olay kimliğinin arkasında H harfi olan bir girişi arayın (örneğimizde eece5138-H--). Bu giriş, HTTP isteği kontrol edilirken tetiklenen güvenlik kuralının kimliğini ve açıklamasını içerir. Güvenlik kuralı kimliği, tırnak içinde, 3 ile başlayan ve öneki kimliği köşeli parantezlere konulmuş olan bir tamsayıdır. Örneğin [id "340003"].',
    'web-app-firewall.auditLogPoint5' => '[id "3 alt dizesini kullanarak olayda bir güvenlik kuralı kimliği bulun.',
    'web-app-firewall.auditLogPoint6' => 'Aşağıdaki Güvenlik kuralları bölümünde bu kimlikle güvenlik kuralını kapatın: güvenlik kuralı kimliğini (sadece rakam) Güvenlik kuralı kimlikleri alanına girin ve Tamam tuşunu tıklatın.',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity Günlük Dosyası',
    'web-app-firewall.auditLogListLink' => 'Günlük Arşivi',
    'web-app-firewall.errorLogSection' => 'Günlükleri',
    'web-app-firewall.errorLogSectionHint' => 'Web uygulamasının güvenlik duvarı modunu Kapalı veya Sadece saptama ayarından Açık ayarına değiştirdiğinizde, bir web sitesinin beklendiği şekilde çalışması durabilir. Bu durumda, ne olduğunu anlamak için hata günlüğünü analiz edin. Aşırı kısıtlayıcı güvenlik kurallarını kapatabilir veya web sitesini ayarlayabilirsiniz.',
    'web-app-firewall.errorLogViewLink' => 'Hata Günlük Dosyası',
    'web-app-firewall.notificationStateEnabled' => 'Kural seti güncellemelerinde Plesk UI bildirimleri açılır. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Kural seti güncellemelerinde Plesk UI bildirimleri kapatılır. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Onları bildirim sayfasından yönet',
    'web-app-firewall.detectionOnlyAndThoroughModeWarning' => 'Hem "Sadece Saptama" hem de "Kapsamlı" seçeneklerin açılması, örneğin işlevsiz Wordpress sitesi gibi <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity sorunuyla</a> ilgili sorunlara yol açabilir',
];