<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Неправильний шлюз: upstream надіслав занадто довгий заголовок під час читання заголовка відповіді"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Внутрішня помилка сервера: параметр FollowSymLinks не дозволений тут"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "сервер досяг налаштування max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Ознаки</h4><ul><li><p>Веб-сайти, для яких обробник PHP встановлено як<strong>FPM-застосунок, що обслуговується Apache</strong> або <strong>FPM-застосунок, що обслуговується nginx</strong> на <strong> Доменах</strong>&gt;<strong>example.com</strong> &gt; <strong> У налаштуваннях PHP</strong> виникає одна з наведених нижче проблем:</p><ul><li><p>довгий час завантаження</p></li><li><p>немає доступу (постійно або періодично) з помилкою 50x у веб-оглядачі:</p><pre>502 Неправильний шлюз</pre><hr><pre>503 Сервіс тимчасово недоступний</pre><hr><pre>504 Час очікування шлюзу перевищено</pre></li></ul></li><li><p>У журналі помилок PHP-FPM з’являється таке повідомлення <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (де <em>XX</em> це версія PHP, яку використовують вебсайти):</p><pre>ПОПЕРЕДЖЕННЯ: сервер [пула example.com] досяг параметра max_children (*), розгляньте варіант його підвищення</pre><ul><li><p>Повідомлення вище зазвичай супроводжується наступною помилкою:</p><pre>неможливо зчитати інформацію дочірного об’єкта: поганий дескриптор файлу (9)</pre></li></ul></li><li><p>Якщо nginx увімкнено на сервері, у журналі помилок домену може з’явитися одне з наведених нижче повідомлень про помилку <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 з\'єднатися() з unix:///var/www/vhosts/system/example.com/php-fpm.sock не вдалося (11: Ресурс тимчасово недоступний) під час підключення до upstream, клієнт: 203.0.113.2, сервер: example.com, запит: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", хост: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream передчасно завершив з\'єднання під час читання заголовка відповіді з upstream, клієнт: 203.0.113.2, сервер: example.com, запит: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM<code>pm.max_children</code> досягнутий вебсайтом (вебсайтами).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>Збільште обмеження <code>pm.max_children</code> для уражених доменів:</p><ol><li><p>З\'єднайтеся з сервером Plesk через <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Знайдіть уражені домени за допомогою команди нижче:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Примітка:</strong>Число зліва вказує, скільки разів<code>pm.max_children</code> обмеження було досягнуто на вебсайті.</div><pre style="white-space: pre-wrap;"># grep -r "сервер досяг налаштування max_children" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Увійти до Plesk</a>.</p></li><li><p>Перейти до<strong>Домени</strong>&gt;<strong>example.com</strong> &gt; <strong>Налаштування PHP</strong> &gt; <strong>Налаштування PHP-FPM</strong>.</p></li><li><p>Збільште значення <code>pm.max_children</code> для домену та застосуйте зміни. Збільште це значення для всіх доменів, перерахованих на кроці 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Забагато відкритих файлів"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx не запускається/перезавантажується на сервері Plesk: забагато відкритих файлів</p><h4>Ознаки</h4><ul><li><p>Служба nginx не запускається/перезавантажується з наступною помилкою в <code>/var/log/nginx/error.log</code> файл:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/ www/vhosts/system/example.com/logs/proxy_access_ssl_log" не вдалося (24: Забагато відкритих файлів)</pre></li><li><p>Деякі або всі вебсайти недоступні</p></li><li><p>Попередження показане в розділі <strong>Інструменти &amp; Налаштування &gt; Виявити &amp; виправити</strong>:</p><pre style="white-space: pre-wrap;">Перевірка наявності nginx ULIMIT значення N доменів знайдена на сервері. Можлива проблема з обмеженням за замовчуванням nginx для відкритих файлів</pre></li><li><p>Веб-застосунки NodeJS і Ruby показують помилку 502 Неправильний шлюз під час виконання деяких завдань Plesk, як-от створення доменів, підписок, зміни в Apache або Nginx тощо:</p><pre style="white-space: pre-wrap;">Помилка сервера<br>502 Неправильний шлюз <br>Веб-сервер отримав недійсну відповідь, працюючи як шлюз або проксі-сервер.</pre></li><li><p>Після <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">встановлення нового сертифіката для домену</a>, старий все ще показаний у веб-оглядачі, однак правильний сертифікат вибирається на <strong>Домени &gt; example.com &gt; Сторінка налаштувань хостингу.</strong></p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Віртуальний хост Nginx відкриває 4 журнали для кожного віртуального хосту з фізичним хостингом:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Отже, сервер nginx перевищив максимальну кількість відкритих файлів через велику кількість доменів (зазвичай більше 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Попередження:</strong> Виконання <code>websrv_ulimits</code> утиліту без <strong>--no-restart</strong> опції ініціює відновлення файлів конфігурації вебсайтів для всіх доменів і може призвести до значних простоїв у разі великої кількості розміщених вебсайтів.<br><br>Виконайте команду протягом періоду обслуговування.</div><p>Рекомендується встановити граничне значення для відкритих файлів більше ніж принаймні <strong>кількість доменів у Plesk * 16</strong>. У прикладі нижче наведено дії, як встановити обмеження на 4096:</p><ol><li><p>З\'єднатися з сервером через <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Установіть обмеження для відкритих файлів на 4096 як для Apache, так і для Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Перезапустіть сервіси Apache і nginx за адресою<strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Інструменти &amp; Налаштування &gt; Управління сервісами</strong>, щоб застосувати зміни.</p></li><li><p>Після перезапуску веб-сервісів переконайтеся, що «Максимальне обмеження відкритих файлів» застосовано належним чином:</p><pre># grep «Максимальна кількість відкритих файлів» /proc/$(cat /var/run/nginx.pid)/limits<br>Максимальна кількість відкритих файлів 4096 4096 файл</pre></li><li><p>Якщо вище вказане рішення не допомогло, встановіть обмеження за допомогою <code>ulimit</code> утиліти: </p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Тіло відповіді завелике"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "У доступі відмовлено, код 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Внутрішня помилка сервера 500: Вичерпано дозволений розмір пам\'яті XXX"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "Діє обмеження open_basedir"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Заборонено AH01797: клієнту відмовлено у доступі конфігурацією сервера"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Не вдається отримати доступ до каталогу вебсайтів у Plesk: 403 Заборонено"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Не вдається отримати доступ до каталогу вебсайтів у Plesk: 403 Заборонено"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "сервер досяг налаштування MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Обмеження тіла запиту PHP "клієнт збирається надіслати занадто довгий текст"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Обмеження тіла запиту PHP "клієнт збирається надіслати занадто довгий текст"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Сеанси PHP "503 Внутрішня помилка сервера" або "Не вдалося прочитати дані сеансу"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Заборонено: pcfg_openfile: неможливо перевірити файл htaccess, переконайтеся, що файл доступний для читання"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];