<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx“502無效閘道：上游讀取回應頭時發送了太大的資訊頭”',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache“500內部伺服器錯誤：此處不允許選項 FollowSymLinks”',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "伺服器達到 max_children 設定"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>症狀</h4><ul><li><p>有 PHP 處理常式的網站設定為 <strong>Apache 服務的 FPM 應用程式</strong>或<strong>nginx 服務的 FPM 應用程式</strong>（位於 <strong>功能變數名稱</strong> &gt; <strong>example.com</strong> &gt;）<strong>PHP 設定</strong>遇到以下當中的一個問題：</p><ul><li><p>載入慢</p></li><li><p>不可訪問（永久或定期），web 流覽器中出現50x錯誤：</p><pre>502 無效閘道</pre><hr><pre>503 服務暫時不可用</pre><hr><pre>504 閘道超時</pre></li></ul></li><li><p>以下資訊出現在 PHP-FPM 錯誤日誌檔<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code>中（其中 <em>XX</em> 是網站使用的 PHP 版本）：</p><pre>警告： [pool example.com] 伺服器達到 max_children 設定 (*)，考慮將其提升</pre><ul><li><p>以上資訊通常伴隨此錯誤：</p><pre>無法讀取子代所說的內容：錯誤的檔描述符(9)</pre></li></ul></li><li><p>如果在伺服器上啟用了nginx，則功能變數名稱的錯誤日誌檔中可能會出現以下錯誤消息之一 <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: 資源臨時不可用)，連接上游時，用戶端：203.0.113.2，伺服器：example.com，請求： "GET / HTTP/1.1"，上游："fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:"，主機："example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 從上游讀取回應頭時，上游連接過早關閉連接，用戶端：203.0.113.2，伺服器：example.com，請求："POST /path/to/some/file HTTP/2.0"，上游：</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>網站已達到 PHP-FPM <code>pm.max_children</code>。</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>提高受影響的域名的 <code>pm.max_children</code> 限制：</p><ol><li><p>連接到 Plesk 伺服器，通過 <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>。</p></li><li><p>使用以下命令查找受影響的域名：</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>注意：</strong> 左邊的資料表示網站已達到 <code>pm.max_children</code> 限制的次數。</div><pre style="white-space: pre-wrap;"># grep -r "伺服器已達到 max_children 設定" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">登入到 Plesk</a>。</p></li><li><p>轉到 <strong>域名</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP 設定</strong> &gt; <strong>PHP-FPM 設定</strong>.</p></li><li><p>增加域名的 <code>pm.max_children</code> 值並應用更改。在第2步驟為所有列出的域名增加此值。</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "太多打開的文件"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx 無法在 Plesk 伺服器上啟動/載入：太多打開的檔</p><h4>症狀</h4><ul><li><p>nginx 服務無法啟動/載入，在 <code>/var/log/nginx/error.log</code> 文件中出現以下問題：</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: 太多打開的檔)</pre></li><li><p>某些或所有的網站不可存取</p></li><li><p>警告在<strong>工具與設定 &gt;診斷與修復</strong>中顯示：</p><pre style="white-space: pre-wrap;">查找nginx ULIMIT 值，在伺服器上找到 N 個域名。可能會出現已打開檔的 nginx 默認限制的問題</pre></li><li><p>NodeJS和Rubyweb應用程式在執行一些Plesk任務時顯示502無效閘道錯誤，例如在創建域名、訂閱或在Apache或Nginx上更改時：</p><pre style="white-space: pre-wrap;">伺服器錯誤<br>502 無效閘道<br>Web伺服器在作為閘道或代理伺服器時收到了一個無效的響應。</pre></li><li><p>在<a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">為域名安裝新的證書後</a>，舊的證書仍會在web 流覽器中顯示，但是會在 <strong>域名 &gt; example.com &gt; 主機設定</strong> 頁面中選定正確的證書。</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx的虛擬主機為帶有物理主機的每個虛擬主機打開了 4 個日誌檔：</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>因域名眾多（通常超過100個）所以會導致超過nginx伺服器可打開的檔的最大數量。</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>警告：</strong> 執行<code>websrv_ulimits</code> 工具而無<strong>--no-restart</strong> 選項會啟動為所有域名重建 web 設定檔，可能會因為託管網站數量眾多而導致嚴重的宕機。<br><br>在維護期間框架內執行該命令</div><p>最好是將打開的檔限制值設定至少不超過<strong>Plesk * 16</strong> 中域名的數量。在下面的示例中，提供了如何設定限制為4096的操作步驟：</p><ol><li><p>通過<a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH連接到伺服器</a></p></li><li><p>為Apache和 Nginx將打開的檔限制設定為4096：</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>在 <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>工具 &amp; 設定 &gt; 服務管理</strong> 重啟Apache 和 nginx以應用更改。</p></li><li><p>在web服務重啟後檢查 \'打開檔限制最大值\' 是否正確應用：</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>打開檔最大值 4096 4096 個檔</pre></li><li><p>若上述方案沒有幫助，請使用 <code>ulimit</code> 工具設定限制：</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "回應主體太大"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "訪問被拒，代碼 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "內部伺服器錯誤 500: 允許的記憶體容量 XXX 已耗盡"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir 限制有效"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403禁止AH01797：用戶端被伺服器配置拒絕"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache“無法存取Plesk中的網站目錄：403禁止”',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx“無法存取Plesk中的網站目錄：403禁止”',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "伺服器達到了 MaxRequestWorkers 設定"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP請求主體限制“用戶端計畫發送過大主體”',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP請求主體限制“用戶端計畫發送過大主體”',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP會話“503內部伺服器錯誤”或“讀取會話資料失敗”',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: 無法檢查htaccess檔，以確保其可讀性”',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];