<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Δεν επιτρέπεται η πρόσβαση.  Ο λογαριασμός σας έχει ανασταλεί.",
    'login_up__login_has_been_locked' => "Προσπαθήσατε πάρα πολλές φορές να συνδεθείτε χρησιμοποιώντας λανθασμένο κωδικό πρόσβασης.  Για λόγους ασφαλείας, δεν θα μπορείτε να συνδεθείτε με αυτό το όνομα χρήστη για κάποιο χρονικό διάστημα.",
    'login_up__login_label_plesk' => "Σύνδεση στο %1", // PFU
    'login_up__login_label_parallels' => "Σύνδεση στο Plesk %1",
    'login_up__login_text' => "Εισαγάγετε το όνομα χρήστη και τον κωδικό πρόσβασής σας.",
    'login_up__unable_to_check_pass' => "Δεν είναι δυνατός ο έλεγχος του κωδικού πρόσβασης: %1",
    'login_up__warning_limits_licence_key' => "Ένα από τα παρακάτω στοιχεία έχει υπερβεί το όριο που καθορίζεται από το κλειδί άδειας χρήσης σας: αριθμός λογαριασμών χρηστών, τομέων, λογαριασμών ηλεκτρονικού ταχυδρομείου ή χρηστών που φιλοξενούνται στο διακομιστή σας.\nΕπικοινωνήστε με το τμήμα πωλήσεων της Plesk για να προμηθευτείτε ένα νέο κλειδί που θα σας δώσει τη δυνατότητα να φιλοξενήσετε τον επιθυμητό αριθμό χρηστών και τομέων. Επικοινωνήστε με το τμήμα τεχνικής υποστήριξης της Plesk αν νομίζετε ότι λάβατε αυτό το μήνυμα κατά λάθος.\nΌριο που προβλέπει η άδεια χρήσης για λογαριασμούς χρηστών/τομείς/λογαριασμούς ηλεκτρονικού ταχυδρομείου/χρήστες web/πακέτα γλωσσών: %2.\nΑριθμός λογαριασμών χρηστών/τομέων/λογαριασμών ηλεκτρονικού ταχυδρομείου/χρηστών web/πακέτων γλωσσών που φιλοξενούνται αυτήν τη στιγμή: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Η ποσότητα των πόρων που χρησιμοποιείτε έχει υπερβεί τα όρια που καθορίζονται από την ισχύουσα άδεια χρήσης του προϊόντος σας. Επικοινωνήστε με το τμήμα πωλήσεων της Plesk για να προμηθευτείτε ένα νέο κλειδί άδειας χρήσης.",
    'login_up__grace_period' => 'Αυτήν τη στιγμή χρησιμοποιείτε την περίοδο χάριτος της άδειας χρήσης του προϊόντος σας.  Για να ανανεώσετε την άδεια χρήσης του προϊόντος σας, επιλέξτε Ανάκτηση κλειδιών στη %1License Management page%2.',
    'login_up__partner_license_message' => 'Χρησιμοποιείτε μια περιορισμένη άδεια χρήσης του προϊόντος, η οποία απαιτεί την εγγραφή σας για να έχετε τη δυνατότητα να ενεργοποιήσετε το σύνολο των λειτουργιών. Για να ανανεώσετε την άδεια χρήσης του προϊόντος σας, επιλέξτε Ανάκτηση κλειδιών στη %1License Management page%2.',
    'login_up__system_admin_disabled' => 'Ο superuser (ριζικός λογαριασμός ή λογαριασμός διαχειριστή) απαγορεύεται να συνδεθεί στο Plesk για λόγους ασφαλείας.',
    'login_up__mobile_application_message' => 'Συνιστούμε να εγκαταστήσετε την όνομα εφαρμογή %%name%% για καλύτερη εμπειρία χρήσης.',
    'login_up__mobile_application_install' => 'Εγκατάσταση τώρα',
    'login_up__mobile_application_hide' => 'Όχι, ευχαριστώ',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Οδηγός διαχειριστή Plesk",
    'plesk_guide_reseller' => "Οδηγός μεταπωλητή Plesk",
    'plesk_guide_client' => "Οδηγός πελάτη Plesk",
    'plesk_guide_domain_admin' => "Οδηγός διαχειριστή τομέα Plesk",
    'plesk_guide_mailuser' => "Οδηγός χρήστη ηλεκτρονικού ταχυδρομείου Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Αναζήτηση', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Πελάτες',
    'ui__reseller_unknown__quick-search' => 'Μεταπωλητές',
    'ui__client/domain_unknown__quick-search' => 'Τομείς',
    'nav__general' => 'Κύριο μενού',
    '__home' => 'Αρχική',
    '__resellers' => 'Μεταπωλητές',
    '__clients' => 'Πελάτες',
    '__domains' => 'Τομείς',
    '__applications' => 'Εφαρμογές',
    '__settings' => 'Ρυθμίσεις',
    'nav__system' => 'Σύστημα',
    '__master' => 'Master',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Επίπεδο πάνω',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Κατάργηση',
    'bt_make_default' => 'Ορισμός ως Προεπιλογή',

    // common list object operation errors
    'class_cList__empty_selection' => 'Δεν έχει επιλεγεί αντικείμενο.',

    // common list object search keys
    'clist__search_show' => 'Εμφάνιση αναζήτησης',
    'clist__search_hide' => 'Απόκρυψη αναζήτησης',

    'bt_show_all' => "Επαναφορά αναζήτησης",

    // common object list info keys
    'clist__first' => 'πρώτη',
    'clist__last' => 'τελευταία',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Σελίδες',
    'clist__page_size' => 'Καταχωρήσεις ανά σελίδα',
    'clist__info' => 'Σύνολο %1: %4',
    'clist__info_empty' => 'Αρ. %1',
    'clist__info_filter' => 'βρέθηκε(-αν) %5 %1 (%4 συνολικά)',
    'clist__info_paging' => '%2-%3 %1 από %4 συνολικά',
    'clist__info_paging_filter' => 'βρέθηκε(-αν) %2-%3 %1 από %5 (%4 συνολικά)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Ενεργό',
    '__object_off' => 'Αναστάλθηκε',

    '__home_description' => 'Επιστροφή στην Αρχική σελίδα.',
    'indicator_title' => '%1% χρησιμοποιείται, %2% ελεύθερο', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Ζητήθηκε μη έγκυρη διεύθυνση URL.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Λογαριασμοί μεταπωλητών",
    'ui__reseller_unknown__title' => "Λογαριασμοί μεταπωλητών",
    'ui__reseller_unknown__description' => "Διαχείριση λογαριασμών μεταπωλητών.",
    'ui__reseller/client_unknown__short-title' => 'Λογαριασμοί πελατών',
    'ui__reseller/client_unknown__title' => 'Λογαριασμοί πελατών',
    'ui__reseller/client_unknown__description' => 'Διαχείριση λογαριασμών πελατών.',
    // dropdowns
    'ui__reseller/client/chowner_multi-select__title' => 'Ορισμός νέου κατόχου για λογαριασμούς πελατών',
    'ui__reseller/client/chowner_multi-select__short-title' => 'Ορισμός νέου κατόχου',
    'ui__reseller/client/chowner_multi-select__description' => 'Ορισμός νέου κατόχου για τους επιλεγμένους λογαριασμούς πελατών.',
    'ui__client/to-reseller_multi__title' => 'Μετατροπή λογαριασμών πελατών σε λογαριασμούς μεταπωλητών',
    'ui__client/to-reseller_multi__short-title' => 'Μετατροπή σε μεταπωλητές',
    'ui__client/to-reseller_multi__description' => 'Μετατροπή επιλεγμένων λογαριασμών πελατών σε λογαριασμούς μεταπωλητών.',
    'ui__reseller/to-client_multi__title' => 'Μετατροπή λογαριασμών μεταπωλητών σε λογαριασμούς πελατών',
    'ui__reseller/to-client_multi__short-title' => 'Μετατροπή σε πελάτες',
    'ui__reseller/to-client_multi__description' => 'Μετατροπή επιλεγμένων λογαριασμών μεταπωλητών σε λογαριασμούς πελατών',
    'ui__admin-alias_unknown__title' => "Πρόσθετοι λογαριασμοί διαχειριστή", // PFW
    'ui__admin-alias_unknown__short-title' => "Πρόσθετοι λογαριασμοί διαχειριστή", // PFW
    'ui__admin-alias_unknown__description' => "Προβολή και διαχείριση πρόσθετων λογαριασμών διαχειριστή.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Ρυθμίσεις διακομιστή αλληλογραφίας",
    'ui__server/mail__title' => "Ρυθμίσεις διακομιστή αλληλογραφίας",
    'ui__server/mail__description' => "Ρύθμιση του διακομιστή αλληλογραφίας σας και διαμόρφωση των ρυθμίσεων αλληλογραφίας σε επίπεδο διακομιστή.",
    'ui__server/dns__short-title' => 'Ρυθμίσεις DNS',
    'ui__server/dns__title' => 'Ρυθμίσεις DNS',
    'ui__server/dns__description' => 'Έλεγχος και ενημέρωση ρυθμίσεων DNS σε επίπεδο διακομιστή.',
    'ui__server/components__short-title' => 'Στοιχεία διακομιστή',
    'ui__server/components__title' => 'Στοιχεία διακομιστή',
    'ui__server/components__description' => 'Προβολή πληροφοριών σχετικά με τα στοιχεία συστήματος που είναι εγκατεστημένα στο διακομιστή και χρησιμοποιούνται από το Plesk.',
    'ui__server/services__short-title' => 'Διαχείριση υπηρεσιών',
    'ui__server/services__title' => 'Διαχείριση υπηρεσιών',
    'ui__server/services__description' => 'Εκκίνηση, διακοπή ή επανεκκίνηση των υπηρεσιών του Plesk.',
    'ui__server/db__short-title' => 'Διακομιστές βάσεων δεδομένων',
    'ui__server/db__title' => 'Διακομιστές βάσεων δεδομένων',
    'ui__server/db__description' => 'Προβολή και διαχείριση των διακομιστών βάσεων δεδομένων σε επίπεδο διακομιστή.',
    'ui__server/crontab/task_unknown__short-title' => 'Προγραμματισμένες εργασίες',
    'ui__server/crontab/task_unknown__title' => 'Προγραμματισμένες εργασίες',
    'ui__server/crontab/task_unknown__description' => 'Προσθήκη και κατάργηση προγραμματισμένων εργασιών σε επίπεδο διακομιστή.',
    'ui__server/ip-address_unknown__short-title' => 'Διευθύνσεις IP',
    'ui__server/ip-address_unknown__title' => 'Διευθύνσεις IP',
    'ui__server/ip-address_unknown__description' => 'Προβολή, προσθήκη και κατάργηση διευθύνσεων IP, εκχώρηση διευθύνσεων IP σε μεταπωλητές.',
    'ui__promotion/smartermail__short-title' => 'Λήψη του SmarterMail',
    'ui__promotion/smartermail__title' => 'Λήψη του SmarterMail',
    'ui__promotion/smartermail__description' => 'Ανοίξτε σε ένα νέο παράθυρο την τοποθεσία web του SmarterMail, απ\' όπου μπορείτε να πραγματοποιήσετε λήψη της πιο πρόσφατης έκδοσης του διακομιστή αλληλογραφίας SmarterMail. Η τοποθεσία web του SmarterMail δημιουργήθηκε και υποστηρίζεται από την SmarterTools Inc. Το Plesk δεν είναι υπεύθυνο για το περιεχόμενο της τοποθεσίας web του SmarterMail και δεν παρέχει υποστήριξη για τον διακομιστή αλληλογραφίας SmarterMail Lite.',
    // dropdowns
    'ui__server/tsclient__short-title' => 'Απομακρυσμένη επιφάνεια εργασίας',
    'ui__server/tsclient__title' => 'Απομακρυσμένη επιφάνεια εργασίας',
    'ui__server/tsclient__description' => 'Πρόσβαση στο διακομιστή μέσω απομακρυσμένης επιφάνειας εργασίας.',
    'ui__server/time__title' => 'Ώρα συστήματος',
    'ui__server/time__short-title' => 'Ώρα συστήματος',
    'ui__server/time__description' => 'Αλλαγή ημερομηνίας και ώρας του συστήματος, ρύθμιση συγχρονισμού με διακομιστή NTP.',
    'ui__server/odbc__title' => 'Αρχεία προέλευσης δεδομένων ODBC', // PFW
    'ui__server/odbc__short-title' => 'Αρχεία προέλευσης δεδομένων ODBC', // PFW
    'ui__server/odbc__description' => 'Ρυθμίσεις προελεύσεων δεδομένων ODBC.', // PFW
    'ui__server/ftp-settings__short-title' => "Ρυθμίσεις FTP", // PFW
    'ui__server/ftp-settings__title' => "Ρυθμίσεις FTP", // PFW
    'ui__server/ftp-settings__description' => "Διαμόρφωση ρυθμίσεων FTP σε επίπεδο διακομιστή.", // PFW
    'ui__server/maillists__title' => 'Ρύθμιση διακομιστή λιστών αλληλογραφίας', // PFU
    'ui__server/maillists__short-title' => 'Ρύθμιση διακομιστή λιστών αλληλογραφίας', // PFU
    'ui__server/maillists__description' => 'Ρύθμιση διακομιστή λιστών αλληλογραφίας Mailman.', // PFU
    'ui__mass-email__short-title' => "Μηνύματα μαζικής αλληλογραφίας", // PFW
    'ui__mass-email__title' => "Μηνύματα μαζικής αλληλογραφίας", // PFW
    'ui__mass-email__description' => "Αποστολή μηνυμάτων ηλεκτρονικού ταχυδρομείου σε πολλούς χρήστες ταυτόχρονα.", // PFW
    'ui__mass-mail__title' => 'Μηνύματα μαζικής αλληλογραφίας', // PFU
    'ui__mass-mail__short-title' => 'Μηνύματα μαζικής αλληλογραφίας', // PFU
    'ui__mass-mail__description' => 'Αποστολή μηνυμάτων ηλεκτρονικού ταχυδρομείου σε πολλούς χρήστες ταυτόχρονα.', // PFU
    'ui__server/spam-filter__title' => 'Ρυθμίσεις φίλτρου ανεπιθύμητης αλληλογραφίας',
    'ui__server/spam-filter__short-title' => 'Ρυθμίσεις φίλτρου ανεπιθύμητης αλληλογραφίας',
    'ui__server/spam-filter__description' => 'Ρύθμιση του φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή.',
    'ui__server/preferences__title' => "Ρυθμίσεις διακομιστή",
    'ui__server/preferences__short-title' => "Ρυθμίσεις διακομιστή",
    'ui__server/preferences__description' => "Ρύθμιση υπολογισμού στατιστικών στοιχείων σε επίπεδο διακομιστή, αλλαγή ονόματος κεντρικού υπολογιστή διακομιστή και αλλαγή άλλων ρυθμίσεων του διακομιστή.",

    // interface
    // icons
    'ui__logo__short-title' => 'Εμπορική ταυτότητα Plesk',
    'ui__logo__title' => 'Εμπορική ταυτότητα Plesk',
    'ui__logo__description' => 'Προσαρμόστε την εμπορική ταυτότητα του Plesk, αλλάζοντας την εικόνα του λογοτύπου και τη γραμμή τίτλου του προγράμματος περιήγησης.',

    // help & support
    // icons
    'ui__support__short-title' => 'Υποστήριξη',
    'ui__support__title' => 'Υποστήριξη',
    'ui__support__description' => 'Υποβολή αιτήματος για τεχνική υποστήριξη ή έλεγχος των εισιτηρίων υποστήριξης που αποστέλλουν οι πελάτες σας.',
    'ui__license__short-title' => 'Διαχείριση αδειών χρήσης',
    'ui__license__title' => 'Διαχείριση αδειών Plesk',
    'ui__license__description' => 'Προβολή πληροφοριών σχετικά με την άδεια σας στο Plesk και παραγγελία νέων κλειδιών άδειας χρήσης.',
    'ui__help__short-title' => 'Βοήθεια',
    'ui__help__title' => 'Ηλεκτρονική βοήθεια',
    'ui__help__description' => 'Προβολή ηλεκτρονικής βοήθειας.',
    'ui__news__short-title' => "Νέα χαρακτηριστικά",
    'ui__news__title' => "Νέα χαρακτηριστικά",
    'ui__news__description' => "Προβολή της λίστας με τις αλλαγές σε αυτήν την έκδοση του Plesk.",
    'ui__server/autoinstaller__short-title' => 'Ενημερώσεις',
    'ui__server/autoinstaller__title' => 'Ενημερώσεις',
    'ui__server/autoinstaller__description' => 'Ενημέρωση Plesk και των στοιχείων του.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Τομείς',
    'ui__client/domain_unknown__title' => 'Τομείς',
    'ui__client/domain_unknown__description' => 'Διαχείριση τομέων.',
    'ui__server/skeleton__short-title' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'ui__server/skeleton__title' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'ui__server/skeleton__description' => 'Καθορίστε τα αρχεία και τους φακέλους που πρέπει να τοποθετούνται στους καταλόγους των νεοσύστατων τομέων.',
    // dropdowns
    'ui__client/domain/properties_unknown-new__title' => 'Δημιουργία τομέα',
    'ui__client/domain/properties_unknown-new__short-title' => 'Δημιουργία τομέα',
    'ui__client/domain/properties_unknown-new__description' => 'Δημιουργία και ρύθμιση παραμέτρων τομέα.',
    'ui__client/domain/chowner_multi-select__title' => 'Ορισμός νέου κατόχου για συνδρομές',
    'ui__client/domain/chowner_multi-select__short-title' => 'Ορισμός νέου κατόχου συνδρομής',
    'ui__client/domain/chowner_multi-select__description' => 'Ορισμός νέου κατόχου για επιλεγμένες συνδρομές',
    'ui__client/domain/to-client_multi__title' => 'Μετατροπή λογαριασμών διαχειριστή τομέα σε λογαριασμούς πελατών',
    'ui__client/domain/to-client_multi__short-title' => 'Μετατροπή σε πελάτες',
    'ui__client/domain/to-client_multi__description' => 'Μετατροπή επιλεγμένων λογαριασμών διαχειριστή τομέα σε λογαριασμούς πελατών',
    'ui__client/domain/disable_multi__title' => 'Αναστολή τομέων',
    'ui__client/domain/disable_multi__short-title' => 'Αναστολή τομέων',
    'ui__client/domain/disable_multi__description' => 'Αναστολή επιλεγμένων τομέων',
    'ui__client/domain/enable_multi__title' => 'Ενεργοποίηση τομέων',
    'ui__client/domain/enable_multi__short-title' => 'Ενεργοποίηση τομέων',
    'ui__client/domain/enable_multi__description' => 'Ενεργοποίηση επιλεγμένων τομέων',

    // icons
    'ui__admin/extras-domain__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'Ρυθμίσεις ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Ρυθμίσεις ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Διαμόρφωση ρυθμίσεων ASP.NET σε επίπεδο διακομιστή.', // PFW
    'ui__server/sitebuilder__short-title' => 'Ρυθμίσεις Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Ρυθμίσεις Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Ρύθμιση του Presence Builder για την επεξεργασία των τοποθεσιών web που φιλοξενούνται σε αυτόν το διακομιστή.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Καταχώρηση τομέα',
    'ui__admin/register-domain__short-title' => 'Καταχώρηση τομέα',
    'ui__admin/register-domain__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Διαχείριση τομέα',
    'ui__admin/manage-domain__short-title' => 'Διαχείριση τομέα',
    'ui__admin/manage-domain__description' => 'Διαχείριση καταχωρημένων ονομάτων τομέα μέσω του MyPlesk.com.',
    'ui__server/register__title' => 'Καταχωρήστε το διακομιστή σας',
    'ui__server/register__short-title' => 'Καταχώρηση διακομιστή',
    'ui__server/register__description' => 'Καταχωρήστε το διακομιστή σας για να συμμετάσχετε στο πρόγραμμα συνεργατών',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Αρχείο καταγραφής ενεργειών',
    'ui__actionlog__title' => 'Αρχείο καταγραφής ενεργειών',
    'ui__actionlog__description' => 'Λήψη αρχείου καταγραφής ενεργειών και διαχείριση ρυθμίσεων αρχείου καταγραφής ενεργειών.',
    'ui__notification_unknown__short-title' => 'Ειδοποιήσεις',
    'ui__notification_unknown__title' => 'Ειδοποιήσεις',
    'ui__notification_unknown__description' => 'Προβολή και επεξεργασία των ειδοποιήσεων που αποστέλλονται μετά από σημαντικά συμβάντα στο Plesk.',
    'ui__server/resources__short-title' => 'Χρήση πόρων',
    'ui__server/resources__title' => 'Χρήση πόρων',
    'ui__server/resources__description' => 'Προβολή της χρήσης πόρων συστήματος.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Πληροφορίες διακομιστή',
    'ui__server/statistics__title' => 'Πληροφορίες διακομιστή',
    'ui__server/statistics__description' => 'Στατιστικά στοιχεία σχετικά με τις υπηρεσίες η διαχείριση των οποίων γίνεται από το Plesk.',
    'ui__admin/report__title' => 'Συνοπτική αναφορά',
    'ui__admin/report__short-title' => 'Συνοπτική αναφορά',
    'ui__admin/report__description' => 'Προβολή αναφοράς σχετικά με την κίνηση και τη χρήση πόρων από τους μεταπωλητές, τους πελάτες και τους τομείς.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Χρόνος αδράνειας περιόδου λειτουργίας',
    'ui__sessions/properties__title' => 'Χρόνος αδράνειας περιόδου λειτουργίας',
    'ui__sessions/properties__description' => 'Ορισμός χρόνου αδράνειας για τις περιόδους λειτουργίας του Plesk.',
    'ui__cp-access__short-title' => 'Πρόσβαση στο Plesk',
    'ui__cp-access__title' => 'Πρόσβαση στο Plesk',
    'ui__cp-access__description' => 'Περιορισμός πρόσβασης στο Plesk.',
    'ui__sessions__short-title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__sessions__title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__sessions__description' => 'Προβολή ενεργών περιόδων λειτουργίας του Plesk.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Πιστοποιητικά SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Πιστοποιητικά SSL/TLS',
    'ui__server/certificate_unknown__description' => 'Η λίστα των πιστοποιητικών SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Προσωπικά δεδομένα',
    'ui__admin-info__title' => 'Προσωπικά δεδομένα',
    'ui__admin-info__description' => 'Αλλαγή προσωπικών δεδομένων στο λογαριασμό σας.',
    'ui__admin-password__short-title' => 'Αλλαγή κωδικού πρόσβασης',
    'ui__admin-password__title' => 'Αλλαγή κωδικού πρόσβασης',
    'ui__admin-password__description' => 'Αλλαγή κωδικού πρόσβασης για το λογαριασμό σας.',
    'ui__admin/interface__short-title' => 'Προτιμήσεις περιβάλλοντος εργασίας',
    'ui__admin/interface__title' => 'Προτιμήσεις περιβάλλοντος εργασίας διαχειριστή',
    'ui__admin/interface__description' => 'Αλλαγή προτιμήσεων περιβάλλοντος εργασίας διαχειριστή του διακομιστή.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => 'Διαχείριση αρχείων',
    'ui__client/domain/hosting/file-manager_unknown__title' => 'Διαχείριση αρχείων',
    'ui__client/domain/hosting/file-manager_unknown__description' => 'Επεξεργασία αρχείων και καταλόγων μέσω της διαχείρισης αρχείων.',
    'ui__client/domain/hosting/tsclient_unknown__short-title' => 'Απομακρυσμένη επιφάνεια εργασίας', // PFW
    'ui__client/domain/hosting/tsclient_unknown__title' => 'Απομακρυσμένη επιφάνεια εργασίας', // PFW
    'ui__client/domain/hosting/tsclient_unknown__description' => 'Πρόσβαση στο διακομιστή μέσω απομακρυσμένης επιφάνειας εργασίας.', // PFW
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'Τερματικό SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'Τερματικό SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => 'Χρήση τερματικού SSH για πρόσβαση στο διακομιστή.', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Κατάλογοι με προστασία κωδικού πρόσβασης',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Κατάλογοι με προστασία κωδικού πρόσβασης',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Προστασία της πρόσβασης σε επιλεγμένες περιοχές της τοποθεσίας web.',
    'ui__client/domain/hosting/virtual-directories_unknown__short-title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__description' => 'Δημιουργία και διαχείριση εικονικών καταλόγων σε έναν τομέα.', // PFW
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Επεξεργασία φυσικών και εικονικών αρχείων και καταλόγων μιας τοποθεσίας web σας.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats_unknown__short-title' => 'Στατιστικά στοιχεία web',
    'ui__client/domain/report/web-stats_unknown__title' => 'Στατιστικά στοιχεία web',
    'ui__client/domain/report/web-stats_unknown__description' => 'Προβολή στατιστικών στοιχείων επισκέψεων στην τοποθεσία web.',
    'ui__reseller/limits__short-title' => 'Χρήση πόρων',
    'ui__reseller/limits__title' => 'Χρήση πόρων',
    'ui__reseller/limits__description' => 'Προβολή και διαχείριση της χρήσης πόρων του μεταπωλητή %1.',
    'ui__reseller/limits_unknown__short-title' => 'Χρήση πόρων',
    'ui__reseller/limits_unknown__title' => 'Χρήση πόρων',
    'ui__reseller/limits_unknown__description' => 'Προβολή και διαχείριση της χρήσης πόρων του μεταπωλητή.',
    'ui__reseller/limits_self__short-title' => 'Χρήση πόρων',
    'ui__reseller/limits_self__title' => 'Χρήση πόρων',
    'ui__reseller/limits_self__description' => "Προβολή και διαχείριση της χρήσης πόρων σας.",
    'ui__reseller/limits_readonly-self__short-title' => 'Χρήση πόρων',
    'ui__reseller/limits_readonly-self__title' => 'Χρήση πόρων',
    'ui__reseller/limits_readonly-self__description' => "Προβολή της χρήσης πόρων σας.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Χρήση κίνησης από τους πελάτες',
    'ui__reseller/client/traffic_unknown__title' => 'Προβολή χρήσης κίνησης από τους πελάτες',
    'ui__reseller/client/traffic_unknown__description' => 'Προβολή αναφορών χρήσης κίνησης για τους λογαριασμούς πελατών.',
    'ui__client/traffic_unknown__short-title' => "Χρήση κίνησης από τους πελάτες", // temporary for presets
    'ui__client/traffic_unknown__title' => "Προβολή χρήσης κίνησης από τους πελάτες", // temporary for presets
    'ui__client/traffic_unknown__description' => "Προβολή αναφορών χρήσης κίνησης για τους λογαριασμούς πελατών.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Διαχείριση αρχείων καταγραφής',
    'ui__client/domain/hosting/logs_unknown__title' => 'Διαχείριση αρχείων καταγραφής',
    'ui__client/domain/hosting/logs_unknown__description' => 'Προβολή αρχείων καταγραφής και διαμόρφωση της ανακύκλωσης αρχείων καταγραφής.',
    // dropdowns
    'ui__reseller/report__title' => 'Συνοπτική αναφορά',
    'ui__reseller/report__short-title' => 'Συνοπτική αναφορά',
    'ui__reseller/report__description' => 'Προβολή αναφοράς σχετικά με τη χρήση κίνησης και πόρων γι\' αυτόν το μεταπωλητή.',
    'ui__reseller/report_unknown__title' => 'Συνοπτική αναφορά',
    'ui__reseller/report_unknown__short-title' => 'Συνοπτική αναφορά',
    'ui__reseller/report_unknown__description' => 'Προβολή αναφοράς σχετικά με τη χρήση κίνησης και πόρων για το μεταπωλητή.',
    'ui__reseller/report_self__title' => 'Συνοπτική αναφορά',
    'ui__reseller/report_self__short-title' => 'Συνοπτική αναφορά',
    'ui__reseller/report_self__description' => 'Προβολή αναφοράς σχετικά με τη χρήση της κίνησης και των πόρων σας.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Εμπορική ταυτότητα Plesk',
    'ui__client/logo_reseller__short-title' => 'Εμπορική ταυτότητα Plesk',
    'ui__client/logo_reseller__description' => 'Εφαρμογή νέας εμπορικής ταυτότητας στο Plesk για τον μεταπωλητή %1.',
    'ui__client/logo_unknown__title' => 'Εμπορική ταυτότητα Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Εμπορική ταυτότητα Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Εφαρμογή νέας εμπορικής ταυτότητας στο Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Εμπορική ταυτότητα Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Εμπορική ταυτότητα Plesk',
    'ui__client/logo_self-reseller__description' => 'Εφαρμόστε νέα εμπορική ταυτότητα στο Plesk σας.',
    'ui__reseller/permissions__title' => 'Δικαιώματα',
    'ui__reseller/permissions__short-title' => 'Δικαιώματα',
    'ui__reseller/permissions__description' => "Προβολή ή αλλαγή των ενεργειών που μπορεί να εκτελέσει ο μεταπωλητής %1 στο Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Δικαιώματα',
    'ui__reseller/permissions_unknown__title' => 'Δικαιώματα',
    'ui__reseller/permissions_unknown__description' => "Προβολή ή αλλαγή των ενεργειών που μπορεί να εκτελέσει ο μεταπωλητής στο Plesk.",
    'ui__reseller/permissions_self__title' => 'Δικαιώματα',
    'ui__reseller/permissions_self__short-title' => 'Δικαιώματα',
    'ui__reseller/permissions_self__description' => 'Προβολή της λίστας με τις ενέργειες που μπορείτε να εκτελέσετε στο Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Δικαιώματα',
    'ui__reseller/permissions_readonly-self__short-title' => 'Δικαιώματα',
    'ui__reseller/permissions_readonly-self__description' => 'Προβολή της λίστας με τις ενέργειες που μπορείτε να εκτελέσετε στο Plesk.',
    // dropdowns
    'ui__reseller/to-client__title' => 'Μετατροπή λογαριασμού μεταπωλητή σε λογαριασμό πελάτη',
    'ui__reseller/to-client__short-title' => 'Μετατροπή μεταπωλητή σε πελάτη',
    'ui__reseller/to-client__description' => 'Μετατροπή αυτού του λογαριασμού μεταπωλητή σε λογαριασμό πελάτη.',
    'ui__reseller/to-client_unknown__title' => 'Μετατροπή λογαριασμού μεταπωλητή σε λογαριασμό πελάτη',
    'ui__reseller/to-client_unknown__short-title' => 'Μετατροπή μεταπωλητή σε πελάτη',
    'ui__reseller/to-client_unknown__description' => 'Μετατροπή λογαριασμού μεταπωλητή σε λογαριασμό πελάτη.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'ui__client/skeleton__short-title' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'ui__client/skeleton__description' => 'Καθορίστε τα αρχεία και τους φακέλους που πρέπει να τοποθετούνται στους καταλόγους των νεοσύστατων τομέων.',
    'ui__client/skeleton_unknown__short-title' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'ui__client/skeleton_unknown__title' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'ui__client/skeleton_unknown__description' => 'Καθορίστε τα αρχεία και τους φακέλους που πρέπει να τοποθετούνται στους καταλόγους των νεοσύστατων τομέων.',
    // dropdowns
    'ui__client/domain/properties_new__title' => 'Δημιουργία τομέα',
    'ui__client/domain/properties_new__short-title' => 'Δημιουργία τομέα',
    'ui__client/domain/properties_new__description' => "Δημιουργία τομέα για το %1.",
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert domain administrator accounts to customer accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Ψευδώνυμα τομέα',
    'ui__client/domain/domain-alias_unknown__title' => 'Ψευδώνυμα τομέα',
    'ui__client/domain/domain-alias_unknown__description' => 'Προβολή της λίστας των εναλλακτικών ονομάτων για τον τομέα σας.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_unknown__description' => 'Διαχείριση ρυθμίσεων ζώνης DNS για έναν τομέα.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Προβολή ρυθμίσεων ζώνης DNS για έναν τομέα.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    'ui__client/domain/odbc_unknown__short-title' => 'Αρχεία προέλευσης δεδομένων ODBC', // PFW
    'ui__client/domain/odbc_unknown__title' => 'Αρχεία προέλευσης δεδομένων ODBC', // PFW
    'ui__client/domain/odbc_unknown__description' => 'Ρύθμιση προελεύσεων δεδομένων ODBC για έναν τομέα.', // PFW
    'ui__reseller/register-domain__short-title' => 'Καταχώρηση τομέα',
    'ui__reseller/register-domain__title' => 'Καταχώρηση τομέα',
    'ui__reseller/register-domain__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Καταχώρηση τομέα',
    'ui__reseller/register-domain_unknown__title' => 'Καταχώρηση τομέα',
    'ui__reseller/register-domain_unknown__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Καταχώρηση τομέα',
    'ui__reseller/register-domain_self__title' => 'Καταχώρηση τομέα',
    'ui__reseller/register-domain_self__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Διαχείριση τομέα',
    'ui__reseller/manage-domain__short-title' => 'Διαχείριση τομέα',
    'ui__reseller/manage-domain__description' => 'Διαχείριση καταχωρημένων ονομάτων τομέα μέσω του MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Διαχείριση τομέα',
    'ui__reseller/manage-domain_unknown__short-title' => 'Διαχείριση τομέα',
    'ui__reseller/manage-domain_unknown__description' => 'Διαχείριση καταχωρημένων ονομάτων τομέα μέσω του MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Διαχείριση τομέα',
    'ui__reseller/manage-domain_self__short-title' => 'Διαχείριση τομέα',
    'ui__reseller/manage-domain_self__description' => 'Διαχείριση καταχωρημένων ονομάτων τομέα μέσω του MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'Διευθύνσεις IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'Διευθύνσεις IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'Διαχείριση διευθύνσεων IP.',
    'ui__client/domain/certificate_unknown__short-title' => 'Πιστοποιητικά SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Πιστοποιητικά SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Εγκατάσταση και διαχείριση πιστοποιητικών SSL/TLS.',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => 'Προστασία Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => 'Προστασία Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => 'Προστασία των αρχείων από το hotlinking.', // PFW
    'ui__reseller/sessions__short-title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__reseller/sessions__title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__reseller/sessions__description' => 'Προβολή ενεργών περιόδων λειτουργίας του Plesk.',
    'ui__reseller/sessions_unknown__short-title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__reseller/sessions_unknown__title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__reseller/sessions_unknown__description' => 'Προβολή ενεργών περιόδων λειτουργίας του Plesk.',
    'ui__reseller/sessions_self__short-title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__reseller/sessions_self__title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__reseller/sessions_self__description' => 'Προβολή ενεργών περιόδων λειτουργίας του Plesk.',
    'ui__client/domain/hosting/performance_unknown__short-title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance_unknown__title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance_unknown__description' => 'Προβολή και προσαρμογή του ορίου χρήσης εύρους ζώνης και του αριθμού ταυτόχρονων συνδέσεων σε μια τοποθεσία web.',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => 'Προβολή του ορίου χρήσης εύρους ζώνης και του αριθμού ταυτόχρονων συνδέσεων σε μια τοποθεσία web.',
    'ui__client/domain/hosting/php_unknown__short-title' => 'Ρυθμίσεις PHP', // PFW
    'ui__client/domain/hosting/php_unknown__title' => 'Ρυθμίσεις PHP', // PFW
    'ui__client/domain/hosting/php_unknown__description' => 'Ρύθμιση παραμέτρων PHP σε έναν τομέα.', // PFW

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Λογαριασμοί αλληλογραφίας στο λογαριασμό χρήστη %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'ui__client/skeleton_self__title' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'ui__client/skeleton_self__description' => 'Καθορίστε τα αρχεία και τους φακέλους που πρέπει να τοποθετούνται στους καταλόγους των νεοσύστατων τομέων.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // Remote desktop - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Χρήση πόρων',
    'ui__client/limits__title' => 'Χρήση πόρων',
    'ui__client/limits__description' => "Προβολή και διαχείριση της χρήσης πόρων του πελάτη %1.",
    'ui__client/limits_unknown__short-title' => 'Χρήση πόρων',
    'ui__client/limits_unknown__title' => 'Χρήση πόρων',
    'ui__client/limits_unknown__description' => 'Προβολή και διαχείριση της χρήσης πόρων του πελάτη.',
    'ui__client/limits_readonly__short-title' => 'Χρήση πόρων',
    'ui__client/limits_readonly__title' => 'Χρήση πόρων',
    'ui__client/limits_readonly__description' => 'Προβολή χρήσης πόρων του πελάτη %1.',
    'ui__client/limits_self__short-title' => 'Χρήση πόρων',
    'ui__client/limits_self__title' => 'Χρήση πόρων',
    'ui__client/limits_self__description' => "Προβολή και διαχείριση της χρήσης πόρων σας.",
    'ui__client/limits_readonly-self__short-title' => 'Χρήση πόρων',
    'ui__client/limits_readonly-self__title' => 'Χρήση πόρων',
    'ui__client/limits_readonly-self__description' => "Προβολή της χρήσης πόρων σας.",
    'ui__client/domain/traffic_unknown__short-title' => "Χρήση κίνησης από τους τομείς %1",
    'ui__client/domain/traffic_unknown__title' => "Προβολή χρήσης κίνησης από τους τομείς",
    'ui__client/domain/traffic_unknown__description' => "Προβολή αναφορών χρήσης κίνησης για τους τομείς.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Συνοπτική αναφορά',
    'ui__client/report__short-title' => 'Συνοπτική αναφορά',
    'ui__client/report__description' => 'Προβολή αναφοράς σχετικά με τη χρήση κίνησης και πόρων γι\' αυτόν τον πελάτη.',
    'ui__client/report_unknown__short-title' => 'Συνοπτική αναφορά',
    'ui__client/report_unknown__title' => 'Συνοπτική αναφορά',
    'ui__client/report_unknown__description' => 'Προβολή αναφοράς σχετικά με τη χρήση κίνησης και πόρων για τον πελάτη.',
    'ui__client/report_self__short-title' => 'Συνοπτική αναφορά',
    'ui__client/report_self__title' => 'Συνοπτική αναφορά',
    'ui__client/report_self__description' => 'Προβολή αναφοράς σχετικά με τη χρήση κίνησης και πόρων.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Προτιμήσεις περιβάλλοντος εργασίας',
    'ui__client/preferences__title' => 'Προτιμήσεις περιβάλλοντος εργασίας',
    'ui__client/preferences__description' => 'Ορισμός προτιμήσεων του Plesk για τον πελάτη %1.',
    'ui__client/preferences_unknown__short-title' => 'Προτιμήσεις περιβάλλοντος εργασίας',
    'ui__client/preferences_unknown__title' => 'Προτιμήσεις περιβάλλοντος εργασίας',
    'ui__client/preferences_unknown__description' => "Ορισμός προτιμήσεων περιβάλλοντος εργασίας για το Plesk του πελάτη.",
    'ui__client/preferences_self__short-title' => 'Προτιμήσεις περιβάλλοντος εργασίας',
    'ui__client/preferences_self__title' => 'Προτιμήσεις περιβάλλοντος εργασίας',
    'ui__client/preferences_self__description' => 'Ορισμός προτιμήσεων περιβάλλοντος εργασίας για το Plesk σας.',
    'ui__client/logo__title' => 'Εμπορική ταυτότητα Plesk',
    'ui__client/logo__short-title' => 'Εμπορική ταυτότητα Plesk',
    'ui__client/logo__description' => "Αλλάξτε την εμπορική ταυτότητα στο Plesk του πελάτη %1.",
    'ui__client/logo_self__title' => 'Εμπορική ταυτότητα Plesk',
    'ui__client/logo_self__short-title' => 'Εμπορική ταυτότητα Plesk',
    'ui__client/logo_self__description' => 'Προσαρμόστε την εμπορική ταυτότητα του Plesk, αλλάζοντας την εικόνα του λογοτύπου και τη γραμμή τίτλου του προγράμματος περιήγησης.',
    'ui__client/permissions__title' => 'Δικαιώματα',
    'ui__client/permissions__short-title' => 'Δικαιώματα',
    'ui__client/permissions__description' => "Προβολή ή αλλαγή των ενεργειών που μπορεί να εκτελέσει ο πελάτης %1 στο Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Δικαιώματα',
    'ui__client/permissions_unknown__title' => 'Δικαιώματα',
    'ui__client/permissions_unknown__description' => "Προβολή ή αλλαγή των ενεργειών που μπορεί να εκτελέσει ο πελάτης στο Plesk.",
    'ui__client/permissions_self__title' => 'Δικαιώματα',
    'ui__client/permissions_self__short-title' => 'Δικαιώματα',
    'ui__client/permissions_self__description' => "Προβολή της λίστας με τις ενέργειες που μπορείτε να εκτελέσετε στο Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Δικαιώματα',
    'ui__client/permissions_readonly-self__short-title' => 'Δικαιώματα',
    'ui__client/permissions_readonly-self__description' => "Προβολή της λίστας με τις ενέργειες που μπορείτε να εκτελέσετε στο Plesk.",
    // dropdowns
    'ui__client/chowner_select__title' => 'Ορισμός νέου κατόχου για το λογαριασμό πελάτη',
    'ui__client/chowner_select__short-title' => 'Ορισμός νέου κατόχου για τον πελάτη',
    'ui__client/chowner_select__description' => 'Ορισμός νέου κατόχου γι\' αυτόν το λογαριασμό πελάτη.',
    'ui__client/chowner_unknown-select__short-title' => 'Ορισμός νέου κατόχου για το λογαριασμό πελάτη',
    'ui__client/chowner_unknown-select__title' => 'Ορισμός νέου κατόχου για τον πελάτη',
    'ui__client/chowner_unknown-select__description' => 'Ορισμός νέου κατόχου για το λογαριασμό πελάτη.',
    'ui__client/to-reseller__title' => 'Μετατροπή λογαριασμού πελάτη σε λογαριασμό μεταπωλητή',
    'ui__client/to-reseller__short-title' => 'Μετατροπή πελάτη σε μεταπωλητή',
    'ui__client/to-reseller__description' => 'Μετατροπή αυτού του λογαριασμού πελάτη σε λογαριασμό μεταπωλητή.',
    'ui__client/to-reseller_unknown__title' => 'Μετατροπή λογαριασμού πελάτη σε λογαριασμό μεταπωλητή',
    'ui__client/to-reseller_unknown__short-title' => 'Μετατροπή πελάτη σε μεταπωλητή',
    'ui__client/to-reseller_unknown__description' => 'Μετατροπή αυτού του λογαριασμού πελάτη σε λογαριασμό μεταπωλητή.',

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/extras-domain__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/extras-domain__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Καταχώρηση τομέα',
    'ui__client/register-domain__short-title' => 'Καταχώρηση τομέα',
    'ui__client/register-domain__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Καταχώρηση τομέα',
    'ui__client/register-domain_unknown__short-title' => 'Καταχώρηση τομέα',
    'ui__client/register-domain_unknown__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Καταχώρηση τομέα',
    'ui__client/register-domain_self__short-title' => 'Καταχώρηση τομέα',
    'ui__client/register-domain_self__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Διαχείριση τομέα',
    'ui__client/manage-domain__short-title' => 'Διαχείριση τομέα',
    'ui__client/manage-domain__description' => 'Διαχείριση καταχωρημένων ονομάτων τομέα μέσω του MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Διαχείριση τομέα',
    'ui__client/manage-domain_unknown__short-title' => 'Διαχείριση τομέα',
    'ui__client/manage-domain_unknown__description' => 'Διαχείριση καταχωρημένων ονομάτων τομέα μέσω του MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Διαχείριση τομέα',
    'ui__client/manage-domain_self__short-title' => 'Διαχείριση τομέα',
    'ui__client/manage-domain_self__description' => 'Διαχείριση καταχωρημένων ονομάτων τομέα μέσω του MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'Διευθύνσεις IP',
    'ui__client/ipaddress_unknown__short-title' => "Διευθύνσεις IP",
    'ui__client/ipaddress_unknown__description' => "Διαχείριση διευθύνσεων IP.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Ψευδώνυμα τομέα',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Ψευδώνυμα τομέα',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Προβολή της λίστας των εναλλακτικών ονομάτων για τον τομέα σας.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__client/sessions__title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__client/sessions__description' => 'Προβολή ενεργών περιόδων λειτουργίας του Plesk.',
    'ui__client/sessions_unknown__short-title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__client/sessions_unknown__title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__client/sessions_unknown__description' => 'Προβολή ενεργών περιόδων λειτουργίας του Plesk.',
    'ui__client/sessions_self__short-title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__client/sessions_self__title' => 'Ενεργές περίοδοι λειτουργίας',
    'ui__client/sessions_self__description' => 'Προβολή ενεργών περιόδων λειτουργίας του Plesk.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => 'Διαχείριση αρχείων',
    'ui__client/domain/hosting/file-manager__title' => 'Διαχείριση αρχείων του τομέα %1',
    'ui__client/domain/hosting/file-manager__description' => "Επεξεργασία αρχείων και καταλόγων του τομέα %1 μέσω της διαχείρισης αρχείων.",
    'ui__client/domain/hosting/file-manager_self__short-title' => 'Διαχείριση αρχείων',
    'ui__client/domain/hosting/file-manager_self__title' => 'Διαχείριση αρχείων',
    'ui__client/domain/hosting/file-manager_self__description' => "Επεξεργασία των αρχείων και καταλόγων σας μέσω της διαχείρισης αρχείων.",
    'ui__client/domain/hosting/tsclient__short-title' => 'Απομακρυσμένη επιφάνεια εργασίας', // PFW
    'ui__client/domain/hosting/tsclient__title' => 'Απομακρυσμένη επιφάνεια εργασίας', // PFW
    'ui__client/domain/hosting/tsclient__description' => 'Πρόσβαση στο διακομιστή μέσω απομακρυσμένης επιφάνειας εργασίας.', // PFW
    'ui__client/domain/hosting/tsclient_self__short-title' => 'Απομακρυσμένη επιφάνεια εργασίας', // PFW
    'ui__client/domain/hosting/tsclient_self__title' => 'Απομακρυσμένη επιφάνεια εργασίας', // PFW
    'ui__client/domain/hosting/tsclient_self__description' => 'Πρόσβαση στο διακομιστή μέσω απομακρυσμένης επιφάνειας εργασίας.', // PFW
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'Τερματικό SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'Τερματικό SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => 'Χρήση τερματικού SSH για πρόσβαση στο διακομιστή.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'Τερματικό SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'Τερματικό SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => 'Χρήση τερματικού SSH για πρόσβαση στο διακομιστή.', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => 'Κατάλογοι με προστασία κωδικού πρόσβασης',
    'ui__client/domain/hosting/protected-directories__title' => 'Κατάλογοι με προστασία κωδικού πρόσβασης',
    'ui__client/domain/hosting/protected-directories__description' => 'Προστασία της πρόσβασης σε επιλεγμένες περιοχές της τοποθεσίας web.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Κατάλογοι με προστασία κωδικού πρόσβασης',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Κατάλογοι με προστασία κωδικού πρόσβασης',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Προστασία της πρόσβασης σε επιλεγμένες περιοχές της τοποθεσίας web.',
    'ui__client/domain/hosting/virtual-directories__short-title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/virtual-directories__title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/virtual-directories__description' => 'Δημιουργία και διαχείριση εικονικών καταλόγων στον τομέα %1.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__short-title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/virtual-directories_self__title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/virtual-directories_self__description' => 'Δημιουργία και διαχείριση εικονικών καταλόγων στον τομέα σας.', // PFW
    'ui__client/domain/hosting/web-directories__title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Επεξεργασία φυσικών και εικονικών αρχείων και καταλόγων της τοποθεσίας %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Εικονικοί κατάλογοι', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Επεξεργασία φυσικών και εικονικών αρχείων και καταλόγων της τοποθεσίας web σας.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats__short-title' => 'Στατιστικά στοιχεία web',
    'ui__client/domain/report/web-stats__title' => 'Στατιστικά στοιχεία web',
    'ui__client/domain/report/web-stats__description' => 'Προβολή στατιστικών στοιχείων επισκέψεων στην τοποθεσία web.',
    'ui__client/domain/report/web-stats_self__short-title' => 'Στατιστικά στοιχεία web',
    'ui__client/domain/report/web-stats_self__title' => 'Στατιστικά στοιχεία web',
    'ui__client/domain/report/web-stats_self__description' => 'Προβολή στατιστικών στοιχείων επισκέψεων στην τοποθεσία web.',
    'ui__client/domain/traffic__short-title' => 'Χρήση κίνησης %1',
    'ui__client/domain/traffic__title' => 'Στατιστικά στοιχεία μεταφοράς δεδομένων για τον τομέα %1',
    'ui__client/domain/traffic__description' => 'Προβολή στατιστικών στοιχείων μεταφοράς δεδομένων για τον τομέα %1.',
    'ui__client/domain/traffic_self__short-title' => 'Χρήση κίνησης',
    'ui__client/domain/traffic_self__title' => 'Προβολή χρήσης κίνησης για τον τομέα σας',
    'ui__client/domain/traffic_self__description' => 'Προβολή αναφοράς χρήσης κίνησης για τον τομέα σας.',
    'ui__client/domain/hosting/logs__short-title' => 'Διαχείριση αρχείων καταγραφής',
    'ui__client/domain/hosting/logs__title' => 'Διαχείριση αρχείων καταγραφής',
    'ui__client/domain/hosting/logs__description' => 'Προβολή αρχείων καταγραφής και διαμόρφωση της ανακύκλωσης αρχείων καταγραφής.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Διαχείριση αρχείων καταγραφής',
    'ui__client/domain/hosting/logs_self__title' => 'Διαχείριση αρχείων καταγραφής',
    'ui__client/domain/hosting/logs_self__description' => 'Προβολή αρχείων καταγραφής και διαμόρφωση της ανακύκλωσης αρχείων καταγραφής.',
    // dropdowns
    'ui__client/domain/report__title' => 'Συνοπτική αναφορά',
    'ui__client/domain/report__short-title' => 'Συνοπτική αναφορά',
    'ui__client/domain/report__description' =>  'Προβολή αναφοράς σχετικά με τη χρήση κίνησης και πόρων.',
    'ui__client/domain/report_unknown__short-title' => 'Συνοπτική αναφορά',
    'ui__client/domain/report_unknown__title' => 'Συνοπτική αναφορά',
    'ui__client/domain/report_unknown__description' => 'Προβολή αναφοράς σχετικά με τη χρήση κίνησης και πόρων.',
    'ui__client/domain/report_self__short-title' => 'Συνοπτική αναφορά',
    'ui__client/domain/report_self__title' => 'Συνοπτική αναφορά',
    'ui__client/domain/report_self__description' => 'Προβολή αναφοράς σχετικά με τη χρήση κίνησης και πόρων.',

    // domain administration
    // icons
    'ui__client/domain/properties__short-title' => 'Προσωπικά δεδομένα',
    'ui__client/domain/properties__title' => 'Προσωπικά δεδομένα',
    'ui__client/domain/properties__description' => 'Αλλαγή προσωπικών δεδομένων για το λογαριασμό διαχειριστή του τομέα.',
    'ui__client/domain/properties_unknown__short-title' => 'Προσωπικά δεδομένα',
    'ui__client/domain/properties_unknown__title' => 'Προσωπικά δεδομένα',
    'ui__client/domain/properties_unknown__description' => 'Αλλαγή προσωπικών δεδομένων για το λογαριασμό.',
    'ui__client/domain/properties_self__short-title' => 'Προσωπικά δεδομένα',
    'ui__client/domain/properties_self__title' => 'Προσωπικά δεδομένα',
    'ui__client/domain/properties_self__description' => 'Αλλαγή προσωπικών δεδομένων στο λογαριασμό σας.',
    // dropdowns
    'ui__client/domain/rename__title' => 'Μετονομασία τομέα',
    'ui__client/domain/rename__short-title' => 'Μετονομασία τομέα',
    'ui__client/domain/rename__description' => 'Μετονομασία του τομέα %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Μετονομασία τομέα',
    'ui__client/domain/rename_unknown__title' => 'Μετονομασία τομέα',
    'ui__client/domain/rename_unknown__description' => 'Μετονομασία ενός τομέα',
    'ui__client/domain/chowner_select__title' => 'Ορισμός νέου κατόχου για τομέα',
    'ui__client/domain/chowner_select__short-title' => 'Ορισμός νέου κατόχου για συνδρομή',
    'ui__client/domain/chowner_select__description' => 'Ορισμός νέου κατόχου για τη συνδρομή',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Ορισμός νέου κατόχου για συνδρομή',
    'ui__client/domain/chowner_unknown-select__title' => 'Ορισμός νέου κατόχου για συνδρομή',
    'ui__client/domain/chowner_unknown-select__description' => 'Ορισμός νέου κατόχου για μια συνδρομή.',
    'ui__client/domain/to-client__title' => 'Μετατροπή λογαριασμού διαχειριστή τομέα σε λογαριασμό πελάτη',
    'ui__client/domain/to-client__short-title' => 'Μετατροπή διαχειριστή τομέα σε πελάτη',
    'ui__client/domain/to-client__description' => 'Μετατροπή αυτού του λογαριασμού διαχειριστή τομέα σε λογαριασμό πελάτη',
    'ui__client/domain/to-client_unknown__short-title' => 'Μετατροπή διαχειριστή τομέα σε πελάτη',
    'ui__client/domain/to-client_unknown__title' => 'Μετατροπή λογαριασμού διαχειριστή τομέα σε λογαριασμό πελάτη',
    'ui__client/domain/to-client_unknown__description' => 'Μετατροπή λογαριασμού διαχειριστή τομέα σε λογαριασμό πελάτη',
    'ui__client/domain/toggle__title' => 'Αναστολή ή ενεργοποίηση τομέα', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Αναστολή ή ενεργοποίηση τομέα', // for HP customization
    'ui__client/domain/toggle__description' => 'Αναστολή ή ενεργοποίηση του τομέα %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Αναστολή ή ενεργοποίηση τομέα', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Αναστολή ή ενεργοποίηση τομέα', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Αναστολή ή ενεργοποίηση τομέα.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Ενεργοποίηση τομέα',
    'ui__client/domain/toggle_enable__short-title' => 'Ενεργοποίηση τομέα',
    'ui__client/domain/toggle_enable__description' => 'Ενεργοποίηση του τομέα %1.',
    'ui__client/domain/toggle_disable__title' => 'Αναστολή τομέα',
    'ui__client/domain/toggle_disable__short-title' => 'Αναστολή τομέα',
    'ui__client/domain/toggle_disable__description' => 'Αναστολή του τομέα %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns__description' => 'Διαχείριση ρυθμίσεων ζώνης DNS για τον τομέα %1.',
    'ui__client/domain/dns_self__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_self__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_self__description' => 'Διαχείριση ρυθμίσεων ζώνης DNS για τον τομέα σας.',
    'ui__client/domain/dns_disabled__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_disabled__description' => 'Διαχείριση ρυθμίσεων ζώνης DNS για τον τομέα %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Διαχείριση ρυθμίσεων ζώνης DNS για τον τομέα σας.',
    'ui__client/domain/dns_readonly__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly__description' => 'Προβολή ρυθμίσεων ζώνης DNS για τον τομέα %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Προβολή ρυθμίσεων ζώνης DNS για τον τομέα σας.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Προβολή ρυθμίσεων ζώνης DNS για τον τομέα σας.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Προβολή ρυθμίσεων ζώνης DNS για τον τομέα σας.',
    'ui__client/domain/dns_slave__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_slave__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_slave__description' => 'Διαχείριση ρυθμίσεων ζώνης DNS για τον τομέα %1.',
    'ui__client/domain/dns_self-slave__title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Ρυθμίσεις DNS',
    'ui__client/domain/dns_self-slave__description' => 'Διαχείριση ρυθμίσεων ζώνης DNS για τον τομέα σας.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/domain/extras__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/domain/extras__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Εργαλεία από το MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Αποκτήστε πρόσθετα εργαλεία και υπηρεσίες από το MyPlesk.com.',
    'ui__client/domain/odbc__short-title' => 'Αρχεία προέλευσης δεδομένων ODBC', // PFW
    'ui__client/domain/odbc__title' => 'Αρχεία προέλευσης δεδομένων ODBC', // PFW
    'ui__client/domain/odbc__description' => 'Ρύθμιση προελεύσεων δεδομένων ODBC για τον τομέα %1.', // PFW
    'ui__client/domain/odbc_self__short-title' => 'Αρχεία προέλευσης δεδομένων ODBC', // PFW
    'ui__client/domain/odbc_self__title' => 'Αρχεία προέλευσης δεδομένων ODBC', // PFW
    'ui__client/domain/odbc_self__description' => 'Ρύθμιση προελεύσεων δεδομένων ODBC για τον τομέα σας.', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Καταχώρηση τομέα',
    'ui__client/domain/register__title' => 'Καταχώρηση τομέα',
    'ui__client/domain/register__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Καταχώρηση τομέα',
    'ui__client/domain/register_unknown__title' => 'Καταχώρηση τομέα',
    'ui__client/domain/register_unknown__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Καταχώρηση τομέα',
    'ui__client/domain/register_self__title' => 'Καταχώρηση τομέα',
    'ui__client/domain/register_self__description' => 'Καταχώρηση ονόματος τομέα μέσω του MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => 'Προστασία Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => 'Προστασία Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => 'Προστασία των αρχείων στον τομέα %1 από το hotlinking.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => 'Προστασία Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => 'Προστασία Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => 'Προστασία των αρχείων σας από το hotlinking.', // PFW
    'ui__client/domain/hosting/performance__short-title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance__title' => 'Περιορισμός της χρήσης εύρους ζώνης και του αριθμού επιτρεπόμενων συνδέσεων στην τοποθεσία web σας',
    'ui__client/domain/hosting/performance__description' => 'Προβολή και προσαρμογή του ορίου χρήσης εύρους ζώνης για τον τομέα %1 και του αριθμού ταυτόχρονων συνδέσεων σε αυτόν.',
    'ui__client/domain/hosting/performance_readonly__short-title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance_readonly__title' => 'Όρια στη χρήση εύρους ζώνης και τον αριθμό επιτρεπόμενων συνδέσεων στην τοποθεσία web σας',
    'ui__client/domain/hosting/performance_readonly__description' => 'Προβολή του ορίου χρήσης εύρους ζώνης για τον τομέα %1 και του αριθμού ταυτόχρονων συνδέσεων σε αυτόν.',
    'ui__client/domain/hosting/performance_self__short-title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance_self__title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance_self__description' => 'Προβολή και προσαρμογή του ορίου χρήσης εύρους ζώνης για τον τομέα σας και του αριθμού ταυτόχρονων συνδέσεων σε αυτόν.',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance_readonly-self__title' => 'Περιορισμός εύρους ζώνης',
    'ui__client/domain/hosting/performance_readonly-self__description' => 'Προβολή του ορίου χρήσης εύρους ζώνης για τον τομέα σας και του αριθμού ταυτόχρονων συνδέσεων σε αυτόν.',
    'ui__client/domain/hosting/php__short-title' => 'Ρυθμίσεις PHP', // PFW
    'ui__client/domain/hosting/php__title' => 'Ρυθμίσεις PHP', // PFW
    'ui__client/domain/hosting/php__description' => 'Ρύθμιση παραμέτρων PHP στον τομέα %1.', // PFW
    'ui__client/domain/hosting/php_self__short-title' => 'Ρυθμίσεις PHP', // PFW
    'ui__client/domain/hosting/php_self__title' => 'Ρυθμίσεις PHP', // PFW
    'ui__client/domain/hosting/php_self__description' => 'Ρύθμιση παραμέτρων PHP στον τομέα σας.', // PFW

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// CLIENTS
    ///

    // list object operations

    // list object operation errors
    'ui__client/to-reseller__empty_selection' => 'Πρέπει να επιλέξετε τους λογαριασμούς πελατών που θέλετε να μετατρέψετε σε λογαριασμούς μεταπωλητών',
    'ui__client/chowner__empty_selection' => 'Πρέπει να επιλέξετε τους λογαριασμούς πελατών στους οποίους θέλετε να ορίσετε νέο κάτοχο',

    ///
    /// END OF CLIENTS
    ///

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Εργαλεία",
    // Create domain - ui__client/domain/properties_unknown-new__short-title (HOME)
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Προβολή στατιστικών στοιχείων',
    'ui__client/domain-summary-report_unknown__title' => 'Προβολή στατιστικών στοιχείων',
    'ui__client/domain-summary-report_unknown__description' => 'Προβολή πληροφοριών σχετικά με τη χρήση πόρων από τους τομείς.',
    'ui__client/domain-summary-report__short-title' => "Προβολή στατιστικών στοιχείων",
    'ui__client/domain-summary-report__title' => "Προβολή στατιστικών στοιχείων",
    'ui__client/domain-summary-report__description' => "Προβολή πληροφοριών σχετικά με τη χρήση πόρων από τους τομείς.",
    'ui__client/domain-summary-report_self__short-title' => "Προβολή στατιστικών στοιχείων",
    'ui__client/domain-summary-report_self__title' => "Προβολή στατιστικών στοιχείων",
    'ui__client/domain-summary-report_self__description' => "Προβολή των πληροφοριών σχετικά με τη χρήση πόρων από τους τομείς σας.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Τομείς", // DOMAINS

    // list object operations
    'ui__client/domain/check-permissions_multi__short-title' => 'Έλεγχος δικαιωμάτων',
    'ui__client/domain/check-permissions_multi__title' => 'Έλεγχος δικαιωμάτων',
    'ui__client/domain/check-permissions_multi__description' => 'Έλεγχος των δικαιωμάτων πρόσβασης σε αρχεία και φακέλους ενός τομέα. Εάν εντοπιστούν σφάλματα, θα διορθωθούν αυτόματα.',

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Πρέπει να επιλέξετε τους τομείς που θέλετε να καταργηθούν',
    'ui__client/domain/properties__empty_selection' => 'Πρέπει να επιλέξετε τους τομείς που θέλετε να τροποποιήσετε',
    'ui__client/domain/chowner__empty_selection' => 'Πρέπει να επιλέξετε τους τομείς τους οποίους θέλετε να εκχωρήσετε σε νέο κάτοχο',
    'ui__client/domain/check-permissions__empty_selection' => 'Πρέπει να επιλέξετε τους τομείς στους οποίους θέλετε να ελέγξετε τα δικαιώματα πρόσβασης σε αρχεία και φακέλους',
    'ui__client/domain/to-client__empty_selection' => 'Πρέπει να επιλέξετε τους τομείς στους οποίους θέλετε να μετατρέψετε τους λογαριασμούς διαχειριστή σε λογαριασμούς πελατών',

    // list objects filtering
    'domains_list__name__filter_title' => 'Όνομα',
    'domains_list__state__filter_title' => 'Χρήση πόρων',
    'domains_list__filter_state_any' => 'Οποιοδήποτε',
    'domains_list__filter_state_overuse' => 'Υπερβολική χρήση',
    'domains_list__filter_state_normal' => 'Εντός ορίων',
    'domains_list__status__filter_title' => 'Κατάσταση',
    'domains_list__filter_status_any' => 'Οποιοδήποτε',
    'domains_list__filter_status_blocked' => 'Αναστάλθηκε',
    'domains_list__filter_status_active' => 'Ενεργό',
    'domains_list__ownership__filter_title' => 'Κυριότητα',
    'domains_list__filter_ownership_all' => 'Όλοι οι τομείς',
    'domains_list__filter_ownership_personal' => 'Μόνο οι τομείς μου',
    'domains_list__filter_owner_pname__filter_title' => 'Όνομα κατόχου',
    'domains_list__subrows__filter_title' => 'Εμφάνιση',
    'domains_list__subrows_off' => 'Μόνο τομείς',
    'domains_list__subrows_subdomain_domainaliases' => 'Με υποτομείς και ψευδώνυμα',
    'domains_list__subrows_subdomain' => 'Με υποτομείς',
    'domains_list__subrows_domainaliases' => 'Με ψευδώνυμα',

    // objects list
    'domains_list__owner__title' => 'Κάτοχος',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Αναζήτηση για εφαρμογές",
    'site_apps__promo_main_text' => "Ο κατάλογος Application Packaging Standard (APS) περιέχει τη λίστα με τις εφαρμογές που μπορούν να καταστούν διαθέσιμες σε έναν τομέα ή webspace.  Αν θέλετε να παρέχετε εφαρμογές που δεν βρίσκονται στον κατάλογο, μπορείτε να το κάνετε εύκολα ακολουθώντας τις οδηγίες συσκευασίας APS από τη διεύθυνση για www.apsstandard.com",
    'site_apps__promo_download_now' => "Λήψη εφαρμογών:",
    'site_apps__promo_close' => "Κλείσιμο αυτού του πλαισίου",
    'site_apps__promo_preset__mostused' => '%1 δημοφιλέστερες',
    'site_apps__promo_preset__lessused' => 'Επόμενες %1 δημοφιλέστερες',
    'site_apps__promo_preset__all' => "Όλες",
    'site_apps__promo_disclaimer_note' => 'Σημειώστε ότι οι εφαρμογές που εγκαθίστανται από τον κατάλογο APS παρέχονται από τρίτους και δεν υποστηρίζονται από την Plesk.',
    'site_apps__promo_preset__page_title' => '%1 εφαρμογές APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Προσθήκη εφαρμογών...',

    // Errors
    'site_apps__no_applications_for_update' => 'Δεν υπάρχουν εγκατεστημένες εφαρμογές στο Application Vault.',
    'site_apps__incorrect_download_preset_configuration' => 'Εντοπίστηκαν σφάλματα στις προκαθορισμένες ρυθμίσεις λήψης του καταλόγου APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'Το καθορισμένο URL δεν είναι έγκυρο.',
    'site_apps__no_updates_at_the_moment' => 'Δεν υπάρχουν διαθέσιμες ενημερώσεις εφαρμογών αυτήν τη στιγμή.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Ελήφθησαν ανακριβείς πληροφορίες από τον κατάλογο εφαρμογών APS.  Δοκιμάστε ξανά αργότερα.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Οι ρυθμίσεις καταλόγου APS αποθηκεύτηκαν, αλλά το Plesk δεν κατάφερε να συνδεθεί με τον κατάλογο APS που ορίζεται στις ρυθμίσεις καταλόγου APS (%1). Βεβαιωθείτε ότι η διεύθυνση του καταλόγου APS είναι σωστή και ο κατάλογος APS σε αυτήν τη διεύθυνση είναι ενεργός.',
    'site_apps__cannot_retrieve_updates' => 'Δεν είναι δυνατή η λήψη ενημερώσεων εφαρμογών αυτήν τη στιγμή: αδυναμία σύνδεσης με τον κατάλογο APS (%1).  Βεβαιωθείτε ότι η διεύθυνση του καταλόγου APS είναι σωστή και ο κατάλογος APS σε αυτήν τη διεύθυνση είναι ενεργός.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Δεν υπάρχουν διαθέσιμες εφαρμογές web για εγκατάσταση.',
    'site_apps__site_applications_already_installed_in_root' => 'Έχουν εγκατασταθεί ήδη άλλες εφαρμογές web στους ριζικούς καταλόγους αυτών των εικονικών κεντρικών υπολογιστών',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Οι εφαρμογές web .NET δεν υποστηρίζονται σε πλατφόρμες Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Οι εφαρμογές web σε επίπεδο διακομιστή δεν υποστηρίζονται',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 επιπλέον εφαρμογές web έχουν προγραμματιστεί για προσθήκη στο Application Vault.",
    'site_apps__applications_all_in_vault' => "Οι επιλεγμένες εφαρμογές web υπάρχουν ήδη στο Application Vault.",
    'site_apps__applications_already_in_download_queue' => "%1 επιλεγμένες εφαρμογές web προστίθενται στο Application Vault αυτήν τη στιγμή.",
    'site_apps__applications_already_in_valut' => "%1 επιλεγμένες εφαρμογές web είναι ήδη στο Application Vault.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Άλλο (χωρίς κατηγοριοποίηση)',

    // Errors
    'site_apps__no_applications_in_category' => 'Δεν υπάρχουν διαθέσιμες εφαρμογές σε αυτήν την κατηγορία.  Επιλέξτε άλλη κατηγορία.',
    'site_apps__no_category_selected__please_specify' => 'Επιλέξτε μια κατηγορία στο αριστερό μενού.  Όλες οι εφαρμογές που είναι διαθέσιμες στην επιλεγμένη κατηγορία θα πρέπει να παρατίθενται σε αυτό το παράθυρο.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Λογαριασμός διαχειριστή',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Γενικά',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Αλλαγή ονόματος κεντρικού υπολογιστή',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Ασφάλεια',
    'bt_setup_firewall' => 'Ρύθμιση τείχους προστασίας',
    'bt_manage_firewall_rules' => 'Διαχείριση κανόνων τείχους προστασίας',
    'cu_firewall__rule' => 'Δημιουργία κανόνα τείχους προστασίας',
    'cu_firewall__protocol' => 'Καθορίστε ένα πρωτόκολλο για τον κανόνα (\'tcp\' ή \'udp\')',
    'cu_firewall__name' => "Καθορίστε ένα όνομα για τον κανόνα",
    'cu_firewall__disabled' => 'Αν είναι \'true\', ο κανόνας απενεργοποιείται μετά τη δημιουργία',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Επιλογή διακομιστή DNS', // PFW
    'bt_soa_records_template' => 'Πρότυπο εγγραφών SOA',
    'bt_restrict_creation_of_subzones' => 'Περιορισμός δημιουργίας υποζωνών',

    'databases' => 'Βάσεις δεδομένων',
    'bt_select_mssqlwebadmin' => 'Επιλογή MS SQL Webadmin', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Εφαρμογές',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Ηλεκτρονικό ταχυδρομείο',
    'bt_select_mailserver' => 'Επιλογή διακομιστή αλληλογραφίας', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Επιλογή λογισμικού προστασίας από ιούς', // PFW
    'bt_virus_protection_settings' => 'Ρυθμίσεις προστασίας από ιούς',
    'bt_select_spamfilter' => 'Επιλογή φίλτρου ανεπιθύμητης αλληλογραφία', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Επιλογή webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Αρχεία καταγραφής & Στατιστικά στοιχεία',
    'bt_server_statistics_settings' => 'Ρυθμίσεις στατιστικών στοιχείων διακομιστή',
    'bt_select_web_statistics' => 'Διαθέσιμο λογισμικό στατιστικών στοιχείων web', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Περιβάλλον εργασίας Plesk',

    'components_and_modules' => 'Στοιχεία & λειτουργικές μονάδες',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Ρύθμιση επιτήρησης', // PFU
    'bt_setup_vpn' => 'Ρύθμιση VPN', // PFU
    'bt_setup_samba' => 'Ρύθμιση samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Ρυθμίσεις',
    'ui__client/domain/settings_self__short-title' => 'Ρυθμίσεις',
    'ui__client/domain/settings_self__description' => 'Προβολή και αλλαγή ρυθμίσεων τομέα.',

    'domain_administrator_account' => 'Λογαριασμός διαχειριστή τομέα',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Ρυθμίσεις λογαριασμού',

    'domain' => 'τομέας',
    'bt_dns_soa_records' => 'Εγγραφές SOA DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Ρυθμίσεις χρονοδιαγράμματος εργασιών',

    'website' => 'Τοποθεσία web',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Δέσμες ενεργειών για χρήστες web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Επιλογή πιστοποιητικού SSL/TLS',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Στατιστικά στοιχεία web',
    'bt_log_rotation_settings' => 'Ρυθμίσεις ανακύκλωσης αρχείων καταγραφής',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Όρια", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Πολιτική υπερβολικής χρήσης (overuse) και υπερπώλησης (overselling)",
    'limits__overuse_policy_legend' => "Υπερβολική χρήση",
    'limits__oversell_policy_legend' => "Υπερπώληση",
    'limits__reseller_overuse_description' => "Η πολιτική υπερβολικής χρήσης υπαγορεύει στο Plesk τι πρέπει να κάνει όταν πραγματοποιείται υπερβολική χρήση των πόρων.",
    'limits__overuse_text' => "Πολιτική υπερβολικής χρήσης",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Χώρος στο δίσκο και κίνηση',
    'limit__disk_space' => 'χώρος στο δίσκο',
    'limit__max_traffic' => 'Κίνηση',
    'limit_group__client' => 'Πελάτες',
    'limit__max_cl' => 'Πελάτες',
    'limit_group__domain' => 'Τομείς',
    'limit__max_dom' => 'Τομείς',
    'limit__max_dom_powerUser' => 'Συνδρομές',
    'limit__max_subdom' => 'Υποτομείς',
    'limit__max_dom_aliases' => 'Ψευδώνυμα τομέα',
    'limit__max_wu' => 'Χρήστες web',
    'limit__max_subftp_users' => 'Πρόσθετοι λογαριασμοί FTP', // PFW
    'limit_group__mail' => 'Ηλεκτρονικό ταχυδρομείο',
    'limit__max_box' => 'Γραμματοκιβώτια',
    'limit__mbox_quota' => 'Μέγεθος γραμματοκιβωτίου',
    'limit__total_mboxes_quota' => 'Όριο συνόλου γραμματοκιβωτίων', // PFW
    'limit__max_maillists' => 'Λίστες αλληλογραφίας',
    'limit_group__database' => 'Βάσεις δεδομένων',
    'limit__max_mssql_db' => 'Βάσεις δεδομένων Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Συνολικό όριο βάσεων δεδομένων MS SQL', // PFW
    'limit__max_odbc' => 'Συνδέσεις ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Όριο βάσεων δεδομένων MySQL', // PFW?
    'limit_group__application' => 'Εφαρμογές',
    'limit__max_iis_app_pools' => 'Χώροι συγκέντρωσης εφαρμογών IIS', // PFW
    'limit_group__security' => 'Ασφάλεια',
    'limit_group__validity' => 'Ημερομηνία λήξης',
    'limit__expiration' => 'Ημερομηνία λήξης',
    'limit__validity' => 'Περίοδος ισχύος',
    'limit__max_site_builder' => 'Τοποθεσίες που δημοσιεύονται με το Presence Builder',
    'limit__max_site' => 'Τομείς',
    'limit__mssql_dbase_filesize' => 'Μέγεθος αρχείου βάσης δεδομένων MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Μέγεθος αρχείου καταγραφής βάσης δεδομένων MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Το μέγιστο μέγεθος ενός αρχείου βάσης δεδομένων Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'Το μέγιστο μέγεθος ενός αρχείου καταγραφής βάσης δεδομένων Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Μη έγκυρο όριο τομέων.  Η ελάχιστη τιμή είναι 1.',

    'property__has_wrong_value' => 'Η ιδιότητα %1 έχει λανθασμένη τιμή.',
    'property__name_outgoing_messages_domain_limit' => 'Καθορίζει το όριο για τα εξερχόμενα μηνύματα από έναν τομέα (ανά ώρα). Για να ορίσετε την Απεριόριστη τιμή, επιλέξτε "-1". Ορίστε την "προεπιλογή" για να ορίσετε την τιμή που καθορίζεται στις ρυθμίσεις σε επίπεδο διακομιστή.',
    'property__name_outgoing_messages_mbox_limit' => 'Καθορίζει το όριο για τα εξερχόμενα μηνύματα από ένα γραμματοκιβώτιο (ανά ώρα). Για να ορίσετε την Απεριόριστη τιμή, επιλέξτε "-1". Ορίστε την "προεπιλογή" για να ορίσετε την τιμή που καθορίζεται στις ρυθμίσεις σε επίπεδο διακομιστή.',
    'property__name_outgoing_messages_subscription_limit' => 'Καθορίζει το όριο για τα εξερχόμενα μηνύματα από μια συνδρομή (ανά ώρα). Για να ορίσετε την Απεριόριστη τιμή, επιλέξτε "-1". Ορίστε την "προεπιλογή" για να ορίσετε την τιμή που καθορίζεται στις ρυθμίσεις σε επίπεδο διακομιστή.',

    // for CLI report & email notifications
    '__resource_notify' => 'Ειδοποίηση',
    '__general' => 'Γενικά',
    '__template_shared' => 'Κοινόχρηστο πρότυπο',
    'limit__overuse' => 'Πολιτική υπερβολικής χρήσης',
    'limit__max_traffic_soft' => 'Ειδοποίηση όταν η χρήση της κίνησης φτάνει',
    'limit__disk_space_soft' => 'Ειδοποίηση όταν η χρήση του χώρου στο δίσκο φτάνει σε',
    '__overuse' => 'Πολιτική υπερβολικής χρήσης',
    'performance__title' => 'Απόδοση',
    'performance__bandwidth' => 'Μέγιστη χρήση εύρους ζώνης (KB/δευτ.)',
    'performance__max_connections' => 'Συνδέσεις περιορισμένες σε',

    'gch__hosting_php_isapi' => 'Εκτελέστε PHP ως επέκταση ISAPI',
    'gch__hosting_ssi_html' => 'Χρησιμοποιήστε το SSI για αρχεία *.htm, *.html',
    'gch__hosting_php_handler_type' => 'Εκτέλεση PHP ως',
    'gch__hosting_php_handler_id' => 'Εκτέλεση PHP ως',
    'gch__hosting_php_served_by_nginx' => 'PHP εξυπηρετείται από nginx',
    'gch__hosting_unpaid_website_status' => 'Κατάσταση τοποθεσιών web σε συνδρομές που έχουν ανασταλεί',
    'gch__mn_no_autoresponder' => 'Δεν έχουν ρυθμιστεί αυτόματες απαντήσεις για το λογαριασμό αλληλογραφίας.',
    'gch__no_clients_selected' => "Δεν έχουν επιλεγεί λογαριασμοί πελατών",
    'gch__no_domains_selected' => "Δεν έχουν επιλεγεί τομείς",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/μήνα",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Όνομα πόρου',
    '__resource_usage' => 'Χρησιμοποιούνται',
    '__resource_limit' => 'Όριο',

    '__used' => 'Χρησιμοποιούνται',
    '__limit' => 'Όριο',

    '__never_expires' => 'Χωρίς λήξη',
    '__resource_free' => '%1 διαθέσιμα από %2',
    '__resource_unlimited' => '%1 χρησιμοποιούνται από Απεριόριστα',

    '__value' => 'Τιμή',
    '__unlimited' => 'Απεριόριστο',
    '__increment' => "Αύξηση (+)",
    '__decrement' => "Μείωση (-)",
    '__pt' => 'μονάδες',
    '__procent' => '%',
    '__overused' => 'Υπερβολική χρήση',
    '__left' => 'αριστερά',
    '__available' => 'διαθέσιμο',
    '__not_available' => 'Δεν περιλαμβάνεται',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'Προβολή ιστορικού κίνησης',
    'ui__admin/report/traffic-history__title' => 'Προβολή ιστορικού κίνησης',
    'ui__admin/report/traffic-history__description' => 'Προβολή ιστορικού κίνησης για τους μεταπωλητές, τους πελάτες και τους τομείς.',
    'admin_traffic_history__title' => 'Ιστορικό κίνησης',

    'ui__admin/report/layout/auto_unknown__short-title' => 'Χρονοδιάγραμμα παράδοσης',
    'ui__admin/report/layout/auto_unknown__title' => 'Χρονοδιάγραμμα παράδοσης αναφοράς',
    'ui__admin/report/layout/auto_unknown__description' => 'Επιλέξτε χρονοδιάγραμμα παράδοσης αναφοράς για μια διάταξη αναφοράς.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Προσθήκη χρονοδιαγράμματος παράδοσης αναφοράς',
    'ui__admin/report/layout/auto/properties_new__title' => 'Προσθήκη χρονοδιαγράμματος παράδοσης αναφοράς',
    'ui__admin/report/layout/auto/properties_new__description' => 'Προσθήκη χρονοδιαγράμματος παράδοσης για την αναφορά %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Χρονοδιάγραμμα παράδοσης αναφοράς',
    'ui__admin/report/layout/auto/properties__title' => 'Χρονοδιάγραμμα παράδοσης αναφοράς',
    'ui__admin/report/layout/auto/properties__description' => 'Προβολή και τροποποίηση ιδιοτήτων χρονοδιαγράμματος παράδοσης αναφοράς.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Κατάργηση χρονοδιαγράμματος παράδοσης αναφοράς',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Κατάργηση χρονοδιαγράμματος παράδοσης αναφοράς',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Κατάργηση επιλεγμένων χρονοδιαγραμμάτων παράδοσης αναφορών.',

    'ui__admin/report/layout_unknown__short-title' => 'Διατάξεις αναφοράς',
    'ui__admin/report/layout_unknown__title' => 'Διατάξεις αναφοράς',
    'ui__admin/report/layout_unknown__description' => 'Προβολή και διαχείριση διατάξεων αναφοράς.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'Δημιουργία διάταξης αναφοράς',
    'ui__admin/report/layout/properties_unknown-new__title' => 'Δημιουργία διάταξης αναφοράς',
    'ui__admin/report/layout/properties_unknown-new__description' => 'Δημιουργία διάταξης αναφοράς.',
    'ui__admin/report/layout/delete_multi__short-title' => 'Κατάργηση διατάξεων αναφοράς',
    'ui__admin/report/layout/delete_multi__title' => 'Κατάργηση διατάξεων αναφοράς',
    'ui__admin/report/layout/delete_multi__description' => 'Κατάργηση των επιλεγμένων διατάξεων αναφοράς',
    'ui__admin/report/layout/properties__short-title' => 'Ιδιότητες',
    'ui__admin/report/layout/properties__title' => 'Ιδιότητες διάταξης αναφοράς',
    'ui__admin/report/layout/properties__description' => 'Επεξεργασία ιδιοτήτων διάταξης αναφοράς.',

    // reseller
    'reseller_traffic_history__title' => "Ιστορικό κίνησης μεταπωλητή %1",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Προβολή χρήσης κίνησης για το μεταπωλητή %1',
    'ui__reseller/traffic__description' => 'Προβολή αναφορών χρήσης κίνησης για το λογαριασμό μεταπωλητή %1.',
    'ui__reseller/traffic_self__short-title' => 'Τα δικά μου',
    'ui__reseller/traffic_self__title' => 'Προβολή χρήσης κίνησης από τους πελάτες',
    'ui__reseller/traffic_self__description' => 'Προβολή αναφορών χρήσης κίνησης για τους λογαριασμούς πελατών σας.',

    'ui__reseller/report/traffic-history__short-title' => 'Προβολή ιστορικού κίνησης',
    'ui__reseller/report/traffic-history__title' => 'Προβολή ιστορικού κίνησης',
    'ui__reseller/report/traffic-history__description' => "Προβολή του ιστορικού κίνησης για το μεταπωλητή %1.",
    'ui__reseller/report/traffic-history_self__short-title' => 'Προβολή ιστορικού κίνησης',
    'ui__reseller/report/traffic-history_self__title' => 'Προβολή ιστορικού κίνησης',
    'ui__reseller/report/traffic-history_self__description' => 'Προβολή του ιστορικού κίνησής σας.',

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Χρονοδιάγραμμα παράδοσης',
    'ui__reseller/report/layout/auto_unknown__title' => 'Χρονοδιάγραμμα παράδοσης αναφοράς',
    'ui__reseller/report/layout/auto_unknown__description' => 'Επιλέξτε χρονοδιάγραμμα παράδοσης αναφοράς για μια διάταξη αναφοράς.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Προσθήκη χρονοδιαγράμματος παράδοσης αναφοράς',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Προσθήκη χρονοδιαγράμματος παράδοσης αναφοράς',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Προσθήκη χρονοδιαγράμματος παράδοσης για την αναφορά %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Χρονοδιάγραμμα παράδοσης αναφοράς',
    'ui__reseller/report/layout/auto/properties__title' => 'Χρονοδιάγραμμα παράδοσης αναφοράς',
    'ui__reseller/report/layout/auto/properties__description' => 'Προβολή και τροποποίηση ιδιοτήτων χρονοδιαγράμματος παράδοσης αναφοράς.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Κατάργηση χρονοδιαγράμματος παράδοσης αναφοράς',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Κατάργηση χρονοδιαγράμματος παράδοσης αναφοράς',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Κατάργηση επιλεγμένων χρονοδιαγραμμάτων παράδοσης αναφορών.',

    'ui__reseller/report/layout_unknown__short-title' => 'Διατάξεις αναφοράς',
    'ui__reseller/report/layout_unknown__title' => 'Διατάξεις αναφοράς',
    'ui__reseller/report/layout_unknown__description' => 'Προβολή και διαχείριση διατάξεων αναφοράς.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'Δημιουργία διάταξης αναφοράς',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'Δημιουργία διάταξης αναφοράς',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'Δημιουργία διάταξης αναφοράς.',
    'ui__reseller/report/layout/properties_new__short-title' => 'Δημιουργία διάταξης αναφοράς',
    'ui__reseller/report/layout/properties_new__title' => 'Δημιουργία διάταξης αναφοράς',
    'ui__reseller/report/layout/properties_new__description' => 'Δημιουργία διάταξης αναφοράς.',
    'ui__reseller/report/layout/delete_multi__short-title' => 'Κατάργηση διατάξεων αναφοράς',
    'ui__reseller/report/layout/delete_multi__title' => 'Κατάργηση διατάξεων αναφοράς',
    'ui__reseller/report/layout/delete_multi__description' => 'Κατάργηση των επιλεγμένων διατάξεων αναφοράς',
    'ui__reseller/report/layout/properties__short-title' => 'Ιδιότητες',
    'ui__reseller/report/layout/properties__title' => 'Ιδιότητες διάταξης αναφοράς',
    'ui__reseller/report/layout/properties__description' => 'Επεξεργασία ιδιοτήτων διάταξης αναφοράς.',

    // customer
    'cl_traffic_history__title' => "Ιστορικό κίνησης πελάτη %1",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Προβολή χρήσης κίνησης για τον πελάτη %1',
    'ui__client/traffic__description' => 'Προβολή αναφορών χρήσης κίνησης για το λογαριασμό πελάτη %1.',
    'ui__client/traffic_self__short-title' => 'Χρήση κίνησης',
    'ui__client/traffic_self__title' => 'Χρήση κίνησης από τους τομείς',
    'ui__client/traffic_self__description' => 'Προβολή αναφορών χρήσης κίνησης για τους τομείς σας.',

    'ui__client/report/traffic-history__short-title' => 'Προβολή ιστορικού κίνησης',
    'ui__client/report/traffic-history__title' => 'Προβολή ιστορικού κίνησης',
    'ui__client/report/traffic-history__description' => 'Προβολή του ιστορικού κίνησης για τον πελάτη %1.',
    'ui__client/report/traffic-history_self__short-title' => 'Προβολή ιστορικού κίνησης',
    'ui__client/report/traffic-history_self__title' => 'Προβολή ιστορικού κίνησης',
    'ui__client/report/traffic-history_self__description' => 'Προβολή του ιστορικού κίνησής σας.',



    // domain
    'dom_traffic_history__title' => "Ιστορικό κίνησης τομέα %1",

    'ui__client/domain/report/traffic-history__short-title' => 'Προβολή ιστορικού κίνησης',
    'ui__client/domain/report/traffic-history__title' =>  'Προβολή ιστορικού κίνησης',
    'ui__client/domain/report/traffic-history__description' => 'Προβολή του ιστορικού κίνησης για τον τομέα %1.',
    'ui__client/domain/report/traffic-history_self__short-title' => 'Προβολή ιστορικού κίνησης',
    'ui__client/domain/report/traffic-history_self__title' =>  'Προβολή ιστορικού κίνησης',
    'ui__client/domain/report/traffic-history_self__description' => 'Προβολή του ιστορικού κίνησης για τον τομέα σας.',



    // Web Statistics - ui__client/domain/report/web-stats__short-title (HOME)
    'ui__client/domain/report/web-stats-ssl__short-title' => 'Στατιστικά στοιχεία για τις ασφαλείς επισκέψεις στην τοποθεσία',
    'ui__client/domain/report/web-stats-ssl__title' => 'Στατιστικά στοιχεία για τις ασφαλείς επισκέψεις στην τοποθεσία %1',
    'ui__client/domain/report/web-stats-ssl__description' => 'Στατιστικά στοιχεία για τις ασφαλείς επισκέψεις στην τοποθεσία %1.',
    'ui__client/domain/report/web-stats-ssl_self__short-title' => 'Στατιστικά web SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_self__title' => 'Στατιστικά στοιχεία για τις ασφαλείς επισκέψεις στην τοποθεσία σας',
    'ui__client/domain/report/web-stats-ssl_self__description' => 'Στατιστικά στοιχεία για τις ασφαλείς επισκέψεις στην τοποθεσία σας.',
    'ui__client/domain/report/ftp-stats__short-title' => 'Στατιστικά στοιχεία FTP',
    'ui__client/domain/report/ftp-stats__title' => 'Στατιστικά στοιχεία FTP για τον τομέα %1',
    'ui__client/domain/report/ftp-stats__description' => 'Στατιστικά στοιχεία FTP για τον τομέα %1',
    'ui__client/domain/report/ftp-stats_self__short-title' => 'Στατιστικά στοιχεία FTP',
    'ui__client/domain/report/ftp-stats_self__title' => 'Στατιστικά στοιχεία FTP για τον τομέα σας',
    'ui__client/domain/report/ftp-stats_self__description' => 'Στατιστικά στοιχεία FTP για τον τομέα σας.',
    'ui__client/domain/report/anon-ftp-stats__short-title' => 'Στατιστικά στοιχεία ανώνυμου FTP',
    'ui__client/domain/report/anon-ftp-stats__title' => 'Στατιστικά στοιχεία ανώνυμου FTP για τον τομέα %1',
    'ui__client/domain/report/anon-ftp-stats__description' => 'Στατιστικά στοιχεία ανώνυμου FTP για τον τομέα %1',
    'ui__client/domain/report/anon-ftp-stats_self__short-title' => 'Στατιστικά στοιχεία ανώνυμου FTP',
    'ui__client/domain/report/anon-ftp-stats_self__title' => 'Στατιστικά στοιχεία ανώνυμου FTP για τον τομέα %1',
    'ui__client/domain/report/anon-ftp-stats_self__description' => 'Στατιστικά στοιχεία ανώνυμου FTP για τον τομέα %1',

    'ui__client/domain/report/webalizer-preferences__short-title' => 'Ρυθμίσεις Webalizer',
    'ui__client/domain/report/webalizer-preferences__title' => 'Ρυθμίσεις Webalizer για το %1',
    'ui__client/domain/report/webalizer-preferences__description' => 'Προσαρμογή της παρουσίασης των αναφορών στατιστικών στοιχείων του Webalizer για το %1.',
    'ui__client/domain/report/webalizer-preferences_self__short-title' => 'Ρυθμίσεις Webalizer',
    'ui__client/domain/report/webalizer-preferences_self__title' => 'Ρυθμίσεις Webalizer για το %1',
    'ui__client/domain/report/webalizer-preferences_self__description' => 'Προσαρμογή της παρουσίασης των αναφορών στατιστικών στοιχείων του Webalizer για το %1.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'Π',
    'report__full_s' => 'Κ',
    'report__full_h' => 'Φ',
    'report__full_reseller_name' => 'Όνομα μεταπωλητή', // reseller report
    'report__full_client_name' => 'Όνομα πελάτη', // customer report
    'report__full_domain_name' => 'Όνομα τομέα', // domain report
    'report__full_owner' => 'Κάτοχος', // customer & domain reports
    'report__full_creation_date' => 'Ημερομηνία δημιουργίας',
    'report__full_size' => 'Μέγεθος',
    'report__full_traffic' => 'Κίνηση',
    'report__full_active_clients' => 'Ενεργοί πελάτες', // reseller report
    'report__full_clients' => 'Πελάτες', // reseller report
    'report__full_active_domains' => 'Ενεργοί τομείς', // reseller & customer reports
    'report__full_domains' => 'Τομείς', // reseller & customer reports
    'report__full_subdomains' => 'Υποτομείς',
    'report__full_mboxes' => 'MBoxes',
    'report__full_disk_space' => 'χώρος στο δίσκο',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => 'Γενικά',
    'report__version' => 'Έκδοση προϊόντος',
    'report__build' => 'Έκδοση προϊόντος',
    'report__status' => 'Κατάσταση',
    'report__company_name' => 'Όνομα εταιρείας',
    'report__personal_name' => 'Προσωπικό όνομα',
    'report__login' => 'Όνομα χρήστη',
    'report__phone' => 'Τηλέφωνο',
    'report__fax' => 'Φαξ',
    'report__email' => 'Διεύθυνση ηλ. ταχ.',
    'report__address' => 'Διεύθυνση',
    'report__city' => 'Πόλη',
    'report__state' => 'Νομός/Επαρχία',
    'report__zip_code' => 'Ταχυδρομικός κώδικας',
    'report__country' => 'Χώρα',
    'report__creation_date' => 'Ημερομηνία δημιουργίας',
    'report__expiration_date' => 'Ημερομηνία λήξης',
    'report__dumps_total_size' => 'Συνολικό μέγεθος αρχείων αντιγράφων ασφαλείας',
    'report__section_resellers' => 'Μεταπωλητές',
    'report__active_resellers' => 'Μεταπωλητές με ενεργές συνδρομές',
    'report__resellers' => 'Μεταπωλητές',
    'report__section_full_resellers' => 'Μεταπωλητές',
    'report__section_clients' => 'Πελάτες',
    'report__active_clients' => 'Πελάτες με ενεργές συνδρομές',
    'report__clients' => 'Πελάτες',
    'report__section_full_clients' => 'Πελάτες',
    'report__section_personal_clients' => 'Δικοί σας πελάτες',
    'report__active_personal_clients' => 'Οι πελάτες σας με ενεργές συνδρομές',
    'report__personal_clients' => 'Δικοί σας πελάτες',
    'report__section_full_personal_clients' => 'Δικοί σας πελάτες',
    'report__section_domains' => 'Τομείς',
    'report__disk_usage' => 'Χρήση δίσκου',
    'report__traffic' => 'Κίνηση',
    'report__active_domains' => 'Ενεργοί τομείς',
    'report__domains' => 'Τομείς',
    'report__subdomains' => 'Υποτομείς',
    'report__mboxes' => 'Γραμματοκιβώτια',
    'report__mail_groups' => 'Προωθήσεις αλληλογραφίας',
    'report__mail_autoresp' => 'Αυτόματες απαντήσεις',
    'report__mail_lists' => 'Λίστες αλληλογραφίας',
    'report__web_users' => 'Χρήστες web',
    'report__mysql_databases' => 'Βάσεις δεδομένων MySQL',
    'report__mssql_databases' => 'Βάσεις δεδομένων MSSQL',
    'report__section_full_domains' => 'Τομείς',
    'report__section_personal_domains' => 'Προσωπικοί τομείς',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Προσωπικοί τομείς',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Τοποθεσίες που δημοσιεύονται με το Presence Builder',
    'report__invalid_email' => 'Καθορίστε μια έγκυρη διεύθυνση ηλεκτρονικού ταχυδρομείου.',


    // CLI-specific sections
    'report__section_hosting' => 'Φιλοξενία',
    'report__section_webusers' => 'Χρήστες web',
    'report__section_mailnames' => 'Λογαριασμοί αλληλογραφίας',
    'report__section_maillists' => 'Λίστες αλληλογραφίας',
    'report__section_databases' => 'Βάσεις δεδομένων',
    'report__section_siteapps' => 'Εφαρμογές web',
    'report__section_aspnetapps' => 'Εφαρμογές ASP.NET', // PFW
    'report__owner_pname' => "Προσωπικό όνομα παρόχου",
    'report__owner_login' => "Όνομα χρήστη παρόχου",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Το καθορισμένο πακέτο γλώσσας έχει εγκατασταθεί, αλλά δεν έχει ενεργοποιηθεί στο σύστημα.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__sessions/delete__title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__sessions/delete__description' => 'Διαγραφή επιλεγμένων περιόδων λειτουργίας.',
    'ui__ftp-sessions__short-title' => 'Περίοδοι λειτουργίας FTP',
    'ui__ftp-sessions__title' => 'Περίοδοι λειτουργίας FTP',
    'ui__ftp-sessions__description' => 'Προβολή περιόδων λειτουργίας FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Διαγραφή περιόδων λειτουργίας FTP',
    'ui__ftp-sessions/delete__title' => 'Διαγραφή περιόδων λειτουργίας FTP',
    'ui__ftp-sessions/delete__description' => 'Διαγραφή επιλεγμένων περιόδων λειτουργίας FTP.',
    'ui__ts-sessions__short-title' => 'Περίοδοι λειτουργίας TS',
    'ui__ts-sessions__title' => 'Περίοδοι λειτουργίας TS',
    'ui__ts-sessions__description' => 'Προβολή περιόδων λειτουργίας υπηρεσιών τερματικού.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__reseller/sessions/delete__title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__reseller/sessions/delete__description' => 'Διαγραφή επιλεγμένων περιόδων λειτουργίας.',
    'ui__reseller/sessions/delete_self__short-title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__reseller/sessions/delete_self__title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__reseller/sessions/delete_self__description' => 'Διαγραφή επιλεγμένων περιόδων λειτουργίας.',
    'ui__reseller/ftp-sessions__short-title' => 'Περίοδοι λειτουργίας FTP',
    'ui__reseller/ftp-sessions__title' => 'Περίοδοι λειτουργίας FTP',
    'ui__reseller/ftp-sessions__description' => 'Προβολή περιόδων λειτουργίας FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Περίοδοι λειτουργίας FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Περίοδοι λειτουργίας FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Προβολή περιόδων λειτουργίας FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Διαγραφή περιόδων λειτουργίας FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Διαγραφή περιόδων λειτουργίας FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Διαγραφή επιλεγμένων περιόδων λειτουργίας FTP.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Διαγραφή περιόδων λειτουργίας FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Διαγραφή περιόδων λειτουργίας FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Διαγραφή επιλεγμένων περιόδων λειτουργίας FTP.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__client/sessions/delete__title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__client/sessions/delete__description' => 'Διαγραφή επιλεγμένων περιόδων λειτουργίας.',
    'ui__client/sessions/delete_self__short-title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__client/sessions/delete_self__title' => 'Διαγραφή περιόδων λειτουργίας',
    'ui__client/sessions/delete_self__description' => 'Διαγραφή επιλεγμένων περιόδων λειτουργίας.',

    // domain administrator

    'forgery_token_expired' => 'Το διακριτικό περιόδου λειτουργίας έχει λήξει.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Οι παρακάτω λογαριασμοί μεταπωλητών θα μετατραπούν σε λογαριασμούς πελατών',
    'downgradeResellers__downgrade' => 'Λογαριασμοί μεταπωλητών που θα μετατραπούν',
    // controls
    'downgradeResellers__submit_downgrade' => 'Εκτέλεση μετατροπής λογαριασμού.',
    'downgradeResellers__cancel_downgrade' => 'Ακύρωση μετατροπής λογαριασμού.',
    'downgradeResellers__confirm' => 'Επιβεβαίωση μετατροπής',
    'downgradeResellers__confirm_message' => 'Επιβεβαιώστε τη μετατροπή του λογαριασμού για να προχωρήσετε',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Επιλογή λογαριασμών πελατών',
    'upgradeClients__upgrade_clients' => 'Οι παρακάτω λογαριασμοί πελατών θα μετατραπούν σε λογαριασμούς μεταπωλητών',
    'upgradeClients__upgrade' => 'Λογαριασμοί μεταπωλητών που θα μετατραπούν',
    // controls
    'upgradeClients__submit_upgrade' => 'Εκτέλεση μετατροπής λογαριασμού.',
    'upgradeClients__cancel_upgrade' => 'Ακύρωση μετατροπής λογαριασμού.',
    'upgradeClients__confirm' => 'Επιβεβαίωση μετατροπής',
    'upgradeClients__confirm_message' => 'Επιβεβαιώστε τη μετατροπή του λογαριασμού για να προχωρήσετε',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Δεν είναι δυνατή η μετατροπή του λογαριασμού \'%1\' σε λογαριασμό μεταπωλητή: ο \'%1\' είναι ήδη μεταπωλητής.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Οι παρακάτω λογαριασμοί διαχειριστή τομέα θα μετατραπούν σε λογαριασμούς πελατών',
    'upgradeDomainUser__upgrade' => 'Λογαριασμοί διαχειριστή τομέα που θα μετατραπούν',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Εκτέλεση μετατροπής λογαριασμού.',
    'upgradeDomainUser__cancel_upgrade' => 'Ακύρωση μετατροπής λογαριασμού.',
    'upgradeDomainUser__confirm' => 'Επιβεβαίωση μετατροπής',
    'upgradeDomainUser__confirm_message' => 'Επιβεβαιώστε τη μετατροπή του λογαριασμού για να προχωρήσετε',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Λογαριασμοί διαχειριστή τομέα που δεν μπορούν να μετατραπούν',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Οι παρακάτω λογαριασμοί διαχειριστή τομέα δεν μπορούν να μετατραπούν σε λογαριασμούς πελατών:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Αρκετοί λογαριασμοί διαχειριστή τομέα δεν μπορούν να μετατραπούν σε λογαριασμούς πελατών.  %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Ο λογαριασμός διαχειριστή τομέα δεν υπάρχει',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Ο τομέας πρέπει να ανήκει απευθείας στο διαχειριστή του διακομιστή ή σε έναν μεταπωλητή.",
    'upgradeDomainUser__all_logins_already_used' => 'Δεν είναι δυνατή η δημιουργία λογαριασμού για τον πελάτη που προκύπτει.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Ο λογαριασμός διαχειριστή τομέα μετατράπηκε',
    'upgradeDomainUser__upgrade_notification_body' => 'Ο λογαριασμός διαχειριστή τομέα σας μετατράπηκε σε λογαριασμό πελάτη με όνομα χρήστη \'%%login%%\' και κωδικό πρόσβασης \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // wizard title
    'ui__client/chowner_unknown__wizard-title' => 'Ορισμός νέου κατόχου για το λογαριασμό του πελάτη %1', // customer home
    'ui__client/chowner_multi__wizard-title' => 'Ορισμός νέου κατόχου για επιλεγμένους λογαριασμούς πελατών', // list of customers
    'ui__reseller/client/chowner_multi__wizard-title' => 'Ορισμός νέου κατόχου για επιλεγμένους λογαριασμούς χρηστών', // reseller & admin home
    // customers selection - reseller & admin home
    'picker_client__title' => 'Επιλογή λογαριασμών πελατών',
    'ui__reseller/client/chowner_multi__wizard__2_multi' => 'Επιλέξτε τους λογαριασμούς πελατών που θέλετε να μεταβιβάσετε σε άλλον κάτοχο.',
    //  owner selection
    'client_chown__select_title' => 'Επιλογή νέου κατόχου για λογαριασμό πελάτη',
    'client_chown__select-multi_title' => 'Επιλογή νέου κατόχου για λογαριασμούς πελατών',
    'ui__reseller/client/chowner_multi__wizard__2_multi-select' => "Επιλογή νέου κατόχου για επιλεγμένους λογαριασμούς πελατών.", // customer home
    'ui__client/chowner_multi__wizard__2_multi-select' => 'Επιλογή νέου κατόχου για επιλεγμένους λογαριασμούς πελατών.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi-select' => 'Επιλογή νέου κατόχου για επιλεγμένους λογαριασμούς πελατών.', // reseller & admin home
    // changes check page
    'client_chown__check_title' => 'Έλεγχος αλλαγών και ολοκλήρωση οδηγού',
    'ui__client/chowner__wizard__2' => 'Ελέγξτε τις αλλαγές και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.', // customer home
    'ui__client/chowner_multi__wizard__2_multi' => 'Ελέγξτε τις αλλαγές και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi' => 'Ελέγξτε τις αλλαγές και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.', // admin "accounts" dropdown:
    // errors
    'client_chown__empty_selection' => 'Θα πρέπει να επιλέξετε νέο κάτοχο των επιλεγμένων λογαριασμών πελατών',
    'clientOwnerChanger__unable_to_transfer_some_clients' => 'Ένας ή περισσότεροι από τους επιλεγμένους λογαριασμούς χρήστη δεν μπορούν να μεταφερθούν στον νέο κάτοχο.',
    'client_chown__client_warn' => 'Περιγραφή',

    'clientOwnerChanger__owner_has_no_permission' => 'Ο επιλεγμένος μεταπωλητής δεν διαθέτει το δικαίωμα \'%1\', αλλά ορισμένοι από τους πελάτες έχουν αυτό το δικαίωμα.',
    'clientOwnerChanger__application_not_allowed' => 'Η εφαρμογή \'%1\' δεν είναι διαθέσιμη για τον επιλεγμένο μεταπωλητή, αλλά είναι διαθέσιμη για ορισμένους από τους πελάτες.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Εκ νέου εκχώρηση επιλεγμένων συνδρομών',
    // errors
    'domain_chown__empty_selection' => 'Πρέπει να επιλέξετε νέο κάτοχο για τους επιλεγμένους τομείς',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => 'Απόδοση',
    'hosting_performance__traffic_bandwidth_legend' => 'Ενεργοποίηση περιορισμού εύρους ζώνης',
    'hosting_performance__traffic_bandwidth_legend_ro' => 'Περιορισμός εύρους ζώνης',
    'hosting_performance__traffic_bandwidth_label' => 'Μέγιστη χρήση εύρους ζώνης (%1)',
    'hosting_performance__traffic_bandwidth_hint' => 'Το όριο χρήσης εύρους ζώνης ισχύει μόνο για δεδομένα που μεταφέρονται μέσω πρωτοκόλλου HTTP.',
    'hosting_performance__max_connection_legend' => 'Ενεργοποίηση περιορισμού συνδέσεων',
    'hosting_performance__max_connection_legend_ro' => 'Περιορισμός συνδέσεων',
    'hosting_performance__max_connection_label' => 'Συνδέσεις περιορισμένες σε',
    'hosting_performance__max_connection_hint' => 'Αν περιορίσετε τη χρήση του εύρους ζώνης, τότε σας συνιστούμε να περιορίσετε επίσης και τον αριθμό των ταυτόχρονων συνδέσεων στην τοποθεσία.  Διαφορετικά, σε περίπτωση συχνών αιτημάτων προς την τοποθεσία, οι διεργασίες διακομιστή web θα αυξήσουν το φόρτο εργασίας του διακομιστή.',

    // errors:
    'performance__qos_not_installed' => 'Η λειτουργία απενεργοποιήθηκε επειδή δεν υπάρχει εγκατεστημένο QoS',
    'performance__bandwidth_throttling' => 'Δεν μπορείτε να ελέγξετε τον περιορισμό εύρους ζώνης επειδή δεν υπάρχει εγκατεστημένο QoS.',
    'performance__invalid_value' => "Η τιμή δεν είναι έγκυρη.  Πρέπει να κυμαίνεται από %1 έως %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Διαθέσιμοι πελάτες webmail',
    'webmail__none' => 'Καμία',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Χώρος IP διακομιστή',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Δεν θα πραγματοποιηθεί επαναφορά της βάσης δεδομένων: δεν υπάρχει κατάλληλος διακομιστής βάσεων δεδομένων',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Δημιουργία αντιγράφου ασφαλείας διακομιστή.",
    '__default_backup_comment_reseller' => "Δημιουργήθηκε αντίγραφο ασφαλείας του λογαριασμού μεταπωλητή από τον %1.",
    '__default_backup_comment_client' => "Δημιουργήθηκε αντίγραφο ασφαλείας του λογαριασμού πελάτη από τον %1.",
    '__default_backup_comment_domain' => "Δημιουργήθηκε αντίγραφο ασφαλείας της συνδρομής από τον %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'Ορισμός αντιστοίχισης διευθύνσεων IP',
    'backup__ip_mapping__download' => 'Αποθήκευση τρέχουσας αντιστοίχισης IP στο αρχείο',
    'b_backup__ip_mapping__download' => 'Κάντε κλικ για λήψη της ρύθμισης παραμέτρων αντιστοίχισης IP.',
    'b_backup__ip_mapping__download_is_empty' => 'Η ρύθμιση παραμέτρων αντιστοίχισης IP είναι κενή.',
    'backup__ip_mapping_upload__title' => 'Αποστολή αρχείου αντιστοίχισης IP',
    'backup__ip_mapping__upload' => 'Αποστολή αρχείου αντιστοίχισης IP',
    'b_backup__ip_mapping__upload' => 'Κάντε κλικ για αποστολή της ρύθμισης παραμέτρων αντιστοίχισης IP.',
    'backup__ip_mapping__list__header' => 'Αντιστοίχιση IP',
    'backup__ip_mapping__list__adddress' => 'Προηγούμενες διευθύνσεις IP',
    'backup__ip_mapping__list__select_ip' => 'Νέες διευθύνσεις IP',
    'backup__ip_mapping__clients_ip' => "Χώρος IP του πελάτη %1",
    'backup__ip_mapping__resellers_ip' => "Χώρος IP του μεταπωλητή %1",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Οι αποκλειστικές διευθύνσεις IP πρέπει να αντιστοιχιστούν με μοναδικές διευθύνσεις IP.  Επιλέξτε μια μοναδική διεύθυνση IP για κάθε αποκλειστική διεύθυνση IP από τη λίστα.',
    'backup__ip_mapping__legend' => 'Αντιστοίχιση IP',
    'backup__ip_mapping__upload_legend' => 'Αποστολή',
    'backup__ip_mapping__upload_file_text' => 'Αρχείο αντιστοίχισης IP',
    'backup__ip_mapping__upload_file_hint' => 'Το αρχείο αντιστοίχισης IP είναι ένα απλό αρχείο κειμένου.  Κάθε γραμμή του αρχείου περιέχει την αντιστοίχιση IP με την εξής μορφή: <προηγούμενη διεύθυνση IP> <νέα διεύθυνση IP>',
    'backup__ip_mapping__ip_address_not_found' => 'Δεν υπάρχουν διαθέσιμες δωρεάν διευθύνσεις IP αυτού του τύπου.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'Δεν είναι δυνατή η πραγματοποίηση της μεταφοράς δεδομένων: Η αντιστοίχιση των διευθύνσεων IP δεν έχει ολοκληρωθεί επειδή δεν υπάρχουν ελεύθερες διευθύνσεις IP στο χώρο του διακομιστή προορισμού.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Οι μη ασφαλείς συνδέσεις FTP θα απαγορεύονται για τους τομείς με αυτήν τη διεύθυνση IP.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Οι ασφαλείς συνδέσεις FTPS θα απαγορεύονται για τους τομείς με αυτήν τη διεύθυνση IP.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Διενέξεις',
    'backup__restore__object_vhost' => 'Εικονικός κεντρικός υπολογιστής',
    'backup__restore__object_plesk_admin' => 'Διαχειριστής Plesk',
    'backup__restore__object_ftpuser' => 'Λογαριασμός FTP',
    'backup__restore__object_frontpageuser' => 'Λογαριασμός FrontPage',
    'backup__restore__object_webuser' => 'χρήστης web',
    'backup__restore__object_domain' => 'τομέας',
    'backup__restore__object_subdomain' => 'υποτομέας',
    'backup__restore__object_domainalias' => 'Ψευδώνυμο τομέα',
    'backup__restore__object_client' => 'πελάτης',
    'backup__restore__object_reseller' => 'μεταπωλητής',
    'backup__restore__object_autoresponder' => 'Αυτόματη απάντηση',
    'backup__restore__object_mailalias' => 'ψευδώνυμο ηλεκτρονικού ταχυδρομείου',
    'backup__restore__object_database' => 'βάση δεδομένων',
    'backup__restore__object_mailname' => 'λογαριασμός αλληλογραφίας',
    'backup__restore__object_db_user' => 'χρήστης βάσης δεδομένων',
    'backup__restore__object_ssl_certificate' => 'Πιστοποιητικό SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Οι παρακάτω μεταπωλητές δεν μπορούν να αποκατασταθούν, επειδή μετατρέπονται σε πελάτες: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Οι παρακάτω πελάτες δεν μπορούν να αποκατασταθούν, επειδή μετατρέπονται σε μεταπωλητές: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Οι παρακάτω πελάτες δεν μπορούν να αποκατασταθούν, επειδή μεταφέρονται σε άλλον κάτοχο: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Δεν υπάρχει αρκετός χώρος στον δίσκο του διακομιστή προορισμού για τη μεταφορά όλων των επιλεγμένων συνδρομών. Διαθέσιμος: %1 MB. Απαιτείται: %2 MB. Σημειώστε ότι ο απαιτούμενος χώρος υπολογίζεται ως το άθροισμα του περιεχομένου web, αλληλογραφίας και βάσεων δεδομένων των τομέων. Ο απαιτούμενος χώρος υπολογίζεται μία φορά την ημέρα και αποθηκεύεται στη μνήμη cache και, συνεπώς, το πραγματικό μέγεθος των τομέων μπορεί να διαφέρει από το υπολογισμένο. Αν είστε βέβαιοι ότι οι επιλεγμένοι τομείς δεν καταλαμβάνουν περισσότερο χώρο απ\' όσο διατίθεται, μπορείτε να προχωρήσετε με τη μεταφορά.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Ελευθερώστε χώρο στο δίσκο του διακομιστή προορισμού.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Δεν υπάρχει αρκετός χώρος στο δίσκο του διακομιστή προέλευσης για την αποθήκευση των προσωρινών αρχείων για τη μεταφορά. Διαθέσιμος: %1 MB. Απαιτείται: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Ελευθερώστε χώρο στο δίσκο του διακομιστή προέλευσης.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Πληροφορίες διακομιστή',

    'backup__restore__capability_not_installed_component_text' => 'Το στοιχείο %1 δεν έχει εγκατασταθεί στον διακομιστή προορισμού. Το %1 θα είναι μη διαθέσιμο για όλα τα αντικείμενα που αποκαθίστανται.',
    'backup__restore__capability_not_installed_component_resolution' => 'Εγκαταστήστε το %1. Αυτό ενδέχεται να διαρκέσει μερικά λεπτά.',
    'backup__restore__capability_existing_sys_user_text' => 'Υπάρχει ήδη ένας χρήστης συστήματος με το όνομα %1 στο διακομιστή προορισμού.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Μετονομάστε τον τρέχοντα χρήστη του συστήματος στο διακομιστή προορισμού.',
    'backup__restore__capability_license_usage_text' => 'Θα σημειωθεί υπέρβαση των παρακάτω ορίων πόρων (που ορίζονται από το κλειδί άδειας χρήσης) στο διακομιστή προορισμού μετά τη μεταφορά δεδομένων:',
    'backup__restore__capability_license_usage_resolution' => 'Εγκαταστήστε ένα άλλο κλειδί άδειας χρήσης στο διακομιστή προορισμού, το οποίο θα παρέχει την απαιτούμενη ποσότητα πόρων.',
    'backup__restore__capability_max_allowed_packet_text' => "Η παράμετρος 'max_allowed_packet' στο διακομιστή βάσεων δεδομένων προέλευσης είναι %1 και είναι μεγαλύτερη σε σχέση με αυτήν του διακομιστή βάσεων δεδομένων προορισμού, δηλ. %2. Ορισμένα αντικείμενα βάσεων δεδομένων για τους παρακάτω τομείς μπορεί να μην αποκατασταθούν.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Αυξήστε την τιμή 'max_allowed_packet' στο διακομιστή βάσεων δεδομένων προορισμού.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Δεν είναι δυνατή η μεταφορά των βάσεων δεδομένων PostgreSQL επειδή η έκδοση του PostgreSQL στο διακομιστή προορισμού είναι προγενέστερη από αυτήν στο διακομιστή προέλευσης.  Η τρέχουσα έκδοση είναι %1 και η απαιτούμενη έκδοση %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Εγκαταστήστε την απαιτούμενη έκδοση του PostgreSQL στο διακομιστή προορισμού.',
    'backup__restore__capability_db_server_connection_problems' => 'Δεν είναι δυνατή η σύνδεση με το διακομιστή βάσεων δεδομένων προορισμού PostgreSQL.  Οι βάσεις δεδομένων δεν θα μεταφερθούν εκτός εάν επαναφέρετε τη σύνδεση.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Ελέγξτε τις ρυθμίσεις σύνδεσης στο διακομιστή βάσεων δεδομένων προορισμού.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Το στοιχείο %1 είναι απενεργοποιημένο στο διακομιστή προορισμού.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Ενεργοποιήστε το %1 στο διακομιστή προορισμού.',
    'backup__restore__capability_not_configured_component_text' => 'Το στοιχείο %1 δεν έχει ρυθμιστεί στο διακομιστή προορισμού.',
    'backup__restore__capability_not_configured_component_resolution' => 'Ρυθμίστε το %1 στη σελίδα Εργαλεία & Ρυθμίσεις.',

    'backup__restore__capability_webmail_is_not_available' => 'Η υπηρεσία webmail %1 δεν είναι διαθέσιμη στο διακομιστή προορισμού. Αντ\' αυτής, το Plesk θα χρησιμοποιήσει την ακόλουθη υπηρεσία webmail: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Για να χρησιμοποιήσετε το ίδιο webmail με τον διακομιστή προέλευσης, πρέπει να το εγκαταστήσετε σε αυτόν τον διακομιστή.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Για να χρησιμοποιήσετε το ίδιο webmail με το διακομιστή προέλευσης, πρέπει να το εγκαταστήσετε στο διακομιστή προορισμού.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Το webmail '%1' δεν είναι διαθέσιμο στο διακομιστή προορισμού. Αντ' αυτού, στις εξής συνδρομές: %3, το Plesk θα χρησιμοποιήσει την ακόλουθη υπηρεσία webmail: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Εγκαταστήστε το απαιτούμενο webmail στο διακομιστή προορισμού.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Ρυθμίσεις webmail',

    'backup__restore__capability_shell_is_not_available' => 'Το κέλυφος %1 δεν είναι διαθέσιμο στο διακομιστή προορισμού.  Αντ\' αυτού, θα χρησιμοποιηθεί ένα από τα διαθέσιμα κελύφη.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Για να χρησιμοποιήσετε το ίδιο κέλυφος με το διακομιστή προέλευσης, πρέπει να το ενεργοποιήσετε (στο /etc/shells) ή να το εγκαταστήσετε στο διακομιστή προορισμού.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Ο διακομιστής DNS προορισμού δεν υποστηρίζει δίκτυα στο Πρότυπο περιορισμών μεταφοράς.  Οι εγγραφές με διευθύνσεις IP δικτύου στους περιορισμούς μεταφοράς DNS δεν θα αποκατασταθούν.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Ο διακομιστής DNS προορισμού δεν υποστηρίζει δίκτυα στο Πρότυπο περιορισμών μεταφοράς, αλλά ορισμένες συνδρομές έχουν δίκτυα σε περιορισμούς μεταφοράς DNS. Οι εγγραφές με διευθύνσεις IP δικτύου στους περιορισμούς μεταφοράς DNS δεν θα αποκατασταθούν.',

    'backup__restore__capability_wrong_php_handler_text' => 'Ο δείκτης χειρισμού PHP %1 δεν είναι διαθέσιμος στο διακομιστή προορισμού. Αντ\' αυτού, το Plesk θα χρησιμοποιήσει τον ακόλουθο δείκτη χειρισμού PHP: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Για να χρησιμοποιήσετε τον ίδιο δείκτη χειρισμού PHP με το διακομιστή προέλευσης, πρέπει να τον ενεργοποιήσετε ή να τον εγκαταστήσετε στο διακομιστή προορισμού.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Ο δείκτης χειρισμού PHP %1 δεν είναι διαθέσιμος. Αντ\' αυτού, το Plesk θα χρησιμοποιήσει το %2 για τα παρακάτω προγράμματα παροχής υπηρεσιών: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Ο δείκτης χειρισμού PHP %1 δεν είναι διαθέσιμος. Αντ\' αυτού, το Plesk θα χρησιμοποιήσει το %2 για τις παρακάτω τοποθεσίες: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Ο δείκτης χειρισμού PHP %1 δεν είναι διαθέσιμος. Δε θα είναι διαθέσιμος για τους ακόλουθους ιστότοπους: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'Το %1 %2 δεν είναι διαθέσιμο στο διακομιστή προορισμού.  Αντ\' αυτού, θα χρησιμοποιηθεί η προεπιλεγμένη έκδοση.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Για να χρησιμοποιήσετε το ίδιο %1 με το διακομιστή προέλευσης, πρέπει να το ενεργοποιήσετε ή να το εγκαταστήσετε στο διακομιστή προορισμού.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Η πολιτική χρήσης του λογισμικού προστασίας από ιούς στο διακομιστή προορισμού δεν επιτρέπει προσωπικές (ανά διεύθυνση ηλεκτρονικού ταχυδρομείου) ρυθμίσεις προστασίας από ιούς για την εξερχόμενη αλληλογραφία. Αυτές οι ρυθμίσεις δεν θα μεταφερθούν.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Η πολιτική χρήσης του λογισμικού προστασίας από ιούς στο διακομιστή προορισμού δεν επιτρέπει προσωπικές (ανά διεύθυνση ηλεκτρονικού ταχυδρομείου) ρυθμίσεις προστασίας από ιούς για την εισερχόμενη αλληλογραφία.  Αυτές οι ρυθμίσεις δεν θα μεταφερθούν.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Η πολιτική χρήσης του λογισμικού προστασίας από ιούς στο διακομιστή προορισμού δεν επιτρέπει προσωπικές (ανά διεύθυνση ηλεκτρονικού ταχυδρομείου) ρυθμίσεις προστασίας από ιούς. Αυτές οι ρυθμίσεις δεν θα μεταφερθούν.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Για να μεταφέρετε προσωπικές (ανά διεύθυνση ηλεκτρονικού ταχυδρομείου) ρυθμίσεις προστασίας από ιούς, ενεργοποιήστε τις αντίστοιχες επιλογές στη διαδρομή Εργαλεία & Ρυθμίσεις > Ρυθμίσεις προστασίας από ιούς.",
    'backup__restore__capability_antivirus_not_active_text' => 'Δεν υπάρχει ενεργοποιημένο λογισμικό προστασίας από ιούς.  Οι ρυθμίσεις προστασίας από ιούς από το διακομιστή προέλευσης δεν θα λειτουργήσουν μέχρι να επιλέξετε το λογισμικό προστασίας από ιούς στο διακομιστή προορισμού.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Επιλέξτε το λογισμικό προστασίας από ιούς από την ενότητα των ρυθμίσεων Εργαλεία & Ρυθμίσεις > Ρυθμίσεις προστασίας από ιούς > Λογισμικό προστασίας από ιούς.',

    'backup__restore__capability_antivirus_another_active_text' => 'Το λογισμικό προστασίας από ιούς %2 δεν είναι διαθέσιμο στο διακομιστή προορισμού.  Αντ\' αυτού, θα χρησιμοποιηθεί το %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Για να χρησιμοποιήσετε το ίδιο λογισμικό προστασίας από ιούς με το διακομιστή προέλευσης, παρακαλούμε να το εγκαταστήσετε και να το επιλέξτε από την ενότητα των ρυθμίσεων Εργαλεία & Ρυθμίσεις > Ρυθμίσεις προστασίας από ιούς > Λογισμικό προστασίας από ιούς.',
    'backup__restore__capability_not_available_sni_text' => 'Το SNI δεν είναι διαθέσιμο στον διακομιστή προορισμού. Οι τοποθεσίες web που έχουν την ίδια διεύθυνση IP δεν θα μπορούν να χρησιμοποιήσουν τα μεμονωμένα πιστοποιητικά SSL/TLS.',
    'backup__restore__capability_not_available_sni_resolution' => "Βεβαιωθείτε ότι το λειτουργικό σύστημα του διακομιστή προορισμού υποστηρίζει το SNI και ότι η υποστήριξη του SNI είναι ενεργοποιημένη στο Plesk (πλαίσιο ελέγχου 'Ενεργοποίηση της υποστήριξης SNI, η οποία επιτρέπει τη χρήση μεμονωμένων πιστοποιητικών SSL/TLS σε τοποθεσίες web με την ίδια διεύθυνση IP' στη διαδρομή Εργαλεία & Ρυθμίσεις> Ρυθμίσεις διακομιστή).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Ρυθμίσεις διακομιστή',

    'backup__restore__capability_vhost_already_exists_text' => 'Η τοποθεσία web %1 δεν είναι δυνατό να μεταφερθεί: υπάρχει ήδη μια τοποθεσία web με το ίδιο όνομα στο διακομιστή προορισμού.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Μετονομάστε ή διαγράψτε την τοποθεσία web με το ίδιο όνομα από το διακομιστή.',
    'backup__restore__capability_removed_vhosts' => 'Οι παρακάτω συνδρομές δεν θα αποκατασταθούν διότι περιέχουν ονόματα τομέα που υπάρχουν ήδη στον διακομιστή προορισμού: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Στο διακομιστή προέλευσης υπάρχουν %3 διαφορετικοί δείκτες χειρισμού PHP τύπου %1 και έκδοσης %2. Αντί αυτών, θα χρησιμοποιηθεί ένας δείκτης χειρισμού του κατάλληλου τύπου και έκδοσης στο διακομιστή προορισμού.  Σημειώστε ότι οι ρυθμίσεις PHP στο διακομιστή προέλευσης και προορισμού μπορεί να διαφέρουν.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Το πρόγραμμα εγκατάστασης Plesk δεν υποστηρίζει το Microsoft FrontPage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Το πρόγραμμα εγκατάστασης Plesk δεν υποστηρίζει το Python. Εγκαταστήστε το Python χειροκίνητα.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Ρυθμίσεις διακομιστή αλληλογραφίας',

    'backup__restore__capability_ftps_disabled' => 'Η χρήση του ασφαλούς FTPS επιτρέπεται στο διακομιστή προέλευσης, αλλά απαγορεύεται στον προορισμό. Οι εφαρμογές χρήστη που χρησιμοποιούν FTP μπορεί να μην λειτουργήσουν σωστά.',
    'backup__restore__capability_ftps_required' => 'Η χρήση του μη ασφαλούς FTP επιτρέπεται στο διακομιστή προέλευσης, αλλά απαγορεύεται στον προορισμό. Οι εφαρμογές χρήστη που χρησιμοποιούν FTP μπορεί να μην λειτουργήσουν σωστά.',
    'backup__restore__capability_ftps_policy_resolution' => 'Αλλάξτε την πολιτική ασφαλούς FTP από τη διαδρομή Εργαλεία & Ρυθμίσεις > Πολιτική Ασφαλείας.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabyte δεδομένων θα μετακινηθούν από το διακομιστή προέλευσης στο διακομιστή προορισμού σε %2 ώρες.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Για ταχύτερη μεταφορά, ελέγξτε τη σύνδεση δικτύου μεταξύ των διακομιστών προέλευσης και προορισμού και επιλύστε τυχόν ζητήματα (αν υπάρχουν).',
    'backup__restore__too_low_download_speed' => "λιγότερο από 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Για ταχύτερη μεταφορά, ελέγξτε τη σύνδεση δικτύου μεταξύ των διακομιστών προέλευσης και προορισμού και επιλύστε τυχόν ζητήματα (αν υπάρχουν).',
    'backup__restore__capability_zero_download_speed_text' => 'Η ελάχιστη αποδεκτή ταχύτητα λήψης είναι %1 MBps.  Η ταχύτητα λήψης μεταξύ του διακομιστή προέλευσης και προορισμού είναι 0 MBps.  Αυτό μπορεί να οφείλεται σε προβλήματα σύνδεσης του δικτύου.  Δεν είναι δυνατή η μεταφορά.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Ελέγξτε τη σύνδεση δικτύου μεταξύ των διακομιστών προέλευσης και προορισμού και επιλύστε τυχόν ζητήματα.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Η ελάχιστη αποδεκτή ταχύτητα λήψης είναι %2 MBps. Η ταχύτητα λήψης μεταξύ του διακομιστή προέλευσης και προορισμού είναι %1 MBps. Αυτό μπορεί να αυξήσει τον χρόνο της μεταφοράς. Στο τρέχον περιβάλλον σας, η μετεγκατάσταση %3 MB θα διαρκέσει %4 ώρες.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Η ελάχιστη αποδεκτή ταχύτητα λήψης είναι %2 MBps. Η ταχύτητα λήψης μεταξύ του διακομιστή προέλευσης και προορισμού είναι %1 MBps. Αυτό μπορεί να αυξήσει τον χρόνο της μεταφοράς.',

    'backup__restore__capability_remote_database_migration' => "Οι ακόλουθοι τομείς χρησιμοποιούν απομακρυσμένες βάσεις δεδομένων: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Μην καταργήσετε αυτούς τους τομείς από το διακομιστή προέλευσης μετά τη μεταφορά εάν η έκδοση του Plesk στο διακομιστή προέλευσης είναι προγενέστερη από την 11.5! Αντ' αυτού, ενεργοποιήστε την αναστολή τους.  Αν καταργήσετε τους τομείς, οι βάσεις δεδομένων θα καταργηθούν από τον απομακρυσμένο διακομιστή. Σημείωση: Τα αρχεία αποτύπωσης των απομακρυσμένων βάσεων δεδομένων θα αποθηκευτούν στο διακομιστή προέλευσης στον κατάλογο %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Τα αρχεία αντιγράφων ασφαλείας βάσεων δεδομένων MySQL με έκδοση προγενέστερη της 5.1 (%1) μπορεί να μην αποκατασταθούν στο MySQL 5.1.x επειδή το MySQL 5.1.x χειρίζεται με διαφορετικό τρόπο τους χαρακτήρες Unicode.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Διαβάστε το σχετικό άρθρο της γνωσιακής βάσης # 136850',

    'backup__restore__capability_firewall_not_installed_text' => 'Η επέκταση τείχους προστασίας δεν έχει εγκατασταθεί στον διακομιστή προορισμού. Εάν έχετε ορίσει κανόνες περιορισμού πρόσβασης, οι κανόνες αυτοί δεν θα λειτουργήσουν.',
    'backup__restore__capability_firewall_not_installed_resolution' => 'Εγκαταστήστε την επέκταση τείχους προστασίας χρησιμοποιώντας το πρόγραμμα εγκατάστασης της Plesk.',
    'backup__restore__capability_courier_not_installed_text' => 'Το Courier-IMAP δεν έχει εγκατασταθεί στον διακομιστή προορισμού.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Εγκαταστήστε το Courier-IMAP μέσω του προγράμματος εγκατάστασης της Plesk.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Το Dovecot δεν έχει εγκατασταθεί στον διακομιστή προορισμού.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Εγκαταστήστε το Dovecot μέσω του προγράμματος εγκατάστασης της Plesk.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Ο χρόνος διατήρησης των στατιστικών στοιχείων κίνησης στις ρυθμίσεις παραμέτρων των ακόλουθων αντικειμένων είναι μικρότερος από την τιμή σε επίπεδο διακομιστή στο διακομιστή προορισμού.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Αλλάξτε την τιμή σε επίπεδο διακομιστή για το χρόνο διατήρησης των στατιστικών στοιχείων στο διακομιστή προορισμού.  Καθορίστε το χρονικό διάστημα αυτό σε τιμή ίση ή χαμηλότερη από τη μικρότερη τιμή στις ρυθμίσεις παραμέτρων των τομέων.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Ο χρόνος διατήρησης των στατιστικών στοιχείων κίνησης σε ορισμένους τομείς είναι μικρότερος από την τιμή σε επίπεδο διακομιστή (%1).  Η τιμή θα αλλάξει σε %1 γι\' αυτούς τους τομείς.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Ο χρόνος διατήρησης των στατιστικών στοιχείων κίνησης σε ορισμένα προγράμματα παροχής υπηρεσιών είναι μικρότερος από την τιμή σε επίπεδο διακομιστή (%1). Η τιμή θα αλλάξει σε %1 γι\' αυτά τα προγράμματα παροχής υπηρεσιών.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Η αντιστοίχιση μιας αποκλειστικής διεύθυνσης IP με μια κοινόχρηστη θα απενεργοποιήσει το ανώνυμο FTP και HTTPS (εκτός αν έχει ενεργοποιηθεί η υποστήριξη SNI).',

    'backup__restore__no_postgresql_commands_text' => 'Η συνδρομή χρησιμοποιεί μια απομακρυσμένη βάση δεδομένων PostgreSQL και δεν είναι δυνατή η δημιουργία του προσωρινού αρχείου αντιγράφου ασφαλείας της επειδή οι εντολές pg_dump και psql λείπουν από τον διακομιστή προέλευσης.',
    'backup__restore__no_postgresql_commands_resolution' => 'Εγκαταστήστε ένα πακέτο πελάτη PostgreSQL που υποστηρίζει αυτές τις εντολές.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Οι παρακάτω λειτουργικές μονάδες Apache είναι απενεργοποιημένες στο διακομιστή προορισμού: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Ενεργοποιήστε αυτές τις λειτουργικές μονάδες για να αποφύγετε πιθανά προβλήματα.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Οι παρακάτω λειτουργικές μονάδες Apache δεν είναι εγκατεστημένες στο διακομιστή προορισμού: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Ενεργοποιήστε και εγκαταστήστε αυτές τις λειτουργικές μονάδες για να αποφύγετε πιθανά προβλήματα.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Ο περιορισμός εξερχόμενων μηνυμάτων δεν υποστηρίζεται από την άδεια χρήσης σας. Οι αντίστοιχες ρυθμίσεις παραμέτρων δεν θα μεταφερθούν.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Εγκαταστήστε ένα άλλο κλειδί άδειας χρήσης στον διακομιστή προορισμού, το οποίο παρέχει τις απαραίτητες λειτουργίες.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Ο περιορισμός των εξερχόμενων μηνυμάτων είναι απενεργοποιημένος στον διακομιστή προορισμού. Οι αντίστοιχες ρυθμίσεις παραμέτρων δεν θα μεταφερθούν.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Ενεργοποιήστε τον περιορισμό των εξερχόμενων μηνυμάτων στον διακομιστή προορισμού.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Ρυθμίσεις αλληλογραφίας σε επίπεδο διακομιστή',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Ο περιορισμός των εξερχόμενων μηνυμάτων από ένα γραμματοκιβώτιο δεν υποστηρίζεται από τον διακομιστή αλληλογραφίας που χρησιμοποιείται στον διακομιστή προορισμού. Η τιμή αυτού του ορίου δεν θα μεταφερθεί.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Αλλάξτε τον διακομιστή αλληλογραφίας σε αυτόν που χρησιμοποιείτε στον διακομιστή προέλευσης.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Ρυθμίσεις αλληλογραφίας σε επίπεδο διακομιστή',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Ο περιορισμός των εξερχόμενων μηνυμάτων από έναν τομέα δεν υποστηρίζεται από τον διακομιστή αλληλογραφίας που χρησιμοποιείται στον διακομιστή προορισμού. Η τιμή αυτού του ορίου δεν θα μεταφερθεί.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Αλλάξτε τον διακομιστή αλληλογραφίας σε αυτόν που χρησιμοποιείτε στον διακομιστή προέλευσης.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Ρυθμίσεις αλληλογραφίας σε επίπεδο διακομιστή',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Ο περιορισμός των εξερχόμενων μηνυμάτων από μια συνδρομή δεν υποστηρίζεται από τον διακομιστή αλληλογραφίας που χρησιμοποιείται στον διακομιστή προορισμού. Η τιμή αυτού του ορίου δεν θα μεταφερθεί.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Αλλάξτε τον διακομιστή αλληλογραφίας σε αυτόν που χρησιμοποιείτε στον διακομιστή προέλευσης.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Ρυθμίσεις αλληλογραφίας σε επίπεδο διακομιστή',

    'bu_conflict_resolver_absent_phosting' => 'Δεν είναι δυνατή η επαναφορά των καθορισμένων αρχείων επειδή δεν υπάρχει φυσική φιλοξενία για την επαναφορά τους. Δημιουργήστε πρώτα έναν τομέα με φυσική φιλοξενία και στη συνέχεια ξεκινήστε εκ νέου την επαναφορά του αντιγράφου ασφαλείας.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Τα δεδομένα μεταπωλητών δεν θα αποκατασταθούν επειδή η διαχείριση μεταπωλητών δεν υποστηρίζεται.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Το στοιχείο ModSecurity δεν έχει εγκατασταθεί στον διακομιστή προορισμού.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Εγκαταστήστε το ModSecurity για να διατηρήσετε σε λειτουργία το τείχος προστασίας εφαρμογών web στις τοποθεσίες που μεταφέρονται. Η εγκατάσταση μπορεί να διαρκέσει μερικά λεπτά.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Εγκαταστήστε το ModSecurity αν θέλετε να μεταφέρετε τις ρυθμίσεις του τείχους προστασίας εφαρμογών web. Η εγκατάσταση μπορεί να διαρκέσει μερικά λεπτά.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Το στοιχείο ModSecurity δεν έχει ρυθμιστεί στον διακομιστή προορισμού.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Ρυθμίστε τις παραμέτρους του ModSecurity αν θέλετε να διατηρήσετε σε λειτουργία το τείχος προστασίας εφαρμογών web στις τοποθεσίες που μεταφέρονται.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Τείχος προστασίας εφαρμογών web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'Το ModSecurity είναι απενεργοποιημένο στον διακομιστή προορισμού.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Ενεργοποιήστε το ModSecurity αν θέλετε να διατηρήσετε σε λειτουργία το τείχος προστασίας εφαρμογών web για τις τοποθεσίες που μεταφέρονται.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Τείχος προστασίας εφαρμογών web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Το στοιχείο ModSecurity δεν έχει εγκατασταθεί. Οι ρυθμίσεις του τείχους προστασίας εφαρμογών web δεν θα αποκασταθούν για τα ακόλουθα αντικείμενα: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Οι τοποθεσίες web δεν μπορούν να αποκατασταθούν επειδή ανήκουν στη συνδρομή %1, η οποία δεν βρέθηκε στο Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Το στοιχείο %1 δεν έχει εγκατασταθεί στον διακομιστή προορισμού. Η υπηρεσία DNS δεν θα είναι διαθέσιμη και οι ρυθμίσεις DNS θα χαθούν. Όλες οι τοποθεσίες web των πελατών θα είναι εκτός σύνδεσης.',
    'bu_conflict_resolver_dns_not_installed' => 'Η υπηρεσία DNS δεν είναι εγκατεστημένη. Οι ρυθμίσεις DNS δεν θα αποκατασταθούν για τα ακόλουθα αντικείμενα: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Δεν είναι δυνατή η επαναφορά των ακόλουθων συνδρομών επειδή έχουν μεταφερθεί σε άλλους κατόχους: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Δεν είναι δυνατή η επαναφορά των ακόλουθων συνδρομών επειδή έχουν μεταφερθεί σε άλλους παρόχους: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Δεν είναι δυνατή η εύρεση του βοηθητικού προγράμματος επαναφοράς Web Presence Builder για την επαναφορά των δεδομένων του Web Presence Builder. Το Web Presence Builder πιθανώς να μην είναι εγκατεστημένο.',
    'backup__restore__capability_renamed_db' => 'Το όνομα βάσης δεδομένων "%1" χρησιμοποιείται ήδη από άλλη συνδρομή. Το όνομα της βάσης δεδομένων που αποκαθίσταται θα αλλάξει σε "%2".',
    'backup__restore__capability_renamed_db_user' => 'Το όνομα χρήστη βάσης δεδομένων "%1" χρησιμοποιείται ήδη από άλλη συνδρομή. Το όνομα χρήστη βάσης δεδομένων που αποκαθίσταται θα αλλάξει σε "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Το πρόγραμμα εγκατάστασης Plesk δεν υποστηρίζει το Perl. Εγκαταστήστε το ActiveState Perl χειροκίνητα.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% εξυπηρετείται από Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% εξυπηρετείται από nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Διενέξεις χρονισμού',
    'backup__restore__hint_timing_conflicts' => 'Οι διενέξεις χρονισμού σημειώνονται όταν το αντικείμενο που αποκαθίσταται υπάρχει ήδη στο σύστημα με πιο πρόσφατη ημερομηνία τροποποίησης ή όταν το αντικείμενο που αποκαθίσταται δεν υπάρχει εκείνη τη στιγμή στο σύστημα.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Χρησιμοποιήστε τη ρύθμιση παραμέτρων και τα δεδομένα από το αντίγραφο ασφαλείας',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Αντικαταστήστε πλήρως τη ρύθμιση παραμέτρων και τα δεδομένα του αντικειμένου που υπάρχουν εκείνη τη στιγμή στο σύστημα με τα δεδομένα και τη ρύθμιση παραμέτρων από το αρχείο του αντιγράφου ασφαλείας.  Εάν το αντικείμενο που αποκαθίσταται ανήκει πλέον σε διαφορετικό κάτοχο, το αντικείμενο θα αποκατασταθεί υπό τον προηγούμενο κάτοχο.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Χρησιμοποιήστε τη ρύθμιση παραμέτρων από το τρέχον σύστημα και τα δεδομένα από το αντίγραφο ασφαλείας',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Αντικαταστήστε τα τρέχοντα δεδομένα του αντικειμένου με τα δεδομένα από το αρχείο του αντιγράφου ασφαλείας, αλλά διατηρήστε τη ρύθμιση παραμέτρων του αντικειμένου που υπάρχει εκείνη τη στιγμή στο σύστημα.  Εάν το αντικείμενο που αποκαθίσταται ανήκει πλέον σε διαφορετικό κάτοχο, το αντικείμενο θα αποκατασταθεί υπό τον τωρινό κάτοχο.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'Να μην γίνει επαναφορά',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'Μην επαναφέρετε αντικείμενα που έχουν διενέξεις χρονισμού.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Διενέξεις χρήσης πόρων',
    'backup__restore__hint_resource_usage_conflicts' => 'Οι διενέξεις χρήσης πόρων σημειώνονται όταν κατά την επαναφορά σημειώνεται υπέρβαση των ορίων χρήσης πόρων του αντικειμένου που αποκαθίσταται.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Να επιτραπεί η υπερβολική χρήση',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Επαναφέρετε το αντικείμενο και επιτρέψτε τη χρήση περισσότερων πόρων από αυτούς που είχαν ανατεθεί αρχικά.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Να μην γίνει επαναφορά',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Μην επαναφέρετε αντικείμενα που έχουν διενέξεις χρήσης πόρων.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Διενέξεις ρύθμισης παραμέτρων',
    'backup__restore__hint_configuration_conflicts' => 'Οι διενέξεις ρύθμισης παραμέτρων σημειώνονται όταν το αντικείμενο που αποκαθίσταται έχει ρυθμίσεις και εφαρμογές web, οι οποίες δεν είναι διαθέσιμες ή απαγορεύονται σύμφωνα με την τρέχουσα πολιτική του κατόχου του αντικειμένου ή του διακομιστή.  Για παράδειγμα, μια διένεξη ρύθμισης παραμέτρων μπορεί να σημειωθεί αν οι λογαριασμοί ηλεκτρονικού ταχυδρομείου που αποκαθίστανται έχουν μεμονωμένες ρυθμίσεις φιλτραρίσματος ανεπιθύμητης αλληλογραφίας, ενώ η τρέχουσα πολιτική σε επίπεδο διακομιστή απαγορεύει τη χρήστη των εν λόγω ρυθμίσεων στους λογαριασμούς ηλεκτρονικού ταχυδρομείου.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Αυτόματο',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Επαναφέρετε το αντικείμενο και ενεργοποιήστε αυτόματα όλες τις επιλογές ρύθμισης παραμέτρων σε διένεξη που μπορείτε να διαχειριστείτε σύμφωνα με τα δικαιώματά σας.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Να μην γίνει επαναφορά',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Μην επαναφέρετε αντικείμενα που έχουν διενέξεις ρύθμισης παραμέτρων.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Οι αποκλειστικοί χώροι συγκέντρωσης εφαρμογών IIS δεν επιτρέπονται στις ρυθμίσεις συγκέντρωσης εφαρμογών IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Αλλάξτε τις ρυθμίσεις συγκέντρωσης εφαρμογών IIS στη διαδρομή Εργαλεία & Ρυθμίσεις > Χώρος συγκέντρωσης εφαρμογών IIS > Καθολικές ρυθμίσεις.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Οι κοινόχρηστοι χώροι συγκέντρωσης εφαρμογών IIS δεν επιτρέπονται στις ρυθμίσεις συγκέντρωσης εφαρμογών IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Αλλάξτε τις ρυθμίσεις συγκέντρωσης εφαρμογών IIS στη διαδρομή Εργαλεία & Ρυθμίσεις > Χώρος συγκέντρωσης εφαρμογών IIS > Καθολικές ρυθμίσεις.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Τα σύντομα ονόματα για τους λογαριασμούς ηλεκτρονικού ταχυδρομείου POP3/IMAP δεν επιτρέπονται στο διακομιστή προορισμού.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Τα σύντομα ονόματα για τους λογαριασμούς ηλεκτρονικού ταχυδρομείου δεν θα είναι διαθέσιμα μετά την επαναφορά των δεδομένων.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Δεν είναι δυνατό το άνοιγμα του αρχείου καταγραφής.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Δεν είναι δυνατή η επαναφορά της συνδρομής %1: έχει καταργηθεί από το λογαριασμό σας και δεν έχετε το δικαίωμα να δημιουργήσετε συνδρομές. Αν θέλετε να την επαναφέρετε, επικοινωνήστε με τον πάροχο υπηρεσιών σας.',

    'backup__error11' => 'Ο χώρος στο δίσκο δεν επαρκεί για τη δημιουργία αντιγράφου ασφαλείας.',
    'backup__error3011' => 'Η σύνδεση απορρίφθηκε: Δεν υπάρχουν προγράμματα σε κατάσταση ακρόασης στην καθορισμένη διεύθυνση και θύρα.',
    'backup__error3012' => 'Λήξη χρονικού ορίου σύνδεσης.',
    'backup__error3013' => 'Το δίκτυο δεν είναι προσβάσιμο.',
    'backup__error3014' => 'Δεν υπάρχει διαδρομή προς τον κεντρικό υπολογιστή.',
    'backup__error3015' => 'Η σύνδεση απέτυχε.',
    'backup__error3016' => 'Δεν είναι δυνατή η ανάλυση του ονόματος του κεντρικού υπολογιστή.',
    'backup__error3017' => 'Λανθασμένο όνομα χρήστη ή κωδικός πρόσβασης.',
    'backup__error3018' => 'Η σύνδεση SSH απέτυχε.',

    'backup__error3110' => 'Δεν είναι δυνατή η σύνδεση με τον απομακρυσμένο διαμεσολαβητή μετεγκατάστασης: Η σύνδεση με τον κεντρικό υπολογιστή δεν είναι διαθέσιμη.',
    'backup__error3111' => 'Ο διαμεσολαβητής μετεγκατάστασης έχει κλειδωθεί από μια αποτυχημένη εργασία μετεγκατάστασης ή χρησιμοποιείται από άλλη διαδικασία μετεγκατάστασης. Επανεκκινήστε τον διαμεσολαβητή μετεγκατάστασης στον διακομιστή προέλευσης.',
    'backup__error3112' => 'Η σύνδεση με τον κεντρικό υπολογιστή δεν είναι διαθέσιμη ή ο διαμεσολαβητής μετεγκατάστασης δεν εκτελείται στον κεντρικό υπολογιστή προέλευσης.',
    'backup__error3113' => 'Δεν είναι δυνατή η ανάπτυξη του διαμεσολαβητή μετεγκατάστασης σε κεντρικό υπολογιστή Linux. Ελέγξτε τη σύνδεση SSH στον κεντρικό υπολογιστή προέλευσης.',
    'backup__error3114' => 'Δεν είναι δυνατή η ανάπτυξη του διαμεσολαβητή μετεγκατάστασης σε κεντρικό υπολογιστή Linux: Η σύνδεση SSH απέτυχε.',
    'backup__error3115' => 'Λανθασμένο όνομα χρήστη ή κωδικός πρόσβασης.',
    'backup__error3116' => 'Ο καθορισμένος χρήστης δεν έχει δικαιώματα διαχείρισης.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Όλες οι ρυθμίσεις παραμέτρων και το περιεχόμενο',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'Όλες οι ρυθμίσεις παραμέτρων και το περιεχόμενο εκτός της αλληλογραφίας',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Μόνο ρυθμίσεις παραμέτρων και περιεχόμενο αλληλογραφίας',

    'dns_t__unable_to_remove_ns_record' => 'Δεν είναι δυνατή η κατάργηση της εγγραφής NS από το πρότυπο DNS: Κάθε ζώνη DNS πρέπει να έχει τουλάχιστον μία εγγραφή NS.',
    'dns__unsupported_server_zone_transfer' => 'Δεν είναι δυνατή η μεταφορά του Προτύπου περιορισμών μεταφοράς εξαιτίας της ρύθμισης παραμέτρων DNS σε επίπεδο διακομιστή: Στο διακομιστή προέλευσης, οι παρακάτω διευθύνσεις δικτύου επιτρέπονται για τη μεταφορά ζώνης, αλλά οι διευθύνσεις αυτές απαγορεύονται από το διακομιστή DNS της Microsoft: %1',
    'dns__unsupported_domain_zone_transfer' => 'Δεν είναι δυνατή η μεταφορά του Προτύπου περιορισμών μεταφοράς εξαιτίας της ρύθμισης παραμέτρων DNS των τομέων: Σε ορισμένους τομείς, οι παρακάτω διευθύνσεις δικτύου επιτρέπονται για τη μεταφορά ζώνης, αλλά οι διευθύνσεις αυτές απαγορεύονται από το διακομιστή DNS της Microsoft: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Ορισμός αντιστοίχισης διακομιστών βάσεων δεδομένων',
    'dbbackup__check_network_settings_failed' => 'Δεν είναι δυνατή η πρόσβαση στον κοινόχρηστο προσωρινό κατάλογο δικτύου για τα αρχεία αντιγράφων ασφαλείας. Ελέγξτε τον κατάλογο του δικτύου και τις ρυθμίσεις ονόματος χρήστη και κωδικού πρόσβασης. Σφάλμα: %1',

    'migration_select_exist_db_server' => 'Επιλέξτε τον διακομιστή βάσεων δεδομένων προορισμού',

    'dbbackup__temp_dir_wrong_value' => 'Καθορίστηκε μη έγκυρη τιμή για τον προσωρινό κατάλογο.',
    'dbbackup__network_temp_dir_wrong_value' => 'Καθορίστηκε μη έγκυρη τιμή για τον προσωρινό κατάλογο του δικτύου.',
    'dbbackup__server_backup_not_configured' => 'Οι ρυθμίσεις δημιουργίας αντιγράφων ασφαλείας βάσεων δεδομένων δεν έχουν διαμορφωθεί στο διακομιστή.',
    'dbbackup__temp_dir' => 'Προσωρινός κατάλογος',
    'dbbackup__temp_dir_hint' => 'Η διαδρομή προς τον φυσικό φάκελο στον απομακρυσμένο διακομιστή όπου βρίσκεται ο διακομιστής MS SQL. Ο διακομιστής MS SQL πρέπει να έχει τη δυνατότητα πρόσβασης σε αυτόν τον φάκελο για την ανάγνωση και εγγραφή προσωρινών αρχείων αντιγράφων ασφαλείας. για παράδειγμα, C:\\ΔιαδρομήΚαταλόγου',
    'dbbackup__network_temp_dir_hint' => 'Η διαδρομή προς το κοινόχρηστο στοιχείο δικτύου αντιστοιχισμένη στον φυσικό φάκελο που ορίζεται παραπάνω. Το Plesk θα αποκτά πρόσβαση στον κοινόχρηστο φάκελο για τη λήψη και αποστολή αρχείων αντιγράφων ασφαλείας. Για παράδειγμα, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Το όνομα χρήστη ενός χρήστη του δικτύου που έχει δημιουργηθεί στον απομακρυσμένο διακομιστή. Για παράδειγμα, ServerName\\UserName. Ο χρήστης πρέπει να έχει πρόσβαση στον κοινόχρηστο φάκελο που ορίζεται παραπάνω.',
    'dbbackup__network_password_hint' => 'Ο κωδικός πρόσβασης του χρήστη του δικτύου',

    'dbbackup__success_import_without_dublicate_users' => 'Δεν πραγματοποιήθηκε εισαγωγή των παρακάτω χρηστών: %1. Υπάρχουν ήδη στον διακομιστή βάσεων δεδομένων.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Συμπίεση αρχείων καταγραφής",
    'log_rot__log_rot_status' => "Κατάσταση ανακύκλωσης αρχείων καταγραφής",
    'log_rot__log_rot_period' => "Προϋποθέσεις ανακύκλωσης αρχείων καταγραφής",
    'log_rot__log_rot_size' => "κατά μέγεθος",
    'log_rot__log_rot_time' => "κατά ώρα",
    'log_rot__logrotation_enable' => "Ενεργοποίηση ανακύκλωσης αρχείων καταγραφής",
    'log_rot__mail' => "Αποστολή επεξεργασμένων αρχείων καταγραφής σε διεύθυνση ηλεκτρονικού ταχυδρομείου",
    'log_rot__max_number_of_logfiles' => "Μέγιστος αριθμός αρχείων καταγραφής",
    'log_rot__time_period' => "περίοδος",
    'log_rot__unable_turn_off' => 'Δεν είναι δυνατή η απενεργοποίηση της ανακύκλωσης αρχείων καταγραφής, επειδή έχει επιβληθεί σε επίπεδο διακομιστή',
    'log_rot__unable_set_period' => 'Δεν είναι δυνατός ο ορισμός διαφορετικής περιόδου ανακύκλωσης αρχείων καταγραφής από \'daily\', επειδή η τιμή αυτή έχει επιβληθεί σε επίπεδο διακομιστή',
    'log_rot__unable_set_max_log_files' => 'Δεν είναι δυνατό να οριστεί μέγιστος αριθμός αρχείων καταγραφής μεγαλύτερος από το όριο σε επίπεδο διακομιστή %1',

    /// action log
    // common/various
    'actionlog__confirm_clean_log' => "Είστε βέβαιοι ότι θέλετε να διαγράψετε τις επιλεγμένες εγγραφές αρχείων καταγραφής ενεργειών;",
    'actionlog__digit_expected' => "Αναμένεται αριθμός: %1",
    'actionlog__dont_remove_recs' => "να μην καταργηθούν οι εγγραφές",
    'actionlog__from_date' => "Από:",
    'actionlog__incorrect_rotation' => "Οι παράμετροι ανακύκλωσης αρχείων καταγραφής που καθορίστηκαν δεν είναι έγκυρες: %1",
    'actionlog__js_incorrect_date' => "Η ημερομηνία που καθορίστηκε δεν είναι έγκυρη.",
    'actionlog__js_incorrect_num_periods' => "Η περίοδος ανακύκλωσης που καθορίστηκε δεν είναι έγκυρη.",
    'actionlog__js_incorrect_num_records' => "Ο αριθμός των εγγραφών που καθορίστηκε δεν είναι έγκυρος.",
    'actionlog__logged_actions' => "Ενέργειες που καταγράφονται",
    'actionlog__period_day' => "ημέρες",
    'actionlog__period_month' => "μήνες",
    'actionlog__period_week' => "εβδομάδες",
    'actionlog__settings' => "Ρυθμίσεις αρχείου καταγραφής ενεργειών",
    'actionlog__store_logs_in_db' => "Αποθήκευση εγγραφών στη βάση δεδομένων",
    'actionlog__store_number' => "εγγραφές",
    'actionlog__to_date' => "Προς:",
    'actionlog__unknown_rot_period' => "Άγνωστη περίοδος ανακύκλωσης: %1",
    'actionlog__unknown_rot_type' => "Άγνωστος τύπος ανακύκλωσης: %1",
    'actionlog__wrong_date_period' => "Η ημερομηνία δεν είναι έγκυρη",
    'actionlog__session_preferences' => 'Ρυθμίσεις περιόδου λειτουργίας',
    // items (PFU schema)
    'actionlog__admin_info' => 'Πληροφορίες διαχειριστή',
    'actionlog__admin_preferences' => "Προτιμήσεις διαχειριστή",
    'actionlog__service' => 'Υπηρεσία',
    'actionlog__ip_addr' => 'Διεύθυνση ΙP',
    'actionlog__client' => 'Λογαριασμός πελάτη',
    'actionlog__client_status' => 'Κατάσταση λογαριασμού πελάτη',
    'actionlog__client_preferences' => "Προτιμήσεις περιβάλλοντος εργασίας πελάτη",
    'actionlog__client_ip_pool' => "Χώρος IP πελάτη",
    'actionlog__client_siteapp' => "Χώρος συγκέντρωσης εφαρμογών web πελάτη",
    'actionlog__client_guid' => "GUID πελάτη",
    'actionlog__domain' => 'Προεπιλεγμένος τομέας (ο πρώτος τομέας που προστίθεται σε μια συνδρομή)',
    'actionlog__domain_owner' => 'Κάτοχος συνδρομής',
    'actionlog__domain_plan' => 'Πρόγραμμα παροχής υπηρεσιών συνδρομής',
    'actionlog__domain_status' => 'Προεπιλεγμένος τομέας, κατάσταση',
    'actionlog__domain_dns' => 'Προεπιλεγμένος τομέας, ζώνη DNS',
    'actionlog__subdomain' => 'Υποτομέας ενός προεπιλεγμένου τομέα',
    'actionlog__domain_alias' => 'Προεπιλεγμένος τομέας, ψευδώνυμο',
    'actionlog__domain_alias_dns' => 'Προεπιλεγμένος τομέας, ζώνη DNS ψευδωνύμου',
    'actionlog__site' => 'τομέας',
    'actionlog__site_status' => 'Κατάσταση τομέα',
    'actionlog__site_dns' => 'Ζώνη DNS τομέα',
    'actionlog__site_guid' => 'GUID τομέα',
    'actionlog__site_subdomain' => 'Υποτομέας',
    'actionlog__site_alias' => 'Ψευδώνυμο τομέα',
    'actionlog__site_alias_dns' => 'Ζώνη DNS ψευδωνύμου τομέα',
    'actionlog__domain_limits' => 'Όρια συνδρομής',
    'actionlog__domain_limit_size' => 'Όριο χώρου στο δίσκο για συνδρομή',
    'actionlog__domain_limit_traffic' => 'Όριο κίνησης για συνδρομή',
    'actionlog__domain_limits_powerUser' => 'Όρια συνδρομής',
    'actionlog__domain_limit_size_powerUser' => 'Όριο χώρου στο δίσκο για συνδρομή',
    'actionlog__domain_limit_traffic_powerUser' => 'Όριο κίνησης για συνδρομή',
    'actionlog__domain_guid' => "Προεπιλεγμένος τομέας, GUID",
    'actionlog__cp_user' => 'Χρήστης Plesk',
    'actionlog__mailname' => 'Λογαριασμός αλληλογραφίας',
    'actionlog__maillist' => 'Λίστα αλληλογραφίας',
    'actionlog__phosting' => 'Ρυθμίσεις φιλοξενίας',
    'actionlog__forwarding' => 'Τυπικό πακέτο φιλοξενίας ή πακέτο φιλοξενίας κρυμμένης ανακατεύθυνσης (frame forwarding)',
    'actionlog__webuser' => 'Λογαριασμός χρήστη web',
    'actionlog__site_application' => 'Εφαρμογή web',
    'actionlog__license' => 'Κλειδί άδειας χρήσης',
    'actionlog__additional_license' => 'Πρόσθετο κλειδί άδειας χρήσης',
    'actionlog__template_domain' => "Πρόγραμμα παροχής υπηρεσιών μεταπωλητή",
    'actionlog__template_admin' => "Πρόγραμμα παροχής υπηρεσιών διαχειριστή",
    'actionlog__template_reseller' => 'Πρόγραμμα μεταπωλητή',
    'actionlog__admin_alias' => 'Πρόσθετος λογαριασμός διαχειριστή', // PFW
    'actionlog__ftpuser' => 'Πρόσθετος λογαριασμός FTP', // PFW
    'actionlog__db_server' => 'Διακομιστής βάσεων δεδομένων',
    'actionlog__db' => 'βάση δεδομένων',
    'actionlog__db_user' => 'Λογαριασμός χρήστη βάσης δεδομένων',
    'actionlog__client_sapppkg_pool' => "Εφαρμογή web χρήστη", // PFW, not used?
    'actionlog__remote_dns' => 'Κατάσταση απομακρυσμένου διακομιστή DNS', // PFW
    'actionlog__reseller' => 'Λογαριασμός μεταπωλητή',
    'actionlog__reseller_guid' => 'GUID μεταπωλητή',
    'actionlog__reseller_ip_pool' => "Χώρος IP μεταπωλητή",
    'actionlog__reseller_limit_size' => 'Όριο χώρου στο δίσκο για το λογαριασμό μεταπωλητή',
    'actionlog__reseller_limit_traffic' => 'Όριο κίνησης για το λογαριασμό μεταπωλητή',
    'actionlog__reseller_limits' => 'Όρια λογαριασμού μεταπωλητή',
    'actionlog__reseller_permissions' => 'Δικαιώματα μεταπωλητή',
    'actionlog__reseller_preferences' => "Προτιμήσεις περιβάλλοντος εργασίας μεταπωλητή",
    'actionlog__reseller_siteapp' => "Εφαρμογές web στο χώρο συγκέντρωσης του μεταπωλητή",
    'actionlog__reseller_status' => 'Κατάσταση λογαριασμού μεταπωλητή',
    'actionlog__health_status' => 'Κατάσταση υγείας διακομιστή',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'συμπληρώθηκε',
    'actionlog__added' => 'προστέθηκε',
    'actionlog__removed' => 'καταργήθηκε',
    'actionlog__change' => 'άλλαξε',
    'actionlog__update' => 'ενημερώθηκε',
    'actionlog__move' => 'μετακινήθηκε',
    'actionlog__upgrade' => 'αναβαθμίστηκε', // PFU?
    'actionlog__update_or_add' => 'ενημερώθηκε ή προστέθηκε',
    'actionlog__expired' => 'έληξε',
    'actionlog__create' => 'δημιουργήθηκε',
    'actionlog__delete' => 'έχει διαγραφεί',
    'actionlog__service_stop' => 'διακόπηκε',
    'actionlog__service_restart' => 'επανεκκινήθηκε',
    'actionlog__service_start' => 'ξεκίνησε',
    'actionlog__login' => 'σε σύνδεση',
    'actionlog__logout' => 'σε αποσύνδεση',
    'actionlog__install' => 'εγκαταστάθηκε',
    'actionlog__uninstall' => 'καταργήθηκε η εγκατάσταση',
    'actionlog__reconfigure' => 'επαναρρυθμίστηκε',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Αίτημα επαναφοράς κωδικού πρόσβασης',
    'actionlog__event_admin_update' => 'Οι πληροφορίες διαχειριστή ενημερώθηκαν',
    'actionlog__event_admin_preferences_update' => "Οι προτιμήσεις διαχειριστή ενημερώθηκαν",
    'actionlog__event_service_restart' => 'Η υπηρεσία επανεκκινήθηκε',
    'actionlog__event_service_start' => 'Η υπηρεσία ξεκίνησε',
    'actionlog__event_service_stop' => 'Η υπηρεσία διακόπηκε',
    'actionlog__event_ip_address_create' => 'Η διεύθυνση IP δημιουργήθηκε',
    'actionlog__event_ip_address_delete' => 'Η διεύθυνση IP διαγράφηκε',
    'actionlog__event_ip_address_update' => 'Η διεύθυνση IP ενημερώθηκε',
    'actionlog__event_client_create' => 'Ο λογαριασμός πελάτη δημιουργήθηκε',
    'actionlog__event_client_delete' => 'Ο λογαριασμός πελάτη διαγράφηκε',
    'actionlog__event_client_update' => 'Ο λογαριασμός πελάτη ενημερώθηκε',
    'actionlog__event_client_status_update' => 'Η κατάσταση λογαριασμού του πελάτη ενημερώθηκε',
    'actionlog__event_client_preferences_update' => "Οι προτιμήσεις περιβάλλοντος εργασίας του πελάτη ενημερώθηκαν",
    'actionlog__event_client_siteapp_added' => "Η εφαρμογή web προστέθηκε στο χώρο συγκέντρωσης εφαρμογών του λογαριασμού του πελάτη",
    'actionlog__event_client_siteapp_removed' => "Η εφαρμογή web καταργήθηκε από το χώρο συγκέντρωσης εφαρμογών του λογαριασμού του πελάτη",
    'actionlog__event_domain_limit_size_reached' => 'Συμπληρώθηκε το όριο χώρου στο δίσκο για τη συνδρομή',
    'actionlog__event_domain_limit_traffic_reached' => 'Συμπληρώθηκε το όριο κίνησης για τη συνδρομή',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Συμπληρώθηκε το όριο χώρου στο δίσκο για τη συνδρομή',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Συμπληρώθηκε το όριο κίνησης για τη συνδρομή',

    'actionlog__domain_limit_database' => 'Όριο αριθμού βάσεων δεδομένων για τη συνδρομή',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Συμπληρώθηκε το όριο βάσεων δεδομένων MySQL για τη συνδρομή',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Συμπληρώθηκε το όριο προειδοποίησης βάσεων δεδομένων MySQL για τη συνδρομή',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Συμπληρώθηκε το όριο βάσεων δεδομένων διακομιστή Microsoft SQL για τη συνδρομή',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Συμπληρώθηκε το όριο προειδοποίησης βάσεων δεδομένων διακομιστή Microsoft SQL για τη συνδρομή',
    'actionlog__event_plesk_component_upgrade' => 'Το στοιχείο του Plesk ενημερώθηκε',
    'actionlog__event_plesk_component_install' => 'Το στοιχείο του Plesk εγκαταστάθηκε',
    'actionlog__event_plesk_component_uninstall' => 'Το στοιχείο του Plesk απεγκαταστάθηκε',
    'actionlog__event_domain_create' => 'Δημιουργήθηκε προεπιλεγμένος τομέας (ο πρώτος τομέας που προστίθεται σε μια συνδρομή/webspace)',
    'actionlog__event_domain_delete' => 'Διαγράφηκε ο προεπιλεγμένος τομέας (ο πρώτος τομέας που προστίθεται σε μια συνδρομή/webspace)',
    'actionlog__event_domain_update' => 'Ενημερώθηκε ο προεπιλεγμένος τομέας (ο πρώτος τομέας που προστίθεται σε μια συνδρομή/webspace)',
    'actionlog__event_domain_owner_change' => 'Ο κάτοχος της συνδρομής άλλαξε',
    'actionlog__event_domain_plan_change' => 'Το πρόγραμμα παροχής υπηρεσιών συνδρομής άλλαξε',
    'actionlog__event_domain_status_update' => 'Προεπιλεγμένος τομέας, η κατάσταση ενημερώθηκε',
    'actionlog__event_domain_dns_update' => 'Προεπιλεγμένος τομέας, η ζώνη DNS ενημερώθηκε',
    'actionlog__event_subdomain_create' => 'Ο υποτομέας ενός προεπιλεγμένου τομέα δημιουργήθηκε',
    'actionlog__event_subdomain_delete' => 'Ο υποτομέας ενός προεπιλεγμένου τομέα διαγράφηκε',
    'actionlog__event_subdomain_update' => 'Ο υποτομέας ενός προεπιλεγμένου τομέα ενημερώθηκε',
    'actionlog__event_domain_alias_create' => 'Προεπιλεγμένος τομέας, το ψευδώνυμο δημιουργήθηκε',
    'actionlog__event_domain_alias_delete' => 'Προεπιλεγμένος τομέας, το ψευδώνυμο διαγράφηκε',
    'actionlog__event_domain_alias_update' => 'Προεπιλεγμένος τομέας, το ψευδώνυμο ενημερώθηκε',
    'actionlog__event_domain_limits_update' => 'Τα όρια της συνδρομής ενημερώθηκαν',
    'actionlog__event_cp_user_login' => 'O χρήστης Plesk συνδέθηκε',
    'actionlog__event_cp_user_logout' => 'O χρήστης Plesk αποσυνδέθηκε',
    'actionlog__event_mailname_create' => 'Ο λογαριασμός αλληλογραφίας δημιουργήθηκε',
    'actionlog__event_mailname_delete' => 'Ο λογαριασμός αλληλογραφίας διαγράφηκε',
    'actionlog__event_mailname_update' => 'Ο λογαριασμός αλληλογραφίας ενημερώθηκε',
    'actionlog__event_maillist_create' => 'Η λίστα αλληλογραφίας δημιουργήθηκε',
    'actionlog__event_maillist_delete' => 'Η λίστα αλληλογραφίας διαγράφηκε',
    'actionlog__event_maillist_update' => 'Η λίστα αλληλογραφίας ενημερώθηκε',
    'actionlog__event_phys_hosting_create' => 'Η φυσική φιλοξενία (physical hosting) δημιουργήθηκε',
    'actionlog__event_phys_hosting_delete' => 'Η φυσική φιλοξενία (physical hosting) διαγράφηκε',
    'actionlog__event_phys_hosting_update' => 'Η φυσική φιλοξενία (physical hosting) ενημερώθηκε',
    'actionlog__event_forwarding_create' => 'Το τυπικό πακέτο φιλοξενίας ή πακέτο φιλοξενίας κρυμμένης ανακατεύθυνσης (frame forwarding) δημιουργήθηκε',
    'actionlog__event_forwarding_delete' => 'Το τυπικό πακέτο φιλοξενίας ή πακέτο φιλοξενίας κρυμμένης ανακατεύθυνσης (frame forwarding) διαγράφηκε',
    'actionlog__event_forwarding_update' => 'Το τυπικό πακέτο φιλοξενίας ή πακέτο φιλοξενίας κρυμμένης ανακατεύθυνσης (frame forwarding) ενημερώθηκε',
    'actionlog__event_webuser_create' => 'Ο λογαριασμός χρήστη web δημιουργήθηκε',
    'actionlog__event_webuser_delete' => 'Ο λογαριασμός χρήστη web διαγράφηκε',
    'actionlog__event_webuser_update' => 'Ο λογαριασμός χρήστη web ενημερώθηκε',
    'actionlog__event_siteapp_install' => 'Η εφαρμογή web εγκαταστάθηκε',
    'actionlog__event_siteapp_reconfigure' => 'Οι παράμετροι της εφαρμογής web επαναρρυθμίστηκαν',
    'actionlog__event_siteapp_uninstall' => 'Η εγκατάσταση της εφαρμογής web καταργήθηκε',
    'actionlog__event_license_update' => 'Το κλειδί άδειας χρήσης ενημερώθηκε',
    'actionlog__event_admin_alias_create' => 'Ο πρόσθετος λογαριασμός διαχειριστή δημιουργήθηκε',
    'actionlog__event_admin_alias_delete' => 'Ο πρόσθετος λογαριασμός διαχειριστή διαγράφηκε',
    'actionlog__event_admin_alias_update' => 'Ο πρόσθετος λογαριασμός διαχειριστή ενημερώθηκε',
    'actionlog__event_ftpuser_create' => 'Ο πρόσθετος λογαριασμός FTP δημιουργήθηκε',
    'actionlog__event_ftpuser_update' => 'Ο πρόσθετος λογαριασμός FTP ενημερώθηκε',
    'actionlog__event_ftpuser_delete' => 'Ο πρόσθετος λογαριασμός FTP διαγράφηκε',
    'actionlog__event_template_domain_create' => "Το πρόγραμμα παροχής υπηρεσιών του μεταπωλητή δημιουργήθηκε",
    'actionlog__event_template_domain_update' => "Το πρόγραμμα παροχής υπηρεσιών του μεταπωλητή ενημερώθηκε",
    'actionlog__event_template_domain_delete' => "Το πρόγραμμα παροχής υπηρεσιών του μεταπωλητή διαγράφηκε",
    'actionlog__event_template_admin_create' => "Το πρόγραμμα παροχής υπηρεσιών του διαχειριστή δημιουργήθηκε",
    'actionlog__event_template_admin_update' => "Το πρόγραμμα παροχής υπηρεσιών του διαχειριστή ενημερώθηκε",
    'actionlog__event_template_admin_delete' => "Το πρόγραμμα παροχής υπηρεσιών του διαχειριστή διαγράφηκε",
    'actionlog__event_database_server_create' => 'Ο διακομιστής βάσης δεδομένων δημιουργήθηκε',
    'actionlog__event_database_server_update' => 'Ο διακομιστής βάσεων δεδομένων ενημερώθηκε',
    'actionlog__event_database_server_delete' => 'Ο διακομιστής βάσεων δεδομένων διαγράφηκε',
    'actionlog__event_remote_dns_status_update' => 'Η κατάσταση του απομακρυσμένου διακομιστή DNS ενημερώθηκε',
    'actionlog__event_session_preferences_update' => 'Οι ρυθμίσεις περιόδου λειτουργίας ενημερώθηκαν',
    'actionlog__event_domain_alias_dns_update' => 'Προεπιλεγμένος τομέας, η ζώνη DNS του ψευδωνύμου τομέα ενημερώθηκε',
    'actionlog__event_domain_move' => 'Ο προεπιλεγμένος τομέας μετακινήθηκε σε νέα συνδρομή',
    'actionlog__event_site_move' => 'Ο τομέας μετακινήθηκε σε νέα συνδρομή',
    'actionlog__event_site_subdomain_move' => 'Ο υποτομέας μεταφέρθηκε σε νέα συνδρομή',
    'actionlog__event_subdomain_move' => 'Ο υποτομέας ενός προεπιλεγμένου τομέα μετακινήθηκε σε νέα συνδρομή',
    'actionlog__event_license_expired' => 'Η άδεια χρήσης του Plesk έχει λήξει',
    'actionlog__event_database_create' => 'Η βάση δεδομένων δημιουργήθηκε',
    'actionlog__event_database_delete' => 'Η βάση δεδομένων καταργήθηκε',
    'actionlog__event_database_user_create' => 'Ο λογαριασμός χρήστη βάσης δεδομένων δημιουργήθηκε',
    'actionlog__event_database_user_update' => 'Οι ρυθμίσεις του λογαριασμού χρήστη βάσης δεδομένων ενημερώθηκαν',
    'actionlog__event_database_user_delete' => 'Ο λογαριασμός χρήστη βάσης δεδομένων καταργήθηκε',
    'actionlog__event_client_guid_update' => "Το GUID πελάτη ενημερώθηκε",
    'actionlog__event_domain_guid_update' => 'Προεπιλεγμένος τομέας, το GUID ενημερώθηκε',
    'actionlog__event_reseller_create' => 'Ο λογαριασμός μεταπωλητή δημιουργήθηκε',
    'actionlog__event_reseller_delete' => 'Ο λογαριασμός μεταπωλητή διαγράφηκε',
    'actionlog__event_reseller_update' => 'Ο λογαριασμός μεταπωλητή ενημερώθηκε',
    'actionlog__event_reseller_guid_update' => 'Το GUID μεταπωλητή ενημερώθηκε',
    'actionlog__event_reseller_ip_pool_update' => "Ο χώρος IP του μεταπωλητή ενημερώθηκε",
    'actionlog__event_reseller_limit_size_reached' => 'Συμπληρώθηκε το όριο χώρου στο δίσκο για το λογαριασμό μεταπωλητή',
    'actionlog__event_reseller_limit_traffic_reached' => 'Συμπληρώθηκε το όριο κίνησης για το λογαριασμό μεταπωλητή',
    'actionlog__event_reseller_limits_update' => 'Τα όρια του λογαριασμού μεταπωλητή ενημερώθηκαν',
    'actionlog__event_reseller_permissions_update' => 'Τα δικαιώματα του λογαριασμού μεταπωλητή ενημερώθηκαν',
    'actionlog__event_reseller_preferences_update' => "Οι προτιμήσεις περιβάλλοντος εργασίας του μεταπωλητή ενημερώθηκαν",
    'actionlog__event_reseller_siteapp_added' => "Η εφαρμογή προστέθηκε στο χώρο συγκέντρωσης εφαρμογών του λογαριασμού μεταπωλητή",
    'actionlog__event_reseller_siteapp_removed' => "Η εφαρμογή καταργήθηκε από το χώρο συγκέντρωσης εφαρμογών του λογαριασμού μεταπωλητή",
    'actionlog__event_reseller_status_update' => 'Η κατάσταση του λογαριασμού μεταπωλητή ενημερώθηκε',
    'actionlog__event_template_reseller_create' => 'Το πρόγραμμα μεταπωλητή δημιουργήθηκε',
    'actionlog__event_template_reseller_delete' => 'Το πρόγραμμα μεταπωλητή διαγράφηκε',
    'actionlog__event_template_reseller_update' => 'Το πρόγραμμα μεταπωλητή ενημερώθηκε',
    'actionlog__event_health_status_change' => 'Η κατάσταση υγείας του διακομιστή άλλαξε',
    'actionlog__event_siteapp_upgrade' => 'Η εφαρμογή web αναβαθμίστηκε',
    'actionlog__event_extension_install' => 'Η επέκταση εγκαταστάθηκε',
    'actionlog__event_extension_uninstall' => 'Η επέκταση απεγκαταστάθηκε',
    'actionlog__event_extension_upgrade' => 'Η επέκταση αναβαθμίστηκε',
    'actionlog__event_extension_status_update' => 'Η κατάσταση της επέκτασης ενημερώθηκε',
    'actionlog__event_additional_license_expired' => 'Το πρόσθετο κλειδί άδειας χρήσης έχει λήξει',
    'actionlog__event_hostname_changed' => 'Το όνομα κεντρικού υπολογιστή διακομιστή άλλαξε',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Το API RPC του Plesk δεν έχει εγκατασταθεί στον απομακρυσμένο διακομιστή. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για βοήθεια.",
    'rsession_no_account_errmsg' => "Δεν είναι δυνατή η πρόσβαση στην απομακρυσμένη υπηρεσία με το λογαριασμό σας.  Ο πιο συνηθισμένος λόγος είναι ότι η υπηρεσία δεν έχει ενεργοποιηθεί ακόμη στο λογαριασμό σας.  Περιμένετε μερικά λεπτά και δοκιμάστε ξανά. Εάν αντιμετωπίσετε ξανά αυτό το πρόβλημα, επικοινωνήστε με το διαχειριστή του συστήματος.",
    'rsession_no_domain_errmsg' => "Δεν είναι δυνατή η πρόσβαση στην απομακρυσμένη υπηρεσία γι' αυτόν τον τομέα. Ο πιο συνηθισμένος λόγος είναι ότι η υπηρεσία δεν έχει ενεργοποιηθεί ακόμη γι' αυτόν τον τομέα. Περιμένετε μερικά λεπτά και δοκιμάστε ξανά. Εάν αντιμετωπίσετε ξανά αυτό το πρόβλημα, επικοινωνήστε με το διαχειριστή του συστήματος.",
    'rsession_unknown_errmsg' => "Ο απομακρυσμένος διακομιστής απέρριψε την απόπειρα δημιουργίας περιόδου λειτουργίας. Επικοινωνήστε με το διαχειριστή του συστήματος για υποστήριξη.  Το σφάλμα ήταν: %1",
    'rsession_unknown2_errmsg' => "Άγνωστο σφάλμα κατά τη δημιουργία απομακρυσμένης περιόδου λειτουργίας.  Ο απομακρυσμένος διακομιστής πιθανώς να μην απαντά σωστά ή να μην απαντά καθόλου.  Ζητήστε από το διαχειριστή του συστήματός σας να ελέγξει τις λεπτομέρειες του σφάλματος στο αρχείο καταγραφής σφαλμάτων του διακομιστή web.",
    'rsession_no_connect_errmsg' => "Δεν είναι δυνατή η πρόσβαση στην απομακρυσμένη υπηρεσία: η σύνδεση στην απομακρυσμένη περίοδο λειτουργίας απέτυχε.  Επικοινωνήστε με το διαχειριστή του συστήματος για υποστήριξη.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Να επιτρέπεται η αποστολή στον κατάλογο εισερχομένων",
    'anonftp__allow_create_dirs' => 'Να επιτρέπεται η δημιουργία καταλόγων στον κατάλογο εισερχομένων',
    'anonftp__allow_download_incoming' => 'Να επιτρέπεται η λήψη από τον κατάλογο εισερχομένων',
    'anonftp__display_login' => 'Εμφάνιση μηνύματος σύνδεσης',
    'anonftp__login_text' => 'Κείμενο μηνύματος',
    'anonftp__limit_incoming_disk_space' => "Περιορισμός χώρου στο δίσκο στον κατάλογο εισερχόμενων",
    'anonftp__limit_maximum_bandwidth' => "Περιορισμός εύρους ζώνης λήψης γι' αυτόν τον εικονικό τομέα FTP",
    'anonftp__limit_maximum_connections' => "Περιορισμός αριθμού ταυτόχρονων συνδέσεων",
    'anonftp__unable_init' => "Δεν είναι δυνατή η προετοιμασία του λογαριασμού ανώνυμου FTP: %1",
    'anonftp__unable_set_quota' => "Δεν είναι δυνατός ο καθορισμός του ορίου χώρου στο δίσκου για τον κατάλογο εισερχομένων: %1",
    'anonftp__unable_update' => "Δεν είναι δυνατή η ενημέρωση των ιδιοτήτων του λογαριασμού ανώνυμου FTP: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Πιστοποιητικά SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Το πιστοποιητικό CA δεν υπογράφει το πιστοποιητικό.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Μη συμβατό ζεύγος ιδιωτικού κλειδιού/πιστοποιητικού.",
    'class_sslcertificate__invalid_cert_format' => "Μη έγκυρη μορφή πιστοποιητικού.",
    'class_sslcertificate__invalid_private_key_format' => "Μη έγκυρη μορφή ιδιωτικού κλειδιού.",
    'class_sslcertificate__prob_invalid_priv_key' => "Η μορφή του ιδιωτικού κλειδιού πιθανώς να μην είναι έγκυρη.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Δημιουργία εικονικού καταλόγου',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Δημιουργία εικονικού καταλόγου',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Δημιουργία εικονικού καταλόγου.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Δημιουργία εικονικού καταλόγου',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Δημιουργία εικονικού καταλόγου',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Δημιουργία εικονικού καταλόγου.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Δημιουργία καταλόγου',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Δημιουργία καταλόγου',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Δημιουργία καταλόγου.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Δημιουργία καταλόγου',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Δημιουργία καταλόγου',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Δημιουργία καταλόγου.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Ιδιότητες καταλόγου',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Ιδιότητες εικονικού καταλόγου',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Προβολή και αλλαγή ιδιοτήτων εικονικού καταλόγου.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Ιδιότητες καταλόγου',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Ιδιότητες εικονικού καταλόγου',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Προβολή και αλλαγή ιδιοτήτων εικονικού καταλόγου.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Δικαιώματα πρόσβασης καταλόγου',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Δικαιώματα πρόσβασης καταλόγου',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Ρύθμιση δικαιωμάτων πρόσβασης καταλόγου.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Δικαιώματα πρόσβασης καταλόγου',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Δικαιώματα πρόσβασης καταλόγου',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Ρύθμιση δικαιωμάτων πρόσβασης καταλόγου.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Ρυθμίσεις ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'Ρυθμίσεις ASP.NET για το %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Διαμόρφωση ρυθμίσεων ASP.NET για τον εικονικό κατάλογο %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Ρυθμίσεις ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'Ρυθμίσεις ASP.NET για το %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Διαμόρφωση ρυθμίσεων ASP.NET για τον εικονικό κατάλογο %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => 'Αλλαγή έκδοσης',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => 'Αλλαγή έκδοσης',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => 'Αλλαγή έκδοσης ASP.NET που χρησιμοποιείται από τον εικονικό κατάλογο %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => 'Αλλαγή έκδοσης',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => 'Αλλαγή έκδοσης',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => 'Αλλαγή έκδοσης ASP.NET που χρησιμοποιείται από τον εικονικό κατάλογο %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'Ρυθμίσεις PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'Ρυθμίσεις PHP για το %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Διαμόρφωση ρυθμίσεων PHP για τον εικονικό κατάλογο %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'Ρυθμίσεις PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Ρυθμίσεις PHP για το %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Διαμόρφωση ρυθμίσεων PHP για τον εικονικό κατάλογο %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Κατάργηση',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Κατάργηση εικονικών καταλόγων',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Κατάργηση επιλεγμένων εικονικών καταλόγων.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Κατάργηση',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Κατάργηση εικονικών καταλόγων',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Κατάργηση επιλεγμένων εικονικών καταλόγων.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Οι παρακάτω εικονικοί κατάλογοι θα καταργηθούν:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Πρέπει να επιλέξετε τους καταλόγους που θέλετε να καταργήσετε.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'Τύποι MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'Τύποι MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Προβολή λίστας καταχωρημένων τύπων MIME.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Προσθήκη τύπου MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Προσθήκη τύπου MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Δημιουργία νέου τύπου MIME.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Έγγραφα σφάλματος',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Έγγραφα σφάλματος',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Προβολή και αλλαγή των εγγράφων σφάλματος.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Προστασία',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Προστασία καταλόγου',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Περιορισμός της πρόσβασης στον κατάλογο με προστασία κωδικού πρόσβασης.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Προστασία',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Προστασία καταλόγου',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Περιορισμός της πρόσβασης στον κατάλογο με προστασία κωδικού πρόσβασης.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Ρυθμίσεις',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Προβολή της θέσης του καταλόγου και καθορισμός ενός τίτλου για την προστατευμένη περιοχή.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Προσθήκη χρήστη',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Προσθήκη λογαριασμού χρήστη για καταστεί εφικτή η πρόσβαση στον προστατευμένο κατάλογο.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Οι νέες ρυθμίσεις εφαρμόστηκαν.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Ο λογαριασμός χρήστη προστέθηκε.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Κατάργηση',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Κατάργηση χρηστών από τον προστατευμένο κατάλογο.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Κατάργηση λογαριασμών χρηστών',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Επιβεβαίωση κατάργησης λογαριασμών χρηστών.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Οι λογαριασμοί χρηστών καταργηθήκαν.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // non-UI
    'check_permissions_done' => 'Η διαδικασία ελέγχου δικαιωμάτων ξεκίνησε.  Κατά την ολοκλήρωση της διαδικασίας ελέγχου θα αποσταλεί μια ειδοποίηση στην εξής διεύθυνση ηλεκτρονικού ταχυδρομείου: %1', // PFW
    'additional_keys__install_done' => 'Η εγκατάσταση του κλειδιού άδειας χρήσης ξεκίνησε.',

    // UI
    'ui____done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__actionlog__done' => "Οι αλλαγές στις ρυθμίσεις αρχείου καταγραφής ενεργειών δεν αποθηκεύτηκαν.",
    'ui__admin/extras-domain__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__admin/interface__done' => 'Οι αλλαγές στις προτιμήσεις περιβάλλοντος εργασίας διαχειριστή του διακομιστή αποθηκεύτηκαν.',
    'ui__admin/report/layout/delete_multi__done' => 'Οι επιλεγμένες διατάξεις αναφοράς καταργήθηκαν.',
    'ui__admin/report/traffic-history__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__admin/report__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__admin-alias/delete_multi__done' => "Οι επιλεγμένοι πρόσθετοι λογαριασμοί διαχειριστή καταργήθηκαν.",
    'ui__admin-alias/properties__done' => "Οι ιδιότητες του πρόσθετου λογαριασμού διαχειριστή ενημερώθηκαν.",
    'ui__admin-alias/properties_new__done' => "Ο πρόσθετος λογαριασμός διαχειριστή δημιουργήθηκε.",
    'ui__admin-alias/properties_unknown__done' => "Οι ιδιότητες του πρόσθετου λογαριασμού διαχειριστή ενημερώθηκαν.",
    'ui__admin-alias__done' => "Οι πληροφορίες του πρόσθετου λογαριασμού διαχειριστή ενημερώθηκαν με επιτυχία.",
    'ui__admin/manage-domain__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__admin/register-domain__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Τα επιλεγμένα χρονοδιαγράμματα παράδοσης αναφορών καταργήθηκαν.',
    'ui__admin/report/layout/auto/properties__done' => 'Το χρονοδιάγραμμα παράδοσης αναφοράς ενημερώθηκε.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Το χρονοδιάγραμμα παράδοσης αναφοράς δημιουργήθηκε.',
    'ui__admin/report/layout/properties__done' => 'Η διάταξη αναφοράς %1 ενημερώθηκε.',
    'ui__admin/report/layout/properties_new__done' => 'Η διάταξη αναφοράς %1 δημιουργήθηκε.',
    'ui__client/chowner__done' => 'Ορίστηκε νέος κάτοχος για το λογαριασμό του πελάτη %1.',
    'ui__client/chowner_multi__done' => "Οι επιλεγμένοι λογαριασμοί χρηστών μεταβιβάστηκαν σε άλλον κάτοχο.",
    'ui__client/chowner_multi-select__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/chowner_select__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/certificate/properties__done' => 'Οι ιδιότητες του πιστοποιητικού SSL/TLS ενημερώθηκαν.',
    'ui__client/domain/certificate/properties_new__done' => 'Το νέο πιστοποιητικό SSL/TLS προστέθηκε. Για να λειτουργήσει, πρέπει να το επιλέξετε στις ρυθμίσεις φιλοξενίας τοποθεσιών web (στην καρτέλα Τοποθεσίες Web & Τομείς> όνομα τομέα).',
    'ui__client/domain/certificate__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/certificate_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/check-permissions_multi__done' => 'Ο έλεγχος δικαιωμάτων τους για επιλεγμένους τομείς ολοκληρώθηκε.', // PFW
    'ui__client/domain/chowner__done' => 'Η συνδρομή %1 ανήκει πλέον σε άλλο χρήστη.',
    'ui__client/domain/chowner_multi__done' => 'Η κυριότητα της συνδρομής άλλαξε.',
    'ui__client/domain/chowner_multi-select__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/chowner_select__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/dbbackup/create__done' => "Το αντίγραφο ασφαλείας της βάσης δεδομένων δημιουργήθηκε με επιτυχία.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Το αντίγραφο ασφαλείας της βάσης δεδομένων δημιουργήθηκε με επιτυχία.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Ο ορφανός χρήστης διορθώθηκε με επιτυχία.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Τα αρχεία αντιγράφων ασφαλείας καταργήθηκαν με επιτυχία.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Η επαναφορά του περιεχομένου της βάσης δεδομένων ολοκληρώθηκε με επιτυχία.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.", // PFW
    'ui__client/domain/dbbackup__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.", // PFW
    'ui__client/domain/delete__done' => "Ο τομέας %1 καταργήθηκε.",
    'ui__client/domain/delete_multi__done' => "Οι τομείς καταργήθηκαν.",
    'ui__client/domain/disable__done' => 'Ο τομέας %1 ανεστάλη.',
    'ui__client/domain/disable_multi__done' => 'Οι επιλεγμένοι τομείς ανεστάλησαν.',
    'ui__client/domain/enable__done' => 'Η τοποθεσία web %1 ενεργοποιήθηκε.',
    'ui__client/domain/enable_multi__done' => 'Οι επιλεγμένες τοποθεσίες web ενεργοποιήθηκαν.',
    'ui__client/domain/extras__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/domain/extras_self__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/domain/hosting/file-manager/copy-move__done' => 'Τα επιλεγμένα αρχεία και οι κατάλογοι έχουν αντιγραφεί ή μετακινηθεί.',
    'ui__client/domain/hosting/file-manager/create-dir__done' => 'Ο κατάλογος δημιουργήθηκε.',
    'ui__client/domain/hosting/file-manager/create-file__done' => 'Το αρχείο δημιουργήθηκε.',
    'ui__client/domain/hosting/file-manager/edit__done' => 'Το αρχείο ενημερώθηκε.',
    'ui__client/domain/hosting/file-manager/permissions__done' => 'Τα δικαιώματα πρόσβασης στο αρχείο ή τον κατάλογο ενημερώθηκαν.', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => 'Ο κατάλογος ή το αρχείο μετονομάστηκε.',
    'ui__client/domain/hosting/file-manager/remove__done' => 'Τα επιλεγμένα αρχεία και οι κατάλογοι καταργήθηκαν.',
    'ui__client/domain/hosting/file-manager/remove_self__done' => 'Τα επιλεγμένα αρχεία και οι κατάλογοι καταργήθηκαν.',
    'ui__client/domain/hosting/file-manager/view__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/hosting/file-manager__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/hosting/file-manager_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/hosting/hotlink-protection__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => 'Οι ρυθμίσεις ανακύκλωσης αρχείων καταγραφής άλλαξαν.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Οι ρυθμίσεις ανακύκλωσης αρχείων καταγραφής άλλαξαν.',
    'ui__client/domain/hosting/logs__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/hosting/logs_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/hosting/performance__done' => 'Οι ρυθμίσεις απόδοσης φιλοξενίας για την τοποθεσία web %1 προσαρμόστηκαν.',
    'ui__client/domain/hosting/performance_self__done' => 'Οι ρυθμίσεις απόδοσης φιλοξενίας για την τοποθεσία web σας προσαρμόστηκαν.',
    'ui__client/domain/hosting/performance_unknown__done' => 'Οι ρυθμίσεις απόδοσης φιλοξενίας περιεχομένου web προσαρμόστηκαν.',
    'ui__client/domain/hosting/php__done' => 'Οι ρυθμίσεις PHP άλλαξαν.', // PFW
    'ui__client/domain/hosting/php_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/hosting/protected-directories__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/hosting/setup__done' => 'Η φιλοξενία για το %1 διαμορφώθηκε.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFU
    'ui__client/domain/hosting/tsclient__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/hosting/tsclient_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/hosting/virtual-directories__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'Η έκδοση ASP.NET άλλαξε.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'Οι ρυθμίσεις ASP.NET για το %1 άλλαξαν.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Δημιουργήθηκε εικονικός κατάλογος στην τοποθεσία web %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Ο εικονικός κατάλογος δημιουργήθηκε.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Οι επιλεγμένα κατάλογοι καταργήθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Οι επιλεγμένα κατάλογοι καταργήθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Τα προσαρμοσμένα έγγραφα σφάλματος ενημερώθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Οι επιλεγμένοι τύποι MIME καταργήθηκαν', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Ο νέος τύπος MIME καταχωρήθηκε.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Τα δικαιώματα πρόσβασης καταλόγου ενημερώθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Τα δικαιώματα πρόσβασης καταλόγου ενημερώθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'Οι ρυθμίσεις PHP για το %1 ενημερώθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'Οι ρυθμίσεις PHP για το %1 ενημερώθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Οι ιδιότητες του καταλόγου ενημερώθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Οι ιδιότητες του καταλόγου ενημερώθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Οι ρυθμίσεις προστασίας καταλόγου ενημερώθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Οι ρυθμίσεις προστασίας καταλόγου ενημερώθηκαν.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Πιστοποιητικά SSL/TLS που διατίθενται στο ηλεκτρονικό κατάστημα',
    'ui__client/domain/mpc-certificates_self__done' => 'Πιστοποιητικά SSL/TLS που διατίθενται στο ηλεκτρονικό κατάστημα',
    'ui__client/domain/odbc__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/odbc_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFW
    'ui__client/domain/properties__done' => "Ο λογαριασμός διαχειριστή τομέα άλλαξε.",
    'ui__client/domain/properties_new__done' => "Ο τομέας %1 δημιουργήθηκε.",
    'ui__client/domain/properties_self__done' => "Οι ιδιότητες του τομέα σας άλλαξαν.",
    'ui__client/domain/register__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/domain/register_self__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/domain/rename__done' => 'Το όνομα τομέα άλλαξε.',
    'ui__client/domain/rename_self__done' => "Το όνομα τομέα άλλαξε με επιτυχία.",
    'ui__client/domain/report/anon-ftp-stats__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/report/ftp-stats__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/report/ftp-stats_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/report/traffic-history__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/report/traffic-history_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/report/webalizer-preferences__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFU
    'ui__client/domain/report/webalizer-preferences_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFU
    'ui__client/domain/report/web-stats__done' => 'Η σελίδα στατιστικών στοιχείων web άνοιξε.',
    'ui__client/domain/report/web-stats_self__done' => 'Η σελίδα στατιστικών στοιχείων web άνοιξε.',
    'ui__client/domain/report/web-stats-ssl__done' => 'Η σελίδα στατιστικών στοιχείων web άνοιξε.',
    'ui__client/domain/report/web-stats-ssl_self__done' => 'Η σελίδα στατιστικών στοιχείων web άνοιξε.',
    'ui__client/domain/report__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/report_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/settings_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/to-client__done' => 'Ο λογαριασμός διαχειριστή τομέα %1 μετατράπηκε σε λογαριασμό πελάτη.',
    'ui__client/domain/to-client_multi__done' => 'Οι λογαριασμοί διαχειριστή τομέα μετατράπηκαν σε λογαριασμούς πελατών.',
    'ui__client/domain/toggle_disable__done' => "Ο τομέας %1 ανεστάλη.",
    'ui__client/domain/toggle_enable__done' => "Ο τομέας %1 ενεργοποιήθηκε.",
    'ui__client/domain/traffic__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/traffic_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/traffic_unknown__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/web-stats__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain-summary-report__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain-summary-report_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain-summary-report_unknown__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/extras-domain__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/extras-domain_self__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/ipaddress/delete_multi__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/ipaddress/properties__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/ipaddress/properties_new__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/ip-pool/properties__done' => "Ο χώρος IP του πελάτη %1 ενημερώθηκε.",
    'ui__client/ip-pool/properties_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/limits__done' => "Τα όρια πόρων για τον πελάτη %1 άλλαξαν.",
    'ui__client/limits_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/logo__done' => 'Οι ρυθμίσεις εμπορικής ταυτότητας για τον πελάτη %1 εφαρμόστηκαν.',
    'ui__client/logo_reseller__done' => 'Οι νέες ρυθμίσεις εμπορικής ταυτότητας του Plesk εφαρμόστηκαν.',
    'ui__client/logo_self__done' => 'Οι ρυθμίσεις εμπορικής ταυτότητας εφαρμόστηκαν.',
    'ui__client/logo_self-reseller__done' => 'Οι ρυθμίσεις εμπορικής ταυτότητάς σας εφαρμόστηκαν στο Plesk.',
    'ui__client/manage-domain__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/manage-domain_self__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/permissions__done' => "Τα δικαιώματα του πελάτη %1 άλλαξαν.",
    'ui__client/permissions_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/preferences__done' => "Οι προτιμήσεις για τον πελάτη %1 άλλαξαν.",
    'ui__client/preferences_self__done' => "Οι προτιμήσεις σας άλλαξαν.",
    'ui__client/register-domain__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/register-domain_self__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__client/report/traffic-history__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/report/traffic-history_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/report__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/report_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/sessions/delete__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/sessions/delete_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/sessions__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/sessions_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/skeleton__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/skeleton_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__client/to-reseller__done' => 'Ο λογαριασμός πελάτη %1 μετατράπηκε σε λογαριασμό μεταπωλητή.',
    'ui__client/to-reseller_multi__done' => "Οι επιλεγμένοι λογαριασμοί πελατών μετατράπηκαν σε λογαριασμούς μεταπωλητών.",
    'ui__client/traffic__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__client/traffic_unknown__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__cp-access__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__cp-session/properties__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__cp-session__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__ftp-sessions__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__license__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__logo__done' => "Οι ιδιότητες εμπορικής ταυτότητας του Plesk άλλαξαν.",
    'ui__longtasks/longtask/properties__done' => "Οι ρυθμίσεις εργασιών παρασκηνίου άλλαξαν με επιτυχία.",
    'ui__mass-email/delete__done' => "Το πρότυπο μηνύματος %1 καταργήθηκε.", // PFW
    'ui__mass-email/delete_multi__done' => "Τα πρότυπα μηνυμάτων καταργήθηκαν.",  // PFW
    'ui__mass-email/send_main__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Οι λογαριασμοί πελατών επιλέχθηκαν με επιτυχία.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Οι λογαριασμοί διαχειριστή τομέα επιλέχθηκαν με επιτυχία.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Οι λογαριασμοί μεταπωλητών επιλέχθηκαν με επιτυχία.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Οι αλλαγές στο πρότυπο μηνύματος μαζικής αλληλογραφίας αποθηκεύτηκαν.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Το πρότυπο μηνύματος μαζικής αλληλογραφίας δημιουργήθηκε.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Επιλέχθηκαν οι λογαριασμοί πελατών για το πρότυπο μηνύματος μαζικής αλληλογραφίας.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Επιλέχθηκαν οι λογαριασμοί διαχειριστή τομέα για το πρότυπο μηνύματος μαζικής αλληλογραφίας.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Επιλέχθηκαν οι λογαριασμοί μεταπωλητών για το πρότυπο μηνύματος μαζικής αλληλογραφίας.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Το πρότυπο μηνύματος μαζικής αλληλογραφία άλλαξε.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Καθορίστηκαν μη έγκυρες τιμές.', // PFW
    'ui__mass-email__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.", // PFW
    'ui__mass-mail__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.", // PFU
    'ui__mass-mail/delete__done' => 'Το πρότυπο μηνύματος %1 καταργήθηκε.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Τα πρότυπα μηνυμάτων καταργήθηκαν.', // PFU
    'ui__mass-mail/properties__done' => 'Το πρότυπο %1 άλλαξε.', // PFU
    'ui__mass-mail/properties_new__done' => 'Το πρότυπο %1 δημιουργήθηκε.', // PFU
    'ui__mass-mail/send__done' => 'Τα μηνύματα εστάλησαν.', // PFU
    'ui__mass-mail/send_new__done' => 'Τα μηνύματα εστάλησαν.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Τα μηνύματα εστάλησαν.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Τα μηνύματα εστάλησαν.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Το νέο πρότυπο μηνύματος δημιουργήθηκε.', // PFU
    'ui__mass-mail/template/properties__done' => 'Το πρότυπο μηνύματος άλλαξε.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Οι νέες ρυθμίσεις παρακολούθησης δίσκου εφαρμόστηκαν.', // PFU
    'ui__modules__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__modules__short-title' => 'Επεκτάσεις',
    'ui__modules__title' => 'Επεκτάσεις',
    'ui__reseller/client/chowner_multi__done' => 'Οι επιλεγμένοι λογαριασμοί πελατών μεταβιβάστηκαν σε άλλον κάτοχο.',
    'ui__reseller/client/chowner_multi-select__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/client/traffic_unknown__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/extras-domain__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__reseller/extras-domain_self__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__reseller/ftp-sessions_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/limits__done' => "Άλλαξαν τα όρια και οι πολιτικές χρήσης πόρων του μεταπωλητή.",
    'ui__reseller/limits_readonly-self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/limits_self__done' => 'Άλλαξαν τα όρια και οι πολιτικές χρήσης πόρων σας.',
    'ui__reseller/manage-domain__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__reseller/manage-domain_self__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__reseller/permissions__done' => 'Τα δικαιώματα του μεταπωλητή %1 άλλαξαν.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/register-domain__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__reseller/register-domain_self__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Τα επιλεγμένα χρονοδιαγράμματα παράδοσης αναφορών καταργήθηκαν.',
    'ui__reseller/report/layout/auto/properties__done' => 'Το χρονοδιάγραμμα παράδοσης αναφοράς ενημερώθηκε.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Το χρονοδιάγραμμα παράδοσης αναφοράς προστέθηκε.',
    'ui__reseller/report/layout/properties__done' => 'Η διάταξη αναφοράς άλλαξε.',
    'ui__reseller/report/layout/properties_new__done' => 'Η νέα διάταξη αναφοράς δημιουργήθηκε.',
    'ui__reseller/report/traffic-history__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/report/traffic-history_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/report__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/report_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/sessions/delete__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία',
    'ui__reseller/sessions/delete_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία',
    'ui__reseller/sessions__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/sessions_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/to-client__done' => 'Ο λογαριασμός μεταπωλητή %1 μετατράπηκε σε λογαριασμό πελάτη.',
    'ui__reseller/to-client_multi__done' => "Οι επιλεγμένοι λογαριασμοί μεταπωλητών μετατράπηκαν σε λογαριασμούς πελατών.",
    'ui__reseller/traffic__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/traffic_self__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/traffic_unknown__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__reseller/logo_self__title' => 'Εμπορική ταυτότητα Plesk',
    'ui__reseller/logo_self__done' => 'Οι ρυθμίσεις εμπορικής ταυτότητάς σας εφαρμόστηκαν στο Plesk.',
    'ui__server/aspdotnet__done' => 'Οι ρυθμίσεις ASP.NET σε επίπεδο διακομιστή άλλαξαν.', // PFW
    'ui__server/certificate/default_multi__done' => 'Το επιλεγμένο πιστοποιητικό SSL/TLS ορίστηκε για να χρησιμοποιείται για την ασφάλιση των συνδέσεων προς τις νέες τοποθεσίες web που φιλοξενούνται.',
    'ui__server/certificate/delete_multi__done' => 'Τα επιλεγμένα πιστοποιητικά SSL/TLS καταργήθηκαν.',
    'ui__server/certificate/download__done' => 'Η λήψη του πιστοποιητικού SSL/TLS ολοκληρώθηκε.',
    'ui__server/certificate/properties__done' => 'Οι ιδιότητες του πιστοποιητικού SSL/TLS ενημερώθηκαν.',
    'ui__server/certificate/properties_new__done' => 'Το πιστοποιητικό SSL/TLS %1 δημιουργήθηκε.',
    'ui__server/certificate/setup_multi__done' => 'Το επιλεγμένο πιστοποιητικό SSL/TLS ορίστηκε για να χρησιμοποιείται για την ασφάλιση των συνδέσεων προς το Plesk.',
    'ui__server/certificate__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/components__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/cp-certificate-download__done' => "Η λήψη του πιστοποιητικού SSL/TLS του Plesk ολοκληρώθηκε.",
    'ui__server/crontab/properties__done' => 'Οι προγραμματισμένες εργασίες του %1 άλλαξαν.',
    'ui__server/crontab/task/delete__done' => 'Η εργασία καταργήθηκε.',
    'ui__server/crontab/task/delete_multi__done' => 'Οι εργασίες καταργήθηκαν.',
    'ui__server/crontab/task/properties__done' => 'Οι προγραμματισμένες εργασίες ενημερώθηκαν.',
    'ui__server/crontab/task/properties_new__done' => 'Η νέα εργασία προγραμματίστηκε.',
    'ui__server/crontab/task/toggle_disable__done' => 'Η προγραμματισμένη εργασία %1 ήταν απενεργοποιημένη.',
    'ui__server/crontab/task/toggle_enable__done' => 'Η προγραμματισμένη εργασία %1 ήταν ενεργοποιημένη.',
    'ui__server/crontab__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/db__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/dns__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/ftp-settings__done' => "Οι ρυθμίσεις FTP άλλαξαν με επιτυχία.",
    'ui__server/ip-address/client/delete__done' => "Η διεύθυνση IP καταργήθηκε από το χώρο IP του χρήστη.",
    'ui__server/ip-address/client/delete_multi__done' => "Η διεύθυνση IP καταργήθηκε από τους χώρους IP των χρηστών.",
    'ui__server/ip-address/client/properties_new__done' => 'Η διεύθυνση IP εκχωρήθηκε στους χρήστες.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'Η διεύθυνση IP %1 εκχωρήθηκε στους επιλεγμένους πελάτες.',
    'ui__server/ip-addresses__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__server/mail/statistics/spam/recipients__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__server/mail/statistics/spam/summary__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__server/mail/statistics/spam__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__server/mail/statistics/virus/recipients__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__server/mail/statistics/virus/summary__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__server/mail/statistics/virus/viruses__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__server/mail/statistics/virus__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__server/mail/statistics__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__server/mail__done' => 'Οι ρυθμίσεις διακομιστή αλληλογραφίας άλλαξαν.',
    'ui__server/maillists__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/mpc-certificates__done' => 'Άνοιξε η σελίδα του ηλεκτρονικού καταστήματος με τα διαθέσιμα πιστοποιητικά SSL/TLS.',
    'ui__server/odbc__done' => 'Οι ρυθμίσεις ODBC σε επίπεδο διακομιστή άλλαξαν.', // PFW
    'ui__server/pmm__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/preferences__done' => "Οι ρυθμίσεις διακομιστή άλλαξαν.",
    'ui__server/register__done' => 'Η σελίδα MyPlesk.com άνοιξε.',
    'ui__server/resources__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/services__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/sitebuilder__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/skeleton__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Η διεύθυνση %1 καταργήθηκε από τη μαύρη λίστα σε επίπεδο διακομιστή.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Οι διευθύνσεις καταργήθηκαν από τη μαύρη λίστα σε επίπεδο διακομιστή.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Οι διευθύνσεις προστέθηκαν στη μαύρη λίστα.',
    'ui__server/spam-filter/black-list/address__done' => 'Οι διευθύνσεις προστέθηκαν στη μαύρη λίστα.',
    'ui__server/spam-filter/black-list__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFU
    'ui__server/spam-filter/properties__done' => 'Οι ρυθμίσεις φίλτρου ανεπιθύμητης αλληλογραφίας άλλαξαν.',
    'ui__server/spam-filter/toggle_disable__done' => 'Το φιλτράρισμα ανεπιθύμητης αλληλογραφίας απενεργοποιήθηκε σε ολόκληρο το σύστημα.',
    'ui__server/spam-filter/toggle_enable__done' => 'Το φιλτράρισμα ανεπιθύμητης αλληλογραφίας ενεργοποιήθηκε σε ολόκληρο το σύστημα.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Η διεύθυνση %1 καταργήθηκε από τη λίστα επιτρεπόμενων σε επίπεδο διακομιστή.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Οι διευθύνσεις καταργήθηκαν από τη λίστα επιτρεπόμενων σε επίπεδο διακομιστή.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Οι διευθύνσεις προστέθηκαν στη λίστα επιτρεπόμενων.',
    'ui__server/spam-filter/white-list/address__done' => 'Οι διευθύνσεις προστέθηκαν στη λίστα επιτρεπόμενων.',
    'ui__server/spam-filter/white-list__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.', // PFU
    'ui__server/spam-filter__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/statistics__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__server/time__done' => "Η ημερομηνία και η ώρα του συστήματος άλλαξαν.",
    'ui__server/tsclient__done' => 'Η περίοδος λειτουργίας της απομακρυσμένης επιφάνειας εργασίας ξεκίνησε.', // PFW
    'ui__server__done' => "Η λειτουργία ολοκληρώθηκε με επιτυχία.",
    'ui__sessions/properties__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__sessions__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__sessions/delete__done' => 'Οι επιλεγμένοι περίοδοι λειτουργίας διαγράφηκαν.',
    'ui__start-page__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',
    'ui__support__done' => 'Η φόρμα αίτησης βοήθειας άνοιξε σε νέο παράθυρο ή καρτέλα του προγράμματος περιήγησης.',
    'ui__ts-sessions__done' => 'Η λειτουργία ολοκληρώθηκε με επιτυχία.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Δεν υπάρχουν αρχεία για αποστολή.',
    'login_up__access_denied_no_permission' => "Δεν επιτρέπεται η πρόσβαση.  Δεν έχετε δικαίωμα σύνδεσης.",
    'mail__unable_remove_pattern' => "Δεν ήταν δυνατή η κατάργηση της διεύθυνσης από τη μαύρη λίστα του διακομιστή: %1", // PFW
    'mail__incorrect_network_format' => 'Λανθασμένη μορφή δικτύου: %1', // PFW
    'dbbackup__new_remote_backup_available' => 'Αυτός ο διακομιστής βάσεων δεδομένων MS SQL λειτουργεί πλέον σε απομακρυσμένο κεντρικό υπολογιστή. Για να έχετε τη δυνατότητα εισαγωγής και εξαγωγής βάσεων δεδομένων χρησιμοποιώντας εγγενή αρχεία ένδειξης σφαλμάτων βάσεων δεδομένων, πρέπει να ορίσετε τις σωστές ρυθμίσεις αντιγράφων ασφαλείας για τον συγκεκριμένο διακομιστή βάσεων δεδομένων.', // PFW
    'dbbackup__local_to_remote_backup_available' => 'Αυτός ο διακομιστής βάσεων δεδομένων MS SQL λειτουργεί πλέον σε απομακρυσμένο κεντρικό υπολογιστή.  Μπορείτε να καθορίσετε τις ρυθμίσεις δημιουργίας αντιγράφων ασφαλείας γι\' αυτόν το διακομιστή βάσεων δεδομένων στη σελίδα %1 του.', // PFW
    'initconf__unable_change_passwd' => "Δεν είναι δυνατή η αλλαγή του κωδικού πρόσβασης διαχειριστή: %1",
    'initconf__unable_get_passwd' => 'Δεν είναι δυνατή η λήψη του τρέχοντος κωδικού πρόσβασης διαχειριστή: %1 απέτυχε: %2',
    'initconf__invalid_hostname' => 'Σφάλμα στο όνομα κεντρικού υπολογιστή "%1"',
    'initconf__unable_reconfig' => 'Δεν είναι δυνατή η ρύθμιση παραμέτρων του Plesk: reconfig απέτυχε: %1',
    'initconf__unable_update_admin' => 'Δεν είναι δυνατή η ενημέρωση των στοιχείων επικοινωνίας του διαχειριστή: %1',
    '__refresh' => 'Ανανέωση',
    '__dalias_not_exist' => 'Το ψευδώνυμο τομέα δεν υπάρχει.',
    '__bug146523_explanation' => 'Στις προηγούμενες εκδόσεις του Plesk επιτρεπόταν η χρήση έως και 16 χαρακτήρων για τα ονόματα χρηστών FTP. Αυτή η έκδοση του Plesk περιορίζει το μέγιστο αριθμό χαρακτήρων που επιτρέπονται στα ονόματα χρηστών FTP σε 15. Για να επιλύσετε αυτό το ζήτημα, μειώστε το μήκος των προβληματικών ονομάτων χρηστών FTP στους 15 χαρακτήρες και αλλάξτε τουλάχιστον έναν χαρακτήρα στα προβληματικά ονόματα χρηστών FTP για να αποφύγετε προβλήματα διένεξης. Ζητούμε συγνώμη για την ταλαιπωρία που ενδεχομένως σας προκαλέσαμε με την αλλαγή αυτή.',
    'domain__cannot_change_webmail' => 'Δεν είναι δυνατή η αλλαγή του webmail για τον τομέα: %1',
    'sb_publish_disable_warning' => 'Εάν απενεργοποιήσετε τη λειτουργία δημιουργίας τοποθεσιών web με το Presence Builder, οι τοποθεσίες web που έχουν δημιουργηθεί προηγουμένως στο Presence Builder θα καταργηθούν και όλα τα δεδομένα τους θα χαθούν.  Κάντε κλικ στο OK αν θέλετε να συνεχίσετε.',
    '__sbnet_client_use_sbnet' => "Δημιουργία αντίστοιχου λογαριασμού χρήστη στο Presence Builder",
    'mail_resp_activate' => 'Ενεργοποίηση αυτόματης απάντησης',
    'limitsManger__limit_available_error' => 'Δεν είναι δυνατή η εκχώρηση της απαιτούμενης ποσότητας πόρων ("%%limitName%%"): ο λογαριασμός διαθέτει μόνο %%available%%.',
    'limitsManger__limit_reserved_error' => 'Δεν είναι δυνατή η εκχώρηση λιγότερων πόρων ("%%limitName%%") από όσους χρησιμοποιούνται ήδη.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Δεν είναι δυνατή η μετονομασία του τομέα: Υπάρχει ήδη ένας εικονικός κατάλογος με το καθορισμένο όνομα.',
    'domain_unable_to_rename' => 'Δεν είναι δυνατή η μετονομασία του τομέα.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Γενικά',
    'spamfilter__spamassassin_status_legend' => 'Φιλτράρισμα ανεπιθύμητης αλληλογραφίας SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Ρυθμίσεις SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Ενεργοποίηση φιλτραρίσματος ανεπιθύμητης αλληλογραφίας μέσω του SpamAssassin σε επίπεδο διακομιστή",
    'spamfilter__spamassassin_user_status_legend' => 'Ενεργοποίηση φιλτραρίσματος ανεπιθύμητης αλληλογραφίας μέσω του SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Ενεργοποίηση της προστασίας από ανεπιθύμητη αλληλογραφία μέσω της προσωρινής απόρριψης μηνυμάτων (greylisting) σε επίπεδο διακομιστή',
    'spamfilter__personal_settings_not_allowed' => 'Η χρήση μεμονωμένων ρυθμίσεων φιλτραρίσματος ανεπιθύμητης αλληλογραφίας δεν επιτρέπεται από την πολιτική του συστήματος.',
    'spamfilter__required_score' => 'Βαθμολογία που πρέπει να λάβει ένα μήνυμα για να χαρακτηριστεί ως ανεπιθύμητο',
    'spamfilter__rewrite_header_subject' => 'Να προστίθεται το ακόλουθο κείμενο στην αρχή του θέματος κάθε μηνύματος που χαρακτηρίζεται ως ανεπιθύμητο',
    'spamfilter__use_mailuser_prefs' => 'Εφαρμογή μεμονωμένων ρυθμίσεων στο φιλτράρισμα ανεπιθύμητης αλληλογραφίας',
    'spamfilter_addresses__text_hint' => 'Ξεχωρίστε τις πολλαπλές διευθύνσεις με νέα γραμμή, κενό, χαρακτήρα στηλοθέτη, κόμμα ή ερωτηματικό.  Δεν πρέπει να υπάρχουν μη ASCII χαρακτήρες αριστερά του συμβόλου @.  Οι διευθύνσεις μπορούν να περιέχουν τους χαρακτήρες μπαλαντέρ "*" και "?" (για παράδειγμα, *@domain.com, user?@*.com).  Τα μη-ASCII τμήματα των ονομάτων τομέα δεν πρέπει να περιέχουν χαρακτήρες μπαλαντέρ.',
    'spamfilter__spamassassin__antivirus_settings_legend' => 'Χρήση ρυθμίσεων σε επίπεδο διακομιστή',
    'spamfilter__antivirus_use_mailuser_prefs' => 'Να επιτρέπονται οι προσωπικές ρυθμίσεις',
    'spamfilter__score_error' => 'Η βαθμολογία δεν πρέπει να είναι αρνητική, το τμήμα πριν την υποδιαστολή πρέπει να είναι μικρότερο από 100 και μπορεί να περιλαμβάνει έως και δύο ψηφία μετά την υποδιαστολή.',
    'spamfilter__rewrite_header_error' => 'Το θέμα του μηνύματος μπορεί να περιέχει οποιονδήποτε εκτυπώσιμο χαρακτήρα εκτός από το σύμβολο αριθμού (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Αναπήδηση',
    'nonexistent_mail__mode_discard' => 'Απόρριψη',
    'nonexistent_mail__mode_catch_addr' => 'Προώθηση στη διεύθυνση ηλεκτρονικού ταχυδρομείου',
    'nonexistent_mail__mode_catch_ip' => 'Προώθηση σε IP',
    'nonexistent_mail__bounce_not_supported' => 'Η λειτουργία αναπήδησης δεν υποστηρίζεται',
    'nonexistent_mail__discard_not_supported' => 'Η λειτουργία απόρριψης δεν υποστηρίζεται',
    'nonexistent_mail__catch_not_supported' => 'Η προώθηση σε διεύθυνση ηλεκτρονικού ταχυδρομείου δεν υποστηρίζεται',
    'nonexistent_mail__redirect_not_supported' => 'Η προώθηση σε IP δεν υποστηρίζεται',
    'nonexistent_mail__ip_used_on_this_host' => 'Η διεύθυνση IP αναλύεται σε localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Επειδή ο έλεγχος εξερχόμενης αλληλογραφίας είναι ενεργοποιημένος, η διεύθυνση ηλεκτρονικού ταχυδρομείου %1 για μη υπαρκτούς παραλήπτες πρέπει να ανήκει στον επιλεγμένο τομέα. Εάν δεν ισχύει αυτό, τότε θα εφαρμοστεί η πολιτική "Reject" αντί της προώθησης.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Εφόσον ο έλεγχος εξερχόμενης αλληλογραφίας είναι ενεργοποιημένος, η διεύθυνση ηλεκτρονικού ταχυδρομείου που ορίζεται για την προώθηση αλληλογραφίας (%1) πρέπει να ανήκει στον επιλεγμένο τομέα. Εάν δεν ισχύει αυτό, τότε τα μηνύματα που αποστέλλονται σε αυτήν τη διεύθυνση δεν θα προσμετρώνται στον έλεγχο εξερχόμενης αλληλογραφίας.',
    // mail acc extras
    '__antivirus' => "Προστασία από ιούς",

    // additional keys
    'additional_keys__select_to_install' => 'Δεν έχουν επιλεγεί κλειδιά.  Επιλέξτε τα κλειδιά που θέλετε να εγκαταστήσετε.',
    'additional_key_update__title' => "Ενημέρωση πρόσθετου κλειδιού",
    'additional_key_update__legend' => "Κατάσταση ενημέρωσης πρόσθετου κλειδιού",
    'additional_key_update__new_key' => "Ιδιότητες πρόσθετου κλειδιού",
    'bt_additional_key_install' => "Εγκατάσταση κλειδιού",
    'b_additional_key_install' => 'Κάντε κλικ για να εγκαταστήσετε το τρέχον κλειδί άδειας χρήσης.',
    'bt_additional_key_update' => "Ανάκτηση πρόσθετου κλειδιού",
    'bt_additional_key_revert' => "Επαναφορά κλειδιού",
    'b_additional_key_upload' => 'Αποστολή νέου κλειδιού άδειας χρήσης.',
    'b_additional_key_download' => 'Λήψη του τρέχοντος κλειδιού άδειας χρήσης.',
    'b_additional_key_remove' => 'Κατάργηση του τρέχοντος κλειδιού άδειας χρήσης.',
    'b_additionalkeyslist_install' => 'Εγκατάσταση επιλεγμένων κλειδιών άδειας χρήσης.',

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Δεν υπάρχουν διαθέσιμοι πρόσθετοι λογαριασμοί διαχειριστή.', // PFW
    'ui__client/domain/certificate__none-available' => 'Ο πελάτης δεν διαθέτει πιστοποιητικά SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'Ο πελάτης δεν διαθέτει τομείς με πιστοποιητικά SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'Ο τομέας δεν διαθέτει πιστοποιητικά SSL/TLS.',
    'ui__reseller/client__none-available' => 'Δεν υπάρχουν μεταπωλητές με πελάτες.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Πρέπει να επιλέξετε τις διευθύνσεις IP που θέλετε να καταργήσετε από το χώρο IP.',
    'ui__reseller/client/chowner__empty_selection' => 'Πρέπει να επιλέξετε τους λογαριασμούς πελατών στους οποίους θέλετε να ορίσετε νέο κάτοχο.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Πρέπει να επιλέξετε τους λογαριασμούς μεταπωλητών από τους χώρους IP των οποίων θέλετε να ανακαλέσετε μια διεύθυνση IP.',
    'ui__server/crontab/task/delete__empty_selection' => 'Πρέπει να επιλέξετε την εργασία που θέλετε να καταργήσετε.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'Η υποστήριξη PHP είναι απενεργοποιημένη γι\' αυτήν την τοποθεσία web.',
    'phosting__aspdotnet_not_enabled' => 'Η υποστήριξη ASP.NET είναι απενεργοποιημένη γι\' αυτήν την τοποθεσία web.',
    'phosting__php_forced_by_site_isolation' => 'Δεν είναι δυνατή η αλλαγή των ρυθμίσεων PHP: δεν χορηγήθηκε άδεια για παράκαμψη της πολιτικής ασφάλειας σε επίπεδο διακομιστή.',
    'phosting__option_forced_by_site_isolation' => 'Δεν είναι δυνατή η αλλαγή των ρυθμίσεων %1: δεν χορηγήθηκε άδεια για παράκαμψη της πολιτικής ασφάλειας σε επίπεδο διακομιστή.',
    'phosting__mod_bw_disabled_by_vps_optimized' => 'Το mod_bw έχει απενεργοποιηθεί επειδή το Plesk λειτουργεί σε βελτιστοποιημένη κατάσταση VPS.',
    'phosting__mod_php_disabled_by_vps_optimized' => 'Το mod_php έχει απενεργοποιηθεί επειδή το Plesk λειτουργεί σε βελτιστοποιημένη κατάσταση VPS.',
    'phosting__perl_disabled_by_vps_optimized' => 'Το Perl έχει απενεργοποιηθεί επειδή το Plesk λειτουργεί σε βελτιστοποιημένη κατάσταση VPS.',
    'phosting__asp_disabled_by_vps_optimized' => 'Το ASP έχει απενεργοποιηθεί επειδή το Plesk λειτουργεί σε βελτιστοποιημένη κατάσταση VPS.',
    'phosting__python_disabled_by_vps_optimized' => 'Το Python έχει απενεργοποιηθεί επειδή το Plesk λειτουργεί σε βελτιστοποιημένη κατάσταση VPS.',
    'phosting__fastcgi_disabled_by_vps_optimized' => 'Το fastcgi έχει απενεργοποιηθεί επειδή το Plesk λειτουργεί σε βελτιστοποιημένη κατάσταση VPS.',
    'phosting__php_handler_id_not_registered' => 'Ο δείκτης χειρισμού PHP δεν επιτρέπεται στις ρυθμίσεις απομόνωσης της τοποθεσίας.  Θα χρησιμοποιηθεί ο προεπιλεγμένος δείκτης χειρισμού PHP.',
    'phosting__php_served_by_nginx_is_not_available' => 'Ο δείκτης χειρισμού PHP (Εφαρμογή FPM που εξυπηρετείται μέσω nginx) δεν επιτρέπεται στις ρυθμίσεις απομόνωσης της τοποθεσίας. Θα χρησιμοποιηθεί ο προεπιλεγμένος δείκτης χειρισμού PHP.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Προβολή της λίστας διευθύνσεων IP',
    'ui__client/ipaddress/properties_readonly__title' => 'Προβολή της λίστας διευθύνσεων IP',
    'ui__client/ipaddress/properties_readonly__description' => 'Προβολή της λίστας των διαθέσιμων διευθύνσεων IP γι\' αυτόν το χρήστη.',
    'ui__server/certificate__short-title' => 'Πιστοποιητικά SSL/TLS',
    'ui__server/certificate__title' => 'Πιστοποιητικά SSL/TLS',
    'ui__server/certificate__description' => 'Προβολή και διαχείριση πιστοποιητικών SSL/TLS.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Κατάργηση τύπων MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Κατάργηση τύπων MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Κατάργηση επιλεγμένων τύπων MIME.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Προσθήκη τύπου MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Προσθήκη τύπου MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Δημιουργία τύπου MIME.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Κατάργηση διευθύνσεων IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Επιλέξτε τις διευθύνσεις IP που θέλετε να καταργήσετε από το χώρο IP του πελάτη %1',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => 'Δημιουργία αρχείου',
    'ui__client/domain/hosting/file-manager/create-file__title' => 'Δημιουργία αρχείου',
    'ui__client/domain/hosting/file-manager/create-file__description' => 'Δημιουργία αρχείου.',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => 'Δημιουργία φακέλου',
    'ui__client/domain/hosting/file-manager/create-dir__title' => 'Δημιουργία φακέλου',
    'ui__client/domain/hosting/file-manager/create-dir__description' => 'Δημιουργία φακέλου.',
    'ui__client/domain/hosting/file-manager/edit__short-title' => 'Επεξεργασία αρχείου ή φακέλου',
    'ui__client/domain/hosting/file-manager/edit__title' => 'Επεξεργασία αρχείου ή φακέλου',
    'ui__client/domain/hosting/file-manager/edit__description' => 'Επεξεργασία του επιλεγμένου αρχείου ή φακέλου.',
    'ui__client/domain/hosting/file-manager/rename__short-title' => 'Μετονομασία αρχείου ή φακέλου',
    'ui__client/domain/hosting/file-manager/rename__title' => 'Μετονομασία αρχείου ή φακέλου',
    'ui__client/domain/hosting/file-manager/rename__description' => 'Μετονομάστε το επιλεγμένο αρχείο ή φάκελο.',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => 'Αλλαγή δικαιωμάτων',
    'ui__client/domain/hosting/file-manager/permissions__title' => 'Αλλαγή δικαιωμάτων',
    'ui__client/domain/hosting/file-manager/permissions__description' => 'Αλλαγή δικαιωμάτων πρόσβασης για ένα αρχείο ή φάκελο.',
    'ui__client/domain/hosting/file-manager/remove__short-title' => 'Κατάργηση αρχείου ή φακέλου',
    'ui__client/domain/hosting/file-manager/remove__title' => 'Κατάργηση αρχείου ή φακέλου',
    'ui__client/domain/hosting/file-manager/remove__description' => 'Κατάργηση αυτού του αρχείου ή φακέλου.',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => 'Κατάργηση αρχείου ή φακέλου',
    'ui__client/domain/hosting/file-manager/remove_self__title' => 'Κατάργηση αρχείου ή φακέλου',
    'ui__client/domain/hosting/file-manager/remove_self__description' => 'Κατάργηση αυτού του αρχείου ή φακέλου.',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => 'Αντιγραφή ή μετακίνηση αρχείου ή καταλόγου',
    'ui__client/domain/hosting/file-manager/copy-move__title' => 'Αντιγραφή ή μετακίνηση αρχείου ή καταλόγου',
    'ui__client/domain/hosting/file-manager/copy-move__description' => 'Αντιγραφή ή μετακίνηση επιλεγμένων αρχείων ή καταλόγων.',
    'ui__client/domain/hosting/file-manager/view__short-title' => 'Προβολή αρχείου',
    'ui__client/domain/hosting/file-manager/view__title' => 'Προβολή αρχείου',
    'ui__client/domain/hosting/file-manager/view__description' => 'Προβολή επιλεγμένου αρχείου.',

    'ui__client/ipaddress__short-title' => 'Διεύθυνση ΙP',
    'ui__client/ipaddress__title' => 'Διεύθυνση ΙP',
    'ui__client/ipaddress__description' => 'Προβολή πληροφοριών σχετικά με τη διεύθυνση IP.',
    'ui__server/ip-address__short-title' => 'Διεύθυνση ΙP',
    'ui__server/ip-address__title' => 'Διεύθυνση ΙP',
    'ui__server/ip-address__description' => 'Προβολή πληροφοριών σχετικά με τη διεύθυνση IP.',
    'ui__client/domain/hosting/setup__short-title' => 'Ρυθμίσεις φιλοξενίας περιεχομένου web',
    'ui__client/domain/hosting/setup__title' => 'Ρυθμίσεις φιλοξενίας περιεχομένου web',
    'ui__client/domain/hosting/setup__description' => 'Διαμόρφωση ρυθμίσεων φιλοξενίας περιεχομένου web για την τοποθεσία web %1.',
    'ui__reseller/client/chowner_multi__description' => 'Επιλογή νέου κατόχου για επιλεγμένους λογαριασμούς πελατών.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Τύπος MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Ιδιότητες τύπου MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Προβολή των ιδιοτήτων του τύπου MIME.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Έγγραφο σφάλματος', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Έγγραφο σφάλματος', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Ιδιότητες εγγράφου σφάλματος.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'Κατάργηση των επιλεγμένων διατάξεων αναφοράς.',
    'b_resellerreportslist_search' => 'Εισαγάγετε ένα συνδυασμό αναζήτησης και κάντε κλικ για εύρεση διατάξεων αναφοράς.',
    'b_resellerreportslist_show_all' => 'Εμφάνιση όλων των διαθέσιμων διατάξεων αναφοράς.',

    'l_resellerreportslist_auto' => 'Ταξινόμηση διατάξεων αναφοράς με βάση τον αυτοματισμό παράδοσης.',
    'l_resellerreportslist_clients' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία πληροφοριών σχετικά με τους πελάτες.',
    'l_resellerreportslist_domains' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία πληροφοριών σχετικά με τους τομείς.',
    'l_resellerreportslist_general' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία γενικών πληροφοριών.',
    'l_resellerreportslist_name' => 'Ταξινόμηση διατάξεων αναφοράς με βάση το όνομα της αναφοράς.',
    'l_resellerreportslist_personal_domains' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία πληροφοριών σχετικά με τους προσωπικούς τομείς.',

    'b_adminreportslist_remove' => 'Κατάργηση των επιλεγμένων διατάξεων αναφοράς.',
    'b_adminreportslist_search' => 'Εισαγάγετε ένα συνδυασμό αναζήτησης και κάντε κλικ για εύρεση διατάξεων αναφοράς.',
    'b_adminreportslist_show_all' => 'Εμφάνιση όλων των διαθέσιμων διατάξεων αναφοράς.',

    'l_adminreportslist_auto' => 'Ταξινόμηση διατάξεων αναφοράς με βάση τον αυτοματισμό παράδοσης.',
    'l_adminreportslist_clients' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία πληροφοριών σχετικά με τους πελάτες.',
    'l_adminreportslist_domains' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία πληροφοριών σχετικά με τους τομείς.',
    'l_adminreportslist_general' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία γενικών πληροφοριών.',
    'l_adminreportslist_name' => 'Ταξινόμηση διατάξεων αναφοράς με βάση το όνομα της αναφοράς.',
    'l_adminreportslist_personal_clients' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία πληροφοριών σχετικά με τους δικούς σας πελάτες.',
    'l_adminreportslist_personal_domains' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία πληροφοριών σχετικά με τους δικούς σας τομείς.',
    'l_adminreportslist_resellers' => 'Ταξινόμηση διατάξεων αναφοράς με βάση την παρουσία πληροφοριών σχετικά με τους μεταπωλητές.',

    'b_clientsonlylist_remove' => 'Κατάργηση επιλεγμένων λογαριασμών πελατών.',
    'b_clientsonlylist_search' => 'Εισαγάγετε ένα συνδυασμό αναζήτησης και κάντε κλικ για εύρεση λογαριασμών πελατών.',
    'b_clientsonlylist_show_all' => 'Εμφάνιση όλων των λογαριασμών πελατών.',
    'l_clientsonlylist_cname' => 'Ταξινόμηση λογαριασμών πελατών με βάση το όνομα της εταιρείας.',
    'l_clientsonlylist_date' => 'Ταξινόμηση λογαριασμών πελατών με βάση την ημερομηνία δημιουργίας.',
    'l_clientsonlylist_domains' => 'Ταξινόμηση λογαριασμών πελατών με βάση τον αριθμό τομέων.',
    'l_clientsonlylist_name' => 'Ταξινόμηση λογαριασμών πελατών με βάση το όνομα.',
    'l_clientsonlylist_owner' => 'Ταξινόμηση λογαριασμών πελατών με βάση τον κάτοχο.',
    'l_clientsonlylist_type' => 'Ταξινόμηση λογαριασμών πελατών με βάση τον τύπο.',

    'b_get_password_cancel' => 'Επιστροφή στην προηγούμενη οθόνη χωρίς να αποσταλεί το email.',
    'b_get_password_send' => 'Κάντε κλικ στο ΟΚ για να αποσταλεί ένα μήνυμα ανάκτησης κωδικού πρόσβασης στη διεύθυνση email που είναι καταχωρημένη στο σύστημα.',



    'b_personaltrafficlist_search' => 'Εισαγάγετε ένα συνδυασμό αναζήτησης και κάντε κλικ για εύρεση τομέων.',
    'b_personaltrafficlist_show_all' => 'Εμφάνιση όλων των τομέων.',

    'b_back' => 'Επιστροφή στην προηγούμενη σελίδα.',
    'b_next' => 'Μετάβαση στην επόμενη σελίδα.',

    'b_dnsnstemplatelist_remove' => 'Διαγραφή των επιλεγμένων διακομιστών ονομάτων.',
    'b_dnsnstemplatelist_search' => 'Εισαγάγετε ένα συνδυασμό αναζήτησης και κάντε κλικ για εύρεση διακομιστών ονομάτων.',
    'b_dnsnstemplatelist_show_all' => 'Εμφάνιση όλων των διακομιστών ονομάτων.',

    'l_dnsnstemplatelist_ns' => 'Ταξινόμηση εγγραφών προτύπων DNS με βάση το όνομα διακομιστή.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Δημιουργία ασφαλών συνδέσεων προς αρχεία και φακέλους',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Ενεργοποίηση δημόσιων αρχείων',
    'cu__serverfilesharing_fsPublicFolder' => 'Φάκελος για αποθήκευση δημόσιων αρχείων',
    'cu__serverfilesharing_fsPublicUrl' => 'Διεύθυνση URL για πρόσβαση επισκεπτών στα δημόσια αρχεία',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Ενεργοποίηση προστασίας με κωδικό πρόσβασης για τα δημόσια αρχεία',
    'cu__serverfilesharing_fsPartnerFolder' => 'Φάκελος για αποθήκευση αρχείων με προστασία κωδικού πρόσβασης',
    'cu__serverfilesharing_fsPartnersLogin' => 'Όνομα χρήστη για πρόσβαση στο αρχείο',
    'cu__serverfilesharing_fsPartnersPassword' => 'Κωδικός πρόσβασης για πρόσβαση στο αρχείο',
    'cu__serverfilesharing_fsDomain' => 'Διεύθυνση URL ρίζας φακέλου web. Όνομα τομέα',
    'cu__serverfilesharing_fsPrefix' => 'Διεύθυνση URL ρίζας φακέλου web.  Πρόθεμα',
    'cu__serverfilesharing_commandUpdate' => 'Ενημέρωση ρυθμίσεων κοινής χρήσης αρχείων',
    'cu__serverfilesharing_commandInfo' => 'Εμφάνιση τρεχουσών ρυθμίσεων κοινής χρήσης αρχείων',
    'server_preferences_include_admin_dumps_into_client_usage' => 'αρχεία αντιγράφων ασφαλείας που έχουν δημιουργηθεί από το διαχειριστή',
    'server_preferences__forbid_subscription_rename' => 'Απαγόρευση στους πελάτες και τους μεταπωλητές να αλλάξουν το κύριο όνομα τομέα τους',
    'subscription_rename_is_forbidden' => 'Η μετονομασία των συνδρομών απαγορεύεται από την πολιτική σε επίπεδο διακομιστή.',
    'server_preferences__allow_sys_user_rename' => 'Οι πελάτες μπορούν να αλλάξουν το όνομα των χρηστών συστήματός τους',
    'server_preferences__allow_sys_user_rename_false' => 'Πάντα',
    'server_preferences__allow_sys_user_rename_true' => 'Μόνο αν έχει εκχωρηθεί το δικαίωμα Διαχείρισης φιλοξενίας',
    'server_preferences__allow_sys_user_rename_forced' => 'Ποτέ',
    'server_preferences__preferred_domain' => 'Προτιμώμενος τομέας για τοποθεσίες web',
    'server_preferences__preferred_domain_none' => 'Καμία',
    'server_preferences__preferred_domain_to_landing' => 'domain.tld',
    'server_preferences__preferred_domain_to_www' => 'www.domain.tld',
    'server_preferences__anonymize_ips' => 'Ανωνυμοποίηση διευθύνσεων IP',
    'server_preferences__anonymize_ips_text' => 'Ανωνυμοποίηση διευθύνσεων IP κατά τη διάρκεια της ανακύκλωσης αρχείων καταγραφής και της συλλογής στατιστικών στοιχείων web',
    'server_preferences__anonymize_ips_description' => 'Η δέσμη ενεργειών μετά την ανακύκλωση αντικαθιστά με το "0" την τελευταία οκτάδα των διευθύνσεων IPv4 σε ανακυκλωμένα αρχεία καταγραφής, πριν από την αρχειοθέτηση. Στις διευθύνσεις, η δέσμη ενεργειών αντικαθιστά το τελικό τμήμα της διεύθυνσης (δύο οκτάδες μετά την τελευταία άνω και κάτω τελεία) με το "0000" (στην πλήρη μορφή) ή το "0" (στη σύντομη μορφή)',
    'server_preferences__logrotate' => 'Ανακύκλωση αρχείων καταγραφής',
    'server_preferences__logrotate_force' => 'Επιβολή καθημερινής ανακύκλωσης αρχείων καταγραφής για όλους τους τομείς',
    'server_preferences__logrotate_period' => 'Να επιτρέπεται η αποθήκευση των αρχείων καταγραφής των τοποθεσιών web για',
    'server_preferences__logrotate_period_days' => 'ημέρες',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Διαχείριση προγραμματισμένων εργασιών στο διακομιστή',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Επιλέξτε το χρήστη συστήματος τις προγραμματισμένες εργασίες του οποίου θέλετε να διαχειριστείτε.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Προγραμματισμένη εργασία %1',
    'ui__server/crontab/task__description' => 'Προβολή ιδιοτήτων της προγραμματισμένης εργασίας %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Χρήστες συστήματος',
    'ui__server/crontab_unknown__title' => 'Χρήστες συστήματος',
    'ui__server/crontab_unknown__description' => 'Χρήστες του συστήματος που μπορούν να είναι κάτοχοι προγραμματισμένων εργασιών.',


    'ui__server/crontab__none-available' => 'Δεν έχετε λογαριασμούς χρηστών συστήματος.',
    'ui__server/crontab_readonly-unknown__description' => 'Προβολή προγραμματισμένων εργασιών.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Προγραμματισμένες εργασίες',
    'ui__server/crontab_readonly-unknown__title' => 'Προβολή προγραμματισμένων εργασιών',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Προβολή προγραμματισμένων εργασιών.',
    'ui__server/crontab_readonly__description' => 'Προβολή των προγραμματισμένων εργασιών του %1.',
    'ui__server/crontab_readonly__short-title' => 'Προγραμματισμένη εργασία του %1',
    'ui__server/crontab_readonly__title' => 'Προβολή των προγραμματισμένων εργασιών του %1',
    'ui__server/crontab_unknown__wizard-title' => 'Διαχείριση προγραμματισμένων εργασιών.',

    'ui__server/crontab/properties__description' => 'Επεξεργασία των προγραμματισμένων εργασιών του %1.',

    'ui__server/crontab/properties__short-title' => 'Ρυθμίσεις',
    'ui__server/crontab/properties__title' => 'Επεξεργασία των προγραμματισμένων εργασιών του %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Προβολή προγραμματισμένων εργασιών.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Ρυθμίσεις',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Προβολή προγραμματισμένων εργασιών',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Προβολή προγραμματισμένων εργασιών.',
    'ui__server/crontab/properties_readonly__description' => 'Προβολή των προγραμματισμένων εργασιών του %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Ρυθμίσεις',
    'ui__server/crontab/properties_readonly__title' => 'Προβολή των προγραμματισμένων εργασιών του %1',
    'ui__server/crontab/properties_unknown__description' => 'Επεξεργασία προγραμματισμένων εργασιών.',
    'ui__server/crontab/properties_unknown__short-title' => 'Ιδιότητες',
    'ui__server/crontab/properties_unknown__title' => 'Επεξεργασία προγραμματισμένων εργασιών',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Επεξεργασία προγραμματισμένων εργασιών.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Επιλέξτε το χρήστη συστήματος τις εργασίες του οποίου θέλετε να δείτε.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Επιλέξτε το χρήστη συστήματος τις εργασίες του οποίου θέλετε να αλλάξετε.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Κάντε κλικ στο Τέλος για να κλείσετε τον οδηγό.',

    'ui__server/crontab/task__none-available' => 'Δεν έχετε προγραμματισμένες εργασίες.',
    'ui__server/crontab/task__none-available__2' => 'Ο χρήστης συστήματος %1 δεν έχει προγραμματισμένες εργασίες.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Προγραμματισμένες εργασίες.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Εργασίες',
    'ui__server/crontab/task_readonly-unknown__title' => 'Προγραμματισμένες εργασίες',

    'ui__server/crontab/task/delete__description' => 'Κατάργηση της προγραμματισμένης εργασίας %1',

    'ui__server/crontab/task/delete__short-title' => 'Κατάργηση',
    'ui__server/crontab/task/delete__title' => 'Κατάργηση της προγραμματισμένης εργασίας %1',
    'ui__server/crontab/task/delete_multi__description' => 'Κατάργηση προγραμματισμένων εργασιών.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Κατάργηση',
    'ui__server/crontab/task/delete_multi__title' => 'Κατάργηση προγραμματισμένων εργασιών',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Κατάργηση προγραμματισμένων εργασιών.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Επιλέξτε το χρήστη συστήματος τις εργασίες του οποίου θέλετε να καταργήσετε.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Επιλέξτε τις εργασίες που θέλετε να καταργήσετε.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Επιβεβαιώστε την κατάργηση της εργασίας επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.',
    'ui__server/crontab/task/delete_unknown__description' => 'Κατάργηση προγραμματισμένης εργασίας.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Κατάργηση',
    'ui__server/crontab/task/delete_unknown__title' => 'Κατάργηση προγραμματισμένης εργασίας',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Κατάργηση προγραμματισμένης εργασίας.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Επιλέξτε το χρήστη συστήματος την εργασία του οποίου θέλετε να καταργήσετε.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Επιλέξτε την εργασία που θέλετε να καταργήσετε.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Επιβεβαιώστε την κατάργηση της εργασίας επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.',

    'ui__server/crontab/task/properties__description' => 'Επεξεργασία προγραμματισμένων εργασιών.',

    'ui__server/crontab/task/properties__short-title' => 'Επεξεργασία της εργασίας %1',
    'ui__server/crontab/task/properties__title' => 'Επεξεργασία προγραμματισμένων εργασιών',
    'ui__server/crontab/task/properties_new__description' => 'Δημιουργία προγραμματισμένων εργασιών για το %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Προσθήκη εργασίας',
    'ui__server/crontab/task/properties_new__title' => 'Δημιουργία προγραμματισμένων εργασιών για το %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Δημιουργία προγραμματισμένης εργασίας.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Επιλέξτε το χρήστη συστήματος για τον οποίο θέλετε να δημιουργήσετε την προγραμματισμένη εργασία.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Προβολή των προγραμματισμένων εργασιών.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Ιδιότητες',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Προβολή των προγραμματισμένων εργασιών',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Προβολή των προγραμματισμένων εργασιών.',
    'ui__server/crontab/task/properties_readonly__description' => 'Προβολή προγραμματισμένων εργασιών.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Προβολή εργασίας %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Προβολή προγραμματισμένων εργασιών',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Δημιουργία προγραμματισμένων εργασιών.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Προσθήκη εργασίας',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Δημιουργία προγραμματισμένων εργασιών',
    'ui__server/crontab/task/properties_unknown__description' => 'Επεξεργασία προγραμματισμένων εργασιών.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Ιδιότητες',
    'ui__server/crontab/task/properties_unknown__title' => 'Επεξεργασία προγραμματισμένων εργασιών',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Επεξεργασία προγραμματισμένων εργασιών.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Επιλέξτε το χρήστη συστήματος τις εργασίες του οποίου θέλετε να δείτε.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Επιλέξτε το χρήστη συστήματος τις εργασίες του οποίου θέλετε να αλλάξετε.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Επιλέξτε την προγραμματισμένη εργασία.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Επιλέξτε την προγραμματισμένη εργασία που θέλετε να αλλάξετε.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Κάντε κλικ στο Τέλος για να κλείσετε τον οδηγό.',

    'ui__server/crontab/task/toggle_disable__description' => 'Απενεργοποίηση της προγραμματισμένης εργασίας %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Απενεργοποίηση',
    'ui__server/crontab/task/toggle_disable__title' => 'Απενεργοποίηση της προγραμματισμένης εργασίας %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Ενεργοποίηση της προγραμματισμένης εργασίας %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Ενεργοποίηση',
    'ui__server/crontab/task/toggle_enable__title' => 'Ενεργοποίηση της προγραμματισμένης εργασίας %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Ενεργοποίηση ή απενεργοποίηση προγραμματισμένων εργασιών.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Ενεργοποίηση ή απενεργοποίηση',
    'ui__server/crontab/task/toggle_unknown__title' => 'Ενεργοποίηση ή απενεργοποίηση προγραμματισμένων εργασιών',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Ενεργοποίηση ή απενεργοποίηση προγραμματισμένων εργασιών',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Επιλέξτε το λογαριασμό χρήστη συστήματος τις εργασίες του οποίου θέλετε να ενεργοποιήσετε ή να απενεργοποιήσετε.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Επιλέξτε την εργασία που θέλετε να ενεργοποιήσετε ή να απενεργοποιήσετε.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Λογαριασμοί πελατών', // not used on HP?
    'ui__client_unknown__title' => 'Λογαριασμοί πελατών', // not used on HP?
    'ui__client_unknown__description' => 'Διαχείριση λογαριασμών πελατών.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Αναστολή τομέα', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Αναστολή τομέα', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Αναστολή τομέα.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Ενεργοποίηση τομέα', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Ενεργοποίηση τομέα', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Ενεργοποίηση τομέα.', // not used on HP


    // to customer home page
    'ui__client/chowner_multi-select__title' => 'Ορισμός νέου κατόχου για λογαριασμούς πελατών',
    'ui__client/chowner_multi-select__short-title' => 'Ορισμός νέου κατόχου',
    'ui__client/chowner_multi-select__description' => 'Ορισμός νέου κατόχου για τους επιλεγμένους λογαριασμούς πελατών.',


    //Additional FTP Accounts
    'directory_browser__select_folder' => 'Επιλογή Φακέλου',
    'ftp__management_domain' => "Λογαριασμοί FTP του τομέα %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Λογαριασμοί FTP",
    'ftp__user_name' => "Όνομα λογαριασμού FTP",
    'ftp__user_home' => "Κεντρικός κατάλογος",
    'ftp__invalid_path' => "Καθορίστηκε μη έγκυρη διαδρομή",
    'ftp__physical_path_not_exist' => "Η φυσική διαδρομή δεν υπάρχει",
    'i_ftp_ses_sub_user' => 'Περίοδος λειτουργίας λογαριασμού FTP.',
    '__new_passwd' => "Νέος κωδικός πρόσβασης %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Δεν είναι δυνατή η ρύθμιση διακομιστή web στον κεντρικό υπολογιστή <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Δεν είναι δυνατή η δημιουργία του αρχείου ρύθμισης παραμέτρων διακομιστή web στον κεντρικό υπολογιστή <%%host%%> εξαιτίας των ακόλουθων σφαλμάτων:\n\n\n\n %%error%%\n\n\n\n Διορθώστε τα σφάλματα στα πρότυπα ρύθμισης παραμέτρων του διακομιστή web και επαναλάβετε τη δημιουργία του αρχείου.",

    'apacheConfigurationMessageAdminTitle' => 'Η δημιουργία της ρύθμισης παραμέτρων του διακομιστή web απέτυχε',
    'apacheConfigurationMessageClientTitle' => 'Προειδοποίηση',

    'apacheConfigurationFailedAdminHomeMessage' => 'Το νέο αρχείο ρύθμισης παραμέτρων δεν δημιουργήθηκε εξαιτίας σφαλμάτων στα πρότυπα ρύθμισης παραμέτρων. Το αναλυτικό μήνυμα σφάλματος στάλθηκε στη διεύθυνση ηλεκτρονικού ταχυδρομείου σας. Παρακαλούμε ελέγξτε το μήνυμα, διορθώσετε τα σφάλματα και κάντε κλικ στο %1 για να επιχειρήσετε ξανά τη δημιουργία της ρύθμισης παραμέτρων.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'εδώ', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Η νέα ρύθμιση παραμέτρων για τον τομέα %1 δεν δημιουργήθηκε εξαιτίας σφαλμάτων στα πρότυπα ρύθμισης παραμέτρων. Το αναλυτικό μήνυμα σφάλματος στάλθηκε στη διεύθυνση ηλεκτρονικού ταχυδρομείου σας. Παρακαλούμε ελέγξτε το μήνυμα, διορθώσετε τα σφάλματα και κάντε κλικ στο %2 για να επιχειρήσετε ξανά τη δημιουργία της ρύθμισης παραμέτρων.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'εδώ', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Η ρύθμιση παραμέτρων του διακομιστή web για τον τομέα %1 ενδέχεται να είναι ασυνεπής.  Επικοινωνήστε με το διαχειριστή του διακομιστή για να επιλύσετε το πρόβλημα.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Η νέα ρύθμιση παραμέτρων για ορισμένους από τους τομείς δεν δημιουργήθηκε εξαιτίας σφαλμάτων στα πρότυπα ρύθμισης παραμέτρων.  Το αναλυτικό μήνυμα σφάλματος στάλθηκε στη διεύθυνση ηλεκτρονικού ταχυδρομείου σας. Παρακαλούμε ελέγξτε το μήνυμα, διορθώσετε τα σφάλματα και κάντε κλικ στο %1 για να επιχειρήσετε ξανά τη δημιουργία της ρύθμισης παραμέτρων.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'εδώ', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Η ρύθμιση παραμέτρων του διακομιστή web για ορισμένους από τους τομείς σας ενδέχεται να είναι ασυνεπής. Επικοινωνήστε με το διαχειριστή του διακομιστή για να επιλύσετε το πρόβλημα.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Προσαρμοσμένα έγγραφα σφάλματος",
    'dom_pref__webusers_script' => "Να επιτρέπεται στους χρήστες web να χρησιμοποιούν δέσμες ενεργειών",
    '__seoRedirect' => 'Διαμόρφωση του προτιμώμενου τομέα ως',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Καμία',

    '__sites' => 'Τομείς',
    'domain_plan__perm_denied_manage_phosting' => 'Δεν έχετε το δικαίωμα να διαχειριστείτε τις ρυθμίσεις φιλοξενίας.',
    '__owned_by_client' => 'υπό την κατοχή του πελάτη',
    'ui__client/permissions_readonly__description' => "Προβολή των ενεργειών που μπορεί να εκτελέσει ο πελάτης %1 στο Plesk.",
    'client_chown_subscription_will_be_anonymous' => 'Θα καταργηθεί η εγγραφή των πελατών από τα τρέχοντα προγράμματα παροχής υπηρεσιών τους.',
    'backup__restore__object_client_template' => 'Πρότυπο πελάτη',
    '__template_name' => 'Όνομα προγράμματος παροχής υπηρεσιών',
    'template__not_exists' => 'Δεν υπάρχει τέτοιο πρόγραμμα παροχής υπηρεσιών',
    'template__exists' => 'Υπάρχει ήδη πρόγραμμα με το όνομα %1.',
    'clientOwnerChanger__has_domains_subscribed_to_reseller_plans' => 'Ο πελάτης διαθέτει τομείς εγγεγραμμένους στα προγράμματα παροχής υπηρεσιών του %1.',
    'clientOwnerChanger__ip_not_in_pool' => 'Η καθορισμένη διεύθυνση IP δεν βρίσκεται στον χώρο συγκέντρωσης του μεταπωλητή.',

    //// Change owner of subscription
    'chown__select_title' => "Επιλέξτε νέο συνδρομητή",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Επιλέξτε τον νέο κάτοχο για τις επιλεγμένες συνδρομές και κάντε κλικ στο Επόμενο >>.',
    'domains__client_info' => "%1 συνδρομές, %2 ενεργές συνδρομές, %3 χώρος στο δίσκο που χρησιμοποιείται, %4 κίνηση που χρησιμοποιείται",
    '__possible_owners' => 'Πιθανοί νέοι κάτοχοι των συνδρομών',

    'clients_list__filter_owner__filter_title' => 'Πάροχος',
    'clients_list__filter_owner_any' => 'Όλοι οι χρήστες',
    'clients_list__filter_owner_my' => 'Μόνο οι συνδρομητές μου',
    'clients_list__filter_owner_name__filter_title' => 'Όνομα παρόχου',

    '__owner' => "Πάροχος",
    'l_clientslist_owner' => 'Ταξινόμηση λογαριασμών χρηστών με βάση τον πάροχο.',
    'l_clientslist_date' => 'Ταξινόμηση λογαριασμών χρηστών με βάση την ημερομηνία δημιουργίας.',
    'l_clientslist_name' => 'Ταξινόμηση λογαριασμών χρηστών με βάση το όνομα.',
    'l_clientslist_domains' => 'Ταξινόμηση λογαριασμών χρηστών με βάση τους τομείς.',
    'l_clientslist_cname' => 'Ταξινόμηση λογαριασμών χρηστών με βάση το όνομα της εταιρείας.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Εκ νέου εκχώρηση επιλεγμένων συνδρομών',
    'chown__check_title' => 'Αλλαγή συνδρομητή',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Κάντε κλικ στο Τέλος για να ολοκληρωθεί η εκ νέου εκχώρηση.  Όταν ολοκληρωθεί, οι επιλεγμένες συνδρομές θα εκχωρηθούν στον νέο κάτοχο, ο πάροχός τους θα αλλάξει στον πάροχο του νέου κατόχου, θα αποσυνδεθούν από τα προγράμματα παροχής υπηρεσιών τους και θα μετατραπούν σε 'Custom'.",

    'chown__error_check' => 'Παρουσιάστηκαν προβλήματα κατά την προσπάθεια εκχώρησης ορισμένων συνδρομών σε νέο κάτοχο.',
    'domain_chown_subscription_will_be_anonymous' => "Οι συνδρομές θα αποσυνδεθούν από τα τρέχοντα προγράμματα παροχής υπηρεσιών τους και θα γίνουν 'Custom'.",
    'chown__error_domains_exclude' => "Παρουσιάστηκαν προβλήματα κατά την προσπάθεια εκχώρησης ορισμένων συνδρομών σε νέο κάτοχο.  Οι συνδρομές αυτές έχουν επισημανθεί.",
    'chown__ip_not_in_client_pool' => "Η διεύθυνση IP που συνδέεται με αυτήν τη συνδρομή δεν προστέθηκε στο χώρο IP του νέου κατόχου.",
    'chown__already_owned_by_client' => "Η συνδρομή αυτή ανήκει ήδη στο συγκεκριμένο χρήστη.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Προστατευμένος κατάλογος /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Διαχείριση προστατευμένου καταλόγου /%1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'Δημιουργία προστατευμένου καταλόγου στην τοποθεσία %1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => 'Προσθήκη προστατευμένου καταλόγου',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => 'Δημιουργία προστατευμένου καταλόγου.',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => 'Η δημιουργία του προστατευμένου καταλόγου %1 ολοκληρώθηκε με επιτυχία.',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => 'Ρυθμίσεις του προστατευμένου καταλόγου /%1',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'Ρυθμίσεις καταλόγου',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => 'Αλλαγή θέσης, ονόματος και τίτλου περιοχής για τον προστατευμένο κατάλογο.',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => 'Οι ρυθμίσεις προστατευμένου καταλόγου άλλαξαν.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => 'Επιβεβαίωση κατάργησης',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => 'Κατάργηση προστασίας',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => 'Κατάργηση προστασίας από τους επιλεγμένους καταλόγους.',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => 'Επιλέξτε ένα κατάλογο από τον οποίο θέλετε να καταργήσετε την προστασία.',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'Η ενέργεια αυτή θα οδηγήσει στην κατάργηση της προστασίας από τους καταλόγους.  Οι κατάλογοι θα καταστούν ελεύθερα προσβάσιμοι στους χρήστες του Internet.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => 'Η προστασία καταργήθηκε με επιτυχία από τους επιλεγμένους καταλόγους.',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Προσθήκη χρήστη',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Προσθήκη χρήστη',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Δημιουργία λογαριασμού χρήστη για πρόσβαση στον προστατευμένο κατάλογο %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'Ο λογαριασμός χρήστη για πρόσβαση στον προστατευμένο κατάλογο δημιουργήθηκε.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "Τα διαπιστευτήρια του χρήστη αποθηκεύτηκαν.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Κατάργηση χρηστών προστατευμένου καταλόγου',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Επιλέξτε τους χρήστες που θέλετε να καταργήσετε.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Κατάργηση',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Κατάργηση χρηστών καταλόγου.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'Οι παρακάτω χρήστες του προστατευμένου καταλόγου θα καταργηθούν:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'Οι επιλεγμένοι λογαριασμοί χρηστών καταργήθηκαν.',

    '__redirect_hint' => 'Θα ανακατευθυνθείτε στη νέα διεύθυνση σε 15 δευτερόλεπτα... Εάν δεν μεταφερθείτε αυτόματα στη νέα τοποθεσία, ενεργοποιήστε το javascript ή κάντε κλικ στην υπερ-σύνδεση %%link%%.',

    'backup__restore__object_maillist' => 'Λίστα αλληλογραφίας',
    'backup__restore__object_site' => 'Τοποθεσία',
    'backup__restore__object_user' => 'Χρήστης',
    'backup__restore__object_role' => 'Ρόλος',

    'limit__name_max_site' => 'τοποθεσίες',

    'iis_pool__unable_rename_client' => "Δεν είναι δυνατή η μετονομασία του χώρου συγκέντρωσης εφαρμογών IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Η υπηρεσία ανώνυμου FTP υποστηρίζεται μόνο για τον κύριο τομέα της συνδρομής.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Η υπηρεσία ανώνυμου FTP υποστηρίζεται μόνο για τον κύριο τομέα της συνδρομής.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/μήνα',
    '__tb_month' => 'TB/μήνα',

    '__customers' => 'Πελάτες',
    '__customer_name' => 'Όνομα πελάτη',
    '__customer_total' => 'Σύνολο πελάτη',
    '__site' => 'Τοποθεσία',
    '__def_site' => 'Προεπιλεγμένη τοποθεσία',
    '__subscription_name' => 'Όνομα συνδρομής',
    '__subscription_name_powerUser' => 'Όνομα συνδρομής',

    'limit__units_max_traffic_suffix' => '/μήνα',

    'dom_pref__discard' => "Απόρριψη",

    'mail__pattern_already_exists' => 'Το μοτίβο "%1" υπάρχει ήδη στη μαύρη λίστα.',

    '__not_supported' => 'Δεν υποστηρίζεται',

    'plesk_key__sitebuilder' => 'Τοποθεσίες που δημοσιεύονται με το Presence Builder',
    'limit__name_max_site_builder' => 'Τοποθεσίες που δημοσιεύονται με το Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Υποστήριξη για πολύγλωσσες τοποθεσίες στο Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Στατιστικά στοιχεία μεταφοράς δεδομένων για τον τομέα %1',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Στατιστικά στοιχεία μεταφοράς δεδομένων για τον τομέα %1',
    'ui__client/domain/traffic-hosting#list__title' => "Μεταφορά δεδομένων από υπηρεσίες",

    'login_up__access_denied_no_subscriptions' => "Δεν επιτρέπεται η πρόσβαση.  Δεν υπάρχουν διαθέσιμες συνδρομές γι' αυτόν το λογαριασμό.",

    'interval__day' => '%1 ημέρα(ες)',
    'interval__hour' => '%1 ώρα(ες)',
    'interval__minute' => '%1 λεπτό(ά)',
    'interval__second' => '%1 δευτερόλεπτο(α)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Προσπαθείτε να χρησιμοποιήσετε ένα κλειδί άδειας χρήσης που δημιουργήθηκε για άλλη έκδοση του Plesk. Επικοινωνήστε με τους αντιπροσώπους πωλήσεων της Plesk για να αποκτήσετε το κατάλληλο κλειδί άδειας χρήσης.',
    //Standalone or virtualization
    'virtualization_any' => "Φυσικός διακομιστής ή οποιαδήποτε λύση εικονικοποίησης",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Διακομιστής Virtuozzo",
    'plesk_key__virtualization' => "Ισχύει για τα εξής περιβάλλοντα:",
    'plesk_key__virtualization_only_key' => 'Το κλειδί άδειας χρήσης προορίζεται για χρήση μόνο με Plesk που λειτουργεί σε εικονικό περιβάλλον %1.',
    'plesk_key__virtualizations_only_key' => 'Το κλειδί άδειας χρήσης προορίζεται για χρήση μόνο με Plesk που λειτουργεί στα εξής εικονικά περιβάλλοντα: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Η χρήση προσαρμοσμένων πακέτων γλωσσών απαγορεύεται.',
    'plesk_key__allowed-locales' => 'Διαθέσιμες γλώσσες',
    'plesk_key__allowed-locales-any' => 'Οποιαδήποτε γλώσσα',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'ο κατάλογος cgi-bin βρίσκεται στο',
    '_cgi_bin_mode_webspace' => 'ριζικός κατάλογος της συνδρομής',
    '_cgi_bin_mode_www_root' => 'ριζικός κατάλογος εγγράφων αυτού του τομέα',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => 'Προσθήκη ODBC DSN',
    'ui__server/odbc/dsn/properties_unknown-new__description' => 'Προσθήκη προέλευσης δεδομένων ODBC.',
    'ui__server/odbc/dsn/delete_multi__short-title' => 'Κατάργηση',
    'ui__server/odbc/dsn/delete_multi__title' => 'Επιβεβαίωση κατάργησης',
    'ui__server/odbc/dsn/delete_multi__description' => 'Κατάργηση επιλεγμένων προελεύσεων δεδομένων ODBC DSN.',
    'ui__server/odbc/dsn/delete#legend__description' => 'Οι παρακάτω συνδέσεις ODBC DSN θα καταργηθούν:',
    'ui__server/odbc/dsn/delete__empty_selection' => 'Δεν έχουν επιλεγεί συνδέσεις ODBC DSN.',
    'ui__server/odbc/dsn/delete_multi__done' => 'Οι επιλεγμένες προελεύσεις δεδομένων καταργήθηκαν.',
    'ui__server/odbc/dsn__title' => 'Σύνδεση ODBC DSN %1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => 'Προσθήκη ODBC DSN',
    'ui__client/domain/odbc/dsn/properties_new__description' => 'Προσθήκη προέλευσης δεδομένων ODBC.',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => 'Κατάργηση',
    'ui__client/domain/odbc/dsn/delete_multi__title' => 'Επιβεβαίωση κατάργησης',
    'ui__client/domain/odbc/dsn/delete_multi__description' => 'Κατάργηση επιλεγμένων προελεύσεων δεδομένων ODBC DSN.',
    'ui__client/domain/odbc/dsn/delete#legend__description' => 'Οι παρακάτω συνδέσεις ODBC DSN θα καταργηθούν:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => 'Δεν έχουν επιλεγεί συνδέσεις ODBC DSN.',
    'ui__client/domain/odbc/dsn/delete_multi__done' => 'Οι επιλεγμένες προελεύσεις δεδομένων καταργήθηκαν.',
    'ui__client/domain/odbc/dsn__title' => 'Σύνδεση ODBC DSN %1',


    /// Custom buttons
    'custom_button__sort_key' => 'Προτεραιότητα',
    'custom_button__place' => 'Τοποθεσία',
    'custom_button__place_navigation' => 'Κοινή πρόσβαση',
    'custom_button__place_admin' => 'Αρχική σελίδα διαχειριστή',
    'custom_button__place_admin-settings' => 'Σελίδα Εργαλεία & Ρυθμίσεις διαχειριστή',
    'custom_button__place_reseller' => "Αρχική σελίδα μεταπωλητή",
    'custom_button__place_reseller-settings' => 'Σελίδα Εργαλεία & Βοηθήματα μεταπωλητή',
    'custom_button__place_client' => 'Αρχική σελίδα πελάτη',
    'custom_button__place_domain' => "Σελίδα Τοποθεσίες Web & Τομείς της συνδρομής",
    'custom_button__place_domain_powerUser' => "Σελίδα Τοποθεσίες Web & Τομείς της συνδρομής",
    'custom_button__place_domain-properties' => 'Εργαλεία τοποθεσιών web',
    'custom_button__private' => 'Εμφάνιση μόνο σε μένα',
    'custom_button__image' => 'Εικόνα φόντου',
    'custom_button__conhelp' => "Κείμενο συμβουλής εργαλείου",
    'custom_button__edit' => "Ρυθμίσεις σύνδεσης σε πρόσθετη υπηρεσία",
    'custom_button__include_client_cname' => "Να συμπεριληφθεί το όνομα της εταιρείας του πελάτη",
    'custom_button__include_client_email' => "Να συμπεριληφθεί η διεύθυνση ηλεκτρονικού ταχυδρομείου του πελάτη",
    'custom_button__include_client_id' => "Να συμπεριληφθεί το αναγνωριστικό του πελάτη",
    'custom_button__include_client_pname' => "Να συμπεριληφθεί το όνομα επαφής του πελάτη",
    'custom_button__include_domain_id' => "Συμπεριλάβετε αναγνωριστικό συνδρομής, αναγνωριστικό τομέα και αναγνωριστικό ψευδωνύμου τομέα",
    'custom_button__include_domain_id_powerUser' => "Συμπεριλάβετε αναγνωριστικό συνδρομής, αναγνωριστικό τομέα και αναγνωριστικό ψευδωνύμου τομέα",

    'custom_button__include_domain_name' => "Να συμπεριληφθεί το κύριο όνομα τομέα",
    'custom_button__include_ftp_user' => "Να συμπεριληφθεί το όνομα χρήστη FTP",
    'custom_button__include_ftp_pass' => "Να συμπεριληφθεί ο κωδικός πρόσβασης FTP",
    'custom_button__internal_open' => "Άνοιγμα της διεύθυνσης URL στο Plesk",
    'custom_button__text' => "Ετικέτα κουμπιού",
    'custom_button__url' => "Διεύθυνση URL",

    'custom_button__not_image' => 'Το αρχείο δεν είναι αρχείο εικόνας.',
    'custom_button__big_image' => 'Το μέγεθος του αρχείου δεν πρέπει να υπερβαίνει τα 100 KB.',
    'custom_button__failed_copy_image' => 'Δεν είναι δυνατή η αντιγραφή του αρχείου: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Δεν μπορείτε να επαναφέρετε ένα αντίγραφο ασφαλείας που δεν είναι Power User σε προβολή Power User.',
    '__unknown_network_interface' => 'Άγνωστη διασύνδεση δικτύου',

    'init_conf__ip_address' => 'Διεύθυνση ΙP',

    //Confirmation page
    'bt_confirm' => 'Επιβεβαίωση',
    'b_confirm' => 'Επαλήθευση κυριότητας των τοποθεσιών web σας.',

    //// New VZPP Integration
    '__vzpp_integration_warning' => 'Αυτή η παρουσία του Plesk είναι εγκατεστημένη σε κοντέινερ Virtuozzo. Οι τρέχουσες ρυθμίσεις διαχείρισης κοντέινερ εκτός σύνδεσης καθιστούν το Plesk μη διαθέσιμο.',
    '__vzpp_integration_contact_admin' => 'Εάν έχετε επαρκή δικαιώματα για να τροποποιήσετε τη ρύθμιση παραμέτρων κοντέινερ, %1. Διαφορετικά, επικοινωνήστε με τον πάροχό σας για να το κάνετε αυτό.',
    '__vzpp_integration_help_link' => 'αλλαγή των ρυθμίσεων διαχείρισης εκτός σύνδεσης',



    'performance__iss_app_pool_forced_by_site_isolation' => 'Οι ρυθμίσεις του αποκλειστικού χώρου συγκέντρωσης εφαρμογών IIS ορίζονται σύμφωνα με την πολιτική ασφαλείας σε επίπεδο διακομιστή (ρύθμιση απομόνωσης τοποθεσίας).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Οι ρυθμίσεις του αποκλειστικού χώρου συγκέντρωσης εφαρμογών IIS ορίζονται σύμφωνα με τις ρυθμίσεις απόδοσης σε επίπεδο διακομιστή.',

    '__current' => 'Τρέχον',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Οι ιδιότητες χρήστη ενημερώθηκαν.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Έχετε χρησιμοποιήσει σχεδόν όλους τους τομείς που παρέχονται με την άδεια του Plesk σας (90% ή και περισσότερο).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Έχετε χρησιμοποιήσει σχεδόν όλους τους τομείς.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Έχετε χρησιμοποιήσει σχεδόν όλες τις τοποθεσίες Presence Builder που παρέχονται με την άδεια του Plesk σας (90% ή και περισσότερο).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Έχετε χρησιμοποιήσει σχεδόν όλες τις τοποθεσίες Presence Builder.',
    'promo__button_hide' => 'Απόκρυψη',
    'promo__button_next' => 'Επόμενο >>',
    'promo__button_prev' => '<< Προηγούμενο',
    'promo__button_license' => 'Ενημέρωση άδειας',

    'promo__google_integration_title' => 'Ενοποίηση με υπηρεσίες της Google',
    'promo__google_integration' => 'Ρυθμίστε την ενοποίηση με υπηρεσίες της Google, όπως το AdSense, το Google Apps και τα εργαλεία Webmaster.',
    'promo__google_integration_button' => 'Ρύθμιση παραμέτρων',

    'promo__button_learn_more' => 'Μάθετε περισσότερα',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Μπορείτε να προσαρμόσετε την εμφάνιση του περιβάλλοντος εργασίας και τις ρυθμίσεις εμπορικής ταυτότητας μέσω των προσαρμοσμένων θεμάτων. Για οδηγίες σχετικά με την προσαρμογή των θεμάτων του Plesk, ανατρέξτε στο %1.',
    'panel_branding__description_link' => 'ακόλουθο έγγραφο',
    'mail__enable_mail_ui_label' => 'Ενεργοποίηση λειτουργιών διαχείρισης αλληλογραφίας στο Plesk',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Εξαγωγή αρχείων',
    'b_filemanager__extract' => 'Εξαγωγή αρχείων από τις επιλεγμένες αρχειοθήκες στον τρέχοντα κατάλογο.  Σημειώστε ότι τα ονόματα των αρχείων μπορεί να μην εμφανίζονται σωστά μετά την εξαγωγή, εφόσον περιέχουν εθνικούς χαρακτήρες.',
    'filemanager_error_extracting_files' => 'Παρουσιάστηκε σφάλμα κατά την εξαγωγή των αρχειοθετημένων αρχείων: %1',
    'filemanager_no_archive_files_specified' => 'Καθορίστε τις αρχειοθήκες που θέλετε να εξαχθούν.',
    'filemanager_not_zip_archive_specified' => 'Το %1 δεν μπορεί να εξαχθεί, καθώς δεν είναι αρχειοθήκη ZIP.',
    'filemanager_files_successfully_extracted' => 'Τα αρχειοθετημένα αρχεία εξήχθησαν.',
    'filemanager_error_file_download' => 'Η λήψη του αρχείου απέτυχε: %1',
    'filemanager__user_poolgrp' => 'Ομάδα χώρου συγκέντρωσης εφαρμογών',

    'loading' => 'Φόρτωση...',
    'bt_create_archive' => 'Προσθήκη στην αρχειοθήκη',
    'filemanager__pack' => "Διαδρομή προς την αρχειοθήκη: %1",
    'filemanager__archive_name' => 'Όνομα αρχειοθετημένου αρχείου',
    'filemanager__empty_filename' => 'Πληκτρολογήστε το όνομα του αρχείου αρχειοθέτησης.',
    'filemanager_archive_created' => 'Η αρχειοθήκη δημιουργήθηκε με επιτυχία.',
    'filemanager_error_creating_archive' => 'Δεν είναι δυνατή η δημιουργία της αρχειοθήκης: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Η εγγραφή αυτή θα έρθει σε αντίθεση με την εγγραφή AAAA για τη ζώνη.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Ο διακομιστής FTP δεν υποστηρίζει διευθύνσεις IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Η εγγραφή αυτή θα έρθει σε αντίθεση με την εγγραφή επικόλλησης για τη ζώνη \'%1\'.',
    '__ftp_ipv6_not_supported' => "(Ο διακομιστής FTP δεν υποστηρίζει διευθύνσεις IPv6.)",
    '__ipv6_not_supported' => 'Το IPv6 δεν υποστηρίζεται.',
    'mail__ipv6_not_supported' => 'Το IPv6 δεν υποστηρίζεται από το διακομιστή αλληλογραφίας.',
    'mail__relay_while_list_ipv6_not_supported' => 'Η λίστα επιτρεπόμενης μεταγωγής IPv6 δεν υποστηρίζεται από το διακομιστή αλληλογραφίας.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Η τιμή της μάσκας πρέπει να είναι πολλαπλάσια του 16.',
    'mail__ip_or_mask_is_invalid' => 'Μη έγκυρη διεύθυνση IP ή μάσκα.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Η προώθηση σε διευθύνσεις IP IPv6 δεν υποστηρίζεται.',
    'sa__invalid_trusted_networks' => 'Αξιόπιστα δίκτυα που έχουν καθοριστεί λανθασμένα: %1',
    'dns_add__enter_ipv6_address' => "Διεύθυνση IPv6",
    'license_trial_days_left' => 'Το Plesk λειτουργεί με δοκιμαστική άδεια χρήσης, η οποία θα λήξει σε %1 ημέρες.',
    'excl_ipv6_num' => 'Αποκλειστική διεύθυνση IPv6',
    '__ip_mask' => "Μάσκα υποδικτύου",
    '__ipv4_addr' => 'Διεύθυνση IPv4',
    '__ipv6_addr' => 'Διεύθυνση IPv6',
    'template__num_excl_ipv6s' => 'Εκχώρηση αποκλειστικών διευθύνσεων IPv6 στο μεταπωλητή',
    'anonftp__exclusive_ipv4_required' => 'Για τη ρύθμιση και χρήση της υπηρεσίας ανώνυμου FTP είναι απαραίτητη μια αποκλειστική διεύθυνση IPv4.',
    'anonftp__ipv4_already_used' => 'Δεν μπορείτε να ρυθμίσετε την υπηρεσία ανώνυμου FTP γι\' αυτήν την τοποθεσία, επειδή έχει ήδη ρυθμιστεί σε άλλον τομέα στην ίδια διεύθυνση IPv4.',


    'restart__kav' => "Kaspersky Antivirus",
    'panel_branding__page_description_admin' => 'Προσθέστε την εμπορική ταυτότητά σας στο περιβάλλον εργασίας του Plesk, αλλάζοντας τον τίτλο της σελίδας που εμφανίζεται στη γραμμή τίτλου του προγράμματος περιήγησης ή/και αντικαθιστώντας το λογότυπο Plesk στην επάνω αριστερή γωνία.',
    '__view_migration_log_detailed_info' => 'Προβολή αρχείου καταγραφής',

    'chown__ip_address_warn' => 'Πριν μεταφέρετε τη συνδρομή στο νέο κάτοχο, πρέπει να επιλέξετε μια νέα διεύθυνση IP για την εν λόγω συνδρομή.',
    'chown__no_ip_address' => 'Καμία',
    'chown__no_ipv4_address' => 'Δεν υπάρχει διεύθυνση IPv4',
    'chown__no_ipv6_address' => 'Δεν υπάρχει διεύθυνση IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'Η συνδρομή %1 ανήκει ήδη στο συγκεκριμένο χρήστη.',
    'chown__error_ip_absent_in_ip_pool' => 'Η διεύθυνση ΙΡ %1 δεν υπάρχει στο χώρο IP του χρήστη προορισμού.',
    'chown__error_ip_not_exist' => 'Η διεύθυνση ΙΡ με αναγνωριστικό \'%1\' δεν υπάρχει.',
    'chown__error_domain_ip_not_selected' => 'Πρέπει να επιλέξετε τουλάχιστον μία διεύθυνση IP για τον τομέα %1.  Ελέγξτε τις επιλεγμένες τιμές για την αντιστοίχιση IP.',

    '__new_passwd_single' => "Κωδικός πρόσβασης",
    '__confirm_passwd_single' => "Επιβεβαίωση κωδικού πρόσβασης",

    'mail__ip_or_mask_is_invalid_ipv6' => 'Μη έγκυρη διεύθυνση IPv6 ή μάσκα: Η διεύθυνση IP πρέπει να είναι έγκυρη διεύθυνση μοναδικής διανομής.',

    '__subscriptions' => 'Συνδρομές',

    '__owned_by_reseller' => 'υπό την κατοχή του μεταπωλητή',
    '__owned_by_provider' => 'υπό την κατοχή του παρόχου',

    'service_plan__anonymous' => 'Προσαρμοσμένο',
    'subscription_not_locked__change_limits_warning' => 'Η συνδρομή αυτή δεν είναι κλειδωμένη: Τα όρια χρήσης πόρων θα αλλάξουν κατά τη διάρκεια του συγχρονισμού με το πρόγραμμα παροχής υπηρεσιών.',
    'subscription_not_locked__change_permissions_warning' => 'Η συνδρομή αυτή δεν είναι κλειδωμένη: Τα δικαιώματα θα αλλάξουν κατά τη διάρκεια του συγχρονισμού με το πρόγραμμα παροχής υπηρεσιών.',

    'subscription__conflict_resolution_policy' => 'Έρχεται σε διένεξη με την πολιτική επίλυσης',
    'subscription__conflict_resolution_policy_lock' => "Κλείδωμα συνδρομής",

    'backup__list__backup_warnings' => 'Προειδοποιήσεις',
    'backup__list__backup_info' => 'Πληροφορία',
    'backup__restore__object_reseller_template' => 'Πρότυπο μεταπωλητή',
    'backup__restore__object_domain_template' => 'Πρότυπο τομέα',

    'ui__client/permissions_readonly__title' => 'Δικαιώματα',
    'ui__client/permissions_readonly__short-title' => 'Δικαιώματα',

    'subscription__unable_lock_anonymous' => 'Η συνδρομή αυτή δεν συνδέεται με κάποιο πρόγραμμα παροχής υπηρεσιών και συνεπώς δεν μπορεί να ξεκλειδωθεί.',
    'subscription__unable_sync_anonymous' => 'Η συνδρομή αυτή δεν συνδέεται με κάποιο πρόγραμμα παροχής υπηρεσιών και συνεπώς δεν μπορεί να συγχρονιστεί.',
    'subscription__unable_sync_locked' => 'Η συνδρομή αυτή είναι κλειδωμένη και συνεπώς δεν μπορεί να συγχρονιστεί.',
    'subscription__locked' => 'Η συνδρομή είναι κλειδωμένη.',
    'component_name__urlrewrite' => "Επανεγγραφή διεύθυνσης URL",
    '__quantity' => 'Ποσότητα',
    'hst__www_root_dir_absent' =>  'Προειδοποίηση: Ο κατάλογος που έχει οριστεί ως ριζικός κατάλογος εγγράφων δεν υπάρχει.',
    'object_creation__domain_is_not_a_webspace' => 'Αυτό το αντικείμενο μπορεί να δημιουργηθεί μόνο σε συνδρομή.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Η συνδρομή περιέχει τοποθεσίες και, ως εκ τούτου, δεν μπορείτε να αλλάξετε ή να διαγράψετε τον τύπο φιλοξενίας.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Σφάλμα: Η ενημέρωση της διεύθυνσης IP απέτυχε. Οι πρόσθετοι τομείς δεν μπορούν να λάβουν διεύθυνση IP που δεν έχει εκχωρηθεί στον κύριο τομέα της συνδρομής.',
    'domain_plan__unable_change' => 'Δεν είναι δυνατή η αλλαγή του προγράμματος παροχής υπηρεσιών: %1.',
    'domain_plan__different_hosting_type' => 'Ο τωρινός τύπος φιλοξενίας διαφέρει από τον τύπο που καθορίζεται στο πρόγραμμα παροχής υπηρεσιών.',
    'domain_plan__addon_text' => 'Πρόσθετο πρόγραμμα',
    'domain_plan__addon_description' => 'Το πρόσθετο πρόγραμμα χρησιμοποιείται ως συμπλήρωμα σε ένα πρόγραμμα φιλοξενίας.',
    'asp_net__managed_runtime_version' => 'Διαχειριζόμενη έκδοση χρόνου εκτέλεσης ASP.NET',
    'plan__can_not_change_hosting_type' => 'Δεν είναι δυνατή η αλλαγή του τύπου φιλοξενίας κατά την επεξεργασία ενός προγράμματος.',
    'plan__apply_problems' => 'Το σχέδιο δεν εφαρμόστηκε εξαιτίας προβλημάτων με την ακόλουθη λειτουργία: %1',
    'plan_save__subscription_update_problem' => 'Δεν είναι δυνατή η εφαρμογή των αλλαγών του προγράμματος στο %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Η συνδρομή έχει ανασταλεί προσωρινά μέχρι να ολοκληρωθεί η διαδικασία δημιουργίας ή επαναφοράς αντιγράφων ασφαλείας.  Επιστρέψτε αργότερα.",
    'mail__whitenet_exists' => "Η λίστα επιτρεπόμενων με πρόθεμα %1 υπάρχει ήδη.",
    '__login_incorrect_plain_shadow_password' => 'Έχετε ορίσει λανθασμένο κωδικό πρόσβασης για το λογαριασμό διαχειριστή.  Χρησιμοποιήστε τα διαπιστευτήρια του διαχειριστή του συστήματος (ρίζα) ή αποκτήστε το σωστό κωδικό πρόσβασης.  Για να μάθετε περισσότερα σχετικά με την απόκτηση του κωδικού πρόσβασης, διαβάστε το αρχείο /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Δεν μπορείτε να αποστείλετε μια διεύθυνση IP που δεν είναι στην κατοχή σας',

    'dns__dns_zone_not_synchronized' => 'Η ζώνη DNS τροποποιήθηκε.  Αν θέλετε να εφαρμόσετε τις αλλαγές του προτύπου DNS σε αυτήν τη ζώνη, κάντε κλικ στο κουμπί \'Εφαρμογή αλλαγών προτύπου DNS\' σε αυτήν τη σελίδα ή επιλέξτε \'Apply the changes to all zones\' από τη διαδρομή Πίνακας διαχείρισης διακομιστή > Εργαλεία & Ρυθμίσεις > Ρυθμίσεις προτύπου DNS > Εφαρμογή αλλαγών προτύπου DNS.',
    'dns__dns_zone_synchronize_link' => 'Κάντε κλικ',
    'dns__dns_zone_synchronize_done' => 'Η ζώνη DNS συγχρονίστηκε με επιτυχία.',

    'dns__dns_zone_template_not_synchronized' => 'Το πρότυπο ζώνης DNS τροποποιήθηκε και θα εφαρμοστεί σε όλους τους νέους τομείς που δημιουργούνται. Μπορείτε επίσης %1.',
    'dns__dns_zone_soa_template_not_synchronized' => 'Το πρότυπο SOA τροποποιήθηκε και θα εφαρμοστεί σε όλους τους νέους τομείς που δημιουργούνται. Μπορείτε επίσης %1.',
    'dns__dns_zone_template_synchronize_link' => 'εφαρμογή των αλλαγών σε όλους τους φιλοξενούμενους τομείς',
    'dns__dns_zone_template_error_details' => 'Λεπτομέρειες',
    'dns__dns_zone_template_error' => 'Παρουσιάστηκαν ζητήματα συγχρονισμού των ζωνών DNS με το πρότυπο ζώνης DNS.%1',

    'dns__soa_rname_type_owner' => 'Διεύθυνση ηλεκτρονικού ταχυδρομείου του κατόχου της τοποθεσίας web',
    'dns__soa_rname_type_domain' => 'Διεύθυνση ηλεκτρονικού ταχυδρομείου τομέα',
    'dns__soa_rname_type_external' => 'Εξωτερική διεύθυνση ηλεκτρονικού ταχυδρομείου',
    'dns__soa_rname_enforce_email' => 'Απαγόρευση αλλαγής της διεύθυνσης ηλεκτρονικού ταχυδρομείου RNAME ανά τομέα',
    'dns__soa_rname_label' => 'Email (RNAME)',
    'dns__soa_rname_hint' => 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου του ατόμου που είναι υπεύθυνος για τη ζώνη DNS του τομέα. Επιστράφηκε από τον διακομιστή DNS ως απάντηση σε ερωτήματα SOA.',

    'dns__dns_zone_soa_sync_title' => 'Παράκαμψη ρυθμίσεων SOA για όλους τους υπάρχοντες τομείς',
    'dns__dns_zone_soa_sync_legend' => 'Απαιτείται επιβεβαίωση',
    'dns__dns_zone_soa_sync_text' => 'Να ενημερωθούν οι εγγραφές SOA όλων των φιλοξενούμενων τομέων μέσω της εφαρμογής των αλλαγών που πραγματοποιήθηκαν στο πρότυπο SOA;',

    'cu_db__repair_mysql_dbus' => "Επιδιόρθωση κωδικών πρόσβασης χρηστών MySQL. Η λειτουργία αυτή είναι απαραίτητη εάν έχετε πραγματοποιήσει αναβάθμιση στο Plesk 11 από προηγούμενες εκδόσεις.",

    'scheduled_backup_settings__start_at_hint' => 'Το διάστημα ελέγχου για προγραμματισμένες εργασίες δημιουργίας αντιγράφων ασφαλείας είναι 15 λεπτά. Αν θέλετε το Plesk να ξεκινήσει τη διαδικασία δημιουργίας αντιγράφων ασφαλείας σε μια συγκεκριμένη χρονική στιγμή, προγραμματίστε την εργασία τουλάχιστον 15 λεπτά νωρίτερα από την επιθυμητή ώρα.',
    'cu_scheduled_backup_comment' => 'Προγραμματισμένη δημιουργία αντιγράφων ασφαλείας',
    'cu_scheduled_backup_error' => 'Παρουσιάστηκε σφάλμα κατά τη διάρκεια της διαδικασίας δημιουργίας αντιγράφου ασφαλείας: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Παρουσιάστηκε σφάλμα κατά τη διάρκεια της προγραμματισμένης διαδικασίας δημιουργίας αντιγράφου ασφαλείας.',
    'cu_scheduled_backup_mail_message' => "%1\nΣημείο εισόδου Plesk: %2\n\nΠαρουσιάστηκαν τα ακόλουθα σφάλματα κατά τη διάρκεια της προγραμματισμένης διαδικασίας δημιουργίας αντιγράφου ασφαλείας: \n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'Προγραμματισμένη δημιουργία αντιγράφων ασφαλείας. Όλες οι ρυθμίσεις παραμέτρων και το περιεχόμενο.',
    'cu_scheduled_backup_comment_backup_vhost' => 'Προγραμματισμένη δημιουργία αντιγράφων ασφαλείας. Όλες οι ρυθμίσεις παραμέτρων και το περιεχόμενο εκτός της αλληλογραφίας.',
    'cu_scheduled_backup_comment_backup_mail' => 'Προγραμματισμένη δημιουργία αντιγράφων ασφαλείας. Μόνο ρυθμίσεις παραμέτρων και περιεχόμενο αλληλογραφίας.',
    'cu_scheduled_backup_comment_backup_domain' => 'Προγραμματισμένη δημιουργία αντιγράφων ασφαλείας. Ρύθμιση παραμέτρων τομέα.',
    'cu_scheduled_backup_to_cloud_not_allowed' => 'Η αποθήκευση προγραμματισμένων αντιγράφων ασφαλείας σε απομακρυσμένο χώρο αποθήκευσης στο cloud είναι μια εξαιρετική λειτουργία. Επικοινωνήστε με τον πάροχο φιλοξενίας σας για να την ξεκλειδώσετε.',

    'i_backup_invalid_file' => 'Το αντίγραφο ασφαλείας δεν είναι έγκυρο.  Δεν είναι δυνατή η επαναφορά δεδομένων από αυτό το αρχείο.  Κάντε κλικ στο όνομα του αντιγράφου ασφαλείας για λεπτομέρειες.',

    'ui__server/migration/download-agent__short-title' => 'Λήψη του Migration & Transfer Agent',
    'ui__server/migration/download-agent__title' => 'Λήψη του Migration & Transfer Agent',
    'ui__server/migration/download-agent__description' => 'Λήψη της τελευταίας διαθέσιμης έκδοσης του Migration & Transfer Agent από την Plesk τοποθεσία web της Parallels.',

    'filemanager_resulting_archive_exists' => 'Το αρχείο %1 υπάρχει ήδη στον κατάλογο προορισμού.',

    'agent_unable_to_connect' => 'Δεν είναι δυνατή η σύνδεση με τον πράκτορα στο \'%2\'.  Βεβαιωθείτε ότι ο πράκτορας έχει εγκατασταθεί και λειτουργεί, καθώς και ότι δεν υπάρχουν προβλήματα σύνδεσης με τον κεντρικό υπολογιστή \'%2\'.',
    'agent_test_connection_failed' => 'Η σύνδεση με τον πράκτορα στο \'%2\' απέτυχε.',

    'agent_unable_to_resolve_host' => 'Δεν είναι δυνατός ο εντοπισμός του απομακρυσμένου κεντρικού υπολογιστή \'%1\'.  Βεβαιωθείτε ότι δεν υπάρχουν προβλήματα σύνδεσης με τον κεντρικό υπολογιστή.',
    'agent_unknown_curl_error' => 'Παρουσιάστηκε το σφάλμα \'%1\' κατά τη διάρκεια της σύνδεσης με τον πράκτορα στο \'%2\'.',
    'agent_unexpected_htp_code' => 'Ελήφθη ο μη αναμενόμενος κωδικός HTTP \'%1\' σχετικά με την αίτηση HTTP στον πράκτορα στο \'%2\'.',
    'agent_unable_to_auth' => 'Δεν είναι δυνατός ο έλεγχος ταυτότητας στον κεντρικό υπολογιστή \'%1\'. Για να επιλύσετε αυτό το ζήτημα, ακολουθήστε τις οδηγίες στη διεύθυνση http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Παρουσιάστηκε εσωτερικό σφάλμα στο διακομιστή κατά την εκτέλεση της εντολής στον απομακρυσμένο κεντρικό υπολογιστή \'%1\'.',
    'agent_response_is_empty' => 'Ελήφθη κενή απάντηση στην αίτηση HTTP προς τον πράκτορα στο \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Δεν ήταν δυνατός ο εντοπισμός του Migration & Transfer Agent στην τοπική μνήμη cache.  Ανοίξτε ξανά το Migration & Transfer Agent για να επιλύσετε το ζήτημα.',

    '__hosting_webdeploy' => "Δημοσίευση μέσω Web Deploy",
    'cu_domain__webdeploy' => "Δημοσίευση μέσω του Web Deploy (προεπιλογή: %1)",
    'cu_dom_tpl__webdeploy' => "Δημοσίευση μέσω του Web Deploy (προεπιλογή: %1)",
    'cu_subdomain__webdeploy' => "Δημοσίευση μέσω του Web Deploy (προεπιλογή: %1)",
    'webdeploy__not_installed' => "Το Microsoft Web Deploy δεν είναι εγκατεστημένο στο διακομιστή",
    'webdeploy__forced_by_site_isolation' => "Δεν είναι δυνατή η αλλαγή των ρυθμίσεων δημοσίευσης μέσω Web Deploy: Δεν έχετε το δικαίωμα να παρακάμψετε την πολιτική ασφαλείας σε επίπεδο διακομιστή.  Επικοινωνήστε με τον πάροχό σας για λεπτομέρειες.",



    'backup__restore_options__admin__server_configuration_license' => 'Κλειδί άδειας χρήσης',
    'migration_start_migrate_server_license' => 'Μεταφορά κλειδιού άδειας χρήσης',

    'defaultcomponents__delegation_rule_not_exist' => '(ο απαιτούμενος κανόνας ανάθεσης \'appPoolPipeline, appPoolNetFx\' δεν υπάρχει)',

    '__o' => 'Κ',

    'i_backup_created_by_admin' => 'Το αντίγραφο ασφαλείας δημιουργήθηκε από το διαχειριστή.',
    'i_backup_created_by_reseller' => 'Το αντίγραφο ασφαλείας δημιουργήθηκε από έναν μεταπωλητή.',
    'i_backup_created_by_client' => 'Το αντίγραφο ασφαλείας δημιουργήθηκε από έναν πελάτη.',

    'migration__object_exists_on_target_host' => '(υπάρχει ήδη στον κεντρικό υπολογιστή προορισμού)',

    '__customers_total' => 'Σύνολο κατά πελάτες',
    '__resellers_total' => 'Σύνολο κατά μεταπωλητές',
    '__reseller_total' => 'Σύνολο μεταπωλητών',


    'cu__mailserver_update_webmail_command' => "Καθορίζει τον πελάτη webmail που θέλετε να ενεργοποιήσετε ή να απενεργοποιήσετε",
    'cu__mailserver_webmail_state' => "Καθορίζει την κατάσταση του επιλεγμένου πελάτη webmail (η επιλογή \"αληθής\" ενεργοποιεί τον πελάτη και η επιλογή \"ψευδής\" τον απενεργοποιεί)",

    'cu_db_set_default_user' => 'Ορισμός ενός συγκεκριμένου χρήστη ως προεπιλεγμένου για μια βάση δεδομένων.  Η επιλογή αυτή χρησιμοποιείται με τις εντολές: add_user, update_user',

    'cu_role__opt_subscription_name' => 'Να επιτρέπεται στους χρήστες η πρόσβαση μόνο σε καθορισμένη συνδρομή',
    'cu_role__opt_for_all_subscription' => 'Να επιτρέπεται στους χρήστες η πρόσβαση σε όλες τις συνδρομές ενός λογαριασμού φιλοξενίας',
    'cu_role__subscription_not_found_role_is_not_limited' => 'Δεν είναι δυνατή η εφαρμογή αλλαγών στο ρόλο: Η συνδρομή %1 δεν βρέθηκε.',

    'cu_cl_pref__manage_website_maintenance' => 'Πρόσβαση σε προηγμένες λειτουργίες: Αντιγραφή τοποθεσίας web',
    'cu_cl_pref__manage_protected_dirs' => 'Διαχείρισης καταλόγων που προστατεύονται με κωδικό πρόσβασης',
    'cu_cl_pref__manage_mail_settings' => 'Δυνατότητα αλλαγής των ρυθμίσεων ηλεκτρονικής αλληλογραφίας',


    'cu__command_update_php_settings' => 'Ενημερώνει τις ρυθμίσεις PHP.',
    'cu__php_settings_option' => 'Καθορίζει τη διαδρομή προς το αρχείο με τις ρυθμίσεις PHP.',

    'cu__additional_php_settings_option' => 'Καθορίζει τη διαδρομή προς το αρχείο με τις πρόσθετες οδηγίες PHP.',
    'cu__command_show_php_settings' => 'Εμφανίζει τις τρέχουσες ρυθμίσεις PHP.',
    'cu__general_settings' => 'Γενικές ρυθμίσεις:',
    'cu__performance_settings' => 'Ρυθμίσεις απόδοσης:',
    'cu__php_fpm_settings' => 'Ρυθμίσεις PHP-FPM:',
    'cu__additional_directives' => 'Πρόσθετες οδηγίες:',

    'b_filemanager__pack' => 'Προσθήκη των επιλεγμένων αρχείων σε μια αρχειοθήκη.',

    'php_settings_permission_required' => 'Διαχείριση κοινών ρυθμίσεων PHP',
    'php_settings_performance_permission_required' => 'Διαχείριση ρυθμίσεων απόδοσης φιλοξενίας',
    'php_settings_customized' => 'Οι ρυθμίσεις PHP προσαρμόστηκαν.',
    'php_settings_synchronized_with_plan' => 'Οι ρυθμίσεις PHP πρέπει να συγχρονιστούν με το πρόγραμμα.',
    'phosting__unknown_shell_type' => 'Μη διαθέσιμο κέλυφος',

    'login_up__access_denied_subscription_deleted' => 'Δεν επιτρέπεται η πρόσβαση: Η συνδρομή σας καταργήθηκε.',

    'role_restricted_to_subscription' => '(μεταφέρθηκε με τη συνδρομή: %1)',

    'filemanager__extract' => "Εξαγωγή αρχείων σε: %1",

    'cu__license_command_check_installed_license' => 'Ελέγξτε την ισχύ του εγκατεστημένου κλειδιού άδειας χρήσης (επαναφέρει τον κωδικό εξόδου 0 αν το κλειδί είναι έγκυρο και 1 αν είναι άκυρο)',

    'promo__mobile_manager_title' => 'Plesk Mobile Server Manager',
    'promo__mobile_manager' => "Επεκτείνετε τη λειτουργικότητα του Plesk για να είστε σε θέση να ελέγχετε και να παρακολουθείτε το διακομιστή από κινητές συσκευές (BlackBerry, iPhone και Android).",
    'promo__mobile_monitor_title' => 'Plesk Mobile Server Monitor',
    'promo__mobile_monitor' => 'Αποκτήστε πρόσβαση στις σημαντικότερες πληροφορίες σχετικά με τους διακομιστές του Plesk οποτεδήποτε και οπουδήποτε από την κινητή συσκευή σας (BlackBerry, iPhone και Android).',
    'promo__mobile_button' => 'Μάθετε περισσότερα',

    'ui__server/migration/video__short-title' => 'Εκπαιδευτικά βίντεο',
    'ui__server/migration/video__title' => 'Παρακολούθηση εκπαιδευτικών βίντεο',
    'ui__server/migration/video__description' => 'Παρακολουθήστε βίντεο εκμάθησης.',

    'auto_install_updates_moved_to_separate_page' => 'Ρύθμιση πολιτικής ενημέρωσης',

    '__system_preferences' => 'Ρυθμίσεις συστήματος',
    'subDomainNameHint' => 'Εισαγάγετε το * ως όνομα υποτομέα για να δημιουργήσετε έναν υποτομέα μπαλαντέρ. Οι επισκέπτες της τοποθεσίας θα ανακατευθύνονται στον συγκεκριμένο υποτομέα, ανεξάρτητα από το όνομα υποτομέα που πληκτρολόγησαν στο πρόγραμμα περιήγησής τους.',
    'subdomains__wildcard_name_invalid' => "Το όνομα του υποτομέα δεν είναι έγκυρο.  Μπορείτε να χρησιμοποιήσετε μόνο αλφαριθμητικούς χαρακτήρες, την παύλα (-) και τον αστερίσκο (*) για τα ονόματα υποτομέα μπαλαντέρ.",
    'subdomains__name_invalid' => "Το όνομα του υποτομέα δεν είναι έγκυρο.  Μπορείτε να χρησιμοποιήσετε μόνο αλφαριθμητικούς χαρακτήρες και την παύλα (-) για τα ονόματα υποτομέα.",

    'domain__wildcard_no_www_prefix' => 'Δεν μπορείτε να χρησιμοποιήσετε το πρόθεμα www για υποτομείς μπαλαντέρ.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Φίλτρο αλληλογραφίας Plesk Postfix",
    '__milter' => "Postfix milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Διακομιστής POP3 Courier",
    'restart__pop3s' => "Διακομιστής POP3 Courier με υποστήριξη SSL/TLS",
    'restart__imap' => "Διακομιστής Courier IMAP",
    'restart__imaps' => "Διακομιστής Courier IMAP με υποστήριξη SSL/TLS",
    'restart__authdaemon' => "Daemon ελέγχου ταυτότητας Courier IMAP",
    'restart__imap-pop3' => "Διακομιστής Dovecot IMAP και POP3",


    'addon_packages_not_supported' => 'Τα πρόσθετα για συσκευασμένες εφαρμογές web APS δεν υποστηρίζονται.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Δεν είναι δυνατή η αυτόματη εκχώρηση διεύθυνσης IP στον τομέα. Καθορίσετε μια διεύθυνση IP χρησιμοποιώντας την επιλογή -ip.',

    'plesk_key__mb_accounts' => 'Λογαριασμοί χρηστών (μεταπωλητές και πελάτες) στο Customer and Business Manager',

    'actionlog__subdomain_dns' => 'Ζώνη DNS υποτομέα',
    'actionlog__site_subdomain_dns' => 'Ζώνη DNS υποτομέα ενός πρόσθετου τομέα',

    // PfW only
    'actionlog__event_site_create' => 'Ο τομέας δημιουργήθηκε',
    'actionlog__event_site_delete' => 'Ο τομέας διαγράφηκε',
    'actionlog__event_site_update' => 'Ο τομέας ενημερώθηκε',

    'actionlog__event_site_status_update' => 'Η κατάσταση τομέα ενημερώθηκε',
    'actionlog__event_site_dns_update' => 'Η ζώνη DNS του τομέα ενημερώθηκε',
    'actionlog__event_site_guid_update' => 'Το GUID τομέα ενημερώθηκε',

    'actionlog__event_site_subdomain_create' => 'Ο υποτομέας δημιουργήθηκε',
    'actionlog__event_site_subdomain_delete' => 'Ο υποτομέας διαγράφηκε',
    'actionlog__event_site_subdomain_update' => 'Ο υποτομέας ενημερώθηκε',

    'actionlog__event_site_alias_create' => 'Το ψευδώνυμο τομέα δημιουργήθηκε',
    'actionlog__event_site_alias_delete' => 'Το ψευδώνυμο τομέα διαγράφηκε',
    'actionlog__event_site_alias_update' => 'Το ψευδώνυμο τομέα ενημερώθηκε',

    'actionlog__event_site_alias_dns_update' => 'Η ζώνη DNS ενός ψευδωνύμου τομέα ενημερώθηκε',
    'actionlog__event_subdomain_dns_update' => 'Η ζώνη DNS ενός υποτομέα του προεπιλεγμένου τομέα ενημερώθηκε',
    'actionlog__event_site_subdomain_dns_update' => 'Η ζώνη DNS ενός υποτομέα ενημερώθηκε',
    // End of PfW only

    'rdp_app__type' => 'Εφαρμογή περιόδου λειτουργίας τερματικού',
    'rdp_app__msactivex' => 'Microsoft RDP ActiveX',
    'rdp_info__prop_title' => "Σύνδεση με το διακομιστή μέσω απομακρυσμένης επιφάνειας εργασίας",
    'rdp_info__session_title' => 'Περίοδος λειτουργίας τερματικού με το διακομιστή %1 (%2)',
    'rdp_info__prop_legend' => "Ιδιότητες περιόδου λειτουργίας τερματικού",
    'rdp_screen_resolution' => 'Ανάλυση οθόνης για την περίοδο λειτουργίας τερματικού',
    'rdp_user_name' => 'Όνομα χρήστη περιόδου λειτουργίας τερματικού',

    'win_policy__bad_password' => 'Η επικύρωση απέτυχε. Ο κωδικός πρόσβασης δεν είναι έγκυρος.',
    'win_policy__password_too_short' => 'Η επικύρωση απέτυχε.  Ο κωδικός πρόσβασης δεν ικανοποιεί τις απαιτήσεις πολιτικής επειδή έχει πολύ μικρό μήκος.',
    'win_policy__password_too_long' => 'Η επικύρωση απέτυχε.  Ο κωδικός πρόσβασης δεν ικανοποιεί τις απαιτήσεις πολιτικής επειδή έχει πολύ μεγάλο μήκος.',
    'win_policy__password_not_complex_enough' => 'Η επικύρωση απέτυχε. Ο κωδικός πρόσβασης δεν είναι αρκετά περίπλοκος και δεν πληροί τις απαιτήσεις πολιτικής κωδικού πρόσβασης. Οι ισχυροί κωδικοί πρόσβασης πρέπει να περιέχουν τουλάχιστον όλα τα ακόλουθα: οκτώ χαρακτήρες, έναν κεφαλαίο ή πεζό χαρακτήρα, τρεις αριθμούς και έναν ειδικό χαρακτήρα (!, @, #, $, %, ^, &, *, ?, _, ~) ή έναν αριθμό και δύο ειδικούς χαρακτήρες.',

    //// Activation Code feature
    'key__tabs_activation' => 'Ενεργοποίηση κλειδιού άδειας χρήσης',
    'key__description' => 'Εδώ μπορείτε να εγκαταστήσετε το κλειδί άδειας χρήσης σας μέσω εισαγωγής του κωδικού ενεργοποίησης ή αποστολής ενός αρχείου κλειδιού άδειας χρήσης.',
    'key__description_code_only' => 'Εδώ μπορείτε να εγκαταστήσετε το κλειδί άδειας χρήσης σας, συμπληρώνοντας έναν κωδικό ενεργοποίησης.',
    'key__license_key' => 'Επιλέξτε ένα από τα παρακάτω:',
    'key__code_text' => 'Εισαγάγετε κωδικό ενεργοποίησης',
    'key__code_hint' => 'Επικολλήστε τον κωδικό ενεργοποίησης που λάβατε.',
    'key__file_text' => 'Αποστολή αρχείου κλειδιού άδειας χρήσης',
    'key__file_hint' => 'Καθορίστε τη διαδρομή προς το αρχείο που περιέχει το κλειδί της άδειας χρήσης.',
    'plesk_key__code_check_wrong' => 'Ο κωδικός ενεργοποίησης δεν είναι έγκυρος.',
    'plesk_key__license_update_failed' => 'Δεν είναι δυνατή η ενημέρωση της άδειας χρήσης του προϊόντος.',


    'filemanager__error_path_is_not_allowed' => 'Η διαδρομή δεν επιτρέπεται',
    'filemanager__error_path_is_invalid' => 'Η διαδρομή δεν είναι έγκυρη',
    'filemanager__error_path_not_found' => 'Η διαδρομή δεν βρέθηκε',
    'filemanager__error_path_already_exists' => 'Η διαδρομή υπάρχει ήδη',
    'filemanager__error_access_is_denied' => 'Η πρόσβαση απορρίφθηκε',
    'filemanager__error_directory_not_empty' => 'Ο φάκελος δεν είναι άδειος',
    'filemanager__error_sharing_violation' => 'Παραβίαση κοινής χρήσης',
    'filemanager__error_not_same_device' => 'Η διαδρομή του προορισμού δεν είναι στην ίδια συσκευή',
    'filemanager__binary_data_access' => 'Το αρχείο αυτό μπορεί να είναι δυαδικό αρχείο.  Θέλετε να το ανοίξετε;',
    'filemanager__unable_to_resolve_realpath' => "Δεν είναι δυνατή η εύρεση του αρχείου %1 στην καθορισμένη θέση",
    'filemanager__access_to_realpath_denied' => "Η πρόσβαση στο realpath απορρίφθηκε: %1 έως %2.",
    'bt_exit' => 'Έξοδος',

    'filemanager__chdir_error__' => "Δεν είναι δυνατή η αλλαγή του καταλόγου σε %1: %2",
    'filemanager__chmod_dir' => "Αλλαγή δικαιωμάτων για τον κατάλογο %1",
    'filemanager__chmod_error__' => "Δεν είναι δυνατή η αλλαγή των δικαιωμάτων για το αρχείο %1: %2",
    'filemanager__chmod_file' => "Αλλαγή δικαιωμάτων για το αρχείο %1",
    'filemanager__copy_error__' => "Δεν είναι δυνατή η αντιγραφή του %1 στο %2: %3",
    'filemanager__copy_move' => "Αντιγραφή (μετακίνηση) αρχείων από το %1",
    'filemanager__count_size__' => 'Επιλογή μεγέθους: %1',
    'filemanager__count_size_error__' => 'Δεν είναι δυνατός ο υπολογισμός του μεγέθους για το %1: %2',
    'filemanager__create_dir' => "Δημιουργία καταλόγου",
    'filemanager__create_dir_error__' => "Δεν ήταν δυνατή η δημιουργία του καταλόγου %1: %2",
    'filemanager__dir_not_exists' => "Ο κατάλογος %1 δεν υπάρχει.",
    'filemanager__dirname' => "Όνομα καταλόγου",
    'filemanager__filename' => "Όνομα αρχείου",
    'filemanager__is_no_such' => "Δεν υπάρχει αρχείο ή κατάλογος με το όνομα %1",
    'filemanager__empty_selection' => "Δεν έχουν επιλεγεί αρχεία.",
    'filemanager__file_exists' => "Το αρχείο %1 υπάρχει ήδη.",
    'filemanager__move_error__' => "Δεν ήταν δυνατή η μετακίνηση του %1 στο %2: %3",
    'filemanager__new_dir' => "Όνομα καταλόγου",
    'filemanager__not_allowed' => "Δεν επιτρέπεται η αλλαγή δικαιωμάτων σε αυτό το αρχείο.",
    'filemanager__r_perm_dir' => "Κατάλογος λίστας",
    'filemanager__r_perm_file' => "Ανάγνωση δεδομένων",
    'filemanager__remove' => "Κατάργηση αρχείων από το %1",
    'filemanager__remove_error__' => "Δεν είναι δυνατή η κατάργηση του αρχείου %1: %2",
    'filemanager__rename_dir' => "Μετονομασία καταλόγου %1",
    'filemanager__rename_error__' => "Δεν είναι δυνατή η μετονομασία του %1 σε %2: %3",
    'filemanager__rename_file' => "Μετονομασία αρχείου %1",
    'filemanager__set_win_permissions_dir' => "Ορισμός δικαιωμάτων για το φάκελο %1",
    'filemanager__set_win_permissions_file' => "Ορισμός δικαιωμάτων για το αρχείο %1",
    'filemanager__touch_confirm' => "Είστε βέβαιοι ότι θέλετε να αλλάξετε τη χρονική σήμανση των επιλεγμένων αρχείων;",
    'filemanager__no_perms_or_unsupported_file_type' => 'Δεν είναι δυνατή η ανάγνωση του αρχείου ή η μορφή του αρχείου δεν υποστηρίζεται.',
    'filemanager__upload_error__' => "Δεν ήταν δυνατή η αποστολή του %1 στο %2: %3",
    'filemanager__upload_file' => "Αποστολή αρχείου",
    'filemanager__upload_file_src' => "Διαδρομή αρχείου",
    'filemanager__username' => "Χρήστης",
    'filemanager__w_perm_dir' => "Δημιουργία αρχείων",
    'filemanager__w_perm_file' => "Εγγραφή δεδομένων",
    'filemanager__x_perm_dir' => "Κατάλογος Traverse",
    'filemanager__x_perm_file' => "Εκτέλεση αρχείου",
    'filemanager__max_image_size_exceeded' => 'Δεν είναι δυνατή η εμφάνιση της εικόνας.  Το μέγεθος της εικόνας δεν είναι δυνατόν να είναι μεγαλύτερο από %2 byte',

    '__fastcgi_unix_support' => 'Υποστήριξη FastCGI',

    'ts_sessions_list' => 'Αυτή η σελίδα εμφανίζει τη λίστα όλων των περιόδων λειτουργίας υπηρεσιών τερματικού.',
    'b_tssessionslist_search' => 'Αναζήτηση περιόδων λειτουργίας με βάση το όνομα.',
    'b_tssessionslist_show_all' => 'Εμφάνιση όλων των περιόδων λειτουργίας υπηρεσιών τερματικού.',
    'l_tssessionslist_state' => 'Ταξινόμηση με βάση την κατάσταση.',
    'l_tssessionslist_name' => 'Ταξινόμηση με βάση το όνομα.',
    'l_tssessionslist_user' => 'Ταξινόμηση με βάση το χρήστη.',
    'b_tssessionslist_logoff' => 'Κάντε κλικ για να αποσυνδεθείτε από τις επιλεγμένες περιόδους λειτουργίας.',
    'b_tssessionslist_disconnect' => 'Κάντε κλικ για να αποσυνδέσετε τις επιλεγμένες περιόδους λειτουργίας.',
    'tssessions_info' => 'Προβολή ιδιοτήτων περιόδου λειτουργίας.',
    'tssessions_disconnect' => 'Επιλέξτε το πλαίσιο ελέγχου Επιβεβαίωση κατάργησης και κάντε κλικ στο OK για να αποσυνδέσετε τις επιλεγμένες περιόδους λειτουργίας διακομιστή τερματικού.',
    'tssessions_logoff' => 'Επιλέξτε το πλαίσιο ελέγχου Επιβεβαίωση κατάργησης και κάντε κλικ στο OK για να πραγματοποιηθεί έξοδος από τις επιλεγμένες περιόδους λειτουργίας διακομιστή τερματικού.',
    'b_tssession_disconnect_submit' => 'Κάντε κλικ για να υποβάλετε τις αλλαγές.',
    'b_tssession_logoff' => 'Κάντε κλικ για να αποσυνδεθείτε από την περίοδο λειτουργίας.',
    'b_tssession_logoff_submit' => 'Κάντε κλικ για να υποβάλετε τις αλλαγές.',
    'i_tssession_active' => 'Ενεργό',
    'i_tssession_connected' => 'Σε σύνδεση',
    'i_tssession_disconnected' => 'Αποσυνδεδεμένο',
    'i_tssession_listen' => 'Ακρόαση',
    'tssessions__tssessionslist' => 'Περίοδοι λειτουργίας',
    'tssessionslist__state' => 'Κ',
    'tssessionslist__name' => 'Όνομα',
    'tssessionslist__user' => 'Χρήστης',
    'bt_logoff_selected' => 'Αποσύνδεση',
    'bt_logoff' => "Αποσύνδεση",
    'bt_disconnect_selected' => 'Αποσύνδεση',
    'bt_tssession_logoff' => 'Αποσύνδεση',
    'bt_tssession_disconnect' => 'Αποσύνδεση',
    'bt_tssession_disconect' => 'Αποσύνδεση',
    'b_tssession_disconnect' => 'Κάντε κλικ για να αποσυνδέσετε την περίοδο λειτουργίας.',
    'b_tssession_logoff_disabled' => 'Δεν ήταν δυνατή η αποσύνδεση από την περίοδο λειτουργίας.',
    'b_tssession_disconnect_disabled' => 'Δεν είναι δυνατή η αποσύνδεση της περιόδου λειτουργίας.',
    'tssessions_info__title' => 'Ιδιότητες περιόδου λειτουργίας %1',
    'tssessions_info__property_name' => 'Όνομα ιδιότητας',
    'tssessions_info__property_value' => 'Τιμή ιδιότητας',
    'tssessions__disconnect_title' => 'Οι παρακάτω περίοδοι λειτουργίας υπηρεσιών τερματικού θα αποσυνδεθούν:',
    'tssessions__session_cant_disconnect' => 'η περίοδος λειτουργίας δεν μπορεί να αποσυνδεθεί',
    'tssessions__logoff_title' => 'Θα πραγματοποιηθεί έξοδος από τις παρακάτω περιόδους λειτουργίας υπηρεσιών τερματικού:',
    'tssessions__session_cant_logoff' => 'δεν μπορεί να πραγματοποιηθεί έξοδος από την περίοδο λειτουργίας',
    'tssessions__select_sessions_to_logoff' => 'Επιλέξτε τις περιόδους λειτουργίας από τις οποίες θα πραγματοποιηθεί έξοδος.',
    'tssessions__select_sessions_to_disconnect' => 'Επιλέξτε τις περιόδους λειτουργίας που θα αποσυνδεθούν.',
    'dns__subdomain_dns_zone_parent' => 'Οι εγγραφές DNS του συγκεκριμένου υποτομέα είναι αποθηκευμένες στη γονική ζώνη DNS.  Μπορείτε να τροποποιήσετε τη γονική ζώνη %1 ή να δημιουργήσετε μια ξεχωριστή ζώνη για τον υποτομέα.',
    'dns__subdomain_dns_zone_parent_link' => 'εδώ',
    'dns__no_dns_zone' => 'Δεν έχει εκχωρηθεί κάποια ζώνη DNS στον τομέα. Για να διαχειριστείτε τη ζώνη DNS του τομέα σας, πρέπει να πατήσετε το κουμπί \'Επαναφορά προεπιλογών\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Δεν είναι δυνατή η αλλαγή της ζώνης του υποτομέα επειδή υπάρχει μια εγγραφή CNAME γι\' αυτόν τον υποτομέα στη ζώνη του γονικού τομέα του.',

    '__hosting_write_modify' => 'Πρόσθετα δικαιώματα εγγραφής/τροποποίησης',


    'aspdotnet__title' => "Ρύθμιση παραμέτρων ASP.NET σε επίπεδο διακομιστή",
    'aspdotnet__dom_title' => "Ρύθμιση παραμέτρων ASP.NET για την τοποθεσία web",
    'aspdotnet__wdir_title' => "Ρύθμιση παραμέτρων ASP.NET για τον εικονικό κατάλογο %1",
    'aspdotnet__group_cas_settings' => "Ασφάλεια πρόσβασης κώδικα",
    'aspdotnet__group_client_scripts' => "Ρυθμίσεις βιβλιοθήκης δέσμης ενεργειών",
    'aspdotnet__group_conn_strings' => "Διαχείριση συμβολοσειράς σύνδεσης",
    'aspdotnet__group_custom_errors' => "Προσαρμοσμένες ρυθμίσεις σφάλματος",
    'aspdotnet__group_framework_version' => "Έκδοση Framework",
    'aspdotnet__group_globalization' => "Καθολικές ρυθμίσεις",
    'aspdotnet__group_other' => "Ρυθμίσεις περιόδου λειτουργίας",
    'aspdotnet__group_page_and_runtime' => "Μεταγλώττιση και Εντοπισμός σφαλμάτων",
    'aspdotnet__invalid_dom_config_file' => "Το αρχείο ρύθμισης παραμέτρων ASP.NET για τη συγκεκριμένη τοποθεσία web είναι αλλοιωμένο.  Για να το επαναφέρετε, εφαρμόστε την προεπιλεγμένη ρύθμιση παραμέτρων ASP.NET κάνοντας κλικ στο Ορισμός της Προεπιλογής.",
    'aspdotnet__invalid_file_enc' => "Μη έγκυρη τιμή για την παράμετρο κωδικοποίησης αρχείου.",
    'aspdotnet__invalid_req_enc' => "Μη έγκυρη τιμή για την παράμετρο κωδικοποίησης αίτησης.",
    'aspdotnet__invalid_res_enc' => "Μη έγκυρη τιμή για την παράμετρο κωδικοποίησης απόκρισης.",
    'aspdotnet__invalid_parent_wdir_config_file' => "Το αρχείο ρύθμισης παραμέτρων ASP.NET έχει αλλοιωθεί λόγω της κατεστραμμένης ρύθμισης παραμέτρων ASP.NET στον γονικό κατάλογο %1. \n\n Για να επιλύσετε αυτό το πρόβλημα, εκτελέστε επαναφορά της ρύθμισης παραμέτρων ASP.NET του %1.",
    'aspdotnet__invalid_global_config_file_admin' => "Η ρύθμιση παραμέτρων ASP.NET έχει αλλοιωθεί λόγω του κατεστραμμένου αρχείου ρύθμισης παραμέτρων ASP.NET του διακομιστή.",
    'aspdotnet__invalid_global_config_file' => "Η ρύθμιση παραμέτρων ASP.NET έχει αλλοιωθεί λόγω του κατεστραμμένου αρχείου ρύθμισης παραμέτρων ASP.NET του διακομιστή.  Επικοινωνήστε με τον πάροχο υπηρεσιών σας για βοήθεια.",
    'aspdotnet__invalid_sess_timeout' => "Μη έγκυρη τιμή για την παράμετρο χρονικού ορίου περιόδου λειτουργίας.  Εισαγάγετε έναν θετικό ακέραιο αριθμό μικρότερο ή ίσο του %1.",
    'aspdotnet__invalid_wdir_config_file' => "Το αρχείο ρύθμισης παραμέτρων ASP.NET γι' αυτόν τον εικονικό κατάλογο είναι αλλοιωμένο.  Για να το επαναφέρετε, εφαρμόστε τη ρύθμιση παραμέτρων ASP.NET του γονικού καταλόγου κάνοντας κλικ στο Ορισμός της Προεπιλογής.",
    'aspdotnet__param_auth_mode' => "Λειτουργία ελέγχου ταυτότητας",
    'aspdotnet__param_conn_strings' => "Συμβολοσειρές σύνδεσης",
    'aspdotnet__param_conn_string_name' => "Όνομα",
    'aspdotnet__param_conn_string_value' => "Παράμετροι σύνδεσης",
    'aspdotnet__param_culture' => "Κουλτούρα",
    'aspdotnet__param_custom_err_mode' => "Λειτουργία προσαρμοσμένου σφάλματος",
    'aspdotnet__param_custom_error_redirect' => "Διεύθυνση URL ανακατεύθυνσης",
    'aspdotnet__param_custom_error_status' => "Κωδικός κατάστασης",
    'aspdotnet__param_custom_errors' => "Προσαρμοσμένα σφάλματα",
    'aspdotnet__param_debug_mode' => "Ενεργοποίηση εντοπισμού σφαλμάτων",
    'aspdotnet__param_def_language' => "Προεπιλεγμένη γλώσσα ιστοσελίδας",
    'aspdotnet__param_temp_directory' => "Προσωρινός κατάλογος",
    'aspdotnet__param_file_enc' => "Κωδικοποίηση αρχείου",
    'aspdotnet__param_req_enc' => "Κωδικοποίηση αίτησης",
    'aspdotnet__param_res_enc' => "Κωδικοποίηση απόκρισης",
    'aspdotnet__param_sess_timeout' => "Λήξη περιόδου λειτουργίας (λεπτά)",
    'aspdotnet__param_trust_level' => "Επίπεδο αξιοπιστίας CAS",
    'aspdotnet__param_ui_culture' => "Κουλτούρα περιβάλλοντος χρήστη",
    'aspdotnet__param_version' => "Έκδοση",
    'aspdotnet__param_trust_level_allow_override' => 'Να επιτρέπεται η αλλαγή του επιπέδου αξιοπιστίας CAS για μεμονωμένες τοποθεσίες web',
    'aspdotnet__restore_default_confirm' => "Επαναφορά των προεπιλεγμένων ρυθμίσεων ASP.NET;",

    'bt_restore_default' => "Ορισμός της Προεπιλογής",
    'b_aspdotnet' => 'Επεξεργασία ρυθμίσεων παραμέτρων ASP.NET.',
    'b_aspdotnet__restore_default' => 'Επαναφορά των προεπιλεγμένων ρυθμίσεων ASP.NET.',
    'b_aspdotnet__restore_wdir_default' => "Επαναφορά ρυθμίσεων ASP.NET του γονικού καταλόγου γι' αυτόν τον εικονικό κατάλογο.",
    'b_aspdotnet__restore_default_disabled' => 'Η επαναφορά των προεπιλεγμένων ρυθμίσεων παραμέτρων ASP.NET δεν είναι διαθέσιμη: Η ρύθμιση παραμέτρων ASP.NET έχει αλλοιωθεί σε επίπεδο διακομιστή ή γονικού καταλόγου.',
    'b_autoinstaller' => 'Ενημέρωση Plesk ή των στοιχείων του.',
    'b_autoinstaller_configure' => 'Ενημέρωση ρυθμίσεων.',
    'b_autoinstaller_install' => 'Εγκατάσταση επιλεγμένων στοιχείων.',

    '__iis_app_pool__use_dedicated' => 'Αποκλειστικός χώρος συγκέντρωσης εφαρμογών IIS',
    '__iis_app_pool__use_dedicated_addons' => 'Αποκλειστικός χώρος συγκέντρωσης εφαρμογών IIS για κάθε τοποθεσία web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Ενεργοποίηση εφαρμογών 32-Bit',
    'bt_iis_app_pool' => "Χώρος συγκέντρωσης εφαρμογών IIS",

    'performance__cpu_usage' => 'Μέγιστη χρήση CPU (%)',
    'performance__cpu_usage_action' => 'Ενέργεια περιορισμού',
    'performance__cpu_usage_interval' => 'Διάστημα περιορισμού (λεπτά)',
    'performance__cpu_usage_action_not_supported' => 'Η καθορισμένη ενέργεια δεν υποστηρίζεται από τον διακομιστή web.',

    'performance__idle_timeout_action_not_supported' => 'Η καθορισμένη ενέργεια χρονικού ορίου αδράνειας δεν υποστηρίζεται από τον διακομιστή web.',
    'performance__max_worker_processes' => 'Ο μέγιστος αριθμός διεργασιών εργασίας',
    'performance__idle_timeout' => 'Χρονικό όριο αδράνειας (λεπτά)',
    'performance__idle_timeout_action' => 'Ενέργεια χρονικού ορίου αδράνειας',
    'performance__recycling_by_time' => 'Ανακύκλωση ανά τακτά χρονικά διαστήματα (λεπτά)',
    'performance__recycling_by_requests' => 'Ανακύκλωση όταν επιτυγχάνεται ο μέγιστος αριθμός αιτήσεων',
    'performance__recycling_by_virtual_memory' => 'Ανακύκλωση όταν χρησιμοποιείται το μέγιστο ποσοστό εικονικής μνήμης',
    'performance__recycling_by_private_memory' => 'Ανακύκλωση όταν χρησιμοποιείται το μέγιστο ποσοστό ιδιωτικής μνήμης',
    'performance__managed_pipeline_mode' => 'Διαχειριζόμενη λειτουργία διοχέτευσης',
    'performance__managed_pipeline_mode_not_supported' => 'Η καθορισμένη λειτουργία δεν υποστηρίζεται από τον διακομιστή web.',

    'iis_app_pool' => 'Διαχείριση χώρου συγκέντρωσης εφαρμογών IIS.',
    'b_iis_app_pool' => 'Διαχείριση χώρου συγκέντρωσης εφαρμογών IIS.',
    'iis_app_pool_cl_dom' => 'Διαχείριση χώρου συγκέντρωσης εφαρμογών IIS.',

    'i_webdirs_not_protected' => 'Ο κατάλογος αυτός δεν προστατεύεται.',
    'i_webdirs_protected' => 'Ο κατάλογος αυτός προστατεύεται.',
    'i_webdirs_manage_protection' => 'Διαχείριση προστασίας.',
    'i_webdirs_open' => 'Άνοιγμα καταλόγου/αρχείου στο πρόγραμμα περιήγησης.',
    'i_webdirs_preferences_disabled' => 'Ο κατάλογος αυτός δεν είναι εικονικός κατάλογος.',
    'i_webdirs_permissions' => 'Διαχείριση δικαιωμάτων.',
    'i_webdirs_permissions_disabled' => 'Η διαχείριση δικαιωμάτων καταλόγων δεν είναι διαθέσιμη.',
    'i_webdirs_type_dir' => 'Φυσικός κατάλογος',
    'i_webdirs_type_vdir' => 'Εικονικός κατάλογος',
    'i_webdirs_browse' => 'Περιήγηση στα περιεχόμενα του καταλόγου.',
    'i_webdirs_preferences' => 'Διαχείριση ρυθμίσεων καταλόγου web.',

    'l_webdirslist_type' => 'Ταξινόμηση καταλόγων με βάση τον τύπο.',
    'l_webdirslist_protected' => 'Ταξινόμηση καταλόγων με βάση το καθεστώς προστασίας.',
    'l_webdirslist_name' => 'Ταξινόμηση καταλόγων με βάση το όνομα.',

    'b_webdirslist_remove' => 'Διαγραφή των επιλεγμένων εικονικών καταλόγων.',
    'b_webdirslist_search' => 'Εισαγάγετε ένα συνδυασμό αναζήτησης και κάντε κλικ για εύρεση εικονικών καταλόγων.',
    'b_webdirslist_show_all' => 'Προβολή όλων των καταλόγων.',

    'l_webdirerrordocslist_code' => 'Ταξινόμηση εγγράφων σφάλματος με βάση τον αριθμό κωδικού σφάλματος.',
    'l_webdirerrordocslist_name' => 'Ταξινόμηση εγγράφων σφάλματος με βάση την περιγραφή του σφάλματος.',
    'l_webdirerrordocslist_type' => 'Ταξινόμηση εγγράφων σφάλματος με βάση τον τύπο του εγγράφου σφάλματος.',
    'l_webdirerrordocslist_location' => 'Ταξινόμηση εγγράφων σφάλματος με βάση την τοποθεσία του εγγράφου σφάλματος.',

    'b_webdirerrordocslist_search' => 'Εισαγάγετε ένα συνδυασμό αναζήτησης και κάντε κλικ για εύρεση εγγράφων σφάλματος.',
    'b_webdirerrordocslist_remove' => 'Διαγραφή επιλεγμένων εγγράφων σφάλματος.',
    'b_webdirerrordocslist_show_all' => 'Εμφάνιση όλων των εγγράφων σφάλματος.',

    'l_webdirmimetypeslist_name' => 'Ταξινόμηση τύπων MIME με βάση την επέκταση.',
    'l_webdirmimetypeslist_content' => 'Ταξινόμηση τύπων MIME με βάση το περιεχόμενο.',

    'b_webdirmimetypeslist_remove' => 'Διαγραφή επιλεγμένων τύπων MIME.',
    'b_webdirmimetypeslist_search' => 'Εισαγάγετε ένα συνδυασμό αναζήτησης και κάντε κλικ για εύρεση τύπων MIME.',
    'b_webdirmimetypeslist_show_all' => 'Εμφάνιση όλων των τύπων MIME.',

    'b_webdir_preferences' => "Ρυθμίσεις εικονικών καταλόγων.",
    'b_webdir_permissions' => "Δικαιώματα εικονικών καταλόγων.",
    'b_webdir_permissions_disabled' => "Η διαχείριση δικαιωμάτων καταλόγων δεν είναι διαθέσιμη.",
    'b_to_webdirs' => 'Επιστροφή στη διαχείριση των καταλόγων.',
    'b_to_webdir_mime_types' => 'Επιστροφή στη διαχείριση των τύπων MIME.',
    'b_to_webdir_error_docs' => 'Επιστροφή στην διαχείριση των εγγράφων σφάλματος.',
    'b_to_webdir_protection' => 'Επιστροφή στη διαχείριση της προστασίας εικονικού καταλόγου.',

    'webdirs__title' => 'Εικονικός κατάλογος %1',
    'webdirs__preferences_title' => 'Ρυθμίσεις εικονικού καταλόγου',
    'webdirs__list_legend' => 'Εικονικοί κατάλογοι',
    'webdirs__list_type' => 'Τ',
    'webdirs__list_protected' => 'Π',
    'webdirs__list_name' => 'Όνομα',
    'webdirs__list_header' => '%1 στοιχεία',
    'webdirs__tabs_general' => 'Γενικά',
    'webdirs__tabs_mime_types' => 'Τύποι MIME',
    'webdirs__tabs_error_docs' => 'Έγγραφα σφάλματος',

    'webdirs__tabs_permissions' => 'Δικαιώματα',
    'webdir__remove_vdirs' => 'Οι παρακάτω εικονικοί κατάλογοι θα διαγραφούν:',
    'webdir__remove_mime_types' => 'Οι παρακάτω τύποι MIME θα διαγραφούν:',
    'webdir__mime_types_title' => 'Τύποι MIME',
    'webdir__protection_disable_confirm' => 'Θέλετε σίγουρα να καταργήσετε την προστασία από τον κατάλογο;',
    'webdir__protect_title' => 'Χρήστες προστατευμένων URL',
    'webdirs__permissions_title' => 'Δικαιώματα εικονικών καταλόγων',
    'webdirs__browse_content_permission_denied' => 'Δεν έχετε δικαιώματα προβολής των περιεχομένων αυτού του καταλόγου.',
    'error_doc__list_code' => 'Σφάλμα',
    'error_doc__list_code_description' => 'Περιγραφή',
    'error_doc__list_type' => 'Τύπος',
    'error_doc__list_location' => 'Τοποθεσία',
    'error_doc__code' => 'Σφάλμα',
    'error_doc__type' => 'Τύπος',
    'error_doc__type_file' => 'Αρχείο',
    'error_doc__type_url' => 'Διεύθυνση URL',
    'error_doc__location' => 'Τοποθεσία',
    'error_doc__legend' => 'Έγγραφο σφάλματος',
    'error_doc__edit_title' => 'Επεξεργασία εγγράφου σφάλματος',
    'error_doc_erorr_invalid_url_location' => 'Η διεύθυνση URL δεν είναι έγκυρη.  Προσδιορίστε τη σωστή διεύθυνση URL.',
    'error_doc_erorr_invalid_file_location' => 'Η διαδρομή αρχείου δεν είναι έγκυρη.  Προσδιορίστε τη σωστή διαδρομή του αρχείου.',
    'error_doc__type_default' => 'Προεπιλογή',

    'webdirs__tabs_protection' => 'Προστασία',
    'pb_webdirs' => 'Εικονικοί κατάλογοι',

    'webdirs_remove_title' => 'Οι παρακάτω εικονικοί κατάλογοι θα καταργηθούν:',
    'webdirs_mime_types_remove_title' => 'Οι παρακάτω τύποι MIME θα καταργηθούν:',
    'webdirs_preferences_title' => 'Ρυθμίσεις εικονικού καταλόγου',
    'webdirs_permissions_title' => 'Ειδικά δικαιώματα για αρχεία και φακέλους',
    'webdi_protection_disable_confirm' => 'Είστε βέβαιοι ότι θέλετε να καταργήσετε την προστασία από τον εικονικό κατάλογο;  Αυτό θα διαγράψει επίσης όλους τους χρήστες του προστατευμένου καταλόγου καθώς και όλες τις ρυθμίσεις προστασίας του καταλόγου.',
    'bt_protect' => 'Προστασία',
    'bt_unprotect' => 'Κατάργηση προστασίας',
    'bt_show_additional_users' => 'Εμφάνιση περισσότερων χρηστών',
    'bt_hide_additional_users' => 'Εμφάνιση λιγότερων χρηστών',
    'error_doc__list_title' => 'Έγγραφα σφάλματος',
    'error_doc__list_header' => 'Έγγραφα σφάλματος',
    'error_doc__code_400' => 'Λανθασμένη αίτηση',
    'error_doc__code_401' => 'Μη εξουσιοδοτημένη πρόσβαση',
    'error_doc__code_401.1' => 'Μη εξουσιοδοτημένη πρόσβαση - Η σύνδεση απέτυχε',
    'error_doc__code_401.2' => 'Μη εξουσιοδοτημένη πρόσβαση - Η σύνδεση απέτυχε εξαιτίας της ρύθμισης παραμέτρων του διακομιστή',
    'error_doc__code_401.3' => 'Μη εξουσιοδοτημένη πρόσβαση - Χωρίς εξουσιοδότηση λόγω του ACL στον πόρο',
    'error_doc__code_401.4' => 'Μη εξουσιοδοτημένη πρόσβαση - Η εξουσιοδότηση απέτυχε λόγω φίλτρου',
    'error_doc__code_401.5' => 'Μη εξουσιοδοτημένη πρόσβαση - Η εξουσιοδότηση απέτυχε λόγω της εφαρμογής ISAPI/CGI',
    'error_doc__code_401.7' => 'Μη εξουσιοδοτημένη πρόσβαση - Απορρίφθηκε λόγω της πολιτικής εξουσιοδότησης URL',
    'error_doc__code_403' => 'Απαγορεύεται η πρόσβαση',
    'error_doc__code_403.1' => 'Απαγορεύεται η πρόσβαση - Δεν επιτρέπεται η πρόσβαση για εκτέλεση',
    'error_doc__code_403.2' => 'Απαγορεύεται η πρόσβαση - Δεν επιτρέπεται η πρόσβαση για ανάγνωση',
    'error_doc__code_403.3' => 'Απαγορεύεται η πρόσβαση - Δεν επιτρέπεται η πρόσβαση για εγγραφή',
    'error_doc__code_403.4' => 'Απαγορεύεται η πρόσβαση - Απαιτείται SSL',
    'error_doc__code_403.5' => 'Απαγορεύεται η πρόσβαση - Απαιτείται SSL 128',
    'error_doc__code_403.6' => 'Απαγορεύεται η πρόσβαση - Η διεύθυνση IP απορρίφθηκε',
    'error_doc__code_403.7' => 'Απαγορεύεται η πρόσβαση - Απαιτείται πιστοποιητικό προγράμματος-πελάτη',
    'error_doc__code_403.8' => 'Απαγορεύεται η πρόσβαση - Δεν επιτρέπεται η πρόσβαση στην τοποθεσία',
    'error_doc__code_403.9' => 'Απαγορεύεται η πρόσβαση - Πάρα πολλοί χρήστες',
    'error_doc__code_403.10' => 'Απαγορεύεται η πρόσβαση - Μη έγκυρη ρύθμιση παραμέτρων',
    'error_doc__code_403.11' => 'Απαγορεύεται η πρόσβαση - Αλλαγή κωδικού πρόσβασης',
    'error_doc__code_403.12' => 'Απαγορεύεται η πρόσβαση - Η πρόσβαση απορρίφθηκε από τον πίνακα αντιστοίχισης',
    'error_doc__code_403.13' => 'Απαγορεύεται η πρόσβαση - Το πιστοποιητικό προγράμματος-πελάτη έχει ανακληθεί',
    'error_doc__code_403.14' => 'Απαγορεύεται η πρόσβαση - Δεν επιτρέπεται η εμφάνιση των περιεχομένων του καταλόγου',
    'error_doc__code_403.15' => 'Απαγορεύεται η πρόσβαση - Υπέρβαση ορίου αδειών πρόσβασης υπολογιστών-πελατών',
    'error_doc__code_403.16' => 'Απαγορεύεται η πρόσβαση - Το πιστοποιητικό προγράμματος-πελάτη δεν είναι αξιόπιστο ή είναι αλλοιωμένο',
    'error_doc__code_403.17' => 'Απαγορεύεται η πρόσβαση - Το πιστοποιητικό υπολογιστή-πελάτη έχει λήξει ή δεν είναι ακόμη έγκυρο',
    'error_doc__code_403.18' => 'Απαγορεύεται η πρόσβαση - Δεν είναι δυνατή η εκτέλεση της αίτησης από αυτόν το χώρο συγκέντρωσης εφαρμογών',
    'error_doc__code_403.19' => 'Απαγορεύεται η πρόσβαση - Δεν επιτρέπεται η πρόσβαση στο CGI',
    'error_doc__code_403.20' => 'Απαγορεύεται η πρόσβαση - Αποτυχία σύνδεσης Passport',
    'error_doc__code_404' => 'Δεν βρέθηκε',
    'error_doc__code_404.2' => 'Δεν βρέθηκε - Απορρίφθηκε λόγω της πολιτικής κλειδώματος',
    'error_doc__code_404.3' => 'Δεν βρέθηκε - Απορρίφθηκε λόγω της πολιτικής MIMEMAP',
    'error_doc__code_405' => 'Η μέθοδος δεν επιτρέπεται',
    'error_doc__code_406' => 'Δεν είναι αποδεκτό',
    'error_doc__code_407' => 'Απαιτείται έλεγχος ταυτότητας διακομιστή μεσολάβησης',
    'error_doc__code_412' => 'Η προϋπόθεση απέτυχε',
    'error_doc__code_414' => 'Πολύ μεγάλο URI αίτησης',
    'error_doc__code_415' => 'Τύπος μέσων που δεν υποστηρίζεται',
    'error_doc__code_500' => 'Εσωτερικό σφάλμα διακομιστή',
    'error_doc__code_500.12' => 'Εσωτερικό σφάλμα διακομιστή - Επανεκκίνηση εφαρμογής',
    'error_doc__code_500.13' => 'Εσωτερικό σφάλμα διακομιστή - Ο διακομιστής είναι απασχολημένος',
    'error_doc__code_500.15' => 'Εσωτερικό σφάλμα διακομιστή - Δεν επιτρέπονται απευθείας αιτήσεις για το GLOBAL.ASA',
    'error_doc__code_500.16' => 'Εσωτερικό σφάλμα διακομιστή - Σφάλμα πρόσβασης UNC',
    'error_doc__code_500.17' => 'Εσωτερικό σφάλμα διακομιστή - Δεν είναι δυνατή η εύρεση του χώρου αποθήκευσης εξουσιοδοτήσεων URL',
    'error_doc__code_500.18' => 'Εσωτερικό σφάλμα διακομιστή - Δεν είναι δυνατό το άνοιγμα του χώρου αποθήκευσης εξουσιοδοτήσεων URL',
    'error_doc__code_500.19' => 'Εσωτερικό σφάλμα διακομιστή - Λανθασμένα μεταδεδομένα αρχείου',
    'error_doc__code_500.100' => 'Εσωτερικό σφάλμα διακομιστή - Σφάλμα ASP',
    'error_doc__code_501' => 'Δεν υλοποιήθηκε',
    'error_doc__code_502' => 'Λανθασμένη πύλη',
    'error_doc__code_503' => 'Η υπηρεσία δεν είναι διαθέσιμη προσωρινά',

    'mimetype__extension' => 'Επέκταση',
    'mimetype__content' => 'Περιεχόμενο',
    'mimetypeslist__title' => 'Τύποι MIME',
    'mimetypes__title' => 'Τύποι MIME',
    'mimetypes__select_to_remove' => 'Επιλέξτε τους τύπους MIME που θέλετε να καταργήσετε.',
    'mimetypes__select_for_remove' => "Επιλέξτε τους τύπους MIME που θα καταργηθούν.",
    'mimetypes_remove__title' => 'Κατάργηση τύπων MIME',
    'mimetype__legend' => 'Τύπος MIME',
    'mimetype_edit__title' => 'Επεξεργασία τύπου MIME',
    'mimetype_edit__already_exists' => 'Ο τύπος MIME έχει οριστεί ήδη γι\' αυτήν την επέκταση.',
    'mimetype_edit__not_exists' => 'Ο τύπος MIME δεν υπάρχει.',
    'mimetype__content_type_other' => 'Προσαρμοσμένο...',

    'b_webdir_protection_enable' => 'Ενεργοποίηση προστασίας με κωδικό πρόσβασης στη διεύθυνση URL που αντιστοιχεί στον κατάλογο.',
    'b_webdir_protection_disable' => 'Να καταστεί προσβάσιμο σε όλους η διεύθυνση URL που αντιστοιχεί στον κατάλογο.',
    'b_webdir_protection_disabled' => 'Η προστασία του εικονικού καταλόγου είναι απενεργοποιημένη.',

    'b_pd_usr_create' => 'Κάντε κλικ για να δημιουργήσετε αυτόν το χρήστη προστατευμένου URL.',
    'php__changeversion_title' => "Επιλογή έκδοσης PHP",
    'php__group_php_version' => "Έκδοση PHP",

    'virtualdir__name' => 'Όνομα',
    'virtualdir__path' => 'Διαδρομή',
    'virtualdir__read' => 'Δικαίωμα ανάγνωσης',
    'virtualdir__read_short' => 'Α',
    'virtualdir__write' => 'Δικαίωμα εγγραφής',
    'virtualdir__write_short' => 'Ε',
    'virtualdir__source' => 'Πρόσβαση στην προέλευση δέσμης ενεργειών',
    'virtualdir__source_short' => 'Κ',
    'virtualdir__browse' => 'Αναζήτηση στον κατάλογο',
    'virtualdir__browse_short' => 'Π',
    'virtualdir__script_execute' => 'Δικαιώματα εκτέλεσης',
    'virtualdir__script_execute_short' => 'Ε',
    'virtualdir__log_visits' => 'Καταγραφή επισκέψεων',
    'virtualdir__app_create' => 'Δημιουργία εφαρμογής',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Ενεργοποιεί τον ανώνυμο έλεγχο ταυτότητας.',
    'virtualdir__auth_windows' => 'Ενεργοποιεί τον έλεγχο ταυτότητας Windows.',
    'virtualdir__auth_not_enabled' => 'Πρέπει να ενεργοποιηθεί ο ανώνυμος έλεγχος ταυτότητας ή ο έλεγχος ταυτότητας Windows.',
    'virtualdir__require_ssl' => 'Να απαιτείται SSL/TLS',
    'virtualdir__enable_default_doc' => 'Χρήση προεπιλεγμένων εγγράφων',
    'virtualdir__default_doc' => 'Προεπιλεγμένη σειρά αναζήτησης εγγράφων',
    'virtualdir__enable_parent_paths' => 'Να επιτρέπεται η χρήση γονικών διαδρομών',
    'virtualdir__execute_in_mta' => 'Να επιτρέπεται η εκτέλεση εφαρμογών σε λειτουργία MTA (multi-threaded apartment)',
    'virtualdir_create__title' => 'Δημιουργία εικονικού καταλόγου στο %1',
    'virtualdir_edit__title' => 'Ιδιότητες του εικονικού καταλόγου %1',
    'virtualdir_edit__legend' => 'Εικονικός κατάλογος',
    'virtualdir_edit__application_legend' => 'Ρυθμίσεις εφαρμογής',
    'virtualdir_edit__security_legend' => 'Ασφάλεια καταλόγου',
    'virtualdir_edit__documents_legend' => 'Έγγραφα',
    'virtualdir_edit__list_legend' => 'Ένθετοι εικονικοί κατάλογοι',
    'virtualdir_error__path_not_in__' => 'Καθορίστηκε μη έγκυρη διαδρομή',
    'virtualdir_error__already_exists' => 'Υπάρχει ήδη ένας κατάλογος με αυτό το όνομα.',
    'virtualdir_root' => 'Εικονικοί κατάλογοι',
    'virtualdir_root__title' => 'Εικονικοί κατάλογοι',
    'virtualdir_root__list_legend' => 'Εικονικοί κατάλογοι',
    'virtualdir_se__none' => 'Καμία',
    'virtualdir_se__script' => 'Μόνο δέσμες ενεργειών',
    'virtualdir_se__script_execute' => 'Δέσμες ενεργειών και εκτελέσιμα αρχεία',
    'virtualdirs__title' => 'Εικονικοί κατάλογοι',
    'virtualdirs__path_not_exists' => 'Μη έγκυρη διαδρομή.',
    'virtualdirs__select_for_remove' => "Επιλέξτε τους εικονικούς καταλόγους που θα καταργηθούν.",
    'virtualdirs_remove__title' => 'Κατάργηση εικονικών καταλόγων',
    'virtualdirs_phys_dir_exist' => 'Υπάρχει ήδη φυσικός κατάλογος με αυτό το όνομα. Αν συνεχίσετε, θα καταστεί μη προσβάσιμος. Θέλετε να προχωρήσετε;',
    'virtualdir_auto_create_dir' => "Δημιουργία φυσικού καταλόγου με το ίδιο όνομα με τον εικονικό κατάλογο",

    'asp_max_default_text' => 'Ορίζεται από τον γονικό κατάλογο (%1 KB)',
    'asp_max_default_text_site' => 'Ορίζεται από το IIS (%1 KB)',
    'asp_max_buffer_text' =>'Μέγιστο μέγεθος του buffer ASP (KB)',
    'asp_max_body_text' => 'Μέγιστο μέγεθος του σώματος οντότητας μιας αίτησης ASP (KB)',
    'asp_buffers_legend' =>'Ρυθμίσεις ASP',

    'asp_debug_default_text' =>'Ορίζεται από τον γονικό κατάλογο',
    'asp_debug_default_text_site' =>'Ορίζεται από το IIS',
    'asp_client_debug_text' =>'Εντοπισμός σφαλμάτων για δέσμες ενεργειών ASP από την πλευρά του προγράμματος-πελάτη',
    'asp_server_debug_text' =>'Εντοπισμός σφαλμάτων για δέσμες ενεργειών ASP από την πλευρά του διακομιστή',

    'webdirs__list_with_broken_dirs' => "Υπάρχουν εικονικοί κατάλογοι που συνδέονται με ανύπαρκτους φυσικούς φακέλους.",
    'webdirs__vdir_physical_path_not_exist' => "Ο εικονικός κατάλογος συνδέεται με ένα φυσικό φάκελο που δεν υπάρχει.",
    'webdirs__physical_path_not_exist' => "Η καθορισμένη διαδρομή δεν υπάρχει.",

    'filemanager__new_dir_title' => 'Δημιουργία καταλόγου',
    'php__configuration_title' => "Ρύθμιση παραμέτρων PHP",

    'permissions__title' => 'Ρύθμιση δικαιωμάτων πρόσβασης',
    'permissions__title_advanced' => 'Ρύθμιση δικαιωμάτων προηγμένης πρόσβασης',
    'permissions__inherit_from_parent' => 'Να επιτρέπεται η εφαρμογή μεταβιβάσιμων δικαιωμάτων από το γονικό αντικείμενο σε αυτό το αντικείμενο και όλα τα θυγατρικά αντικείμενα.  Να συμπεριληφθούν αυτά με τις καταχωρήσεις που ορίζονται ρητά εδώ.',
    'permissions__replace_on_children' => 'Αντικατάσταση καταχωρήσεων δικαιωμάτων σε όλα τα θυγατρικά αντικείμενα με τις καταχωρήσεις που εμφανίζονται εδώ.',
    'permissions__group_or_user_name' => 'Ονόματα ομάδων ή χρηστών',
    'permissions__Permissions_for' => 'Δικαιώματα για',
    'permissions__allow' => 'Να επιτραπεί',
    'permissions__deny' => 'Απόρριψη',
    'permissions__FullControl' => 'Πλήρης έλεγχος',
    'permissions__Modify' => 'Τροποποίηση',
    'permissions__ReadAndExecute' => 'Ανάγνωση & Εκτέλεση',
    'permissions__ListFolderContents' => 'Λίστα περιεχομένων φακέλου',
    'permissions__Read' => 'Αναγνωσμένο',
    'permissions__Write' => 'Εγγραφή',
    'permissions__ReadControl' => 'Έλεγχος ανάγνωσης',
    'permissions__WriteControl' => 'Έλεγχος εγγραφής',
    'permissions__ExecuteControl' => 'Εκτέλεση ελέγχου',
    'permissions__TraverseFolderOrExecuteFile' => 'Αλλαγή φακέλου / Εκτέλεση αρχείου',
    'permissions__ListFolderOrRead' => 'Λίστα φακέλου / Ανάγνωση δεδομένων',
    'permissions__CreateFilesOrWrite' => 'Δημιουργία αρχείων / Εγγραφή δεδομένων',
    'permissions__CreateFoldersOrAppend' => 'Δημιουργία φακέλων / Προσάρτηση δεδομένων',
    'permissions__DeleteSubfoldersandFiles' => 'Διαγραφή υποφακέλων και αρχείων',
    'permissions__Delete' => 'Διαγραφή',
    'permissions__ChangePermissions' => 'Αλλαγή δικαιωμάτων',
    'permissions__TakeOwnership' => 'Ανάληψη κατοχής',
    'permissions__inherited_from' => 'Μεταβιβάστηκε από',
    'permissions__not_inherited' => '<δεν μεταβιβάστηκε>',
    'permissions__apply_to' => 'Εφαρμογή σε',
    'permissions__apply_onto' => 'Εφαρμογή σε:',
    'permissions__apply_onto1' => 'Μόνο αυτόν το φάκελο',
    'permissions__apply_onto2' => 'Υποφακέλους μόνο',
    'permissions__apply_onto3' => 'Αυτόν το φάκελο και τους υποφακέλους',
    'permissions__apply_onto4' => 'Αρχεία μόνο',
    'permissions__apply_onto5' => 'Αυτόν το φάκελο και τα αρχεία',
    'permissions__apply_onto6' => 'Υποφακέλους και αρχεία μόνο',
    'permissions__apply_onto7' => 'Αυτόν το φάκελο, τους υποφακέλους και τα αρχεία',

    'filemanager__not_allowed_dir' => "Δεν επιτρέπεται η αλλαγή δικαιωμάτων σε αυτόν το φάκελο.",

    'filemanager__allow' => "Να επιτραπεί",
    'filemanager__deny' => "Απόρριψη",
    'filemanager__user_domusr' => 'Διαχειριστής τοποθεσίας web',
    'filemanager__user_webusr' => 'Χρήστης web',
    'filemanager__user_admins' => 'Διαχειριστές',
    'filemanager__user_system' => 'ΣΎΣΤΗΜΑ',
    'filemanager__user_aspnet' => 'Χρήστης ASP.NET',
    'filemanager__user_poolusr' => 'Χρήστης χώρου συγκέντρωσης εφαρμογών',
    'filemanager__user_sysaccount' => 'Πρόσθετος χρήστης συστήματος',

    'bt_permissions_advanced' => 'Για προχωρημένους',
    'b_permissions_advanced' => 'Κάντε κλικ για να δείτε και να ορίσετε τα δικαιώματα ειδικής πρόσβασης.',

    'b_hotlinkprotection' => 'Ρύθμιση προστασίας hotlink για την τοποθεσία web.',
    'b_hotlinkprotection_on' => 'Ενεργοποίηση προστασίας hotlink για το περιεχόμενο της τοποθεσίας web.',
    'b_hotlinkprotection_off' => 'Απενεργοποίηση προστασίας hotlink για το περιεχόμενο της τοποθεσίας web.',

    'bt_hotlinkprotection' => 'Προστασία Hotlink',
    'hotlinkprotection__title' =>'Προστασία Hotlink',
    'hotlinkprotection__friend_domains' => 'Διευθύνσεις φιλικών τοποθεσιών web',
    'hotlinkprotection__extensions' => 'Προστατευμένες επεκτάσεις αρχείων',

    'hotlinkprotection_invalid_friend_domains' => 'Μη έγκυρα ονόματα για τους φιλικούς τομείς.',
    'hotlinkprotection_invalid_extensions' => 'Οι επεκτάσεις αρχείων περιέχουν μη έγκυρους χαρακτήρες.',

    'i_domain_alias_status_on' => 'Το ψευδώνυμο τομέα είναι ενεργοποιημένο.',
    'i_domain_alias_status_off' => 'Το ψευδώνυμο τομέα είναι απενεργοποιημένο.',
    'i_domain_alias_status_with_parent' => 'Το ψευδώνυμο τομέα έχει απενεργοποιηθεί επειδή ο τομέας είναι απενεργοποιημένος.',
    'i_domain_alias_turn_off' => 'Κάντε κλικ για απενεργοποίηση.',
    'i_domain_alias_turn_on' => 'Κάντε κλικ για ενεργοποίηση.',
    'i_domain_alias_mail_on' => 'Η υπηρεσία αλληλογραφίας είναι ενεργοποιημένη γι\' αυτό το ψευδώνυμο τομέα.',
    'i_domain_alias_mail_off' => 'Η υπηρεσία αλληλογραφίας είναι απενεργοποιημένη γι\' αυτό το ψευδώνυμο τομέα.',
    'i_domain_alias_mail_with_parent' => 'Η υπηρεσία αλληλογραφίας έχει απενεργοποιηθεί επειδή το ψευδώνυμο τομέα είναι απενεργοποιημένο.',
    'i_domain_alias_web_on' => 'Η υπηρεσία web είναι ενεργοποιημένη γι\' αυτό το ψευδώνυμο τομέα.',
    'i_domain_alias_web_off' => 'Η υπηρεσία web είναι απενεργοποιημένη γι\' αυτό το ψευδώνυμο τομέα.',
    'i_domain_alias_web_with_parent' => 'Η υπηρεσία web έχει απενεργοποιηθεί επειδή το ψευδώνυμο τομέα είναι απενεργοποιημένο.',
    'i_domain_alias_dns_on' => 'Η υπηρεσία ψευδωνύμων DNS είναι ενεργοποιημένη γι\' αυτό το ψευδώνυμο τομέα.',
    'i_domain_alias_dns_off' => 'Η υπηρεσία ψευδωνύμων DNS είναι απενεργοποιημένη γι\' αυτό το ψευδώνυμο τομέα.',
    'i_domain_alias_dns_with_parent' => 'Ο συγχρονισμός DNS με τον γονικό τομέα έχει απενεργοποιηθεί επειδή το ψευδώνυμο τομέα είναι απενεργοποιημένο.',
    'i_domain_alias_seoRedirect_on' => 'Η ανακατεύθυνση με τον κωδικό HTTP 301 είναι ενεργοποιημένη γι\' αυτό το ψευδώνυμο τομέα.',
    'i_domain_alias_seoRedirect_off' => 'Η ανακατεύθυνση με τον κωδικό HTTP 301 είναι απενεργοποιημένη γι\' αυτό το ψευδώνυμο τομέα.',
    'i_domain_alias_seoRedirect_with_parent' => 'Η ανακατεύθυνση με τον κωδικό HTTP 301 είναι απενεργοποιημένη επειδή το ψευδώνυμο τομέα είναι ανενεργό.',

    'domain_alias__control_title' => 'Ψευδώνυμο τομέα %1',
    'domain_alias__control_info_legend' => 'Πληροφορίες',
    'domain_alias__control_status_title' => 'Κ',
    'domain_alias__control_name_title' => 'Όνομα υπηρεσίας',
    'domain_alias__control_details_title' => 'Λεπτομέρειες',

    'domain_alias__invalid_values' => 'Το όνομα τομέα που καθορίσατε δεν είναι έγκυρο.  Τα ονόματα τομέα μπορούν να περιλαμβάνουν γράμματα, αριθμούς και παύλες.  Κάθε τμήμα του ονόματος τομέα ανάμεσα στις τελείες δεν πρέπει να υπερβαίνει τα 63 σύμβολα.',
    'domain_alias__domain_already_exists' => "Λανθασμένο όνομα ψευδωνύμου τομέα %1. Ο τομέας %1 υπάρχει ήδη.",
    'domain_alias__www_prefix_domain_already_exists' => "Λανθασμένο όνομα www ψευδωνύμου τομέα.%1. Το ψευδώνυμο αυτό έχει δημιουργηθεί ήδη για τον τομέα %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Λανθασμένο όνομα webmail ψευδωνύμου τομέα.%1. Το ψευδώνυμο αυτό έχει δημιουργηθεί ήδη για τον τομέα %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Λανθασμένο όνομα της λίστας ψευδωνύμων τομέα.%1. Το ψευδώνυμο αυτό έχει δημιουργηθεί ήδη για τον τομέα %1.',
    'domain_alias__dns_record_already_exists' => 'Δεν είναι δυνατή η δημιουργία του ψευδωνύμου τομέα %1 επειδή υπάρχει ήδη μια εγγραφή DNS που παραπέμπει στον κεντρικό υπολογιστή %1.',
    'domain_alias__domain_alias_already_exists' => "Υπάρχει ήδη ψευδώνυμο τομέα με αυτό το όνομα.",
    'domain_aliases__mail_server_not_support_aliases' => 'Ο διακομιστής αλληλογραφίας δεν υποστηρίζει τη δυνατότητα ψευδωνύμων τομέα.  Τα ψευδώνυμα τομέα μπορεί να μην λειτουργήσουν σωστά.',
    'domain_alias__restrict_domain_creation' => 'Το καθορισμένο όνομα ψευδωνύμου τομέα απαγορεύεται σύμφωνα με την πολιτική σε επίπεδο διακομιστή. Αν αυτό το όνομα ψευδωνύμου τομέα σας ανήκει, επικοινωνήστε με τον πάροχο υπηρεσιών φιλοξενίας σας.',
    'domain_alias__restrict_creation_with_www' => 'Εισαγάγετε ένα όνομα τομέα χωρίς το πρόθεμα \'www\'. Το πρόθεμα www για τον τομέα θα προστεθεί αυτόματα στη ρύθμιση παραμέτρων του διακομιστή web.',
    'domain_unable_to_set_name' => 'Λανθασμένο όνομα %1.',

    'domain_alias__domain_service_dns_disabled' => 'Αυτός ο τομέας εξυπηρετείται από άλλο διακομιστή DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Αυτός ο διακομιστής DNS λειτουργεί ως κύριος διακομιστής ονομάτων για τη συγκεκριμένη ζώνη DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Αυτός ο διακομιστής DNS λειτουργεί ως εξαρτώμενος διακομιστής ονομάτων για τη συγκεκριμένη ζώνη DNS.',
    'domain_alias__domain_service_mail_enabled' => 'Η υπηρεσία αλληλογραφίας είναι ενεργοποιημένη για τον τομέα.',
    'domain_alias__domain_service_mail_disabled' => 'Η υπηρεσία αλληλογραφίας είναι απενεργοποιημένη για τον τομέα.',
    'domain_alias__domain_service_mail_mx' => 'Το %1 χρησιμοποιείται ως διακομιστής αλληλογραφίας.',

    'domain_alias__service_seoRedirect_hint' => 'Όταν οι επισκέπτες ανοίγουν η διεύθυνση URL του ψευδωνύμου, θα ανακατευθύνονται στη διεύθυνση URL του κύριου τομέα. Το Plesk χρησιμοποιεί τη φιλική προς τις μηχανές αναζήτησης ανακατεύθυνση HTTP 301, κάτι που σημαίνει ότι η κατάταξη στις μηχανές αναζήτησης δεν θα μοιράζεται μεταξύ των διευθύνσεων URL.',

    'bt_task_run_now' => 'Εκτέλεση τώρα',
    'ftp__read_perm' => "Δικαίωμα ανάγνωσης",
    'ftp__write_perm' => "Δικαίωμα εγγραφής",

    'filemanager__upload_backup_file_hint' => 'Από εδώ μπορείτε να αποστείλετε τα αρχεία αντιγράφων ασφαλείας στον χώρο αποθήκευσης του Plesk. Το μέγιστο μέγεθος αρχείου περιορίζεται στα δύο gigabyte.',

    'additional_key__used' => 'ενεργοποιημένο',

    '__default_for_mssql' => 'προεπιλογή για MS SQL',

    '__login_does_not_pass_validation' => "Το όνομα χρήστη δεν είναι έγκυρο.  Βεβαιωθείτε ότι πληροί τις προϋποθέσεις: %1",
    '__login_allowed_symbols' => 'Επιτρέπονται μόνο αλφαριθμητικοί χαρακτήρες καθώς και τελείες, παύλες και χαρακτήρες υπογράμμισης.  Ο πρώτος χαρακτήρας πρέπει να είναι αλφαριθμητικός.',

    'restart__nginx' => 'Διακομιστής αντίστροφης μεσολάβησης (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Θα ήθελα να λαμβάνω γενικές πληροφορίες προϊόντων και ανακοινώσεις από την Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Θα ήθελα να λαμβάνω πληροφορίες σχετικά με την ασφάλεια και άλλες τεχνικές ειδοποιήσεις από το Plesk.",

    'server_preferences__webdeploy_include_password' => 'Να συμπεριλαμβάνεται ο κωδικός πρόσβασης χρήστη στο αρχείο με τις ρυθμίσεις δημοσίευσης Web Deploy',

    '__login_status_inactive' => 'Ο λογαριασμός σας είναι ανενεργός. Επικοινωνήστε με το διαχειριστή του Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Επιστροφή στη σελίδα Ρυθμίσεις & Εργαλεία.  Η μετεγκατάσταση θα συνεχιστεί στο παρασκήνιο.',

    'ui__admin-alias-info__description' => "Επεξεργασία στοιχείων επικοινωνίας του πρόσθετου λογαριασμού διαχειριστή.",
    'ui__admin-alias-info__short-title' => "Στοιχεία επικοινωνίας",
    'ui__admin-alias-info__title' => "Πληροφορίες πρόσθετου λογαριασμού διαχειριστή",
    'ui__admin-alias-password__description' => "Αλλαγή κωδικού πρόσβασης πρόσθετου διαχειριστή.",

    'ui__admin-alias-password__short-title' => "Αλλαγή κωδικού πρόσβασης",
    'ui__admin-alias-password__title' => "Κωδικός πρόσβασης πρόσθετου διαχειριστή",
    'ui__admin-alias__description' => "Προβολή και τροποποίηση πληροφοριών πρόσθετων λογαριασμών διαχειριστή.",

    'chk_js__warning_about_login_syntax' => "Στο όνομα χρήστη μπορείτε να χρησιμοποιήσετε πεζούς αλφαριθμητικούς χαρακτήρες, παύλα και το χαρακτήρα υπογράμμισης. Το όνομα χρήστη πρέπει να ξεκινά με αλφαβητικό σύμβολο. Ο κωδικός πρόσβασης δεν πρέπει να περιέχει το όνομα χρήστη ή εισαγωγικά.",
    'chk_js__warning_about_ftp_login_syntax' => "Στο όνομα χρήστη μπορείτε να χρησιμοποιήσετε αλφαριθμητικούς χαρακτήρες, παύλα και το χαρακτήρα υπογράμμισης.",
    'chk_js__warning_about_login_syntax_win' => "Στο όνομα χρήστη μπορείτε να χρησιμοποιήσετε πεζούς αλφαριθμητικούς χαρακτήρες, παύλα, τελεία και το χαρακτήρα υπογράμμισης.  Το όνομα χρήστη πρέπει να ξεκινά με αλφαβητικό σύμβολο ή αριθμό. Ο κωδικός πρόσβασης δεν πρέπει να περιέχει το όνομα χρήστη ή εισαγωγικά.",
    'chk_js__warning_about_passwd_syntax' => "Μη χρησιμοποιείτε εισαγωγικά, κενά και εθνικούς αλφαβητικούς χαρακτήρες στον κωδικό πρόσβασης.\nΟ κωδικός πρόσβασης πρέπει να αποτελείται από %1 έως %2 χαρακτήρες και δεν πρέπει να περιέχει το όνομα χρήστη.",
    'chk_js__warning_about_plesk_login_syntax' => "Στο όνομα χρήστη μπορείτε να χρησιμοποιήσετε πεζούς αλφαριθμητικούς χαρακτήρες, τελεία, παύλα και το χαρακτήρα υπογράμμισης.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Στο όνομα χρήστη μπορείτε να χρησιμοποιήσετε πεζούς αλφαριθμητικούς χαρακτήρες, παύλα και το χαρακτήρα υπογράμμισης.  Το όνομα χρήστη πρέπει να ξεκινά με αλφαβητικό σύμβολο.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Μη χρησιμοποιείτε εισαγωγικά, κενά και εθνικούς αλφαβητικούς χαρακτήρες στον κωδικό πρόσβασης.\nΟ κωδικός πρόσβασης πρέπει να αποτελείται από %1 έως %2 χαρακτήρες και δεν πρέπει να περιέχει το όνομα χρήστη.",
    'chk_js__warning_about_pam_passwd_error' => "Καθορίστηκε λανθασμένος λογαριασμός χρήστη συστήματος: %1",

    'cmd_server__admin_alias_not_found' => "Δεν είναι δυνατός ο εντοπισμός του πρόσθετου λογαριασμού διαχειριστή.",

    'panel_branding__skins_already_exists' => "Σημείωση: Το θέμα '%1' υπάρχει ήδη.  Θα αντικατασταθεί από το θέμα που εγκαθιστάτε αυτήν τη στιγμή.",
    'panel_branding__skins_file_exists' => "Δεν είναι δυνατή η δημιουργία καταλόγου για το θέμα '%1': Υπάρχει ήδη αρχείο με αυτό το όνομα.",

    'actionlog__login_failed' => 'αποτυχία σύνδεσης',
    'actionlog__event_cp_user_login_failed' => 'Η σύνδεση του χρήστη Plesk απέτυχε',
    'actionlog__api_login_failed' => 'η σύνδεση μέσω του API απέτυχε',
    'actionlog__event_cp_user_api_login_failed' => 'Η σύνδεση του χρήστη Plesk μέσω του API απέτυχε',
    'actionlog__pw_reset' => 'ζητήθηκε επαναφορά κωδικού πρόσβασης',

    'ch_pass_by_secret__email_subject' => "Υπενθύμιση κωδικού πρόσβασης Plesk",
    'ch_pass_by_secret__email_body' => "Γεια σας %2,\n\nΓια να δημιουργήσετε νέο κωδικό πρόσβασης, ακολουθήστε τη σύνδεση: %1\n\nΤα στοιχεία σύνδεσής σας: %3",
    'ch_pass_by_secret__message_send_error' => 'Δεν είναι δυνατή η αποστολή του μυστικού κωδικού: %1',
    'ch_pass_by_secret__title' => 'Αλλαγή του κωδικού πρόσβασής σας',
    'ch_pass_by_secret__secret' => 'Μυστικός κωδικός',

    'custom_button__noframe' => "Να μην χρησιμοποιούνται πλαίσια",

    'custom_button__internal_hint' => 'Καθορίστε αν η διεύθυνση URL θα ανοίγει σε σελίδα του Plesk ή σε νέο παράθυρο του προγράμματος περιήγησης.',
    'custom_button__noframe_hint' => 'Εάν προσθέσετε ένα προσαρμοσμένο κουμπί που οδηγεί σε μια επέκταση του Plesk ή σε μια εφαρμογή του Πίνακα Πελάτη, μπορείτε να καθορίσετε πώς θα εμφανίζεται αυτή η επέκταση/εφαρμογή: σε πλαίσιο ή τμήμα του GUI του Plesk.',


    'actionlog__patch' => 'Ενημέρωση',
    'actionlog__patch_available' => 'διαθέσιμο',
    'actionlog__event_patch_available' => 'Διαθέσιμη ενημέρωση',
    'actionlog__patch_installed' => 'εγκαταστάθηκε',
    'actionlog__event_patch_installed' => 'Η ενημέρωση εγκαταστάθηκε',

    'actionlog__extension' => 'Επέκταση',
    'actionlog__extension_status' => 'Κατάσταση της επέκτασης',
    'actionlog__cloning' => 'Κλωνοποίηση διακομιστή',
    'actionlog__cloning_complete' => 'ολοκληρώθηκε',
    'actionlog__event_cloning_complete' => 'Η κλωνοποίηση του διακομιστή ολοκληρώθηκε',

    'actionlog__ssl_web_binding' => 'Πιστοποιητικό SSL/TLS στον τομέα',
    'actionlog__ssl_web_binding_update' => 'εκχωρήθηκε / καταργήθηκε η εκχώρηση',
    'actionlog__event_ssl_web_binding_update' => 'Εκχωρήθηκε / καταργήθηκε η εκχώρηση του πιστοποιητικού SSL/TLS στον τομέα',

    'actionlog__ssl_web_mail_binding' => 'Πιστοποιητικό SSL/TLS στο webmail',
    'actionlog__ssl_web_mail_binding_update' => 'εκχωρήθηκε / καταργήθηκε η εκχώρηση',
    'actionlog__event_ssl_web_mail_binding_update' => 'Εκχωρήθηκε / καταργήθηκε η εκχώρηση του πιστοποιητικού SSL/TLS στο webmail',

    'actionlog__ssl_mail_binding' => 'Πιστοποιητικό SSL/TLS στον διακομιστή αλληλογραφίας',
    'actionlog__ssl_mail_binding_update' => 'εκχωρήθηκε / καταργήθηκε η εκχώρηση',
    'actionlog__event_ssl_mail_binding_update' => 'Εκχωρήθηκε / καταργήθηκε η εκχώρηση του πιστοποιητικού SSL/TLS στον διακομιστή αλληλογραφίας',

    'actionlog__ssl_panel_binding' => 'Πιστοποιητικό SSL/TLS στο Plesk',
    'actionlog__ssl_panel_binding_update' => 'εκχωρήθηκε / καταργήθηκε η εκχώρηση',
    'actionlog__event_ssl_panel_binding_update' => 'Εκχωρήθηκε / καταργήθηκε η εκχώρηση του πιστοποιητικού SSL/TLS στο Plesk',

    'actionlog__hostname' => 'Όνομα κεντρικού υπολογιστή διακομιστή',
    'actionlog__hostname_changed' => 'άλλαξε',

    'actionlog__event_mail_management_status_update' => 'Ενημέρωση κατάστασης διαχείρισης αλληλογραφίας',
    'actionlog__mail_management' => 'Κατάσταση διαχείρισης αλληλογραφίας',
    'actionlog__mail_management_status_update' => 'ενημερώθηκε',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Σύνολο κατά τομείς',

    'chk_js__warning_about_admin_passwd_syntax' => "Μην χρησιμοποιείτε εισαγωγικά, κενά, ερωτηματικό και εθνικούς αλφαβητικούς χαρακτήρες στον κωδικό πρόσβασης.\n Ο κωδικός πρόσβασης πρέπει να αποτελείται από %1 έως %2 χαρακτήρες και δεν πρέπει να περιέχει το όνομα χρήστη.",

    'passwordSecurityLevelCheckFailed' => 'Ο κωδικός πρόσβασής σας δεν είναι αρκετά πολύπλοκος.  Σύμφωνα με την πολιτική του διακομιστή, η ελάχιστη ισχύς του κωδικού πρόσβασης πρέπει να είναι %1. Για να βελτιώσετε την ισχύ του κωδικού πρόσβασης χρησιμοποιήστε αριθμούς, κεφαλαίους και πεζούς χαρακτήρες και ειδικούς χαρακτήρες όπως !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Πολύ αδύναμος',
    'passwordSecurityLevelCheckFailedWeak' => 'Αδύναμος',
    'passwordSecurityLevelCheckFailedMediocre' => 'Μεσαίος',
    'passwordSecurityLevelCheckFailedStrong' => 'Ισχυρός',
    'passwordSecurityLevelCheckFailedStronger' => 'Πολύ ισχυρός',

    'cu__php_settings__command_update_all' => "Ενημέρωση των ρυθμίσεων PHP ανά τομέα για όλους τομείς σύμφωνα με το αρχείο php.ini σε επίπεδο διακομιστή.",
    'cu__php_settings__update_all_done' => "Οι ρυθμίσεις PHP ανά τομέα ενημερώθηκαν με επιτυχία για όλους τους τομείς.",

    'filemanager__invalid_path' => "Καθορίστηκε μη έγκυρη διαδρομή",

    'rdp_app__msactivex_comment' => 'Σας συνιστούμε να χρησιμοποιήσετε τον Internet Explorer επειδή το στοιχείο Microsoft RDP ActiveX ενδέχεται να μην λειτουργήσει με άλλα προγράμματα περιήγησης.',

    'additional_key__descr_app' => 'Εφαρμογή',
    'additional_keys__used_keys' => ', %1 κλειδιά χρησιμοποιούνται',
    'additional_key__descr_key_mailboxes' => 'Γραμματοκιβώτια',

    'ui__client/domain/dns/sync__description' => 'Εφαρμογή αλλαγών από το πρότυπο DNS σε επίπεδο διακομιστή στη ζώνη.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Δεν είναι δυνατή η εφαρμογή των αλλαγών του προτύπου DNS στη ζώνη επειδή η ζώνη εξυπηρετείται άλλο διακομιστή DNS.',
    'ui__client/domain/dns/sync__short-title' => 'Εφαρμογή αλλαγών προτύπου DNS',
    'ui__client/domain/dns/sync__done' => 'Οι αλλαγές από το πρότυπο DNS εφαρμόστηκαν με επιτυχία στη ζώνη.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Εφαρμογή αλλαγών από το πρότυπο DNS σε επίπεδο διακομιστή στη ζώνη.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Δεν είναι δυνατή η εφαρμογή των αλλαγών του προτύπου DNS στη ζώνη επειδή η ζώνη εξυπηρετείται άλλο διακομιστή DNS.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Εφαρμογή αλλαγών προτύπου DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Οι αλλαγές από το πρότυπο DNS εφαρμόστηκαν με επιτυχία στη ζώνη.',
    'dns__dns_zone_sync_form' => 'Εφαρμογή αλλαγών προτύπου DNS',
    'dns__dns_zone_sync_legend' => 'Επιλογές',
    'dns__dns_zone_sync_ways' => 'Επιλέξτε ένα από τα παρακάτω',
    'dns__dns_zone_sync_way_safe' => 'Εφαρμογή των αλλαγών στις μη τροποποιημένες ζώνες. Αν μια ζώνη έχει προσαρμοστεί (προστέθηκαν νέες εγγραφές ή τροποποιήθηκαν οι υφιστάμενες), το Plesk δεν θα εφαρμόσει τις αλλαγές από το πρότυπο σε αυτές τις ζώνες.',
    'dns__dns_zone_sync_way_forced' => 'Εφαρμογή των αλλαγών σε όλες τις ζώνες. Το Plesk θα εφαρμόσει τις αλλαγές από το πρότυπο σε όλες τις ζώνες DNS, συμπεριλαμβανομένων και των προσαρμοσμένων. Σημειώστε ότι τα αρχεία που τροποποιούνται από το χρήστη παραμένουν πάντα άθικτα. Για παράδειγμα, εάν το πρότυπο περιέχει μια νέα εγγραφή που έχει προστεθεί ήδη από έναν πελάτη, το Plesk θα διατηρήσει την εγγραφή του πελάτη.',
    'dns__dns_default_ipv4_modified' => 'Οι εγγραφές με αυτήν τη διεύθυνση IP θα θεωρούνται ως τροποποιημένες από το χρήστη και δεν θα συγχρονίζονται με το πρότυπο DNS σε επίπεδο διακομιστή.',
    'dns__dns_default_ipv6_modified' => 'Οι εγγραφές με αυτήν τη διεύθυνση IP θα θεωρούνται ως τροποποιημένες από το χρήστη και δεν θα συγχρονίζονται με το πρότυπο DNS σε επίπεδο διακομιστή.',

    'dns__view_dns_record_master_title' => 'Προβολή εγγραφών πόρων',
    'dns__view_dns_record_off_title' => 'Προβολή εγγραφών διακομιστών ονομάτων',
    'dns__view_dns_record_slave_title' => 'Προβολή εγγραφών κύριων διακομιστών DNS',

    'dns_unable_to_resolve_hostname' => "Δεν είναι δυνατή η επίλυση του ονόματος κεντρικού υπολογιστή \"%1\": %2\nΒεβαιωθείτε ότι η επίλυση DNS του λειτουργικού συστήματος είναι ρυθμισμένη και λειτουργεί σωστά.",

    'no_database_server_available' => 'Δεν υπάρχουν διαθέσιμοι διακομιστές βάσεων δεδομένων γι\' αυτήν τη συνδρομή.',

    'database_server_edit_form__admin_add_hint' => "Καθορίστε τα διαπιστευτήρια του διαχειριστή της βάσης δεδομένων, τα οποία θα χρησιμοποιεί το Plesk για την πρόσβαση στο διακομιστή βάσεων δεδομένων. Πρέπει να υπάρχει ένας διαχειριστής με αυτά τα διαπιστευτήρια στον διακομιστή βάσεων δεδομένων.",
    'database_server_edit_form__admin_edit_hint' => "Από εδώ μπορείτε να αλλάξετε τα διαπιστευτήρια που χρησιμοποιεί το Plesk για την πρόσβαση στο διακομιστή βάσεων δεδομένων. Αυτά τα διαπιστευτήρια πρέπει να ταιριάζουν με τα διαπιστευτήρια του διαχειριστή της βάσης δεδομένων. Για παράδειγμα, εάν αλλάξετε τα διαπιστευτήρια διαχειριστή στο διακομιστή βάσεων δεδομένων, θα πρέπει να τα αλλάξετε επίσης και στο Plesk.",
    'database_server_edit_form__admin_change_hint' => 'Από εδώ μπορείτε να αλλάξετε τα διαπιστευτήρια που χρησιμοποιεί το Plesk για την πρόσβαση στο διακομιστή βάσεων δεδομένων. Εάν αλλάξετε το όνομα χρήστη ή τον κωδικό πρόσβασης παρακάτω, ο λογαριασμός χρήστη βάσης δεδομένων με δικαιώματα διαχειριστή θα ενημερωθεί τόσο στον διακομιστή βάσεων δεδομένων όσο και στο Plesk.',
    'database_server_edit_form__version' => 'Έκδοση διακομιστή βάσεων δεδομένων',
    'database_used_by_application_can_not_be_moved' => 'Δεν είναι δυνατή η μετακίνηση της βάσης δεδομένων: Μια εφαρμογή τοποθεσίας web χρησιμοποιεί αυτήν τη βάση δεδομένων.',
    'database_server_database_list__subscription' => 'Συνδρομή',
    'database_server_database_list__webspace' => 'Συνδρομή',
    'bt_assign_subscription_selected' => 'Μετακίνηση σε συνδρομή',
    'bt_cp_login' => 'Άνοιγμα στον Πίνακα Πελάτη',
    'bt_cp_login_classic_mode' => 'Διαχείριση φιλοξενίας',
    'hint_cp_login' => 'Διαχείριση της βάσης δεδομένων από τον Πίνακα Πελάτη του συνδρομητή.',
    'hint_cp_admin_login' => 'Διαχειριστείτε τη βάση δεδομένων.',
    'hint_cp_login_classic_mode' => 'Διαχειριστείτε τη βάση δεδομένων.',
    'database_user_update_orphaned_is_restricted' => 'Η ενημέρωση των ορφανών λογαριασμών χρηστών της βάσης δεδομένων απαγορεύεται. Μπορείτε μόνο να τους διαγράψετε ή να τους επιδιορθώσετε.',

    'database_unable_to_get_max_filesize_default_message' => 'Δεν είναι δυνατό να προσδιοριστεί το μέγιστο μέγεθος αρχείου της βάσης δεδομένων: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Δεν είναι δυνατό να οριστεί το μέγιστο μέγεθος αρχείου της βάσης δεδομένων: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Δεν είναι δυνατό να προσδιοριστεί το μέγιστο μέγεθος αρχείου καταγραφής της βάσης δεδομένων: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Δεν είναι δυνατό να οριστεί το μέγιστο μέγεθος αρχείου καταγραφής της βάσης δεδομένων: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Δεν είναι δυνατό να προσδιοριστεί το τρέχον όριο για το μέγεθος αρχείου βάσης δεδομένων Microsoft SQL \'%1\'. Δεν είναι δυνατή η ρύθμιση νέου ορίου.',
    'database_unable_to_set_max_filesize' => 'Δεν είναι δυνατή η ρύθμιση του ορίου για το μέγεθος αρχείου βάσης δεδομένων Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Δεν είναι δυνατό να προσδιοριστεί το τρέχον όριο μεγέθους του αρχείου καταγραφής της βάσης δεδομένων Microsoft SQL \'%1\'. Δεν είναι δυνατή η ρύθμιση νέου ορίου.',
    'database_unable_to_set_max_log_filesize' => 'Δεν είναι δυνατό να καθοριστεί το όριο μεγέθους του αρχείου καταγραφής της βάσης δεδομένων Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Δεν είναι δυνατή η δημιουργία της βάσης δεδομένων Microsoft SQL \'%1\': Το μέγεθος αρχείου της είναι μεγαλύτερο από το μέγιστο επιτρεπόμενο μέγεθος.',
    'database_unable_to_move_because_max_filesize' => 'Δεν είναι δυνατή η μετακίνηση της βάσης δεδομένων Microsoft SQL \'%1\': Το μέγεθος αρχείου της είναι μεγαλύτερο από το μέγιστο επιτρεπόμενο μέγεθος: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Δεν είναι δυνατή η δημιουργία της βάσης δεδομένων Microsoft SQL \'%1\': Το μέγεθος αρχείου του αρχείου καταγραφής είναι μεγαλύτερο από το επιτρεπόμενο μέγεθος.',
    'database_unable_to_move_because_max_log_filesize' => 'Δεν είναι δυνατή η μετακίνηση της βάσης δεδομένων Microsoft SQL \'%1\': Το μέγεθος αρχείου του αρχείου καταγραφής είναι μεγαλύτερο από το επιτρεπόμενο μέγεθος: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Δεν είναι δυνατή η επαναφορά της βάσης δεδομένων Microsoft SQL \'%1\': Το μέγεθος αρχείου της είναι μεγαλύτερο από το μέγιστο επιτρεπόμενο μέγεθος.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Υπάρχει ήδη πανομοιότυπος διακομιστής MS SQL καταχωρημένος στο Plesk. Καθορίστε έναν άλλον διακομιστή MS SQL ως φίλτρο.',
    'database_server__mssql_server_registered_as_sandbox' => 'Υπάρχει ήδη πανομοιότυπος διακομιστής MS SQL φίλτρου καταχωρημένος στο Plesk. Καθορίστε έναν άλλον διακομιστή MS SQL ως φίλτρο.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Δεν είναι δυνατή η σύνδεση στον διακομιστή μέσω \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Η δυνατότητα %1 δεν υποστηρίζεται από τους ακόλουθους κόμβους υπηρεσιών: %2. Η δυνατότητα αυτή θα απενεργοποιηθεί για όλα τα αντικείμενα που έχουν δημιουργηθεί σε αυτούς τους κόμβους.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Η δυνατότητα %1 δεν υποστηρίζεται από αυτόν το διακομιστή.  Η δυνατότητα αυτή θα απενεργοποιηθεί για όλα τα αντικείμενα που αποκαθίστανται.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Το στοιχείο %1 δεν έχει εγκατασταθεί. Δεν θα είναι διαθέσιμο για τις παρακάτω τοποθεσίες web: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Το στοιχείο %1 δεν έχει εγκατασταθεί. Θα αντικατασταθεί με το %2 για τις παρακάτω τοποθεσίες web: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Η τρέχουσα έκδοση του Plesk δεν υποστηρίζει ονόματα χρηστών που περιέχουν τελείες (.) . Οι πελάτες και μεταπωλητές με τέτοιου είδους ονόματα χρηστών δεν θα αποκατασταθούν.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Δεν είναι δυνατός ο εντοπισμός αρχείου αντιγράφου ασφαλείας με τα δεδομένα για το %1 %2. Τα δεδομένα για το %1 %2 δεν θα αποκατασταθούν.',

    'bu_conflict_resolver_zone_master_removed' => "Δεν είναι δυνατή η επαναφορά της κύριας εγγραφής DNS: η εγγραφή στην εξαρτώμενη ζώνη παραπέμπει στην υπάρχουσα διεύθυνση IP %1. Η κύρια εγγραφή DNS θα καταργηθεί από την εξαρτώμενη ζώνη.",

    'bu_conflict_resolver_not_available_scripting' => 'Το %1 δεν υποστηρίζεται.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => 'Το %1 δεν υποστηρίζεται. Δεν θα είναι διαθέσιμο για τις παρακάτω τοποθεσίες web: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Το στοιχείο %1 δεν έχει εγκατασταθεί.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Δεν θα είναι διαθέσιμο για τους ακόλουθους κόμβους υπηρεσιών: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Δεν θα είναι διαθέσιμο για τα παρακάτω αντικείμενα: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Οι παρακάτω διακομιστές βάσεων δεδομένων δεν είναι διαθέσιμοι σε αυτόν το διακομιστή: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Το αρχείο αντιγράφου ασφαλείας της βάσης δεδομένων MS SQL είναι αποθηκευμένο σε τοπική μορφή MS SQL, η οποία μπορεί να αποκατασταθεί μόνο στον τοπικό διακομιστή MS SQL ή σε απομακρυσμένο διακομιστή MS SQL με πλήρως διαμορφωμένες ρυθμίσεις αντιγράφων ασφαλείας. Ορισμένες από τις βάσεις δεδομένων σας δεν αποκαταστάθηκαν επειδή δεν έχει καταχωρηθεί ο κατάλληλος διακομιστής MS SQL στο Plesk. Επηρεάστηκαν οι ακόλουθοι τομείς: {{objects}}. Επικοινωνήστε με το πάροχο υπηρεσιών φιλοξενίας σας.',

    'bu_conflict_resolver_not_available_webmail' => 'Η υπηρεσία webmail %1 δεν είναι διαθέσιμη.  Θα αντικατασταθεί με την %2 για τα παρακάτω αντικείμενα: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Η υπηρεσία webmail %1 δεν είναι διαθέσιμη.  Θα αντικατασταθεί με την %2 για τα παρακάτω προγράμματα παροχής υπηρεσιών: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Οι βάσεις δεδομένων του τύπου '%1' δεν υποστηρίζουν ονόματα χρηστών που είναι ίδια με τα ονόματα των βάσεων δεδομένων.  Ο χρήστης '%2' θα μετονομαστεί σε '%3' για τη βάση δεδομένων '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Το όριο για τη χρήση χώρου στο δίσκο δεν έχει οριστεί στη ρύθμιση παραμέτρων του διακομιστή προορισμού.  Η τιμή αυτής της ρύθμισης θα αλλάξει σε "Απεριόριστη".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Το όριο για τον αριθμό συνδέσεων δεν έχει οριστεί στη ρύθμιση παραμέτρων του διακομιστή προορισμού. Η τιμή αυτής της ρύθμισης θα αλλάξει σε "Απεριόριστη".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Το όριο χρήσης κίνησης δεν έχει οριστεί στη ρύθμιση παραμέτρων του διακομιστή προορισμού. Η τιμή αυτής της ρύθμισης θα αλλάξει σε "Απεριόριστη".',
    'cu__pleskrestore_backup_file_extracted' => 'Το αρχείο αντιγράφου ασφαλείας εξήχθη στο "%1".',
    '__mod_bw_not_supported' => 'Η λειτουργική μονάδα mod_bw για το διακομιστή web Apache δεν υποστηρίζεται λόγω της ρύθμισης παραμέτρων του συστήματος αρχείων.  Τα όρια για τη χρήση κίνησης και τον μέγιστο αριθμό συνδέσεων δεν θα λειτουργήσουν.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Η εξουσιοδότηση POP3 για την αναμετάδοση αλληλογραφίας δεν υποστηρίζεται και αντ\' αυτής θα χρησιμοποιηθεί η εξουσιοδότηση "POP3 before SMTP".  ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Πρόγραμμα παροχής υπηρεσιών \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => 'Το %1 δεν υποστηρίζεται. Θα αντικατασταθεί με την %2 για τα παρακάτω προγράμματα παροχής υπηρεσιών: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => 'Το %1 δεν υποστηρίζεται.  Θα αντικατασταθεί με το %2 για τις παρακάτω τοποθεσίες web: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Τα παρακάτω αντικείμενα δεν βρέθηκαν στο αρχείο αντιγράφου ασφαλείας: %1',
    'bu_conflict_resolver_absent_domains' => 'Ορισμένα αντικείμενα δεν μπορούν να αποκατασταθούν επειδή ανήκουν στους ακόλουθους τομείς που δεν βρέθηκαν στο Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Ορισμένες τοποθεσίες web δεν μπορούν να αποκατασταθούν επειδή ανήκουν στους ακόλουθους γονικούς τομείς που δεν βρέθηκαν στο Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Δεν είναι δυνατή η επαναφορά των ζωνών DNS: Η υπηρεσία DNS είναι απενεργοποιημένη στη ρύθμιση παραμέτρων του διακομιστή.',
    'bu_conflict_resolver_mail_not_supported' => 'Δεν είναι δυνατή η επαναφορά των γραμματοκιβωτίων: Η υπηρεσία αλληλογραφίας είναι απενεργοποιημένη στη ρύθμιση παραμέτρων του διακομιστή.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'Η καθορισμένη λήξη χρονικού ορίου αδράνειας δεν υποστηρίζεται από τον διακομιστή web IIS. Θα πραγματοποιηθεί επαναφορά της τιμής σε %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Η καθορισμένη ενέργεια περιορισμού CPU δεν υποστηρίζεται από τον διακομιστή web IIS. Θα πραγματοποιηθεί επαναφορά της τιμής σε %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'πιστοποιητικό SSL/TLS  %1 διακομιστή',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Πιστοποιητικό SSL/TLS %2 του τομέα %1',
    'bu_conflict_detector_ssl_cert_name' => 'Πιστοποιητικό SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'Τα περιεχόμενα των παρακάτω αντικειμένων δεν μπορούν να αποκατασταθούν επειδή τα αντικείμενα αυτά δεν βρέθηκαν στο Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Τα περιεχόμενα των παρακάτω γραμματοκιβωτίων δεν μπορούν να αποκατασταθούν επειδή τα γραμματοκιβώτια δεν βρέθηκαν στο Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Τα περιεχόμενα των παρακάτω λιστών αλληλογραφίας δεν μπορούν να αποκατασταθούν επειδή οι λίστες αλληλογραφίας δεν βρέθηκαν στο Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Τα περιεχόμενα των παρακάτω βάσεων δεδομένων δεν μπορούν να αποκατασταθούν επειδή οι βάσεις δεδομένων δεν βρέθηκαν στο Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Η επαναφορά της εφαρμογής "%1" στο "%2" απέτυχε επειδή υπάρχει ήδη εγκατεστημένη μια άλλη εφαρμογή στο "%3". Μπορείτε να αφαιρέσετε την εγκατεστημένη εφαρμογή και να δοκιμάσετε ξανά.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Η λειτουργία αυτόματης απάντησης αλληλογραφίας δεν υποστηρίζεται.',
    'bu_conflict_resolver_not_available_mail_content' => 'Η επαναφορά περιεχομένου αλληλογραφίας δεν υποστηρίζεται.',
    'bu_conflict_resolver_invalid_mail_name' => 'Τα ακόλουθα γραμματοκιβώτια δεν έχουν αποκατασταθεί, επειδή είναι ενεργοποιημένη η υποδιευθυνσιοδότηση και ορισμένες διευθύνσεις ηλεκτρονικού ταχυδρομείου περιέχουν το σύμβολο "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Οι ακόλουθοι χρήστες δεν έχουν αποκατασταθεί, επειδή είναι ενεργοποιημένη η υποδιευθυνσιοδότηση και ορισμένες διευθύνσεις ηλεκτρονικού ταχυδρομείου περιέχουν το σύμβολο "%1": %2',
    'expiration_unsupported' => "Το όριο 'expiration' δεν υποστηρίζεται.",

    'component_name__dbconnector' => "Σύνδεση με βάση δεδομένων",
    'component_name__mysqlserver' => 'Διακομιστής MySQL',
    'component_name__troubleshooting' => 'Αντιμετώπιση Προβλημάτων',

    '__subscription_has_no_license_key' => 'Οι πόροι συνδρομών παρέχονται από τον κόμβο υπηρεσιών #%1, ο οποίος δεν διαθέτει συσχετισμένο κλειδί άδειας χρήσης.',
    '__subscription_has_expired_license_key' => 'Οι πόροι συνδρομών παρέχονται από τον κόμβο υπηρεσιών #%1, το κλειδί άδειας χρήσης %2 του οποίου έχει λήξει.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Δεν είναι δυνατή η αποθήκευση των αρχείων ρύθμισης παραμέτρων',
    '__cfgmonConfigurationFileSaveErrorBody' => "Δεν είναι δυνατή η αποθήκευση ορισμένων αρχείων ρύθμισης παραμέτρων στον κεντρικό υπολογιστή <%%host%%>: Παρουσιάστηκαν τα παρακάτω σφάλματα:\n\n\n\n%%errors%%",

    'mail__allow_short_pop3_names' => "Ονόματα λογαριασμών αλληλογραφίας POP3/IMAP",
    'mail__allow_short_pop3_names_disabled' => "Μπορείτε να χρησιμοποιήσετε μόνο πλήρη ονόματα λογαριασμών αλληλογραφίας POP3/IMAP",
    'mail__allow_short_pop3_names_enabled' => "Μπορείτε να χρησιμοποιήσετε συντομευμένα (webmaster) και πλήρη (webmaster@domain.com) ονόματα λογαριασμών αλληλογραφίας POP3/IMAP.",
    'mail__baddomain_exists' => "Ο τομέας υπάρχει ήδη στη μαύρη λίστα.",
    'mail__block_mail_from_doms' => "Μαύρη λίστα",
    'mail__blockers' => "Αποκλεισμένοι τομείς",
    'mail__blockers_remove' => "Κατάργηση αποκλεισμένων τομέων",
    'mail__blocker_add' => "Προσθήκη τομέων στη μαύρη λίστα",
    'mail__closed' => "κλειστό",
    'mail__crypted_passwd_match' => "Υπάρχουν λογαριασμοί αλληλογραφίας που συμφωνούν με τους κρυπτογραφημένους κωδικούς πρόσβασης.",
    'mail__enable_email_subaddressing' => 'Ενεργοποίηση υποδιευθυνσιοδότησης ηλεκτρονικού ταχυδρομείου',
    'mail__enable_email_subaddressing_hint' => 'Αυτή η επιλογή ενεργοποιεί τη δυνατότητα της ρύθμισης παραμέτρων των ηλεκτρονικών διευθύνσεων %%verpStyleLink%% για τις λίστες αλληλογραφίας',
    'mail__enable_email_subaddressing_cli_desc' => 'Αυτή η επιλογή ενεργοποιεί τη δυνατότητα της ρύθμισης παραμέτρων των ηλεκτρονικών διευθύνσεων τύπου VERP για τις λίστες αλληλογραφίας',
    'mail__dom_in_list' => "Ο τομέας υπάρχει ήδη στη μαύρη λίστα.",
    'mail__enable_rbl' => "Ενεργοποιήστε την προστασία από ανεπιθύμητη αλληλογραφία βάσει των καταλόγων καταστροφής δεδομένων (blackhole) DNS",
    'mail__enter_rbl_server' => "Πληκτρολογήστε τη ζώνη DNS.",
    'mail__enter_right_ip_mask' => "Εισαγάγετε τη μάσκα IP μεταξύ 1 και 32",
    'mail__enter_right_ip_mask_24' => "Εισαγάγετε τη μάσκα IP μεταξύ 24 και 32",
    'mail__install_rblsmtpd_program' => "Εγκαταστήστε το λογισμικό rblsmtp.",
    'mail__invalid_dom_name' => "Το όνομα τομέα %1 δεν είναι έγκυρο.",
    'mail__invalid_pop_lock_time' => "Ο χρόνος κλειδώματος POP3 δεν είναι έγκυρος.",
    'mail__invalid_rbl_server' => "Το όνομα της ζώνης DNS δεν είναι έγκυρο.",
    'mail__ip_and_mask' => "Διεύθυνση IP/μάσκα",
    'mail__ip_and_mask_exists' => "Υπάρχει ήδη αυτό το ζεύγος διεύθυνσης IP/μάσκας δικτύου.",
    'mail__lock_time' => "χρόνος κλειδώματος",
    'mail__general_options' => 'Γενικές επιλογές',
    'mail__relay_options' => 'Επιλογές αναμετάδοσης',
    'mail__mailnames_passwd_match' => "Υπάρχουν ήδη ζεύγη λογαριασμού αλληλογραφίας και κωδικού πρόσβασης που συμφωνούν.",
    'mail__select_domains_for_remove' => "Επιλέξτε τους τομείς που θα καταργηθούν.",
    'mail__max_size' => "Μέγιστο μέγεθος μηνύματος",
    'mail__mbox_quota' => "Όριο γραμματοκιβωτίου",
    'mail__min' => "Ελάχ",
    'mail__total_files_size' => "Συνολικό μέγεθος αποθετηρίου: %1",
    'mail__filename_already_in_repository' => "Ένα αρχείο με το ίδιο όνομα υπάρχει ήδη στο αποθετήριο",
    'mail__no_white_list_mask_feature_24' => "Χρησιμοποιήστε τιμή μάσκας 24 ή μεγαλύτερη.\nΟ διακομιστής αλληλογραφίας σας δεν υποστηρίζει ρυθμίσεις μάσκας. Μπορείτε μόνο να εξομοιώσετε τη ρύθμιση της μάσκας για τιμές μεγαλύτερες του 24.",
    'mail__open' => "άνοιγμα",
    'mail__open_relay_warning' => "Ανοίγοντας την αναμετάδοση της αλληλογραφίας σας, εκθέτετε τον διακομιστή αλληλογραφίας σας στην ανεπιθύμητη ηλεκτρονική αλληλογραφία.\n\nΔιατηρήστε αυτή τη ρύθμιση μόνο εάν θέλετε να δοκιμάσετε προσωρινά τον διακομιστή αλληλογραφίας ή ο διακομιστής Plesk σας βρίσκεται σε ένα εσωτερικό δίκτυο που δεν είναι προσβάσιμο μέσω του Internet.\n\nΝα διατηρηθεί η ρύθμιση;",
    'mail__pop3' => "POP3 before SMTP",
    'mail__rbl_zones' => "Ζώνες DNS για την υπηρεσία DNSBL",
    'mail__rbl_zones_hint' => "Διαχωρίστε τις καταχωρήσεις με ερωτηματικό, για παράδειγμα: 'zen.spamhaus.org;dnsbl.example.net'",
    'mail__relay_from_ip' => "Λίστα επιτρεπόμενων",
    'mail__relaying' => "Αναμετάδοση",
    'mail__reqr_auth' => "απαιτείται έλεγχος ταυτότητας:",
    'mail__smtp' => "SMTP",
    'mail__unable_add_new_mail_name' => "Δεν είναι δυνατή η προσθήκη του λογαριασμού αλληλογραφίας: %1",
    'mail_server_is_not_installed' => 'Δεν έχει εγκατασταθεί διακομιστής αλληλογραφίας (Postfix ή Qmail). Εγκαταστήστε το για να συνεχίσετε την εργασία.',
    'mail_server_not_available' => 'Δεν υπάρχουν διαθέσιμοι υποστηριζόμενοι διακομιστές αλληλογραφίας στον κόμβο υπηρεσίας.',
    '__not_installed' => '(δεν έχει εγκατασταθεί)',
    'mail__server_name_label' => 'Εγκατεστημένος διακομιστής αλληλογραφίας',
    'mail__imap_server_name_label' => 'Εγκατεστημένος διακομιστής IMAP/POP3',
    'mail__server_change_hint' => 'Μπορείτε να %%serverChangeLink%%',
    'mail__server_change_link' => 'εγκαταστήσετε και να χρησιμοποιήσετε έναν άλλο διακομιστή αλληλογραφίας',
    'mail__imap_server_change_link' => 'εγκατάσταση και χρήση άλλου διακομιστή IMAP/POP3',
    'mail__message_submission' => 'Ενεργοποίηση υπηρεσίας SMTP στη θύρα 587',
    'mail__message_submission_on_all_ips' => 'Ενεργοποίηση υπηρεσίας SMTP στη θύρα 587 για όλες τις διευθύνσεις IP',
    'mail__message_submission_bind_to' => 'Ενεργ',
    'mail__message_submission_all_ip_addresses' => 'όλες οι διευθύνσεις IP',
    'mail__service_node_outgoing_messages_is_disabled' => 'Το φιλτράρισμα ανεπιθύμητης αλληλογραφίας στα εξερχόμενα μηνύματα ηλεκτρονικού ταχυδρομείου είναι απενεργοποιημένο.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Ο κόμβος υπηρεσιών δεν υποστηρίζει τον περιορισμό του αριθμού εξερχόμενων μηνυμάτων ηλεκτρονικού ταχυδρομείου από έναν τομέα για τον τομέα %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Ο κόμβος υπηρεσιών δεν υποστηρίζει τον περιορισμό του αριθμού εξερχόμενων μηνυμάτων ηλεκτρονικού ταχυδρομείου από ένα γραμματοκιβώτιο για τον τομέα %1.',
    'mail__max_outgoing_messages_enable_text' => 'Ενεργοποιήστε τους περιορισμούς στα εξερχόμενα μηνύματα ηλεκτρονικού ταχυδρομείου',
    'mail__max_outgoing_messages_enable_hint' => 'Τα ακόλουθα όρια είναι περιορισμένα. Μπορούν να αντικατασταθούν σε κάθε πρόγραμμα παροχής υπηρεσιών και συνδρομή. Τα όρια δεν λειτουργούν σε επίπεδο διακομιστή, αλλά χρησιμεύουν ως πρότυπο για προγράμματα και συνδρομές που δεν έχουν καθορισμένα προσαρμοσμένα όρια. Σημειώστε ότι η αλλαγή του περιορισμού των εξερχόμενων μηνυμάτων ηλεκτρονικού ταχυδρομείου μπορεί να επηρεάσει την απόδοση του διακομιστή αλληλογραφίας.',
    'mail__outgoing_messages_mbox_limit_text' => 'Προεπιλεγμένο όριο για τα εξερχόμενα μηνύματα από ένα γραμματοκιβώτιο (ανά ώρα)',
    'mail__outgoing_messages_domain_limit_text' => 'Προεπιλεγμένο όριο για τα εξερχόμενα μηνύματα από έναν τομέα (ανά ώρα)',
    'mail__outgoing_messages_subscription_limit_text' => 'Προεπιλεγμένο όριο για τα εξερχόμενα μηνύματα από μια συνδρομή (ανά ώρα)',
    'mail__outgoing_messages_enable_sendmail_text' => 'Να επιτρέπεται στις δέσμες ενεργειών και τους χρήστες να χρησιμοποιούν το Sendmail',
    'mail__outgoing_messages_enable_sendmail_hint' => 'Οι δέσμες ενεργειών και οι χρήστες θα έχουν τη δυνατότητα να στέλνουν μηνύματα ηλεκτρονικού ταχυδρομείου (για λογαριασμό του χρήστη συστήματος της συνδρομής) χρησιμοποιώντας το Sendmail ακόμη και αν σημειώνεται υπέρβαση των ορίων για ένα γραμματοκιβώτιο ή τομέα. Ο μέγιστος αριθμός των μηνυμάτων που μπορούν να αποσταλούν μέσω του Sendmail καθορίζεται από το όριο που ισχύει για ολόκληρη τη συνδρομή. Η ρύθμιση αυτή δεν επιτρέπει στις δέσμες ενεργειών να χρησιμοποιούν το Sendmail σε επίπεδο διακομιστή, αλλά λειτουργεί ως προεπιλεγμένη ρύθμιση για τα προγράμματα παροχής υπηρεσιών και τις συνδρομές.',
    'mail__outgoing_messages_report_period_text' => 'Εμφάνιση αναφορών με βάση τα στατιστικά στοιχεία για τις τελευταίες',
    'mail__max_outgoing_messages_period_P1D' => '1 ημέρα',
    'mail__max_outgoing_messages_period_P1W' => '1 εβδομάδα',
    'mail__max_outgoing_messages_period_P2W' => '2 εβδομάδες',
    'mail__max_outgoing_messages_period_P1M' => '1 μήνα',
    'mail__outgoing_messages_report_period_hint' => 'Οι αναφορές δημιουργούνται και εμφανίζεται μια ειδοποίηση στην Αρχική σελίδα αναφορικά με τις απόπειρες υπέρβασης των ορίων εξερχόμενης αλληλογραφίας κατά τη διάρκεια της καθορισμένης χρονικής περιόδου.',
    'mail__outgoing_messages_notification_period_text' => 'Να αποστέλλεται ένα μήνυμα ηλεκτρονικού ταχυδρομείου ειδοποίησης κάθε',
    'mail__max_outgoing_messages_period_PT15M' => '15 λεπτά',
    'mail__max_outgoing_messages_period_PT1H' => '1 ώρα',
    'mail__max_outgoing_messages_period_PT6H' => '6 ώρες',
    'mail__max_outgoing_messages_period_PT12H' => '12 ώρες',
    'mail__outgoing_messages_notification_period_hint' => 'Οι ειδοποιήσεις παρέχουν στατιστικά στοιχεία σχετικά με τις απόπειρες υπέρβασης των ορίων εξερχόμενης αλληλογραφίας κατά τη διάρκεια της καθορισμένης χρονικής περιόδου.',
    'mail__outgoing_count_number_recipients_text' => 'Count the number of recipients instead of messages',
    'mail__outgoing_count_number_recipients_hint' => 'Enables mode that counts the number of recipients rather than messages when limiting Outgoing mail and counting statistics. For example, one message sent to 10 recipients will be counted as ten messages.',

    'mail__outgoing_email_mode_explicit_ip_none' => 'Καμία',
    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Καθορίστε μια διεύθυνση τουλάχιστον ενός τύπου (IPv4 ή IPv6).',

    'mail__max_connections_text_courier' => 'Μέγιστος αριθμός συνδέσεων (IMAP, POP3, IMAP over SSL/TLS ή POP3 over SSL/TLS)',
    'mail__max_connections_text_dovecot' => 'Μέγιστος αριθμός συνδέσεων (IMAP, POP3, IMAP over SSL/TLS ή POP3 over SSL/TLS)',
    'mail__max_connections_hint_courier' => 'Ο μέγιστος αριθμός διακομιστών (IMAP ή POP3) που εκκινούνται.',
    'mail__max_connections_hint_dovecot' => 'Ο μέγιστος αριθμός χρηστών αλληλογραφίας που μπορούν να είναι συνδεδεμένοι την ίδια στιγμή.',

    'mail__max_connections_per_ip_text_courier' => 'Μέγιστος αριθμός συνδέσεων ανά διεύθυνση IP',
    'mail__max_connections_per_ip_text_dovecot' => 'Μέγιστος αριθμός συνδέσεων για έναν χρήστη ανά διεύθυνση IP',
    'mail__max_connections_per_ip_hint_courier' => 'Ο μέγιστος αριθμός συνδέσεων (IMAP, POP3, IMAP over SSL/TLS ή POP3 over SSL/TLS) που θα γίνονται αποδεκτές από την ίδια διεύθυνση IP.',
    'mail__max_connections_per_ip_hint_dovecot' => 'Ο μέγιστος αριθμός συνδέσεων (IMAP, POP3, IMAP over SSL/TLS ή POP3 over SSL/TLS) που θα επιτρέπονται για έναν χρήστη αλληλογραφίας από κάθε διεύθυνση IP.',

    'mail__outgoing_email_mode' => 'Λειτουργία εξερχόμενης αλληλογραφίας',
    'mail__outgoing_email_mode_domain_ip' => 'Αποστολή από διευθύνσεις IP τομέα',
    'mail__outgoing_email_mode_domain_name' => 'Αποστολή από τις διευθύνσεις IP του τομέα και χρήση των ονομάτων τομέα στον χαιρετισμό SMTP',
    'mail__outgoing_email_mode_explicit_ip' => 'Αποστολή από τις καθορισμένες διευθύνσεις IP',
    'mail__outgoing_email_mode_explicit_ip_v4' => 'IPv4',
    'mail__outgoing_email_mode_explicit_ip_v6' => 'IPv6',
    'mail__outgoing_email_mode_invalid' => 'Καθορίστηκε μη έγκυρη λειτουργία εξερχόμενης αλληλογραφίας.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Καθορίστηκε μη έγκυρη διεύθυνση IPv4.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Καθορίστηκε μη έγκυρη διεύθυνση IPv6.',
    'mail__outgoing_email_mode_unavailable' => 'Η αλλαγή της λειτουργίας εξερχόμενης αλληλογραφίας δεν υποστηρίζεται, πιθανώς επειδή ο διακομιστής αλληλογραφίας Postfix δεν είναι εγκατεστημένος σε αυτόν τον διακομιστή.',

    'mail__smtp_settings_change_hint' => 'Για να ενεργοποιήσετε την αποστολή ειδοποιήσεων από το Plesk όταν η αναμετάδοση είναι κλειστή, μπορείτε να %%changeLink%%',
    'mail__smtp_settings_change_link' => 'αλλάξετε τις ρυθμίσεις SMTP',

    'mail__autoresponder_attachment_not_supported' => 'Ο διακομιστής αλληλογραφίας που χρησιμοποιείται αυτή τη στιγμή δεν υποστηρίζει τη διαχείριση συνημμένων στη λειτουργία αυτόματης απάντησης.',

    'mail__autoresponder_headers' => 'Επιπλέον κεφαλίδες αυτόματης απάντησης',
    'mail__autoresponder_headers_hint' => 'Ορίστε επιπλέον επικεφαλίδες για κάθε μήνυμα αυτόματης απάντησης που έρχεται από τον διακομιστή Plesk.',
    'mail__autoresponder_headers_label' => 'Επιπλέον κεφαλίδες',

    'mail__smtp_white_list_not_supported' => 'Ο διακομιστής αλληλογραφίας που χρησιμοποιείται επί του παρόντος δεν υποστηρίζει λίστα επιτρεπόμενων διευθύνσεων IP.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Οι μάσκες CIDR δεν υποστηρίζονται από τον τρέχοντα επιλεγμένο διακομιστή αλληλογραφίας. Καθορίστε τη διεύθυνση IP σε μορφή \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'Τα μοτίβα IP μπαλαντέρ δεν υποστηρίζονται από τον τρέχοντα επιλεγμένο διακομιστή αλληλογραφίας. Καθορίστε τη διεύθυνση IP σε μορφή \'192.0.0.0/8\'.',

    'sfdk_server_wide_legend' => 'Προστασία από ανεπιθύμητη αλληλογραφία DKIM',
    'sfdk_server_wide_sign_text' => 'Να επιτρέπεται η υπογραφή της εξερχόμενης αλληλογραφίας',
    'sfdk_server_wide_verify_text' => 'Επαλήθευση εισερχόμενης αλληλογραφίας',
    'sfdk_server_wide_verify_failed' => 'Δεν είναι δυνατή η αλλαγή των ρυθμίσεων για την υπηρεσία επαλήθευσης DKIM',

    'sfdk_domain__serverwide_disabled' => 'Απενεργοποιημένο σύμφωνα με την πολιτική του διακομιστή',
    'feature__domainkeys__serverwide_disabled' => 'Η προστασία από ανεπιθύμητη αλληλογραφία DKIM σε επίπεδο διακομιστή είναι απενεργοποιημένη',

    'defaultcomponents__error_set_default' => 'Δεν είναι δυνατός ο ορισμός του %1 ως προεπιλεγμένο %2',
    'defaultcomponents__required_package_not_default' => 'Το στοιχείο %1 που απαιτείται για την εργασία δεν είναι προεπιλεγμένο.',

    '__percentage' => '%',
    '__seconds' => 'Δευτερόλεπτα',
    '__resource_remain' => 'Απομένουν',

    '__not_registered' => '(δεν έχει καταχωρηθεί)',
    '__php_handler_id' => 'Έκδοση PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Ο δείκτης χειρισμού PHP "%1" δεν έχει καταχωρηθεί. Πιθανώς να έχει διαγραφεί από το διακομιστή. Καταχωρήστε ένα δείκτη χειρισμού με τις ίδιες ιδιότητες και προσπαθήστε ξανά.',
    '__php_handler_not_registered_on_domain' => 'Τομέας "%1": Ο δείκτης χειρισμού PHP "%2" δεν έχει καταχωρηθεί. Πιθανώς να έχει διαγραφεί από το διακομιστή. Καταχωρήστε ένα δείκτη χειρισμού με τις ίδιες ιδιότητες και προσπαθήστε ξανά.',
    '__php_fpm_handler' => 'Εφαρμογή FPM',
    '__php_fpm-dedicated_handler' => 'Αποκλειστική εφαρμογή FPM',

    'mailname_create_assigned_user_dublicate_error' => 'Δεν είναι δυνατή η δημιουργία χρήστη για το γραμματοκιβώτιο.  Ο χρήστης με το όνομα %1 υπάρχει ήδη και διαθέτει άλλο γραμματοκιβώτιο.',
    'mailname_create_assigned_user_role_absent_error' => 'Δεν είναι δυνατή η δημιουργία χρήστη για το γραμματοκιβώτιο.  Ο προεπιλεγμένος ρόλος %1 του χρήστη δεν υπάρχει.',

    'gphd__mime_types' => 'Τύποι MIME',
    'gphd__handlers' => 'Δείκτες χειρισμού Apache',
    'gphd__ip_restrictions_allow' => 'Να επιτρέπεται η πρόσβαση στην τοποθεσία για συγκεκριμένους κεντρικούς υπολογιστές και δίκτυα (εκτός από αυτά που απαγορεύονται)',
    'gphd__ip_restrictions_deny' => 'Να απαγορεύεται η πρόσβαση στην τοποθεσία για συγκεκριμένους κεντρικούς υπολογιστές και δίκτυα',
    'gphd__directory_index' => 'Αρχεία ευρετηρίου',
    'gphd__nginx_transparent_mode' => 'Η λειτουργία κατά την οποία ο Apache χειρίζεται τόσο το στατικό όσο και το δυναμικό περιεχόμενο, ενώ ο nginx περνά μόνο τις αιτήσεις και απαντήσεις HTTP χωρίς τροποποίηση.',
    'gphd__nginx_serve_static' => 'Εξυπηρέτηση στατικών αρχείων απευθείας μέσω του nginx',
    'gphd__nginx_static_extensions' => 'Επεκτάσεις στατικών αρχείων, ο χειρισμός των οποίων πρέπει να γίνεται από τον nginx',
    'gphd__nginx_serve_php' => 'Επεξεργασία αρχείων PHP μέσω του nginx',
    'gphd__www_root' => 'Ριζικός κατάλογος WWW',

    'eol__none' => 'χωρίς τροποποίηση',
    'eol__lf' => 'μετατροπή σε στυλ Unix',
    'eol__cr' => 'μετατροπή σε στυλ MacOS',
    'eol__crlf' => 'μετατροπή σε στυλ Windows',

    'ui__dns_bad_zone' => 'Ασυνεπής ζώνη "%1":',
    'ui__dns_ns_has_no_address_records' => 'Η εγγραφή NS "%1" δεν έχει εγγραφές διεύθυνσης (A ή AAAA).',
    '__dns_bad_zone' => 'Ασυνεπής ζώνη "%1":',
    '__dns_ns_has_no_address_records' => 'Η εγγραφή NS "%1" δεν έχει εγγραφές διεύθυνσης (A ή AAAA).',
    '__dns_ptr_is_wildcard' => 'Η εγγραφή PTR "%1" δεν είναι έγκυρη: Η εγγραφή παραπέμπει σε χαρακτήρα μπαλαντέρ.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Να επιτρέπεται η απομακρυσμένη πρόσβαση για τον χρήστη βάσης δεδομένων \'%3\' του πελάτη \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Δεν είναι δυνατόν να επιτραπούν οι απομακρυσμένες συνδέσεις για τον χρήστη βάσης δεδομένων \'%1\': Δεν ήταν δυνατός ο καθορισμός του αριθμού θύρας TCP που χρησιμοποιεί ο διακομιστής Microsoft SQL \'%2\'. Οι πιθανοί λόγοι είναι οι εξής: το πρωτόκολλο TCP/IP δεν έχει ενεργοποιηθεί στις ρυθμίσεις παραμέτρων δικτύου του διακομιστή ή ο διακομιστής έχει ρυθμιστεί για χρήση δυναμικών θυρών TCP. Ρυθμίστε τις παραμέτρους του διακομιστή ώστε να «ακούει» σε μια συγκεκριμένη σταθερή θύρα TCP και δοκιμάστε ξανά τις απομακρυσμένες συνδέσεις.',

    'command__convertResellerHasCustomer' => 'Ο λογαριασμός μεταπωλητή \'%1\' έχει έναν ή περισσότερους λογαριασμούς πελατών. Για να μετατρέψετε αυτόν το λογαριασμό μεταπωλητή σε λογαριασμό πελάτη, μεταφέρετε πρώτα τους λογαριασμούς πελατών σε έναν νέο κάτοχο ή μετατρέψτε τους σε λογαριασμούς μεταπωλητών.',
    'command__convertResellerNotReseller' => 'Μόνο οι λογαριασμοί μεταπωλητών μπορούν να μετατραπούν σε λογαριασμούς πελατών. Ο \'%1\' δεν είναι μεταπωλητής.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Δεν ήταν δυνατός ο συγχρονισμός της συνδρομής με το πρόγραμμα παροχής υπηρεσιών. Οι ακόλουθες ρυθμίσεις της συνδρομής έρχονται σε διένεξη με το πρόγραμμα παροχής υπηρεσιών: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Ο λογαριασμός \'%1\' είναι λογαριασμός μεταπωλητή. Οι λογαριασμοί μεταπωλητών δεν μπορούν να μεταφερθούν σε νέο κάτοχο επειδή βρίσκονται υπό την κυριότητα του διαχειριστή του διακομιστή.',
    'moveCustomer__wrong_owner_type' => "Ο λογαριασμός του πελάτη '%1' μπορεί να μετακινηθεί μόνο σε έναν μεταπωλητή ή διαχειριστή, όχι σε άλλον πελάτη.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Ο λογαριασμός του πελάτη \'%1\' ανήκει ήδη στο επιλεγμένο κάτοχο.',
    'upgradeClient__user_is_admin' => 'Ο λογαριασμός \'%1\' δεν μπορεί να μετατραπεί σε λογαριασμό μεταπωλητή, επειδή είναι λογαριασμός διαχειριστή.',

    'mail__error_setting_max_connections_courier' => 'Δεν είναι δυνατός ο ορισμός του μέγιστου αριθμού συνδέσεων (IMAP, POP3, IMAP over SSL/TLS ή POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Δεν είναι δυνατός ο ορισμός του μέγιστου αριθμού συνδέσεων (IMAP, POP3, IMAP over SSL/TLS ή POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Δεν είναι δυνατός ο ορισμός του μέγιστου αριθμού συνδέσεων (IMAP, POP3, IMAP over SSL/TLS ή POP3 over SSL/TLS) ανά διεύθυνση IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Δεν είναι δυνατός ο ορισμός του μέγιστου αριθμού συνδέσεων (IMAP, POP3, IMAP over SSL/TLS ή POP3 over SSL/TLS) ανά διεύθυνση IP για έναν συγκεκριμένο χρήστη αλληλογραφίας: %1',
    'mail__error_no_localhost_for_maillists_in_server_white_list' => 'Για να χρησιμοποιήσετε λίστες αλληλογραφίας, το localhost (127.0.0.0/8, ::1/128) πρέπει να υπάρχει στη λίστα επιτρεπόμενων του διακομιστή αλληλογραφίας. Ωστόσο, για να χρησιμοποιήσετε τον έλεγχο εξερχόμενης αλληλογραφίας, δεν πρέπει να υπάρχει localhost στη λίστα επιτρεπόμενων. Ως συμβιβαστική λύση, εάν έχετε ενεργοποιήσει τον έλεγχο εξερχόμενης αλληλογραφίας, μπορείτε να χρησιμοποιήσετε την προώθηση αλληλογραφίας στο γραμματοκιβώτιο αντί για τις λίστες αλληλογραφίας.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv4' => 'Για να χρησιμοποιήσετε λίστες αλληλογραφίας, το localhost πρέπει να υπάρχει στη λίστα επιτρεπόμενων του διακομιστή αλληλογραφίας. Ωστόσο, για να χρησιμοποιήσετε τον έλεγχο εξερχόμενης αλληλογραφίας, δεν πρέπει να υπάρχει localhost στη λίστα επιτρεπόμενων. Ως συμβιβαστική λύση, εάν έχετε ενεργοποιήσει τον έλεγχο εξερχόμενης αλληλογραφίας, μπορείτε να χρησιμοποιήσετε την προώθηση αλληλογραφίας στο γραμματοκιβώτιο αντί για τις λίστες αλληλογραφίας. Σημειώστε ότι δεν υπάρχουν διευθύνσεις τοπικού κεντρικού υπολογιστή IPv4 (127.0.0.0/8) στη λίστα επιτρεπόμενων αυτή τη στιγμή και, συνεπώς, ο έλεγχος εξερχόμενης αλληλογραφίας θα λειτουργεί για τις διευθύνσεις IPv4.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv6' => 'Για να χρησιμοποιήσετε λίστες αλληλογραφίας, το localhost πρέπει να υπάρχει στη λίστα επιτρεπόμενων του διακομιστή αλληλογραφίας. Ωστόσο, για να χρησιμοποιήσετε τον έλεγχο εξερχόμενης αλληλογραφίας, δεν πρέπει να υπάρχει localhost στη λίστα επιτρεπόμενων. Ως συμβιβαστική λύση, εάν έχετε ενεργοποιήσει τον έλεγχο εξερχόμενης αλληλογραφίας, μπορείτε να χρησιμοποιήσετε την προώθηση αλληλογραφίας στο γραμματοκιβώτιο αντί για τις λίστες αλληλογραφίας. Σημειώστε ότι δεν υπάρχουν διευθύνσεις τοπικού κεντρικού υπολογιστή IPv6 (::1/128) στη λίστα επιτρεπόμενων αυτή τη στιγμή και, συνεπώς, ο έλεγχος εξερχόμενης αλληλογραφίας θα λειτουργεί για τις διευθύνσεις IPv6.',
    'mail__outgoing_messages_with_open_relay_error' => 'Για να εφαρμοστεί σωστά ο περιορισμός του αριθμού εξερχόμενων μηνυμάτων ηλεκτρονικού ταχυδρομείου, πρέπει να κλείσετε την αναμετάδοση.',
    'outgoing_messages_limit_value_invalid' => 'Η τιμή πρέπει να είναι εντός του εξής εύρους %%MIN%%..%%MAX%%. Μόνο ο διαχειριστής του Plesk έχει τη δυνατότητα να προσαρμόσει αυτήν τη ρύθμιση.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Οι παρακάτω τομείς χρησιμοποιούν εξωτερικές διευθύνσεις ηλεκτρονικού ταχυδρομείου για την προώθηση της αλληλογραφίας που αποστέλλεται σε ανύπαρκτες διευθύνσεις. Τα μηνύματα που αποστέλλονται σε αυτές τις διευθύνσεις δεν προσμετρώνται στον Έλεγχο εξερχόμενης αλληλογραφίας:\n%1",
    'outgoing_messages_white_list_not_empty' => 'Τα όρια στην εξερχόμενη αλληλογραφία δεν θα λειτουργήσουν για αποστολείς αλληλογραφίας, οι διευθύνσεις IP των οποίων βρίσκονται στη λίστα επιτρεπόμενων του διακομιστή αλληλογραφίας. Για παράδειγμα, εάν υπάρχει το localhost (127.0.0.0 / 8, ::1 / 128) στη λίστα επιτρεπόμενων, όλη η αλληλογραφία από τον τοπικό διακομιστή θα αποστέλλεται κανονικά ανεξαρτήτως των περιορισμών. Οι αποστολείς αλληλογραφίας μπορούν να χρησιμοποιήσουν τοπικές διευθύνσεις IP (τοποθεσίες web και προσαρμοσμένες δέσμες ενεργειών που φιλοξενούνται στον τοπικό διακομιστή) ή εξωτερικές (πελάτες που αποστέλλουν αλληλογραφία από προγράμματα-πελάτες αλληλογραφίας εγκατεστημένα στον υπολογιστή ή τη φορητή συσκευή τους). Για να λειτουργήσουν τα όρια για όλους τους αποστολείς αλληλογραφίας (τοπικούς και εξωτερικούς), αφαιρέστε όλες τις διευθύνσεις IP και τα δίκτυα από τη λίστα επιτρεπόμενων. Σημειώστε ότι η αφαίρεση του localhost (127.0.0.0 / 8, ::1 / 128) από τη λίστα επιτρεπόμενων μπορεί να διαταράξει τη λειτουργία των τοποθεσιών web και των δεσμών ενεργειών που αποστέλλουν αλληλογραφία από τον συγκεκριμένο διακομιστή. Για λεπτομέρειες σχετικά με τους περιορισμούς στην εξερχόμενη αλληλογραφία, ανατρέξτε στον Οδηγό διαχειριστή, στην ενότητα «Προστασία από ανεπιθύμητη εξερχόμενη αλληλογραφία».',
    'outgoing_messages_relay_open' => 'Η αναμετάδοση αλληλογραφίας είναι ανοικτή: Τα όρια στην εξερχόμενη αλληλογραφία δεν θα λειτουργήσουν.',

    'spf_dsnignore' => 'Ο έλεγχος SPF συνεχίζεται όταν παρουσιάζονται προβλήματα αναζήτησης DNS',
    'spf_dnsignore_hint' => 'Αρχικά, το SPF πραγματοποιεί μια αναζήτηση DNS. Ενεργοποιήστε αυτήν την επιλογή για να συνεχίζεται ο έλεγχος σε περίπτωση αποτυχία της αναζήτησης DNS. Αυτή η επιλογή είναι απενεργοποιημένη εάν δεν έχει καμία επίδραση στην τρέχουσα λειτουργία ελέγχου.',
    'spf_behavior_hint' => 'Στη συνέχεια, το SPF εφαρμόζει τους τοπικούς κανόνες και τους κανόνες εικασίας. Το μήνυμα μπορεί να απορριφθεί ανάλογα με την επιλεγμένη λειτουργία ελέγχου και το αποτέλεσμα του ελέγχου.',

    'notification_aps_app_updates_available' => 'Υπάρχουν διαθέσιμες ενημερώσεις για τις εξής εφαρμογές:',
    'notification_aps_app_updates_installed' => 'Εγκαταστάθηκαν αυτόματα ενημερώσεις για τις εξής εφαρμογές:',
    'notification_aps_app_updates_requirements' => 'Υπάρχουν διαθέσιμες ενημερώσεις για τις ακόλουθες εφαρμογές, αλλά δεν μπορούν να εγκατασταθούν επειδή οι ρυθμίσεις φιλοξενίας των αντίστοιχων τοποθεσιών web δεν πληρούν τους όρους εγκατάστασης:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Εγκατεστημένη έκδοση: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Προσθήκη "%%name%%" στο %%parentName%% (%%url%%). Εγκατεστημένη έκδοση: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Θέμα "%%name%%" στο %%parentName%% (%%url%%). Εγκατεστημένη έκδοση: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Εγκατεστημένη έκδοση: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Προσθήκη "%%name%%" στο %%parentName%% (%%url%%). Εγκατεστημένη έκδοση: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Θέμα "%%name%%" στο %%parentName%% (%%url%%). Εγκατεστημένη έκδοση: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Η έκδοσή σας: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Προσθήκη "%%name%%" στο %%parentName%% (%%url%%). Η έκδοσή σας: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Θέμα "%%name%%" στο %%parentName%% (%%url%%). Η έκδοσή σας: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Νέα έκδοση: %%to%%. Προηγούμενη έκδοση: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Νέα έκδοση: %%to%%. Προηγούμενη έκδοση: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Νέα έκδοση: %%to%%. Προηγούμενη έκδοση: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Εγκατεστημένη έκδοση: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Εγκατεστημένη έκδοση: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Η έκδοσή σας: %%from%%. Διαθέσιμη έκδοση: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'εξωτερική εφαρμογή',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Τομείς',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Διευθύνσεις ηλεκτρονικού ταχυδρομείου',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Συνδρομές',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 μηνύματα ανά ώρα',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Απεριόριστο',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, το όριο είναι %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 απόπειρα(-ες) υπέρβασης ορίων από %2 έως %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 απόπειρα(-ες) υπέρβασης ορίων από %2 μέχρι τώρα',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Απαγόρευση διευθύνσεων IP (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Σημειώστε ότι το στοιχείο Fail2ban δεν έχει εγκατασταθεί στον διακομιστή προορισμού.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Εγκαταστήστε το Fail2ban. Αυτό ενδέχεται να διαρκέσει μερικά λεπτά.',

    'plesk_key__no_reseller_support' => 'Δεν μπορείτε να διαχειριστείτε τους μεταπωλητές λόγω περιορισμών της άδειας χρήσης.',
    'plesk_key__no_customers_support' => 'Δεν μπορείτε να διαχειριστείτε τους πελάτες λόγω περιορισμών της άδειας χρήσης.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Δεν είναι δυνατή η μετάβαση σε προβολή Παρόχου υπηρεσιών εξαιτίας των περιορισμών της άδειας χρήσης.',
    'plesk_key__no_security_core_support' => 'Οι βασικές λειτουργίες ασφαλείας (ModSecurity και Fail2ban) δεν είναι διαθέσιμες λόγω περιορισμών της άδειας χρήσης.',
    'plesk_key__outgoing-antispam' => 'Έλεγχος εξερχόμενης αλληλογραφίας',
    'plesk_key__security-core' => 'Πυρήνας ασφάλειας (ModSecurity και Fail2ban)',
    'plesk_key__can-manage-accounts' => 'Διαχείριση λογαριασμών',
    'plesk_key__can-manage-subscriptions' => 'Διαχείριση συνδρομών',
    'plesk_key__can-manage-customers' => 'Διαχείριση πελατών',
    'plesk_key__can-manage-resellers' => 'Διαχείριση μεταπωλητών',
    'plesk_key__can-manage-custom-view' => 'Διαθεσιμότητα περιορισμένης λειτουργίας',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Η διαχείριση συνδρομών είναι απενεργοποιημένη, αλλά διαθέτετε αρκετές συνδρομές (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Η διαχείριση μεταπωλητών είναι απενεργοποιημένη, αλλά διαθέτετε αρκετούς μεταπωλητές (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Η διαχείριση πελατών είναι απενεργοποιημένη, αλλά διαθέτετε αρκετούς πελάτες (%1).',
    'plesk_key__no_subscriptions_support' => 'Δεν μπορείτε να διαχειριστείτε τις συνδρομές λόγω περιορισμών της άδειας χρήσης.',
    'plesk_key__no_custom_view_support' => 'Δεν μπορείτε να χρησιμοποιήσετε την περιορισμένη λειτουργία λόγω περιορισμών της άδειας χρήσης.',
    'plesk_key__trial_forbidden_region' => 'Λυπούμαστε, αλλά το Plesk δεν είναι αυτή τη στιγμή διαθέσιμο στην περιοχή σας.',
    'additional_key__main_key' => 'Το κλειδί είναι κύριο κλειδί: Δεν μπορείτε να αποστείλετε ένα κύριο κλειδί ως πρόσθετο.',

    'gch__hosting_waf_rule_engine' => 'Λειτουργία τείχους προστασίας εφαρμογών web',

    'backup__fieldset__restoration_options' => 'Επιλογές επαναφοράς',
    'backup__restore_options__restore' => 'Επαναφορά',
    'backup__restore_options__domain__domain_configuration' => 'Ρύθμιση παραμέτρων τομέα',
    'backup__restore_options__domain__virtual_host_content' => 'Περιεχόμενο εικονικού κεντρικού υπολογιστή',
    'backup__restore_options__domain__mail' => 'Ηλεκτρονικό ταχυδρομείο',
    'backup__restore_options__domain__databases' => 'Βάσεις δεδομένων',
    'backup__restore_options__client__client_configuration' => 'Ρύθμιση παραμέτρων λογαριασμού πελάτη',
    'backup__restore_options__client__domains' => "Τομείς πελάτη",
    'backup__restore_options__reseller__reseller_configuration' => 'Ρύθμιση παραμέτρων λογαριασμού μεταπωλητή',
    'backup__restore_options__reseller__personal_domains' => "Τομείς μεταπωλητή",
    'backup__restore_options__reseller__clients' => "Πελάτες μεταπωλητή",
    'backup__restore_options__admin__server_configuration' => 'Ρυθμίσεις διακομιστή',
    'backup__restore_options__admin__administrator_configuration' => 'Ρύθμιση παραμέτρων λογαριασμού διαχειριστή',
    'backup__restore_options__admin__personal_domains' => "Τομείς διαχειριστή",
    'backup__restore_options__admin__personal_clients' => "Πελάτες διαχειριστή",
    'backup__restore_options__admin__resellers' => 'Μεταπωλητές',

    'badge_new' => 'Νέα',
    'upgrade_php_on_subscription' => 'Αναβάθμιση του PHP στη συνδρομή σας στην έκδοση 5.3.0 ή νεότερη.',

    'pkey_notify__body_expiration_notification' => 'Το κλειδί άδειας χρήσης έχει λήξει. Ορισμένες δυνατότητες μπορεί να μην είναι διαθέσιμες. Επικοινωνήστε με το πάροχο υπηρεσιών φιλοξενίας σας.',

    'crontab__crontab_entry_exists' => "Η προγραμματισμένη εργασία υπάρχει ήδη.",
    'crontab__crontab_entry_not_exists' => "Η προγραμματισμένη εργασία δεν υπάρχει.",
    'crontab__invalid_values_found' => "Λανθασμένες τιμές παραμέτρων.",
    'crontab__cmd_max_len' => "Η εντολή δεν μπορεί να υπερβαίνει τους %1 χαρακτήρες.",

    'domain__domain_exists' => "Υπάρχει ήδη τομέας με το πρόθεμα 'www' και το ίδιο όνομα: %1.%2.",
    'domain__subdomain_exists' => "Υπάρχει ήδη υποτομέας με το πρόθεμα 'www' και το ίδιο όνομα: %1.%2.",
    'domain__dalias_exists' => "Υπάρχει ήδη ψευδώνυμο τομέα με το πρόθεμα 'www' και το ίδιο όνομα: %1.%2.",
    'domain__record_exists' => "Υπάρχει μια εγγραφή DNS που παραπέμπει στο διακομιστή %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Το πιστοποιητικό '%1' δεν μπορεί να οριστεί ως προεπιλεγμένο: το ιδιωτικό κλειδί λείπει.",
    'ip_addr__update_dns_error' => 'Παρουσιάστηκαν προβλήματα κατά την ενημέρωση της διεύθυνσης IP στις ζώνες DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Δεν είναι δυνατή η προσθήκη της διεύθυνσης IP. Αυτή η διασύνδεση δικτύου λαμβάνει αυτόματα τις διευθύνσεις IP.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Δεν είναι δυνατή η κατάργηση της διεύθυνσης IP %1. Αυτή η διασύνδεση δικτύου λαμβάνει αυτόματα τις διευθύνσεις IP.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Δεν είναι δυνατή η επιδιόρθωση της διεύθυνσης IP %1. Αυτή η διασύνδεση δικτύου λαμβάνει αυτόματα τις διευθύνσεις IP.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Δεν είναι δυνατή η αλλαγή της διασύνδεσης της διεύθυνσης IP %1 επειδή η διασύνδεση δικτύου %2 λαμβάνει τις διευθύνσεις IP αυτόματα.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Έχει σημειωθεί υπέρβαση του ορίου της συνδρομής όσον αφορά τον αριθμό του %%type%%. Το όριο είναι %%limit%% και αυτή τη στιγμή χρησιμοποιείται %%usage%%.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Η δημιουργία του %%type%% δεν επιτρέπεται για αυτή τη συνδρομή.',
    'shm_lmsg__resource_title__db-mysql' => 'Βάσεις δεδομένων MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Βάσεις δεδομένων MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Βάσεις δεδομένων PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'Χρήστες βάσης δεδομένων',
    'shm_lmsg__resource_title__iis-application-pool' => 'Χώροι συγκέντρωσης εφαρμογών IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'Πρόσθετοι λογαριασμοί FTP',

    'db_user_unable_remove_mysql_global_privileges' => 'Δεν είναι δυνατή η κατάργηση των καθολικών προνομίων MySQL του χρήστη %1 της βάσης δεδομένων. Αιτία: %2',
    'report__client_description' => 'Περιγραφή',

    'db__user_role_error' => 'Καθορίστηκε λανθασμένος ρόλος χρήστη βάσης δεδομένων: %1. Επιλέξτε έναν από τους παρακάτω ρόλους: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Δεν είναι δυνατός ο ορισμός του ορίου μεγέθους αρχείου για τις παρακάτω βάσεις δεδομένων Microsoft SQL Server, επειδή έχουν μεγαλύτερο μέγεθος αρχείου: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Δεν είναι δυνατός ο ορισμός του ορίου μεγέθους αρχείου καταγραφής για τις παρακάτω βάσεις δεδομένων Microsoft SQL Server, επειδή έχουν μεγαλύτερο μέγεθος αρχείου καταγραφής: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Δεν είναι δυνατός ο ορισμός δημόσιας διεύθυνσης IP: πρέπει να υπάρχει ιδιωτική διεύθυνση IP.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Δεν είναι δυνατός ο ορισμός δημόσιας διεύθυνσης IPv4 για τη διεύθυνση IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Δεν είναι δυνατός ο ορισμός δημόσιας διεύθυνσης IPv6 για τη διεύθυνση IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Δεν είναι δυνατός ο ορισμός δημόσιας διεύθυνσης IP: μη έγκυρη διεύθυνση IP.',

    '__user_already_exists' => "Ο χρήστης %1 υπάρχει ήδη.",
    '__user_name_is_empty' => "Καθορίστε ένα όνομα χρήστη.",

    'upgrade_php_on_domain' => 'Δεν είναι δυνατή η εύρεση της έκδοσης PHP 5.3.0 ή μεταγενέστερης έκδοσης σε κανέναν από τους τομείς WordPress σας. Δοκιμάστε να αναβαθμίσετε το PHP.',

    'component_name__waf' => 'Τείχος προστασίας εφαρμογών web',
    'component_name__vcs' => 'Σύστημα ελέγχου έκδοσης',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Εντοπίστηκε πιθανή απόπειρα πλαστογράφησης: Η σύνδεση επιχείρησε να εμφανίσει μη συναφές περιεχόμενο.',

    'php_handlers_error_no_available_instance' => 'Δεν είναι δυνατή η δημιουργία τομέα: δεν υπάρχουν διαθέσιμοι δείκτες χειρισμού PHP.',
    'domain_error_unable_to_apply_hosting_settings' => 'Δεν είναι δυνατή η εφαρμογή των ρυθμίσεων φιλοξενίας: %1',

    'plesk_not_configured' => 'Το Plesk δεν έχει ρυθμιστεί. Μεταβείτε στον πίνακα ελέγχου για να εκτελέσετε τη ρύθμιση παραμέτρων μετά την εγκατάσταση.',
    'cmd_mail__mail_password_duplicated' => 'Το καθορισμένο ζεύγος διεύθυνσης ηλεκτρονικού ταχυδρομείου και κωδικού πρόσβασης υπάρχει ήδη στον διακομιστή αλληλογραφίας. Εισαγάγετε άλλη διεύθυνση ηλεκτρονικού ταχυδρομείου ή κωδικό πρόσβασης.',

    'extensionRequirementOs' => 'Το λειτουργικό σύστημα (%1) δεν υποστηρίζεται από το πακέτο.',
    'extensionRequirementPleskMinVersion' => 'Το Plesk %1 είναι η παλαιότερη έκδοση που υποστηρίζεται από το πακέτο.',
    'extensionRequirementPleskMaxVersion' => 'Οι εκδόσεις που ξεκινούν από το Plesk %1 δεν υποστηρίζονται από το πακέτο.',
    'extensionBlacklisted' => 'Η επέκταση %1 δεν επιτρέπεται για την εγκατάσταση.',
    'extensionDisabled' => 'Η επέκταση είναι απενεργοποιημένη.',


    'optimization_settings__unable_set_mpm_event' => 'Δεν είναι δυνατός ο ορισμός της λειτουργίας mpm_event: απαιτεί η λειτουργική μονάδα Apache PHP5 να είναι απενεργοποιημένη αλλά η μονάδα αυτή χρησιμοποιείται από τους τομείς.',
    'optimization_settings__unable_turn_off_php' => 'Δεν είναι δυνατή η ενεργοποίηση της λειτουργικής μονάδας Apache PHP5: χρησιμοποιείται από τους τομείς.',

    'hst_def__fp_admin_login' =>  'Όνομα χρήστη FTP',
    'hst_def__fp_admin_passwd' =>  'Κωδικός πρόσβασης FTP',

    'database_user_orphaned_old_password_wrong' => "Δεν είναι δυνατή η επιδιόρθωση του \"ορφανού\" χρήστη '%1': ο κωδικός πρόσβασης είναι λανθασμένος.",
    'cannot_load_partner_central_property_key_no_exist' => "Δεν είναι δυνατή η ανάκτηση των προσαρμοσμένων ιδιοτήτων: το κλειδί άδειας δεν υπάρχει.",
    'extensionScriptFailure' => "Η εκτέλεση του %1 απέτυχε με το ακόλουθο μήνυμα:\n%3",
    '__ssl_redirect' => "Μόνιμη, ασφαλής ως προς το SEO, ανακατεύθυνση 301 από HTTP σε HTTPS",
    'component_name__dotnetcore' => 'Πυρήνας .NET',
    'mail__dkim_not_supported' => 'Η διαχείριση του DKIM δεν υποστηρίζεται.',
    'mail__dmarc_not_supported' => 'Η διαχείριση DMARC δεν υποστηρίζεται.',
    'mail__relay_white_list_not_supported' => 'Η διαχείριση της λίστα επιτρεπόμενων αναμετάδοσης δεν υποστηρίζεται.',
    'mail__black_list_not_supported' => 'Η διαχείριση της μαύρης λίστας δεν υποστηρίζεται.',
    'mail__autoresponder_not_supported' => 'Η διαχείριση της λειτουργίας αυτόματης απάντησης δεν υποστηρίζεται.',
    'defaultcomponents__not_supported_version' => '(μη υποστηριζόμενη έκδοση)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Το πιστοποιητικό \'%1\' δεν βρέθηκε.',
    'certificate__unable_setup_certificate' => 'Δεν είναι δυνατή η εγκατάσταση του πιστοποιητικού: Λείπει το ιδιωτικό κλειδί και το περιεχόμενο του πιστοποιητικού.',
    'certificate__used_by_panel' => 'Ένα από τα πιστοποιητικά που πρόκειται να διαγράψετε, χρησιμοποιείται για την προστασία του Plesk.',
    'certificate__used_by_mail_server' => 'Ένα από τα πιστοποιητικά που πρόκειται να διαγράψετε, χρησιμοποιείται για την προστασία του διακομιστή αλληλογραφίας.',
    'certificate__used_by_domain_service' => 'Ένα από τα πιστοποιητικά που πρόκειται να διαγράψετε, χρησιμοποιείται από την υπηρεσία τομέα.',
    'mail_server__not_installed' => 'Δεν είναι δυνατή η εγκατάσταση του πιστοποιητικού για τον διακομιστή αλληλογραφίας επειδή δεν έχει εγκατασταθεί ο διακομιστής αλληλογραφίας.',

    'email_activation_mail_subject' => 'Παρακαλούμε ενεργοποιήστε τον λογαριασμό σας στο Plesk',
    'email_activation_mail_body' => "Δημιουργήθηκε ένας λογαριασμός στον διακομιστή Plesk %1 \n\nΛεπτομέρειες λογαριασμού: \nΌνομα: %2 \nΔιεύθυνση E-mail: %3 \n\nΕάν οι πληροφορίες αυτές είναι σωστές και ο λογαριασμός δημιουργήθηκε για εσάς, παρακαλούμε να τον ενεργοποιήσετε με την ακόλουθη σύνδεση: \n\n%4 \n\nΕνεργοποιώντας τον λογαριασμό, εξουσιοδοτείτε τον κάτοχο του διακομιστή να συλλέγει, να αποθηκεύει, να επεξεργάζεται και να χρησιμοποιεί τα προσωπικά δεδομένα σας (όνομα και διεύθυνση ηλεκτρονικού ταχυδρομείου) για τη δημιουργία και υποστήριξη του λογαριασμού σας, σύμφωνα με τους ισχύοντες νόμους περί προστασίας δεδομένων, στο πλαίσιο μιας σύμβασης.",

    'backup_transport_permission_name' => 'Διαχείριση %1',
    'backup_transport_permission_description' => 'Επιτρέπει τη χρήση %1 για την αποθήκευση αντιγράφων ασφαλείας.',

    'domain_move_err_target_no_hosting' => 'Δεν είναι δυνατή η μετακίνηση του τομέα σε μια συνδρομή χωρίς φιλοξενία.',
    'domain_move_err_already_in_target' => 'Ο τομέας ανήκει ήδη στη συνδρομή προορισμού.',
    'domain_move_err_main_domain' => 'Δεν είναι δυνατή η μετακίνηση του κύριου τομέα.',
    'domain_move_err_subdomain_without_parent' => 'Δεν είναι δυνατή η μετακίνηση του υποτομέα %1 χωρίς τον γονικό τομέα %2.',
    'domain_move_err_root_exists' => 'Η διαδρομή προορισμού για το www_root %1 υπάρχει ήδη.',
    'domain_move_err_nested_roots' => 'Δεν είναι δυνατή η μετακίνηση του τομέα επειδή μοιράζεται τον ριζικό κατάλογο εγγράφων με έναν άλλο τομέα: %1.',
    'domain_move_err_no_mail_service' => 'Δεν είναι δυνατή η μετακίνηση του τομέα επειδή η υπηρεσία αλληλογραφίας είναι απενεργοποιημένη στη συνδρομή προορισμού.',
    'domain_move_err_app' => "Η εφαρμογή που είναι εγκατεστημένη στο %1 δεν μετακινήθηκε στη συνδρομή '%2': %3",
    'domain_move_database_used_by_app' => "Η βάση δεδομένων '%1' στο %2 χρησιμοποιείται από την εφαρμογή που μετακινήθηκε. Για να εκχωρήσετε εκ νέου τη βάση δεδομένων στο '%3', εκτελέστε την εντολή `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Η συνδρομή προορισμού '%1' κλειδώθηκε για συγχρονισμό.",
    'domain_move_filesharing_disabled' => 'Η κοινή χρήση αρχείων απενεργοποιήθηκε.',
    'domain_move_website_preview_disabled' => 'Η προεπισκόπηση τοποθεσίας web απενεργοποιήθηκε.',
    'domain_move_additional_webserver_settings' => "Ελέγξτε τις πρόσθετες οδηγίες διακομιστή web του τομέα για να αποφευχθεί η κατεστραμμένη ρύθμιση παραμέτρων.",
    'domain_move_no_permission' => "Το %1 δεν επιτρέπεται για τη συνδρομή '%2'.",
    'domain_move_no_access' => "Δεν υπάρχει πρόσβαση στη συνδρομή '%1'.",
    'domain_split_no_create_permission' => "Δεν επιτρέπεται η δημιουργία τομέων.",
    'domain_split_empty_login' => 'Απαιτείται όνομα σύνδεσης του χρήστη του συστήματος.',
    'domain_split_empty_password' => 'Απαιτείται κωδικός πρόσβασης του χρήστη του συστήματος.',
    'domain_split_err_home_exists' => 'Ο τομέας %1 δεν μπορεί να μετακινηθεί, επειδή η διαδρομή αρχικής σελίδας προορισμού υπάρχει ήδη στο %2. Μετονομάστε τον τομέα για να τον μετακινήσετε σε μια νέα συνδρομή.',
    'domain_split_err_no_hosting_subdomains' => 'Ο τομέας δεν μπορεί να μετακινηθεί σε νέα συνδρομή επειδή ο τομέας αυτός δεν έχει φιλοξενία, αλλά έχει υποτομείς. Για να μετακινήσετε αυτόν τον τομέα, αλλάξτε την τιμή "Τύπος φιλοξενίας" σε "Φιλοξενία τοποθεσίας web" (στις ρυθμίσεις φιλοξενίας).',
    'domain_split_target_locked' => "Η συνδρομή προορισμού '%1' κλειδώθηκε για συγχρονισμό.",
    'domain_split_target_unsynced' => "Η συνδρομή προορισμού '%1' δεν συγχρονίστηκε με το πρόγραμμα εξαιτίας: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Η προγραμματισμένη δημιουργία αντιγράφων ασφαλείας. απενεργοποιήθηκε στο '%1'.",
    'domain_merge_database_error' => "Η βάση δεδομένων '%1' στο %2 δεν μετακινήθηκε στη συνδρομή '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Το ανώνυμο FTP στο '%1' απενεργοποιήθηκε.",
    'domain_merge_smb_user_access' => "Ο πρόσθετος χρήστης '%1' μεταφέρθηκε στη συνδρομή '%2', αλλά η πρόσβαση του χρήστη στη συνδρομή ανακλήθηκε.",
    'domain_merge_scheduled_tasks' => "Οι προγραμματισμένες εργασίες μεταφέρθηκαν στη συνδρομή προορισμού. Ανασκόπηση ρύθμισης παραμέτρων εργασιών.",
    'domain_merge_scheduled_tasks_deactivated' => "Οι προγραμματισμένες εργασίες μεταφέρθηκαν στη συνδρομή προορισμού και απενεργοποιήθηκαν. Ανασκόπηση ρύθμισης παραμέτρων εργασιών.",
    'domain_merge_no_remove_permission' => "Δεν επιτρέπεται η κατάργηση συνδρομών.",
    'domain_merge_err_has_addons' => 'Δεν είναι δυνατή η μετακίνηση του κύριου τομέα με πρόσθετους τομείς. Πρέπει πρώτα να μετακινήσετε τον(ους) τομέα(είς) %1.',
    'domain_merge_err_has_webusers' => 'Δεν είναι δυνατή η μετακίνηση του κύριου τομέα με χρήστες web.',
    'domain_merge_err_root_exists' => 'Η διαδρομή προορισμού %1 υπάρχει ήδη.',

    'database_server_edit_used_for_psa' => 'Δεν επιτρέπεται η ενημέρωση τοπικού διακομιστή βάσεων δεδομένων MySQL.',
    'suggest_repair_main_suggestion_ui' => '<b>Μπορείτε να επιδιορθώσετε αυτό το σφάλμα</b> χρησιμοποιώντας το βοηθητικό πρόγραμμα `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Μπορείτε να επιδιορθώσετε αυτό το σφάλμα χρησιμοποιώντας το βοηθητικό πρόγραμμα `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'μεταβείτε στην επιλογή Εντοπισμός & Επιδιόρθωση',
    'suggest_repair_using_cli_and_ui' => 'Προκειμένου να το κάνετε αυτό, είτε εκτελέστε την εντολή `plesk repair %1` μέσω του CLI είτε %2 και κάντε κλικ στην επιλογή Επιδιόρθωση δίπλα από τη «Βάση Δεδομένων του Plesk»',
    'suggest_repair_using_cli' => 'Προκειμένου να το κάνετε αυτό, εκτελέστε την εντολή `plesk repair %1` μέσω του CLI',
    'verp_style_link' => 'Τύπου VERP',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Η υπηρεσία DNS δεν ήταν διαθέσιμη όταν δημιουργήθηκε το αντίγραφο ασφαλείας. Ωστόσο υπάρχουν ενεργές ζώνες DNS στο αντίγραφο ασφαλείας και θα ενεργοποιηθούν για τα ακόλουθα αντικείμενα: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Ελεγκτής πόρων (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Υποστήριξη απομακρυσμένου SmarterMail',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(δεν επιτρέπεται λόγω κλειδιού άδειας χρήσης)',
    'plesk_key__validation_failed' => '%1 (Κωδικός σφάλματος: %2)',
    'promo__button_details' => 'Λεπτομέρειες',
    'promo__extension_catalog_title' => 'Κατάλογος επεκτάσεων',
    'promo__extension_catalog_description' => 'Δείτε τον νέο κατάλογο επεκτάσεων και εμπλουτίστε το Plesk σας με μια σειρά από πανίσχυρες επεκτάσεις!',
    'promo__button_open_catalog' => 'Άνοιγμα του καταλόγου',

    'backup__repository_check_login' => "Δεν είναι δυνατή η πρόσβαση στον χώρο αποθήκευσης: %1 Βεβαιωθείτε ότι έχετε εισαγάγει τα σωστά διαπιστευτήρια χώρου αποθήκευσης.",
    'backup__repository_check_error_list' => "Δεν είναι δυνατή η πρόσβαση στον χώρο αποθήκευσης: %1 Βεβαιωθείτε ότι έχετε πραγματοποιήσει τις σωστές ρυθμίσεις χώρου αποθήκευσης.",
    'backup__repository_check_error_mkdir' => "Δεν είναι δυνατή η δημιουργία του καταλόγου: %1 Βεβαιωθείτε ότι έχετε δικαιώματα δημιουργίας φακέλων στον χώρο αποθήκευσης.",
    'backup__repository_check_error_upload' => "Δεν είναι δυνατή η αποστολή του αρχείου στον χώρο αποθήκευσης: %1 Βεβαιωθείτε ότι έχετε δικαιώματα αποστολής αρχείων στον χώρο αποθήκευσης.",
    'backup__repository_check_error_download' => "Δεν είναι δυνατή η λήψη του αρχείου από τον χώρο αποθήκευσης: %1 Βεβαιωθείτε ότι έχετε δικαιώματα αποστολής προς και λήψης από τον χώρο αποθήκευσης.",
    'backup__repository_check_error_resume-upload' => "Δεν είναι δυνατή η συνέχιση αποστολής του αρχείου στον χώρο αποθήκευσης: %1 Βεβαιωθείτε ότι έχετε δικαιώματα συνέχισης αποστολών στον χώρο αποθήκευσης.",
    'backup__repository_check_error_resume-download' => "Δεν είναι δυνατή η συνέχιση λήψης του αρχείου από τον χώρο αποθήκευσης: %1 Βεβαιωθείτε ότι έχετε δικαιώματα συνέχισης λήψεων από τον χώρο αποθήκευσης.",
    'backup__repository_check_error_enable-utf8' => "Δεν είναι δυνατός ο χειρισμός του χώρου αποθήκευσης: %1 Ελέγξτε εάν ο χώρος αποθήκευσης υποστηρίζει κωδικοποίηση UTF8.",
    'backup__repository_check_error_rm' => "Δεν είναι δυνατός ο χειρισμός του χώρου αποθήκευσης: %1 Βεβαιωθείτε ότι έχετε δικαιώματα διαγραφής αρχείων από τον χώρο αποθήκευσης.",
    'backup__repository_check_error_rmdir' => "Δεν είναι δυνατός ο χειρισμός του χώρου αποθήκευσης: %1 Βεβαιωθείτε ότι έχετε δικαιώματα διαγραφής φακέλων από τον χώρο αποθήκευσης.",

    'backup__ftp_repository_check_login' => "%1 Μπορείτε να τα ελέγξετε ξεχωριστά με την εντολή: %2",
    'backup__ftp_repository_check_error_list' => "%1 Μπορείτε να τα ελέγξετε ξεχωριστά με την εντολή: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Μπορείτε να το ελέγξετε ξεχωριστά με την εντολή: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Μπορείτε να το ελέγξετε ξεχωριστά με τις εντολές: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Μπορείτε να το ελέγξετε ξεχωριστά με τις εντολές: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Μπορείτε να το ελέγξετε ξεχωριστά με τις εντολές: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Μπορείτε να το ελέγξετε ξεχωριστά με τις εντολές: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Μπορείτε να το ελέγξετε ξεχωριστά με την εντολή: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Μπορείτε να το ελέγξετε ξεχωριστά με τις εντολές: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Μπορείτε να το ελέγξετε ξεχωριστά με τις εντολές: %2 %3",

    'sfdmarc_server_wide_legend' => 'DMARC',
    'sfdmarc_server_wide_enable_dmarc' => 'Ενεργοποίηση του DMARC για τον έλεγχο της εισερχόμενης αλληλογραφίας',
    'sfdmarc_server_wide_enable_failed' => 'Δεν είναι δυνατή η αλλαγή των ρυθμίσεων για το DMARC. Προκειμένου να ενεργοποιήσετε αυτήν την επιλογή, ενεργοποιήστε τις υπηρεσίες προστασίας ανεπιθύμητης αλληλογραφίας DKIM και SPF.',
    'sfdmarc_server_wide_enable_hint' => 'Αυτή η επιλογή είναι διαθέσιμη όταν οι DKIM και SPF είναι ενεργοποιημένες για την εισερχόμενη αλληλογραφία.',
    'spf_server_wide_enable_hint' => 'Αυτή η επιλογή δεν μπορεί να απενεργοποιηθεί όσο το DMARC είναι ενεργοποιημένο για την εισερχόμενη αλληλογραφία.',
    'spf_server_wide_disable_failed' => 'Δεν είναι δυνατή η αλλαγή των ρυθμίσεων για την υπηρεσία προστασίας ανεπιθύμητης αλληλογραφίας SPF. Προκειμένου να απενεργοποιήσετε την SPF, απενεργοποιήστε το DMARC για την εισερχόμενη αλληλογραφία.',
    'sfdk_server_wide_enable_hint' => 'Αυτή η επιλογή δεν μπορεί να απενεργοποιηθεί όσο το DMARC είναι ενεργοποιημένο για την εισερχόμενη αλληλογραφία.',
    'sfdk_server_wide_verify_disable_failed' => 'Δεν είναι δυνατή η αλλαγή των ρυθμίσεων για την υπηρεσία προστασίας ανεπιθύμητης αλληλογραφίας DKIM. Προκειμένου να απενεργοποιήσετε την DKIM, απενεργοποιήστε το DMARC για την εισερχόμενη αλληλογραφία.',

    'ccs_not_supported' => 'Ο Κεντρικός Χώρος Αποθήκευσης του IIS δεν είναι ρυθμισμένος στο σύστημα.',
    'ccs_not_enabled' => 'Η διαχείριση του Κεντρικού Χώρου Αποθήκευσης του IIS δεν είναι ενεργοποιημένη στο Plesk.',
    'ad_not_supported' => 'Ο διακομιστής δεν είναι ενταγμένος σε τομέα.',

    'component_name__appinit' => "Προετοιμασία εφαρμογών",
    'component_name__httpcompression' => 'Συμπίεση περιεχομένου HTTP',
    'common_feature_is_not_supported' => 'Αυτό το χαρακτηριστικό δεν υποστηρίζεται πλέον.',
    'common_feature_is_not_supported_in_proto' => 'Αυτό το χαρακτηριστικό δεν υποστηρίζεται για την έκδοση πρωτοκόλλου %1.',
    'autoinstaller__plesk_component' => 'Στοιχείο Plesk',
    'plesk_key__key_expired' => 'Το κλειδί άδειας χρήσης σας έχει λήξει. Προκειμένου να συνεχίσετε να χρησιμοποιείτε το Plesk, αγοράστε ένα εμπορικό %1 χωρίς ημερομηνία λήξης.',
    'plesk_key__key_purchase' => 'κλειδί άδειας χρήσης',

    'sa_action_move' => 'Μετακίνηση των ανεπιθύμητων μηνυμάτων στον φάκελο ανεπιθύμητης αλληλογραφίας',

    'bu_conflict_resolver_tomcat_not_supported' => 'Οι εφαρμογές Java δεν υποστηρίζονται πλέον. Δε θα είναι διαθέσιμες για τους ακόλουθους ιστότοπους: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Οι εκδόσεις ιστότοπων κινητών συσκευών οι οποίες φιλοξενούνται μέσω της υπηρεσίας UNITY Mobile δεν υποστηρίζονται πλέον. Δε θα είναι διαθέσιμες για τους ακόλουθους ιστότοπους: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Η πολιτική χρήσης σε επίπεδο διακομιστή δεν επιτρέπει τη χρήση προσωπικών ρυθμίσεων προστασίας από ιούς. Θα αποκατασταθούν ατελώς για λογαριασμούς ηλεκτρονικού ταχυδρομείου στους ακόλουθους τομείς: {{objects}}',

    'server_preferences__ip_logging' => 'Καταγραφή IP',
    'server_preferences__disable_ip_logging' => 'Απενεργοποίηση καταγραφής IP σε ISS, FTP και αρχεία καταγραφής αλληλογραφίας',
    'server_preferences__disable_ip_logging_description' => 'Εάν επιλεγεί, δε θα γίνεται πλέον εγγραφή διευθύνσεων IP από τα IIS και MailEnable σε αρχεία καταγραφής',

    'module__not_installed' => "Η επέκταση %1 δεν έχει εγκατασταθεί",

    'mail__mailbox_quota_warning_text' => 'Ενεργοποίηση προειδοποίησης ορίου γραμματοκιβωτίου',
    'mail__mailbox_quota_warning_hint' => 'Αποστολή ειδοποίησης στους χρήστες της αλληλογραφίας όταν το όριο του γραμματοκιβωτίου τους υπερβαίνει το 95%',
    'mail__mailbox_quota_warning_customization_text' => 'Προσαρμογή της προεπιλεγμένης προειδοποίησης για το όριο του γραμματοκιβωτίου',
    'mail__mailbox_fix-incorrectly-set-sender-text' => 'Διόρθωση λανθασμένα καθορισμένου αποστολέα για την εξερχόμενη αλληλογραφία',
    'mail__mailbox_fix-incorrectly-set-sender-hint' => 'Αυτόματος ορισμός έγκυρων κεφαλίδων ηλεκτρονικού ταχυδρομείου και ηλεκτρονικής διεύθυνσης αποστολέα φακέλου για εξερχόμενη αλληλογραφία από τομείς, προκειμένου να μειωθούν οι πιθανότητες αντιμετώπισής τους ως ανεπιθύμητη αλληλογραφία',
    'mail__mail_autodiscovery' => 'Αυτόματος εντοπισμός αλληλογραφίας',
    'mail__mail_autodiscovery_description_text' => 'Δείτε πώς λειτουργεί στο %%link%%',
    'mail__mail_autodiscovery_description_text_link' => 'γνωσιακή βάση',
    'mail__mail_autodiscovery_text' => 'Ενεργοποίηση αυτόματου εντοπισμού αλληλογραφίας',
    'mail__mail_autodiscovery_hint' => 'Η ενεργοποίηση αυτού του χαρακτηριστικού επαναρρυθμίζει όλους τους τομείς που έχουν ενεργοποιημένο τον αυτόματο εντοπισμό',
    'mail__mail_autodiscovery_server_text' => 'Καθορισμός προσαρμοσμένου ονόματος τομέα για τον αυτόματο εντοπισμό αλληλογραφίας',
    'mail__mail_autodiscovery_server_hint' => 'Σημείωση: Το όνομα τομέα θα πρέπει να είναι ασφαλισμένο με έγκυρο πιστοποιητικό SSL/TLS.',
    'mail__mail_autodiscovery_server_error' => 'Καθορισμός προσαρμοσμένου ονόματος τομέα για τον αυτόματο εντοπισμό αλληλογραφίας',
    'mail__mail_autodiscovery_reconfigure_dns_text' => 'Επαναρρύθμιση των εγγραφών DNS αυτόματου εντοπισμού τομέων',
    'mail__mail_autodiscovery_reconfigure_dns_hint' => 'Η ενεργοποίηση αυτού του χαρακτηριστικού επαναρρυθμίζει όλες τις εγγραφές DNS αυτόματου εντοπισμού τομέων που έχουν ενεργοποιημένο τον αυτόματο εντοπισμό',
    'mail__error_mail_autodiscovery_enable' => 'Δεν είναι δυνατός ο ορισμός του αυτόματου εντοπισμού αλληλογραφίας: %1',
    'mail__error_mail_autodiscovery_server' => 'Δεν είναι δυνατός ο ορισμός προσαρμοσμένου ονόματος τομέα για τον αυτόματο εντοπισμό αλληλογραφίας: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Δεν είναι δυνατή η επαναρρύθμιση των εγγραφών DNS αυτόματου εντοπισμού τομέων: %1',

    '__invalid_url' => 'Η διεύθυνση URL «%1» δεν είναι έγκυρη',
    'actionlog__cloning_start' => 'έναρξη',
    'actionlog__event_cloning_start' => 'Έναρξη κλωνοποίησης διακομιστή',

        '__show_hide_title' => 'Ελαχιστοποίηση/Επαναφορά',
    '__show_hide_navigation_pane' => 'Απόκρυψη/εμφάνιση του παραθύρου περιήγησης',
    '__UPLOAD_ERR_FORM_SIZE' => "Το απεσταλμένο αρχείο υπερβαίνει το επιτρεπόμενο μέγεθος",
    '__UPLOAD_ERR_INI_SIZE' => "Το απεσταλμένο αρχείο υπερβαίνει το επιτρεπόμενο μέγεθος",
    '__UPLOAD_ERR_NO_FILE' => "Δεν ελήφθη αρχείο",
    '__UPLOAD_ERR_OK' => "Το αρχείο απεστάλη με επιτυχία",
    '__UPLOAD_ERR_PARTIAL' => "Το αρχείο απεστάλη εν μέρει, προσπαθήστε ξανά",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Ο προσωρινός φάκελος λείπει',
    '__UPLOAD_ERR_CANT_WRITE' => 'Αποτυχία εγγραφής του αρχείου στο δίσκο',
    '__UPLOAD_ERR_UNKNOWN' => 'Παρουσιάστηκε άγνωστο σφάλμα αποστολής αρχείου',
    '__accounts' => "Λογαριασμοί",
    '__access' => "Πρόσβαση",
    '__address' => "Διεύθυνση",
    '__addresses' => "Διευθύνσεις",
    '__acl_records' => 'Εγγραφές ACL',
    '__admin_repository' => "Αποθετήριο διαχειριστή",
    '__all' => 'Όλες',
    '__allowed' => "Επιτρέπεται",
    '__anonftp_status' => "Ανώνυμο FTP",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...εκτελείται επανεκκίνηση του διακομιστή web %1, παρακαλώ περιμένετε...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Υποστήριξη Microsoft ASP.NET",
    '__asp_win_support' => "Υποστήριξη Microsoft ASP",
    '__attachments' => "Συνημμένα",
    '__attachments_list' => "Συνημμένα",
    '__author' => 'Συντάκτης',
    '__autoresp_name_already_exists' => "Υπάρχει ήδη αυτόματη απάντηση με το όνομα %1.",
    '__autoresponder' => "Αυτόματη απάντηση",
    '__autoresponders' => "Αυτόματες απαντήσεις",
    '__autoresponders_list' => "Αυτόματες απαντήσεις",
    '__autoresponder_attachment_files' => "Συνημμένα αρχεία αυτόματης απάντησης",
    '__auto_updates_list' => 'Διαθέσιμες ενημερώσεις',
    '__avail' => "Διαθέσιμο",
    '__backup_utilites' => "Βοηθητικά προγράμματα δημιουργίας αντιγράφων ασφαλείας",
    '__bind_status' => "Κατάσταση διακομιστή DNS",
    '__bu_is_not_installed' => "Η υπηρεσία αυτή δεν είναι διαθέσιμη αυτήν τη στιγμή επειδή τα βοηθητικά προγράμματα αντιγράφων ασφαλείας δεν έχουν εγκατασταθεί.",
    '__bu_not_support_in_key' => "Η δυνατότητα δημιουργίας αντιγράφων ασφαλείας δεν υποστηρίζεται από το κλειδί άδειας χρήσης.",
    '__notifications_not_support_in_key' => 'Οι ειδοποιήσεις δεν υποστηρίζονται από το κλειδί άδειας χρήσης',
    'disabled_by_key' => 'Δεν υποστηρίζεται από το κλειδί άδειας χρήσης',
    '__bytes' => "byte",
    '__can_not_use_reserved_words' => "Δεν μπορείτε να χρησιμοποιήσετε τις δεσμευμένες λέξεις.",
    '__certificate' => "Πιστοποιητικό",
    '__cgi_support' => "Υποστήριξη CGI",
    '__change_date' => "Ημερομηνία τροποποίησης",
    '__choose_logo' => "Αρχείο λογότυπου",
    '__city' => "Πόλη",
    '__cl_not_exist' => "Ο λογαριασμός πελάτη δεν υπάρχει.",
    '__client' => 'Πελάτης',
    '__client_card' => "Καρτέλα πελάτη",
    '__client_contact_name' => "Όνομα επαφής πελάτη",
    '__client_form' => "Προσωπικές πληροφορίες",
    '__client_ip_pool' => "Χώρος IP πελάτη",
    '__client_limits' => "Όρια λογαριασμού πελάτη",
    '__client_permissions' => "Δικαιώματα πελάτη",
    '__client_preferences' => "Προτιμήσεις πελάτη",
    '__client_status' => "Κατάσταση πελάτη",
    '__client_name' => "Όνομα πελάτη",
    '__client_total' => "Σύνολο πελάτη",
    '__client_with_login_name_already_exists' => "Υπάρχει ήδη χρήστης με όνομα χρήστη \"%1\".",
    '__client_domuser_with_login_already_exists' => "Το όνομα χρήστη '%1' χρησιμοποιείται ήδη από το διαχειριστή του τομέα '%1'.",
    '__clients_global_changes' => "Τροποποίηση επιλεγμένων λογαριασμών πελατών",
    '__clients_list' => "Πελάτες",
    '__cmd_not_found' => "Άγνωστη εντολή: %1",
    '__comments' => "Σχόλια",
    '__company_name' => "Όνομα εταιρείας",
    '__component_version' => "Έκδοση στοιχείου",
    '__component_not_installed' => "Το στοιχείο %1 δεν εγκαταστάθηκε",
    '__confirm_del' => "Πρέπει να επιβεβαιώσετε τη διαγραφή.",
    '__confirm_overwrite' => "Επιβεβαίωση αντικατάστασης.",
    '__confirm_stop' => "Πρέπει να επιβεβαιώσετε τη διακοπή της διαδικασίας.",
    '__confirm_passwd' => "Επιβεβαίωση κωδικού πρόσβασης %1",
    '__confirm_removal' => "Επιβεβαίωση κατάργησης",
    '__conhelp' => "Περιγραφή",
    '__contact_name' => "Όνομα επαφής",
    '__country' => "Χώρα",
    '__countries' => 'Χώρα',
    '__country_unknown' => 'Δεν είναι δυνατή η αναγνώριση του υποκωδικού χώρας.',
    '__courier-imap' => 'Διακομιστής Courier',
    '__create_domain' => 'Δημιουργία τομέα',
    '__crypted' => 'κρυπτογραφημένο',
    '__cp_access' => "Πρόσβαση στο Plesk",
    '__cp_user' => "Χρήστης Plesk",
    '__create' => "Δημιουργία",
    '__create_client_template_without_template' => "Δημιουργία λογαριασμού χρήστη χωρίς πρότυπο",
    '__create_domain_for' => "Δημιουργία τομέα για το <b />%1</b>",
    '__create_domain_template_without_template' => "Δημιουργία τομέα χωρίς πρότυπο",
    '__creation_date' => "Ημερομηνία δημιουργίας",
    '__crontab_unix' => "Χρονοδιάγραμμα",
    '__crontab_win' => "Χρονοδιάγραμμα",
    '__ct_month_jan' => 'Ιανουάριος',
    '__ct_month_feb' => 'Φεβρουάριος',
    '__ct_month_mar' => 'Μάρτιος',
    '__ct_month_apr' => 'Απρίλιος',
    '__ct_month_may' => 'Μαι',
    '__ct_month_jun' => 'Ιούνιος',
    '__ct_month_jul' => 'Ιούλιος',
    '__ct_month_aug' => 'Αύγουστος',
    '__ct_month_sep' => 'Σεπτέμβριος',
    '__ct_month_oct' => 'Οκτώβριος',
    '__ct_month_nov' => 'Νοέμβριος',
    '__ct_month_dec' => 'Δεκέμβριος',
    '__custom_button' => "Προσαρμοσμένο κουμπί",
    '__custom_buttons_list' => "Συνδέσεις σε πρόσθετες υπηρεσίες",
    '__daily' => "Καθημερινά",
    '__database_not_activated' => "Το %1 δεν ενεργοποιήθηκε στη σελίδα διαχείρισης του διακομιστή.",
    '__database_not_installed' => "Η βάση δεδομένων %1 δεν έχει εγκατασταθεί.",
    '__database_not_run' => "Η βάση δεδομένων %1 δεν εκτελείται.",
    '__database_is_corrupt' => "Η βάση δεδομένων του Plesk έχει καταστραφεί. Εκτελέσετε το βοηθητικό πρόγραμμα Reconfigurator για να διορθώσετε το πρόβλημα.",
    '__databases' => "Βάσεις δεδομένων",
    '__databases_list' => "Βάσεις δεδομένων",
    '__database_type_not_supported_by_key' => 'Για να χρησιμοποιήσετε τον διακομιστή %1, ο εν λόγω διακομιστής θα πρέπει να υποστηρίζεται από το κλειδί άδειας χρήσης σας. Συμβουλευτείτε τον αντιπρόσωπο πωλήσεων του Plesk.',
    '__date_immediately' => "σήμερα",
    '__date_never' => "ποτέ",
    '__day(s)' => "Ημέρα(ες)",
    '__day0' => "Κυρ",
    '__day1' => "Δευ",
    '__day2' => "Τρί",
    '__day3' => "Τετ",
    '__day4' => "Πέμ",
    '__day5' => "Παρ",
    '__day6' => "Σάβ",
    '__days' => "%1 ημέρα(ες)",
    '__db_admin_login_empty' => "Έχετε εισάγει κενό όνομα χρήστη, απενεργοποιώντας τον έλεγχο του %1 στο περιβάλλον εργασίας. Θέλετε να προχωρήσετε;",
    '__db_unable_to_unregister' => 'Δεν είναι δυνατή η κατάργηση των παραμέτρων σύνδεσης της βάσης δεδομένων',
    '__db_db_exists' => 'Υπάρχει τουλάχιστον μία βάση δεδομένων στο διακομιστή',
    '__db_unable_to_change_server_name' => 'Το όνομα του διακομιστή δεν μπορεί να αλλάξει',
    '__db_unable_to_change_port' => 'Η θύρα του διακομιστή δεν μπορεί να αλλάξει',
    '__db_already_exist' => "Η βάση δεδομένων %1 υπάρχει ήδη.",
    '__db_credentials_invalid' => "Τα διαπιστευτήρια της βάσης δεδομένων δεν είναι έγκυρα.",
    '__db_invalid_password_characters' => 'Το κωδικός πρόσβασης περιέχει χαρακτήρες που δεν είναι έγκυροι',
    '__db_engine' => "Μηχανή βάσης δεδομένων", // indirect
    '__db_type' => "Τύπος βάσης δεδομένων",
    '__db_user' => "Χρήστης βάσης δεδομένων",
    '__db_server' => 'Διακομιστής βάσεων δεδομένων',
    '__def_domain' => "Προεπιλεγμένος τομέας",
    '__default_for_mysql' => 'προεπιλογή για MySQL',
    '__default_for_mariadb' => 'προεπιλογή για MariaDB',
    '__default_for_percona' => 'προεπιλογή για Percona',
    '__default_for_postgresql' => 'προεπιλογή για το PostgreSQL',
    '__delete' => "Διαγραφή",
    '__demo' => "Η λειτουργία αυτή δεν είναι διαθέσιμη στη δοκιμαστική έκδοση.",
    '__directory' => "Κατάλογος",
    '__disable_lock_screen' => 'Αποτρέψτε τη δυνατότητα των χρηστών να χρησιμοποιούν το Plesk μέχρι να φορτωθούν πλήρως οι οθόνες του περιβάλλοντος εργασίας',
    '__dismiss_news?' => "Είστε βέβαιοι ότι θέλετε να κλείσετε τελείως την ενότητα των νέων;\n\nΔεν θα είστε σε θέση να δείτε την ενότητα των νέων μέχρι να καταστούν διαθέσιμα περισσότερα νέα.",
    '__description' => "Περιγραφή",
    '__disabled' => "απενεργοποιήθηκε",
    '__disk_space_limit' => "Όριο χώρου στο δίσκο",
    '__cgroups_cpu_usage_limit' => 'Όριο χρήσης CPU',
    '__cgroups_ram_usage_limit' => 'Όριο χρήσης RAM',
    '__cgroups_disk_read_usage_limit' => 'Όριο εύρους ζώνης ανάγνωσης δίσκου',
    '__cgroups_disk_write_usage_limit' => 'Όριο εύρους ζώνης εγγραφής στον δίσκο',
    '__disk_usage_by' => "Χώρος στο δίσκο που χρησιμοποιείται από το %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Εγγραφές DNS '%1' που υπάρχουν ήδη.",
    '__dns_master_should_be_remote' => "Πρέπει να έχετε δύο διαφορετικούς έγκυρους διακομιστές ονομάτων σε ξεχωριστούς κεντρικούς υπολογιστές.",
    '__dns_record_not_exist' => "Η εγγραφή DNS δεν υπάρχει.",
    '__dns_server' => "Διακομιστής DNS", // indirect
    '__dom_id_is_undefined' => "Δεν έχει καθοριστεί αναγνωριστικό του τομέα.",
    '__dom_name' => "Όνομα τομέα",
    '__dom_name_is_invalid' => "Το όνομα τομέα δεν είναι έγκυρο. Βεβαιωθείτε ότι το όνομα του τομέα σας περιέχει μόνο αλφαριθμητικούς χαρακτήρες, τελεία και παύλα και το μήκος του δεν υπερβαίνει τους 255 χαρακτήρες. Κάθε τμήμα του ονόματος τομέα ανάμεσα στις τελείες δεν πρέπει να υπερβαίνει τα 63 σύμβολα.",
    '__dom_not_exist' => "Ο τομέας δεν υπάρχει.",
    '__domain' => "τομέας",
    '__domain_' => 'Τομέας %1',
    '__domain_form' => "Φόρμα τομέα",
    '__domain_id' => "Αναγνωριστικό τομέα",
    '__domain_is_turned_off_for_backup' => "Η τοποθεσία web %1 έχει απενεργοποιηθεί προσωρινά για δημιουργία ή επαναφορά αντιγράφου ασφαλείας και δεν είναι διαθέσιμη αυτήν τη στιγμή.",
    '__domain_limits' => "Όρια τομέα",
    '__domain_name' => "Όνομα τομέα",
    '__mail_name_in_ASCII_form' => "Όνομα λογαριασμού αλληλογραφίας σε μορφή ASCII",
    '__message_error' => 'Σφάλμα',
    '__message_warning' => 'Προειδοποίηση',
    '__message_info' => 'Πληροφορία',
    '__domain_name_in_ASCII_form' => "Όνομα τομέα σε μορφή ASCII",
    '__domain_repository' => "Αποθετήριο τομέα %1",
    '__domain_status' => "Κατάσταση τομέα",
    '__domain_dns' => 'Ζώνη DNS τομέα',
    '__domain_total' => "Συνολική ποσότητα για τη συνδρομή",
    '__domain_total_powerUser' => "Συνολική ποσότητα για τη συνδρομή",
    '__domain_user' => "Διαχειριστής τομέα",
    '__domains_global_changes' => "Τροποποίηση επιλεγμένων τομέων",
    '__mailnames_global_changes' => "Τροποποίηση επιλεγμένων λογαριασμών αλληλογραφίας",
    '__backup_manager' => 'Διαχείριση αντιγράφων ασφαλείας',
    '__domains_list' => "Τομείς",
    'domains_list__list_header' => "τομείς", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Το όνομα τομέα αρχίζει με www, παρόλο που χρησιμοποιείται το πρόθεμα WWW.\nΘέλετε να συνεχίσετε ούτως ή άλλως;",
    '__dovecot' => 'Διακομιστής Dovecot IMAP και POP3',
    '__dsmail' => "Υπηρεσία αλληλογραφίας",
    '__dsmaillist' => "Υπηρεσία λίστας αλληλογραφίας",
    '__dsr_db' => "DB",
    '__dsr_dname' => "Όνομα τομέα",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "Όνομα πελάτη",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Συνολικό μέγεθος των αρχείων αντιγράφων ασφαλείας στον τοπικό χώρο αποθήκευσης",
    '__email' => "Διεύθυνση ηλ. ταχ.",
    '__email_addr_is_invalid' => "Η διεύθυνση ηλεκτρονικού ταχυδρομείου δεν είναι έγκυρη.",
    '__enabled' => "ενεργοποιημένο",
    '__enter_cert_text' => "Εισαγάγετε το κείμενο του πιστοποιητικού",
    '__enter_logo_url' => "Διεύθυνση URL λογοτύπου",
    '__enter_size' => "Εισαγάγετε το μέγεθος",
    '__exclusive' => "Αποκλειστικό",
    '__expiration_date' => "Ημερομηνία λήξης",
    '__fax' => "Φαξ",
    '__file' => "Αρχείο",
    '__file_is_empty' => "Το αρχείο είναι κενό.",
    '__file_name' => "Όνομα αρχείου",
    '__file_type' => 'Τύπος αρχείου',
    '__filemanager' => "Διαχείριση αρχείων",
    '__filepath_is_empty' => "Η διαδρομή προς το αρχείο είναι κενή",
    '__files_list' => "Αρχεία",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Ρυθμίσεις FTP",
    '__ftp_serv' => "Διακομιστής FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Πρέπει να ορίσετε πρώτα τις ιδιότητες του λογαριασμού FTP!",
    '__ftp_status' => "Κατάσταση διακομιστή FTP",
    '__full_day0' => "Κυριακή",
    '__full_day1' => "Δευτέρα",
    '__full_day2' => "Τρίτη",
    '__full_day3' => "Τετάρτη",
    '__full_day4' => "Πέμπτη",
    '__full_day5' => "Παρασκευή",
    '__full_day6' => "Σάββατο",
    '__full_month1' => "Ιανουάριος",
    '__full_month10' => "Οκτώβριος",
    '__full_month11' => "Νοέμβριος",
    '__full_month12' => "Δεκέμβριος",
    '__full_month2' => "Φεβρουάριος",
    '__full_month3' => "Μάρτιος",
    '__full_month4' => "Απρίλιος",
    '__full_month5' => "Μαι",
    '__full_month6' => "Ιούνιος",
    '__full_month7' => "Ιούλιος",
    '__full_month8' => "Αύγουστος",
    '__full_month9' => "Σεπτέμβριος",
    '__giga' => "G",
    '__group' => "Ομάδα",
    '__h' => "Φ",
    '__hard_disk_quota' => "Όριο σκληρού δίσκου",
    '__hard_disk_quota_not_supported' => 'το όριο σκληρού δίσκου δεν υποστηρίζεται λόγω της ρύθμισης παραμέτρων του συστήματος αρχείων του διακομιστή',
    '__header_text_is_invalid' => "Ο τίτλος της προστατευμένης περιοχής δεν είναι έγκυρος.",
    '__help_topic_not_found' => 'Η θέμα βοήθειας που ζητήσατε (%1) δεν υπάρχει.',
    '__hosting' => "Φιλοξενία",
    '__hosting_ip_dns_ip_not_equiv' => "Καμία από τις διευθύνσεις IP που καθορίζονται στις εγγραφές A DNS δεν ταιριάζει με τη διεύθυνση IP που χρησιμοποιείται για τη φιλοξενία.",
    '__hosting_scripting' => "Υποστήριξη δεσμών ενεργειών της φιλοξενίας",
    '__hosting_setup_page_title' => "Ρύθμιση φιλοξενίας περιεχομένου web για τον τομέα %1",
    '__hosting_title' => "Φιλοξενία (%1)",
    '__hosting_type' => "Τύπος φιλοξενίας",
    '__hostname' => "Όνομα κεντρικού υπολογιστή",
    '__hostname_is_empty' => "Το όνομα κεντρικού υπολογιστή είναι κενό.",
    '__hour(s)' => 'Ώρα(ες)',
    '__hst_type_incorrect' => "Ο τύπος φιλοξενίας είναι λανθασμένος.",
    '__http' => "HTTP", //indirect
    '__htype' => "Φ",
    '__idle_time' => "Χρόνος αδράνειας",
    '__iface' => "Διασύνδεση",
    '__image' => "Εικόνα",
    '__imap_status' => "Κατάσταση διακομιστή IMAP",
    '__in' => "Σε",
    '__in_%' => "σε %",
    '__incorrect_databases_login_pass' => "Τα διαπιστευτήρια που καθορίσατε για την πρόσβαση στο PostgreSQL είναι λανθασμένα.",
    '__incorrect_ip_or_network_address' => 'Λανθασμένη διεύθυνση IP ή δίκτυο.',
    '__info' => 'Πληροφορίες',
    '__install' => "Εγκατάσταση",
    '__install_prefix' => "Εγκατάσταση προθέματος",
    '__invalid_cert_id' => "Μη έγκυρο αναγνωριστικό πιστοποιητικού",
    '__invalid_context' => "Μη έγκυρο περιβάλλον: %1",
    '__invalid_db_usr_name' => "Το όνομα χρήστη της βάσης δεδομένων δεν είναι έγκυρο.",
    '__invalid_dir_name' => "Το όνομα του καταλόγου δεν είναι έγκυρο",
    '__invalid_dom_name' => "Το όνομα τομέα δεν είναι έγκυρο.",
    '__invalid_filename' => "Το όνομα αρχείου δεν είναι έγκυρο.  Μην χρησιμοποιείτε μονά εισαγωγικά ή/και συνδυασμό \"../\".",
    '__invalid_id' => "Μη έγκυρο αναγνωριστικό.",
    '__invalid_lines_num' => "Μη έγκυρη τιμή για τον αριθμό των γραμμών, επιτρέπονται μόνο ψηφία.",
    '__invalid_max_letter_size' => "Το μέγιστο μέγεθος μηνύματος δεν είναι έγκυρο.",
    '__invalid_pdir_name' => "Το όνομα του προστατευμένου καταλόγου δεν είναι έγκυρο.",
    '__invalid_restart_apache_interval' => "Το διάστημα επανεκκίνησης Apache δεν είναι έγκυρο.",
    '__invalid_tmpl_name' => "Το όνομα του προτύπου δεν είναι έγκυρο.",
    '__invalid_value' => "Λανθασμένη τιμή.",
    '__ip_addr' => "Διεύθυνση ΙP",
    '__ip_address_and_mask' => "Διεύθυνση IP και Μάσκα υποδικτύου",
    '__ip_alias__mask' => "Διεύθυνση IP και Μάσκα υποδικτύου",
    '__ip_addr_form' => "Φόρμα διεύθυνσης IP",
    '__ip_addr_is_invalid' => "Η διεύθυνση IP δεν είναι έγκυρη.",
    '__ip_addr_list' => "Διευθύνσεις IP",
    '__ip_address_does_not_exist' => "Η διεύθυνση IP δεν υπάρχει.",
    '__ip_addresses' => "Διευθύνσεις IP",
    '__ip_address_and_mask_hint' => 'Για παράδειγμα, %1',
    '__is_owner' => "Κ",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KByte",
    '__key_for_virtuozzo_only' => "Το κλειδί άδειας χρήσης σας προορίζεται για χρήση μόνο στο Virtuozzo containers.",
    '__key_limits_exceeding' => "Αυτή η ενέργεια υπερβαίνει τα όρια που καθορίζονται από την άδεια χρήσης του λογισμικού σας. Εάν λάβατε αυτό το μήνυμα, μπορείτε να επικοινωνήσετε με τον πάροχό σας ή τον κατασκευαστή για να διευκρινίσετε ή να επεκτείνετε τα όρια της συγκεκριμένης άδειας.",
    '__kilo' => "K",
    '__keywords' => 'Λέξεις κλειδιά',
    '__lang_unknown' => 'Δεν είναι δυνατή η αναγνώριση της γλώσσας.',
    '__languages' => 'Γλώσσα',
    '__learn_more' => 'Μάθετε περισσότερα',
    '__loading' => 'Φόρτωση...',
    '__locales' => "Πακέτα γλωσσών",
    '__link_url_is_invalid' => "Η διεύθυνση URL του λογοτύπου δεν είναι έγκυρη.",
    '__lists' => "Λίστες αλληλογραφίας",
    '__literal_bytes' => "Π",
    '__processing' => "Παρακαλώ περιμένετε.<br>Φόρτωση...",
    '__locale' => "Γλώσσα περιβάλλοντος εργασίας",
    '__locale_is_not_defined' => "Η γλώσσα του περιβάλλοντος εργασίας δεν έχει οριστεί.",
    '__local_server_mysql' => 'Τοπικός διακομιστής MySQL',
    '__local_server_postgresql' => 'Τοπικός διακομιστής PostgreSQL',
    '__log_files' => "Αρχεία καταγραφής",
    '__log_and_statistics_files' => 'Αρχεία καταγραφής και αναφορές στατιστικών στοιχείων',
    '__config_files' => 'Αρχεία ρύθμισης παραμέτρων',
    '__chroot_files' => 'Περιβάλλον chrooted',
    '__login' => "Σύνδεση %1",
    '__login1' => "Σύνδεση",
    '__login_disabled' => "Η σύνδεση απαγορεύεται",
    '__login_enabled' => "Η σύνδεση επιτρέπεται",
    '__login_incorrect' => "Έχετε πληκτρολογήσει λανθασμένο όνομα χρήστη ή κωδικό πρόσβασης.",
    '__login_name' => "Όνομα χρήστη %1",
    '__login_name_is_invalid' => "Το όνομα χρήστη %1 δεν είναι έγκυρο.",
    '__logon_time' => "Χρόνος σύνδεσης",
    '__ma' => "Ψευδώνυμα αλληλογραφίας",
    '__mail' => "Αλληλογραφία",
    '__mail_alias_name' => "Όνομα ψευδωνύμου αλληλογραφίας",
    '__mail_autodiscovery' => 'Αυτόματος εντοπισμός αλληλογραφίας',
    '__mail_exchanger_name_is_invalid' => "Το όνομα ανταλλαγών αλληλογραφίας (mail exchanger) δεν είναι έγκυρο.",
    '__mail_groups' => "Ομάδες αλληλογραφίας",
    '__mail_list_engine' => "Λογισμικό λίστας αλληλογραφίας",
    '__mail_name' => "Λογαριασμός αλληλογραφίας",
    '__mail_name_form' => "Ιδιότητες λογαριασμού αλληλογραφίας",
    '__mail_names' => "Λογαριασμοί αλληλογραφίας",
    '__mail_serv' => "Διακομιστής αλληλογραφίας",
    '__mail_user' => 'Χρήστης αλληλογραφίας',
    '__mailgroup' => "Ομάδα αλληλογραφίας",
    '__maillist' => "Λίστα αλληλογραφίας",
    '__maillists' => "Λίστες αλληλογραφίας",
    '__maillist_member' => 'Μέλος λίστας αλληλογραφίας',
    '__mailname' => "Λογαριασμός αλληλογραφίας",
    '__mailname_redir_self' => "Ο λογαριασμός αλληλογραφίας δεν μπορεί να προωθεί την αλληλογραφία στον εαυτό του.",
    '__max_dom_num_reached_for_cl' => "Συμπληρώθηκε το όριο αριθμού τομέων γι' αυτόν το λογαριασμό πελάτη.",
    '__max_file_size_available' => "Μέγιστο επιτρεπόμενο μέγεθος αρχείου %1",
    '__max_subdom_num_reached_for_cl' => "Συμπληρώθηκε το όριο αριθμού υποτομέων γι' αυτόν το λογαριασμό πελάτη.",
    '__max_subdom_num_reached_for_dom' => "Συμπληρώθηκε το όριο του αριθμού υποτομέων για τον τομέα.",
    '__max_subdom_num_reached_for_key' => "Συμπληρώθηκε το όριο του επιτρεπόμενου αριθμού υποτομέων σύμφωνα με το κλειδί άδειας χρήσης.",
    '__max_traffic_limit' => "Όριο κίνησης",
    '__maximum_excl_ip_num' => "Λογαριασμοί αλληλογραφίας",
    '__mb' => "MB",
    '__mbytes' => "megabyte",
    '__mb_month' => "MB/μήνα",
    '__mb_sec' => "MB/δευτ.",
    '__gb_sec' => "GB/δευτ.",
    '__tb_sec' => "TB/δευτ.",
    '__mega' => "M",
    '__minute(s)' => 'Λεπτά',
    '__mls_not_in_key' => "Το κλειδί προϊόντος σας δεν υποστηρίζει πολυγλωσσικό περιβάλλον εργασίας.",
    '__modification_date' => "Ημερομηνία τροποποίησης",
    '__module' => "Επέκταση",
    '__month' => "Μήνας",
    '__month(s)' => "Μήνας(ες)",
    '__month1' => "Ιαν",
    '__month10' => "Οκτ",
    '__month11' => "Νοε",
    '__month12' => "Δεκ",
    '__month2' => "Φεβ",
    '__month3' => "Μάρ",
    '__month4' => "Απρίλιος",
    '__month5' => "Μαι",
    '__month6' => "Ιούνιος",
    '__month7' => "Ιούλιος",
    '__month8' => "Αυγ",
    '__month9' => "Σεπτ",
    '__monthly' => "Μηνιαία",
    '__months' => "Μήνες",
    '__moved_permanently' => 'Μετακινήθηκε μόνιμα',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Διακομιστής",
    'mssql__server' => "Όνομα διακομιστή Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "το όνομα του διακομιστή δεν μπορεί να αλλάξει: υπάρχει τουλάχιστον μία βάση δεδομένων σε αυτόν.",
    '__mssql_status' => "Κατάσταση διακομιστή Microsoft SQL",
    '__multiply_login_deny' => "Δεν είναι δυνατή η σύνδεσή σας. Υπάρχει ήδη συνδεδεμένος χρήστης στο Plesk με το ίδιο όνομα χρήστη (%1).",
    '__mysql' => "MySQL",
    '__mysql_status' => "Κατάσταση διακομιστή MySQL",
    '__mysql_version' => "Έκδοση Mysql",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Κατάσταση διακομιστή MariaDB",
    '__mariadb_version' => "Έκδοση MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Κατάσταση διακομιστή Percona",
    '__percona_version' => "Έκδοση Percona",
    '__name' => "Όνομα",
    '__name_invalid' => "Το όνομα δεν είναι έγκυρο.",
    '__nameserver' => "διακομιστής ονομάτων",
    '__network' => "Δίκτυο",
    '__networks' => "Δίκτυα",
    '__no' => "όχι",
    '__no_ip_address_with_properly_type_available' => "Δεν είναι δυνατή η επαναφορά των δεδομένων από το αντίγραφο ασφαλείας επειδή δεν υπάρχουν οι κατάλληλες διευθύνσεις IP που απαιτούνται για την επαναφορά.",
    '__no_clients_specified' => "Δεν έχουν καθοριστεί λογαριασμοί πελατών.",
    '__no_comments' => "Δεν υπάρχουν σχόλια.",
    '__no_ip_specified' => "Δεν έχει καθοριστεί IP.",
    '__nologin' => "Απαγορεύεται η πρόσβαση",
    '__none' => "Καμία",
    '__not_configured' => "Δεν έχει ρυθμιστεί",
    '__not_implemented_yet' => "Δεν έχει υλοποιηθεί ακόμα",
    '__not_supported_by_ftp' => "(δεν υποστηρίζεται από το διακομιστή FTP)",
    '__not_supported_by_mailmng' => "δεν υποστηρίζεται από το διακομιστή αλληλογραφίας",
    '__notification' => "Ειδοποίηση",
    '__num_displayed' => "Εμφανίζονται %1 από %2",
    '__num_is_invalid' => "Ο αριθμός δεν είναι έγκυρος.",
    '__object_not_found' => 'Το αντικείμενο δεν βρέθηκε: %1',
    '__of_all' => "% από Όλα",
    '__off' => "Απενεργ.",
    '__ok' => "OK",
    '__old_passwd' => "Προηγούμενος κωδικός πρόσβασης %1",
    '__on' => "Ενεργ.",
    '__others' => "Άλλα",
    '__other_ip__will_be_added' => 'Άλλες διαθέσιμες διευθύνσεις IP (θα προστεθούν στο χώρο IP του πελάτη)',
    '__out' => "Εκτός",
    '__p' => "Π",
    '__passwd' => "Κωδικός πρόσβασης %1",
    '__passwd_is_invalid' => "Ο κωδικός πρόσβασης %1 δεν είναι έγκυρος.",
    '__passwd_not_match' => "Οι κωδικοί πρόσβασης δεν συμφωνούν!",
    '__path' => "Διαδρομή",
    '__perl_unix_support' => "Υποστήριξη Perl",
    '__perl_win_support' => "Υποστήριξη Perl",
    '__perm_denied' => "Το δικαίωμα απορρίφθηκε.",
    '__permissions' => "Δικαιώματα",
    '__personal_name' => "Προσωπικό όνομα",
    '__pg_admin_not_activated' => "Το PostgreSQL δεν ενεργοποιήθηκε στη σελίδα διαχείρισης του διακομιστή.",
    '__pg_not_inst' => "Το PostgreSQL δεν εγκαταστάθηκε.",
    '__pg_not_run_or_inst' => "Το PostgreSQL δεν εγκαταστάθηκε ή δεν εκτελείται.",
    '__pg_not_support_in_key' => "Το PostgreSQL δεν υποστηρίζεται από το κλειδί άδειας χρήσης.",
    '__phone' => "Τηλέφωνο",
    '__phosting' => "Φυσική φιλοξενία",
    '__php_support' => "Υποστήριξη PHP",
    '__php_run_as_isapi' => "εκτέλεση ως επέκταση ISAPI",
    '__php_safe_mode' => "PHP 'safe_mode' στο",
    '__php_version' => "Έκδοση PHP",
    '__physical' => "Φυσική φιλοξενία",
    '__plesk_stat_pdir' => "Προστασία καταλόγου '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Στατιστικά στοιχεία τομέα",
    '__plesk_stat_protect' => "Προστατεύστε την πρόσβαση στα στατιστικά στοιχεία web με το όνομα χρήστη και τον κωδικό πρόσβασης FTP του χρήστη",
    '__plesk_stat_protect_install' => "προσβάσιμο μέσω του καταλόγου με προστασία κωδικού πρόσβασης '/plesk-stat/webstat/'",
    '__plesk_stat_webstat_not_activate' => "Δεν επιλέξατε το πρόγραμμα στατιστικών στοιχείων web που θα χρησιμοποιηθεί γι' αυτήν την τοποθεσία web.",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Κατάσταση διακομιστή POP3",
    '__popen_error' => "Παρουσιάστηκε σφάλμα κατά την κλήση της λειτουργίας popen.",
    '__port' => 'Θύρα',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Κατάσταση PostgreSQL",
    '__preferences' => "Ρυθμίσεις",
    '__account_preferences' => "Ρυθμίσεις λογαριασμού",
    '__interface_preferences_general' => 'Γενικά',
    '__interface_preferences_default' => 'Προεπιλεγμένες προτιμήσεις περιβάλλοντος εργασίας',
    '__interface_preferences_admin' => "Προτιμήσεις περιβάλλοντος εργασίας διαχειριστή",
    '__interface_template' => 'Πρότυπο προσαρμογής περιβάλλοντος εργασίας',
    '__interface_preferences' => "Προτιμήσεις περιβάλλοντος εργασίας",
    '__proceed?' => "Θέλετε να προχωρήσετε;",
    '__protect_dir_user' => "Χρήστης προστατευμένου καταλόγου",
    '__protect_dir_users' => "Χρήστες προστατευμένου καταλόγου",
    '__protect_dirs' => "Προστατευμένοι κατάλογοι",
    '__provider_contact_name' => "Όνομα επαφής κατόχου",
    '__python_unix_support' => "Υποστήριξη Python",
    '__python_win_support' => "Υποστήριξη Python",
    '__quota' => "Όριο",
    '__r' => "Α",
    '__reconfigure' => "Επαναρρύθμιση",
    '__record_type' => "Τύπος εγγραφής",
    '__release' => "Έκδοση",
    '__remote_db_not_supported_by_key' => 'Η φιλοξενία απομακρυσμένης βάσης δεδομένων δεν υποστηρίζεται από το κλειδί άδειας χρήσης σας.',
    '__remove' => "Κατάργηση",
    '__remove_confirmation' => "Επιβεβαίωση κατάργησης",
    '__remove_protection' => 'Κατάργηση προστασίας',
    '__report' => "Αναφορά",
    '__report_auto' => 'Χρονοδιάγραμμα παράδοσης',
    '__report_form' => "Έντυπο αναφοράς",
    '__report_size_na' => "Η υπηρεσία δεν είναι διαθέσιμη",
    '__reports_list' => "Αναφορές",
    '__requested' => "Ζητήθηκε",
    '__required_fields' => "Απαιτούμενα πεδία",
    '__resp_name_invalid' => "Το όνομα της αυτόματης απάντησης δεν είναι έγκυρο. Χρησιμοποιήστε μόνο αλφαριθμητικούς χαρακτήρες, τελείες, χαρακτήρα υπογράμμισης και κενά διαστήματα.",
    '__c' => "A", // Access to panel
    '__s' => "Κ",
    '__server_name_is_invalid' => "Το όνομα του διακομιστή δεν είναι έγκυρο.",
    '__screenshots' => 'Στιγμιότυπα οθόνης',
    '__script_warning' => "Με την κατάργηση της δυνατότητας δεσμών ενεργειών από αυτόν τον τομέα, όλες οι δέσμες ενεργειών που επηρεάζονται θα εμφανίζονται σε μορφή απλού κειμένου όταν καλούνται από ένα πρόγραμμα περιήγησης.  Συνιστάται στο διαχειριστή να καταργήσει όλες τις εξαρτώμενες δέσμες ενεργειών από το συγκεκριμένο τομέα.",
    '__sec' => "Δευτερόλεπτα",
    '__second(s)' => "Δευτερόλεπτο(α)",
    '__see_list_of_logged_in' => "Δείτε τη λίστα με τους χρήστες που είναι συνδεδεμένοι αυτήν τη στιγμή.",
    '__select_certs_to_remove' => "Επιλέξτε τα πιστοποιητικά που θα καταργηθούν.",
    '__select_domains_to_default_host' => "Επιλέξτε έναν τομέα για να οριστεί ως προεπιλεγμένος.",
    '__select_domains_to_remove' => "Επιλέξτε τους τομείς που θα καταργηθούν.",
    '__type_domain_name_to_add' => "Πληκτρολογήστε το όνομα τομέα που θα προστεθεί.",
    '__select_files_to_remove' => "Επιλέξτε τα αρχεία που θα καταργηθούν.",
    '__select_ip' => "Εκχώρηση διεύθυνσης IP",
    '__select_ip_to_remove' => "Επιλέξτε τη διεύθυνση IP που θα καταργηθεί.",
    '__select_domain_template' => "Ρυθμίσεις χρήσης προτύπου τομέα",
    '__select_templates_to_remove' => "Επιλέξτε τα πρότυπα που θα καταργηθούν.",
    '__server' => "Διακομιστής",
    '__server_total' => "Σύνολο διακομιστή",
    '__service' => "Υπηρεσία",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Διακομιστής βάσεων δεδομένων MySQL",
    '__service_description__mysql' => "Διακομιστής βάσεων δεδομένων MySQL",
    '__service_title__web' => "Διακομιστής web",
    '__service_description__web' => "Διακομιστής web",
    '__service_title__smtp' => "Διακομιστής SMTP",
    '__service_description__smtp' => "Διακομιστής SMTP",
    '__service_title__mail' => "Διακομιστής IMAP/POP3",
    '__service_description__mail' => "Διακομιστής IMAP/POP3",
    '__service_title__dns' => "Διακομιστής DNS",
    '__service_description__dns' => "Διακομιστής DNS",
    '__service_title__postgresq' => "Διακομιστής βάσεων δεδομένων PostgreSQL",
    '__service_description__postgresq' => "Διακομιστής βάσεων δεδομένων PostgreSQL",
    '__service_title__spamassassin' => "Υπηρεσία φιλτραρίσματος ανεπιθύμητης αλληλογραφίας SpamAssassin",
    '__service_description__spamassassin' => "Υπηρεσία φιλτραρίσματος ανεπιθύμητης αλληλογραφίας SpamAssassin",
    '__services' => "Υπηρεσίες",
    '__all_services' => "Όλες οι υπηρεσίες",
    '__sessions' => "Περίοδοι λειτουργίας",
    'sessions__feature_ftp_session_manager_not_supported' => "Η δυνατότητα περιόδων λειτουργίας FTP δεν υποστηρίζεται από τον τρέχοντα διακομιστή FTP",
    '__sessions_list' => "Περίοδοι λειτουργίας",
    '__set' => "Ενεργοποίηση",
    '__setup_logo_pref' => "Λογότυπο",
    '__shared' => "Κοινόχρηστο",
    '__shell_access_warning' => "Επιτρέποντας την πρόσβαση κελύφους στο σύστημα θέτετε σε εξαιρετικό κίνδυνο την ασφάλεια του συστήματος. Επιτρέψτε την πρόσβαση στο σύστημα μόνο εάν είστε απόλυτα βέβαιοι γι' αυτό που κάνετε και μόνο σε αξιόπιστους χρήστες. Είστε βέβαιοι ότι θέλετε να επιτρέψετε την πρόσβαση;",
    '__siteapp_not_support_in_key' => "Οι εφαρμογές web δεν υποστηρίζονται από το κλειδί άδειας χρήσης",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Η ρύθμιση παραμέτρων αυτής της εφαρμογής web άλλαξε χειροκίνητα. Για να εξασφαλιστεί η προστασία των χειροκίνητων τροποποιήσεων, η επαναρρύθμιση μέσω του Plesk απενεργοποιήθηκε.',
    '__site_management' => "Δημοσίευση στο web", // indirect
    '__size' => "Μέγεθος",
    '__skeleton' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    '__skins' => 'Εμφανίσεις',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Κατάσταση διακομιστή SMTP",
    '__some_fields_are_empty_or_invalid' => "Ορισμένα πεδία είναι κενά ή περιέχουν μη έγκυρη τιμή.",
    '__spamassassin' => "Φίλτρο ανεπιθύμητης αλληλογραφίας",
    '__spamassassin_status' => "Κατάσταση SpamAssassin",
    '__spamd_status' => 'Κατάσταση φίλτρου ανεπιθύμητης αλληλογραφίας',
    '__splited_backup' => "(αντίγραφο ασφαλείας πολλαπλών τόμων)",
    '__split_backup_file' => "Δημιουργία αντιγράφου ασφαλείας πολλαπλών τόμων",
    '__split_backup_size' => "Μέγεθος τόμου",
    '__split_backup_less_than_500' => "Δεν υποστηρίζονται τόμοι με μέγεθος μικρότερο των 500 megabyte",
    '__ssi' => "SSI",
    '__ssi_support' => "Υποστήριξη SSI",
    '__ssi_with_html' => "Χρησιμοποιήστε το SSI για αρχεία *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Υποστήριξη SSL/TLS",
    '__same_ssl' => "Χρήση ενιαίου καταλόγου για την αποθήκευση SSL/TLS και μη-SSL/TLS περιεχομένου",
    '__same_ssl_cu' => "Κοινό SSL/TLS και μη SSL/TLS περιεχόμενο",
    '__state' => "Νομός/Επαρχία",

    '__status__Active' => 'Ενεργό',
    '__status__active' => 'ενεργό',
    '__status__Passive' => 'Απενεργοποιήθηκε',
    '__status__passive' => 'απενεργοποιήθηκε',
    '__status__off' => 'απενεργοποιήθηκε',
    '__status__with_parent' => 'απενεργοποιήθηκε',
    '__status__backup_restore' => 'έχει ανασταλεί προσωρινά για δημιουργία ή επαναφορά αντιγράφου ασφαλείας',
    '__status__admin' => 'έχει ανασταλεί από το διαχειριστή του διακομιστή',
    '__status__resseler' => 'έχει ανασταλεί από το μεταπωλητή',
    '__status__client' => 'έχει ανασταλεί από τον πελάτη',
    '__status__unknown' => 'η κατάσταση είναι άγνωστη',

    '__status_of' => "Κατάσταση %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Διακομιστής Stunnel", // indirect
    '__subdomain' => "Υποτομέας",
    '__subdomain_name' => "Όνομα υποτομέα",
    '__subdomain_name_in_ASCII_form' => "Όνομα υποτομέα σε μορφή ASCII",
    '__subdomains' => "Υποτομείς",
    '__domainaliases' => "Ψευδώνυμα τομέα",
    '__subdomains_list' => "Υποτομείς",
    '__subdomains_not_support_in_key' => "Οι λειτουργίες υποτομέα δεν υποστηρίζονται από το κλειδί άδειας χρήσης",
    '__sys_user_type' => "Χρήστης FTP",
    '__sys_user_type_main' => "Χρήση του λογαριασμού χρήστη FTP από τον κύριο τομέα",
    '__sys_user_type_native' => "Δημιουργία ξεχωριστού λογαριασμού χρήστη FTP γι' αυτόν τον υποτομέα",
    '__t' => "Τ",
    '__target_domain' => "Τομέας προορισμού",
    '__template' => "Πρότυπο",
    '__template_not_accepted' => "Δεν είναι δυνατή η αποδοχή του προτύπου: σημειώνεται υπέρβαση των παρακάτω ορίων.",
    '__templates' => "Πρότυπα",
    '__templates_list' => "Πρότυπα",
    '__tera' => "Τ",
    '__title' => "Τίτλος",
    '__tools' => "Εργαλεία",
    '__total' => "Σύνολο %1",
    '__total_size' => "Συνολικό μέγεθος",
    '__total_used' => "Σύνολο σε χρήση",
    '__traffic' => "Κυκλοφορία",
    '__traffic_by_client' => "Κίνηση από τον πελάτη",
    '__traffic_by_domain' => "Κίνηση από τον τομέα",
    '__traffic_by_service' => "Κίνηση από την υπηρεσία",
    '__traffic_history' => "Ιστορικό κίνησης",
    '__unable_change_locale' => "Δεν είναι δυνατή η αλλαγή της γλώσσας του περιβάλλοντος εργασίας: %1",
    '__unable_create_new_dom' => "Δεν είναι δυνατή η δημιουργία νέου τομέα: %1",
    '__unable_define_dom_name' => "Δεν είναι δυνατός ο καθορισμός του ονόματος τομέα: %1",
    '__unable_define_necessary_properties' => "Δεν είναι δυνατός ο καθορισμός όλων των απαιτούμενων ιδιοτήτων.",
    '__unable_define_properties' => "Δεν είναι δυνατός ο καθορισμός των ιδιοτήτων: %1",
    '__unable_exec_util' => "Δεν είναι δυνατή η εκτέλεση του βοηθητικού προγράμματος: %1",
    '__unable_get_dns_a_recs' => "Δεν είναι δυνατή η ανάκτηση διευθύνσεων IP για τις εγγραφές Α DNS αυτού του λογαριασμού φιλοξενίας: %1",
    '__unable_get_mbox_quota' => "Δεν είναι δυνατή η ανάκτηση των πληροφοριών σχετικά με το όριο μεγέθους του γραμματοκιβωτίου.",
    '__unable_redirect_to_myself' => "Δεν είναι δυνατή η προώθηση στον ίδιο λογαριασμό.",
    '__unable_redirect_to_my_alias' => "Δεν είναι δυνατή η προώθηση αλληλογραφίας σε ψευδώνυμο αλληλογραφίας.",
    '__default_domain_redirect_to_myself' => "Δεν είναι δυνατός ο ορισμός του τομέα ως προεπιλεγμένου για τη διεύθυνση IP:\n ανιχνεύθηκε ανακατεύθυνση στον εαυτό του.",
    '__unable_remove_client' => "Δεν είναι δυνατή η κατάργηση του πελάτη: %1",
    '__unable_set_up_mbox_quota' => "Δεν είναι δυνατός ο καθορισμός του ορίου μεγέθους γραμματοκιβωτίου για τον τομέα: %1",
    '__unable_setup_pass' => "Δεν είναι δυνατός ο ορισμός του κωδικού πρόσβασης: %1",
    '__unable_to_create_new_account' => "Δεν είναι δυνατή η δημιουργία λογαριασμού: %1",
    '__unable_to_define_db_size' => "Δεν είναι δυνατός ο καθορισμός του μεγέθους της βάσης δεδομένων.",
    '__unable_to_enable_short_names' => "Δεν είναι δυνατόν να επιτραπεί η χρήση σύντομων ονομάτων λογαριασμών αλληλογραφίας για λογαριασμούς POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Δεν είναι δυνατή η λήψη των δεδομένων που υποβλήθηκαν: %1",
    '__unable_to_open_file' => "Δεν είναι δυνατό το άνοιγμα του αρχείου %1: %2",
    '__unable_to_update_subdomain' => "Δεν είναι δυνατή η πραγματοποίηση αλλαγών στον υποτομέα σας: %1",
    '__unable_update_cl_data' => "Δεν είναι δυνατή η αποθήκευση των αλλαγών στο λογαριασμό χρήστη: %1",
    '__unable_update_db_params' => "Δεν είναι δυνατή η ενημέρωση των παραμέτρων της βάσης δεδομένων: %1",
    '__unable_update_dom_data' => "Δεν είναι δυνατή η ενημέρωση των δεδομένων του τομέα: %1",
    '__undefined' => "δεν έχει καθοριστεί",
    '__uninstall' => "Κατάργηση εγκατάστασης",
    '__unknown_error' => "Άγνωστο σφάλμα",
    '__unlimited_lower' => "Απεριόριστο",
    '__unset' => "Απενεργοποίηση",
    '__update' => "Ενημέρωση",
    '__uploaded_file_is_invalid' => "Το απεσταλμένο αρχείο δεν είναι έγκυρο: %1",
    '__url' => "Διεύθυνση URL",
    '__usage' => "Χρήση δίσκου",
    '__user' => 'Χρήστης',
    '__user_already_logged' => "Υπάρχει ήδη συνδεδεμένος χρήστης στο Plesk με το ίδιο όνομα χρήστη (%1).",
    '__version' => "Έκδοση",
    '__aps_license' => "Κλειδί άδειας χρήσης",
    '__vh_type' => "Τύπος εικονικού κεντρικού υπολογιστή",
    '__vhosts_apache_status' => "Κατάσταση διακομιστή web",
    '__wrong_charset_conversion' => 'Λανθασμένο σύνολο χαρακτήρων, η μετατροπή από "%1" σε "%2" δεν επιτρέπεται',
    '__warning_' => "Προειδοποίηση!",
    '__warning_excl_ip_num' => "Αποκλειστική διεύθυνση IP",
    '__warning_expiration' => "Ημερομηνία λήξης",
    '__web_scripting' => "Δέσμες ενεργειών στο web", // indirect
    '__web_serv' => "Διακομιστής web", // indirect
    '__web_statistic' => "Στατιστικά στοιχεία web", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Το Webalizer δεν έχει εγκατασταθεί στο διακομιστή. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για βοήθεια σχετικά με την εγκατάσταση του Webalizer.",
    '__webstat_support' => "Στατιστικά στοιχεία web",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Όταν μεταβαίνετε από το ένα πρόγραμμα στατιστικής ανάλυσης στο άλλο, όλες οι αναφορές που έχουν δημιουργηθεί στο προηγούμενο πρόγραμμα διαγράφονται και οι νέες αναφορές δημιουργούνται σύμφωνα με τις πληροφορίες των αρχείων καταγραφής που διατηρούνται στο διακομιστή.  Αυτό σημαίνει ότι αν έχετε ρυθμίσει το σύστημα (στη διαδρομή Τομείς > όνομα τομέα > Διαχείριση αρχείων καταγραφής > Ανακύκλωση αρχείων καταγραφής) έτσι ώστε να διατηρεί τα αρχεία καταγραφής μόνο για τον τελευταίο μήνα, τότε τα στατιστικά στοιχεία web θα είναι διαθέσιμα μόνο για τον τελευταίο μήνα.  Θέλετε να μεταβείτε σε άλλο πακέτο στατιστικής ανάλυσης;",
    '__webstat_perm_denied' => 'Δεν έχετε δικαίωμα να διαχειριστείτε τα στατιστικά στοιχεία web.',
    '__webuser' => "Χρήστης web",
    '__sysusers_list' => "Χρήστες συστήματος",
    '__sysuser' => "Χρήστης συστήματος",
    '__weekly' => "Κάθε εβδομάδα",
    '__whats_new_in_version' => "Τι νέο υπάρχει στο Plesk %1;",
    '__wrong_hosting_type__none' => 'Δεν έχει ρυθμιστεί φιλοξενία περιεχομένου web στον τομέα %1.',
    '__wrong_hosting_type__std_fwd' => 'Έχει ρυθμιστεί τυπική ανακατεύθυνση στον τομέα %1. Η λειτουργία αυτή είναι διαθέσιμη μόνο για τομείς με φιλοξενία περιεχομένου web.',
    '__wrong_hosting_type__frm_fwd' => 'Έχει ρυθμιστεί κρυμμένη ανακατεύθυνση στον τομέα %1.  Η λειτουργία αυτή είναι διαθέσιμη μόνο για τομείς με φιλοξενία περιεχομένου web.',
    '__wu' => "Χρήστες web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Το πρόθεμα WWW άλλαξε. Θα πρέπει να τροποποιήσετε αναλόγως και το πιστοποιητικό SSL/TLS.",
    '__year' => "Έτος",
    '__year(s)' => "Έτος(η)",
    '__yes' => "Ναι",
    '__you' => "Εσείς",
    '__zip_code' => "Ταχυδρομικός κώδικας",
    '__form_normal' => "Κανονική",
    '__form_advanced' => "Για προχωρημένους",

    'admin_ed__edit_administrator_info' => "Επεξεργασία προφίλ διαχειριστή",
    'admin_ed__create_default_client' => "Θα ήθελα να δημιουργήσω έναν προεπιλεγμένο λογαριασμό πελάτη.",
    'admin_ed__unable_update' => "Δεν είναι δυνατή η ενημέρωση των πληροφοριών διαχειριστή: %1",

    'auth__update_admin_info' => "Εισαγάγετε τις πληροφορίες διαχειριστή.  Αυτές οι πληροφορίες είναι απαραίτητες για τη λειτουργία του %1.",
    'auth__you_not_have_perm' => "Δεν έχετε δικαιώματα διαχείρισης αυτού του τομέα.",
    'auth__key_expired_admin' => 'Το κλειδί άδειας χρήσης σας στο Plesk έχει λήξει. Για να συνεχίσετε να χρησιμοποιείτε το Plesk, ανανεώστε την άδεια χρήσης σας ή αγοράστε μια νέα.',
    'auth__key_expired_admin_restricted' => 'Το κλειδί άδειας χρήσης σας στο Plesk έχει λήξει. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για να συνεχίσετε να χρησιμοποιείτε το Plesk.',
    'auth__key_expired_client' => 'Η άδεια χρήσης του Plesk έχει λήξει. Επικοινωνήστε με το πάροχο υπηρεσιών φιλοξενίας σας.',
    'autoinstaller__not_installed' => 'Το στοιχείο αυτόματης εγκατάστασης δεν έχει εγκατασταθεί.',
    'autoinstaller__release_action' => 'Διαθέσιμες λειτουργίες',
    'autoinstaller__release_action_icon' => 'Κ',
    'autoinstaller__release_action_upgrade' => 'Αναβάθμιση στη νέα έκδοση του Plesk',
    'autoinstaller__release_action_update' => 'Ενημέρωση ή προσθήκη νέων στοιχείων',
    'autoinstaller__release_action_up2date' => 'Η έκδοσή σας είναι η πιο πρόσφατη',
    'autoinstaller__component_action' => 'Κατάσταση',
    'autoinstaller__component_action_icon' => 'Κ',
    'autoinstaller__component_action_install' => 'Δεν έχει εγκατασταθεί',
    'autoinstaller__component_action_update' => 'Υπάρχουν διαθέσιμες ενημερώσεις',
    'autoinstaller__component_action_upgrade' => 'Υπάρχουν διαθέσιμη ενημέρωση',
    'autoinstaller__component_action_up2date' => 'Η έκδοσή σας είναι η πιο πρόσφατη',
    'autoinstaller__component_action_error' => 'Δεν υπάρχουν διαθέσιμες ενημερώσεις',
    'autoinstaller__component_serverbuildtime' => 'Τελευταία έκδοση',
    'autoinstaller__component_localbuildtime' => 'Η έκδοσή σας',
    'autoinstaller__component_installed_version' => 'Η έκδοσή σας',
    'autoinstaller__component_available_version' => 'Τελευταία έκδοση',
    'autoinstaller__component' => 'Στοιχείο',
    'autoinstaller__components' => 'Στοιχεία',
    'autoinstaller__components_title' => 'Στοιχεία %1',
    'autoinstaller__component_dependency_note' => 'απαιτούνται για την εγκατάσταση των στοιχείων που επιλέξατε',
    'autoinstaller__install_confirm' => 'Ναι, θέλω να εγκαταστήσω αυτά τα στοιχεία',
    'autoinstaller__install_confirm_request' => 'Επιλέξτε το πλαίσιο ελέγχου για να επιβεβαιώσετε',
    'autoinstaller__install_title' => 'Επιβεβαιώστε την εγκατάσταση των επιλεγμένων στοιχείων',
    'autoinstaller__key_update_confirm' => 'Επιβεβαιώστε την παράκαμψη της ενημέρωσης του κλειδιού και την εγκατάσταση του προεπιλεγμένου κλειδιού',
    'autoinstaller__key_update_confirm_request' => 'Επιλέξτε το πλαίσιο ελέγχου για να επιβεβαιώσετε.',
    'autoinstaller__key_update_failed' => '<p> Το Plesk δεν έχει τη δυνατότητα να ανανεώσει την άδεια χρήσης του προϊόντος σας.</p> <p> %1</p> <p>Η συνέχιση της αναβάθμισης χωρίς την κατάλληλη άδεια χρήσης του προϊόντος, θα έχει ως αποτέλεσμα την εγκατάσταση μιας προεπιλεγμένης άδειας χρήσης με περιορισμένη λειτουργικότητα. Συνιστάται στους διαχειριστές να προμηθευτούν πρώτα το κατάλληλο κλειδί άδειας χρήσης πριν προχωρήσουν στην αναβάθμιση του προϊόντος.</p>',
    'autoinstaller__email' => 'Αποστολή ειδοποίησης στο',
    'autoinstaller__email_admin' => "Διεύθυνση ηλεκτρονικού ταχυδρομείου διαχειριστή",
    'autoinstaller__email_email' => 'Προσαρμοσμένη διεύθυνση ηλεκτρονικού ταχυδρομείου...',
    'autoinstaller__release' => 'Όνομα έκδοσης',
    'autoinstaller__releases' => 'Διαθέσιμες εκδόσεις',
    'autoinstaller__releases_title' => 'Πρόγραμμα ενημέρωσης Plesk',
    'autoinstaller__select_components_to_install' => 'Επιλέξτε τα στοιχεία που θα εγκατασταθούν',
    'autoinstaller__status_error' => 'Σφάλμα: %1',
    'autoinstaller__status_install_error' => 'Δεν είναι δυνατή η εκκίνηση της εγκατάστασης: %1',
    'autoinstaller__status_install_busy' => 'Δεν είναι δυνατή η εκκίνηση της εγκατάστασης: μια άλλη διαδικασία εγκατάστασης βρίσκεται σε εξέλιξη αυτήν τη στιγμή.',
    'autoinstaller__status_install_ok' => 'Η εγκατάσταση ξεκίνησε.  Θα ειδοποιηθείτε για την πρόοδο της εγκατάστασης μέσω ηλεκτρονικού ταχυδρομείου (%1).',
    'autoinstaller__status_query_busy' => 'Η εγκατάσταση βρίσκεται σε εξέλιξη.',
    'autoinstaller__status_query_error' => 'Δεν είναι δυνατή η ανάκτηση της κατάστασης της εγκατάστασης: %1',
    'autoinstaller__status_unknown' => 'Δεν είναι δυνατή η ανάκτηση της κατάστασης του προγράμματος αυτόματης εγκατάστασης.',
    'autoinstaller__status_busy' => 'Το πρόγραμμα αυτόματης εγκατάστασης είναι απασχολημένο, παρακαλώ περιμένετε.',
    'autoinstaller__configure_title' => 'Ρυθμίσεις προγράμματος ενημέρωσης',
    'autoinstaller__preferences_legend' => 'Ρυθμίσεις',
    'autoinstaller__target' => 'Προσωρινός κατάλογος λήψης',
    'autoinstaller__target_invalid' => "Καθορίστε απόλυτη διαδρομή",
    'autoinstaller__check_updates' => 'Να πραγματοποιείται έλεγχος για ενημερώσεις κατά τη σύνδεση του διαχειριστή στο Plesk',
    'autoinstaller__check_updates_warning' => 'Υπάρχουν διαθέσιμες νέες <a href="%1">ενημερώσεις</a> για το %2',
    'autoinstaller__source_type' => 'Τύπος προέλευσης',
    'autoinstaller__source' => 'Διεύθυνση URL προέλευσης',
    'autoinstaller_source__preferences_legend' => 'Ρυθμίσεις',
    'autoinstaller_source__type' => 'Τύπος προέλευσης',
    'autoinstaller_source__url_invalid' => 'Μη έγκυρη προέλευση',
    'autoinstaller_source__url_invalid_network' => 'Μη έγκυρη διεύθυνση URL προέλευσης (Παράδειγμα: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Διεύθυνση URL προέλευσης',
    'autoinstaller__source_invalid_network' => 'Η διεύθυνση δικτύου που καθορίσατε δεν είναι έγκυρη',
    'backup__repository' => 'Θέση χώρου αποθήκευσης αρχείων αντιγράφων ασφαλείας',
    'backup__error_notify_email' => 'Εάν παρουσιαστούν σφάλματα κατά τη δημιουργία αντιγράφου ασφαλείας, να αποστέλλεται ειδοποίηση στη διεύθυνση ηλεκτρονικού ταχυδρομείου',
    'backup__dump_info' => "Πληροφορίες δημιουργίας αντιγράφων ασφαλείας",
    'backup__dump_file_name_not_defined' => "Το όνομα του αρχείου αντιγράφου ασφαλείας δεν έχει οριστεί",
    'backup__local_file' => 'Τοπικό αρχείο αντιγράφου ασφαλείας',
    'backup__domain_ftp' => 'απομακρυσμένος διακομιστής FTP',
    'backup__wrong_path' => "Λανθασμένη διαδρομή προς τον χώρο αποθήκευσης αρχείων αντιγράφων ασφαλείας: Μην χρησιμοποιείτε την αλληλουχία χαρακτήρων ../../",
    'backup__unable_to_connect_to_ftp_server' => "Δεν είναι δυνατή η σύνδεση στο διακομιστή FTP: %1",
    'backup__unable_to_read_file' => 'Δεν είναι δυνατή η ανάγνωση του αρχείου αντιγράφου ασφαλείας.',
    'backup__backup_task_does_not_exist' => "Η εργασία δημιουργίας αντιγράφου ασφαλείας δεν υπάρχει, θα πρέπει να τη δημιουργήσετε πριν ενεργοποιηθεί.",
    'backup__restore_params' => "Παράμετροι επαναφοράς",
    'backup__confirmation' => "Προειδοποίηση: ο τομέας δεν θα είναι διαθέσιμος κατά τη διάρκεια της δημιουργίας/επαναφοράς αντιγράφων ασφαλείας.",
    'backup__backup_method' => 'Μέθοδος δημιουργίας αντιγράφων ασφαλείας',
    'backup__dumpfile_name' => "Όνομα αρχείου αντιγράφου ασφαλείας",
    'backup__dumpfile_name_is_invalid' => "Το όνομα του αρχείου αντιγράφου ασφαλείας δεν είναι έγκυρο: χρησιμοποιήστε μόνο αλφαριθμητικούς χαρακτήρες, παύλα, τελεία και το χαρακτήρα υπογράμμισης, αποφεύγοντας τη χρήση ονομάτων όπως περιγραφή.*  ως όνομα του αρχείου αντιγράφου ασφαλείας.",
    'backup__email_required' => "Η διεύθυνση ηλεκτρονικού ταχυδρομείου είναι απαραίτητη για να είστε πάντα ενημερωμένοι σχετικά με την πρόοδο των διαδικασιών δημιουργίας και επαναφοράς αντιγράφων ασφαλείας. Συμπληρώστε τη διεύθυνση ηλεκτρονικού ταχυδρομείου σας στις λεπτομέρειες του λογαριασμού.",
    'backup__error_during_backup' => "Δεν είναι δυνατή η δημιουργία του αρχείου αντιγράφου ασφαλείας: %1",
    'backup__input_email_warning' => "Πρέπει είτε να ορίσετε μια διεύθυνση ηλεκτρονικού ταχυδρομείου για τις ειδοποιήσεις είτε να καταργήσετε την επιλογή του πλαισίου ελέγχου.",
    'backup__make_download' => "να μην αποθηκεύεται το αρχείο αντιγράφου ασφαλείας στον χώρο αποθήκευσης, να πραγματοποιείται μόνο λήψη",
    'backup__make_dump' => 'δημιουργία αρχείου αντιγράφου ασφαλείας και αποθήκευσή του στον τοπικό χώρο αποθήκευσης',
    'backup__makedump_to_ftp' => 'δημιουργία αρχείου αντιγράφου ασφαλείας και αποθήκευσή του σε απομακρυσμένο διακομιστή FTP',
    'backup__restore_ip' => "Διεύθυνση IP για επαναφορά",
    'backup__select_dumpfile' => "Επιλέξτε ένα αρχείο αντιγράφου ασφαλείας.",
    'backup__time' => "Ώρα δημιουργίας αντιγράφων ασφαλείας",
    'backup__day' => 'Ημέρα δημιουργίας αντιγράφων ασφαλείας',
    'backup__view_dump_info' => "Προβολή των πληροφοριών αντιγράφου ασφαλείας για τον τομέα %1",
    'backup__wrong_domain_name' => "Το αρχείο αντιγράφου ασφαλείας περιέχει τα δεδομένα του τομέα %1 και ως εκ τούτου δεν μπορεί να πραγματοποιηθεί επαναφορά του στον τομέα %2",
    'backup__incorrect_ftp_user_or_passwd' => "Λανθασμένος χρήστης ή κωδικός πρόσβασης FTP. Διορθώστε τις ιδιότητες του λογαριασμού FTP",
    'backup__access_denied' => "Δεν επιτρέπεται η πρόσβαση.  Διορθώστε τις ιδιότητες του λογαριασμού FTP",
    'backup__restore_from' => "Επαναφορά %1",
    'backup__domain_session_failed' => 'Δεν δημιουργήθηκε αντίγραφο ασφαλείας του τομέα %1',
    'backup__client_session_failed' => 'Δεν δημιουργήθηκε αντίγραφο ασφαλείας του λογαριασμού πελάτη %1',
    'backup__domain_session_restore_failed' => 'Δεν εκτελέστηκε επαναφορά του τομέα %1',
    'backup__client_session_restore_failed' => 'Δεν εκτελέστηκε επαναφορά του λογαριασμού πελάτη %1',
    'backup__domain_session_complete' => 'Δημιουργήθηκε αντίγραφο ασφαλείας του τομέα %1',
    'backup__domain_session_backup' => 'Δημιουργία αντιγράφου ασφαλείας του τομέα %1',
    'backup__client_session_backup' => 'Αντίγραφο ασφαλείας του πελάτη %1',
    'backup__domain_stop_title' => 'Ακύρωση δημιουργίας αντιγράφου ασφαλείας του τομέα %1',
    'backup__client_stop_title' => 'Ακύρωση της δημιουργίας αντιγράφου ασφαλείας του λογαριασμού πελάτη %1',
    'backup__domain_restore_stop_title' => 'Ακύρωση επαναφοράς του τομέα %1',
    'backup__client_restore_stop_title' => 'Ακύρωση επαναφοράς του λογαριασμού πελάτη %1',
    'backup__domain_session_backup_stop' => 'Πρόκειται να ακυρώσετε την ενεργή διαδικασία δημιουργίας αντιγράφου ασφαλείας.  Δεν θα δημιουργηθεί αρχείο αντιγράφου ασφαλείας.',
    'backup__backup_stop_confirm' => 'Ναι, θέλω να σταματήσω τη διαδικασία δημιουργίας αντιγράφου ασφαλείας',
    'backup__restore_stop_confirm' => 'Ναι, θέλω να σταματήσω τη διαδικασία επαναφοράς',
    'backup__domain_session_restore' => 'Επαναφορά του τομέα %1',
    'backup__domain_session_restore_stop' => 'Πρόκειται να ακυρώσετε την ενεργή διαδικασία επαναφοράς.',
    'backup__domain_backup_file_info' => 'Πληροφορίες αρχείου αντιγράφου ασφαλείας τομέα',
    'backup__domain_backup_file_list' => 'υπάρχοντα αρχεία αντιγράφων ασφαλείας',
    'backup__domain_backup_progress' => 'Πρόοδος δημιουργίας αντιγράφου ασφαλείας της τοποθεσίας web %1',
    'backup__domain_restore_progress' => 'Πρόοδος επαναφοράς της τοποθεσίας web %1',
    'backup__domain_backup_progress_elapsed_time' => 'Χρόνος που παρήλθε: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Χρόνος που παρήλθε: %1',
    'backup__ip_map_legend' => 'Αντιστοίχιση IP',
    'backup__ip_map_list_count' => 'Διευθύνσεις IP',
    'backup__domain_restore_session_complete' => 'Εκτελείται επαναφορά του τομέα %1.',
    'backup__domain_restore_session_complete_message' => 'Εκτελέστηκε επαναφορά του τομέα %1.',
    'backup__domain_backup_file_delete' => 'Τα παρακάτω αρχεία αντιγράφων ασφαλείας θα καταργηθούν:',
    'backup__domain_backup_file_for_remove' => 'Επιλέξτε τα αρχεία αντιγράφων ασφαλείας που θέλετε να καταργήσετε',
    'backup__backup_overwrite_file_confirm' => 'Επιβεβαίωση αντικατάστασης',
    'backup__backup_overwrite_file_confirm_text' => 'Το αρχείο αντιγράφου ασφαλείας με το όνομα "%1" υπάρχει ήδη.  Θέλετε να το αντικαταστήσετε;',
    'backup__backup_confirm_overwrite' => 'Επιβεβαίωση αντικατάστασης αρχείου',
    'backup__backup_overwrite_legeng' => 'Αντικατάσταση',
    'backup__backup_not_contain_domain' => 'Το αρχείο αντιγράφου ασφαλείας δεν περιέχει πληροφορίες σχετικά με τον τομέα %1',
    'backup__backup_not_contain_client' => 'Το αρχείο αντιγράφου ασφαλείας δεν περιέχει πληροφορίες σχετικά με το λογαριασμό του πελάτη %1',
    'backup__backup_client_info' => "Δημιουργία αντιγράφου ασφαλείας των ρυθμίσεων και των στοιχείων λογαριασμού του πελάτη",
    'backup__client_backup_progress' => 'Πρόοδος δημιουργίας αντιγράφου ασφαλείας του λογαριασμού πελάτη %1',
    'backup__client_session_complete' => 'Δημιουργήθηκε αντίγραφο ασφαλείας του λογαριασμού πελάτη %1',
    'backup__client_backup_file_info' => 'Πληροφορίες αρχείου αντιγράφου ασφαλείας πελάτη',
    'backup__restore_client_info' => "Επαναφορά των ρυθμίσεων και των στοιχείων λογαριασμού του πελάτη",
    'backup__client_session_restore' => 'Εκτελείται επαναφορά του λογαριασμού πελάτη %1',
    'backup__client_db_server_map' => 'Αντιστοίχιση διακομιστών βάσεων δεδομένων',
    'backup__domain_db_server_map' => 'Αντιστοίχιση διακομιστών βάσεων δεδομένων',
    'backup__client_restore_session_complete_message' => 'Η επαναφορά του λογαριασμού πελάτη %1 ολοκληρώθηκε.',
    'backup__client_restore_session_complete' => 'Η επαναφορά του λογαριασμού πελάτη %1 ολοκληρώθηκε.',
    'backup__restore_select_some' => 'Επιλέξτε τα αντικείμενα που θέλετε να επαναφέρετε.',
    'backup__client_restore_progress' => 'Πρόοδος επαναφοράς για το λογαριασμό πελάτη %1',
    'backup__new_backup' => 'Δημιουργία νέου αντιγράφου ασφαλείας',
    'backup__done' => 'Ολοκληρώθηκε:',
    'backup__done_domains' => '%1 τομέας(είς) από %2',
    'backup__done_clients' => '%1 πελάτης(ες) από %2',
    'backup__remaining' => 'Απομένουν:',
    'backup__remaining_domains' => '%1 τομέας(είς)',
    'backup__remaining_clients' => '%1 πελάτης(ες)',
    'backup__overall_backup_progress' => 'Συνολική πρόοδος δημιουργίας αντιγράφου ασφαλείας',
    'backup__comment_n_a' => 'μ/δ',
    'backup__command_ignore' => 'Η εντολή "%1" θα αγνοηθεί',
    'backup__no_objects' => 'δεν υπάρχουν αντικείμενα για δημιουργία αντιγράφου ασφαλείας',
    'backup__cli_warning_not_enough_ip' => 'ΠΡΟΕΙΔΟΠΟΙΗΣΗ: δεν υπάρχουν αρκετές διευθύνσεις IP για την εκτέλεση της αντιστοίχισης IP:',
    'backup__local_repository' => "Χώρος αποθήκευσης του Plesk",
    'backup__ftp_repository' => 'Χώρος αποθήκευσης FTP',
    'backup__ftp_login' => 'Όνομα χρήστη',
    'backup__ftp_password' => 'Κωδικός πρόσβασης',
    'backup__ftp_directory_hint' => 'Παράδειγμα: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'Ρυθμίσεις λογαριασμού FTP',
    'backup__ftp_account_preferences' => 'Ρυθμίσεις λογαριασμού FTP',
    'backup__repository_not_exist' => 'Ο κατάλογος δεν υπάρχει',
    'backup__repository_not_readable' => 'Δεν είναι δυνατή η ανάγνωση του καθορισμένου καταλόγου',
    'backup__ftp_repository_not_configure' => 'Για να χρησιμοποιήσετε έναν χώρο αποθήκευσης αντιγράφων ασφαλείας FTP, <a href="%1">καθορίστε πρώτα τον λογαριασμό FTP</a> .',
    'backup__ftp_repository_list_not_configure' => 'Δεν καθορίστηκαν οι ρυθμίσεις του λογαριασμού',
    'backup__repository_list_unable_listing' => 'Δεν είναι δυνατή η ανάκτηση της λίστας αρχείων',
    'backup__ftp_repository_unable_listing' => 'Δεν είναι δυνατή η ανάκτηση της λίστας του καταλόγου "%1":',
    'backup__repository_legend' => 'Αποθήκευσης αρχείων αντιγράφων ασφαλείας',
    'backup__store_in_repository' => 'Αποθήκευση αρχείων σε',
    'backup__local_repository_lable' => 'Τοπικός χώρος αποθήκευσης',
    'backup__ftp_repository_lable' => 'Χώρος αποθήκευσης FTP',
    'backup__ftp_repository_not_configure_hint' => '(δεν έχουν καθοριστεί οι ρυθμίσεις του λογαριασμού)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(ο λογαριασμός FTP δεν έχει καθοριστεί ή δεν υποστηρίζεται)',
    'backup__ftp_directory_not_exist' => 'Ο καθορισμένος κατάλογος δεν υπάρχει',
    'backup__other_user_process_modified' => 'Η διαδικασία δημιουργίας αντιγράφου ασφαλείας ή μετεγκατάστασης έχει διακοπεί από έναν άλλο χρήστη.',
    'backup__another_user_exist' => 'Η λειτουργία που βρίσκεται σε εξέλιξη εκκινήθηκε από άλλο χρήστη του Plesk. Ο χρήστης αυτός εξακολουθεί να είναι συνδεδεμένος στο Plesk.',
    'backup__ftp_repository_wait' => 'Παρακαλώ περιμένετε όσο πραγματοποιείται ανάκτηση πληροφοριών σχετικά με τον χώρο αποθήκευσης FTP',
    'backup__ftp_write_test_failed' => 'Αποτυχία εγγραφής δοκιμαστικών δεδομένων στο λογαριασμό FTP %1:',
    'bt_upload_to_repository' => 'Αποστολή αρχείων στον τοπικό χώρο αποθήκευσης',
    'bt_new_restore' => "Επαναφορά",
    'bt_backup_schedule' => "Προγραμματισμός δημιουργίας αντιγράφου ασφαλείας",
    'backup_exist_backups' => "Υπάρχοντα αρχεία αντιγράφων ασφαλείασ",
    'backup_dialog__page_title' => "Δημιουργία αρχείου αντιγράφου ασφαλείας",
    'backup_dialog__please_wait' => "Η διαδικασία δημιουργίας αντιγράφου ασφαλείας είναι έτοιμη να ξεκινήσει. Η διαδικασία αυτή θα διαρκέσει κάποιο διάστημα.  Παρακαλώ περιμένετε...",
    'backup_conf__page_title' => 'Ρύθμιση παραμέτρων αντιγράφων ασφαλείας',
    'bt_accept' => "Αποδοχή",
    'bt_access' => "Πρόσβαση",
    'bt_action_log' => "Αρχείο καταγραφής ενεργειών",
    'bt_add' => "Προσθήκη",
    'bt_add_client' => "Εκχώρηση σε χρήστες",
    'bt_database_server_add' => 'Προσθήκη διακομιστή βάσεων δεδομένων',
    'bt_add_services' => "Προσθήκη υπηρεσιών",
    'bt_anonftp_stats' => "Στατιστικά ανώνυμου FTP",
    'bt_anonymous_ftp' => "Ανώνυμο FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Επισύναψη",
    'bt_autoinstaller' => 'Πρόγραμμα ενημέρωσης',
    'bt_auto-updates' => 'Πρόγραμμα ενημέρωσης',
    'bt_back' => "<< Προηγούμενο",
    'bt_backup' => "Αντίγραφο ασφαλείας",
    'bt_backup_configure' => "Ρυθμίσεις αντιγράφων ασφαλείας",
    'bt_buy_certs' => "Αγορά πιστοποιητικών",
    'bt_blocked_domains' => 'Μαύρη λίστα',
    'bt_blocked_domain_add' => 'Προσθήκη τομέα',
    'bt_card' => "Κάρτα",
    'bt_cert' => "Πιστοποιητικό",
    'bt_certificates' => "Πιστοποιητικά",
    'bt_change_passwd' => "Αλλαγή κωδικού πρόσβασης",
    'bt_clean_log' => "Εκκαθάριση αρχείου καταγραφής",
    'bt_clear' => "Απαλοιφή",
    'bt_client_templates' => "Πρότυπα πελατών",
    'bt_clients' => "Πελάτες",
    'bt_codepage_change' => 'Αλλαγή κωδικοποίησης',
    'bt_comp_info' => "Διαχείριση στοιχείων",
    'bt_configure_maillists' => "Ρύθμιση Mailman",
    'bt_configure_odbc' => "Αρχεία προέλευσης δεδομένων ODBC",
    'bt_configure' => 'Ρύθμιση παραμέτρων',
    'bt_copy' => "Αντιγραφή",
    'bt_copy_move' => "Αντιγραφή/Μετακίνηση",
    'bt_create' => "Δημιουργία",
    'bt_create_account' => "Δημιουργία λογαριασμού",
    'bt_create_dir' => "Προσθήκη καταλόγου",
    'bt_create_file' => "Προσθήκη αρχείου",
    'bt_count_size' => "Υπολογισμός μεγέθους",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Χρονοδιάγραμμα εργασιών",
    'bt_custom_button_new' => "Προσθήκη κουμπιού",
    'bt_custom_buttons' => "Προσαρμοσμένα κουμπιά",
    'bt_customize' => "Προσαρμογή",
    'bt_databases' => "Βάσεις δεδομένων",
    'bt_database_servers' => 'Διακομιστές βάσεων δεδομένων',
    'bt_sqlservers' => "Διακομιστές βάσεων δεδομένων",
    'bt_db_usr_new' => "Προσθήκη χρήστη βάσης δεδομένων",
    'bt_db_new' => "Προσθήκη βάσης δεδομένων",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Ορισμός ως προεπιλογή για το DB Webadmin",
    'bt_decline' => "Απόρριψη",
    'bt_default' => "Προεπιλογή",
    'bt_defaultcomponents' => "Υπηρεσίες τρίτων",
    'bt_defaults' => "Προεπιλογές",
    'bt_delete' => "Διαγραφή",
    'bt_directories' => "Προστατευμένοι κατάλογοι",
    'bt_disable' => "Απενεργοποίηση",
    'bt_dns' => "Ρυθμίσεις DNS",
    'bt_dns_enable' => 'Ενεργοποίηση',
    'bt_dns_disable' => 'Απενεργοποίηση',
    'bt_dns_default' => 'Επαναφορά προεπιλεγμένων',
    'bt_dns_zone_sync' => 'Εφαρμογή αλλαγών προτύπου DNS',
    'bt_dnsrecord_add' => 'Προσθήκη εγγραφής',
    'bt_do_backup' => "Αντίγραφο ασφαλείας",
    'bt_do_restore' => "Επαναφορά",
    'bt_do_upload' => "Αποστολή",
    'bt_domain_aliases' => "Ψευδώνυμα τομέα",
    'bt_domain_templates' => "Πρότυπα τομέα",
    'bt_domain_user' => "Διαχειριστής τομέα",
    'bt_domain_user_passwd' => "Κωδικός πρόσβασης διαχειριστή τομέα",
    'bt_domains' => "Τομείς",
    'bt_domain_alias_add' => 'Προσθήκη ψευδωνύμου τομέα',
    'bt_download' => "Λήψη",
    'bt_download_log' => "Λήψη",
    'bt_edit' => "Επεξεργασία",
    'bt_enable' => "Ενεργοποίηση",
    'bt_export' => 'Εξαγωγή',
    'bt_extras' => "Πρόσθετα",
    'bt_file_manager' => "Διαχείριση αρχείων",
    'bt_finish' => "Ολοκλήρωση",
    'bt_ftp_account' => "Ιδιότητες λογαριασμού FTP",
    'bt_forget_password' => "Ξεχάσατε τον κωδικό πρόσβασής σας;",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Στατιστικά FTP",
    'bt_get_password' => "Λήψη κωδικού πρόσβασης",
    'bt_global_changes' => "Τροποποίηση",
    'bt_help' => "Βοήθεια",
    'bt_hide_aliases' => "Απόκρυψη ψευδωνύμων",
    'bt_hide_toolbar' => 'Απόκρυψη γραμμής εργαλείων',
    'bt_hide_subdomains' => "Απόκρυψη υποτομέων",
    'bt_hide_domainaliases' => "Απόκρυψη ψευδωνύμων τομέα",
    'bt_home' => "Αρχική",
    'bt_hosting' => "Φιλοξενία",
    'bt_icf' => 'Τείχος προστασίας',
    'bt_install' => "Εγκατάσταση",
    'bt_ip_aliasing' => "Διευθύνσεις IP",
    'bt_ip_add' => "Προσθήκη διεύθυνσης IP",
    'bt_ip_pool' => "Χώρος IP",
    'bt_key_info' => "Διαχείριση αδειών χρήσης",
    'bt_key_buyonline_addons' => 'Παραγγελία πρόσθετων του Plesk',
    'bt_key_buyonline_upgrades' => 'Παραγγελία αναβαθμίσεων του Plesk',
    'bt_key_buyonline_new' => 'Παραγγελία νέου κλειδιού',
    'bt_key_update' => 'Ανάκτηση κλειδιών',
    'bt_key_upload' => 'Εγκατάσταση κλειδιού',
    'bt_key_download' => 'Λήψη κλειδιού',
    'bt_key_revert' => 'Επαναφορά κλειδιού',
    'bt_limits' => "Όρια",
    'bt_locale_add' => 'Προσθήκη τοπικών ρυθμίσεων',
    'bt_locales' => 'Τοπικές ρυθμίσεις',
    'bt_log_manager' => "Διαχείριση αρχείων καταγραφής",
    'bt_login' => "Σύνδεση",
    'bt_login_vzpp' => "Σύνδεση στο Power Panel",
    'bt_logo' => "Εμπορική ταυτότητα",
    'bt_logo_default' => "Προεπιλεγμένο λογότυπο",
    'bt_logo_send_link' => "Προσάρτηση σύνδεσης",
    'bt_logo_send_logo' => "Προσάρτηση λογοτύπου",
    'bt_logout' => "Αποσύνδεση",
    'bt_logrotation' => "Ανακύκλωση αρχείων καταγραφής",
    'bt_mail' => "Αλληλογραφία",
    'bt_mail_alias_add' => "Προσθήκη ψευδωνύμου αλληλογραφίας",
    'bt_mail_aliases' => "Ψευδώνυμα αλληλογραφίας",
    'bt_mail_group_add' => "Προσθήκη μέλους",
    'bt_mail_groups' => "Ομάδες",
    'bt_mail_name_add' => "Προσθήκη λογαριασμού αλληλογραφίας",
    'bt_mail_preferences' => "Ρυθμίσεις",
    'bt_mail_group' => "Ομάδα αλληλογραφίας",
    'bt_mail_mailbox' => "Γραμματοκιβώτιο",
    'bt_mail_redirect' => "Διακομιστής προώθησης",
    'bt_mail_resp_add' => "Προσθήκη αυτόματης απάντησης",
    'bt_mail_resp_attach_add' => "Προσθήκη συνημμένου",
    'bt_mail_resp_files' => "Συνημμένα αρχεία",
    'bt_mail_responders' => "Αυτόματες απαντήσεις",
    'bt_mail_spamfilter' => "Φίλτρο ανεπιθύμητης αλληλογραφίας",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Προσθήκη λίστας αλληλογραφίας",
    'bt_maillists' => "Λίστες αλληλογραφίας",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Δημιουργία αντιγράφου ασφαλείας",
    'bt_manage' => "Διαχείριση",
    'bt_master' => "Master",
    'bt_migrate' => 'Μετεγκατάσταση',
    'bt_modules_add' => 'Προσθήκη επέκτασης',
    'bt_modules_manage' => 'Διαχείριση επεκτάσεων',
    'bt_move' => "Μετακίνηση",
    'bt_mimetypes' => 'Τύποι MIME',
    'bt_mimetype_new' => 'Προσθήκη τύπου MIME',
    'bt_new_client' => "Προσθήκη λογαριασμού πελάτη",
    'bt_new_domain' => "Προσθήκη τομέα",
    'bt_next' => "Επόμενο >>",
    'bt_next_page' => "Επόμενο",
    'bt_network_add' => "Προσθήκη δικτύου",
    'bt_notifications' => "Ειδοποιήσεις",
    'bt_odbc_dsn_add' => "Προσθήκη ODBC DSN",
    'bt_off' => "Απενεργ.",
    'bt_on' => "Ενεργ.",
    'bt_on_off' => "Ενεργ./Απενεργ.",
    'bt_pd_new' => "Προσθήκη προστατευμένου καταλόγου",
    'bt_pd_user_new' => "Προσθήκη χρήστη",
    'bt_performance' => 'Απόδοση',
    'bt_permissions' => "Δικαιώματα",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Ρυθμίσεις",
    'bt_prev_page' => "Προηγ.",
    'bt_preview' => 'Προεπισκόπηση τοποθεσίας',
    'bt_print' => "Εκτύπωση",
    'bt_reboot' => "Επανεκκίνηση",
    'bt_reload' => "Επανάληψη φόρτωσης",
    'bt_refresh' => "Ανανέωση",
    'bt_register' => "Καταχώρηση",
    'bt_remove' => "Κατάργηση",
    'bt_enable_selected' => 'Ενεργοποίηση',
    'bt_disable_selected' => 'Απενεργοποίηση',
    'bt_repair_ip' => "Επιδιόρθωση IP",
    'bt_report' => "Αναφορά",
    'bt_report_auto' => 'Παράδοση αναφοράς',
    'bt_report_auto_new' => 'Προσθήκη χρονοδιαγράμματος παράδοσης',
    'bt_report_new' => "Προσθήκη διάταξης",
    'bt_reset' => "Μηδενισμός",
    'bt_restart_services' => "Διαχείριση υπηρεσιών",
    'bt_save' => "Αποθήκευση",
    'bt_send_by_email' => "Αποστολή μέσω ηλεκτρονικού ταχυδρομείου",
    'bt_send_file' => "Αποστολή αρχείου",
    'bt_send_mail' => "Αποστολή αλληλογραφίας",
    'bt_send_passwd' => "Αποστολή κωδικού πρόσβασης",
    'bt_send_text' => "Αποστολή κειμένου",
    'bt_server' => "Διακομιστής",
    'bt_server_add' => "Προσθήκη διακομιστή",
    'bt_server_preferences' => "Ρυθμίσεις διακομιστή",
    'bt_servers_list' => "Διακομιστές",
    'bt_sessions' => "Περίοδοι λειτουργίας",
    'bt_set' => "Ορισμός",
    'bt_set_as_default' => "Ορισμός ως προεπιλογή",
    'bt_setup' => 'Ρύθμιση',
    'bt_show_aliases' => "Εμφάνιση ψευδωνύμων",
    'bt_show_subdomains' => "Εμφάνιση υποτομέων",
    'bt_show_domainaliases' => "Εμφάνιση ψευδωνύμων τομέα",
    'bt_shutdown' => "Τερματισμός",
    'bt_site_apppkgs' => "Application Vault",
    'bt_site_apppool' => "Χώρος συγκέντρωσης εφαρμογών",
    'bt_application-pool' => "Εφαρμογές web",
    'bt_site_apps' => "Εφαρμογές web",
    'bt_site_app_add' => "Εγκατάσταση εφαρμογής",
    'bt_additional_key_upload' => 'Αποστολή νέου κλειδιού',
    'bt_additional_key_download' => 'Λήψη κλειδιού',
    'bt_additional_key_remove' => 'Κατάργηση κλειδιού',
    'bt_additional_key_activate' => 'Ενεργοποίηση',
    'bt_site_builder' => "Υποστήριξη Presence Builder",
    'bt_skeleton' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'bt_skins' => 'Εμφανίσεις',
    'bt_skin_add' => 'Προσθήκη εμφάνισης',
    'bt_skin_manual' => 'Αναφορά προσαρμοσμένων εμφανίσεων του Plesk', // not used
    'bt_skin_download' => 'Λήψη εμφάνισης',
    'bt_skin_replace' => 'Ενημέρωση εμφάνισης',
    'bt_skip' => 'Παράκαμψη',
    'bt_spamassassin' => "Φίλτρο ανεπιθύμητης αλληλογραφίας",
    'bt_spamassassin_train' => "Εκπαίδευση",
    'bt_spamfilter' => "Φίλτρο ανεπιθύμητης αλληλογραφίας",
    'bt_sshterm' => 'Τερματικό SSH',
    'bt_start' => "Έναρξη",
    'bt_stop' => "Διακοπή",
    'bt_recycle' => "Ανακύκλωση",
    'bt_statistics' => "Στατιστικά στοιχεία",
    'bt_subdomain_new' => "Προσθήκη υποτομέα",
    'bt_subdomains' => "Υποτομείς",
    'bt_submit' => "Υποβολή",
    'bt_summary_report' => "Συνοπτική αναφορά",
    'bt_support' => "Υποστήριξη",
    'bt_switch' => "Εναλλαγή",
    'bt_system_time' => "Ώρα συστήματος",
    'bt_task_new' => "Προσθήκη εργασίας",
    'bt_dom_tmpl_add' => 'Προσθήκη προτύπου τομέα',
    'bt_cl_tmpl_add' => 'Προσθήκη προτύπου πελάτη',
    'bt_cron_backup' => 'Ρυθμίσεις προγραμματισμένης δημιουργίας αντιγράφου ασφαλείας',
    'bt_test' => "Δοκιμή σύνδεσης",
    'bt_text' => "Κείμενο",
    'bt_touch' => "Αλλαγή χρονικής σήμανσης",
    'bt_traffic' => "Κυκλοφορία",
    'bt_traffic_history' => "Ιστορικό κίνησης",
    'bt_tsclient' => "Απομακρυσμένη επιφάνεια εργασίας",
    'bt_update' => "Ενημέρωση",
    'bt_upload' => "Αποστολή",
    'bt_upload_from_ftp' => "Αποστολή FTP",
    'bt_virtualdirs' => 'Εικονικοί κατάλογοι',
    'bt_virtualdir_new' => 'Προσθήκη εικονικού καταλόγου',
    'bt_virtualdir_add' => 'Προσθήκη εικονικού καταλόγου',
    'bt_web_app_new' => "Εγκατάσταση εφαρμογής Java",
    'bt_web_stats' => "Στατιστικά web",
    'bt_web_stats_ssl' => "Στατιστικά web SSL/TLS",
    'bt_web_user_add' => "Προσθήκη χρήστη web",
    'bt_web_users' => "Χρήστες web",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_webalizer_preferences' => "Ρυθμίσεις στατιστικών στοιχείων web",
    'bt_hidden-referrer-add' => 'Απόκρυψη καταχωρήσεων',
    'bt_group-referrer-add' => 'Αναφορές (referrers) ομάδας',
    'bt_whats_new_full' => "Δείτε την πλήρη λίστα των αλλαγών",
    'bt_white_list' => "Λίστα επιτρεπόμενων",
    'bt_white_list_add' => "Προσθήκη δικτύου",
    'cert_add__unable_set_ca_cert' => "Δεν είναι δυνατός ο ορισμός του πιστοποιητικού CA: %1",
    'cert_add__unable_set_cert' => "Δεν είναι δυνατός ο ορισμός του πιστοποιητικού: %1",
    'cert_add__unable_set_private_key' => "Δεν είναι δυνατός ο ορισμός του ιδιωτικού κλειδιού: %1",
    'certificates_list__certificate_used_as_default' => "Ένα από τα πιστοποιητικά που πρόκειται να διαγράψετε, χρησιμοποιείται ως προεπιλεγμένο πιστοποιητικό.",
    'certificates_list__certificates_assigned_on_ip' => "ένα ή περισσότερα πιστοποιητικά έχουν εκχωρηθεί στις διευθύνσεις IP/τομείς.",
    'ch_pass__admin_pass' => "Αλλαγή κωδικού πρόσβασης διαχειριστή",
    'ch_pass__old_pass' => "Προηγούμενος κωδικός πρόσβασης",
    'ch_pass__pass_confirm' => "Επιβεβαίωση",
    'ch_pass__unable_change_admin_pass' => "Δεν είναι δυνατή η αλλαγή του κωδικού πρόσβασης διαχειριστή: %1",
    'check_mail_cycle__aliases' => "Ανιχνεύθηκε ανακύκλωση λογαριασμών αλληλογραφίας, η διεύθυνση \"%1\" περιέχεται στα ψευδώνυμα αυτού του λογαριασμού αλληλογραφίας.",
    'check_mail_cycle__autoresponders' => "Ανιχνεύθηκε ανακύκλωση λογαριασμών αλληλογραφίας, η διεύθυνση \"%1\" περιέχεται στις αυτόματες απαντήσεις αυτού του λογαριασμού αλληλογραφίας.",
    'check_mail_cycle__mail_groups' => "Ανιχνεύθηκε ανακύκλωση λογαριασμών αλληλογραφίας, η διεύθυνση \"%1\" περιέχεται στην ομάδα αλληλογραφίας αυτού του λογαριασμού αλληλογραφίας.",
    'check_mail_cycle__mail_name' => "Ανιχνεύθηκε ανακύκλωση λογαριασμών αλληλογραφίας, η διεύθυνση \"%1\" συμπίπτει με αυτόν το λογαριασμό αλληλογραφίας.",
    'check_mail_cycle__redirect' => "Ανιχνεύθηκε ανακύκλωση λογαριασμών αλληλογραφίας, η διεύθυνση \"%1\" συμπίπτει με το διακομιστή προώθησης αυτού του λογαριασμού αλληλογραφίας.",
    'check_mail_dup__redirect' => "Ανιχνεύθηκε διπλότυπη προώθηση, η διεύθυνση \"%1\" συμπίπτει με τη διεύθυνση προώθησης αυτού του λογαριασμού αλληλογραφίας.",
    'check_mail_dup__mail_groups' => "Ανιχνεύθηκε διπλότυπη προώθηση, η διεύθυνση \"%1\" περιέχεται στην ομάδα αλληλογραφίας αυτού του λογαριασμού αλληλογραφίας.",
    'check_maillist_cycle__admin' => "Ανιχνεύθηκε ανακύκλωση λογαριασμών αλληλογραφίας, η ηλεκτρονική διεύθυνση \"%1\" του διαχειριστή συμπίπτει με τη διεύθυνση μιας λίστας αλληλογραφίας.",
    'check_maillist_cycle__member' => "Ανιχνεύθηκε ανακύκλωση λογαριασμών αλληλογραφίας, η διεύθυνση \"%1\" συμπίπτει με τη διεύθυνση μιας λίστας αλληλογραφίας.",
    'chk_js__enter_login_and_passwd' => "Εισαγάγετε όνομα χρήστη και κωδικό πρόσβασης.",
    'chk_js__enter_login_name' => "Εισαγάγετε το όνομα χρήστη.",
    'chk_js__enter_passwd' => "Εισαγάγετε τον κωδικό πρόσβασης.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Λεπτομέρειες λογαριασμού %1",
    'cl_limits__cl' => "Όρια πελάτη %1",
    'cl_logo__setup_logo_pref' => "Ορισμός ιδιοτήτων λογοτύπου για τον πελάτη %1",
    'cl_new__enter_new_cl_data' => "Εισαγάγετε τις πληροφορίες του νέου πελάτη",
    'cl_new__unable_to_sent_notification' => 'Ο λογαριασμός χρήστη δημιουργήθηκε, αλλά η αποστολή ειδοποίησης στον πελάτη απέτυχε: %1',
    'cl_perm__all_ip' => "Όλες οι διαθέσιμες IP",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Όλοι οι λογαριασμοί φιλοξενίας βάσει IP για τον πελάτη θα μετατραπούν σε \"Βάσει ονόματος\".",
    'cl_perm__allow_client_create_domain' => "Τα πεδία που προσπαθείτε να επιλέξετε ισχύουν μόνο για πελάτες που έχουν τη δυνατότητα να δημιουργήσουν τομείς.",
    'cl_perm__allow_create_nb_w_ip' => "Ο πελάτης μπορεί να δημιουργήσει φιλοξενία βάσει ονόματος χρησιμοποιώντας το %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Να επιτρέπεται η δημιουργία λογαριασμών φιλοξενίας βάσει IP",
    'cl_perm__available_ips' => "Διαθέσιμες IP",
    'cl_perm__change_limits' => "Προσαρμογή ορίων",
    'cl_perm__cl_disk_space' => "Συνολικός διαθέσιμος χώρος στο δίσκο",
    'cl_perm__cl_expiration' => "Περίοδος ισχύος λογαριασμού πελάτη",
    'cl_perm__cl_max_box' => "Γραμματοκιβώτια",
    'cl_perm__cl_max_db' => "Βάσεις δεδομένων",
    'cl_perm__cl_max_dom' => "Τομείς",
    'cl_perm__cl_max_maillists' => "Λίστες αλληλογραφίας",
    'cl_perm__cl_max_subdom' => "Υποτομείς",
    'cl_perm__cl_max_traffic' => "Συνολική ποσότητα διαθέσιμης κίνησης",
    'cl_perm__cl_max_wu' => "Χρήστες web",
    'cl_perm__cl_mbox_quota' => "Το όριο μεγέθους γραμματοκιβωτίου γι' αυτόν το λογαριασμό χρήστη",
    'cl_perm__current_maximum_exp_date' => "Η τρέχουσα μέγιστη τιμή της περιόδου ισχύος του τομέα είναι %1, ενώ απαιτείται %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Το τρέχον καθορισμένο όριο για την ποσότητα χώρου στο δίσκο που εκχωρείται για τη φιλοξενία γραμματοκιβωτίων του συγκεκριμένου λογαριασμού χρήστη είναι %1, ενώ η απαιτούμενη ποσότητα είναι %2",
    'cl_perm__current_total_requested' => "Η τρέχουσα συνολική τιμή των ορίων τομέα για το %1 είναι %2, ενώ απαιτείται %3.",
    'cl_perm__current_total_requested_dom' => "Ο τρέχων αριθμός %1 που ανήκουν σε αυτόν τον πελάτη είναι %2, ενώ απαιτούνται %3.",
    'cl_perm__disk_space' => "μέγιστη ποσότητα χώρου στο δίσκο",
    'cl_perm__dashboard_stdgui' => 'Περιβάλλον εργασίας χρήστη',
    'cl_perm__dashboard' => 'Προβολή Αρχικής σελίδας',
    'cl_perm__stdgui' => 'Τυπική προβολή',
    'cl_perm__manage_dashboard' => 'Διαχείριση Αρχικής σελίδας',
    'cl_perm__dashboard_and_stdgui' => 'Η προβολή Αρχικής σελίδας και η τυπική προβολή επιτρέπονται',
    'cl_perm__dashboard_only' => 'Επιτρέπεται μόνο η προβολή Αρχικής σελίδας',
    'cl_perm__stdgui_only' => 'Επιτρέπεται μόνο η τυπική προβολή',
    'cl_perm__edit_cl' => "Δικαιώματα πελάτη %1",
    'cl_perm__exp_date_exceeded' => "Η περίοδος ισχύος που προσπαθείτε να ορίσετε υπερβαίνει το όριο που καθορίζεται στους επιμέρους τομείς που σχετίζονται με αυτόν τον πελάτη.",
    'cl_perm__invalid_value' => "Μη έγκυρη τιμή, μόνο ψηφία επιτρέπονται.",
    'cl_perm__limit_disk_space' => "%1 Περιορισμός της συνολικής ποσότητας χώρου στο δίσκο",
    'cl_perm__limit_expiration' => "%1 Περιορισμός της περιόδου ισχύος του λογαριασμού του πελάτη",
    'cl_perm__limit_max_box' => "%1 Περιορισμός του μέγιστου αριθμού γραμματοκιβωτίων",
    'cl_perm__limit_max_db' => "%1 Περιορισμός του μέγιστου αριθμού βάσεων δεδομένων",
    'cl_perm__limit_max_dom' => "%1 Περιορισμός του μέγιστου αριθμού τομέων",
    'cl_perm__limit_max_maillists' => "%1 Περιορισμός του μέγιστου αριθμού λιστών αλληλογραφίας",
    'cl_perm__limit_max_subdom' => "%1 Περιορισμός του μέγιστου αριθμού υποτομέων",
    'cl_perm__limit_max_traffic' => "%1 Περιορισμός της συνολικής ποσότητας κίνησης",
    'cl_perm__limit_max_wu' => "%1 Περιορισμός του μέγιστου αριθμού χρηστών web",
    'cl_perm__limit_mbox_quota' => "%1 Ρύθμιση ορίου γραμματοκιβωτίου",
    'cl_perm__limits_exceeded' => "Ένα ή περισσότερα όρια που προσπαθείτε να ορίσετε έχουν ήδη ξεπεραστεί από τα όρια που καθορίζονται στους επιμέρους τομείς που ανήκουν σε αυτόν τον πελάτη.\n Το συνολικό όριο για τον πελάτη πρέπει να είναι μεγαλύτερο ή ίσο με το άθροισμα των ορίων τομέων που έχουν καθοριστεί για το συγκεκριμένο λογαριασμό πελάτη.",
    'cl_perm__mailbox_quota_exceeded' => "Το όριο της ποσότητας χώρου στο δίσκο για τα γραμματοκιβώτια που προσπαθείτε να ορίσετε, υπερβαίνει το όριο που καθορίζεται στους επιμέρους τομείς που σχετίζονται με αυτόν τον πελάτη.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Το όριο της ποσότητας χώρου στο δίσκο για τα γραμματοκιβώτια που προσπαθείτε να ορίσετε, υπερβαίνει τον περιορισμό που έχει καθοριστεί σε επίπεδο διακομιστή.",
    'cl_perm__make_dumps' => "Δημιουργία και επαναφορά αντιγράφων ασφαλείας δεδομένων",

    'cl_perm__max_box' => "μέγιστος αριθμός γραμματοκιβωτίων",
    'cl_perm__max_db' => "μέγιστος αριθμός βάσεων δεδομένων",
    'cl_perm__max_dom' => "τομείς",
    'cl_perm__max_maillists' => "μέγιστος αριθμός λιστών αλληλογραφίας",
    'cl_perm__max_subdom' => "υποτομείς",
    'cl_perm__max_traffic' => "μέγιστη ποσότητα κίνησης",
    'cl_perm__max_wu' => "μέγιστος αριθμός χρηστών web",
    'cl_perm__max_dom_aliases' => "ψευδώνυμα τομέα",
    'cl_perm__mbox_quota' => "όριο γραμματοκιβωτίου",
    'cl_perm__not_allow_create_nb_hst' => "Ο πελάτης δεν μπορεί να δημιουργήσει φιλοξενία βάσει ονόματος.",
    'cl_perm__select_ip_addrs' => "Επιλογή διευθύνσεων IP",
    'cl_perm__this_ip_used_vrt_hst' => "Αυτή η διεύθυνση IP χρησιμοποιείται από την εικονική φιλοξενία.\n Για να διαγράψετε αυτήν τη διεύθυνση IP, καταργήστε την υπηρεσία φιλοξενίας ή αλλάξτε τον τύπο της σε \"Βάσει ονόματος\".",
    'cl_perm__unable_off_ipb_creating' => "Έχει ρυθμιστεί ήδη υπηρεσία φιλοξενίας βάσει IP για τον πελάτη.  Για να απενεργοποιήσετε αυτήν τη λειτουργία για τον πελάτη, αποεπιλέξτε το πλαίσιο ελέγχου \"Domain creation\" ή καταργήστε όλους τους λογαριασμούς φιλοξενίας βάσει IP.",
    'cl_perm__unable_off_nb_creating' => "Έχει ρυθμιστεί ήδη υπηρεσία φιλοξενίας βάσει ονόματος για τον πελάτη.  Για να απενεργοποιήσετε αυτήν τη λειτουργία για τον πελάτη, αποεπιλέξτε το πλαίσιο ελέγχου \"Domain creation\" ή καταργήστε όλους τους λογαριασμούς φιλοξενίας βάσει ονόματος.",
    'cl_perm__unable_set_domain_limit' => "Δεν είναι δυνατός ο περιορισμός του μέγιστου αριθμού τομέων: ο πελάτης διαθέτει ήδη %1 τομείς",
    'cl_perm__unable_update_client_limitations' => "Δεν είναι δυνατή η τροποποίηση των ορίων του λογαριασμού του πελάτη: %1",
    'cl_pref__edit_cl' => "Προτιμήσεις πελάτη %1",
    'class_anonftp__create_ftp_domain' => "Δεν υπάρχει εικονικός τομέας FTP γι' αυτό το dom_id, προσπαθήστε να τον δημιουργήσετε πρώτα.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Το όριο χώρου στο δίσκο που προσπαθείτε να ορίσετε (%1) δεν πρέπει να υπερβαίνει το συνολικό όριο χώρου στο δίσκο που έχει καθοριστεί σε επίπεδο τομέα (%2).",
    'class_anonftp__invalid_input_only_digits' => "Καθορίστηκε μη έγκυρη τιμή, μόνο ψηφία επιτρέπονται.",
    'class_anonftp__unable_change_ownerships' => "Δεν είναι δυνατή η αλλαγή της κυριότητας ή των δικαιωμάτων για το αρχείο ορίου: %1",
    'class_anonftp__unable_copy_quota_file' => "Δεν είναι δυνατή η αντιγραφή του αρχείου ορίου: %1",
    'class_anonftp__unable_get_disk_usage' => "Δεν είναι δυνατή η ανάκτηση πληροφοριών χρήσης του δίσκου στον εισερχόμενο κατάλογο: %1",
    'class_anonftp__unable_parse_quota_file' => "Δεν είναι δυνατή η ανάλυση του αρχείου ορίου.",
    'class_anonftp__unable_read_quota_file' => "Δεν είναι δυνατή η ανάγνωση του αρχείου ορίου: %1",
    'class_anonftp__unable_update_quota' => "Δεν είναι δυνατή η ενημέρωση του ορίου: τα αρχεία στον εισερχόμενο κατάλογο χρησιμοποιούν %1 KB χώρου στο δίσκο, το οποίο υπερβαίνει τη νέα τιμή του ορίου.",
    'class_anonftp__unable_write_temp_file' => "Δεν είναι δυνατή η εγγραφή στο προσωρινό αρχείο: %1",
    'class_bsdomain__warn_max_date__' => "Η ημερομηνία λήξης ορίστηκε σε %1",
    'class_cList__empty' => "Δεν υπάρχουν στοιχεία.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Δεν βρέθηκαν αντιστοιχίες για <b>\"%1\"</b> στο %2 (%3 από %4).",
    'class_cList__search_result' => "Αποτέλεσμα αναζήτησης για <b>\"%1\"</b> στο %2 (%3 από %4).",
    'class_client__client_creation_notification' => "Ειδοποίηση δημιουργίας πελάτη.",
    'class_client__client_with_contact_name_already_exists' => "Υπάρχει ήδη πελάτης με το όνομα %1.",
    'class_client__disk_space' => "χώρος στο δίσκο",
    'class_client__invalid_max_dom' => "Μη έγκυρη τιμή αριθμού τομέων, μόνο ψηφία επιτρέπονται.",
    'class_client__limit_exceed' => "Η απαιτούμενη ποσότητα %1 δεν μπορεί να εκχωρηθεί επειδή θα σημειωνόταν υπέρβαση των ορίων του λογαριασμού πελάτη %2 (%3).  Αν θέλετε να εκχωρήσετε περισσότερους πόρους, μεταβείτε στη διαδρομή Πελάτες > όνομα πελάτη > Όρια και αλλάξτε τις εκχωρήσεις ανάλογα με τις απαιτήσεις σας.  Στη συνέχεια, επιστρέψτε σε αυτήν την οθόνη και προσπαθήστε να προσαρμόσετε ξανά τις εκχωρήσεις.",
    'class_client__limit_exceed_unlimited' => "Αν θέλετε να εκχωρήσετε απεριόριστη ποσότητα πόρων (%1), πρέπει πρώτα να μεταβείτε στη διαδρομή Πελάτες > όνομα πελάτη > Όρια και να επιλέξετε το πλαίσιο ελέγχου Απεριόριστο που αντιστοιχεί στον απαιτούμενο τύπο πόρων. Στη συνέχεια, επιστρέψτε σε αυτήν την οθόνη και προσπαθήστε να προσαρμόσετε ξανά τις εκχωρήσεις.",
    'class_client__max_box' => "Γραμματοκιβώτια",
    'class_client__max_db' => "Βάσεις δεδομένων",
    'class_client__max_maillists' => "Λίστες αλληλογραφίας",
    'class_client__max_subdom' => "Υποτομείς",
    'class_client__max_traffic' => "Μέγιστη κίνηση",
    'class_client__max_wu' => "Χρήστες web",
    'class_client__max_dom_aliases' => "Ψευδώνυμα τομέα",
    'class_client__mbox_quota' => "Όριο γραμματοκιβωτίου",
    'class_client__unable_define_cl_status' => "Δεν είναι δυνατός ο καθορισμός της κατάστασης του λογαριασμού του πελάτη: %1",
    'class_client__unable_define_inactive_dom' => "Δεν είναι δυνατός ο καθορισμός των ανενεργών τομέων %1.",
    'class_client__unable_del_ip' => "Δεν είναι δυνατή η κατάργηση των IP: %1",
    'class_db__db_name_not_set' => "Το όνομα της βάσης δεδομένων δεν έχει καθοριστεί.",
    'class_db__db_not_exist_for_curr_dom' => "Η βάση δεδομένων δεν υπάρχει γι' αυτόν το διακομιστή.",
    'class_db__invalid_db_or_dom_name' => "Το αναγνωριστικό του τομέα ή της βάσης δεδομένων είναι άκυρο ή δεν έχει καθοριστεί το όνομα της βάσης δεδομένων.",
    'class_db__invalid_pass' => "Ο κωδικός πρόσβασης δεν είναι έγκυρος.",
    'class_db__mailgrp_member_exist' => "Το μέλος της ομάδας αλληλογραφίας υπάρχει ήδη.",
    'class_db__access_hosts_notsupport' => 'Η ρύθμιση των κεντρικών υπολογιστών πρόσβασης δεν υποστηρίζεται για αυτόν τον τύπο βάσης δεδομένων',
    'class_db__unable_add' => 'Δεν είναι δυνατή η προσθήκη εγγραφής κεντρικού υπολογιστή πρόσβασης: %1',
    'class_db__unable_del' => 'Δεν είναι δυνατή η διαγραφή εγγραφής κεντρικού υπολογιστή πρόσβασης: %1',
    'class_db__inc_user_not_exist' => 'Ο χρήστης βάσης δεδομένων "%1" δεν υπάρχει',
    'class_db__inc_access_record_exist' => 'Αυτή η εγγραφή πρόσβασης υπάρχει ήδη',
    'class_db__inc_access_record_not_exist' => 'Η δεδομένη εγγραφή πρόσβασης δεν υπάρχει',
    'class_db__inc_unable_del_last_record' => 'Δεν είναι δυνατή η διαγραφή της τελευταίας εγγραφής κεντρικού υπολογιστή πρόσβασης',
    'class_domtmpleditform__dns_master' => "Master",
    'class_domtmpleditform__dns_slave' => "Εξαρτώμενη",
    'class_domtmpleditform__dns_type' => "Τύπος της ζώνης DNS τομέα",
    'class_traffichistory__no_data_available' => "Δεν υπάρχουν διαθέσιμα δεδομένα.",
    'class_traffichistory__reten_pref' => 'Ρυθμίσεις διατήρησης στατιστικών στοιχείων κίνησης και web',
    'class_traffichistory__traffic_usage' => "Χρήση κίνησης",
    'clienttrafficlist_header' => "Κίνηση στους τομείς",
    'clienttrafficlist_header_of_client__' => "Κίνηση στους τομείς του πελάτη %1",
    'cmd_dns__a_dns_record_already_exist' => "Η εγγραφή αυτή θα έρθει σε αντίθεση με την εγγραφή A για τη ζώνη.",
    'cmd_dns__domain_last_ns' => 'Δεν είναι δυνατή η διαγραφή της τελευταίας εγγραφής DNS NS για τον τομέα.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Το κανονικό όνομα τομέα δεν είναι έγκυρο.",
    'cmd_dns__cname_dns_record_already_exist' => "Η εγγραφή αυτή θα έρθει σε αντίθεση με την εγγραφή CNAME για τη ζώνη.",
    'cmd_dns__cname_in_rr_combination' => 'Εντοπίστηκε λανθασμένος συνδυασμός εγγραφών DNS στη ζώνη DNS',
    'cmd_dns__cname_coexist_with_data' => 'Η εγγραφή ζώνης CNAME DNS δεν μπορεί να συνυπάρχει με άλλες εγγραφές DNS στην ίδια ζώνη.',
    'cmd_dns__dns_record_type_is_invalid' => "Ο τύπος εγγραφής DNS δεν είναι έγκυρος.",
    'cmd_dns__ext_host_is_not_resolved' => "Το κανονικό όνομα %1 δεν επιλύεται σε εγγραφή A ή AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Δεν είναι δυνατή η προσθήκη της εγγραφής %1 στη ζώνη %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Το όνομα ανταλλαγών αλληλογραφίας (mail exchanger) δεν είναι έγκυρο.",
    'cmd_dns__mx_priority_is_invalid' => "Η προτεραιότητα MX δεν είναι έγκυρη.",
    'cmd_dns__name_server_is_invalid' => "Το όνομα διακομιστή δεν είναι έγκυρο.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Η τιμή μάσκας δικτύου πρέπει να είναι 24, 16 ή 8.",
    'cmd_dns__this_dns_record_already_exists' => "Υπάρχει ήδη τέτοια εγγραφή A DNS.",
    'cmd_dns__unable_add_record' => "Δεν είναι δυνατή η προσθήκη εγγραφής '%1': %2",
    'cmd_dns__unable_add_a_record' => "Δεν είναι δυνατή η προσθήκη εγγραφής Α: %1",
    'cmd_dns__unable_add_cname_record' => "Δεν είναι δυνατή η προσθήκη εγγραφής CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Δεν είναι δυνατή η προσθήκη εγγραφής DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Δεν είναι δυνατή η προσθήκη εγγραφής EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Δεν είναι δυνατή η προσθήκη εγγραφής NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Δεν είναι δυνατή η προσθήκη εγγραφής PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Δεν είναι δυνατή η προσθήκη εγγραφής TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Δεν είναι δυνατή η δημιουργία της ζώνης DNS %1",
    'cmd_dns__unable_define_dns_record' => "Δεν είναι δυνατός ο καθορισμός της εγγραφής DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Δεν είναι δυνατή η ανάκτηση της προεπιλεγμένης κατάστασης ζώνης DNS: %1",
    'cmd_dns__unable_insert_a_record' => "Δεν είναι δυνατή η εισαγωγή εγγραφής Α: %1",
    'cmd_dns__unable_insert_mx_record' => "Δεν είναι δυνατή η εισαγωγή εγγραφής MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Δεν είναι δυνατή η εισαγωγή εγγραφής NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Δεν είναι δυνατός ο ορισμός της κατάστασης ζώνης DNS: %1",
    'cmd_domains__dom_already_exists' => "Ο τομέας %1 υπάρχει ήδη.",
    'cmd_domains__dns_record_already_exists' => "Δεν είναι δυνατή η δημιουργία του τομέα %1 επειδή υπάρχει ήδη μια εγγραφή DNS που παραπέμπει στον κεντρικό υπολογιστή %1.",
    'cmd_domains__dom_already_exists1' => "Υπάρχουν %2 υποτομείς σε αυτόν τον τομέα. Ο τομέας %1 υπάρχει ήδη.",
    'cmd_domains__dom_already_exists2' => "ο υποτομέας %1 υπάρχει ήδη.",
    'cmd_domains__dalias_already_exists' => "Το ψευδώνυμο αυτό υπάρχει ήδη.",
    'cmd_domains__domain_alias_already_exists' => 'Υπάρχει ήδη ψευδώνυμο τομέα με αυτό το όνομα.',
    'cmd_domains__unable_del_mail_for_dom' => "Δεν είναι δυνατή η διαγραφή των υπηρεσιών αλληλογραφίας για τον τομέα: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Δεν είναι δυνατή η διαγραφή του λογαριασμού ανώνυμου FTP για τον τομέα: %1",
    'cmd_domains__unable_update_dom_param' => "Δεν είναι δυνατή η ενημέρωση των παραμέτρων του τομέα: %1.",
    'cmd_domains__unable_rename_client_exist' => "το όνομα χρήστη του διαχειριστή τομέα χρησιμοποιείται ήδη.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Ο τύπος φιλοξενίας δεν είναι φυσικός.",
    'cmd_hosting__unable_create_user' => "Δεν είναι δυνατή η δημιουργία του χρήστη %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Δεν είναι δυνατός ο καθορισμός της διεύθυνσης IP για τους εικονικούς κεντρικούς υπολογιστές βάσει ονόματος: %1",
    'cmd_hosting__unable_del_old_hst' => "Δεν είναι δυνατή η διαγραφή της προηγούμενης φιλοξενίας που είχε δημιουργηθεί: %1",
    'cmd_hosting__unable_del_protected_directory' => "Δεν είναι δυνατή η διαγραφή του προστατευμένου καταλόγου: %1.",
    'cmd_hosting__unable_del_web_user' => "Δεν είναι δυνατή η διαγραφή του χρήστη web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Δεν είναι δυνατή η δημιουργία ή ενημέρωση του εικονικού κεντρικού υπολογιστή: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Δεν είναι δυνατή η ρύθμιση της φιλοξενίας κρυμμένης ανακατεύθυνσης (frame forwarding).",
    'cmd_hosting__unable_rebuild_ftp_config' => "Δεν είναι δυνατή η επαναδόμηση του αρχείου ρύθμισης παραμέτρων proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Δεν είναι δυνατή η ρύθμιση του SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Δεν είναι δυνατή η κατάργηση της προστασίας από τον κατάλογο SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Δεν είναι δυνατή η ενημέρωση της διεύθυνσης URL προορισμού %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Δεν είναι δυνατή η ενημέρωση της ζώνης DNS για τον τομέα: η εκτέλεση το βοηθητικού προγράμματος απέτυχε.",
    'cmd_hosting__unable_update_ftp_passwd' => "Δεν είναι δυνατή η ενημέρωση του κωδικού πρόσβασης FTP %1.",
    'cmd_hosting__unable_update_user' => "Δεν είναι δυνατή η ενημέρωση του χρήστη %2: %1",
    'cmd_hosting__unknown_hst_type' => "Άγνωστος τύπος φιλοξενίας.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Δεν έχετε το δικαίωμα να τερματίσετε την υπηρεσία φιλοξενίας.",
    'cmd_mail__autoresponder__not_configured' => "Δεν έχει διαμορφωθεί αυτόματη απάντηση γι' αυτόν το λογαριασμό αλληλογραφίας",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Η διεύθυνση %1 χρησιμοποιείται ήδη για την προώθηση αλληλογραφίας.",
    'cmd_mail__alias_already_exists' => "το ψευδώνυμο υπάρχει ήδη.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Αναντιστοιχία αναγνωριστικού αυτόματης απάντησης και αναγνωριστικού λογαριασμού αλληλογραφίας.",
    'cmd_mail__autoresp_id_is_undefined' => "Δεν έχει καθοριστεί αναγνωριστικό της αυτόματης απάντησης.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Υπάρχει ήδη ψευδώνυμο αλληλογραφίας με αυτό το όνομα για τον λογαριασμό αλληλογραφίας %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Ο λογαριασμός αλληλογραφίας %1 είναι ήδη εγγεγραμμένος σε αυτήν τη λίστα αλληλογραφίας.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Ο λογαριασμός αλληλογραφίας %1 υπάρχει ήδη σε αυτόν τον τομέα.",
    'cmd_mail__mail_name_not_exist' => "Ο λογαριασμός αλληλογραφίας δεν υπάρχει.",
    'cmd_mail__mail_name_passwd_part' => "Ο κωδικός πρόσβασης δεν πρέπει να περιέχει το όνομα του λογαριασμού αλληλογραφίας.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Η λίστα αλληλογραφίας %1 υπάρχει ήδη σε αυτόν τον τομέα.",
    'cmd_mail__mailname_already_exist_in_mg' => "Ο λογαριασμός αλληλογραφίας %1 είναι ήδη σε μια ομάδα αλληλογραφίας.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Ο λογαριασμός αλληλογραφίας %1 υπάρχει ήδη σε αυτόν τον τομέα.",
    'cmd_mail__mailname_already_exists' => "Ο λογαριασμός αλληλογραφίας υπάρχει ήδη.",
    'cmd_mail__mailname_is_invalid' => "Το όνομα του λογαριασμού αλληλογραφίας %1 δεν είναι έγκυρο.",
    'cmd_mail__mailname_unable_update' => "Δεν είναι δυνατή η ενημέρωση των ιδιοτήτων του λογαριασμού αλληλογραφίας:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Έχει συμπληρωθεί ο μέγιστος αριθμός αυτόματων απαντήσεων γι' αυτόν τον τομέα.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Έχει συμπληρωθεί ο μέγιστος αριθμός ομάδων αλληλογραφίας γι' αυτόν τον τομέα.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Έχει συμπληρωθεί ο μέγιστος αριθμός διακομιστών προώθησης γι' αυτόν τον τομέα.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Έχει συμπληρωθεί ο μέγιστος αριθμός γραμματοκιβωτίων.",
    'cmd_mail__no_members_specified' => "δεν καθορίστηκαν μέλη.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Ο κωδικός πρόσβασης είναι υπερβολικά απλός, παρακαλούμε επιλέξτε έναν άλλο.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Αυτή η διεύθυνση ηλεκτρονικού ταχυδρομείου χρησιμοποιείται ήδη.",
    'cmd_mail__unable_define_autoresp_id' => "Δεν είναι δυνατός ο καθορισμός του αναγνωριστικού αυτόματης απάντησης %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Η αλλαγή των ρυθμίσεων της υπηρεσίας αλληλογραφίας για τον τομέα %1 απέτυχε",
    'cmd_mail__unable_del_mail_for_dom' => "Δεν είναι δυνατή η κατάργηση της υπηρεσίας αλληλογραφίας από τον τομέα %1.",
    'cmd_mail__unable_del_mail_redirection' => "Δεν είναι δυνατή η κατάργηση της υπηρεσίας προώθησης αλληλογραφίας %1.",
    'cmd_mail__unable_remove_autoresp' => "Δεν είναι δυνατή η κατάργηση των αυτόματων απαντήσεων: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Δεν είναι δυνατή η κατάργηση των μελών της ομάδας αλληλογραφίας: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Η απενεργοποίηση της ομάδας αλληλογραφίας απέτυχε: %1",
    'cmd_mail__unable_update_mail_redirect' => "Δεν είναι δυνατή η επαναρρύθμιση της υπηρεσίας προώθησης αλληλογραφίας %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Το μέγεθος του απεσταλμένου αρχείου είναι πολύ μεγάλο.",
    'cmd_mail__additionally' => "Επιπλέον:",
    'cmd_pd__invalid_login' => "Λανθασμένο όνομα χρήστη.",
    'cmd_pd__this_user_already_exist' => "Ο χρήστης αυτός υπάρχει ήδη.",
    'cmd_pd__unable_define_hst_type' => "Δεν είναι δυνατός ο καθορισμός του τύπου φιλοξενίας.",
    'cmd_pd__unable_upd_pd_usr' => "Δεν είναι δυνατή η ενημέρωση των ιδιοτήτων του χρήστη προστατευμένου καταλόγου: %1.",
    'cmd_pd__user_is_undefined' => "Ο χρήστης δεν έχει καθοριστεί.",
    'cmd_server__no_enough_free_disk_space' => "Δεν υπάρχει αρκετός χώρος στο δίσκο.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "ο προηγούμενος κωδικός πρόσβασης είναι λανθασμένος.  Προσπαθήστε ξανά.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "έχει συμπληρωθεί το ανώτατο όριο χρηστών web γι' αυτόν τον τομέα.",
    'cmd_web_usr__unable_create_user' => "δεν είναι δυνατή η δημιουργία του χρήστη συστήματος: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "δεν είναι δυνατός ο καθορισμός του ανώτατου ορίου χρηστών web: %1",
    'cmd_web_usr__user_already_exists' => "ο χρήστης υπάρχει ήδη.",
    'cmd_web_usr__web_user_name_is_invalid' => "το όνομα χρήστη web %1 δεν είναι έγκυρο.",
    'cmd_web_usr__web_user_not_exist' => "ο χρήστης web δεν υπάρχει.",
    'common_func__exec_bad_argument' => "Το όρισμα exec δεν πρέπει να περιλαμβάνει το σύμβολο μονού εισαγωγικού.",
    '__eol' => 'Αλλαγές γραμμών',
    'eol__binary_file' => 'Δεν είναι δυνατή η τροποποίηση του στυλ αλλαγής γραμμής στο δυαδικό αρχείο.',
    'comp_info__header' => 'Στοιχεία',
    'comp_info__comp_name' => "Όνομα στοιχείου",
    'comp_info__comp_disabled' => 'Απενεργοποιήθηκε',
    'comp_info__comp_active' => 'Ενεργό',
    'comp_info__comp_not_configured' => 'Δεν έχει ρυθμιστεί',
    'comp_info__comp_not_started' => 'Δεν έχει εκκινηθεί, ελέγξτε τις ρυθμίσεις του στοιχείου',
    'comp_info__comp_version' => "Έκδοση στοιχείου",
    'comp_info__integration_error' => "Σφάλμα ενοποίησης",
    'comp_info__title' => "Στοιχεία Plesk",
    'comp_info__service_name' => "Υπηρεσία",
    'comp_info__last_updated' => '(τελευταία ενημέρωση: %1)',
    'configure__full_hostname' => "Πλήρες όνομα κεντρικού υπολογιστή",
    'cp_access_admin_deny' => "Η πρόσβαση για το διαχειριστή από τη διεύθυνση '%1' δεν επιτρέπεται σύμφωνα με την τρέχουσα ισχύουσα πολιτική περιορισμού πρόσβασης IP.",
    'create_domain_warn__' => "Κατά τη δημιουργία του τομέα πραγματοποιήθηκαν οι παρακάτω εξαιρέσεις:",
    'create_domain__client_select' => 'Επιλέξτε τον πελάτη για τον οποίο θα δημιουργηθεί ο τομέας',

    'dashboard__nav_button_name' => "Αρχική",
    'dalias__list_title' => 'Ψευδώνυμα τομέα του τομέα %1',
    'dalias__list_legend' => 'Ψευδώνυμα τομέα',
    'dalias__list_header' => 'Ψευδώνυμα τομέα',
    'dalias__list_status' => 'Κ',
    'dalias__list_name' => 'Όνομα ψευδωνύμου τομέα',
    'dalias__list_ascii_name' => 'Σε μορφή ASCII',
    'dalias__remove_title' => 'Τα παρακάτω ψευδώνυμα τομέα του τομέα %1 θα καταργηθούν:',
    'dalias__select_domain_aliases_to_remove' => 'Επιλέξτε τα ψευδώνυμα τομέα που θα καταργηθούν.',
    'dalias__mail_turn_on_failed' => 'Δεν είναι δυνατή η ενεργοποίηση της υπηρεσίας αλληλογραφίας: %1',
    'dalias__web_turn_on_failed' => 'Δεν είναι δυνατή η ενεργοποίηση της υπηρεσίας web: %1',
    'db_usr_edit__db_usr_name_old' => "Προηγούμενο όνομα χρήστη βάσης δεδομένων",
    'databases__db_title' => "Διαπιστευτήρια και εργαλεία διαχειριστή του διακομιστή MS SQL",
    'databases__server_title' => "Κωδικός πρόσβασης διαχειριστή %1",
    'databases__connection' => "Σύνδεση",
    'databases__db_server' => "Όνομα διακομιστή",
    'databases__db_admin_login' => "Όνομα χρήστη διαχειριστή",
    'databases__db_admin_passwd' => "Κωδικός πρόσβασης διαχειριστή",
    'databases__db_confirm_passwd' => "Επιβεβαίωση κωδικού πρόσβασης",
    'databases__can_not_manage' => "Δεν μπορείτε να διαχειριστείτε το διακομιστή βάσεων δεδομένων",
    'databases__not_installed' => "(δεν έχει εγκατασταθεί)",
    'databases__not_supported_license' => "(δεν υποστηρίζεται από το κλειδί άδειας χρήσης σας)",
    'databases__title' => "Διαχείριση βάσης δεδομένων και διαπιστευτήρια διαχειριστή",
    'databases__unable_connect' => "Δεν είναι δυνατή η πρόσβαση στη βάση δεδομένων. Λανθασμένες παράμετροι.",
    'databases__incorrect_db_admin_login' => 'Το όνομα χρήστη μπορεί να περιέχει μόνο αλφαριθμητικούς χαρακτήρες, παύλα και χαρακτήρα υπογράμμισης, και θα πρέπει να ξεκινά με αλφαβητικό σύμβολο.',
    'databases__incorrect_db_admin_passwd' => 'Ο κωδικός πρόσβασης δεν πρέπει να περιέχει το όνομα χρήστη.',
    'database_servers_form__title' => 'Διακομιστές βάσεων δεδομένων',
    'database_servers_form__server_list_legend' => 'Διακομιστές βάσεων δεδομένων',
    'database_servers_form__remove_empty_selection' => 'Δεν έχουν επιλεγεί διακομιστές βάσεων δεδομένων.',
    'database_servers_form__remove_title' => 'Οι παρακάτω διακομιστές βάσεων δεδομένων θα καταργηθούν:',
    'database_server_database_list__client' => 'Πελάτης',
    'database_server_database_list__domain' => 'τομέας',
    'database_server_database_list__header' => 'Βάσεις δεδομένων',
    'database_server_database_list__name' => 'Όνομα',
    'database_server_databases_form__databases_list_legend' => 'Βάσεις δεδομένων',
    'database_server_databases_form__remove_empty_selection' => 'Δεν έχουν επιλεγεί βάσεις δεδομένων.',
    'database_server_databases_form__remove_title' => 'Οι παρακάτω βάσεις δεδομένων θα καταργηθούν:',
    'database_server_databases_form__tab' => 'Βάσεις δεδομένων (%1)',
    'database_server_edit_form__admin_login' => "Όνομα χρήστη",
    'database_server_edit_form__admin_password' => "Κωδικός πρόσβασης",
    'database_server_edit_form__admin_password2' => "Επιβεβαίωση κωδικού πρόσβασης",

    'database_server_edit_form__default' => 'Χρήση αυτού του διακομιστή ως προεπιλογή για το %1',
    'database_server_edit_form__duplicate' => 'Υπάρχει ήδη καταχωρημένος διακομιστής βάσεων δεδομένων με αυτόν το συνδυασμό διεύθυνσης κεντρικού υπολογιστή και αριθμού θύρας.',
    'database_server_edit_form__host' => 'Όνομα κεντρικού υπολογιστή ή διεύθυνση IP',
    'database_server_edit_form__legend_authentication' => 'Έλεγχος ταυτότητας',
    'database_server_edit_form__legend_general' => 'Γενικά',
    'database_server_edit_form__port' => 'Αριθμός θύρας',
    'database_server_edit_form__port_hint' => 'Αφήστε το κενό για να χρησιμοποιηθεί ο προεπιλεγμένος αριθμός θύρας',
    'database_server_edit_form__tab' => 'Διακομιστής βάσεων δεδομένων',
    'database_server_edit_form__title_new' => 'Νέος διακομιστή βάσεων δεδομένων',
    'database_server_edit_form__title_edit' => 'Διακομιστής βάσεων δεδομένων στο %1',
    'database_server_edit_form__type' => 'Τύπος διακομιστή βάσεων δεδομένων',
    'database_server_edit_form__unix_socket' => '(τοπική σύνδεση)',
    'database_server_edit_form__external_connection' => 'Να επιτρέπεται στον τοπικό διακομιστή MySQL να δέχεται εξωτερικές συνδέσεις',
    'database_server_edit_form__external_connection_hint' => 'Η αλλαγή αυτής της ρύθμισης θα έχει ως αποτέλεσμα την επανεκκίνηση του τοπικού διακομιστή MySQL.Για να ενεργοποιήσετε την απομακρυσμένη πρόσβαση σε άλλους διακομιστές MySQL που είναι καταχωρημένοι στο MySQL, αλλάξτε χειροκίνητα τη ρύθμιση παραμέτρων τους.',
    'database_server_edit_form__external_connection__configured_to_local' => 'Ο τοπικός διακομιστής MySQL διαμορφώθηκε έτσι ώστε να απορρίπτει τις απομακρυσμένες συνδέσεις',
    'database_server_edit_form__external_connection__configured_to_remote' => 'Ο τοπικός διακομιστής MySQL διαμορφώθηκε έτσι ώστε να αποδέχεται τις απομακρυσμένες συνδέσεις',
    'database_server_error__consult_admin' => 'Επικοινωνήστε με το διαχειριστή του διακομιστή.',
    'database_server_error__last__connection_failed' => 'Η τελευταία απόπειρα ελέγχου αυτού του διακομιστή βάσεων δεδομένων απέτυχε λόγω προβλημάτων δικτύου.',
    'database_server_error__last__permission_denied' => 'Η τελευταία απόπειρα ελέγχου αυτού του διακομιστή βάσεων δεδομένων απέτυχε επειδή ο καθορισμένος λογαριασμός δεν διαθέτει δικαιώματα διαχειριστή.',
    'database_server_error__last__credentials_not_set' => "Η τελευταία απόπειρα σύνδεσης σε αυτόν τον διακομιστή απέτυχε επειδή δεν καθορίστηκε έγκυρο όνομα χρήστη και κωδικός πρόσβασης διαχειριστή.",
    'database_server_error__last__other_error' => 'Η τελευταία απόπειρα ελέγχου αυτού του διακομιστή βάσεων δεδομένων απέτυχε.',
    'database_server_error__real__connection_failed' => 'Η σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε λόγω προβλημάτων δικτύου:',
    'database_server_error__real__permission_denied' => 'Η σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε επειδή ο καθορισμένος λογαριασμός δεν διαθέτει δικαιώματα διαχειριστή:',
    'database_server_error__real__duplicate_object' => 'Η σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε λόγω διένεξης ονομάτων:',
    'database_server_error__real__unacceptable_name' => 'Η σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε λόγω ενός μη έγκυρου ονόματος αντικειμένου:',
    'database_server_error__real__unacceptable_password' => 'Η σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε λόγω ενός μη αποδεκτού κωδικού πρόσβασης:',
    'database_server_error__real__credentials_not_set' => "Το Plesk δεν μπορεί να συνδεθεί με το διακομιστή βάσεων δεδομένων επειδή δεν καθορίστηκε έγκυρο όνομα χρήστη και κωδικός πρόσβασης διαχειριστή.",
    'database_server_error__real__other_error' => 'Η σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε:',
    'database_server_error__test__connection_failed' => 'Η δοκιμαστική σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε λόγω προβλημάτων δικτύου:',
    'database_server_error__test__permission_denied' => 'Η δοκιμαστική σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε επειδή ο καθορισμένος λογαριασμός δεν διαθέτει δικαιώματα διαχειριστή:',
    'database_server_error__test__duplicate_object' => 'Η δοκιμαστική σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε λόγω διένεξης ονομάτων:',
    'database_server_error__test__unacceptable_name' => 'Η δοκιμαστική σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε λόγω ενός μη έγκυρου ονόματος αντικειμένου:',
    'database_server_error__test__unacceptable_password' => 'Η δοκιμαστική σύνδεση με το διακομιστή βάσεων δεδομένων απέτυχε λόγω ενός μη αποδεκτού κωδικού πρόσβασης:',
    'database_server_error__test__credentials_not_set' => "Η δοκιμαστική σύνδεση σε αυτόν τον διακομιστή απέτυχε επειδή δεν καθορίστηκε έγκυρο όνομα χρήστη και κωδικός πρόσβασης διαχειριστή.",
    'database_server_error__test__other_error' => 'Η δοκιμαστική σύνδεση με τον διακομιστή βάσεων δεδομένων απέτυχε:',
    'database_server_list__header' => 'Διακομιστές βάσεων δεδομένων',
    'database_server_list__last_error' => 'Κ',
    'database_server_list__type' => 'Τύπος διακομιστή',
    'database_server_list__host' => 'Όνομα κεντρικού υπολογιστή',
    'database_server_list__port' => 'Θύρα',
    'database_server_list__version' => 'Έκδοση',
    'database_server_list__dbcount' => 'Βάσεις δεδομένων',
    'db__create_new_db' => "Προσθήκη βάσης δεδομένων",
    'db__db_add' => "Προσθήκη βάσης δεδομένων",
    'db__db_for_dom' => "Βάσεις δεδομένων της τοποθεσίας web %1",
    'db__db_id_undefined' => "Δεν έχει καθοριστεί αναγνωριστικό της βάσης δεδομένων.",
    'db__db_name' => "Όνομα βάσης δεδομένων",
    'db__db_not_exist' => "Η βάση δεδομένων δεν υπάρχει.",
    'db__db_type' => "Τύπος",
    'db__db_server' => "Διακομιστής βάσεων δεδομένων",
    'db_server_not_exist' => "Ο διακομιστής βάσεων δεδομένων δεν υπάρχει.",
    'db__db_user_not_exist' => "Ο χρήστης της βάσης δεδομένων δεν υπάρχει.",
    'db__domain_not_exist' => "Ο τομέας δεν υπάρχει.",
    'db__enter_db_name' => "Εισαγάγετε το νέο όνομα της βάσης δεδομένων.",
    'db__invalid_db_id' => "Τα αναγνωριστικό της βάσης δεδομένων δεν είναι έγκυρο.",
    'db__invalid_db_name' => "Το όνομα της βάσης δεδομένων δεν είναι έγκυρο.  Το όνομα της βάσης δεδομένων πρέπει να περιέχει μόνο λατινικά αλφαβητικά σύμβολα, αριθμητικά ψηφία, χαρακτήρα υπογράμμισης ή παύλα.  Δεν μπορεί να περιέχει περισσότερα από 63 σύμβολα.",
    'db__max_db_reached_for_dom' => "Συμπληρώθηκε το όριο αριθμού βάσεων δεδομένων γι' αυτόν τον τομέα.",
    'db__max_mssql_db_reached_for_dom' => "Συμπληρώθηκε το όριο αριθμού βάσεων δεδομένων Microsoft SQL Server γι' αυτόν τον τομέα",
    'db__postgres_not_connect_for_admin' => "Δεν είναι δυνατή η σύνδεση στο PostgreSQL. Ενεργοποιήστε την υποστήριξη PostgreSQL στη σελίδα διαχείρισης του διακομιστή.",
    'db__postgres_not_connect_for_client' => "Δεν είναι δυνατή η σύνδεση στο PostgreSQL. Ζητήστε βοήθεια από το διαχειριστή του συστήματος.",
    'db__remove_db_on_domain' => "Θα καταργηθούν οι παρακάτω βάσεις δεδομένων της τοποθεσίας web %2 που ανήκει στον πελάτη %1:",
    'db__remove_db_on_domain_of_cl' => "Θα καταργηθούν οι παρακάτω βάσεις δεδομένων για τον τομέα %2 που ανήκει στον πελάτη %1:",
    'db__remove_db_linked_resource' => 'Αυτή η βάση δεδομένων χρησιμοποιείται από μια εφαρμογή web.  Μπορείτε να την καταργήσετε μόνο αφού καταργήσετε πρώτα την εγκατάσταση αυτής της εφαρμογής web.',
    'db__remove_db_users' => "Θα καταργηθούν οι παρακάτω χρήστες της βάσης δεδομένων %3 της τοποθεσίας web %2 που ανήκει στον πελάτη %1:",
    'db__remove_db_users_of_cl' => "Θα καταργηθούν οι παρακάτω χρήστες της βάσης δεδομένων %3 της τοποθεσίας web %2 που ανήκει στον πελάτη %1:",
    'db__select_db_for_remove' => "Επιλέξτε τις βάσεις δεδομένων που θα καταργηθούν.",
    'db__select_db_users_for_remove' => "Επιλέξτε τους χρήστες της βάσης δεδομένων που θα καταργηθούν.",
    'db__unable_create_db_user' => "Δεν είναι δυνατή η δημιουργία του χρήστη βάσης δεδομένων: %1",
    'db__unable_define_db_name' => "Δεν είναι δυνατός ο καθορισμός του ονόματος της βάσης δεδομένων: %1",
    'db__unable_define_db_user' => "Δεν είναι δυνατός ο καθορισμός του χρήστη της βάσης δεδομένων: %1",
    'db__unable_define_db_users' => "Δεν είναι δυνατός ο καθορισμός των χρηστών της βάσης δεδομένων: %1",
    'db__unable_select_dom_name' => "Δεν είναι δυνατή η επιλογή του ονόματος τομέα: %1",
    'db_edit__db_for_dom' => "Χρήστες για τη βάση δεδομένων %1 στον τομέα %2",
    'db_edit__invalid_db_name' => "Το όνομα της βάσης δεδομένων δεν είναι έγκυρο.",
    'db_edit__no_users' => "Δεν υπάρχουν χρήστες με διαπιστευτήρια γι' αυτήν τη βάση δεδομένων.",
    'db_edit__unable_define_db_usrs' => "Δεν είναι δυνατός ο καθορισμός των χρηστών της βάσης δεδομένων: %1",
    'db_edit__unable_select_db_usr' => "Δεν είναι δυνατή επιλογή του χρήστη της βάσης δεδομένων.",
    'db_edit__db_user_password_for_' => "Πληκτρολογήστε τον κωδικό πρόσβασης για να συνδεθείτε ως ο χρήστης της βάσης δεδομένων %1",
    'db_list__tab_title_db_type' => "Τ",
    'db_usr_edit__add_db_usr' => "Προσθήκη χρήστη βάσης δεδομένων",
    'db_usr_edit__db_usr_name' => "Όνομα χρήστη βάσης δεδομένων",
    'db_usr_edit__edit_db_usr' => "Ρύθμιση διαπιστευτηρίων για το λογαριασμό χρήστη της βάσης δεδομένων",
    'db_usr_edit__for_db' => "στη βάση δεδομένων %1",
    'db_usr_edit__not_create_pass' => "Η ενέργεια αυτή θα οδηγήσει στη δημιουργία ενός λογαριασμού χρήστη της βάσης δεδομένων χωρίς κωδικό πρόσβασης.\nΘέλετε να δημιουργήσετε χρήστη χωρίς να ορίσετε κωδικό πρόσβασης;",
    'dbuser__only_one_user_can_be_default' => "Μόνο ένας χρήστης μπορεί να οριστεί ως προεπιλεγμένος.",
    'db_server__cannot_delete_default' => "Δεν είναι δυνατή η διαγραφή του προεπιλεγμένου διακομιστή βάσεων δεδομένων.",
    'db_server__cannot_delete_local' => "Δεν είναι δυνατή η διαγραφή του τοπικού διακομιστή βάσεων δεδομένων.",
    'db_server__cannot_delete_used' => 'Δεν μπορείτε να διαγράψετε ένα διακομιστή βάσεων δεδομένων όσο εξακολουθεί να φιλοξενεί βάσεις δεδομένων ή χρήστες βάσης δεδομένων.',
    'demo__disabled_in_demo' => "Η ενέργεια αυτή δεν υποστηρίζεται στη δοκιμαστική έκδοση.",
    'defaultcomponents__title' => "Επιλογή προεπιλεγμένων στοιχείων",
    'defaultcomponents__select_default' => "Επιλέξτε το προεπιλεγμένο στοιχείο %1",//to check
    'defaultcomponents__not_installed' => "(δεν έχει εγκατασταθεί)",
    'defaultcomponents__not_configured' => "(δεν έχει ρυθμιστεί)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Ορισμένες κατηγορίες υπηρεσιών περιέχουν μη έγκυρες επιλογές ή δεν έχει γίνει καμία επιλογή.",
    'defaultcomponents__depends_on' => "(απαιτεί %1)",
    'defaultcomponents__parameters' => "Παράμετροι του %1",
    'component_name__antivirus' => "Προστασία από ιούς",
    'component_name__database' => "Διακομιστής SQL",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "Διακομιστής DNS",
    'component_name__firewall' => "Τείχος προστασίας",
    'component_name__ftpserver' => "Διακομιστής FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Διακομιστής αλληλογραφίας",
    'component_name__local_mailserver' => "Τοπικός διακομιστής αλληλογραφίας",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Δέσμες ενεργειών στο web",
    'component_name__spamfilter' => "Φίλτρο ανεπιθύμητης αλληλογραφίας",
    'component_name__stats' => "Στατιστικά στοιχεία web",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Δημοσίευση στο web",
    'component_name__webserver' => "Διακομιστής web",
    'dns__dns_record_invalid_values' => 'Καθορίστηκαν λανθασμένες τιμές εγγραφών DNS: %1: %2',
    'dns__dns_zone_invalid_values' => 'Καθορίστηκαν λανθασμένες παράμετροι ζώνης DNS.',

    'dns__soa_mname_title' => 'Κύριος διακομιστής ονομάτων',
    'dns__soa_mname_legend' => 'Διακομιστής ονομάτων',
    'dns__soa_mname_autoselect' => '(Αυτόματη επιλογή)',

    'dns__dns_zone_default' => 'Προεπιλογές ζώνης',
    'dns__dns_soa_legend' => 'Εγγραφή SOA',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => 'Ανανέωση',
    'dns__dns_soa_retry' => 'Επανάληψη',
    'dns__dns_soa_expire' => 'Λήξη',
    'dns__dns_soa_minimum' => 'Ελάχιστο',
    'dns__dns_soa_ttl_error' => 'Η τιμή TTL δεν είναι έγκυρη. Μπορεί να είναι από 1 δευτερόλεπτο έως 68 έτη.',
    'dns__dns_soa_refresh_error' => 'Η τιμή ανανέωσης δεν είναι έγκυρη. Μπορεί να είναι από 1 δευτερόλεπτο έως 68 έτη.',
    'dns__dns_soa_retry_error' => 'Η τιμή επανάληψης δεν είναι έγκυρη. Μπορεί να είναι από 1 δευτερόλεπτο έως 68 έτη.',
    'dns__dns_soa_expire_error' => 'Η τιμή λήξης δεν είναι έγκυρη. Μπορεί να είναι από 1 δευτερόλεπτο έως 68 έτη.',
    'dns__dns_soa_minimum_error' => 'Η ελάχιστη τιμή δεν είναι έγκυρη. Μπορεί να είναι από 1 δευτερόλεπτο έως 68 έτη.',
    'dns__dns_default_title' => 'Επαναφορά της ζώνης DNS',
    'dns__dns_default_legend' => "Επιλογές επαναφοράς ζώνης",
    'dns__dns_default_text' => "Επιλέξτε τις ρυθμίσεις για την επαναφορά της ζώνης DNS, επιβεβαιώστε τις και κάντε κλικ στο OK.",
    'dns__dns_default_confirm' => "Επιβεβαιώστε την επαναφορά της ζώνης DNS",
    'dns__dns_default_confirm_required' => "Παρακαλούμε επιβεβαιώστε την επαναφορά της ζώνης DNS",
    'dns__dns_default_invalid_ip_address' => 'Η διεύθυνση IP δεν είναι έγκυρη',

    'dns_t__dns_default_title' => 'Επαναφορά του προεπιλεγμένου προτύπου ζώνης DNS',
    'dns_t__dns_default_legend' => "Επιλογές επαναφοράς",
    'dns_t__dns_default_text' => 'Επιβεβαιώστε ότι θέλετε να επαναφέρετε την προεπιλεγμένη ρύθμιση παραμέτρων του προτύπου ζώνης DNS.',
    'dns_t__dns_default_confirm' => "Επιβεβαιώστε την επαναφορά",
    'dns_t__dns_default_confirm_required' => "Επιβεβαιώστε την επαναφορά του προτύπου ζώνης DNS",
    'dns_t__dns_zone_off_remove_title' => "Οι παρακάτω εγγραφές πόρων για το πρότυπο ζώνης DNS θα καταργηθούν:",
    'dns_t__dns_zone_master_remove_title' => "Οι παρακάτω εγγραφές πόρων θα καταργηθούν από το πρότυπο ζώνης DNS:",
    'dns_t__add_dns_record_master_title' => 'Προσθήκη εγγραφής πόρων στο πρότυπο ζώνης',
    'dns_t__add_dns_record_off_title' => 'Προσθήκη διακομιστή ονομάτων',
    'dns_t__edit_dns_record_master_title' => 'Επεξεργασία εγγραφής πόρων',
    'dns_t__edit_dns_record_off_title' => 'Επεξεργασία διακομιστή ονομάτων',
    'dns_t__select_record_to_remove' => "Επιλέξτε τις εγγραφές θα καταργηθούν από το πρότυπο ζώνης DNS",
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__dns_zone_off_remove_title' => "Οι παρακάτω εγγραφές πόρων θα καταργηθούν από τη ζώνη %1:",
    'dns__dns_zone_master_remove_title' => "Κατάργηση εγγραφών πόρων από τη ζώνη DNS %1",
    'dns__dns_zone_slave_remove_title' => "Οι παρακάτω εγγραφές κύριου διακομιστή ονομάτων για το %1 θα καταργηθούν:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Εισαγωγή συμβολοσειράς εγγραφής',
    'dns_add__is_spf_syntax' => 'Εγγραφή SPF',
    'dns_add__spf_value_is_invalid' => "Η τιμή της εγγραφής SPF είναι λανθασμένη, πρέπει να ξεκινά με 'v=spf'",
    'dns__dns_zone_status' => "Κατάσταση ζώνης DNS.",
    'dns__dns_zone_template' => 'Ρυθμίσεις DNS',
    'dns__host' => "Κεντρικό υπολογιστής",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "Η διεύθυνση IP του νέου κύριου διακομιστή DNS είναι άκυρη ή κενή.",
    'dns__ip_address' => "Διεύθυνση ΙP",
    'dns__master_dns_type' => "είναι κύριος διακομιστής DNS",
    'dns__masters' => "Κύριοι διακομιστές DNS",
    'dns__soa_minimum_too_large' => 'Δεν συνιστάται η προσωρινή αποθήκευση αρνητικών αποκρίσεων για περισσότερο από τρεις ώρες.',
    'dns__select_masters_to_remove' => "Επιλέξτε τους κύριους διακομιστές DNS που θα καταργηθούν.",
    'dns__select_template_record_to_remove' => 'Επιλέξτε τις εγγραφές προτύπων DNS που θα καταργηθούν.',
    'dns__select_record_to_remove' => 'Επιλέξτε τις εγγραφές DNS που θα καταργηθούν.',
    'dns__nameservers_for_domain' => "Διακομιστές ονομάτων για τον τομέα",
    'dns__ns' => "Διακομιστής ονομάτων",
    'dns__ns_record' => "Διακομιστές ονομάτων",
    'dns__remove_dns_zone_of_domain__' => "Κατάργηση εγγραφών DNS από τον τομέα %1",
    'dns__remove_dns_zone_template__' => "Οι παρακάτω εγγραφές DNS θα καταργηθούν από το πρότυπο:",
    'dns__remove_this_dns_record?' => "Είστε βέβαιοι ότι θέλετε να καταργήσετε αυτήν την εγγραφή DNS;",
    'dns__restore_default' => "Επαναφορά της ζώνης DNS από το πρότυπο",
    'dns__restore_default_confirm' => "Η επαναφορά της ζώνης DNS θα καταργήσει την τρέχουσα ρύθμιση παραμέτρων ζώνης DNS. Θέλετε να συνεχίσετε ούτως ή άλλως;",
    'dns__restore_default_error' => "Σφάλμα επαναφοράς της ζώνης DNS:",
    'dns__slave_dns_type' => "είναι δευτερεύων διακομιστής DNS",
    'dns__soa_refresh_value_is_small' => 'Η τιμή του χρονικού διαστήματος ανανέωσης είναι μικρότερη από μία ώρα, κάτι που μπορεί να αυξήσει σημαντικά την κίνηση και τη χρήση πόρων του διακομιστή.  Θέλετε να συνεχίσετε να χρησιμοποιείτε αυτήν την τιμή;',
    'dns__subdomain_dns_rec_removed' => "Η εγγραφή πόρων A καταργήθηκε από τη ζώνη υποτομέα %1.",
    'dns__zone_switched_off_no_ns' => "Η ζώνη απενεργοποιήθηκε επειδή δεν υπάρχει εγγραφή NS %1, η παρουσία της οποίας είναι απαραίτητη στη ζώνη. Για να προσθέσετε την εγγραφή στη ζώνη, κάντε κλικ στο κουμπί Προσθήκη εγγραφής.",
    'dns__cant_switch_on_no_ns' => "Η ζώνη δεν μπορεί να ενεργοποιηθεί επειδή δεν υπάρχει εγγραφή NS %1, η παρουσία της οποίας είναι απαραίτητη στη ζώνη.  Για να προσθέσετε την εγγραφή στη ζώνη, κάντε κλικ στο κουμπί Προσθήκη εγγραφής.",
    'dns__type' => "Τύπος εγγραφής",
    'dns__unable_activate/deactivate_dns' => "Δεν είναι δυνατή η ενεργοποίηση/απενεργοποίηση του DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Δεν είναι δυνατή η προσθήκη κύριου διακομιστή DNS: διπλή καταχώρηση.",
    'dns__unable_add_dns_master_local_ip' => "Δεν είναι δυνατή η προσθήκη διεύθυνση IP για τον κύριο διακομιστή DNS: η εγγραφή αυτή πρέπει να δημιουργηθεί σε απομακρυσμένο διακομιστή.",
    'dns__unable_define_dns_record' => "Δεν είναι δυνατός ο καθορισμός της εγγραφής DNS: %1",
    'dns__unable_get_dns_template_status' => "Δεν είναι δυνατή η ανάκτηση της κατάστασης προτύπου DNS.",
    'dns__unable_remove_dns_rec' => "Δεν είναι δυνατή η κατάργηση της εγγραφής DNS: %1",
    'dns__val' => "Τιμή",
    'dns__warnings__' => "Το αποτέλεσμα της τροποποίησης της ζώνης DNS:",
    'dns__you_not_have_perm_manage_dns' => "Δεν έχετε δικαίωμα να διαχειριστείτε τη ζώνη DNS γι' αυτόν τον τομέα.",
    'dns__zone_record' => "Εγγραφές DNS",
    'dns__cant_create_record_with_server_ip' => "Δεν είναι δυνατή η προσθήκη της συγκεκριμένης διεύθυνσης IP επειδή συμπίπτει με τη διεύθυνση IP αυτού του διακομιστή που διαχειρίζεται το Plesk.",

    'dns__tabs_acl' => "Μεταφορές ζώνης",
    'dns__acl_add_network_legend' => "Προσθήκη δικτύου",
    'dns__acl_add_ip_legend' => "Προσθήκη διεύθυνσης IP",
    'dns__acl_network_not_allowed' => "Αυτή η διεύθυνση δικτύου δεν επιτρέπεται από το DNS στα Windows.",
    'dns__acl_enter_ip_address_with_mask' => "Διεύθυνση IP/μάσκα",
    'dns__acl_enter_ip_address' => "Διεύθυνση ΙP",
    'dns__acl_list_network_legend' => "Δίκτυα που επιτρέπεται να λάβουν αντίγραφο της ζώνης DNS",
    'dns__acl_list_ip_legend' => "Διευθύνσεις IP που επιτρέπεται να λάβουν αντίγραφο της ζώνης DNS",
    'bt_dns_acl_add_network' => "Προσθήκη δικτύου",
    'bt_dns_acl_add_ip' => "Προσθήκη διεύθυνσης IP",

    'dns_add__add_rec_for_zone' => "Προσθήκη %1 για τη ζώνη %2",
    'dns_add__canonical_dom_name_is_invalid' => "Το κανονικό όνομα τομέα δεν είναι έγκυρο.",
    'dns_add__enter_canonical_name' => "Κανονικό όνομα",
    'dns_add__enter_dom_name' => "Όνομα τομέα",
    'dns_add__enter_ip_address' => "Διεύθυνση ΙP",
    'dns_add__enter_ip_mask' => "Διεύθυνση IP και μάσκα δικτύου",
    'dns_add__enter_mail_domain' => "Τομέας αλληλογραφίας",
    'dns_add__enter_mail_exchanger' => "Mail exchange server",
    'dns_add__enter_nameserver' => "Διακομιστής ονομάτων",
    'dns_add__enter_txt_record' => "Εγγραφή TXT",
    'dns_add__enter_service_name' => "Όνομα υπηρεσίας",
    'dns_add__hint_service_name' => "Παράδειγμα: SIP",
    'dns_add__enter_protocol' => "Πρωτόκολλο",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Προτεραιότητα",
    'dns_add__specify_weight_of_service' => "Σχετική βαρύτητα για τις εγγραφές με την ίδια προτεραιότητα",
    'dns_add__enter_target_host' => "Κεντρικός υπολογιστής προορισμού",
    'dns_add__hint_target_host' => "Παράδειγμα: example.com",
    'dns_add__enter_target_port' => "Θύρα προορισμού",
    'dns_add__caa_tag' => "Ετικέτα",
    'dns_add__caa_value' => "Τιμή",

    'dns_add__invalid_ip' => "Η διεύθυνση IP δεν είναι έγκυρη.",
    'dns_add__low' => "χαμηλή",
    'dns_add__mail_dom_name_is_invalid' => "Το όνομα τομέα αλληλογραφίας δεν είναι έγκυρο.",
    'dns_add__nameserver_is_invalid' => "Το όνομα διακομιστή δεν είναι έγκυρο.",
    'dns_add__record' => "Εγγραφή %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Καθορίστε την προτεραιότητα του mail exchange server",
    'dns_add__unable_insert_new_dns_rec' => "Δεν είναι δυνατή η εισαγωγή νέας εγγραφής DNS: %1",
    'dns_add__very_high' => "πολύ υψηλή",
    'dns_check__test_dns_zone' => "Δοκιμή ζώνης DNS %1 στο %2",
    'dns_check__unable_get_dom_properties' => "Δεν είναι δυνατή η ανάκτηση των ιδιοτήτων του τομέα: %1",
    'dom_ctrl__allowed' => "Επιτρέπεται",
    'dom_ctrl__db' => "Βάσεις δεδομένων MySQL",
    'dom_ctrl__mssql_db' => "Βάσεις δεδομένων MS SQL",
    'dom_ctrl__disk_space' => "χώρος στο δίσκο",
    'dom_ctrl__dom_adm' => "Τομέας %1 από %2",
    'dom_ctrl__dom_cl' => "Τομέας %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Έχει ρυθμιστεί προώθηση στον τομέα με μη καθορισμένη διεύθυνση URL προώθησης",
    'dom_ctrl__domain_has_frame_forwarding' => "Ο τομέας έχει κρυμμένη ανακατεύθυνση στη διεύθυνση URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Δεν έχει διαμορφωθεί φιλοξενία στον τομέα",
    'dom_ctrl__domain_has_physical_hosting' => "Έχει ρυθμιστεί φιλοξενία περιεχομένου web γι' αυτόν τον τομέα στη διεύθυνση IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Ο τομέας διαθέτει τυπική ανακατεύθυνση στη διεύθυνση URL %1",
    'dom_ctrl__maillists' => "Λίστες αλληλογραφίας",
    'dom_ctrl__mboxes' => "Γραμματοκιβώτια",
    'dom_ctrl__mg' => "Προωθήσεις αλληλογραφίας",
    'dom_ctrl__resource_name' => "Πόρος",
    'dom_ctrl__resp' => "Αυτόματες απαντήσεις",
    'dom_ctrl__subdom' => "Υποτομείς",
    'dom_ctrl__dom_aliases' => "Ψευδώνυμα τομέα",
    'dom_ctrl__traffic' => "Κυκλοφορία",
    'dom_ctrl__unable_activate/deactivate_dom' => "Δεν είναι δυνατή η ενεργοποίηση/απενεργοποίηση του τομέα: %1",
    'dom_ctrl__used' => "Χρησιμοποιούνται",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Χρήστες web",
    'dom_pref__bounce_with_phrase' => "Αναπήδηση με μήνυμα",
    'dom_pref__bounce' => "Αναπήδηση",
    'dom_pref__catch_addr' => "Προώθηση στη διεύθυνση",
    'dom_pref__reject' => 'Απόρριψη',
    'dom_pref__confirm_domain_removing' => "Μην ξεχάσετε να ενημερώσετε τους επισκέπτες του τομέα για την αλλαγή του ονόματος τομέα. Είστε βέβαιοι ότι θέλετε να μετονομάσετε τον τομέα;",
    'dom_pref__db_inconsystency' => "ασυνέπεια βάσης δεδομένων.",
    'dom_pref__dbs' => "βάσεις δεδομένων",
    'dom_pref__delete_traffic_stat' => "Διατήρηση στατιστικών στοιχείων κίνησης και web",
    'dom_pref__delete_traffic_stat_older' => "Διατήρηση στατιστικών στοιχείων κίνησης και web",
    'dom_pref__dom_level_name_conflict' => "Το όνομα χρήστη του διαχειριστή του τομέα έρχεται σε διένεξη με το όνομα χρήστη ενός εκ των πελατών.",
    'dom_pref__invalid_disk_space_limit' => "Μη έγκυρο όριο χώρου στο δίσκο.  Μέγιστη τιμή: %1",
    'dom_pref__invalid_expiration_date_limit' => "Μη έγκυρη περίοδος ισχύος.",
    'dom_pref__invalid_max_traffic_limit' => "Μη έγκυρο όριο κίνησης. Μέγιστη τιμή: %1",
    'dom_pref__limits_of_dom' => "Όρια για τον τομέα %1",
    'dom_pref__mail_grps' => "ομάδες αλληλογραφίας",
    'dom_pref__mail_nonexistent_user' => "Ποια ενέργεια πρέπει να πραγματοποιείται με τα μηνύματα αλληλογραφίας που αποστέλλονται σε ανύπαρκτους χρήστες",
    'dom_pref__mail_redirs' => "διακομιστές προώθησης αλληλογραφίας",
    'dom_pref__mail_resps' => "αυτόματες απαντήσεις αλληλογραφίας",
    'dom_pref__max_limit_is_invalid' => "Το %1 δεν είναι έγκυρο.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Ο μέγιστος αριθμός %1 δεν είναι έγκυρος.",
    'dom_pref__new_limit_less_currently_used' => "%1: απαιτούνται - %2, χρησιμοποιούνται αυτήν τη στιγμή - %3",
    'dom_pref__older_that' => "για",
    'dom_pref__postboxes' => "γραμματοκιβώτια",
    'dom_pref__preferences_of_dom' => "Ρυθμίσεις για τον τομέα %1",
    'dom_pref__redirect_to_itself' => "Ο τομέας θα έχει την προώθηση ρυθμισμένη στον εαυτό του",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Έχετε ορίσει χρόνο διατήρησης των στατιστικών στοιχείων κίνησης του τομέα μικρότερο από τη συνολική τιμή που έχει καθοριστεί για το διακομιστή (%1 μήνας(ες)). Ο χρόνος διατήρησης των στατιστικών στοιχείων θα οριστεί ως ίσος με την προεπιλεγμένη τιμή για το διακομιστή (%1 μήνας(ες)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Δεν είναι δυνατή η προσθήκη προθέματος www στον τομέα: %1",
    'dom_pref__unable_define_physical_hst_param' => "Δεν είναι δυνατός ο καθορισμός των παραμέτρων φυσικής φιλοξενίας: %1",
    'dom_pref__unable_rename_domain' => "Δεν είναι δυνατή η μετονομασία του τομέα",
    'dom_pref__unable_set_up_mbox_quota' => "Δεν είναι δυνατός ο καθορισμός του ορίου γραμματοκιβωτίου γι' αυτόν τον τομέα: %1",
    'dom_pref__unable_set_up_web_user_script' => "Δεν είναι δυνατή η ρύθμιση δεσμών ενεργειών για τους χρήστες web: %1",
    'dom_pref__unlimited' => "Απεριόριστο",
    'dom_pref__web_usrs' => "χρήστεσ web",
    'dom_pref__you_already_have_%object' => "Έχετε ήδη %1",
    'dom_cli__warning_ignore_quota' => 'ΠΡΟΕΙΔΟΠΟΙΗΣΗ: Η επιλογή "-hard_quota" αγνοείται: δεν υποστηρίζεται η επιβολή ορίων στο σκληρό δίσκο',
    'dom_user_client_login_exist' => "Δεν είναι δυνατόν να επιτραπεί η πρόσβαση διαχειριστή τομέα στο Plesk για τον τομέα %1: αυτό το όνομα χρήστη χρησιμοποιείται ήδη.",
    'domain__unable_to_turn_on_service' => "Αποτυχία ενεργοποίησης της υπηρεσίας %1.",
    'domains__change_the_status_of_domain?' => "Είστε βέβαιοι ότι θέλετε να διαγράψετε την κατάσταση του τομέα %1;",
    'domains__client_info_hiding_traffic' => "%1 τομείς, %2 ενεργοί τομείς, %3 χώρος στο δίσκο που χρησιμοποιείται",
    'domains__unable_to_change_client_status' => "Δεν είναι δυνατή η αλλαγή της κατάστασης του λογαριασμού πελάτη: %1",
    'domains__unable_update_apache_settings' => "Δεν είναι δυνατή η ενημέρωση των ρυθμίσεων Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Δεν έχετε δικαιώματα διαγραφής τομέων.",
    'domains__you_want_change_the_status_of_the_cl??' => "Είστε βέβαιοι ότι θέλετε να διαγράψετε την κατάσταση του λογαριασμού πελάτη;",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Είστε βέβαιοι ότι θέλετε να εκτελέσετε αυτήν την ενέργεια;",
    'domains_list__unable_remove_doms' => "Δεν είναι δυνατή η κατάργηση των τομέων: %1",
    'domaintrafficlist_header_of_domain__' => "Κίνηση στον τομέα %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Επιλέξτε τα ψευδώνυμα τομέα που θα καταργηθούν.',
    'domain_aliases_remove__title' => 'Κατάργηση ψευδωνύμων τομέα',
    'domain_aliases__max_aliases_reached_for_dom' => "Συμπληρώθηκε το όριο αριθμού ψευδωνύμων γι' αυτόν τον τομέα.",
    'domain_edit__edit_title' => 'Επεξεργασία ονόματος ψευδωνύμου τομέα',
    'domain_alias_edit__type' => 'Τύπος ψευδωνύμου τομέα',
    'domain_aliases__list_header' => 'Ψευδώνυμα τομέα',
    'domain_aliases__name' => 'Όνομα',
    'domain_aliases__type' => 'Τύπος',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Ψευδώνυμα τομέα',
    'domain_aliases__legend' => 'Ψευδώνυμα τομέα',
    'domain_alias__domain_exists' => 'Υπάρχει ήδη τομέας με αυτό το όνομα',
    'domain_alias__subdomain_exists' => 'Υπάρχει ήδη υποτομέας με αυτό το όνομα',
    'domain_alias__dns_record_exists' => 'Υπάρχει ήδη εγγραφή DNS με το καθορισμένο όνομα ψευδωνύμου τομέα',
    'domain_alias__domain_alias_exists' => "Υπάρχει ήδη ένα ψευδώνυμο τομέα με αυτό το όνομα",
    'domain_alias__invalid_type_full' => 'Ο διακομιστής αλληλογραφίας δεν υποστηρίζει τα ψευδώνυμα τομέα',
    'domain_alias__redirect_exists' => 'Ανιχνεύθηκε ανακατεύθυνση στον εαυτό του.',

    'ds__anonymous_ftp' => "Ανώνυμο FTP",
    'drweb__pagetitle' => 'Ρυθμίσεις προστασίας από ιούς',
    'drweb__drweb' => 'Έλεγχος αλληλογραφίας με λογισμικό προστασίας από ιούς',
    'drweb__drweb_direction' => 'Έλεγχος αλληλογραφίας για ιούς',
    'drweb__drweb_direction_off' => 'Να μην πραγματοποιείται έλεγχος για ιούς',
    'drweb__drweb_direction_any' => 'Εισερχόμενη και εξερχόμενη αλληλογραφία',
    'drweb__drweb_direction_from' => 'Μόνο εξερχόμενη αλληλογραφία',
    'drweb__drweb_direction_to' => 'Μόνο εισερχόμενη αλληλογραφία',
    'drweb__disable_reason_key' => 'Το λογισμικό προστασίας από ιούς δεν υποστηρίζεται από το κλειδί άδειας χρήσης.',
    'drweb__disable_reason_perm' => 'Δεν έχετε δικαίωμα να διαχειριστείτε το λογισμικό προστασίας από ιούς.',
    'drweb__disable_reason_install' => 'Το λογισμικό προστασίας από ιούς δεν έχει εγκατασταθεί.',
    'drweb__filters' => 'Φίλτρα προστασίας από ιούς',
    'ds__dns' => "Ζώνη DNS",
    'ds__mail' => "Αλληλογραφία",
    'dsr__of_client_title' => "Συνοπτική αναφορά τομέα του %1",
    'dsr__report_has_been_sent_email' => "Η αναφορά εστάλη στη διεύθυνση ηλεκτρονικού ταχυδρομείου: %1",
    'dsr__title' => "Συνοπτική αναφορά τομέα",
    'dumps_list__deletion_page_title' => "Τα παρακάτω αρχεία αντιγράφων ασφαλείας του τομέα %1 θα καταργηθούν:",
    'dumps_list__dumpfile_is_invalid' => "Το αρχείο %1 δεν είναι έγκυρο αρχείο αντιγράφου ασφαλείας τομέα.",
    'dumps_list__page_title' => "Αποθήκευσης αρχείων αντιγράφων ασφαλείας",
    'dumps_upload__page_title' => "Αποστολή αρχείων αντιγράφων ασφαλείας στον χώρο αποθήκευσης",
    'dumps_list__repository_is_not_exist' => "Ο χώρος αποθήκευσης αρχείων αντιγράφων ασφαλείας δεν υπάρχει.",
    'dumps_list__unable_to_remove' => "Δεν είναι δυνατή η κατάργηση του αρχείου αντιγράφου ασφαλείας: %1",
    'dumps_list__dumpfile_can_conflict' => "Το όνομα αρχείου που καθορίσατε έρχεται σε διένεξη με το αρχείο %1 Εισαγάγετε άλλο όνομα αρχείου.",
    'dusr_ed__allow_dl_usr_access' => "Να επιτρέπεται η πρόσβαση διαχειριστή τομέα",
    'dusr_ed__information' => "Ιδιότητες διαχειριστή του τομέα %1",
    'dusr_ed__locale' => "Γλώσσα διαχειριστή τομέα",
    'dusr_ed__skin' => "Εμφάνιση περιβάλλοντος εργασίας διαχειριστή τομέα",
    'dusr_ed__personal_information' => 'Προσωπικές πληροφορίες',
    'ess__error' => "Σφάλμα",
    'example__' => "Παράδειγμα: %1",
    'extras__allow_certificate_purchasing' => "Να επιτρέπεται η αγορά πιστοποιητικών",
    'extras__allow_domain_registration' => "Να επιτρέπεται η καταχώρηση τομέων",
    'extras__allow_extras' => "Να επιτρέπονται πρόσθετες υπηρεσίες",
    'extras__buy_new_key' => "Η τρέχουσα άδειά σας δεν σας επιτρέπει να τροποποιήσετε αυτά τα αντικείμενα.",
    'extras__setup_services' => "Ρύθμιση πρόσθετων υπηρεσιών",

    'firewallmainform__title' => 'Διαχείριση τείχους προστασίας',
    'firewallmainform__interfaces_list_legend' => 'Λίστα διασυνδέσεων δικτύου',
    'firewall__interfacelist' => 'Διασυνδέσεις δικτύου',
    'interfacelist__enabled' => 'F',
    'interfacelist__status' => 'I',

    'interfacelist__interface' => 'Όνομα διασύνδεσης',
    'interfacelist__type' => 'Τύπος διασύνδεσης',
    'bt_rule_add' => 'Προσθήκη κανόνα τείχους προστασίας',
    'bt_panic' => 'Λειτουργία πανικού',
    'firewallmainform__rules_list_legend' => 'Λίστα κανόνων',
    'firewall__rulelist' => 'Κανόνες',
    'rulelist__enable' => 'Κ',
    'rulelist__name' => 'Όνομα',
    'rulelist__allow_input_from_any_port_profiles' => '[Να επιτρέπονται] οι εισερχόμενες συνδέσεις από [όλα] στη θύρα [%1], προφίλ: [%2]',
    'rulelist__allow_input_from_port_profiles' => '[Να επιτρέπονται] οι εισερχόμενες συνδέσεις από [%1] στη θύρα [%2], προφίλ: [%3]',
    'rulelist__block_input_from_any_port_profiles' => '[Να απορρίπτονται] οι εισερχόμενες συνδέσεις από [όλα] στη θύρα [%1], προφίλ: [%2]',
    'rulelist__block_input_from_port_profiles' => '[Να απορρίπτονται] οι εισερχόμενες συνδέσεις από [%1] στη θύρα [%2], προφίλ: [%3]',
    'rulelist__description' => 'Περιγραφή',
    'ruleeditform__add_title' => 'Προσθήκη νέου κανόνα',
    'ruleeditform__properties' => 'Οι ιδιότητες του κανόνα',
    'ruleeditform__name' => 'Το όνομα του κανόνα',
    'ruleeditform__port' => 'Να επιτρέπονται συνδέσεις στην παρακάτω θύρα ή περιοχή θυρών',
    'ruleeditform__protocol_tcp' => 'Πρωτόκολλο TCP',
    'ruleeditform__protocol_udp' => 'Πρωτόκολλο UDP',
    'ruleeditform__edit_title' => 'Επεξεργασία κανόνα τείχους προστασίας',
    'ruleeditform__newrule' => 'Νέος κανόνας',
    'ruleeditform__enabled' => 'Ενεργοποίηση του κανόνα',
    'ruleeditform__profiles_text' => 'Προφίλ',
    'ruleeditform__profiles_domain_text' => 'τομέας',
    'ruleeditform__profiles_private_text' => 'Ιδιωτικό',
    'ruleeditform__profiles_public_text' => 'Δημόσιος',
    'ruleeditform__action' => 'Ενέργεια',
    'ruleeditform__action_allow' => 'Να επιτραπεί',
    'ruleeditform__action_deny' => 'Απόρριψη',
    'ruleeditform__from' => 'Απομακρυσμένες διευθύνσεις',
    'ruleeditform__from_add' => 'Προσθήκη διεύθυνσης IP ή δικτύου:',
    'ruleeditform__profiles_hint' => 'Πρέπει να καθορίσετε τουλάχιστον ένα προφίλ.',
    'ruleeditform__port_hint' => 'Για παράδειγμα: 1000 ή 1000-1051',
    'ruleeditform__from_hint' => 'Για παράδειγμα: 192.168.0.1 ή 192.168.0.0/16',
    'ruleeditform__ip_any' => 'Όλες',
    'firewall_from_add' => 'Προσθήκη',
    'firewall_from_remove' => 'Κατάργηση',
    'firewall_from_clear' => 'Εκκαθάριση λίστας',
    'bt_firewall_from_add' => 'Προσθήκη',
    'bt_firewall_from_remove' => 'Κατάργηση',
    'bt_firewall_from_clear' => 'Εκκαθάριση λίστας',
    'ruleeditform__name_is_required' => 'Καθορίστε το όνομα του κανόνα.',
    'ruleeditform__profiles_is_required' => 'Επιλέξτε τουλάχιστον ένα προφίλ.',
    'ruleeditform__invalid_action' => 'Η καθορισμένη ενέργεια δεν είναι έγκυρη. Οι τιμές που μπορούν να χρησιμοποιηθούν είναι "Αποδοχή" ή "Απόρριψη".',
    'ruleeditform__invalid_ip' => 'Η καθορισμένη διεύθυνση IP ή δικτύου δεν είναι έγκυρη.',
    'ruleeditform__invalid_protocol' => 'Το καθορισμένο πρωτόκολλο δεν είναι έγκυρο. Οι τιμές που μπορούν να χρησιμοποιηθούν είναι "udp" ή "tcp".',
    'ruleeditform__invalid_port' => 'Η καθορισμένη θύρα δεν είναι έγκυρη. Οι τιμές που μπορούν να χρησιμοποιηθούν είναι 1000 ή 1000-1051',
    'firewall__panic_configuration' => 'Είστε βέβαιοι ότι θέλετε να ενεργοποιήσετε τη λειτουργία πανικού;  Οι χρήστες δεν θα έχουν τη δυνατότητα πρόσβασης στους τομείς τους.',
    'firewall__reset_configuration' => 'Είστε βέβαιοι ότι θέλετε να επαναφέρετε τις ρυθμίσεις του τείχους προστασίας στις προεπιλεγμένες τιμές τους;',
    'rulelist__remove_selected' => 'Θέλετε να καταργήσετε τους επιλεγμένους κανόνες;',

    'filemanager__items' => 'στοιχεία στον κατάλογο %1',
    'filemanager__items_paging' => 'στοιχεία στον κατάλογο %1',

    'get_password__encrypted_password' => "Δεν είναι δυνατή η αποστολή των πληροφοριών κωδικού πρόσβασης: ο κωδικός πρόσβασης έχει αποθηκευτεί σε κρυπτογραφημένη μορφή.",
    'get_password__mail_error' => "Παρουσιάστηκε σφάλμα κατά την προσπάθεια αποστολής του κωδικού πρόσβασης στη διεύθυνση ηλεκτρονικού ταχυδρομείου %1: %2",
    'get_password__mail_ok' => "Ο κωδικός πρόσβασης εστάλη επιτυχώς στη διεύθυνση ηλεκτρονικού ταχυδρομείου: %1",
    'get_password__message' => "Το όνομα χρήστη σας για την πρόσβαση στο σύστημα: %1\n Ο κωδικός πρόσβασής σας είναι %2",
    'get_password__subject' => "Κωδικός πρόσβασης για την πρόσβαση στο σύστημα",
    'groups__available' => "Διαθέσιμες ομάδες αλληλογραφίας",
    'groups__groups_for_mailname' => "Ομάδες αλληλογραφίας στις οποίες είναι εγγεγραμμένος ο λογαριασμός αλληλογραφίας %1",
    'groups__member_of' => "Μέλος των παρακάτω ομάδων αλληλογραφίας",
    'help__help_area' => "Περιοχή βοήθειας.",
    'hst_def__auth_disabled' => "απαγορεύεται",
    'hst_def__auth_enabled' => "επιτρέπεται",
    'hst_def__change_curr_dns_ip' => "Η τρέχουσα διεύθυνση IP της εγγραφής A DNS θα αλλάξει",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Καμία από τις διευθύνσεις IP της εγγραφής A DNS δεν συμφωνεί με τη διεύθυνση IP που έχει εκχωρηθεί στο λογαριασμό φιλοξενίας που δημιουργείται",
    'hst_def__dest_url' => "Διεύθυνση URL προορισμού",
    'hst_def__disk_quota' => "Όριο δίσκου",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Το όριο χώρου στο δίσκο που προσπαθείτε να θέσετε έχει ξεπεραστεί από το όριο χώρου στο δίσκο του καταλόγου εισερχομένων ανώνυμου FTP.  Το όριο χώρου στο δίσκο στον κατάλογο εισερχομένων ανώνυμου FTP δεν πρέπει να υπερβαίνει το όριο χώρου στο δίσκο του τομέα.",
    'hst_def__frame_forwarding_definition' => "Εκχώρηση κρυμμένης ανακατεύθυνσης για τον τομέα %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Προειδοποίηση: Ο χρήστης FTP %1 χρησιμοποιείται στις ρυθμίσεις του λογαριασμού φιλοξενίας, αλλά δεν υπάρχει στο σύστημα.",
    'hst_def__hst_type_is_not_defined' => "Ο τύπος φιλοξενίας δεν έχει καθοριστεί",
    'hst_def__ip_based' => "Βάσει IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "Η μεταφορά αυτού του λογαριασμού φιλοξενίας στην κοινόχρηστη διεύθυνση IP θα καταστήσει μη διαθέσιμη την υπηρεσία ανώνυμου FTP σε αυτόν τον τομέα.  Θέλετε να συνεχίσετε ούτως ή άλλως;",
    'hst_def__password_is_invalid_password_syntax' => "Ο κωδικός πρόσβασης δεν είναι έγκυρος.\n Μην χρησιμοποιείτε μονά εισαγωγικά και εθνικούς αλφαβητικούς χαρακτήρες στον κωδικό πρόσβασης.\n Ο κωδικός πρόσβασης πρέπει να αποτελείται από 5 έως 14 χαρακτήρες. Ο κωδικός πρόσβασης δεν πρέπει να περιέχει το όνομα χρήστη.",
    'hst_def__shell' => "Πρόσβαση SSH στο κέλυφος του διακομιστή από το χρήστη συστήματος της συνδρομής",
    'hst_def__shell_windows' => "Πρόσβαση μέσω απομακρυσμένης επιφάνειας εργασίας στο διακομιστή από το χρήστη συστήματος της συνδρομής",
    'hst_def__standard_forwarding_definition' => "Εκχώρηση τυπικής ανακατεύθυνσης για τον τομέα %1",
    'hst_def__title_name_based' => "Βάσει ονόματος",
    'hst_def__unable_create/update_physic_hst' => "Δεν είναι δυνατή η δημιουργία/ενημέρωση θύρας της φυσικής φιλοξενίας: %1",
    'hst_def__unable_create/update_std_fwd' => "Δεν είναι δυνατή η δημιουργία/ενημέρωση θύρας της τυπικής ανακατεύθυνσης: %1",
    'hst_def__unable_create_forwarding_myself' => "Δεν είναι δυνατή η δημιουργία ανακατεύθυνσης στον ίδιο τον τομέα.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Δεν είναι δυνατόν να επιτραπεί η χρήση ενός ενιαίου καταλόγου για την αποθήκευση SSL/TLS και μη-SSL/TLS περιεχομένου: Η υποστήριξη SSL είναι ενεργοποιημένη.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Δεν είναι δυνατή η ενεργοποίηση της υποστήριξης SSL/TLS: δεν έχει εγκατασταθεί πιστοποιητικό SSL/TLS.",
    'hst_def__url_is_invalid' => "Η διεύθυνση URL δεν είναι έγκυρη.",
    'hst_def__virtual_host_access' => "Πρόσβαση εικονικού κεντρικού υπολογιστή για τον τομέα %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ΠΡΟΕΙΔΟΠΟΙΗΣΗ. Αυτός ο εικονικός κεντρικός υπολογιστής χρησιμοποιεί μια ανύπαρκτη διεύθυνση IP για τη φιλοξενία.",
    'hst_def__you_have_no_ips' => "Δεν έχετε διαθέσιμες διευθύνσεις IP και δεν επιτρέπεται να δημιουργήσετε φιλοξενία βάσει ονόματος.",
    'hst_sel__header' => "Για να φιλοξενήστε μια τοποθεσία web σε αυτόν το διακομιστή, επιλέξτε τη Φυσική φιλοξενία.\n Για να ρυθμίσετε την ανακατεύθυνση του τομέα σε μια τοποθεσία σε ένα άλλο μηχάνημα, επιλέξτε Κρυμμένη ανακατεύθυνση ή Τυπική ανακατεύθυνση.\n Με την τυπική ανακατεύθυνση, ο χρήστης ανακατευθύνεται στην τοποθεσία και η πραγματική διεύθυνση URL της τοποθεσίας εμφανίζεται στο πρόγραμμα περιήγησής του, έτσι ώστε ο χρήστης να γνωρίζει ότι πραγματοποιείται ανακατεύθυνση. Με την κρυμμένη ανακατεύθυνση, ο χρήστης ανακατευθύνεται στην τοποθεσία χωρίς να γνωρίζει ότι η τοποθεσία βρίσκεται σε άλλη θέση.",
    'hst_sel__physical_hst' => "Φυσική φιλοξενία",
    'hst_sel__select_hst_type' => "Επιλέξτε τον τύπο φιλοξενίας για τον τομέα",
    'hst_sel__select_hst_type_warning' => "Επιλέξτε τον τύπο φιλοξενίας για τον τομέα",
    'hst_sel__hosting_exists' => "Δεν είναι δυνατή η δημιουργία φιλοξενίας, καθώς έχει διαμορφωθεί ήδη γι' αυτόν τον τομέα. Θα μεταφερθείτε στη σελίδα διαχείρισης φιλοξενίας.",
    'hst_sel__standard_frw' => "Τυπική ανακατεύθυνση",
    'hst_sel__frame_frw' => "Κρυμμένη ανακατεύθυνση",
    '__frame_frw' => "Κρυμμένη ανακατεύθυνση",
    '__hosting_exists' => "Δεν είναι δυνατή η δημιουργία φιλοξενίας, καθώς έχει διαμορφωθεί ήδη γι' αυτόν τον τομέα. Θα μεταφερθείτε στη σελίδα διαχείρισης φιλοξενίας.",
    '__choose_hst_type' => "Επιλέξτε τον απαιτούμενο τύπο φιλοξενίας.",
    '__no_hst_conf' => "Δεν έχει ρυθμιστεί φιλοξενία για τον τομέα σας.",
    '__physical_hst' => "Φυσική φιλοξενία",
    '__select_hst_type' => "Επιλέξτε τον τύπο φιλοξενίας για τον τομέα",
    '__standard_frw' => "Τυπική ανακατεύθυνση",
    '__warning' => "Προειδοποίηση! Όλες οι παράμετροι που έχουν οριστεί προηγουμένως θα απορριφθούν. Είστε βέβαιοι ότι θέλετε να αλλάξετε τον τύπο φιλοξενίας;",
    'i_cl_off' => "Ο πελάτης είναι ανενεργός.",
    'i_cl_off_by_admin' => "Ο λογαριασμός πελάτη έχει ανασταλεί από το διαχειριστή του διακομιστή.",
    'i_cl_off_expired' => "Ο λογαριασμός πελάτη έχει λήξει.",
    'i_cl_on' => "Ο πελάτης είναι ενεργός.",

    'icf__title' => 'Τείχος προστασίας Internet',
    'icf__if_legend' => 'Διασυνδέσεις',
    'icf__mode' => 'Λειτουργία',

    'invalid_value' => 'Η τιμή δεν είναι έγκυρη',

    'ip_addr__already_exists' => "Η διεύθυνση IP %1 υπάρχει ήδη.",
    'ip_addr__cant_add' => "Η διεύθυνση IP %1 δεν υπάρχει ή ανήκει στο χώρο IP ενός άλλου πελάτη",
    'ip_addr__cl_list_for_ip' => "Μεταπωλητές που χρησιμοποιούν %1 διεύθυνση IP %2",
    'ip_addr__cl_list_for_ip_add' => "Προσθήκη της διεύθυνσης IP στο χώρο συγκέντρωσης του μεταπωλητή",
    'ip_addr__domains_list_for_ip' => "Τοποθεσίες web που χρησιμοποιούν %1 διεύθυνση IP %2",
    'ip_addr__ip_used_by_hst_or_frw' => "Η διεύθυνση IP %1 χρησιμοποιείται για φιλοξενία ή ανακατεύθυνση.",
    'ip_addr__only_one_ip_and_client_have_domain' => "Δεν είναι δυνατή η κατάργηση αυτής της διεύθυνσης IP επειδή υπάρχουν τομείς που φιλοξενούνται σε αυτήν.",
    'ip_addr__remove_ip_addr' => "Αυτές οι διευθύνσεις ΙΡ θα καταργηθούν από το σύστημα:",
    'ip_addr__select_clients' => "Επιλέξτε πελάτες",
    'ip_addr__select_ip_addr_to_remove' => "Επιλέξτε τη διεύθυνση IP που θα καταργηθεί.",
    'ip_addr__unallowed_by_license' => "Αυτό το αντίγραφο του Plesk δεν διαθέτει άδεια για χρήση με τη διεύθυνση IP %1.\nΟι επιτρεπόμενες περιοχές IP είναι: %2.",
    'ip_alias__interface' => "Διασύνδεση",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "Η διεύθυνση IP %1 για την εικονική φιλοξενία βάσει ονόματος είναι άκυρη.",
    'ip_alias__invalid_ip_or_netmask' => "Μη έγκυρος ζεύγος διεύθυνσης IP/μάσκας δικτύου.",
    'ip_alias__orig_ip_can_not_be_deleted' => "Η διεύθυνση IP %1 είναι η αρχική διεύθυνση IP του διακομιστή και, συνεπώς, δεν μπορείτε να την καταργήσετε.",
    'ip_alias__ip_is_invalid' => "Η διεύθυνση IP %1 δεν είναι έγκυρη.",
    'ip_alias__ip_mask_is_invalid' => "Η μάσκα IP %1 δεν είναι έγκυρη.",
    'ip_alias__ip_not_exist' => "Η διεύθυνση IP %1 δεν υπάρχει.",
    'ip_alias__ip_address_and_mask' => 'Διεύθυνση IP και Μάσκα υποδικτύου',
    'ip_alias__mask' => "Μάσκα υποδικτύου",
    'ip_alias__remove_selected_ip_aliases?' => "Είστε βέβαιοι ότι θέλετε να καταργήσετε τις επιλεγμένες διευθύνσεις IP;",
    'ip_alias__select_ip' => "Επιλέξτε τουλάχιστον μία διεύθυνση IP από τη λίστα για να την καταργήσετε.",
    'ip_alias__this_ip_used_for_domain' => "(%1) αυτή η διεύθυνση IP χρησιμοποιείται για τον τομέα %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) αυτή η διεύθυνση IP χρησιμοποιείται για εικονικούς κεντρικούς υπολογιστές βάσει ονόματος.",
    'ip_alias__unable_add_ip' => "Δεν είναι δυνατή η προσθήκη της IP: %1",
    'ip_alias__unable_remove_ip' => "Δεν είναι δυνατή η κατάργηση της IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Δεν μπορείτε να αλλάξετε τον τύπο της διεύθυνσης IP σε κοινόχρηστη, καθώς έτσι θα καταστεί μη διαθέσιμο το ανώνυμο FTP για τον τομέα '%1'.",
    'ip_ctrl__ip_addr' => "Διεύθυνση IP %2 στη διασύνδεση %1",
    'ip_ctrl__ip_exists_many_pools' => "Δεν μπορείτε να αλλάξετε τον τύπο της IP.  Αυτή η IP διεύθυνση ανήκει στους χώρους πολλών χρηστών ταυτόχρονα.",
    'ip_ctrl__ssl_cert' => "Πιστοποιητικό SSL/TLS",
    'ip_pool__ip_address_is_absend_in_pool' => "Η διεύθυνση ΙΡ λείπει.",
    'ip_pool__ip_pool_for_client' => "Χώρος IP του πελάτη %1",
    'ip_pool__no_cliens_avail' => "Δεν υπάρχουν διαθέσιμοι πελάτες.",
    'ip_pool__no_vacant_ips' => "Δεν υπάρχουν ελεύθερες IP.",
    'ip_pool__pool_is_empty' => "Ο χώρος IP είναι κενός.",
    'ip_pool__remove_ip_addr' => "Αυτές οι διευθύνσεις ΙΡ θα καταργηθούν από το χώρο %1:",
    'ip_pool__select_free_ips' => "Ελεύθερες IP",
    'limit__date_in_past' => "Η περίοδος ισχύος δεν είναι έγκυρη.  Το %1 είναι στο παρελθόν.",
    'limit__enter_date' => "Εισαγάγετε ημερομηνία",
    'limit__max_db' => "Βάσεις δεδομένων",
    'limit__name_disk_space' => "χώρος στο δίσκο",
    'limit__name_max_box' => "γραμματοκιβώτια",
    'limit__name_max_db' => "Βάσεις δεδομένων MySQL",
    'limit__name_max_dom' => "τομείς",
    'limit__name_max_maillists' => "λίστες αλληλογραφίας",
    'limit__name_max_subdom' => "υποτομείς",
    'limit__name_max_traffic' => "κίνηση",
    'limit__name_max_wu' => "χρήστεσ web",
    'limit__name_mbox_quota' => "όριο γραμματοκιβωτίου",
    'limit__name_max_mn' => "λογαριασμοί αλληλογραφίας",
    'limit__name_max_cl' => 'πελάτες',
    'limit__name_total_mboxes_quota' => "όριο συνόλου γραμματοκιβωτίων",
    'limit__name_mysql_dbase_space' => "Χώρος στη βάση δεδομένων MySQL",
    'limit__name_mssql_dbase_space' => "Χώρος στη βάση δεδομένων MSSQL",
    'limit__name_expiration' => 'ημερομηνία λήξης',

    'locale_upload__title' => 'Προσθήκη τοπικών ρυθμίσεων',
    'locale_upload__file_name' => 'Διαδρομή προς τη θέση του αρχείου του πακέτου γλωσσών',
    'locale_upload__unable_to_install' => 'Δεν είναι δυνατή η εγκατάσταση του αρχείου του πακέτου γλωσσών',
    'locale_upload__wrong_package' => 'Το αρχείο που αποστείλατε δεν περιέχει έγκυρο πακέτο γλώσσας γι\' αυτήν την έκδοση του Plesk.',
    'locale_upload__wrong_locale' => 'Το αρχείο που αποστείλατε δεν περιέχει έγκυρο πακέτο γλωσσών.',

    'locales_remove__title' => 'Κατάργηση τοπικών ρυθμίσεων',
    'locales_remove__select_locales_for_remove' => 'Επιλέξτε τις τοπικές ρυθμίσεις που θα καταργηθούν.',
    'locales__can_not_remove' => 'Δεν είναι δυνατή η κατάργηση του πακέτου γλωσσών για τις τοπικές ρυθμίσεις %1: %2',

    'ma__create_title' => 'Δημιουργία ψευδωνύμου αλληλογραφίας για το %1',
    'ma__edit_title' => "Επεξεργασία ψευδωνύμου αλληλογραφίας %1",
    'ma__enter_new_alias' => "Εισαγωγή νέου ψευδωνύμου αλληλογραφίας.",
    'ma__invalid_alias' => "Μη έγκυρο ψευδώνυμο αλληλογραφίας.",
    'ma__mail_aliases_mailname' => "Ψευδώνυμα αλληλογραφίας για το λογαριασμό ηλεκτρονικού ταχυδρομείου %1",
    'ma__mailname_does_not_exist' => "Ο λογαριασμός αλληλογραφίας δεν υπάρχει.",
    'ma__select_ma_for_remove' => "Επιλέξτε τα ψευδώνυμα αλληλογραφίας που θα καταργηθούν.",
    'ma__unable_to_add_new_ma' => "Δεν είναι δυνατή η προσθήκη ψευδωνύμου αλληλογραφίας: %1",

    'mail__white_list' => "Λίστα επιτρεπόμενων",
    'mail__white_list_add' => 'Προσθήκη δικτύου',
    'mail__white_list_remove' => 'Τα παρακάτω δίκτυα θα καταργηθούν:',
    'mail__white_list_remove_warning_webmail' => 'Η κατάργηση των παρακάτω δικτύων μπορεί να καταστήσει αδύνατη την αποστολή μηνυμάτων ηλεκτρονικού ταχυδρομείου από το webmail: %1.',
    'mail__white_list_member' => 'Επιτρεπόμενα δίκτυα',
    'mail__white_list_empty_selection_for_remove' => 'Επιλέξτε τις καταχωρήσεις που θα καταργηθούν.',
    'mail_queue__not_allowed_by_license_key' => 'Η διαχείριση της ουράς αλληλογραφίας δεν επιτρέπεται από το κλειδί άδειας χρήσης.',
    'maillist__' => "Λίστα αλληλογραφίας %1",
    'maillist__already_exists' => "Η λίστα αλληλογραφίας υπάρχει ήδη.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Το ψευδώνυμο αλληλογραφίας %1 υπάρχει ήδη σε αυτόν τον τομέα",
    'maillists__' => "Λίστες αλληλογραφίας %1",
    'maillists__limit_cl_max_maillists' => "Συμπληρώθηκε το όριο του αριθμού λιστών αλληλογραφίας για τον πελάτη (όριο: %1, χρησιμοποιούνται: %2)",
    'maillists__limit_dom_max_maillists' => "Συμπληρώθηκε το όριο του αριθμού λιστών αλληλογραφίας για τον τομέα.",
    'maillists__list' => "Λίστες αλληλογραφίας",
    'maillists__mailman_not_installed_or_conf' => "Οι επεκτάσεις του διακομιστή Mailman δεν είναι εγκατεστημένες ή δεν έχουν ρυθμιστεί\n στο διακομιστή.  Επικοινωνήστε με το διαχειριστή του διακομιστή για την εγκατάσταση ή τη σωστή ρύθμιση των επεκτάσεων του διακομιστή Mailman.",
    'maillists__status' => "Η υπηρεσία λιστών αλληλογραφίας είναι ενεργοποιημένη",
    'maillists__unable_to_delete__' => "Δεν είναι δυνατή η διαγραφή της λίστας αλληλογραφίας: %1",
    'maillists__disabled_text' => 'Δεν μπορείτε να διαχειριστείτε τις λίστες αλληλογραφίας επειδή το στοιχείο λιστών αλληλογραφίας Mailman του διακομιστή δεν είναι εγκατεστημένο ή δεν έχει ρυθμιστεί.',
    'maillist_member__already_exists' => 'Ο συνδρομητής λίστας αλληλογραφίας υπάρχει ήδη.',
    'maillist_member__not_exists' => 'Δεν υπάρχει τέτοιος χρήστης στη λίστα αλληλογραφίας.',
    'mailserver_switching_warning' => "Προειδοποίηση!\n\n Η αλλαγή του διακομιστή αλληλογραφίας προορίζεται μόνο για την αρχική εγκατάσταση και, εάν ο διακομιστής είναι ήδη σε χρήση, προκαλεί τα εξής προβλήματα: απώλεια ρυθμίσεων και περιεχομένου γραμματοκιβωτίων και, σε περίπτωση που ο νέος διακομιστής έχει ρυθμιστεί ήδη, διάφορες διενέξεις.\n Εάν ο διακομιστής είναι σε χρήση τη δεδομένη στιγμή και είστε βέβαιοι ότι θέλετε να μεταβείτε σε άλλον, μπορείτε να ενημερώσετε τους πελάτες σας σχετικά με αυτήν την αλλαγή για να έχουν τη δυνατότητα λήψης και αποθήκευσης της αλληλογραφίας τους.",
    'manager__access_denied' => "Δεν επιτρέπεται η πρόσβαση: %1",
    'manager__admin' => "Διαχειριστής",
    'manager__client' => 'Πελάτης',
    'manager__domain' => "τομέας",
    'manager__domain_cl_limit_exceeding' => "Συμπληρώθηκε το όριο αριθμού τομέων γι' αυτόν το λογαριασμό πελάτη.",
    'manager__domain_is_not_yours' => "Ο τομέας %1 δεν ανήκει σε εσάς.",
    'manager__domain_key_limit_exceeding' => "Συμπληρώθηκε το όριο δημιουργίας τομέων με βάση το κλειδί άδειας χρήσης σας.",
    'manager__no_perm_to_call' => "Δεν έχετε δικαίωμα κλήσης του %1.",
    'manager__no_perm_to_create_domains' => "Δεν έχετε δικαίωμα δημιουργίας τομέων.",
    'manager__no_perm_to_modify_domain' => "Δεν έχετε δικαίωμα τροποποίησης του τομέα %1.",
    'manager__no_perm_to_modify_domains' => "Δεν έχετε δικαίωμα τροποποίησης τομέων.",
    'manager__no_perm_to_remove_domain' => "Δεν έχετε δικαίωμα κατάργησης του τομέα %1.",
    'manager__no_perm_to_remove_domains' => "Δεν έχετε δικαίωμα κατάργησης τομέων.",
    'manager__node_doesnt_exist' => "Το %1 δεν υπάρχει.",
    'manager__user_disabled' => "Ο λογαριασμός σας έχει ανασταλεί. Δεν μπορείτε να χειριστείτε το σύστημα.",
    'mail_quota_unsupported' => "δεν υποστηρίζεται από το διακομιστή αλληλογραφίας",
    'mbox_quota_unsupported' => "δεν υποστηρίζεται από το διακομιστή αλληλογραφίας",
    'mn__create_title' => "Δημιουργία λογαριασμού αλληλογραφίας",
    'mn__edit_title' => "Ρυθμίσεις",
    'mn__files_list_title' => "Συνημμένα αρχεία",
    'mn__files_remove' => "Κατάργηση αρχείων από το αποθετήριο συνημμένων.  Τα αρχεία αυτά ενδεχομένως να χρησιμοποιούνται σε αυτόματες απαντήσεις. Θα καταργηθούν τόσο από το αποθετήριο όσο και από τις αυτόματες απαντήσεις που τα χρησιμοποιούν.",
    'mn__files_select_for_remove' => "Επιλέξτε τα αρχεία που θα καταργηθούν.",
    'mn__mail_alias_form' => "Μορφή ψευδωνύμου αλληλογραφίας",
    'mn__mail_aliases_list' => "Ψευδώνυμα αλληλογραφίας",
    'mn__mailbox' => "Διαχείριση γραμματοκιβωτίου",
    'mn__unable_define_mn' => "Δεν είναι δυνατή η δημιουργία λογαριασμών αλληλογραφίας: %1",
    'mn__unable_remove_mbox_quota' => "Δεν είναι δυνατή η κατάργηση του ορίου γραμματοκιβωτίου: %1",
    'mn__upload_file' => "Αποστολή αρχείου",
    'mn_edit__attach_filename_changed' => 'Το απεσταλμένο αρχείο %1 μετονομάστηκε σε %2 επειδή το όνομά του περιείχε μη-ASCII χαρακτήρες.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Πρέπει να προσθέσετε ένα μέλος στην ομάδα αλληλογραφίας πριν την ενεργοποιήσετε.",
    'mn_edit__add_resp_or_turn_off_box' => "Πρέπει να προσθέσετε μια αυτόματη απάντηση ή να καταργήσετε την επιλογή του πλαισίου ελέγχου αυτόματης απάντησης.",
    'mn_edit__attachments' => "Συνημμένα",
    'mn_edit__dom_quota_less_then_quota' => "Το μέγεθος αυτού του γραμματοκιβωτίου δεν πρέπει να υπερβαίνει το όριο χώρου στο δίσκο που διατίθεται για τα γραμματοκιβώτια σε αυτόν τον τομέα.",
    'mn_edit__enter_external_rcpnt_email' => "Εισαγάγετε τη διεύθυνση ηλεκτρονικού ταχυδρομείου του εξωτερικού μέλους της ομάδας αλληλογραφίας",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Πληκτρολογήστε μια διεύθυνση για την προώθηση της αλληλογραφίας ή καταργήστε την επιλογή του πλαισίου ελέγχου.",
    'mn_edit__ext_rcpnt_email_invalid' => "Η διεύθυνση ηλεκτρονικού ταχυδρομείου του εξωτερικού παραλήπτη δεν είναι έγκυρη.",
    'mn_edit__file_exists' => "Το αρχείο υπάρχει. Να αντικατασταθεί;",
    'mn_edit__files_deld_from_repository' => "Αυτά τα αρχεία θα διαγραφούν από το αποθετήριο, όπως επίσης και οι αυτόματες απαντήσεις που τα περιέχουν. Θέλετε να προχωρήσετε;",
    'mn_edit__mail_name' => "Λογαριασμός αλληλογραφίας",
    'mn_edit__mail_name_invalid' => "Το όνομα του λογαριασμού αλληλογραφίας δεν είναι έγκυρο.",
    'mn_edit__mail_redir' => "Διακομιστές προώθησης αλληλογραφίας",
    'mn_edit__mail_redir_add' => "Προσθήκη μέλους ομάδας αλληλογραφίας",
    'mn_edit__mail_resps' => "Αυτόματες απαντήσεις αλληλογραφίας",
    'mn_edit__mailbox' => "Γραμματοκιβώτιο",
    'mn_edit__enable_mailbox' => "Γραμματοκιβώτιο",
    'mn_edit__mailgroup' => "Ομάδα αλληλογραφίας",
    'mn_edit__mailgroup_addresses' => "Μέλη ομάδας αλληλογραφίας",
    'mn_edit__mailgroup_disabled' => "Διατίθεται μόνο όταν έχει προστεθεί ήδη ο λογαριασμός αλληλογραφίας.",
    'mn_edit__max_dom_quota' => "Προεπιλογή για τον τομέα (%1)",
    'mn_edit__mbox_quota_invalid' => "Καθορίστηκε λανθασμένο μέγεθος γραμματοκιβωτίου.",
    'mn_edit__new_resp_name' => "Όνομα νέας αυτόματης απάντησης",
    'mn_edit__no_autoresponders' => "Πρέπει να προσθέσετε τουλάχιστον μία αυτόματη απάντηση πριν ενεργοποιήσετε/απενεργοποιήσετε την υπηρεσία αυτόματης απάντησης.",
    'mn_edit__no_file_sel' => "Δεν έχουν επιλεγεί αρχεία.",
    'mn_edit__no_mail_addresses' => "Δεν καθορίστηκαν ή επιλέχθηκαν διευθύνσεις ηλεκτρονικού ταχυδρομείου.",
    'mn_edit__none' => "Καμία",
    'mn_edit__not_create_pass' => "Με αυτόν τον τρόπο δεν θα δημιουργηθεί κωδικός πρόσβασης για το συγκεκριμένο λογαριασμό.\n Χωρίς κωδικό πρόσβασης, ο χρήστης δεν θα είναι σε θέση να δει και να στείλει μηνύματα ηλεκτρονικού ταχυδρομείου.",
    'mn_edit__redir_email_invalid' => "Η διεύθυνση προώθησης δεν είναι έγκυρη.",
    'mn_edit__redirect_addr' => "Διεύθυνση προώθησης",
    'mn_edit__remove_autoresp?' => "Είστε βέβαιοι ότι θέλετε να καταργήσετε την αυτόματη απάντηση;",
    'mn_edit__remove_rcpnts?' => "Είστε βέβαιοι ότι θέλετε να καταργήσετε αυτούς τους παραλήπτες;",
    'mn_edit__repository' => "Αποθετήριο δεδομένων",
    'mn_edit__resps_attach' => "Συνημμένα αρχεία αυτόματης απάντησης",
    'mn_edit__select_rcpnt_from_list' => "Επιλέξτε τουλάχιστον έναν παραλήπτη από τη λίστα για να τον καταργήσετε.",
    'mn_edit__select_registered_users' => "Επιλογή καταχωρημένων χρηστών",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Έχετε επιλέξει να έχετε γραμματοκιβώτιο, αλλά δεν έχετε δημιουργήσει κωδικό πρόσβασης γι' αυτό.",
    'mn_edit__unable_act_deact_mail_group' => "Δεν είναι δυνατή η ενεργοποίηση ή απενεργοποίηση της ομάδας αλληλογραφίας: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Δεν είναι δυνατή η ενεργοποίηση ή απενεργοποίηση της προώθησης αλληλογραφίας: %1",
    'mn_edit__unable_act_deact_postbox' => "Δεν είναι δυνατή η ενεργοποίηση ή απενεργοποίηση του γραμματοκιβωτίου: %1",
    'mn_edit__unable_act_deact_resp' => "Δεν είναι δυνατή η ενεργοποίηση ή απενεργοποίηση των αυτόματων απαντήσεων: %1",
    'mn_edit__unable_add_attach' => "Δεν είναι δυνατή η προσθήκη συνημμένου αρχείου: %1",
    'mn_edit__unable_add_mail_group_member' => "Δεν είναι δυνατή η προσθήκη μέλους στην ομάδα αλληλογραφίας: %1",
    'mn_edit__unable_add_resp' => "Δεν είναι δυνατή η προσθήκη αυτόματης απάντησης: %1",
    'mn_edit__unable_change_mail_name' => "Δεν είναι δυνατή η αλλαγή του ονόματος του λογαριασμού αλληλογραφίας: %1",
    'mn_edit__unable_deactivate_mail_group' => "Δεν είναι δυνατή η απενεργοποίηση της ομάδας αλληλογραφίας: %1",
    'mn_edit__unable_deactivate_resp' => "Δεν είναι δυνατή η απενεργοποίηση των αυτόματων απαντήσεων: %1",
    'mn_edit__unable_define_resp_id' => "Δεν είναι δυνατός ο καθορισμός του αναγνωριστικού αυτόματης απάντησης: %1",
    'mn_edit__unable_remove_attach' => "Δεν είναι δυνατή η κατάργηση του(ων) συνημμένου(ων) αρχείου(ων): %1",
    'mn_edit__unable_remove_autoresp' => "Δεν είναι δυνατή η κατάργηση της αυτόματης απάντησης: %1",
    'mn_edit__unable_remove_mail_group_member' => "Δεν είναι δυνατή η κατάργηση μελών της ομάδας αλληλογραφίας: %1",
    'mn_edit__wrong_way' => 'Τα μηνύματα που απευθύνονται στο %1 δεν θα παραδίδονται, καθώς ο συγκεκριμένος λογαριασμός αλληλογραφίας δεν διαθέτει ενεργοποιημένο γραμματοκιβώτιο ή διακομιστή προώθησης αλληλογραφίας.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Το γραμματοκιβώτιο στη διεύθυνση %1 απενεργοποιήθηκε.  Τα μηνύματα στο γραμματοκιβώτιο δεν καταργήθηκαν, αλλά δεν θα έχετε τη δυνατότητα να τα ανακτήσετε μέσω του πρωτοκόλλου IMAP ή POP3.',
    'mn_list__mail_names_for_domain' => "Λογαριασμοί αλληλογραφίας του τομέα %1",
    'mn_list__sa_cannot_unable' => "Δεν είναι δυνατή η ενεργοποίηση του φιλτραρίσματος ανεπιθύμητης αλληλογραφίας",
    'mn_list__tab_cp_access' => "Τ",
    'mn_list__tab_title_client' => 'Πελάτης',
    'mn_list__tab_title_domain' => 'τομέας',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "Π",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Όνομα",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "Κ",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Δεν είναι δυνατή η κατάργηση των λογαριασμών αλληλογραφίας: %1",
    'no_psa_mails_matched' => "Δεν υπάρχουν λογαριασμοί ηλεκτρονικού ταχυδρομείου που συμφωνούν με την καθορισμένη συμβολοσειρά μοτίβου.",
    'module_upload__module_was_installed' => 'Αυτή η λειτουργική μονάδα είναι ήδη εγκατεστημένη. Εάν θέλετε να εγκαταστήσετε μια νεότερη έκδοση αυτής της λειτουργικής μονάδας, καταργήστε την εγκατάσταση της μονάδας μέσω του Plesk και, στη συνέχεια, προχωρήστε στην εγκατάσταση της νέας έκδοσης.',
    'module_upload__unable_to_install' => 'Δεν είναι δυνατή η εγκατάσταση του αρχείου του πακέτου λειτουργικής μονάδας',
    'module_upload__wrong_package' => 'Το απεσταλμένο αρχείο δεν είναι υποστηριζόμενο πακέτο λειτουργικής μονάδας.',
    'module_upload__wrong_module' => 'Το απεσταλμένο αρχείο δεν περιέχει πακέτο λειτουργικής μονάδας.',

    'news_articles_title' => 'Νέα του Plesk',
    'notification_text__invalid_subject_length' => "Μη έγκυρο μήκος του θέματος της ειδοποίησης. Πρέπει να αποτελείται από 1 έως 255 χαρακτήρες.",
    'notification_text__invalid_text_length' => "Μη έγκυρο μήκος του κειμένου της ειδοποίησης. Πρέπει να αποτελείται από 1 έως 65.533 χαρακτήρες.",
    'notification_text__subject' => "Θέμα ειδοποίησης",
    'notification_text__text' => "Κείμενο ειδοποίησης",
    'notification_text__title' => "Επεξεργασία ειδοποίησης",
    'notification_text__unable_set_text' => "Δεν είναι δυνατή η τροποποίηση του κειμένου της ειδοποίησης:",

    'odbc__cant_add_dsn' => "Δεν είναι δυνατή η προσθήκη του DSN %1: %2",
    'odbc__cant_build_connection_string' => "Δεν είναι δυνατή η σύνδεση χρησιμοποιώντας τις καθορισμένες παραμέτρους, προσπαθήστε ξανά χρησιμοποιώντας διαφορετικές παραμέτρους.  Το βοηθητικό πρόγραμμα επέστρεψε: %1",
    'odbc__cant_connect' => "Δεν είναι δυνατή η σύνδεση με την προέλευση δεδομένων χρησιμοποιώντας τις καθορισμένες ρυθμίσεις.  Ο διακομιστής επέστρεψε: %1",
    'odbc__cant_delete_dsn' => "Δεν είναι δυνατή η διαγραφή του DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Δεν είναι δυνατή η λήψη πληροφοριών σχετικά με τα προγράμματα οδήγησης.",
    'odbc__cant_get_drivers' => "Δεν είναι δυνατή η ανάκτηση μιας λίστας προγραμμάτων οδήγησης ODBC: %1",
    'odbc__cant_get_list' => "Δεν είναι δυνατή η ανάκτηση μιας λίστας με τα υπάρχοντα DSN: %1",
    'odbc__cant_get_servers_list' => "Δεν είναι δυνατή η ανάκτηση μιας λίστας διακομιστών.",
    'odbc__cant_open_info_file' => "Δεν είναι δυνατό το άνοιγμα του αρχείου με τις πληροφορίες σχετικά με τα προγράμματα οδήγησης ODBC.",
    'odbc__cant_parse_string' => "Δεν είναι δυνατή η ανάλυση της συμβολοσειράς σύνδεσης.",
    'odbc__connect_success' => "Επιτυχημένη σύνδεση",
    'odbc__driver_not_set' => "Δεν έχει οριστεί το πρόγραμμα οδήγησης",
    'odbc__driver_or_name_not_set' => "Δεν έχει οριστεί το πρόγραμμα οδήγησης ή το όνομα της σύνδεσης ODBC",
    'odbc__dsn_already_exists' => "Υπάρχει ήδη DSN με αυτό το όνομα (%1) στο σύστημα",
    'odbc__dsn_not_exists' => "Αυτό το DSN δεν υπάρχει",
    'odbc__enter_connection_params' => "Ρύθμιση σύνδεσης ODBC",
    'odbc__enter_dsn_name' => "Εισαγάγετε όνομα DSN",
    'odbc__invalid_dsn_name' => "Λανθασμένη σύνταξη για το όνομα σύνδεσης ODBC (%1): χρησιμοποιήστε μόνο αλφαριθμητικά σύμβολα.",
    'odbc__no_such_driver' => "Το πρόγραμμα οδήγησης ODBC με αυτό το όνομα (%1) δεν υποστηρίζεται.",
    'odbc__remove_page_title' => "Οι παρακάτω συνδέσεις ODBC DSN θα καταργηθούν:",
    'odbc__select_dsn_to_remove' => "Επιλέξτε τα DSN που θα καταργηθούν.",
    'odbc__unknown_driver' => "Άγνωστο όνομα προγράμματος οδήγησης (%1).",
    'odbc_add_new' => "Προσθήκη σύνδεσης DSN",
    'odbc_driver' => "Πρόγραμμα οδήγησης",
    'odbc_dsn_description' => "Περιγραφή σύνδεσης",
    'odbc_dsn_list' => "Συνδέσεις ODBC DSN",
    'odbc_dsn_name' => "Όνομα σύνδεσης",
    'odbc_dsn_system' => "Σύστημα DSN",
    'odbc_dsn_text' => "ODBC DSN",
    'odbc_dsn_add__title' => 'Προσθήκη ODBC DSN',
    'odbc_req_field_not_set' => "Οι απαιτούμενες παράμετροι δεν παρέχονται.",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => 'Διαδρομή αρχείου βάσης δεδομένων',
    'odbc__access_pagetimeout' => 'Το χρονικό διάστημα, σε δέκατα του δευτερολέπτου, που παραμένει στο buffer μια σελίδα που δεν χρησιμοποιείται.  Η επιλογή αυτή ισχύει για όλες τις προελεύσεις δεδομένων που χρησιμοποιούν το πρόγραμμα οδήγησης Microsoft Access.',
    'odbc__access_maxbuffersize' => 'Το μέγεθος του εσωτερικού buffer σε KB, στοιχισμένο σε όριο 256 KB.',
    'odbc__access_readonly' => 'Ορίζει τη βάση δεδομένων ως "μόνο για ανάγνωση" ούτως ώστε να απαγορεύονται οι ενημερώσεις.',
    'odbc__access_exclusive' => 'Ορίζει τη βάση δεδομένων ως αποκλειστική ούτως ώστε να απαγορεύονται οι κοινόχρηστες ενημερώσεις.',
    'odbc__access_safetransactions' => 'Αν οριστεί σε 0 (προεπιλεγμένη ρύθμιση), όλες οι συναλλαγές πραγματοποιούνται άμεσα.  Αν οριστεί σε 1, όλες οι συναλλαγές αποθηκεύονται στο δίσκο μόνο κατόπιν διαδικασίας δέσμευσης, αλλά η απόδοση είναι ελαφρώς μειωμένη.',
    'odbc__access_threads' => 'Ο αριθμός των νημάτων παρασκηνίου που θα χρησιμοποιήσει η μηχανή.',
    'odbc__access_maxscanrows' => "Ο αριθμός των γραμμών που πρέπει να σαρωθούν κατά τον καθορισμό του τύπου δεδομένων μιας στήλης με βάση τα υπάρχοντα δεδομένα.",
    'odbc__access_implicitcommitsync' => 'Καθορίζει τον τρόπο με τον οποίο εγγράφονται στη βάση δεδομένων οι αλλαγές που πραγματοποιούνται εκτός μιας συναλλαγής.',
    'odbc__access_usercommitsync' => 'Καθορίζει αν το πρόγραμμα οδήγησης MS Access θα εκτελεί ασύγχρονα ρητές συναλλαγές που καθορίζονται από το χρήστη.',
    'odbc__mssql_server' => 'Διακομιστής',
    'odbc__mssql_uid' => 'Αναγνωριστικό σύνδεσης',
    'odbc__mssql_pwd' => 'Κωδικός πρόσβασης',
    'odbc__mssql_database' => 'Προεπιλεγμένη βάση δεδομένων για την προέλευση δεδομένων ODBC',
    'odbc__mssql_app' => 'Όνομα εφαρμογής',
    'odbc__mssql_wid' => 'Αναγνωριστικό σταθμού εργασίας',
    'odbc__mssql_language' => 'Προεπιλογή εθνική γλώσσα που θα χρησιμοποιηθεί',
    'odbc__mssql_oemtoansi' => 'Μετατροπή των εκτεταμένων χαρακτήρων σε τιμές OEM',
    'odbc__mysql_server' => 'Το όνομα κεντρικού υπολογιστή του διακομιστή MySQL',
    'odbc__mysql_database' => 'Η προεπιλεγμένη βάση δεδομένων',
    'odbc__mysql_user' => 'Το όνομα χρήστη που χρησιμοποιείται για τη σύνδεση στο MySQL',
    'odbc__mysql_password' => 'Ο κωδικός πρόσβασης για το λογαριασμό χρήστη στο διακομιστή',
    'odbc__mysql_port' => 'Η θύρα TCP/IP που θα χρησιμοποιηθεί εάν ο διακομιστής δεν είναι ο τοπικός κεντρικός υπολογιστής',
    'odbc__mysql_socket' => 'Επώνυμη διοχέτευση των Windows για σύνδεση εάν ο διακομιστής είναι ο τοπικός κεντρικός υπολογιστής',
    'odbc__mysql_option' => 'Επιλογές που καθορίζουν τον τρόπο λειτουργίας του MyODBC.  Δείτε το <a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html.</a>',
    'odbc__excel_dbq' => 'Διαδρομή αρχείου ΒΔ',
    'odbc__excel_defaultdir' => 'Προεπιλεγμένος κατάλογος δεδομένων',
    'odbc__excel_fil' => 'Έκδοση βάσης δεδομένων',
    'odbc__excel_maxbuffersize' => 'Μέγιστο μέγεθος buffer',
    'odbc__excel_pagetimeout' => 'Χρονικό όριο σελίδας',

    'pb__aliases' => "Ψευδώνυμα",
    'pb__anonftp' => "Ανώνυμο FTP",
    'pb__autoinstaller_releases' => 'Πρόγραμμα ενημέρωσης',
    'pb__cert' => "Πιστοποιητικά",
    'pb__cl_pool' => "Διευθύνσεις IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Ρυθμίσεις",
    'pb__cl_rpt' => "Αναφορά",
    'pb__cl_rpt_list' => "Προσαρμογή",
    'pb__cl_templates' => "Πρότυπα πελατών",
    'pb__cl_traffic' => "Κυκλοφορία",
    'pb__cl_traffic_history' => "Ιστορικό κίνησης",
    'pb__cl_traffic_of' => "Κίνηση του %1",
    'pb__client' => "%1",
    'pb__clients' => "Πελάτες",
    'pb__comp_info' => "Στοιχεία διακομιστή",
    'pb__common_acl' => 'Να επιτραπεί η μεταφορά ACL',
    'pb__cp_access' => "Πρόσβαση",
    'pb__crontab' => "Χρονοδιάγραμμα",
    'pb__scheduler' => "Χρονοδιάγραμμα",
    'pb__custom_buttons' => "Προσαρμοσμένα κουμπιά",
    'pb__databases_db' => 'Βάσεις δεδομένων',
    'pb__sqlservers_db' => 'Διακομιστές SQL',//to check
    'pb__db' => "Βάσεις δεδομένων",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Διακομιστές βάσεων δεδομένων',
    'pb__dl_usr_ed' => "Διαχειριστής τομέα",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Όρια τομέα",
    'pb__dom_pref' => "Ρυθμίσεις",
    'pb__dom_sum_report' => "Συνοπτική αναφορά τομέα",
    'pb__dom_templates' => "Πρότυπα τομέα",
    'pb__dom_traffic' => "Κίνηση του %1",
    'pb__dom_traffic_history' => "Ιστορικό κίνησης",
    'pb__domains' => "Τομείς",
    'pb__domain_aliases' => 'Ψευδώνυμα τομέα',
    'pb__dumps_list' => "Αποθήκευσης αρχείων αντιγράφων ασφαλείας",
    'pb__forwarding_setup' => "Ρύθμιση προώθησης",
    'pb__filemanager' => "Διαχείριση αρχείων",
    'pb__ip_aliasing' => "Διευθύνσεις IP",
    'pb__ip_clients' => "Κατάργηση διευθύνσεων IP",
    'pb__license_management' => 'Διαχείριση αδειών χρήσης',
    'pb__locales' => 'Τοπικές ρυθμίσεις',
    'pb__log_files' => "Αρχεία καταγραφής",
    'pb__mail' => 'Αλληλογραφία',
    'pb__mail_blocked_domains' => 'Μαύρη λίστα',
    'pb__mail_name_files' => "Συνημμένα αρχεία",
    'pb__mail_name_redirects' => "Διακομιστές προώθησης αλληλογραφίας",
    'pb__mail_name_resp_attach_add' => "Νέο συνημμένο",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Αυτόματες απαντήσεις αλληλογραφίας",
    'pb__mail_names' => "Αλληλογραφία",
    'pb__mail_white_list' => 'Λίστα επιτρεπόμενων',
    'pb__maillists' => "Λίστες αλληλογραφίας",
    'pb__mimetypes' => 'Τύποι MIME',
    'pb__modules' => 'Λειτουργικές μονάδες',
    'pb__modules_management' => 'Διαχείριση λειτουργικών μονάδων',
    'pb__notifications' => "Ειδοποιήσεις",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Ρύθμιση φυσικής φιλοξενίας",
    'pb__prtd_dirs' => "Προστατευμένοι κατάλογοι",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Αναφορά",
    'pb__report_auto' => "Χρονοδιάγραμμα παράδοσης για %1",
    'pb__report_list' => "Προσαρμογή",
    'pb__server' => "Διακομιστής",
    'pb__sessions' => "Περίοδοι λειτουργίας",
    'pb__sapp_pool' => "Χώρος συγκέντρωσης εφαρμογών web",
    'pb__siteapp_install' => 'Εγκατάσταση εφαρμογής web',
    'pb__site_app_pkgs' => 'Εφαρμογές web',
    'pb__site_apps' => "Εφαρμογές web",
    'pb__additional_key_info' => 'Βασικές ιδιότητες',
    'pb__additional_key_properties' => 'Βασικές ιδιότητες',
    'pb__skeleton' => 'Πρότυπο εικονικού κεντρικού υπολογιστή',
    'pb__skins' => 'Εμφανίσεις',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Φίλτρο ανεπιθύμητης αλληλογραφίας",
    'pb__statistics' => "Στατιστικά στοιχεία",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Υποτομείς",
    'pb__templates' => "Πρότυπα",
    'pb__virtualdirs' => 'Εικονικοί κατάλογοι',
    'pb__web_users' => "Χρήστες web",
    'pb__webalizer_preferences' => 'Ρυθμίσεις στατιστικών στοιχείων web',
    'pdir__enter_dir_name' => "Εισαγάγετε όνομα καταλόγου.",
    'pdir__invalid_hst' => "Ο τύπος φιλοξενίας δεν είναι έγκυρος.  Πρέπει να είναι φυσική.",
    'pdir__pd_id_is_undefined' => "Μη καθορισμένο αναγνωριστικό προστατευμένου καταλόγου.",
    'pdir__pdir_exist' => "Ο κατάλογος με αυτό το όνομα είναι ήδη προστατευμένος.",
    'pdir__pdir_not_exist' => "Ο προστατευμένος κατάλογος δεν υπάρχει.",
    'pdir__pdir_usr_not_exist' => "Ο χρήστης προστατευμένου καταλόγου δεν υπάρχει.",
    'pdir__prdirs_for_domain' => "Προστατευμένοι κατάλογοι στην τοποθεσία web %1",
    'pdir__prdirs_for_subdomain' => "Προστατευμένοι κατάλογοι για τον υποτομέα %1",
    'pdir__remove_pdir_usrs' => "Οι παρακάτω χρήστες του προστατευμένου καταλόγου %2 της τοποθεσίας web %1 θα καταργηθούν:",
    'pdir__remove_pdir_usrs_on_subdom' => "Οι παρακάτω χρήστες του προστατευμένου καταλόγου %2 του υποτομέα %1 θα καταργηθούν:",
    'pdir__remove_pdirs_on_dom' => "Η ενέργεια αυτή θα οδηγήσει στην κατάργηση της προστασίας από τους καταλόγους της τοποθεσίας web %2 που ανήκει στον πελάτη %1. Οι κατάλογοι δεν θα διαγραφούν.",
    'pdir__remove_pdirs_on_subdom' => "Η ενέργεια αυτή θα οδηγήσει στην κατάργηση της προστασίας από τους καταλόγους του υποτομέα %1. Οι κατάλογοι δεν θα διαγραφούν.",
    'pdir__select_pdir_usrs_for_remove' => "Επιλέξτε τους χρήστες προστατευμένου καταλόγου που θα καταργηθούν.",
    'pdir__select_pdirs_to_remove' => "Επιλέξτε τους καταλόγους από τους οποίους θα καταργηθεί η προστασία.",
    'pdir__unable_define_pdir_users' => "Δεν είναι δυνατός ο καθορισμός των χρηστών προστατευμένου καταλόγου.",
    'pdir__unable_define_pdirs_properties' => "Δεν είναι δυνατός ο ορισμός των ιδιοτήτων των προστατευμένων καταλόγων: %1",
    'pdir__unable_select_dom_param' => "Δεν είναι δυνατή η επιλογή των παραμέτρων του τομέα: %1",
    'pdir_ed__create_pdir_for_domain' => "Δημιουργία προστατευμένου καταλόγου στην τοποθεσία %1",
    'pdir_ed__create_pdir_for_subdomain' => "Δημιουργία προστατευμένου καταλόγου στον υποτομέα %1",
    'pdir_ed__dir_already_protect' => "Ο κατάλογος αυτός είναι ήδη προστατευμένος.",
    'pdir_ed__head_txt' => "Τίτλος της προστατευμένης περιοχής",
    'pdir_ed__invalid_login' => "Το όνομα χρήστη που καθορίσατε είναι λανθασμένο.",
    'pdir_ed__login_exists' => "Αυτός ο χρήστης υπάρχει ήδη. Δοκιμάστε ένα άλλο όνομα χρήστη.",
    'pdir_ed__new_usr' => "Όνομα χρήστη",
    'pdir_ed__non_ssl' => "μη-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Όνομα καταλόγου",
    'pdir_ed__pdir_for_domain' => "Προστατευμένος κατάλογος %1 στον τομέα %2",
    'pdir_ed__pdir_for_subdomain' => "Προστατευμένος κατάλογος %1 στον υποτομέα %2",
    'pdir_ed__pdir_location' => "Θέση καταλόγου",
    'pdir_ed__pdir_users' => "Χρήστες προστατευμένου καταλόγου",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_not_supported_domain' => "Το SSL/TLS δεν υποστηρίζεται από αυτήν την τοποθεσία ή δεν παρέχεται με τη συνδρομή σας. Για να ενεργοποιήσετε την υποστήριξη SSL/TLS, μεταβείτε στην καρτέλα Τοποθεσίες Web & Τομείς και κάντε κλικ στο όνομα του τομέα σας από τη λίστα. Εάν η υποστήριξη SSL/TLS δεν παρέχεται με τη συνδρομή σας, επικοινωνήστε με τον πάροχο υπηρεσιών φιλοξενίας σας για να αναβαθμίσετε το πρόγραμμα φιλοξενίας σας.",
    'pdir_ed__ssl_not_supported_domain_powerUser' => "Το SSL/TLS δεν υποστηρίζεται από αυτήν την τοποθεσία. Για να ενεργοποιήσετε την υποστήριξη SSL/TLS, μεταβείτε στην καρτέλα Τοποθεσίες Web & Τομείς και κάντε κλικ στο όνομα του τομέα από τη λίστα.",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Πρέπει να επιλέξετε τουλάχιστον ένα πλαίσιο ελέγχου, SSL/TLS ή μη-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Δεν είναι δυνατή η δημιουργία του χρήστη προστατευμένου καταλόγου: %1",
    'pdir_ed__unable_create_pdir' => "Δεν είναι δυνατή η δημιουργία του προστατευμένου καταλόγου: %1",
    'pdir_ed__unable_define_hst_type' => "Δεν είναι δυνατός ο καθορισμός του τύπου φιλοξενίας.",
    'pdir_ed__unable_update_pdir' => "Δεν είναι δυνατή η αποθήκευση των ρυθμίσεων του προστατευμένου καταλόγου: %1",
    'pdir_ed__wrong_symbol_in_header' => "Μην χρησιμοποιείτε το χαρακτήρα %1 στον τίτλο του καταλόγου.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Δημιουργία χρήστη για το προστατευμένο κατάλογο %1",
    'pdir_usr_ed__not_create_pass' => "Με αυτόν τον τρόπο δεν θα δημιουργηθεί κωδικός πρόσβασης για το νέο χρήστη του προστατευμένου καταλόγου.\n Χωρίς κωδικό πρόσβασης, ο χρήστης δεν θα έχει τη δυνατότητα να συνδεθεί.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Κωδικό πρόσβασης για το χρήστη προστατευμένου καταλόγου %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Δεν είναι δυνατή η επιλογή του χρήστη προστατευμένου καταλόγου: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Δεν είναι δυνατός ο καθορισμός των χρηστών προστατευμένου καταλόγου: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Δεν είναι δυνατή η κατάργηση των χρηστών προστατευμένου καταλόγου: %1",
    'pdirs_list__name' => "Όνομα",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "Κ",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "Δεν είναι δυνατή η κατάργηση των προστατευμένων καταλόγων: %1",
    'phosting__anonftp_disabled' => "Η υπηρεσία ανώνυμου FTP δεν είναι διαθέσιμη γι' αυτόν τον τομέα επειδή η συγκεκριμένη διεύθυνση IP χρησιμοποιείται ήδη για την υπηρεσία ανώνυμου FTP ενός άλλου τομέα.",
    'phosting__anonftp_encrypt' => 'Ο κωδικός πρόσβασης του χρήστη FTP είναι κρυπτογραφημένος και, συνεπώς, δεν μπορεί να χρησιμοποιηθεί για την προστασία του καταλόγου /plesk-stat/webstat/.  Εισαγάγετε ξανά τον κωδικό πρόσβασής σας στο FTP ή καταργήστε την επιλογή "προσβάσιμο μέσω του καταλόγου με προστασία κωδικού πρόσβασης \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Το όνομα τομέα %%domain_name%% αναλύεται στη διεύθυνση IP %%dns_ip_address%%.  Στην τοποθεσία web σας έχει εκχωρηθεί η διεύθυνση IP %%hosting_ip_address%%.  Εάν η τοποθεσία web σας δεν ανοίγει σε πρόγραμμα περιήγησης στο web χρησιμοποιώντας το όνομα τομέα της, μεταβείτε στην οθόνη διαχείρισης DNS (Τομείς > Όνομα τομέα > DNS) και αλλάξτε τις ιδιότητες της εγγραφής πόρων Α: εκχωρήστε τη διεύθυνση IP %%hosting_ip_address%% στο όνομα τομέα %%domain_name%%.",
    'phosting__ip_change_warning' => "Η διεύθυνση IP άλλαξε.  Οι αντίστοιχες αλλαγές πραγματοποιήθηκαν επίσης στη ζώνη DNS του τομέα.",
    'phosting__other_hosting_exists_on_ip' => "Δεν είναι δυνατή η αλλαγή του πιστοποιητικού επειδή η συγκεκριμένη διεύθυνση IP χρησιμοποιείται σε έναν ή περισσότερους λογαριασμούς φιλοξενίας.",
    'phosting__unable_to_change_certificate' => "Δεν είναι δυνατή η εγκατάσταση του πιστοποιητικού: %1",
    'phosting__unable_to_change_ip_address' => "Δεν είναι δυνατή η αλλαγή της διεύθυνσης IP: %1",
    'phosting__unable_to_set_cert' => "Δεν είναι δυνατός ο ορισμός του πιστοποιητικού SSL/TLS: %1",
    'phosting__unable_update' => "Δεν είναι δυνατή η ενημέρωση των ρυθμίσεων φιλοξενίας: %1",
    'phosting__unable_manage' => "Δεν είναι δυνατή η διαχείριση της φιλοξενίας: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Δεν ήταν δυνατή η διαμόρφωση του fail2ban για την παρακολούθηση αρχείων καταγραφής του τομέα. Τα αρχεία καταγραφής θα παρακολουθούνται αυτόματα την επόμενη φορά που θα γίνει επανεκκίνηση της υπηρεσίας fail2ban.\n%1",

    'picker_acl_record__tittle' => 'Επιλογή αρχείου ACL',
    'picker_autoresponder__title' => 'Επιλογή αυτόματης απάντησης',
    'picker_black_list__domain_name' => 'Επιλογή ονόματος τομέα',
    'picker_certificate' => 'Επιλογή πιστοποιητικού SSL/TLS',

    'picker_dns_zone_template__title' => 'Επιλογή εγγραφής πόρων',
    'picker_domain__title' => 'Επιλέξτε τοποθεσία web',
    'picker_domain_alias__title' => 'Επιλογή ψευδωνύμου τομέα',
    'picker_resource_record__title' => 'Επιλογή εγγραφής πόρων',
    'picker_disabled_resource_record__title' => 'Επιλογή διακομιστή ονομάτων',
    'picker_ip_address__title' => 'Επιλογή διεύθυνσης IP',
    'picker_ip_address_clients__title' => 'Επιλογή πελατών που χρησιμοποιούν αυτήν τη διεύθυνση IP',
    'picker_mail_queue' => 'Επιλογή μηνυμάτων ηλεκτρονικού ταχυδρομείου',
    'picker_site_application__title' => 'Επιλογή εφαρμογής web',
    'picker_subdomain__title' => 'Επιλογή υποτομέα',
    'picker_web_user__title' => 'Επιλογή χρήστη web',
    'picker_custom_button__title' => 'Επιλογή προσαρμοσμένου κουμπιού',
    'picker_license_key__title' => "Επιλογή κλειδιού άδειας χρήσης",
    'picker_spamfilter_address__title' => 'Επιλογή διεύθυνσης φίλτρου ανεπιθύμητης αλληλογραφίας',
    'picker_white_list__networks' => 'Επιλογή δικτύων',

    'plesk_key__action_logs' => "Καταγραφή των ενεργειών που πραγματοποιούνται από τους χρήστες του Plesk",
    'plesk_key__app_vault' => "Application Vault",
    'plesk_key__backup' => "Λειτουργίες δημιουργίας και επαναφοράς αντιγράφων ασφαλείας",
    'plesk_key__client_templs' => "Διαχείριση προγραμμάτων παροχής υπηρεσιών",
    'plesk_key__clients' => "Λογαριασμοί χρηστών (μεταπωλητές και πελάτες)",
    'plesk_key__resellers_only' => "Λογαριασμοί χρηστών (μεταπωλητές)",
    'plesk_key__customers_only' => "Λογαριασμοί χρηστών (πελάτες)",
    'plesk_key__domains' => "Τομείς",
    'plesk_key__domain_aliases' => "Ψευδώνυμα τομέα",
    'plesk_key__manage_dashboard' => 'Προσαρμογή Αρχικής σελίδας',
    'plesk_key__drweb' => "Διαχείριση λογισμικού προστασίας από ιούς",
    'plesk_key__event_manager' => "Διαχείριση συμβάντων",
    'plesk_key__expirations' => "Διαχείριση ημερομηνιών λήξης λογαριασμών",
    'plesk_key__group_ops' => "Τροποποίηση πολλαπλών αντικειμένων ταυτόχρονα",
    'plesk_key__expiration' => "Ημερομηνία λήξης κλειδιού",
    'plesk_key__edition_name' => "Έκδοση του Plesk",
    'plesk_key__key_number' => "Αριθμός σημείου παραπομπής",
    'plesk_key__languages' => "Πακέτα γλωσσών",
    'plesk_key__mailnames' => "Λογαριασμοί αλληλογραφίας",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Υποστήριξη Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Συνδέσεις για την αγορά πιστοποιητικών SSL/TLS και υπηρεσιών καταχώρησης τομέων",
    'plesk_key__myplesk_server_id' => "Αναγνωριστικό εξαρτώμενου διακομιστή MPC",
    'plesk_key__notifications' => "Διαχείριση ειδοποιήσεων",
    'plesk_key__postgresql' => "Υποστήριξη διακομιστή βάσεων δεδομένων PostgreSQL",
    'plesk_key__qmail_queue' => 'Διαχείριση ουράς αλληλογραφίας',
    'plesk_key__remote_db' => 'Φιλοξενία απομακρυσμένης βάσης δεδομένων',
    'plesk_key__slave_servers' => "Εξαρτώμενοι διακομιστές",
    'plesk_key__spamassassin' => "Διαχείριση φίλτρου ανεπιθύμητης αλληλογραφίας",
    'plesk_key__subdomains' => "Διαχείριση υποτομέων",
    'plesk_key__sys_access' => "Διαχείριση της πρόσβασης στον διακομιστή",
    'plesk_key__traffic_reports' => "Αναφορές χρήσης κίνησης",
    'plesk_key__tts' => "Help Desk",
    'plesk_key__virtuozzo' => "Ισχύει μόνο για το Virtuozzo containers",
    'plesk_key__webusers' => "Χρήστες web",
    'plesk_key__license_update_date' => 'Επόμενη ενημέρωση κλειδιού άδειας χρήσης',
    'plesk_key__autoinstaller_config' => 'Διαχείριση ρυθμίσεων προγράμματος ενημέρωσης',
    'plesk_key_update__title' => 'Κατάσταση ενημέρωσης κλειδιού',
    'plesk_key_update__legend' => 'Κατάσταση ενημέρωσης κλειδιού',
    'plesk_key_update__new_additional_key' => 'Ελήφθη νέο πρόσθετο κλειδί',
    'plesk_key__check_wrong' => "Το κλειδί άδειας χρήσης δεν είναι έγκυρο. Για να χρησιμοποιήσετε το Plesk, προμηθευτείτε και εγκαταστήστε ένα νέο έγκυρο κλειδί άδειας χρήσης.",
    'plesk_key__upload_check_wrong' => 'Το απεσταλμένο κλειδί άδειας χρήσης δεν είναι έγκυρο.',
    'plesk_key__revert_check_wrong' => 'Το προηγούμενο εγκατεστημένο κλειδί άδειας χρήσης δεν είναι έγκυρο.',
    'plesk_key__update_check_wrong' => 'Το ενημερωμένο κλειδί άδειας χρήσης δεν είναι έγκυρο.',
    'plesk_key__viruozzo_only_key' => 'Το κλειδί άδειας χρήσης προορίζεται για χρήση μόνο με το Plesk που λειτουργεί εντός του Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'Αυτό το αδειοδοτημένο αντίγραφο του Plesk μπορεί να χρησιμοποιηθεί μόνο με τις παρακάτω διευθύνσεις IP: %2. Οι παρακάτω διευθύνσεις IP δεν καλύπτονται από την άδειας χρήσης σας: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Η ποσότητα των πόρων που χρησιμοποιούνται αυτήν τη στιγμή υπερβαίνει τα όρια που καθορίζονται από την άδεια χρήσης σας.',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Ο αριθμός των τοποθεσιών web που φιλοξενούνται στο διακομιστή υπερβαίνει τα όρια που καθορίζονται από την άδειά σας. Φιλοξενείτε %2 τοποθεσίες. Η άδειά σας επιτρέπει τη φιλοξενία μόνο %1 τοποθεσιών.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Ο αριθμός των ψευδωνύμων τομέα στο διακομιστή υπερβαίνει τα όρια που καθορίζονται από την άδειά σας.  Έχετε %2 ψευδώνυμα τομέα. Η άδειά σας επιτρέπει τη φιλοξενία μόνο %1 ψευδωνύμων τομέα.',
    'plesk_key__limits_exceeded_lim_cl' => 'Ο αριθμός των εξυπηρετούμενων λογαριασμών πελατών υπερβαίνει τα όρια που καθορίζονται από την άδειά σας.  Αυτήν τη στιγμή έχετε %2 εξυπηρετούμενους λογαριασμούς πελατών. Η άδειά σας επιτρέπει την εξυπηρέτηση μόνο %1 λογαριασμών πελατών.',
    'plesk_key__limits_exceeded_lim_mn' => 'Ο αριθμός των εξυπηρετούμενων λογαριασμών ηλεκτρονικού ταχυδρομείου υπερβαίνει τα όρια που καθορίζονται από την άδειά σας.  Αυτήν τη στιγμή έχετε %2 εξυπηρετούμενους λογαριασμούς ηλεκτρονικού ταχυδρομείου. Η άδειά σας επιτρέπει την εξυπηρέτηση μόνο %1 λογαριασμών ηλεκτρονικού ταχυδρομείου.',
    'plesk_key__limits_exceeded_lim_wu' => 'Ο αριθμός των εξυπηρετούμενων λογαριασμών χρηστών web υπερβαίνει τα όρια που καθορίζονται από την άδειά σας.  Αυτήν τη στιγμή έχετε %2 εξυπηρετούμενους λογαριασμούς χρηστών web. Η άδειά σας επιτρέπει την εξυπηρέτηση μόνο %1 λογαριασμών χρηστών web.',
    'plesk_key__limits_exceeded_MLS' => 'Ο αριθμός των εγκατεστημένων πακέτων γλωσσών υπερβαίνει τα όρια που καθορίζονται από την άδειά σας. Έχουν εγκατασταθεί %2 πακέτα γλωσσών. Η άδειά σας επιτρέπει την εγκατάσταση μόνο %1 πακέτων γλωσσών.',
    'plesk_key__wrong_version' => 'Προσπαθείτε να χρησιμοποιήσετε ένα κλειδί άδειας χρήσης που δημιουργήθηκε για άλλη έκδοση του Plesk. Επικοινωνήστε με τους αντιπροσώπους πωλήσεων της Parallels για να προμηθευτείτε το κατάλληλο κλειδί άδειας χρήσης.',
    'plesk_key__other_product' => 'Προσπαθείτε να χρησιμοποιήσετε ένα κλειδί άδειας χρήσης που δημιουργήθηκε για άλλο προϊόν. Επικοινωνήστε με τους αντιπροσώπους πωλήσεων της Parallels για να προμηθευτείτε το κατάλληλο κλειδί άδειας χρήσης.',
    'plesk_key__limits_exceeded_error' => 'Δεν είναι δυνατή η εγκατάσταση του κλειδιού άδειας χρήσης: η ποσότητα των πόρων που χρησιμοποιούνται αυτήν τη στιγμή υπερβαίνει τα όρια που ορίζονται με βάση το απεσταλμένο κλειδί άδειας χρήσης.',
    'plesk_key__limits_exceeded_note' => 'Η ποσότητα των πόρων που χρησιμοποιούνται αυτήν τη στιγμή υπερβαίνει τα όρια που ορίζονται με βάση το απεσταλμένο κλειδί άδειας χρήσης.',
    'plesk_key__key_file_invalid' => 'Το απεσταλμένο αρχείο κλειδιού δεν είναι έγκυρο ή δεν περιέχει κλειδί άδειας χρήσης.',
    'plesk_key__server_request_error' => 'Δεν ήταν δυνατή η ενημέρωση της άδειας χρήσης.Βεβαιωθείτε ότι οι συνδέσεις προς τον διακομιστή αδειών χρήσης ka.plesk.com στη θύρα TCP %1 δεν έχουν αποκλειστεί.<a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">Δείτε πώς μπορείτε να το κάνετε αυτό</a>.',
    'key__title' => 'Διαχείριση αδειών χρήσης',
    'key__upload_title' => 'Εγκατάσταση κλειδιού άδειας χρήσης',
    'key__no_key_file_in_zip' => 'Το απεσταλμένο αρχείο zip δεν περιέχει αρχείο κλειδιού',
    'key__key_upload' => 'Εγκατάσταση κλειδιού άδειας χρήσης',
    'key__tabs_plesk' => 'Κλειδί άδειας χρήσης Plesk',
    'key__tabs_additional' => 'Πρόσθετα κλειδιά άδειας χρήσης',
    'key_revert__title' => 'Επαναφορά κλειδιού άδειας χρήσης',
    'key_revert__legend' => 'Επιβεβαίωση επαναφοράς κλειδιού',
    'key_revert__text' => 'Το κλειδί άδειας χρήσης με τις ακόλουθες ιδιότητες θα αποκατασταθεί:',
    'key__license_update_date_hint' => 'Η ημερομηνία λήξης θα παραταθεί αυτόματα στις %%license_update_date%%.  Για την αυτόματη ενημέρωση πρέπει να επιτρέπονται οι συνδέσεις στο %%keyserver_host%%.  Για περισσότερες πληροφορίες ανατρέξτε στο %%help begin:lim_date%%ακόλουθο θέμα βοήθειας%%help end:lim_date%%.',
    'additional_key__info' => 'Ιδιότητες πρόσθετου κλειδιού',
    'additional_key__prop_name' => 'Ιδιότητα',
    'additional_key__prop_value' => 'Τιμή',
    'additional_key__descr_name' => 'Όνομα κλειδιού',
    'additional_key__descr_key_number' => 'Αριθμός σημείου παραπομπής',
    'additional_key__descr_key_vz' => "Αυτό το κλειδί άδειας χρήσης προορίζεται για χρήση μόνο στο Virtuozzo containers.",
    'additional_key__descr_lim_date' => 'Ημερομηνία λήξης',
    'additional_key__descr_license_update_date' => 'Επόμενη ενημέρωση κλειδιού άδειας χρήσης',
    'additional_key__remove_title' => "Το κλειδί εφαρμογής web με τις ακόλουθες ιδιότητες θα καταργηθεί:",
    'additional_keys__remove_title' => "Τα παρακάτω πρόσθετα κλειδιά θα καταργηθούν:",
    'additional_keys__select_to_remove' => 'Επιλέξτε τα πρόσθετα κλειδιά που θα καταργηθούν.',
    'additional_key__file_invalid' => 'Το απεσταλμένο αρχείο κλειδιού δεν είναι έγκυρο ή δεν περιέχει κλειδί άδειας χρήσης.',
    'additional_key__file_incompatible' => 'Το απεσταλμένο αρχείο κλειδιού δεν είναι έγκυρο γι\' αυτήν την εφαρμογή.',
    'additional_key__expired' => 'Αυτό το πρόσθετο κλειδί έχει λήξει.',
    'additional_key__not_exists' => 'Δεν έχει εγκατασταθεί κλειδί άδειας χρήσης.',
    'additional_key__viruozzo_only_key' => 'Αυτό το κλειδί άδειας χρήσης προορίζεται για χρήση μόνο με το Plesk που είναι εγκατεστημένο σε κοντέινερ Virtuozzo.',
    'additional_keys__legend' => 'Πρόσθετα κλειδιά',
    'additional_keys__list_header' => 'Πρόσθετα κλειδιά',
    'additional_key_update__result_response' => 'Απόκριση διακομιστή αδειών χρήσης: %1',
    'additional_key_update__result_network' => 'Δεν είναι δυνατή η σύνδεση με το διακομιστή αδειών χρήσης.  Βεβαιωθείτε ότι το δίκτυό σας επιτρέπει την επικοινωνία με το %1: %2.',
    'additional_key_update__result_lock' => 'Η ενημέρωση του κλειδιού βρίσκεται ήδη σε εξέλιξη',
    'additional_key_update__result_internal_error' => 'Παρουσιάστηκε σφάλμα κατά την ενημέρωση του κλειδιού άδειας χρήσης: %1',

    'additional_key_revert__title' => 'Επιβεβαιώστε την ενέργεια',
    'additional_key_revert__legend' => 'Ιδιότητες του προηγούμενου πρόσθετου κλειδιού',
    'additional_key_revert__confirm_text' => 'Επαναφορά κλειδιού',
    'additional_key_revert__confirm_required' => 'Επιβεβαιώστε την ενέργεια.',

    'proceed_to_cl_pool' => "Προχωρήστε στη ρύθμιση παραμέτρων του χώρου IP του πελάτη",
    'proceed_to_hosting_setup' => "Προχωρήστε στη ρύθμιση της φιλοξενίας",
    'removeCerts__remove_certificates_cp' => "Τα παρακάτω πιστοποιητικά θα καταργηθούν:",
    'removeCerts__remove_certificates_domain' => "Τα παρακάτω πιστοποιητικά που ανήκουν στον %1 θα καταργηθούν:",
    'removeClientsIP_remove_clients_ip' => "Αυτή η διεύθυνση IP θα καταργηθεί από τους χώρους των παρακάτω πελατών:",
    'removeMailAliases__remove_mail_aliases' => "Τα παρακάτω ψευδώνυμα αλληλογραφίας για το λογαριασμό ηλεκτρονικού ταχυδρομείου %1 θα καταργηθούν:",
    'removeMailNames__remove_mailnames' => "Οι παρακάτω λογαριασμοί και τα ψευδώνυμα αλληλογραφίας θα καταργηθούν από τον τομέα %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Οι παρακάτω λογαριασμοί αλληλογραφίας και τα ψευδώνυμα θα καταργηθούν από τον τομέα %2 που ανήκει στον πελάτη %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Αυτοί οι λογαριασμοί αλληλογραφίας δεν θα καταργηθούν.",
    'removeFtpSessions__remove_title' => "Οι παρακάτω περίοδοι λειτουργίας FTP θα τερματιστούν:",
    'removeTemplates__remove_templates' => "Τα παρακάτω πρότυπα θα καταργηθούν:",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => 'Συχνότητα',
    'report_auto__list_last' => 'Τελευταία ημερομηνία παράδοσης',
    'report_auto__list_recipient' => 'Παράδοση στον/στην',
    'report_auto__list_select' => 'Αναφορά για τον/την',
    'report_auto__title' => 'Χρονοδιαγράμματα παράδοσης για %1',
    'report_auto__recipient_email' => 'διεύθυνση ηλεκτρονικού ταχυδρομείου που θα ορίσω',
    'report_auto__recipient_admin' => 'διαχειριστής του διακομιστή',
    'report_auto__recipient_client' => 'πελάτης',
    'report_auto__recipient_domain' => 'διαχειριστής του τομέα',
    'report_auto_edit__select' => 'Αναφορά για τον/την',
    'report_auto__select_client_report_all' => 'όλοι οι πελάτες',
    'report_auto__select_client_report_current' => 'αυτός ο πελάτης',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'όλοι οι τομείς',
    'report_auto__select_domain_report_other_client' => 'όλοι οι τομείς του %1',
    'report_auto__select_domain_report_client' => 'όλοι οι τομείς αυτού του πελάτη',
    'report_auto__select_domain_report_reseller' => 'όλοι οι τομείς αυτού του μεταπωλητή',
    'report_auto__select_domain_report_current' => 'αυτός ο τομέας',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Χρονοδιαγράμματα παράδοσης',
    'report_auto__select_for_remove' => "Επιλέξτε τα χρονοδιαγράμματα παράδοσης που θα καταργηθούν.",
    'report_auto_remove__title' => "Τα παρακάτω χρονοδιαγράμματα παράδοσης αναφορών θα καταργηθούν:",
    'report_auto_edit__title' => 'Ιδιότητες χρονοδιαγράμματος παράδοσης',
    'report_auto_edit__recipient' => 'Παράδοση στον/στην',
    'report_auto_edit__target' => 'Αναφορά για τον/την',
    'report_auto_edit__auto' => 'Συχνότητα παράδοσης',
    'resp_edit__always_respond' => "πάντα απάντηση",
    'resp_edit__reply_subject' => "Θέμα απάντησης",
    'resp_edit__answer_subject' => "Απάντηση με θέμα",
    'resp_edit__answer_txt' => "Απάντηση με κείμενο",
    'resp_edit__attach' => "Επισύναψη αρχείων",
    'resp_edit__default_subject' => "Απ: %1",
    'resp_edit__for' => "για",
    'resp_edit__frw_rqst_email' => "Με την αυτόματη απάντηση, να προωθείται το πρωτότυπο μήνυμα στην καθορισμένη διεύθυνση ηλεκτρονικού ταχυδρομείου",
    'resp_edit__fwd_email_invalid' => "Η διεύθυνση ηλεκτρονικού ταχυδρομείου προορισμού δεν είναι έγκυρη.",
    'resp_edit__in_body' => "όταν εντοπίζονται οι καθορισμένες στο κύριο σώμα του μηνύματος",
    'resp_edit__in_subject' => "όταν εντοπίζονται οι καθορισμένες στο θέμα του μηνύματος",
    'resp_edit__invalid_resp_freq' => "Η συχνότητα απάντησης δεν είναι έγκυρη.",
    'resp_edit__invalid_rqst_txt' => "Μη έγκυρο κείμενο αίτησης.",
    'resp_edit__invalid_store_lim_num' => "Η τιμή του ορίου δεν είναι έγκυρη.",
    'resp_edit__limits_title' => "Όρια",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Ο μέγιστος αριθμός απαντήσεων ανά ημέρα υπερβαίνει το καθορισμένο ποσοστό. Επιτρέπεται: %1, απαιτείται: %2",
    'resp_edit__no_files_sel' => "Δεν έχουν επιλεγεί αρχεία.",
    'resp_edit__no_txt_supplied' => "Δεν υπάρχει κείμενο.",
    'resp_edit__reply_title' => "Απάντηση",
    'resp_edit__reply_to_address' => "Διεύθυνση αποστολέα",
    'resp_edit__reply_to_invalid' => "Η διεύθυνση αποστολέα δεν είναι έγκυρη.",
    'resp_edit__reply_uniq_email' => "Απάντηση στη μοναδική διεύθυνση ηλεκτρονικού ταχυδρομείου έως και",
    'resp_edit__conditions_title' => "Όροι",
    'resp_edit__request_title' => "Αίτηση",
    'resp_edit__resp' => "Αυτόματη απάντηση",
    'resp_edit__resp_name' => "Όνομα αυτόματης απάντησης",
    'resp_edit__resp_not_exist' => "Η αυτόματη απάντηση δεν υπάρχει.",
    'resp_edit__resp_status' => "Κατάσταση αυτόματης απάντησης",
    'resp_edit__rqst_txt' => 'Καθορίστε την προϋπόθεση γι\' αυτήν την αυτόματη απάντηση',
    'resp_edit__select_files_on_server_for_attach' => "Επιλέξτε τα αρχεία που θέλετε να επισυνάψετε",
    'resp_edit__store_up_to' => "Αποθήκευση έως και",
    'resp_edit__subj_line_invalid' => "Η γραμμή του θέματος είναι λανθασμένη.",
    'resp_edit__text_too_big' => "Το κείμενο του μηνύματος απάντησης είναι πολύ μεγάλο.",
    'resp_edit__times_in_a_day' => "φορές την ημέρα.",
    'resp_edit__unable_define_resp_cond' => "Δεν είναι δυνατός ο καθορισμός της προϋπόθεσης αυτόματης απάντησης: %1",
    'resp_edit__unable_define_resp_status' => "Δεν είναι δυνατός ο καθορισμός της κατάστασης της αυτόματης απάντησης: %1",
    'resp_edit__unable_turn_on_resp' => "Δεν είναι δυνατή η ενεργοποίηση της αυτόματης απάντησης: %1",
    'resp_edit__uniq_email' => "μοναδικές διευθύνσεις ηλεκτρονικού ταχυδρομείου",
    'resp_edit__content_type' => 'Μορφή αποστολής αλληλογραφίας',
    'resp_edit__content_type_text' => 'Απλό κείμενο',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Κωδικοποίηση',
    'restart__dns' => 'Διακομιστής DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "Διακομιστής IMAP/POP3 (%1)",
    'restart__mssql' => "Microsoft SQL Server",
    'restart__mysql' => "Διακομιστής MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Υπηρεσίες",
    'restart__smtp' => "Διακομιστής SMTP (%1)",
    'restart__spamd' => "Φίλτρο ανεπιθύμητης αλληλογραφίας",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Διακομιστής web (%1)",
    'restart__ftp' => "Διακομιστής FTP (%1)",
    'restart__service_start' => 'Περιμένετε λίγο μέχρι να εκκινηθεί η υπηρεσία.',
    'restart__service_stop' => 'Περιμένετε λίγο μέχρι να σταματήσει η υπηρεσία.',
    'restart__service_restart' => 'Περιμένετε λίγο μέχρι να επανεκκινηθεί η υπηρεσία.',
    'rm_domains__some_domains_are_not_exist' => "Ορισμένοι από τους καθορισμένους τομείς δεν υπάρχουν.  Ενδεχομένως να έχουν καταργηθεί από άλλο χρήστη.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Προστασία από ιούς",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "Διακομιστές προώθησης",
    'rpt_cl_dom_subdomains' => "Υποτομείς",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Αναφορά για τον διαχειριστή %1",
    'rpt_cl_report_for_reseller__' => "Αναφορά για τον μεταπωλητή %1",
    'rpt_cl_report_for_cl__' => "Αναφορά για τον πελάτη %1",
    'rpt_cl_section_domains' => "Τομείς",
    'rpt_cl_section_full_domains' => "Τομείς",
    'rpt_cl_section_general' => "Γενικά",
    'rpt_create' => "Δημιουργία αναφοράς",
    'rpt_empty' => "Η αναφορά πρέπει να περιέχει τουλάχιστον μία ενότητα",
    'rpt_default_report' => "Χρήση ως προεπιλεγμένη αναφορά",
    'rpt_dom_report_for_dom__' => "Αναφορά τομέα για το %1",
    'rpt_dom_section_databases' => "Βάσεις δεδομένων",
    'rpt_dom_section_full_databases' => "Βάσεις δεδομένων",
    'rpt_dom_section_full_maillists' => "Λίστες αλληλογραφίας",
    'rpt_dom_section_full_mailnames' => "Λογαριασμοί αλληλογραφίας",
    'rpt_dom_section_full_webusers' => "Χρήστες web",
    'rpt_dom_section_full_siteapps' => 'Εφαρμογές web',
    'rpt_dom_section_full_aspnetapps' => 'Εφαρμογές web ASP.NET',
    'rpt_dom_section_general' => "Γενικά",
    'rpt_dom_section_hosting' => "Φιλοξενία",
    'rpt_dom_section_maillists' => "Λίστες αλληλογραφίας",
    'rpt_dom_section_mailnames' => "Λογαριασμοί αλληλογραφίας",
    'rpt_dom_section_siteapps' => 'Εφαρμογές web',
    'rpt_dom_section_aspnetapps' => 'Εφαρμογές web ASP.NET',
    'rpt_dom_section_webusers' => "Χρήστες web",
    'rpt_dom_title_wa_status' => "Κ",
    'rpt_edit__' => "Επεξεργασία αναφοράς %1",
    'rpt_enter_email_address' => "Εισαγάγετε τη διεύθυνση ηλεκτρονικού ταχυδρομείου στην οποία θα παραδοθεί η αναφορά.",
    'rpt_list' => "Προσαρμοσμένες διατάξεις αναφοράς",
    'rpt_name' => "Όνομα αναφοράς",
    'rpt_remove_reports' => "Οι παρακάτω διατάξεις αναφοράς θα καταργηθούν:",
    'rpt_reports' => "Αναφορές",
    'rpt_section_full' => "Πλήρης",
    'rpt_section_none' => "Καμία",
    'rpt_section_summary' => "Σύνοψη",
    'rpt_select_reports_for_remove' => "Επιλέξτε τις διατάξεις αναφοράς που θα καταργηθούν.",
    'rpt_default_full' => 'Πλήρης αναφορά',
    'rpt_default_summary' => 'Συνοπτική αναφορά',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Σφάλμα αποστολής της αναφοράς: %1",
    'rpt_send_report_by_email_ok__' => "Η αναφορά εστάλη στο %1",
    'sa_action' => "Ενέργεια",
    'sa_action_del' => "Διαγραφή",
    'sa_action_desc' => "Τι πρέπει να γίνεται με την ανεπιθύμητη αλληλογραφία",
    'sa_action_save' => "Επισήμανση ως ανεπιθύμητη αλληλογραφία και αποθήκευση στο γραμματοκιβώτιο",
    'sa_admin_blacklist' => "Μαύρη λίστα διαχειριστή",
    'sa_admin_whitelist' => "Λίστα επιτρεπόμενων διαχειριστή",
    'sa_blacklist' => "Μαύρη λίστα",
    'sa_blacklist_desc' => "Να επισημαίνεται πάντα ως ανεπιθύμητη αλληλογραφία από τις διευθύνσεις",
    'sa_by_tag' => "κατά ετικέτα",
    'sa_conf_list_black' => "Είστε βέβαιοι ότι θέλετε να καταργήσετε τα επιλεγμένα πρότυπα από τη μαύρη λίστα;",
    'sa_conf_list_ignore' => "Είστε βέβαιοι ότι θέλετε να καταργήσετε τα επιλεγμένα πρότυπα από τη λίστα παράβλεψης;",
    'sa_conf_list_white' => "Είστε βέβαιοι ότι θέλετε να καταργήσετε τα επιλεγμένα πρότυπα από τη λίστα επιτρεπόμενων;",
    'sa_db_del_confirm' => "Είστε βέβαιοι ότι θέλετε να γίνει εκκαθάριση της βάσης δεδομένων του φίλτρου ανεπιθύμητης αλληλογραφίας;",
    'sa_disabled__mailserv_not_support_sa_mbox_settings' => "Το φίλτρο ανεπιθύμητης αλληλογραφίας έχει απενεργοποιηθεί: ο διακομιστής αλληλογραφίας δεν υποστηρίζει ρυθμίσεις φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο γραμματοκιβωτίου.",
    'sa_eml_in_ignorelist' => "Η διεύθυνση ηλεκτρονικού ταχυδρομείου είναι στη λίστα παράβλεψης",
    'sa_eml_pattern' => "Μοτίβο μηνύματος ηλεκτρονικού ταχυδρομείου",
    'sa_empty_email' => "Δεν είναι δυνατή η προσθήκη κενού μοτίβου μηνύματος ηλεκτρονικού ταχυδρομείου.",
    'sa_exists_email' => "Το εν λόγω μοτίβο μηνύματος ηλεκτρονικού ταχυδρομείου υπάρχει ήδη.",
    'sa_disabled__mailname_not_filtering' => "Οι τρέχουσες ρυθμίσεις του διακομιστή δεν επιτρέπουν τη χρήση φιλτραρίσματος αλληλογραφίας γι' αυτόν το λογαριασμό αλληλογραφίας",
    'sa_disabled__filtering_is_disabled' => 'Το φιλτράρισμα ανεπιθύμητης αλληλογραφίας έχει απενεργοποιηθεί από το διαχειριστή του διακομιστή',
    'sa_disabled__hasnt_mailbox' => "Δεν είναι δυνατή η ενεργοποίηση του φιλτραρίσματος ανεπιθύμητης αλληλογραφίας χωρίς γραμματοκιβώτιο",
    'sa_enable_filter' => "Ενεργοποίηση φιλτραρίσματος ανεπιθύμητης αλληλογραφίας",
    'bt_sa_clear_db' => 'Εκκαθάριση βάσης δεδομένων φίλτρου ανεπιθύμητης αλληλογραφίας',
    'bt_sa_forget' => 'Κατάργηση της απομνημόνευσης',
    'bt_sa_learn_as_spam' => "Είναι ανεπιθύμητη αλληλογραφία!",
    'bt_sa_learn_as_nonspam' => "Δεν είναι ανεπιθύμητη αλληλογραφία",
    'sa_forget' => "παράβλεψη",
    'sa_from' => "Από",
    'sa_ham' => "μη ανεπιθύμητη αλληλογραφία",
    'sa_ignorelist' => "Λίστα παράβλεψης σε επίπεδο διακομιστή",
    'sa_ignorelist_desc' => "Να μην φιλτράρεται η αλληλογραφία γι' αυτούς τους λογαριασμούς",
    'sa_pattern_in_blacklist' => "Το μοτίβο υπάρχει ήδη στη μαύρη λίστα.",
    'sa_pattern_in_ignorelist' => "Το μοτίβο υπάρχει ήδη στη λίστα παράβλεψης.",
    'sa_pattern_in_whitelist' => "Το μοτίβο υπάρχει ήδη στη λίστα επιτρεπόμενων.",
    'sa_pattern_is_invalid' => "Το μοτίβο δεν είναι έγκυρο.",
    'sa_select_email' => "Επιλέξτε τουλάχιστον ένα μοτίβο μηνύματος ηλεκτρονικού ταχυδρομείου από τη λίστα για να το καταργήσετε.",
    'sa_spam' => "ανεπιθύμητη αλληλογραφία",
    'sa_trainer__page_title' => 'Εκπαίδευση φίλτρου ανεπιθύμητης αλληλογραφίας',
    'sa_trainer__tools_legend' => 'Εργαλεία',
    'sa_trainer__info_legend' => 'Πληροφορίες',
    'sa_trainer__messages_list_legend' => 'Μηνύματα στο γραμματοκιβώτιό σας',
    'sa_trainer__c' => 'Τ',
    'sa_trainer__l' => 'Τ',
    'sa_trainer__subject' => 'Θέμα',
    'sa_trainer__from' => 'Από',
    'sa_trainer__date' => 'Ημερομηνία',
    'sa_trainer__info_text' => 'Μηνύματα που έχουν διαγνωσθεί: %1 ως ανεπιθύμητη αλληλογραφία, %2 ως μη ανεπιθύμητη αλληλογραφία, %3 συνολικά.',
    'sa_trainer__messages' => 'μήνυμα(τα)',
    'sa_trainer__select__all' => 'Όλες',
    'sa_trainer__select__spam_only' => 'Ανεπιθύμητη αλληλογραφία',
    'sa_trainer__select__ham_only' => 'Μη ανεπιθύμητη αλληλογραφία',
    'sa_trainer__select__unknown_only' => 'Άγνωστο',
    'sa_trainer__cannot_remove_messages' => 'Δεν είναι δυνατή η κατάργηση των επιλεγμένων μηνυμάτων από το γραμματοκιβώτιο.',
    'sa_trainer__remove_messages_confirm' => 'Είστε βέβαιοι ότι θέλετε να καταργήσετε τα επιλεγμένα μηνύματα από το γραμματοκιβώτιο;',
    'sa_srv_blacklist' => "Μαύρη λίστα σε επίπεδο διακομιστή",
    'sa_srv_whitelist' => "Λίστα επιτρεπόμενων σε επίπεδο διακομιστή",
    'sa_subj' => "Θέμα",
    'sa_training' => "Εκπαίδευση φίλτρου ανεπιθύμητης αλληλογραφίας",
    'sa_training_legend' => "Εκπαίδευση φίλτρου Bayesian",
    'sa_use_srv_settings' => "Χρήση ρυθμίσεων σε επίπεδο διακομιστή",
    'sa_user_blacklist' => "Μαύρη λίστα χρήστη",
    'sa_user_whitelist' => "Λίστα επιτρεπόμενων χρήστη",
    'sa_usr_disabled_by_srv' => "Οι μεμονωμένες ρυθμίσεις φιλτραρίσματος ανεπιθύμητης αλληλογραφίας δεν επιτρέπονται από το διαχειριστή του διακομιστή",
    'sa_usr_no_postbox' => "Δεν είναι δυνατή η ενεργοποίηση του φιλτραρίσματος ανεπιθύμητης αλληλογραφίας, επειδή το γραμματοκιβώτιο είναι απενεργοποιημένο για τον συγκεκριμένο λογαριασμό ηλεκτρονικού ταχυδρομείου.",
    'sa_whitelist' => "Λίστα επιτρεπόμενων",
    'sa_whitelist_desc' => "Να μην επισημαίνεται ποτέ ως ανεπιθύμητη αλληλογραφία από τις διευθύνσεις",
    'sa_filters' => 'Φίλτρα ανεπιθύμητης αλληλογραφίας',
    'sa_max_mail' => 'Να μην γίνεται φιλτράρισμα αν το μέγεθος της αλληλογραφίας υπερβαίνει το καθορισμένο μέγεθος',
    'sa_size_limit_text' => 'όριο μεγέθους',
    'sa_invalid__max_spam_threads' => 'Μη έγκυρη τιμή.  Εισαγάγετε μια τιμή από 1 έως 32.',
    'sa_max_threads' => 'Αριθμός νημάτων που μπορεί να δημιουργήσει το φίλτρο ανεπιθύμητης αλληλογραφίας',
    'sa_max_threads_maximum' => '(μέγιστο 32)',
    'sa_disabled__spamfilter_not_support_sa_max_threads_limit' => '(δεν είναι διαθέσιμο: το τρέχον φίλτρο ανεπιθύμητης αλληλογραφίας δεν υποστηρίζει αυτήν την επιλογή)',
    'spamfilter__tools_legend' => 'Εργαλεία',
    'spamfilter__prefs_legend' => 'Ρυθμίσεις',
    'spamfilter__max_children' => 'Ο μέγιστος αριθμός διεργασιών εργασίας spamd προς εκτέλεση',
    'spamfilter__rewrite_header_subject_hint' => 'Αφήστε αυτό το πεδίο κενό αν δεν θέλετε να προσθέσετε κείμενο. Πληκτρολογήστε _SCORE_ αν θέλετε να συμπεριλάβετε τη βαθμολογία στο θέμα του μηνύματος.',
    'spamfilter__reject_spam' => 'Διαγραφή ανεπιθύμητης αλληλογραφίας όταν λαμβάνεται στο γραμματοκιβώτιο',
    'spamfilter__enabled' => 'Ενεργοποιημένο',
    'spamfilter_addresses_list__tools_legend' => 'Εργαλεία',
    'spamfilter_addresses_list__list_legend' => 'Διευθύνσεις',
    'spamfilter_addresses_list__items' => 'διευθύνσεις',
    'spamfilter_addresses_list__status' => 'Κ',
    'spamfilter_addresses_list__level' => 'Τ',
    'spamfilter_addresses_list__address' => 'Διεύθυνση',
    'spamfilter_addresses__file_legend' => 'Από αρχείο',
    'spamfilter_addresses__file_label' => 'Όνομα αρχείου',
    'spamfilter_addresses__file_hint' => 'Αποστολή αρχείου σε κωδικοποίηση UTF-8.',
    'spamfilter_addresses__text_legend' => 'Από τη λίστα',
    'spamfilter_addresses__text_label' => 'Διευθύνσεις ηλεκτρονικού ταχυδρομείου',
    'spamfilter_addresses__remove_title' => 'Οι παρακάτω διευθύνσεις θα καταργηθούν από τη λίστα:',
    'spamfilter_addresses__empty_selection' => 'Δεν έχουν επιλεγεί διευθύνσεις.',
    'server__admin_info' => "Πληροφορίες διαχειριστή",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Εισαγάγετε την περιγραφή του σφάλματος παρακάτω",
    'server__power_management' => "Διαχείριση ενέργειας",
    'server__services' => "Υπηρεσίες",
    'server__system' => "Σύστημα",
    'server__title' => "Διαχείριση διακομιστή",
    'server_preferences__admin_skin' => "Εμφάνιση περιβάλλοντος εργασίας διαχειριστή",
    'server_preferences__count_disk_space' => "Να περιλαμβάνεται στον υπολογισμό της χρήσης χώρου στο δίσκο",
    'server_preferences__count_traffic' => "Να περιλαμβάνεται στον υπολογισμό της κίνησης",
    'server_preferences__count_type' => 'Κατά τον υπολογισμό της χρήσης χώρου στο δίσκο, να προσμετράται',
    'server_preferences__count_type__byte' => 'μέγεθος αρχείου',
    'server_preferences__count_type__block' => 'χώρος στο δίσκο που χρησιμοποιείται',
    'server_preferences__default_language' => "Προεπιλεγμένη γλώσσα",
    'server_preferences__default_skin' => "Προεπιλεγμένη εμφάνιση",
    'server_preferences__include_databases' => "βάσεις δεδομένων",
    'server_preferences__include_domaindumps' => "αρχεία αντιγράφων ασφαλείας τομέων",
    'server_preferences__include_incoming' => "μόνο εισερχόμενη κίνηση",
    'server_preferences__include_incoming_and_outgoing' => "εισερχόμενη και εξερχόμενη κίνηση",
    'server_preferences__include_logs' => "αρχεία καταγραφής και αναφορές στατιστικών στοιχείων",
    'server_preferences__include_mailboxes' => "γραμματοκιβώτια",
    'server_preferences__include_maillists' => "λίστες αλληλογραφίας",
    'server_preferences__include_outgoing' => "μόνο εξερχόμενη κίνηση",
    'server_preferences__include_remote_databases' => 'Απομακρυσμένες βάσεις δεδομένων',
    'server_preferences__keep_stats' => "Διατήρηση στατιστικών στοιχείων κίνησης και web για",
    'server_preferences__restart_apache_interval' => "Διάστημα επανεκκίνησης Apache",
    'server_preferences__stat_warning' => "Οι αλλαγές που πραγματοποιήθηκαν στο σύστημα υπολογισμού της χρήσης χώρου στο δίσκο θα τεθούν σε ισχύ μόνο κατά τη διάρκεια του επόμενου υπολογισμού στατιστικών στοιχείων.",
    'server_preferences__title' => "Ρυθμίσεις διακομιστή",
    'server_preferences__system' => 'Ρυθμίσεις συστήματος',
    'server_mail__title' => "Ρυθμίσεις αλληλογραφίας σε επίπεδο διακομιστή",
    'mail__tabs_preferences' => "Ρυθμίσεις",
    'mail__tabs_white_list' => "Λίστα επιτρεπόμενων",
    'mail__tabs_blocked_domains' => "Μαύρη λίστα",
    'mail__tabs_mail_queue' => "Ουρά αλληλογραφίας",
    'server_preferences__use_vocabulary' => "Ελέγξτε τους κωδικούς πρόσβασης για τα γραμματοκιβώτια στο λεξικό",
    'sessions__agreement' => "Ναι, θέλω να τερματίσω αυτές τις περιόδους λειτουργίας.",
    'sessions__select_sessions_for_remove' => "Επιλέξτε τις περιόδους λειτουργίας που θα καταργηθούν.",
    'sessions__tabs_cp_sessions' => 'Περίοδοι λειτουργίας Plesk',
    'sessions__tabs_ftp_sessions' => 'Περίοδοι λειτουργίας FTP',
    'sessions__ftp_sessions_login' => 'Όνομα χρήστη λογαριασμού FTP',
    'sessions__ftp_sessions_domain' => 'Όνομα τομέα',
    'sessions__ftp_sessions_path' => 'Τρέχουσα θέση',
    'sessions__ftp_sessions_file' => 'Όνομα αρχείου',
    'sessions__ftp_sessions_action' => 'Κατάσταση',
    'sessions__ftp_sessions_speed' => 'Ταχύτητα, KB/S',
    'sessions__ftp_sessions_comp' => 'Πρόοδος, %',

    'site_apps__access_level' => 'Επίπεδο πρόσβασης',
    'site_apps__access_level_commercial' => 'Εμπορική',
    'site_apps__access_level_free' => 'Ελεύθερη',
    'site_apps__action_installer' => "Εγκατάσταση εφαρμογής web",
    'site_apps__action_reconfigure' => "Επαναρρύθμιση εφαρμογής web",
    'site_apps__custom_button_level' => 'Θέλετε να δημιουργήσετε ένα προσαρμοσμένο κουμπί για την πρόσβαση σε αυτήν την εφαρμογή;',
    'site_apps__custom_button_level_false_domain_user_only' => 'όχι',
    'site_apps__custom_button_level_domain_user_only' => 'Ναι',
    'site_apps__custom_button_level_false' => 'όχι',
    'site_apps__custom_button_level_domain' => 'Ναι και να καταστεί διαθέσιμο μόνο για τον τρέχοντα τομέα',
    'site_apps__custom_button_level_client' => 'Ναι και να καταστεί διαθέσιμο σε όλους τους τομείς του πελάτη',
    'site_apps__custom_button_level_admin' => 'Ναι και να καταστεί διαθέσιμο σε όλους τους τομείς',
    'site_apps__description' => "Περιγραφή",
    'site_apps__dir_used_by_sapp__' => "Ο κατάλογος \"%1\" χρησιμοποιείται από άλλη εφαρμογή web",
    'site_apps__dir_used_by_unknown__' => "Ο κατάλογος \"%1\" υπάρχει ήδη.  Τα περιεχόμενά του θα αντικατασταθούν εάν συνεχίσετε.",
    'site_apps__dir_invalid_name__' => "Το όνομα καταλόγου %1 είναι λανθασμένο",
    'site_apps__file_name' => 'Όνομα αρχείου εφαρμογής web',
    'site_apps__invalid_install_prefix' => "Μη έγκυρο πρόθεμα εγκατάστασης",
    'site_apps__invalid_package' => "Η εφαρμογή web δεν είναι έγκυρη",
    'site_apps__key_status' => 'Άδειες χρήσης',
    'site_apps__key_status_free' => 'Διανέμεται ελεύθερα. Δεν απαιτείται κλειδί άδειας χρήσης',
    'site_apps__key_status_ok' => 'Το απαιτούμενο κλειδί άδειας χρήσης είναι εγκατεστημένο',
    'site_apps__key_status_problem' => 'Το απαιτούμενο κλειδί άδειας χρήσης δεν έχει εγκατασταθεί',
    'site_apps__name' => "Όνομα",
    'site_apps__no_domains' => 'Δεν είναι δυνατή η εγκατάσταση της εφαρμογής web.  Υπάρχει ήδη μια άλλη εγκατεστημένη εφαρμογή web στον ριζικό κατάλογο αυτού του τομέα. Εξετάστε το ενδεχόμενο δημιουργίας ενός υποτομέα για την εφαρμογή web.',
    'site_apps__package_info_' => "Πληροφορίες εφαρμογής web",
    'site_apps__package_integrated' => "ενσωματωμένη εφαρμογή, δεν είναι δυνατό να καταργηθεί",
    'site_apps__pool_select_packages_to_add' => 'Επιλέξτε τις εφαρμογές web που θέλετε να προσθέσετε στο χώρο συγκέντρωσης',
    'site_apps__release' => "Έκδοση",
    'site_apps__resource_used_by_sapp' => "Αυτός ο πόρος χρησιμοποιείται από μια εγκατεστημένη εφαρμογή web",
    'site_apps__root_used_by_sapp' => "Αυτός ο πόρος χρησιμοποιείται από μια εγκατεστημένη εφαρμογή web",
    'site_apps__these_domains_will_not_delete' => 'Αυτοί οι (υπο)τομείς δεν θα διαγραφούν',
    'site_apps__upload_site_app_pkg_title' => 'Αποστολή νέας εφαρμογής web',
    'site_apps__version' => "Έκδοση",
    'site_apps__access_to' => "Πρόσβαση στο %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Πρότυπο εικονικού κεντρικού υπολογιστή",
    'skeleton__client_label' => "Πρότυπο εικονικού κεντρικού υπολογιστή %1",
    'skeleton__admin_page' => "Διαχείριση προτύπου εικονικού κεντρικού υπολογιστή",
    'skeleton__files_list' => "Αρχεία και κατάλογοι",
    'skeleton__archiver_not_installed' => "Δεν είναι δυνατή η αποσυμπίεση της αρχειοθήκης.  Το λογισμικό αρχειοθέτησης πιθανώς να μην έχει εγκατασταθεί στο διακομιστή.  Επικοινωνήστε με το διαχειριστή του {$PROD_NAME} για να εγκαταστήσετε το λογισμικό αρχειοθέτησης.",
    'skeleton__client_page' => "Διαχείριση προτύπου εικονικού κεντρικού υπολογιστή",
    'skeleton__archive_corrupted' => "Σύμφωνα με τα αποτελέσματα του ελέγχου της αρχειοθήκης, το αρχειοθετημένο αρχείο είναι κατεστραμμένο ή δεν υποστηρίζεται αυτός ο τύπος αρχειοθήκης.",
    'skeleton__archive_too_large' => "Σύμφωνα με τα αποτελέσματα του ελέγχου της αρχειοθήκης, το αρχειοθετημένο αρχείο είναι πολύ μεγάλο.",
    'skeleton__not_supported_archive_type' => "Αυτός ο τύπος αρχειοθήκης (αρχείο %1) δεν υποστηρίζεται.",
    'skeleton__upload_archive_file' => "Αποστολή αρχειοθετημένου αρχείου",
    'skin_download__title' => 'Λήψη εμφάνισης',
    'skin_download_now__title' => 'Λήψη εμφάνισης σε εξέλιξη',
    'skin_download_now__text' => 'Η δημιουργία του πακέτου της εμφάνισης είναι σε εξέλιξη.<br>Αυτή η διαδικασία μπορεί να διαρκέσει κάποιο χρονικό διάστημα.<br> Μόλις εμφανιστεί το παράθυρο διαλόγου, μπορείτε να συνεχίσετε την εργασία σας με το Plesk.',
    'skin_file__help_for_using_types' => "Χρησιμοποιήστε αρχειοθήκες εμφανίσεων σε μία από τις εξής μορφές:",
    'skin_info__title' => 'Ιδιότητες εμφάνισης',
    'skin_mng_err__rpm_not_skin' => 'Αυτό το RPM δεν είναι πακέτο εμφάνισης του Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Η εγκατάσταση εμφάνισης που βασίζεται σε rpm στην καθορισμένη θέση απέτυχε.',
    'skin_mng_err__already_exists' => 'Ο κατάλογος εγκατάστασης εμφανίσεων υπάρχει ήδη και υπάρχει ένα ανεπτυγμένο πακέτο εμφάνισης.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Το απεσταλμένο αρχείο δεν είναι έγκυρο πακέτο εμφάνισης RPM.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Το απεσταλμένο αρχείο δεν είναι έγκυρο πακέτο εμφάνισης.',
    'skin_mng_err__rpm_upgrade_base' => "Το απεσταλμένο αρχείο δεν είναι έγκυρο πακέτο εμφάνισης {$PROD_NAME}.",
    'skin_mng_err__rpm_upgrade_other' => 'Δεν είναι δυνατή η εγκατάσταση της εμφάνισης: μη έγκυρη μορφή εμφάνισης.',
    'skin_mng_err__no_a_skin' => "Το απεσταλμένο αρχείο δεν είναι έγκυρο πακέτο εμφάνισης {$PROD_NAME}.",
    'skin_upload__title' => 'Αποστολή νέας εμφάνισης',
    'skin_upload__already_exists' => "Η εμφάνιση '%1' υπάρχει ήδη.",
    'skin_upload__unable_to_apply' => "Το απεσταλμένο αρχείο δεν περιέχει εμφάνιση του Plesk ή η μορφή της αρχειοθήκης δεν υποστηρίζεται.",
    'skin_upload__unable_to_rename__' => "Δεν είναι δυνατή η μετονομασία της εμφάνισης %2 σε %1: %3.",
    'skin_upload__file_name' => 'Διαδρομή αρχείου πακέτου εμφάνισης',
    'skins_list__title' => 'Αποθετήριο εμφανίσεων',
    'skins_remove__title' => 'Κατάργηση εμφάνισης',
    'skins_remove__select_skins_for_remove' => 'Επιλέξτε τις εμφανίσεις που θα καταργηθούν',

    'spamassassin__title' => "Ρύθμιση παραμέτρων φίλτρου ανεπιθύμητης αλληλογραφίας",
    'spf_parameters' => 'Προστασία από ανεπιθύμητη αλληλογραφία SPF',
    'spf_enable_label' => 'Ενεργοποιήστε την προστασία από ανεπιθύμητη αλληλογραφία SPF για να ελέγξετε την εισερχόμενη αλληλογραφία',
    'spf_behavior' => 'Λειτουργία ελέγχου SPF',
    'spf_rules' => 'Τοπικοί κανόνες SPF',
    'spf_guess' => 'Κανόνες εικασίας SPF',
    'spf_exp' => 'Κείμενο επεξήγησης SPF',
    'spf__unable_update' => 'Δεν είναι δυνατή η ενημέρωση των παραμέτρων SPF',
    'spf_bhv__create_headers_no_block' => 'Μόνο δημιουργία κεφαλίδων ληφθέντων SPF, ποτέ αποκλεισμός',
    'spf_bhv__use_tmp_errors' => 'Χρησιμοποιήστε προσωρινές ειδοποιήσεις σφαλμάτων όταν αντιμετωπίζετε προβλήματα αναζήτησης DNS',
    'spf_bhv__reject_if_fail' => 'Απόρριψη αλληλογραφίας όταν το SPF αναλύεται σε "fail" (απόρριψη)',
    'spf_bhv__reject_if_softfail' => 'Απόρριψη αλληλογραφίας όταν το SPF αναλύεται σε "softfail"',
    'spf_bhv__reject_if_neutral' => 'Απόρριψη αλληλογραφίας όταν το SPF αναλύεται σε "neutral"',
    'spf_bhv__reject_if_no_pass' => 'Απόρριψη αλληλογραφίας όταν το SPF δεν αναλύεται σε "pass"',
    'sshterm__title' => 'Τερματικό ασφαλούς κελύφους',
    'sshterm__password_authentication_warning' => 'Σημείωση: Ο έλεγχος ταυτότητας μέσω κωδικού πρόσβασης είναι απενεργοποιημένος στη ρύθμιση παραμέτρων του τοπικού διακομιστή SSH.  Αν δεν μπορείτε να συνδεθείτε χρησιμοποιώντας το τερματικό SSH, ζητήστε από το διαχειριστή να ορίσει την τιμή "PasswordAuthentication yes" στο αρχείο /etc/ssh/sshd_config.',
    'sshterm__password_authentication_warning_admin' => 'Σημείωση: Ο έλεγχος ταυτότητας μέσω κωδικού πρόσβασης είναι απενεργοποιημένος στη ρύθμιση παραμέτρων του τοπικού διακομιστή SSH.  Αν δεν μπορείτε να συνδεθείτε χρησιμοποιώντας το τερματικό SSH, ορίστε την τιμή "PasswordAuthentication yes" στο αρχείο /etc/ssh/sshd_config.',
    'statistics__active_domains' => "Ενεργοί τομείς",
    'statistics__clients' => "Πελάτες",
    'statistics__subdomains' => "Υποτομείς",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Βάσεις δεδομένων",
    'statistics__db_users' => "Χρήστες βάσης δεδομένων",
    'statistics__dirs' => "Προστατευμένοι κατάλογοι",
    'statistics__dom_active' => "Ενεργό",
    'statistics__dom_passive' => "Παθητικό",
    'statistics__dom_problem' => "Πρόβλημα",
    'statistics__domains' => "Τομείς",
    'statistics__domains_with_host' => "Τομείς με φιλοξενία",
    'statistics__doms' => "Τομείς",
    'statistics__filesystem' => "Σύστημα αρχείων",
    'statistics__general' => "Γενικά",
    'statistics__hdd_available' => "Διαθέσιμο",
    'statistics__hdd_capacity' => "Χωρητικότητα",
    'statistics__hdd_total' => "Σύνολο",
    'statistics__hdd_usage' => "Χρήση σκληρού δίσκου",
    'statistics__hdd_used' => "Χρησιμοποιούνται",
    'statistics__ip' => "Διεύθυνση ΙP",
    'statistics__key_number' => "Αριθμός σημείου παραπομπής",
    'statistics__l1' => "Τελευταίο 1 λεπτό",
    'statistics__l15' => "Τελευταία 15 λεπτά",
    'statistics__l5' => "Τελευταία 5 λεπτά",
    'statistics__la' => "Χρήση CPU",
    'statistics__mail_autoresponders' => "Αυτόματες απαντήσεις",
    'statistics__mail_boxes' => "Γραμματοκιβώτια",
    'statistics__mail_groups' => "Ομάδες αλληλογραφίας",
    'statistics__mail_lists' => "Λίστες αλληλογραφίας",
    'statistics__mail_redirects' => "Διακομιστές προώθησης αλληλογραφίας",
    'statistics__mem' => "Χρήση μνήμης",
    'statistics__mem_usage' => "Χρήση",
    'statistics__memory_available' => "Διαθέσιμο",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Αποθηκευμένο στο cache",
    'statistics__memory_free' => "Ελεύθερη",
    'statistics__memory_shared' => "Κοινόχρηστο",
    'statistics__memory_total' => "Σύνολο",
    'statistics__memory_used' => "Χρησιμοποιούνται",
    'statistics__os' => "Λειτουργικό σύστημα",
    'statistics__problem_clients' => "Προβληματικοί πελάτες",
    'statistics__problem_domains' => "Προβληματικοί τομείς",
    'statistics__swap' => "Εναλλαγή χρήσης",
    'statistics__swap_free' => "Ελεύθερη",
    'statistics__swap_total' => "Σύνολο",
    'statistics__swap_usage' => "Χρήση",
    'statistics__swap_used' => "Χρησιμοποιούνται",
    'statistics__system_stat' => "Πληροφορίες διακομιστή",
    'statistics__unable_define_active_doms' => "Δεν είναι δυνατός ο προσδιορισμός του αριθμού ενεργών τομέων: %1",
    'statistics__unable_define_inactive_doms' => "Δεν είναι δυνατός ο προσδιορισμός του αριθμού ανενεργών τομέων: %1",
    'statistics__up_time' => "Χρόνος λειτουργίας συστήματος:",
    'statistics__ver' => "Έκδοση",
    'statistics__web_users' => "Χρήστες web",
    'statistics__mem_win' => "Χρήση φυσικής μνήμης",
    'statistics__memory_total_win' => "Σύνολο",
    'statistics__memory_used_win' => "Χρησιμοποιούνται",
    'statistics__memory_free_win' => "Διαθέσιμο",
    'statistics__swap_win' => "Χρήση εικονικής μνήμης",
    'statistics__swap_total_win' => "Σύνολο",
    'statistics__swap_used_win' => "Χρησιμοποιούνται",
    'statistics__swap_free_win' => "Διαθέσιμο",
    'status__domain_has_reasons_to_be_off' => "Ο τομέας εξακολουθεί να είναι σε αναστολή για τους εξής λόγους: %1",
    'subdomain__create__' => "Δημιουργία υποτομέα για τον τομέα %1",
    'subdomain__edit__' => "Διαχείριση υποτομέα %1",
    'subdomain__invalid_name' => "Μη έγκυρο όνομα υποτομέα: χρησιμοποιήστε μόνο αλφαριθμητικούς χαρακτήρες και παύλα.",
    'subdomain__incorrect_name' => "Μη έγκυρο όνομα υποτομέα.",
    'subdomains__maillists_enabled_in_domain' => "Λανθασμένες λίστες ονομάτων υποτομέων.%1: αυτό το όνομα τομέα χρησιμοποιείται ήδη από τις λίστες αλληλογραφίας του τομέα %1.",
    'subdomains__dalias_exists' => 'Υπάρχει ήδη ψευδώνυμο τομέα με αυτό το όνομα.',
    'subdomains__name_exists' => "Υπάρχει ήδη υποτομέας με αυτό το όνομα.",
    'subdomains__regular_domain_exists' => "Υπάρχει ήδη τομέας με αυτό το όνομα.",
    'subdomains__domain_alias_exists' => 'Υπάρχει ήδη ψευδώνυμο τομέα με αυτό το όνομα.',
    'subdomains__remove_subdomains_on_domain' => "Οι παρακάτω υποτομείς του τομέα %1 θα καταργηθούν:",
    'subdomains__select_subdomains_for_remove' => "Επιλέξτε τους υποτομείς που θα καταργηθούν.",
    'subdomains__webmail_enabled_in_domain' => "Λανθασμένο webmail ονόματος υποτομέα.%1: αυτό το όνομα τομέα χρησιμοποιείται για πρόσβαση στο webmail του τομέα %1.",
    'subdomains__dns_record_already_exists' => 'Δεν είναι δυνατή η δημιουργία του υποτομέα %1 επειδή υπάρχει ήδη μια εγγραφή DNS που παραπέμπει στον κεντρικό υπολογιστή %1.',
    'subdomains__www_prefix_in_domain' => "Λανθασμένο www ονόματος υποτομέα.%1: Ο τομέας %1 έχει ήδη το πρόθεμα WWW.",
    'subdomains__user_type_quota_exceeds' => 'Δεν είναι δυνατή η αλλαγή του λογαριασμού χρήστη επειδή αυτό θα οδηγούσε σε υπέρβαση του εκχωρημένου χώρου στο δίσκο.',
    'subdomains__creation_in_dns_slave' => "Ο διακομιστής ονομάτων του Plesk λειτουργεί ως δευτερεύων (εξαρτώμενος) διακομιστής ονομάτων γι' αυτόν τον τομέα. Για να αναλύεται σωστά ο υποτομέας σας, βεβαιωθείτε ότι το αρχείο ζώνης στον πρωτεύοντα (κύριο) διακομιστή περιέχει την εγγραφή %1.",
    'sys_user__attributes_not_changed' => "Τα ακόλουθα χαρακτηριστικά των χρηστών του συστήματος δεν άλλαξαν: %1",
    'sys_user__no_access_without_password' => "Δεν έχετε καθορίσει κωδικό πρόσβασης.  Ο χρήστης του συστήματος θα δημιουργηθεί, αλλά δεν θα έχει τη δυνατότητα να συνδεθεί στο σύστημα μέχρι να λάβει τον απαραίτητο κωδικό πρόσβασης. Θέλετε να προχωρήσετε;",
    'sys_user__no_hard_quota' => "δεν υποστηρίζεται",
    'sysuser__zero_quota_is_unlimited' => "0 για απεριόριστο",
    'template__num_excl_ips' => "Εκχώρηση αποκλειστικής διεύθυνσης IP στον πελάτη",
    'template__sel_sh_ips' => "Επιλεγμένες κοινόχρηστες διευθύνσεις IP",
    'template__av_sh_ips' => "Διαθέσιμες κοινόχρηστες διευθύνσεις IP",
    'template__up_to_excl_ip' => "Έως και %1 διευθύνσεις IP",
    'templates__all_clients' => "όλοι οι πελάτες",
    'templates__cl_domain_templates' => "Πρότυπα για το %1",
    'templates__cl_templates' => "Πρότυπα πελατών",
    'time__day' => "Ημέρα",
    'time__dom_name_ip' => "Όνομα τομέα ή IP",
    'time__hours' => "Ώρες",
    'time__invalid_ip' => "Μη έγκυρη διεύθυνση IP ή όνομα τομέα.",
    'time__invalid_year' => "Το έτος δεν είναι έγκυρο. Πρέπει να είναι από 1971 έως 2036.",
    'time__invalid_month' => "Ο μήνας δεν είναι έγκυρος. Πρέπει να είναι από 1 έως 12.",
    'time__invalid_day' => "Η ημέρα δεν είναι έγκυρη. Πρέπει να είναι από 1 έως 31.",
    'time__invalid_hours' => "Οι ώρες δεν είναι έγκυρες.  Πρέπει να είναι από 0 έως 24.",
    'time__invalid_minutes' => "Τα λεπτά δεν είναι έγκυρα. Πρέπει να είναι από 0 έως 59.",
    'time__invalid_seconds' => "Τα δευτερόλεπτα δεν είναι έγκυρα. Πρέπει να είναι από 0 έως 59.",
    'time__minutes' => "Ελάχ.",
    'time__month' => "Μήνας",
    'time__sec' => "Δευτερόλεπτα",
    'time__syn_sys_time' => "Συγχρονισμός ώρας συστήματος",
    'time__system_datetime' => 'Ημερομηνία και ώρα',
    'time__system_date_update' => 'Ενημέρωση ώρας συστήματος',
    'time__system_date' => "Ημερομηνία (Έτος-Μήνας-Ημέρα)",
    'time__system_time' => "Ώρα (Ώρες:Λεπτά:Δευτερόλεπτα)",
    'time__system_date_title' => "Ημερομηνία και ώρα συστήματος",
    'time__timezone_title' => 'Ζώνη ώρας',
    'time__network_time' => 'Ώρα δικτύου',
    'time__timezone' => 'Η ζώνη ώρας σας',
    'time__daylight' => 'Αυτόματη ρύθμιση ρολογιού σύμφωνα με τη χειμερινή/θερινή ώρα',
    'time__please_select_timezone' => 'Επιλέξτε μια ζώνη ώρας',
    '__please_select_country' => 'Επιλέξτε τη χώρα σας',
    'time__unable_set_time' => "Δεν είναι δυνατή η ρύθμιση της ώρας του συστήματος: %1",
    'time__year' => "Έτος",
    'tmpl__create' => "Δημιουργία προτύπου",
    'tmpl__edit__' => 'Πρότυπο %1',
    'tmpl__logrotation_warn' => "Η ανακύκλωση αρχείων καταγραφής στον τομέα που έχει δημιουργηθεί από αυτό το πρότυπο θα πραγματοποιείται μόνο εάν δημιουργηθεί μεταγενέστερα λογαριασμός φυσικής φιλοξενίας γι' αυτόν.",
    'tmpl__name' => "Όνομα προτύπου",
    'tmpl__dom_exist' => "Υπάρχει ήδη πρότυπο τομέα με αυτό το όνομα στον χώρο συγκέντρωσης προτύπων του διαχειριστή ή του πελάτη.",
    'tmpl__name_invalid' => "Το όνομα του προτύπου είναι μη έγκυρο ή κενό.",
    'tmpl__use_next_ip_addr' => "Θα χρησιμοποιηθεί η επόμενη ελεύθερη διεύθυνση IP",
    'tmpl_name_already_exists' => "Το πρότυπο με το όνομα '%1' υπάρχει ήδη.",
    'traffic__no_periods_found' => "Δεν είναι δυνατή η εμφάνιση των στατιστικών στοιχείων κίνησης και web. Η λειτουργία αυτή θα είναι διαθέσιμη μόνο μετά τον επόμενο υπολογισμό των στατιστικών στοιχείων.",

    'vh_based__no_free_ip_for_vh' => "Δεν υπάρχουν ελεύθερες διευθύνσεις IP για την εικονική φιλοξενία βάσει IP. Εισαγάγετε μια διεύθυνση IP.",

    'wu__at_domains_text' => "Να επιτρέπεται μορφή πρόσβασης webuser@%1",
    'wu__unable_create' => "Δεν είναι δυνατή η δημιουργία του χρήστη web: %1",
    'wu_edit__disk_quota' => "Όριο δίσκου",
    'wu_edit__invalid_pass' => "Ο κωδικός πρόσβασης δεν είναι έγκυρος.",
    'wu_edit__invalid_quota' => "Το καθορισμένο όριο χώρου στο δίσκο δεν είναι έγκυρο. Εισαγάγετε έναν θετικό ακέραιο.",
    'wu_edit__invalid_quota_value' => "Το καθορισμένο όριο χώρου στο δίσκο είναι μικρότερο από αυτό που χρησιμοποιείται τη δεδομένη στιγμή (%1MB).  Ορισμένες λειτουργίες μπορεί να μην είναι διαθέσιμες.  Είστε βέβαιοι ότι θέλετε να συνεχίσετε;",
    'wu_edit__not_create_pass' => "Αυτή η ενέργεια δεν θα δημιουργήσει κωδικό πρόσβασης για το νέο χρήστη web.\nΧωρίς κωδικό πρόσβασης, ο χρήστης δεν θα έχει τη δυνατότητα να συνδεθεί.",
    'wu_edit__unable_update' => "Δεν είναι δυνατή η ενημέρωση των ιδιοτήτων του χρήστη web: %1",

    'bt_webdirs' => 'Εικονικοί κατάλογοι',

    'dns__tabs_general' => 'Ρυθμίσεις ζώνης',
    'dns__tabs_zone_settings' => 'Εγγραφές SOA',
    'soa__seconds' => 'δευτερόλεπτα',
    'soa__minutes' => 'λεπτά',
    'soa__hours' => 'ώρες',
    'soa__days' => 'ημέρες',

    'DomainSubdirectory' => 'Υποτομέας προορισμού',

    'filemanager__select_codepage' => 'Επιλέξτε κωδικοσελίδα:',

    'bt_server_app_add' => 'Προσθήκη εφαρμογής διακομιστή',
    'packages_list' => 'Εφαρμογές διακομιστή',

    'bt_packages_management' => 'Διαχείριση πακέτων',
    'pb__packages_management' => 'Διαχείριση εφαρμογών',
    'bt_package_new' => 'Προσθήκη εφαρμογής',
    '__packages' => 'Εφαρμογές διακομιστή',

    'dom_ctrl__mysql_dbase_space' => 'Συνολικό όριο βάσεων δεδομένων MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Συνολικό όριο βάσεων δεδομένων MS SQL',
    'server_preferences__include_mysql_databases' => 'Βάσεις δεδομένων MySQL',
    'server_preferences__include_mssql_databases' => 'Βάσεις δεδομένων Microsoft SQL',

    'check_permissions__domains_selection' => 'Θα ελεγχθούν τα δικαιώματα πρόσβασης στα αρχεία και τους φακέλους των παρακάτω τομέων',

    'dns_add__enter_ixfr_path' => 'Εισαγωγή διαδρομής IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Υπάρχει ήδη εγγραφή SPF TXT. Μπορεί να υπάρχει μόνο μία εγγραφή SPF. Για να προσθέσετε μια εγγραφή, διαγράψτε την υπάρχουσα.',

    'component_name__network' => 'Δικτύωση',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Ορισμός εμφάνισης',
    'bt_set_skin' => 'Ορισμός εμφάνισης',
    'firewall__rule_already_exists' => 'Υπάρχει ήδη κανόνας με το όνομα "%1"',
    'pb__firewall' => 'Τείχος προστασίας',
    'ruleeditform__incorect_port_value' => 'Ο αριθμός θύρας πρέπει να είναι μεταξύ 1 και 65535.',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Η θέση του αρχείου δεν είναι έγκυρη.',

    'error_doc__erorr_invalid_url_location' =>  'Λανθασμένη μορφή URL.  Εισαγάγετε μια απόλυτη διεύθυνση URL εντός του εικονικού κεντρικού υπολογιστή (τοποθεσία).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Προστασία από ιούς',
    'antivirus__antivirus' => 'Προστασία από ιούς',
    'antivirus__antivirus_direction_off' => 'Απενεργοποιήθηκε',
    'antivirus__antivirus_direction_any' => 'Εισερχόμενη και εξερχόμενη αλληλογραφία',
    'antivirus__antivirus_direction_from' => 'Μόνο εξερχόμενη αλληλογραφία',
    'antivirus__antivirus_direction_to' => 'Μόνο εισερχόμενη αλληλογραφία',
    'antivirus__unable_to_update_settings' => 'Δεν είναι δυνατή η αλλαγή των ρυθμίσεων προστασίας από ιούς: %1',




    '__normal' => 'Κανονική',
    '__low' => 'Χαμηλή',
    '__high' => 'Υψηλή',

    'mail__antivirus' => "Εσωτερικό λογισμικό προστασίας από ιούς των διακομιστών αλληλογραφίας",
    'mail__use_internal_antivirus' => 'Χρήση εσωτερικού λογισμικού προστασίας από ιούς',

    'sa__tabs_general' => 'Γενικά',
    'sa__tabs_whitelist' => 'Λίστα επιτρεπόμενων',
    'sa__tabs_blacklist' => 'Μαύρη λίστα',
    'sa__tabs_trustednetworks' => 'Αξιόπιστα δίκτυα',
    'sa__alarm_message_text' => 'Κείμενο ειδοποίησης ανίχνευσης ανεπιθύμητης αλληλογραφίας',
    'sa__ok_languages' => 'Αξιόπιστες γλώσσες',
    'sa__language_groups_available' => 'Διαθέσιμες γλώσσες',
    'sa__language_groups_belonged' => 'Επιλεγμένες αξιόπιστες γλώσσες',
    'sa__ok_locales' => 'Αξιόπιστες τοπικές ρυθμίσεις',
    'sa__locale_groups_available' => 'Διαθέσιμες ομάδες τοπικών ρυθμίσεων',
    'sa__locale_groups_belonged' => 'Επιλεγμένες ομάδες αξιόπιστων τοπικών ρυθμίσεων',

    'sa_trustednetworks' => 'Λίστα αξιόπιστων δικτύων',
    'sa_tn_address' => 'Δίκτυο/Μάσκα',
    'sa_trustednetworks_desc' => 'Επιλεγμένα αξιόπιστα δίκτυα',

    '__mysql_databases' => 'Βάσεις δεδομένων MySQL',

    'check_permissions__read_only' => 'Λειτουργία μόνο ελέγχου',
    'check_permissions__notification_email' => 'Αποστολή ειδοποίησης μέσω ηλεκτρονικού ταχυδρομείου',

    'cl_perm__mysql_dbase_space' => 'Συνολικό όριο βάσεων δεδομένων MySQL',
    'cl_perm__mssql_dbase_space' => 'Συνολικό όριο βάσεων δεδομένων MS SQL',
    'cl_perm__max_mssql_db' => 'Μέγιστος αριθμός βάσεων δεδομένων Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Όριο συνόλου γραμματοκιβωτίων',



    'time__date' => 'Ημερομηνία',
    'time__time' => 'Ώρα',

    'check_permissions_warning' => 'Η διαδικασία μπορεί να διαρκέσει μεγάλο χρονικό διάστημα, παρακαλούμε να είστε υπομονετικοί και να μην ακυρώσετε τη φόρτωση της σελίδας.',

    'i_i_cl_on' => 'Ο λογαριασμός πελάτη είναι ενεργός.',
    'i_i_cl_off_by_admin' => 'Ο λογαριασμός πελάτη έχει ανασταλεί από το διαχειριστή.',

    'check_permissions__email_is_invalid' => 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου που δώσατε δεν είναι έγκυρη.',

    'sa_invalid_tn_ip' => 'Η τιμή IP δεν είναι έγκυρη.',
    'sa_invalid_tn_mask' => 'Η τιμή μάσκας δεν είναι έγκυρη.',
    'sa_exists_tn' => 'Το δίκτυο βρίσκεται ήδη στη λίστα.',
    'sa_select_tn' => 'Δεν έχουν επιλεγεί δίκτυα για κατάργηση.',
    'sa_conf_list_tn' => 'Επιβεβαιώστε την κατάργηση του επιλεγμένου δικτύου(ων).',

    'firewall__tabs_general' => 'Γενικά',
    'firewall_tabs_icmp' => 'Πρωτόκολλο ICMP',

    'firewallicmpform__title' => 'Κανόνες τείχους προστασίας για το πρωτόκολλο ICMP',
    'firewallicmpform__icmpsettings_list_legend' => 'Κανόνες τείχους προστασίας για το πρωτόκολλο ICMP',
    'firewallicmpform__icmpsettingslist' => 'Κανόνες',
    'icmpsettingslist__enabled' => 'Κ',
    'icmpsettingslist__type' => 'Όνομα κανόνα',
    'firewall__icmp_type_allowinboundrouterrequest' => 'Να επιτρέπονται τα εισερχόμενα μηνύματα αιτήσεων δρομολογητή',
    'firewall__icmp_type_allowinboundtimestamprequest' => 'Να επιτρέπονται τα εισερχόμενα μηνύματα αιτήσεων χρονικής σήμανσης',
    'firewall__icmp_type_allowinboundmaskrequest' => 'Να επιτρέπονται τα εισερχόμενα μηνύματα αιτήσεων μάσκας',
    'firewall__icmp_type_allowoutboundsourcequench' => 'Να επιτρέπονται εξερχόμενα μείωσης ρυθμού αποστολής',
    'firewall__icmp_type_allowoutboundparameterproblem' => 'Να επιτρέπονται τα εξερχόμενα μηνύματα προβλήματος παραμέτρων',
    'firewall__icmp_type_allowredirect' => 'Να επιτρέπεται η ανακατεύθυνση',
    'firewall__icmp_type_allowinboundechorequest' => 'Να επιτρέπονται εισερχόμενες αιτήσεις ηχούς',
    'firewall__icmp_type_allowoutboundtimeexceeded' => 'Να επιτρέπονται τα εξερχόμενα μηνύματα υπέρβασης χρονικού ορίου',
    'firewall__icmp_type_allowoutbounddestinationunreachable' => 'Να επιτρέπονται εξερχόμενα μη προσβάσιμου προορισμού',


    'webdir__select_vdirs_to_remove' => 'Επιλέξτε τους καταλόγους που θέλετε να διαγράψετε',
    'webdir__select_mime_types_to_remove' => 'Επιλέξτε τους τύπους MIME που θέλετε να διαγράψετε',

    'defaultcomponents__not_activated' => 'δεν έχει ενεργοποιηθεί',

    'bt_traffic_at_domains' => 'Κυκλοφορία',

    'firewall__icmpsettingslist' => 'Κανόνες',
    'icmpsettingslist__name' => 'Όνομα κανόνα',

    '__awstats_perl_warning' => 'Χωρίς να έχει εγκατασταθεί το Perl, το AWStats δεν θα επιτρέπει στους χρήστες να ελέγχουν στατιστικά στοιχεία για τα προηγούμενα έτη.',

    'class_client__mysql_dbase_space' => 'Η τιμή υπερβαίνει το όριο του πελάτη',
    'class_client__mssql_dbase_space' => 'Η τιμή υπερβαίνει το όριο του πελάτη',
    'class_client__max_mssql_db' => 'Η τιμή υπερβαίνει το όριο του πελάτη',

    'firewall__icmp_reset_configuration' => 'Είστε βέβαιοι ότι θέλετε να επαναφέρετε τις ρυθμίσεις του τείχους προστασίας στις προεπιλεγμένες τιμές τους;',
    'firewall__icmp_panic_configuration' => 'Είστε βέβαιοι ότι θέλετε να ενεργοποιήσετε τη λειτουργία πανικού;  Ορισμένες υπηρεσίες δικτύου ενδέχεται να σταματήσουν να λειτουργούν.',


    'dns__remove_transfer_restrictions_list_items' => 'Τα παρακάτω δίκτυα θα καταργηθούν από τη λίστα ελέγχου πρόσβασης:',

    'firewall__select_rule_to_remove' => 'Επιλέξτε κανόνες για κατάργηση',

    'bt_up' => "Επάνω",
    'bt_down' => "Κάτω",
    'virtualdir__type_default_doc_name_to_add' => 'Εισαγάγετε ένα όνομα αρχείου για να το προσθέσετε στη λίστα',
    'virtualdir__select_default_doc_to_remove' => 'Επιλέξτε αρχεία που θα καταργηθούν από τη λίστα',

    'bt_install_selected' => 'Εγκατάσταση επιλεγμένου κλειδιού άδειας χρήσης', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Ο τομέας αναλύεται σε άλλη διεύθυνση IP: (%1). Διορθώστε τις ρυθμίσεις DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Ο διακομιστής αλληλογραφίας που χρησιμοποιείται αυτήν τη στιγμή, δεν υποστηρίζει την ταυτόχρονη ενεργοποίηση γραμματοκιβωτίων και ομάδων αλληλογραφίας.  Πατήστε OK για να ενεργοποιήσετε το γραμματοκιβώτιο, απενεργοποιώντας έτσι τις ομάδες αλληλογραφίας.  Πατήστε Άκυρο για να αφήσετε όλες τις ρυθμίσεις άθικτες.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Ο διακομιστής αλληλογραφίας που χρησιμοποιείται αυτήν τη στιγμή, δεν υποστηρίζει την ταυτόχρονη ενεργοποίηση γραμματοκιβωτίων και ομάδων αλληλογραφίας.  Πατήστε OK για να ενεργοποιήσετε τις ομάδες αλληλογραφίας, απενεργοποιώντας έτσι το γραμματοκιβώτιο. Πατήστε Άκυρο για να αφήσετε όλες τις ρυθμίσεις άθικτες.',

    'mysql_dbase_space_limit' => 'Όριο χώρου στη βάση δεδομένων MySQL',
    'mysql_dbase_usage' => 'Χρήση χώρου στη βάση δεδομένων MySQL',
    'mssql_dbase_space_limit' => 'Όριο χώρου βάσης δεδομένων Microsoft SQL Server',
    'mssql_dbase_usage' => 'Χρήση χώρου βάσης δεδομένων Microsoft SQL Server',

    '__statistics' => "στατιστικά στοιχεία", //indirect

    'dns__soa_minimum_value_is_big' => 'Ο καθορισμός ελάχιστης τιμής TTL που αντιστοιχεί σε περισσότερο από 3 ώρες μπορεί να καταστήσει μη προσβάσιμους τους τομείς σας για ορισμένους από τους διαχειριστές τομέων.  Σας συνιστούμε να ορίσετε μια τέτοια τιμή μόνο εάν επιμένει ο καταχωρητής ονομάτων τομέα σας.',

    'maillists__server_legend' => 'Ρυθμίσεις Mailman',
    'maillists__secure_links_text' => 'Χρησιμοποιήστε ασφαλείς συνδέσμους σε λίστες αλληλογραφίας',
    'maillists__secure_links_hint' => 'Ενεργοποιήστε ή απενεργοποιήστε την ασφαλή (HTTPS) δημιουργία συνδέσμων σε λίστες αλληλογραφίας.',

    'virusfilter__interface_not_available' => 'Δεν υπάρχουν διαθέσιμα φίλτρα ιών.',
    'virusfilter__none_virus_filter' => 'Καμία',
    'virusfilter__server_legend' => 'Ρυθμίσεις προστασίας από ιούς',
    'virusfilter__server_text' => 'Λογισμικό προστασίας από ιούς που χρησιμοποιείται',
    'virusfilter__mailname_status_text' => 'Λογισμικό προστασίας από ιούς (%1)',
    'virusfilter__status_none' => 'απενεργοποιήθηκε',
    'virusfilter__status_any' => 'εισερχόμενη και εξερχόμενη αλληλογραφία',
    'virusfilter__status_outgoing' => 'μόνο εξερχόμενη αλληλογραφία',
    'virusfilter__status_incoming' => 'μόνο εισερχόμενη αλληλογραφία',

    'visibility__adminonly' => 'Μόνο διαχειριστής',
    'visibility__button_sets' => 'Στοιχεία ελέγχου',
    'visibility__control' => 'Κάντε κλικ για να προσαρμόσετε αυτό το στοιχείο ελέγχου.',
    'visibility__customization_footnote' => 'Κάντε κλικ στο OK για να ολοκληρώσετε την προσαρμογή αυτής της οθόνης.',
    'visibility__default' => 'Προεπιλογή',
    'visibility__export_note' => "Οι ρυθμίσεις προσαρμογής που πραγματοποιήσατε πρόκειται να εξαχθούν. Θα πραγματοποιηθεί λήψη μιας δέσμης ενεργειών κελύφους στον υπολογιστή σας. Για να εφαρμόσετε αυτές τις ρυθμίσεις σε έναν άλλο διακομιστή του Plesk αντικαθιστώντας τις υπάρχουσες ρυθμίσεις διαχείρισης περιβάλλοντος εργασίας, φορτώστε και εκτελέστε τη δέσμη ενεργειών από εκεί.\n\nΣημειώστε ότι εάν έχετε πραγματοποιήσει αλλαγές σε αυτήν την οθόνη αλλά δεν έχετε πατήσει ακόμα το OK, τα δεδομένα που εξάγονται δεν θα περιλαμβάνουν τις τελευταίες αλλαγές σας.",
    'visibility__hide' => 'Απόκρυψη',
    'visibility__reset_all' => 'Επαναφορά όλων των ρυθμίσεων στις προεπιλογές',
    'visibility__reset_screen' => 'Επαναφορά της αρχικής διάταξης αυτής της οθόνης',
    'visibility__root_override_parse_error' => 'Υπάρχει ένα συντακτικό σφάλμα στο αρχείο %1 στη γραμμή %2.',
    'visibility__screen_title' => 'Διαχείριση περιβάλλοντος εργασίας',
    'visibility__set_billing_enabled' => 'Αποσύνδεση του Customer and Business Manager',
    'visibility__set_cert_puchasing' => 'Απόκρυψη κουμπιών για την αγορά πιστοποιητικών',
    'visibility__set_domain_registration' => 'Απόκρυψη κουμπιών για την καταχώρηση τομέων',
    'visibility__set_extras' => 'Απόκρυψη κουμπιά για τις πρόσθετες υπηρεσίες',
    'visibility__set_mail_bounce' => 'Απόκρυψη στοιχείων ελέγχου για μηνύματα απόρριψης για μη υπάρχουσες διευθύνσεις αλληλογραφίας',
    'visibility__show' => 'Εμφάνιση',
    'visibility__show_toolbar' => 'Εμφάνιση της γραμμής εργαλείων διαχείρισης περιβάλλοντος εργασίας',
    'visibility__standby_footnote' => 'Κάντε κλικ για να προσαρμόσετε τα στοιχεία ελέγχου σε αυτήν την οθόνη.',
    'visibility__standby_footnote_nocontrols' => 'Δεν υπάρχουν προσαρμόσιμα στοιχεία ελέγχου σε αυτήν την οθόνη.',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "Η αυτοματοποίηση της δημοσίευσης δεν υποστηρίζεται από το στοιχείο",

    'component_name__cphosting' => "Φιλοξενία Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Η ρύθμιση ορίων γραμματοκιβωτίων δεν υποστηρίζεται από τον τρέχοντα διακομιστή αλληλογραφίας.',
    '__unable_get_total_mboxes_quota' => 'Η ρύθμιση ορίων γραμματοκιβωτίων δεν υποστηρίζεται από τον τρέχοντα διακομιστή αλληλογραφίας.',

    'install_prefix__parent_not_exists' => "Ο γονικός κατάλογος δεν υπάρχει.",

    'bt_change_version' => 'Αλλαγή έκδοσης',
    'aspdotnet__changeversion_title' => 'Επιλογή έκδοσης ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Επιλογή όλων",
    '__uncheck_all' => "Απαλοιφή όλων",

    'dns__editing_domain_controller_zone' => "Η επεξεργασία των εγγραφών ζώνης DNS για τον ελεγκτή τομέα μπορεί να προκαλέσει προβλήματα στη λειτουργία του τομέα",

    'pb__interface_management' => "Διαχείριση περιβάλλοντος εργασίας",
    'interface_management__tabs_skins' => "Εμφανίσεις",
    'interface_management__tabs_interface_templates' => "Πρότυπα διασύνδεσης",
    'interface_management__tabs_locales' => "Τοπικές ρυθμίσεις",
    'locales_list__title' => "Αποθετήριο πακέτων γλωσσών",
    'locales_list__legend' => "Διαθέσιμες γλώσσες",
    'locales_list__active_title' => "Κ",
    'locales_list__locale_title' => "Πακέτο γλωσσών",
    'locales_list__lang_title' => "Γλώσσα",
    'locales_list__country_title' => "Χώρα",
    'locales_list__used_title' => "Χρησιμοποιούνται",

    'backup__suspend_warning_during_backup' => "Ο τομέας δεν θα είναι διαθέσιμος κατά τη διάρκεια της διαδικασίας δημιουργίας αντιγράφου ασφαλείας",
    'backup__suspend_warning_during_restore' => "Ο τομέας δεν θα είναι διαθέσιμος κατά τη διάρκεια της διαδικασίας επαναφοράς",
    'backup__suspend_domain' => "Αναστολή τομέα",

    'locales_list__mls_limit' => "Η τρέχουσα άδεια χρήσης του Plesk επιτρέπει τη χρήση %2 γλωσσών. Αυτήν τη στιγμή έχετε ρυθμίσει %1 γλώσσες ως διαθέσιμες στους χρήστες, υπερβαίνοντας τον αριθμό που προβλέπει η άδεια. Επιλέξτε τις %2 γλώσσες που θέλετε να χρησιμοποιείτε και καταστήστε τις υπόλοιπες μη διαθέσιμες στους χρήστες, κάνοντας κλικ στα εικονίδιά τους στη στήλη 'S'.",

    'bt_change_owner' => 'Ορισμός νέου κατόχου',
    'chown__new_owner' => 'Νέος κάτοχος',
    'chown__selected_domains' => 'Επιλεγμένες συνδρομές',
    'chown__limits_legend' => 'Πόροι',
    'chown__limit_name' => 'Όνομα πόρου',
    'chown__limit_value' => 'Εκχωρημένοι πόροι',
    'chown__limit_assigned_before' => 'Πριν τη μεταφορά',
    'chown__limit_assigned_after' => 'Μετά τη μεταφορά',
    'chown__error_limits' => "Δεν είναι δυνατή η συνέχιση της μεταφοράς της συνδρομής: η συνδρομή αυτή απαιτεί περισσότερους πόρους απ' όσους μπορεί να διαθέσει ο πάροχος του νέου κατόχου.",
    'chown__error_no_domains' => 'Δεν είναι δυνατή η συνέχιση της μεταφοράς της συνδρομής: δεν έχουν επιλεγεί συνδρομές ή οι επιλεγμένες συνδρομές ανήκουν ήδη στο χρήστη προορισμού.',
    'chown__error_empty_ip_pool' => "Δεν είναι δυνατή η συνέχιση της μεταφοράς της συνδρομής: Ο χώρος IP του παρόχου του νέου κατόχου είναι κενός.  Βεβαιωθείτε ότι ο πάροχος έχει τουλάχιστον μία διεύθυνση IP στο χώρο.",
    'chown__please_select_new_domain_owner' => 'Επιλέξτε το νέο κάτοχο γι\' αυτήν τη συνδρομή',
    'chown__old_ip_address' => 'Τρέχουσα διεύθυνση IP',
    'chown__new_ip_address' => 'Νέα διεύθυνση IP',

    'chown__error_ssl_already_used' => "Η υποστήριξη SSL/TLS χρησιμοποιείται ήδη στις ακόλουθες διευθύνσεις IP προορισμού: %1 Συνεπώς, οι παρακάτω τομείς με υποστήριξη SSL/TLS δεν ήταν δυνατό να μεταφερθούν: %2. Επιλύστε το πρόβλημα και προσπαθήστε ξανά",
    'chown__sitebuilder_not_installed' => 'Το Presence Builder δεν έχει εγκατασταθεί',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Ο τομέας %1 δεν μπορεί να μεταφερθεί σε άλλο κάτοχο επειδή το Presence Builder δεν έχει εγκατασταθεί.',

    'backup__backup_time' => 'Ώρα δημιουργίας αντιγράφων ασφαλείας',
    'backup__backup_time_hour' => 'ώρες',
    'backup__backup_time_minute' => 'λεπτά',
    'backup__every' => 'κάθε',
    'backup__day_of_month' => 'ημέρα του μήνα',

    'subdomain__select_hst_type' => 'Επιλέξτε τον τύπο φιλοξενίας για τον υποτομέα',
    'hst_sel__subdom_subfolder_hst' => 'Υποτομέας σε υποφάκελο',
    'subdomain__www_root_folder_not_exists' => 'Ο κεντρικός κατάλογος %1 της τοποθεσίας δεν υπάρχει',
    '__site_home_dir' => 'Κεντρικός κατάλογος τοποθεσίας',
    'subdomain__aspnet_disabled_domain' => 'έχει απενεργοποιηθεί από τον τομέα',

    'domains__remove_description' => 'Θα διαγραφούν όλα τα δεδομένα τομέα, συμπεριλαμβανομένων των ρυθμίσεων και του περιεχομένου του τομέα και των αντίστοιχων υποτομέων, των δεδομένων εφαρμογών web, του περιεχομένου του γραμματοκιβωτίου, της αλληλογραφίας, των ρυθμίσεων προστασίας από ιούς και φιλτραρίσματος ανεπιθύμητης αλληλογραφίας, των αρχείων καταγραφής, των δεδομένων αποθετηρίου αντιγράφων ασφαλείας τομέα και των πιστοποιητικών SSL/TLS. Αν δεν έχετε αρχείο αντιγράφου ασφαλείας στον τοπικό υπολογιστή σας, όλα τα δεδομένα θα χαθούν οριστικά.',
    'subdomains__remove_description' => 'Θα διαγραφούν όλα τα δεδομένα του υποτομέα, συμπεριλαμβανομένου του περιεχομένου και των ρυθμίσεων του υποτομέα, των δεδομένων εφαρμογών web και των αρχείων καταγραφής. Αν δεν έχετε αρχείο αντιγράφου ασφαλείας στον τοπικό υπολογιστή σας, όλα τα δεδομένα θα χαθούν οριστικά.',

    'mail__no_relay_networks' => 'Να μην χρησιμοποιούνται περιορισμοί αναμετάδοσης για τα εξής δίκτυα:',
    'mail__tabs_spam_filtering' => 'Φιλτράρισμα ανεπιθύμητης αλληλογραφίας',
    'mail__tabs_antivirus' => 'Προστασία από ιούς',
    'server_mail__usage_policy_legend' => 'Πολιτική χρήσης',
    'server_mail__for_incoming_mail' => 'για την εισερχόμενη αλληλογραφία',
    'server_mail__for_outgoing_mail' => 'για την εξερχόμενη αλληλογραφία',
    'server_mail__antivirus_direction_off' => 'Η σάρωση είναι απενεργοποιημένη',
    'server_mail__antivirus_direction_any' => 'Σάρωση εισερχόμενης και εξερχόμενης αλληλογραφίας',
    'server_mail__antivirus_direction_from' => 'Σάρωση μόνο της εξερχόμενης αλληλογραφίας',
    'server_mail__antivirus_direction_to' => 'Σάρωση μόνο της εισερχόμενης αλληλογραφίας',
    'antivirus__use_server_settings_scan' => 'Χρήση των προεπιλεγμένων ρυθμίσεων σε επίπεδο διακομιστή (Σάρωση)',
    'antivirus__use_server_settings_no_scan' => 'Χρήση των προεπιλεγμένων ρυθμίσεων σε επίπεδο διακομιστή (Χωρίς σάρωση)',
    'antivirus__check_for_viruses' => 'Σάρωση για ιούς',
    'antivirus__dont_check_for_viruses' => 'Χωρίς σάρωση για ιούς',
    'antivirus__incoming_mail' => 'Εισερχόμενη αλληλογραφία',
    'antivirus__outgoing_mail' => 'Εξερχόμενη αλληλογραφία',

    'domain_alias__CNAME_dns_record_exists' => 'Υπάρχει ήδη εγγραφή DNS CNAME με αυτό το όνομα',
    'domain_alias__A_dns_record_exists' => 'Υπάρχει ήδη εγγραφή DNS A με αυτό το όνομα',
    'domain_alias__bad_prefix' => 'Λανθασμένο πρόθεμα για ψευδώνυμο τομέα',
    'domain_alias__domain_doesnt_exist' => "Ο τομέας δεν υπάρχει",

    'dns__zone_ttl_message_info' => 'Εάν δεν έχει καθοριστεί η τιμή TTL, θα χρησιμοποιηθεί για αυτήν την εγγραφή DNS η τιμή TTL στο Πρότυπο Εγγραφής SOA (%1).',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Θα δημιουργηθεί ένα αρχείο με όνομα index.html για την ανακατεύθυνση στην επιλεγμένη εφαρμογή web.  Αν υπάρχει ήδη αρχείο με όνομα index.html, θα δημιουργηθεί ένα αντίγραφο ασφαλείας του με το όνομα index.html.old και θα αντικατασταθεί από το νέο αρχείο.  Πατήστε OK για επιβεβαίωση",

    'bt_ftp_ctrl' => "Πρόσθετοι λογαριασμοί FTP",
    'ftp_users_no_permission' => "Δεν έχετε δικαίωμα να διαχειριστείτε τους λογαριασμούς FTP γι' αυτόν τον τομέα",
    'ftp_users_limit_reached' => "Συμπληρώθηκε το όριο λογαριασμών FTP γι' αυτόν τον τομέα",
    'pb__ftp_ctrl' => "Διαχείριση FTP",
    'class_client__max_subftp_users' => "Πρόσθετοι λογαριασμοί FTP",

    '__client_form_settings' => "Ρυθμίσεις πελάτη",
    '__sbnet_client_keep_sbnet' => "Διατήρηση του αντίστοιχου λογαριασμού χρήστη στο Presence Builder",
    '__sbnet_cant_add_more_sites' => "Συμπληρώθηκε το όριο για τον αριθμό των τοποθεσιών που μπορούν να χρησιμοποιούν το Presence Builder γι' αυτόν τον πελάτη",
    '__sbnet_legend_text' => "Ενσωμάτωση Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Δημιουργία αντίστοιχου λογαριασμού χρήστη στο Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Προσπαθείτε να καταργήσετε το λογαριασμό χρήστη του Presence Builder που σχετίζεται με αυτόν τον πελάτη.  Αυτό θα διαγράψει όλες τις τοποθεσίες web του χρήστη και όλες τις άλλες σχετικές ρυθμίσεις από το σύστημα Presence Builder, αναιρώντας τη δυνατότητα επεξεργασίας των τοποθεσιών web που υπάρχουν ήδη στο Presence Builder, ακόμα και αν ενεργοποιήσετε ξανά αυτή την επιλογή αργότερα.  Εάν δημιουργήσετε ξανά λογαριασμό χρήστη στο Presence Builder σε μεταγενέστερο χρόνο, θα πρέπει να δημιουργήσετε και να δημοσιεύσετε από την αρχή όλες τις τοποθεσίες web σας. Θέλετε να απενεργοποιήσετε τη δημιουργία και δημοσίευση τοποθεσιών web μέσω του Presence Builder;",
    'sb__build_site_with_subdomains' => "Υποτομείς Δημιουργίας ιστολογίου και Συλλογής φωτογραφιών",
    '__sbnet_client_dont_have_sbuser' => "Δεν είναι δυνατή η δημιουργία και δημοσίευση της τοποθεσίας χρησιμοποιώντας το Presence Builder: Ο χρήστης Presence Builder δεν υπάρχει",

    '__component_disabled' => "Το στοιχείο είναι απενεργοποιημένο",

    'subdomains__physical_path_not_exist' => "Υπάρχουν υποτομείς που συνδέονται με ανύπαρκτους φυσικούς φακέλους",

    'dnsserver_bind_to_msdns_switching_warning' => "Προειδοποίηση: θα μεταφερθούν μόνο οι πρώτες 254 διευθύνσεις IP υποδικτύων με /8 και /16 μάσκες που βρίσκονται στη λίστα ελέγχου πρόσβασης.  Θα μεταφερθούν ως ξεχωριστές διευθύνσεις IP.  Θέλετε να συνεχίσετε;",

    '__sbnet_net_framework_required_for_site' => "Οι τοποθεσίες του Presence Builder μπορεί να απαιτούν υποστήριξη ASP.NET 2.0 στον τομέα σας. Συνιστούμε να ενεργοποιήσετε την υποστήριξη ASP.NET 2.0 εάν χρησιμοποιείτε το Presence Builder.",

    'subdomain_auto_create_dir' => "Δημιουργία φυσικού καταλόγου για τον υποτομέα",

    'sa_trainer__unable_to_get_messages_list' => "Δεν είναι δυνατή η λήψη της λίστας μηνυμάτων στο γραμματοκιβώτιο: %1",
    'sa_trainer__pass_doesnt_exist' => "Ο κωδικός πρόσβασης γι' αυτόν το λογαριασμό λείπει",

    '__sitebuilder_error' => "Παρουσιάστηκε σφάλμα κατά την προσπάθεια σύνδεσης στο Presence Builder. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για βοήθεια.",
    'wsb_error_user_not_exist' => "Αυτός ο λογαριασμός χρήστη Presence Builder δεν υπάρχει.",
    'wsb_error_site_already_exist' => "Αυτή η τοποθεσία υπάρχει ήδη στο Presence Builder.",
    'wsb_error_site_limit_reached' => "Συμπληρώθηκε το όριο του αριθμού τοποθεσιών του Presence Builder.",
    'wsb_error_internal_error' => "Παρουσιάστηκε εσωτερικό σφάλμα του Presence Builder. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για βοήθεια.",
    'wsb_error_user_already_exist' => "Υπάρχει ήδη χρήστης του Presence Builder με αυτό το όνομα.",
    'sb_error_user_not_exist' => "Ο χρήστης Presence Builder δεν υπάρχει.",
    'wsb_error_object_not_found' => "Το Presence Builder δεν κατάφερε να εντοπίσει τη σωστή καταχώρηση κεντρικού υπολογιστή.",

    'mg_no_mail_groups' => "Δεν υπάρχουν ομάδες αλληλογραφίας",

    'drweb__drweb_incoming' => 'Έλεγχος της εισερχόμενης αλληλογραφίας με λογισμικό προστασίας από ιούς',
    'drweb__drweb_outgoing' => 'Έλεγχος της εξερχόμενης αλληλογραφίας με λογισμικό προστασίας από ιούς',
    'drweb__disable_reason_serv' => 'Ο διακομιστής αλληλογραφίας δεν υποστηρίζει ρυθμίσεις φίλτρου προστασίας από ιούς σε επίπεδο γραμματοκιβωτίου',

    'vz_sitebuilder3_client_cant_be_created' => "Δεν είναι δυνατή η δημιουργία του λογαριασμού πελάτη: Δεν έχει εγκατασταθεί το SiteBuilder 3.1 ή νεότερη έκδοση",

    'chown__client_without_sitebuilder_support' => "Δεν είναι δυνατή η συνέχιση της μεταφοράς της συνδρομής: Η υπηρεσία Presence Builder δεν περιλαμβάνεται στο πρόγραμμα παροχής υπηρεσιών του νέου κατόχου ή του παρόχου του.",

    // new limits

    'class_client__max_odbc' => "Συνδέσεις ODBC",
    'cl_perm__max_odbc' => "μέγιστος αριθμός συνδέσεων ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'Κ',
    'domain_alias__list_name' => 'Όνομα ψευδωνύμου τομέα',
    'domain_alias__list_ascii_name' => 'Σε μορφή ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Διαχείριση περιβάλλοντος εργασίας',
    'pb__interface_templates' => 'Διαχείριση περιβάλλοντος εργασίας',
    'pb__interface_clients' => 'Πελάτες που χρησιμοποιούν %1',

    // service management
    'bt_service_showall' => "Εμφάνιση όλων",
    'bt_service_hideall' => "Απόκρυψη όλων",
    'bt_service_start' => "Έναρξη",
    'bt_service_stop' => "Διακοπή",
    'bt_service_restart' => "Επανεκκίνηση",
    'bt_service_disable' => "Απενεργοποίηση",
    'bt_service_manual' => "Μη αυτόματο",
    'bt_service_auto' => "Αυτόματο",
    'comp_info__statup_type' => 'Τύπος εκκίνησης',
    'service_startup_auto' => 'Αυτόματο',
    'service_startup_manual' => 'Μη αυτόματο',
    'service_startup_disabled' => 'Απενεργοποιήθηκε',
    'service_action_ok' => "Η λειτουργία με την υπηρεσία %1 ολοκληρώθηκε με επιτυχία",
    'service_action_failed_disabled_service' => "Δεν ήταν δυνατή η ολοκλήρωση της λειτουργίας με την υπηρεσία %1 γιατί είναι απενεργοποιημένη",
    'service_action_failed_error' => "Δεν ήταν δυνατή η ολοκλήρωση της λειτουργίας: %1",
    'service_group_action_ok' => "Η λειτουργία με τις ακόλουθες υπηρεσίες ολοκληρώθηκε με επιτυχία: \n %1",
    'service_group_action_disabled' => "Δεν ήταν δυνατή η ολοκλήρωση της λειτουργίας με τις ακόλουθες υπηρεσίες γιατί είναι απενεργοποιημένες: \n %1",
    'service_group_action_failed' => "Δεν είναι δυνατή η ολοκλήρωση της λειτουργίας με τις ακόλουθες υπηρεσίες: \n %1. \n Για να λάβετε λεπτομερείς πληροφορίες σφάλματος, εκτελέστε τη λειτουργία με κάθε υπηρεσία ξεχωριστά",

    // php 4vs5
    'bt_php' => "Ρυθμίσεις PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Διαθέσιμοι μεταπωλητές',
    'massmail__resellers_list_selected' => 'Επιλεγμένοι μεταπωλητές',
    'massmail__clients_list_available_for_select' => 'Διαθέσιμοι πελάτες',
    'massmail__clients_list_selected' => 'Επιλεγμένοι πελάτες',
    'massmail__advanced' => 'Για προχωρημένους',
    'bt_massmail_send' => 'Αποστολή',
    'massmail__save_template_name' => 'Αποθήκευση του κειμένου σε νέο πρότυπο με το όνομα',
    'massmail__template' => 'Πρότυπο',
    'massmail__compose_mail' => 'Μήνυμα',
    'massmail__from' => 'Από',
    'massmail__to' => 'Προς',
    'massmail__subject' => 'Θέμα',
    'massmail__body' => 'Κείμενο μηνύματος',
    'massmail__body_hint' => 'Χρησιμοποιήστε τη μεταβλητή <name> για αυτόματη εισαγωγή του ονόματος του χρήστη στο μήνυμά σας.',
    'massmail__send_to_clients' => "Πελάτες",
    'massmail__send_to_domainusers' => "Διαχειριστές τομέα",
    'massmail__send_to_admins' => "Διαχειριστές Plesk",
    'massmail_select' => 'Επιλέξτε διευθύνσεις',
    'massmail_showhide_selected' => "Εμφάνιση/απόκρυψη επιλεγμένων",
    'massmail_send_all' => "Όλες",
    'massmail_send_selected' => "Μόνο οι επιλεγμένες",
    'massmail_send_except' => "Όλες εκτός των επιλεγμένων",
    'bt_new_mass_mail_template' => "Προσθήκη προτύπου μαζικής αλληλογραφίας",
    '__mass_mail_templates_list' => "Λίστα προτύπων μηνυμάτων μαζικής αλληλογραφίας",
    'massmail__template_name' => 'Όνομα προτύπου',
    'massmail__receivers' => 'Παραλήπτες',
    'massmail__created' => 'Αποστολέας',
    'massmail__date_created' => 'Ημερομηνία δημιουργίας',
    'massmail__compose' => 'Αποστολή',
    'mass_mail__resellers_all' => 'Όλοι οι μεταπωλητές',
    'mass_mail__clients_all' => 'Όλοι οι πελάτες',
    'mass_mail__domainusers_all' => 'Όλοι οι διαχειριστές τομέα',
    'mass_mail__resellers_selected' => 'Επιλεγμένοι μεταπωλητές',
    'mass_mail__clients_selected' => 'Επιλεγμένοι πελάτες',
    'mass_mail__domainusers_selected' => 'Επιλεγμένοι διαχειριστές τομέα',
    'mass_mail__resellers_except' => 'Όλοι οι μεταπωλητές εκτός από τους επιλεγμένους',
    'mass_mail__clients_except' => 'Όλοι οι πελάτες εκτός από τους επιλεγμένους',
    'mass_mail__domainusers_except' => 'Όλοι οι διαχειριστές τομέα εκτός από τους επιλεγμένους',
    'mass_mail__admins_all' => 'Όλοι οι διαχειριστές',
    'massmailtemplateslist__title' => 'Πρότυπα μηνυμάτων μαζικής αλληλογραφίας',
    'massmail__insert_from_template' => "Εισαγωγή δεδομένων από πρότυπο",
    'massmail__select_template' => "Επιλογή προτύπου",
    'massmail__body_short_hint' => "(μόνο απλό κείμενο)",
    'massmail__from_short_hint' => "(διεύθυνση ηλεκτρονικού ταχυδρομείου ή όνομα)",
    'bt_insert' => "Εισαγωγή",
    'massmail__mail_send_successfully' => "Η αποστολή του μηνύματος ολοκληρώθηκε με επιτυχία",
    'massmail__mail_send_successfully_with_some_errors' => "Το μήνυμα εστάλη, αλλά παρουσιάστηκαν μια σειρά από σφάλματα.  Μερικοί από τους παραλήπτες ενδεχομένως να μην λάβουν το μήνυμα.  Για περισσότερες πληροφορίες, συμβουλευτείτε το εξής αρχείο καταγραφής: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Το μήνυμα δεν εστάλη. Βεβαιωθείτε ότι έχει επιλεγεί τουλάχιστον ένας παραλήπτης και ο διακομιστής αλληλογραφίας του Plesk λειτουργεί σωστά. Για περισσότερες πληροφορίες, συμβουλευτείτε το εξής αρχείο καταγραφής: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Η εισαγωγή των δεδομένων από το πρότυπο %1 ολοκληρώθηκε με επιτυχία.",
    'massmail__template_added_successfully' => "Το πρότυπο μηνύματος αποθηκεύεται με το όνομα %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Παρουσιάστηκε σφάλμα βάσης δεδομένων του Presence Builder. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για βοήθεια.",
    'wsb_error_sitebuilder_access_denied_error' => "Δεν είναι δυνατή η πρόσβαση στο αρχείο: Το Presence Builder δεν έχει δικαίωμα πρόσβασης για το απαιτούμενο αρχείο ή φάκελο. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για βοήθεια.",
    'wsb_error_sitebuilder_connection_failed' => "Δεν είναι δυνατή η σύνδεση στο Presence Builder επειδή η σύνδεση έχει χαθεί. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για βοήθεια.",
    'wsb_error_critical_during_operation' => "Παρουσιάστηκε κρίσιμο σφάλμα του Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "Παρουσιάστηκε σφάλμα άδειας χρήσης του Presence Builder:\n%1",
    'wsb_error_during_operation' => "Παρουσιάστηκε σφάλμα του Presence Builder:\n%1",
    'wsb_error_license_error' => "Παρουσιάστηκε περιορισμός της άδειας χρήσης του Presence Builder.",

    // Other
    '__confrim_service_stop' => "Προειδοποίηση! Αν διακόψετε την υπηρεσία %1, το Plesk μπορεί να σταματήσει να λειτουργεί. Είστε βέβαιοι ότι θέλετε να διακόψετε την υπηρεσία %1;",
    'virtualdir__name_is_reserved' => "Αυτό το όνομα είναι δεσμευμένο",
    'index_redirect_help_text' => 'Θα ανακατευθυνθείτε αυτόματα στην επιθυμητή τοποθεσία web.  Αν το πρόγραμμα περιήγησής σας δεν υποστηρίζει την ανακατεύθυνση, κάντε κλικ %1 εδώ %2',
    'bt_default_settings' => "Επαναφορά προεπιλογών",
    'logfiles__remove_failed' => "Δεν είναι δυνατή η διαγραφή του αρχείου %1: το αρχείο είναι κλειδωμένο από κάποια άλλη εφαρμογή.  Δοκιμάστε ξανά αργότερα",
    'subdomain__invalid_homedirectory' => "Ο καθορισμένος κεντρικός κατάλογος του υποτομέα δεν είναι έγκυρος",
    'scheduler_item__empty_filename' => "Καθορίστε το εκτελέσιμο αρχείο που θα εκτελεστεί",
    'subdomains__overlapped_domain_exists' => 'Ο υποτομέας επικαλύπτεται από τη ζώνη DNS του τομέα %1',
    'subdomains__overlapped_domain_alias_exists' => 'Ο υποτομέας επικαλύπτεται από τη ζώνη DNS του ψευδωνύμου τομέα %1',
    'services_action_none_selected' => 'Δεν ήταν δυνατή η ολοκλήρωση της λειτουργίας: επιλέξτε τις απαιτούμενες υπηρεσίες',
    'cl_perm__max_subftp_users' => "μέγιστος αριθμός πρόσθετων λογαριασμών FTP",
    'login_up__access_denied_no_cp_access' => 'Δεν επιτρέπεται η πρόσβαση. Δεν έχετε δικαίωμα πρόσβασης στο Plesk.',
    'drweb__disable_reason_admin' => "Οι ρυθμίσεις φίλτρου προστασίας από ιούς σε επίπεδο γραμματοκιβωτίου δεν επιτρέπονται σύμφωνα με την πολιτική του διακομιστή.",

    'webdirs__name_is_invalid' => 'Χρησιμοποιήστε μόνο αλφαριθμητικούς χαρακτήρες, χαρακτήρα υπογράμμισης και παύλα στο όνομα του καταλόγου.',
    'webdirs__physical_path_is_invalid' => 'Η φυσική διαδρομή δεν είναι έγκυρη ή δεν υπάρχει',
    '__use_default' => 'Χρήση προεπιλογής',
    'branding_pagetitle' => 'Ρυθμίσεις εμπορικής ταυτότητας',
    'fieldset_titlebar_setup' => "Τίτλος σελίδων του Plesk",
    'use_custom_titlebar' => "Κείμενο τίτλου",
    'odbc__dsn_list_legend' => 'Συνδέσεις ODBC DSN',

    'webalizer_preferences__title' => 'Ρυθμίσεις στατιστικών στοιχείων web',
    'webalizer_preferences__tab_hidden_referrers' => 'Κρυφές αναφορές (referrers)',
    'webalizer_preferences__tab_group_referrers' => 'Ομαδοποιημένες αναφορές (referrers)',

    'webalizer_hidden_referrer__edit_title' => 'Ιδιότητες κρυφής καταχώρησης',
    'webalizer_hidden_referrer__edit_legend' => 'Κρυφές καταχωρήσεις',
    'webalizer_hidden_referrer__referrer_type' => 'Τύπος καταχώρησης',
    'webalizer_hidden_referrer__referrer' => 'Αναφορά (referrer)',
    'webalizer_hidden_referrer__list_header' => 'Κρυφές αναφορές (referrers)',
    'webalizer_hidden_referrer__list_legend' => 'Κρυφές αναφορές (referrers)',
    'webalizer_hidden_referrer__referrer_direct_request' => 'Απευθείας αίτηση',
    'webalizer_hidden_referrer__referrer_custom_referrer' => 'Αναφορά (referrer)',
    'webalizer_hidden_referrer__remove_empty_selection' => 'Δεν έχουν επιλεγεί καταχωρήσεις',
    'webalizer_hidden_referrer__remove_title' => 'Οι παρακάτω αναφορές (referrers) δεν είναι πλέον κρυφές:',
    'webalizer_hidden_referrer__already_exist' => 'Η καταχώρηση αυτή υπάρχει ήδη.',

    'webalizer_group_referrer__list_header' => 'Αναφορές (referrers) ομάδας',
    'webalizer_group_referrer__list_legend' => 'Αναφορές (referrers) ομάδας',
    'webalizer_group_referrer__edit_title' => 'Ιδιότητες ομάδας αναφορών (referrers)',
    'webalizer_group_referrer__edit_legend' => 'Ιδιότητες ομάδας αναφορών (referrers)',
    'webalizer_group_referrer__group' => 'Ομάδα',
    'webalizer_group_referrer__referrer' => 'Αναφορά (referrer)',
    'webalizer_group_referrer__already_exist' => 'Υπάρχει ήδη αναφορά (referrer) ομάδας με αυτό το όνομα.',
    'webalizer_group_referrer__remove_empty_selection' => 'Δεν έχουν επιλεγεί αναφορές (referrers)',
    'webalizer_group_referrer__remove_title' => 'Θα καταργηθεί η ομαδοποίηση των παρακάτω τοποθεσιών αναφοράς (referrer):',

    'pb__dashboard' => 'Αρχική',

    'server_interface__page_title' => 'Ρυθμίσεις περιβάλλοντος εργασίας διακομιστή',
    'server_interface__tabs_locales' => 'Τοπικές ρυθμίσεις',
    'server_interface__tabs_skins' => 'Εμφανίσεις',
    'server_interface__tabs_interface_templates' => 'Πρότυπα διασύνδεσης',
    'bt_server_interface' => 'Προτιμήσεις περιβάλλοντος εργασίας',
    'pb__server_interface' => 'Προτιμήσεις περιβάλλοντος εργασίας',

    'bt_wizard_next' => 'Επόμενο >>',
    'bt_wizard_prev' => '<< Προηγούμενο',

    '__limit_exceeded_max_dom_server' => 'Δεν μπορείτε να φιλοξενήσετε περισσότερους τομείς σε αυτόν το διακομιστή επειδή συμπληρώθηκε το όριο του επιτρεπόμενου αριθμού τομέων σύμφωνα με το κλειδί άδειας χρήσης. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για να επιλύσετε αυτό το ζήτημα.',
    '__limit_exceeded_max_subdom_server' => 'Δεν μπορείτε να φιλοξενήσετε περισσότερους υποτομείς σε αυτόν το διακομιστή. Επικοινωνήστε με τον πάροχο υπηρεσιών σας.',
    '__limit_exceeded_max_dom_aliases_server' => 'Δεν μπορείτε να δημιουργήσετε περισσότερα ψευδώνυμα τομέα σε αυτόν το διακομιστή. Επικοινωνήστε με τον πάροχο υπηρεσιών σας.',
    '__limit_exceeded_max_wu_server' => 'Δεν μπορείτε να δημιουργήσετε περισσότερους χρήστες web επειδή συμπληρώθηκε το όριο του επιτρεπόμενου αριθμού χρηστών web στο διακομιστή σύμφωνα με το κλειδί άδειας χρήσης. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για να επιλύσετε αυτό το ζήτημα.',
    '__limit_exceeded_max_mn_server' => 'Δεν μπορείτε να δημιουργήσετε περισσότερους λογαριασμούς αλληλογραφίας επειδή συμπληρώθηκε το όριο του επιτρεπόμενου αριθμού λογαριασμών αλληλογραφίας στο διακομιστή σύμφωνα με το κλειδί άδειας χρήσης. Επικοινωνήστε με τον πάροχο υπηρεσιών σας για να επιλύσετε αυτό το ζήτημα.',

    '__limit_exceeded_max_cl_useradmin' => 'Έχετε συμπληρώσει το όριο του αριθμού λογαριασμών πελατών που προβλέπεται από το κλειδί άδειας χρήσης σας (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Έχετε συμπληρώσει το όριο του αριθμού τομέων που προβλέπεται από το κλειδί άδειας χρήσης σας (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Έχετε συμπληρώσει το όριο του αριθμού υποτομέων που προβλέπεται από το κλειδί άδειας χρήσης σας (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Έχετε συμπληρώσει το όριο του αριθμού ψευδωνύμων τομέα που προβλέπεται από το κλειδί άδειας χρήσης σας (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Δεν έχετε ελεύθερο χώρο στο δίσκο',
    '__limit_exceeded_max_wu_useradmin' => 'Έχετε συμπληρώσει το όριο του αριθμού λογαριασμών χρηστών web που προβλέπεται από το κλειδί άδειας χρήσης σας (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Έχετε συμπληρώσει το όριο του αριθμού βάσεων δεδομένων που προβλέπεται από το κλειδί άδειας χρήσης σας (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Έχετε συμπληρώσει το όριο του αριθμού γραμματοκιβωτίων που προβλέπεται από το κλειδί άδειας χρήσης σας (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Έχετε συμπληρώσει το όριο του αριθμού λογαριασμών ηλεκτρονικού ταχυδρομείου που προβλέπεται από το κλειδί άδειας χρήσης σας (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Έχετε συμπληρώσει το όριο του αριθμού λιστών αλληλογραφίας που προβλέπεται από το κλειδί άδειας χρήσης σας (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Έχετε συμπληρώσει το όριο του αριθμού τομέων (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Έχετε συμπληρώσει το όριο του αριθμού υποτομέων (%2) που επιτρέπονται από τον πάροχο υπηρεσιών σας',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Έχετε συμπληρώσει το όριο του αριθμού ψευδωνύμων τομέα (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Έχετε συμπληρώσει το όριο χρήσης χώρου στο δίσκο (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Έχετε συμπληρώσει το όριο χρήσης εύρους ζώνης ανά μήνα (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Έχετε συμπληρώσει το όριο του αριθμού χρηστών web (%2) που επιτρέπονται από τον πάροχο υπηρεσιών σας.',
    '__limit_exceeded_max_db_userclient' => 'Έχετε συμπληρώσει το όριο του αριθμού βάσεων δεδομένων (%2)',
    '__limit_exceeded_max_box_userclient' => 'Έχετε συμπληρώσει το όριο του αριθμού γραμματοκιβωτίων (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Έχετε συμπληρώσει το όριο του αριθμού λιστών αλληλογραφίας (%2)',
    '__limit_exceeded_expiration_userclient' => 'Ο λογαριασμός σας έληξε στις %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Έχετε συμπληρώσει το όριο του αριθμού υποτομέων (%2) που επιτρέπονται από τον πάροχο υπηρεσιών σας',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Έχετε συμπληρώσει το όριο του αριθμού ψευδωνύμων τομέα (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Έχετε συμπληρώσει το όριο χρήσης χώρου στο δίσκο (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Έχετε συμπληρώσει το όριο εύρους ζώνης που χρησιμοποιείται ανά μήνα (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Έχετε συμπληρώσει το όριο του αριθμού λογαριασμών χρηστών web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Έχετε συμπληρώσει το όριο του αριθμού βάσεων δεδομένων (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Έχετε συμπληρώσει το όριο του αριθμού γραμματοκιβωτίων (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Έχετε συμπληρώσει το όριο του αριθμού λιστών αλληλογραφίας (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Ο λογαριασμός σας έληξε στις %2',

    'mmt__to_none' => 'Καμία',
    'mmt__to_admin' => 'Διαχειριστής',
    'mmt__to_resellers_all' => 'Όλοι οι μεταπωλητές',
    'mmt__to_resellers_select' => 'Επιλεγμένοι μεταπωλητές',
    'mmt__to_resellers_select__available' => 'Διαθέσιμοι μεταπωλητές',
    'mmt__to_resellers_except' => 'Όλοι οι μεταπωλητές εκτός από τους επιλεγμένους',
    'mmt__to_clients_all' => 'Όλοι οι πελάτες',
    'mmt__to_clients_select' => 'Επιλεγμένοι πελάτες',
    'mmt__to_clients_select__available' => 'Διαθέσιμοι πελάτες',
    'mmt__to_clients_except' => 'Όλοι οι πελάτες εκτός από τους επιλεγμένους',

    'mmt__unable_send_empty_selection' => 'Δεν είναι δυνατή η αποστολή μαζικής αλληλογραφίας καθώς δεν έχουν επιλεγεί διευθύνσεις ηλεκτρονικού ταχυδρομείου.',
    'mmt__unable_send_to__' => 'Δεν είναι δυνατή η αποστολή μαζικής αλληλογραφίας σε:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Δεν είναι δυνατή η επικύρωση της εφαρμογή web επειδή ένα από τα απαιτούμενα αρχεία (%1) δεν βρέθηκε.  Επικοινωνήστε με τον αντιπρόσωπο τεχνικής υποστήριξής σας για βοήθεια.',
    'sapp_error_validation_spec_failed' => 'Η απεσταλμένη εφαρμογή web δεν συνάδει με τις προδιαγραφές AppPacks: %1.',
    'sapp_error_validation_register' => 'Δεν είναι δυνατή η εγγραφή της εφαρμογής web που βρίσκεται στον κατάλογο "%1": %2 Πρέπει να καταργήσετε την εφαρμογή web από το διακομιστή, διότι δεν θα λειτουργήσει σωστά.',

    'sapp__install_failed' => 'Η εγκατάσταση της εφαρμογής web απέτυχε: %1',
    'sapp__install_res_failed' => 'Η δημιουργία του απαιτούμενου πόρου απέτυχε.',

    'server_preferences__subdomains_blog_and_photo' => 'Υποτομείς Δημιουργίας ιστολογίου και Συλλογής φωτογραφιών από προεπιλογή',
    'firewall__info' => 'Για λόγους ασφαλείας, το τείχος προστασίας αποκλείει όλες τις συνδέσεις εκτός από εκείνες που επιτρέπονται ρητά.  Μπορείτε να επιτρέψετε μια σύνδεση δημιουργώντας έναν κανόνα.  Ανατρέξτε στην τεκμηρίωση για περισσότερες πληροφορίες',
    'plesk_key__blog_and_photo' => 'Δυνατότητα διαχείρισης της προεπιλεγμένης κατάστασης του πλαισίου ελέγχου των υποτομέων Δημιουργίας ιστολογίου και Συλλογής φωτογραφιών',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Δεν είναι δυνατή η αλλαγή του τύπου της διεύθυνσης IP σε αποκλειστική επειδή έχει εκχωρηθεί σε περισσότερους από έναν χρήστες.',

    // 8.1.1


    'database_server_list__mssql_server_port_undefined' => "Δεν είναι δυνατός ο προσδιορισμός του αριθμού θύρας TCP που χρησιμοποιείται από τον διακομιστή Microsoft SQL '%1': το πρωτόκολλο TCP/IP δεν έχει ενεργοποιηθεί στις ρυθμίσεις παραμέτρων δικτύου του διακομιστή ή ο διακομιστής έχει ρυθμιστεί για χρήση δυναμικών θυρών TCP. \nΓια να δώσετε τη δυνατότητα στους πελάτες σας να ρυθμίζουν αυτόματα τις παραμέτρους του τείχους προστασίας για την απομακρυσμένη πρόσβαση σε βάσεις δεδομένων, ρυθμίστε χειροκίνητα τον διακομιστή SQL ώστε να «ακούει» σε μια συγκεκριμένη σταθερή θύρα TCP.",
    '__local_server_mssql' => 'Τοπικός διακομιστής MS SQL',
    'pb__db_server_databases' => 'Διαχείριση διακομιστή βάσεων δεδομένων',

    '__write_modify_warning' => 'Η επιλογή πρόσθετων δικαιωμάτων εγγραφής/τροποποίησης θα εξασφαλίσει τη σωστή λειτουργία ορισμένων εφαρμογών web, αλλά θα αυξήσει επίσης σημαντικά τους κινδύνους ασφαλείας',
    '__write_modify_subdomain_warning' => 'Η επιλογή πρόσθετων δικαιωμάτων εγγραφής/τροποποίησης θα εξασφαλίσει τη σωστή λειτουργία ορισμένων εφαρμογών web, αλλά θα αυξήσει επίσης σημαντικά τους κινδύνους ασφαλείας',

    'phosting__php_incorrect_version_used' => "Ανιχνεύθηκαν προβλήματα έκδοσης PHP.  Για να επιλύσετε αυτά τα προβλήματα, επιλέξτε παρακάτω το πλαίσιο ελέγχου με την απαιτούμενη έκδοση PHP και κάντε κλικ στο OK.  Για να απενεργοποιήσετε το PHP σε αυτόν τον τομέα, κάντε κλικ στο OK χωρίς να επιλέξετε την έκδοση PHP",
    'fp__mail_preferences' => 'Ρυθμίσεις αλληλογραφίας',

    'mail__specify_patterns' => 'Διευθύνσεις ηλεκτρονικού ταχυδρομείου',
    'mail__specify_patterns_with_ip' => 'Διευθύνσεις ηλεκτρονικού ταχυδρομείου ή IP',
    'mail__blocker_action_text' => 'Ποια ενέργεια πρέπει να πραγματοποιείται με την αλληλογραφία που πληροί τα κριτήρια:',
    'mail__action_delete' => 'Διαγραφή από το διακομιστή',
    'mail__action_spam' => 'Σήμανση ως ανεπιθύμητη αλληλογραφία',
    'mail__action_with_mails' => 'Ενέργεια',
    'mail__white_list_action_text' => 'Email addresses specified here will not be recognized as spam by SpamAssassin.',
    'mail__smtp_white_list_action_text' => 'Οι καταχωρίσεις IP που καθορίζονται εδώ θα προστεθούν στις εξαιρέσεις του διακομιστή αλληλογραφίας.',
    'mail__invalid_white_pattern' => 'Η καθορισμένη τιμή δεν είναι έγκυρη. Χρησιμοποιήστε τις ακόλουθες μορφές: mail@example.com για διευθύνσεις ηλεκτρονικού ταχυδρομείου, example.com για τομείς.',
    'mail__white_list__text_wildcard_pattern' => 'Οι διευθύνσεις IP μπορούν να περιέχουν μπαλαντέρ (για παράδειγμα, 123.123.*.123).',
    'mail__white_list__text_cidr_pattern' => 'Οι διευθύνσεις IP μπορούν να περιέχουν μάσκες CIDR (για παράδειγμα, 10.0.0.0/8).',
    'mail__invalid_black_pattern' => 'Η καθορισμένη τιμή δεν είναι έγκυρη.  Χρησιμοποιήστε την ακόλουθη μορφή: mail@example.com για διευθύνσεις ηλεκτρονικού ταχυδρομείου, example.com για τομείς.',
    'mail__black_list_no_sa_warning' => 'Οι καταχωρήσεις δεν θα επισημανθούν ως ανεπιθύμητες επειδή το Spamassassin δεν έχει εγκατασταθεί ή είναι απενεργοποιημένο',
    'mail__smtp_white_list__text_hint' => 'Ξεχωρίστε τις πολλαπλές διευθύνσεις με κόμμα ή ερωτηματικό. Δεν πρέπει να υπάρχουν μη ASCII χαρακτήρες αριστερά του συμβόλου @. Οι διευθύνσεις μπορούν να περιέχουν τους χαρακτήρες μπαλαντέρ "*" και "?" (για παράδειγμα, *@domain.com, user?@*.com). Τα μη-ASCII τμήματα των ονομάτων τομέα δεν πρέπει να περιέχουν χαρακτήρες μπαλαντέρ.',

    'resp_edit__reply_as_html' => 'Αποστολή ως HTML',
    'exception__path_very_long' => "Η διαδρομή είναι πολύ μεγάλη.  Βεβαιωθείτε ότι η διαδρομή περιέχει λιγότερους από %1 χαρακτήρες.",

    // 8.2


    //SAPP
    'sapp_on' => 'Ενεργ.',
    'sapp_off' => 'Απενεργ.',
    'sapp_directive_aspect' => 'Απαιτούμενο',
    'sapp_databases_num' => 'Βάσεις δεδομένων',
    'sapp_db_required' => 'Απαιτούμενο',
    'sapp_Required' => 'Απαιτούμενο',
    'sapp_Variant' => 'Χαρακτηριστικό',
    'sapp_db_id' => 'Αναγνωριστικό βάσης δεδομένων',
    'sapp_db_id_type' => 'ΒΔ (αναγνωριστικό: %1) τύπος',
    'sapp_db_id_min_version' => 'ΒΔ (αναγνωριστικό: %1) ελάχ. έκδοση',
    'sapp_db_id_table_prefix' => 'ΒΔ (αναγνωριστικό: %1) πρόθεμα πίνακα',
    'sapp_Default' => 'Προεπιλεγμένη τιμή',
    'sapp_apache_mod_req' => 'Μονάδα Apache',
    'sapp_dbtype_not_installed' => 'δεν έχει εγκατασταθεί',
    'sapp_apache_mod_not_installed' => 'δεν έχει εγκατασταθεί',
    'sapp__value_error_empty' => 'Δεν επιτρέπεται κενή τιμή.',
    'sapp_error_invalid_type' => 'Η εφαρμογή "%1" δεν υποστηρίζει την απαιτούμενη ενέργεια.',
    'sapp_error_unknown_app_type' => 'Μη υποστηριζόμενος τύπος εφαρμογής: %1.',
    'sapp__ssl_text' => 'Να εγκατασταθεί η εφαρμογή σε κεντρικό υπολογιστή "http://" ή "https://";',
    'sapp__app_to_upgrade' => 'Εφαρμογές που θα αναβαθμιστούν',
    'sapp__upgrade_apps_title' => 'Αναβάθμιση εφαρμογών',
    'sapp__upgrade_to_ver' => 'Αναβάθμιση στην έκδοση',
    'sapp__choose_pkg_ver' => 'Επιλέξτε ένα πακέτο...',
    'sapp__pkg_cant_upgrade_pkg' => 'Το πακέτο "%1" δεν μπορεί να χρησιμοποιηθεί για την αναβάθμιση της εφαρμογής web "%2".',
    'sapp__app_ugrade_error' => 'Δεν είναι δυνατή η αναβάθμιση της εφαρμογής: %1. Επικοινωνήστε με το διαχειριστή του συστήματός σας.',
    'sapp__no_suitable_db_found' => 'Δεν βρέθηκε κατάλληλη βάση δεδομένων.',
    'sapp__upgrade_success' =>  'Η αναβάθμιση της εφαρμογής ολοκληρώθηκε με επιτυχία.',
    'sapp__pkg_info_changelog' => 'Ιστορικό αλλαγών',
    'sapp_requirement_legend' => 'Δυνατότητες φιλοξενίας που απαιτούνται από την εφαρμογή',

    // other
    'odbc__mssql_wsid' => 'Αναγνωριστικό σταθμού εργασίας',
    'odbc__mssql_driver' => 'Πρόγραμμα οδήγησης',
    'bt_apply' => 'Εφαρμογή',
    'tsclient_disabled' => 'Δεν έχετε δικαίωμα πρόσβασης στο σύστημα μέσω απομακρυσμένης επιφάνειας εργασίας',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Για να δημιουργήσετε ένα ψευδώνυμο αλληλογραφίας, το γραμματοκιβώτιο θα πρέπει να έχει ενεργοποιηθεί σε αυτόν το λογαριασμό ηλεκτρονικού ταχυδρομείου.  Να ενεργοποιηθεί το γραμματοκιβώτιο;',
    'mn_edit__mailbox_disable_if_has_alias' => 'Η απενεργοποίηση του γραμματοκιβωτίου θα καταργήσει τα ψευδώνυμα αλληλογραφίας καθώς θα σταματήσουν να λειτουργούν.  Να απενεργοποιηθεί το γραμματοκιβώτιο;',
    'odbc__mysql_driver' => 'Πρόγραμμα οδήγησης MySQL ODBC',
    'antivirus__disable_reason_install' => 'Δεν μπορείτε να διαχειριστείτε το λογισμικό προστασίας από ιούς επειδή δεν έχει εγκατασταθεί.',
    'antivirus__disable_reason_key' => 'Δεν μπορείτε να διαχειριστείτε το λογισμικό προστασίας από ιούς επειδή δεν έχει ενεργοποιηθεί με το κατάλληλο κλειδί άδειας χρήσης.',
    'antivirus__disable_reason_deny_personal_settings' => 'Δεν μπορείτε να διαχειριστείτε το λογισμικό προστασίας από ιούς επειδή η πολιτική του διακομιστή απαγορεύει τις μεμονωμένες ρυθμίσεις προστασίας από ιούς.',
    'component_name__sqladminmssql' => 'Microsoft SQL Webadmin',
    'change_foreign_user_password' => 'Αλλαγή κωδικού πρόσβασης',
    'change_foreign_user_password_hint' => "Ο συγκεκριμένος χρήστης δεν ανήκει σε αυτήν την εφαρμογή.  Κάντε κλικ στη σύνδεση για να μεταβείτε σε άλλη εφαρμογή και να αλλάξετε τον κωδικό πρόσβασης του χρήστη από εκεί. Για να το κάνετε αυτό, πρέπει να έχετε τα κατάλληλα δικαιώματα στην εφαρμογή.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Μορφή συμβολοσειράς',
    'lang_unknown' => 'Άγνωστη γλώσσα',
    'odbc__access_driver' => 'Πρόγραμμα οδήγησης',
    'odbc__access_pwd' => 'Κωδικός πρόσβασης',
    'odbc__access_uid' => 'Αναγνωριστικό σύνδεσης',
    'odbc__excel_driver' => 'Πρόγραμμα οδήγησης',
    'pb__cl_ed' => 'Λεπτομέρειες πελάτη',
    'pb__actionlog' => 'Αρχείο καταγραφής ενεργειών',
    'pb__cl_limits' => 'Όρια πελάτη',
    'pb__edit' => 'Επεξεργασία',
    'pb__subdom_edit' => 'Ρυθμίσεις φιλοξενίας',
    'cf__select_dsn_to_remove' => 'Επιλέξτε τουλάχιστον ένα DSN για κατάργηση',

    // NEW 8.3 FEATURES

    'firewall__port_range_warn_limit' => 'Η επεξεργασία των κανόνων γι\' αυτήν την περιοχή θυρών μπορεί να διαρκέσει αρκετή ώρα.\\nΘέλετε να συνεχίσετε;',
    'firewall__port_range_exceeds_limit' => 'Η καθορισμένη περιοχή θυρών υπερβαίνει την τιμή της διαθέσιμης περιοχής θυρών %1',

    'backup_mail_content' => 'Δημιουργία αντιγράφων ασφαλείας του περιεχομένου των γραμματοκιβωτίων',

    'maillist_import_result' => "Συνολικός αριθμός διευθύνσεων ηλεκτρονικού ταχυδρομείου στο αρχείο: %1\n αριθμός εισαγόμενων διευθύνσεων ηλεκτρονικού ταχυδρομείου: %2\n αριθμός διευθύνσεων ηλεκτρονικού ταχυδρομείου που υπάρχουν ήδη: %3\n αριθμός διπλότυπων διευθύνσεων ηλεκτρονικού ταχυδρομείου στο καθορισμένο αρχείο: %4\n αριθμός μη έγκυρων διευθύνσεων ηλεκτρονικού ταχυδρομείου στο καθορισμένο αρχείο: %5",
    'maillist_import_error' => 'Δεν είναι δυνατή η εισαγωγή της λίστας διευθύνσεων ηλεκτρονικού ταχυδρομείου',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Το αρχείο που επιλέξατε είναι κενό ή μη έγκυρο έγγραφο HTML στην επιλεγμένη κωδικοποίηση. Επιλέξτε τη σωστή κωδικοποίηση ή απλά προσθέστε περιεχόμενο στο αρχείο.",

    'dom_pref__external_mail_srv' => "Ανακατεύθυνση σε εξωτερικό διακομιστή αλληλογραφίας με τη διεύθυνση IP:",
    'mn_edit__store_messages' => 'Γραμματοκιβώτιο',

    // aps

    'sapp__before_upgrade_notice' => 'Συνιστάται να δημιουργήσετε αντίγραφο ασφαλείας της εφαρμογής και των δεδομένων των χρηστών πριν ξεκινήσετε τη διαδικασία αναβάθμισης.',
    'sapp__application_properties' => 'Ιδιότητες εφαρμογής',
    'sapp__application_root_descr' => 'Η κεντρική σελίδα της εφαρμογής',

    'sapp__aps_license_invalid_id' => 'Το κλειδί άδειας χρήσης δεν έχει έγκυρο αναγνωριστικό: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Υπάρχει ήδη άδεια χρήσης με τον αριθμό κλειδιού %1 στη βάση δεδομένων.',
    'sapp__aps_lic_del_used' => 'Δεν είναι δυνατή η διαγραφή του κλειδιού άδειας χρήσης, καθώς χρησιμοποιείται από μία από τις εγκατεστημένες εφαρμογές.',
    'sapp__aps_lic_del_unknown' => 'Δεν είναι δυνατή η διαγραφή του κλειδιού άδειας χρήσης: %1',
    'sapp__aps_cappi_duplicate' => "Αυτή η εφαρμογή βρίσκεται ήδη στο χώρο συγκέντρωσης εφαρμογών του συγκεκριμένου πελάτη",
    'sapp__appi_not_shared_no_install' => "Δεν υπάρχει καμία τέτοια εφαρμογή στο χώρο συγκέντρωσης εφαρμογών του πελάτη. Εάν θέλετε να εγκαταστήσετε την εφαρμογή σε μια τοποθεσία, θα πρέπει πρώτα να προσθέσετε την εφαρμογή στο χώρο συγκέντρωσης εφαρμογών του πελάτη.",
    'sapp__appi_shared_not_client' => "Δεν υπάρχει καμία τέτοια εφαρμογή στο χώρο συγκέντρωσης εφαρμογών του πελάτη. Εάν θέλετε να αναβαθμίσετε την εφαρμογή στην καθορισμένη έκδοση, θα πρέπει πρώτα να προσθέσετε την εφαρμογή στο χώρο συγκέντρωσης εφαρμογών του πελάτη.",
    'sapp__apply_license_script_not_found' => 'Δεν είναι δυνατή η εύρεση της δέσμης ενεργειών "εφαρμογή άδειας χρήσης" γι\' αυτήν την εφαρμογή web.',
    'sapp__unable_to_activate_key' => 'Παρουσιάστηκε σφάλμα κατά τη διάρκεια της προσπάθειας ενεργοποίησης ενός κλειδιού άδειας χρήσης: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Υπάρχουν εγκατεστημένες εφαρμογές web που απαιτούν την παρουσία αυτής της εφαρμογής web στο σύστημα.',
    'sapp__unable_to_delete_ai_in_pool' => 'Αυτή η εφαρμογή εξακολουθεί να βρίσκεται στο χώρο συγκέντρωσης εφαρμογών ενός πελάτη.  Εάν θέλετε να καταργήσετε αυτήν την εφαρμογή, πρέπει πρώτα να την καταργήσετε από τους χώρους συγκέντρωσης εφαρμογών όλων των πελατών ή να την καταστήσετε δωρεάν.',
    'sapp__unable_to_delete_app_template' => 'Δεν είναι δυνατή η κατάργηση της εφαρμογής #%1: %2',
    'sapp__limit_exceeded_client' => 'Έχετε συμπληρώσει το όριο για τον αριθμό των φορών που μπορείτε να εγκαταστήσετε αυτήν την εφαρμογή web (%2).',


    // atis module

    '_week_on' => 'εβδομάδα, την',
    '__week_first' => 'πρώτη',
    '__week_second' => 'δεύτερη',
    '__week_third' => 'τρίτη',
    '__week_fourth' => 'τέταρτη',
    '__week_last' => 'τελευταία',
    '__not_started' => 'Αναμονή',
    '__started' => 'Εκτελείται',
    '__cancel_pending' => 'Ακύρωση',
    '__canceled' => 'Ακυρώθηκε',
    '__error' => 'Σφάλμα',
    '__done' => 'Ολοκληρώθηκε',

    '__php_cgi_handler' => 'Εφαρμογή CGI',
    '__php_isapi_handler' => 'Επέκταση ISAPI',
    '__php_fastcgi_handler' => 'Εφαρμογή FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'εκτέλεση ως',

    'firewall_tabs_rules' => 'Κανόνες τείχους προστασίας',

    'cf_dbfolder_text' =>'Φάκελος βάσης δεδομένων',
    'cf_isnewdb_text' => 'Δημιουργία βάσης δεδομένων',
    'cf_isnewdb_title' => 'Επιλέξτε το πλαίσιο ελέγχου εάν η βάση δεδομένων πρέπει να δημιουργηθεί',

    'pb__site_apps_upgrade' => 'Αναβάθμιση εφαρμογής web',

    'detach' => 'Αποσύνδεση',
    'preferences' => "Αλλαγή κωδικού πρόσβασης",

    'toolsbar__switch_user?' => "Είστε βέβαιοι ότι θέλετε να συνδεθείτε με άλλο λογαριασμό χρήστη;",
    '__aps_left' => 'Εγκαταστάσεις που απομένουν',
    'aps__license_key' => 'Κλειδί άδειας χρήσης',
    'aps__download_code' => 'Λήψη κλειδιού άδειας χρήσης και κωδικός ενεργοποίησης',
    'aps__license_key_hint' => 'Ανάκτηση από το διακομιστή αδειών χρήσης χρησιμοποιώντας τον κωδικό ενεργοποίησης',
    'aps__database_not_available' => 'δεν είναι διαθέσιμο, ελέγξτε τα όρια τομέα ή πελάτη',
    'aps__yes' => 'ναι',
    'aps__no' => 'όχι',
    '__click_to_enlarge' => 'Κάντε κλικ για μεγέθυνση',
    'site_apps__back_to_list' => 'Επιστροφή στη λίστα',
    'sapp__pkg_info_installation_requirements' => 'Απαιτήσεις εγκατάστασης',
    '__close_window' => 'Κλείσιμο',

    //SAPP END

    'skin_info__already_default' => 'Η εμφάνιση έχει ήδη οριστεί ως προεπιλογή.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Ρυθμίσεις Plesk Premium Antivirus για το %1',
    'drweb:properties_legend' => 'Ρυθμίσεις',
    'drweb:status' => 'Έλεγχος αλληλογραφίας για ιούς',

    // sb integration
    'sitebuilder_wizard' => 'Οδηγός Presence Builder',
    'dom_site_builder' => 'Κάντε κλικ για να ανοίξετε τον οδηγό Presence Builder.',
    'sb_plesk_admin_url' => 'Διεύθυνση URL διακομιστή Presence Builder.  Βεβαιωθείτε ότι η διεύθυνση αυτή αναλύεται σωστά στο DNS',
    'sb_plesk_admin_login' => 'Όνομα χρήστη για τη σύνδεση του διαχειριστή του διακομιστή στο Presence Builder',
    'sb_plesk_admin_password' => 'Κωδικός πρόσβασης διαχειριστή',
    'sb_sitebuilder_preferences' => 'Διαπιστευτήρια διαχειριστή Presence Builder',
    'sb__server' => 'Προτιμήσεις διαχειριστή συστήματος Presence Builder',
    'sb__sitebuilder_support' => 'Υποστήριξη Presence Builder',
    'sb_keep_sb_user' => 'Διατήρηση του αντίστοιχου λογαριασμού χρήστη στο Presence Builder',
    'sb_create_sb_user' => 'Δημιουργία αντίστοιχου λογαριασμού χρήστη στο Presence Builder',
    'sb__build_site_using_sitebuilder' => "Δημιουργία τοποθεσίας web χρησιμοποιώντας το Presence Builder",
    'sb_no_current_sb_server_set' => 'Η σύνδεση με το Presence Builder δεν έχει ρυθμιστεί ακόμα: πρέπει να προσθέσετε μια εγγραφή A στο πρότυπο ζώνης DNS που θα παραπέμπει στο διακομιστή του Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Δεν είναι δυνατή η ανάκτηση των πληροφοριών από το σύστημα Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Δεν είναι δυνατή η σύνδεση με το Presence Builder: λανθασμένο όνομα χρήστη ή κωδικός πρόσβασης.",
    'sb_init_sb_manager' => "Προετοιμασία της διαχείρισης Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Η σύνδεση με το σύστημα Presence Builder απέτυχε.",
    'sb_err_client_dont_have_sbuser' => "Αυτός ο πελάτης δεν έχει λογαριασμό χρήστη στο Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Το Presence Builder δεν έχει διαμορφωθεί.",
    'sb_err_you_dont_have_sbaccount' => "Αποτυχία ελέγχου ταυτότητας στο Presence Builder.",
    'sb_error_critical_during_operation' => "Παρουσιάστηκε το ακόλουθο σφάλμα στο Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Η υποστήριξη καθολικής σύνδεσης δεν είναι ενεργοποιημένη στο Plesk.",

    'forbid_create_dns_subzone' => "Να απαγορεύεται στους χρήστες να δημιουργούν υποζώνες DNS στις υποζώνες DNS άλλων χρηστών",
    'warning__super_zone_exist' => "Η ζώνη %1 δημιουργήθηκε, ωστόσο αυτό το όνομα ζώνης είναι υποζώνη μιας άλλης ήδη υπάρχουσας ζώνης %2, η οποία ανήκει σε άλλο χρήστη %3. Η δημιουργία της είναι εφικτή, αλλά πρέπει να βεβαιωθείτε ότι έχετε επιλέξει το σωστό λογαριασμό χρήστη.",
    'error__super_zone_exist' => "Δεν είναι δυνατή η δημιουργία της ζώνης DNS επειδή η υπερζώνη της ανήκει σε άλλο χρήστη.",

    'locales__files_not_exits' => 'Δεν είναι δυνατή η αλλαγή των τοπικών ρυθμίσεων: τα καθορισμένα αρχεία πακέτων γλωσσών περιβάλλοντος εργασίας δεν υπάρχουν στο σύστημα.',
    'locales__unavailable' => 'Δεν είναι δυνατή η αλλαγή των τοπικών ρυθμίσεων: το καθορισμένα αρχείο πακέτου γλωσσών περιβάλλοντος εργασίας δεν υπάρχει στο σύστημα.',

    // DB BU

    'pb__dbbackup_list' => 'Αρχεία αντιγράφων ασφαλείας βάσεων δεδομένων',
    // server
    'dbbackup__server_backup_settings' => 'Αντίγραφο ασφαλείας',
    'dbbackup__network_temp_dir' => 'Προσωρινός κατάλογος δικτύου',
    'dbbackup__network_user' => 'Όνομα χρήστη',
    'dbbackup__network_pass' => 'Κωδικός πρόσβασης',
    // domain
    'dbbackup__add_database_legend' => 'Επαναφορά βάσης δεδομένων για την οποία δημιουργήθηκε αντίγραφο ασφαλείας',
    'dbbackup__add_database_restore' => 'Επαναφορά βάσης δεδομένων από αρχείο αντιγράφου ασφαλείας',
    'dbbackup__add_database_file' => 'Αρχείο αντιγράφου ασφαλείας βάσης δεδομένων',
    'dbbackup__add_database_user' => 'Προεπιλεγμένο όνομα χρήστη',
    'dbbackup__add_database_pass' => 'Κωδικός πρόσβασης προεπιλεγμένου χρήστη',
    'dbbackup__add_database_pass2' => 'Επιβεβαίωση κωδικού πρόσβασης προεπιλεγμένου χρήστη',

    'bt_dbbackup_now' => 'Αντίγραφο ασφαλείας',

    'bt_repair' => 'Επιδιόρθωση',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Η αποστολή αρχείων ένδειξης σφαλμάτων βάσεων δεδομένων SQL Server απαγορεύεται από τον πάροχο υπηρεσιών φιλοξενίας.',

    // APS categories

    'cf_invalid_password' => 'Ο κωδικός πρόσβασης δεν μπορεί να περιέχει περισσότερους από 16 χαρακτήρες',
    'cf_invalid_description_length' => 'Η περιγραφή δεν μπορεί να περιέχει περισσότερα από 256 σύμβολα',
    'ip_addr__ip_used_by_external_mail_server' => 'Η διεύθυνση IP %1 χρησιμοποιείται ήδη από τον εξωτερικό διακομιστή αλληλογραφίας',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Μη έγκυρο όνομα χρήστη ή κωδικός πρόσβασης του λογαριασμού FTP.  Εισαγάγετε τα σωστά διαπιστευτήρια του χρήστη FTP.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Συμπληρώθηκε το όριο των αλλαγών σειριακού αριθμού. Δεν μπορούν να πραγματοποιηθούν άλλες αλλαγές ζώνης DNS σήμερα.',
    'dns__zone_apply_changes' => 'Οι αλλαγές που πραγματοποιήθηκαν στις εγγραφές DNS δεν έχουν αποθηκευτεί ακόμα.  Οι αλλαγές που πραγματοποιήθηκαν επισημαίνονται παρακάτω.  Κάντε κλικ στο Ενημέρωση για να εφαρμόσετε τις αλλαγές στη ζώνη DNS ή κάντε κλικ στο Επαναφορά για να απορρίψετε τις αλλαγές.',
    'dns__update_dns_zone' => 'Κάντε κλικ για να αποθηκεύσετε τις αλλαγές που πραγματοποιήθηκαν στις εγγραφές DNS',
    'dns__revert_dns_zone' => 'Κάντε κλικ για να ακυρώσετε τις αλλαγές που πραγματοποιήθηκαν στις εγγραφές DNS',
    'bt_revert' => 'Επαναφορά',
    'dns__dns_zone_has_beed_updated' => 'Οι αλλαγές που πραγματοποιήθηκαν στις εγγραφές DNS αποθηκεύτηκαν.',
    'dns__dns_zone_has_beed_reverted' => 'Οι αλλαγές που πραγματοποιήθηκαν στις εγγραφές DNS ακυρώθηκαν',
    'db__nondefault_server_not_allowed' => 'Δεν επιτρέπεται η χρήση μη προεπιλεγμένου διακομιστή βάσεων δεδομένων',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Λογαριασμοί και τομείς του πελάτη %1.',
    'ui__client__disabled-warning' => 'Ο λογαριασμός του πελάτη %1 έχει ανασταλεί.',
    'ui__client__none-available' => 'Δεν έχουν ρυθμιστεί λογαριασμοί πελατών.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Πελάτης %1',
    'ui__client_self__description' => 'Λίστα των τομέων μου.',
    'ui__client_self__short-title' => 'Οι τομείς μου',
    'ui__client_self__title' => 'Οι τομείς μου',


    'site_apps__non_removable' => 'Στοιχεία που δεν μπορούν να καταργηθούν',
    'site_apps__non_removable_items' => 'Δεν είναι δυνατή η κατάργηση των ακόλουθων εφαρμογών web:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Δεν υπάρχουν προσαρμοσμένα κουμπιά.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Δεν υπάρχουν προσαρμοσμένα κουμπιά στον Πίνακα Πελάτη του πελάτη %1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Κατάργηση του κουμπιού %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Κατάργηση',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Κατάργηση του κουμπιού %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Κατάργηση προσαρμοσμένων κουμπιών από τον Πίνακα πελάτη',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Κατάργηση',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Κατάργηση προσαρμοσμένων κουμπιών',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Κατάργηση κουμπιών',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Επιλέξτε έναν πελάτη τα προσαρμοσμένα κουμπιά του οποίου θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Επιλέξτε τα προσαρμοσμένα κουμπιά που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Επιβεβαιώστε την κατάργηση των κουμπιών επιλέγοντας το πλαίσιο ελέγχου σε αυτήν την οθόνη και, στη συνέχεια, κάντε κλικ στο Τέλος.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Κατάργηση ενός προσαρμοσμένου κουμπιού από τον Πίνακα Πελάτη του πελάτη.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Κατάργηση',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Κατάργηση ενός προσαρμοσμένου κουμπιού',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Κατάργηση προσαρμοσμένου κουμπιού',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Επιλέξτε έναν πελάτη το προσαρμοσμένο κουμπί του οποίου θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Επιλέξτε το προσαρμοσμένο κουμπί που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Επιβεβαιώστε την κατάργηση του προσαρμοσμένου κουμπιού επιλέγοντας το πλαίσιο ελέγχου σε αυτήν την οθόνη και, στη συνέχεια, κάντε κλικ στο Τέλος.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Επεξεργασία των ιδιοτήτων του κουμπιού σε επίπεδο πελάτη %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Ρυθμίσεις',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Τροποποίηση του προσαρμοσμένου κουμπιού %1 του πελάτη',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Προσθήκη προσαρμοσμένου κουμπιού',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Επιλέξτε έναν πελάτη στον Πίνακα Πελάτη του οποίου θέλετε να δημιουργήσετε ένα προσαρμοσμένο κουμπί και κάντε κλικ στο Επόμενο>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Για να δημιουργηθεί το κουμπί, κάντε κλικ στο Τέλος.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Αλλαγή των ιδιοτήτων ενός κουμπιού στον Πίνακα Πελάτη του πελάτη.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Ιδιότητες',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Αλλαγή των ιδιοτήτων ενός κουμπιού στον Πίνακα Πελάτη του πελάτη',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Αλλαγή ιδιοτήτων προσαρμοσμένου κουμπιού',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Επιλέξτε έναν πελάτη το προσαρμοσμένο κουμπί του οποίου θέλετε να τροποποιήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Επιλέξτε το προσαρμοσμένο κουμπί που θέλετε να τροποποιήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Όταν ολοκληρώσετε την επεξεργασία των ιδιοτήτων του κουμπιού, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Να καταστεί το κουμπί %1 μη διαθέσιμο στους πελάτες σας.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Να καταστεί μη διαθέσιμο στους πελάτες σας',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Να καταστεί το κουμπί %1 μη διαθέσιμο στους πελάτες σας',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Να καταστεί το κουμπί %1 ορατό στους χρήστες του πελάτη.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Να καταστεί διαθέσιμο στους πελάτες σας',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Να καταστεί το κουμπί %1 ορατό στους χρήστες του πελάτη',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Καταστήστε ένα προσαρμοσμένο κουμπί διαθέσιμο/μη διαθέσιμο στους πελάτες σας.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Διαθέσιμο/μη διαθέσιμο στους πελάτες σας',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Καταστήστε ένα προσαρμοσμένο κουμπί διαθέσιμο ή μη διαθέσιμο στους πελάτες σας',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Καταστήστε ένα προσαρμοσμένο κουμπί διαθέσιμο/μη διαθέσιμο στους πελάτες σας.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Επιλέξτε έναν πελάτη το προσαρμοσμένο κουμπί του οποίου θέλετε να καταστήσετε διαθέσιμο ή μη διαθέσιμο στους χρήστες του πελάτη και κάντε κλικ στο Επόμενο >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Επιλέξτε ένα προσαρμοσμένο κουμπί που θέλετε να καταστήσετε διαθέσιμο ή μη διαθέσιμο στους πελάτες σας και κάντε κλικ στο Επόμενο >>.',

    'ui__client/domain__description' => 'Διαχείριση τομέα %1.',
    'ui__client/domain__disabled-warning' => 'Ο τομέας %1 έχει ανασταλεί.',
    'ui__client/domain__none-available' => 'Δεν έχετε τομείς.',
    'ui__client/domain__none-available__1' => 'Ο λογαριασμός του %1 δεν έχει τομείς.',
    'ui__client/domain__none-available__2' => 'Ο λογαριασμός του %1 δεν έχει τομείς.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Τομέας %1',
    'ui__client/domain_self__description' => 'Διαχείριση του τομέα σας.',
    'ui__client/domain_self__disabled-warning' => 'Ο τομέας σας έχει ανασταλεί.',
    'ui__client/domain_self__quick-search' => 'Οι τομείς μου',
    'ui__client/domain_self__short-title' => 'Ο τομέας μου',
    'ui__client/domain_self__title' => 'Ο τομέας μου',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Δεν υπάρχουν τοποθετημένα προσαρμοσμένα κουμπιά στον Πίνακα Πελάτη του πελάτη.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Ο πελάτης %1 δεν έχει προσαρμοσμένα κουμπιά στον Πίνακα Πελάτη.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Δεν υπάρχουν προσαρμοσμένα κουμπιά για τον τομέα %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Κατάργηση του προσαρμοσμένου κουμπιού %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Κατάργηση',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Κατάργηση του προσαρμοσμένου κουμπιού %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Κατάργηση προσαρμοσμένων κουμπιών.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Κατάργηση',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Κατάργηση προσαρμοσμένων κουμπιών',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Κατάργηση προσαρμοσμένων κουμπιών',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Επιλέξτε τον πελάτη για τον οποίο θέλετε να καταργήσετε τα κουμπιά από τον πίνακα διαχείρισης τομέα και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Επιλέξτε τον τομέα για τον οποίο θέλετε να καταργήσετε τα κουμπιά από τον πίνακα διαχείρισης και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Επιλέξτε τα προσαρμοσμένα κουμπιά που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Επιβεβαιώστε την κατάργηση των κουμπιών επιλέγοντας τα αντίστοιχα πλαίσια ελέγχου και κάντε κλικ στο Τέλος για να καταργήσετε τα κουμπιά και να κλείσετε τον οδηγό.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Κατάργηση ενός προσαρμοσμένου κουμπιού.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Κατάργηση',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Κατάργηση ενός προσαρμοσμένου κουμπιού',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Κατάργηση ενός προσαρμοσμένου κουμπιού',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Επιλέξτε τον πελάτη για τον οποίο θέλετε να καταργήσετε το προσαρμοσμένο κουμπί από τον πίνακα διαχείρισης τομέα και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα για τον οποίο θέλετε να καταργήσετε το κουμπί από τον πίνακα διαχείρισης και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Επιλέξτε το προσαρμοσμένο κουμπί που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Επιβεβαιώστε την κατάργηση του προσαρμοσμένου κουμπιού επιλέγοντας το αντίστοιχο πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να καταργήσετε το κουμπί και να κλείσετε τον οδηγό.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Αλλαγή των ιδιοτήτων του προσαρμοσμένου κουμπιού %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Ιδιότητες",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Αλλαγή των ιδιοτήτων του προσαρμοσμένου κουμπιού %1 στον Πίνακα Πελάτη.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Προσθήκη κουμπιού',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Επιλέξτε τον πελάτη στον Πίνακα Πελάτη του οποίου θέλετε να τοποθετήσετε το κουμπί και κάντε κλικ στο Επόμενο>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Επιλέξτε τη συνδρομή όπου θέλετε να τροποποιήσετε το κουμπί και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Κάντε κλικ στο Τέλος για να δημιουργήσετε το κουμπί και να κλείσετε τον οδηγό.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Αλλαγή των ιδιοτήτων ενός κουμπιού στον Πίνακα Πελάτη.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Ιδιότητες',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Αλλαγή των ιδιοτήτων ενός κουμπιού στον Πίνακα Πελάτη',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Αλλαγή ιδιοτήτων κουμπιού',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Επιλέξτε το προσαρμοσμένο κουμπί τις ρυθμίσεις του οποίου θέλετε να τροποποιήσετε και κάντε κλικ στο Επόμενο >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Όταν ολοκληρώσετε την αλλαγή των ιδιοτήτων του κουμπιού, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Καταστήστε το κουμπί %1 μη διαθέσιμο στους χρήστες αλληλογραφίας αυτού του τομέα.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Μη διαθέσιμο στους χρήστες αλληλογραφίας',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Καταστήστε το κουμπί %1 μη διαθέσιμο στους χρήστες αλληλογραφίας αυτού του τομέα',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Καταστήστε το κουμπί %1 ορατό στους χρήστες αλληλογραφίας του τομέα.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Προσβάσιμο στους χρήστες αλληλογραφίας αυτού του τομέα',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Καταστήστε το προσαρμοσμένο κουμπί %1 ορατό στους χρήστες αλληλογραφίας αυτού του τομέα',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Καταστήστε ένα προσαρμοσμένο κουμπί διαθέσιμο ή μη διαθέσιμο στους άλλους χρήστες.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Διαθέσιμο/μη διαθέσιμο στους άλλους χρήστες',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Καταστήστε ένα προσαρμοσμένο κουμπί διαθέσιμο ή μη διαθέσιμο στους χρήστες αλληλογραφίας',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Καταστήστε ένα προσαρμοσμένο κουμπί διαθέσιμο ή μη διαθέσιμο στους άλλους χρήστες',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα όπου είναι τοποθετημένο το κουμπί και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Επιλέξτε ένα κουμπί που θέλετε να καταστήσετε διαθέσιμο ή μη διαθέσιμο στους άλλους χρήστες και κάντε κλικ στο Επόμενο >>.',

    'ui__client/domain/delete__description' => 'Κατάργηση του τομέα %1.',
    'ui__client/domain/delete__short-title' => 'Κατάργηση',
    'ui__client/domain/delete__title' => 'Κατάργηση του τομέα %1',
    'ui__client/domain/delete_multi__description' => 'Κατάργηση τομέων.',

    'ui__client/domain/delete_multi__short-title' => 'Κατάργηση',
    'ui__client/domain/delete_multi__title' => 'Κατάργηση τομέων',
    'ui__client/domain/delete_multi__wizard-title' => 'Κατάργηση τομέων',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Επιλέξτε τους τομείς που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Επιβεβαιώστε την κατάργηση των τομέων επιλέγοντας το αντίστοιχο πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να τους καταργήσετε και να κλείσετε τον οδηγό.',
    'ui__client/domain/delete_unknown__description' => 'Κατάργηση τομέα.',
    'ui__client/domain/delete_unknown__short-title' => 'Κατάργηση',
    'ui__client/domain/delete_unknown__title' => 'Κατάργηση τομέα',
    'ui__client/domain/delete_unknown__wizard-title' => 'Προσθήκη τομέα',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Επιβεβαιώστε την κατάργηση του τομέα επιλέγοντας το αντίστοιχο πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να τον καταργήσετε και να κλείσετε τον οδηγό.',

    'ui__client/domain/hosting__none-available' => 'Δεν υπάρχουν τομείς με ρυθμισμένη φιλοξενία περιεχομένου web.  Για να αποκτήσετε πρόσβαση σε αυτήν τη λειτουργία, δημιουργήστε έναν τομέα και ρυθμίστε τη φιλοξενία περιεχομένου web σε αυτόν.',
    'ui__client/domain/hosting__none-available__1' => 'Αυτός ο λογαριασμός χρήστη δεν διαθέτει τομείς με ρυθμισμένη φιλοξενία περιεχομένου web.  Ρυθμίστε τη φιλοξενία περιεχομένου web στον απαιτούμενο τομέα για να αποκτήσετε πρόσβαση σε αυτήν τη λειτουργία.',
    'ui__client/domain/hosting__none-available__2' => 'Η φιλοξενία περιεχομένου web δεν έχει ρυθμιστεί για τον τομέα %1. Ρυθμίστε τη φιλοξενία περιεχομένου web στον τομέα %1 για να αποκτήσετε πρόσβαση σε αυτήν τη λειτουργία.',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => 'Διαχείριση των αρχείων και των καταλόγων σας',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα τα αρχεία του οποίου θέλετε να επεξεργαστείτε.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => 'Δεν έχει ρυθμιστεί ακόμα φιλοξενία στον τομέα. Ρυθμίστε τη φυσική φιλοξενία και κάντε κλικ στο Επόμενο >> για να μεταβείτε στο πρόγραμμα διαχείρισης αρχείων.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => 'Δεν έχει ρυθμιστεί ακόμα φιλοξενία στον τομέα σας. Ρυθμίστε τη φυσική φιλοξενία και κάντε κλικ στο Επόμενο >> για να μεταβείτε στο πρόγραμμα διαχείρισης αρχείων.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => 'Όταν ολοκληρώσετε την επεξεργασία των αρχείων και των καταλόγων, κάντε κλικ στο Τέλος για να κλείσετε τον οδηγό.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => 'Όταν ολοκληρώσετε την επεξεργασία των αρχείων και των καταλόγων, κάντε κλικ στο Τέλος για να κλείσετε τον οδηγό.',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => 'Προβολή ρυθμίσεων απόδοσης φιλοξενίας',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => 'Προσαρμογή ρυθμίσεων απόδοσης φιλοξενίας περιεχομένου web',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => 'Επιλέξτε τον τομέα τις ρυθμίσεις απόδοσης φιλοξενίας του οποίου θέλετε να δείτε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα τις ρυθμίσεις απόδοσης φιλοξενίας του οποίου θέλετε να διαμορφώσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => 'Προσαρμόστε τις ρυθμίσεις απόδοσης φιλοξενίας στον τομέα και κάντε κλικ στο Τέλος.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => 'Όταν ολοκληρώσετε την προβολή των ρυθμίσεων απόδοσης φιλοξενίας στον τομέα, κάντε κλικ στο Τέλος.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => 'Όταν ολοκληρώσετε την προβολή των ρυθμίσεων απόδοσης φιλοξενίας στον τομέα σας, κάντε κλικ στο Τέλος.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => 'Όταν ολοκληρώσετε την προβολή των ρυθμίσεων απόδοσης φιλοξενίας στον τομέα, κάντε κλικ στο Τέλος.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => 'Όταν ολοκληρώσετε τη διαμόρφωση των ρυθμίσεων απόδοσης φιλοξενίας στον τομέα σας, κάντε κλικ στο Τέλος.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => 'Όταν ολοκληρώσετε τη διαμόρφωση των ρυθμίσεων απόδοσης φιλοξενίας στον τομέα, κάντε κλικ στο Τέλος.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Πελάτες",
    'ui__client/domain/hosting/application#list_header__description__title' => "Περιγραφή",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Στοιχεία",
    'ui__client/domain/hosting/application#list_header__name__title' => "Όνομα",
    'ui__client/domain/hosting/application#list_header__release__title' => "Έκδοση",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Ταξινόμηση κατά πελάτες",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Ταξινόμηση κατά περιγραφή",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Ταξινόμηση κατά στοιχεία",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Ταξινόμηση κατά όνομα",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Ταξινόμηση κατά κυκλοφορία",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Ταξινόμηση κατά έκδοση",
    'ui__client/domain/hosting/application#list_header__title' => "Εφαρμογές web",
    'ui__client/domain/hosting/application#list_header__version__title' => "Εκδόσεις",

    'ui__client/domain/properties__client_ip_address_was_assigned' => 'Η διεύθυνση IP %%ip_address%% εκχωρήθηκε στον %%client_name%%.',
    'ui__client/domain/properties__client_ip_pool_is_empty' => 'Ο χώρος IP του χρήστη είναι κενός.  Η επιλεγμένη διεύθυνση IP θα εκχωρηθεί στον αντίστοιχο λογαριασμό χρήστη.',

    'ui__client/domain/properties_new-adhoc__wizard__3_new' => 'Ο νέος τομέας θα δημιουργηθεί αμέσως μόλις κάνετε κλικ στο Επόμενο >>.',

    'ui__client/domain/properties_new__wizard-title' => 'Δημιουργία τομέα',
    'ui__client/domain/properties_new__wizard__1_unknown' => 'Επιλέξτε τον πελάτη για τον οποίο θέλετε να δημιουργήσετε τον τομέα.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties' => 'Επιλέξτε τον επιθυμητό τύπο υπηρεσίας φιλοξενίας και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_forwarding' => 'Όταν ολοκληρώσετε τη ρύθμιση παραμέτρων της προώθησης στον τομέα, κάντε κλικ στο Τέλος για να εφαρμόσετε τις παραμέτρους και να κλείσετε τον οδηγό.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_phosting' => 'Όταν ολοκληρώσετε τη ρύθμιση της υπηρεσίας φιλοξενίας στον τομέα, κάντε κλικ στο Τέλος για να εφαρμόσετε όλες τις αλλαγές και να κλείσετε τον οδηγό.',

    'ui__client/domain/properties_unknown__wizard-title' => 'Ρύθμιση του λογαριασμού του διαχειριστή τομέα',
    'ui__client/domain/properties_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα για τον οποίο θέλετε να ρυθμίσετε το λογαριασμό του διαχειριστή τομέα.',
    'ui__client/domain/properties_unknown__wizard__3' => 'Για να ολοκληρώσετε τη δημιουργία του λογαριασμού διαχειριστή τομέα, κάντε κλικ στο Τέλος.',
    'ui__client/domain/properties_unknown__wizard__3_self' => 'Κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',

    'ui__client/domain/report/anon-ftp-stats_unknown__description' => 'Στατιστικά στοιχεία ανώνυμου FTP για έναν τομέα',
    'ui__client/domain/report/anon-ftp-stats_unknown__short-title' => 'Στατιστικά στοιχεία ανώνυμου FTP',
    'ui__client/domain/report/anon-ftp-stats_unknown__title' => 'Στατιστικά στοιχεία ανώνυμου FTP για έναν τομέα',

    'ui__client/domain/report/ftp-stats_unknown__description' => 'Στατιστικά στοιχεία FTP για έναν τομέα',
    'ui__client/domain/report/ftp-stats_unknown__short-title' => 'Στατιστικά στοιχεία FTP',
    'ui__client/domain/report/ftp-stats_unknown__title' => 'Στατιστικά στοιχεία FTP για έναν τομέα',

    'ui__client/domain/report/traffic__description' => 'Προβολή χρήσης εύρους ζώνης από την τοποθεσία %1',
    'ui__client/domain/report/traffic__short-title' => 'Χρήση εύρους ζώνης',
    'ui__client/domain/report/traffic__title' => 'Εύρος ζώνης που χρησιμοποιείται από την τοποθεσία %1',

    'ui__client/domain/report/web-stats-ssl_unknown__description' => 'Στατιστικά στοιχεία για τις ασφαλείς επισκέψεις στην τοποθεσία',
    'ui__client/domain/report/web-stats-ssl_unknown__short-title' => 'Στατιστικά στοιχεία επισκέψεων μέσω SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_unknown__title' => 'Στατιστικά στοιχεία για τις ασφαλείς επισκέψεις στην τοποθεσία',

    'rpt_reseller_section_general' => 'Γενικά',
    'rpt_reseller_section_domains' => 'Τομείς',
    'rpt_reseller_section_clients' => 'Πελάτες',
    'statistics__cl_active_domains' => "Ενεργοί τομείς",
    'rpt_reseller_cl_domains' => "Τομείς",
    'rpt_reseller_cl_subdomains' => "Υποτομείς",
    'by__cl_domains' => "τομείς πελατών",
    'dom_ctrl__cl_mboxes' => "Γραμματοκιβώτια",
    'rpt_reseller_cl_redirects' => "Διακομιστές προώθησης",
    'rpt_reseller_cl_mail_groups' => "Ομάδες αλληλογραφίας",
    'rpt_reseller_cl_mail_resps' => "Αυτόματες απαντήσεις",
    'rpt_reseller_cl_mail_lists' => "Λίστες αλληλογραφίας",
    'rpt_reseller_cl_web_users' => "Χρήστες web",
    'rpt_reseller_cl_data_bases' => "Βάσεις δεδομένων",

    'statistics__active_clients' => 'Πελάτες με ενεργές συνδρομές',
    'statistics__clients_active_domains' => 'Ενεργοί τομείς',
    'statistics__clients_doms' => 'Τομείς',
    'statistics__cl_doms' => 'Τομείς',
    '__clients_subdomains' => 'Υποτομείς',
    '__clients_domains' => 'Τομείς',
    'dom_ctrl__clients_mboxes' => 'Γραμματοκιβώτια',
    'dom_ctrl__clients_redir' => 'Διακομιστές προώθησης',
    'dom_ctrl__clients_mg' => 'Ομάδες αλληλογραφίας',
    'dom_ctrl__clients_resp' => 'Αυτόματες απαντήσεις',
    'dom_ctrl__clients_maillists' => 'Λίστες αλληλογραφίας',
    'dom_ctrl__clients_wu' => 'Χρήστες web',
    'dom_ctrl__clients_db' => 'Βάσεις δεδομένων',

    'dom_ctrl__cl_redir' => 'Διακομιστές προώθησης', // to resolve!
    'dom_ctrl__cl_mg' => 'Ομάδες αλληλογραφίας', // to resolve!
    'dom_ctrl__cl_resp' => 'Αυτόματες απαντήσεις', // to resolve!
    'dom_ctrl__cl_maillists' => 'Λίστες αλληλογραφίας', // to resolve!
    'dom_ctrl__cl_wu' => 'Χρήστες web', // to resolve!
    'dom_ctrl__cl_db' => 'Βάσεις δεδομένων', // to resolve!

    'rpt_cl_section_clients' => 'Πελάτες',

    'rpt_admin_section_general' => 'Γενικά',
    'rpt_admin_section_resellers' => 'Μεταπωλητές',
    'rpt_admin_section_clients' => 'Πελάτες',
    'rpt_admin_section_personal_clients' => 'Δικοί σας πελάτες',
    'rpt_admin_section_domains' => 'Τομείς',
    'rpt_admin_section_personal_domains' => 'Προσωπικοί τομείς',

    'rpt_reseller_section_personal_domains' => 'Προσωπικοί τομείς',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα που θέλετε να αναστείλετε ή να ενεργοποιήσετε.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Αναστολή ή ενεργοποίηση τομέα',

    'ui__client/ip-pool__description' => 'Εκχώρηση και κατάργηση εκχώρησης διευθύνσεων IP και πιστοποιητικών SSL/TLS στον πελάτη %1.',
    'ui__client/ip-pool__short-title' => 'Χώρος IP',
    'ui__client/ip-pool__title' => 'Χώρος IP του πελάτη %1',
    'ui__client/ip-pool_self__description' => 'Προβολή του χώρου IP σας.',
    'ui__client/ip-pool_self__short-title' => 'Χώρος IP',
    'ui__client/ip-pool_self__title' => 'Ο χώρος IP μου',
    'ui__client/ip-pool/properties__description' => 'Ρύθμιση χώρου IP για τον πελάτη %1.',

    'ui__client/ip-pool/properties__short-title' => 'Χώρος IP',
    'ui__client/ip-pool/properties__title' => 'Ρύθμιση χώρου IP για τον πελάτη %1',
    'ui__client/ip-pool/properties_self__description' => 'Προβολή του χώρου IP σας.',

    'ui__client/ip-pool/properties_self__short-title' => 'Ο χώρος IP μου',
    'ui__client/ip-pool/properties_self__title' => 'Ο χώρος IP μου',
    'ui__client/ip-pool/properties_unknown__description' => 'Εκχώρηση ή κατάργηση εκχώρησης διευθύνσεων IP και πιστοποιητικών SSL/TLS από τον πελάτη.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Χώρος IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Ρύθμιση χώρου IP πελάτη',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Ρύθμιση χώρου IP πελάτη',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Επιλέξτε τον πελάτη το χώρο IP του οποίου θέλετε να διαμορφώσετε.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Όταν ολοκληρώσετε τη ρύθμιση παραμέτρων του χώρου IP, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',


    'ui__client/limits_readonly-unknown__description' => 'Προβολή ορίων πόρων για έναν πελάτη.',
    'ui__client/limits_readonly-unknown__short-title' => 'Όρια πόρων',
    'ui__client/limits_readonly-unknown__title' => 'Προβολή ορίων πόρων για ένα λογαριασμό πελάτη',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Προβολή ή αλλαγή ορίων πόρων για έναν πελάτη',

    'ui__client/limits_unknown__wizard-title' => 'Προβολή ή αλλαγή ορίων πόρων για έναν πελάτη',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Επιλέξτε τον επιθυμητό πελάτη.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Επιλέξτε τον επιθυμητό πελάτη.',
    'ui__client/limits_unknown__wizard__2' => 'Για να εφαρμόσετε τις αλλαγές, κάντε κλικ στο Τέλος.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Για να κλείσετε τον οδηγό, κάντε κλικ στο Τέλος.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Για να κλείσετε τον οδηγό, κάντε κλικ στο Τέλος.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Για να κλείσετε τον οδηγό, κάντε κλικ στο Τέλος.',

    'ui__client/permissions_unknown__wizard-title' => 'Προβολή ή αλλαγή δικαιωμάτων για έναν πελάτη',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Όταν ολοκληρώσετε την προβολή των δικαιωμάτων σας, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Επιλέξτε τον πελάτη τα δικαιώματα του οποίου θέλετε να δείτε ή να αλλάξετε.',
    'ui__client/permissions_unknown__wizard__2' => 'Όταν ολοκληρώσετε την αλλαγή των δικαιωμάτων του πελάτη, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',

    'ui__client/preferences_unknown__wizard-title' => 'Επεξεργασία προτιμήσεων πελάτη',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Επιλέξτε τον πελάτη στον οποίο θέλετε να διαχειριστείτε τις ιδιότητες περιβάλλοντος εργασίας και περιόδου λειτουργίας.',
    'ui__client/preferences_unknown__wizard__2' => 'Όταν ολοκληρώσετε την αλλαγή των προτιμήσεων του πελάτη, κάντε κλικ στο Τέλος.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Όταν ολοκληρώσετε την αλλαγή των προτιμήσεών σας, κάντε κλικ στο Τέλος.',

    'ui__custom-buttons/custom-button__none-available' => 'Δεν έχετε προσαρμοσμένα κουμπιά.',
    'ui__custom-buttons/custom-button/delete__description' => 'Κατάργηση του προσαρμοσμένου κουμπιού %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Κατάργηση',
    'ui__custom-buttons/custom-button/delete__title' => 'Κατάργηση του προσαρμοσμένου κουμπιού %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Κατάργηση των προσαρμοσμένων κουμπιών.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Κατάργηση',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Κατάργηση προσαρμοσμένων κουμπιών',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Κατάργηση προσαρμοσμένων κουμπιών',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Επιλέξτε τα κουμπιά που θέλετε να καταργήσετε.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Επιβεβαιώστε την κατάργηση των κουμπιών επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Κατάργηση προσαρμοσμένων κουμπιών.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Κατάργηση',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Κατάργηση προσαρμοσμένων κουμπιών',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Κατάργηση προσαρμοσμένων κουμπιών',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Επιλέξτε το προσαρμοσμένο κουμπί που θέλετε να καταργήσετε.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Επιβεβαιώστε την κατάργηση του κουμπιού επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.',
    'ui__custom-buttons/custom-button/properties__description' => 'Αλλαγή των ιδιοτήτων του κουμπιού %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Ιδιότητες',
    'ui__custom-buttons/custom-button/properties__title' => 'Αλλαγή των ιδιοτήτων του κουμπιού %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Δημιουργία κουμπιού',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Για να δημιουργηθεί το κουμπί, κάντε κλικ στο Τέλος.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Αλλαγή των ιδιοτήτων ενός προσαρμοσμένου κουμπιού.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Ιδιότητες',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Αλλαγή των ιδιοτήτων ενός προσαρμοσμένου κουμπιού',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Αλλαγή των ιδιοτήτων ενός προσαρμοσμένου κουμπιού',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Επιλέξτε το προσαρμοσμένο κουμπί τις ιδιότητες του οποίου θέλετε να αλλάξετε.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Για να εφαρμόσετε τις αλλαγές, κάντε κλικ στο Τέλος.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Καταστήστε το προσαρμοσμένο κουμπί %1 μη διαθέσιμο στους άλλους χρήστες.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Μη διαθέσιμο στους άλλους χρήστες',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Καταστήστε το προσαρμοσμένο κουμπί %1 μη διαθέσιμο στους άλλους χρήστες',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Καταστήστε το προσαρμοσμένο κουμπί %1 διαθέσιμο στους άλλους χρήστες.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Διαθέσιμο στους άλλους χρήστες',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Καταστήστε το προσαρμοσμένο κουμπί %1 διαθέσιμο στους άλλους χρήστες',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Καταστήστε το προσαρμοσμένο κουμπί διαθέσιμο ή μη διαθέσιμο στους άλλους χρήστες.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Διαθέσιμο ή μη διαθέσιμο στους άλλους χρήστες',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Καταστήστε το προσαρμοσμένο κουμπί διαθέσιμο ή μη διαθέσιμο στους άλλους χρήστες',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Καταστήστε το προσαρμοσμένο κουμπί διαθέσιμο ή μη διαθέσιμο στους άλλους χρήστες',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Επιλέξτε το προσαρμοσμένο κουμπί που θέλετε να καταστήσετε διαθέσιμο ή μη διαθέσιμο στους άλλους χρήστες και κάντε κλικ στο Επόμενο >>.',

    'ui__longtasks#list_header__name__title' => "Όνομα",
    'ui__longtasks#list_header__owner__title' => "Κάτοχος",
    'ui__longtasks#list_header__start_time__title' => "Ώρα δημιουργίας",
    'ui__longtasks#list_header__status__title' => "Κατάσταση",
    'ui__longtasks#list_header__title' => "Εργασίες",
    'ui__longtasks#list_header__finish_time__title' => "Ώρα ολοκλήρωσης",
    'ui__longtasks#task_list_legend__title' => "Εργασίες",
    'ui__longtasks#tools_legend__title' => "Εργαλεία",
    'ui__longtasks__description' => "Διαχείριση εργασιών παρασκηνίου",
    'ui__longtasks__short-title' => "Εργασίες παρασκηνίου",
    'ui__longtasks__title' => "Εργασίες παρασκηνίου",
    'ui__longtasks/longtask/properties#current_operation__title' => "Τρέχουσα λειτουργία:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Εκτιμώμενη ώρα ολοκλήρωσης:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Γενικά",
    'ui__longtasks/longtask/properties#owner__title' => "Η εργασία ξεκίνησε από:",
    'ui__longtasks/longtask/properties#progress__title' => "Συνολική πρόοδος:",
    'ui__longtasks/longtask/properties#start_time__title' => "Η εργασία ξεκίνησε:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Κατάσταση εργασίας",
    'ui__longtasks/longtask/properties__description' => "Κατάσταση και πληροφορίες εργασίας παρασκηνίου",

    'ui__longtasks/properties__description' => "Ρυθμίσεις εργασιών παρασκηνίου",
    'ui__longtasks/properties__short-title' => "Ρυθμίσεις",
    'ui__longtasks/properties__title' => "Εργασίες παρασκηνίου",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Πρότυπα μηνυμάτων μαζικής αλληλογραφίας',
    'ui__mass-mail/template#list_header__name__title' => 'Όνομα προτύπου',
    'ui__mass-mail/template#list_header__from_email__title' => 'Αποστολέας',
    'ui__mass-mail/template#list_header__to__title' => 'Παραλήπτες',
    'ui__mass-mail/template#list_header__subject__title' => 'Θέμα',
    'ui__mass-mail/template#list_header__cdate__title' => 'Ημερομηνία δημιουργίας',
    'ui__mass-mail/template#list_header__send__title' => 'Αποστολή',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Επεξεργασία προτύπου μηνύματος μαζικής αλληλογραφίας',
    'ui__mass-mail/template/properties__description' => 'Επεξεργασία αυτού του προτύπου μηνύματος μαζικής αλληλογραφίας.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Προσθήκη προτύπου μαζικής αλληλογραφίας',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Προσθήκη προτύπου μαζικής αλληλογραφίας',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Προσθήκη ενός προτύπου μηνύματος μαζικής αλληλογραφίας.',
    'ui__mass-mail/send__short-title' => 'Αποστολή μηνύματος μαζικής αλληλογραφίας',
    'ui__mass-mail/send__title' => 'Αποστολή μαζικού μηνύματος ηλεκτρονικού ταχυδρομείου',
    'ui__mass-mail/send__description' => 'Αποστολή μηνύματος μαζικής αλληλογραφίας σε επιλεγμένους παραλήπτες.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας',
    'ui__mass-mail/template/delete_multi__title' => 'Κατάργηση αυτών των προτύπων μηνυμάτων μαζικής αλληλογραφίας:',
    'ui__mass-mail/template/delete_multi__description' => 'Κατάργηση επιλεγμένων προτύπων μηνυμάτων μαζικής αλληλογραφίας.',
    'ui__mass-mail/template/delete_multi__done' => 'Τα επιλεγμένα πρότυπα μηνυμάτων καταργήθηκαν.',
    'ui__mass-mail/template/properties__invalid_values' => 'Οι καθορισμένες τιμές δεν είναι έγκυρες',


    // old
    'ui__mass-mail#body_text__description' => 'Μπορείτε να <name>χρησιμοποιήσετε τη μεταβλητή στο κείμενο του μηνύματος (αλλά όχι στην κεφαλίδα). Θα αντικατασταθεί από το όνομα επικοινωνίας του πελάτη ή του μεταπωλητή.',
    'ui__mass-mail#body_text__title' => 'Κείμενο μηνύματος',
    'ui__mass-mail#compose_legend__title' => 'Μήνυμα',
    'ui__mass-mail#from_email_text__title' => 'Από (τη διεύθυνση ηλεκτρονικού ταχυδρομείου)',
    'ui__mass-mail#list_header__cdate__title' => 'Δημιουργήθηκε',
    'ui__mass-mail#list_header__from_email__title' => 'Από',
    'ui__mass-mail#list_header__name__title' => 'Όνομα',
    'ui__mass-mail#list_header__send__title' => 'Δημιουργία μηνύματος',
    'ui__mass-mail#list_header__subject__title' => 'Θέμα',
    'ui__mass-mail#list_header__title' => 'Πρότυπα μηνυμάτων μαζικής αλληλογραφίας',
    'ui__mass-mail#list_header__to__title' => 'Προς',
    'ui__mass-mail#list_legend__title' => 'Πρότυπα μηνυμάτων μαζικής αλληλογραφίας',
    'ui__mass-mail#load_template_text__title' => 'Φόρτωση',
    'ui__mass-mail#name_text__title' => 'Όνομα προτύπου',
    'ui__mass-mail#option_mode_all__title' => 'Όλες',
    'ui__mass-mail#option_mode_except__title' => 'Όλες εκτός των επιλεγμένων',
    'ui__mass-mail#option_mode_select__title' => 'Μόνο οι επιλεγμένες',
    'ui__mass-mail#option_select_template__title' => '---Επιλέξτε ένα πρότυπο---',
    'ui__mass-mail#picker_legend__title' => 'Πρότυπα μηνυμάτων ηλεκτρονικού ταχυδρομείου',
    'ui__mass-mail#picker_title__title' => 'Επιλογή προτύπου',
    'ui__mass-mail#save_as_legend__title' => 'Αποθήκευση ως πρότυπο',
    'ui__mass-mail#save_as_text__title' => 'Αποθήκευση του κειμένου που συντάχθηκε σε νέο πρότυπο με το όνομα',
    'ui__mass-mail#subject_text__title' => 'Θέμα',
    'ui__mass-mail#template_legend__title' => 'Πρότυπο',
    'ui__mass-mail#to_admin_text__title' => 'Διαχειριστής Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Πελάτες',
    'ui__mass-mail#to_domains_text__title' => 'Διαχειριστές τομέα',
    'ui__mass-mail#to_select_text__title' => 'Επιλέξτε διευθύνσεις',
    'ui__mass-mail#to_show_hide_text__title' => 'Εμφάνιση/απόκρυψη επιλεγμένων',
    'ui__mass-mail#to_text__title' => 'Προς',
    'ui__mass-mail#tools_legend__title' => 'Εργαλεία',
    'ui__mass-mail__already_exists' => 'Το πρότυπο με το όνομα %1 υπάρχει ήδη',
    'ui__mass-mail__none-available' => 'Δεν έχετε πρότυπα μηνυμάτων.',

    'ui__mass-mail/delete__description' => 'Κατάργηση προτύπου μηνύματος μαζικής αλληλογραφίας %1',

    'ui__mass-mail/delete__empty_selection' => 'Επιλέξτε τα πρότυπα που θέλετε να καταργήσετε',
    'ui__mass-mail/delete__short-title' => 'Κατάργηση %1',
    'ui__mass-mail/delete__title' => 'Κατάργηση προτύπου μηνύματος μαζικής αλληλογραφίας %1',
    'ui__mass-mail/delete_multi__description' => 'Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας.',

    'ui__mass-mail/delete_multi__short-title' => 'Κατάργηση',
    'ui__mass-mail/delete_multi__title' => 'Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας',
    'ui__mass-mail/delete_multi__wizard-title' => 'Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Επιλέξτε τα πρότυπα μηνυμάτων μαζικής αλληλογραφίας που θέλετε να καταργήσετε.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Επιβεβαιώστε την κατάργηση των προτύπων επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.',
    'ui__mass-mail/delete_unknown__description' => 'Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας.',
    'ui__mass-mail/delete_unknown__short-title' => 'Κατάργηση',
    'ui__mass-mail/delete_unknown__title' => 'Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Επιλέξτε το πρότυπο μηνύματος μαζικής αλληλογραφίας που θέλετε να καταργήσετε.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Επιβεβαιώστε την κατάργηση του προτύπου επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.',

    'ui__mass-mail/properties__description' => 'Επεξεργασία προτύπου μηνύματος ηλεκτρονικού ταχυδρομείου %1.',

    'ui__mass-mail/properties__invalid_values' => 'Οι τιμές που καθορίστηκαν είναι λανθασμένες',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Επεξεργασία προτύπου μηνύματος ηλεκτρονικού ταχυδρομείου %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Δημιουργία προτύπου μηνύματος μαζικής αλληλογραφίας',
    'ui__mass-mail/properties_unknown-new__description' => 'Δημιουργία ενός προτύπου μηνύματος ηλεκτρονικού ταχυδρομείου.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Προσθήκη προτύπου μηνύματος ηλεκτρονικού ταχυδρομείου',
    'ui__mass-mail/properties_unknown-new__title' => 'Δημιουργία προτύπου μηνύματος ηλεκτρονικού ταχυδρομείου',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Επεξεργασία προτύπου μηνύματος μαζικής αλληλογραφίας',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Επιλέξτε το πρότυπο που θέλετε να τροποποιήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Όταν ολοκληρώσετε την επεξεργασία του προτύπου, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',

    'ui__mass-mail/send__invalid_values' => 'Οι τιμές που καθορίσατε είναι λανθασμένες',

    'ui__mass-mail/send_new__wizard-title' => 'Δημιουργία προτύπου μηνύματος και αποστολή μηνύματος ηλεκτρονικού ταχυδρομείου',
    'ui__mass-mail/send_unknown-new__description' => 'Αποστολή μηνύματος ηλεκτρονικού ταχυδρομείου στους επιλεγμένους αποδέκτες',

    'ui__mass-mail/send_unknown-new__short-title' => 'Αποστολή μηνύματος μαζικής αλληλογραφίας',
    'ui__mass-mail/send_unknown-new__title' => 'Αποστολή μαζικού μηνύματος ηλεκτρονικού ταχυδρομείου',
    'ui__mass-mail/send_unknown__description' => 'Αποστολή μηνύματος ηλεκτρονικού ταχυδρομείου στους επιλεγμένους αποδέκτες',

    'ui__mass-mail/send_unknown__short-title' => 'Αποστολή μηνύματος μαζικής αλληλογραφίας',
    'ui__mass-mail/send_unknown__title' => 'Αποστολή μαζικού μηνύματος ηλεκτρονικού ταχυδρομείου',
    'ui__mass-mail/send_unknown__wizard-title' => 'Αποστολή μαζικού μηνύματος ηλεκτρονικού ταχυδρομείου',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Επιλέξτε το επιθυμητό πρότυπο και κάντε κλικ στο Επόμενο >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Όταν ολοκληρώσετε την επεξεργασία των ιδιοτήτων του προτύπου, κάντε κλικ στο Τέλος για στείλετε το μήνυμα και να κλείσετε τον οδηγό.',

    'ui__mass-email/delete__description' => 'Κατάργηση επιλεγμένων προτύπων μηνυμάτων μαζικής αλληλογραφίας.',

    'ui__mass-email/delete__empty_selection' => "Επιλέξτε τα πρότυπα που θέλετε να καταργήσετε.",
    'ui__mass-email/delete__short-title' => "Κατάργηση %1",
    'ui__mass-email/delete__title' => "Κατάργηση προτύπου μηνύματος μαζικής αλληλογραφίας %1",
    'ui__mass-email/delete_multi__description' => "Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας.",

    'ui__mass-email/delete_multi__short-title' => "Κατάργηση",
    'ui__mass-email/delete_multi__title' => "Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Επιβεβαιώστε την κατάργηση των προτύπων επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Επιλέξτε τα πρότυπα μηνυμάτων μαζικής αλληλογραφίας που θέλετε να καταργήσετε.",
    'ui__mass-email/delete_multi__wizard-title' => "Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας",
    'ui__mass-email/delete_unknown__description' => "Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας.",
    'ui__mass-email/delete_unknown__short-title' => "Κατάργηση",
    'ui__mass-email/delete_unknown__title' => "Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Επιβεβαιώστε την κατάργηση του προτύπου επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Επιλέξτε το πρότυπο μηνύματος μαζικής αλληλογραφίας που θέλετε να καταργήσετε.",
    'ui__mass-email/delete_unknown__wizard-title' => "Κατάργηση προτύπων μηνυμάτων μαζικής αλληλογραφίας.",
    'ui__mass-email/send__description' => "Αποστολή μηνύματος ηλεκτρονικού ταχυδρομείου στους επιλεγμένους αποδέκτες",
    'ui__mass-email/send__short-title' => "Αποστολή μηνύματος μαζικής αλληλογραφίας",
    'ui__mass-email/send__title' => "Αποστολή μαζικού μηνύματος ηλεκτρονικού ταχυδρομείου",
    'ui__mass-email/send_main__description' => "Αποστολή μηνύματος ηλεκτρονικού ταχυδρομείου στους επιλεγμένους αποδέκτες",

    'ui__mass-email/send_main__short-title' => "Αποστολή μηνύματος μαζικής αλληλογραφίας",
    'ui__mass-email/send_main__title' => "Αποστολή μαζικού μηνύματος ηλεκτρονικού ταχυδρομείου",
    'ui__mass-email/send_selectresellers__title' => 'Επιλογή μεταπωλητών',
    'ui__mass-email/send_selectresellers__short-title' => 'Μεταπωλητές',
    'ui__mass-email/send_selectresellers__description' => 'Επιλογή λογαριασμών μεταπωλητών',

    'ui__mass-email/send_selectclients__description' => "Επιλογή λογαριασμών πελατών",

    'ui__mass-email/send_selectclients__short-title' => "Πελάτες",
    'ui__mass-email/send_selectclients__title' => "Επιλέξτε πελάτες",
    'ui__mass-email/send_selectdomainusers__description' => "Επιλογή λογαριασμών διαχειριστή τομέα",

    'ui__mass-email/send_selectdomainusers__short-title' => "Διαχειριστές τομέα",
    'ui__mass-email/send_selectdomainusers__title' => "Επιλογή διαχειριστών τομέα",
    'ui__mass-email/template/properties_main__description' => "Δημιουργία προτύπου μηνύματος μαζικής αλληλογραφίας",
    'ui__mass-email/template/properties_main__short-title' => "Επεξεργασία προτύπου",
    'ui__mass-email/template/properties_main__title' => "Επεξεργασία προτύπου μηνύματος μαζικής αλληλογραφίας",
    'ui__mass-email/template/properties_new-main__description' => "Δημιουργία ενός προτύπου για μηνύματα μαζικής αλληλογραφίας.",
    'ui__mass-email/template/properties_new-main__short-title' => "Δημιουργία προτύπου μηνύματος μαζικής αλληλογραφίας",
    'ui__mass-email/template/properties_new-main__title' => "Δημιουργία προτύπου μηνύματος μαζικής αλληλογραφίας",
    'ui__mass-email/template/properties_new-selectclients__description' => "Επιλέξτε τους πελάτες που θα πρέπει να λαμβάνουν τα μηνύματα μαζικής αλληλογραφίας με βάση αυτό το πρότυπο",
    'ui__mass-email/template/properties_new-selectclients__title' => "Επιλέξτε τους πελάτες που θα πρέπει να λαμβάνουν τα μηνύματα μαζικής αλληλογραφίας με βάση αυτό το πρότυπο",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Επιλέξτε τους διαχειριστές τομέα που θα πρέπει να λαμβάνουν μηνύματα μαζικής αλληλογραφίας με βάση αυτό το πρότυπο.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Επιλέξτε τους διαχειριστές τομέα που θα πρέπει να λαμβάνουν μηνύματα μαζικής αλληλογραφίας με βάση αυτό το πρότυπο.",
    'ui__mass-email/template/properties_selectclients__title' => "Επιλέξτε τους πελάτες που θα πρέπει να λαμβάνουν τα μηνύματα μαζικής αλληλογραφίας με βάση αυτό το πρότυπο",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Επιλέξτε τους διαχειριστές τομέα που θα πρέπει να λαμβάνουν μηνύματα μαζικής αλληλογραφίας με βάση αυτό το πρότυπο.",

    'ui__mass-email/template/properties_unknown-new__description' => "Δημιουργία προτύπου μηνύματος μαζικής αλληλογραφίας",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Δημιουργία προτύπου",
    'ui__mass-email/template/properties_unknown-new__title' => "Δημιουργία προτύπου μηνύματος μαζικής αλληλογραφίας",
    'ui__news/dismiss__description' => 'Κάντε κλικ για να κλείσετε το πλαίσιο νέων. Το Plesk δεν θα εμφανίσει αυτό το πλαίσιο μέχρι να ενημερωθούν τα άρθρα των νέων.',

    'ui__news/dismiss__title' => 'Κλείστε τα νέα',

    'ui__server__description' => 'Διαχείριση διακομιστή.',
    'ui__server__short-title' => 'Διαχειριστείτε το διακομιστή σας',
    'ui__server__title' => 'Διαχείριση διακομιστή',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'Η διεύθυνση IP %1 είναι δεν είναι διαθέσιμη.',
    'ui__server/ip-address__none-available' => 'Δεν υπάρχουν διευθύνσεις IP.',
    'ui__server/ip-addresses/ip-address__title' => "Διευθύνσεις IP",
    'ui__server/ip-address/client/properties_new__description' => "Εκχώρηση διεύθυνσης IP %1 σε μεταπωλητές.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Εκχώρηση',
    'ui__server/ip-address/client/properties_new__title' => "Εκχώρηση διεύθυνσης IP %1 σε μεταπωλητές",
    'ui__server/ip-address/client__none-available' => 'Δεν υπάρχουν λογαριασμοί χρηστών',
    'ui__server/ip-address/client_unknown__quick_search' => 'Χρήστες',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Λίστα χρηστών που χρησιμοποιούν αυτήν τη διεύθυνση IP.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Επιλέξτε τη διεύθυνση IP.',
    'ui__server/ip-address/client/delete__description' => 'Κατάργηση εκχώρησης διεύθυνσης IP από το μεταπωλητή.',
    'ui__server/ip-address/client/delete__short-title' => 'Κατάργηση εκχώρησης',
    'ui__server/ip-address/client/delete__title' => 'Κατάργηση εκχώρησης διεύθυνσης IP από το μεταπωλητή',
    'ui__server/ip-address/client/delete_multi__description' => "Κατάργηση εκχώρησης της διεύθυνσης IP από τους χώρους συγκέντρωσης των μεταπωλητών.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Κατάργηση εκχώρησης',
    'ui__server/ip-address/client/delete_multi__title' => 'Κατάργηση εκχώρησης μιας διεύθυνσης IP από ένα μεταπωλητή',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Κατάργηση διεύθυνσης IP από τους χώρους συγκέντρωσης των χρηστών.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Επιλέξτε τη διεύθυνση IP την εκχώρηση της οποίας θέλετε να καταργήσετε από τους χρήστες και κάντε κλικ στο Επόμενο >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Επιλέξτε τους χρήστες από τους οποίους θέλετε να καταργήσετε την εκχώρηση της διεύθυνσης IP και κάντε κλικ στο Επόμενο >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Επιβεβαιώστε την κατάργηση της εκχώρησης της διεύθυνσης IP από τους χρήστες επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Κατάργηση εκχώρησης μιας διεύθυνσης IP από μεταπωλητές.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Κατάργηση εκχώρησης',
    'ui__server/ip-address/client/delete_unknown__title' => 'Κατάργηση εκχώρησης διεύθυνσης IP από μεταπωλητές',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Κατάργηση εκχώρησης μιας διεύθυνσης IP από χρήστες',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Επιλέξτε τη διεύθυνση IP την εκχώρηση της οποίας θέλετε να καταργήσετε από τους χρήστες και κάντε κλικ στο Επόμενο >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Επιλέξτε το χρήστη από τον οποίο θέλετε να καταργήσετε την εκχώρηση της διεύθυνσης IP και κάντε κλικ στο Επόμενο >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Επιβεβαιώστε την κατάργηση της εκχώρησης της διεύθυνσης IP από τους χρήστες επιλέγοντας το πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να ολοκληρώσετε τον οδηγό.',

    'ui__server/ip-address/domain__description' => "Όλοι οι τομείς στη διεύθυνση IP %1.",
    'ui__server/ip-address/domain__short-title' => "Τομείς",
    'ui__server/ip-address/domain__title' => "Τομείς στη διεύθυνση IP %1",
    'ui__server/ip-address/domain_unknown__description' => "Όλοι οι τομείς στη διεύθυνση IP.",
    'ui__server/ip-address/domain_unknown__short-title' => "Τομείς",
    'ui__server/ip-address/domain_unknown__title' => "Τομείς στη διεύθυνση IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Επιλέξτε την επιθυμητή διεύθυνση IP και κάντε κλικ στο Επόμενο >>.",

    'ui__server/ip-address/properties__description' => 'Αλλαγή των ιδιοτήτων της διεύθυνσης IP %1.',
    'ui__server/ip-address/properties__short-title' => 'Ιδιότητες',
    'ui__server/ip-address/properties__title' => 'Αλλαγή των ιδιοτήτων της διεύθυνσης IP %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Προσθήκη διεύθυνσης IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Όταν ολοκληρώσετε την αλλαγή των ιδιοτήτων της διεύθυνσης IP, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές.',
    'ui__server/ip-address/properties_unknown__description' => 'Αλλαγή των ιδιοτήτων της διεύθυνσης IP.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Ιδιότητες',
    'ui__server/ip-address/properties_unknown__title' => 'Αλλαγή των ιδιοτήτων της διεύθυνσης IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Αλλαγή των ιδιοτήτων της διεύθυνσης IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Επιλέξτε τη διεύθυνση IP τις ιδιότητες της οποίας θέλετε να αλλάξετε.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Όταν ολοκληρώσετε την αλλαγή των ιδιοτήτων της διεύθυνσης IP, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές.',

    'ui__server/spam-filter/black-list__description' => 'Ρύθμιση μαύρης λίστας για το φίλτρο ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή.',
    'ui__server/spam-filter/black-list__short-title' => 'Μαύρη λίστα',
    'ui__server/spam-filter/black-list__title' => 'Μαύρη λίστα για το φίλτρο ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Θα προστεθούν μόνο οι %1 πρώτες μοναδικές διευθύνσεις ηλεκτρονικού ταχυδρομείου.',
    'ui__server/spam-filter/black-list/address__description' => 'Διεύθυνση μαύρης λίστας φίλτρου ανεπιθύμητης αλληλογραφίας.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Δεν υπάρχουν διευθύνσεις ηλεκτρονικού ταχυδρομείου στη λίστα.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Το απεσταλμένο αρχείο είναι κενό.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Οι παρακάτω διευθύνσεις ηλεκτρονικού ταχυδρομείου δεν είναι έγκυρες: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Δεν υπάρχουν διευθύνσεις στη μαύρη λίστα του φίλτρου ανεπιθύμητης αλληλογραφίας.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Διεύθυνση',
    'ui__server/spam-filter/black-list/address__title' => 'Διεύθυνση μαύρης λίστας %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Προσθήκη διευθύνσεων στη μαύρη λίστα.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Προσθήκη διευθύνσεων',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Προσθήκη διευθύνσεων στη μαύρη λίστα',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Κατάργηση διεύθυνσης %1 από τη μαύρη λίστα σε επίπεδο διακομιστή.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Κατάργηση',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Κατάργηση διεύθυνσης %1 από τη μαύρη λίστα σε επίπεδο διακομιστή',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Κατάργηση διευθύνσεων από τη μαύρη λίστα σε επίπεδο διακομιστή.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Κατάργηση',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Κατάργηση διευθύνσεων από τη μαύρη λίστα σε επίπεδο διακομιστή',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Κατάργηση διευθύνσεων από τη μαύρη λίστα του φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Επιλέξτε τις διευθύνσεις φίλτρου ανεπιθύμητης αλληλογραφίας που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Επιβεβαιώστε την κατάργηση των διευθύνσεων φίλτρου ανεπιθύμητης αλληλογραφίας επιλέγοντας το αντίστοιχο πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να τις καταργήσετε πλήρως και να κλείσετε τον οδηγό.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Κατάργηση διεύθυνσης από τη μαύρη λίστα σε επίπεδο διακομιστή.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Κατάργηση',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Κατάργηση διεύθυνσης από τη μαύρη λίστα σε επίπεδο διακομιστή',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Κατάργηση διευθύνσεων από τη μαύρη λίστα του φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Επιλέξτε τη διεύθυνση φίλτρου ανεπιθύμητης αλληλογραφίας που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Επιβεβαιώστε την κατάργηση της διεύθυνσης φίλτρου ανεπιθύμητης αλληλογραφίας επιλέγοντας το αντίστοιχο πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να την καταργήσετε πλήρως και να κλείσετε τον οδηγό.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Θα προστεθούν μόνο οι %1 πρώτες μοναδικές διευθύνσεις ηλεκτρονικού ταχυδρομείου.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Δεν υπάρχουν διευθύνσεις ηλεκτρονικού ταχυδρομείου στη λίστα.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Δεν είναι δυνατή η αποστολή του αρχείου. Το μέγιστο μέγεθος ενός αρχείου προς αποστολή είναι %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Οι παρακάτω διευθύνσεις ηλεκτρονικού ταχυδρομείου δεν είναι έγκυρες: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Προσθήκη διευθύνσεων στη μαύρη λίστα.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Προσθήκη διευθύνσεων',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Προσθήκη διευθύνσεων στη μαύρη λίστα',

    'ui__server/spam-filter/properties__description' => 'Ρύθμιση του φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή.',

    'ui__server/spam-filter/properties__short-title' => 'Ρυθμίσεις',
    'ui__server/spam-filter/properties__title' => 'Ρυθμίσεις φίλτρου ανεπιθύμητης αλληλογραφίας',

    'ui__server/spam-filter/toggle_disable__description' => 'Απενεργοποίηση φιλτραρίσματος ανεπιθύμητης αλληλογραφίας για ολόκληρο το σύστημα.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Απενεργοποίηση',
    'ui__server/spam-filter/toggle_disable__title' => 'Απενεργοποίηση φιλτραρίσματος ανεπιθύμητης αλληλογραφίας',
    'ui__server/spam-filter/toggle_enable__description' => 'Ενεργοποίηση φιλτραρίσματος ανεπιθύμητης αλληλογραφίας για ολόκληρο το διακομιστή.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Ενεργοποίηση',
    'ui__server/spam-filter/toggle_enable__title' => 'Ενεργοποίηση φιλτραρίσματος ανεπιθύμητης αλληλογραφίας',
    'ui__server/spam-filter/toggle_unknown__description' => 'Ενεργοποίηση ή απενεργοποίηση φιλτραρίσματος ανεπιθύμητης αλληλογραφίας για ολόκληρο το διακομιστή.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Ενεργοποίηση ή απενεργοποίηση',
    'ui__server/spam-filter/toggle_unknown__title' => 'Ενεργοποίηση ή απενεργοποίηση φιλτραρίσματος ανεπιθύμητης αλληλογραφίας',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Ενεργοποίηση ή απενεργοποίηση φίλτρου ανεπιθύμητης αλληλογραφίας',

    'ui__server/spam-filter/white-list__description' => 'Ρύθμιση λίστας επιτρεπόμενων φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο συστήματος.',
    'ui__server/spam-filter/white-list__short-title' => 'Λίστα επιτρεπόμενων',
    'ui__server/spam-filter/white-list__title' => 'Λίστα επιτρεπόμενων φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο συστήματος',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Θα προστεθούν μόνο οι %1 πρώτες μοναδικές διευθύνσεις ηλεκτρονικού ταχυδρομείου.',
    'ui__server/spam-filter/white-list/address__description' => 'Διεύθυνση λίστας επιτρεπόμενων φίλτρου ανεπιθύμητης αλληλογραφίας.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Δεν υπάρχουν διευθύνσεις ηλεκτρονικού ταχυδρομείου στη λίστα.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Το απεσταλμένο αρχείο είναι κενό.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Οι παρακάτω διευθύνσεις ηλεκτρονικού ταχυδρομείου δεν είναι έγκυρες: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Δεν υπάρχουν διευθύνσεις στη λίστα επιτρεπόμενων του φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Διεύθυνση',
    'ui__server/spam-filter/white-list/address__title' => 'Διεύθυνση λίστας επιτρεπόμενων %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Προσθήκη διευθύνσεων στη λίστα επιτρεπόμενων.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Προσθήκη διευθύνσεων',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Προσθήκη διευθύνσεων στη λίστα επιτρεπόμενων',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Κατάργηση της διεύθυνσης %1 από τη λίστα επιτρεπόμενων σε επίπεδο διακομιστή.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Κατάργηση',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Κατάργηση της διεύθυνσης %1 από τη λίστα επιτρεπόμενων σε επίπεδο διακομιστή',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Κατάργηση διευθύνσεων από τη λίστα επιτρεπόμενων σε επίπεδο διακομιστή.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Κατάργηση',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Κατάργηση διευθύνσεων από τη λίστα επιτρεπόμενων σε επίπεδο διακομιστή',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Κατάργηση διευθύνσεων από τη λίστα επιτρεπόμενων του φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Επιλέξτε τις διευθύνσεις φίλτρου ανεπιθύμητης αλληλογραφίας που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Επιβεβαιώστε την κατάργηση των διευθύνσεων φίλτρου ανεπιθύμητης αλληλογραφίας επιλέγοντας το αντίστοιχο πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να τις καταργήσετε πλήρως και να κλείσετε τον οδηγό.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Κατάργηση διεύθυνσης από τη λίστα επιτρεπόμενων σε επίπεδο διακομιστή.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Κατάργηση',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Κατάργηση διεύθυνσης από τη λίστα επιτρεπόμενων σε επίπεδο διακομιστή',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Κατάργηση διευθύνσεων από τη λίστα επιτρεπόμενων του φίλτρου ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Επιλέξτε τη διεύθυνση φίλτρου ανεπιθύμητης αλληλογραφίας που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Επιβεβαιώστε την κατάργηση της διεύθυνσης φίλτρου ανεπιθύμητης αλληλογραφίας επιλέγοντας το αντίστοιχο πλαίσιο ελέγχου και κάντε κλικ στο Τέλος για να την καταργήσετε πλήρως και να κλείσετε τον οδηγό.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Θα προστεθούν μόνο οι %1 πρώτες μοναδικές διευθύνσεις ηλεκτρονικού ταχυδρομείου.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Δεν υπάρχουν διευθύνσεις ηλεκτρονικού ταχυδρομείου στη λίστα.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Δεν είναι δυνατή η αποστολή του αρχείου. Το μέγιστο μέγεθος ενός αρχείου προς αποστολή είναι %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Οι παρακάτω διευθύνσεις ηλεκτρονικού ταχυδρομείου δεν είναι έγκυρες: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Προσθήκη διευθύνσεων στη λίστα επιτρεπόμενων.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Προσθήκη διευθύνσεων',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Προσθήκη διευθύνσεων στη λίστα επιτρεπόμενων',

    'ui__server/mail/statistics#apply__description' => "Εφαρμογή φίλτρου",
    'ui__server/mail/statistics#apply__title' => "Εφαρμογή",
    'ui__server/mail/statistics#custom_from__title' => "από",
    'ui__server/mail/statistics#custom_to__title' => "προς",
    'ui__server/mail/statistics#period_all__title' => "Όλες",
    'ui__server/mail/statistics#period_custom__title' => "Προσαρμοσμένο",
    'ui__server/mail/statistics#period_month__title' => "Τρέχοντας μήνας",
    'ui__server/mail/statistics#period_prev_month__title' => "Προηγούμενος μήνας",
    'ui__server/mail/statistics#period_prev_week__title' => "Προηγούμενη εβδομάδα",
    'ui__server/mail/statistics#period_today__title' => "Σήμερα",
    'ui__server/mail/statistics#period_week__title' => "Τρέχουσα εβδομάδα",
    'ui__server/mail/statistics#period_yesterday__title' => "Χθες",
    'ui__server/mail/statistics#show_for_period__title' => "Εμφάνιση για την περίοδο",
    'ui__server/mail/statistics#tools_legend__title' => "Εργαλεία",
    'ui__server/mail/statistics__description' => "Προβολή στατιστικών στοιχείων ανεπιθύμητης αλληλογραφίας και ιών",

    'ui__server/mail/statistics__short-title' => "Στατιστικά στοιχεία",
    'ui__server/mail/statistics__title' => "Ρυθμίσεις αλληλογραφίας",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Στατιστικά στοιχεία ανεπιθύμητης αλληλογραφίας",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Εργαλεία",
    'ui__server/mail/statistics/spam__description' => "Προβολή στατιστικών στοιχείων ανεπιθύμητης αλληλογραφίας",

    'ui__server/mail/statistics/spam__short-title' => "Στατιστικά στοιχεία ανεπιθύμητης αλληλογραφίας",
    'ui__server/mail/statistics/spam__title' => "Στατιστικά στοιχεία ανεπιθύμητης αλληλογραφίας",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Mailname",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% από Όλα",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Ταξινόμηση κατά λογαριασμό αλληλογραφίας",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Ταξινόμηση κατά % του συνόλου",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Ταξινόμηση κατά ληφθείσα ανεπιθύμητη αλληλογραφία",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "λογαριασμοί αλληλογραφίας",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Ληφθείσα ανεπιθύμητη αλληλογραφία",
    'ui__server/mail/statistics/spam/recipients__description' => "Παραλήπτες",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Παραλήπτες",
    'ui__server/mail/statistics/spam/recipients__title' => "Παραλήπτες",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Καθαρό",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Μολυσμένο",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Κατάσταση",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% από Όλα",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Αριθμός",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Με προστασία",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Δεν ελέγχθηκε",
    'ui__server/mail/statistics/spam/summary__description' => "Σύνοψη",

    'ui__server/mail/statistics/spam/summary__short-title' => "Σύνοψη",
    'ui__server/mail/statistics/spam/summary__title' => "Σύνοψη",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Στατιστικά στοιχεία ιών",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Εργαλεία",
    'ui__server/mail/statistics/virus__description' => "Προβολή στατιστικών στοιχείων ιών",

    'ui__server/mail/statistics/virus__short-title' => "Στατιστικά στοιχεία ιών",
    'ui__server/mail/statistics/virus__title' => "Στατιστικά στοιχεία ιών",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Λογαριασμός αλληλογραφίας",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% από Όλα",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Ταξινόμηση κατά mailname",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Ταξινόμηση κατά % του συνόλου",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Ταξινόμηση κατά ληφθέντες ιούς",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Λογαριασμοί αλληλογραφίας",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Ληφθέντες ιοί",
    'ui__server/mail/statistics/virus/recipients__description' => "Παραλήπτες",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Παραλήπτες",
    'ui__server/mail/statistics/virus/recipients__title' => "Παραλήπτες",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Καθαρό",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Μολυσμένο",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Κατάσταση",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% από Όλα",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Αριθμός",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Με προστασία",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Δεν ελέγχθηκε",
    'ui__server/mail/statistics/virus/summary__description' => "Σύνοψη",

    'ui__server/mail/statistics/virus/summary__short-title' => "Σύνοψη",
    'ui__server/mail/statistics/virus/summary__title' => "Σύνοψη",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Όνομα",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% από Όλα",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Ταξινόμηση κατά όνομα",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Ταξινόμηση κατά % του συνόλου",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Ταξινόμηση κατά μολυσμένα αντικείμενα",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Ιοί",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Μολυσμένα αντικείμενα",
    'ui__server/mail/statistics/virus/viruses__description' => "Ιοί",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Ιοί",
    'ui__server/mail/statistics/virus/viruses__title' => "Ιοί",

    'ui__support#param_company__title' => "Εταιρεία",
    'ui__support#param_email__title' => "Διεύθυνση ηλ. ταχ.",
    'ui__support#param_firstname__title' => "Όνομα",
    'ui__support#param_keynumber__title' => "Αριθμός κλειδιού προϊόντος",
    'ui__support#param_operatingsystem__title' => "Λειτουργικό σύστημα",
    'ui__support#param_phone__title' => "Τηλέφωνο",
    'ui__support#param_psabuild__title' => "Δομή Plesk",
    'ui__support#param_psainsttype__title' => "Τύπος εγκατάστασης Plesk",
    'ui__support#param_psaversion__title' => "Έκδοση Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Εργαλεία",

    'ui__reseller/traffic-history_unknown__short-title' => "Προβολή κίνησης μεταπωλητών",
    'ui__reseller/traffic-history_unknown__title' => "Προβολή κίνησης μεταπωλητών",
    'ui__reseller/traffic-history_unknown__description' => "Προβολή της κίνησης από τους λογαριασμούς μεταπωλητών.",
    'ui__reseller#list__title' => "Μεταπωλητές",
    'accounts_list__name__filter_title' => "Όνομα",
    'accounts_list__resource__filter_title' => "Χρήση πόρων",
    'resellers_list__filter_resource_usage_any' => "Οποιοδήποτε",
    'resellers_list__filter_resource_usage_overuse' => "Υπερβολική χρήση",
    'resellers_list__filter_resource_usage_normal' => "Εντός ορίων",
    'accounts_list__status__filter_title' => "Κατάσταση",
    'resellers_list__filter_status_any' => "Οποιοδήποτε",
    'resellers_list__filter_status_blocked' => "Αναστάλθηκε",
    'resellers_list__filter_status_active' => "Ενεργό",
    'resellers_list__filter_clients__filter_title' => "Εμφάνιση",
    'resellers_list__filter_clients_on' => "Μεταπωλητές με τους πελάτες τους",
    'resellers_list__filter_clients_off' => "Μόνο μεταπωλητές",
    '__disk_usage' => "Χώρος στο δίσκο που χρησιμοποιείται",
    'ui__reseller/traffic_unknown__short-title' => "Προβολή κίνησης μεταπωλητών",
    'ui__reseller/traffic_unknown__title' => "Προβολή κίνησης μεταπωλητών",
    'ui__reseller/traffic#list__title' => "Κίνηση μεταπωλητή",
    'ui__reseller/traffic_unknown__description' => "Προβολή αναφορών χρήσης κίνησης.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Κίνηση μεταπωλητή",

    '__reseller_name' => "Όνομα μεταπωλητή",
    '__reseller' => "Μεταπωλητές",
    'resellertrafficlist_header' => "Προβολή κίνησης μεταπωλητών",
    '__reseller_personal' => "Κίνηση που χρησιμοποιείται από τους τομείς του μεταπωλητή",
    'ui__reseller/traffic-history__short-title' => "Κίνηση μεταπωλητών",
    'ui__reseller/traffic-history__title' => "Κίνηση μεταπωλητών",
    'ui__reseller/traffic-history__description' => "Προβολή αναφορών χρήσης κίνησης.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Να επιτρέπεται η υπερπώληση",
    'limits__reseller_oversell_description' => "Η υπερπώληση δίνει τη δυνατότητα στο μεταπωλητή να διαθέσει προς πώληση περισσότερους πόρους απ' όσους του έχουν κατανεμηθεί στην πραγματικότητα.  Αν επιτραπεί η υπερπώληση, η δραστηριότητα του μεταπωλητή διέπεται από καθεστώς πραγματικής χρήσης πόρων και όχι από την αρχική κατανομή πόρων",
    'limits__overuse_block_text' => "Πολιτική υπερβολικής χρήσης",
    'limits__overuse_block_true_text' => "Η υπερπώληση δεν επιτρέπεται",
    'limits__reseller_overuse_block_true_description' => "Αποκλεισμός της υπερβολικής χρήσης πόρων. Η πραγματική χρήση των πόρων δεν μπορεί να υπερβαίνει την αρχική κατανομή πόρων",
    'limits__overuse_block_false_text' => "Η υπερπώληση επιτρέπεται",
    'limits__reseller_overuse_block_false_description' => "Να μην αποτρέπεται η υπερβολική χρήση των πόρων, δίνοντας στο μεταπωλητή τη δυνατότητα να χρησιμοποιήσει περισσότερους πόρους απ' όσους είχαν προβλεφθεί αρχικά. Η πραγματική χρήση των πόρων μπορεί να υπερβαίνει την αρχική κατανομή πόρων",
    'limits__reseller_overuse_notify_text' => "Να ειδοποιείται ο μεταπωλητής σχετικά με την επίτευξη των ορίων χρήσης πόρων",
    'reseller_perm__manage_sh_access_disabled' => "Ο μεταπωλητής δεν μπορεί να επιτρέψει ή να απαγορεύσει την πρόσβαση στο κέλυφος",
    'reseller_perm__manage_sh_access_chrooted' => "Ο μεταπωλητής μπορεί να επιτρέψει την πρόσβαση μόνο σε περιβάλλον chrooted",
    'reseller_perm__manage_sh_access_any' => "Ο μεταπωλητής μπορεί να επιτρέψει την πρόσβαση σε κάθε τύπο κελύφους",
    'template__reseller_num_excl_ips' => "Εκχώρηση αποκλειστικής διεύθυνσης IP στο μεταπωλητή",

    // Reseller's Home page
    'client_chown__no_clients_selected' => 'Επιλέξτε τους λογαριασμούς πελατών στους οποίους θέλετε να εκχωρήσετε νέο κάτοχο.',
    'ui__reseller#tools2__title' => "Λογαριασμός",
    'ui__reseller#info__title' => "Πληροφορίες",
    'ui__reseller#clientsTab__title' => "Πελάτες",
    'ui__reseller#domainsTab__title' => "Τομείς",
    'ui__reseller__title' => "Διαχείριση λογαριασμού μεταπωλητή %1",
    'domains__reseller_info' => "%1 πελάτες, %2 τομείς, %3 χώρος στο δίσκο που χρησιμοποιείται, %4 δεδομένα που μεταφέρθηκαν.",
    'domains__reseller_info_hiding_traffic' => "%1 πελάτες, %2 τομείς, %3 χώρος στο δίσκο που χρησιμοποιείται.",
    'ui__reseller__description' => "Διαχείριση λογαριασμού μεταπωλητή.",

    'ui__reseller/limits_unknown__wizard-title' => 'Προβολή ή αλλαγή ορίων πόρων για ένα μεταπωλητή',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Επιλέξτε τον επιθυμητό μεταπωλητή.',
    'ui__reseller/limits_unknown__wizard__2' => 'Για να εφαρμόσετε τις αλλαγές, κάντε κλικ στο Τέλος.',

    'ui__client/report_reseller__short-title' => "Αναφορά",
    'ui__client/report_reseller__title' => "Προβολή αναφοράς λογαριασμού",
    'ui__client/report_reseller__description' => "Προβολή αναφοράς λογαριασμού μεταπωλητή.",
    'ui__client/ip-pool_reseller__short-title' => "Χώρος IP",
    'ui__client/ip-pool_reseller__description' => "Εκχώρηση διευθύνσεων IP και πιστοποιητικών SSL/TLS στο λογαριασμό μεταπωλητή.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Καθορίστε τις ρυθμίσεις του λογαριασμού και κάντε κλικ στο Τέλος.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Προβολή ή αλλαγή δικαιωμάτων για ένα μεταπωλητή',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Επιλέξτε το μεταπωλητή τα δικαιώματα του οποίου θέλετε να δείτε ή να αλλάξετε.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Όταν ολοκληρώσετε την αλλαγή των δικαιωμάτων του μεταπωλητή, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',

    // Customers > create customer account

    '__resellers_list' => 'Μεταπωλητές',
    'picker_reseller__title' => 'Επιλέξτε το μεταπωλητή',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Εργαλεία",
    'ui__client#tools2__title' => "Λογαριασμός",
    'ui__client#info__title' => "Πληροφορίες",
    'ui__client#clientslist__title' => "Πελάτες",
    'ui__client#domainslist__title' => "Τομείς",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Όλες οι εφαρμογές web έχουν ταξινομηθεί ανά κατηγορία, γεγονός που διευκολύνει την επιλογή της κατάλληλης εφαρμογής για εγκατάσταση.",
    'feature__domainkeys__reseller' => "Μπορείτε να χρησιμοποιήσετε το μηχανισμό ελέγχου ταυτότητας αποστολέων ηλεκτρονικού ταχυδρομείου DKIM για να μειώσετε τον όγκο της ανεπιθύμητης αλληλογραφίας και των μηνυμάτων ηλεκτρονικού ψαρέματος.",

    '__reseller_form' => "Φόρμα μεταπωλητή",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Επιλέξτε το λογαριασμό πελάτη τις ρυθμίσεις του οποίου θέλετε να αλλάξετε.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Για να αλλάξετε τα όρια χρήσης των πόρων, κάντε κλικ στην επιλογή Όρια πόρων.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Για να αλλάξετε τα δικαιώματα για τις ενέργειες που μπορεί να εκτελέσει ο πελάτης στο Plesk, κάντε κλικ στην επιλογή Δικαιώματα.",

    // Reseller's session in the control panel - Home page > Create Domain
    'ui__client/domain/properties_new__wizard__reseller' => "Για να δημιουργήσετε έναν τομέα που θα ανήκει στο δικό σας λογαριασμό, κάντε κλικ στην επιλογή Δημιουργία τομέα. Για να δημιουργήσετε ένα τομέα για έναν από τους πελάτες σας, κάντε κλικ στο όνομα του πελάτη και, στη συνέχεια, κάντε κλικ στην επιλογή Δημιουργία τομέα.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Να καταστεί αυτό το πρότυπο διαθέσιμο σε άλλους χρήστες",
    'template__shared_description' => "Ενεργοποιήστε αυτήν την επιλογή αν θέλετε οι πελάτες σας να έχουν τη δυνατότητα να χρησιμοποιήσουν αυτό το πρότυπο.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Εργαλεία',

    'ui__client/traffic-history_unknown__short-title' => 'Προβολή κίνησης πελατών',
    'ui__client/traffic-history_unknown__title' => 'Κίνηση από τους πελάτες',
    'ui__client/traffic-history_unknown__description' => 'Προβολή αναφοράς χρήσης κίνησης για όλους τους πελάτες',
    'ui__client/traffic-history__short-title' => 'Κίνηση από τους πελάτες',
    'ui__client/traffic-history__title' => 'Προβολή κίνησης πελατών',
    'ui__client/traffic-history__description' => 'Προβολή αναφοράς χρήσης κίνησης για όλους τους πελάτες',

    'ui__client/traffic#list__title' => 'Κίνηση από τους πελάτες',
    'ui__reseller/client/traffic#list__title' => 'Κίνηση από τους πελάτες',

    'clients_list__filter_type__filter_title' => 'Εμφάνιση',
    'clients_list__filter_type_any' => 'Πελάτες και μεταπωλητές',
    'clients_list__filter_type_clients' => 'Μόνο πελάτες',
    'clients_list__filter_type_resellers' => 'Μόνο μεταπωλητές',
    'ui__client/domain_unknown-new__short-title' => "Δημιουργία τομέα",

    // Customers > View traffic by customers
    '__personal' => "Κίνηση που χρησιμοποιείται από τους τομείς του χρήστη",
    'PersonalTrafficList_header_of_client__' => "Προβολή αναφοράς χρήσης κίνησης για το λογαριασμό σας",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Ο διαχειριστής τομέα δεν μπορεί να επιτρέψει ή να απαγορεύσει την πρόσβαση στο κέλυφος",
    'domain_perm__manage_sh_access_chrooted' => "Ο διαχειριστής τομέα μπορεί να επιτρέψει την πρόσβαση μόνο σε περιβάλλον chrooted",
    'domain_perm__manage_sh_access_any' => "Ο διαχειριστής τομέα μπορεί να επιτρέψει την πρόσβαση σε κάθε τύπο κελύφους",

    // APS Catalog
    'bt_add_to_vault' => "Προσθήκη στο Vault",
    'bt_hide_updates' => "Απόκρυψη διαθέσιμων ενημερώσεων",
    'bt_show_updates' => "Εμφάνιση διαθέσιμων ενημερώσεων",

    '__site_apps__applications' => "Εφαρμογές",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Εφαρμογές που έχουν επιλεγεί για προσθήκη στο vault",
    'site_apps__application_selected' => "Επιλεγμένo",
    'site_apps__currently_in_vault' => "Άλλες εκδόσεις που βρίσκονται ήδη στο vault:",
    'site_apps__new_versions' => "Νέες εκδόσεις:",
    'site_apps__patches' => "Ενημερώσεις κώδικα:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Αριθμός εφαρμογών που έχουν προγραμματιστεί για προσθήκη στο vault: %1",
    'site_apps__applications_downloading_now' => "Πραγματοποιείται λήψη των ακόλουθων εφαρμογών: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Ήδη στο vault",

    // Server > Action Log
    'bt_skin_edit' => "Επεξεργασία περιγραφής εμφάνισης",
    'domains__you_want_change_the_status_of_the_reseller??' => "Είστε βέβαιοι ότι θέλετε να διαγράψετε την κατάσταση του λογαριασμού μεταπωλητή;",
    'limits__oversell_legend' => "Υπερπώληση",
    'limitsManager__limit_available_error' => "Δεν είναι δυνατή η εκχώρηση των απαιτούμενων πόρων (%%quantity%% %%limitName%%).  Διατίθενται μόνο %%available%% %%limitName%%.",
    'limitsManager__limit_reserved_error' => "Δεν είναι δυνατός ο καθορισμός του απαιτούμενου ορίου χρήσης πόρων (%%quantity%% %%limitName%%) επειδή η νέα τιμή είναι μικρότερη από την ποσότητα των πόρων που έχουν δεσμευτεί για τους πελάτες σας ή χρησιμοποιούνται από εσάς (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Δεν είναι δυνατός ο καθορισμός του απαιτούμενου ορίου χρήσης πόρων (%%quantity%% %%limitName%%) επειδή η νέα τιμή είναι μικρότερη από την πραγματική ποσότητα των πόρων που χρησιμοποιούνται ήδη από το λογαριασμό και τις τοποθεσίες σας (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Χρήση εύρους ζώνης από τις υπηρεσίες",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Προβολή αναφοράς χρήσης κίνησης",
    'ui__client/domain/traffic_unknown-reseller__title' => "Προβολή αναφοράς χρήσης κίνησης",

    'ui__client/domain_new__short-title' => "Δημιουργία τομέα",

    'ui__client_reseller__description' => "Διαχείριση λογαριασμού μεταπωλητή %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Διαχείριση λογαριασμού μεταπωλητή",

    '__owner_name' => "Όνομα κατόχου",
    'domains_list__resource__filter_title' => "Χρήση πόρων",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Κατάλογος εφαρμογών APS",
    'site_apps__applications_have_updates' => "Υπάρχουν διαθέσιμες ενημερωμένες εκδόσεις για τις παρακάτω εφαρμογές:\n%1\nΓια να δείτε τις ενημερώσεις, βεβαιωθείτε ότι εμφανίζεται η περιοχή αναζήτησης, επιλέξτε το πλαίσιο ελέγχου <b>Εμφάνιση μόνο των ενημερώσεων</b> και αναζητήστε τις εφαρμογές που χρειάζεστε.",
    'site_apps__progress_adding_to_vault' => "Προσθήκη στο vault:",
    'site_apps__progress_done_message' => "Πρόοδος:",
    'site_apps__progress_applications_left' => "απομένουν %1 από %2 εφαρμογές",
    'site_apps__download_item_long_task_title' => "Λήψη εφαρμογής APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Λήψη εφαρμογών APS από τον κατάλογο APS",
    'site_apps__last_check_for_updates' => "τελευταίος έλεγχος για ενημερώσεις: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Όλες οι προγραμματισμένες εφαρμογές προστέθηκαν με επιτυχία στο Application Vault",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 προγραμματισμένες εφαρμογές προστέθηκαν με επιτυχία στο Application Vault.",
    'site_apps__no_search_results' => 'Δεν εντοπίστηκαν εφαρμογές.  Δοκιμάστε διαφορετικό ερώτημα αναζήτησης ή περιηγηθείτε στις εφαρμογές ανά κατηγορία.',
    'site_apps__search_results_title' => 'Αποτελέσματα αναζήτησης',
    '__site_apps__search_by_application' => 'Όνομα εφαρμογής',
    '__site_apps__search_by_vendor' => 'Προμηθευτής',
    '__site_apps__search_by_vendor__all' => 'Όλοι οι προμηθευτές',
    '__site_apps__search_by_packager' => 'Συσκευασία',
    '__site_apps__search_by_certification_level' => 'Επίπεδο πιστοποίησης',
    '__site_apps__search_by_cert__any' => 'Οποιοδήποτε',
    '__site_apps__search_by_cert__silver_and_higher' => 'Ασημένιο και υψηλότερο',
    '__site_apps__search_by_cert__gold_and_higher' => 'Χρυσό και υψηλότερο',
    '__retry' => 'Επανάληψη',
    'site_apps__application_packager_site' => 'Συσκευασία',
    'site_apps__add_to_pool_message' => "Οι εφαρμογές που επισημαίνονται ως \\\"available for all\\\" διατίθενται αυτόματα σε όλους τους μεταπωλητές και τους πελάτες με απεριόριστο αριθμό εγκαταστάσεων. Οι περιορισμένες εφαρμογές διατίθενται χειροκίνητα σε όλους τους μεταπωλητές και πελάτες σε ατομική βάση, με ρητά καθορισμένο αριθμό διαθέσιμων εγκαταστάσεων.",
    'site_apps__make_available_for_all' => "Να καταστούν οι επιλεγμένες εφαρμογές διαθέσιμες σε όλους τους χρήστες",

    'site_apps__broadcast_app_text' => "Οι εφαρμογές που επισημαίνονται ως \\\"available for all\\\" διατίθενται αυτόματα σε όλους τους μεταπωλητές και τους πελάτες με απεριόριστο αριθμό εγκαταστάσεων. Οι περιορισμένες εφαρμογές διατίθενται χειροκίνητα σε όλους τους μεταπωλητές και πελάτες σε ατομική βάση, με ρητά καθορισμένο αριθμό διαθέσιμων εγκαταστάσεων.",
    'site_apps__broadcast_app_name' => 'Να καταστεί η εφαρμογή διαθέσιμη σε όλους τους χρήστες',

    // User Application Pool per application
    'site_apps__available_clients' => 'Διαθέσιμοι χρήστες',
    'site_apps__no_more_clients_to_add_to_pool' => 'Δεν υπάρχουν άλλοι λογαριασμοί χρηστών στους οποίους μπορείτε να διαθέσετε αυτήν την εφαρμογή',

    // Installed application instances
    'site_apps__installations' => 'Εγκαταστάσεις',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Όνομα τομέα και διεύθυνση IP",
    '__assign_ip_address' => "Εκχώρηση διεύθυνσης IP",
    '__switch_on_service' => "Ενεργοποίηση υπηρεσίας",
    '__hosting_configuration' => "Ρύθμιση παραμέτρων φιλοξενίας",
    '__vrt_hst' => "Φιλοξενία τοποθεσίας web",
    '__vrt_hst_hint' => "Φιλοξενία τοποθεσίας web σε αυτόν το διακομιστή.",
    '__fwd' => "Προώθηση",
    '__web_hosting_settings' => "Ρυθμίσεις φιλοξενίας",
    '__fwd_hint' => "Ανακατεύθυνση επισκεπτών σε άλλη τοποθεσία web.",
    '__none_hint' => "Να μην φιλοξενηθεί τοποθεσία web αυτήν τη στιγμή.",
    '__login_hint' => "Αυτό το όνομα χρήστη χρησιμοποιείται για την πρόσβαση στην τοποθεσία web σας μέσω FTP",
    '__password_hint' => "Αυτός ο κωδικός πρόσβασης χρησιμοποιείται για την πρόσβαση στην τοποθεσία web σας μέσω FTP",
    '__advanced_hosting_setup' => "Διαμόρφωση προηγμένων ρυθμίσεων φιλοξενίας τοποθεσιών web",
    '__domain_creation_successful' => "Ο τομέας δημιουργήθηκε.",
    'bt_hosting_settings' => "Ρυθμίσεις φιλοξενίας",
    '__change_hosting_type' => "Αλλαγή τύπου φιλοξενίας για τον τομέα %1",
    '__hosting_type_change_warning' => "Όταν αλλάζετε τον τύπο φιλοξενίας σε προώθηση ή χωρίς φιλοξενία, όλα τα αρχεία και οι κατάλογοι που σχετίζονται με την τοποθεσία σας καταργούνται από το διακομιστή.  Βεβαιωθείτε πως έχετε αποθηκεύσει ένα τοπικό αντίγραφο της τοποθεσίας σας.",
    '__current_hosting_type' => "Τρέχων τύπος φιλοξενίας",
    '__new_hosting_type' => "Νέος τύπος φιλοξενίας",
    '__fwd_settings' => "Ρυθμίσεις προώθησης",
    '__fwd_settings_legend' => "Ρυθμίσεις προώθησης",
    '__fwd_destination_url' => "Διεύθυνση URL προορισμού",
    '__fwd_type' => "Τύπος προώθησης",
    '__fwd_type_standart' => "Τυπική ανακατεύθυνση",
    '__fwd_type_standart_hint' => "Να ανακατευθύνονται οι επισκέπτες σε άλλη τοποθεσία web και να τους εμφανίζεται η διεύθυνση προορισμού, ούτως ώστε να γνωρίζουν για την ανακατεύθυνση.",
    '__fwd_type_frame' => "Κρυμμένη ανακατεύθυνση",
    '__fwd_type_frame_hint' => "Να ανακατευθύνονται οι επισκέπτες σε άλλη τοποθεσία web, αλλά να μην τους εμφανίζεται η διεύθυνση προορισμού, ούτως ώστε να μην γνωρίζουν για την ανακατεύθυνση.",
    '__hosting_type_template_warning' => "Ο τύπος της φιλοξενίας που έχετε επιλέξει είναι διαφορετικός από τον τύπο που ορίζεται στο πρότυπο.  Αν συνεχίσετε, οι ρυθμίσεις φιλοξενίας περιεχομένου web στο επιλεγμένο πρότυπο θα αγνοηθούν.  Είστε βέβαιοι ότι θέλετε να ορίσετε τον επιλεγμένο τύπο φιλοξενίας;",

    'ui__client/domain/properties#vrt_hst__title' => "Φιλοξενία τοποθεσίας web",
    'ui__client/domain/properties#vrt_hst__description' => "Φιλοξενία τοποθεσίας web σε αυτόν το διακομιστή",
    'ui__client/domain/properties#fwd__title' => "Προώθηση",
    'ui__client/domain/properties#fwd__description' => "Ανακατεύθυνση επισκεπτών σε άλλη τοποθεσία web",
    'ui__client/domain/properties#none__title' => "Χωρίς φιλοξενία",
    'ui__client/domain/properties#none__description' => "Να μην φιλοξενηθεί τοποθεσία web αυτήν τη στιγμή",

    '__no_resellers_selected' => "Πρέπει να επιλέξετε τουλάχιστον ένα λογαριασμό μεταπωλητή.",

    'ui__client/logo_unknown__wizard-title' => 'Ρύθμιση λογοτύπου',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Επιλέξτε τον πελάτη τις ιδιότητες λογοτύπου του οποίου θέλετε να αλλάξετε.',
    'ui__client/logo_unknown__wizard__2' => 'Πατήστε Τέλος για να εφαρμόσετε τις αλλαγές.',
    'ui__client/logo_unknown__wizard__2_self' => 'Πατήστε Τέλος για να εφαρμόσετε τις αλλαγές.',

    'ui__client/ipaddress/properties_new__short-title' => "Προσθήκη διεύθυνσης IP",
    'ui__client/ipaddress/properties_new__title' => 'Προσθήκη διεύθυνσης IP',
    'ui__client/ipaddress/properties_new__description' => "Προσθήκη διεύθυνσης IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Προσθήκη διεύθυνσης IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "Προσθήκη διεύθυνσης IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "Προσθήκη διεύθυνσης IP",
    'ui__client/ipaddress/delete_multi__short-title' => "Κατάργηση διεύθυνσης IP",
    'ui__client/ipaddress/delete_multi__description' => "Κατάργηση διευθύνσεων IP.",
    'ippool_Manager__no_available_ips' => "Δεν υπάρχουν ελεύθερες διευθύνσεις IP στο χώρο IP.",
    'ippool_Manager__ip_shared' => "κοινόχρηστο",
    'ippool_Manager__ip_exclusive' => "αποκλειστικό",
    'ui__client/ipaddress/properties__title' => "Διαχείριση διευθύνσεων IP",
    'ui__client/ipaddress/properties__description' => "Προβολή ή αλλαγή των ιδιοτήτων της διεύθυνσης IP.",
    'ui__client/ipaddress_unknown-new__title' => "Προσθήκη διεύθυνσης IP",
    'ui__client/ipaddress_unknown-new__short-title' => "Προσθήκη διεύθυνσης IP",
    'ui__client/ipaddress_unknown-new__description' => "Προσθήκη διευθύνσεων IP.",

    'ui__mass-mail#to_resellers_text__title' => "Μεταπωλητές",
    'ui__mass-mail#to_domainusers_text__title' => "Διαχειριστές τομέα",
    'ui__mass-email#tools_legend__title' => "Εργαλεία",
    'ui__mass-email#list_legend__title' => 'Πρότυπα μηνυμάτων μαζικής αλληλογραφίας',
    'ui__mass-email#template_legend__title' => "Πρότυπο",
    'ui__mass-email#from_email_text__title' => "Από",
    'ui__mass-email#to_text__title' => 'Προς',
    'ui__mass-email#to_resellers_text__title' => "Μεταπωλητές",
    'ui__mass-email#to_clients_text__title' => "Πελάτες",
    'ui__mass-email#to_domainusers_text__title' => "Διαχειριστές τομέα",
    'ui__mass-email#to_admin_text__title' => "Διαχειριστής Plesk",
    'ui__mass-email#option_mode_all__title' => "Όλες",
    'ui__mass-email#option_mode_select__title' => "Μόνο οι επιλεγμένες",
    'ui__mass-email#option_mode_except__title' => "Όλες εκτός των επιλεγμένων",
    'ui__mass-email#option_select_template__title' => '---Επιλέξτε ένα πρότυπο---',
    'ui__mass-email#subject_text__title' => "Θέμα",
    'ui__mass-email#body_text__title' => "Κείμενο μηνύματος",
    'ui__mass-email#save_as_legend__title' => "Αποθήκευση ως πρότυπο",
    'ui__mass-email#save_as_text__title' => "Αποθήκευση του κειμένου που συντάχθηκε σε νέο πρότυπο με το όνομα",
    'ui__reseller/preferences_unknown__wizard-title' => "Αλλαγή ρυθμίσεων λογαριασμού",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Επιλέξτε το μεταπωλητή τις ρυθμίσεις λογαριασμού του οποίου θέλετε να αλλάξετε και κάντε κλικ στο Επόμενο >>.",
    'ui__reseller/preferences_unknown__wizard__2' => "Καθορίστε τις ρυθμίσεις του λογαριασμού και κάντε κλικ στο OK.",
    'ippoolManager__ip_shared' => "κοινόχρηστο",
    'ippoolManager__ip_exclusive' => "αποκλειστικό",

    '__users_list' => "Χρήστες",
    '__users' => "Χρήστες",
    '__user_name' => "Όνομα χρήστη",

    'clientOwnerChanger__wrong_owner_type' => "Μπορείτε να μεταφέρετε τους επιλεγμένους λογαριασμούς πελατών μόνο σε λογαριασμό μεταπωλητή.",
    'clientOwnerChanger__wrong_client_type' => 'Ο επιλεγμένος λογαριασμός χρήστη είναι λογαριασμός μεταπωλητή.  Οι λογαριασμοί μεταπωλητών δεν μπορούν να εκχωρηθούν σε νέο κάτοχο καθώς βρίσκονται υπό την κυριότητα του διαχειριστή του διακομιστή.',
    'ui__client/chowner_multi__description' => "Μεταφορά λογαριασμών χρηστών σε άλλο κάτοχο.",
    'client_chown__clients_list_legend' => "Λογαριασμοί χρηστών",
    'client_chown__client_name' => "Όνομα χρήστη",
    'client_chown__old_owner' => "Προηγούμενος κάτοχος",
    'client_chown__limits_legend' => "Πόροι",
    'client_chown__limit_name' => "Όνομα πόρου",
    'client_chown__limit_value' => "Εκχωρημένοι πόροι",
    'client_chown__usage_before' => "Πριν τη μεταφορά",
    'client_chown_usage_after' => "Μετά τη μεταφορά",
    'limit__name_max_dom_aliases' => "ψευδώνυμα τομέα",
    'limit__name_max_subftp_users' => "Πρόσθετοι λογαριασμοί FTP",
    'limit__name_max_mssql_db' => "Βάσεις δεδομένων Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Χώροι συγκέντρωσης εφαρμογών IIS",
    'limit__name_max_odbc' => "Συνδέσεις ODBC",
    'total_mboxes_quota_unsupported' => 'δεν υποστηρίζεται από το διακομιστή αλληλογραφίας',
    'limit_soft__disk_space' => 'Ειδοποίηση όταν επιτυγχάνεται το όριο χώρου στο δίσκο',
    'limit_soft__max_traffic' => 'Ειδοποίηση όταν επιτυγχάνεται το όριο κίνησης',
    'dsr__of_reseller_title' => "Χρήση πόρων από τους τομείς",
    'client_chown__new_owner' => 'Νέος κάτοχος',
    'ui__reseller/to-client__has_clients_warning' => 'Ορισμένοι από τους επιλεγμένους λογαριασμούς μεταπωλητών δεν μπορούν να μετατραπούν σε λογαριασμούς πελατών επειδή διαθέτουν εγγεγραμμένους πελάτες στις υπηρεσίες τους.  Καταργήστε τους λογαριασμούς πελατών που είναι εγγεγραμμένοι σε αυτόν το μεταπωλητή ή μετακινήστε τους σε άλλο μεταπωλητή.',
    'limitsManager__commit_failed' => "Δεν είναι δυνατή η αλλαγή των ορίων πόρων.",
    'limitsManager__date_in_past' => "Λανθασμένη ημερομηνία λήξης %1.",
    'limitsManager__limit_not_supported' => "Δεν είναι δυνατός ο καθορισμός ορίων για τον τύπο πόρων %1.",
    'limitsManager__limit_oversell_inconsistency' => "Δεν είναι δυνατή η εκχώρηση της καθορισμένης ποσότητας πόρων με απενεργοποιημένη την υπερπώληση.",
    'limitsManager__limit_overuse_inconsistency' => "Η χρήση των πόρων υπερβαίνει τα καθορισμένα όρια.",
    'limitsManager__no_resource_available' => "Δεν υπάρχουν διαθέσιμοι πόροι αυτού του τύπου (%%limitName%%).  Απαιτούνται: %%quantity%%, διαθέσιμοι: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Δεν υπάρχουν διαθέσιμοι πόροι αυτού του τύπου (%%limitName%%) από τον πάροχο υπηρεσιών σας. Απαιτούνται: %%quantity%%, διαθέσιμοι: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Η ημερομηνία λήξης πρέπει να είναι μικρότερη ή ίση με %1.",
    'limitsManager__invalid_disk_space_limit' => "Η ποσότητα του χώρου στο δίσκο πρέπει να είναι μικρότερη ή ίση με %1.",
    'limitsManager__invalid_max_traffic_limit' => "Η ποσότητα της κίνησης πρέπει να είναι μικρότερη ή ίση με %1.",
    'ippoolManager__ip_has_suballocations' => "Δεν είναι δυνατή η αλλαγή του τύπου μιας διεύθυνσης IP που έχει εκχωρηθεί ήδη σε χρήστη.  Η διεύθυνση IP %%ip%% έχει εκχωρηθεί ήδη στον(ους) χρήστης(ες) ως διεύθυνση IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Αυτή η διεύθυνση IP έχει εκχωρηθεί ήδη στο χρήστη.",
    'ippoolManager__ip_is_not_in_pool' => "Δεν υπάρχει διεύθυνση IP %%ip%% στο χώρο.",
    'ippoolManager__can_not_allocate_ip' => "Η διεύθυνση IP %%ip%% είναι διαθέσιμη μόνο ως %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "Η διεύθυνση IP %%ip%% δεν μπορεί να εκχωρηθεί ως αποκλειστική.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Η διεύθυνση IP %%ip%% χρησιμοποιείται ήδη για φιλοξενία.",
    'ippoolManager__active_anon_ftp_on_ip' => "Η πρόσβαση στο ανώνυμο FTP είναι ήδη ενεργοποιημένη για τη διεύθυνση IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Δεν υπάρχουν ελεύθερες διευθύνσεις IP.",
    'ippoolManager__no_available_ips' => "Δεν υπάρχουν διαθέσιμες διευθύνσεις IP.",
    'templates__dublicate_name' => "Υπάρχει ήδη πρότυπο με αυτό το όνομα. Επιλέξτε άλλο όνομα γι' αυτό το πρότυπο.",
    'cl_perm__client_limits_exceeded' => "Οι καθορισμένες τιμές των ορίων πόρων υπερβαίνουν τις τιμές που επιτρέπονται βάσει του προγράμματος φιλοξενίας σας ή οι τιμές αυτές παρέχουν λιγότερους πόρους απ' όσους χρησιμοποιούν επί του παρόντος οι τοποθεσίες σας.",
    'cl_perm__reseller_limits_exceeded' => "Οι καθορισμένες τιμές των ορίων πόρων υπερβαίνουν τις τιμές που επιτρέπονται βάσει του προγράμματος φιλοξενίας σας ή οι τιμές αυτές παρέχουν λιγότερους πόρους απ' όσους χρησιμοποιούν επί του παρόντος οι λογαριασμοί και οι τοποθεσίες των χρηστών.",

    'site_apps__preferences_show_all_versions_title' => "Εμφάνιση της πλήρους λίστας εκδόσεων για κάθε εφαρμογή που ανακτάται από τον κατάλογο",
    'site_apps__preferences_show_all_versions_hint' => "Αν ενεργοποιηθεί αυτή η επιλογή, η ανάκτηση όλων των εκδόσεων κάθε εφαρμογής μπορεί να διαρκεί μεγάλο χρονικό διάστημα κάθε φορά που ανοίγετε τον κατάλογο.  Αν αυτή η επιλογή δεν ενεργοποιηθεί, εμφανίζονται μόνο οι τελευταίες εκδόσεις.",
    '__select_user_template' => "Δημιουργία νέου λογαριασμού χρήστη βάσει ενός προτύπου",
    'ip_already_added_to_all_clients' => "Αυτή η διεύθυνση IP έχει εκχωρηθεί ήδη σε άλλους χρήστες.",
    'ui__server/ip-address/client/delete#legend__description' => "Οι παρακάτω διευθύνσεις IP θα καταργηθούν από τους χώρους IP του συστήματος και των χρηστών:",

    'site_apps__cancelled_apps' => "Ακυρώσατε την προσθήκη των παρακάτω εφαρμογών: %2",

    'sb_url_is_not_resolved' => 'Δεν είναι δυνατή η ανάλυση της διεύθυνσης URL: ελέγξτε τις ρυθμίσεις DNS σας.  Η διεύθυνση URL %1 πρέπει να αναλύεται στη διεύθυνση IP του διακομιστή όπου έχει εγκατασταθεί το Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Δεν είναι δυνατή η κατάργηση της διεύθυνσης IP %%ip%% επειδή είναι η τελευταία διεύθυνση IP που υπάρχει σε μια διασύνδεση δικτύου.',
    'ip_addr__used_for_current_session' => 'Δεν είναι δυνατή η κατάργηση της διεύθυνσης IP %%ip%% επειδή χρησιμοποιείται από μια ενεργή περίοδο λειτουργίας.',
    'ip_addr__used_for_hosting' => 'Δεν είναι δυνατή η κατάργηση της διεύθυνσης IP %%ip%% επειδή χρησιμοποιείται για τη φιλοξενία μιας τοποθεσίας web.',
    'ip_addr__is_main' => 'Δεν είναι δυνατή η κατάργηση της διεύθυνσης IP %%ip%% επειδή είναι η κύρια διεύθυνση IP μιας διασύνδεσης δικτύου.',
    'ip_addr__ip_used_by_message_submission' => 'Δεν είναι δυνατή η κατάργηση της διεύθυνσης IP %%ip%% επειδή χρησιμοποιείται για την υποβολή των μηνυμάτων ηλεκτρονικού ταχυδρομείου',

    // RESELLER ACTION LOG

    '__cl_domains' => 'τομείς των πελατών',
    'excl_ip_num' => 'Αποκλειστική διεύθυνση IP',

    'sb_err_sitebuilder_not_installed' => 'Το Presence Builder δεν έχει εγκατασταθεί.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Το δικαίωμα υπερπώλησης δεν μπορεί να ανακληθεί από το χρήστη δεδομένου ότι ο χρήστης έχει ήδη εκχωρήσει περισσότερους από τους διαθέσιμους πόρους, μεταβαίνοντας έτσι σε λειτουργία υπερπώλησης.',
    'limitsManager__invalid_limit_value' => 'Καθορίστηκε λανθασμένη τιμή %%value%% για το όριο %%limit_name%%',
    'ip_alias__type' => "Η διεύθυνση IP έχει διανεμηθεί ως",
    'ip_alias__in_type' => 'Η διεύθυνση IP έχει εκχωρηθεί ως',
    'ui__client/ipaddress/delete_multi__title' => 'Κατάργηση διευθύνσεων IP',
    'ui__client/ipaddress/delete#legend__short-title' => 'Στοιχεία που θα καταργηθούν',
    'ui__client/ipaddress/delete#legend__description' => "Οι παρακάτω διευθύνσεις IP θα καταργηθούν από το χώρο IP του χρήστη:",
    'ui__client/ipaddress/delete#nlegend__short-title' => 'Στοιχεία που δεν μπορούν να καταργηθούν',
    'ui__client/ipaddress/delete#nlegend__description' => 'Δεν είναι δυνατή η κατάργηση των παρακάτω διευθύνσεων IP:',
    'ui__server/ip-address/delete#legend__description' => 'Οι παρακάτω διευθύνσεις IP θα καταργηθούν από το χώρο IP του διακομιστή:',
    'confirmationForm_default_agreement_text' => 'Επιβεβαίωση της λειτουργίας',
    'confirmationForm_default_confirm_message' => 'Επιβεβαιώστε την ενέργεια.',
    'limit__max_mn' => 'Μέγιστος αριθμός λογαριασμών αλληλογραφίας',

    'limits__client_overuse_description' => 'Η πολιτική υπερβολικής χρήσης υποδεικνύει στο Plesk τι πρέπει να κάνει όταν η χρήση των πόρων υπερβαίνει την αρχική κατανομή πόρων.',
    'limits__client_overuse_block_true_description' => 'Αποκλεισμός της υπερβολικής χρήσης πόρων. Η πραγματική χρήση των πόρων δεν μπορεί να υπερβαίνει την αρχική κατανομή πόρων',
    'limits__client_overuse_block_false_description' => 'Να μην αποτρέπεται η υπερβολική χρήση των πόρων, δίνοντας στον πελάτη τη δυνατότητα να χρησιμοποιήσει περισσότερους πόρους απ\' όσους είχαν προβλεφθεί αρχικά.  Η πραγματική χρήση των πόρων μπορεί να υπερβαίνει την αρχική κατανομή πόρων',
    'limits__client_overuse_notify_text' => 'Να ειδοποιείται ο πελάτης σχετικά με τη συμπλήρωση των ορίων χρήσης πόρων',

    'limits__domain_overuse_description' => 'Η πολιτική υπερβολικής χρήσης υποδεικνύει στο Plesk τι πρέπει να κάνει όταν η χρήση των πόρων υπερβαίνει την αρχική κατανομή πόρων.',
    'limits__domain_overuse_block_true_description' => 'Η πολιτική υπερβολικής χρήσης υπαγορεύει στο Plesk τι πρέπει να κάνει όταν πραγματοποιείται υπερβολική χρήση των πόρων.',
    'limits__domain_overuse_block_false_description' => 'Να μην αποτρέπεται η υπερβολική χρήση των πόρων, δίνοντας στον τομέα τη δυνατότητα να χρησιμοποιήσει περισσότερους πόρους απ\' όσους είχαν προβλεφθεί αρχικά. Η πραγματική χρήση των πόρων μπορεί να υπερβαίνει την αρχική κατανομή πόρων',
    'limits__domain_overuse_notify_text' => 'Να ειδοποιείται ο κάτοχος του τομέα σχετικά με την επίτευξη των ορίων χρήσης πόρων',


    'cancel_remove' => 'Απόρριψη αλλαγών και επιστροφή στην προηγούμενη σελίδα.',
    'php_not_installed' => 'Το PHP δεν έχει εγκατασταθεί',

    'dns__dns_rr_delete' => 'Στοιχεία που θα καταργηθούν',
    'dns__delete_rr' => 'Οι παρακάτω εγγραφές DNS θα καταργηθούν από τη ζώνη DNS:',
    'dns__dns_rr_delete_non_removable' => 'Στοιχεία που δεν μπορούν να καταργηθούν',
    'dns__non_delete_rr' => 'Δεν είναι δυνατή η κατάργηση των ακόλουθων εγγραφών DNS:',
    'dns__dns_rr_delete_confirm_message' => 'Επιβεβαιώστε την κατάργηση των εγγραφών DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Άγνωστη μορφή εφαρμογής web: η εφαρμογή web μπορεί να μην είναι διαθέσιμη για εγκατάσταση και χρήση.',

    '__php_handler_type_desc' => 'Εκτέλεση PHP ως',
    'sfdk_domain_sign__failed' => 'Παρουσιάστηκε άγνωστο σφάλμα κατά την προσπάθεια ενεργοποίησης της υπογραφής της αλληλογραφίας με το DKIM στον τομέα. Ανατρέξτε στο αρχείο καταγραφής σφαλμάτων του διακομιστή για περισσότερες πληροφορίες.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Ειδοποίηση επιτυχούς ενημέρωσης κλειδιού Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Ειδοποίηση αναβολής ενημέρωσης κλειδιού Plesk',
    'pkey_notify__subj_update_error_notification' => 'Ειδοποίηση σφάλματος ενημέρωσης κλειδιού Plesk',
    'pkey_notify__update_successful' => 'Η ενημέρωση του %1 ολοκληρώθηκε με επιτυχία.',
    'pkey_notify__update_failed_no_more_try' => 'Δεν είναι δυνατή η ενημέρωση του %1. Το κλειδί που επιχειρείτε να αποστείλετε δεν είναι έγκυρο.  Μην συνεχίσετε να προσπαθείτε να ενημερώσετε αυτό το κλειδί.',
    'pkey_notify__update_failed_try_later' => 'Δεν είναι δυνατή η ενημέρωση του %1: Παρουσιάστηκε σφάλμα κατά την επεξεργασία του κλειδιού σας. Μπορείτε να δοκιμάσετε να ανακτήσετε χειροκίνητα το κλειδί στο Plesk (Εργαλεία & Ρυθμίσεις>Διαχείριση αδειών χρήσης) ή να αφήσετε το Plesk να επιχειρήσει την ενημέρωση μέσα στις επόμενες 24 ώρες. Εάν δεν θέλετε να λαμβάνετε πλέον την ειδοποίηση, καταργήστε αυτό το κλειδί από το Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Δεν είναι δυνατή η απενεργοποίηση του φιλτραρίσματος ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Δεν είναι δυνατή η ενεργοποίηση του φιλτραρίσματος ανεπιθύμητης αλληλογραφίας σε επίπεδο διακομιστή',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Αυτός ο μεταπωλητής',
    'report_auto__select_reseller_report_all' => 'Όλοι οι μεταπωλητές',
    'report_auto__select_reseller_report_client' => 'Όλοι οι μεταπωλητές αυτού του πελάτη',
    'report_auto__select_reseller_report_current' => 'Αυτός ο μεταπωλητής',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Όλοι οι πελάτες αυτού του μεταπωλητή',
    'report_auto__select_client_report_client' => 'Αυτός ο πελάτης',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'Μεταπωλητές, πελάτες και τομείς',

    'rpt_reseller_section_full_domains' => 'Τομείς',
    'rpt_reseller_dom_subdomains' => 'Υποτομείς',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'Διακομιστές προώθησης',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'AntiSpam',
    'rpt_reseller_dom_mail_antivirus' => 'Προστασία από ιούς',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Πελάτες',
    '__cl_name' => 'Όνομα πελάτη',
    '__cl_creation_date' => 'Ημερομηνία δημιουργίας',
    '__clients_traffic' => 'Κίνηση πελάτη',
    'rpt_reseller_cl_mail_antispam' => 'AntiSpam',
    'rpt_reseller_cl_mail_antivirus' => 'Προστασία από ιούς',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Το Presence Builder δεν έχει εγκατασταθεί.',
    'sitebuilder_disabled' => 'Το Presence Builder είναι απενεργοποιημένο.',
    'b_sitebuilder_disabled' => 'Το Presence Builder είναι απενεργοποιημένο.',
    'webmail_not_installed' => 'Το λογισμικό webmail δεν έχει εγκατασταθεί.',
    'webmail_disabled' => 'Η υπηρεσία webmail είναι απενεργοποιημένη.',
    'spamassassin_not_installed' => 'Το SpamAssassin δεν έχει εγκατασταθεί.',
    // pfu:
    'anonymous_ftp_shared' => 'Δεν είναι δυνατή η ρύθμιση ανώνυμου FTP: τύπος κοινόχρηστης διεύθυνσης IP.',
    'anonymous_ftp_used' => 'Δεν είναι δυνατή η ρύθμιση ανώνυμου FTP: η διεύθυνση IP χρησιμοποιείται από άλλο τομέα για την υπηρεσία ανώνυμου FTP.',
    'sshterm__not_installed' => 'Το τερματικό SSH δεν έχει εγκατασταθεί.',
    'sshterm__empty_shell' => 'Για να χρησιμοποιήσετε το πρόγραμμα-πελάτη τερματικού, πρέπει να επιτρέψετε την πρόσβασης κελύφους γι\' αυτόν τον τομέα.',
    // pfw:
    'aspdotnet_not_installed' => 'Το ASP.NET δεν έχει εγκατασταθεί.',
    'tsclient__not_installed' => 'Η απομακρυσμένη επιφάνεια εργασίας δεν έχει εγκατασταθεί.',
    'site_builder_no_package' => 'Το Presence Builder δεν είναι διαθέσιμο.  Βεβαιωθείτε ότι το Presence Builder έχει εγκατασταθεί και έχει επιλεγεί ως ενεργό στοιχείο.',
    'site_builder_not_configured' => 'Το Presence Builder δεν έχει διαμορφωθεί.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Εργαλεία',
    'ui__reseller/client#clientslist__title' => 'Πελάτες',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "Ρύθμιση προελεύσεων δεδομένων ODBC για τοποθεσία web",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "Επιλέξτε την τοποθεσία web για τις εφαρμογές της οποίας θέλετε να ρυθμίσετε προελεύσεις δεδομένων ODBC.",

    'ui__client/domain/hosting/tsclient_unknown__wizard-title' => "Πρόσβαση στον εικονικό κεντρικό υπολογιστή του τομέα μέσω Απομακρυσμένης επιφάνειας εργασίας",
    'ui__client/domain/hosting/tsclient_unknown__wizard__2_unknown' => "Επιλέξτε τον τομέα τον εικονικό κεντρικό υπολογιστή του οποίου θέλετε να προσπελάσετε μέσω Απομακρυσμένης επιφάνειας εργασίας.",

    'ui__client/domain/hosting/virtual-directories_unknown__wizard-title' => "Διαχείριση εικονικών καταλόγων στον τομέα",
    'ui__client/domain/hosting/virtual-directories_unknown__wizard__2_unknown' => "Επιλέξτε τον τομέα τους εικονικούς καταλόγους του οποίου θέλετε να διαχειριστείτε.",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Διαχείριση εικονικών καταλόγων μιας τοποθεσίας web',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Επιλέξτε την τοποθεσία web τους καταλόγους της οποίας θέλετε να διαχειριστείτε.",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "Ρύθμιση προστασίας hotlink για τον τομέα",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "Επιλέξτε τον τομέα τα αρχεία του οποίου θέλετε να προστατεύσετε από το hotlinking.",

    'ui__client/domain/hosting/php_unknown__wizard-title' => "Διαμόρφωση ρυθμίσεων PHP για τον τομέα",
    'ui__client/domain/hosting/php_unknown__wizard__2_unknown' => "Επιλέξτε τον τομέα τις ρυθμίσεις PHP του οποίου θέλετε να διαμορφώσετε.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Ρύθμιση ανώνυμου FTP στον τομέα',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα για τον οποίο θέλετε να ρυθμίσετε ανώνυμο FTP.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Διαχείριση καταλόγων με προστασία κωδικού πρόσβασης στον τομέα',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα τους καταλόγους με προστασία κωδικού πρόσβασης του οποίου θέλετε να διαχειριστείτε.',




    'ui__client/domain/report/web-stats_unknown__wizard-title' => 'Προβολή στατιστικών στοιχείων web για τον τομέα',
    'ui__client/domain/report/web-stats_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα για τον οποίο θέλετε να δείτε τα στατιστικά στοιχεία web.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Ρύθμιση διαχειριστή αρχείων καταγραφής για τον τομέα και προβολή αρχείων καταγραφής του τομέα',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα για τον οποίο θέλετε να ρυθμίσετε το πρόγραμμα διαχείρισης αρχείων καταγραφής και να δείτε τα αρχεία καταγραφής του.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Διαχείριση πιστοποιητικών SSL/TLS για τον τομέα',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα τα πιστοποιητικά SSL/TLS του οποίου θέλετε να διαχειριστείτε.',

    'ui__client/to-reseller_multi__wizard-title' => 'Μετατροπή λογαριασμών πελατών σε λογαριασμούς μεταπωλητών',
    'ui__client/to-reseller_multi__wizard__1_multi' => 'Πρέπει να επιλέξετε τους λογαριασμούς πελατών που θέλετε να μετατρέψετε σε λογαριασμούς μεταπωλητών.',

    'ui__reseller/to-client_multi__wizard-title' => 'Μετατροπή λογαριασμών μεταπωλητών σε λογαριασμούς πελατών',
    'ui__reseller/to-client_multi__wizard__1_multi' => 'Πρέπει να επιλέξετε τους λογαριασμούς μεταπωλητών που θέλετε να μετατρέψετε σε λογαριασμούς πελατών.',

    'ui__client/domain/properties_new__wizard__2/hosting/setup' => 'Διαχείριση ρυθμίσεων φιλοξενίας για τον τομέα.',







    'ui__client/domain/disable_multi__wizard-title' => 'Αναστολή τομέων',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Επιλέξτε τους τομείς που θέλετε να αναστείλετε.',

    'ui__client/domain/enable_multi__wizard-title' => 'Ενεργοποίηση τομέων',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Επιλέξτε τους τομείς που θέλετε να ενεργοποιήσετε.',

    'ui__client/domain_unknown__wizard-title' => 'Προβολή τομέων',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Επιλέξτε έναν πελάτη τους τομείς του οποίου θέλετε να δείτε.',

    'ui__client/domain/to-client_multi__wizard-title' => 'Μετατροπή λογαριασμών διαχειριστή τομέα σε λογαριασμούς πελατών',
    'ui__client/domain/to-client_multi__wizard__2_multi' => 'Επιλέξτε τους τομείς τους λογαριασμούς διαχειριστή των οποίων θέλετε να μετατρέψετε σε λογαριασμούς πελατών',

    'ui__client/domain/register_unknown__wizard-title' => 'Καταχώρηση τομέων',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα που θέλετε να καταχωρήσετε.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Χρήση εργαλείων από το MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα που θέλετε να διαχειριστείτε με τα εργαλεία από το MyPlesk.com.',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => 'Πρόσβαση στο διακομιστή μέσω SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα στον εικονικό κεντρικό υπολογιστή του οποίου θέλετε να συνδεθείτε μέσω SSH.', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Χρήστες διεύθυνσης IP',
    'ui__server/ip-address/client_unknown__title' => 'Χρήστες διεύθυνσης IP',
    'ui__server/ip-address/client_unknown__description' => 'Χρήστες της διεύθυνσης IP %1',

    'disabled_by_admin' => 'Έχει απενεργοποιηθεί από το διαχειριστή του διακομιστή',






    'ui__client/domain/chowner_multi__short-title' => 'Αλλαγή κατοχής',
    'ui__client/domain/chowner_multi__title' => 'Αλλαγή κατοχής συνδρομής',
    'ui__client/domain/chowner_multi__description' => 'Αλλαγή κατοχής συνδρομής.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Επιλέξτε τους τομείς στους οποίους θέλετε να αλλάξετε την κατοχή και κάντε κλικ στο Επόμενο >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Αλλαγή κατοχής',
    'ui__client/domain/chowner_unknown__title' => 'Αλλαγή κατοχής συνδρομής',
    'ui__client/domain/chowner_unknown__description' => 'Αλλαγή κατοχής συνδρομής.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Αλλαγή κατοχής συνδρομής',


    'ui__client/chowner__short-title' => 'Αλλαγή κατόχου πελάτη',
    'ui__client/chowner__title' => 'Αλλαγή κατόχου λογαριασμού πελάτη',
    'ui__client/chowner__description' => 'Ορισμός νέου κατόχου γι\' αυτόν το λογαριασμό πελάτη',


    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Δεν υπάρχουν προσαρμοσμένα κουμπιά.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Δεν υπάρχουν προσαρμοσμένα κουμπιά στο περιβάλλον εργασίας του μεταπωλητή %1.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Κατάργηση του κουμπιού %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Κατάργηση',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Κατάργηση του κουμπιού %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Κατάργηση προσαρμοσμένων κουμπιών από το περιβάλλον εργασίας μεταπωλητή',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Κατάργηση',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Κατάργηση προσαρμοσμένων κουμπιών',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Κατάργηση κουμπιών',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Επιλέξτε ένα μεταπωλητή τα προσαρμοσμένα κουμπιά του οποίου θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Επιλέξτε τα προσαρμοσμένα κουμπιά που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Επιβεβαιώστε την κατάργηση των κουμπιών επιλέγοντας το πλαίσιο ελέγχου σε αυτήν την οθόνη και, στη συνέχεια, κάντε κλικ στο Τέλος.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Κατάργηση προσαρμοσμένου κουμπιού από το περιβάλλον εργασίας μεταπωλητή.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Κατάργηση',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Κατάργηση ενός προσαρμοσμένου κουμπιού',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Κατάργηση προσαρμοσμένου κουμπιού',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Επιλέξτε ένα μεταπωλητή το προσαρμοσμένο κουμπί του οποίου θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Επιλέξτε το προσαρμοσμένο κουμπί που θέλετε να καταργήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Επιβεβαιώστε την κατάργηση του προσαρμοσμένου κουμπιού επιλέγοντας το πλαίσιο ελέγχου σε αυτήν την οθόνη και, στη συνέχεια, κάντε κλικ στο Τέλος.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Επεξεργασία των ιδιοτήτων του προσαρμοσμένου κουμπιού σε επίπεδο μεταπωλητή %1.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Ρυθμίσεις',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Τροποποίηση του προσαρμοσμένου κουμπιού %1 του μεταπωλητή',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Προσθήκη προσαρμοσμένου κουμπιού',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Επιλέξτε έναν μεταπωλητή, στο περιβάλλον εργασίας του οποίου θέλετε να δημιουργήσετε ένα προσαρμοσμένο κουμπί και κάντε κλικ στο Επόμενο >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Για να δημιουργηθεί το κουμπί, κάντε κλικ στο Τέλος.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Αλλαγή των ιδιοτήτων ενός κουμπιού στο περιβάλλον εργασίας μεταπωλητή.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Ιδιότητες',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Αλλαγή των ιδιοτήτων ενός κουμπιού στο περιβάλλον εργασίας μεταπωλητή',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Αλλαγή ιδιοτήτων προσαρμοσμένου κουμπιού',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Επιλέξτε ένα μεταπωλητή το προσαρμοσμένο κουμπί του οποίου θέλετε να τροποποιήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Επιλέξτε το προσαρμοσμένο κουμπί που θέλετε να τροποποιήσετε και κάντε κλικ στο Επόμενο >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Όταν ολοκληρώσετε την επεξεργασία των ιδιοτήτων του κουμπιού, κάντε κλικ στο Τέλος για να εφαρμόσετε τις αλλαγές και να κλείσετε τον οδηγό.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Να καταστεί το κουμπί %1 μη διαθέσιμο στους πελάτες σας.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Να καταστεί μη διαθέσιμο στους πελάτες σας',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Να καταστεί το κουμπί %1 μη διαθέσιμο στους πελάτες σας',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Να καταστεί το κουμπί %1 ορατό στους πελάτες του μεταπωλητή.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Να καταστεί διαθέσιμο στους πελάτες σας',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Να καταστεί το κουμπί %1 ορατό στους πελάτες του μεταπωλητή',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Καταστήστε ένα προσαρμοσμένο κουμπί διαθέσιμο/μη διαθέσιμο στους πελάτες σας.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Διαθέσιμο/μη διαθέσιμο στους πελάτες σας',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Καταστήστε ένα προσαρμοσμένο κουμπί διαθέσιμο ή μη διαθέσιμο στους πελάτες σας',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Καταστήστε ένα προσαρμοσμένο κουμπί διαθέσιμο/μη διαθέσιμο στους πελάτες σας.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Επιλέξτε ένα μεταπωλητή το προσαρμοσμένο κουμπί του οποίου θέλετε να καταστήσετε διαθέσιμο ή μη διαθέσιμο στους πελάτες του μεταπωλητή και κάντε κλικ στο Επόμενο >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Επιλέξτε ένα προσαρμοσμένο κουμπί που θέλετε να καταστήσετε διαθέσιμο ή μη διαθέσιμο στους πελάτες σας και κάντε κλικ στο Επόμενο >>.',




    'ui__server/ip-addresses__short-title' => 'Διευθύνσεις IP',
    'ui__server/ip-addresses__title' => 'Διαχείριση διευθύνσεων IP',
    'ui__server/ip-addresses__description' => 'Προσθήκη, κατάργηση και εκχώρηση διευθύνσεων IP.',

    'ip_ctrl__allow_ftps' => 'Να επιτρέπεται το FTP μέσω SSL/TLS',
    '__ftps' => 'FTP μέσω SSL/TLS',
    '__not_allowed' => 'Δεν επιτρέπεται',



    'ui__client/ipaddress/domain_unknown__short-title' => 'Τομείς που χρησιμοποιούν το %2',
    'ui__client/ipaddress/domain_unknown__title' => 'Τομείς που χρησιμοποιούν %1 διεύθυνση IP %2',
    'ui__client/ipaddress/domain_unknown__description' => 'Προβολή της λίστας με τους τομείς που χρησιμοποιούν %1 διεύθυνση IP %2',

    'ui__client/ipaddress__none-available' => 'Δεν υπάρχουν διαθέσιμες διευθύνσεις IP',
    'ui__client/ipaddress__none-available__1' => 'Δεν υπάρχουν διαθέσιμες διευθύνσεις IP',



    'ui__client/domain/report_unknown__wizard-title' => 'Προβολή αναφοράς τομέα',
    'ui__client/domain/report_unknown__wizard__2_unknown' => 'Επιλέξτε τον τομέα την αναφορά του οποίου θέλετε να δείτε.',


    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Επιλέξτε το νέο κάτοχο του τομέα.',

    'ui__client/chowner__wizard__2_select' => 'Επιλέξτε νέο κάτοχο για το λογαριασμό πελάτη.',

    '__ip_addr_state_unknown' => "Η διεύθυνση IP δεν λειτουργεί επειδή το σύστημα εξακολουθεί να επεξεργάζεται την αίτησή σας. Περιμένετε ένα λεπτό.",


    'resellers_list__accounts' => 'Χρήστες',

    'ip_addr__repair_is_not_allowed' => 'Η διεύθυνση IP δεν μπορεί να επιδιορθωθεί στο περιβάλλον του Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'Ο μεταπωλητής %1 δεν έχει πελάτες.',

    'ippoolManager__ip_used_by_nohost_domain' => "Η διεύθυνση IP %%ip%% δεν μπορεί να καταργηθεί επειδή χρησιμοποιείται από έναν ή περισσότερους τομείς χωρίς φιλοξενία.",
    'ippoolManager__ip_used_for_mail_service' => "Δεν είναι δυνατή η κατάργηση της διεύθυνσης IP %%ip%% επειδή χρησιμοποιείται από έναν ή περισσότερους τομείς για τη διεύθυνση IP της υπηρεσίας αλληλογραφίας τους.",
    'ippoolManager__ip_used_for_send_emails' => "Δεν είναι δυνατή η κατάργηση της διεύθυνσης IP %%ip%% επειδή χρησιμοποιείται για την αποστολή email από συγκεκριμένη IP (βλ. Ρυθμίσεις διακομιστή αλληλογραφίας).",
    'ippoolManager__ip_used_in_dns_zone' => 'Η διεύθυνση IP %%ip%% δεν μπορεί να καταργηθεί επειδή χρησιμοποιείται από τη ζώνη DNS ενός ή περισσότερων τομέων.',
    'ip_ctrl__cannot_manage_on_vz' => 'Αυτή η εγκατάσταση του Plesk λειτουργεί εντός του Virtuozzo containers. Νέες διευθύνσεις IP μπορούν να προστεθούν μόνο από το διαχειριστή του κόμβου Virtuozzo containers.',

    'client_template__limits_auto_adjusted' => 'Τα όρια από το πρότυπο πελάτη προσαρμόστηκαν αυτόματα.',

    '__entries' => 'Εγγραφές',

    '__path_is_not_set' => 'Η διαδρομή δεν καθορίστηκε.  Καθορίστε μια έγκυρη διαδρομή.',

    // license keys
    'key_new_plesk_key_is_uploaded' => 'Το νέο κλειδί του Plesk απεστάλη.',
    'key_new_additional_key_is_uploaded' => 'Το νέο πρόσθετο κλειδί απεστάλη.',

    'defaultcomponents__imap_required' => '(Ο τρέχων διακομιστής αλληλογραφίας δεν υποστηρίζει IMAP)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => 'Η προστασία Hotlink είναι ενεργοποιημένη για τον τομέα.',
    'i_hotlinkprotection_off' => 'Η προστασία Hotlink είναι απενεργοποιημένη για τον τομέα.',

    '__commercial_web_stats_not_installed' => 'Το Plesk υποστηρίζει μόνο εμπορικό λογισμικό στατιστικών στοιχείων web για τον υπολογισμό των στατιστικών υποτομέων. Αυτήν τη στιγμή δεν υπάρχει τέτοιο λογισμικό εγκατεστημένο στο σύστημα.',

    'mail__spamassassin_personal_settings_disallowed' => 'Η δυνατότητα εφαρμογής προσωπικών ρυθμίσεων φιλτραρίσματος ανεπιθύμητης αλληλογραφίας είναι απενεργοποιημένη από το διαχειριστή του διακομιστή.  Οι παρακάτω ρυθμίσεις φιλτραρίσματος ανεπιθύμητης αλληλογραφίας δεν θα εφαρμοστούν',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => 'Δεν είναι δυνατή η δημιουργία του αντικειμένου %1: %2',
    'cu_dom_pref__invalid_expiration_date' => 'Μη έγκυρη ημερομηνία λήξης: %1',
    'cu_cl_pref__illegal_date_val' => 'Καθορίσατε μη έγκυρη τιμή ημερομηνίας ("%1")',
    'cu_cl_pref__illegal_date_greater_less' => 'Εισαγάγετε το έτος από "%1" έως "%2"',
    'cu_initconf__unable_set_ip_alias_type' => 'Δεν είναι δυνατός ο ορισμός του τύπου ψευδωνύμου IP: %1',
    'cu_mlist__unable_change_status' => "Δεν είναι δυνατή η αλλαγή της κατάστασης της λίστας αλληλογραφίας: %1",
    'cu_initconf__unable_change_passwd' => "Δεν είναι δυνατή η αλλαγή του κωδικού πρόσβασης διαχειριστή: %1",
    'cu_serverpref__option_description_include_remote_databases' => 'Οι απομακρυσμένες βάσεις δεδομένων MySQL περιλαμβάνονται στον υπολογισμό της χρήσης χώρου στον δίσκο.',
    'cu_siteapp_item__add_to_pool_success' => 'Η εφαρμογή web προστέθηκε στο χώρο συγκέντρωσης εφαρμογών web.',
    'cu_siteapp_item__remove_from_pool_success' => 'Η εφαρμογή web καταργήθηκε από το χώρο συγκέντρωσης εφαρμογών web.',
    'cu_traffic_command_description_add_user' => 'Καταχωρεί μια συγκεκριμένη ποσότητα κίνησης σαν να χρησιμοποιείται ήδη από τον πελάτη/μεταπωλητή',
    'cu_traffic_command_description_sub_user' => 'Αφαιρεί μια συγκεκριμένη ποσότητα κίνησης από την ποσότητα που έχει καταχωρηθεί για τον πελάτη/μεταπωλητή',
    'cu_traffic_command_description_add_batch_user' => 'Καταχωρεί μια συγκεκριμένη ποσότητα κίνησης σαν να χρησιμοποιείται ήδη από τον πελάτη/μεταπωλητή (λειτουργία δέσμης)',
    'cu_traffic_command_description_del_user' => 'Επαναφέρει την ποσότητα της κίνησης που έχει καταχωρηθεί γι\' αυτόν τον πελάτη/μεταπωλητή στο μηδέν',
    'cu_resellerpref__option_lock_screen' => 'Αποτρέπει τη δυνατότητα των χρηστών να χρησιμοποιούν το Plesk μέχρι να φορτωθούν πλήρως οι οθόνες του περιβάλλοντος εργασίας',
];