<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>症状</h4><ul><li><p><strong>［ドメイン］</strong> &gt; <strong>example.com</strong> &gt; <strong>［PHP 設定］</strong>でPHP ハンドラが「<strong>Apache で処理される FPM アプリケーション</strong>」または「<strong>nginx で処理される FPM アプリケーション</strong>」に設定されたウェブサイトで、以下のいずれかの問題が発生しています。</p><ul><li><p>読み込みが遅い</p></li><li><p>ウェブブラウザに 50x エラーが表示され利用できない（永久的または一時的）：</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p> PHP-FPM エラーログファイルに以下のメッセージが表示されます<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code>（ここで <em>XX</em> はウェブサイトで使用されている PHP のバージョン）：</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>上記のメッセージは通常、こちらのエラーとともに表示されます： </p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>サーバで nginx が有効になっている場合、以下のいずれかのエラーメッセージがドメインのエラーログファイル<code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code> に表示される場合があります。</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' ウェブサイトが <p>PHP-FPM <code>pm.max_children</code> に達しました。</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'pm.max_children の上限を増やす',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>影響を受けたドメインに対して <code>pm.max_children</code> の上限値を増やします。</p><ol><li><p>Plesk に <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a> 経由で接続します。</p></li><li><p>以下のコマンドを使用して、影響を受けたドメインを探します。</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>注：</strong> 左側の数字は、このウェブサイトが<code>pm.max_children</code> の上限に達した回数を示します。</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Plesk にログインします</a>。</p></li><li><p><strong>［ドメイン］</strong> &gt; <strong>example.com</strong> &gt; <strong>［PHP 設定］</strong> &gt; <strong>［PHP-FPM 設定］</strong>の順に選択します。</p></li><li><p>このドメインに対して <code>pm.max_children</code> の値を増やし、変更を適用します。手順 2 で挙げられたすべてのドメインに対してこの値を増やします。</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx が Plesk サーバで起動/リロードに失敗する：Too many open files</p><h4>症状</h4><ul><li><p> nginx サービスが起動/リロードに失敗し、<code>/var/log/nginx/error.log</code> ファイルに以下のエラーが表示されます。</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>一部またはすべてのウェブサイトが利用できません。</p></li><li><p><strong>［ツールと設定］&gt; ［診断して修復］</strong>に警告が表示されます。</p><pre style="white-space: pre-wrap;">nginx 値のチェックにより、サーバで N 個のドメインが見つかりました。nginx のデフォルトのファイルオープン上限の問題が考えられます。</pre></li><li><p>NodeJS および Ruby ウェブアプリケーションで、ドメインや契約の作成、Apache または Nginx での変更などの Plesk 関連タスクを実行すると、502 Bad Gateway エラーが表示されます。</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p> <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">ドメイン用に新しい証明書をインストール</a>した後で、<strong>［ドメイン］&gt; example.com &gt;［ホスティング設定］</strong>で正しい証明書が選択されているにも関わらず、古い証明書が引き続きウェブブラウザに表示されます。</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx の仮想ホストは、物理ホスティングの各仮想ホストに対して 4 つのログファイルを開きます。</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>この結果、ドメインが大量にあることにより（通常は 100 以上）、nginx サーバでファイルオープン数の上限を超過します。</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'ファイルオープンの上限を増やす',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>警告：</strong> <code>websrv_ulimits</code> ユーティリティを <strong>--no-restart</strong> オプションなしで実行すると、すべてのドメインに対してウェブ構成ファイルの再構築が開始され、ホストされているウェブサイトが多い場合はダウンタイムが長期化する可能性があります。<br><br>コマンドは、メンテナンス期間中に実行してください。</div><p>ファイルオープン数の上限は、<strong>Plesk 上のドメイン数 * 16</strong> 以上に設定することをお勧めします。以下の例では、上限を4096 に設定する方法を説明します。</p><ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a> 経由でサーバに接続します。</p></li><li><p>Apache と Nginx の両方に対し、ファイルオープン数の上限を 4096 に設定します。</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p><strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">［Plesk］</a> &gt;</strong> <strong>［ツールと設定］&gt; ［サービス管理］</strong>で Apache および nginx サービスを再起動し、変更を適用します。</p></li><li><p>ウェブサービスの再起動後に、\'Max open files limit\' が適切に適用されていることを確認します。</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>上記の方法で解決しなかった場合は、<code>ulimit</code> ユーティリティを使用して上限を設定します。</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP リクエストボディ上限 "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP リクエストボディ上限 "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP セッション "503 Internal Server Error" or "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];