<?php
try {
    $allQueued = $signup->getQueuedSignups();
} catch (Horde_Exception $e) {
    $allQueued = $e;
}
?>
<h1 class="header">
 <?php echo _("Pending Signups:") ?>
</h1>

<?php if ($allQueued instanceof Exception): ?>
 <div class="text"><em><?php echo htmlspecialchars($allQueued->getMessage()) ?></em></div>
<?php elseif (!count($allQueued)): ?>
 <div class="text"><em><?php echo _("No pending signups.") ?></em></div>
<?php else: ?>
<br />
<table class="horde-table" id="signup-pending">
<thead>
 <tr>
  <th>&nbsp;</th>
  <th>&nbsp;</th>
  <th class="horde-split-left"><?php echo _("Username") ?></th>
  <th class="horde-split-left"><?php echo _("Date Received") ?></th>
 </tr>
</thead>
<tbody>
<?php foreach ($allQueued as $signup): $data = $signup->getData(); ?>
 <tr>
  <td>
   <form method="post" action="<?php echo Horde::selfUrl() ?>">
    <input type="hidden" name="user_name" value="<?php echo $signup->getName() ?>" />
    <input type="hidden" name="form" value="approve_f" />
    <input type="submit" class="horde-default" value="<?php echo _("Approve") ?>" />
   </form>
  </td>
  <td>
   <form method="post" action="<?php echo Horde::selfUrl() ?>">
    <input type="hidden" name="user_name" value="<?php echo $signup->getName() ?>" />
    <input type="hidden" name="form" value="removequeued_f" />
    <input type="submit" class="horde-delete" value="<?php echo _("Remove") ?>" />
   </form>
  </td>
  <td><?php echo htmlspecialchars($signup->getName()) ?></td>
  <td><?php echo date('Y-m-d H:i:s', $data['dateReceived']) ?></td>
 </tr>
<?php endforeach; ?>
</tbody>
</table>
<br />
<?php endif; ?>
