<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx ‏"‎502 Bad Gateway: ממעלה הזרם נשלחה כותרת גדולה מדי בעת קריאת כותרת התגובה"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'יהיה מוכן בקרוב.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache ‏"שגיאת שרת פנימית 500: האפשרות FollowSymLinks אינה מותרת כאן"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'יהיה מוכן בקרוב.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "השרת הגיע להגדרת max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>תסמינים</h4><ul><li><p>אתרים שמטפל ה-PHP שלהם מוגדר כ<strong>יישום FPM שמקבל שירות מ-Apache</strong> או כ<strong>יישום FPM שמקבל שירות מ-nginx</strong> ב<strong>דומיינים</strong> &gt; <strong>example.com</strong> &gt; <strong>הגדרות PHP</strong> חווים אחת מהבעיות הבאות:</p><ul><li><p>נטענים לאט</p></li><li><p>לא נגישים (לצמיתות או לפרקים) עם שגיאת 50x בדפדפן אינטרנט:</p><pre>‎502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>‎‎504 Gateway Time-out</pre></li></ul></li><li><p>ההודעה הבאה מופיעה בקובץ יומן השגיאות PHP-FPM בשם <code>‎/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (כאשר <em>XX</em> זו גרסת PHP המשמשת את האתרים):</p><pre>אזהרה: [pool example.com] השרת הגיע למגבלת max_children (*), שקול להעלות אותה</pre><ul><li><p>ההודעה מעל מלווה בדרך כלל בשגיאה זו:</p><pre>unable to read what child say: Bad file descriptor (9)‎</pre></li></ul></li><li><p>אם nginx מופעל בשרת, אחת מהודעות השגיאה הבאות עשויה להופיע בקובץ יומן השגיאות של הדומיין בשם <code>‎/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>האתר(ים) הגיע(ו) למגבלת <code>pm.max_children</code> של PHP-FPM.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'הגדלת ההגבלה של pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>הגדל את מגבלת <code>pm.max_children</code> עבור הדומיינים המושפעים:</p><ol><li><p>התחבר לשרת Plesk באמצעות <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>מצא את הדומיינים המושפעים באמצעות הפקודה הבאה:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>הערה:</strong> המספר בצד מציין את מספר הפעמים שבהן האתר הגיע למגבלה של <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">היכנס אל Plesk</a>.</p></li><li><p>עבור אל <strong>דומיינים</strong> &gt; <strong>example.com</strong> &gt; <strong>הגדרות PHP</strong> &gt; <strong>הגדרות PHP-FPM</strong>.</p></li><li><p>הגדל את הערך <code>pm.max_children</code> עבור הדומיין והחל את השינויים. הגדל את הערך הזה עבור כל הדומיינים שמופיעים בשלב 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "יותר מדי קבצים פתוחים"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx fails to start/reload on a Plesk server: Too many open files</p><h4>תסמינים</h4><ul><li><p>לא ניתן להפעיל או לטעון מחדש את שירות nginx ומוצגת הודעת השגיאה הבאה בקובץ <code>‎/var/log/nginx/error.log</code>‏:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)‎</pre></li><li><p>חלק מהאתרים או כולם לא נגישים</p></li><li><p>האזהרה מוצגת בנתיב <strong>כלים והגדרות &gt; אבחון ותיקון</strong>:</p><pre style="white-space: pre-wrap;">בבדיקת ערך ULIMIT של nginx נמצאו N דומיינים בשרת. ייתכן שקיימת בעיה עם מגבלת ברירת המחדל של nginx עבור קבצים פתוחים</pre></li><li><p>יישומי האינטרנט NodeJS ו-Ruby מציגים שגיאת ‎502 Bad Gateway בעת ביצוע משימות Plesk מסוימות כגון יצירת דומיינים, מינויים, שינויים ב-Apache או ב-Nginx וכו\':</p><pre style="white-space: pre-wrap;">שגיאת שרת<br>‎502 Bad Gateway <br>שרת האינטרנט קיבל תגובה לא חוקית כשפעל כשער או כשרת Proxy.</pre></li><li><p>לאחר <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">התקנת אישור חדש עבור הדומיין</a>, האישור הישן עדיין מוצג בדפדפן אינטרנט, אך האישור הנכון נבחר בדף <strong>דומיינים &gt; example.com &gt; הגדרות אירוח</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>המארח הווירטואלי של Nginx פותח 4 קובצי יומן עבור כל מארח וירטואלי בעל אירוח פיזי:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>כתוצאה מכך, שרת nginx חורג מהמספר המרבי של קבצים פתוחים עקב מספר הדומיינים הרב (בדרך כלל למעלה מ-100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'הגדלת ההגבלה של קבצים פתוחים',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>אזהרה:</strong> הפעלת כלי העזר <code>websrv_ulimits</code> ללא האפשרות <strong>‎--no-restart</strong> מפעילה בנייה מחדש של קובצי תצורת אינטרנט עבור כל הדומיינים ועלולה לגרום לזמן השבתה רב במקרה שיש אתרים מתארחים רבים.<br><br>הפעל את הפקודה במשבצת זמן תחזוקה.</div><p>מומלץ להגדיר את ערך הגבלת קבצים פתוחים למספר גדול מ<strong>מספר הדומיינים ב-Plesk * לפחות 16</strong>. בדוגמה הבאה מתוארות הפעולות להגדרת ההגבלה ל-4096:</p><ol><li><p>התחבר לשרת באמצעות <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>הגדר את הגבלת הקבצים הפתוחים ל-4096 הן עבור Apache והן עבור Nginx‏:</p><pre>‎# /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>הפעל מחדש את השירותים Apache ו-nginx ב-<strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>כלים והגדרות &gt; ניהול שירותים</strong> כדי להחיל את השינויים.</p></li><li><p>ודא ש\'הגבלת מקס\' קבצים פתוחים\' הוחלה כהלכה, לאחר ההפעלה מחדש של שירותי האינטרנט:</p><pre>‎# grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>מקס\' קבצים פתוחים 4096 קובץ 4096</pre></li><li><p>אם הפתרון מעל לא עוזר, הגדר את ההגבלה באמצעות כלי העזר <code>ulimit</code>‏:</p><pre>‎# ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "גוף התגובה גדול מדי"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'יהיה מוכן בקרוב.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "הגישה נדחתה עם קוד 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>תסמינים</h4><ul><li><p>ModSecurity מותקן ומופעל בנתיב <strong>כלים והגדרות > חומת אש של אפליקציית אינטרנט‬ (ModSecurity) > מצב חומת אש של אפליקציית אינטרנט > פעיל</strong>.</p></li><li>הטעינה של אתר שמתארח ב-Plesk נכשלה. לא ניתן לבצע פעולות באתר כמו ניהול WordPress, גישה לדואר אינטרנט או גישה לקובץ <code>robots.txt</code>. הדפדפן עשוי להציג אחת מהודעות השגיאה הבאות: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>‎403 Forbidden</pre><hr><pre>שגיאת שרת פנימית 500: </pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>הודעת שגיאה של ModSecurity כמו זו המוצגת מתחת מופיעה בקובץ יומן הרישום <code>‎/var/log/modsec_audit.log</code> או בדף "יומני רישום" ב-Plesk (<strong>דומיינים</strong> &gt; <strong>example.com</strong> &gt; <strong>יומני רישום</strong>): <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]‎</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p> חומת אש של אפליקציית אינטרנט עם ModSecurity מופעלת עם קבוצת כללים מאוד קפדנית, כגון OWASP‏, Comodo או קבוצת כללים מותאמת אישית כגון Imunify360. קבוצות כללים קפדניות עלולות לחסום מספר פעולות באתר.</p><p><Strong>הערה:</strong> שגיאת ModSecurity עלולה להצביע על תקיפה של השרת. השתמש בפתרונות הבאים רק אם אתה בטוח ש-ModSecurity חוסם שימוש חוקי באתר.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'השבת את קבוצת הכללים של ModSecurity לפי מזהה או תג',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>מצא את המזהה של הכלל שחוסם את השימוש הלגיטימי של האתר שלך.
אתה יכול למצוא את המזהים בהודעות שגיאה בקובץ היומן<code>/var/log/modsec_audit.log</code>. המזהה הוא מספר שלם בין סימני ציטוט עם הקידומת <code>id</code> בסוגריים מרובעים, למשל, <strong>[id "210831"]</strong></p></li><li><a href="https://support.plesk.com/hc/en-us/articles/115002531753" target="_blank" rel="noopener">כבה את מערכי הכללים הספציפיים ב-Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'עבור לקבוצת כללים אחרת של ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>עבור לקבוצת כללים פחות קפדנית של ModSecurity, למשל, "Atomic ModSecurity Ruleset". לצורך כך, עבור אל <strong>כלים והגדרות</strong> > <strong>‫חומת אש של אפליקציית אינטרנט‬ (ModSecurity)</strong> > <strong>הגדרות</strong>, בחר <strong>Atomic Standard</strong> ולאחר מכן לחץ על <strong>אישור</strong> כדי להחיל את השינויים.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "שגיאת שרת פנימית 500: גודל הזיכרון המותר של XXX נוצל"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>תסמינים</h4><ul><li><p>אתר שמתארח ב-Plesk אינו נגיש:</p><pre>שגיאת שרת פנימית 500</pre></li><li><p>הודעת השגיאה הבאה מוצגת ביומן הרישום של האתר:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on "line 3</pre></li></ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>לא הוקצה לאתר מספיק זיכרון לעיבוד.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'הגדלת ה-memory_limit של האתר',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000304194" target="_blank" rel="noopener">קרא את המאמר במרכז המידע ובצע את ההוראות</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "ההגבלה open_basedir בתוקף"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>תסמינים</h4><ul><li><p>אתר מסוים אינו נגיש עקב אחת מהודעות השגיאה הבאות בדפדפן:</p><pre>‎404 file not found</pre><hr><pre>‎500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)‎</pre></li><li><p>הודעת השגיאה הבאה מופיעה בדף "יומני רישום" של הדומיין (<strong>דומיינים</strong> > <strong>example.com</strong> > <strong>יומני רישום</strong>):</p><pre>‎<...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...>‎</pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'קובץ ה-Script של PHP מנסה לגשת לספריה שהגישה אליה אסורה. הגבלה זו מוגדרת על ידי ההוראה <code>open_basedir</code> של PHP עבור כל דומיין בנפרד. כברירת מחדל, ההוראה <code>open_basedir</code> מתירה גישה לספריית <code>tmp</code> ולספריות הבסיס למסמכים של הדומיין, כמו גם אל נתיב ההפעלות של המערכת המוגדר כברירת מחדל.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'הוסף את הנתיב הנוסף להוראה open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000278993" target="_blank" rel="noopener">קרא את המאמר במרכז המידע ובצע את ההוראות</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'השבתת ההוראה open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>עבור לדף <strong>דומיינים &gt example.com &gt הגדרות PHP</strong> והגדר את ההוראה <code>open_basedir</code> ל"ללא".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess ‏"‎403 Forbidden AH01797: תצורת השרת דחתה את הלקוח"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>תסמינים</h4><ul><li><p>האתר מציג הודעת שגיאה דומה להודעה הבאה:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The <code>/var/www/vhosts/system/example.com/logs/error_log</code> log file contains errors like the following one:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>תצורת Apache מותאמת אישית אינה מאפשרת גישה לאתר.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'בדוק את תצורת השרת ואת קבצי ‎.htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">קרא את המאמר במרכז המידע ובצע את ההוראות</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "לא ניתן לגשת לספריית אתר ב-Plesk‏: ‎403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>תסמינים</h4><ul><li><p>לא ניתן לגשת למיקום מסוים באתר, למשל, <code>http://example.com/some_folder</code>. מתרחשת השגיאה הבאה:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>השגיאה הבאה מופיעה בקובץ <code>‎/var/www/vhosts/example.com/logs/error_log<code/>‏:</p><pre>‎[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>הספריה המבוקשת אינה מכילה קבצי אינדקס או שדפדוף בספריות אינו מופעל.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'הוספת קובץ אינדקס לספריה',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">קרא את המאמר במרכז המידע ובצע את ההוראות</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'אפשר דפדוף בספריות',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">קרא את המאמר במרכז המידע ובצע את ההוראות</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "לא ניתן לגשת לספריית אתר ב-Plesk‏: ‎403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>תסמינים</h4><ul><li><p>לא ניתן לגשת למיקום מסוים באתר, למשל, <code>http://example.com/some_folder</code>. מתרחשת השגיאה הבאה:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>השגיאה הבאה מופיעה ב-<code>‎/var/www/vhosts/example.com/logs/error_log file</code>‏:</p><pre>‎[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>הספריה המבוקשת אינה מכילה קבצי אינדקס או שדפדוף בספריות אינו מופעל.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'הוספת קובץ אינדקס לספריה',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">קרא את המאמר במרכז המידע ובצע את ההוראות</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'אפשר דפדוף בספריות',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">קרא את המאמר במרכז המידע ובצע את ההוראות</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "השרת הגיע להגדרת MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'יהיה מוכן בקרוב.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'מגבלת גוף בקשת PHP "הלקוח ניסה לשלוח גוף בקשה גדול מדי"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'יהיה מוכן בקרוב.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'מגבלת גוף בקשת PHP "הלקוח ניסה לשלוח גוף בקשה גדול מדי"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'יהיה מוכן בקרוב.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'הפעלות PHP ‏"שגיאת שרת פנימית 503" או "לא ניתן היה לקרוא את נתוני ההפעלה"',
    'problem-detail.php-failed-to-read-session-data.description' => 'יהיה מוכן בקרוב.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "‏‎403 Forbidden‏: pcfg_openfile: לא ניתן לבדוק את קובץ htaccess, ודא שהוא קריא"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>תסמינים</h4><ul><li><p>אתר שמתארח ב-Plesk אינו פועל:</p><pre>אין לך הרשאה לגשת אל / בשרת זה. <br> בנוסף, המערכת נתקלה בשגיאת ‎403 Forbidden במהלך ניסיון להשתמש ב-ErrorDocument לטיפול בבקשה.</pre><p>במקום השגיאה שצוינה מעל, ייתכן גם שהדף יהיה ריק.</p></li><li><p>יומן השגיאות של הדומיין בנתיב <strong>דומיינים &gt example.com &gt יומני רישום</strong> מכיל את השגיאה הבאה:</p><pre>‎(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'הרשאות שגויות עבור הקבצים או התיקיות של הדומיין.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'תיקון ההרשאות עבור תוכן האתר',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/213939685" target="_blank" rel="noopener">קרא את המאמר במרכז המידע ובצע את ההוראות</a>.</p></li></ol>',
];