<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'cgroups.size' => 'Valore non valido: "%value%". Il valore deve essere uguale o maggiore di %unitMin%, minore o uguale a %unitMax% e non può essere 0.',
    'cgroups.unlimited' => 'Illimitato',
    'cgroups.period' => 'Valore non valido: "%value%". Il valore deve essere pari a 5 minuti, un\'ora o un giorno e specificato in secondi (300, 3.600 o 86.400).',

    'file.fileIsImageFalseType' => 'Il file che cerchi di caricare non è un\'immagine.',
    'file.fileUploadErrorIniSize' => 'Il file che state cercando di caricare supera la dimensione ini definita.',
    'file.fileUploadErrorFormSize' => 'Il file che state cercando di caricare supera la dimensione del formulario definito.',
    'file.fileUploadErrorPartial' => 'Il file è stato caricato solo parzialmente.',
    'file.fileUploadErrorNoFile' => 'Il file non è stato caricato.',
    'file.fileUploadErrorNoTmpDir' => 'Nessuna cartella termporanea trovata per il file che state cercando di caricare.',
    'file.fileUploadErrorCantWrite' => 'Impossibile scrivere il file che state cercando di caricare.',
    'file.fileUploadErrorExtension' => 'L\'estensione ritorna un errore durante il caricamento del file.',
    'file.fileUploadErrorAttack' => 'Il file è stato caricato illegalmente; potrebbe trattarsi di un tentativo di intrusione.',
    'file.fileUploadErrorFileNotFound' => 'Il file che state cercando di caricare non è stato trovato.',
    'file.fileUploadErrorUnknown' => 'Errore sconosciuto durante il caricamento del file.',
    'file.fileExtensionFalse' => 'Il file che state cercando di caricare presenta un\'estensione non consentita.',
    'file.fileExistsDoesNotExist' => 'La directory o file specificato è inesistente.',

    'hostname.hostnameIpAddressNotAllowed' => "'%value%' sembra essere un indirizzo IP, ma gli indirizzi IP non sono consentiti.",
    'hostname.hostnameUnknownTld' => "'%value%' sembra essere un hostname DNS ma non può corrispondere a TLD secondo la lista conosciuta.",
    'hostname.hostnameDashCharacter' => "'%value%' sembra essere un hostname DNS ma contiene un trattino (-) in una posizione non valida.",
    'hostname.hostnameInvalidHostnameSchema' => "'%value%' sembra essere un hostname DNS ma non può corrispondere allo schema dell'hostname per TLD '%tld%'",
    'hostname.hostnameUndecipherableTld' => "'%value%' sembra essere un hostname DNS ma non può estrarre la parte TLD.",
    'hostname.hostnameInvalidHostname' => "'%value%' non corrisponde alla struttura prevista per un hostname DNS.",
    'hostname.hostnameInvalidLocalName' => "'%value%' non sembra essere un nome di rete locale valido.",
    'hostname.hostnameLocalNameNotAllowed' => "'%value%' sembra essere un nome di rete locale ma i nomi di rete locale non sono consentiti.",

    'port.notBetween' => 'Il valore della porta specificato non è valido. Deve essere tra 1 e 65535, inclusivamente',

    'dns.invalidSoaValue' => 'Valore non valido. Può essere da 1 secondo a 68 anni.',

    'isEmpty' => 'Questo campo obbligatorio è vuoto. È necessario specificare un valore.',
    'stringLengthTooShort' => "'%value%' è inferiore di '%min%' caratteri",
    'stringLengthTooLong' => "'%value%' è superiore di '%max%' caratteri",
    'regexNotMatch' => "'%value%' non coincide con il modello '%pattern%'.",
    'notAlnum' => "'%value%' presenta caratteri non alfanumerici. Accertati di usare solo caratteri alfanumerici.",
    'alnumStringEmpty' => "Il valore è vuoto.",
    'stringEmpty' => "'%value%' è vuoto.",
    'loginSyntax' => 'È possibile usare caratteri alfanumerici, trattini (-), punti (.), apostrofi (\'), segni di percentuale (%) e caratteri di sottolineatura (_) nel nome utente. Il nome utente deve iniziare con un simbolo alfanumerico.',
    'loginExists' => 'L\'account utente %value% esiste già.',
    'cu_admin_alias__login_exists' => 'Account utente già esistente.',
    'loginPassword' => 'La password non dovrebbe contenere un nome utente.',
    'passwordSyntax' => 'La password contiene caratteri non consentiti.',
    'passwordLength' => 'La lunghezza della password deve essere compresa tra %minLength% e %maxLength% caratteri.',
    'domain_invalid_name' => 'Il nome di dominio specificato non è valido. Devi specificare un nome di dominio valido come domain.com.',
    'dns_domain_invalid_name' => 'Il nome di dominio specificato non è valido.',
    'dns_domain_template_invalid_name' => 'Il modello del nome di dominio specificato non è valido.',
    'not_ascii_string' => 'Il valore non è una stringa ASCII valida.',
    'virtual_directory_name_invalid' => 'Usa solo caratteri alfanumerici, caratteri di sottolineatura e trattini nel nome della directory.',
    'virtual_directory_name_reserved' => 'Questo nome è riservato.',
    'invalid_city_name' => 'Il nome della città inserito non è valido',
    'invalid_country_code' => 'Codice paese non valido',
    'not_specified_country_code' => 'Il campo relativo al Paese di provenienza è obbligatorio, non può essere lasciato vuoto.',
    'invalid_system_user_login' => 'Il login dell\'utente del sistema non è valido',
    'invalid_rfc_domain_name' => 'Il nome di dominio specificato non è un dominio RFC valido',
    'idn_name_conversion' => 'Impossibile convertire il nome di dominio da IDN a Punycode',
    'domain_label_too_long' => 'Nessuna parte del nome di dominio può superare 63 caratteri di lunghezza.',
    'domain_label_too_long_idn' => 'Il dominio utilizza un nome di dominio internazionalizzato. Nessuna parte del nome, convertita in Punycode, può superare 63 caratteri di lunghezza.',
    'domain_starts_with_www' => 'Inserisci un nome di dominio senza il prefisso \'www\'. Il prefisso www per il dominio sarà automaticamente aggiunto alla configurazione del server web.',
    'domain_already_exists' => 'Questo nome di dominio esiste già.',
    'domain_without_www_already_exists' => 'Questo nome di dominio esiste già senza il prefisso \'www\'.',
    'domain_with_www_already_exists' => 'Questo nome di dominio esiste già con il prefisso \'www\'.',
    'subdomain_conflicts_with_existing_domain' => 'C\'è un dominio con lo stesso nome del sottodominio \'%value%\'.',
    'restrict_domain_creation' => 'Il nome di dominio specificato è proibito dalle normative del server. Se questo dominio ti appartiene, sei pregato di contattare il tuo fornitore di hosting.',
    'dns_record_already_exists' => 'Questo registro DNS esiste già.',
    'domain_like_hostname' => 'Questo nome a dominio è lo stesso del nome host del server.',
    'passwordsNotMatch' => 'Le password inserite non coincidono.',
    'stringsNotEqual' => 'I valori non sono uguali.',
    'equalMailAliases' => 'L\'alias e-mail specificato coincide con quello di un altro alias e-mail.',
    'mailAliasExist' => 'L\'alias email specificato esiste già.',
    'mailNameExist' => 'L\'indirizzo e-mail specificato esiste già.',
    'mailListExist' => 'L\'indirizzo specificato è già stato assegnato ad una lista di posta.',
    'mailAutoReplyHeadersSpaceError' => "Le intestazioni di risposta automatica non devono contenere spazi",
    'mailAutoReplyHeadersInvalidValueError' => 'Alcuni campi sono vuoti o contengono dati non validi.',
    'sysUserExist' => 'Il nome utente specificato è già usato da un altro utente del sistema. Specifica un altro nome utente.',
    'emailAddressInvalid' => 'L\'indirizzo e-mail inserito non è valido. Inseriscine uno valido che rispetti il seguente modello: mariorossi@esempio.com.',
    'emailAddressInvalidLocal' => 'L\'indirizzo email specificato non è valido. L\'indirizzo email deve appartenere al dominio selezionato. Unicamente l\'amministratore può indicare gli indirizzi email esterni in questo caso.',
    'emailAddressSpecialNames' => 'L\'indirizzo specificato non è valido. La parte del nome utente dell\'indirizzo non deve iniziare con un nome di sistema riservato (ad es. con, lpt1, prn), separato dal simbolo del punto (.) dal resto del nome utente.',
    'longAddress' => 'L\'indirizzo email è troppo lungo.',
    'longMailboxAddressMailServer' => 'La parte del nome utente dell\'indirizzo email è troppo lunga per questo server di posta. Indica un nome utente non più lungo di %%max%% simboli.',
    'longFullAddressMailServer' => 'L\'indirizzo email è troppo lungo per questo server di posta. Indica un indirizzo non più lungo di %%max%% simboli.',
    'dir_invalid_name' => 'Directory di destinazione non valida.',
    'directoryHidesDomain' => 'Questa directory non può essere usata perché sostituirebbe il sito web su %path%. Tale sovrapposizione eviterebbe la disponibilità dell\'applicazione installata.',
    'directoryHidesAnotherApplication' => 'Questa directory non può essere usata perché sostituirebbe un\'altra applicazione installata su %path%. Tale sovrapposizione eviterebbe la disponibilità dell\'applicazione installata.',
    'directoryIsBehindAnotherApplication' => 'Questa directory non può essere usata perché sarebbe sovrapposta da un\'altra applicazione installata su %path%. Tale sovrapposizione eviterebbe la disponibilità del sito web installato.',
    'domainLoginSyntaxWindows' => 'Il nome utente deve iniziare con un carattere alfabetico e non può superare %%maxlength%% caratteri di lunghezza. Tutti i caratteri tranne il primo possono essere caratteri alfanumerici minuscoli, trattino, punto e segno di sottolineatura. Il nome utente non può terminare con un punto.',
    'domainLoginSyntaxUnix' => 'Il nome utente non deve superare %%maxlength%% caratteri e può contenere solo caratteri alfanumerici minuscoli e trattini alti o bassi. Il nome utente dovrebbe iniziare con un carattere alfabetico minuscolo',
    'notLocalMssqlHost' => 'Host name MSSQL locale non valido',
    'invalidMailTo' => 'Mailto non valido: link',
    'passwordsNotEqual' => 'Le password inserite non coincidono.',
    'passwordPolicy' => '%policyError%',
    'fileImageSizeWidthTooBig' => "L'immagine '%value%' che stai cercando di caricare è troppo ampia ('%width%'). Le immagini caricate non possono superare la larghezza: '%maxwidth%'.",
    'fileImageSizeWidthTooSmall' => "L'immagine '%value%' che stai cercando di caricare non è sufficientemente ampia ('%width%'). Le immagini caricate devono presentare una larghezza di almeno '%minwidth%'.",
    'fileImageSizeHeightTooBig' => "L'altezza dell'immagine '%value%' che stai cercando di caricare è troppo grande ('%height%'). Le immagini caricate non possono superare '%maxheight%' di altezza.",
    'fileImageSizeHeightTooSmall' => "L'altezza dell'immagine '%value%' che stai cercando di caricare è troppo piccola ('%height%'). Le immagini caricate non possono essere inferiori di '%minheight%' di altezza.",
    'fileImageSizeNotDetected' => "La dimensione dell'immagine '%value%\\ che stai provando di caricare non è stata rilevata.",
    'fileImageSizeNotReadable' => "Impossibile leggere l'immagine '%value%' che stai cercando di caricare.",
    'passwordConfirmation' => 'Conferma la password',
    'databaseUserNameExists' => 'Esiste già un nome_utente del database con il nome %value%.',
    'invalidUserName' => 'Il nome utente del database contiene caratteri non consentiti.',
    'longUserName' => 'Il nome dell\'utente del database supera %%max%% caratteri.',
    'forbiddenName' => 'Il nome utente del database "%value%" non è consentito.',
    'invalidAdminLogin' => 'Impossibile usare le credenziali dell\'utente selezionato per l\'accesso dell\'amministratore. Il nome utente specificato non è valido: %%cause%%',
    'invalidAdminPassword' => 'Impossibile usare le credenziali dell\'utente selezionato per l\'accesso dell\'amministratore. La password specificata non è valida: %%cause%%',
    'passwordLengthTooShort' => "la password ha una lunghezza inferiore a %min% caratteri.",
    'passwordLengthTooLong' => "la password ha una lunghezza maggiore di %max% caratteri.",
    'passwordRegexNotMatch' => "la password non coincide con il modello '%pattern%'.",
    'fileSharingEmptyFolderName' => "È necessario specificare un nome per la cartella.",
    'fileSharingInvalidFolderName' => "Il nome della cartella specificato non è valido. Non può contenere nessuno dei caratteri seguenti: \\ / : * ? \" < > |",
    'fileSharingFolderExists' => "Impossibile creare una cartella con il nome specificato perché esiste già una cartella con questo nome.",
    'invalidUrl' => 'L\'indirizzo specificato non è valido. Devi specificare un indirizzo valido come http://domain.com.',
    'domainVirtualdirectoryReservedName' => 'Il nome di questa directory è riservato. Specificare un nome diverso per la directory virtuale.',
    'domainVirtualdirectoryInvalidName' => 'Il nome di una directory deve contenere solo caratteri alfanumerici, di sottolineatura  e trattini.',
    'filesharingPathUnavailable' => 'Esiste già una directory con questo nome nel dominio indicato.Usa un altro nome per la directory.',
    'filesharingSslNotAvailableOnDomain' => 'Hai selezionato di usare collegamenti sicuri ma il dominio non ha un SSL/TLS abilitato. Seleziona un dominio con supporto SSL/TLS o deseleziona la casella di controllo Crea collegamenti sicuri.',
    'filesharingSslRedirectOnDomain' => 'L’opzione "Reindirizzamento SEO-safe 301 permanente da HTTP a HTTPS” per il dominio selezionato è abilitata.Per impostare la condivisione di file, scegli un dominio con questa opzione disabilitata oppure seleziona la casella di controllo “Genera link sicuri per file e cartelle”.',
    'filesharingSslNotAvailableOnDefaultDomain' => 'Hai scelto di usare collegamenti sicuri sull\'indirizzo IP o nome host del server, ma tali collegamenti possono essere creati solo sui siti web con supporto SSL/TLS. Configura un sito web con supporto SSL/TLS o deseleziona la casella di controllo Crea collegamenti sicuri.',
    'filesharingDefaultDomainSelectedOnServerIp' => 'Hai selezionato l\'indirizzo IP del server a cui è stato assegnato un dominio predefinito. Seleziona un sito web come URL root invece di un indirizzo IP.',
    'physicalPathOnDomainAlreadyExists' => 'Esiste già una directory con questo nome.',
    'virtualPathOnDomainAlreadyExists' => 'Esiste già una directory virtuale con questo nome.',
    'sysUserLoginSyntaxWindows' => 'Il nome utente può contenere simboli alfanumerici, trattino (-), punto (.) e carattere di sottolineatura (_). Il nome utente deve incominciare con un simbolo alfanumerico.',
    'sysUserLoginSyntaxUnix' => 'Il nome utente può contenere minuscole, simboli alfanumerici, trattino (-), punto (.) e carattere di sottolineatura (_). Il nome utente deve incominciare con un simbolo alfanumerico.',
    'docrootNotInWebspaceRoot' => 'La directory specificata non è presente nella directory principale dell\'abbonamento.',
    'docrootContainsSpecialCharacters' => 'Il nome di directory specificato contiene simboli che non si possono usare.',
    'docrootWithinProhibitedDirectory' => 'La directory specificata contiene una directory di servizio.',
    'docrootWithinInstalledApplication' => 'La directory specificata è sovrapposta dall\'applicazione web installata su %path%',
    'docrootIsNotDirectory' => 'Il percorso specificato non può essere usato perché una sua parte si riferisce a un file.',
    'docrootTooLongPart' => 'Il nome della directory specificato è troppo lunga.',
    'subdomainWrongName' => '%errorDescription%',
    'subdomainWrongDomain' => 'È stato selezionato un dominio non valido.',
    'domainAliasWrongName' => '%errorDescription%',
    'phoneRegexNotMatch' => 'È stato specificato un numero di telefono errato. Contiene simboli non consentiti.',
    'stateInvalid' => 'È stato specificato uno stato o una provincia non validi.',
    'zipRegexNotMatch' => 'È stato specificato un codice di avviamento postale non valido.',
    'limitValueInvalid' => 'Il limite specificato non è valido.',
    'softLimitValueInvalid' => 'Il valore deve essere nell\'intervallo %%MIN%%..%%MAX%%.',
    'outgoingMessagesLimitValueInvalid' => 'Il valore deve essere nell\'intervallo %%MIN%%..%%MAX%%. Unicamente l\'amministratore Plesk può regolare tale impostazione.',
    'limitMssqlDatabaseFileSizeValueInvalid' => 'La dimensione di un file di database MS SQL deve essere un numero intero tra 0 e 16 TB.',
    'limitMssqlDatabaseLogFileSizeValueInvalid' => 'La dimensione di un file di registro del database MS SQL deve essere un numero intero tra 0 e 2 TB.',
    'limitDiskspaceValueInvalid' => 'Il limite dello spazio su disco deve essere un numero intero tra 0 e 4095 TB.',
    'limitTrafficValueInvalid' => 'Il limite del traffico deve essere un numero intero tra 0 e 4095 TB/mese.',
    'limitMboxQuotaValueInvalid' => 'Il limite della dimensione della casella postale deve essere un numero intero tra 0 e 4095 TB.',
    'limitRetainPeriodValueInvalid' => 'Il valore per "Conserva statistiche web e del traffico" nei piani di servizio non può essere inferiore al valore per "Conserva statistiche web e del traffico" in Strumenti e Impostazioni> Impostazioni del server. Specifica un numero intero superiore o uguale a %%MIN%% e inferiore a %%MAX%%.',
    'limitValueOverused' => 'La quantità di risorse attualmente usate supera il valore del limite specificato. Non è possibile specificare un valore inferiore di %%used%%',
    'limitValueOverselled' => 'Il limite dell\'utilizzo delle risorse di %%reserved%% è già assegnato agli abbonamenti. Non è possibile specificare un valore inferiore a %%reserved%%',
    'lessThan' => "'%value%' è inferiore di '%min%'",
    'greaterThan' => "'%value%' è superiore di '%max%'",
    'greaterThanDiskQuota' => "%value% è superiore alla quota del disco (%max%)",
    'notDigits' => 'Il valore deve essere un numero intero.',
    'digitsInvalid' => 'Il valore deve essere un numero intero.',
    'digitsStringEmpty' => 'Il valore deve essere un numero intero.',
    'isEqual' => "Il valore non deve essere uguale a \"%invalidValue%\".",
    'notInt' => 'Il valore deve essere un numero intero.',
    'maillistNameInvalid' => 'L\'indirizzo della mailing list specificato non è valido.',
    'maillistReservedNameAlreadyExists' => 'L\'indirizzo specificato è già riservato.',
    'maillistAlreadyExists' => 'L\'indirizzo specificato è già usato da una lista di posta.',
    'maillistAlreadyExistsOnServer' => 'Il nome specificato per la lista di posta è già usato da un altro abbonamento',
    'mailnameAlreadyExists' => 'L\'indirizzo e-mail specificato esiste già.',
    'mailaliasAlreadyExists' => 'L\'indirizzo specificato è già usato da un altro alias e-mail.',
    'autoresponderEndDateIsInvalid' => 'La data specificata deve essere in futuro.',
    'mailPostboxLimit' => '%message%',
    'userEmailLimitExceeded' => '%limitManagerMessage%',

    'zxcvbnEstimator.passwordStrength' => 'La tua password non è abbastanza complessa. Secondo le norme del server, la lunghezza minima della password è %strength%.',
    'zxcvbnEstimator.passwordStrengthVeryWeak' => 'Molto debole (non consigliato)',
    'zxcvbnEstimator.passwordStrengthWeak' => 'Debole (non consigliato)',
    'zxcvbnEstimator.passwordStrengthMediocre' => 'Mezza',
    'zxcvbnEstimator.passwordStrengthStrong' => 'Forte (consigliato)',
    'zxcvbnEstimator.passwordStrengthStronger' => 'Molto alta',
    'zxcvbnEstimator.passwordStrengthVeryWeakHint' => 'Può essere forzata facilmente con attacchi di forza bruta. È vulnerabile agli attacchi credential stuffing e dizionario.',
    'zxcvbnEstimator.passwordStrengthWeakHint' => 'Può essere forzata facilmente con attacchi di forza bruta. È meno vulnerabile agli attacchi credential stuffing e dizionario.',
    'zxcvbnEstimator.passwordStrengthMediocreHint' => 'Può essere forzata con attacchi di forza bruta.',
    'zxcvbnEstimator.passwordStrengthStrongHint' => 'Difficilmente forzabile con attacchi di forza bruta. Ha un po\' di protezione dagli attacchi offline.',
    'zxcvbnEstimator.passwordStrengthStrongerHint' => 'Forza bruta impraticabile. Protezione ragionevole contro gli attacchi offline.',

    'emailCantBeRenamed' => "Il server non consente di rinominare gli account di posta",
    'emailOwnedByAnotherUser' => "Questo indirizzo e-mail appartiene a un altro utente.",
    'maillistAdminEmailShouldExistsOnDomain' => 'L\'indirizzo e-mail dell\'amministratore della lista di posta deve essere registrato sullo stesso dominio come lista di posta.',
    'webmailExists' => "Il servizio webmail '%value%' esiste già.",
    'invalidDbName' => 'Il nome del database può contenere soltanto caratteri alfanumerici, punti, trattini e simboli di sottolineatura.',
    'longDbName' => 'Il nome del database è troppo lungo.',
    'dbNameClash' => 'Il nome del database e il nome utente del database devono essere diversi.',
    'dbConnectFailed' => 'Impossibile connettere al server database.Verifica le credenziali dell\'utente del database e le limitazioni di accesso.',
    'databaseNameAlreadyExists' => 'Esiste già un database con il nome %value%.',
    'wrongUrlSyntax' => 'L\'indirizzo specificato non è valido. È necessario specificare un indirizzo valido come http://domain.com, relativo/percorso o mailto:address',
    'connectionRefused' => 'Connessione rifiutata.',
    'loginIncorrect' => 'Nome utente non valido',
    'failedToChangeDirectory' => 'Directory inesistente',
    'failedToChangeMode' => 'Impossibile cambiare modalità',
    'failedToCreateDirectory' => 'Creazione di file non consentita',
    'failedToRenameDirectory' => 'Ridenominazione di file non constentita',
    'failedToDeleteDirectory' => 'Eliminazione di file non consentita',
    'ipInvalid' => "'%value%' non sembra essere un indirizzo IP valido o appartiene al tipo sbagliato.",
    'ipMaskInvalid' => "'%value%' non sembra essere una maschera di indirizzo IP valida.",
    'ipInvalidForInterface' => 'L\'indirizzo IP specificato non può essere usato sull\'interfaccia di rete. Devi specificare un indirizzo IP valido con una maschera o un intervallo di prefisso di sottorete.',
    'ipInvalidForInterfaceIpv6NotAvailable' => 'L\'indirizzo IP specificato non può essere usato sull\'interfaccia di rete selezionata perché il supporto IPv6 è disattivato per questa interfaccia.',
    'ipAlreadyExists' => 'L\'indirizzo IP %value% esiste già.',
    'notInArray' => 'Questa opzione non è supportata.',
    'ipAddressIsNotSelected' => 'Almeno un indirizzo IP deve essere selezionato',
    'noServiceNodeSpecified' => 'Errore interno: nessun nodo di servizio specificato.',
    'serviceNodeInvalidName' => 'Nome del nodo di servizio non valido "%value%".',
    'serviceNodeNameAlreadyExists' => 'Il nodo di servizio con il nome "%value%" esiste già.',
    'serviceNodeIpUsed' => "Impossibile rimuovere il nodo di servizio: l'indirizzo IP è registrato.",
    'serviceNodeIpAddressAlreadyExists' => 'Il nodo di servizio con l\'indirizzo IP "%value%" esiste già.',
    'serviceNodeInvalidTransport' => 'Nome di trasporto non valido "%value%".',
    'app_non_unique_setting_value' => 'Un altro oggetto ha lo stesso valore impostato. Questa impostazione deve essere unica per questo oggetto.',
    'wrongLocalUrlSyntax' => 'L\'indirizzo specificato non è valido. Indicare un indirizzo locale valido, come /smb/web/view.',
    'phpIsapiHandlerTypeNotSupported' => 'Il tipo di gestore ISAPI non è supportato dall\'attuale versione PHP.',
    'dbNameNotExist' => 'Il database specificato è inesistente.',
    'invalidBooleanValue' => 'I valori consentiti sono "true" o "false".',
    'invalidMimeType' => 'Il tipo MIME specificato non è valido: "%value%".',
    'invalidHeaders' => 'L’intestazione specificata non è valida: "%value%".',
    'invalidHandler' => 'Il gestore specificato non è valido: "%value%".',
    'invalidAllowDeny' => 'La direttiva Consenti/Nega specificata non è valida: "%value%".',
    'nonUniqueAllowDeny' => 'Il valore specificato per la direttiva Consenti/Nega esiste già: "%value%".',
    'maxItemsCountExeededAllowDeny' => 'Il numero di indirizzi IP nella lista deve essere inferiore di o pari a %value%.',
    'invalidDirectoryIndex' => 'Il file indice della directory root specificato non è valido.',
    'invalidNginxProxyMode' => 'Il valore specificato per la proprietà nginxProxyMode non è valido. I valori consentiti sono "true" o "false".',
    'invalidNginxTransparentMode' => 'Il valore specificato per la proprietà nginxTransparentMode non è valido. I valori consentiti sono "true" o "false".',
    'invalidNginxServeStatic' => 'Il valore specificato per la proprietà nginxServeStatic non è valido. I valori consentiti sono "true" o "false".',
    'invalidStaticFilesExtensions' => 'Le estensioni di file statici specificate non sono valide: "%value%".',
    'invalidNginxServePhp' => 'Il valore specificato per la proprietà nginxServePhp non è valido. I valori consentiti sono "true" o "false".',
    'invalidDocuments' => 'Il nome del documento non deve contenere virgole (",").',
    'duplicateDocuments' => 'I seguenti documenti esistono già nell\'elenco di documenti predefiniti: "%value%"',
    'protected_directory_invalid_login' => 'Il login di un utente della directory protetta da password non può contenere più di 20 caratteri alfanumerici. Il login può anche contenere il simbolo barra ("-"), ma non può cominciare con esso.',
    'notARelativePath' => 'Il percorso deve essere relativo',
    'cannotUseJunctions' => 'Non è possibile utilizzare le giunzioni al di fuori dello spazio web come directory temporanea di compilazione',
    'notBetween' => '"%value%" non è compreso tra "%min%" e "%max%", inclusivamente',
    'notBetweenStrict' => '"%value%" non è precisamente tra "%min%" e "%max%"',
    'redirectToMyself' => 'Impossibile inoltrare il sito Web a se stesso.Inserire un indirizzo di destinazione diverso dall\'indirizzo principale dell\'URL del sito Web.',
    'redirectToAlias' => 'Impossibile inoltrare il sito Web all\'alias corrispondente.Inserire un indirizzo di destinazione diverso dall\'indirizzo principale dell\'alias del sito Web.',
    'relativePathInvalid' => 'Il percorso indicato non è valido.',
    'aspDotNetSettingsInvalid' => 'Uno o più valori specificati per le impostazioni ASP.NET non sono validi.',
    'mboxOutgoingMessagesLimitValueInvalid' => 'Il valore del limite sui messaggi in uscita per una casella postale deve essere maggiore di "%%MIN%%".',
    'domainOutgoingMessagesLimitValueInvalid' => 'Il valore del limite sui messaggi in uscita per un dominio deve essere maggiore di "%%MIN%%".',
    'subscriptionOutgoingMessagesLimitValueInvalid' => 'Il valore del limite sui messaggi in uscita per un abbonamento deve essere maggiore di "%%MIN%%".',
    'iisAuthNotEnabled' => 'L\'autenticazione anonima o di Windows non deve essere attivata nelle impostazioni del server web per il dominio.',
    'mboxOutgoingMessagesLimitValueInvalidDigit' => 'Il valore del limite sui messaggi in uscita per una casella postale deve essere un numero intero positivo o \'default\'.Può anche essere \'-1\' per il valore \'Illimitato\'.',
    'domainOutgoingMessagesLimitValueInvalidDigit' => 'Il valore del limite sui messaggi in uscita per un dominio deve essere un numero intero positivo o \'default\'.Può anche essere \'-1\' per il valore \'Illimitato\'.',
    'subscriptionOutgoingMessagesLimitValueInvalidDigit' => 'Il valore del limite sui messaggi in uscita per un abbonamento deve essere un numero intero positivo o \'default\'.Può anche essere \'-1\' per il valore \'Illimitato\'.',
    'outgoingMessagesReportPeriodValueInvalid' => 'Il valore specificato per il periodo di reporting non è supportato.',
    'outgoingMessagesNotificationPeriodValueInvalid' => 'Il valore specificato per il periodo di notifica non è supportato.',
    'textItemsListInvalid' => 'Il tema specificato non è valido: "%value%".',
    'textItemsListInvalidMulti' => 'Gli elementi specificati non sono validi: "%value%".',
    'textItemsListNonUnique' => 'Il valore specificato esiste già: "%value%".',
    'textItemsListMaxItemsCountExeeded' => 'Il numero di elementi non deve superare %value%.',
    'invalidAcl' => 'L\'host specificato non è valido: "%value%".',
    'nonUniqueAcl' => 'Il valore specificato per l\'host esiste già: "%value%".',
    'httpInvalidStatusFormat' => 'I codici di stato devono essere numeri nella forma 400 o 400.1',
    'httpInvalidStatusCode' => 'I codici di stato devono essere compresi tra %%minCode%% e %%maxCode%%',
    'httpInvalidStatusSubCode' => 'I codici di stato devono essere compresi tra %%minSubCode%% e %%maxSubCode%%',
    'httpInvalidStatusRange' => 'Gli intervalli di stato devono indicare un intervallo da un minimo valore a un massimo valore',
    'phpSettingValueByteRegexNotMatch' => 'È stato specificato un valore non valido. Digita un numero intero e un carattere a sintassi abbreviata (K per kilobyte, M per megabyte, G per gigabyte, per esempio, 128M)',
    'phpFpmServersAmountNotPositive' => "Il valore deve essere un numero positivo",
    'phpFpmServersAmountLessThan' => "'%value%' è inferiore di '%%min%%' (%%field%%)",
    'phpFpmServersAmountGreaterThan' => "'%value%' è superiore di '%%max%%' (%%field%%)",
    'phpInvalidIniSyntax' => "Rilevata sintassi INI non valida sulla linea %%line%%: '%%text%%'",
    'portRangeInvalid' => 'L\'intervallo delle porte specificato non è valido. Il valore di sinistra deve essere inferiore a quello di destra.',
    'portRangeValueInvalid' => 'Il valore %value% nell\'intervallo delle porte non è valido. Deve essere compreso tra %min% - %max%.',
    'domainResolvesToAnotherIp' => 'Il dominio si risolve all\'indirizzo IP errato (%value%). Per pubblicare il tuo sito web online, correggi %%dnsSettingsLink%%.',
    'domainNotResolved' => 'Il dominio non si può risolvere. Per pubblicare il tuo sito web online, correggi %%dnsSettingsLink%%.',
    'dnsSettingsLink' => 'Impostazioni DNS',
    'backupPathInvalidCharacters' => '%value% contiene caratteri non validi.',
    'backupPathInvalidDot' => '%value% contiene un percorso "." o ".." non valido.',
    'networkAccessAlreadyExists' => 'La rete è già presente nella lista di restrizioni di accesso.',
    'codeRegexNotMatch' => 'Il codice di attivazione non è valido.',
    'nameUsedForPlesk' => 'Impossibile creare il dominio poiché il suo nome è incluso nell’URL utilizzato per accedere a Plesk. Per creare il dominio, accedi a Plesk tramite https://%value%:8443 o https://plesk.%value%.',
    'invalidNameDirectory' => 'Nome specificato non valido.',
    'invalidPasswordCharacters' => 'La password non può contenere virgolette, spazi o caratteri nazionali.',
    'invalidPasswordLength' => 'La password deve avere una lunghezza compresa fra %%min%% e %%max%% caratteri.',
    'passwordContainsLogin' => 'La password non deve contenere il nome di accesso.',

    'invalidPhpExtensionName' => 'Nome dell\'estensione non valido.',
    'hexStringNotMatch' => 'Il valore specificato non è una stringa esadecimale valida.',
    'invalidCertificateData' => 'Il valore specificato non è un dato di certificato valido.',
    'invalidSha256Hash' => 'Il valore specificato non è un hash SHA-256 valido.',
    'invalidSha512Hash' => 'Il valore specificato non è un hash SHA-512 valido.',
    'invalidTlsaMatchingType' => 'Tipo di corrispondenza TLSA indicato non valido',
];