<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => '追加キープロパティ',
    'additional-key-info.update' => '追加キーの取得',
    'additional-key-info.updateDescription' => '追加キーを取得しインストールします。',
    'additional-key-info.download' => 'キーをダウンロード',
    'additional-key-info.downloadDescription' => '現在のライセンスキーをダウンロードする',
    'additional-key-info.install' => 'キーのインストール',
    'additional-key-info.installDescription' => '現在のライセンスキーをインストールします。',
    'additional-key-info.revert' => 'キーをロールバック',
    'additional-key-info.revertDescription' => '以前にインストールしたライセンスキーに戻します。',
    'additional-key-info.revertNotAvailableDescription' => 'キーがインストールされていません。',
    'additional-key-info.installSuccess' => 'ライセンスキーのインストール作業が開始されました。',

    'additional-key-revert.title' => '追加キーのロールバック',
    'additional-key-revert.success' => '追加キーがロールバックされました。',

    'additional-key-upload.title' => 'ライセンスキーをインストールする',
    'additional-key-upload.success' => '新しい拡張キーがアップロードされました。',

    'additional-keys.title' => '追加のライセンスキー',

    'change-owner.title' => '選択した契約の再割り当て',

    'customers.hint' => 'ホスティングサービスの顧客のアカウントを管理します。サービス契約付きでアカウントを作成したり、既存リセラーの管理やアカウントの削除を行います。ウェブサイトやメールなど、顧客に提供されているサービスを管理するには、リストの右端にあるログインリンクをクリックして顧客パネルを開いてください。',

    'customer-domains.hint' => 'ウェブサイトの設定と管理を行います。',

    'customer-subscriptions.hint' => '顧客の契約を管理します。',

    'domains.hint' => 'システムに登録されたすべてのドメイン名についての情報を表示し、ホスティングサービスの管理に進むことができます。自社またはホスティング顧客用にドメインを追加するには、［ドメインを追加］をクリックしてください。 ドメインの作成時に、顧客と契約を新規作成するか、既存のものを選択するかを選ぶ必要があります。',

    'database-servers.title' => 'データベースサーバ',

    'database-server-create.title' => '新しいデータベースサーバ',

    'database-server-properties.title' => 'データベースサーバ',

    'database-server-upgrade.title' => 'データベースサーバのアップグレード',
    'database-server-upgrade.currentVersion' => '現在のバージョン',
    'database-server-upgrade.selectVersion' => 'バージョンを選択',
    'database-server-upgrade.information' => '情報',
    'database-server-upgrade.releaseNotes' => 'リリースノート',
    'database-server-upgrade.releaseDate' => 'リリース日',
    'database-server-upgrade.unable' => 'アップグレードできません',
    'database-server-upgrade.endOfLifeDate' => 'EOL 日',
    'database-server-upgrade.description' => 'MySQL/MariaDB は、一般的に使用されているリレーショナルデータベース管理システムで、ほとんどの Plesk システムのコアサービスです。このインターフェースでは、MySQL/MariaDB サーバをバージョン 10.6 にアップグレードできます。ポイントリリース（バージョン番号の 3 桁目）はアップグレードしてもユーザのデータに与えるリスクが少ないため、Plesk は MySQL/MariaDB のインストールをより新しいポイントリリースに自動でアップグレードします。一方、新しいメジャーリリース（バージョン番号の最初の 2 桁）へのアップグレードは、データ損失のリスクが高いため、より複雑になります。このインターフェースでは、メジャーリリースへのアップグレード工程についてガイダンスを提供します。',
    'database-server-upgrade.warning' => 'インプレースアップグレードは一般的に安全ですが、アップグレード前にデータベースの完全なバックアップを実行することを強くお勧めします。以前のバージョンへのダウングレードはサポートされていません。データベースサーバをアップグレードした後で以前のバージョンに戻すことはできない可能性があります。MariaDB を MySQL 8 に置き換えることはダウングレードとみなされ、サポートされません。',

    'database-server-databases.title' => 'データベース',

    'database-server-change-password.title' => '管理者パスワード',

    'home.title' => 'ホーム',

    'license.title' => 'ライセンス情報',

    'primary-key-info.title' => 'Plesk ライセンスキー',
    'primary-key-info.update' => 'キーを取得',
    'primary-key-info.updateDescription' => '注文したライセンスキーを検索/インストールします。',
    'primary-key-info.upload' => 'キーのインストール',
    'primary-key-info.uploadDescription' => '新しいライセンスキーをアップロードしてインストールします。',
    'primary-key-info.revert' => 'キーをロールバック',
    'primary-key-info.revertDescription' => '以前にインストールしたライセンスキーに戻します。',

    'primary-key-revert.title' => 'ライセンスキーのロールバック',
    'primary-key-revert.success' => 'Plesk キーがロールバックされました。',

    'primary-key-upload.title' => 'ライセンスキーをインストールする',
    'primary-key-upload.success' => '新しい Plesk キーがアップロードされました。',

    'resellers.hint' => 'リセラー（ホスティングサービスを再販し、自分のウェブサイトをホスティングする顧客）のアカウントを管理します。サービス契約に従って、アカウントの作成、既存のリセラーの管理、アカウントの削除を行います。',

    'reseller-customers.hint' => '顧客の設定と管理を行います。',

    'reseller-domains.hint' => 'ウェブサイトの設定と管理を行います。',

    'reseller-subscriptions.hint' => 'リセラーの契約を管理します。',

    'subscriptions.hint' => '顧客がホスティングプランを利用するには、ホスティングプランを契約する必要があります。この画面で、自社のウェブサイトのホスティング用に作成した契約とともに、これらの契約を管理することができます。契約で提供するサービス（ウェブサイトやメールなど）を管理するには、リストの右側にあるリンクをクリックして契約者の顧客パネルを開いてください。',

    'server-mail-settings.title' => '設定',
    'server-mail-spam-filter.title' => 'スパムフィルタ',
    'server-mail-antivirus.title' => 'アンチウイルス',
    'server-mail-black-list.title' => 'ブラックリスト',
    'server-mail-white-list.title' => 'ホワイトリスト',
    'server-mail-queue.title' => 'メールキュー',
    'server-mail-statistics.title' => '統計',

    'firewall.title' => 'ファイアウォール管理',
    'firewall-general.title' => '全般',
    'firewall-general.toggleStatus' => 'ファイアウォール保護',
    'firewall-general.buttonDefault' => 'デフォルトにリセット',
    'firewall-general.buttonPanic' => 'パニックモード',
    'firewall-general.confirmationDefault' => 'ファイアウォール設定をデフォルトにリセットしますか？',
    'firewall-general.confirmationPanic' => 'パニックモードをオンにしますか？ユーザは自分のドメインにアクセスできなくなり、一部のネットワークサービスの機能が停止する可能性があります。',
    'firewall-general.successDefault' => 'ファイアウォール設定がデフォルトにリセットされました。',
    'firewall-general.successPanic' => 'パニックモードが有効になりました。',
    'firewall-general.info' => 'セキュリティ上の理由により、ファイアウォールは明示的に許可された接続以外のすべての接続をブロックします。接続を許可するためにルールを作成することができます。詳細はマニュアルを参照してください。',
    'firewall-general.interfaces' => 'ネットワークインターフェース',
    'firewall-icmp.title' => 'ICMP プロトコル',
    'firewall-rules.title' => 'ファイアウォールルール',

    'dns.title' => 'DNS 設定',
    'dns-records.title' => 'ゾーンレコードテンプレート',
    'dns-soa-record.title' => 'ゾーン設定テンプレート',

    'php-handler.title' => ' %%name%% の設定',
    'php-handler.extensions.title' => '拡張',
    'php-handler.extensions.description' => 'これらの PHP 拡張の設定は、このハンドラにのみ使用されます。',
    'php-handler.extensions.descriptionShared' => 'これらは、PHP ハンドラ %%handlers%% で共通の設定であり、このハンドラを使用するすべてのウェブサイトに適用されます。',
    'php-handler.extensions.buttonManage' => 'PECL パッケージを管理',
    'php-handler.extensions.manage.title' => 'PECL パッケージを管理',
    'php-handler.extensions.manage.risks' => 'PHP 拡張はサードパーティの PECL パッケージで提供されます。インストールはご自分の責任で行ってください。',
    'php-handler.extensions.manage.description' => 'PECL パッケージのインストール、アップグレード、アンインストールを行います。変更は %%handlers%% で実行されているすべてのウェブサイトに適用されます。',
    'php-handler.extensions.manage.notFound' => '必要なパッケージがリストにない理由',
    'php-handler.extensions.manage.limitations' => 'コントロールパネルのプロバイダおよび OS ベンダーから提供された PHP 拡張はリストに表示されません。',
    'php-handler.php-ini.title' => 'php.ini',

    'ServerAbout.copyright' => '© 2023 Plesk International GmbH. All rights reserved.',
    'ServerAbout.linkLicenseManagement' => 'ライセンス情報へ移動する',
    'ServerAbout.panelVersion' => 'バージョン',
    'ServerAbout.installedPatchVersion' => '#%%patch%% のアップデート',
    'ServerAbout.licenseKey' => 'ライセンスキー',
    'ServerAbout.productDescription' => 'Plesk は業界をリードする WebOps プラットフォームであり、アプリケーションやウェブサイト、ホスティングビジネスの運用、自動化、拡張に使用できます。',
    'ServerAbout.readEula' => '%%link%%',
    'ServerAbout.linkEula' => 'エンドユーザライセンス契約（EULA）',
    'ServerAbout.visitForum' => '%%link%%',
    'ServerAbout.linkForum' => 'Plesk フォーラム',
    'ServerAbout.followUs' => 'フォロー',
    'ServerAbout.visitSite' => '%%link%% でもっと詳しく',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => '%%link%%',
    'ServerAbout.linkBlog' => 'Plesk ブログ',

    'ServerAbout.darkThemePromoTitle' => 'おつかれさまでした。',
    'ServerAbout.darkThemePromoDescription' => 'Plesk Obsidian 18.0.50 アニバーサリーバージョンで魔法の子猫が追加されました。',
    'ServerAbout.darkThemePromoButton' => 'シュッ！ダークサイドへようこそ',
    'ServerAbout.darkThemeTourDescription' => 'このオプションを切り替えて、インターフェースのダークテーマを有効/無効にしましょう。',
    'ServerAbout.darkThemeTourButton' => '了解しました',

    'ts-sessions.title' => 'ターミナルサーバセッション',
    'ts-sessions-properties.title' => 'セッションのプロパティ',

    'BandwidthLimiting.title' => '%%domainName%% の帯域幅制限',
    'BandwidthLimiting.bandwidthThrottling' => 'QoS がインストールされていないため帯域幅制限をコントロールすることができません',
    'BandwidthLimiting.virtualHostingRequired' => '帯域幅制限は、ウェブホスティング付きのドメインでのみ実行できます。',
    'BandwidthLimiting.bandwidthLabel' => '最大帯域幅利用率',
    'BandwidthLimiting.bandwidthHint' => '帯域幅使用率の上限は、HTTP プロトコル経由のデータ転送にのみ適用されます。',
    'BandwidthLimiting.maxConnectionLabel' => '接続数の上限',
    'BandwidthLimiting.maxConnectionHint' => '帯域幅に上限を設定する場合、ウェブサイトへの同時接続数にも上限を設定することをお勧めします。 サイトへのアクセスが大量に発生すると、ウェブサーバプロセスが増大してウェブサーバの負荷が過剰に上昇する可能性があるためです。',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => '帯域幅制限の設定が変更されました。',
    'BandwidthLimiting.unlimited' => '無制限',

    'ip-address-domains.title' => '%%type%% IP アドレス %%ipAddress%% を使用しているウェブサイト',
    'ip-address-domains.site' => 'サイト',
    'ip-address-domains.setAsDefault' => 'デフォルトとして選択',
    'ip-address-domains.type-SHARED' => '共用',
    'ip-address-domains.type-EXCLUSIVE' => '専用',

    'HotlinkProtection.title' => '%%domainName%% のホットリンク対策',
    'HotlinkProtection.virtualHostingRequired' => 'ホットリンク対策は、ウェブホスティング付きのドメインでのみ実行できます。',
    'HotlinkProtection.enabledLabel' => 'ホットリンク対策を有効化',
    'HotlinkProtection.extensionsLabel' => '保護されるファイル拡張子',
    'HotlinkProtection.friendsLabel' => '許可するウェブサイトのアドレス',
    'HotlinkProtection.success' => 'ホットリンク対策の設定を変更しました',

    'Odbc.serverTitle' => 'ODBC DSN 接続',
    'Odbc.domainTitle' => '%%domainName%% 用 ODBC DSN 接続',
    'Odbc.add' => 'ODBC DSN を追加',
    'Odbc.resourceUsage' => '作成済み %%used%% 件/許可 %%allowed%% 件',
    'Odbc.limitExceeded' => 'ODBC DSN 接続の上限に達しました。',
    'Odbc.unlimited' => '無制限',
    'Odbc.addTooltip' => 'ODBC データソースを追加します。',
    'Odbc.status' => 'ステータス',
    'Odbc.name' => '接続名',
    'Odbc.driver' => 'ドライバ',
    'Odbc.description' => '接続の説明',
    'Odbc.hostname' => 'ホスト名',
    'Odbc.statusSystem' => 'システムDSNです',
    'Odbc.statusConfigured' => 'DSNは設定されています。',
    'Odbc.statusNotConfigured' => 'DSNは設定されていません',
    'Odbc.noSelectionText' => '削除するアイテムを 1 つ以上選択してください。',
    'Odbc.removeConfirmation' => '{count, plural, =1 {{name} 接続} other {# 件の選択された接続}}を削除しますか？',
    'Odbc.removeSuccess' => '選択された接続は削除されました。',

    'DomainAliasSettings.title' => 'ドメインエイリアス設定',
    'DomainAliasSettings.updateSuccess' => 'ドメインエイリアス %%name%% のプロパティが変更されました。%%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'ウェブサイト設定は %%restartInterval%% 分以内に適用されます。',

    'HostingSettings.title' => 'ホスティング設定',
    'HostingSettings.updateSuccess' => '設定は更新されました。',
    'HostingSettings.emptyLogin' => 'ユーザ名を入力してください。',
    'HostingSettings.emptyPassword' => 'パスワードを入力してください。',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP サーバが IPv6 をサポートしていません。IPv4 アドレスを少なくとも 1 つ割り当ててください。これを行わないと、FTP 経由でサーバにファイルをアップロードできなくなります。',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'ドメイン設定',
    'HostingSettings.domainSettingsSection.domainName' => 'ドメイン名',
    'HostingSettings.domainSettingsSection.description' => '例えば example.com ',

    'HostingSettings.submitPopover.title' => '%%website%% のコンテンツを削除',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'ホスティングタイプを「ウェブサイト」から「%%type%%」に切り替えると、以下のディレクトリを含め、ウェブサイト全体のコンテンツが完全に削除されます。',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'ウェブサイトのホスティングタイプを変更しますか？',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'その他の設定にアクセスするには、システムユーザのログイン情報を入力して、［ウェブスペースを作成］をクリックしてください。',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'その他の設定にアクセスするには、［次へ］をクリックしてホスティングを作成してください。',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'ホスティングタイプ',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'タイプ',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'ウェブサイト',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => '転送',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'ウェブホスティングなし',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'ドメイン名の下でメールボックスを管理するためにドメインの DNS ゾーンを使用する',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'ウェブサイトのホームディレクトリへのパス',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => '優先ドメイン',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => '訪問者は SEO フレンドリーな HTTP 301 リダイレクトを介してここにリダイレクトされます。',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => '訪問者の転送先',
    'HostingSettings.domainSettingsSection.forwardingType.title' => '転送タイプ',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => '恒久的に移動（コード 301）',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'ウェブサイト訪問者を別のサイトへリダイレクトし、リダイレクト先アドレスを訪問者に表示します。このようなリダイレクトでは、サイトの検索ランキングが維持されます。',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => '一時的に移動（コード 302）',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => '検索エンジンに一時サイトをインデックスさせたくない時に、ウェブサイト訪問者を一時サイトコピーへリダイレクトします。',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'フレーム転送',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'ウェブサイトの訪問者を他のサイトへリダイレクトしますが、転送先のアドレスは表示しません。 そのため、訪問者は転送されていることを把握できまません。',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => '優先ドメイン',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'なし',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'ドキュメントルート',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'このウェブサイトにウェブアプリケーションがインストールされているため、ドキュメントルートを変更できません',
    'HostingSettings.domainSettingsSection.save' => '保存',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'この設定を変更しますか？',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'この設定を変更すると、サーバのセキュリティポリシーに反することになり、パフォーマンスに悪影響を及ぼすか、サーバが攻撃に対して脆弱になります。',
    'HostingSettings.domainSettingsSection.security.buttonChange' => '変更',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => '戻す',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'セキュア設定のプリセットが適用されています',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'セキュリティを強化するために、セキュアプリセット設定を適用してください。なお、特定のパーミッションにより、契約者がこれらの設定を変更できます。ご注意ください。',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'セキュアプリセットを適用する',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'セキュアホスティング設定について',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS サポート',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => '有効',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'ウェブサイトと訪問者のブラウザとの間の接続を暗号化します。',
    'HostingSettings.domainSettingsSection.security.certificate' => '証明書',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'HTTPS を有効化するには、SSL/TLS 証明書をドメインのリポジトリにアップロードしてから、ここで選択してください。',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'SEO フレンドリーな HTTP 301 リダイレクトを介して訪問者を HTTP から HTTPS にリダイレクトする',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'リポジトリに SSL/TLS 証明書がありません。証明書を追加するには、%%link%%に進みます。',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'このページ',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%%（その他のリポジトリ）',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => '未選択',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'ウェブスクリプティング',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'ウェブサーバで解釈すべきプログラミング言語とスクリプティング言語を選択します。',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin ディレクトリの場所：%%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'SSI を *.htm、*.html ファイルで使用',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET バージョン',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'カスタムエラードキュメント',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin ディレクトリの場所：',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'このドメインのドキュメントルート',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'ウェブスペースのルートディレクトリ',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'このドメインの旧スタイルのルート',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'カスタムエラードキュメント',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => '追加の書き込み/変更パーミッション',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy パブリッシング',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'ウェブ統計',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'ツール',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'ウェブ統計へのアクセスを FTP ユーザ名とパスワードで保護する',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => '無効',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'ウェブスペース設定',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP アドレス',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'ディスク容量クォータ',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => '有効',
    'HostingSettings.webspaceSettingsSection.quota.description' => '契約の設定に設定されたディスクスペースクォータ（もしあれば）を超過した場合、ウェブサイトのファイルでの操作を禁止します。',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'サーバのファイルシステムの構成により、ハードディスククォータはサポートされません。',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'システムユーザのクレデンシャル',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'FTP またはファイルマネージャ経由でウェブサイトのファイルとフォルダを管理します。許可される場合、SSH 経由でサーバにアクセスします。',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'FTP またはファイルマネージャ経由でウェブサイトのファイルとフォルダを管理します。許可される場合、リモートデスクトップ経由でサーバにアクセスします。',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'ユーザ名',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'パスワード',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'システムユーザのパスワードを変更するには、ここに新しいパスワードを指定します。',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH アクセス',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'リモートデスクトップアクセス',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => '有効',
    'HostingSettings.webspaceSettingsSection.shell.description' => "システムユーザのログイン情報でサーバにアクセスします。",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'タイプ',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => '無効',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => '{count, plural, other {# 件のドメイン}}用',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => '以下の設定は、{count, plural, other {ウェブスペース {name} の全 # 件のドメイン}}で共通です：',

    'OdbcAdd.title' => 'ODBC DSN を追加',
    'OdbcAdd.nameLabel' => '接続名',
    'OdbcAdd.descriptionLabel' => '接続の説明',
    'OdbcAdd.driver' => 'ドライバ',
    'OdbcAdd.submit' => 'ODBC DSN を作成',

    'OdbcEdit.title' => 'ODBC 接続をセットアップ',
    'OdbcEdit.saveSuccess' => '接続の設定が保存されました。',
    'OdbcEdit.test' => 'テスト接続',
    'OdbcEdit.connectSuccess' => '接続に成功しました',

    'OdbcEdit.excel.driver.label' => 'ドライバ',
    'OdbcEdit.excel.dbq.label' => 'データベースファイルへのパス',
    'OdbcEdit.excel.defaultdir.label' => 'デフォルトデータディレクトリ',
    'OdbcEdit.excel.fil.label' => 'データベースバージョン',
    'OdbcEdit.excel.maxbuffersize.label' => '最大バッファサイズ',
    'OdbcEdit.excel.pagetimeout.label' => 'ページタイムアウト',

    'OdbcEdit.access.driver.label' => 'ドライバ',
    'OdbcEdit.access.dbq.label' => 'データベースファイルへのパス',
    'OdbcEdit.access.uid.label' => 'ログイン名',
    'OdbcEdit.access.pwd.label' => 'パスワード',
    'OdbcEdit.access.pagetimeout.label' => 'ページタイムアウト',
    'OdbcEdit.access.pagetimeout.description' => '未使用のページがバッファに留まる期間を 10 分の 1 秒単位で設定します。このオプションは Microsoft Access Driver を使用しているすべてのデータソースに適用されます。',
    'OdbcEdit.access.maxbuffersize.label' => '最大バッファサイズ',
    'OdbcEdit.access.maxbuffersize.description' => '内部バッファのサイズです。KB 単位で指定し、上限値は 256KB となっています。',
    'OdbcEdit.access.readonly.label' => '読み取り専用',
    'OdbcEdit.access.readonly.description' => 'すべてのアップデートも禁止するためには、データベースを読込専用と指定します。',
    'OdbcEdit.access.exclusive.label' => '排他的',
    'OdbcEdit.access.exclusive.description' => 'シェアアップデートを禁止するためには、データベースを排他として指定します。',
    'OdbcEdit.access.safetransactions.label' => '安全なトランザクション',
    'OdbcEdit.access.safetransactions.description' => '0 （デフォルト）に設定すると、すべてのトランザクションは即座にコミットされます。 1 に設定すると、すべてのトランザクションはコミット命令後ディスクに保存されますが、パフォーマンスは確実に低下してしまいます。',
    'OdbcEdit.access.threads.label' => 'スレッド数',
    'OdbcEdit.access.threads.description' => 'エンジンで使用するバックグラウンドスレッド数',
    'OdbcEdit.access.maxscanrows.label' => 'スキャンする最大行数',
    'OdbcEdit.access.maxscanrows.description' => '既存のデータに基づいて列のデータタイプを設定する際にスキャンする行数',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'トランザクションの外部でデータベースへの書き込みが実行された場合どのように変更するかを指定します。',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'MS Access ドライバが明示的にユーザ定義のトランザクションを非同期的に取り扱うかを指定します。',

    'OdbcEdit.mssql.driver.label' => 'ドライバ',
    'OdbcEdit.mssql.server.label' => 'サーバ',
    'OdbcEdit.mssql.uid.label' => 'ログイン名',
    'OdbcEdit.mssql.pwd.label' => 'パスワード',
    'OdbcEdit.mssql.database.label' => 'デフォルトデータベース',
    'OdbcEdit.mssql.app.label' => 'アプリケーション名',
    'OdbcEdit.mssql.wsid.label' => 'ワークステーション ID',
    'OdbcEdit.mssql.language.label' => 'デフォルト言語',
    'OdbcEdit.mssql.oemtoansi.label' => '拡張文字を OEM 値に変換',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC ドライバ',
    'OdbcEdit.mysql.server.label' => 'サーバ',
    'OdbcEdit.mysql.server.description' => 'MySQL サーバのホスト名',
    'OdbcEdit.mysql.database.label' => 'デフォルトデータベース',
    'OdbcEdit.mysql.user.label' => 'ユーザ名',
    'OdbcEdit.mysql.user.description' => 'MySQL に接続するためのユーザ名',
    'OdbcEdit.mysql.password.label' => 'パスワード',
    'OdbcEdit.mysql.password.description' => 'サーバ上のユーザアカウントのパスワード',
    'OdbcEdit.mysql.port.label' => 'ポート',
    'OdbcEdit.mysql.port.description' => 'サーバがローカルホストでは無い場合に使用する TCP/IP ポート',
    'OdbcEdit.mysql.socket.label' => 'ソケット',
    'OdbcEdit.mysql.socket.description' => 'サーバがローカルホストの場合、Windows の名前付きパイプに接続します。',
    'OdbcEdit.mysql.option.label' => 'オプション',
    'OdbcEdit.mysql.option.description' => 'MyODBC を動作させるためのオプションを設定します。 詳細は<a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">ドキュメント</a>を参照してください',

    'ProtectedDirectoryList.title' => '%%domainName%% の保護ディレクトリ',
    'ProtectedDirectoryList.add' => '保護ディレクトリを追加',
    'ProtectedDirectoryList.addTooltip' => '保護ディレクトリを作成します。',
    'ProtectedDirectoryList.name' => '名前',
    'ProtectedDirectoryList.realmTitle' => '保護エリアのタイトル',
    'ProtectedDirectoryList.noSelectionText' => '削除するアイテムを 1 つ以上選択してください。',
    'ProtectedDirectoryList.edit' => '編集',
    'ProtectedDirectoryList.remove' => '保護を解除',
    'ProtectedDirectoryList.removeTooltip' => '選択したディレクトリから保護を削除します。',
    'ProtectedDirectoryList.removeConfirmation' => 'この操作により、{count, plural, =1 {the {name} directory} other {選択された # 件のディレクトリ}}で保護が解除され、{count, plural, =1 {This directory} other {このディレクトリ}}はインターネットユーザが自由にアクセスできるようになります。',
    'ProtectedDirectoryList.removeSuccess' => '選択されたディレクトリは削除されました。',

    'ProtectedDirectoryAdd.title' => '保護ディレクトリを作成します',
    'ProtectedDirectoryAdd.submit' => '作成',
    'ProtectedDirectoryAdd.success' => '保護ディレクトリ %%path%% を作成しました',

    'ProtectedDirectoryEdit.title' => '保護ディレクトリ設定',
    'ProtectedDirectoryEdit.success' => '保護ディレクトリの設定を変更しました',

    'SummaryReport.Layout.title' => 'レポートレイアウトプロパティ',
    'SummaryReport.Layout.success' => 'レポートレイアウト %%name%% がアップデートされました。',

    'SummaryReport.Layout.Add.title' => 'レポートレイアウトの作成',
    'SummaryReport.Layout.Add.success' => 'レポートレイアウト %%name%% が作成されました。',
];