<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Capaian ditolak. Akaun anda digantung.",
    'login_up__login_has_been_locked' => "Anda mencuba untuk menelog masuk menggunakan kata laluan yang salah banyak kali. Atas sebab keselamatan, anda tidak boleh untuk mengelog masuk di bawah nama pengguna ini untuk seketika.",
    'login_up__unable_to_check_pass' => "Kata laluan tidak boleh disemak: %1",
    'login_up__warning_limits_licence_key' => "Satu daripada item berikut telah melebihi had yang ditentukan oleh kunci lesen anda: jumlah akaun pengguna, domain, akaun mel atau pengehosan pengguna web pada pelayan anda.\nSila hubungi jabatan jualan Plesk untuk membeli kunci yang akan membenarkan anda mengehos jumlah pengguna dan domain yang dikehendaki. Sila hubungi jabatan sokongan teknikal Plesk jika anda merasakan anda telah tersalah menerima mesej ini.\nHad lesen untuk akaun pengguna/domain/akaun mel/pengguna web/pek bahasa: %2.\nBilangan akaun pengguna/domain/akaun mel/pengguna web/pek bahasa yang dihoskan pada masa ini: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Anda beroperasi dengan jumlah sumber yang melebihi had yang ditentukan oleh lesen produk semasa anda. Sila hubungi jabatan jualan Plesk dan beli kunci lesen yang baharu.",
    'login_up__grace_period' => 'Anda sekarang beroperasi di dalam tempoh ihsan lesen produk anda. Untuk mengemas kini lesen produk anda, pilih opsyen Kunci Dapatkan Semula pada %1halaman Maklumat Lesen%2.',
    'login_up__partner_license_message' => 'Anda sekarang beroperasi dengan lesen produk yang terhad yang memerlukan pendaftaran sebelum mengaktifkan set ciri yang penuh. Untuk mengemas kini lesen produk anda, pilih opsyen Kunci Dapatkan Semula pada %1halaman Maklumat Lesen%2.',
    'login_up__system_admin_disabled' => 'Superpengguna (akar atau akaun pentadbir) dilarang melog masuk ke Plesk atas sebab keselamatan.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Panduan Pentadbir Plesk",
    'plesk_guide_reseller' => "Panduan Penjual Semula Plesk",
    'plesk_guide_client' => "Panduan Pelanggan Plesk",
    'plesk_guide_domain_admin' => "Panduan Pentadbir Domain Plesk",
    'plesk_guide_mailuser' => "Panduan Pengguna E-mel Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Carian', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Pelanggan',
    'ui__reseller_unknown__quick-search' => 'Penjual semula',
    'ui__client/domain_unknown__quick-search' => 'Domain',
    'nav__general' => 'Menu Utama',
    '__home' => 'Laman Utama',
    '__resellers' => 'Penjual semula',
    '__clients' => 'Pelanggan',
    '__domains' => 'Domain',
    '__applications' => 'Aplikasi',
    '__settings' => 'Tetapan',
    'nav__system' => 'Sistem',
    '__master' => 'Induk',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Aras Atas',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Alih keluar',
    'bt_make_default' => 'Jadikan Lalai',

    // common list object operation errors
    'class_cList__empty_selection' => 'Tiada objek yang terpilih.',

    // common list object search keys
    'clist__search_show' => 'Tayangan Carian',
    'clist__search_hide' => 'Sembunyikan Carian',

    'bt_show_all' => "Tetap Semula Carian",

    // common object list info keys
    'clist__first' => 'Pertama',
    'clist__last' => 'Terakhir',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Halaman',
    'clist__page_size' => 'Entri bagi setiap halaman',
    'clist__info' => 'Jumlah %1: %4',
    'clist__info_empty' => 'No %1',
    'clist__info_filter' => '%5 %1 dijumpai (jumlah %4)',
    'clist__info_paging' => '%2-%3 %1 daripada jumlah %4',
    'clist__info_paging_filter' => '%2-%3 %1 daripada %5 dijumpai (jumlah %4)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktif',
    '__object_off' => 'Digantung',

    '__home_description' => 'Kembali kepada laman Utama.',
    'indicator_title' => '%1% digunakan, %2% bebas', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Permintaan URL yang tidak sah.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Akaun penjual semula",
    'ui__reseller_unknown__title' => "Akaun penjual semula",
    'ui__reseller_unknown__description' => "Urus akaun penjual semula",
    'ui__reseller/client_unknown__short-title' => 'Akaun Pelanggan',
    'ui__reseller/client_unknown__title' => 'Akaun Pelanggan',
    'ui__reseller/client_unknown__description' => 'Urus akaun pelanggan.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Akaun pentadbir tambahan", // PFW
    'ui__admin-alias_unknown__short-title' => "Akaun pentadbir tambahan", // PFW
    'ui__admin-alias_unknown__description' => "Papar dan urus akaun pentadbir tambahan.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Tetapan mel lebar pelayan",
    'ui__server/mail__title' => "Tetapan mel lebar pelayan",
    'ui__server/mail__description' => "Setkan pelayan mel dan konfigurasikan tetapan mel lebar pelayan.",
    'ui__server/dns__short-title' => 'Tetapan DNS',
    'ui__server/dns__title' => 'Tetapan DNS',
    'ui__server/dns__description' => 'Semak semula dan kemas kini tetapan DNS lebar pelayan.',
    'ui__server/services__title' => 'Pengurusan Perkhidmatan',
    'ui__server/services__description' => 'Mulakan, hentikan atau mulakan semula perkhidmatan Plesk.',
    'ui__server/crontab/task_unknown__short-title' => 'Tugas yang Dijadualkan',
    'ui__server/crontab/task_unknown__title' => 'Tugas yang Dijadualkan',
    'ui__server/crontab/task_unknown__description' => 'Tambah atau alih keluar tugas dijadual lebar pelayan.',
    'ui__server/ip-address_unknown__short-title' => 'Alamat IP',
    'ui__server/ip-address_unknown__title' => 'Alamat IP',
    'ui__server/ip-address_unknown__description' => 'Papar, tambah dan alih keluar alamat IP, Tetapkan alamat IP kepada penjual semula.',
    // dropdowns
    'ui__server/time__title' => 'Masa sistem',
    'ui__server/time__short-title' => 'Masa sistem',
    'ui__server/time__description' => 'Tukar tarikh dan masa sistem, setkan penyegerakkan dengan pelayan NTP.',
    'ui__server/maillists__title' => 'Sediakan pelayan senarai mel', // PFU
    'ui__server/maillists__short-title' => 'Sediakan pelayan senarai mel', // PFU
    'ui__server/maillists__description' => 'Sediakan lelaki Mel senarai mel pelayan.', // PFU
    'ui__mass-email__short-title' => "Mesej e-mel massa", // PFW
    'ui__mass-email__title' => "Mesej e-mel massa", // PFW
    'ui__mass-email__description' => "Hantar mesej e-mel secara serentak kepada beberapa pengguna.", // PFW
    'ui__mass-mail__title' => 'Mesej e-mel massa', // PFU
    'ui__mass-mail__short-title' => 'Mesej e-mel massa', // PFU
    'ui__mass-mail__description' => 'Hantar mesej e-mel secara serentak kepada beberapa pengguna.', // PFU
    'ui__server/spam-filter__title' => 'Tetapan penapis spam',
    'ui__server/spam-filter__short-title' => 'Tetapan penapis spam',
    'ui__server/spam-filter__description' => 'Setkan tapisan spam lebar pelayan.',
    'ui__server/preferences__title' => "Tetapan pelayan",
    'ui__server/preferences__short-title' => "Tetapan pelayan",
    'ui__server/preferences__description' => "Setkan kiraan statistik lebar pelayan, tukar nama hos pelayan dan tetapan pelayan yang lain.",

    // help & support
    // icons
    'ui__support__short-title' => 'Sokongan',
    'ui__support__title' => 'Sokongan',
    'ui__support__description' => 'Serahkan permintaan untuk sokongan teknikal atau semak semula tiket yang dibuat oleh pelanggan anda.',
    'ui__license__short-title' => 'Maklumat Lesen',
    'ui__license__title' => 'Maklumat Lesen Plesk',
    'ui__license__description' => 'Paparkan maklumat tentang lesen Plesk anda dan pesan kunci lesen yang baharu.',
    'ui__help__short-title' => 'Bantuan',
    'ui__help__title' => 'Bantuan dalam talian',
    'ui__help__description' => 'Paparkan bantuan dalam talian.',
    'ui__news__short-title' => "Apa yang baru",
    'ui__news__title' => "Apa yang baru",
    'ui__news__description' => "Lihat senarai bagi perubahan dalam versi Plesk ini.",
    'ui__server/autoinstaller__short-title' => 'Kemas kini',
    'ui__server/autoinstaller__title' => 'Kemas kini',
    'ui__server/autoinstaller__description' => 'Kemas kini Plesk dan komponennya.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domain',
    'ui__client/domain_unknown__title' => 'Domain',
    'ui__client/domain_unknown__description' => 'Urus domain.',
    'ui__server/skeleton__short-title' => 'Templat Hos Maya',
    'ui__server/skeleton__title' => 'Templat Hos Maya',
    'ui__server/skeleton__description' => 'Tentukan fail dan folder yang sepatutnya ditempatkan di dalam direktori bagi domain yang baharu dicipta.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Tetapkan pemilik yang baharu untuk langganan',
    'ui__client/domain/chowner_multi-select__short-title' => 'Tetapkan pemilik langganan yang baharu',
    'ui__client/domain/chowner_multi-select__description' => 'Tetapkan pemilik yang baharu untuk langganan yang terpilih',
    'ui__client/domain/disable_multi__title' => 'Gantung domain',
    'ui__client/domain/disable_multi__short-title' => 'Gantung domain',
    'ui__client/domain/disable_multi__description' => 'Gantung domain yang terpilih',
    'ui__client/domain/enable_multi__title' => 'Aktifkan domain',
    'ui__client/domain/enable_multi__short-title' => 'Aktifkan domain',
    'ui__client/domain/enable_multi__description' => 'Aktifkan domain yang terpilih',

    // icons
    'ui__admin/extras-domain__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Alatan daripada MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'Tetapan ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Tetapan ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Konfigurasikan tetapan ASP.NET lebar pelayan.', // PFW
    'ui__server/sitebuilder__short-title' => 'Tetapan Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Tetapan Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Setkan Presence Builder untuk mengedit tapak web yang dihoskan pelayan ini.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Daftar Domain',
    'ui__admin/register-domain__short-title' => 'Daftar Domain',
    'ui__admin/register-domain__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Urus Domain',
    'ui__admin/manage-domain__short-title' => 'Urus Domain',
    'ui__admin/manage-domain__description' => 'Urus nama domain yang didaftarkan melalui MyPlesk.com.',
    'ui__server/register__title' => 'Daftarkan pelayan anda',
    'ui__server/register__short-title' => 'Daftarkan pelayan',
    'ui__server/register__description' => 'Daftarkan pelayan anda untuk menyertai atur cara ahli gabungan',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Log tindakan',
    'ui__actionlog__title' => 'Log tindakan',
    'ui__actionlog__description' => 'Muat turun log tindakan dan menguruskan tetapan log tindakan.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Pelayan Maklumat',
    'ui__server/statistics__title' => 'Pelayan Maklumat',
    'ui__server/statistics__description' => 'Statistik pada perkhidmatan yang diuruskan oleh Plesk.',
    'ui__admin/report__title' => 'Laporan Ringkasan',
    'ui__admin/report__short-title' => 'Laporan Ringkasan',
    'ui__admin/report__description' => 'Paparkan laporan penggunaan trafik dan sumber untuk penjual semula, pelanggan dan domain.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Sesi Masa Melahu',
    'ui__sessions/properties__title' => 'Sesi Masa Melahu',
    'ui__sessions/properties__description' => 'Setkan sesi masa melahu untuk sesi Plesk.',
    'ui__cp-access__short-title' => 'Akses ke Plesk',
    'ui__cp-access__title' => 'Akses ke Plesk',
    'ui__cp-access__description' => 'Capaian terhad pada Plesk',
    'ui__sessions__short-title' => 'Sesi Aktif',
    'ui__sessions__title' => 'Sesi Aktif',
    'ui__sessions__description' => 'Paparkan sesi Plesk yang aktif.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Sijil SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Sijil SSL/TLS',
    'ui__server/certificate_unknown__description' => 'Senarai sijil SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Data Peribadi',
    'ui__admin-info__title' => 'Data Peribadi',
    'ui__admin-info__description' => 'Tukar data peribadi untuk akaun anda.',
    'ui__admin-password__short-title' => 'Tukar kata laluan',
    'ui__admin-password__title' => 'Tukar kata laluan',
    'ui__admin-password__description' => 'Tukar kata laluan untuk akaun anda.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Direktori terlindung kata laluan',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Direktori terlindung kata laluan',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Capaian terlindung pada kawasan tapak web yang terpilih.',
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Direktori Maya', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Direktori Maya', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Bekerja dengan fail fizikal dan maya, dibawah direktori tapak web.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Penggunaan Sumber',
    'ui__reseller/limits__title' => 'Penggunaan Sumber',
    'ui__reseller/limits__description' => 'Paparkan dan uruskan penggunaan sumber bagi penjual semula %1.',
    'ui__reseller/limits_unknown__short-title' => 'Penggunaan Sumber',
    'ui__reseller/limits_unknown__title' => 'Penggunaan Sumber',
    'ui__reseller/limits_unknown__description' => 'Paparkan dan uruskan penggunaan sumber bagi penjual semula.',
    'ui__reseller/limits_self__short-title' => 'Penggunaan Sumber',
    'ui__reseller/limits_self__title' => 'Penggunaan Sumber',
    'ui__reseller/limits_self__description' => "Paparkan dan uruskan penggunaan sumber anda.",
    'ui__reseller/limits_readonly-self__short-title' => 'Penggunaan Sumber',
    'ui__reseller/limits_readonly-self__title' => 'Penggunaan Sumber',
    'ui__reseller/limits_readonly-self__description' => "Paparkan penggunaan sumber anda.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Penggunaan Trafik oleh Pelanggan',
    'ui__reseller/client/traffic_unknown__title' => 'Paparkan Penggunaan Trafik mengikut Pelanggan',
    'ui__reseller/client/traffic_unknown__description' => 'Paparkan laporan penggunaan trafik untuk akaun pelanggan.',
    'ui__client/traffic_unknown__short-title' => "Penggunaan Trafik oleh Pelanggan", // temporary for presets
    'ui__client/traffic_unknown__title' => "Paparkan penggunaan trafik mengikut pelanggan", // temporary for presets
    'ui__client/traffic_unknown__description' => "Paparkan laporan penggunaan trafik untuk akaun pelanggan.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Pengurus Log',
    'ui__client/domain/hosting/logs_unknown__title' => 'Pengurus Log',
    'ui__client/domain/hosting/logs_unknown__description' => 'Paparkan log dan konfigurasikan putaran log.',
    // dropdowns
    'ui__reseller/report__title' => 'Laporan ringkasan',
    'ui__reseller/report__short-title' => 'Laporan ringkasan',
    'ui__reseller/report__description' => 'Paparkan laporan tentang penggunaan trafik dan sumber untuk penjual semula ini.',
    'ui__reseller/report_unknown__title' => 'Laporan ringkasan',
    'ui__reseller/report_unknown__short-title' => 'Laporan ringkasan',
    'ui__reseller/report_unknown__description' => 'Paparkan laporan tentang penggunaan trafik dan sumber untuk penjual semula.',
    'ui__reseller/report_self__title' => 'Laporan ringkasan',
    'ui__reseller/report_self__short-title' => 'Laporan ringkasan',
    'ui__reseller/report_self__description' => 'Paparkan laporan tentang penggunaan trafik dan sumber anda.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Penjenamaan Plesk',
    'ui__client/logo_reseller__short-title' => 'Penjenamaan Plesk',
    'ui__client/logo_reseller__description' => 'Penjenamaan semula Plesk untuk penjual semula %1.',
    'ui__client/logo_unknown__title' => 'Penjenamaan Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Penjenamaan Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Penjenamaan semula Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Penjenamaan Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Penjenamaan Plesk',
    'ui__client/logo_self-reseller__description' => 'Penjenamaan semula Plesk anda.',
    'ui__reseller/permissions__title' => 'Kebenaran',
    'ui__reseller/permissions__short-title' => 'Kebenaran',
    'ui__reseller/permissions__description' => "Paparkan atau tukarkan tindakan yang boleh dilaksanakan oleh penjual semula %1 dalam Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Kebenaran',
    'ui__reseller/permissions_unknown__title' => 'Kebenaran',
    'ui__reseller/permissions_unknown__description' => "Paparkan atau tukarkan tindakan yang boleh dilaksanakan oleh penjual semula dalam Plesk.",
    'ui__reseller/permissions_self__title' => 'Kebenaran',
    'ui__reseller/permissions_self__short-title' => 'Kebenaran',
    'ui__reseller/permissions_self__description' => 'Paparkan senarai tindakan yang boleh laksanakan dalam Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Kebenaran',
    'ui__reseller/permissions_readonly-self__short-title' => 'Kebenaran',
    'ui__reseller/permissions_readonly-self__description' => 'Paparkan senarai tindakan yang boleh laksanakan dalam Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Templat Hos Maya',
    'ui__client/skeleton__short-title' => 'Templat Hos Maya',
    'ui__client/skeleton__description' => 'Tentukan fail dan folder yang sepatutnya ditempatkan di dalam direktori bagi domain yang baharu dicipta.',
    'ui__client/skeleton_unknown__short-title' => 'Templat Hos Maya',
    'ui__client/skeleton_unknown__title' => 'Templat Hos Maya',
    'ui__client/skeleton_unknown__description' => 'Tentukan fail dan folder yang sepatutnya ditempatkan di dalam direktori bagi domain yang baharu dicipta.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Alias domain',
    'ui__client/domain/domain-alias_unknown__title' => 'Alias domain',
    'ui__client/domain/domain-alias_unknown__description' => 'Paparkan senarai nama alternatif untuk domain anda.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Tetapan DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_unknown__description' => 'Uruskan tetapan zon DNS untuk domain.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Paparkan tetapan zon DNS untuk domain.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Alatan daripada MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Alatan daripada MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Alatan daripada MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Daftar Domain',
    'ui__reseller/register-domain__title' => 'Daftar Domain',
    'ui__reseller/register-domain__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Daftar Domain',
    'ui__reseller/register-domain_unknown__title' => 'Daftar Domain',
    'ui__reseller/register-domain_unknown__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Daftar Domain',
    'ui__reseller/register-domain_self__title' => 'Daftar Domain',
    'ui__reseller/register-domain_self__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Urus Domain',
    'ui__reseller/manage-domain__short-title' => 'Urus Domain',
    'ui__reseller/manage-domain__description' => 'Urus nama domain yang didaftarkan melalui MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Urus Domain',
    'ui__reseller/manage-domain_unknown__short-title' => 'Urus Domain',
    'ui__reseller/manage-domain_unknown__description' => 'Urus nama domain yang didaftarkan melalui MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Urus Domain',
    'ui__reseller/manage-domain_self__short-title' => 'Urus Domain',
    'ui__reseller/manage-domain_self__description' => 'Urus nama domain yang didaftarkan melalui MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'Alamat IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'Alamat IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'Urus alamat IP',
    'ui__client/domain/certificate_unknown__short-title' => 'Sijil SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Sijil SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Pasangkan dan uruskan sijil SSL/TLS.',
    'ui__reseller/sessions__short-title' => 'Sesi Aktif',
    'ui__reseller/sessions__title' => 'Sesi Aktif',
    'ui__reseller/sessions__description' => 'Lihat sesi Plesk yang aktif.',
    'ui__reseller/sessions_unknown__short-title' => 'Sesi Aktif',
    'ui__reseller/sessions_unknown__title' => 'Sesi Aktif',
    'ui__reseller/sessions_unknown__description' => 'Paparkan sesi Plesk yang aktif.',
    'ui__reseller/sessions_self__short-title' => 'Sesi Aktif',
    'ui__reseller/sessions_self__title' => 'Sesi Aktif',
    'ui__reseller/sessions_self__description' => 'Paparkan sesi Plesk yang aktif.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Akaun Mel Di Bawah Akaun Pengguna %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Templat Hos Maya',
    'ui__client/skeleton_self__title' => 'Templat Hos Maya',
    'ui__client/skeleton_self__description' => 'Tentukan fail dan folder yang sepatutnya ditempatkan di dalam direktori bagi domain yang baharu dicipta.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Penggunaan sumber',
    'ui__client/limits__title' => 'Penggunaan sumber',
    'ui__client/limits__description' => "Paparkan dan uruskan penggunaan sumber bagi pelanggan %1.",
    'ui__client/limits_unknown__short-title' => 'Penggunaan sumber',
    'ui__client/limits_unknown__title' => 'Penggunaan sumber',
    'ui__client/limits_unknown__description' => 'Paparkan dan uruskan penggunaan sumber bagi pelanggan.',
    'ui__client/limits_readonly__short-title' => 'Penggunaan sumber',
    'ui__client/limits_readonly__title' => 'Penggunaan sumber',
    'ui__client/limits_readonly__description' => 'Paparkan penggunaan sumber bagi pelanggan %1.',
    'ui__client/limits_self__short-title' => 'Penggunaan sumber',
    'ui__client/limits_self__title' => 'Penggunaan sumber',
    'ui__client/limits_self__description' => "Paparkan dan uruskan penggunaan sumber anda.",
    'ui__client/limits_readonly-self__short-title' => 'Penggunaan sumber',
    'ui__client/limits_readonly-self__title' => 'Penggunaan sumber',
    'ui__client/limits_readonly-self__description' => "Paparkan penggunaan sumber anda.",
    'ui__client/domain/traffic_unknown__short-title' => "Penggunaan Trafik mengikut Domain %1",
    'ui__client/domain/traffic_unknown__title' => "Paparkan penggunaan trafik mengikut domain",
    'ui__client/domain/traffic_unknown__description' => "Paparkan laporan penggunaan trafik untuk domain.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Laporan ringkasan',
    'ui__client/report__short-title' => 'Laporan ringkasan',
    'ui__client/report__description' => 'Paparkan laporan tentang penggunaan trafik dan sumber untuk pelanggan ini.',
    'ui__client/report_unknown__short-title' => 'Laporan ringkasan',
    'ui__client/report_unknown__title' => 'Laporan ringkasan',
    'ui__client/report_unknown__description' => 'Paparkan laporan tentang penggunaan trafik dan sumber untuk pelanggan.',
    'ui__client/report_self__short-title' => 'Laporan ringkasan',
    'ui__client/report_self__title' => 'Laporan ringkasan',
    'ui__client/report_self__description' => 'Paparkan laporan tentang penggunaan trafik dan sumber.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Keutamaan antara muka',
    'ui__client/preferences__title' => 'Keutamaan antara muka',
    'ui__client/preferences__description' => 'Tetapkan keutamaan antara muka Plesk untuk pelanggan %1.',
    'ui__client/preferences_unknown__short-title' => 'Keutamaan antara muka',
    'ui__client/preferences_unknown__title' => 'Keutamaan antara muka',
    'ui__client/preferences_unknown__description' => "Setkan keutamaan antara muka untuk pelanggan Plesk anda.",
    'ui__client/preferences_self__short-title' => 'Keutamaan antara muka',
    'ui__client/preferences_self__title' => 'Keutamaan antara muka',
    'ui__client/preferences_self__description' => 'Setkan keutamaan antara muka untuk Plesk anda.',
    'ui__client/logo__title' => 'Penjenamaan Plesk',
    'ui__client/logo__short-title' => 'Penjenamaan Plesk',
    'ui__client/logo__description' => "Penjenamaan semula pelanggan %1' Plesk.",
    'ui__client/logo_self__title' => 'Penjenamaan Plesk',
    'ui__client/logo_self__short-title' => 'Penjenamaan Plesk',
    'ui__client/logo_self__description' => 'Penjenamaan semula Plesk, menukar imej logo dan bar tajuk pelayar.',
    'ui__client/permissions__title' => 'Kebenaran',
    'ui__client/permissions__short-title' => 'Kebenaran',
    'ui__client/permissions__description' => "Paparkan atau tukarkan tindakan yang boleh dilaksanakan oleh pelanggan %1 dalam Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Kebenaran',
    'ui__client/permissions_unknown__title' => 'Kebenaran',
    'ui__client/permissions_unknown__description' => "Paparkan atau tukarkan tindakan yang boleh dilaksanakan oleh pelanggan dalam Plesk.",
    'ui__client/permissions_self__title' => 'Kebenaran',
    'ui__client/permissions_self__short-title' => 'Kebenaran',
    'ui__client/permissions_self__description' => "Paparkan senarai tindakan yang boleh laksanakan dalam Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Kebenaran',
    'ui__client/permissions_readonly-self__short-title' => 'Kebenaran',
    'ui__client/permissions_readonly-self__description' => "Paparkan senarai tindakan yang boleh laksanakan dalam Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__client/extras-domain__title' => 'Alatan daripada MyPlesk.com',
    'ui__client/extras-domain__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Alatan daripada MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Alatan daripada MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Daftar Domain',
    'ui__client/register-domain__short-title' => 'Daftar Domain',
    'ui__client/register-domain__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Daftar Domain',
    'ui__client/register-domain_unknown__short-title' => 'Daftar Domain',
    'ui__client/register-domain_unknown__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Daftar Domain',
    'ui__client/register-domain_self__short-title' => 'Daftar Domain',
    'ui__client/register-domain_self__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Urus Domain',
    'ui__client/manage-domain__short-title' => 'Urus Domain',
    'ui__client/manage-domain__description' => 'Urus nama domain yang didaftarkan melalui MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Urus Domain',
    'ui__client/manage-domain_unknown__short-title' => 'Urus Domain',
    'ui__client/manage-domain_unknown__description' => 'Urus nama domain yang didaftarkan melalui MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Urus Domain',
    'ui__client/manage-domain_self__short-title' => 'Urus Domain',
    'ui__client/manage-domain_self__description' => 'Urus nama domain yang didaftarkan melalui MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'Alamat IP',
    'ui__client/ipaddress_unknown__short-title' => "Alamat IP",
    'ui__client/ipaddress_unknown__description' => "Urus alamat IP",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Alias domain',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Alias domain',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Paparkan senarai nama alternatif untuk domain anda.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Sesi Aktif',
    'ui__client/sessions__title' => 'Sesi Aktif',
    'ui__client/sessions__description' => 'Paparkan sesi Plesk yang aktif.',
    'ui__client/sessions_unknown__short-title' => 'Sesi Aktif',
    'ui__client/sessions_unknown__title' => 'Sesi Aktif',
    'ui__client/sessions_unknown__description' => 'Paparkan sesi Plesk yang aktif.',
    'ui__client/sessions_self__short-title' => 'Sesi Aktif',
    'ui__client/sessions_self__title' => 'Sesi Aktif',
    'ui__client/sessions_self__description' => 'Paparkan sesi Plesk yang aktif.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/protected-directories__short-title' => 'Direktori terlindung kata laluan',
    'ui__client/domain/hosting/protected-directories__title' => 'Direktori terlindung kata laluan',
    'ui__client/domain/hosting/protected-directories__description' => 'Capaian terlindung pada kawasan tapak web yang terpilih.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Direktori terlindung-kata laluan',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Direktori terlindung-kata laluan',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Capaian terlindung pada kawasan tapak web yang terpilih.',
    'ui__client/domain/hosting/web-directories__title' => 'Direktori Maya', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Direktori Maya', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Bekerja dengan fail fizikal dan maya, dibawah direktori tapak %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Direktori Maya', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Direktori Maya', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Bekerja dengan fail fizikal dan maya, dibawah direktori tapak web anda.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 Penggunaan trafik',
    'ui__client/domain/traffic__title' => 'Statistik Pemindahan Data untuk <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Paparkan statistik pindahan data untuk domain %1.',
    'ui__client/domain/traffic_self__short-title' => 'Penggunaan trafik',
    'ui__client/domain/traffic_self__title' => 'Paparkan penggunaan trafik untuk domain anda.',
    'ui__client/domain/traffic_self__description' => 'Paparkan penggunaan trafik untuk domain anda.',
    'ui__client/domain/hosting/logs__short-title' => 'Pengurus log',
    'ui__client/domain/hosting/logs__title' => 'Pengurus log',
    'ui__client/domain/hosting/logs__description' => 'Paparkan log dan konfigurasikan putaran log.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Pengurus log',
    'ui__client/domain/hosting/logs_self__title' => 'Pengurus log',
    'ui__client/domain/hosting/logs_self__description' => 'Paparkan log dan konfigurasikan putaran log.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Namakan semula domain',
    'ui__client/domain/rename__short-title' => 'Namakan semula domain',
    'ui__client/domain/rename__description' => 'Namakan semula domain %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Namakan semula domain',
    'ui__client/domain/rename_unknown__title' => 'Namakan semula domain',
    'ui__client/domain/rename_unknown__description' => 'Namakan semula domain',
    'ui__client/domain/chowner_select__title' => 'Tetapkan pemilik yang baharu untuk domain',
    'ui__client/domain/chowner_select__short-title' => 'Tetapkan pemilik yang baharu untuk langganan',
    'ui__client/domain/chowner_select__description' => 'Tetapkan pemilik yang baharu untuk langganan ini',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Tetapkan Pemilik yang Baharu untuk Langganan',
    'ui__client/domain/chowner_unknown-select__title' => 'Tetapkan Pemilik yang Baharu untuk Langganan',
    'ui__client/domain/chowner_unknown-select__description' => 'Tetapkan pemilik yang baharu untuk langganan.',
    'ui__client/domain/toggle__title' => 'Domain Digantung atau Diaktifkan', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Domain Digantung atau Diaktifkan', // for HP customization
    'ui__client/domain/toggle__description' => 'Gantung atau aktifkan domain %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Domain Digantung atau Diaktifkan', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Domain Digantung atau Diaktifkan', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Domain digantung atau diaktifkan.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Aktifkan Domain',
    'ui__client/domain/toggle_enable__short-title' => 'Aktifkan Domain',
    'ui__client/domain/toggle_enable__description' => 'Aktifkan domain %1.',
    'ui__client/domain/toggle_disable__title' => 'Gantung Domain',
    'ui__client/domain/toggle_disable__short-title' => 'Gantung Domain',
    'ui__client/domain/toggle_disable__description' => 'Gantung domain %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Tetapan DNS',
    'ui__client/domain/dns__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns__description' => 'Uruskan tetapan zon DNS untuk domain %1.',
    'ui__client/domain/dns_self__title' => 'Tetapan DNS',
    'ui__client/domain/dns_self__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_self__description' => 'Uruskan tetapan zon DNS untuk domain anda.',
    'ui__client/domain/dns_disabled__title' => 'Tetapan DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_disabled__description' => 'Uruskan tetapan zon DNS untuk domain %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Tetapan DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Uruskan tetapan zon DNS untuk domain anda.',
    'ui__client/domain/dns_readonly__title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly__description' => 'Paparkan tetapan zon DNS untuk domain %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Paparkan tetapan zon DNS untuk domain anda.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Paparkan tetapan zon DNS untuk domain anda.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Paparkan tetapan zon DNS untuk domain anda.',
    'ui__client/domain/dns_slave__title' => 'Tetapan DNS',
    'ui__client/domain/dns_slave__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_slave__description' => 'Uruskan tetapan zon DNS untuk domain %1.',
    'ui__client/domain/dns_self-slave__title' => 'Tetapan DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Tetapan DNS',
    'ui__client/domain/dns_self-slave__description' => 'Uruskan tetapan zon DNS untuk domain anda.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__client/domain/extras__title' => 'Alatan daripada MyPlesk.com',
    'ui__client/domain/extras__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Alatan daripada MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Alatan daripada MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Alatan daripada MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Dapatkan alat dan khidmat tambahan daripada MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Daftar domain',
    'ui__client/domain/register__title' => 'Daftar domain',
    'ui__client/domain/register__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Daftar domain',
    'ui__client/domain/register_unknown__title' => 'Daftar domain',
    'ui__client/domain/register_unknown__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Daftar domain',
    'ui__client/domain/register_self__title' => 'Daftar domain',
    'ui__client/domain/register_self__description' => 'Daftarkan nama domain yang melalui MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Alat",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Lihat statistik',
    'ui__client/domain-summary-report_unknown__title' => 'Lihat statistik',
    'ui__client/domain-summary-report_unknown__description' => 'Paparkan maklumat tentang penggunaan sumber mengikut domain.',
    'ui__client/domain-summary-report__short-title' => "Lihat statistik",
    'ui__client/domain-summary-report__title' => "Lihat statistik",
    'ui__client/domain-summary-report__description' => "Paparkan maklumat tentang penggunaan sumber mengikut domain.",
    'ui__client/domain-summary-report_self__short-title' => "Lihat statistik",
    'ui__client/domain-summary-report_self__title' => "Lihat statistik",
    'ui__client/domain-summary-report_self__description' => "Paparkan maklumat tentang penggunaan sumber mengikut domain anda.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domain", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Anda mesti memilih domain yang mahu dialih keluar',
    'ui__client/domain/chowner__empty_selection' => 'Anda harus memilih domain yang hendak ditetapkan pada pemilik yang baharu',

    // list objects filtering
    'domains_list__name__filter_title' => 'Nama',
    'domains_list__state__filter_title' => 'Penggunaan Sumber',
    'domains_list__filter_state_any' => 'Sebarang',
    'domains_list__filter_state_overuse' => 'Lebih guna',
    'domains_list__filter_state_normal' => 'Dalam had',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Sebarang',
    'domains_list__filter_status_blocked' => 'Digantung',
    'domains_list__filter_status_active' => 'Aktif',
    'domains_list__ownership__filter_title' => 'Pemilikan',
    'domains_list__filter_ownership_all' => 'Semua domain',
    'domains_list__filter_ownership_personal' => 'Hanya domain saya',
    'domains_list__filter_owner_pname__filter_title' => 'Nama Pemilik',
    'domains_list__subrows__filter_title' => 'Tunjukkan',
    'domains_list__subrows_off' => 'Domain sahaja',
    'domains_list__subrows_subdomain_domainaliases' => 'Dengan subdomain dan alias',
    'domains_list__subrows_subdomain' => 'Dengan subdomain',
    'domains_list__subrows_domainaliases' => 'Dengan alias',

    // objects list
    'domains_list__owner__title' => 'Pemilik',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Semak lalu untuk aplikasi",
    'site_apps__promo_main_text' => "Katalog Piawai Pembungkusan Aplikasi (APS) mengandungi senarai aplikasi yang diperuntukkan kepada domain atau ruang web. Jika anda mahu memperuntukkan aplikasi semasa yang tiada dalam katalog, cuma ikut arahan pembungkusan APS yang mudah pada www.apsstandard.com",
    'site_apps__promo_download_now' => "Muat turun Aplikasi:",
    'site_apps__promo_close' => "Tutup sekatan ini",
    'site_apps__promo_preset__mostused' => '%1 Paling Popular',
    'site_apps__promo_preset__lessused' => 'Seterusnya %1 Paling Popular',
    'site_apps__promo_preset__all' => "Semua",
    'site_apps__promo_disclaimer_note' => 'Perhatian bahawa Plesk tidak menyokong aplikasi yang dipasang daripada Katalog APS yang disediakan oleh pihak ketiga.',
    'site_apps__promo_preset__page_title' => '%1 Aplikasi APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Menambah aplikasi...',

    // Errors
    'site_apps__no_applications_for_update' => 'Anda tidak mempunyai pemasangan aplikasi dalam Vault Aplikasi.',
    'site_apps__incorrect_download_preset_configuration' => 'Ralat dalam praset muat turun konfigurasi Katalog APS telah dijumpai.',
    'site_apps__aps_catalog_url_is_invalid' => 'URL yang ditentukan tidak sah.',
    'site_apps__no_updates_at_the_moment' => 'Tiada kemas kini aplikasi yang tersedia pada masa ini.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Katalog aplikasi APS menghantar maklumat yang salah. Sila cuba lagi kemudian.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Tetapan katalog APS telah disimpan tetapi sambungan tidak dapat diwujudkan oleh Plesk kepada katalog APS yang ditentukan pada tetapan katalog APS (%1). Pastikan alamat katalog APS adalah betul dan aktif.',
    'site_apps__cannot_retrieve_updates' => 'Kemas kini aplikasi tidak boleh dimuat turun sekarang: sambungan pada katalog APS (%1) tidak dapat diwujudkan. Pastikan alamat katalog APS adalah betul dan aktif.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Tiada aplikasi web yang tersedia untuk pemasangan.',
    'site_apps__site_applications_already_installed_in_root' => 'Aplikasi web yang lain sudah dipasang dalam direktori akar bagi hos maya ini.',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Aplikasi web .NET tidak disokong pada platform Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Tidak menyokong aplikasi web lebar pelayan',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 lebih banyak jadual pada aplikasi web untuk tambahan kepada Vault Aplikasi.",
    'site_apps__applications_all_in_vault' => "Aplikasi web yang terpilih telah hadir di Vault Aplikasi.",
    'site_apps__applications_already_in_download_queue' => "%1 Aplikasi web yang terpilih sedang ditambah pada Vault Aplikasi sekarang.",
    'site_apps__applications_already_in_valut' => "%1 aplikasi web yang terpilih telah berada di Vault Aplikasi.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Yang lain (tidak dikategorikan)',

    // Errors
    'site_apps__no_applications_in_category' => 'Dalam kategori ini, tiada aplikasi yang tersedia. Sila pilih kategori yang lain.',
    'site_apps__no_category_selected__please_specify' => 'Pilih kategori di dalam menu sebelah kiri. Semua aplikasi yang tersedia di dalam kategori yang terpilih akan disenaraikan dalam tetingkap ini.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Akaun pentadbir',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Umum',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Tukar nama hos',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Keselamatan',
    'bt_setup_firewall' => 'Setkan tembok api',
    'bt_manage_firewall_rules' => 'Urus peraturan tembok api',
    'cu_firewall__rule' => 'Cipta peraturan tembok api',
    'cu_firewall__protocol' => 'Setkan protokol untuk peraturan (\'tcp\' atau \'udp\')',
    'cu_firewall__name' => "Setkan nama peraturan",
    'cu_firewall__disabled' => 'Jika \'benar\', menyahdayakan peraturan selepas dicipta',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Pilih pelayan DNS', // PFW
    'bt_soa_records_template' => 'Templat rekod SOA',
    'bt_restrict_creation_of_subzones' => 'Ciptaan subzon dihadkan',

    'databases' => 'Pangkalan Data',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Aplikasi',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Mel',
    'bt_select_mailserver' => 'Pilih pelayan mel', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Pilih antivirus', // PFW
    'bt_virus_protection_settings' => 'Tetapan perlindungan virus',
    'bt_select_spamfilter' => 'Pilih penapis spam', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Pilih Mel web',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Log & statistik',
    'bt_server_statistics_settings' => 'Tetapan statistik pelayan',
    'bt_select_web_statistics' => 'Perisian statistik web yang tersedia', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Antara muka Plesk',

    'components_and_modules' => 'Komponen & modul',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Setkan Pengawas', // PFU
    'bt_setup_vpn' => 'Setkan VPN', // PFU
    'bt_setup_samba' => 'Setkan samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Tetapan',
    'ui__client/domain/settings_self__short-title' => 'Tetapan',
    'ui__client/domain/settings_self__description' => 'Papar dan tukar tetapan domain.',

    'domain_administrator_account' => 'Akaun pentadbir domain',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Tetapan akaun',

    'domain' => 'Domain',
    'bt_dns_soa_records' => 'Rekod SOA DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Tetapan penjadual tugas',

    'website' => 'Laman Web',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Menskrip untuk pengguna web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Pilih sijil SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Statistik web',
    'bt_log_rotation_settings' => 'Tetapan putaran log',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Had", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Dasar lebih guna dan lebihan jualan",
    'limits__overuse_policy_legend' => "Lebih guna",
    'limits__oversell_policy_legend' => "Menjual berlebihan",
    'limits__reseller_overuse_description' => "Dasar lebih guna memberitahu apa yang perlu dilakukan oleh Plesk apabila sumber digunakan berlebihan.",
    'limits__overuse_text' => "Dasar lebih guna",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Ruang cakera dan trafik',
    'limit__disk_space' => 'Ruang cakera',
    'limit__max_traffic' => 'Trafik',
    'limit_group__client' => 'Pelanggan',
    'limit__max_cl' => 'Pelanggan',
    'limit_group__domain' => 'Domain',
    'limit__max_dom' => 'Domain',
    'limit__max_dom_powerUser' => 'Langganan',
    'limit__max_subdom' => 'Subdomain',
    'limit__max_dom_aliases' => 'Alias domain',
    'limit__max_wu' => 'Pengguna web',
    'limit__max_subftp_users' => 'Akaun FTP tambahan', // PFW
    'limit_group__mail' => 'Mel',
    'limit__max_box' => 'Peti mel',
    'limit__mbox_quota' => 'Saiz peti mel',
    'limit__total_mboxes_quota' => 'Jumlah kuota peti mel', // PFW
    'limit__max_maillists' => 'Senarai Mel',
    'limit_group__database' => 'Pangkalan Data',
    'limit__max_mssql_db' => 'Pengkalan data Pelayan SQL Microsoft', // PFW
    'limit__mssql_dbase_space' => 'Jumlah kuota pangkalan data MS SQL', // PFW
    'limit__max_odbc' => 'Sambungan ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Kuota pangkalan data MySQL', // PFW?
    'limit_group__application' => 'Aplikasi',
    'limit__max_iis_app_pools' => 'Himpunan aplikasi IIS', // PFW
    'limit_group__security' => 'Keselamatan',
    'limit_group__validity' => 'Tarikh tamat tempoh',
    'limit__expiration' => 'Tarikh tamat tempoh',
    'limit__validity' => 'Tempoh sah',
    'limit__max_site_builder' => 'Tapak yang diterbitkan dengan Presence Builder',
    'limit__max_site' => 'Domain',
    'limit__mssql_dbase_filesize' => 'Saiz fail pangkalan data MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Saiz fail log pangkalan data MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Saiz fail maksimum bagi pangkalan data SQL Microsoft.',
    'limit__mssql_dbase_log_filesize_hint' => 'Saiz fail log maksimum bagi pangkalan data SQL Microsoft.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Had domain tidak sah. Nilai minimum ialah 1.',

    'property__has_wrong_value' => 'Sifat %1 mempunyai nilai yang salah.',
    'property__name_outgoing_messages_domain_limit' => 'Setkan pengehadan pada mesej keluar daripada domain (per jam). Untuk mengeset nilai tanpa had, nyatakan "-1". Nyatakan "lalai" untuk mengeset nilai yang ditentukan dalam tetapan lebar pelayan.',
    'property__name_outgoing_messages_mbox_limit' => 'Setkan pengehadan pada mesej keluar daripada peti mel (per jam). Untuk mengeset nilai tanpa had, nyatakan "-1". Nyatakan "lalai" untuk mengeset nilai yang ditentukan dalam tetapan lebar pelayan.',
    'property__name_outgoing_messages_subscription_limit' => 'Setkan pengehadan pada mesej keluar daripada langganan (per jam). Untuk mengeset nilai tanpa had, nyatakan "-1". Nyatakan "lalai" untuk mengeset nilai yang ditentukan dalam tetapan lebar pelayan.',

    // for CLI report & email notifications
    '__resource_notify' => 'Beritahu',
    '__general' => 'Umum',
    '__template_shared' => 'Templat dikongsi',
    'limit__overuse' => 'Dasar lebih guna',
    'limit__max_traffic_soft' => 'Beritahu bila penggunaan trafik mencapai',
    'limit__disk_space_soft' => 'Beritahu bila penggunaan ruang cakera mencapai',
    '__overuse' => 'Dasar lebih guna',
    'performance__title' => 'Prestasi',
    'performance__bandwidth' => 'Penggunaan lebar jalur maksimum (KB/s)',
    'performance__max_connections' => 'Sambungan terhad kepada',

    'gch__hosting_php_isapi' => 'Jalankan PHP sebagai sambungan ISAPI',
    'gch__hosting_ssi_html' => 'Gunakan SSI untuk fail *.htm, *.html',
    'gch__hosting_php_handler_type' => 'jalankan PHP sebagai',
    'gch__hosting_php_handler_id' => 'jalankan PHP sebagai',
    'gch__hosting_php_served_by_nginx' => 'PHP dikendalikan oleh nginx',
    'gch__hosting_unpaid_website_status' => 'Status tapak web dalam langganan yang digantung',
    'gch__mn_no_autoresponder' => 'Tiada persediaan auto-balas untuk akaun mel.',
    'gch__no_clients_selected' => "Tiada akaun pelanggan yang terpilih",
    'gch__no_domains_selected' => "Tiada domain yang terpilih",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/bulan",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nama sumber',
    '__resource_usage' => 'Digunakan',
    '__resource_limit' => 'Had',

    '__used' => 'Digunakan',
    '__limit' => 'Had',

    '__never_expires' => 'Tidak akan tamat tempoh',
    '__resource_free' => '%1 bebas dari %2',
    '__resource_unlimited' => '%1 digunakan bagi Tanpa had',

    '__unlimited' => 'Tidak terhad',
    '__increment' => "Naikkan (+)",
    '__decrement' => "Menurun (-)",
    '__pt' => 'unit',
    '__procent' => '%',
    '__overused' => 'Menggunakan berlebihan',
    '__left' => 'tinggal',
    '__available' => 'tersedia',
    '__not_available' => 'Tidak termasuk',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Jadual Penghantaran',
    'ui__admin/report/layout/auto_unknown__title' => 'Jadual Penghantaran Laporan',
    'ui__admin/report/layout/auto_unknown__description' => 'Pilih jadual penghantaran laporan untuk tataletak laporan.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Tambah Jadual Penghantaran Laporan',
    'ui__admin/report/layout/auto/properties_new__title' => 'Tambah Jadual Penghantaran Laporan',
    'ui__admin/report/layout/auto/properties_new__description' => 'Tambah jadual penghantaran laporan untuk laporan %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Jadual Penghantaran Laporan',
    'ui__admin/report/layout/auto/properties__title' => 'Jadual Penghantaran Laporan',
    'ui__admin/report/layout/auto/properties__description' => 'Papar dan ubahsuai sifat bagi jadual penghantaran laporan.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Alih keluar Jadual Penghantaran Laporan',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Alih keluar Jadual Penghantaran Laporan',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Alih keluar jadual penghantaran laporan yang terpilih.',

    'ui__admin/report/layout_unknown__short-title' => 'Tataletak Laporan',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Lihat Penggunaan Trafik untuk <b>%1</b>',
    'ui__reseller/traffic__description' => 'Paparkan laporan penggunaan trafik untuk akaun penjual semula %1.',
    'ui__reseller/traffic_self__short-title' => 'Saya',
    'ui__reseller/traffic_self__title' => 'Paparkan Penggunaan Trafik mengikut Pelanggan',
    'ui__reseller/traffic_self__description' => 'Paparkan laporan penggunaan trafik untuk akaun pelanggan anda.',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Nama penjual semula', // reseller report
    'report__full_client_name' => 'Nama pelanggan', // customer report
    'report__full_domain_name' => 'Nama domain', // domain report
    'report__full_owner' => 'Pemilik', // customer & domain reports
    'report__full_creation_date' => 'Tarikh ciptaan',
    'report__full_size' => 'Saiz',
    'report__full_traffic' => 'Trafik',
    'report__full_active_clients' => 'Pelanggan aktif', // reseller report
    'report__full_clients' => 'Pelanggan', // reseller report
    'report__full_active_domains' => 'Domain aktif', // reseller & customer reports
    'report__full_domains' => 'Domain', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Peti M',
    'report__full_disk_space' => 'Ruang cakera',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'ResponsBalas',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'Senarai mel',
    'report__full_web_users' => 'Pengguna web',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => 'Umum',
    'report__version' => 'Versi produk',
    'report__build' => 'Binaan produk',
    'report__status' => 'Status',
    'report__company_name' => 'Nama syarikat',
    'report__personal_name' => 'Nama peribadi',
    'report__login' => 'Nama pengguna',
    'report__phone' => 'Telefon',
    'report__fax' => 'Faks',
    'report__email' => 'E-mel',
    'report__address' => 'Alamat',
    'report__city' => 'Bandar',
    'report__state' => 'Negeri/wilayah',
    'report__zip_code' => 'Poskod/kod ZIP',
    'report__country' => 'Negara',
    'report__creation_date' => 'Tarikh ciptaan',
    'report__expiration_date' => 'Tarikh tamat tempoh',
    'report__dumps_total_size' => 'Jumlah saiz fail sandaran',
    'report__section_resellers' => 'Penjual semula',
    'report__active_resellers' => 'Penjual semula dengan langganan aktif',
    'report__resellers' => 'Penjual semula',
    'report__section_full_resellers' => 'Penjual semula',
    'report__section_clients' => 'Pelanggan',
    'report__active_clients' => 'Pelanggan dengan langganan aktif',
    'report__clients' => 'Pelanggan',
    'report__section_full_clients' => 'Pelanggan',
    'report__section_personal_clients' => 'Pelanggan sendiri',
    'report__active_personal_clients' => 'Pelanggan anda dengan langganan aktif',
    'report__personal_clients' => 'Pelanggan sendiri',
    'report__section_full_personal_clients' => 'Pelanggan sendiri',
    'report__section_domains' => 'Domain',
    'report__disk_usage' => 'Penggunaan cakera',
    'report__traffic' => 'Trafik',
    'report__active_domains' => 'Domain aktif',
    'report__domains' => 'Domain',
    'report__subdomains' => 'Subdomain',
    'report__mboxes' => 'Peti mel',
    'report__mail_groups' => 'Pemajuan mel',
    'report__mail_autoresp' => 'Auto-balas',
    'report__mail_lists' => 'Senarai Mel',
    'report__web_users' => 'Pengguna web',
    'report__mysql_databases' => 'Pangkalan data MySQL',
    'report__mssql_databases' => 'Pengkalan data MSSQL',
    'report__section_full_domains' => 'Domain',
    'report__section_personal_domains' => 'Domain peribadi',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Domain peribadi',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Tapak yang diterbitkan dengan Presence Builder',
    'report__invalid_email' => 'Sila tentukan alamat e-mel yang sah.',


    // CLI-specific sections
    'report__section_hosting' => 'Pengehosan',
    'report__section_webusers' => 'Pengguna Web',
    'report__section_mailnames' => 'Akaun Mel',
    'report__section_maillists' => 'Senarai Mel',
    'report__section_databases' => 'Pangkalan Data',
    'report__section_siteapps' => 'Aplikasi Web',
    'report__section_aspnetapps' => 'Aplikasi ASP.NET', // PFW
    'report__owner_pname' => "Nama peribadi pembekal",
    'report__owner_login' => "Nama pengguna pembekal",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Jadual Penghantaran',
    'ui__reseller/report/layout/auto_unknown__title' => 'Jadual Penghantaran Laporan',
    'ui__reseller/report/layout/auto_unknown__description' => 'Pilih jadual penghantaran laporan untuk tataletak laporan.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Tambah Jadual Penghantaran Laporan',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Tambah Jadual Penghantaran Laporan',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Tambah jadual penghantaran laporan untuk laporan %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Jadual Penghantaran Laporan',
    'ui__reseller/report/layout/auto/properties__title' => 'Jadual Penghantaran Laporan',
    'ui__reseller/report/layout/auto/properties__description' => 'Papar dan ubahsuai sifat bagi jadual penghantaran laporan.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Alih keluar Jadual Penghantaran Laporan',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Alih keluar Jadual Penghantaran Laporan',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Alih keluar jadual penghantaran laporan yang terpilih.',

    'ui__reseller/report/layout_unknown__short-title' => 'Tataletak Laporan',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Lihat Penggunaan Trafik untuk <b>%1</b>',
    'ui__client/traffic__description' => 'Paparkan laporan penggunaan trafik untuk akaun pelanggan %1.',
    'ui__client/traffic_self__short-title' => 'Penggunaan Trafik',
    'ui__client/traffic_self__title' => 'Penggunaan Trafik oleh Domain',
    'ui__client/traffic_self__description' => 'Paparkan penggunaan trafik untuk domain anda.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Bungkusan bahasa yang ditentukan telah dipasang tetapi tidak didayakan dalam sistem.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Padam Sesi',
    'ui__sessions/delete__title' => 'Padam Sesi',
    'ui__sessions/delete__description' => 'Padamkan sesi yang terpilih.',
    'ui__ftp-sessions__short-title' => 'Sesi FTP',
    'ui__ftp-sessions__title' => 'Sesi FTP',
    'ui__ftp-sessions__description' => 'Paparkan sesi FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Padamkan Sesi FTP',
    'ui__ftp-sessions/delete__title' => 'Padamkan Sesi FTP',
    'ui__ftp-sessions/delete__description' => 'Padamkan sesi FTP yang terpilih.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Padam Sesi',
    'ui__reseller/sessions/delete__title' => 'Padam Sesi',
    'ui__reseller/sessions/delete__description' => 'Padamkan sesi yang terpilih.',
    'ui__reseller/sessions/delete_self__short-title' => 'Padam Sesi',
    'ui__reseller/sessions/delete_self__title' => 'Padam Sesi',
    'ui__reseller/sessions/delete_self__description' => 'Padamkan sesi yang terpilih.',
    'ui__reseller/ftp-sessions__short-title' => 'Sesi FTP',
    'ui__reseller/ftp-sessions__title' => 'Sesi FTP',
    'ui__reseller/ftp-sessions__description' => 'Paparkan sesi FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Sesi FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Sesi FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Paparkan sesi FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Padamkan Sesi FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Padamkan Sesi FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Padamkan sesi FTP yang terpilih.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Padamkan Sesi FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Padamkan Sesi FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Padamkan sesi FTP yang terpilih.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Padam Sesi',
    'ui__client/sessions/delete__title' => 'Padam Sesi',
    'ui__client/sessions/delete__description' => 'Padamkan sesi yang terpilih.',
    'ui__client/sessions/delete_self__short-title' => 'Padam Sesi',
    'ui__client/sessions/delete_self__title' => 'Padam Sesi',
    'ui__client/sessions/delete_self__description' => 'Padamkan sesi yang terpilih.',

    // domain administrator

    'forgery_token_expired' => 'Token sesi telah tamat tempoh.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Akaun penjual semula yang berikut yang akan ditukar kepada akaun pelanggan',
    'downgradeResellers__downgrade' => 'Akaun penjual semula yang akan ditukarkan',
    // controls
    'downgradeResellers__submit_downgrade' => 'Laksanakan penukaran akaun.',
    'downgradeResellers__cancel_downgrade' => 'Batalkan penukaran akaun.',
    'downgradeResellers__confirm' => 'Sahkan penukaran',
    'downgradeResellers__confirm_message' => 'Sahkan penukaran akaun untuk meneruskan',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Pilih Akaun Pelanggan',
    'upgradeClients__upgrade_clients' => 'Akaun pelanggan yang berikut yang akan ditukar kepada akaun penjual semula',
    'upgradeClients__upgrade' => 'Akaun pelanggan yang akan ditukarkan',
    // controls
    'upgradeClients__submit_upgrade' => 'Laksanakan penukaran akaun.',
    'upgradeClients__cancel_upgrade' => 'Batalkan penukaran akaun.',
    'upgradeClients__confirm' => 'Sahkan penukaran',
    'upgradeClients__confirm_message' => 'Sahkan penukaran akaun untuk meneruskan',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Akaun \'%1\' tidak boleh ditukarkan kepada akaun penjual semula: \'%1\' telah menjadi penjual semula.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Akaun pentadbir yang berikut akan ditukarkan kepada akaun pelanggan',
    'upgradeDomainUser__upgrade' => 'Akaun pentadbir domain yang akan ditukarkan',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Laksanakan penukaran akaun.',
    'upgradeDomainUser__cancel_upgrade' => 'Batalkan penukaran akaun.',
    'upgradeDomainUser__confirm' => 'Sahkan penukaran',
    'upgradeDomainUser__confirm_message' => 'Sahkan penukaran akaun untuk meneruskan',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Akaun pentadbir domain tidak boleh ditukarkan',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Akaun pentadbir yang berikut tidak sepatutnya ditukarkan kepada akaun pelanggan:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Beberapa akaun pentadbir tidak sepatutnya ditukarkan kepada akaun pelanggan. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Akaun pentadbir domain tidak wujud',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Domain sepatutnya secara terus kepunyaan pentadbir pelayan atau penjual semula.",
    'upgradeDomainUser__all_logins_already_used' => 'Akaun tidak boleh dicipta untuk pelanggan yang terhasil.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Akaun pentadbir domain ditukar',
    'upgradeDomainUser__upgrade_notification_body' => 'Akaun pentadbir domain anda ditukarkan kepada akaun pelanggan dengan nama pengguna\'%%login%%\' dan kata laluan \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Pilih Akaun Pelanggan',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Penjual semula yang terpilih tidak mempunyai kebenaran \'%1\' tetapi beberapa pelanggan mempunyai keizinan ini.',
    'clientOwnerChanger__application_not_allowed' => 'Aplikasi \'%1\' tidak tersedia kepada penjual semula yang terpilih tetapi kepada beberapa pelanggan.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Menetapkan semula Langganan yang Terpilih',
    // errors
    'domain_chown__empty_selection' => 'Anda harus memilih pemilik baharu untuk domain yang terpilih',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Penggunaan lebar jalur maksimum (%1)',
    'hosting_performance__max_connection_label' => 'Sambungan terhad kepada',
    'performance__invalid_value' => "Nilai tidak sah. Mestilah diantara julat dari %1 ke %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Mel web',
    'webmail__server_text' => 'Pelanggan mel web yang tersedia',
    'webmail__none' => 'Tiada',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Himpunan IP Pelayan',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Pengkalan data tidak akan dipulihkan: tiada pelayan pengkalan data yang sesuai',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Sandaran pelayan.",
    '__default_backup_comment_reseller' => "Sandaran akaun penjual semula dicipta oleh %1.",
    '__default_backup_comment_client' => "Sandaran akaun pelanggan dicipta oleh %1.",
    '__default_backup_comment_domain' => "Sandaran akaun langganan dicipta oleh %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'Tentukan Pemetaan Alamat IP',
    'backup__ip_mapping__download' => 'Simpan Pemetaan IP Semasa ke Fail',
    'b_backup__ip_mapping__download' => 'Klik untuk memuat turun konfigurasi pemetaan IP.',
    'b_backup__ip_mapping__download_is_empty' => 'Konfigurasi pemetaan IP kosong.',
    'backup__ip_mapping_upload__title' => 'Muat Naik Fail Pemetaan IP',
    'backup__ip_mapping__upload' => 'Muat Naik Fail Pemetaan IP',
    'b_backup__ip_mapping__upload' => 'Klik untuk memuat naik konfigurasi pemetaan IP.',
    'backup__ip_mapping__list__header' => 'Pemetaan IP',
    'backup__ip_mapping__list__adddress' => 'Alamat IP Lama',
    'backup__ip_mapping__list__select_ip' => 'Alamat IP Baharu',
    'backup__ip_mapping__clients_ip' => "Himpunan IP pelanggan %1",
    'backup__ip_mapping__resellers_ip' => "Himpunan IP penjual semula %1",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Alamat IP yang khusus haruslah dipetakan kepada alamat IP yang unik. Pilih alamat IP unik untuk alamat IP yang khusus di dalam senarai.',
    'backup__ip_mapping__legend' => 'Pemetaan IP',
    'backup__ip_mapping__upload_legend' => 'Muat naik',
    'backup__ip_mapping__upload_file_text' => 'Fail pemetaan IP',
    'backup__ip_mapping__upload_file_hint' => 'Fail pemetaan IP ialah fail teks biasa. Setiap garisan fail ini mengandungi pemetaan IP dalam format yang berikut: <alamat IP lama> <alamat IP baharu>',
    'backup__ip_mapping__ip_address_not_found' => 'Tidak terdapat alamat IP yang kosong jenis ini.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'Pindahan data tidak boleh dilakukan: Pemetaan alamat IP tidak lengkap kerana tidak terdapat alamat IP yang kosong di dalam himpunan pada pelayan di destinasi.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Sambungan FTP tidak selamat akan dilarang untuk domain yang mempunyai alamat IP ini.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Sambungan FTPS selamat akan dilarang untuk domain yang mempunyai alamat IP ini.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Konflik',
    'backup__restore__object_vhost' => 'Hos maya',
    'backup__restore__object_plesk_admin' => 'Pentadbir Plesk',
    'backup__restore__object_ftpuser' => 'Akaun FTP',
    'backup__restore__object_frontpageuser' => 'Akaun Frontpage',
    'backup__restore__object_webuser' => 'pengguna web',
    'backup__restore__object_domain' => 'domain',
    'backup__restore__object_subdomain' => 'subdomain',
    'backup__restore__object_domainalias' => 'alias domain',
    'backup__restore__object_client' => 'pelanggan',
    'backup__restore__object_reseller' => 'penjual semula',
    'backup__restore__object_autoresponder' => 'auto-balas',
    'backup__restore__object_mailalias' => 'alias mel',
    'backup__restore__object_database' => 'pangkalan data',
    'backup__restore__object_mailname' => 'akaun mel',
    'backup__restore__object_db_user' => 'pengguna pengkalan data',
    'backup__restore__object_ssl_certificate' => 'Sijil SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Tidak dapat memulihkan penjual semula yang berikut kerana mereka telah ditukar kepada pelanggan: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Tidak dapat memulihkan pelanggan yang berikut kerana mereka telah ditukar kepada penjual semula: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Tidak dapat memulihkan pelanggan yang berikut kerana mereka telah dipindahkan kepada pemilik yang lain: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Ruang cakera tidak mencukupi pada pelayan destinasi untuk memindahkan semua langganan yang terpilih. Tersedia: %1 MB. Diperlukan: %2 MB. Perhatian bahawa ruang yang diperlukan dikira sebagai jumlah kandungan domain web, mel dan pengkalan data. Ruang yang diperlukan dikira sehari sekali dan disimpan di dalam cache, saiz sebenar domain mungkin berbeza daripada saiz yang dikira. Jika anda pastikan domain yang terpilih tidak mengambil lebih ruang daripada yang tersedia, pemindahan boleh diteruskan.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Sila kosongkan ruang cakera pada pelayan destinasi.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Ruang cakera tidak mencukupi pada pelayan sumber untuk menyimpan fail sementara untuk pemindahan. Tersedia: %1 MB. Diperlukan: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Sila kosongkan ruang cakera pada pelayan sumber.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Maklumat pelayan',

    'backup__restore__capability_not_installed_component_text' => 'Komponen %1 tidak dipasang pada pelayan destinasi. %1 tidak tersedia untuk semua objek yang dipulihkan.',
    'backup__restore__capability_not_installed_component_resolution' => 'Sila pasang %1. Ambil perhatian yang ini akan memakan masa beberapa minit.',
    'backup__restore__capability_existing_sys_user_text' => 'Pengguna sistem dengan nama %1 sudah wujud pada pelayan destinasi.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Sila namakan semula pengguna sistem yang sedia ada pada pelayan destinasi.',
    'backup__restore__capability_license_usage_text' => 'Pengehadan sumber yang berikut (tertakrif oleh kunci lesen) akan melebihi selepas pemindahan pada pelayan destinasi:',
    'backup__restore__capability_license_usage_resolution' => 'Sila pasangkan kunci lesen lain yang akan menyediakan jumlah ciri-ciri sumber pada pelayan destinasi.',
    'backup__restore__capability_max_allowed_packet_text' => "Parameter 'max_allowed_packet' pada pelayan pengkalan data sumber ialah %1, yang lebih besar daripada yang ada pada pelayan destinasi iaitu bernilai %2. Untuk domain yang di tentukan di bawah, beberapa objek pengkalan data mungkin tidak akan dipulihkan.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Sila tambah nilai 'max_allowed_packet' pada pelayan pengkalan data destinasi.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Tidak boleh untuk memindahkan pengkalan data PostSQL kerana versi PostSQL pada pelayan destinasi adalah lebih awal daripada versi pelayan sumber. Versi semasa ialah %1, versi yang diperlukan ialah %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Sila pasang versi PostgreSQL yang diperlukan pada pelayan destinasi.',
    'backup__restore__capability_db_server_connection_problems' => 'Tidak boleh untuk menyambung kepada pelayan pengkalan data PostgreSQL destinasi. Pengkalan data tidak akan dipindahkan kecuali anda memulihkan sambungan.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Sila semak tetapan sambungan pada pelayan pengkalan data destinasi.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Komponen %1 dimatikan pada pelayan destinasi.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Sila hidupkan %1 pada pelayan destinasi.',
    'backup__restore__capability_not_configured_component_text' => 'Komponen %1 tidak dikonfigurasikan pada pelayan destinasi.',
    'backup__restore__capability_not_configured_component_resolution' => 'Sila konfigurasikan %1 pada Alat & Halaman Tetapan.',

    'backup__restore__capability_webmail_is_not_available' => '%1 perkihmatan mel web tidak terdapat pada pelayan destinasi. Sebaliknya, Plesk akan menggunakan perkhidmatan mel web yang berikut: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Untuk gunakan mel web yang sama seperti pada pelayan sumber, anda hendaklah memasangkannya pada pelayan ini.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Untuk gunakan mel web yang sama seperti pada pelayan sumber, pemasangan harus dibuat pada pelayan destinasi.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "'%1' mel web tidak tersedia pada pelayan destinasi. Sebaliknya, pada langganan yang berikut: %3, Plesk akan gunakan perkhidmatan mel web yang berikut: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Sila pasang mel web yang diperlukan pada pelayan destinasi anda.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Tetapan mel web',

    'backup__restore__capability_shell_is_not_available' => 'Cangkerang %1 tidak tersedia pada pelayan destinasi. Salah satu daripada cangkerang yang tersedia akan digunakan.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Untuk menggunakan cangkerang yang sama seperti yang terdapat pada pelayan sumber, anda harus hidupkan (in /etc/shells) atau pasangkannya pada pelayan destinasi.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Pelayan destinasi DNS tidak menyokong rangkaian dalam Templat Pembatasan Pindahan. Rekod dengan alamat IP dalam pembatasan pindahan DNS tidak akan dipulihkan.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Pelayan destinasi DNS tidak menyokong rangkaian dalam Templat Pembatasan Pindahan tetapi beberapa langganan mempunyai rangkaian dalam pembatasan pindahan DNS. Rekod dengan alamat IP dalam pembatasan pindahan DNS tidak akan dipulihkan.',

    'backup__restore__capability_wrong_php_handler_text' => 'Penggendali PHP %1 tidak tersedia pada pelayan destinasi. Sebaliknya, Plesk akan menggunakan penggendali PHP yang berikut: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Untuk menggunakan penggendali PHP yang sama seperti pada pelayan sumber, hidupkannya atau pasangkannya pada pelayan destinasi.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Pengendali PHP %1 tidak tersedia. Sebaliknya, Plesk akan menggunakan %2 untuk pelan perkhidmatan berikut: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Pengendali PHP %1 tidak tersedia. Sebaliknya, Plesk akan menggunakan %2 untuk tapak web berikut: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Pengendali PHP %1 tidak tersedia. Pengendali ini tidak akan tersedia untuk tapak web berikut: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 tidak terdapat pada pelayan destinasi. Sebaliknya, versi lalai akan digunakan.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Untuk menggunakan %1 yang sama seperti pada pelayan sumber, hidupkannya atau pasangkannya pada pelayan destinasi.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Dasar penggunaan antivirus pada pelayan destinasi tidak membenarkan tetapan antivirus peribadi (bagi setiap alamat e-mel) untuk mel keluar. Tetapan ini tidak akan dipindahkan.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Dasar penggunaan antivirus pada pelayan destinasi tidak membenarkan tetapan antivirus peribadi (bagi setiap alamat e-mel) untuk mel masuk. Tetapan ini tidak akan dipindahkan.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Dasar penggunaan antivirus pada pelayan destinasi tidak membenarkan tetapan antivirus peribadi (bagi setiap alamat e-mel). Tetapan ini tidak akan dipindahkan.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Untuk memindahkan tetapan antivirus peribadi (bagi setiap alamat e-mel), hidupkan pilihan yang berkaitan dalam Alat & Tetapan > Tetapan Perlindungan Virus.",
    'backup__restore__capability_antivirus_not_active_text' => 'Tiada perisian antivirus yang dihidupkan. Semua tetapan antivirus daripada pelayan sumber tidak akan bekerja sehingga anda memilih perisian antivirus pada pelayan destinasi.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Sila pilih perisian antivirus dalam Alat & Tetapan > Tetapan Perlindungan Virus > Seksyen tetapan antivirus.',

    'backup__restore__capability_antivirus_another_active_text' => 'Perisian antivirus %2 tidak terdapat pada pelayan destinasi. %1 sebaliknya akan digunakan.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Untuk menggunakan antivirus pada pelayan sumber, sila pasangkan dan pilihnya di dalam Alat & Tetapan > Tetapan Perlindungan Virus > Seksyen tetapan antivirus.',
    'backup__restore__capability_not_available_sni_text' => 'SNI tidak tersedia pada pelayan destinasi. Tapak web yang mempunyai alamat IP yang sama tidak boleh menggunakan sijil SSL/TLS individu.',
    'backup__restore__capability_not_available_sni_resolution' => "Sila semak sistem operasi pada pelayan destinasi menyokong SNI dan sokongan untuk SNI dihidupkan dalam Plesk (kotak semak 'Hidupkan sokongan SNI, yang membenarkan penggunaan sijil SSL/TLS individu pada tapak web dengan alamat IP yang sama' dalam Alat & Tetapan> Tetapan Pelayan).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Tetapan pelayan',

    'backup__restore__capability_vhost_already_exists_text' => 'Tapak web %1 tidak boleh dipindahkan: tapak web dengan nama yang sama sudah wujud pada pelayan destinasi.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Sila namakan semula atau alih keluar tapak web yang mempunyai sama nama daripada pelayan.',
    'backup__restore__capability_removed_vhosts' => 'Langganan yang berikut tidak akan dipulihkan kerana mengandungi nama domain yang sudah wujud pada pelayan destinasi: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Terdapat %3 penggendali PHP yang berbeza untuk jenis %1 dan versi %2 pada pelayan sumber.Selain daripada mereka, satu penggendali jenis yang sesuai dan versi yang akan digunakan pada pelayan destinasi. Ambil perhatian bahawa kemungkinan perbezaan tetapan PHP pada pelayan sumber dan destinasi.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Pemasang Plesk tidak menyokong Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Pemasang Plesk tidak menyokong Python. Sila pasang Python secara manual.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Tetapan pelayan mel',

    'backup__restore__capability_ftps_disabled' => 'Menggunakan FTPS selamat dibenarkan pada pelayan sumber tetapi dilarang kepada sasaran. Apl pengguna yang menggunakan FTP mungkin tidak akan bekerja dengan betul.',
    'backup__restore__capability_ftps_required' => 'Menggunakan FTPS tidak selamat dibenarkan pada pelayan sumber tetapi dilarang kepada sasaran. Apl pengguna yang menggunakan FTP mungkin tidak akan bekerja dengan betul.',
    'backup__restore__capability_ftps_policy_resolution' => 'Tukar dasar FTP Selamat dalam Alat & Tetapan > Dasar Keselamatan.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabait dari data akan dikeluarkan daripada pelayan sumber kepada destinasi dalam masa %2 jam.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Untuk pemindahan yang lebih cepat, semak sambungan rangkaian anda diantara pelayan sumber dan destinasi serta selesaikan sebarang isu (jika ada).',
    'backup__restore__too_low_download_speed' => "Kurang daripada 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Untuk pemindahan yang lebih cepat, semak sambungan rangkaian anda diantara pelayan sumber dan destinasi serta selesaikan sebarang isu (jika ada).',
    'backup__restore__capability_zero_download_speed_text' => 'Kelajuan muat turun minimum yang boleh diterima ialah %1 MBps. Kelajuan muat turun diantara pelayan sumber dan destinasi ialah 0 MBps. Ini mungkin disebabkan isu sambungan rangkaian. Pindahan adalah mustahil.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Sila semak sambungan rangkaian anda diantara pelayan sumber dan destinasi serta selesaikan isu.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Kelajuan muat turun minimum yang boleh diterima ialah %2 MBps. Kelajuan muat turun diantara pelayan sumber dan destinasi ialah %1 MBps. Masa pemindahan juga akan bertambah. Pada persekitaran semasa anda, migrasi %3 MB akan mengambil masa %4 jam.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Kelajuan muat turun minimum yang boleh diterima ialah %2 MBps. Kelajuan muat turun diantara pelayan sumber dan destinasi ialah %1 MBps. Masa pemindahan juga akan bertambah.',

    'backup__restore__capability_remote_database_migration' => "Domain yang berikut menggunakan pengkalan data jauh: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Selepas pemindahan jangan mengalih keluar domain daripada pelayan sumber jika versi Plesk pada pelayan sumber adalah lebih awal daripada 11.5! Sebaliknya gantung mereka. Jika anda mengalih keluar domain, pengkalan data akan dibuang daripada pelayan jauh. Nota: Longgokan fail pengkalan data jauh akan disimpan dalam direktori pada pelayan sumber %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Fail sandaran pelayan pengkalan data MySQL yang lebih awal dari 5.1 (%1) mungkin tidak akan dipulihkan pada MySQL 5.1.x kerana mengendalikan aksara Unikod secara berlainan.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Sila baca artikel asas pengetahuan yang berkaitan #136850',

    'backup__restore__capability_courier_not_installed_text' => 'IMAP-Courier tidak dipasang pada pelayan destinasi.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Sila pasang IMAP-Courier dengan menggunakan Pemasang Plesk.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot tidak dipasang pada pelayan destinasi.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Sila pasang Dovecot dengan menggunakan Pemasang Plesk.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Masa pengekalan statik trafik dalam konfigurasi objek yang berikut adalah kurang daripada nilai lebar pelayan pada pelayan destinasi.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Sila tukar nilai lebar pelayan untuk masa pengekalan statik pada pelayan destinasi. Set masa sama dengan atau kurang daripada nilai terkecil dalam konfigurasi domain.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Masa untuk statistik trafik disimpan pada beberapa pelan perkhidmatan ialah kurang dari nilai lebar pelayan (%1). Nilainya akan ditukarkan kepada %1 untuk domain ini.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Masa untuk statistik trafik disimpan pada beberapa pelan perkhidmatan ialah kurang dari nilai lebar pelayan (%1). Nilainya akan ditukar kepada %1 untuk pelan perkhidmatan ini.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Pemetaan alamat IP yang ekslusif kepada yang dikongsi akan menyahdayakan FTP tanpa nama dan HTTPS (melainkan sokongan SNI dihidupkan).',

    'backup__restore__no_postgresql_commands_text' => 'Langganan menggunakan pengkalan data PostgreSQL jauh dan fail sandaran sementaranya tidak boleh dijana kerana perintah pg_dump dan psql hilang pada pelayan sumber.',
    'backup__restore__no_postgresql_commands_resolution' => 'Sila pasangkan sebarang pakej pelanggan PostgreSQL yang menyokong perintah ini.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Modul Apache yang berikut dinyahdayakan pada pelayan destinasi: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Sila dayakan modul ini untuk mengelakkan masalah yang berkemungkinan.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Modul Apache yang berikut tidak dipasang pada pelayan destinasi: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Sila pasang dan dayakan modul ini untuk mengelakkan masalah yang berkemungkinan.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Pengehadan mesej keluar tidak disokong oleh lesen anda. Konfigurasi tetapan yang berkaitan tidak akan dipindahkan.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Sila pasangkan kunci lesen lain yang menyediakan ciri-ciri yang diperlukan pada pelayan destinasi.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Pengehadan mesej keluar telah dimatikan pada pelayan destinasi. Konfigurasi tetapan yang berkaitan tidak akan dipindahkan.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Sila hidupkan pengehadan mesej keluar pada pelayan destinasi.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Tetapan Mel Lebar Pelayan',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Pengehadan mesej keluar daripada peti mel tidak disokong oleh pelayan mel yang digunakan pada pelayan destinasi. Pemindahan tidak akan dilakukan untuk nilai had ini.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Sila tukar pelayan mel kepada yang sama seperti yang digunakan pada pelayan sumber anda.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Tetapan Mel Lebar Pelayan',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Pengehadan mesej keluar daripada domain tidak disokong oleh pelayan mel yang digunakan pada pelayan destinasi. Pemindahan tidak akan dilakukan untuk nilai had ini.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Sila tukar pelayan mel kepada yang sama seperti yang digunakan pada pelayan sumber anda.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Tetapan Mel Lebar Pelayan',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Pengehadan mesej keluar daripada langganan tidak disokong oleh pelayan mel yang digunakan pada pelayan destinasi. Pemindahan tidak akan dilakukan untuk nilai had ini.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Sila tukar pelayan mel kepada yang sama seperti yang digunakan pada pelayan sumber anda.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Tetapan Mel Lebar Pelayan',

    'bu_conflict_resolver_absent_phosting' => 'Fail yang ditentukan tidak boleh dipulihkan kerana pengehosan fizikal untuk memulihkannya tidak wujud. Sila cipta dahulu satu domain dengan pengehosan fizikal dan kemudian mulakan pemulihan sandaran sekali lagi.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Data penjual semula tidak akan dipulihkan kerana pengurusan penjual semula tidak disokong.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Komponen ModSecurity tidak dipasang pada pelayan destinasi.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Sila pasang ModSecurity untuk memastikan tembok api aplikasi web bekerja untuk laman yang dipindahkan. Ambil perhatian yang pemasangan akan memakan masa beberapa minit.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Pasang ModSecurity jika anda mahu pindahkan tetapan tembok api aplikasi web. Ambil perhatian yang pemasangan akan memakan masa beberapa minit.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Komponen ModSecurity tidak dikonfigurasikan pada pelayan destinasi.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Konfigurasikan ModSecurity jika anda mahu menyimpan tembok api aplikasi web yang bekerja untuk laman yang dipindahkan.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Tembok Api Aplikasi Web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity dimatikan pada pelayan destinasi.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktifkan ModSecurity jika anda mahu menyimpan tembok api aplikasi web yang bekerja untuk laman yang dipindahkan.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Tembok Api Aplikasi Web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Komponen ModSecurity tidak dipasang. Tetapan tembok api aplikasi web tidak akan dipulihkan untuk objek yang berikut: {{objek}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Tapak web tidak dapat dipulihkan kerana dimiliki oleh langganan %1 yang tidak dijumpai dalam Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Komponen %1 tidak dipasang pada pelayan destinasi. Tidak terdapat perkhidmatan DNS dan tetapan DNS akan hilang. Semua tapak web pelanggan akan ditutup.',
    'bu_conflict_resolver_dns_not_installed' => 'Perkhidmatan DNS tidak dipasang. Tetapan DNS tidak akan dipulihkan untuk objek yang berikut: {{objek}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Tidak dapat memulihkan langganan yang berikut kerana mereka telah dipindahkan kepada pemilik lain: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Tidak dapat memulihkan langganan yang berikut kerana mereka telah dipindahkan kepada pembekal yang lain: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Tidak dapat untuk mencari utiliti pemulihan Tapak Presence Builder untuk data Tapak Presence Builder. Tapak Presence Builder mungkin tidak dipasang.',
    'backup__restore__capability_renamed_db' => 'Nama pangkalan data "%1" telah digunakan oleh langganan yang lain. Nama pangkalan data yang dipulihkan akan ditukarkan ke "%2".',
    'backup__restore__capability_renamed_db_user' => 'Nama pengguna pangkalan data "%1" telah digunakan oleh langganan yang lain. Nama bagi pengguna pangkalan data yang dipulihkan akan ditukarkan ke "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Pemasang Plesk tidak menyokong Perl. Sila pasang ActiveState Perl secara manual.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% dikendalikan oleh Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% dikendalikan oleh nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Antivirus Kaspersky',
    '__drweb' => 'Antivirus Premium Odin',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Konflik Pemasaan',
    'backup__restore__hint_timing_conflicts' => 'Konflik masa berlaku sama ada apabila objek yang dipulihkan sudah wujud dalam sistem dengan tarikh pengubahsuaian yang lebih baru atau apabila objek yang dipulihkan tidak terdapat dalam sistem.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Gunakan konfigurasi dan data daripada sandaran',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Tulis ganti sepenuhnya konfigurasi objek dan data dalam sistem sekarang dengan konfigurasi dan data daripada fail sandaran. Jika objek yang dipulihkan sekarang kepunyaan pemilik yang lain, objek itu akan dipulihkan di bawah pemilik terdahulu.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Gunakan konfigurasi daripada sistem dan data sekarang daripada sandaran',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Tulis ganti data objek sekarang dengan data daripada fail sandaran tetapi simpan konfigurasi objek dalam sistem sekarang. Jika objek yang dipulihkan sekarang kepunyaan pemilik yang lain, objek itu akan dipulihkan di bawah pemilik sekarang.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'Jangan pulihkan',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'Jangan pulihkan objek yang mempunyai konflik pemasaan.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Konflik Penggunaan Sumber',
    'backup__restore__hint_resource_usage_conflicts' => 'Konflik penggunaan sumber berlaku ketika penggunaan objek sumber yang dipulihkan melebihi had semasa pemulihan.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Benarkan penggunaan berlebihan',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Pulihkan objek dan benarkannya untuk menggunakan sumber yang lebih dari yang disediakan pada mulanya.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Jangan pulihkan',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Jangan pulihkan objek yang mempunyai konflik penggunaan sumber.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Konflik Konfigurasi',
    'backup__restore__hint_configuration_conflicts' => 'Konflik konfigurasi berlaku ketika objek yang dipulihkan mempunyai aplikasi tetapan dan web yang tidak tersedia atau dilarang oleh pelayan semasa atau dasar pemilik objek. Contohnya konflik konfigurasi akan berlaku jika akaun mel yang dipulihkan mempunyai tetapan spam individu sementara dasar lebar pelayan melarang akaun mel dari mempunyai tetapan ini.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatik',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Pulihkan objek dan semua opsyen konflik konfigurasi yang anda dibenarkan untuk menguruskannya akan dihidupkan secara automatik.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Jangan pulihkan',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Jangan pulihkan objek yang mempunyai konflik konfigurasi.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Himpunan aplikasi IIS yang khusus tidak dibenarkan dalam tetapan himpunan aplikasi IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Sila tukar tetapan himpunan aplikasi IIS anda di Alat & Tetapan > Himpunan Aplikasi IIS > Tetapan Global.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Himpunan aplikasi IIS yang dikongsi tidak dibenarkan dalam tetapan himpunan aplikasi IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Sila tukar tetapan himpunan aplikasi IIS anda di Alat & Tetapan > Himpunan Aplikasi IIS > Tetapan Global.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Nama akaun mel POP3/IMAP pendek tidak dibenarkan pada pelayan destinasi.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Nama pendek untuk akaun mel selepas pemulihan data tidak akan tersedia.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Tidak dapat membuka fail log.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Tidak dapat memulihkan langganan %1: telah dikeluarkan daripada akaun anda dan anda tidak mempunyai kebenaran untuk mencipta langganan. Jika anda perlu untuk memulihkannya, sila hubungi pembekal perkhidmatan anda.',

    'backup__error11' => 'Ruang cakera tidak cukup untuk sandaran.',
    'backup__error3011' => 'Sambungan ditolak: Tiada program yang mendengar pada alamat dan port yang ditentukan.',
    'backup__error3012' => 'Sambungan tamat masa.',
    'backup__error3013' => 'Rangkaian tidak boleh dicapai.',
    'backup__error3014' => 'Tiada laluan kepada hos.',
    'backup__error3015' => 'Sambungan gagal.',
    'backup__error3016' => 'Nama hos tidak dapat diselesaikan.',
    'backup__error3017' => 'Nama pengguna atau kata laluan salah.',
    'backup__error3018' => 'Gagal menyambung SSH.',

    'backup__error3110' => 'Tidak boleh disambungan kepada ejen migrasi jauh: Tidak terdapat sambungan kepada hos.',
    'backup__error3111' => 'Ejen migrasi dikunci oleh tugasan migrasi yang gagal atau sedang digunakan oleh proses migrasi yang lain. Sila mulakan semula ejen migrasi pada pelayan sumber.',
    'backup__error3112' => 'Tidak terdapat sambungan kepada hos atau ejen migrasi pada hos sumber tidak berjalan.',
    'backup__error3113' => 'Ejen migrasi tidak dapat digunakan kepada hos Linux. Sila semak sambungan SSH kepada hos sumber.',
    'backup__error3114' => 'Ejen migrasi ini tidak dapat digunakan kepada hos Linux. Gagal menyambung SSH.',
    'backup__error3115' => 'Nama pengguna atau kata laluan salah.',
    'backup__error3116' => 'Pengguna yang ditentukan tidak mempunyai keistimewaan pentadbiran.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Semua konfigurasi dan kandungan',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'Semua konfigurasi dan kandungan kecuali mel',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Hanya konfigurasi mel dan kandungan',

    'dns_t__unable_to_remove_ns_record' => 'Rekod NS tidak boleh dialih keluar daripada templat DNS: Setiap zon DNS mesti mempunyai sekurang-kurangnya satu rekod NS.',
    'dns__unsupported_server_zone_transfer' => 'Tidak boleh untuk memindahkan Templat Sekatan Pemindahan kerana konfigurasi lebar pelayan domain: Alamat rangkaian yang berikut dibenarkan untuk pemindahan zon pada pelayan sumber tetapi alamat ini dilarang oleh Pelayan DNS Microsoft: %1',
    'dns__unsupported_domain_zone_transfer' => 'Tidak boleh untuk memindahkan Templat Sekatan Pemindahan kerana konfigurasi domain: Alamat rangkaian yang berikut dibenarkan untuk pemindahan zon pada beberapa domain tetapi alamat ini dilarang oleh Pelayan DNS Microsoft: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Tentukan Pemetaan Pangkalan Data Pelayan',
    'dbbackup__check_network_settings_failed' => 'Tidak boleh untuk mencapai direktori rangkaian sementara yang dikongsi untuk fail sandaran. Sila semak tetapan direktori rangkaian, nama pengguna dan kata laluan. Ralat: %1',

    'migration_select_exist_db_server' => 'Pilih pelayan pengkalan data destinasi',

    'dbbackup__temp_dir_wrong_value' => 'Nilai yang tidak sah telah ditentukan untuk direktori sementara.',
    'dbbackup__network_temp_dir_wrong_value' => 'Nilai yang tidak sah telah ditentukan untuk direktori rangkaian sementara.',
    'dbbackup__server_backup_not_configured' => 'Tetapan sandaran pengkalan data tidak dikonfigurasikan pada pelayan.',
    'dbbackup__temp_dir' => 'Direktori sementara',
    'dbbackup__temp_dir_hint' => 'Laluan kepada folder fizikal pada pelayan jauh di mana terletaknya pelayan MS SQL. Pelayan MS SQL mesti berupaya untuk mengakses folder ini untuk membaca dan menulis fail sandaran sementara. Sebagai contoh, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Laluan kepada kongsi rangkaian dipetakan ke folder fizikal yang dinyatakan di atas. Plesk akan mengakses folder kongsi untuk fail sandaran dimuat turun dan dimuat naik. Sebagai contoh, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Nama pengguna bagi pengguna rangkaian telah dicipta pada pelayan jauh. Sebagai contoh, ServerName\\UserName. Pengguna mesti mempunyai akses kepada folder kongsi yang ditentukan di atas.',
    'dbbackup__network_password_hint' => 'Kata laluan pengguna rangkaian',

    'dbbackup__success_import_without_dublicate_users' => 'Pengguna yang berikut tidak diimport: %1. Mereka sudah wujud pada pelayan pangkalan data.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Mampatkan fail log",
    'log_rot__log_rot_status' => "Log status putaran",
    'log_rot__log_rot_period' => "Keadaan putaran log",
    'log_rot__log_rot_size' => "ikut saiz",
    'log_rot__log_rot_time' => "ikut masa",
    'log_rot__logrotation_enable' => "Hidupkan putaran log",
    'log_rot__mail' => "Hantar fail log yang telah diproses kepada e-mel",
    'log_rot__max_number_of_logfiles' => "Bilangan maksimum fail log",
    'log_rot__time_period' => "tempoh",
    'log_rot__unable_turn_off' => 'Tidak dapat mematikan putaran log kerana ia dikuatkuasakan di peringkat pelayan',
    'log_rot__unable_set_period' => 'Tidak dapat menetapkan tempoh putaran log yang berbeza daripada \'harian\', kerana ia dikuatkuasakan di peringkat pelayan',
    'log_rot__unable_set_max_log_files' => 'Tidak dapat menetapkan bilangan maksimum fail log yang lebih banyak daripada had seluruh pelayan %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Satu nombor dijangka: %1",
    'actionlog__incorrect_rotation' => "Log parameter putaran yang tidak sah ditentukan: %1",
    'actionlog__unknown_rot_period' => "Tempoh putaran yang tidak diketahui: %1",
    'actionlog__unknown_rot_type' => "Jenis putaran yang tidak diketahui: %1",
    'actionlog__session_preferences' => 'Tetapan sesi',
    // items (PFU schema)
    'actionlog__admin_info' => 'Maklumat pentadbir',
    'actionlog__admin_preferences' => "Pilihan pentadbir",
    'actionlog__service' => 'Perkhidmatan',
    'actionlog__ip_addr' => 'Alamat IP',
    'actionlog__client' => 'Akaun pelanggan',
    'actionlog__client_status' => 'Status akaun pelanggan',
    'actionlog__client_preferences' => "Keutamaan antara muka pelanggan",
    'actionlog__client_ip_pool' => "Himpunan IP pelanggan",
    'actionlog__client_siteapp' => "Himpunan aplikasi web pelanggan",
    'actionlog__client_guid' => "GUID Pelanggan",
    'actionlog__domain' => 'Domain lalai (domain pertama yang ditambah kepada langganan atau langganan)',
    'actionlog__domain_owner' => 'Pemilik langganan',
    'actionlog__domain_plan' => 'Pelan perkhidmatan langganan',
    'actionlog__domain_status' => 'Domain lalai, status',
    'actionlog__domain_dns' => 'Domain lalai, zon DNS',
    'actionlog__subdomain' => 'Subdomain daripada domain lalai',
    'actionlog__domain_alias' => 'Domain lalai, alias',
    'actionlog__domain_alias_dns' => 'Domain lalai, zon alias DNS',
    'actionlog__site' => 'Domain',
    'actionlog__site_status' => 'Status domain',
    'actionlog__site_dns' => 'Zon DNS domain',
    'actionlog__site_guid' => 'GUID Domain',
    'actionlog__site_subdomain' => 'Subdomain',
    'actionlog__site_alias' => 'Alias domain',
    'actionlog__site_alias_dns' => 'Alias domain zon DNS',
    'actionlog__domain_limits' => 'Had langganan',
    'actionlog__domain_limit_size' => 'Had ruang cakera untuk langganan',
    'actionlog__domain_limit_traffic' => 'Had trafik untuk langganan',
    'actionlog__domain_limits_powerUser' => 'Had langganan',
    'actionlog__domain_limit_size_powerUser' => 'Had ruang cakera untuk langganan',
    'actionlog__domain_limit_traffic_powerUser' => 'Had trafik untuk langganan',
    'actionlog__domain_guid' => "Domain lalai, GUID",
    'actionlog__cp_user' => 'Pengguna plesk',
    'actionlog__mailname' => 'Akaun mel',
    'actionlog__maillist' => 'Senarai mel',
    'actionlog__phosting' => 'Tetapan pengehosan',
    'actionlog__forwarding' => 'Standard atau pengehosan pemajuan bingkai',
    'actionlog__webuser' => 'Akaun pengguna web',
    'actionlog__site_application' => 'Aplikasi web',
    'actionlog__license' => 'Kunci lesen',
    'actionlog__additional_license' => 'Kunci lesen tambahan',
    'actionlog__template_domain' => "Pelan perkhidmatan penjual semula",
    'actionlog__template_admin' => "Pelan perkhidmatan pentadbir",
    'actionlog__template_reseller' => 'Pelan penjual semula',
    'actionlog__admin_alias' => 'Akaun pentadbir tambahan', // PFW
    'actionlog__ftpuser' => 'Akaun FTP tambahan', // PFW
    'actionlog__db_server' => 'Pelayan pangkalan data',
    'actionlog__db' => 'Pangkalan Data',
    'actionlog__db_user' => 'Akaun pengguna pengkalan data',
    'actionlog__client_sapppkg_pool' => "Aplikasi web pelanggan", // PFW, not used?
    'actionlog__remote_dns' => 'Status pelayan DNS jauh', // PFW
    'actionlog__reseller' => 'Akaun penjual semula',
    'actionlog__reseller_guid' => 'GUID Penjual semula',
    'actionlog__reseller_ip_pool' => "Himpunan IP penjual semula",
    'actionlog__reseller_limit_size' => 'Had ruang cakera untuk akaun penjual semula',
    'actionlog__reseller_limit_traffic' => 'Had trafik untuk akaun penjual semula',
    'actionlog__reseller_limits' => 'Had akaun penjual semula',
    'actionlog__reseller_permissions' => 'Kebenaran penjual semula',
    'actionlog__reseller_preferences' => "Keutamaan antara muka penjual semula",
    'actionlog__reseller_siteapp' => "Aplikasi web dalam himpunan penjual semula",
    'actionlog__reseller_status' => 'Status akaun penjual semula',
    'actionlog__health_status' => 'Status kesihatan pelayan',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'dicapai',
    'actionlog__added' => 'ditambah',
    'actionlog__removed' => 'dialih keluar',
    'actionlog__change' => 'diubah',
    'actionlog__update' => 'dikemas kini',
    'actionlog__move' => 'dipindahkan',
    'actionlog__upgrade' => 'dinaik taraf', // PFU?
    'actionlog__update_or_add' => 'dikemas kini atau ditambah',
    'actionlog__expired' => 'tamat tempoh',
    'actionlog__create' => 'dicipta',
    'actionlog__delete' => 'dipadam',
    'actionlog__service_stop' => 'dihentikan',
    'actionlog__service_restart' => 'dimulakan semula',
    'actionlog__service_start' => 'dimulakan',
    'actionlog__login' => 'telah log masuk',
    'actionlog__logout' => 'log keluar',
    'actionlog__install' => 'telah dipasang',
    'actionlog__uninstall' => 'dinyahpasang',
    'actionlog__reconfigure' => 'dikonfigurasi semula',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Permintaan tetapan semula kata laluan',
    'actionlog__event_admin_update' => 'Maklumat pentadbir dikemas kini',
    'actionlog__event_admin_preferences_update' => "Pilihan pentadbir dikemas kini",
    'actionlog__event_service_restart' => 'Perkhidmatan dimulakan semula',
    'actionlog__event_service_start' => 'Perkhidmatan dimulakan',
    'actionlog__event_service_stop' => 'Perkhidmatan dihentikan',
    'actionlog__event_ip_address_create' => 'Alamat IP dicipta',
    'actionlog__event_ip_address_delete' => 'Alamat IP dipadam',
    'actionlog__event_ip_address_update' => 'Alamat IP dikemas kini',
    'actionlog__event_client_create' => 'Akaun pelanggan dicipta',
    'actionlog__event_client_delete' => 'Akaun pelanggan dipadam',
    'actionlog__event_client_update' => 'Akaun pelanggan dikemas kini',
    'actionlog__event_client_status_update' => 'Status akaun pelanggan dikemas kini',
    'actionlog__event_client_preferences_update' => "Keutamaan antara muka pelanggan dikemas kini",
    'actionlog__event_client_siteapp_added' => "Aplikasi web ditambah kepada himpunan aplikasi akaun pelanggan",
    'actionlog__event_client_siteapp_removed' => "Aplikasi web ditambah kepada himpunan aplikasi akaun pelanggan",
    'actionlog__event_domain_limit_size_reached' => 'Had ruang cakera untuk langganan dicapai',
    'actionlog__event_domain_limit_traffic_reached' => 'Had trafik untuk langganan dicapai',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Had ruang cakera untuk langganan dicapai',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Had trafik untuk langganan dicapai',

    'actionlog__domain_limit_database' => 'Kuota pangkalan data untuk langganan',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Kuota pangkalan data MySQL untuk langganan dicapai',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Kuota lembut pangkalan data MySQL untuk langganan dicapai',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Kuota pangkalan data SQL Microsoft untuk langganan dicapai',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Kuota lembut pangkalan data SQL Microsoft untuk langganan dicapai',
    'actionlog__event_plesk_component_upgrade' => 'Komponen Plesk dikemas kini',
    'actionlog__event_plesk_component_install' => 'Komponen Plesk dipasang',
    'actionlog__event_plesk_component_uninstall' => 'Komponen Plesk dibuang pemasangan',
    'actionlog__event_domain_create' => 'Domain lalai (domain pertama yang ditambah kepada langganan atau langganan) dibuat',
    'actionlog__event_domain_delete' => 'Domain lalai (domain pertama yang ditambah kepada langganan atau langganan) dipadamkan',
    'actionlog__event_domain_update' => 'Domain lalai (domain pertama yang ditambah kepada langganan atau langganan) dikemas kini',
    'actionlog__event_domain_owner_change' => 'Pemilik langganan diubah',
    'actionlog__event_domain_plan_change' => 'Pelan perkhidmatan langganan ditukar',
    'actionlog__event_domain_status_update' => 'Domain lalai, status dikemas kini',
    'actionlog__event_domain_dns_update' => 'Domain lalai, zon DNS dikemas kini',
    'actionlog__event_subdomain_create' => 'Subdomain daripada domain lalai dicipta',
    'actionlog__event_subdomain_delete' => 'Subdomain daripada domain lalai dipadam',
    'actionlog__event_subdomain_update' => 'Subdomain daripada domain lalai dikemas kini',
    'actionlog__event_domain_alias_create' => 'Domain lalai, alias dicipta',
    'actionlog__event_domain_alias_delete' => 'Domain lalai, alias dipadam',
    'actionlog__event_domain_alias_update' => 'Domain lalai, alias dikemas kini',
    'actionlog__event_domain_limits_update' => 'Had langganan dikemas kini',
    'actionlog__event_cp_user_login' => 'Pengguna plesk telah mengelog masuk',
    'actionlog__event_cp_user_logout' => 'Pengguna plesk telah log keluar',
    'actionlog__event_mailname_create' => 'Akaun mel dicipta',
    'actionlog__event_mailname_delete' => 'Akaun mel dipadam',
    'actionlog__event_mailname_update' => 'Akaun mel dikemas kini',
    'actionlog__event_maillist_create' => 'Senarai mel dicipta',
    'actionlog__event_maillist_delete' => 'Senarai mel dipadam',
    'actionlog__event_maillist_update' => 'Senarai mel dikemas kini',
    'actionlog__event_phys_hosting_create' => 'Pengehosan fizikal dicipta',
    'actionlog__event_phys_hosting_delete' => 'Pengehosan fizikal dipadam',
    'actionlog__event_phys_hosting_update' => 'Pengehosan fizikal dikemas kini',
    'actionlog__event_forwarding_create' => 'Standard atau pengehosan pemajuan bingkai dicipta',
    'actionlog__event_forwarding_delete' => 'Standard atau pengehosan pemajuan bingkai dipadam',
    'actionlog__event_forwarding_update' => 'Standard atau pengehosan pemajuan bingkai dikemas kini',
    'actionlog__event_webuser_create' => 'Akaun pengguna web dicipta',
    'actionlog__event_webuser_delete' => 'Akaun pengguna web dipadam',
    'actionlog__event_webuser_update' => 'Akaun pengguna web dikemas kini',
    'actionlog__event_siteapp_install' => 'Aplikasi web telah dipasang',
    'actionlog__event_siteapp_reconfigure' => 'Aplikasi web dikonfigurasi semula',
    'actionlog__event_siteapp_uninstall' => 'Aplikasi web dinyahpasang',
    'actionlog__event_license_update' => 'Kunci lesen dikemas kini',
    'actionlog__event_admin_alias_create' => 'Akaun pentadbir tambahan dicipta',
    'actionlog__event_admin_alias_delete' => 'Akaun pentadbir tambahan dipadam',
    'actionlog__event_admin_alias_update' => 'Akaun pentadbir tambahan dikemas kini',
    'actionlog__event_ftpuser_create' => 'Akaun FTP tambahan dicipta',
    'actionlog__event_ftpuser_update' => 'Akaun FTP tambahan dikemas kini',
    'actionlog__event_ftpuser_delete' => 'Akaun FTP tambahan dipadam',
    'actionlog__event_template_domain_create' => "Pelan perkhidmatan penjual semula dicipta",
    'actionlog__event_template_domain_update' => "Pelan perkhidmatan penjual semula dikemas kini",
    'actionlog__event_template_domain_delete' => "Pelan perkhidmatan penjual semula dipadam",
    'actionlog__event_template_admin_create' => "Pelan perkhidmatan pentadbir dicipta",
    'actionlog__event_template_admin_update' => "Pelan perkhidmatan pentadbir dikemas kini",
    'actionlog__event_template_admin_delete' => "Pelan perkhidmatan pentadbir dipadam",
    'actionlog__event_database_server_create' => 'Pelayan pengkalan data dicipta',
    'actionlog__event_database_server_update' => 'Pelayan pengkalan data dikemas kini',
    'actionlog__event_database_server_delete' => 'Pelayan pengkalan data dipadam',
    'actionlog__event_remote_dns_status_update' => 'Status pelayan DNS jauh dikemas kini',
    'actionlog__event_session_preferences_update' => 'Tetapan sesi dikemas kini',
    'actionlog__event_domain_alias_dns_update' => 'Domain lalai, zon DNS daripada domain alias dikemas kini',
    'actionlog__event_domain_move' => 'Domain lalai dipindahkan ke langganan baharu',
    'actionlog__event_site_move' => 'Domain dipindahkan ke langganan baharu',
    'actionlog__event_site_subdomain_move' => 'Subdomain dipindahkan ke langganan baharu',
    'actionlog__event_subdomain_move' => 'Subdomain untuk domain lalai dipindahkan ke langganan baharu',
    'actionlog__event_license_expired' => 'Lesen Plesk telah tamat tempoh',
    'actionlog__event_database_create' => 'Pengkalan data dicipta',
    'actionlog__event_database_delete' => 'Pengkalan data dialih keluar',
    'actionlog__event_database_user_create' => 'Akaun pengguna pengkalan data dicipta',
    'actionlog__event_database_user_update' => 'Tetapan akaun pengguna pengkalan data dikemas kini',
    'actionlog__event_database_user_delete' => 'Akaun pengguna pengkalan data telah dialih keluar',
    'actionlog__event_client_guid_update' => "GUID pelanggan dikemas kini",
    'actionlog__event_domain_guid_update' => 'Domain lalai, GUID dikemas kini',
    'actionlog__event_reseller_create' => 'Akaun penjual semula dicipta',
    'actionlog__event_reseller_delete' => 'Akaun penjual semula dipadam',
    'actionlog__event_reseller_update' => 'Akaun penjual semula dikemas kini',
    'actionlog__event_reseller_guid_update' => 'GUID penjual semula dikemas kini',
    'actionlog__event_reseller_ip_pool_update' => "Himpunan IP penjual semula dikemas kini",
    'actionlog__event_reseller_limit_size_reached' => 'Had ruang cakera untuk penjual semula dicapai',
    'actionlog__event_reseller_limit_traffic_reached' => 'Had trafik untuk akaun penjual semula dicapai',
    'actionlog__event_reseller_limits_update' => 'Had akaun penjual semula dikemas kini',
    'actionlog__event_reseller_permissions_update' => 'Keizinan akaun penjual semula dikemas kini',
    'actionlog__event_reseller_preferences_update' => "Keutamaan antara muka penjual semula dikemas kini",
    'actionlog__event_reseller_siteapp_added' => "Aplikasi ditambah kepada himpunan aplikasi akaun penjual semula",
    'actionlog__event_reseller_siteapp_removed' => "Aplikasi dialih keluar daripada himpunan aplikasi akaun penjual semula",
    'actionlog__event_reseller_status_update' => 'Status akaun penjual semula dikemas kini',
    'actionlog__event_template_reseller_create' => 'Pelan penjual semula dicipta',
    'actionlog__event_template_reseller_delete' => 'Pelan penjual semula dipadam',
    'actionlog__event_template_reseller_update' => 'Pelan penjual semula dikemas kini',
    'actionlog__event_health_status_change' => 'Status kesihatan pelayan diubah',
    'actionlog__event_siteapp_upgrade' => 'Apl web dinaik taraf',
    'actionlog__event_extension_install' => 'Sambungan dipasang',
    'actionlog__event_extension_uninstall' => 'Sambungan dibuang pemasangan',
    'actionlog__event_extension_upgrade' => 'Sambungan dinaik taraf',
    'actionlog__event_extension_status_update' => 'Status sambungan dikemas kini',
    'actionlog__event_additional_license_expired' => 'Lesen tambahan telah tamat tempoh',
    'actionlog__event_hostname_changed' => 'Nama hos pelayan diubah',
    'actionlog__event_smb_user_create' => 'Pengguna tambahan dibuat',
    'actionlog__event_smb_user_delete' => 'Pengguna tambahan dipadamkan',
    'actionlog__event_smb_user_update' => 'Pengguna tambahan dikemaskini',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "RPC API Plesk tidak dipasang pada hos jauh. Hubungi pembekal perkhidmatan untuk bantuan.",
    'rsession_no_account_errmsg' => "Perkhidmatan jauh di bawah akaun anda tidak boleh dicapai. Alasan yang biasa ialah perkhidmatan untuk akaun anda masih belum diaktifkan lagi. Sila tunggu beberapa minit dan cuba lagi. Jika anda menghadapi ralat ini lagi, hubungi pentadbir sistem anda.",
    'rsession_no_domain_errmsg' => "Perkhidmatan jauh untuk domain ini tidak boleh dicapai. Alasan yang biasa ialah perkhidmatan untuk domain ini masih belum diaktifkan lagi. Sila tunggu beberapa minit dan cuba lagi. Jika anda menghadapi ralat ini lagi, hubungi pentadbir sistem anda.",
    'rsession_unknown_errmsg' => "Pelayan jauh telah menolak cubaan untuk mewujudkan sesi. Hubungi pentadbir sistem anda untuk sokongan. Ralatnya ialah: %1",
    'rsession_unknown2_errmsg' => "Ralat yang tidak diketahui semasa sesi jauh diwujudkan. Berkemungkinan, pelayan jauh tidak menjawab dengan betul atau tidak menjawab langsung. Tanya pentadbir sistem anda untuk memeriksa butiran ralat dalam log ralat pelayan web.",
    'rsession_no_connect_errmsg' => "Perkhidmatan jauh tidak boleh dicapai: sambungan ke sesi jauh gagal. Hubungi pentadbir sistem anda untuk sokongan.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Membenarkan memuat naik ke direktori masuk",
    'anonftp__allow_create_dirs' => 'Membenarkan penciptaan direktori di dalam direktori masuk',
    'anonftp__allow_download_incoming' => 'Membenarkan memuat turun dari direktori masuk',
    'anonftp__display_login' => 'Paparkan mesej log masuk',
    'anonftp__login_text' => 'Teks mesej',
    'anonftp__limit_incoming_disk_space' => "Had ruang cakera di dalam direktori masuk",
    'anonftp__limit_maximum_bandwidth' => "Had muat turun jalur lebar untuk domain FTP maya ini",
    'anonftp__limit_maximum_connections' => "Had nombor bagi sambungan serentak",
    'anonftp__unable_init' => "Tidak boleh untuk mengasal akaun FTP tanpa nama: %1",
    'anonftp__unable_set_quota' => "Tidak boleh untuk set had ruang cakera direktori masuk: %1",
    'anonftp__unable_update' => "Tidak boleh untuk mengemas kini sifat akaun FTP tanpa nama: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Sijil SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Sijil CA tidak menanda tangani sijil.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Pasangan kunci/sijil persendirian tidak serasi.",
    'class_sslcertificate__invalid_cert_format' => "Format sijil tidak sah.",
    'class_sslcertificate__invalid_private_key_format' => "Format kunci persendirian tidak sah.",
    'class_sslcertificate__prob_invalid_priv_key' => "Mungkin format kunci persendirian tidak sah.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Cipta Direktori Maya',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Cipta Direktori Maya',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Cipta direktori maya.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Cipta Direktori Maya',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Cipta Direktori Maya',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Cipta direktori maya.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Cipta Direktori',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Cipta Direktori',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Cipta direktori.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Cipta Direktori',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Cipta Direktori',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Cipta direktori.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Sifat Direktori',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Sifat Direktori Maya',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Paparkan dan tukarkan sifat direktori maya.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Sifat Direktori',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Sifat Direktori Maya',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Paparkan dan tukarkan sifat direktori maya.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Kebenaran Capaian Direktori',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Kebenaran Capaian Direktori',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Setkan kebenaran capaian direktori.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Kebenaran Capaian Direktori',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Kebenaran Capaian Direktori',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Setkan kebenaran capaian direktori.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Tetapan ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'Tetapan ASP.NET untuk %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Konfigurasi tetapan ASP.NET untuk direktori maya %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Tetapan ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'Tetapan ASP.NET untuk %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Konfigurasi tetapan ASP.NET untuk direktori maya %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'Tetapan PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'Tetapan PHP untuk %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Konfigurasi tetapan PHP untuk direktori maya %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'Tetapan PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Tetapan PHP untuk %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Konfigurasi tetapan PHP untuk direktori maya %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Alih keluar',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Alih keluar Direktori Maya',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Alih keluar direktori maya yang terpilih.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Alih keluar',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Alih keluar Direktori Maya',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Alih keluar direktori maya yang terpilih.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Direktori maya yang berikut akan dialih keluar:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Anda harus memilih direktori yang anda hendak alih keluar.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'Jenis MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'Jenis MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Paparkan senarai jenis MIME yang didaftarkan.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Tambah Jenis MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Tambah Jenis MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Daftarkan jenis MIME yang baharu.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Dokumen Ralat',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Dokumen Ralat',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Papar dan tukar dokumen ralat.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Perlindungan',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Perlindungan Direktori',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Capaian dihadkan kepada direktori yang mempunyai perlindungan kata laluan.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Perlindungan',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Perlindungan Direktori',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Capaian dihadkan kepada direktori yang mempunyai perlindungan kata laluan.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Tetapan',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Paparkan lokasi direktori dan tentukan tajuk untuk kawasan terlindung.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'Tetapan Pengguna',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'Tambah Pengguna',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Tambah Pengguna',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Tambahkan akaun pengguna untuk membenarkan capaian kepada direktori dilindungi.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Tetapan yang baharu telah digunakan.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Akaun pengguna telah ditambah.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Alih keluar',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Alih keluar pengguna bagi direktori dilindungi.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Alih keluar Akaun Pengguna',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Sahkan pengalih keluar akaun pengguna.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Akaun pengguna telah dialih keluar.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Pengendalian berjaya selesai.',
    'ui__admin/extras-domain__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__admin/report/layout/delete_multi__done' => 'Tataletak laporan yang terpilih telah dialih keluar.',
    'ui__admin/report/traffic-history__done' => 'Pengendalian berjaya selesai.',
    'ui__admin/report__done' => 'Pengendalian berjaya selesai.',
    'ui__admin-alias/delete_multi__done' => "Akaun pentadbir tambahan yang terpilih telah dialih keluar.",
    'ui__admin-alias/properties__done' => "Ciri akaun pentadbir tambahan telah dikemas kini.",
    'ui__admin-alias/properties_new__done' => "Akaun pentadbir tambahan dicipta.",
    'ui__admin-alias/properties_unknown__done' => "Ciri akaun pentadbir tambahan telah dikemas kini.",
    'ui__admin-alias__done' => "Maklumat akaun pentadbir tambahan berjaya dikemas kini.",
    'ui__admin/manage-domain__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__admin/register-domain__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Jadual penghantaran laporan yang terpilih telah dialih keluar.',
    'ui__admin/report/layout/auto/properties__done' => 'Jadual penghantaran laporan dikemas kini.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Jadual penghantaran laporan dicipta.',
    'ui__client/domain/certificate/properties__done' => 'Sifat sijil SSL/TLS telah dikemas kini.',
    'ui__client/domain/certificate/properties_new__done' => 'Sijil SSL/TLS yang baharu ditambah. Untuk membuatkannya berfungsi, pastikan untuk memilih tetapan pengehosan tapak web (di Tapak web & tab Domain> nama domain).',
    'ui__client/domain/certificate__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/certificate_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/chowner__done' => 'Langganan %1 kini dimiliki oleh pengguna yang lain.',
    'ui__client/domain/chowner_multi__done' => 'Pemilikan langganan ditukar.',
    'ui__client/domain/chowner_multi-select__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/chowner_select__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/dbbackup/create__done' => "Pengkalan data berjaya disandarkan.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Pengkalan data berjaya disandarkan.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Pengguna yatim berjaya dibaiki.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Fail sandaran telah berjaya dialih keluar.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Kandungan pengkalan data berjaya dipulihkan.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Pengendalian berjaya selesai.", // PFW
    'ui__client/domain/dbbackup__done' => "Pengendalian berjaya selesai.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Pengendalian berjaya selesai.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Pengendalian berjaya selesai.", // PFW
    'ui__client/domain/delete__done' => "Domain %1 dialih keluar.",
    'ui__client/domain/delete_multi__done' => "Domain telah dialih keluar.",
    'ui__client/domain/disable__done' => 'Domain %1 digantung.',
    'ui__client/domain/disable_multi__done' => 'Domain yang dipilih telah digantung.',
    'ui__client/domain/enable__done' => 'Tapak web %1 diaktifkan.',
    'ui__client/domain/enable_multi__done' => 'Tapak web yang terpilih telah diaktifkan.',
    'ui__client/domain/extras__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/domain/extras_self__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Tetapan putaran log telah ditukar.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Tetapan putaran log telah ditukar.',
    'ui__client/domain/hosting/logs__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/hosting/logs_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/hosting/protected-directories__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/hosting/setup__done' => 'Pengehosan untuk %1 dikonfigurasikan.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'Versi ASP.NET ditukar.', // PFW
    'ui__client/domain/hosting/ssh-terminal__done' => 'Pengendalian berjaya selesai.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Pengendalian berjaya selesai.', // PFU
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'Tetapan ASP.NET untuk %1 telah ditukar.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Direktori maya dicipta di bawah tapak web %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Direktori maya dicipta.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Direktori yang terpilih telah dialih keluar.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Direktori yang terpilih telah dialih keluar.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Dokumen ralat tersuai telah dikemas kini.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Jenis MIME yang terpilih telah dialih keluar', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Jenis MIME yang baharu didaftarkan.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Pengendalian berjaya selesai.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Kebenaran capaian direktori telah dikemas kini.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Kebenaran capaian direktori telah dikemas kini.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'Tetapan PHP untuk %1 telah dikemas kini.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'Tetapan PHP untuk %1 telah dikemas kini.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Sifat direktori telah dikemas kini.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Sifat direktori telah dikemas kini.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Tetapan perlindungan direktori telah dikemas kini.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Tetapan perlindungan direktori telah dikemas kini.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Pengendalian berjaya selesai.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Pengendalian berjaya selesai.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Sijil SSL/TLS tersedia dalam kedai dalam talian',
    'ui__client/domain/mpc-certificates_self__done' => 'Sijil SSL/TLS tersedia dalam kedai dalam talian',
    'ui__client/domain/register__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/domain/register_self__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/domain/rename__done' => 'Nama domain ditukar.',
    'ui__client/domain/rename_self__done' => "Berjaya menukarkan nama domain.",
    'ui__client/domain/settings_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/toggle_disable__done' => "Domain %1 digantung.",
    'ui__client/domain/toggle_enable__done' => "Domain %1 diaktifkan.",
    'ui__client/domain/traffic__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/traffic_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain/traffic_unknown__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain-summary-report__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain-summary-report_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/domain-summary-report_unknown__done' => 'Pengendalian berjaya selesai.',
    'ui__client/extras-domain__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/extras-domain_self__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/ipaddress/delete_multi__done' => 'Pengendalian berjaya selesai.',
    'ui__client/ipaddress/properties__done' => 'Pengendalian berjaya selesai.',
    'ui__client/ipaddress/properties_new__done' => 'Pengendalian berjaya selesai.',
    'ui__client/ip-pool/properties__done' => "Himpunan IP %1' pelanggan dikemas kini.",
    'ui__client/ip-pool/properties_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/limits__done' => "Had sumber untuk pelanggan %1 telah ditukar.",
    'ui__client/limits_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/logo__done' => 'Tetapan penjenamaan semula yang baharu untuk pelanggan %1 telah digunakan.',
    'ui__client/logo_reseller__done' => 'Tetapan penjenamaan panel yang baharu telah digunakan.',
    'ui__client/logo_self__done' => 'Tetapan penjenamaan semula telah digunakan.',
    'ui__client/logo_self-reseller__done' => 'Tetapan penjenamaan panel anda telah digunakan.',
    'ui__client/manage-domain__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/manage-domain_self__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/permissions__done' => "Kebenaran bagi pelanggan %1 telah ditukar.",
    'ui__client/permissions_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/preferences__done' => "Keutamaan untuk pelanggan %1 telah ditukar.",
    'ui__client/preferences_self__done' => "Keutamaan anda telah ditukar.",
    'ui__client/register-domain__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/register-domain_self__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__client/report/traffic-history__done' => 'Pengendalian berjaya selesai.',
    'ui__client/report/traffic-history_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/report__done' => 'Pengendalian berjaya selesai.',
    'ui__client/report_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/sessions/delete__done' => 'Pengendalian berjaya selesai.',
    'ui__client/sessions/delete_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/sessions__done' => 'Pengendalian berjaya selesai.',
    'ui__client/sessions_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/skeleton__done' => 'Pengendalian berjaya selesai.',
    'ui__client/skeleton_self__done' => 'Pengendalian berjaya selesai.',
    'ui__client/traffic__done' => "Pengendalian berjaya selesai.",
    'ui__client/traffic_unknown__done' => 'Pengendalian berjaya selesai.',
    'ui__cp-access__done' => 'Pengendalian berjaya selesai.',
    'ui__cp-session/properties__done' => 'Pengendalian berjaya selesai.',
    'ui__cp-session__done' => 'Pengendalian berjaya selesai.',
    'ui__ftp-sessions__done' => 'Pengendalian berjaya selesai.',
    'ui__license__done' => 'Pengendalian berjaya selesai.',
    'ui__logo__done' => "Sifat penjenamaan Plesk telah ditukar.",
    'ui__longtasks/longtask/properties__done' => "Tetapan tugas latar belakang telah berjaya ditukar.",
    'ui__mass-email/delete__done' => "Templat mesej %1 dialih keluar.", // PFW
    'ui__mass-email/delete_multi__done' => "Templat mesej telah dialih keluar.",  // PFW
    'ui__mass-email/send_main__done' => "Pengendalian berjaya selesai.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Akaun pelanggan telah berjaya terpilih.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Akaun pentadbir domain telah berjaya terpilih.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Akaun penjual semula telah berjaya terpilih.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Perubahan pada templat mesej e-mel massa telah disimpan.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Templat mesej e-mel massa dicipta.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Akaun pelanggan untuk templat mesej e-mel massa telah terpilih.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Akaun pentadbir domain untuk templat mesej e-mel massa telah terpilih.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Akaun penjual semula untuk templat mesej e-mel massa telah terpilih.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Templat mesej e-mel massa ditukar.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Nilai yang dinyatakan tidak sah.', // PFW
    'ui__mass-email__done' => "Pengendalian berjaya selesai.", // PFW
    'ui__mass-mail__done' => "Pengendalian berjaya selesai.", // PFU
    'ui__mass-mail/delete__done' => 'Templat mesej %1 dialih keluar.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Templat mesej telah dialih keluar.', // PFU
    'ui__mass-mail/properties__done' => 'Templat %1 ditukar.', // PFU
    'ui__mass-mail/properties_new__done' => 'Templat %1 dicipta.', // PFU
    'ui__mass-mail/send__done' => 'Mesej telah dihantar.', // PFU
    'ui__mass-mail/send_new__done' => 'Mesej telah dihantar.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Mesej telah dihantar.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Mesej telah dihantar.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Templat mesej yang baharu dicipta.', // PFU
    'ui__mass-mail/template/properties__done' => 'Templat mesej ditukar.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Tetapan pemantauan cakera yang baharu telah digunakan.', // PFU
    'ui__modules__done' => 'Pengendalian berjaya selesai.',
    'ui__modules__short-title' => 'Sambungan',
    'ui__modules__title' => 'Sambungan',
    'ui__reseller/client/traffic_unknown__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/extras-domain__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__reseller/extras-domain_self__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__reseller/ftp-sessions_self__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/limits__done' => "Dasar penggunaan dan had sumber penjual semula telah ditukar.",
    'ui__reseller/limits_readonly-self__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/limits_self__done' => 'Dasar penggunaan dan had sumber telah ditukar.',
    'ui__reseller/manage-domain__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__reseller/manage-domain_self__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__reseller/permissions__done' => 'Kebenaran bagi penjual semula %1 telah ditukar.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/register-domain__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__reseller/register-domain_self__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Jadual penghantaran laporan yang terpilih telah dialih keluar.',
    'ui__reseller/report/layout/auto/properties__done' => 'Jadual penghantaran laporan dikemas kini.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Jadual penghantaran laporan ditambah.',
    'ui__reseller/report/traffic-history__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/report/traffic-history_self__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/report__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/report_self__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/sessions/delete__done' => 'Pengendalian berjaya selesai',
    'ui__reseller/sessions/delete_self__done' => 'Pengendalian berjaya selesai',
    'ui__reseller/sessions__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/sessions_self__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/traffic__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/traffic_self__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/traffic_unknown__done' => 'Pengendalian berjaya selesai.',
    'ui__reseller/logo_self__title' => 'Penjenamaan Plesk',
    'ui__reseller/logo_self__done' => 'Tetapan penjenamaan Plesk anda telah digunakan.',
    'ui__server/aspdotnet__done' => 'Tetapan ASP.NET lebar pelayan telah ditukar.', // PFW
    'ui__server/certificate/default_multi__done' => 'Sijil SSL/TLS yang terpilih disetkan untuk digunakan bagi melindungi sambungan ke tapak web pengehosan yang baharu.',
    'ui__server/certificate/delete_multi__done' => 'Sijil SSL/TLS yang dipilih telah dialih keluar.',
    'ui__server/certificate/download__done' => 'Sijil SSL/TLS dimuat turun.',
    'ui__server/certificate/properties__done' => 'Sifat sijil SSL/TLS telah dikemas kini.',
    'ui__server/certificate/properties_new__done' => 'Sijil SSL/TLS %1 dicipta.',
    'ui__server/certificate/setup_multi__done' => 'Sijil SSL/TLS yang terpilih disetkan untuk digunakan bagi melindungi sambungan ke Plesk.',
    'ui__server/certificate__done' => 'Pengendalian berjaya selesai.',
    'ui__server/cp-certificate-download__done' => "Sijil SSL/TLS Plesk's dimuat turun.",
    'ui__server/crontab/properties__done' => 'Tugas dijadual bagi %1 telah ditukar.',
    'ui__server/crontab/task/delete__done' => 'Tugasan dialih keluar.',
    'ui__server/crontab/task/delete_multi__done' => 'Tugasan telah dialih keluar.',
    'ui__server/crontab/task/properties__done' => 'Tugas dijadual telah dikemas kini.',
    'ui__server/crontab/task/properties_new__done' => 'Tugasan yang baharu dijadualkan.',
    'ui__server/crontab/task/toggle_disable__done' => 'Tugas dijadual %1 dinyahdayakan.',
    'ui__server/crontab/task/toggle_enable__done' => 'Tugas dijadual %1 didayakan.',
    'ui__server/crontab__done' => 'Pengendalian berjaya selesai.',
    'ui__server/dns__done' => 'Pengendalian berjaya selesai.',
    'ui__server/ip-address/client/delete__done' => "Alamat IP dialih keluar daripada himpunan IP pengguna.",
    'ui__server/ip-address/client/delete_multi__done' => "Alamat IP dialih keluar daripada himpunan IP pengguna.",
    'ui__server/ip-address/client/properties_new__done' => 'Alamat IP ditetapkan kepada pengguna.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'Alamat IP %1 ditetapkan kepada pelanggan yang terpilih.',
    'ui__server/ip-addresses__done' => "Pengendalian berjaya selesai.",
    'ui__server/mail/statistics/spam/recipients__done' => "Pengendalian berjaya selesai.",
    'ui__server/mail/statistics/spam/summary__done' => "Pengendalian berjaya selesai.",
    'ui__server/mail/statistics/spam__done' => "Pengendalian berjaya selesai.",
    'ui__server/mail/statistics/virus/recipients__done' => "Pengendalian berjaya selesai.",
    'ui__server/mail/statistics/virus/summary__done' => "Pengendalian berjaya selesai.",
    'ui__server/mail/statistics/virus/viruses__done' => "Pengendalian berjaya selesai.",
    'ui__server/mail/statistics/virus__done' => "Pengendalian berjaya selesai.",
    'ui__server/mail/statistics__done' => "Pengendalian berjaya selesai.",
    'ui__server/mail__done' => 'Tetapan pelayan mel telah ditukar.',
    'ui__server/maillists__done' => 'Pengendalian berjaya selesai.',
    'ui__server/mpc-certificates__done' => 'Senarai halaman kedai dalam talian yang tersedia sijil SSL/TLS telah dibuka.',
    'ui__server/pmm__done' => 'Pengendalian berjaya selesai.',
    'ui__server/preferences__done' => "Tetapan pelayan telah ditukar.",
    'ui__server/register__done' => 'Halaman MyPlesk.com dibuka.',
    'ui__server/services__done' => 'Pengendalian berjaya selesai.',
    'ui__server/sitebuilder__done' => 'Pengendalian berjaya selesai.',
    'ui__server/skeleton__done' => 'Pengendalian berjaya selesai.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Alamat %1 dialih keluar daripada senarai hitam lebar pelayan.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Alamat telah dialih keluar daripada senarai hitam lebar pelayan.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Alamat telah ditambahkan kepada senarai hitam.',
    'ui__server/spam-filter/black-list/address__done' => 'Alamat telah ditambahkan kepada senarai hitam.',
    'ui__server/spam-filter/black-list__done' => 'Pengendalian berjaya selesai.', // PFU
    'ui__server/spam-filter/properties__done' => 'Tetapan penapis spam telah ditukar.',
    'ui__server/spam-filter/toggle_disable__done' => 'Penapisan spam dinyahdayakan oleh lebar pelayan.',
    'ui__server/spam-filter/toggle_enable__done' => 'Penapisan spam didayakan oleh lebar pelayan.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Alamat %1 dialih keluar daripada senarai putih lebar pelayan.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Alamat telah dialih keluar daripada senarai putih lebar pelayan.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Alamat telah ditambahkan kepada senarai putih.',
    'ui__server/spam-filter/white-list/address__done' => 'Alamat telah ditambahkan kepada senarai putih.',
    'ui__server/spam-filter/white-list__done' => 'Pengendalian berjaya selesai.', // PFU
    'ui__server/spam-filter__done' => 'Pengendalian berjaya selesai.',
    'ui__server/statistics__done' => 'Pengendalian berjaya selesai.',
    'ui__server/time__done' => "Tarikh dan masa sistem telah ditukar.",
    'ui__server__done' => "Pengendalian berjaya selesai.",
    'ui__sessions/properties__done' => 'Pengendalian berjaya selesai.',
    'ui__sessions__done' => 'Pengendalian berjaya selesai.',
    'ui__sessions/delete__done' => 'Sesi yang terpilih telah dipadamkan.',
    'ui__start-page__done' => 'Pengendalian berjaya selesai.',
    'ui__support__done' => 'Borang permintaan bantuan dibuka di dalam tetingkap yang baharu atau tab.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Tiada fail untuk dimuat naik.',
    'login_up__access_denied_no_permission' => "Capaian ditolak. Anda tidak mempunyai kebenaran untuk log masuk.",
    'mail__unable_remove_pattern' => "Alamat tidak boleh dialih keluar daripada senarai hitam pelayan: %1", // PFW
    'mail__incorrect_network_format' => 'Format rangkaian tidak betul: %1', // PFW
    'initconf__unable_change_passwd' => "Tidak dapat mengubah kata laluan pentadbir: %1",
    'initconf__unable_get_passwd' => 'Tidak boleh mendapatkan kata laluan pentadbir semasa: %1 gagal: %2',
    'initconf__invalid_hostname' => 'Ralat dalam nama hos "%1"',
    'initconf__unable_reconfig' => 'Tidak boleh mengkonfigurasi Plesk: nginxmng gagal: %1',
    'initconf__unable_update_admin' => 'Tidak boleh mengemas kini maklumat hubungan pentadbir: %1',
    '__refresh' => 'Segar semula',
    '__dalias_not_exist' => 'Alias domain tidak wujud.',
    '__bug146523_explanation' => 'Versi Plesk sebelumnya membenarkan penggunaan sehingga 16 aksara untuk nama pengguna FTP. Versi Plesk ini mengehadkan jumlah aksara maksimum yang dibenarkan dalam nama pengguna FTP sehingga 15 aksara. Untuk menyelesaikan isu ini, pendekkan nama pengguna FTP kepada 15 aksara bagi nama pengguna FTP yang terjejas dan tukar sekurang-kurangnya satu aksara nama pengguna FTP yang terjejas untuk mengelakkan isu pelanggaran nama pengguna. Kami memohon maaf atas segala kesulitan yang disebabkan oleh perubahan ini.',
    'domain__cannot_change_webmail' => 'Tidak boleh menukar mel web untuk domain: %1',
    'sb_publish_disable_warning' => 'Jika ciptaan tapak web dimatikan dengan Presence Builder, tapak web yang dicipta sebelumnya dalam Presence Builder akan dialih keluar serta data tapak web akan hilang. Klik OK jika anda ingin meneruskan.',
    '__sbnet_client_use_sbnet' => "Cipta akaun pengguna yang sepadan dalam Presence Builder",
    'mail_resp_activate' => 'Aktifkan auto-balas',
    'limitsManger__limit_available_error' => 'Tidak boleh memperuntukkan jumlah sumber yang diperlukan ("%%limitName%%"): hanya %%available%% tersedia untuk akaun anda.',
    'limitsManger__limit_reserved_error' => 'Tidak boleh memperuntukkan sumber yang kurang ("%%limitName%%") dari yang sedang digunakan.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Tidak boleh untuk namakan semula domain: Direktori maya dengan nama yang ditentukan sudah wujud.',
    'domain_unable_to_rename' => 'Tidak dapat menamakan semula domain.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Umum',
    'spamfilter__spamassassin_status_legend' => 'Penapisan spam SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Tetapan SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Hidupkan penapisan spam SpamAssassin lebar pelayan",
    'spamfilter__spamassassin_user_status_legend' => 'Hidupkan penapisan spam SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Hidupkan perlindungan spam greylisting lebar pelayan',
    'spamfilter__personal_settings_not_allowed' => 'Penggunaan tetapan penapisan span individu tidak dibenarkan oleh dasar sistem.',
    'spamfilter__required_score' => 'Markah yang mesti diterima mesej untuk melayakkannya sebagai spam',
    'spamfilter__rewrite_header_subject' => 'Tambahkan teks yang berikut pada permulaan tajuk untuk setiap mesej yang dikenali sebagai spam',
    'spamfilter__use_mailuser_prefs' => 'Guna tetapan individu pada penapisan spam',
    'spamfilter_addresses__text_hint' => 'Pisahkan alamat pelbagai menggunakan garisan yang baharu, ruang putih, tab atau koma bertindih. Mestilah mempunyai aksara bukan-ASCII pada sebelah kiri @ tanda. Alamat boleh mengandungi kad bebas "*" dan "?" (contohnya *@domain.com, user?@*.com). Bahagian domain bagi bahagian bukan-ASCII tidak boleh mengandungi kad bebas.',
    'spamfilter__score_error' => 'Markah tidak boleh mempunyai nilai negatif, bahagian sebelum titik perpuluhan mestilah kurang dari 100 dan hanya dua digit yang boleh dimasukkan selepas titik perpuluhan.',
    'spamfilter__rewrite_header_error' => 'Tajuk mesej boleh mengandungi sebarang aksara yang boleh dicetak kecuali tanda nombor (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Lantunan',
    'nonexistent_mail__mode_discard' => 'Dibuang',
    'nonexistent_mail__mode_catch_addr' => 'Majukan kepada alamat e-mel',
    'nonexistent_mail__mode_catch_ip' => 'Majukan kepada IP',
    'nonexistent_mail__bounce_not_supported' => 'Mod lantun tidak disokong',
    'nonexistent_mail__discard_not_supported' => 'Mod buang tidak disokong',
    'nonexistent_mail__catch_not_supported' => 'Pemajuan kepada alamat e-mel tidak disokong',
    'nonexistent_mail__redirect_not_supported' => 'Pemajuan kepada IP tidak disokong',
    'nonexistent_mail__ip_used_on_this_host' => 'Penyelesaian alamat IP pada hos setempat',
    'nonexistent_mail_address_should_be_local_domain' => 'Disebabkan kawalan mel keluar dihidupkan, alamat mel %1 untuk penerima yang tidak wujud sepatutnya menjadi milik domain yang terpilih. Jika tidak, maka polisi "Tolak" akan digunakan dan bukannya pemajuan.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Disebabkan kawalan mel keluar dihidupkan, alamat emel yang dinyatakan untuk pemajuan (%1) mel harus dimiliki oleh domain yang dipilih. Jika tidak, maka mesej yang dihantar ke alamat ini tidak akan dikira dalam Kawalan Mel Keluar.',
    // mail acc extras
    '__antivirus' => "AntiVirus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Tiada akaun pentadbir tambahan yang tersedia.', // PFW
    'ui__client/domain/certificate__none-available' => 'Pelanggan tidak mempunyai sijil SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'Pelanggan tidak mempunyai domain bersama sijil SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'Domain tidak mempunyai sijil SSL/TLS.',
    'ui__reseller/client__none-available' => 'Tiada penjual semula yang mempunyai pelanggan.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Anda harus memilih alamat IP yang anda hendak alih keluar daripada himpunan IP.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Anda perlu memilih akaun penjual semula dari himpunan IP yang anda mahu membatalkan alamat IP.',
    'ui__server/crontab/task/delete__empty_selection' => 'Anda harus memilih tugasan yang mahu dibatalkan.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'Sokongan PHP dimatikan untuk tapak web ini.',
    'phosting__aspdotnet_not_enabled' => 'Sokongan ASP.NET dimatikan untuk tapak web ini.',
    'phosting__php_forced_by_site_isolation' => 'Tetapan PHP tidak boleh diubah: kebenaran untuk mengatasi dasar keselamatan lebar pelayan tidak dibenarkan.',
    'phosting__option_forced_by_site_isolation' => 'Tetapan tidak boleh diubah %1: kebenaran untuk mengatasi dasar keselamatan lebar pelayan tidak dibenarkan.',
    'phosting__php_handler_id_not_registered' => 'Penggendali PHP tidak dibenarkan dalam tetapan pemencilan tapak. Penggendali PHP lalai akan digunakan.',
    'phosting__php_served_by_nginx_is_not_available' => 'Pengendali PHP (aplikasi FPM yang disediakan oleh nginx) tidak dibenarkan dalam tetapan pemencilan tapak. Penggendali PHP lalai akan digunakan.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Paparan senarai alamat IP',
    'ui__client/ipaddress/properties_readonly__title' => 'Paparan senarai alamat IP',
    'ui__client/ipaddress/properties_readonly__description' => 'Paparan senarai alamat IP yang tersedia untuk pengguna ini.',
    'ui__server/certificate__short-title' => 'Sijil SSL/TLS',
    'ui__server/certificate__title' => 'Sijil SSL/TLS',
    'ui__server/certificate__description' => 'Lihat dan uruskan sijil SSL/TLS.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Alih keluar Jenis MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Alih keluar Jenis MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Alihkan keluar jenis MIME yang terpilih.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Tambah Jenis MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Tambah Jenis MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Daftarkan jenis MIME.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Alih keluar Alamat IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Pilih alamat IP yang anda hendak alih keluar daripada himpunan IP bagi pelanggan %1',

    // mail

    'ui__client/ipaddress__short-title' => 'Alamat IP',
    'ui__client/ipaddress__title' => 'Alamat IP',
    'ui__client/ipaddress__description' => 'Paparkan maklumat tentang alamat IP.',
    'ui__server/ip-address__short-title' => 'Alamat IP',
    'ui__server/ip-address__title' => 'Alamat IP',
    'ui__server/ip-address__description' => 'Paparkan maklumat tentang alamat IP.',
    'ui__client/domain/hosting/setup__short-title' => 'Tetapan Pengehosan Web',
    'ui__client/domain/hosting/setup__title' => 'Tetapan Pengehosan Web',
    'ui__client/domain/hosting/setup__description' => 'Setkan tetapan pengehosan untuk tapak web %1.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Jenis MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Sifat Jenis MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Paparkan sifat bagi jenis MIME.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Dokumen Ralat', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Dokumen Ralat', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Sifat dokumen ralat.', // PFW

    // tooltips

    'b_get_password_cancel' => 'Kembali kepada skrin sebelumnya tanpa menghantar e-mel.',
    'b_get_password_send' => 'Klik OK untuk menghantar mesej pemulihan kata laluan kepada alamat e-mel yang didaftarkan di dalam sistem.',



    'b_personaltrafficlist_search' => 'Masukkan corak carian dan klik untuk mencari domain.',
    'b_personaltrafficlist_show_all' => 'Tunjukkan semua domain.',

    'b_back' => 'Kembali kepada halaman sebelumnya.',
    'b_next' => 'Pergi ke halaman berikut.',

    'b_dnsnstemplatelist_remove' => 'Padamkan nama pelayan yang terpilih.',
    'b_dnsnstemplatelist_search' => 'Masukkan corak carian dan klik untuk mencari pelayan nama.',
    'b_dnsnstemplatelist_show_all' => 'Tunjukkan semua pelayan nama.',

    'l_dnsnstemplatelist_ns' => 'Isihkan rekod templat DNS mengikut pelayan nama.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Janakan pautan yang selamat pada fail dan folder',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Mendayakan fail awam',
    'cu__serverfilesharing_fsPublicFolder' => 'Folder untuk penstoran fail awam',
    'cu__serverfilesharing_fsPublicUrl' => 'URL untuk capaian pelawat kepada fail awam',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Mendayakan perlindungan-kata laluan fail awam',
    'cu__serverfilesharing_fsPartnerFolder' => 'Folder untuk penstoran fail terlindung-kata laluan',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nama pengguna untuk capaian fail',
    'cu__serverfilesharing_fsPartnersPassword' => 'Kata laluan untuk capaian fail',
    'cu__serverfilesharing_fsDomain' => 'URL web folder akar. Nama domain',
    'cu__serverfilesharing_fsPrefix' => 'URL web folder akar. Prefiks',
    'cu__serverfilesharing_commandUpdate' => 'Kemas kini tetapan perkongsian fail',
    'cu__serverfilesharing_commandInfo' => 'Paparkan tetapan perkongsian fail semasa',
    'subscription_rename_is_forbidden' => 'Dilarang menamakan semula langganan oleh dasar lebar pelayan.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Uruskan Tugas Dijadual pada Pelayan',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Pilih pengguna sistem bagi tugas dijadual yang ingin uruskan.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Tugas Dijadual %1',
    'ui__server/crontab/task__description' => 'Paparkan sifat bagi tugas dijadual bagi %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Pengguna Sistem',
    'ui__server/crontab_unknown__title' => 'Pengguna Sistem',
    'ui__server/crontab_unknown__description' => 'Pengguna sistem yang boleh menjadi pemilik bagi tugas dijadual.',


    'ui__server/crontab__none-available' => 'Anda tidak mempunyai akaun pengguna sistem.',
    'ui__server/crontab_readonly-unknown__description' => 'Paparkan tugas dijadual.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Tugas berjadual',
    'ui__server/crontab_readonly-unknown__title' => 'Paparkan tugas dijadual',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Paparkan tugas dijadual.',
    'ui__server/crontab_readonly__description' => 'Paparkan tugas dijadual bagi %1.',
    'ui__server/crontab_readonly__short-title' => 'Tugas dijadual bagi %1',
    'ui__server/crontab_readonly__title' => 'Paparkan tugas dijadual bagi %1',
    'ui__server/crontab_unknown__wizard-title' => 'Uruskan tugas dijadual.',

    'ui__server/crontab/properties__description' => 'Edit tugas dijadual bagi %1.',

    'ui__server/crontab/properties__short-title' => 'Tetapan',
    'ui__server/crontab/properties__title' => 'Edit tugas dijadual bagi %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Paparkan tugas dijadual.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Tetapan',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Paparkan tugas dijadual',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Paparkan tugas dijadual.',
    'ui__server/crontab/properties_readonly__description' => 'Paparkan tugas dijadual bagi %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Tetapan',
    'ui__server/crontab/properties_readonly__title' => 'Paparkan tugas dijadual bagi %1',
    'ui__server/crontab/properties_unknown__description' => 'Edit tugas dijadual.',
    'ui__server/crontab/properties_unknown__short-title' => 'Sifat',
    'ui__server/crontab/properties_unknown__title' => 'Edit tugas dijadual',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Edit tugas dijadual.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Pilih pengguna sistem bagi tugas yang ingin dilihat.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Pilih pengguna sistem bagi tugas yang ingin ditukar.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Klik Selesai untk pertukaran digunakan dan keluar dari pendeta.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Klik Tamat untuk keluar dari pendeta.',

    'ui__server/crontab/task__none-available' => 'Anda tidak mempunyai tugas dijadual.',
    'ui__server/crontab/task__none-available__2' => 'Pengguna sistem %1 tidak mempunyai sebarang tugas dijadual.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Tugas dijadual.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Tugas',
    'ui__server/crontab/task_readonly-unknown__title' => 'Tugas berjadual',

    'ui__server/crontab/task/delete__description' => 'Alih keluar tugas dijadual %1',

    'ui__server/crontab/task/delete__short-title' => 'Alih keluar',
    'ui__server/crontab/task/delete__title' => 'Alih keluar tugas dijadual %1',
    'ui__server/crontab/task/delete_multi__description' => 'Alih keluar tugas dijadual.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Alih keluar',
    'ui__server/crontab/task/delete_multi__title' => 'Alih keluar tugas dijadual',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Alih keluar tugas dijadual.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Pilih pengguna sistem bagi tugas yang ingin dialih keluar.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Pilih tugasan yang hendak dialih keluar.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Sahkan pengalih keluaran tugas dengan memilih kotak semak dan klik Selesai untuk pendeta dilengkapkan.',
    'ui__server/crontab/task/delete_unknown__description' => 'Alih keluar tugas dijadual.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Alih keluar',
    'ui__server/crontab/task/delete_unknown__title' => 'Alih keluar tugas dijadual',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Alih keluar tugas dijadual.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Pilih pengguna sistem bagi tugas yang ingin dialih keluar.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Pilih tugasan yang hendak dialih keluar.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Sahkan pengalih keluaran tugas dengan memilih kotak semak dan klik Selesai untuk pendeta dilengkapkan.',

    'ui__server/crontab/task/properties__description' => 'Edit tugas dijadual.',

    'ui__server/crontab/task/properties__short-title' => 'Edit tugasan %1',
    'ui__server/crontab/task/properties__title' => 'Edit tugas dijadual',
    'ui__server/crontab/task/properties_new__description' => 'Ciptakan tugas di jadual untuk %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Tambah tugas',
    'ui__server/crontab/task/properties_new__title' => 'Ciptakan tugas di jadual untuk %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Cipta tugas di jadual.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Pilih pengguna sistem untuk siapa anda ingin mencipta tugas dijadual.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Klik Selesai untk pertukaran digunakan dan keluar dari pendeta.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Paparkan tugas dijadual.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Sifat',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Paparkan tugas dijadual',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Paparkan tugas dijadual.',
    'ui__server/crontab/task/properties_readonly__description' => 'Paparkan tugas dijadual.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Paparkan tugas %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Paparkan tugas dijadual',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Cipta tugas di jadual.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Tambah tugas',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Cipta tugas di jadual',
    'ui__server/crontab/task/properties_unknown__description' => 'Edit tugas dijadual.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Sifat',
    'ui__server/crontab/task/properties_unknown__title' => 'Edit tugas dijadual',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Edit tugas dijadual.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Pilih pengguna sistem bagi tugas yang ingin dilihat.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Pilih pengguna sistem bagi tugas yang ingin ditukar.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Pilih tugas dijadual.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Pilih tugas dijadual yang hendak ditukar.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Klik Selesai untk pertukaran digunakan dan keluar dari pendeta.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Klik Tamat untuk keluar dari pendeta.',

    'ui__server/crontab/task/toggle_disable__description' => 'Menyahdayakan tugas dijadual %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Nyahdayakan',
    'ui__server/crontab/task/toggle_disable__title' => 'Menyahdayakan tugas dijadual %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Mendayakan tugas dijadual %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Mendayakan',
    'ui__server/crontab/task/toggle_enable__title' => 'Mendayakan tugas dijadual %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Tugas dijadual didayakan atau dinyahdayakan.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Dayakan atau nyahdayakan',
    'ui__server/crontab/task/toggle_unknown__title' => 'Tugas dijadual didayakan atau dinyahdayakan',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Tugas dijadual didayakan atau dinyahdayakan',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Pilih akaun pengguna sistem bagi tugas yang ingin didayakan atau dinyahdayakan.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Pilih tugas yang ingin didayakan atau nyahdayakan.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Akaun pelanggan', // not used on HP?
    'ui__client_unknown__title' => 'Akaun pelanggan', // not used on HP?
    'ui__client_unknown__description' => 'Urus akaun pelanggan.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Gantung domain', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Gantung domain', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Gantung domain.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Aktifkan domain', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Aktifkan domain', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Aktifkan satu domain.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "Akaun FTP di Bawah Domain %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Akaun FTP",
    'ftp__user_name' => "Nama akaun FTP",
    'ftp__user_home' => "Direktori rumah",
    'ftp__invalid_path' => "Laluan yang ditentukan tidak sah",
    'i_ftp_ses_sub_user' => 'Sesi akaun FTP.',
    '__new_passwd' => "Kata laluan yang baharu %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Tidak boleh untuk mengkonfigurasi pelayan web pada hos <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Tidak boleh untuk menjana fail konfigurasi pelayan web pada hos <%%host%%> kerana ralat yang berikut:\n\n%%error%%\n\nSila selesaikan ralat di dalam templat konfigurasi pelayan web dan janakan semula fail.",

    'apacheConfigurationMessageAdminTitle' => 'Gagal menjanakan konfigurasi pelayan web',
    'apacheConfigurationMessageClientTitle' => 'Amaran',

    'apacheConfigurationFailedAdminHomeMessage' => 'Konfigurasi baharu fail tidak terbina kerana ralat di dalam templat konfigurasi. Butiran mesej ralat telah dihantar ke e-mel anda, semak emel, betulkan ralat dan klik %1 untuk menjana semula.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'di sini', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Konfigurasi baharu untuk domain %1 tidak terbina kerana ralat di dalam templat konfigurasi. Butiran mesej ralat telah dihantar ke e-mel anda, semak emel, betulkan ralat dan klik %2 untuk menjana semula.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'di sini', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Konfigurasi pelayan web untuk domain %1 mungkin tak konsisten. Sila hubungi pentadbir pelayan untuk menyelesaikan masalah.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Konfigurasi baharu untuk beberapa daripada domain tidak terbina kerana ralat di dalam templat konfigurasi. Butiran mesej ralat telah dihantar ke e-mel anda, semak emel, betulkan ralat dan klik %1 untuk menjana semula.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'di sini', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Konfigurasi pelayan web untuk beberapa domain anda mungkin tidak konsisten. Sila hubungi pentadbir pelayan untuk menyelesaikan masalah tersebut.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Dokumen ralat tersuai",
    'dom_pref__webusers_script' => "Benarkan pengguna web menggunakan skrip",
    '__seoRedirect' => 'Konfigurasikan domain yang diutamakan sebagai',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Tiada',

    '__sites' => 'Domain',
    'domain_plan__perm_denied_manage_phosting' => 'Anda tidak mempunyai kebenaran untuk menguruskan tetapan pengehosan.',
    '__owned_by_client' => 'dimiliki oleh pelanggan',
    'ui__client/permissions_readonly__description' => "Paparkan tindakan yang boleh dilaksanakan oleh pelanggan %1 dalam Plesk.",
    'backup__restore__object_client_template' => 'Templat pelanggan',
    '__template_name' => 'Nama pelan perkhidmatan',
    'template__not_exists' => 'Tiada pelan perkhidmatan seperti itu',
    'template__exists' => 'Pelan yang mempunyai nama %1 sudah wujud.',
    'clientOwnerChanger__ip_not_in_pool' => 'Alamat IP yang ditentukan tidak berada di dalam himpunan penjual semula.',

    //// Change owner of subscription
    'chown__select_title' => "Pilih Pelanggan Baharu",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Pilih pemilik yang baharu untuk langganan yang terpilih dan klik Kemudian >>.',
    'domains__client_info' => "%1 langganan, %2 langganan aktif, %3 ruang cakera digunakan, %4 trafik digunakan",
    '__possible_owners' => 'Mungkin pemilik yang baharu bagi langganan',

    'clients_list__filter_owner__filter_title' => 'Pembekal',
    'clients_list__filter_owner_any' => 'Semua pengguna',
    'clients_list__filter_owner_my' => 'Hanya pelanggan saya',
    'clients_list__filter_owner_name__filter_title' => 'Nama pembekal',

    '__owner' => "Pembekal",
    'l_clientslist_owner' => 'Isihkan akaun pengguna mengikut pembekal.',
    'l_clientslist_date' => 'Isihkan akaun pengguna mengikut tarikh dicipta.',
    'l_clientslist_name' => 'Isihkan akaun pengguna mengikut nama.',
    'l_clientslist_domains' => 'Isihkan akaun pengguna mengikut domain.',
    'l_clientslist_cname' => 'Isihkan akaun pengguna mengikut nama syarikat.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Menetapkan semula Langganan yang Terpilih',
    'chown__check_title' => 'Ubah Pelanggan',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Klik Tamat untuk melengkapkan penugasan semula. Setelah selesai, langganan yang terpilih akan ditetapkan pada pemilik yang baharu dan tidak terikat, pembekal mereka akan ditukar kepada pembekal pemilik yang baharu dan pelan perkhidmatan dan menjadi 'Tersuai'.",

    'chown__error_check' => 'Beberapa masalah telah dihadapi ketika cubaan untuk menetapkan beberapa langganan kepada pemilik baharu.',
    'domain_chown_subscription_will_be_anonymous' => "Langganan akan tidak terikat daripada pelan perkhidmatan semasa mereka dan menjadi 'Tersuai'.",
    'chown__error_domains_exclude' => "Beberapa masalah telah dihadapi ketika cubaan untuk menetapkan beberapa langganan kepada pemilik baharu. Langganan ini diserlahkan.",
    'chown__ip_not_in_client_pool' => "Alamat IP yang berkaitan dengan langganan ini tidak ditambah kepada himpunan IP pemilik baharu.",
    'chown__already_owned_by_client' => "Langganan ini sudah dimiliki oleh pengguna ini.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Direktori dilindungi /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Pengurusan direktori dilindungi /%1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Tambah Pengguna',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Tambah Pengguna',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Setkan akaun pengguna untuk capaian kepada direktori dilindungi %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'Akaun pengguna untuk capaian kepada direktori dilindungi dicipta.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "Kelayakan pengguna telah disimpan.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Pengalih keluar pengguna direktori dilindungi',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Pilih pengguna yang anda hendak alih keluar.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Alih keluar',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Alih keluar pengguna direktori.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'Pengguna direktori dilindungi yang berikut akan dialih keluar:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'Akaun pengguna yang terpilih telah dialih keluar.',

    '__redirect_hint' => 'Anda akan dilencongkan ke alamat yang baharu dalam masa 15 saat... Jika anda tidak dibawa ke alamat yang baharu secara automatik, dayakan javascript atau klik hiperpautan %%link%%.',

    'backup__restore__object_maillist' => 'Senarai mel',
    'backup__restore__object_site' => 'Tapak',
    'backup__restore__object_user' => 'Pengguna',
    'backup__restore__object_role' => 'Peranan',

    'limit__name_max_site' => 'tapak',

    'iis_pool__unable_rename_client' => "Himpunan aplikasi IIS tidak boleh dinamakan semula: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Perkhidmatan FTP tanpa nama hanya disokong untuk langganan domain utama.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Perkhidmatan FTP tanpa nama hanya disokong untuk langganan domain utama.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/bulan',
    '__tb_month' => 'TB/bulan',

    '__customers' => 'Pelanggan',
    '__customer_name' => 'Nama pelanggan',
    '__customer_total' => 'Jumlah pelanggan',
    '__site' => 'Tapak',
    '__def_site' => 'Tapak lalai',
    '__subscription_name' => 'Nama langganan',
    '__subscription_name_powerUser' => 'Nama langganan',

    'limit__units_max_traffic_suffix' => '/bulan',

    'dom_pref__discard' => "Tolak",

    'mail__pattern_already_exists' => 'Corak "%1" telah disenarai hitam.',

    '__not_supported' => 'Tidak disokong',

    'plesk_key__sitebuilder' => 'Tapak yang diterbitkan dengan Presence Builder',
    'limit__name_max_site_builder' => 'Tapak yang diterbitkan dengan Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Sokongan untuk laman multi-bahasa dalam Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Statistik Pemindahan Data untuk <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Statistik Pemindahan Data untuk <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Pindahan data dengan perkhidmatan",

    'login_up__access_denied_no_subscriptions' => "Capaian ditolak. Tiada langganan yang tersedia untuk akaun ini.",

    'interval__day' => '%1 hari',
    'interval__hour' => '%1 jam',
    'interval__minute' => '%1 minit',
    'interval__second' => '%1 saat',

    ///License options
    'plesk_key__backward_incompatibility' => 'Anda sedang cuba menggunakan kunci lesen yang dicipta untuk versi Plesk lain. Hubungi wakil jualan Plesk untuk mendapatkan kunci lesen yang betul.',
    //Standalone or virtualization
    'virtualization_any' => "Pelayan fizikal atau sebarang penyelesaian maya",
    'virtualization_pvc' => "Bekas Virtuozzo",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Hyper-V Microsoft",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo Server",
    'plesk_key__virtualization' => "Persekitaran yang berikut adalah sah:",
    'plesk_key__virtualization_only_key' => 'Kunci lesen ini hanya bertujuan untuk kegunaan dengan operasi Plesk dalam persekitaran maya %1.',
    'plesk_key__virtualizations_only_key' => 'Kunci lesen ini hanya bertujuan untuk kegunaan dengan operasi Plesk dalam persekitaran maya berikut: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Penggunaan bungkusan bahasa tersuai adalah dilarang.',
    'plesk_key__allowed-locales' => 'Bahasa yang tersedia',
    'plesk_key__allowed-locales-any' => 'Sebarang bahasa',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'Direktori cgi-bin terletak di',
    '_cgi_bin_mode_webspace' => 'direktori akar bagi langganan',
    '_cgi_bin_mode_www_root' => 'akar dokumen domain ini',

    /// Custom buttons
    'custom_button__sort_key' => 'Keutamaan',
    'custom_button__place' => 'Lokasi',
    'custom_button__place_navigation' => 'Capaian Biasa',
    'custom_button__place_admin' => 'Laman Utama Pentadbir',
    'custom_button__place_admin-settings' => 'Alatan Pentadbir & Laman tetapan',
    'custom_button__place_reseller' => "Laman Utama Penjual semula",
    'custom_button__place_reseller-settings' => 'Alatan Penjual semula & Laman utiliti',
    'custom_button__place_client' => 'Laman Utama Pelanggan',
    'custom_button__place_domain' => "Tapak web & Halaman domain Langganan",
    'custom_button__place_domain_powerUser' => "Tapak web & Halaman domain Langganan",
    'custom_button__place_domain-properties' => 'Alat Tapak web',
    'custom_button__private' => 'Tunjukkan hanya kepada saya',
    'custom_button__image' => 'Imej latar belakang',
    'custom_button__conhelp' => "Teks Petua alat",
    'custom_button__edit' => "Tetapan pautan kepada Perkhidmatan Tambahan",
    'custom_button__include_client_cname' => "Masukkan nama syarikat pelanggan",
    'custom_button__include_client_email' => "Masukkan e-mel pelanggan",
    'custom_button__include_client_id' => "Masukkan ID pelanggan",
    'custom_button__include_client_pname' => "Masukkan nama kenalan pelanggan",
    'custom_button__include_domain_id' => "Masukkan ID langganan, ID domain dan ID alias domain",
    'custom_button__include_domain_id_powerUser' => "Masukkan ID langganan, ID domain dan ID alias domain",

    'custom_button__include_domain_name' => "Masukkan nama Domain Primer",
    'custom_button__include_ftp_user' => "Sertakan nama pengguna FTP",
    'custom_button__include_ftp_pass' => "Sertakan kata laluan FTP",
    'custom_button__internal_open' => "Buka URL dalam Plesk",
    'custom_button__text' => "Label butang",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Fail ini bukan fail imej.',
    'custom_button__big_image' => 'Saiz fail tidak boleh melebihi 100 KB.',
    'custom_button__failed_copy_image' => 'Tidak dapat menyalin fail: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Sandaran bukan Pengguna Kuasa tidak dapat dipulihkan dalam paparan Pengguna Kuasa.',
    '__unknown_network_interface' => 'Antara muka rangkaian yang tidak diketahui',

    'init_conf__ip_address' => 'Alamat IP',

    //Confirmation page
    'bt_confirm' => 'Sahkan',
    'b_confirm' => 'Sahkan pemilikan tapak anda.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Tetapan himpunan aplikasi IIS yang khusus disetkan mengikut dasar keselamatan lebar pelayan (konfigurasi pemencilan tapak).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Tetapan himpunan aplikasi IIS yang khusus disetkan mengikut tetapan kemajuan lebar pelayan.',

    '__current' => 'Semasa',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Sifat pengguna telah dikemas kini.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Hampir kesemua domain yang disediakan dengan lesen Plesk telah anda gunakan (90% atau lebih).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Hampir kesemua domain telah anda gunakan.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Hampir kesemua laman Presence Builder yang disediakan dengan lesen Plesk telah anda gunakan (90% atau lebih).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Hampir kesemua laman Presence Builder telah anda gunakan.',
    'promo__button_hide' => 'Sembunyikan',
    'promo__button_next' => 'Seterusnya >>',
    'promo__button_prev' => '<< Sebelumnya',
    'promo__button_license' => 'Kemas kini Lesen',

    'promo__google_integration_title' => 'Integrasi dengan perkhidmatan Google',
    'promo__google_integration' => 'Konfigurasikan integrasi dengan perkhidmatan Google seperti AdSense, Google Apps, alatan Webmaster.',
    'promo__google_integration_button' => 'Konfigurasi',

    'promo__button_learn_more' => 'Ketahui Lebih Lanjut',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Anda boleh menyesuaikan tetapan penampilan antara muka dan penjenamaan bagi tema tersuai. Untuk arahan penyesuaian tema Plesk, rujuk kepada %1.',
    'panel_branding__description_link' => 'dokumen yang berikut',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Ekstrak Fail',
    'b_filemanager__extract' => 'Ekstrak fail daripada arkib yang terpilih ke dalam direktori semasa. Ambil perhatian yang nama fail mungkin tidak dipaparkan dengan betul selepas pengekstrakan jika mengandungi aksara nasional.',
    'filemanager_error_extracting_files' => 'Ralat berlaku ketika mengekstrak fail arkib: %1',
    'filemanager_no_archive_files_specified' => 'Tentukan arkib yang anda mahu ekstrak.',
    'filemanager_not_zip_archive_specified' => '%1 tidak boleh diekstrak, bukannya arkib ZIP.',
    'filemanager_files_successfully_extracted' => 'Fail arkib telah diekstrak.',
    'filemanager_error_file_download' => 'Gagal memuat turun fail: %1',
    'filemanager__user_poolgrp' => 'Kumpulan himpunan aplikasi',

    'loading' => 'Memuatkan...',
    'bt_create_archive' => 'Tambah ke Arkib',
    'filemanager__pack' => "Laluan untuk ke arkib: %1",
    'filemanager__archive_name' => 'Nama fail arkib',
    'filemanager__empty_filename' => 'Sila masukkan nama fail arkib.',
    'filemanager_archive_created' => 'Arkib berjaya dicipta.',
    'filemanager_error_creating_archive' => 'Arkib tidak boleh dicipta: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Rekod ini akan konflik dengan rekod AAAA untuk zon.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Pelayan FTP tidak menyokong alamat IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Rekod ini akan konflik dengan rekod gam untuk zon \'%1\'.',
    '__ftp_ipv6_not_supported' => "(Pelayan FTP tidak menyokong alamat IPv6.)",
    '__ipv6_not_supported' => 'IPv6 tidak disokong.',
    'mail__ipv6_not_supported' => 'Pelayan mel tidak menyokong IPv6.',
    'mail__relay_while_list_ipv6_not_supported' => 'Pelayan mel tidak menyokong senarai putih geganti IPv6.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Nilai topeng mestilah berganda 16.',
    'mail__ip_or_mask_is_invalid' => 'Alamat IP atau topeng tidak sah.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Pemajuan kepada alamat IPv6 tidak disokong.',
    'sa__invalid_trusted_networks' => 'Rangkaian dipercayai yang ditentukan dengan salah: %1',
    'dns_add__enter_ipv6_address' => "Alamat IPv6",
    'license_trial_days_left' => 'Plesk anda beroperasi menggunakan lesen percubaan yang akan tamat tempoh dalam masa %1 hari.',
    'excl_ipv6_num' => 'Alamat IPv6 khusus',
    '__ip_mask' => "Topeng subnet",
    '__ipv4_addr' => 'Alamat IPv4',
    '__ipv6_addr' => 'Alamat IPv6',
    'template__num_excl_ipv6s' => 'Peruntukkan alamat IPv6 yang khusus untuk penjual semula',
    'anonftp__exclusive_ipv4_required' => 'Alamat IPv4 khusus diperlukan untuk menyediakan dan menggunakan perkhidmatan FTP tanpa nama.',
    'anonftp__ipv4_already_used' => 'Tidak boleh menyediakan perkhidmatan FTP tanpa nama untuk laman ini kerana telah dikonfigurasikan pada domain yang lain di alamat IPv4 yang sama.',


    'restart__kav' => "Antivirus Kaspersky",
    '__view_migration_log_detailed_info' => 'Lihat log',

    'chown__ip_address_warn' => 'Sebelum langganan dipindahkan kepada pemilik baharu, anda mesti memilih alamat IP baharu untuk langganan itu.',
    'chown__no_ip_address' => 'Tiada',
    'chown__no_ipv4_address' => 'Tiada alamat IPv4',
    'chown__no_ipv6_address' => 'Tiada alamat IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'Langganan %1 sudah dimiliki oleh pengguna itu.',
    'chown__error_ip_absent_in_ip_pool' => 'Alamat IP %1 tidak hadir di dalam himpunan IP pengguna sasaran.',
    'chown__error_ip_not_exist' => 'Alamat IP dengan ID \'%1\' tidak wujud.',
    'chown__error_domain_ip_not_selected' => 'Sekurang-kurangnya satu alamat IP untuk domain %1 yang perlu terpilih. Semak nilai yang terpilih untuk pemetaan IP.',

    '__new_passwd_single' => "Kata laluan",
    '__confirm_passwd_single' => "Sahkan kata laluan",

    'mail__ip_or_mask_is_invalid_ipv6' => 'Alamat IPv6 atau topeng tidak sah. Alamat IP mestilah alamat unisiar yang sah.',

    '__subscriptions' => 'Langganan',

    '__owned_by_reseller' => 'dimiliki oleh penjual semula',
    '__owned_by_provider' => 'dimiliki oleh pembekal',

    'service_plan__anonymous' => 'Tersuai',
    'subscription_not_locked__change_limits_warning' => 'Langganan ini tidak dikunci: Had penggunaan sumber akan ditukar semasa penyegerakkan dengan pelan perkhidmatan.',
    'subscription_not_locked__change_permissions_warning' => 'Langganan ini tidak dikunci: Keizinan akan ditukar semasa penyegerakkan dengan pelan perkhidmatan.',

    'subscription__conflict_resolution_policy' => 'Dasar penyelesaian konflik',
    'subscription__conflict_resolution_policy_lock' => "Kunci langganan",

    'backup__list__backup_warnings' => 'Amaran',
    'backup__list__backup_info' => 'Maklumat',
    'backup__restore__object_reseller_template' => 'Templat penjual semula',
    'backup__restore__object_domain_template' => 'Templat domain',

    'ui__client/permissions_readonly__title' => 'Kebenaran',
    'ui__client/permissions_readonly__short-title' => 'Kebenaran',

    'subscription__unable_lock_anonymous' => 'Langganan ini tidak terikat dengan pelan perkhidmatan dan tidak boleh dibuka.',
    'subscription__unable_sync_anonymous' => 'Langganan ini tidak terikat dengan pelan perkhidmatan dan tidak boleh disegerakkan.',
    'subscription__unable_sync_locked' => 'Langganan ini dikunci dan tidak boleh disegerakkan.',
    'subscription__locked' => 'Langganan dikunci.',
    'component_name__urlrewrite' => "Tulis semula URL",
    '__quantity' => 'Kuantiti',
    'hst__www_root_dir_absent' =>  'Amaran: Direktori yang ditentukan sebagai akar dokumen tidak wujud.',
    'object_creation__domain_is_not_a_webspace' => 'Objek ini hanya boleh dicipta dalam langganan.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Langganan mengandungi tapak, jadi jenis pengehosan tidak boleh ditukar atau dipadam.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Ralat: Gagal untuk mengemas kini alamat IP. Domain tambahan tidak dapat diberikan alamat IP yang tidak peruntukkan kepada domain utama langganan.',
    'domain_plan__unable_change' => 'Tidak boleh untuk menukar pelan perkhidmatan: %1.',
    'domain_plan__different_hosting_type' => 'Jenis pengehosan semasa berlainan daripada jenis yang ditentukan dalam pelan perkhidmatan.',
    'domain_plan__addon_text' => 'Pelan pasang tambah',
    'domain_plan__addon_description' => 'Pelan pasang tambah digunakan untuk tambahan pelan pengehosan.',
    'asp_net__managed_runtime_version' => 'Pengurusan versi masa jalanan ASP.NET',
    'plan__can_not_change_hosting_type' => 'Semasa pelan diedit, mustahil untuk menukar jenis pengehosan.',
    'plan__apply_problems' => 'Pelan tidak digunakan disebabkan masalah dengan fungsi berikut: %1',
    'plan_save__subscription_update_problem' => 'Perubahan pelan tidak boleh digunakan pada %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Langganan digantung sementara sehingga sandaran atau proses pemulihan selesai. Sila kembali sebentar lagi.",
    '__login_incorrect_plain_shadow_password' => 'Penentuan kata laluan pada akaun pentadbir tidak betul. Sila gunakan kelayakan pentadbir (akar) sistem atau dapatkan kata laluan yang betul. Ketahui lebih lanjut tentang mendapatkan kata laluan, baca fail /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Anda tidak dapat menghantar alamat IP yang bukan milik anda',

    'dns__dns_zone_not_synchronized' => 'Zon DNS diubahsuai. Jika anda ingin gunakan perubahan pada templat DNS untuk zon ini, sama ada klik butang \'Apply DNS Template Changes\' pada halaman ini atau pilih opsyen \'Gunakan perubahan pada semua zon\' dalam Panel Pengurusan Pelayan > Alat & Tetapan > Tetapan Templat DNS > Gunakan Perubahan Templat DNS.',
    'dns__dns_zone_synchronize_link' => 'Klik',
    'dns__dns_zone_synchronize_done' => 'Zon DNS berjaya tersegerak.',

    'dns__dns_zone_template_error' => 'Terdapat isu penyegerakkan zon DNS dengan templat zon DNS.%1',

    'dns__soa_rname_type_owner' => 'Alamat e-mel pemilik laman web',
    'dns__soa_rname_type_domain' => 'Alamat e-mel domain',
    'dns__soa_rname_type_external' => 'Alamat e-mel luaran',
    'dns__soa_rname_enforce_email' => 'Melarang perubahan terhadap RNAME alamat e-mel pada setiap domain',
    'dns__soa_rname_label' => 'E-mel (RNAME)',
    'dns__soa_rname_hint' => 'Alamat e-mel orang yang bertanggungjawab untuk zon DNS domain. Dikembalikan oleh pelayan DNS sebagai tindak balas kepada pertanyaan SOA.',

    'dns__dns_zone_soa_sync_title' => 'Gantikan tetapan SOA untuk semua domain sedia ada',
    'dns__dns_zone_soa_sync_legend' => 'Pengesahan diperlukan',
    'dns__dns_zone_soa_sync_text' => 'Kemas kini rekod SOA semua domain dihoskan dengan menggunakan perubahan yang dibuat kepada templat SOA?',

    'cu_db__repair_mysql_dbus' => "Baiki kata laluan pengguna MySQL. Operasi ini perlu jika anda menaik taraf kepada Plesk 11 daripada versi yang sebelumnya.",

    'scheduled_backup_settings__start_at_hint' => 'Semak selang untuk tugasan sandaran berjadual dalam 15 minit. Jika anda mahukan Plesk untuk memulakan proses sandaran pada masa tertentu, jadualkan tugasan itu untuk minimum 15 minit lebih awal dari masa yang diingini.',
    'cu_scheduled_backup_comment' => 'Sandaran Berjadual',
    'cu_scheduled_backup_error' => 'Ralat berlaku semasa proses sandaran: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Ralat berlaku semasa sandaran yang dijadualkan.',
    'cu_scheduled_backup_mail_message' => "%1\nTitik permulaan Plesk: %2\n\nRalat berikut berlaku semasa proses sandaran berjadual:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Sandaran Per Jam',
    'cu_scheduled_backup_daily' => 'Sandaran Harian',
    'cu_scheduled_backup_weekly' => 'Sandaran Mingguan',
    'cu_scheduled_backup_monthly' => 'Sandaran Bulanan',
    'cu_scheduled_backup_comment_backup_all' => '%1. Semua konfigurasi dan kandungan.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Semua konfigurasi dan kandungan kecuali mesej mel.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Hanya konfigurasi dan mesej mel.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Semua konfigurasi dan kandungan kecuali pangkalan data pengguna.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Semua konfigurasi dan kandungan kecuali fail pengguna.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Hanya konfigurasi dan pangkalan data pengguna.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Hanya konfigurasi dan fail pengguna',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Konfigurasi domain.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Menyimpan sandaran berjadual di penyimpanan awan jauh adalah ciri premium. Hubungi penyedia pengehosan anda untuk membukanya.',

    'i_backup_invalid_file' => 'Sandaran ini tidak sah. Tidak boleh untuk memulihkan data dari fail ini. Klik pada nama sandaran untuk butiran.',

    'ui__server/migration/download-agent__short-title' => 'Muat turun Agen Pindahan & Migrasi',
    'ui__server/migration/download-agent__title' => 'Muat turun Agen Pindahan & Migrasi',
    'ui__server/migration/download-agent__description' => 'Muat turun versi tersedia yang terkini bagi Agen Pindahan & Migrasi daripada tapak web Plesk.',

    'filemanager_resulting_archive_exists' => 'Fail %1 sudah wujud dalam direktori sasaran.',

    'agent_unable_to_connect' => 'Tidak dapat menyambungkan kepada ejen \'%2\'. Sila pastikan ejen telah dipasang dan berjalan serta tiada masalah sambungan dengan hos \'%2\'.',
    'agent_test_connection_failed' => 'Gagal menyambungkan kepada ejen pada \'%2\'.',

    'agent_unable_to_resolve_host' => 'Hos jauh \'%1\' tidak dapat dikesan. Sila pastikan sambungan dengan hos tidak mempunyai masalah.',
    'agent_unknown_curl_error' => 'Ralat \'%1\' berlaku semasa penyambungan kepada ejen di \'%2\'.',
    'agent_unexpected_htp_code' => 'Kod HTTP \'%1\' yang tidak dijangka telah diterima daripada permintaan HTTP kepada ejen di \'%2\'.',
    'agent_unable_to_auth' => 'Tidak dapat mengesahkan pada hos \'%1\'. Untuk menyelesaikan isu ini, sila ikut arahan di http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Ralat pelayan dalaman dihadapi semasa perlaksanaan perintah pada hos jauh \'%1\'.',
    'agent_response_is_empty' => 'Permintaan HTTP kepada ejen telah menerima gerak balas yang kosong pada\'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Agen Pemindahan & Migrasi tidak dijumpai dalam cache setempat. Sila buka semula Pengurus Pemindahan & Migrasi untuk membetulkan isu ini.',

    '__hosting_webdeploy' => "Penerbitan Kerah Web",
    'cu_domain__webdeploy' => "Penerbitan Menggunakan Web (lalai: %1)",
    'cu_dom_tpl__webdeploy' => "Penerbitan Menggunakan Web (lalai: %1)",
    'cu_subdomain__webdeploy' => "Penerbitan Menggunakan Web (lalai: %1)",
    'webdeploy__not_installed' => "Web Deploy Microsoft tidak dipasang pada pelayan",
    'webdeploy__forced_by_site_isolation' => "Tetapan penerbitan Web Deploy tidak boleh ditukar: Anda tidak mempunyai kebenaran untuk mengatadi dasar keselamatan lebar pelayan. Hubungi pembekal anda untuk butiran.",



    'backup__restore_options__admin__server_configuration_license' => 'Kunci lesen',
    'migration_start_migrate_server_license' => 'Pindahkan kunci lesen',

    'defaultcomponents__delegation_rule_not_exist' => '(peraturan penugasan yang diperlukan \'appPoolPipeline, appPoolNetFx\' tidak wujud)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Pentadbir mencipta sandaran.',
    'i_backup_created_by_reseller' => 'Penjual semula mencipta sandaran.',
    'i_backup_created_by_client' => 'Pelanggan mencipta sandaran.',

    'migration__object_exists_on_target_host' => '(sudah wujud pada hos sasaran)',

    '__customers_total' => 'Jumlah mengikut pelanggan',
    '__resellers_total' => 'Jumlah mengikut penjual semula',
    '__reseller_total' => 'Jumlah penjual semula',


    'cu_cl_pref__manage_website_maintenance' => 'Akses ke operasi lanjutan: Menyalin Tapak web',
    'cu_cl_pref__manage_protected_dirs' => 'Pengurusan direktori dilindungi kata laluan',
    'cu_cl_pref__manage_mail_settings' => 'Keupayaan untuk menukar tetapan mel',


    'cu__command_update_php_settings' => 'Kemas kini tetapan PHP.',
    'cu__php_settings_option' => 'Setkan laluan kepada fail dengan tetapan PHP.',

    'cu__additional_php_settings_option' => 'Setkan laluan kepada fail dengan arahan PHP tambahan.',
    'cu__command_show_php_settings' => 'Paparkan tetapan PHP semasa.',
    'cu__general_settings' => 'Tetapan umum:',
    'cu__performance_settings' => 'Tetapan prestasi:',
    'cu__php_fpm_settings' => 'Tetapan PHP-FPM:',
    'cu__additional_directives' => 'Arahan tambahan:',

    'php_settings_permission_required' => 'Pengurusan tetapan PHP biasa',
    'php_settings_performance_permission_required' => 'Pengurusan tetapan prestasi pengehosan',
    'php_settings_customized' => 'Tetapan PHP telah tersuai.',
    'php_settings_synchronized_with_plan' => 'Tetapan PHP mestilah disegerakkan dengan pelan.',
    'phosting__unknown_shell_type' => 'Cangkerang tidak tersedia',

    'login_up__access_denied_subscription_deleted' => 'Capaian ditolak: Langganan anda dialih keluar.',

    'role_restricted_to_subscription' => '(dipindahkan dengan langganan: %1)',

    'filemanager__extract' => "Ekstrak fail ke: %1",

    'cu__license_command_check_installed_license' => 'Semak kesahihan kunci lesen yang dipasang (kembali kod keluar 0 jika kunci sah dan 1 jika tidak sah)',

    'promo__mobile_manager_title' => 'Pengurus Mudah Alih Pelayan Plesk',
    'promo__mobile_manager' => "Lanjutkan fungsi Plesk untuk membolehkan pengawalan dan pengawasan pelayan daripada peranti mudah alih (BlackBerry, iPhone dan Android).",
    'promo__mobile_monitor_title' => 'Pemantau Mudah Alih Pelayan Plesk',
    'promo__mobile_monitor' => 'Dapatkan maklumat yang paling penting tentang pelayan Plesk pada bila-bila masa dan di mana sahaja daripada peranti mudah alih (BlackBerry, iPhone, dan Android).',
    'promo__mobile_button' => 'Ketahui Lebih Lanjut',

    'ui__server/migration/video__short-title' => 'Video tutorial',
    'ui__server/migration/video__title' => 'Tonton video tutorial',
    'ui__server/migration/video__description' => 'Tonton video tutorial.',

    'subDomainNameHint' => 'Masukkan nama subdomain sebagai * untuk mencipta subdomain kad bebas. Pelawat tapak akan dilencongkan ke subdomain tanpa mengambil kira nama subdomain yang dimasukkan pada pelayar.',
    'subdomains__wildcard_name_invalid' => "Nama subdomain tidak sah. Anda boleh menggunakan aksara abjad angka, tanda sempang (-) dan asterisk (*) bagi nama subdomain kad bebas.",
    'subdomains__name_invalid' => "Nama subdomain tidak sah. Anda boleh menggunakan aksara abjad angka dan tanda sempang (-) bagi nama subdomain.",

    'domain__wildcard_no_www_prefix' => 'Penggunaan www prefiks adalah tidak mungkin untuk subdomain kad bebas.',

    '__service_title__milter' => "Milter Postfix Plesk",
    '__service_description__milter' => "Penapis mel Postfix Plesk",
    '__milter' => "Milter Postfix",
    'restart__milter' => "Milter Plesk (%1)",
    'restart__pop3' => "Pelayan Courier POP3",
    'restart__pop3s' => "Pelayan Courier POP3 dengan sokongan SSL/TLS",
    'restart__imap' => "Pelayan IMAP Courier",
    'restart__imaps' => "Pelayan Courier IMAP dengan sokongan SSL/TLS",
    'restart__authdaemon' => "Daemon pengesahan IMAP Courier",
    'restart__imap-pop3' => "Pelayan IMAP Dovecot dan POP3",


    'addon_packages_not_supported' => 'Apl web pakej APS tidak menyokong pasang tambah.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Tidak boleh untuk menetapkan alamat IP kepada domain secara automatik. Sila nyatakan alamat IP menggunakan pilihan -ip.',

    'plesk_key__mb_accounts' => 'Akaun pengguna (penjual semula dan pelanggan) dalam Pengurus Perniagaan dan Pelanggan',

    'actionlog__subdomain_dns' => 'Zon subdomain DNS',
    'actionlog__site_subdomain_dns' => 'Zon DNS daripada subdomain dibawah domain tambahan',

    // PfW only
    'actionlog__event_site_create' => 'Domain dicipta',
    'actionlog__event_site_delete' => 'Domain dipadam',
    'actionlog__event_site_update' => 'Domain dikemas kini',

    'actionlog__event_site_status_update' => 'Status domain dikemas kini',
    'actionlog__event_site_dns_update' => 'Zon DNS domain dikemas kini',
    'actionlog__event_site_guid_update' => 'GUID domain dikemas kini',

    'actionlog__event_site_subdomain_create' => 'Subdomain dicipta',
    'actionlog__event_site_subdomain_delete' => 'Subdomain dipadam',
    'actionlog__event_site_subdomain_update' => 'Subdomain dikemas kini',

    'actionlog__event_site_alias_create' => 'Alias domain dicipta',
    'actionlog__event_site_alias_delete' => 'Alias domain dipadam',
    'actionlog__event_site_alias_update' => 'Alias domain dikemas kini',

    'actionlog__event_site_alias_dns_update' => 'Zon DNS alias domain dikemas kini',
    'actionlog__event_subdomain_dns_update' => 'Zon DNS daripada subdomain di bawah domain lalai telah dikemas kini',
    'actionlog__event_site_subdomain_dns_update' => 'Zon DNS subdomain dikemas kini',
    // End of PfW only

    'win_policy__bad_password' => 'Pengesahsahihan gagal. Kata laluan tidak sah.',
    'win_policy__password_too_short' => 'Pengesahsahihan gagal. Kata laluan tidak memenuhi syarat dasar kata laluan kerana terlalu pendek.',
    'win_policy__password_too_long' => 'Pengesahsahihan gagal. Kata laluan tidak memenuhi syarat dasar kata laluan kerana terlalu panjang.',
    'win_policy__password_not_complex_enough' => 'Pengesahan gagal. Kata laluan tidak cukup rumit dan tidak mengikut syarat dasar kata laluan. Kata laluan yang kukuh mesti mengandungi sekurang-kurangnya semua yang berikut: lapan aksara; satu huruf besar atau huruf kecil; tiga nombor dan satu aksara khas (!, @, #, $, %, ^, &, *, ?, _, ~) atau satu nombor dan dua aksara khas.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Tidak dapat mengemas kini lesen produk.',


    'filemanager__error_path_is_not_allowed' => 'Laluan tidak dibenarkan',
    'filemanager__error_path_is_invalid' => 'Laluan tidak sah',
    'filemanager__error_path_not_found' => 'Laluan tidak dijumpai',
    'filemanager__error_path_already_exists' => 'Laluan sudah wujud',
    'filemanager__error_access_is_denied' => 'Capaian ditolak',
    'filemanager__error_directory_not_empty' => 'Folder tidak kosong',
    'filemanager__error_sharing_violation' => 'Pelanggaran perkongsian',
    'filemanager__error_not_same_device' => 'Laluan destinasi bukan pada peranti yang sama',
    'filemanager__binary_data_access' => 'Fail ini mungkin fail perduaan. Anda ingin membukanya?',
    'filemanager__unable_to_resolve_realpath' => "Fail %1 tidak dijumpai pada lokasi yang dinyatakan",
    'filemanager__access_to_realpath_denied' => "Akses ke realpath ditolak: %1 hingga %2.",
    'bt_exit' => 'Keluar',

    'filemanager__chdir_error__' => "Direktori tidak boleh ditukar kepada %1: %2",
    'filemanager__chmod_dir' => "Kebenaran penukaran untuk direktori %1",
    'filemanager__chmod_error__' => "Tidak boleh untuk kebenaran menukar bagi fail %1: %2",
    'filemanager__chmod_file' => "Kebenaran penukaran untuk fail %1",
    'filemanager__copy_error__' => "Tidak boleh untuk menyalin %1 kepada %2: %3",
    'filemanager__copy_move' => "Salin (alih) fail daripada %1",
    'filemanager__count_size__' => 'Pilihan saiz: %1',
    'filemanager__count_size_error__' => 'Tidak boleh untuk mengira saiz untuk %1: %2',
    'filemanager__create_dir' => "Ciptaan direktori",
    'filemanager__create_dir_error__' => "Direktori tidak boleh dicipta kepada %1: %2",
    'filemanager__dir_not_exists' => "Direktori %1 tidak wujud.",
    'filemanager__dirname' => "Nama direktori",
    'filemanager__filename' => "Nama fail",
    'filemanager__is_no_such' => "Tiada fail atau direktori dengan nama %1",
    'filemanager__empty_selection' => "Tiada fail dipilih.",
    'filemanager__file_exists' => "Fail %1 sudah wujud.",
    'filemanager__move_error__' => "Tidak boleh untuk mengalih %1 kepada %2: %3",
    'filemanager__new_dir' => "Nama direktori",
    'filemanager__not_allowed' => "Anda tidak dibenarkan untuk kebenaran menukar fail ini.",
    'filemanager__r_perm_dir' => "Senarai direktori",
    'filemanager__r_perm_file' => "Baca data",
    'filemanager__remove' => "Alih keluar fail daripada %1",
    'filemanager__remove_error__' => "Fail tidak boleh dialih keluar %1: %2",
    'filemanager__rename_dir' => "Namakan semula direktori %1",
    'filemanager__rename_error__' => "Tidak boleh untuk mennamakan semula %1 kepada %2: %3",
    'filemanager__rename_file' => "Namakan semula fail %1",
    'filemanager__set_win_permissions_dir' => "Setkan kebenaran untuk folder %1",
    'filemanager__set_win_permissions_file' => "Setkan kebenaran untuk fail %1",
    'filemanager__touch_confirm' => "Anda pasti untuk menukar cop masa bagi fail yang terpilih?",
    'filemanager__no_perms_or_unsupported_file_type' => 'Fail tidak boleh dibaca atau format fail tidak disokong.',
    'filemanager__upload_error__' => "Tidak boleh untuk memuat naik %1 kepada %2: %3",
    'filemanager__upload_file' => "Muat naik fail",
    'filemanager__upload_file_src' => "Laluan ke fail",
    'filemanager__username' => "Pengguna",
    'filemanager__w_perm_dir' => "Cipta fail",
    'filemanager__w_perm_file' => "Tulis data",
    'filemanager__x_perm_dir' => "Direktori menyusur",
    'filemanager__x_perm_file' => "Laksanakan fail",
    'filemanager__max_image_size_exceeded' => 'Imej tidak boleh dipaparkan. Saiz imej tidak boleh lebih besar dari %2 bait',

    '__fastcgi_unix_support' => 'Sokongan FastCGI',

    'dns__subdomain_dns_zone_parent' => 'Rekod DNS untuk subdomain ini disimpan di dalam zon DNS induk. Anda boleh mengubahsuai zon induk %1 atau mencipta zone yang berasingan untuk subdomain itu.',
    'dns__subdomain_dns_zone_parent_link' => 'di sini',
    'dns__no_dns_zone' => 'Tiada sebarang zon DNS yang ditetapkan dengan domain. Untuk menguruskan zon DNS untuk domain anda, anda perlu menekan butang \'Restore Defaults\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Tidak boleh untuk menghidupkan zon subdomain kerana terdapat rekod CNAME untuk subdomain ini dalam zon domain induk.',

    '__hosting_write_modify' => 'Kebenaran menulis/mengubah suai tambahan',

    'aspdotnet__group_framework_version' => "Versi Kerangka",
    'aspdotnet__param_version' => "Versi",

    'bt_restore_default' => "Set kepada Lalai",
    'b_aspdotnet' => 'Edit tetapan konfigurasi ASP.NET.',
    'b_aspdotnet__restore_default' => 'Simpan semula tetapan ASP.NET lalai.',
    'b_aspdotnet__restore_wdir_default' => "Pulihkan tetapan direktori induk untuk direktori maya ini.",
    'b_aspdotnet__restore_default_disabled' => 'Pemulihan konfigurasi lalai ASP.NET tidak tersedia: Konfigurasi ASP.NET rosak sama ada pada pelayan atau tahap direktori induk.',
    'b_autoinstaller' => 'Kemas kini Plesk atau komponennya.',
    'b_autoinstaller_configure' => 'Kemas kini tetapan.',
    'b_autoinstaller_install' => 'Pasangkan komponen yang terpilih.',

    '__iis_app_pool__use_dedicated' => 'Himpunan aplikasi khusus ISS',
    '__iis_app_pool__use_dedicated_addons' => 'Himpunan aplikasi IIS khusus untuk setiap tapak web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Dayakan aplikasi 32-bit',
    '__iis_app_pool__load_user_profile' => 'Muatkan profil pengguna',
    'bt_iis_app_pool' => "Himpunan Aplikasi IIS",

    'performance__cpu_usage' => 'Penggunaan Maksimum CPU (%)',
    'performance__cpu_usage_action' => 'Tindakan pengehadan',
    'performance__cpu_usage_interval' => 'Selang pengehadan (minit)',
    'performance__cpu_usage_action_not_supported' => 'Tindakan tidak disokong oleh pelayan web.',

    'performance__idle_timeout_action_not_supported' => 'Tindakan tamat masa melahu tidak disokong oleh pelayan web.',
    'performance__max_worker_processes' => 'Jumlah maksimum proses pekerja',
    'performance__idle_timeout' => 'Tamat masa melahu (minit)',
    'performance__idle_timeout_action' => 'Tamat masa tidakan',
    'performance__recycling_by_time' => 'Kitar semula pada selang masa yang biasa (minit)',
    'performance__recycling_by_requests' => 'Kitar semula apabila mencapai jumlah permintaan yang maksimum',
    'performance__recycling_by_virtual_memory' => 'Kitar semula apabila menggunakan jumlah maksimum memori maya',
    'performance__recycling_by_private_memory' => 'Kitar semula apabila menggunakan jumlah maksimum memori peribadi',
    'performance__managed_pipeline_mode' => 'Uruskan mod talian paip',
    'performance__managed_pipeline_mode_not_supported' => 'Mod tidak disokong oleh pelayan web.',

    'iis_app_pool' => 'Pengurusan himpunan apikasi IIS.',
    'b_iis_app_pool' => 'Urus himpunan aplikasi IIS.',
    'iis_app_pool_cl_dom' => 'Pengurusan himpunan apikasi IIS.',

    'i_webdirs_not_protected' => 'Direktori ini tidak terlindung.',
    'i_webdirs_protected' => 'Direktori ini terlindung.',
    'i_webdirs_manage_protection' => 'Uruskan perlindungan.',
    'i_webdirs_open' => 'Buka direktori/fail dalam pelayar.',
    'i_webdirs_preferences_disabled' => 'Direktori ini bukannya direktori maya.',
    'i_webdirs_permissions' => 'Kebenaran menguruskan.',
    'i_webdirs_permissions_disabled' => 'Pengurusan keizinan direktori tidak tersedia.',
    'i_webdirs_type_dir' => 'Direktori fizikal',
    'i_webdirs_type_vdir' => 'Direktori maya',
    'i_webdirs_browse' => 'Semak lalu kandungan direktori.',
    'i_webdirs_preferences' => 'Pengurusan tetapan direktori web.',

    'l_webdirslist_type' => 'Isihkan direktori mengikut jenis.',
    'l_webdirslist_protected' => 'Isihkan direktori mengikut status perlindungan.',
    'l_webdirslist_name' => 'Isihkan direktori mengikut nama.',

    'b_webdirslist_remove' => 'Padamkan direktori maya yang terpilih.',
    'b_webdirslist_search' => 'Masukkan corak carian dan klik untuk mencari direktori maya.',
    'b_webdirslist_show_all' => 'Tunjukkan semua direktori.',

    'l_webdirerrordocslist_code' => 'Isihkan dokumen ralat mengikut nombor kod ralat.',
    'l_webdirerrordocslist_name' => 'Isihkan dokumen ralat mengikut perihal ralat.',
    'l_webdirerrordocslist_type' => 'Isihkan dokumen ralat mengikut jenis dokumen ralat.',
    'l_webdirerrordocslist_location' => 'Isihkan dokumen ralat mengikut lokasi dokumen ralat.',

    'b_webdirerrordocslist_search' => 'Masukkan corak carian dan klik untuk mencari dokumen ralat.',
    'b_webdirerrordocslist_remove' => 'Padamkan dokumen ralat yang terpilih.',
    'b_webdirerrordocslist_show_all' => 'Tunjukkan semua dokumen ralat.',

    'l_webdirmimetypeslist_name' => 'Isihkan jenis MIME mengikut sambungan.',
    'l_webdirmimetypeslist_content' => 'Isihkan jenis MIME mengikut kandungan.',

    'b_webdirmimetypeslist_remove' => 'Padamkan jenis MIME yang terpilih.',
    'b_webdirmimetypeslist_search' => 'Masukkan corak carian dan klik untuk mencari jenis MIME.',
    'b_webdirmimetypeslist_show_all' => 'Tunjukkan semua jenis MIME.',

    'b_webdir_preferences' => "Tetapan direktori maya.",
    'b_webdir_permissions' => "Keizinan direktori maya.",
    'b_webdir_permissions_disabled' => "Pengurusan keizinan direktori tidak tersedia.",
    'b_to_webdirs' => 'Kembali kepada menguruskan direktori.',
    'b_to_webdir_mime_types' => 'Kembali kepada menguruskan jenis MIME.',
    'b_to_webdir_error_docs' => 'Kembali kepada menguruskan dokumen ralat.',
    'b_to_webdir_protection' => 'Kembali kepada menguruskan perlindungan direktori maya.',

    'webdirs__title' => 'Direktori Maya %1',
    'webdirs__preferences_title' => 'Tetapan Direktori Maya',
    'webdirs__list_legend' => 'Direktori maya',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Nama',
    'webdirs__list_header' => '%1 item',
    'webdirs__tabs_general' => 'Umum',
    'webdirs__tabs_mime_types' => 'Jenis MIME',
    'webdirs__tabs_error_docs' => 'Dokumen Ralat',

    'webdirs__tabs_permissions' => 'Kebenaran',
    'webdir__remove_vdirs' => 'Direktori maya yang berikut akan dipadam:',
    'webdir__remove_mime_types' => 'Jenis MIME yang berikut akan dipadam:',
    'webdir__mime_types_title' => 'Jenis MIME',
    'webdir__protection_disable_confirm' => 'Anda mahu mengalih keluar perlindungan daripada direktori?',
    'webdir__protect_title' => 'Pengguna URL Terlindung',
    'webdirs__permissions_title' => 'Keizinan direktori maya',
    'webdirs__browse_content_permission_denied' => 'Anda tidak mempunyai kebenaran untuk memaparkan kandungan bagi direktori ini.',
    'error_doc__list_code' => 'Ralat',
    'error_doc__list_code_description' => 'Perihalan',
    'error_doc__list_type' => 'Jenis',
    'error_doc__list_location' => 'Lokasi',
    'error_doc__code' => 'Ralat',
    'error_doc__type' => 'Jenis',
    'error_doc__type_file' => 'Fail',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Lokasi',
    'error_doc__legend' => 'Dokumen ralat',
    'error_doc__edit_title' => 'Edit Dokumen Ralat',
    'error_doc_erorr_invalid_url_location' => 'URL tidak sah. Sila tentukan URL yang betul.',
    'error_doc_erorr_invalid_file_location' => 'Laluan fail tidak sah. Sila tentukan laluan fail yang betul.',
    'error_doc__type_default' => 'Lalai',

    'webdirs__tabs_protection' => 'Perlindungan',
    'pb_webdirs' => 'Direktori Maya',

    'webdirs_remove_title' => 'Direktori maya yang berikut akan dialih keluar:',
    'webdirs_mime_types_remove_title' => 'Jenis MIME yang berikut akan dialih keluar:',
    'webdirs_preferences_title' => 'Tetapan Direktori Maya',
    'webdirs_permissions_title' => 'Kebenaran Khas untuk Fail dan Folder',
    'webdi_protection_disable_confirm' => 'Anda pasti untuk mengalih keluar perlindungan dari direktori maya? Semua direktori pengguna dan tetapan terlindung akan dialih keluar.',
    'bt_protect' => 'Lindung',
    'bt_unprotect' => 'Alih keluar Perlindungan',
    'bt_show_additional_users' => 'Tunjukkan pengguna yang lebih banyak',
    'bt_hide_additional_users' => 'Tunjukkan kurang pengguna',
    'error_doc__list_title' => 'Ralat dokumen',
    'error_doc__list_header' => 'Ralat dokumen',
    'error_doc__code_400' => 'Permintaan Tidak Baik',
    'error_doc__code_401' => 'Tidak dibenarkan',
    'error_doc__code_401.1' => 'Tidak dibenarkan - Log masuk gagal',
    'error_doc__code_401.2' => 'Tidak dibenarkan - log masuk gagal kerana konfigurasi pelayan',
    'error_doc__code_401.3' => 'Tidak dibenarkan - tidak dibenarkan kerana ACL pada sumber',
    'error_doc__code_401.4' => 'Tidak dibenarkan - Pengesahan dengan penapis gagal',
    'error_doc__code_401.5' => 'Tidak dibenarkan - Pengesahan dengan apl ISAPI/CGI gagal',
    'error_doc__code_401.7' => 'Tidak dibenarkan - Ditolak kerana dasar pengesahan URL',
    'error_doc__code_403' => 'Dilarang',
    'error_doc__code_403.1' => 'Dilarang - Melaksanakan capaian ditolak',
    'error_doc__code_403.2' => 'Dilarang - Capaian baca ditolak',
    'error_doc__code_403.3' => 'Dilarang - Capaian tulis ditolak',
    'error_doc__code_403.4' => 'Dilarang - SSL diperlukan',
    'error_doc__code_403.5' => 'Dilarang - SSL 128 diperlukan',
    'error_doc__code_403.6' => 'Dilarang - Alamat IP ditolak',
    'error_doc__code_403.7' => 'Dilarang - Sijil pelanggan diperlukan',
    'error_doc__code_403.8' => 'Dilarang - Capaian tapak ditolak',
    'error_doc__code_403.9' => 'Dilarang - Terlalu banyak pengguna',
    'error_doc__code_403.10' => 'Dilarang - Konfigurasi tidak sah',
    'error_doc__code_403.11' => 'Dilarang - Tukar kata laluan',
    'error_doc__code_403.12' => 'Dilarang - Capaian ditolak pemeta',
    'error_doc__code_403.13' => 'Dilarang - Sijil pelanggan dibatalkan',
    'error_doc__code_403.14' => 'Dilarang - Senarai direktori ditolak',
    'error_doc__code_403.15' => 'Dilarang - Lesen capaian pelanggan melebihi',
    'error_doc__code_403.16' => 'Dilarang - Sijil pelanggan tidak dipercayai atau pincang bentuk',
    'error_doc__code_403.17' => 'Dilarang - Sijil pelanggan telah tamat tempoh atau belum sah lagi',
    'error_doc__code_403.18' => 'Dilarang - Permintaan tidak boleh dilaksanakan daripada himpunan aplikasi ini',
    'error_doc__code_403.19' => 'Dilarang - Capaian CGI ditolak',
    'error_doc__code_403.20' => 'Dilarang - Log masuk pasport gagal',
    'error_doc__code_404' => 'Tidak dijumpai',
    'error_doc__code_404.2' => 'Tidak dijumpai - Ditolak kerana dasar penguncian',
    'error_doc__code_404.3' => 'Tidak dijumpai - Ditolak kerana dasar MIMEMAP',
    'error_doc__code_405' => 'Kaedah tidak dibenarkan',
    'error_doc__code_406' => 'Tidak boleh diterima',
    'error_doc__code_407' => 'Pengesahan proksi diperlukan',
    'error_doc__code_412' => 'Prasyarat gagal',
    'error_doc__code_414' => 'Permintaan-URI terlalu panjang',
    'error_doc__code_415' => 'Jenis media tidak disokong',
    'error_doc__code_500' => 'Ralat pelayan dalaman',
    'error_doc__code_500.12' => 'Ralat pelayan dalaman - Aplikasi bermula semula',
    'error_doc__code_500.13' => 'Ralat pelayan dalaman - Pelayan sibuk',
    'error_doc__code_500.15' => 'Ralat pelayan dalaman - Permintaan terus untuk GLOBAL.ASA dilarang',
    'error_doc__code_500.16' => 'Ralat pelayan dalaman - Ralat capaian UNC',
    'error_doc__code_500.17' => 'Ralat pelayan dalaman - Stor pengesahan URL tidak dijumpai',
    'error_doc__code_500.18' => 'Ralat pelayan dalaman - Stor pengesahan URL tidak boleh dibuka',
    'error_doc__code_500.19' => 'Ralat pelayan dalaman - Fail rosak metadata',
    'error_doc__code_500.100' => 'Ralat pelayan dalaman - Ralat ASP',
    'error_doc__code_501' => 'Tidak dilaksanakan',
    'error_doc__code_502' => 'Gerbang rosak',
    'error_doc__code_503' => 'Perkhidmatan tergendala sementara',

    'mimetype__extension' => 'Sambungan',
    'mimetype__content' => 'Kandungan',
    'mimetypeslist__title' => 'Jenis MIME',
    'mimetypes__title' => 'Jenis MIME',
    'mimetypes__select_to_remove' => 'Pilih jenis MIME yang hendak dialih keluar.',
    'mimetypes__select_for_remove' => "Pilih jenis MIME untuk dialih keluar.",
    'mimetypes_remove__title' => 'Alih keluar Jenis MIME',
    'mimetype__legend' => 'Jenis MIME',
    'mimetype_edit__title' => 'Edit Jenis MIME',
    'mimetype_edit__already_exists' => 'Jenis MIME telah ditentukan untuk sambungan ini.',
    'mimetype_edit__not_exists' => 'Jenis MIME tidak wujud.',
    'mimetype__content_type_other' => 'Tersuai...',

    'b_webdir_protection_enable' => 'Jadikan URL yang sepadan dengan direktori terlindung-kata laluan.',
    'b_webdir_protection_disable' => 'Jadikan URL yang sepadan dengan direktori yang boleh diakses kepada semua.',
    'b_webdir_protection_disabled' => 'Menyahdayakan perlindungan direktori maya.',

    'b_pd_usr_create' => 'Klik untuk mencipta pengguna URL terlindung ini.',
    'php__changeversion_title' => "Pilih Versi PHP",
    'php__group_php_version' => "Versi PHP",

    'virtualdir__name' => 'Nama',
    'virtualdir__path' => 'Laluan',
    'virtualdir__read' => 'Baca kebenaran',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Tulis kebenaran',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Capaian sumber skrip',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Menyemak imbas direktori',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Kebenaran perlaksanaan',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Log lawatan',
    'virtualdir__app_create' => 'Cipta aplikasi',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Menghidupkan pengesahan tanpa nama.',
    'virtualdir__auth_windows' => 'Menghidupkan pengesahan Windows.',
    'virtualdir__auth_not_enabled' => 'Pengesahan tanpa nama atau Windows mesti dihidupkan.',
    'virtualdir__require_ssl' => 'Memerlukan SSL/TLS',
    'virtualdir__enable_default_doc' => 'Gunakan dokumen lalai',
    'virtualdir__default_doc' => 'Aturan carian dokumen lalai',
    'virtualdir__enable_parent_paths' => 'Benarkan untuk menggunakan laluan induk',
    'virtualdir__execute_in_mta' => 'Benarkan perlaksanaan aplikasi dalam mod MTA (bilik teruntai berbilang)',
    'virtualdir_create__title' => 'Cipta direktori maya dalam %1',
    'virtualdir_edit__title' => 'Sifat bagi direktori maya %1',
    'virtualdir_edit__legend' => 'Direktori maya',
    'virtualdir_edit__application_legend' => 'Tetapan aplikasi',
    'virtualdir_edit__security_legend' => 'Keselamatan direktori',
    'virtualdir_edit__documents_legend' => 'Dokumen',
    'virtualdir_edit__list_legend' => 'Direkroti maya bersarang',
    'virtualdir_error__path_not_in__' => 'Laluan yang ditentukan tidak sah',
    'virtualdir_error__already_exists' => 'Direktori seperti nama itu telah wujud.',
    'virtualdir_root' => 'Direktori maya',
    'virtualdir_root__title' => 'Direktori maya',
    'virtualdir_root__list_legend' => 'Direktori maya',
    'virtualdir_se__none' => 'Tiada',
    'virtualdir_se__script' => 'Skrip sahaja',
    'virtualdir_se__script_execute' => 'Skrip dan Boleh dilaksanakan',
    'virtualdirs__title' => 'Direktori maya',
    'virtualdirs__path_not_exists' => 'Laluan tidak sah.',
    'virtualdirs__select_for_remove' => "Pilih direktori maya untuk dialih keluar.",
    'virtualdirs_remove__title' => 'Alih keluar direktori maya',
    'virtualdirs_phys_dir_exist' => 'Direktori fizikal dengan nama seperti itu sudah wujud. Jika diteruskan, ia akan mejadi tidak tercapai. Anda ingin meneruskan?',
    'virtualdir_auto_create_dir' => "Cipta direktori fizikal dengan nama yang sama dengan direktori maya",

    'asp_max_default_text' => 'Tertakrif oleh direktori induk (%1 KB)',
    'asp_max_default_text_site' => 'Tertakrif oleh IIS (%1 KB)',
    'asp_max_buffer_text' =>'Saiz maksimum dari penimbal ASP (KB)',
    'asp_max_body_text' => 'Saiz maksimum dari permintaan ASP(KB) badan entiti',
    'asp_buffers_legend' =>'Tetapan ASP',

    'asp_debug_default_text' =>'Tertakrif oleh direktori induk',
    'asp_debug_default_text_site' =>'Tertakrif oleh IIS',
    'asp_client_debug_text' =>'Mendayakan penyahpepijatan skrip pihak pelanggan',
    'asp_server_debug_text' =>'Mendayakan penyahpepijatan skrip pihak pelayan',

    'webdirs__list_with_broken_dirs' => "Terdapat direktori maya yang berpaut pada folder fizikal yang tidak wujud.",
    'webdirs__vdir_physical_path_not_exist' => "Direktori maya berpaut pada folder fizikal yang tidak wujud.",
    'webdirs__physical_path_not_exist' => "Laluan yang ditentukan tidak wujud.",

    'filemanager__new_dir_title' => 'Cipta direktori',
    'php__configuration_title' => "Konfigurasi PHP",

    'permissions__title' => 'Setkan Kebenaran Capaian',
    'permissions__title_advanced' => 'Tetapkan Kebenaran Capaian Lanjutan',
    'permissions__inherit_from_parent' => 'Benarkan keizinan warisan daripada induk kepada merambat bagi objek dan semua objek anak ini. Masukkan ini dengan ketersuratan entri yang ditentukan di sini.',
    'permissions__replace_on_children' => 'Gantikan kebenaran entri pada semua objek anak dengan entri yang ditunjukkan di sini.',
    'permissions__group_or_user_name' => 'Kumpulan atau nama pengguna',
    'permissions__Permissions_for' => 'Kebenaran untuk',
    'permissions__allow' => 'Benarkan',
    'permissions__deny' => 'Tolak',
    'permissions__FullControl' => 'Kawalan Penuh',
    'permissions__Modify' => 'Ubahsuai',
    'permissions__ReadAndExecute' => 'Baca & Laksanakan',
    'permissions__ListFolderContents' => 'Senarai Kandungan Folder',
    'permissions__Read' => 'Baca',
    'permissions__Write' => 'Tulis',
    'permissions__ReadControl' => 'Kawalan Baca',
    'permissions__WriteControl' => 'Kawalan Tulis',
    'permissions__ExecuteControl' => 'Kawalan Eksekutif',
    'permissions__TraverseFolderOrExecuteFile' => 'Susur Folder / Lakukan Fail',
    'permissions__ListFolderOrRead' => 'Senarai Folder / Baca Data',
    'permissions__CreateFilesOrWrite' => 'Cipta Fail / Tulis Data',
    'permissions__CreateFoldersOrAppend' => 'Cipta Folder / Tambah Data',
    'permissions__DeleteSubfoldersandFiles' => 'Padam Subfolder dan Fail',
    'permissions__Delete' => 'Padam',
    'permissions__ChangePermissions' => 'Tukar Kebenaran',
    'permissions__TakeOwnership' => 'Ambil Pemilikan',
    'permissions__inherited_from' => 'Bentuk warisan',
    'permissions__not_inherited' => '<tiada warisan>',
    'permissions__apply_to' => 'Gunakan pada',
    'permissions__apply_onto' => 'Memohon kepada:',
    'permissions__apply_onto1' => 'Hanya folder ini',
    'permissions__apply_onto2' => 'Subfolder sahaja',
    'permissions__apply_onto3' => 'Folder dan subfolder ini',
    'permissions__apply_onto4' => 'Hanya fail',
    'permissions__apply_onto5' => 'Folder dan fail ini',
    'permissions__apply_onto6' => 'Subfolder dan fail sahaja',
    'permissions__apply_onto7' => 'Folder, subfolder dan fail ini',

    'filemanager__not_allowed_dir' => "Anda tidak dibenarkan untuk kebenaran menukar folder ini.",

    'filemanager__allow' => "Benarkan",
    'filemanager__deny' => "Tolak",
    'filemanager__user_domusr' => 'Pentadbir tapak web',
    'filemanager__user_webusr' => 'Pengguna web',
    'filemanager__user_admins' => 'Pentadbir',
    'filemanager__user_system' => 'SISTEM',
    'filemanager__user_aspnet' => 'Pengguna ASP.NET',
    'filemanager__user_poolusr' => 'Pengguna himpunan aplikasi',
    'filemanager__user_sysaccount' => 'Pengguna sistem tambahan',

    'bt_permissions_advanced' => 'Lanjutan',
    'b_permissions_advanced' => 'Klik untuk lihat dan set keizinan yang khusus.',

    'hotlink-protection_invalid_friend_domain' => 'Nama tidak sah untuk domain mesra.',
    'hotlink-protection_duplicate_friend_domain' => 'Nama pendua untuk domain mesra.',
    'hotlink-protection_invalid_extensions' => 'Sambungan fail mengandungi aksara yang tidak wajar.',

    'i_domain_alias_status_on' => 'Alias domain didayakan.',
    'i_domain_alias_status_off' => 'Alias domain dinyahdayakan.',
    'i_domain_alias_status_with_parent' => 'Alias domain dinyahdayakan kerana domain dimatikan.',
    'i_domain_alias_turn_off' => 'Klik untuk menyahdayakan.',
    'i_domain_alias_turn_on' => 'Klik untuk mendayakan.',
    'i_domain_alias_mail_on' => 'Perkhidmatan mel didayakan untuk alias domain ini.',
    'i_domain_alias_mail_off' => 'Perkhidmatan mel dinyahdayakan untuk alias domain ini.',
    'i_domain_alias_mail_with_parent' => 'Perkhidmatan mel dinyahdayakan kerana alias domain dimatikan.',
    'i_domain_alias_web_on' => 'Perkhidmatan web didayakan untuk alias domain ini.',
    'i_domain_alias_web_off' => 'Perkhidmatan web dinyahdayakan untuk alias domain ini.',
    'i_domain_alias_web_with_parent' => 'Perkhidmatan web dinyahdayakan kerana alias domain dimatikan.',
    'i_domain_alias_dns_on' => 'Perkhidmatan alias DNS dihidupkan untuk alias domain ini.',
    'i_domain_alias_dns_off' => 'Perkhidmatan alias DNS dimatikan untuk alias domain ini.',
    'i_domain_alias_dns_with_parent' => 'Penyegerakkan DNS dengan domain induk dinyahdayakan kerana alias domain dimatikan.',
    'i_domain_alias_seoRedirect_on' => 'Ubah hala dengan kod 301 HTTP telah dihidupkan untuk alias domain ini.',
    'i_domain_alias_seoRedirect_off' => 'Ubah hala dengan kod 301 HTTP telah dimatikan untuk alias domain ini.',
    'i_domain_alias_seoRedirect_with_parent' => 'Ubah hala dengan kod 301 HTTP telah dimatikan kerana alias domain tersebut dimatikan.',

    'domain_alias__control_title' => 'Alias domain %1',
    'domain_alias__control_info_legend' => 'Maklumat',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Nama perkhidmatan',
    'domain_alias__control_details_title' => 'Butiran',

    'domain_alias__invalid_values' => 'Nama domain yang anda tentukan tidak sah. Nama domain boleh merangkumi surat, digit dan tanda sempang. Setiap bahagian nama domain diantara titik tidak perlu lebih panjang dari 63 simbol.',
    'domain_alias__domain_already_exists' => "Nama alias domain %1 salah. Domain %1 sudah wujud.",
    'domain_alias__www_prefix_domain_already_exists' => "Nama www. alias domain %1 salah. Alias ini telah dicipta untuk domain %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nama mel web alias domain %1 salah. Alias ini telah dicipta untuk domain %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nama senarai alias domain %1 salah. Alias ini telah dicipta untuk domain %1.',
    'domain_alias__dns_record_already_exists' => 'Alias domain %1 tidak boleh disetkan kerana penunjuk rekod DNS kepada hos %1 sudah wujud.',
    'domain_alias__domain_alias_already_exists' => "Alias domain dengan nama seperti itu sudah wujud.",
    'domain_aliases__mail_server_not_support_aliases' => 'Pelayan mel tidak menyokong ciri alias domain. Alias domain mungkin tidak berfungsi dengan betul.',
    'domain_alias__restrict_domain_creation' => 'Nama alias domain yang ditentukan adalah dilarang oleh dasar lebar pelayan. Jika nama alias domain ini kepunyaan anda, sila hubungi pembekal pengehosan anda.',
    'domain_alias__restrict_creation_with_www' => 'Sila masukkan nama domain tanpa prefiks \'www\'. Prefiks www untuk domain akan ditambah kepada konfigurasi pelayan web secara automatik.',
    'domain_unable_to_set_name' => 'Salah nama %1.',

    'domain_alias__domain_service_dns_disabled' => 'Domain ini dilayani oleh pelayan DNS yang lain.',
    'domain_alias__domain_service_dns_enabled_master' => 'Pelayan DNS ini bertindak sebagai pelayan nama utama untuk zon DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Pelayan DNS ini bertindak sebagai pelayan nama sekunder untuk zon DNS.',
    'domain_alias__domain_service_mail_enabled' => 'Perkhidmatan mel dihidupkan untuk domain.',
    'domain_alias__domain_service_mail_disabled' => 'Perkhidmatan mel dimatikan untuk domain.',
    'domain_alias__domain_service_mail_mx' => '%1 digunakan sebagai pelayan mel.',

    'domain_alias__service_seoRedirect_hint' => 'Apabila pengunjung membuka URL alias, mereka akan dihalakan semula ke URL domain utama. Plesk menggunakan carian enjin mesra HTTP 301 yang dihalakan semula, bermakna kedudukan enjin carian tidak akan berpecah antara URL.',

    'bt_task_run_now' => 'Jalankan Sekarang',
    'ftp__read_perm' => "Baca kebenaran",
    'ftp__write_perm' => "Tulis kebenaran",

    'filemanager__upload_backup_file_hint' => 'Anda boleh memuat naik fail sandaran kepada storan Plesk. Saiz fail maksimum terhad kepada dua gigabait.',

    '__default_for_mssql' => 'lalai untuk MS SQL',

    '__login_does_not_pass_validation' => "Nama pengguna tidak sah. Pastikannya supaya memenuhi syarat yang berikut: %1",
    '__login_allowed_symbols' => 'Hanya aksara abjad angka termasuk tempoh, sempang dan garis bawah. Aksara pertama mestilah abjad angka.',

    'restart__nginx' => 'Pelayan Proksi Songsang (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Saya ingin menerima maklumat produk dan pengumuman umum daripada Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Saya ingin menerima maklumat dan pemberitahuan teknikal lain yang berkaitan keselamatan daripada Plesk.",

    '__login_status_inactive' => 'Akaun anda tidak aktif. Sila hubungi pentadbir Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Kembali ke laman Alatan & Tetapan. Pemindahan akan diteruskan dalam latar belakang.',

    'ui__admin-alias-info__description' => "Edit maklumat kenalan bagi akaun pentadbir tambahan.",
    'ui__admin-alias-info__short-title' => "Maklumat hubungan",
    'ui__admin-alias-info__title' => "Maklumat Akaun Pentadbir Tambahan",
    'ui__admin-alias-password__description' => "Tukar kata laluan pentadbir tambahan.",

    'ui__admin-alias-password__short-title' => "Tukar kata laluan",
    'ui__admin-alias-password__title' => "Kata laluan pentadbir tambahan",
    'ui__admin-alias__description' => "Papar dan tukar akaun pentadbir tambahan.",

    'chk_js__warning_about_login_syntax' => "Anda boleh menggunakan huruf kecil abjad angka, simbol sempang dan garis bawah dalam nama pengguna. Nama pengguna hendaklah dimulai dengan simbol abjad. Kata laluan tidak boleh mengandungi nama pengguna dan tanda koma.",
    'chk_js__warning_about_ftp_login_syntax' => "Anda boleh menggunakan abjad angka, simbol sempang dan garis bawah dalam nama pengguna.",
    'chk_js__warning_about_login_syntax_win' => "Anda boleh menggunakan abjad angka huruf kecil, sengkang, titik dan simbol garis bawah dalam nama pengguna. Nama pengguna hendaklah dimulai dengan simbol abjad atau nombor. Kata laluan tidak boleh mengandungi nama pengguna dan tanda koma.",
    'chk_js__warning_about_passwd_syntax' => "Jangan gunakan tanda petikan, ruang dan aksara abjad kebangsaan dalam kata laluan.\nPanjang kata laluan hendaklah antara %1 hingga %2 aksara dan tidak boleh mengandungi nama pengguna.",
    'chk_js__warning_about_plesk_login_syntax' => "Anda boleh menggunakan huruf kecil abjad angka, simbol titik, sempang dan garis bawah dalam nama pengguna.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Anda boleh menggunakan huruf kecil abjad angka, simbol sempang dan garis bawah dalam nama pengguna. Nama pengguna hendaklah dimulai dengan simbol abjad.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Jangan gunakan petikan, ruang dan aksara abjad kebangsaan dalam kata laluan.\nPanjang kata laluan hendaklah antara %1 hingga %2 aksara dan tidak boleh mengandungi nama pengguna.",
    'chk_js__warning_about_pam_passwd_error' => "Akaun pengguna sistem yang dinyatakan tidak betul. %1",

    'cmd_server__admin_alias_not_found' => "Tidak dapat untuk mencari akaun pentadbir tambahan.",

    'panel_branding__skins_already_exists' => "Nota: Tema '%1' sudah wujud. Ia akan digantikan dengan tema yang sedang dipasang.",
    'panel_branding__skins_file_exists' => "Tidak dapat mewujudkan direktori untuk tema '%1': Fail dengan nama ini sudah wujud.",

    'actionlog__login_failed' => 'gagal untuk log masuk',
    'actionlog__event_cp_user_login_failed' => 'Pengguna plesk gagal untuk log masuk',
    'actionlog__api_login_failed' => 'gagal log masuk melalui API',
    'actionlog__event_cp_user_api_login_failed' => 'Pengguna plesk gagal untuk mengelog masuk melalui API',
    'actionlog__pw_reset' => 'meminta penetapan semula kata laluan',

    'ch_pass_admin__email_subject' => "Peringatan kata laluan Plesk",
    'ch_pass_admin__email_body' => "Helo, %1.\n\nKata laluan pentadbir tidak boleh dihantar melalui e-mel atas sebab keselamatan.\n\nUntuk log masuk sebagai 'admin', gunakan arahan 'plesk login'.\n\nUntuk menetapkan kata laluan 'admin' baharu, gunakan arahan 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Tidak dapat menghantar e-mel: %1',

    'ch_pass_by_secret__email_subject' => "Peringatan kata laluan Plesk",
    'ch_pass_by_secret__email_body' => "Helo %2,\n\nUntuk menetapkan kata laluan baru, ikuti pautan: %1\n\nLog masuk anda: %3",
    'ch_pass_by_secret__message_send_error' => 'Tidak boleh untuk menghantar kod rahsia: %1',
    'ch_pass_by_secret__title' => 'Tukar Kata Laluan Anda',
    'ch_pass_by_secret__secret' => 'Kod rahsia',

    'custom_button__noframe' => "Jangan gunakan bingkai",

    'custom_button__internal_hint' => 'Tentukan sama ada untuk membuka URL pada halaman Plesk atau dalam tetingkap pelayar yang baharu.',
    'custom_button__noframe_hint' => 'Jika anda menambahkan butang tersuai yang membawa kepada sambungan Plesk atau apl dalam Panel Pelanggan, anda boleh menentukan cara sambungan/apl ini dipaparkan: dalam bingkai atau sebahagian daripada GUI Plesk.',


    'actionlog__patch' => 'Kemas Kini',
    'actionlog__patch_available' => 'tersedia',
    'actionlog__event_patch_available' => 'Kemas kini tersedia',
    'actionlog__patch_installed' => 'telah dipasang',
    'actionlog__event_patch_installed' => 'Kemas kini telah dipasang',

    'actionlog__extension' => 'Sambungan',
    'actionlog__extension_status' => 'Status sambungan',
    'actionlog__cloning' => 'Pengklonan pelayan',
    'actionlog__cloning_complete' => 'selesai',
    'actionlog__event_cloning_complete' => 'Pengklonan pelayan selesai',

    'actionlog__ssl_web_binding' => 'Sijil SSL/TLS pada domain',
    'actionlog__ssl_web_binding_update' => 'diberikan/tidak diberikan',
    'actionlog__event_ssl_web_binding_update' => 'Sijil SSL/TLS pada domain diberikan/tidak diberikan',

    'actionlog__ssl_web_mail_binding' => 'Sijil SSL/TLS pada mel web',
    'actionlog__ssl_web_mail_binding_update' => 'diberikan/tidak diberikan',
    'actionlog__event_ssl_web_mail_binding_update' => 'Sijil SSL/TLS pada mel web diberikan/tidak diberikan',

    'actionlog__ssl_mail_binding' => 'Sijil SSL/TLS pada pelayan mel',
    'actionlog__ssl_mail_binding_update' => 'diberikan/tidak diberikan',
    'actionlog__event_ssl_mail_binding_update' => 'Sijil SSL/TLS pada pelayan mel diberikan/tidak diberikan',

    'actionlog__ssl_panel_binding' => 'Sijil SSL/TLS pada Plesk',
    'actionlog__ssl_panel_binding_update' => 'diberikan/tidak diberikan',
    'actionlog__event_ssl_panel_binding_update' => 'Sijil SSL/TLS pada Plesk diberikan/tidak diberikan',

    'actionlog__hostname' => 'Nama hos pelayan',
    'actionlog__hostname_changed' => 'diubah',

    'actionlog__smb_user' => 'Pengguna tambahan',
    'actionlog__smb_user_create' => 'Pengguna tambahan dibuat',
    'actionlog__smb_user_delete' => 'Pengguna tambahan dipadamkan',
    'actionlog__smb_user_update' => 'Pengguna tambahan dikemaskini',

    'actionlog__event_mail_management_status_update' => 'Kemas kini status pengurusan mel',
    'actionlog__mail_management' => 'Status pengurusan mel',
    'actionlog__mail_management_status_update' => 'dikemas kini',

    'virtualization_openvz' => 'BukaVZ',

    '__domains_total' => 'Jumlah mengikut domain',

    'chk_js__warning_about_admin_passwd_syntax' => "Jangan gunakan petikan, ruang, koma bertitik dan aksara abjad kebangsaan dalam kata laluan.\nKata laluan hendaklah di antara %1 dan %2 panjang aksara dan ia tidak seharusnya mengandungi nama pengguna.",

    'passwordSecurityLevelCheckFailed' => 'Kata laluan anda tidak cukup kompleks. Mengikut dasar pelayan, kekuatan kata laluan yang minima ialah %1. Untuk kekuatan kata laluan diperbaiki, gunakan nombor, aksara huruf kecil dan besar serta aksara khas seperti !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Sangat lemah',
    'passwordSecurityLevelCheckFailedWeak' => 'Lemah',
    'passwordSecurityLevelCheckFailedMediocre' => 'Sederhana',
    'passwordSecurityLevelCheckFailedStrong' => 'Kuat',
    'passwordSecurityLevelCheckFailedStronger' => 'Sangat kuat',

    'filemanager__invalid_path' => "Laluan yang ditentukan tidak sah",

    'ui__client/domain/dns/sync__description' => 'Gunakan perubahan daripada templat DNS lebar pelayan DNS kepada zon.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Tidak dapat menggunakan perubahan templat DNS pada zon kerana zon dilayani oleh pelayan DNS lain.',
    'ui__client/domain/dns/sync__short-title' => 'Guna Perubahan Templat DNS',
    'ui__client/domain/dns/sync__done' => 'Perubahan daripada templat DNS telah berjaya digunakan pada zon.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Gunakan perubahan daripada templat DNS lebar pelayan DNS kepada zon.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Tidak dapat menggunakan perubahan templat DNS pada zon kerana zon dilayani oleh pelayan DNS lain.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Guna Perubahan Templat DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Perubahan daripada templat DNS telah berjaya digunakan pada zon.',
    'dns__dns_default_ipv4_modified' => 'Rekod dengan alamat IP ini akan dianggap sebagai \'diubahsuai pengguna\' dan tidak akan disegerakkan dengan templat lebar pelayan DNS.',
    'dns__dns_default_ipv6_modified' => 'Rekod dengan alamat IP ini akan dianggap sebagai \'diubahsuai pengguna\' dan tidak akan disegerakkan dengan templat lebar pelayan DNS.',

    'dns__view_dns_record_master_title' => 'Melihat Rekod Sumber',
    'dns__view_dns_record_off_title' => 'Melihat Rekod Pelayan nama',
    'dns__view_dns_record_slave_title' => 'Melihat Rekod Pelayan DNS Primer',

    'dns_unable_to_resolve_hostname' => "Tidak dapat menyelesaikan nama hos \\\"%1\\\": %2Pastikan penyelesai DNS sistem pengendalian telah disediakan dan berfungsi dengan betul.",

    'no_database_server_available' => 'Tiada pelayan pengkalan data yang tersedia untuk langganan ini.',

    'database_used_by_application_can_not_be_moved' => 'Tidak dapat mengalihkan pangkalan data: Aplikasi tapak web menggunakan pangkalan data ini.',
    'database_user_update_orphaned_is_restricted' => 'Mengemas kini akaun pengguna pangkalan data Yatim adalah dilarang. Anda hanya boleh padam atau baikinya.',

    'database_unable_to_get_max_filesize_default_message' => 'Tidak boleh menentukan saiz fail maksimum bagi pangkalan data: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Tidak boleh setkan saiz fail maksimum bagi pangkalan data: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Tidak boleh menentukan saiz fail log maksimum bagi pangkalan data: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Tidak boleh setkan saiz fail log maksimum bagi pangkalan data: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Tidak boleh menentukan had semasa daripada saiz fail pangkalan data SQL Microsoft \'%1\'. Menetapkan had yang baharu adalah mustahil.',
    'database_unable_to_set_max_filesize' => 'Tidak dapat menetapkan had untuk saiz fail pangkalan data Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Tidak boleh menentukan had semasa daripada saiz fail log pangkalan data SQL Microsoft \'%1\'. Menetapkan had yang baharu adalah mustahil.',
    'database_unable_to_set_max_log_filesize' => 'Tidak dapat menetapkan had untuk saiz fail pangkalan data Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Tidak boleh mencipta pangkalan data SQL Microsoft \'%1\': Saiz failnya lebih besar dari saiz maksimum yang dibenarkan.',
    'database_unable_to_move_because_max_filesize' => 'Tidak boleh mengalih pangkalan data SQL Microsoft \'%1\': Saiz failnya lebih besar dari saiz maksimum yang dibenarkan: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Tidak boleh mencipta pangkalan data SQL Microsoft \'%1\': Saiz fail lognya lebih besar dari saiz maksimum yang dibenarkan.',
    'database_unable_to_move_because_max_log_filesize' => 'Tidak boleh mengalih pangkalan data SQL Microsoft \'%1\': Saiz fail lognya lebih besar dari saiz maksimum yang dibenarkan: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Tidak boleh pulihkan pangkalan data SQL Microsoft \'%1\': Saiz failnya lebih besar dari saiz maksimum yang dibenarkan.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Pelayan MS SQL yang sama telah didaftarkan dalam Plesk. Sila tentukan pelayan MS SQL sebagai sandbox.',
    'database_server__mssql_server_registered_as_sandbox' => 'Pelayan MS SQL sandbox yang sama telah didaftarkan dalam Plesk. Sila tentukan pelayan MS SQL sebagai sandbox.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Tidak dapat menyambung ke pelayan melalui \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Ciri %1 tidak disokong oleh nod perkhidmatan yang berikut: %2. Ciri ini akan menyahdayakan untuk semua ciptaan objek pada nod ini.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Pelayan ini tidak menyokong ciri %1. Ciri ini akan menyahdayakan untuk semua objek yang dipulihkan.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Komponen %1 tidak dipasang. Ia tidak akan tersedia untuk tapak web berikut: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Komponen %1 tidak dipasang. Ini akan digantikan dengan %2 untuk tapak web yang berikut: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Versi Plesk semasa tidak menyokong nama pengguna dalam tempoh (.) aksara. Pelanggan dan penjual semula dengan nama pengguna seperti itu tidak akan dipulihkan.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Fail sokongan dengan data tidak dapat dicari untuk %1 %2. Data untuk %1 %2 tidak akan dipulihkan.',

    'bu_conflict_resolver_zone_master_removed' => "Tidak boleh untuk memulihkan rekod utama DNS: Rekod di dalam titik zon sekunder untuk alamat IP yang sedia ada %1. Rekod utama DNS akan dibuang daripada zon sekunder.",

    'bu_conflict_resolver_not_available_scripting' => '%1 tidak disokong.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 tidak disokong. Ia tidak akan tersedia untuk tapak web berikut: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Komponen %1 tidak dipasang.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Ia tidak akan tersedia untuk nod perkhidmatan berikut: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Ia tidak akan tersedia untuk objek berikut: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Pelayan pengkalan data yang berikut tidak tersedia pada pelayan ini: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Fail sandaran pangkalan data MS SQL disimpan dalam format natif MS SQL, yang boleh dipulihkan hanya kepada pelayan MS SQL setempat atau pelayan MS SQL jauh dengan tetapan sandaran yang dikonfigurasi sepenuhnya. Beberapa pangkalan data anda tidak dipulihkan kerana tiada pelayan MS SQL yang sesuai yang berdaftar di Plesk. Domain berikut didapati terjejas: {{objects}}. Sila hubungi pembekal pengehosan anda.',

    'bu_conflict_resolver_not_available_webmail' => 'Perkhidmatan mel web %1 tidak tersedia. Ini akan digantikan dengan %2 untuk objek yang berikut: {{objek}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Perkhidmatan mel web %1 tidak tersedia. Ini akan digantikan dengan %2 untuk pelan perkhidmatan yang berikut: {{objek}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Jenis pengkalan data '%1' tidak menyokong nama pengguna yang berkebetulan dengan nama pengkalan data. Pengguna '%2' will be renamed '%3' untuk pengkalan data '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Had penggunaan ruang cakera tidak disetkan di dalam konfigurasi pelayan destinasi. Nilai tetapan ini akan bertukar kepada "Tanpa had".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Had jumlah sambungan tidak disetkan di dalam konfigurasi pelayan destinasi. Nilai tetapan ini akan bertukar kepada "Tanpa had".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Had penggunaan trafik tidak disetkan di dalam konfigurasi pelayan destinasi. Nilai tetapan ini akan bertukar kepada "Tanpa had".',
    'cu__pleskrestore_backup_file_extracted' => 'Fail sandaran diekstrak kepada "%1".',
    '__mod_bw_not_supported' => 'Modul mod_bw untuk pelayan web Apache tidak disokong kerana konfigurasi bagi sistem fail. Had penggunaan trafik dan jumlah sambungan maksimum tidak akan berfungsi.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Keizinan POP3 untuk penggegantian mel tidak disokong, sebaliknya pengesahan POP3 sebelum SMTP akan digunakan. {{objek}}',
    'bu_conflict_resolver_service_plan_name' => 'Pelan perkhidmatan \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 tidak disokong. Ini akan digantikan dengan %2 untuk pelan perkhidmatan yang berikut: {{objek}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 tidak disokong. Ini akan digantikan dengan %2 untuk tapak web yang berikut: {{objek}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Objek yang berikut tidak dijumpai di dalam fail sandaran: %1',
    'bu_conflict_resolver_absent_domains' => 'Beberapa objek tidak boleh dipulihkan kerana dimiliki oleh domain yang berikut tidak dijumpai dalam Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Beberapa tapak web tidak boleh dipulihkan kerana dimiliki oleh domain induk yang berikut tidak dijumpai dalam Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Zon DNS yang tidak boleh dipulihkan: Perkhidmatan DNS dimatikan di dalam konfigurasi pelayan.',
    'bu_conflict_resolver_mail_not_supported' => 'Tidak dapat untuk memulihkan peti mel: Perkhidmatan mel dimatikan di dalam konfigurasi pelayan.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'Tindakan waktu tamat melahu yang ditentukan tidak disokong oleh pelayan web IIS. Nilai ini akan diset semula kepada %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Tindakan pengehadan CPU yang ditentukan tidak disokong oleh pelayan web IIS. Nilai ini akan diset semula kepada %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'sijil SSL/TLS pelayan %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Sijil SSL/TLS %2 daripada domain %1',
    'bu_conflict_detector_ssl_cert_name' => 'Sijil SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'Kandungan objek yang berikut tidak boleh dipulihkan kerana objek tidak dijumpai dalam Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Kandungan peti mel yang berikut tidak boleh dipulihkan kerana peti mel tidak dijumpai dalam Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Kandungan senarai mel yang berikut tidak boleh dipulihkan kerana senarai mel tidak dijumpai dalam Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Kandungan pengkalan data yang berikut tidak boleh dipulihkan kerana pengkalan data tidak dijumpai dalam Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Pemulihan aplikasi "%1" pada "%2" telah gagal kerana aplikasi lain sudah dipasang pada "%3". Anda boleh mengalih keluar aplikasi yang dipasang dan cuba lagi.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Fungsi auto-balas mel tidak disokong.',
    'bu_conflict_resolver_not_available_mail_content' => 'Fungsi pemulihan kandungan mel tidak disokong.',
    'bu_conflict_resolver_invalid_mail_name' => 'Peti mel berikut belum dipulihkan kerana subalamat e-mel didayakan dan terdapat alamat e-mel tertentu mengandungi tanda "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Pengguna berikut belum dipulihkan kerana subalamat e-mel didayakan dan terdapat alamat e-mel tertentu mengandungi tanda "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Lesen berikut telah tamat tempoh dan tidak akan dipulihkan: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Lesen berikut tidak sah atau tamat tempoh dan tidak akan dipulihkan: {{objects}}',
    'expiration_unsupported' => "Had 'tamat tempoh' tidak disokong.",

    'component_name__dbconnector' => "Penyambung Pengkalan Data",
    'component_name__mysqlserver' => 'Pelayan MySQL',
    'component_name__troubleshooting' => 'Penyelesaian Masalah',
    'component_name__savi' => 'Antara Muka Anti-Virus Sophos',

    '__subscription_has_no_license_key' => 'Nod perkhidmatan #%1 menyediakan sumber langganan yang tidak mempunyai kunci lesen yang berkaitan.',
    '__subscription_has_expired_license_key' => 'Nod perkhidmatan #%1 menyediakan sumber langganan di mana kunci lesen %2 telah tamat tempoh.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Fail konfigurasi tidak boleh disimpan',
    '__cfgmonConfigurationFileSaveErrorBody' => "Beberapa konfigurasi pelayan web pada hos tidak boleh disimpan<%%host%%>: Ralat berikut telah berlaku:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Pilihan ini mendayakan keupayaan untuk mengkonfigurasi alamat e-mel gaya VERP untuk senarai mel',
    'mail__enter_right_ip_mask' => "Masukkan topeng IP di antara 1 dan 32",
    'mail__enter_right_ip_mask_24' => "Masukkan topeng IP di antara 24 dan 32",
    'mail__invalid_dom_name' => "Nama domain %1 tidak sah.",
    'mail__invalid_pop_lock_time' => "Masa kunci POP3 adalah tidak sah.",
    'mail__invalid_rbl_server' => "Nama zon DNS adalah tidak sah.",
    'mail__total_files_size' => "Jumlah saiz repositori: %1",
    'mail__filename_already_in_repository' => "Fail dengan nama yang sama sudah ada dalam repositori",
    'mail__no_white_list_mask_feature_24' => "Gunakan nilai topeng 24 atau lebih tinggi.\nPelayan mel anda tidak menyokong topeng tetapan. Kita hanya boleh emulasi tetapan topeng bagi nilai tidak kurang daripada 24.",
    'mail__unable_add_new_mail_name' => "Tidak dapat untuk menambah akaun mel: %1",
    'mail_server_is_not_installed' => 'Pelayan mel (Postfix atau Qmel) tidak dipasang. Pasangkannya untuk meneruskan kerja.',
    'mail_server_not_available' => 'Tiada sokongan dari pelayan mel yang tersedia pada nod perkhidmatan.',
    '__not_installed' => '(tidak dipasang)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Menyahdayakan penapisan spam pada mesej e-mel keluar.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Pengehadan jumlah mesej e-mel keluar daripada domain ke domain %1 tidak disokong oleh nod perkhidmatan.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Pengehadan jumlah mesej e-mel keluar daripada peti mel ke domain %1 tidak disokong oleh nod perkhidmatan.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Nyatakan sekurang-kurangnya satu jenis alamat (IPv4 atau IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Mod mel keluar yang ditentukan tidak sah.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Alamat IPv4 yang ditentukan tidak sah.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Alamat IPv6 yang ditentukan tidak sah.',
    'mail__outgoing_email_mode_unavailable' => 'Menukar mod mel keluar tidak disokong, mungkin kerana pelayan mel Postfix tidak dipasang pada pelayan ini.',

    'mail__autoresponder_attachment_not_supported' => 'Pelayan mel yang digunakan pada masa ini tidak menyokong pengurusan lampiran auto-responder.',

    'mail__smtp_white_list_not_supported' => 'Pelayan mel yang digunakan pada masa ini tidak menyokong penyenaraian putih alamat IP.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Topeng CIDR tidak disokong oleh pelayan mel yang dipilih pada masa ini. Nyatakan alamat IP dalam format \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'Corak IP kad bebas tidak disokong oleh pelayan mel yang dipilih pada masa ini. Nyatakan alamat IP dalam format \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Tidak dapat mengubah tetapan untuk pengesahan perkhidmatan DKIM',

    'sfdk_domain__serverwide_disabled' => 'Matikan menurut dasar pelayan',
    'feature__domainkeys__serverwide_disabled' => 'Perlindungan spam DKIM seluruh pelayan telah dimatikan',

    'defaultcomponents__error_set_default' => 'Tidak dapat menetapkan %1 sebagai lalai %2: %3',
    'defaultcomponents__error_set_default_none' => 'Tidak dapat menetapkan tiada komponen lalai untuk %1: %2',
    'defaultcomponents__required_package_not_default' => 'Komponen %1 diperlukan kerana kerjanya bukannya lalai.',

    '__percentage' => '%',
    '__seconds' => 'Saat',
    '__resource_remain' => 'Tinggal',

    '__not_registered' => '(tidak didaftar)',
    '__php_handler_id' => 'Versi PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Pengendali PHP "%1" tidak didaftarkan. Kemungkinan telah dipadam daripada pelayan. Daftarkan penggendali dengan sifat yang sama dan cuba lagi.',
    '__php_handler_not_registered_on_domain' => 'Domain "%1": pengendali PHP "%2" tidak didaftarkan. Kemungkinan telah dipadam daripada pelayan. Daftarkan penggendali dengan sifat yang sama dan cuba lagi.',
    '__php_fpm_handler' => 'Aplikasi FPM',
    '__php_fpm-dedicated_handler' => 'Himpunan aplikasi khusus FPM',

    'mailname_create_assigned_user_dublicate_error' => 'Pengguna untuk peti mel tidak boleh dicipta. Pengguna yang menggunakan nama pengguna %1 sudah wujud dan mempunyai peti mel yang lain.',
    'mailname_create_assigned_user_role_absent_error' => 'Pengguna untuk peti mel tidak boleh dicipta. Peranan lalai %1 dari pengguna tidak wujud.',

    'gphd__mime_types' => 'Jenis MIME',
    'gphd__handlers' => 'Penggendali Apache',
    'gphd__ip_restrictions_allow' => 'Benarkan capaian ke laman hos dan rangkaian yang ditentukan (tidak termasuk yang ditolak)',
    'gphd__ip_restrictions_deny' => 'Tolak capaian ke laman hos dan rangkaian yang ditentukan',
    'gphd__directory_index' => 'Fail indeks',
    'gphd__nginx_transparent_mode' => 'Mod semasa Apache mengendalikan kedua-dua kandungan statik dan dinamik, sementara nginx hanya menghantar permintaan dan maklum balas HTTP tanpa pengubah suaian.',
    'gphd__nginx_serve_static' => 'Fail statik dilayani secara langsung oleh nginx',
    'gphd__nginx_static_extensions' => 'Sambungan fail statik yang mesti dikendalikan oleh nginx',
    'gphd__nginx_serve_php' => 'Proses fail PHP oleh nginx',
    'gphd__www_root' => 'Direktori Akar WWW',

    'eol__none' => 'jangan ubah suai',
    'eol__lf' => 'tukar kepada gaya Unix',
    'eol__cr' => 'tukar kepada gaya MacOS',
    'eol__crlf' => 'tukar kepada gaya Windows',

    'ui__dns_bad_zone' => 'Zon "%1" tak konsisten:',
    'ui__dns_ns_has_no_address_records' => 'Rekod NS "%1" tidak mempunyai rekod (A atau AAAA).',
    '__dns_bad_zone' => 'Zon "%1" tak konsisten:',
    '__dns_ns_has_no_address_records' => 'Rekod NS "%1" tidak mempunyai rekod (A atau AAAA).',
    '__dns_ptr_is_wildcard' => 'Rekod PTR "%1" tidak sah: Titik rekod kepada domain kad bebas.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Benarkan capaian jauh untuk pengguna pengkalan data \'%3\' daripada pelanggan \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Sambungan jauh tidak dibenarkan untuk pengguna pengkalan data \'%1\': Tidak boleh menentukan nombor port TCP yang digunakan oleh pelayan SQL Microsoft \'%2\'. Berikut adalah kemungkinannya: tidak mendayakan protokol TCP/IP di dalam konfigurasi rangkaian pelayan atau pelayan dikonfigurasikan untuk menggunakan port TCP yang dinamik. Konfigurasikan pelayan untuk mendengar pada port TCP yang khusus dan cuba benarkan lagi sambungan jauh.',

    'command__convertResellerHasCustomer' => 'Akaun penjual semula \'%1\' mempunyai satu atau lebih akaun pelanggan. Untuk menukar akaun penjual semula ini kepada akaun pelanggan, mula-mula sekali pindahkan akaun pelanggan kepada pemilik baharu atau tukarkannya kepada akaun penjual semula.',
    'command__convertResellerNotReseller' => 'Akaun penjual semula sahaja yang boleh ditukar kepada akaun pelanggan. \'%1\' bukan penjual semula.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Tidak dapat segerakkan langganan dengan pelan perkhidmatan. Tetapan langganan berikut mempunyai konflik dengan pelan perkhidmatan: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Akaun \'%1\' ialah akaun penjual semula. Akaun penjual semula tidak boleh dialihkan kepada pemilik baharu kerana kepunyaan pentadbir pelayan.',
    'moveCustomer__wrong_owner_type' => "Akaun pelanggan '%1' hanya boleh dialihkan kepada penjual semula atau pentadbir, bukannya kepada pelanggan yang lain.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Akaun pengguna \'%1\' kepunyaan pemilik yang terpilih.',
    'upgradeClient__user_is_admin' => 'Akaun \'%1\' tidak boleh ditukarkan kepada akaun penjual semula kerana ini ialah akaun pentadbir.',

    'mail__error_setting_max_connections_courier' => 'Jumlah maksimum sambungan tidak boleh disetkan (IMAP, POP3, IMAP pada SSL/TLS atau POP3 pada SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Jumlah maksimum sambungan tidak boleh disetkan (IMAP, POP3, IMAP pada SSL/TLS atau POP3 pada SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Jumlah maksimum sambungan tidak boleh disetkan (IMAP, POP3, IMAP pada SSL/TLS atau POP3 pada SSL/TLS) bagi setiap alamat IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Jumlah maksimum sambungan tidak boleh disetkan (IMAP, POP3, IMAP pada SSL/TLS atau POP3 pada SSL/TLS) bagi setiap alamat IP untuk pengguna mel yang khusus: %1',
    'outgoing_messages_limit_value_invalid' => 'Nilai tersebut mestilah dalam julat %%MIN%%..%%MAX%%. Hanya pentadbir Plesk boleh melaraskan tetapan ini.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Domain yang berikut menggunakan alamat emel luaran untuk pemajuan mel serta penghantaran mel kepada alamat yang tidak wujud. Mesej yang dihantar kepada alamat ini tidak akan dikira dalam Kawalan Mel Keluar:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Had mel keluar tidak akan berfungsi untuk penghantar mel yang menggunakan alamat IP di dalam senarai putih pelayan mel. Contohnya jika terdapat hos setempat (127.0.0.0 / 8, ::1 / 128) di dalam senarai putih, semua mel akan berjaya dihantar daripada pelayan setempat tanpa mengira hadnya. Penghantar mel boleh menggunakan sama ada alamat IP setempat (tapak web dan skrip tersuai yang dihoskan pada pelayan setempat) atau luarannya (pelanggan yang menghantar mel daripada pelanggan mel yang dipasang pada peranti mudah alih atau komputer). Untuk pengehadan berfungsi pada semua penghantar mel (setempat dan luaran kedua-duanya), alih keluar semua alamat IP dan rangkaian daripada senarai putih. Pastikan bahawa membuang hos setempat (127.0.0.0 / 8, ::1 / 128) daripada senarai putih mungkin akan mengganggu operasi tapak web dan skrip yang menghantar mel daripada pelayan ini. Untuk maklumat tentang pengehadan pada mel keluar, lihat Panduan Pentadbir, Perlindungan daripada Spam Keluar.',
    'outgoing_messages_relay_open' => 'Geganti mel dibuka: Had mel keluar tidak akan berfungsi.',

    'notification_aps_app_updates_available' => 'Kemas kini tersedia untuk aplikasi yang berikut:',
    'notification_aps_app_updates_installed' => 'Kemas kini telah dipasang secara automatik untuk aplikasi yang berikut:',
    'notification_aps_app_updates_requirements' => 'Kemas kini tersedia untuk aplikasi yang berikut tetapi tidak boleh dipasang kerana tetapan pengehosan tapak web yang berkaitan tidak memenuhi keperluan pemasangan.',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Pasang masuk "%%name%%" pada %%parentName%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" pada %%parentName%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Pasang masuk "%%name%%" pada %%parentName%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" pada %%parentName%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Versi anda: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Pasang masuk "%%name%%" pada %%parentName%% (%%url%%). Versi anda: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" pada %%parentName%% (%%url%%). Versi anda: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versi baharu: %%to%%. Versi sebelumnya: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versi baharu: %%to%%. Versi sebelumnya: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versi baharu: %%to%%. Versi sebelumnya: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versi anda: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'apl luaran',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domain',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Alamat E-mel',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Langganan',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 mesej per jam',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Tidak terhad',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, hadnya ialah %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 cubaan untuk melebihi had daripada %2 kepada %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 cubaan untuk melebihi had daripada %2 sehingga sekarang',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Larangan Alamat IP (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Komponen Fail2ban tidak dipasang pada pelayan destinasi.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Pasang Fail2ban. Ambil perhatian yang ini akan memakan masa beberapa minit.',

    'plesk_key__no_reseller_support' => 'Penjual semula tidak boleh diuruskan kerana pembatasan lesen.',
    'plesk_key__no_customers_support' => 'Pelanggan tidak boleh diuruskan kerana pembatasan lesen.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Paparan Pembekal Perkhidmatan tidak boleh ditukar kerana pembatasan lesen.',
    'plesk_key__no_security_core_support' => 'Ciri teras keselamatan (ModSecurity dan Fail2Ban) tidak tersedia kerana pembatasan lesen.',
    'plesk_key__outgoing-antispam' => 'Kawalan Mel Keluar',
    'plesk_key__security-core' => 'Teras Kawalan (ModSecurity dan Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Pengurusan akaun',
    'plesk_key__can-manage-subscriptions' => 'Pengurusan langganan',
    'plesk_key__can-manage-customers' => 'Pengurusan pelanggan',
    'plesk_key__can-manage-resellers' => 'Pengurusan penjual semula',
    'plesk_key__can-manage-custom-view' => 'Ketersediaan Mod Terhad',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Pengurusan langganan telah dimatikan tetapi anda mempunyai beberapa langganan (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Pengurusan penjual semula telah dimatikan tetapi anda mempunyai beberapa penjual semula (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Pengurusan pelanggan telah dimatikan tetapi anda mempunyai beberapa pelanggan (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Sumber langganan tertentu yang anda tidak boleh uruskan lagi dalam antara muka Plesk (seperti had pada peti mel dan ruang cakera domain) kini ditetapkan kepada tidak terhad.',
    'plesk_key__no_subscriptions_support' => 'Langganan tidak boleh diuruskan kerana pembatasan lesen.',
    'plesk_key__no_custom_view_support' => 'Anda tidak boleh menggunakan Mod Terhad disebabkan pembatasan lesen.',
    'plesk_key__trial_forbidden_region' => 'Maaf, Plesk tidak tersedia di rantau anda pada masa ini.',
    'additional_key__main_key' => 'Kunci ini ialah kunci utama: Kunci utama tidak boleh dimuat naik sebagai kunci tambahan.',

    'gch__hosting_waf_rule_engine' => 'Mod tembok api aplikasi web',

    'backup__fieldset__restoration_options' => 'Pilihan pemulihan',
    'backup__restore_options__restore' => 'Pulihkan',
    'backup__restore_options__domain__domain_configuration' => 'Konfigurasi domain',
    'backup__restore_options__domain__virtual_host_content' => 'Kandungan hos maya',
    'backup__restore_options__domain__mail' => 'Mel',
    'backup__restore_options__domain__databases' => 'Pangkalan Data',
    'backup__restore_options__client__client_configuration' => 'Konfigurasi akaun pelanggan',
    'backup__restore_options__client__domains' => "Domain pelanggan",
    'backup__restore_options__reseller__reseller_configuration' => 'Konfigurasi akaun penjual semula',
    'backup__restore_options__reseller__personal_domains' => "Domain penjual semula",
    'backup__restore_options__reseller__clients' => "Pelanggan penjual semula",
    'backup__restore_options__admin__server_configuration' => 'Tetapan pelayan',
    'backup__restore_options__admin__administrator_configuration' => 'Konfigurasi akaun pentadbir',
    'backup__restore_options__admin__personal_domains' => "Domain pentadbir",
    'backup__restore_options__admin__personal_clients' => "Pelanggan pentadbir",
    'backup__restore_options__admin__resellers' => 'Penjual semula',

    'badge_new' => 'Baru',
    'upgrade_php_on_subscription' => 'Naik taraf PHP pada langganan anda kepada versi 5.3.0 atau yang terkemudian.',

    'pkey_notify__body_expiration_notification' => 'Kunci lesen tamat tempoh. Beberapa ciri boleh menjadi tidak tersedia. Sila hubungi pembekal pengehosan anda.',

    'crontab__crontab_entry_exists' => "Tugasan yang dijadualkan sudah wujud.",
    'crontab__crontab_entry_not_exists' => "Tugasan yang dijadualkan tidak wujud.",
    'crontab__invalid_values_found' => "Nilai parameter tidak betul.",
    'crontab__cmd_max_len' => "Perintah tidak boleh lebih panjang daripada %1 aksara.",

    'domain__domain_exists' => "Terdapat domain yang mempunyai prefiks 'www' dan nama yang sama: %1.%2.",
    'domain__subdomain_exists' => "Terdapat subdomain yang mempunyai prefiks 'www' dan nama yang sama: %1.%2.",
    'domain__dalias_exists' => "Terdapat alias domain yang mempunyai prefiks 'www' dan nama yang sama: %1.%2.",
    'domain__record_exists' => "Terdapat rekod DNS menunding kepada hos %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Sijil '%1' tidak boleh diset sebagai yang lalai: kunci privasi hilang.",
    'ip_addr__update_dns_error' => 'Masalah berlaku semasa mengemas kini alamat IP dalam zon DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Tidak dapat menambahkan alamat IP. Antara muka rangkaian ini memperoleh alamat IP secara automatik.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Tidak dapat mengalih keluar alamat IP %1. Antara muka rangkaian ini memperoleh alamat IP secara automatik.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Tidak dapat membaiki alamat IP %1. Antara muka rangkaian ini memperoleh alamat IP secara automatik.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Tidak dapat menukar antara muka alamat IP %1 kerana antara muka rangkaian %2 memperoleh alamat IP secara automatik.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Melebihi had langganan untuk bilangan %%type%%. Had ialah %%limit%% dan %%usage%% sedang digunakan.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Penciptaan %%type%% tidak dibenarkan untuk langganan ini.',
    'shm_lmsg__resource_title__db-mysql' => 'Pangkalan data MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Pangkalan data MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Pangkalan data PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'pengguna pangkalan data',
    'shm_lmsg__resource_title__iis-application-pool' => 'Himpunan aplikasi IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'akaun FTP tambahan',

    'db_user_unable_remove_mysql_global_privileges' => 'Tidak dapat mengeluarkan keistimewaan global MySQL daripada pangkalan data pengguna %1. Sebab: %2',
    'report__client_description' => 'Perihalan',

    'db__user_role_error' => 'Peranan pengguna pangkalan data yang salah telah ditetapkan: %1. Sila pilih satu daripada peranan berikut: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Tidak dapat menetapkan limit saiz fail untuk pangkalan data Microsoft SQL Server berikut kerana ia mempunyai saiz fail yang lebih besar: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Tidak dapat menetapkan limit saiz fail log untuk pangkalan data Microsoft SQL Server berikut kerana ia mempunyai saiz fail log yang lebih besar: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Tidak dapat menyediakan alamat IP awam: alamat IP peribadi mesti wujud.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Tidak dapat menyediakan alamat IPv4 awam untuk alamat IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Tidak dapat menyediakan alamat IPv6 awam untuk alamat IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Tidak dapat menyediakan alamat IP awam: alamat IP tidak sah.',

    '__user_already_exists' => "Pengguna %1 telah wujud.",
    '__user_name_is_empty' => "Sila nyatakan nama pengguna.",

    'upgrade_php_on_domain' => 'Tidak dapat menemui versi PHP 5.3.0 atau lebih baharu pada mana-mana domain WordPress anda. Cuba naik taraf PHP.',

    'component_name__waf' => 'Tembok Api Aplikasi Web',
    'component_name__vcs' => 'Sistem Kawalan Versi',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Kemungkinan percubaan penipuan dikesan: Pautan cuba memaparkan kandungan yang tidak relevan.',
    'forceResetPasswordUpdated' => 'Kata laluan anda telah ditukar. Gunakan kata laluan baharu untuk log masuk ke Plesk.',

    'php_handlers_error_no_available_instance' => 'Tidak boleh untuk mencipta domain: pengendali PHP tidak tersedia.',
    'domain_error_unable_to_apply_hosting_settings' => 'Tidak dapat menggunakan tetapan pengehosan: %1',

    'plesk_not_configured' => 'Plesk tidak dikonfigurasi. Pergi ke panel kawalan untuk melakukan konfigurasi pasca pemasangan.',
    'cmd_mail__mail_password_duplicated' => 'Pasangan alamat e-mel dan kata laluan yang dinyatakan sudah wujud pada pelayan mel. Sila nyatakan alamat e-mel atau kata laluan lain.',

    'extensionRequirementOs' => 'Sistem pengendalian (%1) tidak disokong oleh pakej ini.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 ialah versi paling awal yang disokong oleh pakej ini.',
    'extensionRequirementPleskMaxVersion' => 'Versi yang bermula daripada Plesk %1 tidak disokong oleh pakej ini.',
    'extensionBlacklisted' => 'Sambungan %1 tidak dibenarkan untuk pemasangan.',
    'extensionDisabled' => 'Sambungan dinyahdayakan.',


    'optimization_settings__unable_set_mpm_event' => 'Tidak dapat menetapkan mod mpm_event: ia memerlukan modul Apache PHP5 dimatikan tetapi modul ini digunakan oleh domain.',
    'optimization_settings__unable_turn_off_php' => 'Tidak dapat mematikan modul Apache PHP5: ia digunakan oleh domain.',

    'hst_def__fp_admin_login' =>  'Nama Pengguna FTP',
    'hst_def__fp_admin_passwd' =>  'Kata Laluan FTP',

    'database_user_orphaned_old_password_wrong' => "Tidak dapat membaiki pengguna yatim '%1': kata laluan tidak betul.",
    'cannot_load_partner_central_property_key_no_exist' => "Tidak dapat mengambil sifat tersuai: kunci lesen tidak wujud.",
    'extensionScriptFailure' => "Pelaksanaan %1 telah gagal dengan mesej berikut:\n%3",
    '__ssl_redirect' => "SEO-safe 301 kekal diubah hala dari HTTP ke HTTPS",
    'component_name__dotnetcore' => 'Teras .NET',
    'mail__dkim_not_supported' => 'Pengurusan DKIM tidak disokong.',
    'mail__dmarc_not_supported' => 'Pengurusan DMARC tidak disokong.',
    'mail__relay_white_list_not_supported' => 'Pengurusan penggantian senarai putih tidak disokong.',
    'mail__black_list_not_supported' => 'Pengurusan senarai hitam tidak disokong.',
    'mail__autoresponder_not_supported' => 'Pengurusan auto-responder tidak disokong.',
    'defaultcomponents__not_supported_version' => '(versi yang tidak disokong)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Sijil \'%1\' tidak dijumpai.',
    'certificate__unable_setup_certificate' => 'Tidak dapat memasang sijil: Kunci dan kandungan sijil peribadi hilang.',
    'certificate__used_by_panel' => 'Salah satu sijil yang anda akan memadam digunakan untuk melindungi Plesk.',
    'certificate__used_by_mail_server' => 'Salah satu sijil yang anda akan memadam digunakan untuk melindungi pelayan mel.',
    'certificate__used_by_domain_service' => 'Salah satu sijil yang anda akan padam digunakan oleh perkhidmatan domain.',
    'mail_server__not_installed' => 'Tidak dapat memasang sijil untuk pelayan mel kerana pelayan mel tidak dipasang.',

    'email_activation_mail_subject' => 'Sila aktifkan akaun anda dalam Plesk',
    'email_activation_mail_body' => "Akaun telah dicipta pada pelayan Plesk %1\n\nButiran akaun:\nNama: %2\nAlamat e-mel: %3\n\nSekiranya maklumat ini betul dan akaun tersebut telah dibuat untuk anda, sila aktifkan dengan pautan berikut:\n\n%4\n\nDengan mengaktifkan akaun, anda memberi kuasa kepada pemegang pelayan untuk mengumpul, menyimpan, memproses dan menggunakan data peribadi anda (nama dan e-mel) untuk mencipta dan menyokong akaun anda, selaras dengan undang-undang perlindungan data yang diguna pakai pada masa ini, sebagai sebahagian daripada kontrak.",

    'backup_transport_permission_name' => '%1 pengurusan',
    'backup_transport_permission_description' => 'Benarkan penggunaan %1 untuk menyimpan sandaran.',

    'domain_move_err_target_no_hosting' => 'Tidak dapat mengalihkan domain ke langganan tanpa pengehosan.',
    'domain_move_err_already_in_target' => 'Domain sudah berada di langganan sasaran.',
    'domain_move_err_main_domain' => 'Domain utama tidak dapat dialihkan.',
    'domain_move_err_subdomain_without_parent' => 'Tidak dapat mengalihkan subdomain %1 tanpa domain induk %2.',
    'domain_move_err_root_exists' => 'Laluan sasaran untuk www_root %1 telah wujud.',
    'domain_move_err_nested_roots' => 'Tidak dapat mengalihkan domain kerana ia berkongsi akar dokumen dengan domain lain: %1.',
    'domain_move_err_no_mail_service' => 'Tidak dapat mengalihkan domain kerana perkhidmatan mel dinyahdayakan pada langganan sasaran.',
    'domain_move_err_app' => "Aplikasi yang dipasang pada %1 tidak dialihkan ke langganan '%2': %3",
    'domain_move_database_used_by_app' => "Pangkalan data '%1' pada %2 digunakan oleh aplikasi yang dialihkan. Untuk menetapkan semula pangkalan data kepada '%3', jalankan perintah `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Sasaran langganan '%1' dikunci untuk disegerakkan.",
    'domain_move_filesharing_disabled' => 'Perkongsian fail dinyahdayakan.',
    'domain_move_website_preview_disabled' => 'Pratonton laman web dinyahdayakan.',
    'domain_move_additional_webserver_settings' => "Semak semula arahan pelayan web domain tambahan untuk mencegah kerosakan konfigurasi.",
    'domain_move_no_permission' => "%1 tidak dibenarkan untuk langganan '%2'.",
    'domain_move_no_access' => "Tiada akses ke langganan '%1'.",
    'domain_split_no_create_permission' => "Penciptaan domain tidak dibenarkan.",
    'domain_split_empty_login' => 'Log masuk pengguna sistem diperlukan.',
    'domain_split_empty_password' => 'Kata laluan pengguna sistem diperlukan.',
    'domain_split_err_home_exists' => 'Domain %1 tidak dapat dialihkan kerana laluan halaman utama sasaran telah wujud dalam %2. Namakan semula domain untuk mengalihkannya ke langganan baru.',
    'domain_split_err_no_hosting_subdomains' => 'Domain tidak boleh dipindahkan ke langganan baru kerana domain tidak mempunyai pengehosan tetapi mempunyai subdomain. Untuk memindahkan domain, ubah nilai "Jenis Pengehosan" kepada "Pengehosan laman web" (dalam Tetapan Pengehosan).',
    'domain_split_target_locked' => "Sasaran langganan '%1' dikunci untuk disegerakkan.",
    'domain_split_target_unsynced' => "Sasaran langganan '%1' tidak disegerakkan dengan pelan kerana: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Sandaran berjadual telah dinyahaktifkan pada '%1'.",
    'domain_merge_database_error' => "Pangkalan data '%1' pada %2 tidak dialihkan ke langganan '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "FTP tanpa nama pada '%1' telah dimatikan.",
    'domain_merge_smb_user_access' => "Pengguna tambahan '%1' telah dialihkan ke langganan '%2' tetapi akses pengguna untuk langganan tersebut telah ditolak.",
    'domain_merge_scheduled_tasks' => "Tugas berjadual telah dialihkan ke langganan sasaran. Semak semula konfigurasi tugas.",
    'domain_merge_scheduled_tasks_deactivated' => "Tugas berjadual telah dialihkan ke langganan sasaran dan dinyahaktifkan. Semak semula konfigurasi tugas.",
    'domain_merge_no_remove_permission' => "Tidak dibenarkan untuk mengeluarkan langganan.",
    'domain_merge_err_has_addons' => 'Tidak dapat mengalihkan domain utama dengan domain tambahannya; alih domain %1 terlebih dahulu.',
    'domain_merge_err_has_webusers' => 'Tidak dapat mengalihkan domain utama dengan pengguna webnya.',
    'domain_merge_err_root_exists' => 'Laluan sasaran %1 telah wujud.',

    'database_server_edit_used_for_psa' => 'Mengemas kini pelayan pangkalan data MySQL setempat tidak dibenarkan.',
    'suggest_repair_main_suggestion_ui' => '<b>Anda boleh membaiki ralat ini</b> menggunakan utiliti `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Anda boleh membaiki ralat ini menggunakan utiliti `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'pergi ke Diagnosis & Baiki',
    'suggest_repair_using_cli_and_ui' => 'Untuk melakukannya, jalankan perintah `plesk repair %1` melalui CLI atau %2 dan klik Baiki di sebelah “Pangkalan Data Plesk”',
    'suggest_repair_using_cli' => 'Untuk melakukannya, jalankan perintah `plesk repair %1` melalui CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Perkhidmatan DNS tidak tersedia semasa sandaran dibuat. Walau bagaimanapun, terdapat zon DNS aktif dalam sandaran dan zon ini akan didayakan untuk objek berikut: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Pengawal Sumber (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Sokongan untuk SmarterMail jauh',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(tidak dibenarkan oleh kunci lesen)',
    'plesk_key__validation_failed' => '%1 (Kod ralat: %2)',
    'promo__button_details' => 'Butiran',
    'promo__extension_catalog_title' => 'Katalog Sambungan',
    'promo__extension_catalog_description' => 'Lihat katalog sambungan baru dan tingkatkan kuasa Plesk anda melalui pelbagai sambungan yang berkuasa!',
    'promo__button_open_catalog' => 'Buka Katalog',

    'backup__repository_check_login' => "Tidak dapat mengakses storan: %1 Pastikan anda telah memasukkan bukti kelayakan storan yang betul.",
    'backup__repository_check_error_list' => "Tidak dapat mengakses storan: %1 Pastikan anda telah memasukkan tetapan storan yang betul.",
    'backup__repository_check_error_mkdir' => "Tidak dapat mencipta direktori: %1 Semak sama ada anda mempunyai kebenaran untuk mencipta folder dalam storan.",
    'backup__repository_check_error_upload' => "Tidak dapat memuat naik fail ke storan: %1 Semak sama ada anda mempunyai kebenaran untuk memuat naik fail ke storan.",
    'backup__repository_check_error_download' => "Tidak dapat memuat turun fail dari storan: %1 Semak sama ada anda mempunyai kebenaran untuk memuat naik dan memuat turun fail dari storan.",
    'backup__repository_check_error_resume-upload' => "Tidak dapat meneruskan muat naik fail ke storan: %1 Semak sama ada anda mempunyai kebenaran untuk meneruskan muat naik ke storan.",
    'backup__repository_check_error_resume-download' => "Tidak dapat meneruskan muat turun fail dari storan: %1 Semak sama ada anda mempunyai kebenaran untuk meneruskan muat turun dari storan.",
    'backup__repository_check_error_enable-utf8' => "Tidak dapat mengendalikan storan: %1 Semak sama ada storan menyokong pengekodan UTF8.",
    'backup__repository_check_error_rm' => "Tidak dapat mengendalikan storan: %1 Semak sama ada anda mempunyai kebenaran untuk memadam fail dari storan.",
    'backup__repository_check_error_rmdir' => "Tidak dapat mengendalikan storan: %1 Semak sama ada anda mempunyai kebenaran untuk memadam folder dari storan.",

    'backup__ftp_repository_check_login' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2",
    'backup__ftp_repository_check_error_list' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Anda boleh menyemaknya secara berasingan dengan perintah: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Tidak boleh mengubah tetapan untuk DMARC. Untuk mendayakan pilihan ini, sila hidupkan perlindungan spam DKIM dan SPF.',
    'spf_server_wide_disable_failed' => 'Tidak boleh mengubah tetapan untuk perlindungan spam SPF. Untuk menyahdayakan SPF, sila matikan DMARC untuk mel masuk.',
    'sfdk_server_wide_verify_disable_failed' => 'Tidak boleh mengubah tetapan untuk perlindungan spam DKIM. Untuk menyahdayakan DKIM, sila matikan DMARC untuk mel masuk.',

    'ccs_not_supported' => 'IIS Central Certificate Store tidak dikonfigurasi pada sistem.',
    'ccs_not_enabled' => 'Pengurusan IIS Central Certificate Store tidak didayakan di Plesk.',
    'ad_not_supported' => 'Pelayan tidak disertai domain.',

    'component_name__appinit' => "Permulaan Aplikasi",
    'component_name__httpcompression' => 'Pemampatan Kandungan HTTP',
    'common_feature_is_not_supported' => 'Ciri ini tidak disokong lagi.',
    'common_feature_is_not_supported_in_proto' => 'Ciri ini tidak disokong untuk versi protokol %1.',
    'autoinstaller__plesk_component' => 'Komponen Plesk',
    'plesk_key__key_expired' => 'Kunci lesen anda telah tamat tempoh. Untuk terus menggunakan Plesk, beli %1 komersial yang tidak tamat tempoh.',
    'plesk_key__key_purchase' => 'kunci lesen',

    'sa_action_move' => 'Alih spam ke folder "E-mel Sarap"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Aplikasi Java tidak disokong lagi. Aplikasi ini tidak akan tersedia untuk tapak web berikut: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Tapak web versi mudah alih yang dihoskan dengan UNITY Mobile tidak disokong lagi. Aplikasi ini tidak akan tersedia untuk tapak web berikut: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Dasar penggunaan di seluruh pelayan tidak membenarkan penggunaan tetapan antivirus peribadi. Tetapan ini akan dipulihkan secara tidak lengkap untuk akaun e-mel di domain berikut: {{objects}}',

    'module__not_installed' => "Sambungan %1 tidak dipasang",

    'mail__mail_autodiscovery_server_error' => 'Tentukan nama domain tersuai untuk penemuan automatik mel',
    'mail__error_mail_autodiscovery_enable' => 'Tidak dapat menetapkan penemuan automatik mel: %1',
    'mail__error_mail_autodiscovery_server' => 'Tidak dapat menetapkan nama domain tersuai untuk penemuan automatik mel: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Tidak dapat mengkonfigurasi semula rekod DNS penemuan automatik domain: %1',

    '__invalid_url' => 'URL "%1" tidak sah',
    'actionlog__cloning_start' => 'mula',
    'actionlog__event_cloning_start' => 'Klon pelayan dimulakan',

    '__UPLOAD_ERR_FORM_SIZE' => "Muat naik fail melebihi saiz yang dibenarkan",
    '__UPLOAD_ERR_INI_SIZE' => "Muat naik fail melebihi saiz yang dibenarkan",
    '__UPLOAD_ERR_NO_FILE' => "Tiada fail diterima",
    '__UPLOAD_ERR_OK' => "Fail berjaya dimuat naik",
    '__UPLOAD_ERR_PARTIAL' => "Fail sebahagiannya dimuat naik, sila cuba lagi",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Folder sementara telah hilang',
    '__UPLOAD_ERR_CANT_WRITE' => 'Gagal menulis fail ke cakera',
    '__UPLOAD_ERR_UNKNOWN' => 'Ralat muat naik fail tidak diketahui telah berlaku',
    '__accounts' => "Akaun",
    '__access' => "Akses",
    '__address' => "Alamat",
    '__addresses' => "Alamat",
    '__acl_records' => 'Rekod ACL',
    '__admin_repository' => "Repositori pentadbir",
    '__all' => 'Semua',
    '__allowed' => "Dibenarkan",
    '__anonftp_status' => "FTP Awanama",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 pelayan web sedang dimulakan, sila tunggu...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Sokongan Microsoft ASP.NET",
    '__asp_win_support' => "Sokongan Microsoft ASP",
    '__attachments' => "Lampiran",
    '__attachments_list' => "Lampiran",
    '__author' => 'Pengarang',
    '__autoresp_name_already_exists' => "Autobalas dengan nama %1 sudah wujud.",
    '__autoresponder' => "Autobalas",
    '__autoresponders' => "Auto-balas",
    '__autoresponders_list' => "Auto-balas",
    '__autoresponder_attachment_files' => "Fail Lampiran Autobalas",
    '__auto_updates_list' => 'Kemas kini tersedia',
    '__avail' => "Tersedia",
    '__backup_utilites' => "Utiliti sandaran",
    '__bind_status' => "Status pelayan DNS",
    '__bu_is_not_installed' => "Perkhidmatan ini tidak tersedia pada masa ini kerana utiliti sandaran tidak dipasang.",
    '__bu_not_support_in_key' => "Keupayaan sandaran ini adalah tidak disokong oleh kunci lesen.",
    '__notifications_not_support_in_key' => 'Pemberitahuan tidak disokong oleh kunci lesen',
    'disabled_by_key' => 'Tidak disokong oleh kunci lesen',
    '__bytes' => "bait",
    '__can_not_use_reserved_words' => "Anda tidak boleh menggunakan perkataan terpelihara.",
    '__certificate' => "Sijil",
    '__cgi_support' => "Sokongan CGI",
    '__change_date' => "Tarikh pengubahsuaian",
    '__city' => "Bandar",
    '__cl_not_exist' => "Akaun pelanggan tidak wujud.",
    '__client' => 'Pelanggan',
    '__client_card' => "Kad pelanggan",
    '__client_contact_name' => "Nama kenalan pelanggan",
    '__client_form' => "Maklumat peribadi",
    '__client_ip_pool' => "Himpunan IP pelanggan",
    '__client_limits' => "Had akaun pelanggan",
    '__client_permissions' => "Kebenaran pelanggan",
    '__client_preferences' => "Keutamaan pelanggan",
    '__client_status' => "Status pelanggan",
    '__client_name' => "Nama pelanggan",
    '__client_total' => "Jumlah pelanggan",
    '__client_with_login_name_already_exists' => "Pengguna dengan nama pengguna \"%1 \" telah wujud.",
    '__client_domuser_with_login_already_exists' => "Nama pengguna '%1' sudah digunakan oleh pentadbir domain '%1'.",
    '__clients_global_changes' => "Ubah suai akaun pelanggan dipilih",
    '__clients_list' => "Pelanggan",
    '__cmd_not_found' => "Perintah tidak diketahui: %1",
    '__comments' => "Komen",
    '__company_name' => "Nama syarikat",
    '__component_version' => "Versi komponen",
    '__component_not_installed' => "Komponen %1 tidak dipasang",
    '__confirm_del' => "Anda mesti sahkan padaman.",
    '__confirm_overwrite' => "Sahkan penggantian.",
    '__confirm_stop' => "Anda mesti sahkan proses berhenti.",
    '__confirm_passwd' => "Sahkan %1 kata laluan",
    '__confirm_removal' => "Sahkan alih keluar",
    '__conhelp' => "Perihalan",
    '__contact_name' => "Nama kenalan",
    '__country' => "Negara",
    '__countries' => 'Negara',
    '__country_unknown' => 'Tidak dapat kenal pasti subkod negara.',
    '__courier-imap' => 'Pelayan kurier',
    '__create_domain' => 'Cipta domain',
    '__crypted' => 'disulitkan',
    '__cp_access' => "Akses ke Plesk",
    '__cp_user' => "Pengguna Plesk",
    '__create' => "Cipta",
    '__create_client_template_without_template' => "Cipta akaun pengguna tanpa templat",
    '__create_domain_for' => "Cipta domain untuk <b>%1</b>",
    '__create_domain_template_without_template' => "Cipta domain tanpa templat",
    '__creation_date' => "Tarikh ciptaan",
    '__crontab_unix' => "Penjadual",
    '__crontab_win' => "Penjadual",
    '__ct_month_jan' => 'Januari',
    '__ct_month_feb' => 'Februari',
    '__ct_month_mar' => 'Mac',
    '__ct_month_apr' => 'April',
    '__ct_month_may' => 'Mei',
    '__ct_month_jun' => 'Jun',
    '__ct_month_jul' => 'Julai',
    '__ct_month_aug' => 'Ogos',
    '__ct_month_sep' => 'September',
    '__ct_month_oct' => 'Oktober',
    '__ct_month_nov' => 'November',
    '__ct_month_dec' => 'Disember',
    '__custom_button' => "Butang Tersuai",
    '__custom_buttons_list' => "Pautan kepada Perkhidmatan Tambahan",
    '__daily' => "Harian",
    '__database_not_activated' => "%1 tidak diaktifkan pada halaman pentadbiran pelayan pada halaman pelayan pentadbiran.",
    '__database_not_installed' => "Pangkalan data %1 tidak dapat dipasang.",
    '__database_not_run' => "Pangkalan data %1 tidak dapat berjalan.",
    '__database_is_corrupt' => "Pangkalan data Plesks rosak. Sila lancarkan utiliti Reconfigurator untuk membaikinya.",
    '__databases' => "Pangkalan Data",
    '__databases_list' => "Pangkalan Data",
    '__database_type_not_supported_by_key' => 'Untuk guna %1 pelayan, anda perlukan sokongan untuk kunci lesen. Sila rujuk wakil jualan Plesk anda.',
    '__date_immediately' => "Hari ini",
    '__date_never' => "jangan sekali-kali",
    '__day(s)' => "Hari",
    '__day0' => "Aha",
    '__day1' => "Isn",
    '__day2' => "Selasa",
    '__day3' => "Rab",
    '__day4' => "Khamis",
    '__day5' => "Jum",
    '__day6' => "Sab",
    '__days' => "%1 hari",
    '__db_admin_login_empty' => "Anda telah masukkan nama pengguna kosong, matikan kawalan ke atas %1 antara muka. Adakah anda mahu meneruskannya?",
    '__db_unable_to_unregister' => 'Tidak dapat alih keluar parameter sambungan pangkalan data',
    '__db_db_exists' => 'Terdapat sekurang-kurangnya satu pangkalan data pada pelayan',
    '__db_unable_to_change_server_name' => 'Nama untuk pelayan tidak boleh diubah',
    '__db_unable_to_change_port' => 'Port untuk pelayan tidak boleh diubah',
    '__db_already_exist' => "Pangkalan data %1 telah wujud.",
    '__db_credentials_invalid' => "Kelayakan pangkalan data adalah tidak sah.",
    '__db_invalid_password_characters' => 'Kata laluan mengandungi aksara yang tidak sah',
    '__db_engine' => "Enjin Pangkalan data", // indirect
    '__db_type' => "Jenis pangkalan data",
    '__db_user' => "Pangkalan Data pengguna",
    '__db_server' => 'Pelayan pangkalan data',
    '__def_domain' => "Domain lalai",
    '__default_for_mysql' => 'MySQL untuk lalai',
    '__default_for_mariadb' => 'lalai untuk MariaDB',
    '__default_for_percona' => 'lalai untuk Percona',
    '__default_for_postgresql' => 'PostgreSQL untuk lalai',
    '__delete' => "Padam",
    '__demo' => "Fungsi tidak tersedia pada versi demo.",
    '__directory' => "Direktori",
    '__disable_lock_screen' => 'Elakkan pengguna daripada bekerja dengan Plesk sehingga skrin antara muka dimuatkan sepenuhnya',
    '__dismiss_news?' => "Adakah anda benar-benar ingin untuk tutup sepenuhnya berita sekatan?\n\nAnda tidak dapat untuk lihat sekatan berita hingga banyak berita tersedia.",
    '__description' => "Perihalan",
    '__disabled' => "Dimatikan",
    '__disk_space_limit' => "Had ruang cakera",
    '__cgroups_cpu_usage_limit' => 'Had penggunaan CPU',
    '__cgroups_ram_usage_limit' => 'Had penggunaan RAM',
    '__cgroups_disk_read_usage_limit' => 'Had Lebar jalur Cakera Baca',
    '__cgroups_disk_write_usage_limit' => 'Had Lebar jalur Cakera Tulis',
    '__disk_usage_by' => "Ruang cakera digunakan mengikut %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Rekod DNS '%1'\\ telah wujud.",
    '__dns_master_should_be_remote' => "Anda perlu mempunyai dua pelayan nama berwibawa yang berbeza pada hos yang berasingan.",
    '__dns_record_not_exist' => "Rekod DNS tidak wujud.",
    '__dns_server' => "Pelayan DNS", // indirect
    '__dom_id_is_undefined' => "ID domain tidak ditakrifkan.",
    '__dom_name' => "Nama domain",
    '__dom_name_is_invalid' => "Nama domain adalah tidak sah. Sila pastikan nama domain anda hanya terdiri daripada abjad angka, titik dan sempang simbol, dan tidak lebih besar dari 255 simbol panjang. Setiap bahagian nama domain di antara titik tidak boleh melebihi 63 simbol.",
    '__dom_not_exist' => "Domain tidak wujud.",
    '__domain' => "Domain",
    '__domain_' => 'Domain %1',
    '__domain_form' => "Bentuk domain",
    '__domain_id' => "ID Domain",
    '__domain_is_turned_off_for_backup' => "Tapak web %1 buat sementara dimatikan untuk membuat sandaran atau menyimpan dan tidak tersedia pada masa ini.",
    '__domain_limits' => "Had domain",
    '__domain_name' => "Nama domain",
    '__mail_name_in_ASCII_form' => "Nama akaun mel dalam format ASCII",
    '__message_error' => 'Ralat',
    '__message_warning' => 'Amaran',
    '__message_info' => 'Maklumat',
    '__domain_name_in_ASCII_form' => "Nama domain dalam format ASCII",
    '__domain_repository' => "Domain repositori %1",
    '__domain_status' => "Status domain",
    '__domain_found_tech' => "Teknologi ditemui pada domain",
    '__domain_dns' => 'Zon DNS domain',
    '__domain_total' => "Jumlah amaun untuk langganan",
    '__domain_total_powerUser' => "Jumlah amaun untuk langganan",
    '__domain_user' => "Pentadbir domain",
    '__domains_global_changes' => "Ubah suai domain dipilih",
    '__mailnames_global_changes' => "Ubah suai akaun mel dipilih",
    '__backup_manager' => 'Pengurus Sandaran',
    '__domains_list' => "Domain",
    'domains_list__list_header' => "domain",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Nama domain bermula dengan www, walaupun awalan WWW digunakan.\nTeruskan juga?",
    '__dovecot' => 'Pelayan IMAP Dovecot dan POP3',
    '__dsmail' => "Perkhidmatan mel",
    '__dsmaillist' => "Senarai mel perkhidmatan",
    '__dsr_db' => "DB",
    '__dsr_dname' => "Nama domain",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "Nama pelanggan",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Jumlah saiz bagi fail sandaran dalam storan tempatan",
    '__email' => "E-mel",
    '__email_addr_is_invalid' => "e-mel adalah tidak sah.",
    '__enabled' => "dihidupkan",
    '__enter_cert_text' => "Masuk teks sijil",
    '__enter_size' => "Masuk saiz",
    '__exclusive' => "Khusus",
    '__expiration_date' => "Tarikh tamat tempoh",
    '__fax' => "Faks",
    '__file' => "Fail",
    '__file_is_empty' => "Fail itu kosong.",
    '__file_name' => "Nama fail",
    '__file_type' => 'Jenis fail',
    '__filemanager' => "Pengurus Fail",
    '__filepath_is_empty' => "Laluan ke fail kosong",
    '__files_list' => "Fail",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Tetapan FTP",
    '__ftp_serv' => "Pelayan FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Anda perlu tetapkan ciri akaun FTP dahulu!",
    '__ftp_status' => "Tetapan status pelayan",
    '__full_day0' => "Ahad",
    '__full_day1' => "Isnin",
    '__full_day2' => "Selasa",
    '__full_day3' => "Rabu",
    '__full_day4' => "Khamis",
    '__full_day5' => "Jumaat",
    '__full_day6' => "Sabtu",
    '__full_month1' => "Januari",
    '__full_month10' => "Oktober",
    '__full_month11' => "November",
    '__full_month12' => "Disember",
    '__full_month2' => "Februari",
    '__full_month3' => "Mac",
    '__full_month4' => "April",
    '__full_month5' => "Mei",
    '__full_month6' => "Jun",
    '__full_month7' => "Julai",
    '__full_month8' => "Ogos",
    '__full_month9' => "September",
    '__giga' => "G",
    '__group' => "Kumpulan",
    '__h' => "H",
    '__hard_disk_quota' => "Kuota cakera keras",
    '__hard_disk_quota_not_supported' => 'kuota cakera keras tidak disokong kerana konfigurasi sistem fail pelayan',
    '__header_text_is_invalid' => "Tajuk dari kawasan dilindungi yang tidak sah.",
    '__help_topic_not_found' => 'Bantuan topik anda permintaan (%1) tidak wujud.',
    '__hosting_ip_dns_ip_not_equiv' => "Tiada alamat IP yang dinyatakan dalam rekod DNS sepadan dengan alamat IP yang digunakan untuk pengehosan.",
    '__hosting_scripting' => "Pengehosan sokongan skrip",
    '__hosting_setup_page_title' => "Pengehosan web persediaan untuk domain %1",
    '__hosting_title' => "Pengehosan (%1)",
    '__hosting_type' => "Jenis pengehosan",
    '__hostname_is_empty' => "Nama hos adalah kosong.",
    '__hour(s)' => 'Jam',
    '__hst_type_incorrect' => "Jenis pengehosan tidak betul.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Masa melahu",
    '__iface' => "Antara muka",
    '__image' => "Imej",
    '__imap_status' => "Status pelayan IMAP",
    '__in' => "Dalam",
    '__in_%' => "dalam %",
    '__incorrect_databases_login_pass' => "Kelayakan yang dinyatakan untuk mengakses PostgreSQL adalah tidak betul.",
    '__incorrect_ip_or_network_address' => 'Alamat IP atau rangkaian tidak betul.',
    '__info' => 'Maklumat',
    '__install' => "Pasang",
    '__install_prefix' => "Awalan dipasang",
    '__invalid_cert_id' => "Sijil ID tidak sah",
    '__invalid_context' => "Konteks tidak sah %1",
    '__invalid_db_usr_name' => "Pangkalan data nama pelanggan adalah tidak sah.",
    '__invalid_dir_name' => "Direktori nama adalah tidak sah.",
    '__invalid_dom_name' => "Nama domain adalah tidak sah.",
    '__invalid_filename' => "Nama fail tidak sah. Jangan gunakan petikan tunggal dan/atau kombinasi \"../\".",
    '__invalid_id' => "Pengecam tidak sah.",
    '__invalid_lines_num' => "Nilai tidak sesuai untuk beberapa baris hanya digit yang dibenarkan.",
    '__invalid_max_letter_size' => "Saiz mesej maksimum adalah tidak sah.",
    '__invalid_pdir_name' => "Direktori nama dilindungi adalah tidak sah.",
    '__invalid_restart_apache_interval' => "Selang Apache mula semula adalah tidak sah.",
    '__invalid_tmpl_name' => "Nama templat adalah tidak sah.",
    '__invalid_value' => "Nilai tidak wajar.",
    '__ip_addr' => "Alamat IP",
    '__ip_address_and_mask' => "Alamat IP dan Topeng Subnet",
    '__ip_alias__mask' => "Alamat IP dan Topeng Subnet",
    '__ip_addr_is_invalid' => "Alamat IP adalah tidak sah.",
    '__ip_addr_list' => "Alamat IP",
    '__ip_address_and_mask_hint' => 'Sebagai contoh, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB",
    '__kbytes' => "KBytes",
    '__key_for_virtuozzo_only' => "Kunci lesen anda hanya bertujuan untuk digunakan dalam bekas Virtuozzo.",
    '__key_limits_exceeding' => "Tindakan ini melebihi had yang ditetapkan oleh lesen perisian anda. Jika anda menerima mesej ini anda boleh hubungi pembekal anda atau pengilang untuk menjelaskan atau melanjutkan had lesen ini.",
    '__kilo' => "K",
    '__keywords' => 'Kata kunci',
    '__lang_unknown' => 'Tidak dapat untuk kenal pasti bahasa.',
    '__languages' => 'Bahasa',
    '__learn_more' => 'Ketahui lebih lanjut',
    '__loading' => 'Memuatkan...',
    '__locales' => "Pek bahasa",
    '__lists' => "Senarai Mel",
    '__literal_bytes' => "B",
    '__processing' => "Sila tunggu.<br>Memuatkan...",
    '__locale' => "Bahasa antara muka",
    '__locale_is_not_defined' => "bahasa antara muka adalah tidak ditakrifkan.",
    '__local_server_mysql' => 'Pelayan MySQL setempat',
    '__local_server_postgresql' => 'Pelayan PostgreSQL setempat',
    '__local_server_mssql' => 'Pelayan MS SQL setempat',
    '__log_and_statistics_files' => 'Fail log dan laporan statistik',
    '__config_files' => 'Fail konfigurasi',
    '__chroot_files' => 'Persekitaran chrooted',
    '__login' => "%1 Log masuk",
    '__login1' => "Log masuk",
    '__login_disabled' => "Log masuk dilarang",
    '__login_enabled' => "log masuk dibenarkan",
    '__login_incorrect' => "Anda masukkan nama penguna atau kata laluan yang tidak betul.",
    '__login_name' => "%1 nama pengguna",
    '__login_name_is_invalid' => "%1 nama pengguna tidak sah.",
    '__logon_time' => "Masa log masuk",
    '__ma' => "Alias mel",
    '__mail' => "Mel",
    '__mail_alias_name' => "Mel alias mel",
    '__mail_autodiscovery' => 'Penemuan automatik mel',
    '__mail_exchanger_name_is_invalid' => "Nama penukar mel tidak sah.",
    '__mail_groups' => "Kumpulan mel",
    '__mail_list_engine' => "Senarai mel perisian",
    '__mail_name' => "Akaun mel",
    '__mail_name_form' => "Sifat akaun mel",
    '__mail_names' => "Akaun mel",
    '__mail_serv' => "Pelayan Mel",
    '__mail_user' => 'Pengguna mel',
    '__mailgroup' => "Kumpulan mel",
    '__maillist' => "Senarai mel",
    '__maillists' => "Senarai Mel",
    '__maillist_member' => 'Senarai mel ahli',
    '__mailname' => "Akaun mel",
    '__mailname_redir_self' => "Akaun mel tidak boleh pemaju mel kepadanya sendiri.",
    '__max_dom_num_reached_for_cl' => "Had bilangan domain telah dicapai untuk akaun pelanggan ini.",
    '__max_file_size_available' => "Saiz fail maksimum dibenarkan %1",
    '__max_subdom_num_reached_for_cl' => "Bilangan had dari subdomain telah dicapai untuk akaun pelanggan.",
    '__max_subdom_num_reached_for_dom' => "Bilangan had dari subdomain telah dicapai untuk domain.",
    '__max_subdom_num_reached_for_key' => "Bilangan had dari subdomain dibenarkan mengikut kunci lesen telah dicapai.",
    '__max_traffic_limit' => "Had trafik",
    '__maximum_excl_ip_num' => "Akaun mel",
    '__mb' => "MB",
    '__mbytes' => "megabait",
    '__mb_month' => "MB/bulan",
    '__mb_sec' => "MB/saat",
    '__gb_sec' => "GB/saat",
    '__tb_sec' => "TB/saat",
    '__mega' => "M",
    '__minute(s)' => 'Minit',
    '__mls_not_in_key' => "Kunci produk anda tidak disokong oleh antara muka multilingual.",
    '__modification_date' => "Tarikh pengubahsuaian",
    '__module' => "Sambungan",
    '__month' => "Bulan",
    '__month(s)' => "Bulan",
    '__month1' => "Januari",
    '__month10' => "Okt",
    '__month11' => "November",
    '__month12' => "Dis",
    '__month2' => "Februari",
    '__month3' => "Mac",
    '__month4' => "April",
    '__month5' => "Mei",
    '__month6' => "Jun",
    '__month7' => "Julai",
    '__month8' => "Ogo",
    '__month9' => "September",
    '__monthly' => "Bulanan",
    '__months' => "Bulan",
    '__moved_permanently' => 'Mengalih selamanya',
    '__mssql' => "Pelayan Microsoft SQL",
    '__mssql__server' => "Pelayan",
    'mssql__server' => "Microsoft SQL nama pelayan",
    'mssql__unable_to_change_server_name_db_exists' => "nama untuk pelayan tidak boleh diubah: terdapat sekurang-kurangnya satu pangkalan data padanya.",
    '__mssql_status' => "Status pelayan Microsoft SQL",
    '__multiply_login_deny' => "Tidak dapat log masuk anda. Pengguna yang lain dengan nama pengguna (%1) telah log masuk pada Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Status pelayan MYSQL",
    '__mysql_version' => "versi Mysql",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Status pelayan MariaDB",
    '__mariadb_version' => "Versi MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Status pelayan Percona",
    '__percona_version' => "Versi Percona",
    '__name' => "Nama",
    '__name_invalid' => "Nama adalah tidak sah.",
    '__nameserver' => "namapelayan",
    '__network' => "Rangkaian",
    '__networks' => "Rangkaian",
    '__no' => "Tidak",
    '__no_ip_address_with_properly_type_available' => "Tidak dapat pulih data sandaran kerana tidak ada alamat IP yang sesuai diperlukan untuk pemulihan.",
    '__no_clients_specified' => "Tiada akaun pelanggan ditentukan.",
    '__no_comments' => "Tiada komen.",
    '__nologin' => "Dilarang",
    '__none' => "Tiada",
    '__not_configured' => "Tidak dikonfigurasikan",
    '__not_implemented_yet' => "Tidak dilaksanakan lagi",
    '__not_supported_by_ftp' => "(tidak disokong oleh pelayan FTP)",
    '__notification' => "Pemberitahuan",
    '__num_displayed' => "%1 daripada %2 dipaparkan",
    '__num_is_invalid' => "Nombor tidak sah.",
    '__object_not_found' => 'Objek tidak dijumpai: %1',
    '__of_all' => "% daripada Semua",
    '__off' => "Mati",
    '__ok' => "OK",
    '__old_passwd' => "Lama %1 kata laluan",
    '__on' => "Hidup",
    '__others' => "Lain",
    '__other_ip__will_be_added' => 'Alamat IP tersedia lain (akan ditambahkan pada himpunan IP pelanggan)',
    '__out' => "Keluar",
    '__p' => "P",
    '__passwd' => "%1 Kata laluan",
    '__passwd_is_invalid' => "%1 Kata laluan tidak sah",
    '__passwd_not_match' => "Kata laluan tidak sepadan!",
    '__path' => "Laluan",
    '__perl_unix_support' => "Sokongan Perl",
    '__perl_win_support' => "Sokongan Perl",
    '__perm_denied' => "Kebenaran ditolak",
    '__permissions' => "Kebenaran",
    '__personal_name' => "Nama peribadi",
    '__pg_admin_not_activated' => "PostgreSQL tidak diaktifkan pada halaman pentadbiran pelayan.",
    '__pg_not_inst' => "PostgreSQL tidak dipasang.",
    '__pg_not_run_or_inst' => "PostgreSQL tidak dipasang atau tidak berjalan.",
    '__pg_not_support_in_key' => "PostgreSQL tidak disokong oleh kunci lesen.",
    '__phone' => "Telefon",
    '__phosting' => "Pengehosan fizikal",
    '__php_support' => "Sokongan PHP",
    '__php_run_as_isapi' => "Jalan sebagai sambungan ISAPI",
    '__php_safe_mode' => "'safe_mode' PHP hidup",
    '__php_version' => "Versi PHP",
    '__physical' => "Pengehosan fizikal",
    '__plesk_stat_pdir' => "Direktori dilindungi '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Statistik domain",
    '__plesk_stat_protect' => "Lindungi akses ke statistik web dengan nama pengguna dan kata laluan FTP pengguna",
    '__plesk_stat_protect_install' => "boleh diakses melalui direktori kata laluan dilindungi '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Status pelayan POP3",
    '__popen_error' => "Ralat berlaku semasa memanggil fungsi popen.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Status PostgreSQL",
    '__preferences' => "Tetapan",
    '__account_preferences' => "Tetapan akaun",
    '__interface_preferences_general' => 'Umum',
    '__interface_preferences_default' => 'Keutamaan Antara muka Lalai',
    '__interface_preferences_admin' => "PentadbirI Keutamaan Antara Muka",
    '__interface_template' => 'Templat antara muka tersuai',
    '__interface_preferences' => "Keutamaan antara muka",
    '__proceed?' => "Adakah anda mahu meneruskannya?",
    '__protect_dir_user' => "Pengguna direktori dilindungi",
    '__protect_dir_users' => "Pengguna direktori dilindungi",
    '__provider_contact_name' => "Nama kenalan pemilik",
    '__python_unix_support' => "Sokongan Python",
    '__python_win_support' => "Sokongan Python",
    '__quota' => "Kuota",
    '__r' => "R",
    '__reconfigure' => "Konfigurasi semula",
    '__record_type' => "Jenis rekod",
    '__release' => "Keluaran",
    '__remote_db_not_supported_by_key' => 'Pangkalan data pengehosan jauh tidak disokong mengikut kunci lesen.',
    '__remove' => "Alih keluar",
    '__remove_confirmation' => "Sahkan Alih keluar",
    '__remove_protection' => 'Alih keluar Perlindungan',
    '__report' => "Laporan",
    '__report_auto' => 'Jadual penghantaran',
    '__report_size_na' => "Perkhidmatan tidak tersedia",
    '__reports_list' => "Laporan",
    '__requested' => "Diminta",
    '__required_fields' => "Medan yang diperlukan",
    '__resp_name_invalid' => "Nama Autobalas adalah tidak sah. Gunakan hanya abjad angka, simbol titik, sempang dan ruang putih.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Nama pelayan adalah tidak sah",
    '__screenshots' => 'Tangkapan skrin',
    '__script_warning' => "Dengan mengalih keluar keupayaan skrip dari domain ini semua skrip dipengaruhi akan dipaparkan dalam teks biasa apabila dipanggil oleh pelayar.  Ia adalah dinasihatkan untuk pentadbir untuk alih keluar semua skrip dari domain yang diberikan.",
    '__sec' => "Saat",
    '__second(s)' => "saat",
    '__see_list_of_logged_in' => "Lihat senarai semasa log masuk pengguna.",
    '__select_certs_to_remove' => "Pilih sijil untuk dialih keluar.",
    '__select_domains_to_default_host' => "Pilih domain untuk tetapkan sebagai lalai.",
    '__select_files_to_remove' => "Pilih fail untuk dibuang.",
    '__select_ip' => "Alamat IP memperuntukkan",
    '__select_ip_to_remove' => "Pilih alamat IP untu dialih keluar.",
    '__select_domain_template' => "Guna tetapan templat domain",
    '__select_templates_to_remove' => "Pilih templat untuk dialih keluar.",
    '__server' => "Pelayan",
    '__server_total' => "Jumlah Pelayan",
    '__service' => "Perkhidmatan",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MYSQL pangkalan data pelayan",
    '__service_description__mysql' => "MYSQL pangkalan data pelayan",
    '__service_title__web' => "Pelayan web",
    '__service_description__web' => "Pelayan web",
    '__service_title__smtp' => "Pelayan SMTP",
    '__service_description__smtp' => "Pelayan SMTP",
    '__service_title__mail' => "Pelayan IMAP/POP3",
    '__service_description__mail' => "Pelayan IMAP/POP3",
    '__service_title__dns' => "Pelayan DNS",
    '__service_description__dns' => "Pelayan DNS",
    '__service_title__postgresq' => "PostgreSQL pangkalan data pelayan",
    '__service_description__postgresq' => "PostgreSQL pangkalan data pelayan",
    '__service_title__spamassassin' => "SpamAssassin perkhidmatan penapisan spam",
    '__service_description__spamassassin' => "SpamAssassin perkhidmatan penapisan spam",
    '__services' => "Perkhidmatan",
    '__all_services' => "Semua perkhidmatan",
    '__sessions' => "Sesi",
    'sessions__feature_ftp_session_manager_not_supported' => "Ciri Sesi FTP tidak disokong oleh pelayan FTP semasa",
    '__sessions_list' => "Sesi",
    '__set' => "Hidupkan",
    '__shared' => "Dikongsi",
    '__shell_access_warning' => "Benarkan cangkerang akses sistem adalah sangat merbahaya untuk keselamatan sistem. Benarkan akses kepada sistem tersebut hanya jika anda memahami dengan jelas apa yang anda lakukan, dan hanya kepada pengguna yang dipercayai. Adakah anda benar-benar mahu benarkan akses?",
    '__siteapp_not_support_in_key' => "Aplikasi web tidak disokong oleh kunci lesen",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Konfigurasi aplikasi web ini telah diubah secara manual. Dalam usaha untuk melindungi pengubahsuaian manual, konfigurasi semula melalui Plesk telah dibuat tidak tersedia.',
    '__site_management' => "Penerbitan web", // indirect
    '__size' => "Saiz",
    '__skeleton' => 'Templat hos maya',
    '__skins' => 'Kulit',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP status pelayan",
    '__some_fields_are_empty_or_invalid' => "Beberapa medan adalah kosong atau mengandungi nilai yang tidak wajar",
    '__unable_to_set_parameters' => "Tidak dapat menetapkan parameter komponen",
    '__spamassassin' => "Penapis Spam",
    '__spamassassin_status' => "Status SpamAssassin",
    '__spamd_status' => 'Status penapis spam',
    '__splited_backup' => "(sandaran berbilang volum)",
    '__split_backup_file' => "Cipta sandaran berbilang volum",
    '__split_backup_size' => "Saiz volum",
    '__split_backup_less_than_500' => "Saiz volum tidak kurang daripada 500 megabait adalah tidak disokong",
    '__ssi' => "SSI",
    '__ssi_support' => "Sokongan SSI",
    '__ssi_with_html' => "gunakan SSI untuk fail *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Sokongan SSL/TLS",
    '__same_ssl' => "Gunakan direktori tunggal untuk perumahan SSL/TLS dan kandungan bukan SSL/TLS",
    '__same_ssl_cu' => "SSL/TLS biasa dan kandungan bukan SSL/TLS",
    '__state' => "Negeri/Wilayah",

    '__status__Active' => 'Aktif',
    '__status__active' => 'aktif',
    '__status__Passive' => 'Dimatikan',
    '__status__passive' => 'Dimatikan',
    '__status__off' => 'Dimatikan',
    '__status__with_parent' => 'Dimatikan',
    '__status__backup_restore' => 'Digantung buat sementara waktu untuk membuat sandaran atau menyimpan.',
    '__status__admin' => 'Digantung oleh pentadbir pelayan',
    '__status__resseler' => 'Penjual semula digantung',
    '__status__client' => 'Digantung oleh pelanggan',
    '__status__unknown' => 'Status adalah tidak diketahui',

    '__status_of' => "Status %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Pelayan stunnel", // indirect
    '__subdomain' => "Subdomain",
    '__subdomain_name' => "Nama subdomain",
    '__subdomain_name_in_ASCII_form' => "Nama subdomain dalam format ASCII",
    '__subdomains' => "Subdomain",
    '__domainaliases' => "Alias domain",
    '__subdomains_list' => "Subdomain",
    '__subdomains_not_support_in_key' => "Subdomain adalah tidak disokong oleh kunci lesen",
    '__sys_user_type' => "Pengguna FTP",
    '__sys_user_type_main' => "Gunakan akaun pengguna FTP daripada domain utama",
    '__sys_user_type_native' => "Buat akaun pengguna FTP yang berasingan untuk subdomain ini",
    '__t' => "T",
    '__target_domain' => "Domain sasaran",
    '__template' => "Templat",
    '__template_not_accepted' => "Tidak dapat menerima templat: melebihi had berikut.",
    '__templates' => "Templat",
    '__templates_list' => "Templat",
    '__tera' => "T",
    '__title' => "Tajuk",
    '__tools' => "Alat",
    '__total' => "Jumlah %1",
    '__total_size' => "Jumlah saiz",
    '__total_used' => "Jumlah Penggunaan",
    '__traffic' => "Trafik",
    '__traffic_by_client' => "Trafik mengikut pelanggan",
    '__traffic_by_domain' => "Trafik mengikut domain",
    '__traffic_by_service' => "Trafik mengikut perkhidmatan",
    '__traffic_history' => "Sejarah trafik",
    '__unable_change_locale' => "Tidak dapat mengubah bahasa antara muka: %1",
    '__unable_create_new_dom' => "Tidak boleh untuk mencipta domain: %1",
    '__unable_define_dom_name' => "Tidak dapat untuk takrifkan nama domain: %1",
    '__unable_define_necessary_properties' => "Tidak dapat menentukan semua sifat yang dikehendaki.",
    '__unable_define_properties' => "Tidak dapat takrifkan sifat: %1",
    '__unable_exec_util' => "Tidak dapat untuk pelaksanaan utilti: %1",
    '__unable_get_dns_a_recs' => "Tidak dapat untuk dapatkan semula alamat IP untuk rekod DNS untuk pengehosan akaun ini: %1",
    '__unable_get_mbox_quota' => "Tidak dapat untuk dapatkan semula maklumat pada had saiz peti mel.",
    '__unable_redirect_to_myself' => "Tidak dapat untuk majukan ke akaun yang sama.",
    '__unable_redirect_to_my_alias' => "Tidak dapat majukan mel kepada mel alias.",
    '__default_domain_redirect_to_myself' => "Tidak dapat tetapkan domain sebagai lalai untuk alamat IP:\n mengubah hala pada dirinya telah dikesan.",
    '__unable_remove_client' => "Tidak dapat untuk alih keluar pelanggan: %1",
    '__unable_set_up_mbox_quota' => "Tidak dapat tetapkan had saiz peti mel untuk domain: %1",
    '__unable_setup_pass' => "Tidak dapat tetapkan kata laluan: %1",
    '__unable_to_create_new_account' => "Akaun tidak boleh dicipta: %1",
    '__unable_to_define_db_size' => "Tidak dapat takrifan saiz pangkalan data.",
    '__unable_to_enable_short_names' => "Tidak dapat membenarkan guna nama akaun mel pendek untuk akaun POP3 / IMAP.",
    '__unable_to_fetch_data_from_submit' => "Tidak dapat mengambil data yang dihantar: %1",
    '__unable_to_open_file' => "Tidak dapat buka fail %1: %2",
    '__unable_to_update_subdomain' => "Tidak dapat buat perubahan ke subdomain: %1",
    '__unable_update_cl_data' => "Tidak dapat simpan perubahan ke akaun pengguna: %1",
    '__unable_update_db_params' => "Tidak dapat mengemas kini pangkalan data parameter: %1",
    '__unable_update_dom_data' => "Tidak dapat kemas kini data domain: %1",
    '__undefined' => "Tidak Ditakrif",
    '__uninstall' => "Nyahpasang",
    '__unknown_error' => "Ralat tidak diketahui",
    '__unlimited_lower' => "Tidak terhad",
    '__unset' => "Matikan",
    '__update' => "Kemas Kini",
    '__uploaded_file_is_invalid' => "Kemas kini fail adalah tidak sah: %1",
    '__url' => "URL",
    '__usage' => "Penggunaan cakera",
    '__user' => 'Pengguna',
    '__user_already_logged' => "Pengguna yang lain dengan nama pengguna (%1) telah log masuk pada Plesk.",
    '__version' => "Versi",
    '__aps_license' => "Kunci lesen",
    '__vh_type' => "Jenis hos maya",
    '__vhosts_apache_status' => "Status pelayan web",
    '__wrong_charset_conversion' => 'Charset salah, penukaran dari "%1" to "%2" adalah tidak dibenarkan',
    '__warning_' => "Amaran!",
    '__warning_excl_ip_num' => "Alamat IP khusus",
    '__warning_expiration' => "Tarikh tamat tempoh",
    '__web_scripting' => "Menskrip web", // indirect
    '__web_serv' => "Pelayan web", // indirect
    '__web_statistic' => "Statistik web", // indirect
    '__webmail' => "Mel web", // +indirect
    '__webstat_not_installed' => "Webalizer tidak dipasang pada pelayan. Hubungi pembekal perkhidmatan anda untuk bantuan dengan pemasangan Webalizer.",
    '__webstat_support' => "Statistik web",
    '__webstat_awstats_support' => "Ubah",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "Ubah",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Apabila anda menukar dari satu program statistik yang lain, semua laporan yang dibuat oleh program statistik yang digunakan sebelumnya akan dipadam dan laporan baru dicipta mengikut maklumat yang dibaca dari fail log disimpan pada pelayan. Ini bermakna jika anda mengkonfigurasi sistem (di Domain > nama domain > Pengurus Log > Putaran Log) supaya menyimpan fail log hanya untuk bulan lepas maka statistik web akan tersedia hanya untuk bulan lepas. Adakah anda ingin menukar kepada pakej statistik?",
    '__webstat_perm_denied' => 'Anda tidak ada kebenaran untuk mengurus statistik web.',
    '__webuser' => "Pengguna web",
    '__sysusers_list' => "Pengguna Sistem",
    '__sysuser' => "Pengguna sistem",
    '__weekly' => "Mingguan",
    '__whats_new_in_version' => "Apakah yang baru dalam Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Operasi ini tersedia hanya untuk domain dengan pengehosan web.",
    '__wrong_hosting_type__none' => 'Tiada pengehosan web dikonfigurasi pada domain %1.',
    '__wrong_hosting_type__std_fwd' => 'Domain %1 mempunyai pemajuan standard yang dikonfigurasikan. Operasi ini tersedia hanya untuk domain dengan pengehosan web.',
    '__wrong_hosting_type__frm_fwd' => 'Domain %1 ada bingkai pemajuan dikonfigurasi. Operasi ini tersedia hanya untuk domain dengan pengehosan web.',
    '__wu' => "Pengguna web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Awalan WWW telah diubah. Pastikan untuk mengubah suai sijil SSL/TLS tersebut dengan sewajarnya.",
    '__year' => "Tahun",
    '__year(s)' => "Tahun",
    '__yes' => "Ya",
    '__you' => "Anda",
    '__zip_code' => "Poskod/kod ZIP",
    '__form_normal' => "Normal",
    '__form_advanced' => "Lanjutan",

    'admin_ed__edit_administrator_info' => "Mengedit profil pentadbir",
    'admin_ed__create_default_client' => "Saya mahu mencipta akaun pelanggan lalai.",
    'admin_ed__unable_update' => "Tidak dapat mengemaskini maklumat pentadbir. %1",

    'auth__update_admin_info' => "Sila masukkan maklumat pentadbir. Maklumat ini diperlukan untuk mengendali %1.",
    'auth__you_not_have_perm' => "Anda tidak mempunyai kebenaran untuk menguruskan domain ini.",
    'auth__key_expired_admin' => 'Lesen Plesk anda telah tamat tempoh. Untuk terus menggunakan Plesk, perbaharui lesen anda atau beli yang baharu.',
    'auth__key_expired_admin_restricted' => 'Lesen Plesk anda telah tamat tempoh. Hubungi penyedia perkhidmatan anda untuk terus menggunakan Plesk.',
    'auth__key_expired_client' => 'Lesen Plesk telah tamat tempoh. Sila hubungi pembekal pengehosan anda.',
    'autoinstaller__not_installed' => 'Komponen auto-pasang tidak dipasang.',
    'autoinstaller__release_action' => 'Operasi tersedia',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Menaik taraf kepada versi Plesk baru.',
    'autoinstaller__release_action_update' => 'Mengemas kini atau menambah komponen baru.',
    'autoinstaller__release_action_up2date' => 'Anda mempunyai versi terbaru',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Tidak dipasang',
    'autoinstaller__component_action_update' => 'Kemas kini tersedia.',
    'autoinstaller__component_action_upgrade' => 'Kemas kini tersedia.',
    'autoinstaller__component_action_up2date' => 'Anda mempunyai versi terbaru',
    'autoinstaller__component_action_error' => 'Kemas kini tidak tersedia',
    'autoinstaller__component_serverbuildtime' => 'Keluaran terbaru',
    'autoinstaller__component_localbuildtime' => 'Keluaran anda',
    'autoinstaller__component_installed_version' => 'Versi anda',
    'autoinstaller__component_available_version' => 'Versi terbaru',
    'autoinstaller__component' => 'Komponen',
    'autoinstaller__components' => 'Komponen',
    'autoinstaller__components_title' => '%1 Komponen',
    'autoinstaller__component_dependency_note' => 'diperlukan untuk pemasangan komponen yang anda pilih',
    'autoinstaller__install_confirm' => 'Ya, saya mahu memasang komponen ini',
    'autoinstaller__install_confirm_request' => 'Sila pilih kotak semak untuk pengesahan',
    'autoinstaller__install_title' => 'Sahkan pemasangan untuk komponen yang dipilih',
    'autoinstaller__key_update_confirm' => 'Sahkan melangkau kemas kini kunci dan memasang kunci lalai',
    'autoinstaller__key_update_confirm_request' => 'Sila pilih kotak semak untuk pengesahan.',
    'autoinstaller__key_update_failed' => '<p/> Plesk tidak dapat mengemas kini lesen produk anda.</p><p>%1</p><p>Terus menaik taraf tanpa memiliki lesen produk yang sesuai akan mengakibatkan pemasangan lesen lalai dengan fungsi terhad. Pentadbir dinasihatkan supaya mendapatkan dahulu kunci lesen yang bersesuaian sebelum meneruskan naik taraf produk.</p>',
    'autoinstaller__email' => 'Hantar makluman ke',
    'autoinstaller__email_admin' => "E-mel Pentadbir",
    'autoinstaller__email_email' => 'Alamat e-mel tersuai',
    'autoinstaller__release' => 'Nama keluaran',
    'autoinstaller__releases' => 'Keluaran tersedia',
    'autoinstaller__releases_title' => 'Pengemaskini Plesk',
    'autoinstaller__select_components_to_install' => 'Pilih komponen untuk di pasang',
    'autoinstaller__status_error' => 'Ralat: %1',
    'autoinstaller__status_install_error' => 'Pemasangan tidak dapat dimulakan: %1',
    'autoinstaller__status_install_busy' => 'Pemasangan tidak dapat dimulakan: terdapat prosedur pemasangan lain sedang berjalan.',
    'autoinstaller__status_install_ok' => 'Pemasangan bermula. Anda akan dimaklumkan mengenai kemajuan pemasangan melalui e-mel (%1).',
    'autoinstaller__status_query_busy' => 'Pemasangan sedang dijalankan.',
    'autoinstaller__status_query_error' => 'Tidak boleh mendapatkan status pemasangan: %1',
    'autoinstaller__status_unknown' => 'Tidak boleh mendapatkan status auto-pasang.',
    'autoinstaller__status_busy' => 'Autoinstaller sedang sibuk, sila tunggu.',
    'autoinstaller__configure_title' => 'Tetapan pengemas kini',
    'autoinstaller__preferences_legend' => 'Tetapan',
    'autoinstaller__target' => 'Direktori muat turun semntara.',
    'autoinstaller__target_invalid' => "Tentukan laluan mutlak.",
    'autoinstaller__check_updates' => 'Semak untuk kemas kini apabila pentadbir log masuk ke Plesk',
    'autoinstaller__check_updates_warning' => 'Baru <a href="%1">kemas kini</a> adalah tersedia untuk %2',
    'autoinstaller__source_type' => 'Jenis sumber',
    'autoinstaller__source' => 'Sumber URL',
    'autoinstaller_source__preferences_legend' => 'Tetapan',
    'autoinstaller_source__type' => 'Jenis sumber',
    'autoinstaller_source__url_invalid' => 'Sumber tidak sah',
    'autoinstaller_source__url_invalid_network' => 'URL sumber tidak sah (Contoh: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Sumber URL',
    'autoinstaller__source_invalid_network' => 'Anda menyatakan alamat rangkaian yang tidak sah.',
    'backup__repository' => 'Lokasi storan fail sandaran',
    'backup__error_notify_email' => 'Jika ralat terjadi semasa sandaran, hantar pemberitahuan ke e-mel',
    'backup__dump_info' => "Maklumat sandaran",
    'backup__dump_file_name_not_defined' => "Nama fail sandaran tidak dinyatakan",
    'backup__local_file' => 'Fail sandaran setempat',
    'backup__domain_ftp' => 'pelayan FTP jauh',
    'backup__wrong_path' => "Laluan yang tidak betul kepada storan fail sandaran: Jangan gunakan jujukan bagi aksara ../../",
    'backup__unable_to_connect_to_ftp_server' => "Tidak dapat sambung ke pelayan FTP: %1",
    'backup__unable_to_read_file' => 'Tidak dapat membaca fail sandaran:',
    'backup__backup_task_does_not_exist' => "Tugasan sandaran tidak wujud, anda patut menciptanya sebelum menghidupkan.",
    'backup__restore_params' => "Parameter pemulihan",
    'backup__confirmation' => "Amaran: domain tidak akan tersedia semasa penyandaran/ pemulihan.",
    'backup__backup_method' => 'Kaedah sandaran',
    'backup__dumpfile_name' => "Nama fail sandaran",
    'backup__dumpfile_name_is_invalid' => "Nama fail sandaran tidak sah: gunakan hanya abjad angka, simbol sempang, titik dan garis bawah, jangan gunakan nama seperti perihalan.* sebagai nama fail sandaran.",
    'backup__email_required' => "Alamat e-mel anda diperlukan untuk memaklumkan kemajuan penyandaran dan pemulihan. SIla nyatakan e-mel anda di dalam butiran akaun.",
    'backup__error_during_backup' => "Tidak dapat mencipta fail sandaran: %1",
    'backup__input_email_warning' => "Anda perlu sama ada nyatakan e-mel untuk makluman atau kosongkan kotak semakkan.",
    'backup__make_download' => "jangan simpan fail sandaran dalam storan, hanya muat turunnya",
    'backup__make_dump' => 'cipta fail sandaran dan simpan di storan tempatan',
    'backup__makedump_to_ftp' => 'cipta fail sandaran dan simpan pada pelayan FTP jauh',
    'backup__restore_ip' => "Alamat IP untuk pemulihan",
    'backup__select_dumpfile' => "Pilih fail sandaran.",
    'backup__time' => "Masa sandaran",
    'backup__day' => 'Hari sandaran',
    'backup__view_dump_info' => "Lihat maklumat sandaran untuk domain %1",
    'backup__wrong_domain_name' => "Fail sandaran mengandungi data domain %1 maka ia tidak boleh dipulihkan pada domain %2",
    'backup__incorrect_ftp_user_or_passwd' => "Pengguna atau kata laluan FTP salah. SIla betulkan sifat akaun FTP",
    'backup__access_denied' => "Akses ditolak. SIla betulkan sifat akaun FTP",
    'backup__restore_from' => "Pemulihan %1",
    'backup__domain_session_failed' => 'Domain %1 tidak disandarkan',
    'backup__client_session_failed' => 'Pelanggan %1 tidak disandarkan',
    'backup__domain_session_restore_failed' => 'Domain %1 tidak dipulihkan.',
    'backup__client_session_restore_failed' => 'Akaun pelanggan %1 tidak dipulihkan.',
    'backup__domain_session_complete' => 'Domain %1 telah disandarkan',
    'backup__domain_session_backup' => 'Sandaran domain %1',
    'backup__client_session_backup' => 'Sandaran pelanggan %1',
    'backup__domain_stop_title' => 'Membatalkan sandaran domain %1',
    'backup__client_stop_title' => 'Membatalkan penyandaran akaun pelanggan %1',
    'backup__domain_restore_stop_title' => 'Membatalkan pemulihan domain %1',
    'backup__client_restore_stop_title' => 'Membatalkan pemulihan akaun pelanggan %1',
    'backup__domain_session_backup_stop' => 'Anda akan membatalkan proses penyandaran yang sedang aktif. Fail sandaran tidak akan dicipta.',
    'backup__backup_stop_confirm' => 'Ya, saya mahu menghentikan proses sandaran',
    'backup__restore_stop_confirm' => 'Ya, saya mahu menghentikan proses pemulihan',
    'backup__domain_session_restore' => 'Pemulihan domain %1',
    'backup__domain_session_restore_stop' => 'Anda akan membatalkan proses pemulihan yang sedang aktif.',
    'backup__domain_backup_file_info' => 'Maklumat Fail Sandaran Domain',
    'backup__domain_backup_file_list' => 'fail sandaran tersedia',
    'backup__domain_backup_progress' => 'Kemajuan sandaran tapak web %1',
    'backup__domain_restore_progress' => 'Kemajuan pemulihan tapak web %1',
    'backup__domain_backup_progress_elapsed_time' => 'Masa berlalu: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Masa berlalu: %1',
    'backup__ip_map_legend' => 'Pemetaan IP',
    'backup__ip_map_list_count' => 'Alamat IP',
    'backup__domain_restore_session_complete' => 'Domain %1 telah dipulihkan.',
    'backup__domain_restore_session_complete_message' => 'Domain %1 telah dipulihkan.',
    'backup__domain_backup_file_delete' => 'Fail penyandaran berikut akan di alih keluarkan.',
    'backup__domain_backup_file_for_remove' => 'Pilih fail sandaran yang anda mahu alih keluarkan.',
    'backup__backup_overwrite_file_confirm' => 'Pengesahan penggantian',
    'backup__backup_overwrite_file_confirm_text' => 'Fail sandaran dengan nama "%1" sudah wujud. Adakah anda mahu menggantikannya?',
    'backup__backup_confirm_overwrite' => 'Sahkan penggantian fail.',
    'backup__backup_overwrite_legeng' => 'Ganti',
    'backup__backup_not_contain_domain' => 'Fail sandaran tidak mengandungi maklumat tentang domain %1',
    'backup__backup_not_contain_client' => 'Fail sandaran tidak mengandungi maklumat tentang akaun pelanggan %1',
    'backup__backup_client_info' => "Tetapan pelanggan sandaran dan butiran akaun.",
    'backup__client_backup_progress' => 'Kemajuan penyandaran akaun pelanggan %1',
    'backup__client_session_complete' => 'Akaun pelanggan %1 telah disandarkan',
    'backup__client_backup_file_info' => 'Maklumat Fail Sandaran Pelanggan',
    'backup__restore_client_info' => "Pulihkan tetapan pelanggan dan butiran akaun",
    'backup__client_session_restore' => 'Memulihkan akaun pelanggan %1',
    'backup__client_db_server_map' => 'Pemetaan pelayan pangkalan data',
    'backup__domain_db_server_map' => 'Pemetaan pelayan pangkalan data',
    'backup__client_restore_session_complete_message' => 'Akaun pelanggan %1 telah dipulihkan.',
    'backup__client_restore_session_complete' => 'Akaun pelanggan %1 telah dipulihkan.',
    'backup__restore_select_some' => 'Sila pilih objek yang anda mahu pulihkan.',
    'backup__client_restore_progress' => 'Kemajuan pemulihan akaun pelanggan %1',
    'backup__new_backup' => 'Cipta Sandaran Baru',
    'backup__done' => 'Selesai:',
    'backup__done_domains' => '%1 domain daripada %2',
    'backup__done_clients' => '%1 pelanggan daripada %2',
    'backup__remaining' => 'Baki:',
    'backup__remaining_domains' => '%1 domain',
    'backup__remaining_clients' => '%1 pelanggan',
    'backup__overall_backup_progress' => 'Kemajuan sandaran keseluruhan',
    'backup__comment_n_a' => 't/b',
    'backup__command_ignore' => 'Perintah "%1" diabaikan',
    'backup__no_objects' => 'tiada objek untuk sandaran',
    'backup__cli_warning_not_enough_ip' => 'AMARAN: alamat IP tidak mencukupi untuk melaksanakan pemetaan IP lalai:',
    'backup__local_repository' => "Storan Plesk",
    'backup__ftp_repository' => 'Storan FTP',
    'backup__ftp_login' => 'Nama pengguna',
    'backup__ftp_password' => 'Kata laluan',
    'backup__ftp_directory_hint' => 'Contoh: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'Tetapan Akaun FTP',
    'backup__ftp_account_preferences' => 'Tetapan akaun FTP',
    'backup__repository_not_exist' => 'Direktori tidak wujud',
    'backup__repository_not_readable' => 'Direktori yang dinyatakan tidak dapat dibaca',
    'backup__ftp_repository_not_configure' => 'Untuk menggunakan storan sandaran FTP, <a href=\'%1\'> tentukan akaun FTP</a> dahulu.',
    'backup__ftp_repository_list_not_configure' => 'Tetapan akaun tidak ditentukan',
    'backup__repository_list_unable_listing' => 'Tidak dapat mengambil senarai fail',
    'backup__ftp_repository_unable_listing' => 'Tidak dapat mengambil senarai direktori "%1":',
    'backup__repository_legend' => 'Storan fail sandaran',
    'backup__store_in_repository' => 'Simpan fail dalam',
    'backup__local_repository_lable' => 'Storan tempatan',
    'backup__ftp_repository_lable' => 'Storan FTP',
    'backup__ftp_repository_not_configure_hint' => '(tetapan akaun tidak dinyatakan)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(akaun FTP tidak dinyatakan atau tidak disokong)',
    'backup__ftp_directory_not_exist' => 'Direktori yang dinyatakan tidak wujud',
    'backup__other_user_process_modified' => 'Pengguna lain telah hentikan proses penyandaran atau penghijrahan.',
    'backup__another_user_exist' => 'Operasi yang sedang berjalan dimulakan oleh pengguna Plesk lain. Pengguna ini masih log masuk di dalam Plesk.',
    'backup__ftp_repository_wait' => 'Sila tunggu sementara mendapatkan semula maklumat tentang storan FTP',
    'backup__ftp_write_test_failed' => 'Gagal untuk tulis data ujian ke akaun FTP %1:',
    'backup__ftp_storage' => 'Storan FTP',
    'bt_upload_to_repository' => 'Muat naik fail kepada Storan Tempatan',
    'bt_new_restore' => "Pulihkan",
    'bt_backup_schedule' => "Sandaran Jadual",
    'backup_exist_backups' => "Fail sandaran tersedia",
    'backup_dialog__page_title' => "Penciptaan fail sandaran.",
    'backup_dialog__please_wait' => "Proses sandaran akan bermula. Operasi mungkin mengambil masa. Sila tunggu...",
    'backup_conf__page_title' => 'Konfigurasi sandaran.',
    'bt_accept' => "Terima",
    'bt_access' => "Akses",
    'bt_action_log' => "Log Tindakan",
    'bt_add' => "Tambah",
    'bt_add_client' => "Tetapkan pada Pengguna",
    'bt_database_server_add' => 'Tambah Pelayan Pangkalan Data',
    'bt_add_services' => "Tambah Perkhidmatan",
    'bt_anonftp_stats' => "Statistik FTP Awanama",
    'bt_anonymous_ftp' => "FTP Awanama",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Lampir",
    'bt_autoinstaller' => 'Pengemas kini',
    'bt_auto-updates' => 'Pengemas kini',
    'bt_back' => "<< Kembali",
    'bt_backup' => "Sandaran",
    'bt_backup_configure' => "Tetapan Sandaran",
    'bt_buy_certs' => "Beli Sijil",
    'bt_card' => "Kad",
    'bt_cert' => "Sijil",
    'bt_certificates' => "Sijil",
    'bt_change_passwd' => "Tukar Kata Laluan",
    'bt_clear' => "Kosong",
    'bt_client_templates' => "Templat Pelanggan",
    'bt_clients' => "Pelanggan",
    'bt_codepage_change' => 'Tukar Pengekodan',
    'bt_comp_info' => "Pengurusan Komponen",
    'bt_configure_maillists' => "Sediakan Mailman",
    'bt_configure' => 'Konfigurasi',
    'bt_copy' => "Salin",
    'bt_copy_move' => "Salin/Alih",
    'bt_create' => "Cipta",
    'bt_create_account' => "Tambah Akaun",
    'bt_create_dir' => "Tambah Direktori",
    'bt_create_file' => "Tambah Fail",
    'bt_count_size' => "Kira Saiz",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Penjadual Tugasan",
    'bt_custom_button_new' => "Tambah Butang",
    'bt_custom_buttons' => "Butang tersuai",
    'bt_customize' => "Penyesuaian",
    'bt_databases' => "Pangkalan Data",
    'bt_database_servers' => 'Pelayan Pangkalan data',
    'bt_sqlservers' => "Pelayan Pangkalan data",
    'bt_db_usr_new' => "Tambah Pengguna Pangkalan Data.",
    'bt_db_new' => "Tambah Pangkalan data",
    'bt_db_phpmyadmin' => "Pentadbir MySQL",
    'bt_dbuser_default' => "Jadikan Lalai untuk DB Pentadbir Web.",
    'bt_decline' => "Tolak",
    'bt_default' => "Lalai",
    'bt_defaultcomponents' => "Perkhidmatan Pihak Ketiga",
    'bt_defaults' => "Lalai",
    'bt_delete' => "Padam",
    'bt_directories' => "Direktori Dilindungi",
    'bt_disable' => "Matikan",
    'bt_dns_zone_sync' => 'Guna Perubahan Templat DNS',
    'bt_dnsrecord_add' => 'Tambah Rekod',
    'bt_do_backup' => "Sandaran",
    'bt_do_restore' => "Pulihkan",
    'bt_do_upload' => "Muat naik",
    'bt_domain_aliases' => "Alias Domain",
    'bt_domain_templates' => "Templat Domain",
    'bt_domain_user' => "Pentadbir Domain",
    'bt_domain_user_passwd' => "Kata Laluan Pentadbir Domain",
    'bt_domains' => "Domain",
    'bt_domain_alias_add' => 'Tambah Alias Domain',
    'bt_download' => "Muat turun",
    'bt_edit' => "Edit",
    'bt_enable' => "Hidupkan",
    'bt_export' => 'Eksport',
    'bt_extras' => "Lebih",
    'bt_finish' => "Selesai",
    'bt_ftp_account' => "Sifat Akaun FTP",
    'bt_forget_password' => "Terlupa Kata Laluan?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Pentadbir Web",
    'bt_fp_webadmin' => "FP Pentadbir Web",
    'bt_ftp_stats' => "Statistik FTP",
    'bt_get_password' => "Dapatkan Kata Laluan",
    'bt_global_changes' => "Ubahsuai",
    'bt_help' => "Bantuan",
    'bt_hide_aliases' => "Sembunyikan Alias",
    'bt_hide_toolbar' => 'Sembunyi bar alat',
    'bt_hide_subdomains' => "Sembunyikan Subdomain.",
    'bt_hide_domainaliases' => "Sembunyikan Alias Domain.",
    'bt_home' => "Laman Utama",
    'bt_hosting' => "Pengehosan",
    'bt_icf' => 'Tembok api',
    'bt_install' => "Pasang",
    'bt_ip_aliasing' => "Alamat IP",
    'bt_ip_add' => "Tambah Alamat IP",
    'bt_ip_pool' => "Himpunan IP",
    'bt_key_info' => "Maklumat Lesen",
    'bt_key_buyonline_addons' => 'Pesan Pasang Tambah Plesk.',
    'bt_key_buyonline_upgrades' => 'Pesan Naik Taraf Plesk.',
    'bt_key_buyonline_new' => 'Pesan Kunci Baru',
    'bt_limits' => "Had",
    'bt_locale_add' => 'Tambah setempat',
    'bt_locales' => 'Tempatan',
    'bt_log_manager' => "Pengurus Log",
    'bt_login' => "Log Masuk",
    'bt_logo' => "Penjenamaan",
    'bt_logo_send_link' => "Lampirkan Pautan",
    'bt_logo_send_logo' => "Lampirkan Logo",
    'bt_logout' => "Log keluar",
    'bt_logrotation' => "Putaran Log",
    'bt_mail' => "Mel",
    'bt_mail_alias_add' => "Tambah Alias Mel",
    'bt_mail_aliases' => "Alias Mel",
    'bt_mail_group_add' => "Tambah Ahli",
    'bt_mail_groups' => "Kumpulan",
    'bt_mail_name_add' => "Tambah Akaun Mel",
    'bt_mail_preferences' => "Tetapan",
    'bt_mail_group' => "Kumpulan Mel",
    'bt_mail_mailbox' => "Peti Mel",
    'bt_mail_redirect' => "Pemaju",
    'bt_mail_resp_add' => "Tambah Auto-Balas",
    'bt_mail_resp_attach_add' => "Tambah Lampiran",
    'bt_mail_resp_files' => "Fail Lampiran",
    'bt_mail_responders' => "Auto-balas",
    'bt_mail_spamfilter' => "Penapis Spam",
    'bt_mail_webmail' => "Mel web",
    'bt_maillist_new' => "Tambah Senarai Mel",
    'bt_maillists' => "Senarai Mel",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Cipta Sandaran",
    'bt_manage' => "Urus",
    'bt_master' => "Induk",
    'bt_migrate' => 'Hijrah',
    'bt_modules_add' => 'Tambah sambungan.',
    'bt_modules_manage' => 'Urus Sambungan',
    'bt_move' => "Alih",
    'bt_mimetypes' => 'Jenis MIME',
    'bt_mimetype_new' => 'Tambah Jenis MIME',
    'bt_new_client' => "Tambah Akaun Pelanggan",
    'bt_new_domain' => "Tambah Domain",
    'bt_next' => "Seterusnya >>",
    'bt_next_page' => "Berikut",
    'bt_network_add' => "Tambah Rangkaian",
    'bt_notifications' => "Pemberitahuan",
    'bt_off' => "Mati",
    'bt_on' => "Hidup",
    'bt_on_off' => "Hidup/Mati",
    'bt_pd_new' => "Tambah Direktori Dilindungi",
    'bt_pd_user_new' => "Tambah Pengguna",
    'bt_performance' => 'Prestasi',
    'bt_permissions' => "Kebenaran",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Tetapan",
    'bt_prev_page' => "Pratonton",
    'bt_preview' => 'Pratonton Tapak',
    'bt_print' => "Cetak",
    'bt_reboot' => "But semula",
    'bt_reload' => "Muat semula",
    'bt_refresh' => "Segar semula",
    'bt_register' => "Daftar",
    'bt_remove' => "Alih keluar",
    'bt_enable_selected' => 'Hidupkan',
    'bt_disable_selected' => 'Matikan',
    'bt_repair_ip' => "Baiki IP",
    'bt_report' => "Laporan",
    'bt_report_auto' => 'Penghantaran Laporan',
    'bt_report_auto_new' => 'Tambah Jadual Penghantaran',
    'bt_report_new' => "Tambah Tataletak",
    'bt_reset' => "Set semula",
    'bt_restart_services' => "Pengurusan Perkhidmatan",
    'bt_save' => "Simpan",
    'bt_send_by_email' => "Hantar Melalui E-Mel",
    'bt_send_file' => "Hantar Fail",
    'bt_send_mail' => "Hantar Mel",
    'bt_send_passwd' => "Hantar Kata Laluan",
    'bt_send_text' => "Hantar Teks",
    'bt_server' => "Pelayan",
    'bt_server_add' => "Tambah Pelayan",
    'bt_server_preferences' => "Tetapan pelayan",
    'bt_servers_list' => "Pelayan",
    'bt_sessions' => "Sesi",
    'bt_set' => "Tetapkan",
    'bt_set_as_default' => "Tetapkan Sebagai Lalai",
    'bt_setup' => 'Sediakan',
    'bt_show_aliases' => "Papar Alias",
    'bt_show_subdomains' => "Papar Subdomain",
    'bt_show_domainaliases' => "Papar Domain Alias",
    'bt_shutdown' => "Tutup",
    'bt_site_apppkgs' => "Ruang Simpan Aplikasi",
    'bt_site_apppool' => "Himpunan Aplikasi",
    'bt_application-pool' => "Aplikasi Web",
    'bt_site_apps' => "Aplikasi Web",
    'bt_site_app_add' => "Pasang Aplikasi",
    'bt_site_builder' => "Sokongan Presence Builder",
    'bt_skeleton' => 'Templat Hos Maya',
    'bt_skins' => 'Kulit',
    'bt_skin_add' => 'Tambah Skrin',
    'bt_skin_manual' => 'Rujukan Kulit Plesk Tersuai', // not used
    'bt_skin_download' => 'Muat Turun Kulit',
    'bt_skin_replace' => 'Kemas Kini Kulit',
    'bt_skip' => 'Langkau',
    'bt_spamassassin' => "Penapis Spam",
    'bt_spamassassin_train' => "Latihan",
    'bt_spamfilter' => "Penapis Spam",
    'bt_start' => "Mula",
    'bt_stop' => "Berhenti",
    'bt_recycle' => "Kitar semula",
    'bt_statistics' => "Statistik",
    'bt_subdomain_new' => "Tambah Subdomain",
    'bt_subdomains' => "Subdomain",
    'bt_submit' => "Hantar",
    'bt_summary_report' => "Laporan Ringkasan",
    'bt_support' => "Sokongan",
    'bt_switch' => "Tukar",
    'bt_system_time' => "Sistem Masa",
    'bt_task_new' => "Tambah Tugas",
    'bt_dom_tmpl_add' => 'Tambah Templat Domain',
    'bt_cl_tmpl_add' => 'Tambah Templat Pelanggan',
    'bt_cron_backup' => 'Tetapan Sandaran Berjadual',
    'bt_test' => "Uji Sambungan",
    'bt_text' => "Teks",
    'bt_touch' => "Ubah Cap Masa",
    'bt_traffic' => "Trafik",
    'bt_traffic_history' => "Sejarah Trafik",
    'bt_update' => "Kemas Kini",
    'bt_upload' => "Muat naik",
    'bt_upload_from_ftp' => "Muat Naik FTP",
    'bt_virtualdirs' => 'Direktori Maya',
    'bt_virtualdir_new' => 'Tambah Direktori Maya',
    'bt_virtualdir_add' => 'Tambah Direktori Maya',
    'bt_web_app_new' => "Pasang Aplikasi Java",
    'bt_web_stats' => "Statistik Web",
    'bt_web_stats_ssl' => "Statistik Web SSL/TLS",
    'bt_web_user_add' => "Tambah Pengguna Web",
    'bt_web_users' => "Pengguna Web",
    'bt_webadmin' => "Pentadbir Web",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Lihat senarai penuh perubahan",
    'cert_add__unable_set_ca_cert' => "Tidak dapat menetapkan sijil CA: %1",
    'cert_add__unable_set_cert' => "Tidak dapat menetapkan sijil: %1",
    'cert_add__unable_set_private_key' => "Tidak dapat menetapkan kunci peribadi: %1",
    'certificates_list__certificate_used_as_default' => "Salah satu sijil anda akan memadam digunakan sebagai Sijil Lalai.",
    'certificates_list__certificates_assigned_on_ip' => "Satu atau beberapa sijil ditugaskan kepada alamat IP / domain.",
    'ch_pass__admin_pass' => "Mengubah kata laluan pentadbir",
    'ch_pass__old_pass' => "Kata laluan lama",
    'ch_pass__pass_confirm' => "Sahkan",
    'ch_pass__unable_change_admin_pass' => "Tidak dapat mengubah kata laluan pentadbir: %1",
    'check_mail_cycle__aliases' => "Kitaran mel dikesan, alamat \"%1\" terkandung dalam alias akaun mel ini.",
    'check_mail_cycle__autoresponders' => "Kitaran mel dikesan, alamat \"%1\" terkandung dalam autobalas akaun mel ini.",
    'check_mail_cycle__mail_groups' => "Kitaran mel dikesan, alamat \"%1\" terkandung dalam kumpulan mel akaun mel ini.",
    'check_mail_cycle__mail_name' => "Kitaran mel dikesan, alamat \"%1\" bertindan dengan akaun mel ini.",
    'check_mail_cycle__redirect' => "Kitaran mel dikesan, alamat \"%1\" bertindan dengan pemaju akaun mel ini.",
    'check_mail_dup__redirect' => "Pemajuan pendua dikesan, alamat \"%1\" bertembung dengan alamat pemajuan bagi akaun mel ini.",
    'check_mail_dup__mail_groups' => "Pemajuan pendua dikesan, alamat \"%1\" terkandung dalam kumpulan mel daripada akaun mel ini.",
    'check_maillist_cycle__admin' => "Kitaran mel dikesan e-mel pentadbir \"%1\" bertembung dengan alamat senarai mel.",
    'check_maillist_cycle__member' => "Kitaran mel dikesan alamat \"%1\" bertembung dengan alamat senarai mel.",
    'chk_js__enter_login_and_passwd' => "Masukkan nama pengguna dan kata laluan.",
    'chk_js__enter_login_name' => "Masukkan nama pengguna.",
    'chk_js__enter_passwd' => "Masukkan kata laluan.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Butiran akaun %1",
    'cl_limits__cl' => "Had pelanggan %1",
    'cl_logo__setup_logo_pref' => "Tetapkan sifat logo untuk pelanggan %1",
    'cl_new__enter_new_cl_data' => "Masukkan maklumat pelanggan baru",
    'cl_new__unable_to_sent_notification' => 'Akaun pengguna telah dicipta, walau bagaimanapon, penghantaran makluman kepada pelanggan gagal: %1',
    'cl_perm__all_ip' => "Semua IP tersedia",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Semua akaun pengehosan berasaskan IP untuk pelanggan akan dipindahkan kepada berasaskan nama.",
    'cl_perm__allow_client_create_domain' => "Medan yang anda cuba pilih adalah hanya untuk pelanggan yang dibenarkan mencipta domain sahaja.",
    'cl_perm__allow_create_nb_w_ip' => "Pelanggan boleh mencipta pengehosan berasaskan Nama menggunakan %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Benarkan penciptaan akaun pengehosan berasaskan IP",
    'cl_perm__available_ips' => "IP tersedia",
    'cl_perm__change_limits' => "Pelarasan had",
    'cl_perm__cl_disk_space' => "Jumlah ruang cakera tersedia",
    'cl_perm__cl_expiration' => "Tempoh sah akaun pelanggan",
    'cl_perm__cl_max_box' => "Peti mel",
    'cl_perm__cl_max_db' => "Pangkalan Data",
    'cl_perm__cl_max_dom' => "Domain",
    'cl_perm__cl_max_maillists' => "Senarai Mel",
    'cl_perm__cl_max_subdom' => "Subdomain",
    'cl_perm__cl_max_traffic' => "Jumlah amaun trafik tersedia",
    'cl_perm__cl_max_wu' => "Pengguna web",
    'cl_perm__cl_mbox_quota' => "Had saiz peti mel untuk akaun pengguna ini",
    'cl_perm__current_maximum_exp_date' => "Nilai maksimum semasa bagi tempoh sah domain adalah %1: yang dipohon %2",
    'cl_perm__current_maximum_mailbox_quota' => "Had semasa yang ditakrifkan untuk jumlah ruang cakera yang diperuntukkan bagi menyimpan peti mel di bawah akaun pengguna ini adalah %1: yang dipohon %2",
    'cl_perm__current_total_requested' => "Jumlah nilai semasa bagi had domain untuk %1 adalah %2: yang dipohon %3",
    'cl_perm__current_total_requested_dom' => "Bilangan semasa untuk %1 yang dimiliki pelanggan ini adalah %2: yang dipohon %3",
    'cl_perm__disk_space' => "Jumlah maksimum ruang cakera",
    'cl_perm__dashboard_stdgui' => 'Antara muka pengguna',
    'cl_perm__dashboard' => 'Paparan laman utama',
    'cl_perm__stdgui' => 'Paparan standard',
    'cl_perm__manage_dashboard' => 'Pengurusan laman utama',
    'cl_perm__dashboard_and_stdgui' => 'Paparan laman utama dan paparan standard dibenarkan',
    'cl_perm__dashboard_only' => 'Hanya paparan laman utama sahaja yang dibenarkan',
    'cl_perm__stdgui_only' => 'Hanya paparan standard dibenarkan',
    'cl_perm__edit_cl' => "Kebenaran pelanggan %1",
    'cl_perm__exp_date_exceeded' => "Tempoh sah yang anda cuba tetapkan melebihi had yang ditetapkan bagi domain individu berkenaan dengan pelanggan ini.",
    'cl_perm__invalid_value' => "Nilai tidak sah, hanya digit dibenarkan.",
    'cl_perm__limit_disk_space' => "%1 Hadkan jumlah amaun ruang cakera",
    'cl_perm__limit_expiration' => "%1 Menghadkan tempoh sah bagi akaun pelanggan.",
    'cl_perm__limit_max_box' => "%1 Menghadkan bilangan maksimum peti mel",
    'cl_perm__limit_max_db' => "%1 Menghadkan bilangan maksimum pangkalan data",
    'cl_perm__limit_max_dom' => "%1 Menghadkan bilangan maksimum domain",
    'cl_perm__limit_max_maillists' => "%1 Menghadkan bilangan maksimum senarai mel",
    'cl_perm__limit_max_subdom' => "%1 Menghadkan bilangan maksimum subdomain",
    'cl_perm__limit_max_traffic' => "%1 Hadkan jumlah amaun trafik",
    'cl_perm__limit_max_wu' => "%1 Menghadkan bilangan maksimum pengguna web",
    'cl_perm__limit_mbox_quota' => "%1 Menetapkan kuota peti mel",
    'cl_perm__limits_exceeded' => "Satu atau beberapa had yang anda cuba tetapkan telah melebihi had yang ditetapkan bagi domain individu dimiliki oleh pelanggan ini.\nJumlah had untuk pelanggan mestilah lebih atau bersamaan dengan jumlah keseluruhan had domain yang ditetapkan untuk akaun pelanggan.",
    'cl_perm__mailbox_quota_exceeded' => "Had yang anda cuba tetapkan pada jumlah ruang cakera yang diperuntukkan untuk peti mel melebihi had yang ditetapkan bagi domain individu berkenaan dengan akaun pelanggan ini.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Had yang anda cuba tetapkan pada jumlah ruang cakera yang diperuntukkan untuk peti mel melebihi had yang dikenakan di aras pelayan.",
    'cl_perm__make_dumps' => "Sandarkan dan pulihkan data",

    'cl_perm__max_box' => "Bilangan maksimum peti mel",
    'cl_perm__max_db' => "Bilangan maksimum pangkalan data",
    'cl_perm__max_dom' => "domain",
    'cl_perm__max_maillists' => "Bilangan maksimum senarai mel",
    'cl_perm__max_subdom' => "subdomain",
    'cl_perm__max_traffic' => "Jumlah maksimum trafik",
    'cl_perm__max_wu' => "Bilangan maksimum pengguna web",
    'cl_perm__max_dom_aliases' => "alias domain",
    'cl_perm__mbox_quota' => "saiz peti mel",
    'cl_perm__not_allow_create_nb_hst' => "Pelanggan boleh mencipta pengehosan berasaskan Nama.",
    'cl_perm__this_ip_used_vrt_hst' => "Alamat IP ini digunakan oleh pengehosan maya.\nUntuk memadam alamat IP ini, alih keluarkan perkhidmatan hos atau ubah jenisnya kepada berasaskan Nama.",
    'cl_perm__unable_off_ipb_creating' => "Pelanggan sudah mempunyai sediakan perkhidmatan pengehosan berdasarkan IP. Untuk nyahaktifkan ciri ini bagi pelanggan, kosongkan kotak semak \"Penciptaan domain\" atau alih keluar semua akaun pengehosan berasaskan IP.",
    'cl_perm__unable_off_nb_creating' => "Pelanggan telah mempunyai penyediakan perkhidmatan pengehosan berasaskan Nama. Untuk nyahaktifkan ciri ini bagi pelanggan, kosongkan kotak semak \"Penciptaan domain\" atau alih keluar semua akaun pengehosan berasaskan Nama.",
    'cl_perm__unable_set_domain_limit' => "Tidak dapat menghadkan bilangan maksimum domain: pelanggan sudah memiliki %1 domain",
    'cl_perm__unable_update_client_limitations' => "Tidak dapat mengubahsuai had akaun pelanggan: %1",
    'cl_pref__edit_cl' => "Kebenaran pelanggan %1",
    'class_anonftp__create_ftp_domain' => "Tiada domain FTP maya untuk dom_id ini, cuba menciptanya dahulu.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Had ruang cakera yang anda mahu tetapkan (%1) tidak boleh melebihi jumlah had ruang cakera yang ditetapkan pada domain aras (%2).",
    'class_anonftp__invalid_input_only_digits' => "Nilai yang ditentukan tidak sah, hanya digit dibenarkan.",
    'class_anonftp__unable_change_ownerships' => "Tidak dapat mengubah pemilikan atau kebenaran untuk fail kuota. %1",
    'class_anonftp__unable_copy_quota_file' => "Tidak dapat menyalin fail kuota: %1",
    'class_anonftp__unable_get_disk_usage' => "Tidak dapat mengambil maklumat penggunaan cakera pada direktori kemasukan: %1",
    'class_anonftp__unable_parse_quota_file' => "Tidak dapat menghurai fail kuota.",
    'class_anonftp__unable_read_quota_file' => "Tidak dapat membaca fail kuota: %1",
    'class_anonftp__unable_update_quota' => "Tidak dapat mengemas kini kuota: fail dalam direktori kemasukan menggunakan %1 KB ruang cakera yang mana melebihi nilai kuota baru.",
    'class_anonftp__unable_write_temp_file' => "Tidak dapat menulis pada fail sementara: %1",
    'class_bsdomain__warn_max_date__' => "Tarikh tamat tempoh telah ditetapkan ke %1",
    'class_cList__empty' => "Tiada item.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Tiada padanan ditemui untuk <b>\"%1\"</b> dalam %2 (%3 daripada %4).",
    'class_cList__search_result' => "Hasil carian untuk <b>\"%1\"</b> dalam %2 (%3 daripada %4).",
    'class_client__client_creation_notification' => "Makluman penciptaan pelanggan.",
    'class_client__client_with_contact_name_already_exists' => "Pelanggan dengan nama %1 sudah wujud.",
    'class_client__disk_space' => "Ruang cakera",
    'class_client__invalid_max_dom' => "Nilai domain tidak sah hanya digit dibenarkan.",
    'class_client__limit_exceed' => "Jumlah %1 yang diminta tidak dapat diperuntukkan kerana ia akan melebihi pengagihan untuk pelanggan %2 akaun (%3). Jika anda ingin memperuntukkan lebih banyak sumber, pergi ke Pelanggan > nama pelanggan > Had dan ubah peruntukan seperti yang diperlukan. Kemudian kembali ke skrin ini dan cuba laraskan agihan semula.",
    'class_client__limit_exceed_unlimited' => "Jika anda ingin memperuntukkan jumlah sumber yang tidak terhad (%1), anda hendaklah pergi ke Pelanggan > nama pelanggan > Had dan tandakan kotak semak Tanpa Had yang sepadan dengan jenis sumber yang diperlukan. Kemudian kembali ke skrin ini dan cuba laraskan agihan semula.",
    'class_client__max_box' => "Peti mel",
    'class_client__max_db' => "Pangkalan Data",
    'class_client__max_maillists' => "Senarai Mel",
    'class_client__max_subdom' => "Subdomain",
    'class_client__max_traffic' => "Trafik maksimum",
    'class_client__max_wu' => "Pengguna web",
    'class_client__max_dom_aliases' => "Alias domain",
    'class_client__mbox_quota' => "Kuota peti mel",
    'class_client__unable_define_cl_status' => "Tidak dapat mentakrifkan status akaun pelanggan: %1",
    'class_client__unable_define_inactive_dom' => "Tidak dapat mentakrif domain tak aktif %1",
    'class_client__unable_del_ip' => "Tidak dapat mengalih keluar IP: %1",
    'class_db__db_name_not_set' => "Nama pangkalan data tidak ditetapkan lagi.",
    'class_db__db_not_exist_for_curr_dom' => "Pangkalan data tersebut tidak wujud untuk domain ini.",
    'class_db__invalid_db_or_dom_name' => "ID domain atau pangkalan data tidak sah atau nama pangkalan data tidak ditetapkan.",
    'class_db__invalid_pass' => "Kata laluan tidak sah.",
    'class_db__mailgrp_member_exist' => "Ahli kumpulan mel sudah wujud.",
    'class_db__access_hosts_notsupport' => 'Tetapan hos akses tidak disokong untuk jenis pangkalan data ini.',
    'class_db__unable_add' => 'Tidak dapat menambah rekod hos akses: %1',
    'class_db__unable_del' => 'Tidak dapat memadam rekod hos akses: %1',
    'class_db__inc_user_not_exist' => 'Pengguna pangkalan data "%1" tidak wujud',
    'class_db__inc_access_record_exist' => 'Rekod akses ini sudah wujud.',
    'class_db__inc_access_record_not_exist' => 'Rekod akses yang diberi tidak wujud.',
    'class_db__inc_unable_del_last_record' => 'Tidak dapat memadam rekod hos akses yang terakhir',
    'class_domtmpleditform__dns_master' => "Utama",
    'class_domtmpleditform__dns_slave' => "Sekunder",
    'class_domtmpleditform__dns_type' => "Hamba",
    'clienttrafficlist_header' => "Trafik pada domain",
    'clienttrafficlist_header_of_client__' => "Trafik pada domain pelanggan %1",
    'cmd_dns__a_dns_record_already_exist' => "Rekod ini akan konflik dengan rekod A untuk zon.",
    'cmd_dns__domain_last_ns' => 'Tidak dapat memadam rekod DNS NS terakhir untuk domain.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Nama domain berkanun tidak sah.",
    'cmd_dns__cname_dns_record_already_exist' => "Rekod ini akan konflik dengan rekod CNAME untuk zon.",
    'cmd_dns__cname_in_rr_combination' => 'Kombinasi yang salah bagi rekod DNS wujud dalam zon DNS',
    'cmd_dns__cname_coexist_with_data' => 'Rekod zon DNS CNAME tidak boleh wujud sekali dengan rekod DNS lain dalam zon yang sama.',
    'cmd_dns__dns_record_type_is_invalid' => "Jenis rekod DNS tidak sah.",
    'cmd_dns__ext_host_is_not_resolved' => "Nama berkanun %1 tidak dapat diselesaikan kepada rekod A atau AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Tidak dapat menambahkan rekod %1 pada zon %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Nama penukar mel tidak sah.",
    'cmd_dns__mx_priority_is_invalid' => "Keutamaan MX tidak sah",
    'cmd_dns__name_server_is_invalid' => "Pelayan nama tidak sah.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Nilai topeng rangkaian sepatutnya adalah 24,16 atau 8",
    'cmd_dns__this_dns_record_already_exists' => "Rekod DNS sebegini sudah wujud.",
    'cmd_dns__unable_add_record' => "Tidak dapat menambah rekod '%1': %2",
    'cmd_dns__unable_add_a_record' => "Tidak dapat menambah rekod A: %1",
    'cmd_dns__unable_add_cname_record' => "Tidak dapat menambah rekod CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Tidak dapat menambah rekod DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Tidak dapat menambah rekod EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Tidak dapat menambah rekod NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Tidak dapat menambah rekod PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Tidak dapat menambah rekod TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Tidak dapat mencipta zon DNS %1",
    'cmd_dns__unable_define_dns_record' => "Tidak dapat mencipta rekod DNS %1",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Tidak dapat mengambil status zon DNS lalai: %1",
    'cmd_dns__unable_insert_a_record' => "Tidak dapat memasukkan rekod A: %1",
    'cmd_dns__unable_insert_mx_record' => "Tidak dapat memasukkan rekod MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Tidak dapat memasukkan rekod NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Tidak dapat mengambil status zon DNS: %1",
    'cmd_domains__dom_already_exists' => "Domain %1 sudah wujud.",
    'cmd_domains__dns_record_already_exists' => "Tidak boleh mencipta domain %1 kerana terdapat rekod DNS yang ditujukan kepada hos %1.",
    'cmd_domains__dom_already_exists1' => "Terdapat %2 subdomain di dalam domain ini. Domain %1 sudah wujud.",
    'cmd_domains__dom_already_exists2' => "subdomain %1 sudah wujud.",
    'cmd_domains__dalias_already_exists' => "Alias ini sudah wujud",
    'cmd_domains__domain_alias_already_exists' => 'Alias domain dengan nama seperti itu sudah wujud.',
    'cmd_domains__unable_del_mail_for_dom' => "Tidak dapat memadam perkhidmatan mel untuk domain: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Tidak dapat memadam akaun FTP awanama untuk domain: %1",
    'cmd_domains__unable_update_dom_param' => "Tidak dapat mengemaskini parameter domain: %1.",
    'cmd_domains__unable_rename_client_exist' => "Nama pengguna pentadbir domain sudah digunakan",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Pengehosan adalah bukan fizikal.",
    'cmd_hosting__unable_create_user' => "Tidak dapat mencipta pengguna %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Tidak dapat menentukan alamat IP untuk hos maya berasaskan Nama: %1",
    'cmd_hosting__unable_del_old_hst' => "Tidak dapat memadam pengehosan yang didirikan sebelumnya: %1",
    'cmd_hosting__unable_del_protected_directory' => "Tidak dapat memadam direktori dilindungi: %1.",
    'cmd_hosting__unable_del_web_user' => "Tidak dapat memadam pengguna web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Tidak dapat mencipta atau mengemaskini Hos Maya: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Tidak dapat sediakan pengehosan pemajuan bingkai.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Tidak dapat bina semula fail konfigurasi proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Tidak dapat sediakan SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Tidak dapat mengalih keluar perlindungan dari direktori SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Tidak dapat mengemaskini URL destinasi %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Tidak dapat mengemas kini zon DNS untuk domain: perlaksanaan utiliti gagal.",
    'cmd_hosting__unable_update_ftp_passwd' => "Tidak dapat mengemaskini kata laluan FTP %1",
    'cmd_hosting__unable_update_user' => "Tidak dapat mengemaskini pengguna %2: %1",
    'cmd_hosting__unknown_hst_type' => "Jenis pengehosan tidak diketahui.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Anda tidak mempunyai kebenaran untuk mematikan perkhidmatan pengehosan.",
    'cmd_mail__autoresponder__not_configured' => "Autobalas untuk akaun mel ini tidak dikonfigurasikan",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Alamat %1 sudah digunakan untuk pemajuan mel.",
    'cmd_mail__alias_already_exists' => "Alias sudah wujud.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID autobalas dan ID akaun mel tidak berpadanan.",
    'cmd_mail__autoresp_id_is_undefined' => "ID autobalas tidak ditakrifkan.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Alias mel dengan nama tersebut sudah wujud untuk akaun mel %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Akaun mel %1 sudah didaftarkan kepada senarai mel ini.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Akaun mel %1 sudah wujud pada domain ini.",
    'cmd_mail__mail_name_not_exist' => "Akaun mel tidak wujud.",
    'cmd_mail__mail_name_passwd_part' => "Kata laluan tidak sepatutnya mengandungi nama akaun mel.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Senarai mel %1 sudah wujud pada domain ini.",
    'cmd_mail__mailname_already_exist_in_mg' => "Akaun mel %1 sudah berada dalam kumpulan mail.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Akaun mel %1 sudah wujud pada domain ini.",
    'cmd_mail__mailname_already_exists' => "Akaun mel sudah wujud.",
    'cmd_mail__mailname_is_invalid' => "Nama akaun mel %1 tidak sah.",
    'cmd_mail__mailname_unable_update' => "Tidak dapat mengemaskini sifat akaun mel:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Bilangan maksimum autobalas telah dicapai untuk domain ini.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Bilangan maksimum kumpulan mel telah dicapai untuk domain ini.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Bilangan maksimum pemaju telah dicapai untuk domain ini.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Bilangan maksimum peti mel telah dicapai.",
    'cmd_mail__no_members_specified' => "tiada ahli yang ditetapkan.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Kata laluan terlalu ringkas, sila pilih yang lain.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Alamat e-mel ini sudah digunakan.",
    'cmd_mail__unable_define_autoresp_id' => "Tidak dapat mentakrif ID autobalas %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Gagal untuk mengubah tetapan perkhidmatan mel untuk domain %1",
    'cmd_mail__unable_del_mail_for_dom' => "Tidak dapat mengalih keluar perkhidmatan mel dari domain %1.",
    'cmd_mail__unable_del_mail_redirection' => "Tidak dapat mengalih keluar perkhidmatan pemajuan mel %1.",
    'cmd_mail__unable_remove_autoresp' => "Tidak dapat mengalih keluar autobalas: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Tidak dapat mengalih keluar ahli kumpulan mel: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Gagal untuk mematikan kumpulan mel. %1",
    'cmd_mail__unable_update_mail_redirect' => "Tidak dapat mengkonfigurasi semula perkhidmatan pemajuan mel %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Saiz fail yang dimuat naik terlalu besar.",
    'cmd_mail__additionally' => "Tambahan lagi:",
    'cmd_pd__invalid_login' => "Nama pengguna salah.",
    'cmd_pd__this_user_already_exist' => "Pengguna sebegitu sudah wujud.",
    'cmd_pd__unable_define_hst_type' => "Tidak dapat mentakrif jenis pengehosan.",
    'cmd_pd__unable_upd_pd_usr' => "Tidak dapat mengemaskini sifat pengguna direktori dilindungi: %1.",
    'cmd_pd__user_is_undefined' => "Pengguna tidak ditetapkan.",
    'cmd_server__no_enough_free_disk_space' => "Ruang cakera tidak mencukupi.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "kata laluan lama tidak betul. Sila cuba lagi.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "Had maksima pengguna web telah dicapai untuk domain ini.",
    'cmd_web_usr__unable_create_user' => "tidak dapat mencipta pengguna sistem: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "Tidak dapat menetapkan had maksima pengguna web: %1",
    'cmd_web_usr__user_already_exists' => "pengguna sudah wujud.",
    'cmd_web_usr__web_user_name_is_invalid' => "nama pengguna web %1 tidak sah.",
    'cmd_web_usr__web_user_not_exist' => "pengguna web tidak wujud.",
    'common_func__exec_bad_argument' => "argumen exec tidak boleh mengandungi simbol koma tunggal.",
    '__eol' => 'Garis pemisah',
    'eol__binary_file' => 'Tidak dapat mengubah stail garis pemisah dalam fail binai.',
    'comp_info__header' => 'Komponen',
    'comp_info__comp_name' => "Nama komponen",
    'comp_info__comp_disabled' => 'Dimatikan',
    'comp_info__comp_active' => 'Aktif',
    'comp_info__comp_not_configured' => 'Tidak dikonfigurasikan',
    'comp_info__comp_not_started' => 'Tidak dimulakan, semak tetapan komponen',
    'comp_info__comp_version' => "Versi komponen",
    'comp_info__integration_error' => "Ralat integrasi",
    'comp_info__title' => "Komponen Plesk",
    'comp_info__service_name' => "Perkhidmatan",
    'comp_info__last_updated' => '(terakhir dikemas kini: %1)',
    'cp_access_admin_deny' => "Akses untuk pentadbir dari alamat '%1' telah disekat mengikut dasar sekatan akses IP yang digunakan.",
    'create_domain_warn__' => "Pengecualian berikut dibuat semasa penciptaan domain:",
    'create_domain__client_select' => 'Pilih pelanggan yang anda ingin ciptakan domain untuknya.',

    'dashboard__nav_button_name' => "Laman Utama",
    'dalias__list_title' => 'Alias domain bagi domain %1',
    'dalias__list_legend' => 'Alias domain',
    'dalias__list_header' => 'Alias domain',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Nama alias domain',
    'dalias__list_ascii_name' => 'Dalam format ASCII',
    'dalias__remove_title' => 'Alias domain yang berikut bagi domain %1 akan dialih keluarkan:',
    'dalias__select_domain_aliases_to_remove' => 'Pilih alias domain untuk di alih keluar.',
    'dalias__mail_turn_on_failed' => 'Tidak dapat menghidupkan perkhidmatan mel: %1',
    'dalias__web_turn_on_failed' => 'Tidak dapat menghidupkan perkhidmatan web: %1',
    'db_usr_edit__db_usr_name_old' => "Nama pengguna pangkalan data lama",
    'database_server_edit_form__cannot_infer_type' => 'Tidak boleh membuat kesimpulan kaedah sambungan daripada data yang disediakan. Tentukan "127.0.0.1" sebagai nama hos pelayan pangkalan data untuk menyambung melalui TCP/IP dengan port yang disediakan, atau biarkan medan port kosong untuk menggunakan soket Unix "%1".',
    'database_server_edit_form__duplicate' => 'Terdapat pelayan pangkalan data dengan kombinasi alamat hos ini dan nombor port yang sudah didaftarkan.',
    'database_server_edit_form__host_is_invalid' => 'Nama hos yang dinyatakan tidak sah.',
    'database_server_edit_form__port_is_invalid' => 'Nombor port yang dinyatakan tidak sah.',
    'database_server_error__consult_admin' => 'Sila hubungi pentadbir pelayan',
    'database_server_error__last__connection_failed' => 'Cubaan terakhir untuk mengawal pelayan pangkalan data ini gagal kerana masalah rangkaian.',
    'database_server_error__last__permission_denied' => 'Cubaan terakhir untuk mengawal pelayan pangkalan data ini gagal kerana akaun yang dibekalkan tidak memiliki kelebihan pentadbiran.',
    'database_server_error__last__credentials_not_set' => "Cubaan terakhir untuk sambung ke pelayan ini gagal kerana nama pengguna dan kata laluan pentadbir yang dinyatakan tidak sah.",
    'database_server_error__last__other_error' => 'Cubaan terakhir untuk mengawal pelayan pangkalan data ini gagal.',
    'database_server_error__real__connection_failed' => 'Sambungan ke pelayan pangkalan data gagal kerana masalah rangkaian:',
    'database_server_error__real__permission_denied' => 'Sambungan ke pelayan pangkalan data gagal kerana akaun yang diberikan tidak memiliki keistimewaan pentadbiran:',
    'database_server_error__real__duplicate_object' => 'Sambungan ke pelayan pangkalan data gagal kerana percanggahan nama:',
    'database_server_error__real__unacceptable_name' => 'Sambungan ke pelayan pangkalan data gagal kerana nama objek yang tidak sah.',
    'database_server_error__real__unacceptable_password' => 'Sambungan ke pelayan pangkalan data telah gagal kerana kata laluan yang tidak diterima:',
    'database_server_error__real__credentials_not_set' => "Plesk tidak dapat menyambung ke pelayan pangkalan data kerana tiada nama pengguna dan kata laluan pentadbir yang sah ditentukan.",
    'database_server_error__real__other_error' => 'Sambungan ke pelayan pangkalan data gagal.',
    'database_server_error__test__connection_failed' => 'Sambungan ujian ke pelayan pangkalan data gagal kerana masalah rangkaian:',
    'database_server_error__test__permission_denied' => 'Sambungan ujian ke pelayan pangkalan data gagal kerana akaun yang dibekalkan tidak memiliki keistimewaan pentadbiran:',
    'database_server_error__test__duplicate_object' => 'Sambungan ujian ke pelayan pangkalan data gagal kerana percanggahan nama:',
    'database_server_error__test__unacceptable_name' => 'Sambungan ujian ke pelayan pangkalan data gagal kerana nama objek tidak sah:',
    'database_server_error__test__unacceptable_password' => 'Sambungan ujian ke pelayan pangkalan data gagal kerana kata laluan tidak diterima:',
    'database_server_error__test__credentials_not_set' => "Sambungan ujian ke pelayan ini gagal kerana tiada nama pengguna dan kata laluan pentadbir yang sah ditentukan.",
    'database_server_error__test__other_error' => 'Sambungan ujian ke pelayan pangkalan data gagal:',

    'db__create_new_db' => "Tambah pangkalan data",
    'db__db_add' => "Tambah Pangkalan data",
    'db__db_for_dom' => "Pangkalan data untuk tapak web %1",
    'db__db_id_undefined' => "ID pangkalan data tidak ditakrifkan.",
    'db__db_name' => "Nama pangkalan data",
    'db__db_not_exist' => "Pangkalan data tidak wujud.",
    'db__db_type' => "Jenis",
    'db__db_server' => "Pelayan pangkalan data",
    'db_server_not_exist' => "Pelayan pangkalan data tidak wujud.",
    'db__db_user_not_exist' => "Pengguna pangkalan data tidak wujud",
    'db__domain_not_exist' => "Domain tidak wujud.",
    'db__enter_db_name' => "Masukkan nama pangkalan data baru.",
    'db__invalid_db_id' => "Pengenal pasti pangkalan data tidak sah.",
    'db__invalid_db_name' => "Nama pangkalan data tidak sah. Nama pangkalan data patut mengandungi hanya simbol abjad latin, digit, garis bawah atau sempang. Ia tidak boleh lebih panjang daripada 63 simbol.",
    'db__max_db_reached_for_dom' => "Had untuk bilangan pangkalan data sudah dicapai bagi domain ini.",
    'db__max_mssql_db_reached_for_dom' => "Had pada nombor pangkalan data Pelayan Microsoft SQL dicapai bagi domain ini",
    'db__postgres_not_connect_for_admin' => "Tidak dapat sambung kepada PostgreSQL. Hidupkan sokongan PostgreSQL pada halaman pentadbiran pelayan.",
    'db__postgres_not_connect_for_client' => "Tidak dapat sambung kepada PostgreSQL. Rujuk kepada pentadbir sistem anda untuk bantuan.",
    'db__remove_db_on_domain' => "Pangkalan data berikut di bawah tapak web %2 dimiliki oleh pelanggan %1 akan dialih keluar:",
    'db__remove_db_on_domain_of_cl' => "Pangkalan data berikutnya untuk domain %2 yang dimiliki pelanggan %1 akan di alih keluarkan:",
    'db__remove_db_linked_resource' => 'Pangkalan data ini sedang digunakan oleh aplikasi web. Ia hanya boleh dialih keluar selepas menyahpasang aplikasi web tersebut.',
    'db__remove_db_users' => "Pengguna pangkalan data berikut %3 dibawah tapak web %2 yang dimiliki pelanggan %1 akan dialih keluar:",
    'db__remove_db_users_of_cl' => "Pengguna pangkalan data berikut %3 dibawah tapak web %2 yang dimiliki pelanggan %1 akan dialih keluar:",
    'db__select_db_for_remove' => "Pilih pangkalan data untuk dialih keluar.",
    'db__select_db_users_for_remove' => "Pilih pengguna pangkalan data untuk dialih keluar.",
    'db__unable_create_db_user' => "Tidak dapat mencipta pengguna pangkalan data: %1",
    'db__unable_define_db_name' => "Tidak dapat mentakrif nama pangkalan data: %1",
    'db__unable_define_db_user' => "Tidak dapat mentakrif pengguna pangkalan data: %1",
    'db__unable_define_db_users' => "Tidak dapat mentakrif pengguna pangkalan data: %1",
    'db__unable_select_dom_name' => "Tidak dapat memilih nama domain: %1",
    'db_edit__db_for_dom' => "Pengguna untuk pangkalan data %1 pada domain %2",
    'db_edit__invalid_db_name' => "Nama pangkalan data tidak sah.",
    'db_edit__no_users' => "Tidak ada pengguna yang memiliki kelayakan untuk pangkalan data ini.",
    'db_edit__unable_define_db_usrs' => "Tidak dapat takrifkan pengguna pangkalan data: %1",
    'db_edit__unable_select_db_usr' => "Tidak dapat memilih pengguna pangkalan data.",
    'db_edit__db_user_password_for_' => "Sila taip masuk kata laluan untuk log masuk sebagai pengguna pangkalan data %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Tambah pengguna pangkalan data",
    'db_usr_edit__db_usr_name' => "Nama pengguna pangkalan data",
    'db_usr_edit__edit_db_usr' => "Sediakan kelayakan untuk akaun pengguna pangkalan data",
    'db_usr_edit__for_db' => "dalam %1 pangkalan data",
    'db_usr_edit__not_create_pass' => "Operasi ini akan menghasilkan penciptaan akaun pengguna pangkalan data tanpa kata laluan.\nAdakah anda mahu mencipta pengguna tanpa memperuntukkan kata laluan baginya?",
    'dbuser__only_one_user_can_be_default' => "Hanya satu pengguna sahaja yang boleh disetkan sebagai lalai.",
    'db_server__cannot_delete_default' => "Pelayan pangkalan data lalai tidak boleh dipadam.",
    'db_server__cannot_delete_local' => "Pelayan pangkalan data setempat tidak boleh dipadam.",
    'db_server__cannot_delete_used' => 'Pelayan pangkalan data tidak boleh dipadamkan jika ada pangkalan data atau pengguna pangkalan data yang dihoskan padanya.',
    'demo__disabled_in_demo' => "Operasi ini tidak disokong dalam versi demo.",
    'defaultcomponents__title' => "Memilih Komponen lalai",
    'defaultcomponents__select_default' => "Pilih komponen %1 lalai",//to check
    'defaultcomponents__not_installed' => "(tidak dipasang)",
    'defaultcomponents__not_configured' => "(tidak dikonfigurasikan)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Beberapa kategori perkhidmatan mengandungi pilihan yang tidak sah atau tidak ada pemilihan telah dibuat.",
    'defaultcomponents__depends_on' => "(memerlukan %1)",
    'defaultcomponents__parameters' => "Parameter %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "Pelayan SQL",
    'component_name__sqladmin' => "Pentadbir Web MySQL",
    'component_name__sqladminmysql' => "Pentadbir Web MySQL",
    'component_name__dnsserver' => "Pelayan DNS",
    'component_name__firewall' => "Tembok api",
    'component_name__ftpserver' => "Pelayan FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Pelayan Mel",
    'component_name__local_mailserver' => "Pelayan Mel Setempat",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Penskripan Web",
    'component_name__spamfilter' => "Penapis Spam",
    'component_name__stats' => "Statistik Web",
    'component_name__stunnel' => "Pembalut SSL/TLS",
    'component_name__webmail' => "Mel web",
    'component_name__webpublish' => "Penerbitan web",
    'component_name__webserver' => "Pelayan Web",
    'dns__dns_record_invalid_values' => 'Nilai rekod DNS yang ditetapkan adalah salah: %1: %2',
    'dns__dns_record_not_found' => 'Rekod DNS tidak ditemui',
    'dns__dns_zone_invalid_values' => 'Nilai parameter zon DNS yang ditetapkan salah.',

    'dns__soa_mname_title' => 'Pelayan Nama Utama',
    'dns__soa_mname_legend' => 'Pelayan Nama',
    'dns__soa_mname_autoselect' => '(Auto pilih)',

    'dns__dns_zone_off_remove_title' => "Rekod sumber yang berikutnya akan dialih keluar dari zon %1:",
    'dns__dns_zone_master_remove_title' => "Mengalih keluar Rekod Sumber dari Zon DNS %1",
    'dns__dns_zone_slave_remove_title' => "Rekod pelayan nama utama yang berikut bagi %1 akan dialih keluarkan:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Masukkan rentetan rekod',
    'dns_add__is_spf_syntax' => 'Rekod SPF',
    'dns_add__spf_value_is_invalid' => "SPF nilai rekod tidak betul, ia perlu bermula dengan 'v=spf'",
    'dns__dns_zone_status' => "Status zon DNS.",
    'dns__dns_zone_template' => 'Tetapan DNS',
    'dns__invalid_ip_address' => "Alamat IP pelayan DNS utama baharu adalah tidak sah atau kosong.",
    'dns__ip_address' => "Alamat IP",
    'dns__master_dns_type' => "adalah pelayan DNS utama",
    'dns__masters' => "pelayan DNS utama",
    'dns__soa_minimum_too_large' => 'Cache maklum balas negative untuk lebih dari tiga jam tidak disarankan.',
    'dns__select_masters_to_remove' => "Pilih pelayan DNS utama untuk dialih keluarkan.",
    'dns__select_template_record_to_remove' => 'Pilih rekod templat DNS untuk dialih keluarkan.',
    'dns__nameservers_for_domain' => "Pelayan nama untuk domain",
    'dns__remove_dns_zone_of_domain__' => "Pembuangan rekod DNS dari domain %1",
    'dns__remove_dns_zone_template__' => "Rekod DNS yang berikutnya akan dialih keluar dari templat:",
    'dns__remove_this_dns_record?' => "Adakah anda pasti anda mahu mengalih keluar rekod DNS ini?",
    'dns__restore_default' => "Memulihkan zon DNS dengan templat",
    'dns__restore_default_confirm' => "Memulihkan zon DNS akan membuang konfigurasi semasa zon DNS. Teruskan juga?",
    'dns__restore_default_error' => "Ralat memulihkan zon DNS:",
    'dns__slave_dns_type' => "adalah pelayan DNS sekunder",
    'dns__subdomain_dns_rec_removed' => "Rekod A telah dialih keluar dari zon subdomain %1.",
    'dns__zone_switched_off_no_ns' => "Zon telah dimatikan kerana tiada rekod NS %1 yang perlu ada dalam zon. Untuk tambah rekod pada zon, klik butang Tambah Rekod.",
    'dns__cant_switch_on_no_ns' => "Zon tidak dapat dihidupkan kerana tiada rekod NS %1 yang perlu ada di dalam zon. Untuk tambah rekod pada zon, klik butang Tambah Rekod.",
    'dns__unable_activate/deactivate_dns' => "Tidak dapat mengaktifkan/nyahaktifkan DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Tidak dapat menambah pelayan DNS utama: entri pendua.",
    'dns__unable_add_dns_master_local_ip' => "Tidak dapat menambahkan alamat IP bagi pelayan DNS utama: rekod ini hendaklah dicipta pada pelayan jauh.",
    'dns__unable_define_dns_record' => "Tidak dapat mentakrif rekod DNS: %1",
    'dns__unable_get_dns_template_status' => "Tidak dapat mengambil status templat DNS.",
    'dns__unable_remove_dns_rec' => "Tidak dapat mengalih keluar rekod DNS: %1",
    'dns__warnings__' => "Hasil pengubahsuaian zon DNS:",
    'dns__you_not_have_perm_manage_dns' => "Anda tidak mempunyai kebenaran untuk mengurus zon DNS untuk domain ini.",
    'dns__cant_create_record_with_server_ip' => "Tidak dapat menambah alamat IP ini kerana ia sepadan dengan alamat IP bagi pelayan diuruskan Plesk ini.",

    'dns__tabs_acl' => "Pemindahan Zon",
    'dns__acl_add_network_legend' => "Tambah Rangkaian",
    'dns__acl_add_ip_legend' => "Tambah Alamat IP",
    'dns__acl_network_not_allowed' => "Alamat rangkaian adalah tidak dibenarkan oleh DNS dalam Windows.",
    'dns__acl_enter_ip_address_with_mask' => "alamat IP/topeng",
    'dns__acl_enter_ip_address' => "Alamat IP",
    'dns__acl_list_network_legend' => "Rangkaian dibenarkan untuk mendapatkan salinan zon DNS",
    'dns__acl_list_ip_legend' => "Alamat IP dibenarkan untuk mendapatkan salinan zon DNS",
    'bt_dns_acl_add_network' => "Tambah Rangkaian",
    'bt_dns_acl_add_ip' => "Tambah Alamat IP",

    'dns_add__add_rec_for_zone' => "Tambah %1 untuk zon %2",
    'dns_add__canonical_dom_name_is_invalid' => "Nama domain berkanun tidak sah.",
    'dns_add__enter_canonical_name' => "Nama canonical",
    'dns_add__enter_dom_name' => "Nama domain",
    'dns_add__enter_ip_address' => "Alamat IP",
    'dns_add__enter_ip_mask' => "Alamat IP dan topeng rangkaian",
    'dns_add__enter_mail_domain' => "Domain mel",
    'dns_add__enter_mail_exchanger' => "Pelayan pertukaran mel",
    'dns_add__enter_nameserver' => "Namakan pelayan",
    'dns_add__enter_txt_record' => "Rekod TXT",
    'dns_add__enter_service_name' => "Nama perkhidmatan",
    'dns_add__hint_service_name' => "Contoh: SIP (tanpa simbol garis bawah)",
    'dns_add__enter_protocol' => "Protokol",
    'dns_add__hint_protocol_name' => "Contoh: TCP (tanpa simbol garis bawah)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Keutamaan",
    'dns_add__specify_weight_of_service' => "Berat relatif bagi rekod dengan keutamaan yang sama",
    'dns_add__enter_target_host' => "Hos sasaran",
    'dns_add__hint_target_host' => "Contoh: example.com",
    'dns_add__enter_target_port' => "Port sasaran",
    'dns_add__caa_tag' => "Tag",
    'dns_add__caa_value' => "Nilai",
    'dns_add-invalid-A_ip' => "Alamat IP adalah tidak sah.",
    'dns_add-invalid-AAAA_ip' => "Alamat IP adalah tidak sah.",
    'dns_add-invalid-PTR_ip_mask' => "Pasangan alamat IP/netmask berpasangan tidak sah.",
    'dns_add-invalid-SRV_service_name' => "Nama perkhidmatan tidak sah",
    'dns_add-invalid-SRV_protocol_name' => "Protokol tidak sah",
    'dns_add-invalid-SRV_target_port' => "Port sasaran tidak sah",

    'dns_add__invalid_ip' => "Alamat IP adalah tidak sah.",
    'dns_add__low' => "rendah",
    'dns_add__mail_dom_name_is_invalid' => "Nama domain mel tidak sah.",
    'dns_add__nameserver_is_invalid' => "Pelayan nama tidak sah.",
    'dns_add__record' => "%1 rekod",
    'dns_add__select_prefer_for_mail_exchange_server' => "Menentukan keutamaan pelayan pertukaran mel",
    'dns_add__unable_insert_new_dns_rec' => "Tidak dapat memasukkan rekod NS baru: %1",
    'dns_add__very_high' => "sangat tinggi",
    'dom_ctrl__allowed' => "Dibenarkan",
    'dom_ctrl__db' => "Pangkalan data MySQL",
    'dom_ctrl__mssql_db' => "Pangkalan data MS SQL",
    'dom_ctrl__disk_space' => "Ruang cakera",
    'dom_ctrl__dom_adm' => "Domain %1 dari %2",
    'dom_ctrl__dom_cl' => "Domain %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Pemajuan pada domain sediakan dengan URL pemajuan yang tidak ditakrif",
    'dom_ctrl__domain_has_frame_forwarding' => "Domain mempunyai pemajuan bingkai kepada URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Domain tidak ada pengehosan yang dikonfigurasikan.",
    'dom_ctrl__domain_has_physical_hosting' => "Pengehosan web dikonfigurasikan untuk domain ini pada alamat IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domain mempunyai pemajuan standard kepada URL %1",
    'dom_ctrl__maillists' => "Senarai Mel",
    'dom_ctrl__mboxes' => "Peti mel",
    'dom_ctrl__mg' => "Pemajuan mel",
    'dom_ctrl__resource_name' => "Sumber",
    'dom_ctrl__resp' => "Auto-balas",
    'dom_ctrl__subdom' => "Subdomain",
    'dom_ctrl__dom_aliases' => "Alias domain",
    'dom_ctrl__traffic' => "Trafik",
    'dom_ctrl__unable_activate/deactivate_dom' => "Tidak dapat mengaktifkan/nyahaktifkan domain: %1",
    'dom_ctrl__used' => "Digunakan",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Pengguna web",
    'dom_pref__bounce_with_phrase' => "Lantun dengan mesej",
    'dom_pref__bounce' => "Lantunan",
    'dom_pref__catch_addr' => "Majukan ke alamat",
    'dom_pref__reject' => 'Tolak',
    'dom_pref__confirm_domain_removing' => "Tolong jangan lupa untuk memaklumkan pelawat domain tentang perubahan nama domain. Adakah anda pasti anda mahu menamakan semula domain?",
    'dom_pref__db_inconsystency' => "Ketidaktekalan pangkalan data.",
    'dom_pref__dbs' => "Pangkalan Data",
    'dom_pref__delete_traffic_stat' => "Kekalkan statistik web dan trafik",
    'dom_pref__delete_traffic_stat_older' => "Kekalkan statistik web dan trafik",
    'dom_pref__dom_level_name_conflict' => "Nama pengguna pentadbir domain berkonflik dengan nama pengguna salah satu pelanggan.",
    'dom_pref__invalid_disk_space_limit' => "Had ruang cakera tidak sah. Nilai maksima: %1",
    'dom_pref__invalid_expiration_date_limit' => "Tempoh sah tidak sah.",
    'dom_pref__invalid_max_traffic_limit' => "Had trafik tidak sah. Nilai maksima: %1",
    'dom_pref__limits_of_dom' => "Had untuk domain %1",
    'dom_pref__mail_grps' => "Kumpulan mel",
    'dom_pref__mail_nonexistent_user' => "Apa yang perlu dilakukan dengan mel yang dihantar kepada pengguna yang tidak wujud",
    'dom_pref__mail_redirs' => "pemaju mel",
    'dom_pref__mail_resps' => "autobalas mel",
    'dom_pref__max_limit_is_invalid' => "%1 adalah tidak sah.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Bilangan maksimum %1 tidak sah.",
    'dom_pref__new_limit_less_currently_used' => "%1: diminta - %2, sedang digunakan - %3",
    'dom_pref__older_that' => "untuk",
    'dom_pref__postboxes' => "peti mel",
    'dom_pref__preferences_of_dom' => "Tetapan untuk domain %1",
    'dom_pref__redirect_to_itself' => "Pemajuan pada domain akan disetkan kepada domain itu sendiri",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Anda menetapkan masa bendungan statistik trafik domain kurang dari jumlah nilai yang ditetapkan untuk pelayan (%1 bulan). Tempoh bendungan statistik ditetapkan bersamaan dengan nilai lalai untuk pelayan (%1 bulan).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Tidak dapat menambah awalan www pada domain: %1",
    'dom_pref__unable_define_physical_hst_param' => "Tidak dapat mentakrif parameter pengehosan fizikal: %1",
    'dom_pref__unable_rename_domain' => "Tidak dapat menamakan semula domain %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Tidak dapat menentukan kuota peti mel untuk domain ini: %1",
    'dom_pref__unable_set_up_web_user_script' => "Tidak dapat menyediakan bahasa skrip untuk pengguna web: %1",
    'dom_pref__unlimited' => "Tidak terhad",
    'dom_pref__web_usrs' => "pengguna web",
    'dom_pref__you_already_have_%object' => "Anda sudah memiliki %1",
    'cu_domain__error_unable_update_ftp_users' => 'Gagal mengemas kini pengguna FTP domain: %1',
    'dom_cli__warning_ignore_quota' => 'AMARAN: Pilihan "-hard_quota" diabaikan: kuota cakera keras tidak disokong',
    'dom_user_client_login_exist' => "Tidak dapat benarkan akses pentadbir domain kepada Plesk pada domain %1: nama pengguna ini sudah digunakan.",
    'domain__unable_to_turn_on_service' => "Gagal untuk menghidupkan perkhidmatan %1.",
    'domains__change_the_status_of_domain?' => "Adakah anda yakin mahu mengubah status domain %1?",
    'domains__client_info_hiding_traffic' => "%1 domain, %2 domain aktif, %3 ruang cakera yang digunakan",
    'domains__unable_to_change_client_status' => "Tidak dapat mengubah status akaun pelanggan: %1",
    'domains__unable_update_apache_settings' => "Tidak dapat mengemas kini tetapan Apache.:",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Anda tidak mempunyai kebenaran untuk memadam domain.",
    'domains__you_want_change_the_status_of_the_cl??' => "Adakah anda yakin mahu mengubah keadaan akaun pelanggan?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Adakah anda pasti anda mahu melaksanakan operasi ini?",
    'domains_list__unable_remove_doms' => "Tidak dapat mengalih keluar domain: %1",
    'domaintrafficlist_header_of_domain__' => "Trafik di domain %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Pilih alias domain untuk di alih keluar.',
    'domain_aliases_remove__title' => 'Alih keluar alias domain',
    'domain_aliases__max_aliases_reached_for_dom' => "Had ke atas alias nombor dicapai untuk domain ini.",
    'domain_edit__edit_title' => 'Alias nama domain',
    'domain_alias_edit__type' => 'Jenis alias domain',
    'domain_aliases__list_header' => 'Alias domain',
    'domain_aliases__name' => 'Nama',
    'domain_aliases__type' => 'Jenis',
    'domain_aliases__type_full' => 'Web+FTP+Mel',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Alias domain',
    'domain_aliases__legend' => 'Alias domain',
    'domain_alias__domain_exists' => 'Domain dengan apa-apa nama yang sudah wujud',
    'domain_alias__subdomain_exists' => 'Subdomain dengan apa-apa nama yang sudah wujud',
    'domain_alias__dns_record_exists' => 'Suatu rekod DNS dengan domain alias nama yang ditentukan telah wujud',
    'domain_alias__domain_alias_exists' => "Satu domain alias dengan apa-apa nama yang sudah wujud",
    'domain_alias__invalid_type_full' => 'Pelayan mel tidak menyokong alias domain',
    'domain_alias__redirect_exists' => 'Penghalaan semula kepada dirinya dikesan.',

    'ds__anonymous_ftp' => "FTP Awanama",
    'drweb__pagetitle' => 'Tetapan Antivirus',
    'drweb__drweb' => 'Antivirus Parallels Premium',
    'drweb__drweb_direction' => 'Semak mel untuk virus',
    'drweb__drweb_direction_off' => 'Jangan menyemak virus',
    'drweb__drweb_direction_any' => 'Mel masuk dan keluar',
    'drweb__drweb_direction_from' => 'Mel keluar sahaja',
    'drweb__drweb_direction_to' => 'Mel masuk sahaja',
    'drweb__disable_reason_key' => 'Antivirus ini tidak disokong oleh kunci lesen.',
    'drweb__disable_reason_perm' => 'Anda tidak mempunyai kebenaran untuk mengurus Antivirus.',
    'drweb__disable_reason_install' => 'Antivirus tidak dipasang.',
    'drweb__filters' => 'Penapis antivirus',
    'ds__dns' => "Zon DNS",
    'ds__mail' => "Mel",
    'dsr__of_client_title' => "Laporan Ringkas Domain bagi %1",
    'dsr__report_has_been_sent_email' => "Laporan dihantar ke e-mel: %1",
    'dsr__title' => "Laporan Ringkasan Domain",
    'dumps_list__deletion_page_title' => "Fail penyandaran berikut untuk domain %1 akan di alih keluarkan:",
    'dumps_list__dumpfile_is_invalid' => "Fail %1 adalah fail sandaran domain yang tidak sah.",
    'dumps_list__page_title' => "Storan fail sandaran",
    'dumps_upload__page_title' => "Memuat naik Fail Sandaran kepada Storan",
    'dumps_list__repository_is_not_exist' => "Storan fail sandaran tidak wujud.",
    'dumps_list__unable_to_remove' => "Tidak dapat mengalih keluar fail sandaran: %1",
    'dumps_list__dumpfile_can_conflict' => "Nama fail yang anda tetapkan berkonflik dengan fail %1 Tolong tetapkan nama fail lain.",
    'dusr_ed__allow_dl_usr_access' => "Benarkan pentadbir domain akses",
    'dusr_ed__information' => "Sifat Pentadbir Domain %1",
    'dusr_ed__locale' => "Bahasa pentadbir domain",
    'dusr_ed__skin' => "Kulit antara muka pentadbir domain",
    'dusr_ed__personal_information' => 'Maklumat peribadi',
    'ess__error' => "Ralat",
    'example__' => "Contoh: %1",
    'extras__allow_certificate_purchasing' => "Membenarkan pembelian sijil",
    'extras__allow_domain_registration' => "Membenarkan pendaftaran domain",
    'extras__allow_extras' => "Benarkan perkhidmatan tambahan",
    'extras__buy_new_key' => "Lesen semasa anda tidak benarkan anda untuk mengubahsuai objek ini.",
    'extras__setup_services' => "Persediaan perkhidmatan tambahan",

    'ruleeditform__error' => 'Tidak boleh mengemas kini peraturan tembok api.',
    'ruleeditform__name_is_required' => 'Tentukan nama peraturan.',
    'ruleeditform__profiles_is_required' => 'Pilih sekurang-kurangnya satu profil.',
    'ruleeditform__invalid_ip' => 'Alamat IP yang ditentukan atau rangkaian tidak sah.',
    'ruleeditform__invalid_port' => 'Port yang ditentukan adalah tidak sah. Nilai yang mungkin 1000 atau 1000-1051',

    'filemanager__items' => 'Item dalam direktori %1',
    'filemanager__items_paging' => 'Item dalam direktori %1',

    'get_password__encrypted_password' => "Tidak dapat menghantar maklumat kata laluan: kata laluan disimpan dalam bentuk disulitkan.",
    'get_password__mail_error' => "Ralat berlaku ketika cuba menghantar kata laluan ke e-mel %1: %2",
    'get_password__mail_ok' => "Kata laluan berjaya dihantar ke e-mel: %1",
    'get_password__message' => "Nama pengguna anda untuk mengakses sistem: %1\nKata laluan anda ialah %2",
    'get_password__subject' => "Kata laluan untuk mengakses sistem",
    'groups__available' => "Kumpulan mel tersedia",
    'groups__groups_for_mailname' => "Kumpulan mel yang mana akaun mel %1 didaftarkan",
    'groups__member_of' => "Ahli kumpulan mel berikut",
    'help__help_area' => "Kawasan bantuan.",
    'hst_def__auth_disabled' => "dilarang",
    'hst_def__auth_enabled' => "dibenarkan",
    'hst_def__change_curr_dns_ip' => "Alamat IP semasa bagi rekod DNS A akan diubah",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Tidak ada alamat IP bagi rekod DNS A yang berpadanan dengan alamat IP yang memperuntukkan pada akaun pengehosan dicipta",
    'hst_def__dest_url' => "URL destinasi",
    'hst_def__disk_quota' => "Kuota cakera",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Had ruang cakera yang anda cuba tetapkan dilampaui oleh had ruang cakera dalam direktori kemasukan FTP awanama. Had ruang cakera dalam direktori kemasukan FTP awanama mestilah tidak melebihi had ruang cakera domain.",
    'hst_def__frame_forwarding_definition' => "Tugasan pemajuan bingkai untuk domain %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Amaran: Pengguna FTP %1 digunakan dalam tetapan akaun pengehosan tetapi tidak wujud di dalam sistem.",
    'hst_def__hst_type_is_not_defined' => "Jenis pengehosan tidak ditetapkan.",
    'hst_def__ip_based' => "Berasaskan IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "Memindahkan akaun pengehosan ini kepada alamat IP kongsi akan menyebabkan perkhidmatan FTP awanama pada Teruskan juga?",
    'hst_def__password_is_invalid_password_syntax' => "Kata laluan tidak sah.\nJangan gunakan aksara koma tunggal dan huruf bukan abjad di dalam kata laluan.\nPanjang kata laluan mestilah di antara aksara 5 hingga 14. Kata laluan tidak boleh mengandungi nama pengguna.",
    'hst_def__shell' => "Akses SSH ke cangkerang pelayan di bawah pengguna sistem langganan",
    'hst_def__shell_windows' => "Akses Desktop jauh untuk pelayan di bawah pengguna sistem langganan",
    'hst_def__standard_forwarding_definition' => "Tugasan pemajuan standard untuk domain %1",
    'hst_def__title_name_based' => "Berasaskan nama",
    'hst_def__unable_create/update_physic_hst' => "Tidak dapat mencipta atau mengemaskini hos fizikal: %1",
    'hst_def__unable_create/update_std_fwd' => "Tidak dapat mencipta atau mengemaskini pemajuan standard: %1",
    'hst_def__unable_create_forwarding_myself' => "Tidak dapat mencipta pemajuan kepada domain itu sendiri.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Tidak dapat benarkan penggunaan direktori tunggal untuk menyimpan kandungan SSL/TLS dan bukan SSL/TLS: Sokongan SSL/TLS tidak dihidupkan.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Tidak dapat menghidupkan sokongan SSL/TLS: tiada sijil SSL/TLS dipasang.",
    'hst_def__url_is_invalid' => "URL tidak sah",
    'hst_def__virtual_host_access' => "Akses hos maya bagi domain %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "AMARAN. Hos maya ini menggunakan alamat IP yang tidak wujud untuk pengehosan.",
    'hst_def__you_have_no_ips' => "Anda tiada alamat IP yang tersedia dan anda tidak dibenarkan untuk mencipta pengehosan berasaskan Nama.",
    'hst_sel__header' => "Untuk mengehos tapak web pada pelayan ini, pilih pengehosan fizikal.\n Untuk menyediakan pemajuan domain kepada tapak di mesin lain, pilih Pemajuan Bingkai atau Pemajuan Standard.\n Dengan pemajuan standard, pengguna akan dihalakan semula kepada tapak dan URL tapak nyata dipaparkan pada pelayar pengguna, supaya pengguna menyedari penghalaan semula itu. Dengan pemajuan bingkai, pengguna akan dihalakan semula ke tapak tanpa menyedari bahawa tapak tersebut terletak pada lokasi lain.",
    'hst_sel__physical_hst' => "Pengehosan fizikal",
    'hst_sel__select_hst_type' => "Pilih jenis pengehosan untuk domain.",
    'hst_sel__select_hst_type_warning' => "Pilih jenis pengehosan untuk domain.",
    'hst_sel__hosting_exists' => "Tidak dapat mencipta pengehosan kerana ia sudah dikonfigurasikan untuk domain ini. Anda akan dihalakan semula ke halaman pengurusan pengehosan.",
    'hst_sel__standard_frw' => "Pemajuan standard",
    'hst_sel__frame_frw' => "Pemajuan bingkai",
    '__frame_frw' => "Pemajuan bingkai",
    '__hosting_exists' => "Tidak dapat mencipta pengehosan kerana ia sudah dikonfigurasikan untuk domain ini. Anda akan dihalakan semula ke halaman pengurusan pengehosan.",
    '__choose_hst_type' => "Pilih jenis pengehosan yang diperlukan.",
    '__no_hst_conf' => "Tiada pengehosan dikonfigurasikan untuk domain anda.",
    '__physical_hst' => "Pengehosan fizikal",
    '__select_hst_type' => "Pilih jenis pengehosan untuk domain.",
    '__standard_frw' => "Pemajuan standard",
    '__warning' => "Amaran! Semua parameter yang ditetapkan sebelum ini akan dibuang. Adakah anda pasti anda mahu ubah jenis pengehosan?",
    'i_cl_off' => "Pelanggan tidak aktif.",
    'i_cl_off_by_admin' => "Akaun pelanggan digantung oleh pentadbir pelayan.",
    'i_cl_off_expired' => "Akaun pelanggan telah luput.",
    'i_cl_on' => "Pelanggan aktif.",

    'icf__title' => 'Sambungan Tembok Api Internet',
    'icf__if_legend' => 'Antara muka',
    'icf__mode' => 'Mod',

    'invalid_value' => 'Nilai tidak sah',

    'ip_addr__already_exists' => "Alamat IP %1 sudah wujud.",
    'ip_addr__cant_add' => "IP %1 tidak wujud atau tergolong pada himpunan IP pelanggan lain",
    'ip_alias__interface' => "Antara muka",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "Alamat IP %1 untuk pengehosan maya berasaskan Nama adalah tidak sah.",
    'ip_alias__invalid_ip_or_netmask' => "Pasangan alamat IP/netmask berpasangan tidak sah.",
    'ip_alias__orig_ip_can_not_be_deleted' => "Alamat IP %1 adalah alamat asal pelayan, oleh itu anda tidak boleh mengalih keluarkannya",
    'ip_alias__ip_is_invalid' => "%1 Alamat IP tidak sah.",
    'ip_alias__ip_mask_is_invalid' => "%1 Topeng IP tidak sah.",
    'ip_alias__ip_not_exist' => "Alamat IP %1 tidak wujud.",
    'ip_alias__ip_address_and_mask' => 'Alamat IP dan topeng subnet',
    'ip_alias__mask' => "Topeng subnet",
    'ip_alias__remove_selected_ip_aliases?' => "Adakah anda pasti anda mahu mengalih keluar alamat IP yang dipilih?",
    'ip_alias__select_ip' => "Pilih sekurang-kurangnya satu alamat IP dari senarai untuk mengalih keluar.",
    'ip_alias__this_ip_used_for_domain' => "(%1)Alamat IP ini digunakan untuk domain %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) Alamat IP ini digunakan oleh hos maya berasaskan Nama.",
    'ip_alias__unable_add_ip' => "Tidak dapat menambah IP: %1",
    'ip_alias__unable_remove_ip' => "Tidak dapat mengalih keluar IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Anda tidak boleh mengubah jenis alamat IP kepada kongsi, kerana ia akan menjadikan FTP awanama untuk domain '%1' tidak tersedia lagi.",
    'ip_ctrl__ip_addr' => "Alamat IP %2 pada antara muka %1",
    'ip_ctrl__ip_exists_many_pools' => "Anda tidak boleh mengubah jenis IP. Alamat IP ini dimiliki oleh himpunan beberapa pengguna dalam masa yang sama.",
    'ip_ctrl__ssl_cert' => "Sijil SSL/TLS",
    'limit__date_in_past' => "Tempoh pengesahan adalah tidak sah. %1 adalah di masa lalu.",
    'limit__enter_date' => "Tarikh masuk",
    'limit__max_db' => "Pangkalan Data",
    'limit__name_disk_space' => "ruang cakera",
    'limit__name_max_box' => "peti mel",
    'limit__name_max_db' => "Pangkalan data MySQL",
    'limit__name_max_dom' => "domain",
    'limit__name_max_maillists' => "senarai mel",
    'limit__name_max_subdom' => "subdomain",
    'limit__name_max_traffic' => "trafik",
    'limit__name_max_wu' => "pengguna web",
    'limit__name_mbox_quota' => "saiz peti mel",
    'limit__name_max_mn' => "akaun mel",
    'limit__name_max_cl' => 'klien',
    'limit__name_total_mboxes_quota' => "jumlah kuota peti mel",
    'limit__name_mysql_dbase_space' => "Ruang pangkalan data MySQL",
    'limit__name_mssql_dbase_space' => "Ruang pangkalan data MSSQL",
    'limit__name_expiration' => 'tarikh tamat tempoh',

    'locale_upload__unable_to_install' => 'Tidak dapat memasang fail pek bahasa',
    'locale_upload__wrong_package' => 'Fail yang dimuat naik oleh anda tidak mengandungi pek bahasa sah bagi versi Plesk ini.',
    'locale_upload__wrong_locale' => 'Fail yang dimuat naik oleh anda tidak mengandungi pek bahasa sah.',

    'ma__create_title' => 'Mencipta alias mel bagi %1',
    'ma__edit_title' => "Mengedit alias mel %1",
    'ma__enter_new_alias' => "Masukkan alias baru.",
    'ma__invalid_alias' => "Alias mel tidak sah.",
    'ma__mail_aliases_mailname' => "Alias mel bagi akaun mel %1",
    'ma__mailname_does_not_exist' => "Akaun mel tidak wujud.",
    'ma__select_ma_for_remove' => "Pilih alias mel untuk dialih keluar.",
    'ma__unable_to_add_new_ma' => "Tidak dapat untuk menambah alias mel: %1",

    'mail_queue__not_allowed_by_license_key' => 'Pengurusan baris gilir mel tidak dibenarkan oleh kunci lesen.',
    'maillist__' => "Senarai mel %1",
    'maillist__already_exists' => "Senarai mel sudah wujud.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Alias mel %1 telah wujud di dalam domain ini",
    'maillists__' => "Senarai mel %1",
    'maillists__limit_cl_max_maillists' => "Had nombor dari senarai mel telah dicapai untuk pelanggan (had: %1 pengguna: %2)",
    'maillists__limit_dom_max_maillists' => "Had nombor dari senarai mel telah dicapai untuk domain.",
    'maillists__list' => "Senarai Mel",
    'maillists__mailman_not_installed_or_conf' => "\nSambungan Pelayan Mailman tidak dipasang atau dikonfigurasikan\npada pelayan. Hubungi pentadbir pelayan untuk Sambungan Pelayan Mailman dipasang atau dikonfigurasikan dengan betul.",
    'maillists__status' => "Perkhidmatan senarai mel dihidupkan",
    'maillists__unable_to_delete__' => "Tidak dapat memadam senarai mel: %1",
    'maillists__disabled_text' => 'Anda tidak boleh mengurus senarai mel kerana komponen pelayan senarai mel Mailman tidak dipasang atau dikonfigurasikan.',
    'maillist_member__already_exists' => 'Pelanggan senarai mel sudah wujud.',
    'maillist_member__not_exists' => 'Tiada pengguna pada senarai mel.',
    'mailserver_switching_warning' => "Amaran!\n\nMengubah pelayan mel hanyalah ditujukan untuk penyediaan awal dan, jika pelayan telah pun digunakan, menyebabkan masalah berikut: kehilangan tetapan dan kandungan peti mel dan dalam kes apabila pelayan yang anda tukarkan telah dikonfigurasikan, pelbagai konflik.\nJika pelayan ini sedang digunakan dan anda pasti mahu menukar kepada yang lain, anda boleh memberitahu pelanggan anda mengenai operasi itu supaya mereka boleh memuat turun dan menyimpan mel mereka.",
    'manager__access_denied' => "Akses ditolak: %1",
    'manager__admin' => "Pentadbir",
    'manager__client' => 'Pelanggan',
    'manager__domain' => "Domain",
    'manager__domain_cl_limit_exceeding' => "Had bilangan domain telah dicapai untuk akaun pelanggan ini.",
    'manager__domain_is_not_yours' => "Domain %1 bukan milik anda.",
    'manager__domain_key_limit_exceeding' => "Had pada ciptaan domain yang ditakrifkan oleh lesen anda telah dicapai.",
    'manager__no_perm_to_call' => "Anda tidak mempunyai kebenaran untuk memanggil %1.",
    'manager__no_perm_to_create_domains' => "Anda tidak mempunyai kebenaran untuk mencipta domain.",
    'manager__no_perm_to_modify_domain' => "Anda tidak mempunyai kebenaran untuk mengubah domain %1.",
    'manager__no_perm_to_modify_domains' => "Anda tidak mempunyai kebenaran untuk mengubah domain.",
    'manager__no_perm_to_remove_domain' => "Anda tidak mempunyai kebenaran untuk mengalih keluar domain %1.",
    'manager__no_perm_to_remove_domains' => "Anda tidak mempunyai kebenaran untuk membuang domain.",
    'manager__node_doesnt_exist' => "%1 tidak wujud.",
    'manager__user_disabled' => "Akaun anda telah digantung. Anda tidak boleh mengoperasikan sistem.",
    'mail_quota_unsupported' => "tidak disokong oleh pelayan mel",
    'mbox_quota_unsupported' => "tidak disokong oleh pelayan mel",
    'mn__create_title' => "Cipta akaun mel",
    'mn__edit_title' => "Tetapan",
    'mn__files_list_title' => "Fail Lampiran",
    'mn__files_remove' => "Alih keluar fail dari lampiran repositori. Fail mungkin digunakan oleh autobalas. Ianya akan dialih keluar dari kedua-dua repositori dan autobalas menggunakannya.",
    'mn__files_select_for_remove' => "Pilih fail untuk dibuang.",
    'mn__mail_alias_form' => "Borang alias mel",
    'mn__mail_aliases_list' => "Alias mel",
    'mn__mailbox' => "Pengurusan peti mel",
    'mn__unable_define_mn' => "Tidak dapat sediakan akaun mel: %1",
    'mn__unable_remove_mbox_quota' => "Tidak dapat mengalih keluar kuota peti mel. %1",
    'mn__upload_file' => "Muat naik fail",
    'mn_edit__attach_filename_changed' => 'Fail yang dimuat naik %1 telah dinamakan semula kepada %2 kerana nama tersebut mengandungi aksara bukan ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Anda perlu menambah ahli kumpulan mel sebelum mendayakan kumpulan mel.",
    'mn_edit__add_resp_or_turn_off_box' => "Anda perlu menambah autobalas atau kosongkan kotak semak autobalas.",
    'mn_edit__attachments' => "Lampiran",
    'mn_edit__dom_quota_less_then_quota' => "Saiz peti mel ini tidak boleh melebihi had jumlah ruang cakera diperuntukkan bagi peti mel dalam domain ini.",
    'mn_edit__enter_external_rcpnt_email' => "Masuk e-mel ahli\\ kumpulan mel luaran.",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Taip alamat bagi pemajuan mel atau kosongkan kotak semak.",
    'mn_edit__ext_rcpnt_email_invalid' => "Alamat e-mel penerima' luaran adalah tidak sah.",
    'mn_edit__file_exists' => "Fail wujud. Tulis ganti?",
    'mn_edit__files_deld_from_repository' => "Fail tersebut akan dipadam dari repositori dan kandungannya dari auto balas. Adakah anda mahu meneruskannya?",
    'mn_edit__mail_name' => "Akaun mel",
    'mn_edit__mail_name_invalid' => "Nama akaun mel adalah tidak sah.",
    'mn_edit__mail_redir' => "Pemaju mel",
    'mn_edit__mail_redir_add' => "Tambah ahli kumpulan mel",
    'mn_edit__mail_resps' => "Autobalas mel",
    'mn_edit__mailbox' => "Peti Mel",
    'mn_edit__enable_mailbox' => "Peti Mel",
    'mn_edit__mailgroup' => "Kumpulan mel",
    'mn_edit__mailgroup_addresses' => "Ahli kumpulan mel",
    'mn_edit__mailgroup_disabled' => "Hanya tersedia apabila akaun mel telah ditambah.",
    'mn_edit__max_dom_quota' => "Lalai bagi domain (%1)",
    'mn_edit__mbox_quota_invalid' => "Kesalahan pernyataan saiz peti mel.",
    'mn_edit__new_resp_name' => "Nama autobalas baru",
    'mn_edit__no_autoresponders' => "Anda perlu menambah sekurang-kurangnya satu autobalas sebelum meghidupkan/mematikan perkhidmatan autobalas.",
    'mn_edit__no_file_sel' => "Tiada fail dipilih.",
    'mn_edit__no_mail_addresses' => "Tiada alamat e-mel yang dinyatakan atau dipilih.",
    'mn_edit__none' => "Tiada",
    'mn_edit__not_create_pass' => "Ini tidak akan mencipta kata laluan bagi akaun tersebut.\nTanpa kata laluan, pengguna tidak akan dapat melihat dan menghantar mel.",
    'mn_edit__redir_email_invalid' => "Memajukan alamat adalah tidak sah.",
    'mn_edit__redirect_addr' => "Memajukan alamat",
    'mn_edit__remove_autoresp?' => "Adakah anda pasti anda mahu mengalih keluar auto alas?",
    'mn_edit__remove_rcpnts?' => "Adakah anda pasti anda mahu mengalih keluar penerima ini?",
    'mn_edit__repository' => "Repositori",
    'mn_edit__resps_attach' => "Fail lampiran autobalas",
    'mn_edit__select_rcpnt_from_list' => "Pilih sekurang-kurangnya satu penerima dari senarai untuk dialih keluar.",
    'mn_edit__select_registered_users' => "Pilih pengguna berdaftar",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Anda telah memilih untuk mempunyai peti mel tetapi anda sediakan kata laluan untuknya.",
    'mn_edit__unable_act_deact_mail_group' => "Tidak dapat mengaktifkan atau menyahaktifkan kumpulan mel: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Tidak dapat mengaktifkan atau menyahaktifkan mel yang dimajukan: %1",
    'mn_edit__unable_act_deact_postbox' => "Tidak dapat mengaktifkan atau menyahaktifkan peti mel: %1",
    'mn_edit__unable_act_deact_resp' => "Tidak dapat mengaktifkan atau menyahaktifkan auto balas: %1",
    'mn_edit__unable_add_attach' => "Tidak dapat menambah fail lampiran: %1",
    'mn_edit__unable_add_mail_group_member' => "Tidak dapat menambah ahli kumpulan mel: %1",
    'mn_edit__unable_add_resp' => "Tidak dapat menambah autobalas: %1",
    'mn_edit__unable_change_mail_name' => "Tidak dapat menukar nama akaun mel: %1",
    'mn_edit__unable_deactivate_mail_group' => "Tidak dapat menyahaktifkan kumpulan mel: %1",
    'mn_edit__unable_deactivate_resp' => "Tidak dapat nyahaktifkan autobalas mel: %1",
    'mn_edit__unable_define_resp_id' => "Tidak dapat mentakrifkan ID autobalas: %1",
    'mn_edit__unable_remove_attach' => "Tidak dapat mengalih keluar fail lampiran: %1",
    'mn_edit__unable_remove_autoresp' => "Tidak dapat mengalih keluar autobalas: %1",
    'mn_edit__unable_remove_mail_group_member' => "Tidak dapat mengalih keluar ahli kumpulan mel: %1",
    'mn_edit__wrong_way' => 'Mesej yang beralamat pada %1 tidak akan dihantar, kerana akaun mel tidak mempunyai peti mel atau pemaju mel dihidupkan.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Peti mel pada alamat %1 telah dimatikan. Mesej di dalam peti mel tidak dialih keluar tetapi anda tidak akan dapat mengambilnya melalui IMAP atau protokol POP3.',
    'mn_list__mail_names_for_domain' => "Akaun mel bawah domain %1",
    'mn_list__sa_cannot_unable' => "Tidak dapat menghidupkan penapisan spam",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Pelanggan',
    'mn_list__tab_title_domain' => 'Domain',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nama",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Tidak dapat mengalih keluar akaun mel. %1",
    'module_upload__module_was_installed' => 'Modul ini sudah dipasang. Jika anda ingin memasang versi terbaru modul ini, sila nyahpasang modul melalui Plesk dan kemudian cuba memasangnya.',
    'module_upload__unable_to_install' => 'Tidak dapat memasang fail pek modul',
    'module_upload__wrong_package' => 'Fail yang dimuat naik tidak disokong oleh pakej modul.',
    'module_upload__wrong_module' => 'Fail yang dimuat naik tidak mengandungi pakej modul.',

    'news_articles_title' => 'Berita Plesk',
    'notification_text__invalid_subject_length' => "Panjang subjek notis tidak sah. Mestilah aksara dari 1 ke 255.",
    'notification_text__invalid_text_length' => "Panjang teks notis tidak sah. Mestilah aksara dari 1 ke 65533.",
    'notification_text__subject' => "Subjek notis",
    'notification_text__text' => "Teks notis",
    'notification_text__title' => "Edit notis",
    'notification_text__unable_set_text' => "Tidak dapat mengubah teks notis:",

    'odbc__cant_add_dsn' => "Tidak dapat menambah DSN %1: %2",
    'odbc__cant_connect' => "Tidak dapat menyambung sumber data menggunakan tetapan yang ditakrifkan. Pelayan telah dikembalikan: %1",
    'odbc__cant_delete_dsn' => "Tidak dapat memadam DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Tidak dapat mendapatkan maklumat tentang pemacu.",
    'odbc__cant_get_drivers' => "Tidak dapat mengambil senarai dari pemacu ODBC: %1",
    'odbc__cant_open_info_file' => "Tidak dapat membuka fail dengan maklumat pemacu ODBC.",
    'odbc__cant_parse_string' => "Tidak dapat menghurai sambungan rentetan.",
    'odbc__driver_not_set' => "Pemacu tidak ditetapkan",
    'odbc__driver_or_name_not_set' => "Pemacu atau nama dari sambungan ODBC tidak ditetapkan",
    'odbc__dsn_already_exists' => "DSN dengan nama (%1) telah pun wujud dalam sistem",
    'odbc__dsn_not_exists' => "Langganan tersebut tidak wujud.",
    'odbc__enter_dsn_name' => "Masukkan nama DSN",
    'odbc__invalid_dsn_name' => "Sintaks yang salah bagi nama sambungan ODBC (%1): sila guna hanya simbol abjad angka.",
    'odbc__no_such_driver' => "Pemacu ODBC dengan nama (%1) tidak disokong.",
    'odbc__unknown_driver' => "Nama pemacu yang tidak diketahui (%1).",
    'odbc_dsn_system' => "Sistem DSN",

    'pb__aliases' => "Alias",
    'pb__anonftp' => "FTP Awanama",
    'pb__autoinstaller_releases' => 'Pengemas kini',
    'pb__cert' => "Sijil",
    'pb__cl_pool' => "Alamat IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Tetapan",
    'pb__cl_rpt' => "Laporan",
    'pb__cl_rpt_list' => "Penyesuaian",
    'pb__cl_templates' => "Templat pelanggan",
    'pb__cl_traffic' => "Trafik",
    'pb__cl_traffic_history' => "Sejarah trafik",
    'pb__cl_traffic_of' => "Trafik dari %1",
    'pb__client' => "%1",
    'pb__clients' => "Pelanggan",
    'pb__comp_info' => "Komponen Pelayan",
    'pb__common_acl' => 'Benarkan Pindahan ACL',
    'pb__cp_access' => "Akses",
    'pb__crontab' => "Penjadual",
    'pb__scheduler' => "Penjadual",
    'pb__custom_buttons' => "Butang tersuai",
    'pb__databases_db' => 'Pangkalan Data',
    'pb__sqlservers_db' => 'Pelayan SQL',//to check
    'pb__db' => "Pangkalan Data",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Pelayan pangkalan data',
    'pb__dl_usr_ed' => "Pentadbir domain",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Had domain",
    'pb__dom_pref' => "Tetapan",
    'pb__dom_sum_report' => "Laporan Ringkasan Domain",
    'pb__dom_templates' => "Templat Domain",
    'pb__dom_traffic' => "Trafik dari %1",
    'pb__domains' => "Domain",
    'pb__domain_aliases' => 'Alias Domain',
    'pb__dumps_list' => "Storan Fail Sandaran",
    'pb__forwarding_setup' => "Persediaan Pemajuan",
    'pb__filemanager' => "Pengurus Fail",
    'pb__ip_aliasing' => "Alamat IP",
    'pb__ip_clients' => "Pembuangan alamat IP",
    'pb__license_management' => 'Maklumat Lesen',
    'pb__locales' => 'Tempatan',
    'pb__log_files' => "Fail log",
    'pb__mail' => 'Mel',
    'pb__mail_name_files' => "Fail Lampiran",
    'pb__mail_name_redirects' => "Pemaju mel",
    'pb__mail_name_resp_attach_add' => "Lampiran baru",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Autobalas mel",
    'pb__mail_names' => "Mel",
    'pb__maillists' => "Senarai Mel",
    'pb__mimetypes' => 'Jenis MIME',
    'pb__modules' => 'Modul',
    'pb__modules_management' => 'Urus Modul',
    'pb__notifications' => "Pemberitahuan",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Persediaan pengehosan fizikal",
    'pb__prtd_dirs' => "Direktori Dilindungi",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Laporan",
    'pb__report_auto' => "Jadual penghantaran untuk %1",
    'pb__report_list' => "Penyesuaian",
    'pb__server' => "Pelayan",
    'pb__sessions' => "Sesi",
    'pb__sapp_pool' => "Himpuanan Aplikasi Web",
    'pb__siteapp_install' => 'Pemasangan aplikasi web',
    'pb__site_app_pkgs' => 'Aplikasi Web',
    'pb__site_apps' => "Aplikasi Web",
    'pb__additional_key_info' => 'Sifat Kunci',
    'pb__additional_key_properties' => 'Sifat Kunci',
    'pb__skeleton' => 'Templat Hos Maya',
    'pb__skins' => 'Kulit',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Penapis Spam",
    'pb__statistics' => "Statistik",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomain",
    'pb__templates' => "Templat",
    'pb__virtualdirs' => 'Direktori maya',
    'pb__web_users' => "Pengguna web",
    'pdir__enter_dir_name' => "Masukkan nama direktori.",
    'pdir__invalid_hst' => "Jenis pengehosan tidak sah. Mesti secara fizikal.",
    'pdir__pd_id_is_undefined' => "ID direktori dilindungi tidak dapat ditakrifkan.",
    'pdir__pdir_exist' => "Direktori dengan nama ini sudah pun dilindungi.",
    'pdir__pdir_not_exist' => "Direktori dilindungi tidak wujud.",
    'pdir__pdir_usr_not_exist' => "Direktori dilindungi pengguna tidak wujud.",
    'pdir__remove_pdir_usrs' => "Pengguna berikut dari direktori dilindungi %2 bawah tapak web %1 akan dibuang:",
    'pdir__remove_pdir_usrs_on_subdom' => "Pengguna berikut bagi direktori dilindungi %2 di bawah subdomain %1 akan dialih keluar:",
    'pdir__select_pdir_usrs_for_remove' => "Pilih pengguna direktori dilindungi untuk dialih keluar.",
    'pdir__select_pdirs_to_remove' => "Pilih direktori untuk mengalih keluar perlindungan.",
    'pdir__unable_define_pdir_users' => "Tidak dapat mentakrif pengguna direktori dilindungi.",
    'pdir__unable_define_pdirs_properties' => "Tidak dapat tetapkan sifat dari direktori dilindungi: %1",
    'pdir__unable_select_dom_param' => "Tidak dapat memilih parameter domain: %1",
    'pdir_ed__create_pdir_for_domain' => "Cipta direktori dilindungi di bawah %1",
    'pdir_ed__create_pdir_for_subdomain' => "Cipta direktori dilindungi di bawah subdomain %1",
    'pdir_ed__dir_already_protect' => "Direktori ini sudah pun dilindungi.",
    'pdir_ed__head_txt' => "Tajuk dari kawasan yang dilindungi",
    'pdir_ed__invalid_login' => "Anda menyatakan nama pengguna yang salah.",
    'pdir_ed__login_exists' => "Pengguna ini sudah pun wujud. Cuba nyatakan nama pengguna yang lain.",
    'pdir_ed__new_usr' => "Nama pengguna",
    'pdir_ed__non_ssl' => "bukan SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Nama direktori",
    'pdir_ed__pdir_for_domain' => "Direktori dilindungi %1 pada domain %2",
    'pdir_ed__pdir_for_subdomain' => "Direktori dilindungi %1 di bawah subdomain %2",
    'pdir_ed__pdir_location' => "Lokasi direktori",
    'pdir_ed__pdir_users' => "Pengguna direktori dilindungi",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Sekurang-kurangnya satu kotak semak perlu dipilih dari kotak semak SSL/TLS dan bukan SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Tidak dapat mencipta direktori dilindungi pengguna: %1",
    'pdir_ed__unable_create_pdir' => "Tidak dapat mencipta direktori dilindungi: %1",
    'pdir_ed__unable_define_hst_type' => "Tidak dapat mentakrifkan jenis pengehosan.",
    'pdir_ed__unable_update_pdir' => "Tidak dapat ubtuk simpan tetapan dari direktori dilindungi: %1",
    'pdir_ed__wrong_symbol_in_header' => "Sila jangan gunakan aksara %1 dalam tajuk direktori.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Cipta pengguna bagi direktori dilindungi %1",
    'pdir_usr_ed__not_create_pass' => "Ini tidak akan mencipta kata laluan bagi pengguna direktori dilindungi baru.\nTanpa kata laluan pengguna tidak akan dapat untuk log masuk.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Kata laluan bagi pengguna direktori yang dilindungi %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Tidak dapat memilih pengguna direktori yang dilindungi: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Tidak dapat mentakrif direktori dilindungi pengguna: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Tidak dapat mengalih keluar direktori dilindungi pengguna: %1",
    'phosting__anonftp_encrypt' => 'Kata laluan dari pengguna FTP telah disulitkan, dan oleh itu ianya tidak boleh digunakan untuk direktori pelindungan /stat-plesk/statweb/. Sila masukkan semula kata laluan FTP anda, atau tidak pilih pilihan "accessible via password protected directory \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Nama domain %%domain_name%% diselesaikan kepada alamat IP %%dns_ip_address%%. Tapak web anda memperuntukkan alamat IP %%hosting_ip_address%%. Jika tapak web anda tidak dapat dibuka dalam pelayar web semasa anda merujuk padanya melalui nama domainnya, pergi ke skrin pengurusan DNS (Domain > Nama domain > DNS) dan tukar sifat rekod sumber A: peruntukkan alamat IP %%hosting_ip_address%% kepada nama domain %%domain_name%%.",
    'phosting__ip_change_warning' => "Alamat IP berubah. Perubahan yang sepadan juga dibuat dalam zon DNS domain.",
    'phosting__other_hosting_exists_on_ip' => "Tidak dapay ubah butiran kerana alamat IP ini sedang diguna dalam satu atau beberapa pengehosan urus:",
    'phosting__unable_to_change_certificate' => "Tidak dapat memasang sijil: %1",
    'phosting__unable_to_change_ip_address' => "Tidak dapat ubah alamat IP: %1",
    'phosting__unable_to_set_cert' => "Tidak dapat tetapkan Sijil SSL/TLS: %1",
    'phosting__unable_update' => "Tidak dapat untuk kemas kini tetapan pengehosan: %1",
    'phosting__unable_manage' => "Tidak dapat urus pengehosan: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Tidak dapat mengkonfigurasi fail2ban untuk mengesan log domain. Log akan dikesan secara automatik apabila perkhidmatan fail2ban dimulakan semula.\n%1",

    'picker_acl_record__tittle' => 'Pilih rekod ACL',
    'picker_autoresponder__title' => 'Pilih Autobalas',
    'picker_black_list__domain_name' => 'Pilih Nama domain',
    'picker_certificate' => 'Pilih sijil SSL/TLS',

    'picker_dns_zone_template__title' => 'Pilih Sumber Rekod',
    'picker_domain__title' => 'Pilih Tapak Web',
    'picker_domain_alias__title' => 'Pilih Alias Domain',
    'picker_resource_record__title' => 'Pilih Sumber Rekod',
    'picker_disabled_resource_record__title' => 'Pilih Nama Pelayan',
    'picker_ip_address__title' => 'Pilih alamat IP',
    'picker_ip_address_clients__title' => 'Pilih pelanggan yang guna Alamat IP ini',
    'picker_mail_queue' => 'Pilih Mesej E-mel',
    'picker_site_application__title' => 'Pilih Aplikasi Web',
    'picker_subdomain__title' => 'Pilih Subdomain',
    'picker_web_user__title' => 'Pilih Pengguna Web',
    'picker_custom_button__title' => 'Pilih butang tersuai',
    'picker_license_key__title' => "Pilihan kunci lesen",
    'picker_spamfilter_address__title' => 'Pilih Alamat Penapis Spam',
    'picker_white_list__networks' => 'Pemilihan rangkaian',

    'plesk_key__action_logs' => "Log masuk tindakan yang dilakukan oleh pengguna Plesk.",
    'plesk_key__app_vault' => "Ruang simpan aplikasi",
    'plesk_key__backup' => "Fungsi sandaran dan pemulihan",
    'plesk_key__client_templs' => "Pengurusan pelan perkhidmatan",
    'plesk_key__clients' => "Guna akaun (penjual semula dan pelanggan)",
    'plesk_key__resellers_only' => "Akaun pengguna (penjual semula)",
    'plesk_key__customers_only' => "Akaun pengguna (pelanggan)",
    'plesk_key__domains' => "Domain",
    'plesk_key__domain_aliases' => "Alias domain",
    'plesk_key__manage_dashboard' => 'Penyesuaian laman utama',
    'plesk_key__drweb' => "Pengurusan antivirus",
    'plesk_key__event_manager' => "Pengurus acara",
    'plesk_key__expirations' => "Pengurusan akaun tarikh tamat tempoh",
    'plesk_key__group_ops' => "Pengubahsuaian pelbagai objek sekaligus",
    'plesk_key__expiration' => "Kunci tarikh tamat tempoh",
    'plesk_key__edition_name' => "Edisi Plesk",
    'plesk_key__key_number' => "Nombor kunci.",
    'plesk_key__languages' => "Pek bahasa",
    'plesk_key__mailnames' => "Akaun mel",
    'plesk_key__migration_manager' => "Migrasi & Pemindahan Pengurus",
    'plesk_key__mssql' => "Sokongan Pelayan Microsoft SQL",
    'plesk_key__myplesk_func' => "Pautan untuk membeli sijil SSL/TLS dan perkhidmatan pendaftaran domain",
    'plesk_key__myplesk_server_id' => "Pengecam pelayan hamba MPC",
    'plesk_key__notifications' => "Pengurusan pemberitahuan",
    'plesk_key__postgresql' => "Sokongan pelayan pangkalan data PostgreSQL",
    'plesk_key__qmail_queue' => 'Pengurusan mel giliran',
    'plesk_key__remote_db' => 'Pengehosan pangkalan data jauh',
    'plesk_key__slave_servers' => "Pelayan hamba",
    'plesk_key__spamassassin' => "Pengurusan penapis spam",
    'plesk_key__subdomains' => "Pengurusan subdomain",
    'plesk_key__sys_access' => "Pengurusan akses ke pelayan",
    'plesk_key__traffic_reports' => "Laporan penggunaan trafik",
    'plesk_key__tts' => "Meja Bantuan",
    'plesk_key__virtuozzo' => "Sah untuk bekas Virtuozzo sahaja",
    'plesk_key__webusers' => "Pengguna web",
    'plesk_key__license_update_date' => 'Kemas kini kunci lesen seterusnya.',
    'plesk_key__autoinstaller_config' => 'Pengurusan tetapan pengemask kini',
    'plesk_key__check_wrong' => "Kunci lesen adalah tidak sah. Untuk menggunakan Plesk, sila dapatkan dan pasang kunci lesen baru sah.",
    'plesk_key__upload_check_wrong' => 'Muat naik kunci lesen tidak sah.',
    'plesk_key__revert_check_wrong' => 'Kunci lesen dipasang sebelum ini tidak sah.',
    'plesk_key__update_check_wrong' => 'Kemas kini kunci lesen tidak sah.',
    'plesk_key__viruozzo_only_key' => 'Kunci lesen ini hanya bertujuan untuk digunakan dengan Plesk yang beroperasi dalam bekas Virtuozzo.',
    'plesk_key__ip_ranges_exceeded' => 'Anda boleh menggunakan salinan Plesk berlesen ini hanya dengan alamat IP berikut: %2. Alamat IP berikut tidak dilindungi oleh lesen anda: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Jumlah sumber yang digunakan kini melebihi had yang ditetapkan oleh lesen anda.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Bilangan tapak web yang dihoskan pada pelayan yang melebihi had yang ditakrifkan oleh lesen anda. Anda mempunyai %2 tapak yang dihoskan; lesen anda membenarkan anda mengendalikan hanya %1 tapak.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Bilangan alias domain pada pelayan melebihi had yang ditakrifkan oleh lesen anda. Anda mempunyai %2 alias domain; lesen anda membenarkan anda mengehoskan hanya %1 alias domain.',
    'plesk_key__limits_exceeded_lim_cl' => 'Bilangan akaun pelanggan yang diuruskan melebihi had yang ditakrifkan oleh lesen anda. Anda mempunyai %2 akaun pelanggan yang dikendalikan pada masa ini; lesen anda membenarkan anda mengendalikan hanya %1 akaun pelanggan.',
    'plesk_key__limits_exceeded_lim_mn' => 'Bilangan akaun e-mel diuruskan melebihi had yang ditakrifkan oleh lesen anda. Anda mempunyai %2 akaun e-mel yang dikendalikan pada masa ini; lesen anda membenarkan anda mengendalikan hanya %1 akaun e-mel.',
    'plesk_key__limits_exceeded_lim_wu' => 'Bilangan akaun web pengguna diuruskan melebihi had yang ditakrifkan oleh lesen anda. Anda mempunyai %2 akaun pengguna web yang dikendalikan pada masa ini; lesen anda membenarkan anda mengendalikan hanya %1 akaun pengguna web.',
    'plesk_key__limits_exceeded_MLS' => 'Bilangan pek bahasa kini dipasang melebihi had yang ditakrifkan oleh lesen anda. Terdapat %2 pek bahasa dipasang; lesen anda membenarkan anda memasang %1 pek bahasa.',
    'plesk_key__wrong_version' => 'Anda sedang cuba menggunakan kunci lesen yang dicipta untuk versi Plesk lain. Hubungi wakil jualan Plesk untuk mendapatkan kunci lesen yang betul.',
    'plesk_key__other_product' => 'Anda sedang cuba menggunakan kunci lesen yang dicipta untuk produk lain. Hubungi wakil jualan Plesk untuk mendapatkan kunci lesen yang betul.',
    'plesk_key__invalid_machine_id_trial' => 'Lesen semasa anda tidak sah kerana ia sudah diaktifkan pada pelayan Plesk yang lain. Untuk terus menggunakan Plesk, sama ada pasang lesen baharu atau pasang lesen semasa anda sekali lagi dengan memasukkan kod pengaktifannya (jika anda ada).',
    'plesk_key__invalid_machine_id_retail' => 'Lesen semasa anda tidak sah kerana ia telah diaktifkan pada pelayan Plesk yang lain. EULA Plesk (https://www.plesk.com/legal/) melarang penggunaan satu lesen pada dua atau lebih pelayan pada masa yang sama. Untuk terus menggunakan Plesk, sama ada pasang lesen baharu atau pasang lesen semasa anda sekali lagi dengan memasukkan kod pengaktifannya. Ia telah dihantar kepada anda melalui e-mel semasa anda membeli lesen. <br>Tidak dapat mencari kod pengaktifan? Anda boleh mendapatkannya menggunakan Plesk 360. Untuk berbuat demikian, log masuk ke https://platform360.io/ dengan e-mel yang anda gunakan untuk membeli lesen, pergi ke tab "Licenses", dan lihat kod pengaktifan lesen anda. Atau anda boleh menghubungi sokongan Pelesenan dan Pembelian Plesk menggunakan borang dalam talian (https://www.plesk.com/licensing-and-purchase-support/). Ingat untuk menyebut nombor lesen anda dalam bahagian "How can we help you?" borang.',
    'plesk_key__limits_exceeded_error' => 'Tidak dapat memasang kunci lesen: jumlah yang kini digunakan sumber melebihi had yang ditakrifkan dalam kunci lesen yang dimuat naik.',
    'plesk_key__limits_exceeded_note' => 'Jumlah yang kini digunakan sumber melebihi had yang ditakrifkan dalam kunci lesen yang dimuat naik.',
    'plesk_key__key_file_invalid' => 'Fail utama yang dimuat naik tidak sah atau tidak mengandungi kunci lesen.',
    'plesk_key__server_request_error' => 'Tidak dapat mengemas kini lesen. Pastikan sambungan ke pelayan lesen ka.plesk.com pada port TCP %1 tidak disekat. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Lihat cara untuk melakukannya</a>.',
    'key__no_key_file_in_zip' => 'Fail .zip yang dimuat naik tidak mengandungi fail kunci',
    'key__key_upload' => 'Pemasangan kunci lesen',
    'additional_key__prop_name' => 'Sifat',
    'additional_key__prop_value' => 'Nilai',
    'additional_key__descr_name' => 'Nama kunci.',
    'additional_key__descr_key_number' => 'Nombor kunci.',
    'additional_key__descr_key_vz' => "Kunci lesen ini hanya bertujuan untuk digunakan dalam bekas Virtuozzo.",
    'additional_key__descr_key_mailboxes' => 'Peti mel',
    'additional_key__descr_lim_date' => 'Tarikh tamat tempoh',
    'additional_key__descr_license_update_date' => 'Kemas kini kunci lesen seterusnya.',
    'additional_key__file_invalid' => 'Fail utama yang dimuat naik tidak sah atau tidak mengandungi kunci lesen.',
    'additional_key__file_incompatible' => 'Fail kunci yang dimuat naik tidak sah untuk aplikasi ini.',
    'additional_key__expired' => 'Kunci tambahan sudah tamat tempoh.',
    'additional_key__not_exists' => 'Tiada kunci lesen yang dipasang.',
    'additional_key__viruozzo_only_key' => 'Kunci lesen ini hanya bertujuan untuk digunakan dengan Plesk yang dipasang dalam bekas Virtuozzo.',
    'additional_key_update__result_response' => 'Maklum balas pelayan perlesenan. %1',
    'additional_key_update__result_network' => 'Tidak dapat sambung ke pelayan perlesenan. Tolong pastikan raingkaian anda benarkan komunikasi ke %1: %2.',
    'additional_key_update__result_lock' => 'Kemas kini kunci dalam perjalanan.',
    'additional_key_update__result_internal_error' => 'Ralat terjadi semasa mengemaskini kunci lesen. %1',

    'proceed_to_cl_pool' => "Teruskan ke konfigurasi himpunan pelanggan",
    'proceed_to_hosting_setup' => "Teruskan ke persediaan pengehosan",
    'removeCerts__remove_certificates_cp' => "Sijil berikut akan dialih keluar:",
    'removeCerts__remove_certificates_domain' => "Sijil berikut yang dimiliki oleh %1 akan dialih keluar:",
    'removeClientsIP_remove_clients_ip' => "Alamat IP akan dialih keluar kolam daripada pelanggan seperti berikut:",
    'removeMailAliases__remove_mail_aliases' => "Alias mel berikut untuk %1 akaun mel akan dikeluarkan:",
    'removeMailNames__remove_mailnames' => "Akaun mel dan alias berikut akan dialih keluar dari domain %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Akaun mel dan alias berikut akan dialih keluar dari domain %2 dimiliki oleh pelanggan %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Akaun mel ini tidak akan dipadam.",
    'removeFtpSessions__remove_title' => "Sesi FTP berikut akan ditamatkan:",
    'removeTemplates__remove_templates' => "Templat berikut akan dialih keluar:",
    'report_auto__list_auto' => 'Frekuensi',
    'report_auto__list_last' => 'Tarikh akhir penghantaran',
    'report_auto__list_recipient' => 'Hantar pada',
    'report_auto__list_select' => 'Lapor pada',
    'report_auto__title' => 'Jadual Penghantaran untuk %1',
    'report_auto__recipient_email' => 'alamat e-mel I ditentukan',
    'report_auto__recipient_admin' => 'pentadbir pelayan',
    'report_auto__recipient_client' => 'pelanggan',
    'report_auto__recipient_domain' => 'entadbir domain',
    'report_auto_edit__select' => 'Lapor pada',
    'report_auto__select_client_report_all' => 'semua pelanggan',
    'report_auto__select_client_report_current' => 'pelanggan ini',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'semua domain',
    'report_auto__select_domain_report_other_client' => 'semua domain dari %1',
    'report_auto__select_domain_report_client' => 'semua domain dari pelanggan ini',
    'report_auto__select_domain_report_reseller' => 'semua domain dari penjual semula ini',
    'report_auto__select_domain_report_current' => 'domain ini',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Jadual penghantaran',
    'report_auto__select_for_remove' => "Pilih jadual penghantaran untuk dialih keluar.",
    'report_auto_remove__title' => "Jadual penghantaran laporan berikut akan dialih keluar:",
    'report_auto_edit__title' => 'Jadual Ciri Penghantaran',
    'report_auto_edit__recipient' => 'Hantar pada',
    'report_auto_edit__target' => 'Lapor pada',
    'report_auto_edit__auto' => 'Frekuensi penghantaran',
    'resp_edit__always_respond' => "selalu respons",
    'resp_edit__reply_subject' => "Balas subjek",
    'resp_edit__answer_subject' => "Jawab dengan subjek",
    'resp_edit__answer_txt' => "Balas dengan teks",
    'resp_edit__attach' => "Lampir fail",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "untuk",
    'resp_edit__frw_rqst_email' => "Apabila respons automatik, menghantar mesej asal kepada e-mel yang dinyatakan",
    'resp_edit__fwd_email_invalid' => "Alamat emel destinasi tidak sah.",
    'resp_edit__in_body' => "apabila perkataan dinyatakan telah jumpa dalam kandungan mesej",
    'resp_edit__in_subject' => "apabila perkataan dinyatakan telah jumpa dalam subjek mesej",
    'resp_edit__invalid_resp_freq' => "Frekuensi respons tidak sah.",
    'resp_edit__invalid_rqst_txt' => "Teks permintaan tidak sah.",
    'resp_edit__invalid_store_lim_num' => "Nilai had adalah tidak sah.",
    'resp_edit__limits_title' => "Had",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Bilangan respons maksimum per hari melebihi kadar yang ditakrifkan. Dibenarkan: %1, diminta: %2",
    'resp_edit__no_files_sel' => "Tiada fail dipilih.",
    'resp_edit__no_txt_supplied' => "Tiada teks dibekalkan.",
    'resp_edit__reply_title' => "Balas",
    'resp_edit__reply_to_address' => "Alamat kembali",
    'resp_edit__reply_to_invalid' => "Alamat kembali adalah tidak sah.",
    'resp_edit__reply_uniq_email' => "Balas kepada alamat e-mel yang unik tidak lebih daripada",
    'resp_edit__conditions_title' => "Keadaan",
    'resp_edit__request_title' => "Permintaan",
    'resp_edit__resp' => "Autobalas",
    'resp_edit__resp_name' => "Nama autobalas",
    'resp_edit__resp_not_exist' => "Autobalas tidak wujud.",
    'resp_edit__resp_status' => "Status autobalas",
    'resp_edit__rqst_txt' => 'Nyatakan syarat untuk jawapan automatik ini',
    'resp_edit__select_files_on_server_for_attach' => "Pilih fail yang anda ingin lampir",
    'resp_edit__store_up_to' => "Menyimpan sehingga",
    'resp_edit__subj_line_invalid' => "Baris subjek adalah tidak betul.",
    'resp_edit__text_too_big' => "Teks mesej balasan terlalu besar.",
    'resp_edit__times_in_a_day' => "kali sehari.",
    'resp_edit__unable_define_resp_cond' => "Tidak dapat mentakrifkan keadaan autobalas: %1",
    'resp_edit__unable_define_resp_status' => "Tidak dapat mentakrifkan status autobalas: %1",
    'resp_edit__unable_turn_on_resp' => "Tidak dapat menghidupkan autobalas: %1",
    'resp_edit__uniq_email' => "alamat e-mel unik",
    'resp_edit__content_type' => 'Format menghantar mel',
    'resp_edit__content_type_text' => 'Teks biasa',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Pengekodan',
    'restart__dns' => 'Pelayan DNS (%1)',
    'restart__drweb' => 'Antivirus Premium Plesk',
    'restart__mail' => "Pelayan IMAP/POP3 (%1)",
    'restart__mssql' => "Pelayan Microsoft SQL",
    'restart__mysql' => "Pelayan MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Perkhidmatan",
    'restart__smtp' => "Pelayan SMTP (%1)",
    'restart__spamd' => "Penapis Spam",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Pelayan web (%1)",
    'restart__ftp' => "Pelayan FTP (%1)",
    'restart__service_start' => 'Sila benarkan sedikit masa untuk perkhidmatan untuk mula.',
    'restart__service_stop' => 'Sila benarkan sedikit masa untuk perkhidmatan untuk berhenti.',
    'restart__service_restart' => 'Sila benarkan sedikit masa untuk perkhidmatan untuk memulakan semula.',
    'rm_domains__some_domains_are_not_exist' => "Sebahagian dari domain yang dinyatakan tidak wujud. Mungkin, mereka telah dialih keluar oleh pengguna lain.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "MBox",
    'rpt_cl_dom_redirects' => "Pemaju",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Laporan untuk pentadbir %1",
    'rpt_cl_report_for_reseller__' => "Laporan untuk penjual semula %1",
    'rpt_cl_report_for_cl__' => "Laporan tentang pelanggan %1",
    'rpt_cl_section_domains' => "Domain",
    'rpt_cl_section_full_domains' => "Domain",
    'rpt_cl_section_general' => "Umum",
    'rpt_create' => "Cipta laporan",
    'rpt_empty' => "Laporan itu hendaklah mengandungi sekurang-kurangnya satu bahagian",
    'rpt_dom_report_for_dom__' => "Laporan domain untuk %1",
    'rpt_dom_section_databases' => "Pangkalan Data",
    'rpt_dom_section_full_databases' => "Pangkalan Data",
    'rpt_dom_section_full_maillists' => "Senarai Mel",
    'rpt_dom_section_full_mailnames' => "Akaun mel",
    'rpt_dom_section_full_webusers' => "Pengguna web",
    'rpt_dom_section_full_siteapps' => 'Aplikasi Web',
    'rpt_dom_section_full_aspnetapps' => 'Aplikasi web ASP.NET',
    'rpt_dom_section_general' => "Umum",
    'rpt_dom_section_hosting' => "Pengehosan",
    'rpt_dom_section_maillists' => "Senarai Mel",
    'rpt_dom_section_mailnames' => "Akaun mel",
    'rpt_dom_section_siteapps' => 'Aplikasi Web',
    'rpt_dom_section_aspnetapps' => 'Aplikasi web ASP.NET',
    'rpt_dom_section_webusers' => "Pengguna web",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Edit laporan %1",
    'rpt_enter_email_address' => "Masukkan alamat e-mel laporan itu akan dihantar kepada.",
    'rpt_list' => "Laporan tataletak tersuai",
    'rpt_section_full' => "Penuh",
    'rpt_section_none' => "Tiada",
    'rpt_section_summary' => "Ringkasan",
    'rpt_default_full' => 'Laporan penuh',
    'rpt_default_summary' => 'Laporan Ringkasan',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Ralat menghantar laporan: %1",
    'rpt_send_report_by_email_ok__' => "Laporan telah dihantar untuk %1",
    'sa_action' => "Tindakan",
    'sa_action_del' => "Padam",
    'sa_action_desc' => "Apa yang perlu dilakukan dengan mel spam",
    'sa_action_save' => "Tanda sebagai spam dan simpan di peti mel",
    'sa_admin_blacklist' => "Senarai hitam Pentadbir",
    'sa_admin_whitelist' => "Senarai putih Pentadbir",
    'sa_db_del_confirm' => "Adakah anda pasti anda mahu kosongkan pangkalan data penapis Spam?",
    'sa_eml_in_ignorelist' => "E-mel dalam senarai abai",
    'sa_empty_email' => "Tidak boleh menambah corak e-mel yang kosong.",
    'sa_exists_email' => "Apa-apa corak e-mel telah wujud.",
    'sa_disabled__mailname_not_filtering' => "Tetapan pelayan semasa tidak membenarkan untuk guna mel penapisan untuk akaun mel ini",
    'sa_disabled__filtering_is_disabled' => 'Penapis spam telah dimatikan oleh pentadbir pelayan',
    'sa_disabled__hasnt_mailbox' => "Mustahil untuk menghidupkan penapisan spam tanpa peti mel",
    'sa_enable_filter' => "Hidupkan penapisan spam",
    'sa_forget' => "lupa",
    'sa_from' => "Dari",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Corak tidak sah.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Latihan penapis spam',
    'sa_trainer__tools_legend' => 'Alat',
    'sa_trainer__info_legend' => 'Maklumat',
    'sa_trainer__messages_list_legend' => 'Mesej dalam peti mel anda',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Subjek',
    'sa_trainer__from' => 'Dari',
    'sa_trainer__date' => 'Tarikh',
    'sa_trainer__info_text' => 'Mesej dipelajari: %1 sebagai spam, %2 sebagai bukan spam, %3 jumlah.',
    'sa_trainer__messages' => 'mesej',
    'sa_trainer__select__all' => 'Semua',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Bukan spam',
    'sa_trainer__select__unknown_only' => 'Tidak Diketahui',
    'sa_trainer__cannot_remove_messages' => 'Tidak dapat alih keluar mesej yang dipilih dari peti mel.',
    'sa_trainer__remove_messages_confirm' => 'Adakah anda pasti bahawa anda ingin untuk alih keluar mesej yang dipilih dari peti mel?',
    'sa_subj' => "Subjek",
    'sa_training' => "Latihan penapis spam",
    'sa_training_legend' => "Latihan penapis Bayesian",
    'sa_use_srv_settings' => "Guna tetapan lebar pelayan",
    'sa_user_blacklist' => "Senarai hitam pengguna",
    'sa_user_whitelist' => "Senarai putih pengguna",
    'sa_usr_disabled_by_srv' => "Tetapan penapisan spam individu tidak dibenarkan oleh pentadbir pelayan",
    'sa_usr_no_postbox' => "Tidak dapat mendayakan penapisan spam kerana peti mel dimatikan untuk akaun e-mel ini.",
    'sa_filters' => 'Penapis spam',
    'spamfilter__tools_legend' => 'Alat',
    'spamfilter__prefs_legend' => 'Tetapan',
    'spamfilter__max_children' => 'Bilangan maksimum proses spamd pekerja untuk jalankan',
    'spamfilter__rewrite_header_subject_hint' => 'Tinggalkan medan ini kosong jika anda tidak mahu menambah apa-apa teks. Taipkan _SCORE_ jika anda ingin memasukkan skor dalam subjek mesej.',
    'spamfilter__reject_spam' => 'Padam mel spam apabila ia datang ke peti mel',
    'spamfilter__enabled' => 'Dihidupkan',
    'spamfilter_addresses_list__tools_legend' => 'Alat',
    'spamfilter_addresses_list__list_legend' => 'Alamat',
    'spamfilter_addresses_list__items' => 'alamat',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => 'Alamat',
    'spamfilter_addresses__file_legend' => 'Dari fail',
    'spamfilter_addresses__file_label' => 'Nama fail',
    'spamfilter_addresses__file_hint' => 'Muat naik fail dalam pengekodan UTF-8.',
    'spamfilter_addresses__text_legend' => 'Dari senarai',
    'spamfilter_addresses__text_label' => 'Alamat e-mel',
    'spamfilter_addresses__remove_title' => 'Alamat berikut akan dialih keluar dari senarai:',
    'spamfilter_addresses__empty_selection' => 'Tiada alamat dipilih.',
    'server__admin_info' => "Maklumat pentadbir",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Masukkan perihalan pepijat di bawah",
    'server__power_management' => "Pengurusan kuasa",
    'server__services' => "Perkhidmatan",
    'server__system' => "Sistem",
    'server__title' => "Pentadbir Pelayan",
    'server_preferences__admin_skin' => "Pentadbir antara muka kulit",
    'server_preferences__default_language' => "Bahasa lalai",
    'server_preferences__default_skin' => "Kulit lalai",
    'server_preferences__restart_apache_interval' => "Apache selang mula semula",
    'server_preferences__system' => 'Tetapan sistem',
    'mail__tabs_preferences' => "Tetapan",
    'mail__tabs_white_list' => "Senarai Putih",
    'server_preferences__use_vocabulary' => "Semak kata laluan untuk peti mel di dalam kamus",
    'sessions__agreement' => "Ya, saya ingin tamatkan sesi ini.",
    'sessions__select_sessions_for_remove' => "Pilih sesi untuk ditamatkan.",
    'sessions__tabs_cp_sessions' => 'Sesi Plesk',
    'sessions__tabs_ftp_sessions' => 'Sesi FTP',
    'sessions__ftp_sessions_login' => 'Nama pengguna akaun FTP',
    'sessions__ftp_sessions_domain' => 'Nama domain',
    'sessions__ftp_sessions_path' => 'Lokasi semasa',
    'sessions__ftp_sessions_file' => 'Nama fail',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Kelajuan, KB/S',
    'sessions__ftp_sessions_comp' => 'Kemajuan, %',

    'site_apps__access_level' => 'Tahap akses',
    'site_apps__access_level_commercial' => 'Komersil',
    'site_apps__access_level_free' => 'Percuma',
    'site_apps__action_installer' => "Pemasangan aplikasi web",
    'site_apps__action_reconfigure' => "Konfigurasi semula aplikasi web",
    'site_apps__custom_button_level' => 'Anda ingin mencipta butang tersuai untuk mengakses aplikasi ini?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Tidak',
    'site_apps__custom_button_level_domain_user_only' => 'Ya',
    'site_apps__custom_button_level_false' => 'Tidak',
    'site_apps__custom_button_level_domain' => 'Ya, dan jadikannya tersedia untuk domain semasa sahaja',
    'site_apps__custom_button_level_client' => 'Ya, dan jadikannya tersedia untuk semua domain pelanggan',
    'site_apps__custom_button_level_admin' => 'Ya, dan jadikannya tersedia untuk semua domain',
    'site_apps__description' => "Perihalan",
    'site_apps__dir_used_by_sapp__' => "Direktori \"%1\" digunakan oleh aplikasi web yang lain",
    'site_apps__dir_used_by_unknown__' => "Direktori \"%1\" telah wujud. Kandungannya akan ditulis ganti jika anda teruskan.",
    'site_apps__dir_invalid_name__' => "Nama direktori %1 adalah salah",
    'site_apps__file_name' => 'Nama fail aplikasi web',
    'site_apps__invalid_install_prefix' => "Awalan pemasangan tidak sah",
    'site_apps__invalid_package' => "Aplikasi web tidak sah",
    'site_apps__key_status' => 'Pelesenan',
    'site_apps__key_status_free' => 'Diedarkan secara bebas. Tiada kunci lesen yang diperlukan',
    'site_apps__key_status_ok' => 'Kunci lesen yang diperlukan dipasang',
    'site_apps__key_status_problem' => 'Kunci lesen yang diperlukan tidak dipasang',
    'site_apps__name' => "Nama",
    'site_apps__no_domains' => 'Aplikasi web tidak boleh dipasang. Terdapat satu lagi aplikasi web yang dipasang di dalam direktori akar domain ini. Pertimbang untuk mencipta subdomain untuk aplikasi web.',
    'site_apps__package_info_' => "Maklumat Aplikasi Web",
    'site_apps__package_integrated' => "terbina dalam aplikasi, tidak dapat dialih keluar:",
    'site_apps__pool_select_packages_to_add' => 'Pilih aplikasi web untuk menambah kepada himpunan',
    'site_apps__release' => "Keluaran",
    'site_apps__resource_used_by_sapp' => "Sumber ini digunakan oleh aplikasi web yang telah dipasang",
    'site_apps__root_used_by_sapp' => "Sumber ini digunakan dengan pemasangan aplikasi web",
    'site_apps__these_domains_will_not_delete' => '(sub) domain ini tidak akan dipadam',
    'site_apps__upload_site_app_pkg_title' => 'Muat naik aplikasi web baru',
    'site_apps__version' => "Versi",
    'site_apps__access_to' => "Akses kepada %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Templat hos maya",
    'skeleton__client_label' => "%1 Templat hos maya",
    'skeleton__admin_page' => "Urus Templat Host Maya",
    'skeleton__files_list' => "Fail dan direktori",
    'skeleton__archiver_not_installed' => "Tidak dapat membuka bungkusan arkib. Arkib mungkin tidak dipasang pada pelayan. Hubungi pentadbir {$PROD_NAME} untuk mempunyai perisian archiver dipasang.",
    'skeleton__client_page' => "Urus Templat Host Maya",
    'skeleton__archive_corrupted' => "Semakan arkib mendapati bahawa fail arkib adalah sama ada rosak atau jenis arkib ini tidak disokong.",
    'skeleton__archive_too_large' => "Semakan arkib mendapati bahawa fail arkib terlalu besar.",
    'skeleton__not_supported_archive_type' => "Jenis arkib (fail %1) ini tidak disokong.",
    'skeleton__upload_archive_file' => "Muat naik fail arkib",
    'skin_download__title' => 'Muat Turun Kulit',
    'skin_download_now__title' => 'Muat turun kulit dalam kemajuan',
    'skin_download_now__text' => 'Ciptaan pakej kulit sedang dalam kamajuan.<br>Prosedur ini mungkin mengambil sedikit masa.<br> Apabila tetingkap dialog muncul, anda boleh menerus bekerja dengan Plesk.',
    'skin_file__help_for_using_types' => "Sila, gunakan arkib kulit di salah satu daripada format berikut:",
    'skin_info__title' => 'Sifat Kulit',
    'skin_mng_err__rpm_not_skin' => 'RPM Ini bukan satu pakej kulit Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Gagal untuk memasang kulit berasaskan rpm di lokasi yang dinyatakan.',
    'skin_mng_err__already_exists' => 'Direktori pemasangan kulit telah wujud dan terdapat pakej kulit dikerahkan.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Fail yang dimuat naik bukan pakej kulit RPM yang sah.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Fail yang dimuat naik bukan pakej kulit yang sah.',
    'skin_mng_err__rpm_upgrade_base' => "Fail yang dimuat naik bukan pakej kulit {$PROD_NAME} yang sah.",
    'skin_mng_err__rpm_upgrade_other' => 'Tidak dapat memasang kulit: format kulit tidak sah.',
    'skin_mng_err__no_a_skin' => "Fail yang dimuat naik bukan pakej kulit {$PROD_NAME} yang sah.",
    'skin_upload__title' => 'Muat Naik Kulit Baru',
    'skin_upload__already_exists' => "Kulit '%1' telah wujud.",
    'skin_upload__unable_to_apply' => "Fail yang dimuat naik tidak mengandungi kulit Plesk atau format arkib tidak disokong.",
    'skin_upload__unable_to_rename__' => "Tidak dapat menamakan semula kulit %2 kepada %1: %3.",
    'skin_upload__file_name' => 'Laluan ke fail pakej kulit',
    'skins_list__title' => 'Repositori Kulit',
    'skins_remove__title' => 'Pembuangan Kulit',
    'skins_remove__select_skins_for_remove' => 'Pilih kulit untuk dialih keluar.',

    'spf__unable_update' => 'Tidak dapat mengemas kini parameter SPF',
    'statistics__active_domains' => "Domain aktif",
    'statistics__clients' => "Pelanggan",
    'statistics__subdomains' => "Subdomain",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Pangkalan Data",
    'statistics__db_users' => "Pangkalan data pengguna",
    'statistics__dirs' => "Direktori dilindungi",
    'statistics__dom_active' => "Aktif",
    'statistics__dom_passive' => "Pasif",
    'statistics__dom_problem' => "Masalah",
    'statistics__domains' => "Domain",
    'statistics__domains_with_host' => "Domain dengan pengehosan",
    'statistics__doms' => "Domain",
    'statistics__filesystem' => "Sistem fail",
    'statistics__general' => "Umum",
    'statistics__hdd_available' => "Tersedia",
    'statistics__hdd_capacity' => "Kapasiti",
    'statistics__hdd_total' => "Jumlah",
    'statistics__hdd_usage' => "Penggunaan Cakera Keras",
    'statistics__hdd_used' => "Digunakan",
    'statistics__ip' => "Alamat IP",
    'statistics__key_number' => "Nombor kunci.",
    'statistics__l1' => "1 minit akhir",
    'statistics__l15' => "15 minit akhir",
    'statistics__l5' => "5 minit akhir",
    'statistics__la' => "Penggunaan CPU",
    'statistics__mail_autoresponders' => "Auto-balas",
    'statistics__mail_boxes' => "Peti mel",
    'statistics__mail_groups' => "Kumpulan mel",
    'statistics__mail_lists' => "Senarai Mel",
    'statistics__mail_redirects' => "Pemaju mel",
    'statistics__mem' => "Penggunaan Memori",
    'statistics__mem_usage' => "Penggunaan",
    'statistics__memory_available' => "Tersedia",
    'statistics__memory_buffer' => "Penimbal",
    'statistics__memory_cached' => "Dicache",
    'statistics__memory_free' => "Percuma",
    'statistics__memory_shared' => "Dikongsi",
    'statistics__memory_total' => "Jumlah",
    'statistics__memory_used' => "Digunakan",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Pelanggan masalah",
    'statistics__problem_domains' => "Domain masalah",
    'statistics__swap' => "Penggunaan pertukaran",
    'statistics__swap_free' => "Percuma",
    'statistics__swap_total' => "Jumlah",
    'statistics__swap_usage' => "Penggunaan",
    'statistics__swap_used' => "Digunakan",
    'statistics__system_stat' => "Pelayan Maklumat",
    'statistics__unable_define_active_doms' => "Tidak dapat menentukan bilangan domain aktif: %1",
    'statistics__unable_define_inactive_doms' => "Tidak dapat menentukan bilangan domain nyahaktif: %1",
    'statistics__failed_define_swap_usage' => 'Gagal menentukan Penggunaan Swap',
    'statistics__failed_define_load_averages' => 'Gagal menentukan Purata Muatan',
    'statistics__up_time' => "Uptime sistem:",
    'statistics__ver' => "Versi",
    'statistics__web_users' => "Pengguna web",
    'statistics__mem_win' => "Penggunaan Memori fizikal",
    'statistics__memory_total_win' => "Jumlah",
    'statistics__memory_used_win' => "Digunakan",
    'statistics__memory_free_win' => "Tersedia",
    'statistics__swap_win' => "Penggunaan Memori maya",
    'statistics__swap_total_win' => "Jumlah",
    'statistics__swap_used_win' => "Digunakan",
    'statistics__swap_free_win' => "Tersedia",
    'status__domain_has_reasons_to_be_off' => "Domain ini masih digantung atas sebab yang berikut: %1",
    'subdomain__create__' => "Cipta subdomain di dalam domain %1",
    'subdomain__edit__' => "Urus subdomain %1",
    'subdomain__invalid_name' => "Nama subdomain tidak sah: hanya gunakan abjad angka dan simbol sengkang.",
    'subdomain__incorrect_name' => "Nama subdomain tidak sah.",
    'subdomains__maillists_enabled_in_domain' => "Senarai nama subdomain tidak betul.%1: nama domain ini telah digunakan oleh senarai mel di bawah domain %1.",
    'subdomains__dalias_exists' => 'Alias domain dengan nama seperti itu sudah wujud.',
    'subdomains__name_exists' => "Subdomain dengan nama tersebut telah wujud.",
    'subdomains__regular_domain_exists' => "Domain dengan nama tersebut telah wujud.",
    'subdomains__domain_alias_exists' => 'Alias domain dengan nama seperti itu sudah wujud.',
    'subdomains__remove_subdomains_on_domain' => "Subdomain berikut untuk domain %1 akan dialih keluar:",
    'subdomains__select_subdomains_for_remove' => "Pilih subdomain untuk dialih keluar.",
    'subdomains__webmail_enabled_in_domain' => "Nama subdomain mel web yang tidak betul.%1: nama domain ini digunakan untuk mengakses ke mel web di bawah domain %1.",
    'subdomains__dns_record_already_exists' => 'Tidak dapat mencipta subdomain %1 kerana sudah ada rekod DNS menunjuk ke hos %1.',
    'subdomains__www_prefix_in_domain' => "Nama subdomain www salah.%1: domain %1 telah mempunyai awalan WWW.",
    'subdomains__user_type_quota_exceeds' => 'Tidak dapat untuk mengubah akaun pengguna kerana ini akan mengakibatkan melebihi ruang cakera yang diuntukkan.',
    'subdomains__creation_in_dns_slave' => "Pelayan nama Plesk bertindak sebagai pelayan nama sekunder untuk domain ini. Untuk subdomain anda untuk menyelesaikan dengan betul, Pastikan fail zon pada pelayan DNS utama mengandungi rekod %1.",
    'sys_user__attributes_not_changed' => "\nSistem berikut sifat pengguna tidak berubah: %1",
    'sys_user__no_access_without_password' => "Anda tidak menetapkan kata laluan. Pengguna sistem akan diwujudkan, tetapi tidak akan dapat log masuk ke sistem, sehingga dia diberikan kata laluan. Adakah anda ingin teruskan?",
    'sys_user__no_hard_quota' => "tidak disokong",
    'sysuser__zero_quota_is_unlimited' => "0 untuk tidak terhad",
    'template__num_excl_ips' => "Memperuntukkan alamat IP khusus untuk pelanggan",
    'template__sel_sh_ips' => "Alamat IP kongsi dipilih",
    'template__av_sh_ips' => "Alamat IP kongsi tersedia",
    'template__up_to_excl_ip' => "Sehingga%1 alamat IP",
    'templates__all_clients' => "semua pelanggan",
    'templates__cl_domain_templates' => "Templat untuk %1",
    'templates__cl_templates' => "Templat pelanggan",
    'time__invalid_ip' => "Alamat IP tidak sah atau nama domain.",
    '__please_select_country' => 'Sila, pilih negara anda',
    'time__unable_set_time' => "Tidak dapat tetapkan sistem masa: %1",
    'time__sinchronization_setup_error' => 'Tidak dapat menyediakan penyegerakan masa: timemng gagal: %1',
    'time__sinchronization_disable_error' => 'Tidak dapat melumpuhkan penyegerakan masa: timemng gagal: %1',
    'tmpl__create' => "Cipta templat",
    'tmpl__edit__' => 'Templat %1',
    'tmpl__logrotation_warn' => "Log putaran pada domain yang dicipta oleh templat ini akan dilakukan hanya dalam kes berikutnya cipta akaun pengehosan fizikal untuk itu.",
    'tmpl__name' => "Nama templat",
    'tmpl__dom_exist' => "Templat domain dengan nama tersebut sudah wujud dalam himpunan templat pentadbir atau pelanggan.",
    'tmpl__name_invalid' => "Nama Templat tidak sah atau kosong.",
    'tmpl__use_next_ip_addr' => "Seterusnya alamat IP kosong akan digunakan",
    'tmpl_name_already_exists' => "Templat dengan nama '%1' sudah wujud.",
    'traffic__no_periods_found' => "Tidak dapat paparkan web dan statistik trafik. Fungsi ini boleh didapati hanya selepas pengiraan statistik seterusnya.",

    'vh_based__no_free_ip_for_vh' => "Tiada alamat IP kosong untuk pengehosan maya berasaskan IP. Sila tambah alamat IP.",

    'wu__at_domains_text' => "Benarkan webuser@%1 format akses",
    'wu__unable_create' => "Tidak dapat cipta pengguna web. %1",
    'wu_edit__disk_quota' => "Kuota cakera",
    'wu_edit__invalid_pass' => "Kata laluan tidak sah.",
    'wu_edit__invalid_quota' => "Nilai kuota ruang cakera yang dinyatakan adalah tidak sah. Sila, masukkan integer positif.",
    'wu_edit__invalid_quota_value' => "Kuota ruang cakera Yang ditentukan adalah kurang daripada yang digunakan sekarang (%1MB). Beberapa fungsi mungkin akan menjadi tidak tersedia. Adakah anda pasti anda mahu untuk meneruskan?",
    'wu_edit__not_create_pass' => "Tindakan ini tidak akan mencipta kata laluan bagi pengguna baru.\nTanpa kata laluan pengguna tidak akan dapat untuk log masuk.",
    'wu_edit__unable_update' => "Tidak dapat kemas kini harta pengguna web: %1",

    'bt_webdirs' => 'Direktori Maya',

    'dns__tabs_general' => 'Tetapan Zon',
    'dns__tabs_zone_settings' => 'Rekod SOA',
    'soa__seconds' => 'saat',
    'soa__minutes' => 'minit',
    'soa__hours' => 'jam',
    'soa__days' => 'hari',

    'DomainSubdirectory' => 'Subdirektori destinasi',

    'filemanager__select_codepage' => 'Pilih Halaman kod:',

    'bt_server_app_add' => 'Tambah Aplikasi Pelayan',
    'packages_list' => 'Aplikasi Pelayan',

    'bt_packages_management' => 'Pengurusan Pakej',
    'pb__packages_management' => 'Pengurusan Aplikasi',
    'bt_package_new' => 'Tambah Aplikasi',
    '__packages' => 'Aplikasi Pelayan',

    'dom_ctrl__mysql_dbase_space' => 'Jumlah kuota pangkalan data MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Jumlah kuota pangkalan data MS SQL',

    'dns_add__enter_ixfr_path' => 'Masukkan IXFR jalan',

    'cmd_dns__txt_dns_record_already_exist' => 'Rekod SPF TXT sudah wujud. Hanya satu sahaja rekod SPF. Untuk menambah rekod, padamkan satu sebelumnya.',

    'component_name__network' => 'Rangkaian',
    'component_name__sitebuilder' => 'Pembina Keutamaan',

    'bt_skin_set' => 'Set Kulit',
    'bt_set_skin' => 'Set Kulit',
    'firewall__rule_already_exists' => 'Peraturan dengan nama "%1" sudah wujud',
    'firewall__rule_readonly' => 'Peraturan "%1" adalah baca sahaja',
    'pb__firewall' => 'Tembok api',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Lokasi fail tidak sah.',

    'error_doc__erorr_invalid_url_location' =>  'Format URL salah. Sila masukkan URL yang mutlak dalam hos maya (tapak).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Perlindungan antivirus',
    'antivirus__antivirus_direction_off' => 'Dimatikan',
    'antivirus__antivirus_direction_any' => 'Mel masuk dan keluar',
    'antivirus__antivirus_direction_from' => 'Mel keluar sahaja',
    'antivirus__antivirus_direction_to' => 'Mel masuk sahaja',
    'antivirus__unable_to_update_settings' => 'Tidak dapat mengubah tetapan antivirus: %1',




    '__normal' => 'Normal',
    '__low' => 'Rendah',
    '__high' => 'Tinggi',

    'mail__antivirus' => "Antivirus pelayan mel dalaman",
    'mail__use_internal_antivirus' => 'Guna antivirus dalaman',

    'sa__tabs_blacklist' => 'Senarai Hitam',

    '__mysql_databases' => 'Pangkalan data MySQL',

    'cl_perm__mysql_dbase_space' => 'Jumlah kuota pangkalan data MySQL',
    'cl_perm__mssql_dbase_space' => 'Jumlah kuota pangkalan data MS SQL',
    'cl_perm__max_mssql_db' => 'Bilangan maksimum pangkalan data Pelayan Microsoft SQL',
    'cl_perm__total_mboxes_quota' => 'Jumlah kuota peti mel',

    'i_i_cl_on' => 'Akaun pelanggan adalah aktif.',
    'i_i_cl_off_by_admin' => 'Akaun pelanggan digantung oleh pentadbir.',

    'sa_exists_tn' => 'Rangkaian ini sudah ada dalam senarai itu.',

    'webdir__select_vdirs_to_remove' => 'Pilih direktori yang anda ingin untuk padam',
    'webdir__select_mime_types_to_remove' => 'Pilih jenis MIME yang anda ingin untuk padam',

    'defaultcomponents__not_activated' => 'tidak diaktifkan',

    'bt_traffic_at_domains' => 'Trafik',

    '__awstats_perl_warning' => 'Tanpa pemasangan Perl, AWStats tidak akan membenarkan pengguna untuk menyemak statistik untuk tahun sebelumnya.',

    'class_client__mysql_dbase_space' => 'Nilai melebihi had pelanggan.',
    'class_client__mssql_dbase_space' => 'Nilai melebihi had pelanggan.',
    'class_client__max_mssql_db' => 'Nilai melebihi had pelanggan.',

    'dns__remove_transfer_restrictions_list_items' => 'Rangkaian berikut akan dialih keluar dari senarai kawalan akses:',

    'bt_up' => "Atas",
    'bt_down' => "Bawah",
    'virtualdir__type_default_doc_name_to_add' => 'Masukkan nama fail untuk ditambahkan pada senarai',
    'virtualdir__select_default_doc_to_remove' => 'Pilih fail untuk dialih keluar daripada senarai',
    'virtualdir__select_directory' => 'Pilih direktori',

    'bt_install_selected' => 'Pasang Kunci Lesen yang Dipilih', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Domain ini menyelesaikan kepada yang lain untuk alamat IP lain: (%1). Sila betulkan tetapan DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Pelayan mel kini sedang diguna tidak sokong kedua-dua peti mel dan mel kumpulan suis dibuka serentak. Tekan OK untuk membuka pada peti mel dengan mengorbankan menutup kumpulan mel. Tekan batal untuk tinggal segala-galanya dalam keadaan baik.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Pelayan mel kini sedang diguna tidak sokong kedua-dua peti mel dan mel kumpulan suis dibuka serentak. Tekan OK untuk membuka pada mel kumpulan dengan mengorbankan peti mel. Tekan batal untuk tinggal segala-galanya dalam keadaan baik.',

    'mysql_dbase_space_limit' => 'Had ruang pangkalan data MySQL',
    'mysql_dbase_usage' => 'Penggunaan ruang pangkalan data MySQL',
    'mssql_dbase_space_limit' => 'Microsoft SQL pelayan pangkalan data ruang had',
    'mssql_dbase_usage' => 'Microsoft SQL pelayan pangkalan data ruang diguna',

    '__statistics' => "statistik", //indirect

    'dns__soa_minimum_value_is_big' => 'Menetapkan nilai Minimum TTL yang lebih daripada 3 jam boleh membuat domain anda tidak boleh diakses untuk beberapa pentadbir domain. Ia adalah disarankan untuk menetapkan apa-apa nilai hanya jika pendaftar nama domain anda menegaskan padanya.',

    'virusfilter__interface_not_available' => 'Tiada tapis virus adalah tersedia.',
    'virusfilter__none_virus_filter' => 'Tiada',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'Dimatikan',
    'virusfilter__status_any' => 'mel masuk dan keluar',
    'virusfilter__status_outgoing' => 'hanya mel keluar',
    'virusfilter__status_incoming' => 'hanya mel masuk',

    'visibility__root_override_parse_error' => 'Ralat sintaks dalam fail %1 in line %2.',

    'sb__not_support_publishing_api' => "Automasi Penerbitan tidak disokong dengan komponen",

    'component_name__cphosting' => "Pengehosan Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Menetapkan kuota peti mel tidak disokong oleh pelayan mel semasa.',
    '__unable_get_total_mboxes_quota' => 'Menetapkan kuota peti mel tidak disokong oleh pelayan mel semasa.',

    'install_prefix__parent_not_exists' => "Direktori induk tidak wujud.",

    'bt_change_version' => 'Ubah Versi',
    'aspdotnet__changeversion_title' => 'Memilih Versi ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Pilih Semua",
    '__uncheck_all' => "Kosongkan Semua",

    'dns__editing_domain_controller_zone' => "Mengedit rekod DNS untuk zon pengawal domain boleh menyebabkan masalah dalam fungsi domain",

    'pb__interface_management' => "Pengurusan Antara Muka",
    'interface_management__tabs_skins' => "Kulit",
    'interface_management__tabs_interface_templates' => "Templat Antara muka",
    'interface_management__tabs_locales' => "Tempatan",
    'locales_list__title' => "Pek bahasa repositori",
    'locales_list__legend' => "Bahasa yang tersedia",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Pek bahasa",
    'locales_list__lang_title' => "Bahasa",
    'locales_list__country_title' => "Negara",
    'locales_list__used_title' => "Digunakan",

    'backup__suspend_warning_during_backup' => "Domain tidak boleh digunakan semasa proses sandaran",
    'backup__suspend_warning_during_restore' => "Domain tidak boleh digunakan semasa proses pemulihan",
    'backup__suspend_domain' => "Gantung domain",

    'locales_list__mls_limit' => "Lesen Plesk semasa anda membenarkan menggunakan %2 bahasa. Pada masa ini, anda mempunyai %1 set bahasa yang tersedia untuk pengguna, di mana melanjutkan nombor yang disediakan dengan lesen. Sila pilih %2 bahasa yang anda mahu guna, dan buat selebihnya tidak tersedia untuk pengguna dengan klik ikonnya dalam lajur 'S'.",

    'bt_change_owner' => 'Tetapkan Pemilik yang Baharu',
    'chown__new_owner' => 'Pemilik baru',
    'chown__selected_domains' => 'Langganan yang dipilih',
    'chown__limits_legend' => 'Sumber',
    'chown__limit_name' => 'Nama sumber',
    'chown__limit_value' => 'Sumber yang diperuntukkan',
    'chown__limit_assigned_before' => 'Sebelum pindahan',
    'chown__limit_assigned_after' => 'Selepas pindahan',
    'chown__error_limits' => "Tidak boleh meneruskan pindahan langganan: langganan ini memerlukan sumber yang lebih banyak dari apa yang dibekalkan oleh pembekal pemilik baru.",
    'chown__error_no_domains' => 'Tidak boleh meneruskan pindahan langganan: sama ada tiada langganan yang dipilih atau langganan yang dipilih sudah dipunyai oleh pengguna sasaran.',
    'chown__error_empty_ip_pool' => "Tidak boleh meneruskan pindahan langganan: Himpunan IP pembekal pemilik baru adalah kosong Sila pastikan yang pembekal mempunyai sekurang-kurangnya satu alamat IP dalam himpunan.",
    'chown__please_select_new_domain_owner' => 'Pilih pemilik baru untuk langganan ini',
    'chown__old_ip_address' => 'Alamat IP semasa',
    'chown__new_ip_address' => 'Alamat IP baru',

    'chown__error_ssl_already_used' => "Sokongan SSL/TLS ini telah digunakan pada IP destinasi berikut: %1 Oleh itu, domain berikut dengan sokongan SSL/TLS tidak boleh dipindahkan: %2. Sila selesaikan masalah itu dan cuba lagi",
    'chown__sitebuilder_not_installed' => 'Presence Builder tidak dipasang',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domain %1 tidak boleh dipindahkan kepada pemilik lain kerana Presence Builder tidak dipasang.',

    'backup__backup_time' => 'Masa sandaran',
    'backup__backup_time_hour' => 'jam',
    'backup__backup_time_minute' => 'minit',
    'backup__every' => 'setiap',
    'backup__day_of_month' => 'hari dalam bulan',

    'subdomain__select_hst_type' => 'Pilih jenis pengehosan untuk subdomain',
    'hst_sel__subdom_subfolder_hst' => 'Subdomain pada subfolder',
    'subdomain__www_root_folder_not_exists' => 'Tapak direktori rumah %1 tidak wujud',
    '__site_home_dir' => 'Tapak direktori rumah',
    'subdomain__aspnet_disabled_domain' => 'dimatikan oleh domain',

    'domains__remove_description' => 'Semua data domain, termasuk kandungan dan tetapan domain dan subdomain, data aplikasi web, kandungan peti mel, mel, antivirus dan tetapan penapisan spam, fail log, sandaran data domain repositori dan sijil SSL/TLS akan dipadamkan. Jika anda tidak mempunyai fail sandaran pada mesin setempat anda, semua data akan hilang selama-lamanya.',
    'subdomains__remove_description' => 'Semua data subdomain, termasuk kandungan subdomain dan tetapan data aplikasi web dan log fail akan dipadam Jika anda tidak mempunyai fail sandaran pada mesin setempat anda, semua data akan hilang selama-lamanya.',

    'mail__tabs_spam_filtering' => 'Penapisan Spam',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Gunakan tetapan lebar pelayan lalai (Imbas)',
    'antivirus__use_server_settings_no_scan' => 'Gunakan tetapan lebar pelayan lalai (Jangan imbas)',
    'antivirus__check_for_viruses' => 'Imbas untuk virus',
    'antivirus__dont_check_for_viruses' => 'Jangan imbas virus',
    'antivirus__incoming_mail' => 'Mel masuk',
    'antivirus__outgoing_mail' => 'Mel keluar',

    'domain_alias__CNAME_dns_record_exists' => 'Rekod DNS CNAME dengan apa-apa nama yang sudah wujud',
    'domain_alias__A_dns_record_exists' => 'Rekod A DNS dengan apa-apa nama yang sudah wujud',
    'domain_alias__bad_prefix' => 'Prefiks yang salah untuk alias domain',
    'domain_alias__domain_doesnt_exist' => "Domain tidak wujud",

    'dns__zone_ttl_message_info' => 'Sekiranya nilai TTL tidak ditentukan, nilai TTL dalam Templat Rekod SOA (%1) akan digunakan untuk rekod DNS ini.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'Ubah',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Nama fail index.html akan dicipta untuk hala semula kepada aplikasi web yang dipilih. Jika nama fail index.html sudah wujud, ia akan disokong sebagai index.html.old dan digantikan dengan yang baru. Tekan OK untuk sahkan",

    'bt_ftp_ctrl' => "Akaun FTP Tambahan",
    'ftp_users_no_permission' => "Anda tidak mempunyai kebenaran bagi mengurus akaun FTP untuk domain ini",
    'ftp_users_limit_reached' => "Had akaun FTP dicapai untuk domain ini",
    'pb__ftp_ctrl' => "Pengurusan FTP",
    'class_client__max_subftp_users' => "Akaun FTP tambahan",

    '__client_form_settings' => "Tetapan pelanggan",
    '__sbnet_client_keep_sbnet' => "Simpan akaun pengguna sepadan di Presence Builder",
    '__sbnet_cant_add_more_sites' => "Had pada jumlah tapak yang boleh digunakan Presence Builder dicapai untuk pelanggan ini",
    '__sbnet_legend_text' => "Integrasi Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Cipta akaun pengguna yang sepadan dalam Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Anda sedang cuba untuk alih keluar akaun pengguna Presence Builder yang berkaitan dengan pelanggan ini. Ini akan memadam semua tapak web pengguna dan tetapan lain yang berkaitan dari sistem Presence Builder, mengalih keluar keupayaan untuk edit tapak web yang sedia ada melalui Presence Builder, walaupun anda menuukar pilihan ini lagi kemudian. Jika nanti anda membuat akaun pengguna Presence Builder lagi, anda perlu cipta dan terbit semua tapak web anda dari awal. Adakah anda ingin untuk mematikan ciptaan tapak web dan penerbitan melalui Presence Builder?",
    'sb__build_site_with_subdomains' => "Cipta Blog dan subdomain Galeri Gambar",
    '__sbnet_client_dont_have_sbuser' => "Tidak boleh mencipta dan menerbitkan tapak dengan menggunakan Presence Builder: Pengguna Presence Builder tidak wujud",

    '__component_disabled' => "Komponen dimatikan",

    'subdomains__physical_path_not_exist' => "Terdapat subdomain dikaitkan dengan folder fizikal tidak wujud",

    'dnsserver_bind_to_msdns_switching_warning' => "Amaran: hanya 254 alamat IP subnet yang pertama dengan /8 dan /16 topeng yang terdapat dalam Senarai Kawalan Akses akan dipindahkan. Ia akan dipindahkan sebagai alamat IP yang berasingan. Adakah anda mahu teruskan?",

    '__sbnet_net_framework_required_for_site' => "Tapak Presence Builder mungkin memerlukan sokongan ASP.NET 2.0 pada domain anda. Kami sarankan untuk mendayakan sokongan ASP.NET 2.0 jika anda menggunakan Presence Builder.",

    'subdomain_auto_create_dir' => "Cipta direktori fizikal untuk subdomain",

    'sa_trainer__unable_to_get_messages_list' => "Gagal mendapatkan senarai mesej dalam peti mel: %1",
    'sa_trainer__pass_doesnt_exist' => "Kata laluan untuk akaun mel ini hilang",

    '__sitebuilder_error' => "Ralat berlaku semasa cuba menyambung kepada Presence Builder. Hubungi pembekal perkhidmatan anda untuk mendapatkan bantuan.",
    'wsb_error_user_not_exist' => "Akaun pengguna Presence Builder tidak wujud.",
    'wsb_error_site_already_exist' => "Tapak ini telah wujud di Presence Builder.",
    'wsb_error_site_limit_reached' => "Had pada bilangan tapak Presence Builder telah dicapai.",
    'wsb_error_internal_error' => "Ralat Presence Builder dalaman telah berlaku. Hubungi pembekal perkhidmatan anda untuk mendapatkan bantuan.",
    'wsb_error_user_already_exist' => "Pengguna Presence Builder dengan nama tersebut telah wujud di Presence Builder.",
    'sb_error_user_not_exist' => "Pengguna Presence Builder tidak wujud.",
    'wsb_error_object_not_found' => "Presence Builder tidak dapat mencari kemasukan hos yang betul.",

    'mg_no_mail_groups' => "Tiada kumpulan mel",

    'drweb__drweb_incoming' => 'Antivirus cek surat masuk',
    'drweb__drweb_outgoing' => 'Antivirus cek mel keluar',
    'drweb__disable_reason_serv' => 'Pelayan mel tidak menyokong tetapan penapis antivirus pada tahap peti mel',

    'vz_sitebuilder3_client_cant_be_created' => "Tidak dapat mencipta akaun pelanggan: SiteBuilder version 3.1 atau lebih baru yang tidak dipasang.",

    'chown__client_without_sitebuilder_support' => "Tidak boleh meneruskan pindahan langganan: Perkhidmatan Presence Builder tidak termasuk dalam pemilik baru atau pelan pembekal perkhidmatannya.",

    // new limits

    'class_client__max_odbc' => "Sambungan ODBC",
    'cl_perm__max_odbc' => "bilangan maksimum sambungan ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Nama alias domain',
    'domain_alias__list_ascii_name' => 'Dalam format ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Pengurusan Antara Muka',
    'pb__interface_templates' => 'Pengurusan antara muka',
    'pb__interface_clients' => 'Pelanggan mengguna %1',

    // service management
    'bt_service_showall' => "Tunjukkan Semua",
    'bt_service_hideall' => "Sembunyikan Semua",
    'bt_service_start' => "Mula",
    'bt_service_stop' => "Berhenti",
    'bt_service_restart' => "Mula Semula",
    'bt_service_disable' => "Matikan",
    'bt_service_manual' => "Manual",
    'bt_service_auto' => "Automatik",
    'comp_info__statup_type' => 'Jenis Persediaan',
    'service_startup_auto' => 'Automatik',
    'service_startup_manual' => 'Manual',
    'service_startup_disabled' => 'Dimatikan',
    'service_action_ok' => "Operasi dengan perkhidmatan %1 berjaya diselesaikan",
    'service_action_failed_disabled_service' => "Tidak dapat menyelesaikan operasi dengan perkhidmatan %1 kerana ia telah dimatikan",
    'service_action_failed_error' => "Tidak dapat melengkapkan operasi: %1",
    'service_group_action_ok' => "Operasi dengan perkhidmatan berikut telah diselesaikan dengan jayanya: \n %1",
    'service_group_action_disabled' => "Tidak dapat menyelesaikan operasi dengan perkhidmatan yang berikut kerana ia telah dimatikan: \n %1",
    'service_group_action_failed' => "Tidak dapat selesaikan operasi dengan perkhidmatan berikut: \n %1. \n Untuk menerima maklumat ralat terperinci, melakukan operasi itu dengan setiap perkhidmatan secara berasingan",

    // php 4vs5
    'bt_php' => "Tetapan PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Penjual semula tersedia',
    'massmail__resellers_list_selected' => 'Penjual semula yang dipilih',
    'massmail__clients_list_available_for_select' => 'Pelanggan tersedia',
    'massmail__clients_list_selected' => 'Pelanggan yang dipilih',
    'massmail__advanced' => 'Lanjutan',
    'bt_massmail_send' => 'Hantar',
    'massmail__save_template_name' => 'Simpan teks ke templat bernama baru',
    'massmail__template' => 'Templat',
    'massmail__compose_mail' => 'Mesej',
    'massmail__from' => 'Dari',
    'massmail__to' => 'Kepada',
    'massmail__subject' => 'Subjek',
    'massmail__body' => 'Teks mesej',
    'massmail__body_hint' => 'Gunakan <name> pemboleh ubah untuk masukkan nama pengguna secara automatik ke dalam mesej anda.',
    'massmail__send_to_clients' => "Pelanggan",
    'massmail__send_to_domainusers' => "Pentadbir Domain",
    'massmail__send_to_admins' => "Pentadbir Plesk",
    'massmail_select' => 'Pilih Alamat',
    'massmail_showhide_selected' => "Tunjukkan/Sembunyikan yang Dipilih",
    'massmail_send_all' => "Semua",
    'massmail_send_selected' => "Hanya dipilih",
    'massmail_send_except' => "Semua kecuali dipilih",
    'bt_new_mass_mail_template' => "Tambah Templat E-mel Massa",
    '__mass_mail_templates_list' => "E-mel massa senarai templat mesej",
    'massmail__template_name' => 'Nama templat',
    'massmail__receivers' => 'Penerima',
    'massmail__created' => 'Penghantar',
    'massmail__date_created' => 'Tarikh ciptaan',
    'massmail__compose' => 'Hantar',
    'mass_mail__resellers_all' => 'Semua penjual semula',
    'mass_mail__clients_all' => 'Semua pelanggan',
    'mass_mail__domainusers_all' => 'Semua pentadbir domain',
    'mass_mail__resellers_selected' => 'Penjual semula yang dipilih',
    'mass_mail__clients_selected' => 'Pelanggan yang dipilih',
    'mass_mail__domainusers_selected' => 'Pentadbir domain yang dipilih',
    'mass_mail__resellers_except' => 'Semua penjual semula kecuali yang dipilih',
    'mass_mail__clients_except' => 'Semua pelanggan kecuali yang dipilih',
    'mass_mail__domainusers_except' => 'Semua pentadbir domain kecuali yang dipilih',
    'mass_mail__admins_all' => 'Semua pentadbir',
    'massmailtemplateslist__title' => 'Mesej e-mel massa templat mesej',
    'massmail__insert_from_template' => "Masukkan data dari templat",
    'massmail__select_template' => "Pilih templat",
    'massmail__body_short_hint' => "(teks biasa sahaja)",
    'massmail__from_short_hint' => "(e-mel atau nama)",
    'bt_insert' => "Selit",
    'massmail__mail_send_successfully' => "Mesej yang dihantar telah berjaya.",
    'massmail__mail_send_successfully_with_some_errors' => "Mesej yang dihantar telah berjaya tetapi beberapa ralat telah ditemui. Beberapa penerima tidak mungkin tidak dapat menerima mesej. Untuk maklumat lebih lanjut, lihat fail log yang berikut: %plesk_dir%\\pentadbir\\log\\hantar_massa_mel.log",
    'massmail__mail_send_failed' => "Mesej tidak dihantar keluar. Sila pastikan yang sekurang-kurangnya satu penerima yang dipilh dan pelayan mel Plesk berfungsi dengan betul. Untuk maklumat lebih lanjut, lihat fail log yang berikut: %plesk_dir%\\pentadbir\\log\\hantar_massa_mel.log",
    'massmail__template_data_inserted' => "Data dari templat %1 telah berjaya dimasukkan.",
    'massmail__template_added_successfully' => "Templat mesej telah disimpan di bawah nama %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Ralat pangkalan data Presence Builder telah berlaku. Hubungi pembekal perkhidmatan anda untuk mendapatkan bantuan.",
    'wsb_error_sitebuilder_access_denied_error' => "Tidak boleh untuk akses fail: Presence Builder tidak mempunyai hak akses untuk fail atau folder yang diperlukan. Hubungi pembekal perkhidmatan anda untuk mendapatkan bantuan.",
    'wsb_error_sitebuilder_connection_failed' => "Tidak dapat menyambung Presence Builder kerana sambungannya terputus. Hubungi pembekal perkhidmatan anda untuk mendapatkan bantuan.",
    'wsb_error_critical_during_operation' => "Kritikal ralat Presence Builder berlaku:\n%1",
    'wsb_error_license_during_operation' => "Ralat lesen Presence Builder telah berlaku:\n%1",
    'wsb_error_during_operation' => "Ralat Presence Builder berlaku:\n%1",
    'wsb_error_license_error' => "Had lesen Presence Builder telah dihadapi.",

    // Other
    '__confrim_service_stop' => "Amaran! Jika anda menghentikan perkhidmatan %1, Plesk mungkin gagal berfungsi. Adakah anda pasti anda mahu hentikan perkhidmatan %1?",
    'virtualdir__name_is_reserved' => "Nama ini disimpan",
    'index_redirect_help_text' => 'Sekarang anda akan dihalakan semula secara automatik ke tapak web yang diperlukan. Jika pelayar anda tidak menyokong penghalaan semula, sila klik %1 sini %2',
    'bt_default_settings' => "Pulihkan Lalai",
    'logfiles__remove_failed' => "Tidak dapat memadam fail %1: fail tersebut dikunci oleh aplikasi lain. Sila cuba lagi kemudian",
    'subdomain__invalid_homedirectory' => "Tentukan direktori rumah subdomain adalah tidak sah",
    'scheduler_item__empty_filename' => "Sila tentukan fail boleh laku untuk jalan",
    'subdomains__overlapped_domain_exists' => 'Subdomain yang bertindih dengan zon DNS domain %1',
    'subdomains__overlapped_domain_alias_exists' => 'Subdomain yang bertindih dengan zon DNS domain alias %1',
    'services_action_none_selected' => 'Tidak dapat melengkapkan operasi: sila pilih perkhidmatan yang diperlukan',
    'cl_perm__max_subftp_users' => "bilangan maksimum akaun FTP tambahan",
    'login_up__access_denied_no_cp_access' => 'Akses ditolak. Anda tidak mempunyai kebenaran untuk mengakses Plesk.',
    'drweb__disable_reason_admin' => "Tetapan penapis Antivirus pada tahap peti mel tidak dibenarkan oleh dasar pelayan.",

    'webdirs__name_is_invalid' => 'Gunakan hanya abjad angka dan aksara sempang dalam nama direktori.',
    'webdirs__physical_path_is_invalid' => 'Laluan fizikal adalah tidak sah atau tidak wujud',
    '__use_default' => 'Guna lalai',

    'webalizer_hidden_referrer__already_exist' => 'Entri seperti telah wujud.',
    'webalizer_group_referrer__already_exist' => 'Perujuk kumpulan dengan nama seperti sudah wujud.',

    'pb__dashboard' => 'Laman Utama',

    'server_interface__page_title' => 'Tetapan Pelayan Antara muka',
    'server_interface__tabs_locales' => 'Tempatan',
    'server_interface__tabs_skins' => 'Kulit',
    'server_interface__tabs_interface_templates' => 'Templat Antara muka',
    'bt_server_interface' => 'Keutamaan Antara Muka',
    'pb__server_interface' => 'Keutamaan Antara Muka',

    'bt_wizard_next' => 'Seterusnya >>',
    'bt_wizard_prev' => '<< Kembali',

    '__limit_exceeded_max_dom_server' => 'Anda tidak boleh hos lebih domain pada pelayan kerana bilangan had pada domain dibenarkan pada pelayan dengan kunci lesen telah dicapai. Hubungi penyedia perkhidmatan anda untuk menyelesaikan isu ini.',
    '__limit_exceeded_max_subdom_server' => 'Anda tidak boleh hos lebih subdomain pada pelayan ini. Sila hubungi pembekal perkhidmatan anda.',
    '__limit_exceeded_max_dom_aliases_server' => 'Anda tidak boleh persediaanavailable lebih alias domain pada pelayan ini. Sila hubungi pembekal perkhidmatan anda.',
    '__limit_exceeded_max_wu_server' => 'Anda tidak boleh cipta pengguna web lebih kerana had pada bilangan pengguna web dibenarkan pada pelayan dengan kunci lesen telah dicapai. Hubungi penyedia perkhidmatan anda untuk menyelesaikan isu ini.',
    '__limit_exceeded_max_mn_server' => 'Anda tidak boleh cipta lebih akaun mel kerana had pada bilangan akaun mel dibenarkan pada pelayan dengan kunci lesen telah dicapai. Hubungi penyedia perkhidmatan anda untuk menyelesaikan isu ini.',

    '__limit_exceeded_max_cl_useradmin' => 'Anda telah mencapai had pada bilangan akaun pelanggan ditakrifkan mengikut kunci lesen anda (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Anda telah mencapai had pada bilangan domain ditakrifkan mengikut kunci lesen anda (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Anda telah mencapai had pada bilangan subdomain ditakrifkan mengikut kunci lesen anda (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Anda telah mencapai had pada bilangan alias domain ditakrifkan mengikut kunci lesen anda (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Anda telah tiada baki ruang bebas cakera',
    '__limit_exceeded_max_wu_useradmin' => 'Anda telah mencapai had pada bilangan pengguna web ditakrifkan mengikut kunci lesen anda (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Anda telah mencapai had pada bilangan pangkalan data ditakrifkan mengikut kunci lesen anda (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Anda telah mencapai had pada bilangan peti mel ditakrifkan mengikut kunci lesen anda (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Anda telah mencapai had pada bilangan mel akaun ditakrifkan mengikut kunci lesen anda (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Anda telah mencapai had pada bilangan senarai mel ditakrifkan mengikut kunci lesen anda (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Anda telah mencapai had pada bilangan domain (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Anda telah mencapai had pada bilangan subdomain (%2) dibenarkan mengikut pembekal perkhidmatan anda.',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Anda telah mencapai had pada bilangan alias domain (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Anda sudah mencapai ruang cakera had penggunaan (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Anda telah mencapai had pada jumlah lebar jalur yang digunakan setiap bulan (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Anda telah mencapai had pada bilangan pengguna web (%2) dibenarkan mengikut pembekal perkhidmatan anda.',
    '__limit_exceeded_max_db_userclient' => 'Anda telah mencapai had pada bilangan pangkalan data %2.',
    '__limit_exceeded_max_box_userclient' => 'Anda telah mencapai had pada bilangan peti mel %2.',
    '__limit_exceeded_max_maillists_userclient' => 'Anda telah mencapai had pada bilangan senarai mel (%2)',
    '__limit_exceeded_expiration_userclient' => 'Akaun anda luput pada %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Anda telah mencapai had pada bilangan subdomain (%2) dibenarkan mengikut pembekal perkhidmatan anda.',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Anda telah mencapai had pada bilangan alias domain (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Anda sudah mencapai ruang cakera had penggunaan (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Anda telah mencapai had pada jumlah lebar jalur yang digunakan setiap bulan (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Anda telah mencapai had pada bilangan pengguna web %2.',
    '__limit_exceeded_max_db_userdomain' => 'Anda telah mencapai had pada bilangan pangkalan data %2.',
    '__limit_exceeded_max_box_userdomain' => 'Anda telah mencapai had pada bilangan peti mel %2.',
    '__limit_exceeded_max_maillists_userdomain' => 'Anda telah mencapai had pada bilangan senarai mel (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Akaun anda luput pada %2',

    'mmt__to_none' => 'Tiada',
    'mmt__to_admin' => 'Pentadbir',
    'mmt__to_resellers_all' => 'Semua penjual semula',
    'mmt__to_resellers_select' => 'Penjual semula yang dipilih',
    'mmt__to_resellers_select__available' => 'Penjual semula tersedia',
    'mmt__to_resellers_except' => 'Semua penjual semula kecuali yang dipilih',
    'mmt__to_clients_all' => 'Semua pelanggan',
    'mmt__to_clients_select' => 'Pelanggan yang dipilih',
    'mmt__to_clients_select__available' => 'Pelanggan tersedia',
    'mmt__to_clients_except' => 'Semua pelanggan kecuali yang dipilih',

    'mmt__unable_send_empty_selection' => 'Tidak dapat menghantar mel massa, tiada alamat e-mel dipilih.',
    'mmt__unable_send_to__' => 'Tidak dapat menghantar mel massa pada:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Tidak dapat sahkan aplikasi web kerana salah satu fail yang diperlukan (%1) tidak ditemui. Hubungi wakil teknikal sokongan anda untuk mendapatkan bantuan.',
    'sapp_error_validation_spec_failed' => 'Aplikasi web yang dimuat naik tidak mematuhi spesifikasi AppPacks: %1.',
    'sapp_error_validation_register' => 'Tidak dapat mendaftarkan aplikasi web yang terletak di dalam direktori "%1": %2 Anda perlu mengalih keluar aplikasi web dari pelayan kerana ia tidak akan berfungsi dengan betul.',

    'sapp__install_failed' => 'Pemasangan aplikasi web gagal: %1',
    'sapp__install_res_failed' => 'Gagal untuk cipta sumber permintaan.',

    'server_preferences__subdomains_blog_and_photo' => 'Cipta Blog dan subdomain Galeri Gambar melalui lalai',
    'plesk_key__blog_and_photo' => 'Kebolehan mengurus keadaan lalai Cipta Blog dan kotak semak subdomain Galeri Gambar',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Tidak dapat mengubah jenis alamat IP untuk dikhususkan kerana ia diuntukkan kepada lebih daripada satu pengguna.',

    // 8.1.1

    '__write_modify_warning' => 'Pilih kebenaran menulis/mengubah suai akan menjadikan beberapa aplikasi web berfungsi dengan betul, tetapi ia juga akan meningkatkan risiko keselamatan',
    '__write_modify_subdomain_warning' => 'Pilih kebenaran menulis/mengubah suai akan menjadikan beberapa aplikasi web berfungsi dengan betul, tetapi ia juga akan meningkatkan risiko keselamatan',

    'phosting__php_incorrect_version_used' => "Masalah versi PHP dikesan. Untuk menyelesaikan masalah ini, pilih kotak semak dengan versi PHP yang diperlukan di bawah dan klik OK. Untuk mematikan PHP pada domain ini, klik OK tanpa memilih versi PHP",
    'fp__mail_preferences' => 'Tetapan Mel',

    'mail__invalid_white_pattern' => 'Nilai yang dinyatakan tidak sah. Gunakan format berikut: mail@example.com untuk alamat e-mel, example.com untuk domain.',
    'mail__invalid_black_pattern' => 'Nilai yang dinyatakan tidak sah. Gunakan format berikut: mail@example.com untuk alamat e-mel, example.com untuk domain.',

    'resp_edit__reply_as_html' => 'Hantar sebagai HTML',
    'exception__path_very_long' => "Laluan yang terlalu panjang. Sila pastikan bahawa terdapat kurang daripada %1 aksara di laluan.",

    // 8.2


    //SAPP
    'sapp_on' => 'Hidup',
    'sapp_off' => 'Mati',
    'sapp_directive_aspect' => 'Diperlukan',
    'sapp_databases_num' => 'Pangkalan Data',
    'sapp_db_required' => 'Diperlukan',
    'sapp_Required' => 'Diperlukan',
    'sapp_Variant' => 'Varian',
    'sapp_db_id' => 'Id pangkalan data',
    'sapp_db_id_type' => 'DB (id: %1) jenis',
    'sapp_db_id_min_version' => 'DB (id: %1) versi minimum',
    'sapp_db_id_table_prefix' => 'DB (id: %1) meja awalan',
    'sapp_Default' => 'Nilai lalai',
    'sapp_apache_mod_req' => 'Modul Apache',
    'sapp_dbtype_not_installed' => 'Tidak dipasang',
    'sapp_apache_mod_not_installed' => 'Tidak dipasang',
    'sapp__value_error_empty' => 'Nilai kosong tidak dibenarkan.',
    'sapp_error_invalid_type' => 'Aplikasi "%1" tidak sokong tindakan yang diminta.',
    'sapp_error_unknown_app_type' => 'Jenis aplikasi tidak disokong: %1.',
    'sapp__ssl_text' => 'Pasang aplikasi pada hos maya "http://" atau "https://"?',
    'sapp__app_to_upgrade' => 'Aplikasi untuk dinaik taraf',
    'sapp__upgrade_apps_title' => 'Naik taraf aplikasi',
    'sapp__upgrade_to_ver' => 'Naik taraf kepada versi',
    'sapp__choose_pkg_ver' => 'Pilih pakej',
    'sapp__pkg_cant_upgrade_pkg' => 'Pakej "%1" tidak boleh digunakan untuk naik taraf aplikasi web "%2".',
    'sapp__app_ugrade_error' => 'Tidak dapat naik taraf aplikasi: %1. Sila hubungi pentadbir sistem anda.',
    'sapp__no_suitable_db_found' => 'Tiada pangkalan data yang sesuai ditemui.',
    'sapp__upgrade_success' =>  'Aplikasi telah berjaya dinaik taraf.',
    'sapp__pkg_info_changelog' => 'Sejarah bagi perubahan',
    'sapp_requirement_legend' => 'Pengehosan ciri yang diperlukan oleh aplikasi',

    // other
    'bt_apply' => 'Guna',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Untuk mencipta alias mel, peti mel haruslah ditukarkan pada akaun mel ini. Hidupkan peti mel?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Matikan peti mel akan mengalih keluar alias mel kerana ia akan berhenti berfungsi. Tutup suis pada peti mel?',
    'antivirus__disable_reason_install' => 'Anda tidak boleh mengurus antivirus kerana ia tidak dipasang.',
    'antivirus__disable_reason_key' => 'Anda tidak boleh mengurus antivirus kerana ia tidak diaktifkan oleh kunci lesen yang sepatutnya.',
    'antivirus__disable_reason_deny_personal_settings' => 'Anda tidak boleh mengurus antivirus kerana dasar pelayan melarang tetapan antivirus individu.',
    'change_foreign_user_password' => 'Tukar kata laluan',
    'change_foreign_user_password_hint' => "Pengguna tidak tergolong dalam aplikasi ini. Klik pada pautan untuk pergi ke aplikasi lain dan ubah kata laluan pengguna di situ. Untuk perlaksanaan ini, anda memerlukan hak yang bersesuaian di dalam aplikasi ini.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Format Rentetan',
    'lang_unknown' => 'Bahasa yang tidak diketahui',
    'pb__cl_ed' => 'Butiran pelanggan',
    'pb__actionlog' => 'Log tindakan',
    'pb__cl_limits' => 'Had pelanggan',
    'pb__edit' => 'Edit',
    'pb__subdom_edit' => 'Tetapan pengehosan',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Sandarkan kandungan peti mel',

    'maillist_import_result' => "\nJumlah keseluruhan alamat e-mel dalam fail: %1\njumlah alamat e-mel yang diimport: %2\njumlah alamat e-mel yang telah sedia ada: %3\njumlah alamat e-mel dalam fail salinan yang ditentukan: %4\njumlah alamat e-mel tidak sah dalam fail: %5",
    'maillist_import_error' => 'Tidak dapat mengimport senarai alamat e-mel',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Fail yang anda pilih sama ada kosong atau bukannya dokumen HTML yang sah dalam pengekodan yang dipilih. Sila pilih pengekodan yang betul atau tambah kandungan kepada fail.",

    'dom_pref__external_mail_srv' => "Ubah hala ke pelayan mel luaran dengan alamat IP yang:",
    'mn_edit__store_messages' => 'Peti Mel',

    // aps

    'sapp__before_upgrade_notice' => 'Ia disarankan untuk membuat sandaran data aplikasi dan pengguna sebelum memulakan proses naik taraf.',
    'sapp__application_properties' => 'Sifat aplikasi',
    'sapp__application_root_descr' => 'Aplikasi halaman utama',

    'sapp__aps_license_invalid_id' => 'Kunci lesen mempunyai ID tidak sah: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Lesen dengan kunci nombor %1 sudah wujud dalam pangkalan data.',
    'sapp__aps_lic_del_used' => 'Tidak boleh memadam kunci lesen, ia sedang digunakan oleh satu aplikasi yang dipasang.',
    'sapp__aps_lic_del_unknown' => 'Tidak dapat memadam kunci lesen: %1',
    'sapp__aps_cappi_duplicate' => "Aplikasi ini sudah dalam himpunan aplikasi pelanggan ini",
    'sapp__appi_not_shared_no_install' => "Tidak ada aplikasi seperti di himpunan aplikasi pelanggan. Jika anda mahu untuk pasang aplikasi ini pada tapak, anda patut tambah aplikasi ini untuk himpunan aplikasi pelanggan.",
    'sapp__appi_shared_not_client' => "Tidak ada aplikasi seperti di himpunan aplikasi pelanggan. Jika anda mahu untuk naik taraf aplikasi pada versi tertentu, anda patut tambah versi aplikasi ini untuk himpunan aplikasi pelanggan.",
    'sapp__apply_license_script_not_found' => 'Tidak dapat mencari "mohon lesen-" skrip untuk aplikasi web ini.',
    'sapp__unable_to_activate_key' => 'Ralat berlaku semasa percubaan untuk mengaktifkan kunci lesen: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Terdapat aplikasi web dipasang yang perlu hadir pada aplikasi web dalam sistem.',
    'sapp__unable_to_delete_ai_in_pool' => 'Aplikasi ini masih dalam himpunan pelanggan. Jika anda ingin alih keluar aplikasi ini, anda perlu alih keluar dari semua himpunan aplikasi pelanggan atau buat ia percuma.',
    'sapp__unable_to_delete_app_template' => 'Tidak dapat mengalih keluar aplikasi #%1: %2',
    'sapp__limit_exceeded_client' => 'Anda telah mencapai had kepada bilangan kali anda boleh memasang aplikasi web ini (%2).',


    // atis module

    '_week_on' => 'minggu pada',
    '__week_first' => 'pertama',
    '__week_second' => 'kedua',
    '__week_third' => 'ketiga',
    '__week_fourth' => 'keempat',
    '__week_last' => 'terakhir',
    '__not_started' => 'Menunggu',
    '__started' => 'Berjalan',
    '__cancel_pending' => 'Pembatalan',
    '__canceled' => 'Dibatalkan',
    '__error' => 'Ralat',
    '__done' => 'Selesai',

    '__php_cgi_handler' => 'Aplikasi CGI',
    '__php_isapi_handler' => 'Sambungan ISAPI',
    '__php_fastcgi_handler' => 'Aplikasi FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'jalan sebagai',

    'cf_dbfolder_text' =>'Folder Pangkalan Data',
    'cf_isnewdb_text' => 'Cipta Pangkalan Data',
    'cf_isnewdb_title' => 'Pilih kotak semak jika pangkalan data harus dicipta',

    'pb__site_apps_upgrade' => 'Naik taraf aplikasi web',

    'detach' => 'Putuskan',
    'preferences' => "Tukar Kata Laluan",

    'toolsbar__switch_user?' => "Adakah anda pasti anda mahu log masuk di bawah akaun pengguna?",
    '__aps_left' => 'Baki pemasangan',
    'aps__license_key' => 'Kunci lesen',
    'aps__download_code' => 'Muat turun kunci lesen dan kod pengaktifan.',
    'aps__license_key_hint' => 'Dapatkan kod pengaktifan dari pelayan perlesenan.',
    'aps__database_not_available' => 'tidak tersedia, tolong semak domain atau had pelanggan.',
    'aps__yes' => 'Ya',
    'aps__no' => 'Tidak',
    '__click_to_enlarge' => 'Klik untuk besarkan',
    'site_apps__back_to_list' => 'Kembali ke senarai',
    'sapp__pkg_info_installation_requirements' => 'Keperluan pemasangan',
    '__close_window' => 'Tutup',

    //SAPP END

    'skin_info__already_default' => 'Kulit ini telah ditetapkan sebagai lalai satu.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Antivirus Premium Plesk',
    'drweb:properties_page_title' => 'Tetapan Antivirus Premium Plesk untuk %1',
    'drweb:properties_legend' => 'Tetapan',
    'drweb:status' => 'Semak mel untuk virus',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder bestari',
    'dom_site_builder' => 'Klik untuk membuka Presence Builder Wizard.',
    'sb_plesk_admin_url' => 'URL pelayan Presence Builder. Sambungan ke Presence Builder tidak dikonfigurasikan lagi: anda perlu menambah rekod dalam zon templat DNS yang akan tunjuk ke pelayan Presence Builder.',
    'sb_plesk_admin_login' => 'Kata laluan untuk pelayan pentadbir log masuk pada Presence Builder',
    'sb_plesk_admin_password' => 'Kata laluan pentadbir',
    'sb_sitebuilder_preferences' => 'Butiran pentadbir Presence Builder',
    'sb__server' => 'Sistem Presence Builder keutamaan Pentadbir',
    'sb__sitebuilder_support' => 'Sokongan Presence Builder',
    'sb_keep_sb_user' => 'Simpan akaun pengguna sepadan di Presence Builder',
    'sb_create_sb_user' => 'Cipta akaun pengguna yang sepadan dalam Presence Builder',
    'sb__build_site_using_sitebuilder' => "Cipta tapak web guna Presence Builder",
    'sb_no_current_sb_server_set' => 'Sambungan ke Presence Builder belum dikonfigurasikan lagi. anda perlu menambah rekod dalam Zon DNS templat yang akan tunjuk kepada pelayan Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Tidak dapat untuk dapatkan semula maklumat dari sistem Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Tidak dapat menyambung ke Presence Builder: nama pengguna atau kata laluan salah.",
    'sb_init_sb_manager' => "Memulakan pengurus Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Gagal untuk sambung kepada sistem Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Pelanggan ini tidak mempunyai akaun pengguna di Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder tidak dikonfigurasikan.",
    'sb_err_you_dont_have_sbaccount' => "Gagal memberi kuasa kepada anda di Presence Builder.",
    'sb_error_critical_during_operation' => "Ralat berikut telah berlaku di Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Log masuk tunggal sokongan tidak dihidupkan dalam Plesk.",

    'warning__super_zone_exist' => "Zon %1 telah diciptakan, bagaimanapun, nama zon ini adalah subzon bagi zon lain yang telah sedia ada %2, yang dimiliki oleh pengguna lain %3. Ia adalah mungkin, tetapi sila pastikan anda telah memilih akaun pengguna yang betul.",
    'error__super_zone_exist' => "Tidak dapat mencipta zon DNS kerana superzon dimiliki oleh pengguna lain.",

    'locales__files_not_exits' => 'Tidak dapat mengubah tempatan: fail pek bahasa antara muka yang dinyatakan tidak wujud dalam sistem.',
    'locales__unavailable' => 'Tidak dapat mengubah tempatan: pek bahasa antara muka yang dinyatakan tidak tersedia.',

    // DB BU

    'pb__dbbackup_list' => 'Fail sandaran pangkalan data',
    // server
    'dbbackup__server_backup_settings' => 'Sandaran',
    'dbbackup__network_temp_dir' => 'Direktori rangkaian sementara',
    'dbbackup__network_user' => 'Nama pengguna',
    'dbbackup__network_pass' => 'Kata laluan',
    // domain
    'dbbackup__add_database_legend' => 'Pulih pangkalan data sandaran',
    'dbbackup__add_database_restore' => 'Pulih pangkalan data dari fail sandaran',
    'dbbackup__add_database_file' => 'Fail sandaran pangkalan data',
    'dbbackup__add_database_user' => 'Nama pengguna lalai',
    'dbbackup__add_database_pass' => 'Kata laluan pengguna lalai',
    'dbbackup__add_database_pass2' => 'Pengesahan kata laluan pengguna lalai',

    'bt_dbbackup_now' => 'Sandaran',

    'bt_repair' => 'Baiki',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Memuat naik pangkalan data Pelayan SQL ke tempat pembuangan adalah dilarang oleh penyedia pengehosan.',

    // APS categories

    'cf_invalid_password' => 'Kata laluan tidak boleh lebih panjang daripada 16 aksara',
    'cf_invalid_description_length' => 'Perihalan tidak boleh lebih panjang daripada 256 simbol',
    'ip_addr__ip_used_by_external_mail_server' => 'Alamat IP %1 sudah pun digunakan oleh pelayan mel luaran',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Nama pengguna akaun FTP atau kata laluan tidak sah. Sila tentukan dengan betul kelayakan FTP pengguna.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Had pada perubahan nombor siri dicapai. Tiada perubahan pada zon DNS yang boleh dilakukan lagi hari ini.',
    'dns__zone_apply_changes' => 'Perubahan yang dibuat pada rekod DNS belum disimpan. Perubahan yang telah dibuat diserlahkan di bawah. Klik Kemas kini untuk menggunakan perubahan kepada zon DNS atau klik Berbalik untuk mengabaikan perubahan.',
    'dns__update_dns_zone' => 'Klik untuk simpan perubahan yang dibuat kepada rekod DNS',
    'dns__revert_dns_zone' => 'Klik untuk batalkan perubahan yang dibuat kepada rekod DNS',
    'bt_revert' => 'Kembali Sebelum',
    'dns__dns_zone_has_beed_updated' => 'Perubahan yang dibuat pada rekod DNS telah disimpan.',
    'dns__dns_zone_has_beed_reverted' => 'Perubahan yang dibuat pada rekod DNS telah dibatalkan.',
    'db__nondefault_server_not_allowed' => 'Penggunaan pelayan pangkalan data bukan lalai adalah tidak dibenarkan',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Akaun dan domain pelanggan %1.',
    'ui__client__disabled-warning' => 'Akaun pelanggan %1 digantung.',
    'ui__client__none-available' => 'Tiada akaun pelanggan dikonfigurasikan.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Pelanggan %1',
    'ui__client_self__description' => 'Senarai domain saya.',
    'ui__client_self__short-title' => 'Domain saya',
    'ui__client_self__title' => 'Domain saya',


    'site_apps__non_removable' => 'Item yang tidak dapat dialih keluar',
    'site_apps__non_removable_items' => 'Aplikasi web berikut tidak boleh dialih keluar:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Tiada butang tersuai.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Tiada butang tersuai dalam Panel Pelanggan %1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Alih keluar butang %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Alih keluar',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Alih keluar butang %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Alih keluar butang tersuai daripada Panel Pelanggan pelanggan',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Alih keluar',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Alih keluar butang tersuai',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Alih keluar butang',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Pilih pelanggan yang ingin dialih keluar butang tersuainya dan klik Seterunya >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Pilih butang yang ingin dialih keluar dan klik Seterusnya >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Sahkan mengalih keluar butang dengan memilih kotak semak pada skrin ini dan kemudian klik Selesai.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Alih keluar butang tersuai daripada Panel Pelanggan pelanggan.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Alih keluar',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Alih keluar butang tersuai',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Alih keluar butang tersuai',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Pilih pelanggan yang ingin dialih keluar butang tersuainya dan klik Seterusnya >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Pilih butang tersuai yang ingin dialih keluar dan klik Seterusnya >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Sahkan mengalih keluar butang tersuai dengan memilih kotak semak pada skrin ini dan kemudian klik Selesai.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Edit sifat tahap pelanggan butang %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Tetapan',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Ubah suai pelanggan butang tersuai %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Tambah butang tersuai',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Pilih pelanggan yang anda ingin cipta butang tersuai dalam Panel Pelanggannya dan klik Seterusnya >>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klik Selesai untuk cipta butang.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Ubah sifat butang dalam Panel Pelanggan pelanggan.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Sifat',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Ubah sifat butang dalam Panel Pelanggan pelanggan',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ubah sifat butang tersuai',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Pilih pelanggan yang ingin diubah suai butang tersuainya dan klik Seterusnya >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Pilih butang tersuai yang ingin diubah suai dan klik Seterusnya >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Apabila dilakukan dengan mengedit sifat butang, klik Selesai untuk menggunakan perubahan dan keluar dari wizard.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Buat butang %1 tidak tersedia kepada pelanggan anda.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Buat tidak tersedia kepada pelanggan anda',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Buat butang %1 tidak tersedia kepada pelanggan anda',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Buat butang %1 kelihatan kepada pengguna pelanggan.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Buat tersedia kepada pelanggan anda',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Buat butang %1 kelihatan kepada pengguna pelanggan',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Buat butang tersuai yang tersedia/tidak tersedia kepada pelanggan anda.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tersedia/tidak tersedia kepada pelanggan anda',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Buat butang tersuai ada atau tidak tersedia untuk pelanggan anda',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Buat butang tersuai yang tersedia/tidak tersedia kepada pelanggan anda.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Pilih pelanggan yang butang tersuainya ingin dijadikan tersedia kepada pengguna pelanggan dan klik Seterusnya >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Pilih butang tersuai yang ingin dijadikan tersedia atau tidak tersedia kepada pelanggan anda dan klik Seterusnya >>.',

    'ui__client/domain__description' => 'Urus domain %1.',
    'ui__client/domain__disabled-warning' => 'Domain %1 digantung.',
    'ui__client/domain__none-available' => 'Anda tidak mempunyai mana-mana domain.',
    'ui__client/domain__none-available__1' => 'Akaun %1 tidak mempunyai domain.',
    'ui__client/domain__none-available__2' => 'Akaun %1 tidak mempunyai domain.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domain %1',
    'ui__client/domain_self__description' => 'Urus domain anda',
    'ui__client/domain_self__disabled-warning' => 'Domain ini digantung.',
    'ui__client/domain_self__quick-search' => 'Domain saya',
    'ui__client/domain_self__short-title' => 'Domain saya',
    'ui__client/domain_self__title' => 'Domain saya',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Tiada butang tersuai diletakkan dalam Panel Pelanggan pelanggan.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Pelanggan %1 tiada butang tersuai dalam Panel Pelanggan.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Tiada butang tersuai untuk domain %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Alih keluar butang tersuai %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Alih keluar',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Alih keluar butang tersuai %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Alih keluar butang tersuai.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Alih keluar',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Alih keluar butang tersuai',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Alih keluar butang tersuai',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Pilih pelanggan yang ingin dialih keluar butang dari panel pentadbiran domainnya dan klik Seterusnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Pilih domain yang ingin dialih keluar butang dari panel pentadbiran domainnya dan klik Seterusnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Pilih butang yang ingin dialih keluar dan klik Seterusnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Sahkan mengalih keluar butang dengan memilih kotak semak yang berkenaan dan klik Selesai untuk membuang butang dan keluar dari bestari.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Alih keluar butang tersuai',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Alih keluar',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Alih keluar butang tersuai',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Alih keluar butang tersuai',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Pilih pelanggan yang ingin dialih keluar butang tersuainya dari panel pentadbiran domainnya dan klik Seterusnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Pilih domain yang ingin dialih keluar butang dari panel pentadbiran dan klik Seterusnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Pilih butang tersuai yang ingin dialih keluar dan klik Seterusnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Sahkan mengalih keluar butang tersuai dengan memilih kotak semak yang berkenaan dan klik Selesai untuk membuang butang dan keluar dari bestari.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Ubah sifat butang tersuai %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Sifat",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Ubah sifat butang tersuai %1 dalam Panel Pelanggan.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Tambah butang',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Pilih pelanggan yang ingin anda letakkan butang dalam Panel Pelanggannya dan klik Seterusnya >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Pilih langganan yang ingin diubah suai butangnya dan klik Seterusnya >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Klik Selesai untuk membuat butang dan keluar dari bestari.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Ubah sifat butang dalam Panel Pelanggan.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Sifat',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Ubah sifat butang dalam Panel Pelanggan',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ubah sifat butang',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Pilih butang tersuai yang ingin diubah suai tetapannya dan klik Seterusnya >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Apabila selesai dengan mengubah sifat butang, klik Selesai untuk menggunakan perubahan dan keluar dari bestari.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Buat butang %1 tidak tersedia kepada pengguna mel di bawah domain ini.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Tidak tersedia untuk pengguna mel',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Buat butang %1 tidak tersedia kepada pengguna mel di bawah domain ini',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Buat butang %1 kelihatan kepada pengguna mel di bawah domain.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Boleh diakses oleh pengguna mel di bawah domain ini',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Buat butang tersuai %1 kelihatan kepada pengguna mel di bawah domain ini',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Buat butang tersuai tersedia atau tidak tersedia kepada pengguna lain.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tersedia/tidak tersedia kepada pengguna lain',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Buat butang tersuai tersedia atau tidak tersedia kepada pengguna mel.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Buat butang tersuai tersedia atau tidak tersedia kepada pengguna lain',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Pilih domain tempat butang ingin diletakkan dan klik Seterusnya >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Pilih butang yang ingin dijadikan tersedia atau tidak tersedia kepada pengguna lain dan klik Seterusnya >>.',

    'ui__client/domain/delete__description' => 'Alih keluar domain %1',
    'ui__client/domain/delete__short-title' => 'Alih keluar',
    'ui__client/domain/delete__title' => 'Alih keluar domain %1',
    'ui__client/domain/delete_multi__description' => 'Alih keluar domain.',

    'ui__client/domain/delete_multi__short-title' => 'Alih keluar',
    'ui__client/domain/delete_multi__title' => 'Alih keluar domain',
    'ui__client/domain/delete_multi__wizard-title' => 'Alih keluar domain',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Pilih domain yang ingin dialih keluar dan klik Seterusnya >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Sahkan mengalih keluar domain dengan memilih kotak semak, dan kemudian klik Selesai untuk membuangnya dan keluar dari bestari.',
    'ui__client/domain/delete_unknown__description' => 'Alih keluar domain.',
    'ui__client/domain/delete_unknown__short-title' => 'Alih keluar',
    'ui__client/domain/delete_unknown__title' => 'Alih keluar domain.',
    'ui__client/domain/delete_unknown__wizard-title' => 'Alih keluar domain.',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Pilih domain yang ingin dialih keluar dan klik Seterusnya >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Sahkan mengalih keluar domain dengan memilih kotak semak, dan kemudian klik Selesai untuk membuangnya dan keluar dari bestari.',

    'ui__client/domain/hosting__none-available' => 'Tiada domain dengan pengehosan web dikonfigurasikan. Cipta domain dan konfigurasi pengehosan web padanya untuk mengakses fungsi ini.',
    'ui__client/domain/hosting__none-available__1' => 'Akaun pengguna ini tidak mempunyai domain dengan pengehosan web dikonfigurasikan. Konfigurasi pengehosan web pada domain yang diperlukan untuk mengakses fungsi ini.',
    'ui__client/domain/hosting__none-available__2' => 'Pengehosan web tidak dikonfigurasikan untuk domain %1. Konfigurasi pengehosan web pada domain %1 untuk mengakses fungsi ini.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Pelanggan",
    'ui__client/domain/hosting/application#list_header__description__title' => "Perihalan",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Item",
    'ui__client/domain/hosting/application#list_header__name__title' => "Nama",
    'ui__client/domain/hosting/application#list_header__release__title' => "Keluaran",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Isih mengikut pelanggan",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Isih mengikut perihalan",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Isih mengikut item",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Isih mengikut nama",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Isih mengikut keluaran",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Isih mengikut versi",
    'ui__client/domain/hosting/application#list_header__title' => "Aplikasi Web",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versi",

    'rpt_reseller_section_general' => 'Umum',
    'rpt_reseller_section_domains' => 'Domain',
    'rpt_reseller_section_clients' => 'Pelanggan',
    'statistics__cl_active_domains' => "Domain aktif",
    'rpt_reseller_cl_domains' => "Domain",
    'rpt_reseller_cl_subdomains' => "Subdomain",
    'by__cl_domains' => "domain klien",
    'dom_ctrl__cl_mboxes' => "Peti mel",
    'rpt_reseller_cl_redirects' => "Pemaju",
    'rpt_reseller_cl_mail_groups' => "Kumpulan mel",
    'rpt_reseller_cl_mail_resps' => "Auto-balas",
    'rpt_reseller_cl_mail_lists' => "Senarai Mel",
    'rpt_reseller_cl_web_users' => "Pengguna web",
    'rpt_reseller_cl_data_bases' => "Pangkalan Data",

    'statistics__active_clients' => 'Pelanggan dengan langganan aktif',
    'statistics__clients_active_domains' => 'Domain aktif',
    'statistics__clients_doms' => 'Domain',
    'statistics__cl_doms' => 'Domain',
    '__clients_subdomains' => 'Subdomain',
    '__clients_domains' => 'Domain',
    'dom_ctrl__clients_mboxes' => 'Peti mel',
    'dom_ctrl__clients_redir' => 'Pemaju',
    'dom_ctrl__clients_mg' => 'Kumpulan mel',
    'dom_ctrl__clients_resp' => 'Auto-balas',
    'dom_ctrl__clients_maillists' => 'Senarai Mel',
    'dom_ctrl__clients_wu' => 'Pengguna web',
    'dom_ctrl__clients_db' => 'Pangkalan Data',

    'dom_ctrl__cl_redir' => 'Pemaju', // to resolve!
    'dom_ctrl__cl_mg' => 'Kumpulan mel', // to resolve!
    'dom_ctrl__cl_resp' => 'Auto-balas', // to resolve!
    'dom_ctrl__cl_maillists' => 'Senarai Mel', // to resolve!
    'dom_ctrl__cl_wu' => 'Pengguna web', // to resolve!
    'dom_ctrl__cl_db' => 'Pangkalan Data', // to resolve!

    'rpt_cl_section_clients' => 'Pelanggan',

    'rpt_admin_section_general' => 'Umum',
    'rpt_admin_section_resellers' => 'Penjual semula',
    'rpt_admin_section_clients' => 'Pelanggan',
    'rpt_admin_section_personal_clients' => 'Pelanggan sendiri',
    'rpt_admin_section_domains' => 'Domain',
    'rpt_admin_section_personal_domains' => 'Domain peribadi',

    'rpt_reseller_section_personal_domains' => 'Domain peribadi',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Pilih domain anda mahu untuk gantung atau aktifkan.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Gantung atau aktifkan domain',

    'ui__client/ip-pool__description' => 'Peruntukkan dan batalkan peruntukan alamat IP dan sijil SSL/TLS untuk pelanggan %1.',
    'ui__client/ip-pool__short-title' => 'Himpunan IP',
    'ui__client/ip-pool__title' => 'Himpunan IP pelanggan %1',
    'ui__client/ip-pool_self__description' => 'Papar himpunan IP anda.',
    'ui__client/ip-pool_self__short-title' => 'Himpunan IP',
    'ui__client/ip-pool_self__title' => 'Himpunan IP saya',
    'ui__client/ip-pool/properties__description' => 'Sediakan himpunan IP untuk pelanggan %1.',

    'ui__client/ip-pool/properties__short-title' => 'Himpunan IP',
    'ui__client/ip-pool/properties__title' => 'Sediakan himpunan IP untuk pelanggan %1',
    'ui__client/ip-pool/properties_self__description' => 'Papar himpunan IP anda.',

    'ui__client/ip-pool/properties_self__short-title' => 'Himpunan IP saya',
    'ui__client/ip-pool/properties_self__title' => 'Himpunan IP saya',
    'ui__client/ip-pool/properties_unknown__description' => 'Peruntukkan atau batalkan peruntukan alamat IP dan sijil SSL/TLS daripada pelanggan.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Himpunan IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Sediakan himpunan IP pelanggan',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Sediakan himpunan IP pelanggan',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Pilih pelanggan yang ingin dikonfigurasikan himpunan IP.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Apabila selesai dengan konfigurasikan himpunan IP, klik Selesai untuk menggunakan perubahan dan keluar dari bestari.',


    'ui__client/limits_readonly-unknown__description' => 'Papar had sumber untuk pelanggan.',
    'ui__client/limits_readonly-unknown__short-title' => 'Had sumber',
    'ui__client/limits_readonly-unknown__title' => 'Papar had sumber untuk akaun pelanggan',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Papar atau ubah had sumber untuk pelanggan',

    'ui__client/limits_unknown__wizard-title' => 'Papar atau ubah had sumber untuk pelanggan',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Pilih pelanggan yang anda perlukan.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Pilih pelanggan yang anda perlukan.',
    'ui__client/limits_unknown__wizard__2' => 'Untuk menggunakan perubahan, klik Selesai.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Untuk keluar bestari, klik Selesai.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Untuk keluar bestari, klik Selesai.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Untuk keluar bestari, klik Selesai.',

    'ui__client/permissions_unknown__wizard-title' => 'Papar atau ubah kebenaran untuk pelanggan',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Apabila dilakukan dengan melihat kebenaran anda, klik Selesai untuk menggunakan perubahan dan keluar dari bestari.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Pilih pelanggan yang mana kebenaran anda ingin papar atau ubah.',
    'ui__client/permissions_unknown__wizard__2' => 'Apabila dilakukan dengan menukar pelanggan kebenaran, klik Selesai untuk menggunakan perubahan dan keluar dari bestari',

    'ui__client/preferences_unknown__wizard-title' => 'Edit pilihan pelanggan.',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Pilih pelanggan yang sesi dan pilihan antara muka anda mahu urus.',
    'ui__client/preferences_unknown__wizard__2' => 'Apabila selesai dengan mengubah keutamaan pelanggan, klik Selesai.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Apabila selesai dengan menukar pilihan anda, klik Selesai.',

    'ui__custom-buttons/custom-button__none-available' => 'Anda tidak ada butang tersuai.',
    'ui__custom-buttons/custom-button/delete__description' => 'Alih keluar butang tersuai %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Alih keluar',
    'ui__custom-buttons/custom-button/delete__title' => 'Alih keluar butang tersuai %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Alih keluar butang tersuai.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Alih keluar',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Alih keluar butang tersuai',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Alih keluar butang tersuai',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Pilih butang yang anda mahu alih keluar.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Sahkan mengalih keluar butang dengan memilih kotak semak, dan kemudian klik Selesai untuk lengkapkan bestari.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Alih keluar butang tersuai.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Alih keluar',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Alih keluar butang tersuai',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Alih keluar butang tersuai',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Pilih butang tersuai yang anda mahu alih keluar.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Sahkan alih keluar butang dengan memilih kotak semak dan kemudian klik Selesai untuk lengkapkan bestari.',
    'ui__custom-buttons/custom-button/properties__description' => 'Ubah sifat butang %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Sifat',
    'ui__custom-buttons/custom-button/properties__title' => 'Ubah sifat butang %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Cipta butang',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Klik Selesai untuk cipta butang.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Ubah sifat butang tersuai.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Sifat',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Ubah sifat butang tersuai',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ubah sifat butang tersuai',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Pilih butang tersuai yang anda hendak ubah',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Untuk menggunakan perubahan, klik Selesai.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Buat butang tersuai %1 tidak tersedia kepada pengguna lain.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Tidak tersedia kepada pengguna lain',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Buat butang tersuai %1 tidak tersedia kepada pengguna lain.',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Buat butang tersuai %1 tersedia kepada pengguna lain.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Tersedia kepada pengguna lain',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Buat butang tersuai %1 tersedia kepada pengguna lain.',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Buat butang tersuai tersedia atau tidak tersedia kepada pengguna lain.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Tersedia atau tidak tersedia kepada pengguna lain',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Buat butang tersuai tersedia atau tidak tersedia kepada pengguna lain',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Buat butang tersuai tersedia atau tidak tersedia kepada pengguna lain',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Pilih butang tersuai yang ingin dijadikan tersedia atau tidak tersedia kepada pengguna lain dan klik Seterusnya >>.',

    'ui__longtasks#list_header__name__title' => "Nama",
    'ui__longtasks#list_header__owner__title' => "Pemilik",
    'ui__longtasks#list_header__start_time__title' => "Masa penciptaan",
    'ui__longtasks#list_header__status__title' => "Status",
    'ui__longtasks#list_header__title' => "Tugas",
    'ui__longtasks#list_header__finish_time__title' => "Masa selesai",
    'ui__longtasks#task_list_legend__title' => "Tugas",
    'ui__longtasks#tools_legend__title' => "Alat",
    'ui__longtasks__description' => "Urus tugas latar belakang",
    'ui__longtasks__short-title' => "Tugas Latar Belakang",
    'ui__longtasks__title' => "Tugas Latar Belakang",
    'ui__longtasks/longtask/properties#current_operation__title' => "Operasi semasa:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Aggaran masa selesai:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Umum",
    'ui__longtasks/longtask/properties#owner__title' => "Tugas dimulakan dengan:",
    'ui__longtasks/longtask/properties#progress__title' => "Keseluruhan kemajuan:",
    'ui__longtasks/longtask/properties#start_time__title' => "Tugas dimulakan:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Status Tugas",
    'ui__longtasks/longtask/properties__description' => "Status tugas latar belakang dan maklumat",

    'ui__longtasks/properties__description' => "Tetapan tugas latar belakang",
    'ui__longtasks/properties__short-title' => "Tetapan",
    'ui__longtasks/properties__title' => "Tugas latar belakang",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Mesej e-mel massa templat mesej',
    'ui__mass-mail/template#list_header__name__title' => 'Nama templat',
    'ui__mass-mail/template#list_header__from_email__title' => 'Penghantar',
    'ui__mass-mail/template#list_header__to__title' => 'Penerima',
    'ui__mass-mail/template#list_header__subject__title' => 'Subjek',
    'ui__mass-mail/template#list_header__cdate__title' => 'Tarikh ciptaan',
    'ui__mass-mail/template#list_header__send__title' => 'Hantar',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Edit Templat Mesej E-mel Massa',
    'ui__mass-mail/template/properties__description' => 'Edit templat mesej e-mel massa ini.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Tambah Templat E-mel Massa',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Tambah Templat E-mel Massa',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Tambah templat mesej emel secara besar-besaran.',
    'ui__mass-mail/send__short-title' => 'Hantar E-mel Massa',
    'ui__mass-mail/send__title' => 'Hantar Mesej E-mel Massa',
    'ui__mass-mail/send__description' => 'Hantar mesej e-mel massa kepada penerima dipilih.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Alih Keluar Templat E-mel Massa',
    'ui__mass-mail/template/delete_multi__title' => 'Alih keluar templat mesej e-mel massa ini:',
    'ui__mass-mail/template/delete_multi__description' => 'Alih keluar templat mesej e-mel massa yang dipilih.',
    'ui__mass-mail/template/delete_multi__done' => 'Templat mesej yang dipilih telah dialih keluar.',
    'ui__mass-mail/template/properties__invalid_values' => 'Nilai had yang dinyatakan tidak sah',


    // old
    'ui__mass-mail#body_text__description' => 'Anda boleh menggunakan pemboleh ubah <name> dalam teks mesej (tetapi bukan dalam tajuk). Ia akan digantikan dengan nama hubungan pelanggan atau penjual semula.',
    'ui__mass-mail#body_text__title' => 'Teks mesej',
    'ui__mass-mail#compose_legend__title' => 'Mesej',
    'ui__mass-mail#from_email_text__title' => 'Dari (alamat e-mel)',
    'ui__mass-mail#list_header__cdate__title' => 'Dicipta',
    'ui__mass-mail#list_header__from_email__title' => 'Dari',
    'ui__mass-mail#list_header__name__title' => 'Nama',
    'ui__mass-mail#list_header__send__title' => 'Cipta mesej',
    'ui__mass-mail#list_header__subject__title' => 'Subjek',
    'ui__mass-mail#list_header__title' => 'Mesej e-mel massa templat mesej',
    'ui__mass-mail#list_header__to__title' => 'Kepada',
    'ui__mass-mail#list_legend__title' => 'Mesej e-mel massa templat mesej',
    'ui__mass-mail#load_template_text__title' => 'Memuatkan',
    'ui__mass-mail#name_text__title' => 'Nama templat',
    'ui__mass-mail#option_mode_all__title' => 'Semua',
    'ui__mass-mail#option_mode_except__title' => 'Semua kecuali dipilih',
    'ui__mass-mail#option_mode_select__title' => 'Hanya dipilih',
    'ui__mass-mail#option_select_template__title' => '---Pilih templat---',
    'ui__mass-mail#picker_legend__title' => 'Templat mesej e-mel',
    'ui__mass-mail#picker_title__title' => 'Pilih templat',
    'ui__mass-mail#save_as_legend__title' => 'Simpan sebagai templat',
    'ui__mass-mail#save_as_text__title' => 'Simpan mesej dikarang kepada templat baru yang dinamakan',
    'ui__mass-mail#subject_text__title' => 'Subjek',
    'ui__mass-mail#template_legend__title' => 'Templat',
    'ui__mass-mail#to_admin_text__title' => 'Pentadbir Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Pelanggan',
    'ui__mass-mail#to_domains_text__title' => 'Pentadbir domain',
    'ui__mass-mail#to_select_text__title' => 'Pilih alamat',
    'ui__mass-mail#to_show_hide_text__title' => 'Tunjuk/Sembunyi yang dipilih',
    'ui__mass-mail#to_text__title' => 'Kepada',
    'ui__mass-mail#tools_legend__title' => 'Alat',
    'ui__mass-mail__already_exists' => 'Templat dengan nama %1 telah wujud.',
    'ui__mass-mail__none-available' => 'Anda tidak mempunyai templat mesej.',

    'ui__mass-mail/delete__description' => 'Alih keluar mesej e-mel massa templat %1',

    'ui__mass-mail/delete__empty_selection' => 'Sila pilih templat yang anda mahu alih keluar',
    'ui__mass-mail/delete__short-title' => 'Alih keluar %1',
    'ui__mass-mail/delete__title' => 'Alih keluar mesej e-mel massa templat %1',
    'ui__mass-mail/delete_multi__description' => 'Alih keluar templat mesej e-mel massa.',

    'ui__mass-mail/delete_multi__short-title' => 'Alih keluar',
    'ui__mass-mail/delete_multi__title' => 'Alih keluar templat mesej e-mel massa',
    'ui__mass-mail/delete_multi__wizard-title' => 'Pengalihkeluaran templat mesej e-mel massa',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Pilih templat mesej e-mel massa yang anda ingin alih keluar.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Sahkan mengalih keluar templat dengan memilih kotak semak, dan kemudian klik Selesai untuk lengkapkan bestari.',
    'ui__mass-mail/delete_unknown__description' => 'Alih keluar templat mesej e-mel massa.',
    'ui__mass-mail/delete_unknown__short-title' => 'Alih keluar',
    'ui__mass-mail/delete_unknown__title' => 'Alih keluar templat mesej e-mel massa',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Pengalihkeluaran templat mesej e-mel massa.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Pilih templat mesej e-mel massa yang anda ingin alih keluar.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Sahkan mengalih keluar templat dengan memilih kotak semak, dan kemudian klik Selesai untuk lengkapkan bestari.',

    'ui__mass-mail/properties__description' => 'Edit templat mesej e-mel massa %1.',

    'ui__mass-mail/properties__invalid_values' => 'Nilai ditentukan adalah tidak tepat',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Edit templat mesej e-mel %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Cipta templat mesej e-mel massa',
    'ui__mass-mail/properties_unknown-new__description' => 'Cipta templat mesej e-mel massa.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Tambah templat mesej e-mel',
    'ui__mass-mail/properties_unknown-new__title' => 'Cipta templat mesej e-mel massa',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Edit templat mesej e-mel massa',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Pilih templat yang ingin diubah suai dan klik Seterusnya >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Apabila selesai dengan mengedit templat, klik Selesai untuk menggunakan perubahan dan keluar dari bestari.',

    'ui__mass-mail/send__invalid_values' => 'Anda nyatakan nilai yang salah.',

    'ui__mass-mail/send_new__wizard-title' => 'Cipta Templat Mesej dan Hantar E-mel',
    'ui__mass-mail/send_unknown-new__description' => 'Hantar e-mel kepada penerima yang dipilih',

    'ui__mass-mail/send_unknown-new__short-title' => 'Hantar E-mel Massa',
    'ui__mass-mail/send_unknown-new__title' => 'Hantar Mesej E-mel Massa',
    'ui__mass-mail/send_unknown__description' => 'Hantar e-mel kepada penerima yang dipilih',

    'ui__mass-mail/send_unknown__short-title' => 'Hantar E-mel Massa',
    'ui__mass-mail/send_unknown__title' => 'Hantar Mesej E-mel Massa',
    'ui__mass-mail/send_unknown__wizard-title' => 'Hantar Mesej E-mel Massa',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Pilih templat yang diperlukan dan klik Seterusnya >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Apabila selesai dengan mengedit sifat temlplat, klik Selesai untuk menghantar mesej dan keluar dari bestari.',

    'ui__mass-email/delete__description' => 'Alih keluar templat mesej e-mel massa yang dipilih.',

    'ui__mass-email/delete__empty_selection' => "Pilih templat yang anda mahu untuk alih keluar.",
    'ui__mass-email/delete__short-title' => "Alih keluar %1",
    'ui__mass-email/delete__title' => "Alih keluar mesej e-mel massa templat %1",
    'ui__mass-email/delete_multi__description' => "Alih keluar templat mesej e-mel massa.",

    'ui__mass-email/delete_multi__short-title' => "Alih keluar",
    'ui__mass-email/delete_multi__title' => "Alih keluar templat mesej e-mel massa",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Sahkan mengalih keluar templat dengan memilih kotak semak, dan kemudian klik Selesai untuk lengkapkan bestari.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Pilih templat mesej e-mel massa yang anda ingin alih keluar.",
    'ui__mass-email/delete_multi__wizard-title' => "Pengalihkeluaran templat mesej e-mel massa",
    'ui__mass-email/delete_unknown__description' => "Alih keluar templat mesej e-mel massa.",
    'ui__mass-email/delete_unknown__short-title' => "Alih keluar",
    'ui__mass-email/delete_unknown__title' => "Alih keluar templat mesej e-mel massa",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Sahkan mengalih keluar templat dengan memilih kotak semak, dan kemudian klik Selesai untuk lengkapkan bestari.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Pilih templat mesej e-mel massa yang anda ingin alih keluar.",
    'ui__mass-email/delete_unknown__wizard-title' => "Pengalihkeluaran templat mesej e-mel massa.",
    'ui__mass-email/send__description' => "Hantar e-mel kepada penerima yang dipilih",
    'ui__mass-email/send__short-title' => "Hantar e-mel massa",
    'ui__mass-email/send__title' => "Hantar Mesej E-mel Massa",
    'ui__mass-email/send_main__description' => "Hantar e-mel kepada penerima yang dipilih",

    'ui__mass-email/send_main__short-title' => "Hantar e-mel massa",
    'ui__mass-email/send_main__title' => "Hantar mesej e-mel massa",
    'ui__mass-email/send_selectresellers__title' => 'Pilih penjual semula',
    'ui__mass-email/send_selectresellers__short-title' => 'Penjual semula',
    'ui__mass-email/send_selectresellers__description' => 'Pilih akaun penjual semula',

    'ui__mass-email/send_selectclients__description' => "Pilih akaun pelanggan",

    'ui__mass-email/send_selectclients__short-title' => "Pelanggan",
    'ui__mass-email/send_selectclients__title' => "Pilih pelanggan",
    'ui__mass-email/send_selectdomainusers__description' => "Pilih akaun pentadbir domain",

    'ui__mass-email/send_selectdomainusers__short-title' => "Pentadbir domain",
    'ui__mass-email/send_selectdomainusers__title' => "Pilih pentadbir domain",
    'ui__mass-email/template/properties_main__description' => "Cipta templat mesej e-mel massa",
    'ui__mass-email/template/properties_main__short-title' => "Edit templat",
    'ui__mass-email/template/properties_main__title' => "Edit templat mesej e-mel massa",
    'ui__mass-email/template/properties_new-main__description' => "Cipta templat mesej e-mel massa",
    'ui__mass-email/template/properties_new-main__short-title' => "Cipta templat mesej e-mel massa",
    'ui__mass-email/template/properties_new-main__title' => "Cipta templat mesej e-mel massa",
    'ui__mass-email/template/properties_new-selectclients__description' => "Pilih pelanggan yang akan menerima mesej e-mel massa berdasarkan templat ini",
    'ui__mass-email/template/properties_new-selectclients__title' => "Pilih pelanggan yang akan menerima mesej e-mel massa berdasarkan templat ini",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Pilih pentadbir domain yang akan menerima mesej e-mel massa berdasarkan templat ini.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Pilih pentadbir domain yang akan menerima mesej e-mel massa berdasarkan templat ini.",
    'ui__mass-email/template/properties_selectclients__title' => "Pilih pelanggan yang akan menerima mesej e-mel massa berdasarkan templat ini",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Pilih pentadbir domain yang akan menerima mesej e-mel massa berdasarkan templat ini.",

    'ui__mass-email/template/properties_unknown-new__description' => "Cipta templat mesej emel secara besar-besaran",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Cipta templat",
    'ui__mass-email/template/properties_unknown-new__title' => "Penciptaan templat mesej e-mel massa",
    'ui__news/dismiss__description' => 'Klik untuk menutup bingkai berita. Plesk tidak akan menunjukkan bingkai ini sehingga artikel berita dikemas kini.',

    'ui__news/dismiss__title' => 'Tutup berita',

    'ui__server__description' => 'Pengurusan Pelayan',
    'ui__server__short-title' => 'Urus pelayan anda',
    'ui__server__title' => 'Pengurusan pelayan',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'Alamat IP %1 tidak tersedia.',
    'ui__server/ip-address__none-available' => 'Tiada alamat IP.',
    'ui__server/ip-addresses/ip-address__title' => "Alamat IP",
    'ui__server/ip-address/client/properties_new__description' => "Memperuntukkan alamat IP %1 kepada penjual semula.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Memperuntukkan',
    'ui__server/ip-address/client/properties_new__title' => "Memperuntukkan alamat IP %1 kepada penjual semula.",
    'ui__server/ip-address/client__none-available' => 'Tiada akaun pengguna',
    'ui__server/ip-address/client_unknown__quick_search' => 'Pengguna',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Senarai pengguna yang guna alamat IP ini.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Sila pilih alamat IP.',
    'ui__server/ip-address/client/delete__description' => 'Batalkan peruntukan alamat IP dari penjual semula.',
    'ui__server/ip-address/client/delete__short-title' => 'Batalkan peruntukan',
    'ui__server/ip-address/client/delete__title' => 'Batalkan peruntukan alamat IP dari penjual semula',
    'ui__server/ip-address/client/delete_multi__description' => "Batalkan peruntukan alamat IP dari himpunan penjual semula.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Batalkan peruntukan',
    'ui__server/ip-address/client/delete_multi__title' => 'Batalkan peruntukan alamat IP dari penjual semula',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Alih keluar alamat IP dari himpunan pengguna.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Pilih alamat IP yang ingin anda batalkan peruntukan dari pengguna dan klik Seterusnya >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Pilih pengguna yang ingin dibatalkan peruntukan alamat IPnya dan klik Seterusnya >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Sahkan pembatalan peruntukan alamat IP dari pengguna dengan memilih kotak semak dan klik Selesai untuk lengkapkan bestari.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Batalkan peruntukan alamat IP dari penjual semula.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Batalkan peruntukan',
    'ui__server/ip-address/client/delete_unknown__title' => 'Batalkan peruntukan alamat IP dari penjual semula',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Batalkan peruntukan alamat IP dari pengguna',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Pilih alamat IP yang ingin anda batalkan peruntukan dari pengguna dan klik Seterusnya >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Pilih pengguna yang ingin anda batalkan peruntukan alamat IP dan klik Seterusnya >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Sahkan pembatalan peruntukan alamat IP dari pengguna dengan memilih kotak semak dan klik Selesai untuk lengkapkan bestari.',

    'ui__server/ip-address/domain__description' => "Semua Domain pada alamat IP %1",
    'ui__server/ip-address/domain__short-title' => "Domain",
    'ui__server/ip-address/domain__title' => "Domain pada alamat IP %1",
    'ui__server/ip-address/domain_unknown__description' => "Semua domain pada alamat IP",
    'ui__server/ip-address/domain_unknown__short-title' => "Domain",
    'ui__server/ip-address/domain_unknown__title' => "Domain pada alamat IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Pilih alamat IP yang diperlukan dan klik Seterusnya >>.",

    'ui__server/ip-address/properties__description' => 'Ubah sifat alamat IP %1.',
    'ui__server/ip-address/properties__short-title' => 'Sifat',
    'ui__server/ip-address/properties__title' => 'Ubah sifat alamat IP %1.',

    'ui__server/ip-address/properties_new__wizard-title' => 'Tambah alamat IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Apabila selesai mengubah sifat rekod alamat IP, klik Selesai untuk menggunakan perubahan.',
    'ui__server/ip-address/properties_unknown__description' => 'Ubah sifat alamat IP',
    'ui__server/ip-address/properties_unknown__short-title' => 'Sifat',
    'ui__server/ip-address/properties_unknown__title' => 'Ubah sifat alamat IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Ubah sifat alamat IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Pilih alamat IP yang sifat anda hendak ubah.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Apabila selesai mengubah sifat rekod alamat IP, klik Selesai untuk menggunakan perubahan.',

    'ui__server/spam-filter/black-list__description' => 'Sediakan senarai hitam untuk lebar pelayan penapis spam.',
    'ui__server/spam-filter/black-list__short-title' => 'Senarai hitam',
    'ui__server/spam-filter/black-list__title' => 'Senarai hitam untuk lebar pelayan penapis spam.',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Hanya %1 pertama alamat e-mel unik boleh ditambah.',
    'ui__server/spam-filter/black-list/address__description' => 'Penapis spam alamat senarai hitam.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Tiada alamat e-mel di dalam senarai.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Fail yang dimuat naik adalah kosong.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Alamat e-mel berikut adalah tidak sah: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Tiada alamat dalam penapis spam senarai hitam.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Alamat',
    'ui__server/spam-filter/black-list/address__title' => 'Senarai alamat hitam %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Tambah alamat ke senarai hitam.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Tambah Alamat',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Tambah alamat ke senarai hitam.',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Alih keluar %1 alamat daripada senarai hitam lebar pelayan.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Alih keluar',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Alih keluar %1 alamat daripada senarai hitam lebar pelayan.',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Alih keluar alamat dari senarai hitam lebar pelayan.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Alih keluar',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Alih keluar alamat dari senarai hitam lebar pelayan.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Alih keluar alamat dari senarai hitam penapis spam lebar pelayan',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Pilih alamat penapis spam yang ingin dialih keluar dan klik Seterusnya >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Sahkan mengalih keluar penapis spam dengan memilih kotak semak dan klik Selesai untuk mengalih keluar sepenuhnya dan keluar dari bestari.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Alih keluar alamat daripada senarai hitam lebar pelayan.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Alih keluar',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Alih keluar alamat daripada senarai hitam lebar pelayan.',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Alih keluar alamat dari senarai hitam penapis spam lebar pelayan',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Pilih alamat penapis spam yang ingin dialih keluar dan klik Seterusnya >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Sahkan mengalih keluar penapis spam dengan memilih kotak semak dan klik Selesai untuk mengalih keluar sepenuhnya dan keluar dari bestari.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Hanya %1 pertama alamat e-mel unik boleh ditambah.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Tiada alamat e-mel di dalam senarai.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Tidak dapat memuat naik fail. Saiz maksimum fail yang hendak dimuat naik ialah %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Alamat e-mel berikut adalah tidak sah: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Tambah alamat ke senarai hitam.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Tambah Alamat',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Tambah alamat ke senarai hitam.',

    'ui__server/spam-filter/properties__description' => 'Setkan tapisan spam lebar pelayan.',

    'ui__server/spam-filter/properties__short-title' => 'Tetapan',
    'ui__server/spam-filter/properties__title' => 'Tetapan penapis spam',

    'ui__server/spam-filter/toggle_disable__description' => 'Menyahdayakan penapisan spam untuk keseluruhan sistem.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Nyahdayakan',
    'ui__server/spam-filter/toggle_disable__title' => 'Menyahdayakan penapisan spam',
    'ui__server/spam-filter/toggle_enable__description' => 'Mendayakan penapisan spam untuk keseluruhan pelayan.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Mendayakan',
    'ui__server/spam-filter/toggle_enable__title' => 'Mendayakan penapisan spam',
    'ui__server/spam-filter/toggle_unknown__description' => 'Mendayakan atau menyahdayakan penapisan spam untuk keseluruhan pelayan.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Dayakan atau nyahdayakan',
    'ui__server/spam-filter/toggle_unknown__title' => 'Mendayakan atau menyahdayakan penapisan spam',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Mendayakan atau menyahdayakan penapis spam',

    'ui__server/spam-filter/white-list__description' => 'Tetapkan lebar sistem penapis spam senarai putih.',
    'ui__server/spam-filter/white-list__short-title' => 'Senarai putih',
    'ui__server/spam-filter/white-list__title' => 'Lebar sistem penapis spam senarai putih.',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Hanya %1 pertama alamat e-mel unik boleh ditambah.',
    'ui__server/spam-filter/white-list/address__description' => 'Penapis spam alamat senarai putih.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Tiada alamat e-mel di dalam senarai.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Fail yang dimuat naik adalah kosong.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Alamat e-mel berikut adalah tidak sah: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Tiada alamat dalam penapis spam lebar pelayan senarai putih.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Alamat',
    'ui__server/spam-filter/white-list/address__title' => 'Senarai alamat putih %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Tambah alamat ke senarai putih.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Tambah Alamat',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Tambah alamat ke senarai putih.',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Alih keluar %1 alamat daripada senarai putih lebar pelayan.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Alih keluar',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Alih keluar %1 alamat daripada senarai putih lebar pelayan.',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Alih keluar alamat daripada senarai putih lebar pelayan.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Alih keluar',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Alih keluar alamat daripada senarai putih lebar pelayan.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Alih keluar alamat dari senarai putih penapis spam lebar pelayan',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Pilih alamat penapis spam yang ingin dialih keluar dan klik Seterusnya >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Sahkan mengalih keluar penapis spam dengan memilih kotak semak dan klik Selesai untuk mengalih keluar sepenuhnya dan keluar dari bestari.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Alih keluar alamat daripada senarai putih lebar pelayan.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Alih keluar',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Alih keluar alamat daripada senarai putih lebar pelayan.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Alih keluar alamat dari senarai putih penapis spam lebar pelayan',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Pilih alamat penapis spam yang ingin dialih keluar dan klik Seterusnya >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Sahkan mengalih keluar penapis spam dengan memilih kotak semak dan klik Selesai untuk mengalih keluar sepenuhnya dan keluar dari bestari.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Hanya %1 pertama alamat e-mel unik boleh ditambah.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Tiada alamat e-mel di dalam senarai.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Tidak dapat memuat naik fail. Saiz maksimum fail yang hendak dimuat naik ialah %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Alamat e-mel berikut adalah tidak sah: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Tambah alamat ke senarai putih.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Tambah Alamat',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Tambah alamat ke senarai putih.',

    'ui__server/mail/statistics#apply__description' => "Gunakan penapis",
    'ui__server/mail/statistics#apply__title' => "Guna",
    'ui__server/mail/statistics#custom_from__title' => "dari",
    'ui__server/mail/statistics#custom_to__title' => "kepada",
    'ui__server/mail/statistics#period_all__title' => "Semua",
    'ui__server/mail/statistics#period_custom__title' => "Tersuai",
    'ui__server/mail/statistics#period_month__title' => "Bulan semasa",
    'ui__server/mail/statistics#period_prev_month__title' => "Bulan sebelum",
    'ui__server/mail/statistics#period_prev_week__title' => "Minggu sebelum",
    'ui__server/mail/statistics#period_today__title' => "Hari ini",
    'ui__server/mail/statistics#period_week__title' => "Minggu semasa",
    'ui__server/mail/statistics#period_yesterday__title' => "Semalam",
    'ui__server/mail/statistics#show_for_period__title' => "Tunjukkan bagi tempoh",
    'ui__server/mail/statistics#tools_legend__title' => "Alat",
    'ui__server/mail/statistics__description' => "Lihat statistik virus dan spam",

    'ui__server/mail/statistics__short-title' => "Statistik",
    'ui__server/mail/statistics__title' => "Statistik",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Statistik spam",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Alat",
    'ui__server/mail/statistics/spam__description' => "Lihat statistik spam",

    'ui__server/mail/statistics/spam__short-title' => "Statistik spam",
    'ui__server/mail/statistics/spam__title' => "Statistik spam",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Nama mel",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% daripada semua",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Isih mengikut akaun mel",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Isih mengikut % daripada semua",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Isih mengikut recived spam",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "akaun mel",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Recived spam",
    'ui__server/mail/statistics/spam/recipients__description' => "Penerima",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Penerima",
    'ui__server/mail/statistics/spam/recipients__title' => "Penerima",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Bersih",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Dijangkiti",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% daripada semua",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Kira",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Dilindungi",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Tidak disemak",
    'ui__server/mail/statistics/spam/summary__description' => "Ringkasan",

    'ui__server/mail/statistics/spam/summary__short-title' => "Ringkasan",
    'ui__server/mail/statistics/spam/summary__title' => "Ringkasan",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Statistik virus",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Alat",
    'ui__server/mail/statistics/virus__description' => "Lihat statistik virus",

    'ui__server/mail/statistics/virus__short-title' => "Statistik virus",
    'ui__server/mail/statistics/virus__title' => "Statistik virus",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Akaun mel",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% daripada semua",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Isih mengikut nama mel",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Isih mengikut % daripada semua",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Isih mengikut recived virus",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Akaun mel",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Recived virus",
    'ui__server/mail/statistics/virus/recipients__description' => "Penerima",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Penerima",
    'ui__server/mail/statistics/virus/recipients__title' => "Penerima",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Bersih",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Dijangkiti",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% daripada semua",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Kira",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Dilindungi",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Tidak disemak",
    'ui__server/mail/statistics/virus/summary__description' => "Ringkasan",

    'ui__server/mail/statistics/virus/summary__short-title' => "Ringkasan",
    'ui__server/mail/statistics/virus/summary__title' => "Ringkasan",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Nama",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% daripada semua",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Isih mengikut nama",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Isih mengikut % daripada semua",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Isih mengikut objek yang dijangkiti",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Virus",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Objek yang dijangkiti",
    'ui__server/mail/statistics/virus/viruses__description' => "Virus",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Virus",
    'ui__server/mail/statistics/virus/viruses__title' => "Virus",

    'ui__support#param_company__title' => "Syarikat",
    'ui__support#param_email__title' => "E-mel",
    'ui__support#param_firstname__title' => "Nama pertama",
    'ui__support#param_keynumber__title' => "Nombor kunci produk",
    'ui__support#param_operatingsystem__title' => "Sistem pengendalian",
    'ui__support#param_phone__title' => "Telefon",
    'ui__support#param_psabuild__title' => "Binaan Plesk",
    'ui__support#param_psainsttype__title' => "Jenis pemasangan Plesk",
    'ui__support#param_psaversion__title' => "Versi Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Alat",

    'ui__reseller/traffic-history_unknown__short-title' => "Papar trafik oleh Penjual semula",
    'ui__reseller/traffic-history_unknown__title' => "Papar trafik oleh Penjual semula",
    'ui__reseller/traffic-history_unknown__description' => "Papar trafik oleh akaun penjual semula.",
    'ui__reseller#list__title' => "Penjual semula",
    'accounts_list__name__filter_title' => "Nama",
    'accounts_list__resource__filter_title' => "Penggunaan sumber",
    'resellers_list__filter_resource_usage_any' => "Sebarang",
    'resellers_list__filter_resource_usage_overuse' => "Lebih guna",
    'resellers_list__filter_resource_usage_normal' => "Dalam had",
    'accounts_list__status__filter_title' => "Status",
    'resellers_list__filter_status_any' => "Sebarang",
    'resellers_list__filter_status_blocked' => "Digantung",
    'resellers_list__filter_status_active' => "Aktif",
    'resellers_list__filter_clients__filter_title' => "Tunjukkan",
    'resellers_list__filter_clients_on' => "Penjual semula dengan pelanggan mereka",
    'resellers_list__filter_clients_off' => "Penjual semula",
    '__disk_usage' => "Ruang cakera digunakan.",
    'ui__reseller/traffic_unknown__short-title' => "Papar trafik oleh Penjual semula",
    'ui__reseller/traffic_unknown__title' => "Papar trafik oleh Penjual semula",
    'ui__reseller/traffic#list__title' => "Trafik oleh penjual semula",
    'ui__reseller/traffic_unknown__description' => "Papar penggunaan laporan trafik.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Trafik oleh penjual semula",

    '__reseller_name' => "Nama penjual semula",
    '__reseller' => "Penjual semula",
    'resellertrafficlist_header' => "Papar trafik oleh Penjual semula",
    '__reseller_personal' => "Trafik yang digunakan oleh domain penjual semula",
    'ui__reseller/traffic-history__short-title' => "Trafik oleh penjual semula",
    'ui__reseller/traffic-history__title' => "Trafik oleh penjual semula",
    'ui__reseller/traffic-history__description' => "Papar penggunaan laporan trafik.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Benarkan lebihan jualan",
    'limits__reseller_oversell_description' => "Lebihan jualan membolehkan penjual semula untuk menjual lebih banyak sumber daripada yang sebenarnya diperuntukkan kepada beliau. Jika lebihan jualan dibenarkan, penjual semula yang ditadbir oleh penggunaan sumber sebenar dan bukannya peruntukan sumber awal",
    'limits__overuse_block_text' => "Dasar lebih guna",
    'limits__overuse_block_true_text' => "Lebih guna tidak dibenarkan",
    'limits__reseller_overuse_block_true_description' => "Sekat penggunaan lebih guna sumber. Penggunaan sumber sebenar tidak boleh melebihi peruntukan sumber awal",
    'limits__overuse_block_false_text' => "Lebih guna dibenarkan",
    'limits__reseller_overuse_block_false_description' => "Jangan menghalang penggunaan berlebihan sumber, membolehkan penjual semula untuk menggunakan lebih banyak sumber berbanding disediakan pada mulanya. Penggunaan sumber sebenar boleh melebihi peruntukan sumber awal",
    'limits__reseller_overuse_notify_text' => "Beritahu penjual semula tentang mencapai had sumber",
    'reseller_perm__manage_sh_access_disabled' => "Penjual semula tidak boleh benarkan atau melarang akses cangkerang",
    'reseller_perm__manage_sh_access_chrooted' => "Penjual semula boleh benarkan akses hanya kepada persekitaran yang chrooted",
    'reseller_perm__manage_sh_access_any' => "Penjual semula boleh benarkan akses pada mana-mana jenis cangkerang",
    'template__reseller_num_excl_ips' => "Memperuntukkan alamat IP khusus kepada penjual semula",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Akaun",
    'ui__reseller#info__title' => "Maklumat",
    'ui__reseller#clientsTab__title' => "Pelanggan",
    'ui__reseller#domainsTab__title' => "Domain",
    'ui__reseller__title' => "Urus %1 akaun penjual semula",
    'domains__reseller_info' => "%1 pelanggan, %2 domain, %3 ruang cakera yang digunakan, %4 daripada data dipindahkan.",
    'domains__reseller_info_hiding_traffic' => "%1 pelanggan, %2 domain, %3 ruang cakera yang digunakan.",
    'ui__reseller__description' => "Urus akaun penjual semula.",

    'ui__reseller/limits_unknown__wizard-title' => 'Papar atau ubah had sumber untuk penjual semula',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Pilih penjual semula yang anda perlukan.',
    'ui__reseller/limits_unknown__wizard__2' => 'Untuk menggunakan perubahan, klik Selesai.',

    'ui__client/report_reseller__short-title' => "Laporan",
    'ui__client/report_reseller__title' => "Papar Laporan Akaun",
    'ui__client/report_reseller__description' => "Papar laporan akaun penjual semula",
    'ui__client/ip-pool_reseller__short-title' => "Himpunan IP",
    'ui__client/ip-pool_reseller__description' => "Memperuntukkan alamat IP dan sijil SSL/TLS untuk akaun penjual semula.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Tentukan tetapan akaun dan klick Selesai.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Papar atau ubah kebenaran untuk penjual semula',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Pilih penjual semula yang mana kebenaran anda ingin papar atau ubah.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Apabila selesai dengan mengubah penjual semula kebenaran, klik Selesai untuk menggunakan perubahan dan keluar dari bestari',

    // Customers > create customer account

    '__resellers_list' => 'Penjual semula',
    'picker_reseller__title' => 'Pilih penjual semula',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Alat",
    'ui__client#tools2__title' => "Akaun",
    'ui__client#info__title' => "Maklumat",
    'ui__client#clientslist__title' => "Pelanggan",
    'ui__client#domainslist__title' => "Domain",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Semua aplikasi web sekarang diisihkan mengikut kategori, bagi memudahkan untuk memilih aplikasi yang betul untuk dipasang.",
    'feature__domainkeys__reseller' => "Anda boleh menggunakan mekanisma pengesahan penghantar e-mel DKIM untuk mengurangkan jumlah spam dan e-mel pemalsuan.",

    '__reseller_form' => "Penjual semula dari",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Pilih akaun pelanggan yang mana tetapan yang anda mahu tukar.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Untuk ubah had penggunaan sumber, klik had Sumber.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Untuk menukar kebenaran untuk operasi pelanggan boleh melakukan di Plesk, klik Kebenaran.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Membuat templat ini boleh didapati kepada pengguna lain",
    'template__shared_description' => "Pilih pilihan ini jika anda ingin pelanggan anda untuk dapat menggunakan templat ini.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Alat',

    'ui__client/traffic-history_unknown__short-title' => 'Papar trafik oleh Pelanggan',
    'ui__client/traffic-history_unknown__title' => 'Trafik mengikut pelanggan',
    'ui__client/traffic-history_unknown__description' => 'Papar semua laporan penggunaan trafik pelanggan',
    'ui__client/traffic-history__short-title' => 'Trafik mengikut pelanggan',
    'ui__client/traffic-history__title' => 'Papar trafik oleh Pelanggan',
    'ui__client/traffic-history__description' => 'Papar semua laporan penggunaan trafik pelanggan',

    'ui__client/traffic#list__title' => 'Trafik mengikut pelanggan',
    'ui__reseller/client/traffic#list__title' => 'Trafik mengikut pelanggan',

    'clients_list__filter_type__filter_title' => 'Tunjukkan',
    'clients_list__filter_type_any' => 'Pelanggan dan penjual semula',
    'clients_list__filter_type_clients' => 'Pelanggan sahaja',
    'clients_list__filter_type_resellers' => 'Penjual semula',
    'ui__client/domain_unknown-new__short-title' => "Cipta Domain",

    // Customers > View traffic by customers
    '__personal' => "Trafik yang digunakan mengikut domain pengguna",
    'PersonalTrafficList_header_of_client__' => "Papar Laporan Penggunaan Trafik untuk Akaun Anda",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Pentadbir domain tidak boleh benarkan atau melarang akses cangkerang",
    'domain_perm__manage_sh_access_chrooted' => "Pentadbir domain boleh benarkan akses hanya kepada persekitaran yang di chroot",
    'domain_perm__manage_sh_access_any' => "Pentadbir domain boleh benarkan akses kepada mana-mana jenis cangkerang",

    // APS Catalog
    'bt_add_to_vault' => "Tambah ke Ruang Simpan",
    'bt_hide_updates' => "Sembunyi kemas kini tersedia",
    'bt_show_updates' => "Papar Kemas Kini Tersedia",

    '__site_apps__applications' => "Aplikasi",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Aplikasi dipilh untuk ruang simpan tambahan",
    'site_apps__application_selected' => "Dipilih",
    'site_apps__currently_in_vault' => "Versi lain sudah di dalam ruang simpan ini:",
    'site_apps__new_versions' => "Versi baru:",
    'site_apps__patches' => "Tampalan:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Bilangan aplikasi dijadualkan untuk tambah ruang simpan: %1",
    'site_apps__applications_downloading_now' => "Aplikasi berikut kini dimuat turun: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Telah sedia di dalam ruang simpan",

    // Server > Action Log
    'bt_skin_edit' => "Edit Perihalan Kulit",
    'domains__you_want_change_the_status_of_the_reseller??' => "Adakah anda yakin mahu mengubah status akaun penjual semula?",
    'limits__oversell_legend' => "Lebihan jualan",
    'limitsManager__limit_available_error' => "Tidak dapat memperuntukkan jumlah sumber yang diperlukan (%%quantity%% %%limitName%%). Hanya %%available%% %%limitName%% tersedia.",
    'limitsManager__limit_reserved_error' => "Tidak dapat menetapkan had penggunaan sumber yang diperlukan (%%quantity%% %%limitName%%) kerana nilai baru adalah kurang daripada jumlah sumber yang dikhaskan untuk pelanggan anda atau digunakan oleh anda sendiri (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Tidak dapat menetapkan had penggunaan sumber yang diperlukan (%%quantity%% %%limitName%%) kerana nilai baru adalah kurang daripada jumlah sebenar sumber telah digunakan oleh akaun dan tapak anda (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Penggunan lebar jalur mengikut perkhidmatan",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Papar Penggunaan Laporan Trafik",
    'ui__client/domain/traffic_unknown-reseller__title' => "Papar Penggunaan Laporan Trafik",

    'ui__client/domain_new__short-title' => "Cipta Domain",

    'ui__client_reseller__description' => "Urus akaun penjual semula %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Urus akaun penjual semula",

    '__owner_name' => "Nama pemilik",
    'domains_list__resource__filter_title' => "Penggunaan Sumber",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Katalog aplikasi APS",
    'site_apps__applications_have_updates' => "Versi dikemas kini bagi aplikasi berikut adalah tersedia:\n%1\nUntuk papar kemas kini, pastikan kawasan Carian boleh dilihat, pilih <b>Tunjukkan kemas kini sahaja</b> Kotak semak dan carian untuk aplikasi yang diperlukan anda.",
    'site_apps__progress_adding_to_vault' => "Menambahkan pada ruang simpan:",
    'site_apps__progress_done_message' => "Kemajuan:",
    'site_apps__progress_applications_left' => "%1 daripada %2 aplikasi yang tinggal",
    'site_apps__download_item_long_task_title' => "Muat turun aplikasi APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Muat turun aplikasi APS dari Katalog APS",
    'site_apps__last_check_for_updates' => "semakan terakhir untuk mengemaskini: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Semua aplikasi jadual berjaya ditambah ke ruang simpan aplikasi",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 aplikasi yang dijadualkan berjaya ditambah ke Ruang simpan Aplikasi",
    'site_apps__no_search_results' => 'Tiada aplikasi ditemui. Cuba minta carian yang berbeza atau aplikasi pelayar mengikut kategori.',
    'site_apps__search_results_title' => 'Hasil carian',
    '__site_apps__search_by_application' => 'Nama aplikasiPangkalan data lalai untuk sumber data ODBC',
    '__site_apps__search_by_vendor' => 'Vendor',
    '__site_apps__search_by_vendor__all' => 'Semua vendor',
    '__site_apps__search_by_packager' => 'Dipakej',
    '__site_apps__search_by_certification_level' => 'Tahap perakuan',
    '__site_apps__search_by_cert__any' => 'Sebarang',
    '__site_apps__search_by_cert__silver_and_higher' => 'Perak dan lebih tinggi',
    '__site_apps__search_by_cert__gold_and_higher' => 'Emas dan lebih tinggi',
    '__retry' => 'Cuba Semula',
    'site_apps__application_packager_site' => 'Dipakej',
    'site_apps__add_to_pool_message' => "Aplikasi yang ditandakan sebagai \"available for all\" secara automatik diagihkan kepada semua penjual semula dan pelanggan dengan jumlah pemasangan yang tidak terhad. Aplikasi terhad diedarkan secara manual kepada semua penjual semula dan pelanggan secara individu dengan jumlah pemasangan tersedia yang dinyatakan dengan jelas.",
    'site_apps__make_available_for_all' => "Membuat aplikasi yang dipilih tersedia kepada semua pengguna",

    'site_apps__broadcast_app_text' => "Aplikasi yang ditandakan sebagai \"available for all\" secara automatik diagihkan kepada semua penjual semula dan pelanggan dengan jumlah pemasangan yang tidak terhad. Aplikasi terhad diedarkan secara manual kepada semua penjual semula dan pelanggan secara individu dengan jumlah pemasangan tersedia yang dinyatakan dengan jelas.",
    'site_apps__broadcast_app_name' => 'Membuat aplikasi tersedia kepada semua pengguna',

    // User Application Pool per application
    'site_apps__available_clients' => 'Pengguna tersedia',
    'site_apps__no_more_clients_to_add_to_pool' => 'Tiada lagi akaun pengguna yang anda boleh sediakan bagi aplikasi ini',

    // Installed application instances
    'site_apps__installations' => 'Pemasangan',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Nama domain dan alamat IP",
    '__assign_ip_address' => "Alamat IP memperuntukkan",
    '__switch_on_service' => "Perkhidmatan dihidupkan",
    '__hosting_configuration' => "Konfigurasi pengehosan",
    '__vrt_hst' => "Pengehosan tapak web",
    '__vrt_hst_hint' => "Hoskan tapak web pada pelayan ini.",
    '__fwd' => "Pemajuan",
    '__web_hosting_settings' => "Tetapan pengehosan",
    '__fwd_hint' => "Ubah hala pengunjung ke tapak web yang lain.",
    '__none_hint' => "Jangan menghoskan tapak web pada masa ini.",
    '__login_hint' => "Nama pengguna ini digunakan untuk akses tapak web anda melalui FTP",
    '__password_hint' => "Kata laluan ini digunakan untuk akses tapak web anda melalui FTP",
    '__advanced_hosting_setup' => "Konfigurasi tetapan tapak web pengehosan lanjutan",
    '__domain_creation_successful' => "Domain telah dicipta.",
    'bt_hosting_settings' => "Tetapan Pengehosan",
    '__change_hosting_type' => "Ubah jenis pengehosan untuk domain %1",
    '__hosting_type_change_warning' => "Apabila anda menukar jenis pengehosan untuk pemajuan atau tiada pengehosan, semua fail dan direktori yang berkaitan dengan tapak web anda dikeluarkan dari pelayan. Pastikan anda menyimpan salinan setempat laman web anda.",
    '__current_hosting_type' => "Jenis pengehosan semasa",
    '__new_hosting_type' => "Jenis pengehosan baru",
    '__fwd_settings' => "Tetapan pemajuan",
    '__fwd_settings_legend' => "Tetapan pemajuan",
    '__fwd_destination_url' => "URL destinasi",
    '__fwd_type' => "Jenis pemajuan",
    '__fwd_type_standart' => "Pemajuan standard",
    '__fwd_type_standart_hint' => "Ubah hala tapak web pengunjung ke tapak yang lain tunjukkannya alamat destinasi, jadi mereka tahu tentang penghalaan semula",
    '__fwd_type_frame' => "Pemajuan bingkai",
    '__fwd_type_frame_hint' => "Mengubah hala tapak web pengunjung ke tapak lain, tetapi jangan tunjukkan mereka alamat destinasi, oleh itu, mereka tidak tahu tentang penghalaan semula.",
    '__hosting_type_template_warning' => "Jenis pengehosan yang anda pilih adalah berbeza daripada jenis yang dinyatakan dalam templat. Jika anda teruskan, tetapan web pengehosan dalam templat yang dipilih akan diabaikan. Adakah anda pasti anda mahu tetapkan jenis pengehosan dipilih?",

    '__no_resellers_selected' => "Anda mesti pilih sekurang-kurangnya satu akaun penjual semula.",

    'ui__client/logo_unknown__wizard-title' => 'Sediakan logo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Sila pilih pelanggan yang sifat logi anda mahu ubah.',
    'ui__client/logo_unknown__wizard__2' => 'Klik Selesai untuk menggunakan perubahan.',
    'ui__client/logo_unknown__wizard__2_self' => 'Klik Selesai untuk menggunakan perubahan.',

    'ui__client/ipaddress/properties_new__short-title' => "Tambah Alamat IP",
    'ui__client/ipaddress/properties_new__title' => 'Tambah Alamat IP',
    'ui__client/ipaddress/properties_new__description' => "Tambah alamat IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Tambah Alamat IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "Tambah Alamat IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "Tambah Alamat IP",
    'ui__client/ipaddress/delete_multi__short-title' => "Alih Keluar Alamat IP",
    'ui__client/ipaddress/delete_multi__description' => "Alih keluar alamat IP.",
    'ippool_Manager__no_available_ips' => "Tiada alamat IP kosong dalam himpunan IP.",
    'ippool_Manager__ip_shared' => "kongsi",
    'ippool_Manager__ip_exclusive' => "khusus",
    'ui__client/ipaddress/properties__title' => "Urus Aamat IP",
    'ui__client/ipaddress/properties__description' => "Papar atau ubah sifat alamat IP.",
    'ui__client/ipaddress_unknown-new__title' => "Tambah Alamat IP",
    'ui__client/ipaddress_unknown-new__short-title' => "Tambah Alamat IP",
    'ui__client/ipaddress_unknown-new__description' => "Tambah alamat IP.",

    'ui__mass-mail#to_resellers_text__title' => "Penjual semula",
    'ui__mass-mail#to_domainusers_text__title' => "Pentadbir domain",
    'ui__mass-email#tools_legend__title' => "Alat",
    'ui__mass-email#list_legend__title' => 'Mesej e-mel massa templat mesej',
    'ui__mass-email#template_legend__title' => "Templat",
    'ui__mass-email#from_email_text__title' => "Dari",
    'ui__mass-email#to_text__title' => 'Kepada',
    'ui__mass-email#to_resellers_text__title' => "Penjual semula",
    'ui__mass-email#to_clients_text__title' => "Pelanggan",
    'ui__mass-email#to_domainusers_text__title' => "Pentadbir domain",
    'ui__mass-email#to_admin_text__title' => "Pentadbir Plesk",
    'ui__mass-email#option_mode_all__title' => "Semua",
    'ui__mass-email#option_mode_select__title' => "Hanya dipilih",
    'ui__mass-email#option_mode_except__title' => "Semua kecuali dipilih",
    'ui__mass-email#option_select_template__title' => '---Pilih templat---',
    'ui__mass-email#subject_text__title' => "Subjek",
    'ui__mass-email#body_text__title' => "Teks mesej",
    'ui__mass-email#save_as_legend__title' => "Simpan sebagai templat",
    'ui__mass-email#save_as_text__title' => "Simpan mesej dikarang kepada templat baru yang dinamakan",
    'ui__reseller/preferences_unknown__wizard-title' => "Ubah Tetapan Akaun",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Pilih penjual semula yang tetapan akaun yang anda mahu ubah dan klik Seterusnya.",
    'ui__reseller/preferences_unknown__wizard__2' => "Tentukan tetapan akaun dan klik OK.",
    'ippoolManager__ip_shared' => "kongsi",
    'ippoolManager__ip_exclusive' => "khusus",

    '__users_list' => "Pengguna",
    '__users' => "Pengguna",
    '__user_name' => "Nama pengguna",

    'limit__name_max_dom_aliases' => "alias domain",
    'limit__name_max_subftp_users' => "akaun FTP tambahan",
    'limit__name_max_mssql_db' => "Pengkalan data Pelayan SQL Microsoft",
    'limit__name_max_iis_app_pools' => "Himpunan aplikasi IIS",
    'limit__name_max_odbc' => "Sambungan ODBC",
    'total_mboxes_quota_unsupported' => 'tidak disokong oleh pelayan mel',
    'limit_soft__disk_space' => 'Beritahu apabila mencapai ruang cakera',
    'limit_soft__max_traffic' => 'Beritahu apabila mencapai trafik',
    'dsr__of_reseller_title' => "Penggunaan Sumber oleh Domain",
    'limitsManager__commit_failed' => "Tidak boleh mengubah had sumber.",
    'limitsManager__date_in_past' => "Tarikh tamat tempoh tidak betul %1",
    'limitsManager__limit_not_supported' => "Had untuk jenis sumber %1 tidak dapat ditetapkan.",
    'limitsManager__limit_oversell_inconsistency' => "Tidak dapat memperuntukkan jumlah sumber yang ditetapkan kerana lebihan jualan dimatikan.",
    'limitsManager__limit_overuse_inconsistency' => "Penggunaan sumber melebihi had yang ditetapkan.",
    'limitsManager__no_resource_available' => "Tiada lagi sumber dari jenis ini (%%limitName%%) yang tinggal. Diminta: %%quantity%%; tersedia: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Tiada sumber dari jenis ini (%%limitName%%) yang tersedia dari pembekal perkhidmatan anda. Diminta: %%quantity%%; tersedia: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Tarikh tamat tempoh mestilah kurang daripada atau sama dengan %1.",
    'limitsManager__invalid_disk_space_limit' => "Jumlah ruang cakera mestilah kurang daripada atau sama dengan %1.",
    'limitsManager__invalid_max_traffic_limit' => "Jumlah trafik mestilah kurang daripada atau sama dengan %1.",
    'ippoolManager__ip_has_suballocations' => "Tidak dapat mengubah jenis alamat IP yang telah diperuntukkan kepada pengguna. Alamat IP %%ip%% telah diperuntukkan kepada pengguna sebagai %%reserved%% alamat IP.",
    'ippoolManager__ip_is_already_in_pool' => "Alamat IP ini telah diperuntukkan kepada pengguna.",
    'ippoolManager__ip_is_not_in_pool' => "Tiada alamat IP %%ip%% di dalam himpunan.",
    'ippoolManager__can_not_allocate_ip' => "Alamat IP %%ip%% tersedia hanya sebagai %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "Alamat IP %%ip%% tidak boleh diperuntukkan sebagai khusus.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Alamat IP %%ip%% telah digunakan untuk pengehosan.",
    'ippoolManager__active_anon_ftp_on_ip' => "Akses FTP awanama telah dihidupkan untuk alamat IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Tiada alamat IP kosong.",
    'ippoolManager__no_available_ips' => "Tiada alamat IP tersedia.",
    'templates__dublicate_name' => "Templat dengan nama tersebut telah wujud. Sila pilih nama lain untuk templat ini.",
    'cl_perm__client_limits_exceeded' => "Nilai had sumber yang ditetapkan melebihi nilai yang dibenarkan oleh pelan pengehosan anda atau nilai tersebut memperuntukkan sumber kurang daripada yang diperlukan oleh tapak anda.",
    'cl_perm__reseller_limits_exceeded' => "Nilai had sumber yang ditetapkan melebihi nilai yang dibenarkan oleh pelan pengehosan anda atau nilai tersebut memperuntukkan sumber kurang daripada yang diperlukan oleh akaun pengguna dan tapak.",

    'site_apps__preferences_show_all_versions_title' => "Tunjukkan senarai penuh versi untuk setiap aplikasi yang didapatkan semula daripada katalog",
    'site_apps__preferences_show_all_versions_hint' => "Jika pilihan ini dipilih, ia mungkin mengambil masa untuk mendapatkan semula semua versi setiap aplikasi setiap kali anda membuka katalog. Jika pilihan ini tidak dipilih, hanya versi terkini ditunjukkan.",
    '__select_user_template' => "Cipta akaun pengguna berdasarkan pada templat",
    'ip_already_added_to_all_clients' => "Alamat IP ini telah diuntukkan kepada semua pengguna.",
    'ui__server/ip-address/client/delete#legend__description' => "Alamat IP berikut akan dialih keluar dari sistem dan himpunan IP pengguna:",

    'site_apps__cancelled_apps' => "Anda telah batalkan tambah bagi aplikasi berikut: %2",

    'sb_url_is_not_resolved' => 'URL tidak dapat diselesaikan: semak tetapan DNS anda. URL %1 mesti diselesaikan dalam alamat IP pelayan dengan Presence Builder yang dipasang.',

    'ip_addr__is_last_on_interface' => 'Tidak boleh mengalih keluar alamat IP %%ip%% kerana ia adalah alamat IP terakhir yang ada pada antara muka rangkaian.',
    'ip_addr__used_for_current_session' => 'Tidak boleh mengalih keluar alamat IP %%ip%% kerana ia sedang digunakan oleh sesi aktif.',
    'ip_addr__used_for_hosting' => 'Tidak boleh mengalih keluar alamat IP %%ip%% kerana ia digunakan untuk menghos tapak web.',
    'ip_addr__is_main' => 'Tidak boleh mengalih keluar alamat IP %%ip%% kerana ia adalah alamat IP utama bagi antara muka rangkaian.',
    'ip_addr__ip_used_by_message_submission' => 'Tidak boleh mengalih keluar alamat IP %%ip%% kerana ia digunakan untuk penghantaran mesej mel',

    // RESELLER ACTION LOG

    '__cl_domains' => 'Domain pelanggan',
    'excl_ip_num' => 'Alamat IP khusus',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder tidak dipasang.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Kebenaran untuk membenarkan banyak menjual tidak boleh dibatalkan daripada pengguna di mana pengguna telah memperuntukkan lebih daripada sumber yang ada, pergi ke mod lebih jual.',
    'limitsManager__invalid_limit_value' => 'Nilai salah %%value%% specified for limit %%limit_name%%',
    'confirmationForm_default_agreement_text' => 'Sahkan operasi',
    'confirmationForm_default_confirm_message' => 'Sila sahkan operasi.',
    'limit__max_mn' => 'Bilangan maksimum akaun mel',

    'limits__client_overuse_description' => 'Dasar berlebihan memberitahu Plesk apa yang perlu dilakukan apabila penggunaan sumber melebihi peruntukan sumber awal.',
    'limits__client_overuse_block_true_description' => 'Sekat penggunaan lebih guna sumber. Penggunaan sumber sebenar tidak boleh melebihi peruntukan sumber awal',
    'limits__client_overuse_block_false_description' => 'Jangan menghalang penggunaan berlebihan sumber, membenarkan pelanggan untuk menggunakan lebih banyak sumber berbanding disediakan pada mulanya. Penggunaan sumber sebenar boleh melebihi peruntukan sumber awal',
    'limits__client_overuse_notify_text' => 'Maklumkan pelanggan mengenai mencapai had sumber',

    'limits__domain_overuse_description' => 'Dasar berlebihan memberitahu Plesk apa yang perlu dilakukan apabila penggunaan sumber melebihi peruntukan sumber awal.',
    'limits__domain_overuse_block_true_description' => 'Dasar lebih guna memberitahu apa yang perlu dilakukan oleh Plesk apabila sumber digunakan berlebihan.',
    'limits__domain_overuse_block_false_description' => 'Jangan menghalang penggunaan berlebihan sumber, membenarkan domain untuk menggunakan lebih banyak sumber berbanding disediakan pada mulanya. Penggunaan sumber sebenar boleh melebihi peruntukan sumber awal',
    'limits__domain_overuse_notify_text' => 'Maklumkan pemilik domain tentang mencapai had sumber',


    'cancel_remove' => 'Buang sebarang perubahan dan kembali ke halaman sebelumnya.',
    'php_not_installed' => 'PHP tidak dipasang',

    'dns__dns_rr_delete' => 'Item yang akan dialih keluar',
    'dns__delete_rr' => 'Rekod DNS yang berikutnya akan dialih keluar dari zon DNS:',
    'dns__dns_rr_delete_non_removable' => 'Item yang tidak dapat dialih keluar',
    'dns__non_delete_rr' => 'Rekod DNS berikut tidak dapat di alih keluarkan:',
    'dns__dns_rr_delete_confirm_message' => 'Sahkan alih keluar rekod DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Tidak diketahui format aplikasi web: aplikasi web mungkin tidak tersedia untuk pemasangan dan penggunaan.',

    '__php_handler_type_desc' => 'PHP jalanan sebagai',
    'sfdk_domain_sign__failed' => 'Ralat tidak diketahui telah berlaku ketika cuba untuk hidupkan tandatangan mel dengan DKIM pada domain. Rujuk kepada log ralat pelayan untuk maklumat lanjut.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Pemberitahuan berjaya mengemas kini kunci Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Pemberitahuan penundaan kemas kini kunci Plesk.',
    'pkey_notify__subj_update_error_notification' => 'Pemberitahuan ralat kemas kini kunci Plesk.',
    'pkey_notify__update_successful' => '%1 kemas kini telah lengkap jayanya.',
    'pkey_notify__update_failed_no_more_try' => 'Tidak dapat mengemas kini %1. Kunci yang anda sedang cuba hantar tidak sah. Anda tidak boleh cuba kemas kini kunci ini lagi.',
    'pkey_notify__update_failed_try_later' => 'Tidak dapat untuk mengemas kini %1: ralat berlaku semasa kunci anda diproses. Anda boleh mencuba untuk mendapatkan semula kunci secara manual dalam Plesk (Alatan & Settings>Maklumat Lesen) atau biarkan Plesk cuba mengemas kininya dalam masa 24 jam yang berikut. Jika anda tidak mahu menerima pemberitahuan ini lagi, alih keluar kunci ini dari Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Tidak dapat mematikan lebar pelayan penapisan spam.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Tidak dapat menghidupkan lebar pelayan penapisan spam.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Penjual semula ini',
    'report_auto__select_reseller_report_all' => 'Semua penjual semula',
    'report_auto__select_reseller_report_client' => 'Semua penjual semula dari pelanggan ini',
    'report_auto__select_reseller_report_current' => 'Penjual semula ini',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Semua pelanggan dari penjual semula ini',
    'report_auto__select_client_report_client' => 'Pelanggan ini',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'Penjual semula, pelanggan dan domain',

    'rpt_reseller_section_full_domains' => 'Domain',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBox',
    'rpt_reseller_dom_redirects' => 'Pemaju',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Pelanggan',
    '__cl_name' => 'Nama pelanggan',
    '__cl_creation_date' => 'Tarikh ciptaan',
    '__clients_traffic' => 'Trafik pelanggan',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder tidak dipasang.',
    'sitebuilder_disabled' => 'Presence Builder adalah matikan.',
    'b_sitebuilder_disabled' => 'Presence Builder adalah matikan.',
    'webmail_not_installed' => 'Perisian Mel Web tidak dipasang.',
    'webmail_disabled' => 'Perkhidmatan web mel adalah dimatikan.',
    'spamassassin_not_installed' => 'SpamAssassin adalah tidak dipasang.',
    // pfu:
    'anonymous_ftp_shared' => 'Tidak dapat sediakan FTP awanama: jenis alamat IP kongsi.',
    'anonymous_ftp_used' => 'Tidak dapat sediakan FTP awanama: alamat IP tersebut digunakan oleh domain lain untuk perkhidmatan FTP awanama.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET tidak dipasang.',
    'site_builder_no_package' => 'Presence Builder tidak tersedia Sila pastikan bahawa Presence Builder dipasang dan dipilih sebagai komponen yang aktif.',
    'site_builder_not_configured' => 'Presence Builder tidak dikonfigurasikan.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Alat',
    'ui__reseller/client#clientslist__title' => 'Pelanggan',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Urus Direktori Maya di Bawah Tapak Web',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Pilih tapak web untuk direktori yang anda mahu urus.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Sediakan FTP awanama untuk domain',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Pilih domain yang anda mahu tetapkan FTP tanpa nama.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Urus kata laluan dilindungi direktori pada domain',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Pilih domain yang dilindungi kata lalauan direktori anda ingin uruskan.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Sediakan pengurus log untuk domain dan papar fail log domain',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Pilih domain yang log pengurus anda mahu untuk sediakan dan yang log fail yang anda mahu papar.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Urus sijil SSL/TLS untuk domain',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Pilih domain yang sijil SSL/TLS anda mahu uruskan.',

    'ui__client/domain/disable_multi__wizard-title' => 'Gantung Domain',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Pilih domain yang anda mahu untuk gantung.',

    'ui__client/domain/enable_multi__wizard-title' => 'Aktifkan domain',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Pilih domain yang anda mahu untuk aktifkan.',

    'ui__client/domain_unknown__wizard-title' => 'Papar domain',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Pilih pelanggan yang mana domain anda ingin papar.',

    'ui__client/domain/register_unknown__wizard-title' => 'Pendaftaran domain.',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Pilih domain yang anda mahu untuk pendaftaran.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Guna alat dari MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Pilih domain yang anda mahu untuk mengurus dengan alat dari MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Pengguna Alamat IP',
    'ui__server/ip-address/client_unknown__title' => 'Pengguna Alamat IP',
    'ui__server/ip-address/client_unknown__description' => 'Alamat IP pengguna %1',

    'disabled_by_admin' => 'Dinyahdayakan oleh pentadbir pelayan.',






    'ui__client/domain/chowner_multi__short-title' => 'Ubah pemilikan',
    'ui__client/domain/chowner_multi__title' => 'Ubah pemilikan langganan',
    'ui__client/domain/chowner_multi__description' => 'Ubah pemilikan langganan.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Pilih domain yang ingin diubah pemilikannya dan klik Seterusnya >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Ubah pemilikan',
    'ui__client/domain/chowner_unknown__title' => 'Ubah pemilikan langganan',
    'ui__client/domain/chowner_unknown__description' => 'Ubah pemilikan langganan.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Ubah pemilikan langganan',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Tiada butang tersuai.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Tiada butang tersuai pada penjual semula %1 antara muka.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Alih keluar butang %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Alih keluar',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Alih keluar butang %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Alih keluar butang tersuai dari penjual semula antara muka',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Alih keluar',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Alih keluar butang tersuai',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Alih keluar butang',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Pilih penjual semula yang ingin dialih keluar butang tersuainya dan klik Seterusnya >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Pilih butang yang ingin dialih keluar dan klik Seterusnya >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Sahkan mengalih keluar butang dengan memilih kotak semak pada skrin ini dan kemudian klik Selesai.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Alih keluar butang tersuai dari penjual semula antara muka',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Alih keluar',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Alih keluar butang tersuai',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Alih keluar butang tersuai',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Pilih penjual semula yang ingin dialih keluar butang tersuainya dan klik Seterusnya >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Pilih butang tersuai yang ingin dialih keluar dan klik Seterusnya >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Sahkan mengalih keluar butang tersuai dengan memilih kotak semak pada skrin ini dan kemudian klik Selesai.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Edit sifat tahap penjual semula butang tersuai %1.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Tetapan',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Ubah suai penjual semula butang tersuai %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Tambah butang tersuai',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Pilih penjual semula yang yang ingin dicipta butang tersuai di dalam antara mukanya dan klik Seterusnya >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klik Selesai untuk cipta butang.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Ubah sifat butang dalam penjual semula antara muka.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Sifat',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Ubah sifat butang dalam penjual semula antara muka.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ubah sifat butang tersuai',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Pilih penjual semula yang ingin diubah suai butang tersuainya dan klik Seterusnya >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Pilih butang tersuai yang ingin diubah suai dan klik Seterusnya >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Apabila dilakukan dengan mengedit sifat butang, klik Selesai untuk menggunakan perubahan dan keluar dari wizard.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Buat butang %1 tidak tersedia kepada pelanggan anda.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Buat tidak tersedia kepada pelanggan anda',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Buat butang %1 tidak tersedia kepada pelanggan anda',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Buat butang %1 kelihatan kepada pejual semula pelanggan.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Buat tersedia kepada pelanggan anda',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Buat butang %1 kelihatan kepada pejual semula pelanggan.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Buat butang tersuai yang tersedia/tidak tersedia kepada pelanggan anda.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tersedia/tidak tersedia kepada pelanggan anda',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Buat butang tersuai ada atau tidak tersedia untuk pelanggan anda',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Buat butang tersuai yang tersedia/tidak tersedia kepada pelanggan anda.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Pilih penjual semula yang butang tersuainya ingin dijadikan tersedia kepada pelanggan penjual semula dan klik Seterusnya >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Pilih butang tersuai yang ingin dijadikan tersedia atau tidak tersedia kepada pelanggan anda dan klik Seterusnya >>.',

    '__not_allowed' => 'Tidak dibenarkan',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Pilih pemilik baru domain.',

    '__ip_addr_state_unknown' => "Alamat IP tidak beroperasi sekarang kerana sistem masih memproses permintaan anda. Sila tunggu sebentar.",


    'resellers_list__accounts' => 'Pengguna',

    'ip_addr__repair_is_not_allowed' => 'Alamat IP tidak boleh diperbaiki dalam persekitaran Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'Penjual semula %1 tidak mempunyai pelanggan.',

    'ippoolManager__ip_used_by_nohost_domain' => "Alamat IP %%ip%% tidak boleh dialih keluar kerana sedang digunakan oleh satu atau beberapa domain tanpa hos.",
    'ippoolManager__ip_used_for_mail_service' => "Alamat IP %%ip%% tidak boleh dialih keluar kerana sedang digunakan oleh satu atau beberapa domain untuk alamat IP perkhidmatan mel mereka.",
    'ippoolManager__ip_used_for_send_emails' => "Alamat IP %%ip%% tidak boleh dialih keluar kerana sedang digunakan untuk menghantar e-mel dari IP tertentu (lihat Tetapan Pelayan Mel).",
    'ippoolManager__ip_used_in_dns_zone' => 'Alamat IP %%ip%% tidak boleh dialih keluar kerana ia sedang digunakan oleh zon DNS satu atau lebih domain.',
    'ip_ctrl__cannot_manage_on_vz' => 'Pemasangan Plesk sedang beroperasi di bawah bekas Virtuozzo. Alamat IP baharu hanya boleh ditambahkan oleh pentadbir nod bekas Virtuozzo.',

    'client_template__limits_auto_adjusted' => 'Had dari templat pelanggan telah dilaraskan secara automatik.',

    '__entries' => 'Entri',

    '__path_is_not_set' => 'Laluan adalah tidak ditentukan. Sila tentukan laluan yang sah.',

    'defaultcomponents__imap_required' => '(Pelayan mel ini tidak menyokong IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk hanya menyokong perisian statistik web komersil bagi pengiraan statistik subdomain. Tiada apa-apa perisian yang kini dipasang dalam sistem.',

    'mail__spamassassin_personal_settings_disallowed' => 'Keupayaan untuk menggunakan tetapan penapisan spam peribadi dimatikan oleh pentadbir pelayan. Tetapan penapisan spam dinyatakan di bawah tidak akan digunakan',

    'server_settings_invalid_traffic_statistics' => 'Parameter statistik pengekalan trafik tidak sah.',
    'server_settings_invalid_logrotate_period' => 'Parameter tempoh putaran log tidak sah.',
];