<?php
// Copyright 1999-2024. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Eigenschaften des zusätzlichen Schlüssels',
    'additional-key-info.update' => 'Zusätzlichen Schlüssel abrufen',
    'additional-key-info.updateDescription' => 'Zusätzlichen Schlüssel abrufen und installieren.',
    'additional-key-info.download' => 'Schlüssel herunterladen',
    'additional-key-info.downloadDescription' => 'Aktuellen Lizenzschlüssel herunterladen.',
    'additional-key-info.install' => 'Schlüssel installieren',
    'additional-key-info.installDescription' => 'Aktuellen Lizenzschlüssel installieren.',
    'additional-key-info.revert' => 'Rollback für Schlüssel ausführen',
    'additional-key-info.revertDescription' => 'Stellen Sie den zuvor installierten Lizenzschlüssel wieder her.',
    'additional-key-info.revertNotAvailableDescription' => 'Kein Schlüssel installiert.',
    'additional-key-info.installSuccess' => 'Die Installation des Lizenzschlüssels ist gestartet.',

    'additional-key-revert.title' => 'Zusätzlicher Schlüssel-Rollback',
    'additional-key-revert.success' => 'Der zusätzliche Schlüssel wurde zurückgesetzt.',

    'additional-key-upload.title' => 'Einen Lizenzschlüssel installieren',
    'additional-key-upload.success' => 'Der neue zusätzliche Schlüssel wurde hochgeladen.',

    'additional-keys.title' => 'Zusätzliche Lizenzschlüssel',

    'change-owner.title' => 'Ausgewählte Abonnements neu zuweisen',

    'customers.hint' => 'Hier können Sie die Konten Ihrer Hosting-Service-Kunden verwalten: Erstellen Sie Konten zusammen mit Abonnements bestimmter Services, verwalten Sie die bestehenden Kunden oder entfernen Sie Konten. Wenn Sie die dem Kunden bereitgestellten Websites, E-Mail-Services oder andere Services verwalten wollen, gehen Sie zum Kunden-Panel des Kunden, indem Sie auf den Link in der rechten Spalte der Liste klicken.',

    'customer-domains.hint' => 'Hier können Sie Websites erstellen und verwalten.',

    'customer-subscriptions.hint' => 'Hier können Sie die Abonnements des Kunden verwalten.',

    'domains.hint' => 'Hier können Sie Informationen zu allen Domainnamen anzeigen, die im System registriert sind, und die Hosting-Services verwalten. Wenn Sie eine Domain für sich selbst oder für Hosting-Kunden hinzufügen möchten, klicken Sie einfach auf "Domain hinzufügen". Während der Erstellung einer Domain werden Sie aufgefordert, einen neuen Kunden und ein neues Abonnement zu erstellen oder aus den bestehenden Optionen auszuwählen.',

    'database-servers.title' => 'Datenbankserver',

    'database-server-create.title' => 'Neuer Datenbankserver',

    'database-server-properties.title' => 'Datenbankserver',

    'database-server-upgrade.drawerTitle' => 'MariaDB-Upgrade',
    'database-server-upgrade.drawerTitle.completed' => 'Upgrade abgeschlossen',
    'database-server-upgrade.drawerSubTitle.line1' => 'Die Leiste kann nicht geschlossen werden, da das Upgrade noch nicht beendet ist.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Bei Problemen während des Upgrades finden Sie hilfreiche Informationen %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'Der MariaDB-Datenbankserver wurde auf die Version %%releaseVersion%% upgegradet. Falls Probleme auftreten, finden Sie hilfreiche Informationen %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'Die LTS-Version wurde installiert.',
    'database-server-upgrade.troubleshootingArticle' => 'in diesem KB-Artikel',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Details zur Fehlerbehebung bei Problemen mit dem MariaDB-Upgrade finden Sie %%troubleshootingArticle%%.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Sie können ein Upgrade für Ihren lokalen MariaDB-Datenbankserver auf die aktuelle LTS-Version (langfristiger Support) durchführen.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Wir empfehlen dringend, vor dem Upgrade ein Backup des Servers zu erstellen und das Upgrade durchzuführen, wenn die Websites gerade nicht ausgelastet sind.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Während des MariaDB-Upgrades sind der Plesk Server und die gehosteten Websites nicht verfügbar. Das MariaDB-Upgrade wird in der Regel ohne Fehler abgeschlossen und dauert etwa 10 Minuten. Es kann aber der gesamte Server betroffen sein.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Hinweis: Wenn Sie MariaDB 5.5 verwenden, führt Plesk zunächst ein Upgrade auf MariaDB 10.5 durch. Nachdem das Upgrade abgeschlossen ist, starten Sie diesen Assistenten erneut, um auf die aktuelle LTS-Version von MariaDB zu aktualisieren.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Aktuelle Version',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Version für das Upgrade auswählen',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Es sind keine Hauptversionen vorhanden',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Versionshinweise',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Release-Datum: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'End-of-Life-Datum: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Upgrades können nur für MariaDB-Forks durchgeführt werden, die vom BS- oder MariaDB-Anbieter stammen.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Überprüfungen vor dem Upgrade',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'MariaDB-Konfigurationsdateien parsen',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Datenbanken mit mysqlcheck analysieren',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'WebSocket überprüfen',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Um mit dem Upgrade fortzufahren, klicken Sie alle Kontrollkästchen an. Vergewissern Sie sich unbedingt, dass Sie mit den Konfigurationsänderungen einverstanden sind, die das Upgrade mit sich bringt, und dass Sie Zugriff auf die Wiederherstellungsoptionen haben.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Die folgenden Variablen werden aus Gründen der Kompatibilität mit der neuen Version entfernt:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} aus {count, plural, one {der Datei {files}} other {den # Dateien: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Zugriff auf Wiederherstellungsoptionen (Server-Befehlszeilenkonsole und Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Ich habe SSH-Zugriff auf den Server',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Verwenden Sie einen SSH-Client oder öffnen Sie die %%sshTerminalExtension%% in einem neuen Browsertab (schließen Sie das Fenster der SSH-Terminal-Erweiterung nicht, bevor das Upgrade abgeschlossen ist). Sollte das Upgrade fehlschlagen, kann die Wiederherstellung via SSH-Zugriff erfolgen.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH Terminal-Erweiterung',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Ich habe Zugriff auf Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Öffnen Sie %%repairKit%% in einem neuen Browsertab und melden Sie sich mit den Administrator-Anmeldedaten an. Schließen Sie das Fenster der Repair Kit-Erweiterung erst, wenn das Upgrade abgeschlossen ist.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Backup der Datenbanken erstellen',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Alle Datenbanken auf dem Server vor der Aktualisierung sichern',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk speichert das Backup der Datenbanken in dem Verzeichnis %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket ist in Plesk nicht verfügbar',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Ohne WebSocket sehen Sie das Resultat des Upgrades nicht in Echtzeit.',

    'database-server-upgrade.submitPopover.title' => 'Um Datenverlust zu verhindern, empfehlen wir dringend, ein Speicherabbild der gehosteten Datenbanken zu erstellen, bevor Sie fortfahren. Weiter ohne Speicherabbild?',

    'database-server-databases.title' => 'Datenbanken',

    'database-server-change-password.title' => 'Administratorpasswort',

    'home.title' => 'Start',

    'license.title' => 'Lizenzinformationen',

    'primary-key-info.title' => 'Plesk Lizenzschlüssel',
    'primary-key-info.update' => 'Schlüssel abrufen',
    'primary-key-info.updateDescription' => 'Bestellte Lizenzschlüssel abrufen und installieren.',
    'primary-key-info.upload' => 'Schlüssel installieren',
    'primary-key-info.uploadDescription' => 'Neuen Lizenzschlüssel hochladen und installieren.',
    'primary-key-info.revert' => 'Rollback für Schlüssel ausführen',
    'primary-key-info.revertDescription' => 'Stellen Sie den zuvor installierten Lizenzschlüssel wieder her.',

    'primary-key-revert.title' => 'Lizenzschlüssel-Rollback',
    'primary-key-revert.success' => 'Der Plesk-Schlüssel wurde zurückgesetzt.',

    'primary-key-upload.title' => 'Einen Lizenzschlüssel installieren',
    'primary-key-upload.success' => 'Der neue Plesk Schlüssel wurde hochgeladen.',

    'resellers.hint' => 'Hier verwalten Sie die Konten von Resellern. Das sind Ihre Kunden, die Hosting-Services weiterverkaufen sowie ihre eigenen Websites hosten. Hier können Sie Konten zusammen mit Service-Abonnements erstellen, Reseller verwalten und Konten entfernen.',

    'reseller-customers.hint' => 'Hier können Sie Kunden einrichten und verwalten.',

    'reseller-domains.hint' => 'Hier können Sie Websites erstellen und verwalten.',

    'reseller-subscriptions.hint' => 'Hier können Sie die Abonnements des Resellers verwalten.',

    'subscriptions.hint' => 'Kunden erhalten Hosting-Services von Ihnen, indem sie ein Hosting-Paket abonnieren. Hier können Sie diese Abonnements und Ihre eigenen Abonnements verwalten, die Sie zum Hosten Ihrer Websites erstellen. Wenn Sie die mit einem Abonnement bereitgestellten Websites, E-Mail-Services oder anderen Services verwalten wollen, gehen Sie zum Kunden-Panel des Abonnenten, indem Sie auf den Link in der rechten Spalte der Liste klicken.',

    'server-mail-settings.title' => 'Einstellungen',
    'server-mail-spam-filter.title' => 'Spamfilterung',
    'server-mail-antivirus.title' => 'Virenschutz',
    'server-mail-black-list.title' => 'Schwarze Liste',
    'server-mail-white-list.title' => 'Whitelist',
    'server-mail-queue.title' => 'E-Mail-Warteschlange',
    'server-mail-statistics.title' => 'Statistiken',

    'server-spam-filter.title' => 'Spamfilter-Einstellungen',
    'server-spam-filter.settings' => 'Einstellungen',
    'server-spam-filter.black-list' => 'Schwarze Liste',
    'server-spam-filter.white-list' => 'Whitelist',

    'firewall.title' => 'Firewall-Verwaltung',
    'firewall-general.title' => 'Allgemein',
    'firewall-general.toggleStatus' => 'Firewall-Schutz',
    'firewall-general.buttonDefault' => 'Auf Standard zurücksetzen',
    'firewall-general.buttonPanic' => 'Panikmodus',
    'firewall-general.confirmationDefault' => 'Die Firewall-Einstellungen auf die Standardeinstellungen zurücksetzen?',
    'firewall-general.confirmationPanic' => 'Panikmodus einschalten? Die Benutzer können dann nicht auf ihre Domains zugreifen und einige Netzwerkdienste funktionieren möglicherweise nicht mehr.',
    'firewall-general.successDefault' => 'Die Firewall-Einstellungen wurden auf die Standardwerte zurückgesetzt.',
    'firewall-general.successPanic' => 'Der Panikmodus wurde aktiviert.',
    'firewall-general.info' => 'Aus Sicherheitsgründen blockiert die Firewall alle Verbindungen, die nicht ausdrücklich erlaubt sind. Sie können eine Verbindung zulassen, indem Sie eine Regel erstellen. Weitere Informationen finden Sie in der Dokumentation',
    'firewall-general.interfaces' => 'Netzwerkschnittstellen',
    'firewall-icmp.title' => 'ICMP-Protokoll',
    'firewall-rules.title' => 'Firewall-Regeln',

    'dns.title' => 'DNS-Einstellungen',
    'dns-records.title' => 'Vorlage für Zoneneintrag',
    'dns-soa-record.title' => 'Vorlage für Zoneneinstellungen',

    'php-handler.title' => 'Einstellungen für %%name%%',
    'php-handler.extensions.title' => 'Erweiterungen',
    'php-handler.extensions.description' => 'Diese Einstellungen für PHP-Erweiterungen sind nur für diesen Handler vorgesehen.',
    'php-handler.extensions.descriptionShared' => 'Diese Einstellungen sind für folgende PHP-Handler gleich: %%handlers%%. Die Einstellungen gelten für alle Websites, die diese Handler nutzen.',
    'php-handler.extensions.buttonManage' => 'PECL-Pakete verwalten',
    'php-handler.extensions.manage.title' => 'PECL-Pakete verwalten',
    'php-handler.extensions.manage.risks' => 'PHP-Erweiterungen werden von PECL-Paketen Dritter bereitgestellt. Sie installieren sie auf eigenes Risiko.',
    'php-handler.extensions.manage.description' => 'Installieren, aktualisieren und deinstallieren Sie PECL-Pakete. Die Änderungen werden auf alle Websites angewendet, die auf %%handlers%% ausgeführt werden.',
    'php-handler.extensions.manage.notFound' => 'Warum ist das erwünschte Pakete nicht auf der Liste?',
    'php-handler.extensions.manage.limitations' => 'PHP-Erweiterungen, die vom Anbieter des Kontrollpanels und des Betriebssystems geliefert werden, sind in der Liste nicht aufgeführt.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.title' => "Serverinformationen",
    'ServerInformation.refresh' => "Aktualisieren",
    'ServerInformation.sectionGeneral' => "Allgemein",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Version",
    'ServerInformation.os' => "Betriebssystem",
    'ServerInformation.key' => "Plesk Lizenzschlüssel",
    'ServerInformation.uptime' => "Erreichbarkeit",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# Tag} other {# Tage}} {hours, plural, one {# Stunde} other {# Stunden}} {minutes, plural, one {# Minute} other {# Minuten}}",
    'ServerInformation.sectionCpu' => "CPU-Auslastung",
    'ServerInformation.la1min' => "Letzte Minute",
    'ServerInformation.la5min' => "Letzte 5 Minuten",
    'ServerInformation.la15min' => "Letzte 15 Minuten",
    'ServerInformation.sectionMemory' => "Speicherauslastung",
    'ServerInformation.memoryTotal' => "Gesamt",
    'ServerInformation.memoryUsed' => "Verwendet",
    'ServerInformation.memoryFree' => "Kostenlos",
    'ServerInformation.memoryShared' => "Gemeinsam genutzt",
    'ServerInformation.memoryBuffer' => "Puffer",
    'ServerInformation.memoryCached' => "Im Zwischenspeicher",
    'ServerInformation.memoryAvailable' => "Verfügbar",
    'ServerInformation.memoryUsage' => "Belegung",
    'ServerInformation.sectionSwap' => "Swap-Nutzung",
    'ServerInformation.sectionVirtualMemory' => "Ausnutzung des virtuellen Speichers",
    'ServerInformation.swapTotal' => "Gesamt",
    'ServerInformation.swapUsed' => "Verwendet",
    'ServerInformation.swapFree' => "Kostenlos",
    'ServerInformation.swapUsage' => "Belegung",
    'ServerInformation.sectionHarddisk' => "Festplattenauslastung",
    'ServerInformation.harddiskDirectory' => "Dateisystem",
    'ServerInformation.harddiskProtectedDir' => "Geschützte Verzeichnisse",
    'ServerInformation.harddiskTotal' => "Gesamt",
    'ServerInformation.harddiskUsed' => "Verwendet",
    'ServerInformation.harddiskAvailable' => "Verfügbar",
    'ServerInformation.harddiskCapacity' => "Kapazität",
    'ServerInformation.sectionDomains' => "Domains",
    'ServerInformation.activeDomains' => "Aktiv",
    'ServerInformation.inactiveDomains' => "Inaktiv",
    'ServerInformation.problemDomains' => "Probleme",
    'ServerInformation.refreshed' => "Information aktualisiert.",

    'ServerAbout.title' => 'Über Plesk',
    'ServerAbout.copyright' => '© 2024 Plesk International GmbH. Alle Rechte vorbehalten.',
    'ServerAbout.linkLicenseManagement' => 'Lizenzinformationen anzeigen',
    'ServerAbout.panelVersion' => 'Version',
    'ServerAbout.installedPatchVersion' => 'Update Nr. %%patch%%',
    'ServerAbout.licenseKey' => 'Lizenzschlüssel',
    'ServerAbout.productDescription' => 'Plesk ist die führende WebOps-Plattform zum Ausführen, Automatisieren und Ausbauen von Anwendungen, Websites und Hosting-Unternehmen.',
    'ServerAbout.readEula' => 'Mehr Informationen unter %%link%%',
    'ServerAbout.linkEula' => 'Endbenutzer-Lizenzvertrag',
    'ServerAbout.visitForum' => 'Besuchen Sie %%link%%.',
    'ServerAbout.linkForum' => 'Plesk Forum',
    'ServerAbout.followUs' => 'Folgen Sie uns',
    'ServerAbout.visitSite' => 'Weitere Informationen unter %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Finden Sie inspirierende Ideen unter %%link%%.',
    'ServerAbout.linkBlog' => 'Plesk Blog',

    'ServerAbout.darkThemePromoTitle' => 'Glückwunsch!',
    'ServerAbout.darkThemePromoDescription' => 'Sie haben ein Zauberkätzchen gefunden, das in der Jubiläumsversion von Plesk Obsidian 18.0.50 hinzugefügt wurde.',
    'ServerAbout.darkThemePromoButton' => 'Whoosh! Willkommen auf der dunklen Seite',
    'ServerAbout.darkThemeTourDescription' => 'Schalten Sie diese Option um, um das dunkle Thema für Ihre Benutzeroberfläche zu aktivieren oder zu deaktivieren.',
    'ServerAbout.darkThemeTourButton' => 'OK',

    'ts-sessions.title' => 'Terminalserver-Sitzungen',
    'ts-sessions-properties.title' => 'Eigenschaften der Sitzung',

    'BandwidthLimiting.title' => 'Bandbreitenlimit für %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'Sie können die Bandbreiteneinschränkung nicht kontrollieren, da QoS nicht installiert ist.',
    'BandwidthLimiting.virtualHostingRequired' => 'Bandbreitenlimits sind nur für Domains mit Webhosting verfügbar.',
    'BandwidthLimiting.bandwidthLabel' => 'Maximale Bandbreitenauslastung',
    'BandwidthLimiting.bandwidthHint' => 'Das Bandbreitennutzungslimit gilt nur für Daten, die über das HTTP-Protokoll übertragen werden.',
    'BandwidthLimiting.maxConnectionLabel' => 'Verbindungen begrenzt auf',
    'BandwidthLimiting.maxConnectionHint' => 'Wenn Sie die Bandbreite beschränken, wird empfohlen, auch die Anzahl an gleichzeitigen Verbindungen zu der Website einzuschränken. Ansonsten wird die Serverlast im Fall von häufigen Website-Abfragen durch die Webserver-Prozesse erhöht.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Einstellungen für Bandbreitenlimit wurden geändert.',
    'BandwidthLimiting.unlimited' => 'Unbegrenzt',

    'ip-address-domains.title' => 'Websites, die die IP-Adresse %%ipAddress%% (%%type%%) verwenden',
    'ip-address-domains.site' => 'Website',
    'ip-address-domains.setAsDefault' => 'Als Standard festlegen',
    'ip-address-domains.type-SHARED' => 'gemeinsam genutzt',
    'ip-address-domains.type-EXCLUSIVE' => 'dediziert',

    'HotlinkProtection.title' => 'Hotlinking-Schutz für %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'Der Hotlinking-Schutz ist nur für Domains mit Webhosting verfügbar.',
    'HotlinkProtection.enabledLabel' => 'Schutz vor Hotlinking aktivieren',
    'HotlinkProtection.extensionsLabel' => 'Geschützte Dateierweiterungen',
    'HotlinkProtection.friendsLabel' => 'Adressen von zugelassenen Websites',
    'HotlinkProtection.success' => 'Einstellungen für den Hotlinking-Schutz wurden geändert.',

    'Odbc.serverTitle' => 'ODBC-DSN-Verbindungen',
    'Odbc.domainTitle' => 'ODBC-DSN-Verbindungen für %%domainName%%',
    'Odbc.add' => 'ODBC DSN hinzufügen',
    'Odbc.resourceUsage' => '%%used%% erstellt / %%allowed%% zugelassen.',
    'Odbc.limitExceeded' => 'Das Limit der ODBC-DSN-Verbindungen wurde überschritten.',
    'Odbc.unlimited' => 'Unbegrenzt',
    'Odbc.addTooltip' => 'Fügen Sie eine ODBC-Datenquelle hinzu.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Verbindungsname',
    'Odbc.driver' => 'Treiber',
    'Odbc.description' => 'Verbindungsbeschreibung',
    'Odbc.hostname' => 'Hostname',
    'Odbc.statusSystem' => 'Es ist eine System-DSN.',
    'Odbc.statusConfigured' => 'DSN ist konfiguriert.',
    'Odbc.statusNotConfigured' => 'DSN ist nicht konfiguriert.',
    'Odbc.noSelectionText' => 'Wählen Sie mindestens ein Element aus, das entfernt werden soll.',
    'Odbc.removeConfirmation' => 'Die {count, plural, one {}=1 {Verbindung {name}} other {# ausgewählten Verbindungen}} entfernen?',
    'Odbc.removeSuccess' => 'Die ausgewählten Verbindungen wurden entfernt.',

    'DomainAliasSettings.title' => 'Einstellungen für Domain-Alias',
    'DomainAliasSettings.updateSuccess' => 'Die Eigenschaften des Domain-Alias %%name%% wurden geändert. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Die Website-Einstellungen werden in %%restartInterval%% Minuten übernommen.',

    'HostingSettings.title' => 'Hosting-Einstellungen',
    'HostingSettings.updateSuccess' => 'Die Einstellungen wurden aktualisiert.',
    'HostingSettings.emptyLogin' => 'Sie müssen einen Benutzernamen angeben.',
    'HostingSettings.emptyPassword' => 'Sie müssen ein Passwort angeben.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Der FTP-Server unterstützt kein IPv6 .Weisen Sie mindestens eine IPv4-Adresse zu, andernfalls wird der Benutzer nicht in der Lage sein, Dateien auf den Server via FTP hochzuladen.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Domaineinstellungen',
    'HostingSettings.domainSettingsSection.domainName' => 'Domainname',
    'HostingSettings.domainSettingsSection.description' => 'Zum Beispiel example.com ',

    'HostingSettings.submitPopover.title' => 'Inhalt von %%website%% entfernen',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Wenn Sie den Hostingtyp "Website" in "%%type%%" ändern, wird der gesamte Inhalt der Website, einschließlich der folgenden Verzeichnisse, dauerhaft entfernt:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Möchten Sie den Hosting-Typ für Ihre Website ändern?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Um auf weitere Einstellungen zuzugreifen, geben Sie die Anmeldedaten des Systembenutzers ein und klicken dann auf „Webspace erstellen“.',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Um auf weitere Einstellungen zuzugreifen, klicken Sie auf „Weiter“, um das Hosting zu erstellen.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Hosting-Typ',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Typ',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Webseite',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Weiterleitung',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Kein Webhosting',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Nutzen Sie die DNS-Zone der Domain, um Postfächer unter diesem Domainnamen zu verwenden.',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Der Pfad zum Basisverzeichnis der Website',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Bevorzugte Domain',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Die Besucher werden über eine SEO-freundliche HTTP 301-Weiterleitung hierher umgeleitet.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Besucher weiterleiten an',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Weiterleitungsart',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Dauerhaft verschoben (Code 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Leiten Sie Website-Besucher auf eine andere Website weiter und lassen Sie sie die Zieladresse sehen. Eine derartige Weiterleitung sorgt für den Erhalt des Suchmaschinen-Rankings der Website.',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Temporär verschoben (Code 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Leiten Sie Besucher auf eine temporäre Kopie der Website weiter, wenn Sie nicht wollen, dass Suchmaschinen die temporäre Website indexieren.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Frame-Weiterleitung',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Leiten Sie Besucher auf eine andere Website weiter, aber lassen Sie ihnen nicht die Zieladresse anzeigen, damit sie die Weiterleitung nicht bemerken.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Bevorzugte Domain',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Keine',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Dokumentstamm',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Der Dokumentstamm kann nicht geändert werden, da Webanwendungen auf dieser Website installiert sind.',
    'HostingSettings.domainSettingsSection.save' => 'Speichern',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Diese Einstellung ändern?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Die Änderung dieser Einstellung widerspricht den Sicherheitsrichtlinien des Servers und kann die Leistung beeinträchtigen oder den Server anfällig für Angriffe machen.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Ändern',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Zurücksetzen',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Voreingestellte sichere Einstellungen werden angewendet',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Um die Sicherheit zu erhöhen, sollten Sie die vordefinierten sicheren Einstellungen verwenden. Beachten Sie, dass bestimmte Berechtigungen es den Abonnenten erlauben, diese Einstellungen zu ändern.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Vordefinierte sichere Einstellungen anwenden',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Weitere Informationen zu sicheren Hosting-Einstellungen',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS-Unterstützung',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Aktiviert',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Verschlüsselung der Verbindungen zwischen der Website und dem Browser des Besuchers.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Zertifikat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Um HTTPS zu aktivieren, laden Sie ein SSL/TLS-Zertifikat in das Repository der Domain hoch und wählen es dann hier aus.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Besucher über eine SEO-freundliche 301-Umleitung von HTTP zu HTTPS weiterleiten',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Sie haben keine SSL/TLS-Zertifikate in Ihrem Repository. Um ein Zertifikat hinzuzufügen, gehen Sie zu %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'dieser Seite',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (anderes Repository)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Nicht ausgewählt',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web-Scripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Wählen Sie aus, welche Programmier- und Skriptsprachen vom Webserver interpretiert werden müssen.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin-Verzeichnis befindet sich in %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'SSI für *.htm- und *.html-Dateien verwenden',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET-Version',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Benutzerdefinierte Fehlerdokumente',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin-Verzeichnis befindet sich in',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'Dokumentstamm dieser Domain',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'Stammverzeichnis des Webspaces',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'der Stamm dieser Domain im alten Stil',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Benutzerdefinierte Fehlerdokumente',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Zusätzliche Schreib-/ Änderungsrechte',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Veröffentlichen mit Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Webstatistiken',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Tool',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Zugriff auf meine Webstatistiken mit meinem FTP-Benutzernamen und Passwort schützen',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Deaktiviert',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Webspace-Einstellungen',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP-Adressen',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Datenträgerkontingent',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Aktiviert',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Verhindern Sie den Zugriff auf die Dateien der Website, wenn das in den Abonnementeinstellungen festgelegte Speicherplatzkontingent (falls vorhanden) überschritten wird.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Das Datenträgerkontingent wird aufgrund der Konfiguration des Dateisystems des Servers nicht unterstützt.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Anmeldedaten für Systembenutzer',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Verwalten Sie die Dateien und Verzeichnisse der Website über FTP oder den Dateimanager. Zugriff auf den Server über SSH, wenn erlaubt.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Verwalten Sie die Dateien und Verzeichnisse der Website über FTP oder den Dateimanager. Zugriff auf den Server über Remotedesktop, wenn erlaubt.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Benutzername',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Passwort',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Geben Sie hier ein neues Passwort ein, um das Passwort des Systembenutzers zu ändern.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH-Zugriff',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Zugriff via Remotedesktop',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Aktiviert',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Mit den Zugangsdaten des Systembenutzers auf den Server zugreifen.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Typ',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Deaktiviert',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Für {count, plural, one {}other {# Domains}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Die folgenden Einstellungen gelten für alle {count, plural, one {}other {# Domains im Webspace {name}}}:',

    'OdbcAdd.title' => 'ODBC-DSN hinzufügen',
    'OdbcAdd.nameLabel' => 'Verbindungsname',
    'OdbcAdd.descriptionLabel' => 'Verbindungsbeschreibung',
    'OdbcAdd.driver' => 'Treiber',
    'OdbcAdd.submit' => 'ODBC-DSN-Verbindung erstellen',

    'OdbcEdit.title' => 'ODBC-Verbindung einrichten',
    'OdbcEdit.saveSuccess' => 'Die Einstellungen der Verbindung wurden gespeichert.',
    'OdbcEdit.test' => 'Verbindung testen',
    'OdbcEdit.connectSuccess' => 'Verbindung erfolgreich.',

    'OdbcEdit.excel.driver.label' => 'Treiber',
    'OdbcEdit.excel.dbq.label' => 'Pfad der Datenbankdatei',
    'OdbcEdit.excel.defaultdir.label' => 'Standard-Datenverzeichnis',
    'OdbcEdit.excel.fil.label' => 'Datenbankversion',
    'OdbcEdit.excel.maxbuffersize.label' => 'Maximale Puffergröße',
    'OdbcEdit.excel.pagetimeout.label' => 'Seiten-Timeout',

    'OdbcEdit.access.driver.label' => 'Treiber',
    'OdbcEdit.access.dbq.label' => 'Pfad der Datenbankdatei',
    'OdbcEdit.access.uid.label' => 'Login-ID',
    'OdbcEdit.access.pwd.label' => 'Passwort',
    'OdbcEdit.access.pagetimeout.label' => 'Seiten-Timeout',
    'OdbcEdit.access.pagetimeout.description' => 'Der Zeitraum in Zehntelsekunden, für die eine unbenutzte Seite im Puffer verbleibt. Diese Option gilt für alle Datenquellen, die den Microsoft Access-Treiber verwenden.',
    'OdbcEdit.access.maxbuffersize.label' => 'Maximale Puffergröße',
    'OdbcEdit.access.maxbuffersize.description' => 'Die Größe des internen Puffers in KB, ausgerichtet auf 256 KB-Grenze.',
    'OdbcEdit.access.readonly.label' => 'Schreibgeschützt',
    'OdbcEdit.access.readonly.description' => 'Kennzeichnet die Datenbank als schreibgeschützt, um Updates zu verhindern.',
    'OdbcEdit.access.exclusive.label' => 'Exklusiv',
    'OdbcEdit.access.exclusive.description' => 'Kennzeichnet die Datenbank als exklusiv, um gemeinsam verwendete Updates zu verhindern.',
    'OdbcEdit.access.safetransactions.label' => 'Sichere Transaktionen',
    'OdbcEdit.access.safetransactions.description' => 'Bei 0 (Standardwert) werden alle Transaktionen sofort ausgeführt. Bei 1 werden alle Transaktionen nur bei einer Ausführungsoperation auf dem Datenträger gespeichert, die Performance ist jedoch leicht vermindert.',
    'OdbcEdit.access.threads.label' => 'Threads',
    'OdbcEdit.access.threads.description' => 'Anzahl der Hintergrund-Threads, die die Maschine verwenden soll.',
    'OdbcEdit.access.maxscanrows.label' => 'Maximale Anzahl der zu prüfenden Zeilen',
    'OdbcEdit.access.maxscanrows.description' => 'Anzahl der zu durchsuchenden Zeilen bei Einstellen des Datentyps einer Spalte basierend auf vorhandenen Daten',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Gibt an, wie außerhalb einer Transaktion vorgenommene Änderungen in die Datenbank geschrieben werden.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Gibt an, ob der MS Access-Treiber explizite benutzerdefinierte Transaktionen asynchron ausführt.',

    'OdbcEdit.mssql.driver.label' => 'Treiber',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'Login-ID',
    'OdbcEdit.mssql.pwd.label' => 'Passwort',
    'OdbcEdit.mssql.database.label' => 'Standard-Datenbank',
    'OdbcEdit.mssql.app.label' => 'Anwendungsname',
    'OdbcEdit.mssql.wsid.label' => 'Workstation-ID',
    'OdbcEdit.mssql.language.label' => 'Standardsprache',
    'OdbcEdit.mssql.oemtoansi.label' => 'Konvertierung der erweiterten Zeichen in OEM-Werte',

    'OdbcEdit.mysql.driver.label' => 'MySQL-ODBC-Treiber',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'Hostname des MySQL-Servers',
    'OdbcEdit.mysql.database.label' => 'Standard-Datenbank',
    'OdbcEdit.mysql.user.label' => 'Benutzername',
    'OdbcEdit.mysql.user.description' => 'Der Benutzername für die Verbindung mit MySQL',
    'OdbcEdit.mysql.password.label' => 'Passwort',
    'OdbcEdit.mysql.password.description' => 'Passwort für das Benutzerkonto auf dem Server',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Zu verwendender TCP/IP-Port, wenn der Server nicht der Local Host ist.',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => '(Von) Windows benannte Verbindungsleitung, wenn der Server der Local Host ist.',
    'OdbcEdit.mysql.option.label' => 'Option',
    'OdbcEdit.mysql.option.description' => 'Optionen, die die Funktionen von MyODBC bestimmen. <<a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">Weitere Informationen</a>',

    'ProtectedDirectoryList.title' => 'Geschützte Verzeichnisse von %%domainName%%',
    'ProtectedDirectoryList.add' => 'Geschütztes Verzeichnis hinzufügen',
    'ProtectedDirectoryList.addTooltip' => 'Erstellen Sie ein geschütztes Verzeichnis.',
    'ProtectedDirectoryList.name' => 'Name',
    'ProtectedDirectoryList.realmTitle' => 'Titel des geschützten Bereichs',
    'ProtectedDirectoryList.noSelectionText' => 'Wählen Sie mindestens ein Element aus, das entfernt werden soll.',
    'ProtectedDirectoryList.edit' => 'Bearbeiten',
    'ProtectedDirectoryList.remove' => 'Schutz entfernen',
    'ProtectedDirectoryList.removeTooltip' => 'Schutz für ausgewählte Verzeichnisse entfernen.',
    'ProtectedDirectoryList.removeConfirmation' => 'Dieser Vorgang führt dazu, dass der Schutz {count, plural, one {}=1 {des Verzeichnisses „{name}“} other {# ausgewählten Verzeichnissen}} entfernt wird. {count, plural, one {}=1 {Dieses Verzeichnis} other {Die Verzeichnisse}} werden für Internetnutzer frei zugänglich sein.',
    'ProtectedDirectoryList.removeSuccess' => 'Die ausgewählten Verzeichnisse wurden entfernt.',

    'ProtectedDirectoryAdd.title' => 'Erstellen Sie ein geschütztes Verzeichnis',
    'ProtectedDirectoryAdd.submit' => 'Erstellen',
    'ProtectedDirectoryAdd.success' => 'Das geschützte Verzeichnis %%path%% wurde erfolgreich erstellt',

    'ProtectedDirectoryEdit.title' => 'Geschützte Verzeichnis-Einstellungen',
    'ProtectedDirectoryEdit.success' => 'Geschützte Verzeichnis-Einstellungen wurden geändert',

    'ProtectedDirectoryUserList.title' => 'Benutzer des geschützten Verzeichnisses %%directory%%',
    'ProtectedDirectoryUserList.add' => 'Benutzer hinzufügen',
    'ProtectedDirectoryUserList.addTooltip' => 'Benutzerkonten für den Zugriff auf das geschützte Verzeichnis %%directory%% erstellen',
    'ProtectedDirectoryUserList.login' => 'Name',
    'ProtectedDirectoryUserList.changePassword' => 'Passwort ändern',
    'ProtectedDirectoryUserList.noSelectionText' => 'Wählen Sie mindestens einen Benutzer aus, der entfernt werden soll.',
    'ProtectedDirectoryUserList.remove' => 'Entfernen',
    'ProtectedDirectoryUserList.removeTooltip' => 'Ausgewählte Benutzer entfernen.',
    'ProtectedDirectoryUserList.removeConfirmation' => '{count, plural, one {}=1 {Den Benutzer {login}} other {# ausgewählte Benutzer}} entfernen?',
    'ProtectedDirectoryUserList.removeSuccess' => 'Die ausgewählten Benutzer wurden entfernt.',

    'ProtectedDirectoryUserAdd.title' => 'Benutzer für geschütztes Verzeichnis erstellen',
    'ProtectedDirectoryUserAdd.subtitle' => 'Verzeichnis %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Benutzername',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Passwort',
    'ProtectedDirectoryUserAdd.submit' => 'Erstellen',
    'ProtectedDirectoryUserAdd.success' => 'Der Benutzer %%login%% des geschützten Verzeichnisses wurde erstellt.',

    'ProtectedDirectoryUserPassword.title' => 'Passwort für den Benutzer des geschützten Verzeichnisses',
    'ProtectedDirectoryUserPassword.subtitle' => 'Benutzer %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Passwort',
    'ProtectedDirectoryUserPassword.submit' => 'Speichern',
    'ProtectedDirectoryUserPassword.success' => 'Die Benutzeranmeldeinformationen wurden gespeichert.',

    'SummaryReport.Layout.title' => 'Berichtlayout-Eigenschaften',
    'SummaryReport.Layout.success' => 'Berichtlayout %%name%% wurde aktualisiert.',
    'SummaryReport.Layouts.title' => 'Berichtlayouts',

    'SummaryReport.Layout.Add.title' => 'Berichtlayout erstellen',
    'SummaryReport.Layout.Add.success' => 'Berichtlayout %%name%% wurde erstellt.',

    'SummaryReport.Report.title' => 'Zusammenfassender Bericht',
    'SummaryReport.Report.buttonLayouts' => 'Layouts',
    'SummaryReport.Report.buttonSchedule' => 'Zeitplan',
    'SummaryReport.Report.buttonProperties' => 'Eigenschaften',
    'SummaryReport.Report.buttonTrafficHistory' => 'Traffic-Verlauf',
    'SummaryReport.Report.buttonPrint' => 'Drucken',
    'SummaryReport.Report.buttonSend' => 'Per E-Mail senden',
    'SummaryReport.Report.successSent' => 'Der Bericht wurde an %%email%% versendet',

    'SummaryReport.Schedule.title' => 'Zustellungspläne für %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Zustellungsplan für %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Berichtzustellungsplan wurde aktualisiert.',

    'SummaryReport.Schedule.Add.title' => 'Zustellungspläne für %%name%% erstellen',
    'SummaryReport.Schedule.Add.success' => 'Berichtzustellungsplan wurde erstellt.',

    'SummaryReport.TrafficHistory.title' => 'Traffic-Verlauf',

    'VirtualDirectory.title' => 'Virtuelles Verzeichnis %%path%% von %%domainName%%',
    'VirtualDirectory.errNotExist' => 'Dieses virtuelle Verzeichnis ist mit einem nicht existierenden physischen Ordner verknüpft.',
    'VirtualDirectory.errNoPermissions' => 'Sie haben keine Berechtigung, den Inhalt dieses Verzeichnisses zu sehen.',
    'VirtualDirectory.buttonProperties' => 'Verzeichnis-eigenschaften',
    'VirtualDirectory.buttonPropertiesHint' => 'Eigenschaften von virtuellem Verzeichnis anzeigen und ändern.',
    'VirtualDirectory.buttonPermissions' => 'Verzeichniszugriffs-berechtigungen',
    'VirtualDirectory.buttonPermissionsHint' => 'Richten Sie Verzeichniszugriffsberechtigungen ein.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'ASP.NET-Einstellungen konfigurieren.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'PHP-Einstellungen konfigurieren.',
    'VirtualDirectory.buttonMimeTypes' => 'MIME-Typen',
    'VirtualDirectory.buttonMimeTypesHint' => 'Registrierte MIME-Typen verwalten.',
    'VirtualDirectory.buttonErrorDocs' => 'Fehlerdokumente',
    'VirtualDirectory.buttonErrorDocsHint' => 'Fehlerdokumente verwalten.',
    'VirtualDirectory.buttonProtection' => 'Schutz',
    'VirtualDirectory.buttonProtectionHint' => 'Schränken Sie den Zugriff auf das Verzeichnis durch einen Passwortschutz ein.',

    'VirtualDirectory.CreateDirectory.title' => 'Verzeichnis erstellen',
    'VirtualDirectory.CreateDirectory.name' => 'Verzeichnisname',
    'VirtualDirectory.CreateDirectory.success' => 'Das Verzeichnis %%name%% wurde erstellt.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Das Verzeichnis %%name%% ist bereits vorhanden.',

    'VirtualDirectory.AspDotNet.title' => 'ASP.NET-Einstellungen konfigurieren',

    'VirtualDirectory.Php.title' => 'PHP-Version',
    'VirtualDirectory.Php.version' => 'Version',
    'VirtualDirectory.Php.success' => 'PHP-Version wurde aktualisiert.',
];