<?php
// Copyright 1999-2024. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'További kulcs tulajdonságok',
    'additional-key-info.update' => 'Kiegészítő kulcs letöltése',
    'additional-key-info.updateDescription' => 'További kulcs lekérése és telepítése.',
    'additional-key-info.download' => 'Kulcs letöltése',
    'additional-key-info.downloadDescription' => 'Töltse le az aktuális licenckulcsot.',
    'additional-key-info.install' => 'Kulcs telepítése',
    'additional-key-info.installDescription' => 'Telepítse a jelenlegi licenckulcsot.',
    'additional-key-info.revert' => 'Kulcs visszaállítása',
    'additional-key-info.revertDescription' => 'Térjen vissza a korábban telepített licenckulcshoz.',
    'additional-key-info.revertNotAvailableDescription' => 'Nincs kulcs telepítve.',
    'additional-key-info.installSuccess' => 'Megtörtént a licenckulcs telepítésének az elindítása.',

    'additional-key-revert.title' => 'További licenckulcs visszaállítása',
    'additional-key-revert.success' => 'Megtörtént a további licenckulcs visszaállítása.',

    'additional-key-upload.title' => 'Egy licenckulcs telepítése',
    'additional-key-upload.success' => 'Megtörtént az új aktív kulcs feltöltése.',

    'additional-keys.title' => 'További licenckulcsok',

    'change-owner.title' => 'Kiválasztott előfizetések ismételt hozzárendelése',

    'customers.hint' => 'Itt végezheti el üzemeltetési szolgáltatása ügyfelei számláinak a kezelését: szolgáltatási előfizetésekkel együtt számlák létrehozását, meglévő ügyfelek kezelését és számlák eltávolítását. Egy ügyfélnek biztosított webhelyek, levelezési és egyéb szolgáltatások felügyeletéhez, a lista jobb oldali oszlopában található hivatkozásra kattintva ugorjon az Ügyfelek paneljeire.',

    'customer-domains.hint' => 'Itt lehet beállítani és kezelni a webhelyeket.',

    'customer-subscriptions.hint' => 'Itt végezheti az ügyfél előfizetéseinek a kezelését.',

    'domains.hint' => 'Itt tekintheti meg a rendszerben regisztrált összes domain névre vonatkozó információt, majd az üzemeltetési szolgáltatások kezelésével folytathatja. Egy saját célra vagy ügyfelek üzemeltetésére szolgáló domain hozzáadásához csupán a Domain hozzáadása gombra kell kattintania. Egy domain létrehozásakor egy új ügyfél vagy előfizetés létrehozására, illetve a meglévők közül egy kiválasztására kérdez rá a kezelőpanel.',

    'database-servers.title' => 'Adatbázis-kiszolgálók',

    'database-server-create.title' => 'Új adatbázis-kiszolgáló',

    'database-server-properties.title' => 'Adatbázis-kiszolgáló',

    'database-server-upgrade.drawerTitle' => 'MariaDB magasabb verzióra frissítése',
    'database-server-upgrade.drawerTitle.completed' => 'Befejeződött a magasabb verzióra frissítés',
    'database-server-upgrade.drawerSubTitle.line1' => 'A magasabb verzióra frissítés során nem zárható be a menü.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Ha hiba történik a magasabb verzióra való frissítés során, akkor %%troubleshootingArticle%% cikket nézze meg.',
    'database-server-upgrade.drawerSubTitle.completed' => '%%releaseVersion% verzióra lett frissítve a MariaDB adatbázis kiszolgáló, ha probléma merül fel, akkor.kövesse %%troubleshootingArticle%% cikk útmutatásait.',
    'database-server-upgrade.upToDate' => 'Már telepítve van a legújabb hosszú távon támogatott verzió.',
    'database-server-upgrade.troubleshootingArticle' => 'Ez Tudásbázis cikk',
    'database-server-upgrade.troubleshootingArticleDescription' => '%%troubleshootingArticle%% cikkünket használja a MariaDB kiszolgáló magasabb verzióra frissítési problémái esetén.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'A jelenlegi hosszú távon támogatott (long-term support - LTS) verzióra frissítse a helyi MariaDB adatbázis-kiszolgálót.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Nyomatékosan ajánljuk, hogy a magasabb verzióra frissítés előtt végezze el a kiszolgálója biztonsági mentését, továbbá a webhely csúcsidőszakán kívül végezze a magasabb verzióra frissítést.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'A MariaDB magasabb verzióra frissítése alatt nem lesz elérhetőek a Plesk kiszolgáló, illetve nem leszek elérhetővé az azon üzemeltetett webhelyek. Általában hibamentes a MariaDB magasabb verzióra frissítése, és körülbelül 10 percig tart, de ettől még érintheti az egész kiszolgáló működését.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Megjegyzés: Ha MariaDB 5.5 verziót futtat, akkor a Plesk először MariaDB 10.5 verzióra frissíti. A magasabb verzióra frissítés befejezése után, indítsa el újból a varázslót, hogy a MariaDB jelenleg hosszú távon támogatott magasabb verziójára frissítse.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Jelenlegi verzió',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Válassza ki azt a verziót, amire frissíteni akar.',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Nincsenek nagyobb kiadások',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Kibocsátási megjegyzések',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Kiadás dátuma: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Élettartam vég dátuma: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Csak MariaDB adattármásolatokat szállítanak az operációs rendszer forgalmazói, illetve magasabb verzióra frissíthető a MariaDB-kiszolgáló szállítója által biztosított példány.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Magasabb verzióra frissítést megelőző ellenőrzések',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'MariaDB konfigurációs fájlok elemzése',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Adatbázisok mysqlcheck táblázat adatbázis javító program segítségével való ellenőrzése',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'WebSocket ellenőrzése',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'A magasabb verzióra frissítés folytatásához jelölje be az összes jelölőnégyzetet. Ez szükséges ahhoz, hogy elfogadja a magasabb verzióra frissítés konfigurációs változtatásait, és hozzáférése legyen a helyreállítási választási lehetőségekhez.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Az új verzióval való kompatibilitás érdekében eltávolításra kerülnek a következő változók:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} a következőből: {count, plural, one {fájl {files}} other {# fájl: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'A helyreállítási választási lehetőségekhez való hozzáférés (a kiszolgáló parancssor konzolja és a Javítókészlet)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Megerősítem, hogy van a biztonságos héjon keresztüli hozzáférésem a kiszolgálóhoz.',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Egy SSH-ügynököt használjonm vagy egy új böngésző lapon nyissa meg %%sshTerminalExtension%% bővítményt (a magasabb verzióra frissítés befejezése előtt ne zárja be az SSH Terminal bővítmény ablakot). Ha nem sikerül a magasabb verzióra frissítés, akkor a biztonságos héjon keresztüli hozzáférés segít a helyreállításban.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH Terminal bővítmény',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Megerősítem, hogy van-e javítókészlethez hozzáférésem.',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Egy új böngésző lapon nyissa meg a %%repairKit%% bővítményt, majd adminisztrátor hitelesítő adatokkal lépjen be. A magasabb verzióra frissítés befejezése előtt ne zárja be a Repair Kit bővítményt.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Adatbázisok biztonsági mentése',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'A frissítés előtt a kiszolgálón üzemeltetett összes adatbázis biztonsági mentése',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'A Plesk kiszolgáló %%path%% könyvtárban tárolja az adatbázis biztonsági másolatokat.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket internetes technológia nem áll rendelkezésre a Plesk kiszolgálón.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'WebSocket internetes technológia nélkül nem láthatja a magasabb verzióra frissítési eljárás valós idejű eredményét.',

    'database-server-upgrade.submitPopover.title' => 'A potenciális adatvesztés megakadályozására, a folytatás előtt nyomatékosan ajánljuk az üzemeltetett adatbázisokból egy kiírás létrehozását. Kiírás létrehozása nélkül folytatja?',

    'database-server-databases.title' => 'Adatbázisok',

    'database-server-change-password.title' => 'Adminisztrátor jelszava',

    'home.title' => 'Kezdőlap',

    'license.title' => 'Licencinformációk',

    'primary-key-info.title' => 'Plesk licenckulcs',
    'primary-key-info.update' => 'Kulcsok lekérése',
    'primary-key-info.updateDescription' => 'A megrendelt licenckulcsok lekérése és telepítése.',
    'primary-key-info.upload' => 'Kulcs telepítése',
    'primary-key-info.uploadDescription' => 'Töltsön fel és telepítsen egy új licenckulcsot.',
    'primary-key-info.revert' => 'Kulcs visszaállítása',
    'primary-key-info.revertDescription' => 'Térjen vissza a korábban telepített licenckulcshoz.',

    'primary-key-revert.title' => 'Licenckulcs visszaállítása',
    'primary-key-revert.success' => 'Megtörtént a Plesk kulcs visszaállítása.',

    'primary-key-upload.title' => 'Egy licenckulcs telepítése',
    'primary-key-upload.success' => 'Nem történt meg az új aktív kulcs feltöltése.',

    'resellers.hint' => 'Itt végezheti a viszonteladók számláinak a kezelését – a viszonteladók olyan ügyfelek, akik üzemeltetési szolgáltatás viszonteladásával foglalkoznak és üzemeltetik a saját webhelyeiket. Itt hozhat létre szolgáltatási előfizetésekkel együtt számlákat, kezelheti a meglévő viszonteladókat és eltávolíthat számlákat.',

    'reseller-customers.hint' => 'Itt végezheti el a az ügyfelek beállítását és kezelését.',

    'reseller-domains.hint' => 'Itt lehet beállítani és kezelni a webhelyeket.',

    'reseller-subscriptions.hint' => 'Itt végezheti a viszonteladó előfizetéseinek a kezelését.',

    'subscriptions.hint' => 'Egy üzemeltetési csomagra való előfizetés által jutnak üzemeltetési szolgáltatásokhoz az ügyfelei. Itt végezheti ezen, illetve a saját előfizetések kezelését, melyeket a saját webhelyei üzemeltetése céljából hoz létre. Egy előfizetéssel biztosított webhelyek, levelezési és egyéb szolgáltatások felügyeletéhez, a lista jobb oldali oszlopában található hivatkozásra kattintva ugorjon az előfizető Ügyfél kezelőpaneljére.',

    'server-mail-settings.title' => 'Beállítások',
    'server-mail-spam-filter.title' => 'Levélszemét szűrése',
    'server-mail-antivirus.title' => 'Vírusvédelem',
    'server-mail-black-list.title' => 'Tiltólista',
    'server-mail-white-list.title' => 'Engedélyezési lista',
    'server-mail-queue.title' => 'Levelzés várólista',
    'server-mail-statistics.title' => 'Statisztikák',

    'server-spam-filter.title' => 'Levélszemét szűrő beállítások',
    'server-spam-filter.settings' => 'Beállítások',
    'server-spam-filter.black-list' => 'Tiltólista',
    'server-spam-filter.white-list' => 'Engedélyezési lista',

    'firewall.title' => 'Tűzfal kezelés',
    'firewall-general.title' => 'Általános',
    'firewall-general.toggleStatus' => 'Tűzfal védelem',
    'firewall-general.buttonDefault' => 'Visszaállítás az alapértelmezett értékekre',
    'firewall-general.buttonPanic' => 'Pánik mód',
    'firewall-general.confirmationDefault' => 'Visszaállítja az alapbeállításokra a tűzfal beállításait?',
    'firewall-general.confirmationPanic' => 'Bekapcsolja a Pánik módot? A felhasználók nem férhetnek a domainjeikhez, és leállhatnak egyes hálózati szolgáltatások.',
    'firewall-general.successDefault' => 'Az alapbeállításaikra vannak visszaállítva a tűzfal beállításai.',
    'firewall-general.successPanic' => 'Engedélyezve van a Pánik mód.',
    'firewall-general.info' => 'Biztonsági okokból, a kifejezetten engedélyezettek kivételével, a tűzfal blokkolja az összes kapcsolatot Egy szabály létrehozásával engedélyezhet egy kapcsolatot. További információkért a dokumentációt nézze meg. További információkért a dokumentációt nézze meg.',
    'firewall-general.interfaces' => 'Hálózati illesztők',
    'firewall-icmp.title' => 'ICMP-protokoll',
    'firewall-rules.title' => 'Tűzfalszabályok',

    'dns.title' => 'DNS-beállítások',
    'dns-records.title' => 'Zóna rekord sablon',
    'dns-soa-record.title' => 'Zóna beállítások sablon',

    'php-handler.title' => '%%name%% beállításai',
    'php-handler.extensions.title' => 'Bővítmények',
    'php-handler.extensions.description' => 'Csak e kiszolgálóra érvényesek e PHP-kiterjesztési beállítások.',
    'php-handler.extensions.descriptionShared' => 'E beállítások közösek a következő PHP-kezelők esetében: %%handlers%%. E beállítások az összes olyan webhelyen alkalmazásra kerülnek, melyek használják e kezelőket.',
    'php-handler.extensions.buttonManage' => 'PECL-csomagok kezelése',
    'php-handler.extensions.manage.title' => 'PECL-csomagok kezelése',
    'php-handler.extensions.manage.risks' => 'PECL-csomagokként harmadik fél szállítja a PHP-bővítményeket. Saját kockázatára telepíti azokat.',
    'php-handler.extensions.manage.description' => 'Végezze el a PECL csomagok telepítését, magasabb verzióra frissítését és eltávolítását. %%handlers%% kezelőn futó valamennyi webhely esetében megtörténik a változtatások átvezetése.',
    'php-handler.extensions.manage.notFound' => 'Miért nem szerepel a kívánt csomag a listán?',
    'php-handler.extensions.manage.limitations' => 'A vezérlőpult és az operációs rendszer szállítója által biztosítottt PHP-bővítmények nem jelennek meg a listán.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.title' => "Kiszolgáló adatai",
    'ServerInformation.refresh' => "Frissítés",
    'ServerInformation.sectionGeneral' => "Általános",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Verzió",
    'ServerInformation.os' => "Operációs rendszer",
    'ServerInformation.key' => "Plesk licenckulcs",
    'ServerInformation.uptime' => "Bekacsolási idő",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# nap} other {# nap}} {hours, plural, one {# óra} other {# óra}} {minutes, plural, one {# perc} other {# perc}}",
    'ServerInformation.sectionCpu' => "CPU-használat",
    'ServerInformation.la1min' => "Az utolsó 1 perc",
    'ServerInformation.la5min' => "Utolsó 5 perc",
    'ServerInformation.la15min' => "Az utolsó 15 perc",
    'ServerInformation.sectionMemory' => "Memóriahasználat",
    'ServerInformation.memoryTotal' => "Összes",
    'ServerInformation.memoryUsed' => "Használt",
    'ServerInformation.memoryFree' => "Ingyenes",
    'ServerInformation.memoryShared' => "Megosztott",
    'ServerInformation.memoryBuffer' => "Puffer",
    'ServerInformation.memoryCached' => "Gyorsítótárazott",
    'ServerInformation.memoryAvailable' => "Rendelkezésre áll",
    'ServerInformation.memoryUsage' => "Használat",
    'ServerInformation.sectionSwap' => "Felcserélés használata",
    'ServerInformation.sectionVirtualMemory' => "Fizikai memória használat",
    'ServerInformation.swapTotal' => "Összes",
    'ServerInformation.swapUsed' => "Használt",
    'ServerInformation.swapFree' => "Ingyenes",
    'ServerInformation.swapUsage' => "Használat",
    'ServerInformation.sectionHarddisk' => "Merevlemez kihasználtsága",
    'ServerInformation.harddiskDirectory' => "Fájlrendszer",
    'ServerInformation.harddiskProtectedDir' => "Védett könyvtárak",
    'ServerInformation.harddiskTotal' => "Összes",
    'ServerInformation.harddiskUsed' => "Használt",
    'ServerInformation.harddiskAvailable' => "Rendelkezésre áll",
    'ServerInformation.harddiskCapacity' => "Kapacitás",
    'ServerInformation.sectionDomains' => "Domainek",
    'ServerInformation.activeDomains' => "Aktív",
    'ServerInformation.inactiveDomains' => "Inaktív",
    'ServerInformation.problemDomains' => "Problémák",
    'ServerInformation.refreshed' => "Frissítettek az információk.",

    'ServerAbout.title' => 'Plesk névjegy',
    'ServerAbout.copyright' => '© 2024 Plesk International GmbH. Minden jog fenntartva.',
    'ServerAbout.linkLicenseManagement' => 'Ugrás a licencinformációkra',
    'ServerAbout.panelVersion' => 'Verzió',
    'ServerAbout.installedPatchVersion' => '#%%patch%% frissítése',
    'ServerAbout.licenseKey' => 'Licenckulcs',
    'ServerAbout.productDescription' => 'A Plesk vezető WebOps platform az üzemeltetési szolgáltatások futtatása, automatizálása és alkalmazásfejlesztése területén.',
    'ServerAbout.readEula' => 'Végezze %%link%% olvasását.',
    'ServerAbout.linkEula' => 'Végfelhasználói licencszerződés',
    'ServerAbout.visitForum' => '%%link%% felkeresése',
    'ServerAbout.linkForum' => 'Plesk fórum',
    'ServerAbout.followUs' => 'Kövessen minket',
    'ServerAbout.visitSite' => '%%link%% helyen találhatóak további tudnivalók.',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => '%%link%% helyen található inspiráció.',
    'ServerAbout.linkBlog' => 'Plesk blog',

    'ServerAbout.darkThemePromoTitle' => 'Gratulálunk!',
    'ServerAbout.darkThemePromoDescription' => 'Talált egy Varázsmacska ikont, amellyel kiegészítették az évfordulós Plesk Obsidian 18.0.50 verziót.',
    'ServerAbout.darkThemePromoButton' => 'Huss! Jöjjön a sötét oldalra.',
    'ServerAbout.darkThemeTourDescription' => 'E beállítást használja a kezelőfelülete sötét témáinak engedélyezésére vagy tiltására.',
    'ServerAbout.darkThemeTourButton' => 'Megértettem',

    'ts-sessions.title' => 'Terminalkiszolgáló munkamenetek',
    'ts-sessions-properties.title' => 'Munkamenet tulajdonságok',

    'BandwidthLimiting.title' => '%%domainName%% sávszélesség korlátozása',
    'BandwidthLimiting.bandwidthThrottling' => 'Nem tudja a sávszélességet korlátozni, mivel nincs telepítve a QoS.',
    'BandwidthLimiting.virtualHostingRequired' => 'Csak webhely üzemeltetéssel rendelkező domainek esetében áll a sávszélesség korlátozás rendelkezésre.',
    'BandwidthLimiting.bandwidthLabel' => 'Maximális használt sávszélesség',
    'BandwidthLimiting.bandwidthHint' => 'Kizárólag a HTTP-protokoll alkalmazásával történő adatátvitelre vonatkozik a sávszélesség használat korlátozás.',
    'BandwidthLimiting.maxConnectionLabel' => 'A következőre korlátozott a kapcsolatszám',
    'BandwidthLimiting.maxConnectionHint' => 'Ha korlátozza a sávszélességet, akkor célszerű korlátozni a webhely egyidejű kapcsolatainak a számát is. Ellenkező esetben gyakori webhely kérelmek esetén a webkiszolgáló eljárásai növelik a kiszolgáló terhelését.',
    'BandwidthLimiting.kbps' => 'kB/s',
    'BandwidthLimiting.success' => 'Megváltoztatásra kerültek a sávszélességet korlátozás beállításai.',
    'BandwidthLimiting.unlimited' => 'Korlátlan',

    'ip-address-domains.title' => '%%type%% %%ipAddress%% IP-címet használó webhelyek',
    'ip-address-domains.site' => 'Hely',
    'ip-address-domains.setAsDefault' => 'Alapértelmezettként beállítás',
    'ip-address-domains.type-SHARED' => 'megosztva',
    'ip-address-domains.type-EXCLUSIVE' => 'dedikált',

    'HotlinkProtection.title' => '%%domainName%% aktív hivatkozás védelme',
    'HotlinkProtection.virtualHostingRequired' => 'Csak webhely üzemeltetéssel rendelkező domainek esetében áll az aktív hivatkozás védelem rendelkezésre.',
    'HotlinkProtection.enabledLabel' => 'Közvetlen hivatkozás elleni védelem engedélyezése',
    'HotlinkProtection.extensionsLabel' => 'Védett fájl bővítmények',
    'HotlinkProtection.friendsLabel' => 'Közelálló webhely címek',
    'HotlinkProtection.success' => 'Megváltoztatásra kerültek az aktív hivatkozás védelem beállításai.',

    'Odbc.serverTitle' => 'ODBC DSN-kapcsolatok',
    'Odbc.domainTitle' => '%%domainName%% ODBC DSN-kapcsolatok',
    'Odbc.add' => 'ODBC DSN hozzáadása',
    'Odbc.resourceUsage' => '%%used%% létrehozott / %%allowed%% engedélyezett.',
    'Odbc.limitExceeded' => 'Az ODBC DSN-kapcsolati korlát túllépés történt.',
    'Odbc.unlimited' => 'Korlátlan',
    'Odbc.addTooltip' => 'Végezze el az ODBC-adatforrás hozzáadását.',
    'Odbc.status' => 'Állapot',
    'Odbc.name' => 'Kapcsolatnév',
    'Odbc.driver' => 'Illeszőprogram',
    'Odbc.description' => 'Kapcsolat leírása',
    'Odbc.hostname' => 'Állomásnév',
    'Odbc.statusSystem' => 'Ez egy rendszer adatforrásnév.',
    'Odbc.statusConfigured' => 'Konfigurálva van az adatforrásnév.',
    'Odbc.statusNotConfigured' => 'Nincs konfigurálva az adatforrásnév.',
    'Odbc.noSelectionText' => 'Válasszon ki egy vagy több eltávolítandó elemet.',
    'Odbc.removeConfirmation' => 'Eltávolításra kerül {count, plural, =1 {{name} kapcsolat} other {# kiválasztott kapcsolat}}?',
    'Odbc.removeSuccess' => 'Megtörtént a kiválasztott kapcsolatok eltávolítása.',

    'DomainAliasSettings.title' => 'Domain alias beállítások',
    'DomainAliasSettings.updateSuccess' => 'Megtörtént %%name%% domain alias tulajdonságainak a változtatása. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => '%%restartInterval%% percen belül alkalmazásra kerülnek webhely beállítások.',

    'HostingSettings.title' => 'Üzemeltetési beállítások',
    'HostingSettings.updateSuccess' => 'Megtörtént a beállítások frissítése.',
    'HostingSettings.emptyLogin' => 'Meg kell adnia egy felhasználónevet.',
    'HostingSettings.emptyPassword' => 'Meg kell adnia egy jelszót.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Az FTP-kiszolgáló nem támogatja az IPv6-protokoll használatát. Foglaljon le legalább egy IPv4-címet, ellenkező esetben a felhasználó nem tud FTP-n keresztül fájlokat feltölteni.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Domain beállítások',
    'HostingSettings.domainSettingsSection.domainName' => 'Domain név',
    'HostingSettings.domainSettingsSection.description' => 'Például, example.com ',

    'HostingSettings.submitPopover.title' => '%%website%% tartalmának az eltávolítása',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'A „Webhely” üzemeltetési típusának "%%type%%" típusra való átkapcsolása a következő könyvtárakkal együtt véglegesen eltávolítja az egész webhely tartalmát:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Meg akarja változtatni webhelye üzemeltetési típusát?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'További beállításokhoz való hozzáféréshez írja be a rendszerfelhasználói hotelesítési adatait, majd kattintson a „Webtárhely létrehozása” gombra.',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'További beállításokhoz való hozzáféréshez, üzemeltetés létrehozása céljából, kattintson a „Tovább” gombra.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Üzemeltetési típus',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Típus',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Webhely',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Továbbítás',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Nincs webes üzemeltetés.',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'A domain DNS-zónáját használja, hogy ezen domain név alá tartozzanak a postaládák.',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'A webhely kezdőkönyvtárának elérési útja.',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Előnyben részesített domain',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Egy keresőmotor-optimalizálás barát HTTP 301 által ide kerülnek átirányításra a látogatók.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Látogatók következő helyre továbbítása:',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Továbbítási típus',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Véglegesen áthelyezve (301 kód)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Irányítsa át a webhely látogatókat másik webhelyre és jelenítse meg a számukra a cél címét. Az ilyen átirányítás megőrzi a webhely rangsorolását.',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Ideiglenesen áthelyezve (302 kód)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Irányítsa át a webhely látogatókat egy ideiglenes webhely másolatra, ha nem akarja, hogy a keresőmotorok indexeljék ezen ideiglenes webhelyet.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Kerettovábbítás',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Irányítsa át a webhely látogatókat másik webhelyre, de nem jelenítse meg a számukra a cél címét, így nem fognak tudni az átirányításról.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Előnyben részesített domain',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Nincs',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Kezdőkönyvtár',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Nem lehetséges a dokumentumgyökér megváltoztatása, mivel webalkalmazások vannak telepítve e webhelyre.',
    'HostingSettings.domainSettingsSection.save' => 'Mentés',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Megváltoztatja ezt a beállítást?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'E beállítás megváltoztatása ellentmond a kiszolgáló biztonsági szabályzatának, továbbá ronthatja a teljesítményét vagy a támadásokkal szemben védtelenebbé teheti a kiszolgálót.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Módosítás',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Visszaállítás',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Előbeállított biztonsági beállítások alkalmazottak',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'A fokozott biztonság érdekében, az előre beállított biztonsági beállításokat alkalmazza. Ne feledje, hogy bizonyos beállítások lehetővé teszik az előfizetők számára ezen beállítások módosítását.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Előre beállított biztonsági beállítások alkalmazása',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'További tudnivalók a biztonságos üzemeltetési beállításokról',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS-támogatás',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Engedélyezett',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Titkosítsa a webhely és a látogató böngészője közötti kapcsolatokat.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Tanúsítvány',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'A HTTPS-szolgáltatás engedélyezéséhez, töltsön fel egy SSL/TLS-tanúsítványt a domain tárolójára, majd itt válassza ki azt.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Keresőmotor-optimalizált 301 átitányítással irányítsa át a látogatókat HTTP protokollról HTTPS protokollra.',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Nincsenek SSL/TLS-tanúsítványok az adattárjában. Egy tanúsítvány hozzáadásához ugorjon ezen %%link%% helyre.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'ezen oldal',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (más tároló)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Nincs kiválasztva.',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Webes parancsnyelv',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Válassza ki, hogy melyik programozási és parancsnyelveket kell a webkiszolgálónak értelmeznie.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => '%%value%% helyen található a CGI-bin könyvtár.',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'SSI használata *.htm, *.html fájlokhoz',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP technológia',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET keretrendszer',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET verzió',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Egyéni hiba dokumentumok',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'A következő helyen található a CGI-bin könyvtár;',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'e domain dokumentumgyökere',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'A webtárhely gyökérkönyvtára',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'e domain régi stílusú gyökere',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Egyéni hiba dokumentumok',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'További írás/olvasás engedélyek',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy közzététele',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Webstatisztikák',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Eszköz',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Az FTP-felhasználónevével és jelszavával védje a webstatisztikáihoz való hozzáférést.',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Letiltva',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Webtérhely beállítások',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP-címek',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Lemezterületi kvóta',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Engedélyezett',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Tiltsa meg a webhely fájl műveleteket, az előfizetési beállítások (ha vannak) között beállított lemezterület kvóta túllépése esetén.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'A szolgáltatás fájlrendszerének konfigurációja miatt nem támogatott merevlemez kvóta használata.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Rendszerfelhasználó hitelesítő adatai',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Webhely fájlok és mappák kezelése FTP szolgáltatáson vagy fájlkezelőn keresztül. Biztonságos héjon keresztüli kiszolgáló hozzáférés, ha engedélyezve van.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Webhely fájlok és mappák kezelése FTP szolgáltatáson vagy fájlkezelőn keresztül. Távoli asztalon keresztüli kiszolgáló hozzáférés, ha engedélyezve van.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Felhasználónév',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Jelszó',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'A rendszerfelhasználó jelszavának megváltoztatására itt adjon meg új jelszót.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH-n keresztüli hozzáférés',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Távoli asztalon keresztüli hozzáférés',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Engedélyezett',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Rendszerfelhasználói hitelesítő adatokkal férjen a kiszolgálóhoz",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Típus',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Letiltva',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => '{count, plural, other {# domain}} esetén',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'A következő beállítások közösek {count, plural, other {# domainnél {name} elnevezésű webtárhely esetén}}:',

    'OdbcAdd.title' => 'ODBC DSN hozzáadása',
    'OdbcAdd.nameLabel' => 'Kapcsolatnév',
    'OdbcAdd.descriptionLabel' => 'Kapcsolat leírása',
    'OdbcAdd.driver' => 'Illeszőprogram',
    'OdbcAdd.submit' => 'ODBC DSN létrehozása',

    'OdbcEdit.title' => 'ODBC-kapcsoalt beállítása',
    'OdbcEdit.saveSuccess' => 'Megtörtént a kapcsolati beállítások mentése.',
    'OdbcEdit.test' => 'Tesztelje a kapcsolatot',
    'OdbcEdit.connectSuccess' => 'A kapcsolódás sikerült.',

    'OdbcEdit.excel.driver.label' => 'Illeszőprogram',
    'OdbcEdit.excel.dbq.label' => 'Adatbázisfájl elérési útja',
    'OdbcEdit.excel.defaultdir.label' => 'Alapértelmezett adatkönyvtár',
    'OdbcEdit.excel.fil.label' => 'Adatbázis verzió',
    'OdbcEdit.excel.maxbuffersize.label' => 'Maximális pufferméret',
    'OdbcEdit.excel.pagetimeout.label' => 'Várakozási idő',

    'OdbcEdit.access.driver.label' => 'Illeszőprogram',
    'OdbcEdit.access.dbq.label' => 'Adatbázisfájl elérési útja',
    'OdbcEdit.access.uid.label' => 'Bejelentkezési azonosító',
    'OdbcEdit.access.pwd.label' => 'Jelszó',
    'OdbcEdit.access.pagetimeout.label' => 'Várakozási idő',
    'OdbcEdit.access.pagetimeout.description' => 'Azon idő tizedmásodpercekben, amíg a használaton kívüli oldal a pufferben marad. Minden Microsoft Access illesztőprogramot használó adatforrásra vonatkozik e beállítás.',
    'OdbcEdit.access.maxbuffersize.label' => 'Maximális pufferméret',
    'OdbcEdit.access.maxbuffersize.description' => 'A 256 kB-os határhoz igazított belső puffer mérete kB-ban.',
    'OdbcEdit.access.readonly.label' => 'Csak olvasható',
    'OdbcEdit.access.readonly.description' => 'A frissítések tiltása érdekében csak olvashatóként jelöli ki az adatbázist.',
    'OdbcEdit.access.exclusive.label' => 'Kizárólagos',
    'OdbcEdit.access.exclusive.description' => 'A megoszott frissítések tiltása érdekében kizárólagosként jelöli ki az adatbázist.',
    'OdbcEdit.access.safetransactions.label' => 'Biztonságos tranzakciók',
    'OdbcEdit.access.safetransactions.description' => 'Ha 0 (az alapértelmezett beállítás) van beállítva, akkor azonnal megtörténik az összes tranzakció jóváhagyása. Ha 1 van beállítva, akkor kizárólag a jóváhagyás művelet elvégzése után történik meg az összes tranzakció lemezre mentése, azonban kissé csökken a teljesítmény.',
    'OdbcEdit.access.threads.label' => 'Szálak',
    'OdbcEdit.access.threads.description' => 'A használatban lévő motor háttérszálainak a száma.',
    'OdbcEdit.access.maxscanrows.label' => 'Keresendő sorok maximális száma',
    'OdbcEdit.access.maxscanrows.description' => 'A keresendő sorok száma, az oszlop adattípusának a meglévő adatok alapján történő beállítása esetén.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Megadja a tranzakciók kívüli végzett változtatások adatbázisra írásának a módját.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Azt határozza meg, hogy az MS Access illesztőprogram aszinkron módon végrehajt-e felhasználó által meghatározott explicit tranzakciókat.',

    'OdbcEdit.mssql.driver.label' => 'Illeszőprogram',
    'OdbcEdit.mssql.server.label' => 'Kiszolgáló',
    'OdbcEdit.mssql.uid.label' => 'Bejelentkezési azonosító',
    'OdbcEdit.mssql.pwd.label' => 'Jelszó',
    'OdbcEdit.mssql.database.label' => 'Alapértelmezett adatbázis',
    'OdbcEdit.mssql.app.label' => 'Alkalmazás neve',
    'OdbcEdit.mssql.wsid.label' => 'Munkaállomás azonosító',
    'OdbcEdit.mssql.language.label' => 'Alapértelmezett nyelv',
    'OdbcEdit.mssql.oemtoansi.label' => 'Speciális karakter konverzió OEM-értékek számára',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC-illesztőprogram',
    'OdbcEdit.mysql.server.label' => 'Kiszolgáló',
    'OdbcEdit.mysql.server.description' => 'A MySQL kiszolgáló állomásneve',
    'OdbcEdit.mysql.database.label' => 'Alapértelmezett adatbázis',
    'OdbcEdit.mysql.user.label' => 'Felhasználónév',
    'OdbcEdit.mysql.user.description' => 'A MySQL-adatbázishoz kapcsolódáshoz használt felhasználónév',
    'OdbcEdit.mysql.password.label' => 'Jelszó',
    'OdbcEdit.mysql.password.description' => 'A kiszolgálón található felhasználói számla jelszava',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'A használandó TCP/IP-port, ha nem a helyi állomás a kiszolgáló.',
    'OdbcEdit.mysql.socket.label' => 'Szoftvercsatorna',
    'OdbcEdit.mysql.socket.description' => 'Windows nevesített cső, melyhez kapcsolódni kell, ha nem a helyi állomás a kiszolgáló.',
    'OdbcEdit.mysql.option.label' => 'Beállítás',
    'OdbcEdit.mysql.option.description' => 'A MyODBC működését meghatározó beállítások. Lásd <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentáció.</a>',

    'ProtectedDirectoryList.title' => '%%domainName%% védett könyvtárai',
    'ProtectedDirectoryList.add' => 'Védett könyvtár hozzáadása',
    'ProtectedDirectoryList.addTooltip' => 'Hozzon létre védett könyvtárat.',
    'ProtectedDirectoryList.name' => 'Név',
    'ProtectedDirectoryList.realmTitle' => 'A védett terület elnevezése',
    'ProtectedDirectoryList.noSelectionText' => 'Válasszon ki egy vagy több eltávolítandó elemet.',
    'ProtectedDirectoryList.edit' => 'Szerkesztés',
    'ProtectedDirectoryList.remove' => 'Védelem eltávolítása',
    'ProtectedDirectoryList.removeTooltip' => 'A védelem eltávolítása a kijelölt könyvtárról.',
    'ProtectedDirectoryList.removeConfirmation' => 'A védelem eltávolítását okozza e művelet {count, plural, =1 {{name} könyvtárból} other {# kiválasztott könyvtárból}}. Ezután {count, plural, =1 {könyvtár} other {könyvtár}} szabadon elérhetővé válnak az internetfelhasználók számára,.',
    'ProtectedDirectoryList.removeSuccess' => 'Megtörtént a kiválasztott könyvtárak eltávolítása.',

    'ProtectedDirectoryAdd.title' => 'Hozzon létre védett könyvtárat',
    'ProtectedDirectoryAdd.submit' => 'Létrehozás',
    'ProtectedDirectoryAdd.success' => 'A védett könyvtár %%path%% létrehozása sikerült',

    'ProtectedDirectoryEdit.title' => 'Védett könyvtár beállítások',
    'ProtectedDirectoryEdit.success' => 'Megváltoztatásra kerültek a védett könyvtár beállításai',

    'ProtectedDirectoryUserList.title' => '%%directory%% védett könyvtár felhasználói',
    'ProtectedDirectoryUserList.add' => 'Felhasználó hozzáadása',
    'ProtectedDirectoryUserList.addTooltip' => 'Hozzon létre felhasználói számlát, hogy hozzáférhessen a védett %%directory%% könyvtárhoz.',
    'ProtectedDirectoryUserList.login' => 'Név',
    'ProtectedDirectoryUserList.changePassword' => 'Jelszó módosítása',
    'ProtectedDirectoryUserList.noSelectionText' => 'Válasszon ki egy vagy több eltávolítandó felhasználót.',
    'ProtectedDirectoryUserList.remove' => 'Eltávolítás',
    'ProtectedDirectoryUserList.removeTooltip' => 'Távolítsa el a kiválasztott felhasználókat.',
    'ProtectedDirectoryUserList.removeConfirmation' => 'Eltávolításra kerül {count, plural, =1 {{name} felhasználó} other {# kiválasztott felhasználó}}?',
    'ProtectedDirectoryUserList.removeSuccess' => 'Távolítsa el a kiválasztott felhasználókat.',

    'ProtectedDirectoryUserAdd.title' => 'Védett könyvtár felhasználó létrehozása',
    'ProtectedDirectoryUserAdd.subtitle' => '%%directory%% könyvtár',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Felhasználónév',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Jelszó',
    'ProtectedDirectoryUserAdd.submit' => 'Létrehozás',
    'ProtectedDirectoryUserAdd.success' => 'Sikerült %%login%% védett könyvtár felhasználó létrehozása.',

    'ProtectedDirectoryUserPassword.title' => 'Védett könyvtár felhasználó jelszava',
    'ProtectedDirectoryUserPassword.subtitle' => 'Felhasználói %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Jelszó',
    'ProtectedDirectoryUserPassword.submit' => 'Mentés',
    'ProtectedDirectoryUserPassword.success' => 'Megtörtént a felhasználó hitelesítő adatainak mentése.',

    'SummaryReport.Layout.title' => 'Jelentés elrendezés tulajdonságok',
    'SummaryReport.Layout.success' => 'Megtörtént %%name%% jelentés elrendezés frissítése.',
    'SummaryReport.Layouts.title' => 'Jelentés elrendezések',

    'SummaryReport.Layout.Add.title' => 'Jelentés elrendezés létrehozása',
    'SummaryReport.Layout.Add.success' => 'Megtörtént %%name%% jelentés elrendezés létrehozása.',

    'SummaryReport.Report.title' => 'Összesítő jelentés',
    'SummaryReport.Report.buttonLayouts' => 'Elrendezések',
    'SummaryReport.Report.buttonSchedule' => 'Ütemezés',
    'SummaryReport.Report.buttonProperties' => 'Tulajdonságok',
    'SummaryReport.Report.buttonTrafficHistory' => 'Forgalmi kimutatás',
    'SummaryReport.Report.buttonPrint' => 'Nyomtatás',
    'SummaryReport.Report.buttonSend' => 'E-mailben küldés',
    'SummaryReport.Report.successSent' => 'Megtörtént %%email%% helyre a jelentés elküldése',

    'SummaryReport.Schedule.title' => '%%name%% kézbesítési ütemezései',
    'SummaryReport.Schedule.Properties.title' => '%%name%% kézbesítési ütemezése',
    'SummaryReport.Schedule.Properties.success' => 'Megtörtént a jelentés kézbesítés ütemezés frissítése.',

    'SummaryReport.Schedule.Add.title' => '%%name%% kézbesítési ütemezésének való létrehozása',
    'SummaryReport.Schedule.Add.success' => 'Megtörtént a jelentés kézbesítés ütemezés létrehozás.',

    'SummaryReport.TrafficHistory.title' => 'Forgalmi kimutatás',

    'VirtualDirectory.title' => '%%domainName%% %%path%% virtuális könyvtára',
    'VirtualDirectory.errNotExist' => 'Nem létező fizikai mappára hivatkozik e virtuális könyvtár.',
    'VirtualDirectory.errNoPermissions' => 'Nem rendelkezik e könyvtár megtekintéséhez szükséges engedéllyel.',
    'VirtualDirectory.buttonProperties' => 'Könyvtár tulajdonságok',
    'VirtualDirectory.buttonPropertiesHint' => 'Tekintse meg a virtuális könyvtár tulajdonságokat és végezze el a változtatásokat.',
    'VirtualDirectory.buttonPermissions' => 'Könyvtár hozzáférési engedélyek',
    'VirtualDirectory.buttonPermissionsHint' => 'Végezze el a könyvtár hozzáférési engedélyek beállítását.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET keretrendszer',
    'VirtualDirectory.buttonAspDotNetHint' => 'Végezze el az ASP.NET beállítások konfigurálását.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Végezze el a PHP-beállítások konfigurálását.',
    'VirtualDirectory.buttonMimeTypes' => 'MIME-típusok',
    'VirtualDirectory.buttonMimeTypesHint' => 'Végezze a regisztrált MIME-típusok kezelését.',
    'VirtualDirectory.buttonErrorDocs' => 'Hibadokumentumok',
    'VirtualDirectory.buttonErrorDocsHint' => 'Végezze el a hiba dokumentumok kezelését.',
    'VirtualDirectory.buttonProtection' => 'Védelem',
    'VirtualDirectory.buttonProtectionHint' => 'Jelszavas védelemmel korlátozza a könyvtárhoz való hozzáférést.',

    'VirtualDirectory.CreateDirectory.title' => 'Könyvtár létrehozása',
    'VirtualDirectory.CreateDirectory.name' => 'Könyvtárnév',
    'VirtualDirectory.CreateDirectory.success' => 'Megtörtént %%name%% könyvtár létrehozása.',
    'VirtualDirectory.CreateDirectory.errExists' => '%%name%% könyvtár már létezik.',

    'VirtualDirectory.AspDotNet.title' => 'ASP.NET beállítások konfigurálása',

    'VirtualDirectory.Php.title' => 'PHP-verzió',
    'VirtualDirectory.Php.version' => 'Verzió',
    'VirtualDirectory.Php.success' => 'Frissítve lett a PHP-verzió.',
];