<?php
// Copyright 1999-2024. Plesk International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => '%%name%% を %%path%% にインストール中...',
    'aps-install.queueNoPath' => '%%name%% をインストール中...',
    'aps-install.done' => '%%name%% は %%path%% に正常にインストールされました。アプリケーションへのログイン用のクレデンシャルを以下で確認できます。%%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% は正常にインストールされました。アプリケーションへのログイン用のクレデンシャルを以下で確認できます。%%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% は %%path%% に正常にインストールされました。%%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% は正常にインストールされました。%%additionalMessage%%',
    'aps-install.error' => '%%path%% における %%name%% のインストールが失敗しました。%%errorMessage%%',
    'aps-install.errorNoPath' => '%%name%% のインストールが失敗しました。%%errorMessage%%',

    'aps-update.queueDownload' => '%%packageName%% をダウンロード中...',
    'aps-update.errorDownload' => '%%packageName%% のダウンロードが失敗しました。',
    'aps-update.queueInstall' => '%%domainName%% 用の %%name%% を更新中...',
    'aps-update.doneInstall' => '%%domainName%% 用の %%name%% が正常に更新されました。',
    'aps-update.errorInstall' => '%%domainName%% 用の %%name%% の更新に失敗しました。',
    'aps-update.queueInstallMulti' => '%%instances%% 件の %%name%% を更新中...',
    'aps-update.doneInstallMulti' => '%%successes%% 件の %%name%% が正常に更新されました。',
    'aps-update.errorInstallMulti' => '%%failures%% 件の %%name%% の更新が失敗しました。',
    'aps-update.incorrectUpdateInformation' => '更新情報が正しくありません。',

    'common.hideCompletedTasks' => '完了したタスクを隠す',
    'common.progressBarHide' => '隠す',
    'common.progressBarShow' => '表示',
    'common.close' => '閉じる',
    'common.refresh' => 'ページ更新',
    'common.taskInProgress' => '%%count%% 件のタスクを処理中です...',
    'common.percentCompleted' => '%%percent%%% 完了',
    'common.allTasksCompleted' => '合計 %%num%% 件のタスクが正常に完了しました。',
    'common.minimize' => '最小化',
    'common.statusDone' => '完了',
    'common.statusError' => '失敗',
    'common.statusNotStarted' => 'キューに登録済',
    'common.statusCanceled' => 'キャンセル済み',
    'common.progressDialogLink' => '進捗の詳細',

    'database-check.queue' => '%%database%% データベーステーブルを確認中...',
    'database-check.done' => '%%database%% データベースにはエラーがありません。',
    'database-check.error' => '%%database%% データベースのエラーを確認できません。',
    'database-check.done-with-errors' => "%%database%% データベースには問題が %%number%% 件あります。\n %%link%%",
    'database-check.info-link-title' => '詳細を確認し、問題を解決',

    'database-download.queue' => '%%database%% ダンプをエクスポート用に準備中...',
    'database-download.done' => '%%database%% のダンプの準備ができました。%%downloadLink%% できます。',
    'database-download.downloadLink' => 'ダウンロード',
    'database-download.error' => '%%database%% のダンプをエクスポートできません。',

    'database-repair.queue' => '%%database%% データベーステーブルを修復中...',
    'database-repair.done' => '%%database%% データベースにはエラーがありません。',
    'database-repair.error' => '%%database%% データベースを修復できません。',
    'database-repair.done-with-errors' => "%%database%% データベースには問題が %%number%% 件あります。\n %%link%%",
    'database-repair.info-link-title' => '詳細を見る',

    'database-upload.queue' => '%%database%% のダンプをインポート中...',
    'database-upload.done' => '%%database%% のダンプがインポートされました。',
    'database-upload.error' => '%%database%% ダンプをアップロードできません。',
    'database-upload.done-with-errors' => "%%database%% のダンプがエラーありでインポートされました。",
    'database-upload.orphanedUsersSuccess' => 'データベース %%database%% が正常にインポートされました。ただし、一部のユーザが孤立しています（データベースサーバに、このユーザに紐付けられたログインがありません）。データベースにアクセスするには、これらのユーザにログインを紐付けてください。%%viewUsersLink%%',
    'database-upload.orphanedUsersError' => '一部のユーザが孤立しています（データベースサーバに、このユーザに紐付けられたログインがありません）。%%orphanedUsers%%。',
    'database-upload.orphanedUsersLink' => 'ユーザを表示',

    'domain-app-scan.queue' => 'アプリケーションをスキャン中...',
    'domain-app-scan.done' => 'アプリケーションのスキャンが完了しました。',
    'domain-app-scan.error' => 'アプリケーションのスキャンがエラー終了しました。',

    'domain-move.queue' => '%%domainName%% を %%webspaceName%% に移動中',
    'domain-move.done' => '%%domainName%% は %%webspaceName%% に移動されました',
    'domain-move.error' => '%%domainName%% は %%webspaceName%% に移動されませんでした',

    'domain-split.queue' => '%%domainName%% を新しい契約に移動中',
    'domain-split.done' => '%%domainName%% が新しい契約に移動されました',
    'domain-split.error' => '%%domainName%% は新しい契約に移動されていません',

    'file-manager-import-file.done' => '%%fileName%% ファイルが <a href="%%listUrl%%">%%fileDir%% フォルダ</a>にインポートされました。',
    'file-manager-import-file.error' => '%%fileName%% ファイルをインポートできません：%%errorMessage%%。<br><a href="%%url%%">自分のコンピュータにダウンロード</a>',
    'file-manager-import-file.queue' => '%%host%% から %%fileName%% ファイルをインポートしています。',
    'file-manager-import-file.progress' => '%%host%% から %%fileName%% ファイルをインポートしています（%%value%% MB）。',
    'file-manager-import-file.errors.auth' => '認証エラーが発生しました。正しいログイン名とパスワードを入力したことを確認してください',
    'file-manager-import-file.errors.resolve' => 'ホスト名 %%host%% を解決できませんでした。正しい URL を入力したことを確認してください',
    'file-manager-import-file.errors.connect' => '%%host%% サーバに接続できませんでした。正しい URL を入力したことを確認してください',
    'file-manager-import-file.errors.notFound' => 'リモートファイルが見つからなかったか、アクセスできません。正しい URL を入力したこととファイルがアクセス可能であることを確認してください',
    'file-manager-import-file.errors.maxSize' => 'ディスク容量の上限または空き容量 %%diskSpaceLimit%% を超過しました',
    'file-manager-import-file.errors.lowSpeedTime' => '転送速度が遅すぎるため、ファイルをインポートできませんでした。過去 %%lowSpeedTime%% 秒間に転送されたのは %%lowSpeedLimit%% バイト未満です。ファイルがホストされているウェブサイトで、大量のトラフィックが発生している可能性があります。後でファイルのインポートをやり直してください',
    'file-manager-import-file.errors.certificate' => 'ファイルをインポートできません。%%host%% サーバの SSL/TLS 証明書が信頼できません。ファイルがホストされているウェブサイトが、信頼できる証明書で保護されていることを確認してください',
    'file-manager-import-file.errors.redirects' => 'リダイレクトの最大数（%%maxRedirects%%）に達しました。%%host%% サーバが正常に機能していることを確認してください',

    'force-log-rotation.queue' => 'グローバルログローテーション設定を適用中',
    'force-log-rotation.done' => 'グローバルログローテーション設定が適用されました。',
    'force-log-rotation.error' => 'グローバルログローテーションの適用がエラー終了しました',
    'force-log-rotation.systemLogRotationError' => 'システムログ：%%error%%',
    'force-log-rotation.planLogRotationError' => 'サービスプラン %%name%%：%%error%%',
    'force-log-rotation.domainLogRotationError' => 'ドメイン %%name%%：%%error%%',

    'initial-setup.queue' => 'Plesk を初期化中...',
    'initial-setup.done' => 'Plesk が初期化されました。',
    'initial-setup.doneWithErrors' => 'Plesk の初期化中にエラーが発生しました。',
    'initial-setup.error' => 'Plesk の初期化に失敗しました。',
    'initial-setup.step.setupPanel' => 'Plesk パネルのセットアップ',
    'initial-setup.step.requestLicense' => 'ライセンスのリクエスト',
    'initial-setup.step.configureServer' => 'ウェブサーバの構成',
    'initial-setup.step.secureServer' => 'サーバのセキュリティ強化',

    'ip-update.queue' => 'IP アドレスの更新',
    'ip-update.done' => 'IP アドレスが更新されました。',
    'ip-update.error' => 'IP アドレスの更新がエラー終了しました',
    'ip-update.updating' => 'IP アドレスの更新',
    'ip-update.updatingWebServer' => 'IP アドレスの更新：ウェブサーバの更新',
    'ip-update.updatingFtpServer' => 'IP アドレスの更新：FTP サーバの更新',
    'ip-update.updatingDnsZones' => 'IP アドレスの更新：DNS ゾーンの更新',
    'ip-update.restartingDnsService' => 'IP アドレスの更新：DNS サーバの再起動',

    'ip-reload-public.queue' => 'クラウドメタデータを使用してパブリック IP アドレスを更新しています',
    'ip-reload-public.done' => 'パブリック IP アドレスが更新されました',

    'logrotate_anonymize_ips.queue' => 'ログ内で IP アドレスを匿名化',
    'logrotate_anonymize_ips.queueRevert' => 'ログ内で IP アドレスの匿名化を解除',
    'logrotate_anonymize_ips.done' => 'IP アドレスが匿名化されました。',
    'logrotate_anonymize_ips.doneRevert' => 'IP アドレスの匿名化が解除されました。',
    'logrotate_anonymize_ips.error' => 'IP アドレスの匿名化がエラー終了しました',
    'logrotate_anonymize_ips.errorRevert' => 'IP アドレスの匿名化の解除がエラー終了しました',

    'panel-components-install.queue' => '選択したコンポーネントをインストールしています。',
    'panel-components-install.done' => '選択したコンポーネントは正常にインストールされました。',
    'panel-components-install.error' => 'コンポーネントをインストールできません。エラーを説明する通知がメール送信されました。',

    'panel-update.queue' => 'Plesk にアップデートをインストールしています。しばらく時間がかかる可能性があります。%%warning%%',
    'panel-update.warning' => '更新が完了するまで、Plesk で管理作業を行わないでください。',
    'panel-update.done' => 'Plesk は更新されました。詳細は %%changelog%% でご確認ください。',
    'panel-update.changelog' => 'Plesk 変更履歴',
    'panel-update.error' => 'Plesk の更新に失敗しました。%%errorDetails%%',
    'panel-update.support' => 'この問題を解決するために、更新ログを Plesk サポートに送信します。%%failedLog%% このメッセージを閉じる前に、コンピュータにログをコピーしてください。',
    'panel-update.failedLog' => '%%date%% 以降の更新ログを確認してください。',

    'pum-update-packages.queue' => '%%count%% パッケージを更新しています...',
    'pum-update-packages.done' => '%%count%% パッケージが正常に更新されました。',
    'pum-update-packages.error' => '更新に失敗しました。',

    'scheduler-run-task.queue' => 'タスク "%%task%%" を実行中...',
    'scheduler-run-task.done' => 'タスク "%%task%%" が %%seconds%% 秒で正常に完了しました。',
    'scheduler-run-task.error' => 'タスク "%%task%%" が %%seconds%% 秒でエラー終了しました。',
    'scheduler-run-task.popupSeeDetails' => '詳細を見る',
    'scheduler-run-task.popupTitle' => 'スケジュール済みタスクを実行',
    'scheduler-run-task.popupDone' => 'タスク "%%task%%" が %%seconds%% 秒で正常に完了しました。出力：',
    'scheduler-run-task.popupError' => 'タスク "%%task%%" が %%seconds%% 秒でエラー終了しました。出力：',
    'scheduler-run-task.popupClose' => '閉じる',

    'sdk.queue' => 'タスク "%%name%%" は実行中です...',
    'sdk.error' => 'タスク "%%name%%" が失敗しました。',
    'sdk.done' => 'タスク "%%name%%" が完了しました。',
    'sdk.canceled' => 'タスク "%%name%%" がキャンセルされました。',

    'sync-php-settings.queue' => 'グローバル PHP %%version%% 設定をドメインに適用しています',
    'sync-php-settings.done' => 'グローバル PHP %%version%% 設定がドメインに正常に適用されました。',
    'sync-php-settings.error' => 'グローバル PHP %%version%% 設定をドメインに適用する際にエラーが発生しました',

    'sync-service-plan.queue' => 'サービスプラン %%name%% を契約と同期しています',
    'sync-service-plan.done' => 'サービスプラン %%name%% が契約と正常に同期されました',
    'sync-service-plan.doneWithErrors' => 'サービスプラン %%name%% の同期が完了しました。一部の契約がプランと同期されませんでした',
    'sync-service-plan.error' => 'サービスプラン %%name%% と契約の同期中にエラーが発生しました',

    'domain-create.queue' => 'ドメイン %%domainName%% を作成しています',
    'domain-create.done' => 'ドメイン %%domainName%% が作成されました',
    'domain-create.error' => 'ドメイン %%domainName%% の作成に失敗しました',
    'domain-create.warning' => 'ドメイン %%domainName%% が作成されましたが、いくつか問題があります：<br> %%problems%%',
    'domain-create.refreshUrl' => '表示',
    'domain-create.steps.createCustomer' => '顧客の作成',
    'domain-create.steps.createSubscription' => '契約を作成しています',
    'domain-create.steps.createDomain' => 'ドメインの追加',
    'domain-create.steps.configureDns' => 'DNS ゾーンの構成',
    'domain-create.steps.createHosting' => '物理ホスティングの作成',
    'domain-create.steps.configurePhp' => 'PHP の構成',
    'domain-create.steps.configureMail' => 'メールの構成',

    'domain-delete.queue' => 'ドメインの削除を処理中',
    'domain-delete.done' => 'ドメインを削除しました',
    'domain-delete.error' => 'ドメインの削除に失敗しました',
    'domain-delete.step.domains' => 'ドメインを削除中…',

    'domain-resolve-checking.warning' => 'ドメイン %%domainName%% の解決で問題が検知されました：<br> %%errors%%',

    'customer-create.queue' => '顧客 %%customerName%% の作成を処理中',
    'customer-create.done' => '顧客 %%customerName%% が作成されました',
    'customer-create.error' => '顧客 %%customerName%% の作成に失敗しました',
    'customer-create.warning' => '顧客 %%customerName%% が作成されましたが、いくつか問題があります：<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => '手動で同期できます。',

    'customer-delete.queue' => '顧客の削除を処理中',
    'customer-delete.done' => '顧客を削除しました',
    'customer-delete.error' => '顧客の削除に失敗しました',

    'reseller-delete.queue' => 'リセラーの削除を処理中',
    'reseller-delete.done' => 'リセラーを削除しました',
    'reseller-delete.error' => 'リセラーの削除に失敗しました',

    'subscription-create.queue' => '契約 %%subscriptionName%% の作成を処理中',
    'subscription-create.done' => '契約 %%subscriptionName%% が作成されました',
    'subscription-create.error' => '契約 %%subscriptionName%% の作成に失敗しました',
    'subscription-create.warning' => '契約 %%subscriptionName%% が作成されましたが、いくつか問題があります：<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => '手動で同期できます。',

    'subscription-delete.queue' => '契約の削除を処理中',
    'subscription-delete.done' => '契約を削除しました',
    'subscription-delete.error' => '契約の削除に失敗しました',

    'websites-diagnostic.queue' => 'ウェブサイト診断を実行中',
    'websites-diagnostic.done' => 'ウェブサイト診断が完了',
    'websites-diagnostic.error' => 'ウェブサイト診断がエラーありで完了',

    'install-php-extension.queue' => 'PHP ハンドラ %%phpHandlerName%% に %%extensionName%% パッケージをインストール中',
    'install-php-extension.done' => '%%extensionName%% パッケージが PHP ハンドラ %%phpHandlerName%% にインストールされました',
    'install-php-extension.error' => 'PHP ハンドラ %%phpHandlerName%% への %%extensionName%% パッケージのインストールに失敗しました',
    'install-php-extension.step.validate' => '要件をチェック中',
    'install-php-extension.step.dependencies' => '依存関係を解決中',
    'install-php-extension.step.process' => 'パッケージをインストール中',
    'install-php-extension.step.enable' => '拡張を有効化中',
    'install-php-extension.step.sync' => 'サイトを同期中',
    'install-php-extension.errorReason' => '利用可能なパッケージのリストは PECL によって提供されます。インストールが失敗する一般的な理由には、次のようなものがあります。',
    'install-php-extension.errorReasonDependencies' => '- パッケージに追加ライブラリとの外部依存関係がある。',
    'install-php-extension.errorReasonRequirements' => '- パッケージがインストール要件を満たしていない（OS、PHP バージョンなど）。',
    'install-php-extension.errorReasonOutdated' => '- パッケージが古い。',
    'install-php-extension.errorOutput' => 'インストールが失敗した理由を特定するには、ユーティリティの出力を確認してください。',

    'uninstall-php-extension.queue' => 'PHP ハンドラ %%phpHandlerName%% から %%extensionName%% パッケージをアンインストール中',
    'uninstall-php-extension.done' => '%%extensionName%% パッケージが PHP ハンドラ %%phpHandlerName%% からアンインストールされました',
    'uninstall-php-extension.error' => 'PHP ハンドラ %%phpHandlerName%% からの %%extensionName%% パッケージのアンインストールに失敗しました',
    'uninstall-php-extension.step.validate' => '要件をチェック中',
    'uninstall-php-extension.step.process' => 'パッケージをアンインストール中',
    'uninstall-php-extension.step.sync' => 'ウェブサイトを同期中',

    'upgrade-database-server.queue' => 'データベースサーバをアップグレード中',
    'upgrade-database-server.error' => 'データベースサーバのアップグレードに失敗',
    'upgrade-database-server.done' => 'データベースサーバがアップグレードされました',
    'upgrade-database-server.step.validate' => 'システムをチェック中',
    'upgrade-database-server.step.dump' => 'データベースダンプを作成中',
    'upgrade-database-server.step.disableService' => '古いシステムサービスを無効化中',
    'upgrade-database-server.step.configureRepo' => '新規リポジトリを構成中',
    'upgrade-database-server.step.upgradePackages' => 'データベースサーバをアップグレード中',
    'upgrade-database-server.step.updateConfiguration' => 'サーバ構成を更新中',
    'upgrade-database-server.step.startService' => '新規システムサービスを起動中',
    'upgrade-database-server.step.upgradeTablesStructure' => 'すべてのテーブルの構造をアップグレード',
    'upgrade-database-server.step.sync' => 'システムコンポーネントを同期中',

    'update-spam-filter-individual-settings.queue' => 'スパムフィルタ設定を更新中',
    'update-spam-filter-individual-settings.done' => 'スパムフィルタ設定が更新されました',
    'update-spam-filter-individual-settings.error' => 'スパムフィルタ設定の更新に失敗しました',
    'update-spam-filter-individual-settings.mailNameError' => 'メールアドレス %%name%%：%%error%%',

    'update-default-cert.queue' => 'デフォルトの証明書を更新中',
    'update-default-cert.done' => 'デフォルトの証明書が更新されました。',
    'update-default-cert.error' => 'デフォルトの証明書の更新がエラーありで終了しました。',
    'update-default-cert.step.updating' => 'デフォルトの証明書を更新中…',
];