<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'adminaliases.statusActive' => '該帳戶處於啟動狀態。',
    'adminaliases.statusInactive' => '帳戶已被掛起：該管理員無法登錄到 Plesk。',
    'adminaliases.buttonRemoveAdminAlias' => '移除',
    'adminaliases.hintRemoveAdminAlias' => '移除選定的管理員帳戶。',
    'adminaliases.confirmOnRemove' => '您真的要移除選定的管理員帳戶？',
    'adminaliases.buttonAddNewAdminAlias' => '添加管理員帳戶',
    'adminaliases.hintAddNewAdminAlias' => '創建一個其它的管理員帳戶。',
    'adminaliases.buttonMoreActions' => '更多',
    'adminaliases.buttonActivateAdminAlias' => '啟動',
    'adminaliases.hintActivateAdminAlias' => '啟動掛起的管理員帳戶。',
    'adminaliases.buttonDeactivateAdminAlias' => '掛起',
    'adminaliases.hintDeactivateAdminAlias' => '掛起選定的管理員帳戶。Plesk 將會拒絕這些管理員的存取。',
    'adminaliases.confirmOnDelete' => '您真的要移除選定的管理員帳戶嗎？',
    'adminaliases.login' => '用戶名',
    'adminaliases.contact' => '聯繫名稱',
    'adminaliases.email' => '電郵地址',
    'adminaliases.comments' => '備註',

    'appinfo.installedAt' => '安裝路徑',
    'appinfo.noInstallationUrlAvailable' => '無',
    'appinfo.subscriptionName' => '訂閱',
    'appinfo.subscriptionOwner' => '訂閱所有者',
    'appinfo.buttonLogin' => '在客戶面板中打開',
    'appinfo.buttonLoginClassicMode' => '管理主機',
    'appinfo.hintLogin' => '打開訂戶的客戶面板。',
    'appinfo.hintAdminLogin' => '管理與某個主機帳戶相關聯的主機服務：域名與 DNS、web 應用程式與資料庫、郵件等等。',
    'appinfo.hintLoginClassicMode' => '管理與某個主機帳戶相關聯的主機服務：域名與 DNS、web 應用程式與資料庫、郵件等等。',
    'appinfo.update' => '有可用的更新。',
    'appinfo.updateFailed' => '更新失敗。',
    'appinfo.noUpdates' => '無可用更新。',
    'appinfo.foundUpdates' => '下列應用程式可用的更新:',
    'appinfo.buttonCheckForUpdates' => '檢查更新',
    'appinfo.buttonCheckForUpdatesDescription' => '檢查可用的更新。',
    'appinfo.buttonChangeSettings' => '設定',
    'appinfo.buttonChangeSettingsDescription' => '更改應用程式的伺服器級設定。',
    'appinfo.appNotConfigured' => '未配置',

    'appuploaded.name' => '名稱',
    'appuploaded.numberOfInstances' => '安裝數量',
    'appuploaded.buttonUploadNewApp' => '添加應用程式',
    'appuploaded.buttonUploadNewAppDescription' => '添加應用套裝程式到伺服器。',
    'appuploaded.buttonRemove' => '移除',
    'appuploaded.buttonRemoveDescription' => '移除所選套裝程式。',
    'appuploaded.confirmOnDelete' => '您確定要移除所選套裝程式嗎？',
    'appuploaded.appInvisible' => '對客戶不可用',
    'appuploaded.appGlobalSettingsNotSet' => '未配置',
    'appuploaded.buttonMakeAppVisible' => '設為可用',
    'appuploaded.buttonMakeAppVisibleDescription' => '設定客戶可安裝應用程式。',
    'appuploaded.buttonMakeAppInvisible' => '設為不可用',
    'appuploaded.buttonMakeAppInvisibleDescription' => '設定客戶無法安裝應用程式。',

    'appusage.name' => '名稱',
    'appusage.numberOfInstances' => '安裝數量',
    'appusage.buttonCleanApplicationCache' => '清除緩存',
    'appusage.buttonCleanApplicationCacheDescription' => '在應用程式安裝過程中刪除下載的暫存檔案。',
    'appusage.buttonRedirectToMarket' => '轉到線上商店',
    'appusage.buttonRedirectToMarketDescription' => '購買要安裝到網站上的應用程式許可證。',
    'appusage.updateFailed' => '更新失敗。',
    'appusage.noUpdates' => '無可用更新。',
    'appusage.foundUpdates' => '可供下列應用程式使用的更新:',
    'appusage.buttonCheckForUpdates' => '檢查更新',
    'appusage.buttonCheckForUpdatesDescription' => '在應用程式目錄中檢查可用更新。',
    'appusage.buttonUpdateSettings' => '更新設定',
    'appusage.buttonUpdateSettingsDescription' => '伺服器級的應用程式更新設定',

    'controlpanelaccessnetworks.ipAddress' => 'IP 地址',
    'controlpanelaccessnetworks.subnetMask' => '子網路遮罩',
    'controlpanelaccessnetworks.buttonAddNewNetwork' => '添加網路',
    'controlpanelaccessnetworks.buttonAddNewNetworkDescription' => '按一下將該網路添加到限制存取清單中。',
    'controlpanelaccessnetworks.buttonRemove' => '移除',
    'controlpanelaccessnetworks.buttonRemoveDescription' => '按一下以刪除所選的網路。',
    'controlpanelaccessnetworks.confirmOnDelete' => '您想要移除所選網路嗎？',
    'controlpanelaccessnetworks.buttonSettings' => '設定',
    'controlpanelaccessnetworks.buttonSettingsDescription' => '按一下更改限制存取策略。',
    'controlpanelaccessnetworks.loadingTitle' => '請稍候。載入中...',

    'customers.filterCustomerName' => '客戶名稱',
    'customers.filterSubscription' => '訂閱',
    'customers.filterOptionSubscriptionAny' => '任何',
    'customers.filterOptionSubscriptionMy' => '我的方案',
    'customers.filterOptionSubscriptionReseller' => '%%planOwnerContactName%%的方案', // Note for translators: you can use here structure like "Plans of Reseller <name>" or alike if it is more convenient
    'customers.filterOptionSubscriptionCustom' => '自訂',
    'customers.filterOwnership' => '服務商',
    'customers.filterOptionOwnershipAny' => '所有客戶',
    'customers.filterOptionOwnershipMy' => '我的客戶',
    'customers.filterOwnershipReseller' => '%%resellerContactName%%的客戶', //Note for translators: see 'filterOptionSubscriptionReseller'
    'customers.filterResourceUsage' => '資源使用量',
    'customers.filterOptionResourceUsageAny' => '任何',
    'customers.filterOptionResourceUsageOveruse' => '超額使用資源',
    'customers.filterOptionResourceUsageOk' => '在限制內',
    'customers.filterStatus' => '狀態',
    'customers.filterOptionStatusAny' => '任何',
    'customers.filterOptionStatusSuspended' => '掛起',
    'customers.filterOptionStatusActive' => '活動',
    'customers.filterDescription' => '描述',
    'customers.statusOk' => '此客戶帳戶處於活動狀態。',
    'customers.statusInactive' => '該客戶帳戶已被停用：該客戶被阻止存取客戶面板。',
    'customers.statusSuspended' => '客戶帳戶被掛起：會阻止客戶與其所有使用者存取客戶面板；掛起客戶的域名，互聯網用戶無法存取他們的網站、FTP 和郵件服務。',
    'customers.customerName' => '客戶名稱',
    'customers.subscription' => '訂閱',
    'customers.setupDate' => '創建日期',
    'customers.ownerName' => '服務商',
    'customers.buttonLogin' => '以客戶身份登入',
    'customers.buttonLoginClassicMode' => '管理主機',
    'customers.hintLogin' => '以客戶身份登入。',
    'customers.hintLoginClassicMode' => '管理與客戶主機帳戶相關聯的主機服務：域名與 DNS、web 應用程式與資料庫、郵件等等。',
    'customers.buttonRemoveCustomer' => '移除',
    'customers.hintRemoveCustomer' => '移除所選客戶。',
    'customers.confirmOnRemove' => '您確定要移除所選客戶帳戶嗎？',
    'customers.buttonConvertCustomersToReseller' => '轉換為代理商',
    'customers.hintConvertCustomersToReseller' => '轉換所選客戶為代理商。',
    'customers.buttonAddNewCustomer' => '添加客戶',
    'customers.hintAddNewCustomer' => '創建客戶帳戶及訂閱。',
    'customers.buttonChangeStatus' => '更改狀態',
    'customers.hintChangeStatus' => 'Change the customer\'s status to "Active" or "Suspended"',
    'customers.buttonSuspendCustomers' => '掛起',
    'customers.hintSuspendCustomers' => '掛起所選客戶帳戶：客戶與其所有使用者將無法存取客戶面板；客戶的域名也將被掛起，互聯網用戶則無法再存取其網站、FTP 和郵件等服務。',
    'customers.buttonActivateCustomers' => '啟動',
    'customers.hintActivateCustomers' => '啟動所選客戶帳戶。',
    'customers.buttonChangeOwner' => '移動到',
    'customers.hintChangeOwner' => '移動所選客戶到其它代理商。',
    'customers.customPlanName' => '自訂',
    'customers.selectNewIp' => '選擇一個 IP 位址',
    'customers.selectAnotherOwner' => '選擇一個所有者',
    'customers.shared' => '共用',
    'customers.exclusive' => '獨立',
    'customers.confirmOnDelete' => '您確定要移除 {count, plural, =1 {{name} 客戶帳戶} other {# 選定的客戶帳戶}}?',
    'customers.hintInfo' => '(?)',

    'customerserviceplans.planName' => '方案名稱',
    'customerserviceplans.planTraffic' => '流量',
    'customerserviceplans.planDiskSpace' => '磁碟空間',
    'customerserviceplans.planSubscriptions' => '訂閱',
    'customerserviceplans.planOwner' => '服務商',
    'customerserviceplans.filterPlanItem' => '自訂方案項目',
    'customerserviceplans.filterOptionPlanItemAny' => '任何一個',
    'customerserviceplans.filterOwnership' => '方案所有者',
    'customerserviceplans.filterOptionOwnershipAny' => '所有方案',
    'customerserviceplans.filterOptionOwnershipMy' => '我的方案',
    'customerserviceplans.filterOwnershipReseller' => '%%resellerContactName%%的方案',
    'customerserviceplans.unlimited' => '無限',
    'customerserviceplans.addonPlanType' => '（附加方案）',
    'customerserviceplans.buttonAddNewPlan' => '添加方案',
    'customerserviceplans.hintAddNewPlan' => '創建主機方案。',
    'customerserviceplans.buttonDuplicatePlans' => '克隆方案',
    'customerserviceplans.hintDuplicatePlans' => '克隆選定的服務方案。',
    'customerserviceplans.buttonAddNewAddonPlan' => '添加附加方案',
    'customerserviceplans.hintAddNewAddonPlan' => '創建附加主機方案。',
    'customerserviceplans.buttonRemove' => '移除',
    'customerserviceplans.hintRemove' => '移除所選服務方案。',
    'customerserviceplans.buttonMoreActions' => '更多操作',
    'customerserviceplans.confirmOnDelete' => '您確定要移除所選服務方案嗎？',
    'customerserviceplans.disabledSelectHint' => '此服務至少有一個關聯訂閱，無法刪除此訂閱。',

    'domains.filterHint' => 'Filter domains by criteria',
    'domains.filterDomainName' => '名稱',
    'domains.filterStatus' => '狀態',
    'domains.filterOptionStatusAny' => '任何',
    'domains.filterOptionStatusSuspended' => '掛起',
    'domains.filterOptionStatusDisabled' => '禁用',
    'domains.filterOptionStatusActive' => '活動',
    'domains.filterHostingType' => '主機類型',
    'domains.filterPhpHandler' => 'PHP 處理常式',
    'domains.filterOptionPhpHandlerAny' => '任何',
    'domains.filterOptionHostingTypeAny' => '任何',
    'domains.filterOptionHostingTypeNone' => '無主機',
    'domains.filterOptionHostingTypeForward' => '域名轉發',
    'domains.filterOptionHostingTypeAlias' => '域名別名',
    'domains.filterOptionHostingTypeVirtualHost' => '域名主機',
    'domains.filterOptionHostingTypeSubdomain' => '子域名主機',
    'domains.filterSubscriberName' => '訂戶',
    'domains.filterServiceNode' => '服務節點',
    'domains.filterServiceNodeOptionAny' => '任意',
    'domains.filterDescription' => '描述',
    'domains.filterTitlePlaceholder' => '查找域名......',
    'domains.filterTitle' => '過濾',
    'domains.filterApply' => '應用篩檢程式',
    'domains.filterClear' => '清除',
    'domains.statusDisabled' => '該域已被禁用。',
    'domains.statusSuspended' => '該域名已掛起。',
    'domains.domainName' => '域名',
    'domains.hostingType' => '主機類型',
    'domains.ownerName' => '訂戶',
    'domains.setupDate' => '創建日期',
    'domains.expirationDate' => '到期日',
    'domains.diskUsage' => '磁片使用',
    'domains.traffic' => '流量',
    'domains.status' => '狀態',
    'domains.description' => '描述',
    'domains.resellerDescription' => '代理商',
    'domains.ownerDescription' => '客戶',
    'domains.openSite' => '打開',
    'domains.previewSite' => '預覽',
    'domains.manageInResellerPanel' => '在代理商面板中管理',
    'domains.manageInCustomerPanel' => '在客戶面板中管理',
    'domains.customPlanName' => '自訂',
    'domains.website' => '網站',
    'domains.subdomainWebsite' => '子域名網站',
    'domains.noHosting' => '無主機',
    'domains.forwardingTo' => '轉發至',
    'domains.aliasFor' => '別名',
    'domains.forwardingToDomain' => '轉發到 %%domain%%',
    'domains.aliasForDomain' => '%%domain%%的別名',
    'domains.add' => '添加',
    'domains.buttonAddDomain' => '新增網域',
    'domains.hintAddDomain' => '在此伺服器上託管新的網站，設定網站轉發，或如果想要一個域名下只有一個電郵位址，則可設定一個域名 DNS 區域。',
    'domains.buttonAddSubdomain' => '添加子域名',
    'domains.hintAddSubdomain' => '創建一個三級域名，如 shop.example.com。',
    'domains.buttonAddDomainAlias' => '添加域名別名',
    'domains.hintAddDomainAlias' => '為網站設定其它的域名。',
    'domains.hintRemove' => '移除選定的網站和其所有的網站內容、應用程式、資料庫和郵件。',
    'domains.removeConfirmation' => '您確定要移除 {count, plural, =1 {{name} 域名} other {# 個選定的域名}}?',
    'domains.removeConfirmationSubscription' => "還將移除下列域名：%%domains%%",
    'domains.buttonSetStatus' => '設定狀態',
    'domains.hintSetStatus' => 'Change the domain\'s status to "Active", "Suspended", or "Disabled"',
    'domains.activateActionStatus' => '活動',
    'domains.hintActivateDomains' => '設定選定的域名處於活動狀態。',
    'domains.disableActionStatus' => '禁用',
    'domains.hintDisableDomains' => '禁用選定的域名。',
    'domains.suspendActionStatus' => '掛起',
    'domains.hintSuspendDomains' => '掛起選定的域名。',
    'domains.changeStatusNoItems' => '選擇一個或多個網域以變更其狀態',
    'domains.removeNoItems' => '選擇要移除的一個或多個域名',
    'domains.activated' => '選定的域名與別名已啟動。',
    'domains.disabled' => '選定的域名與別名已停用。',
    'domains.suspended' => '選定的域名與別名已暫時停用。',

    'dnsaclrecords.value' => 'IP 地址',
    'dnsaclrecords.add' => '添加 IP 地址',
    'dnsaclrecords.remove' => '移除',
    'dnsaclrecords.hintRemove' => '刪除選定的 IP 位址。',
    'dnsaclrecords.confirmOnDelete' => '移除選定的 IP 位址？',
    'dnsaclrecords.emptyViewTitle' => '不允許區域傳輸',
    'dnsaclrecords.emptyViewDescription1' => '出於安全原因，您可以只允許將DNS區域傳輸到該區域的NS記錄中指定的伺服器上。',
    'dnsaclrecords.emptyViewDescription2' => '要指定一個或多個允許傳輸到的伺服器，請按一下“添加IP位址”。',

    'eventhandlers.event' => '事件',
    'eventhandlers.priority' => '優先順序',
    'eventhandlers.priorityHighest' => '最高 (%%value%%)',
    'eventhandlers.priorityHigh' => '高 (%%value%%)',
    'eventhandlers.priorityNormal' => '正常 (%%value%%)',
    'eventhandlers.priorityLow' => '低 (%%value%%)',
    'eventhandlers.priorityLowest' => '最低 (%%value%%)',
    'eventhandlers.user' => '用戶',
    'eventhandlers.command' => '命令',
    'eventhandlers.buttonAddNewEventHandler' => '添加事件處理常式',
    'eventhandlers.buttonAddNewEventHandlerDescription' => '設定新的事件處理常式。',
    'eventhandlers.buttonRemove' => '移除',
    'eventhandlers.buttonRemoveDescription' => '移除所選的事件處理常式。',
    'eventhandlers.confirmOnDelete' => '刪除所選的事件處理常式？',

    'firewallicmprules.status' => '狀態',
    'firewallicmprules.on' => '規則有效。',
    'firewallicmprules.off' => '規則無效。',
    'firewallicmprules.name' => '規則名稱',
    'firewallicmprules.allowinboundrouterrequest' => '允許入站路由器請求',
    'firewallicmprules.allowinboundtimestamprequest' => '允許入站時間戳記請求',
    'firewallicmprules.allowinboundmaskrequest' => '允許入站遮罩請求',
    'firewallicmprules.allowoutboundsourcequench' => '允許出站源抑制',
    'firewallicmprules.allowoutboundparameterproblem' => '允許出站參數問題',
    'firewallicmprules.allowredirect' => '允許重定向',
    'firewallicmprules.allowinboundechorequest' => '允許入站回應要求',
    'firewallicmprules.allowoutboundtimeexceeded' => '允許出站時間超時',
    'firewallicmprules.allowoutbounddestinationunreachable' => '允許出站目標不能達到',

    'firewallinterfaces.firewall' => '防火牆狀態',
    'firewallinterfaces.firewallOn' => '該網路介面上的防火牆已啟用。',
    'firewallinterfaces.firewallOff' => '該網路介面上的防火牆已禁用。',
    'firewallinterfaces.connection' => '介面狀態',
    'firewallinterfaces.connectionOn' => '網路介面連接已啟用。',
    'firewallinterfaces.connectionOff' => '網路介面連接已禁用。',
    'firewallinterfaces.name' => '介面名稱',
    'firewallinterfaces.type' => '介面類別型',
    'firewallinterfaces.statusOn' => '啟用',
    'firewallinterfaces.statusOff' => '停用',

    'firewallrules.status' => '狀態',
    'firewallrules.on' => '規則有效。',
    'firewallrules.off' => '規則無效。',
    'firewallrules.name' => '規則名稱',
    'firewallrules.description' => '描述',
    'firewallrules.descriptionText' => '來自埠 %%port%% 上 %%from%% 的傳入連接，設定檔：%%profiles%%',
    'firewallrules.allow' => '允許',
    'firewallrules.block' => '拒絕',
    'firewallrules.fromAll' => '所有',
    'firewallrules.groupAdd' => '添加',
    'firewallrules.buttonAdd' => '添加規則',
    'firewallrules.buttonAddHint' => '添加防火牆規則',
    'firewallrules.groupActions' => '操作',
    'firewallrules.buttonRemove' => '移除',
    'firewallrules.removeEmptySelection' => '未選擇防火牆規則。',
    'firewallrules.removeConfirmation' => '移除 {count, plural, =1 {{name} 防火牆規則} other {# 選定的防火牆規則}}?',
    'firewallrules.removeSuccess' => '選定的防火牆規則已被移除。',

    'ftpsessions.buttonRemove' => '關閉',
    'ftpsessions.buttonRemoveDescription' => '結束所選的 FTP 會話',
    'ftpsessions.buttonRefresh' => '刷新',
    'ftpsessions.buttonRefreshDescription' => '刷新螢幕上的資料',
    'ftpsessions.typeColumnName' => 'T',
    'ftpsessions.statusColumnName' => '秒',
    'ftpsessions.loginColumnName' => '登入名',
    'ftpsessions.domainColumnName' => '域名',
    'ftpsessions.currentLocationColumnName' => '當前位置',
    'ftpsessions.fileNameColumnName' => '檔案名',
    'ftpsessions.speedColumnName' => '速度，KB/S',
    'ftpsessions.progressColumnName' => '進度，%',
    'ftpsessions.ipAddressColumnName' => 'IP 地址',
    'ftpsessions.logonTimeColumnName' => '登入時間',
    'ftpsessions.idleTimeColumnName' => '閒置時間',
    'ftpsessions.sessionTypeDomainAdminTooltip' => '域名管理員的會話。',
    'ftpsessions.sessionTypeSubDomainAdminTooltip' => '子域名管理員會話。',
    'ftpsessions.sessionTypeWebUserTooltip' => '網站用戶會話。',
    'ftpsessions.sessionTypeFtpAccountTooltip' => 'FTP子帳戶會話。',
    'ftpsessions.sessionTypeAnonymousTooltip' => '匿名 FTP 用戶會話。',
    'ftpsessions.sessionTypeNotPleskUserTooltip' => '未在 Plesk 中註冊的 FTP 用戶。',
    'ftpsessions.sessionStatusIdle' => '客戶發送的最後一個命令是 IDLE。',
    'ftpsessions.sessionStatusUploadInProgress' => '客戶發送的最後一個命令是 UPLOAD。',
    'ftpsessions.sessionStatusDownloadInProgress' => '客戶發送的最後一個命令是 DOWNLOAD。',
    'ftpsessions.sessionStatusDownloadingDirsList' => '客戶發送的最後一個命令是 LIST。',
    'ftpsessions.sessionStatusLastCmdIsType' => '客戶發送的最後一個命令是TYPE。',
    'ftpsessions.sessionStatusLastCmdIsPass' => '客戶發送的最後一個命令是PASS。',
    'ftpsessions.sessionStatusLastCmdIsNoop' => '客戶發送的最後一個命令是NOOP。',
    'ftpsessions.sessionStatusNotKnown' => '客戶發送的最後一個命令的類型未知。',
    'ftpsessions.confirmOnDelete' => '您確定要結束所選會話嗎？',

    'ipaddresses.buttonAddNewIpAddress' => '添加 IP 地址',
    'ipaddresses.buttonAddNewIpAddressDescription' => '在 IP 位址的伺服器池裡添加一個 IP 位址。',
    'ipaddresses.buttonRereadConfiguration' => '重新讀取 IP',
    'ipaddresses.buttonRereadConfigurationDescription' => 'IP 地址清單與網路介面卡的配置同步。',
    'ipaddresses.buttonReloadPublic' => '更新公共 IP',
    'ipaddresses.buttonReloadPublicDescription' => '根據 hyperscaler（超大規模業者）實例中繼資料更新公共 IP 位址',
    'ipaddresses.buttonFirewall' => '防火牆',
    'ipaddresses.buttonFirewallDescription' => '設定防火牆。',
    'ipaddresses.buttonRemove' => '移除',
    'ipaddresses.buttonRemoveDescription' => '移除',
    'ipaddresses.confirmOnDelete' => '移除選定的 IP 位址？',
    'ipaddresses.address' => 'IP 地址',
    'ipaddresses.publicAddress' => '公共 IP 地址',
    'ipaddresses.type' => 'IP類型',
    'ipaddresses.interface' => '介面',
    'ipaddresses.resellerCount' => '代理商',
    'ipaddresses.subscriptionCount' => '網站',
    'ipaddresses.typeAny' => '任一個',
    'ipaddresses.typeShared' => '共用',
    'ipaddresses.typeExclusive' => '獨立',
    'ipaddresses.typeSharedHint' => '共用',
    'ipaddresses.typeExclusiveHint' => '獨立',
    'ipaddresses.ipAddressBroken' => '此 IP 位址未正確配置。',
    'ipaddresses.ipAddressBlacklisted' => '該 IP 地址被列入黑名單。',
    'ipaddresses.repair' => '修理',
    'ipaddresses.buttonSearch' => '搜尋',
    'ipaddresses.buttonResetSearch' => '重置搜尋',
    'ipaddresses.removeConfirmation' => '您確定要移除 {count, plural, =1 {{name} IP 位址} other {# 選定的 IP 位址}}?',
    'ipaddresses.hint' => '查看、添加、移除 IP 地址。',
    'ipaddresses.hintWithResellers' => '查看、添加、移除 IP 地址，並分配 IP 位址給代理商。',
    'ipaddresses.repairSuccess' => '此 IP 位址%%address%%曾與系統同步。',
    'ipaddresses.removeSuccess' => '已移除選定的 IP 位址。',

    'resourceusage.clientName' => '客戶名稱',
    'resourceusage.domainName' => '域名',
    'resourceusage.diskUsage' => 'DU',
    'resourceusage.traffic' => 'TR',
    'resourceusage.subDomainsCount' => 'SD',
    'resourceusage.webUsersCount' => 'WU',
    'resourceusage.databasesCount' => 'DB',
    'resourceusage.mailBoxesCount' => 'MBox',
    'resourceusage.autoRepliesCount' => 'MA',
    'resourceusage.mailForwardingsCount' => 'MF',
    'resourceusage.mailListsCount' => 'ML',
    'resourceusage.sendByEmail' => '按一下通過電子郵件發送此報告。',
    'resourceusage.buttonSendByEmail' => '通過電子郵件發送',
    'resourceusage.noResults' => '沒有關於網域資源使用的資訊。',
    'resourceusage.reportWasSent' => '資訊：報告已傳至電子郵件：%%email%%',

    'languages.headerStatus' => '秒',
    'languages.headerCode' => '語言包',
    'languages.headerLanguage' => '語言',
    'languages.headerCountry' => '國家',
    'languages.headerUsed' => '已使用',
    'languages.filterCode' => '語言包',
    'languages.buttonDisable' => '禁用',
    'languages.buttonDisableDescription' => '設定使用者無法使用選定的語言。',
    'languages.disableDone' => '使用者已無法使用選定的語言。',
    'languages.buttonEnable' => '啟用',
    'languages.buttonEnableDescription' => '設定使用者可使用選定的語言。',
    'languages.enableDone' => '使用者已可使用選定的語言。',
    'languages.buttonMakeDefault' => '設為默認',
    'languages.buttonMakeDefaultDescription' => '設定選定語言為 Plesk 預設語言。',
    'languages.makeDefaultDone' => '設定所選語言為 Plesk 預設語言。',
    'languages.makeDefaultSelectOne' => '請選擇要設定為 Plesk 預設語言的語言。',
    'languages.statusActive' => 'Plesk 使用者可使用該語言。',
    'languages.statusActiveUnavailable' => '因已超出所支援的語言包數量上限，從而導致使用者無法使用此語言。',
    'languages.buttonHintStatusActive' => '按一下此圖示使使用者無法使用此語言。',
    'languages.statusInactive' => '使用者無法使用此語言。',
    'languages.buttonHintStatusInactive' => '按一下此圖示使使用者可以使用此語言。',
    'languages.buttonHintStatusDefaultLangugage' => '這是預設的語言：您無法禁止使用者使用此語言。',
    'languages.langUnknown' => '無法識別此語言',
    'languages.countryUnknown' => '無法識別國家/地區的子碼',

    'mailqueue.filterQueue' => '佇列',
    'mailqueue.filterSubject' => '主題',
    'mailqueue.filterSender' => '寄件者',
    'mailqueue.filterRecipients' => '收件人',
    'mailqueue.subject' => '主題',
    'mailqueue.sender' => '寄件者',
    'mailqueue.recipients' => '收件人',
    'mailqueue.date' => '日期',
    'mailqueue.age' => '年齡',
    'mailqueue.size' => '大小',
    'mailqueue.buttonRefresh' => '刷新',
    'mailqueue.buttonRefreshHint' => '刷新螢幕上的資料。',
    'mailqueue.buttonRemove' => '移除',
    'mailqueue.buttonRemoveHint' => '從郵件佇列移除所選資訊。',
    'mailqueue.confirmOnDelete' => '您確定要從郵件佇列中移除所選資訊嗎？',
    'mailqueue.buttonClean' => '清空',
    'mailqueue.buttonCleanHint' => '清除所有資訊的郵件佇列。',
    'mailqueue.confirmOnClean' => '您想要清除郵件佇列嗎？',
    'mailqueue.queueAll' => '所有',
    'mailqueue.queueTodo' => '沒有預處理',
    'mailqueue.queueRemote' => '遠程',
    'mailqueue.queueLocal' => '本地',
    'mailqueue.queueLocalAndRemote' => '本地和遠端',
    'mailqueue.queueActive' => '活動的資訊佇列',
    'mailqueue.queueCorrupted' => '損壞的資訊佇列',
    'mailqueue.queueDeferred' => '延遲的資訊佇列',
    'mailqueue.queueHold' => '待處理的資訊佇列',
    'mailqueue.queueIncoming' => '傳入的資訊佇列',
    'mailqueue.postfixHint' => '佇列中的資訊：延遲 %%deferred%%，暫停 %%hold%%，傳入 %%incoming%%，活動 %%active%%，損壞 %%corrupted%%，全部 %%total%%',
    'mailqueue.qmailHint' => '佇列中的資訊：待辦 %%todo%%，本地 %%local%%，遠端 %%remote%%，全部 %%total%%',
    'mailqueue.messagesDeleted' => '選定的資訊已從郵件佇列中移除。',
    'mailqueue.messagesNotDeleted' => '無法從郵件佇列中移除一些資訊：%%error%%',
    'mailqueue.queueCleaned' => '已成功清除郵件佇列。',
    'mailqueue.queueNotCleaned' => '無法清除郵件佇列：%%error%%。',

    'phpextensions.enable' => '啟用擴展',
    'phpextensions.disable' => '禁用擴展',

    'phpextensions.installable.status' => '狀態',
    'phpextensions.installable.notInstalled' => '尚未安裝',
    'phpextensions.installable.outdated' => '已過時，最新版是 %%latestVersion%%',
    'phpextensions.installable.latest' => '最新',
    'phpextensions.installable.name' => '套裝程式',
    'phpextensions.installable.description' => '描述',
    'phpextensions.installable.actionInstall' => '安裝',
    'phpextensions.installable.actionUpgrade' => '升級到 %%version%%',
    'phpextensions.installable.actionDocs' => '文檔',
    'phpextensions.installable.actionUninstall' => '卸載',
    'phpextensions.installable.uninstallConfirmation' => '您確定要卸載 %%name%% 套裝程式嗎？',
    'phpextensions.installable.groupInstall' => '安裝',
    'phpextensions.installable.groupReload' => '重新載入',
    'phpextensions.installable.buttonInstallCustom' => '安裝套裝程式',
    'phpextensions.installable.buttonInstallCustomHint' => '安裝任何 PECL 套裝程式',
    'phpextensions.installable.buttonReload' => '重新載入',
    'phpextensions.installable.buttonReloadHint' => '重新載入 PECL 程式',
    'phpextensions.installable.emptyViewFilteredTitle' => '找不到與該篩檢程式相匹配的任何套裝程式',
    'phpextensions.installable.emptyViewFilteredDescription' => '請嘗試安裝您正在搜索的套裝程式。',

    'phphandlers.name' => '處理常式',
    'phphandlers.domains' => '域名',
    'phphandlers.statusBroken' => '該處理常式已被損壞。',
    'phphandlers.statusDisallowedApacheModule' => '處理常式無法被啟用因為相應的 Apache 模組已被關閉。',
    'phphandlers.domainsTitle' => '%%domains%% 域名使用 PHP %%handler%%',
    'phphandlers.closeTitle' => '關閉',
    'phphandlers.handlerOutdated' => '（已過時）',
    'phphandlers.handlerDeprecated' => '（已棄用）',
    'phphandlers.handlerOutdatedAndDeprecated' => '（已過時、已棄用）',

    'planitems.name' => '名稱',
    'planitems.numberOfPlans' => '服務方案',
    'planitems.numberOfSubscriptions' => '訂閱',
    'planitems.itemInvisible' => '代理商無許可權提供該服務',
    'planitems.buttonMakeItemVisible' => '設為可用',
    'planitems.buttonMakeItemVisibleDescription' => '允許代理商通過其主機方案提供所選服務。這些服務相對應的選項將會在 其它服務 標籤上的主機方案屬性裡顯示。',
    'planitems.buttonMakeItemInvisible' => '設為不可用',
    'planitems.buttonMakeItemInvisibleDescription' => '不允許代理商通過其主機方案提供所選服務。將會從主機方案屬性裡移除這些服務相對應的選項。',
    'planitems.buttonAddNewCustomItemButton' => '添加服務',
    'planitems.buttonAddNewCustomItemButtonDescription' => '添加服務作為服務方案中的選項。',
    'planitems.buttonRemoveCustomItem' => '移除服務',
    'planitems.buttonRemoveCustomItemDescription' => '從主機方案屬性裡移除所選服務相對應的選項。',
    'planitems.confirmOnDeleteSupportButton' => '您確定要移除所選項？',

    'pumpackages.buttonUpdate' => '更新',
    'pumpackages.buttonUpdateDescription' => '更新選定的套裝程式。',
    'pumpackages.buttonLock' => '鎖定',
    'pumpackages.buttonLockDescription' => '鎖定選定的套裝程式以阻止更新。',
    'pumpackages.buttonUnlock' => '解除鎖定',
    'pumpackages.buttonUnlockDescription' => '解除鎖定選定的套裝程式以允許更新。',
    'pumpackages.buttonCheckUpdates' => '檢查更新',
    'pumpackages.buttonCheckUpdatesDescription' => '檢查套裝程式更新。',
    'pumpackages.name' => '套裝程式',
    'pumpackages.summary' => '描述',
    'pumpackages.updates' => '更新',
    'pumpackages.lockedCut' => 'L',
    'pumpackages.lockedHint' => '此套裝程式已被鎖定。',
    'pumpackages.unlockedHint' => '此套裝程式已被解除鎖定。',
    'pumpackages.updated' => '最新',
    'pumpackages.update' => '更新到 %%version%%',
    'pumpackages.unknownRepo' => '未知',
    'pumpackages.allUpToDate' => '所有套裝程式已是最新版',
    'pumpackages.allUpToDateLastChecked' => '檢查時間：%%date%%',
    'pumpackages.recheckUpdates' => '現在重新檢查',
    'pumpackages.popupInfoTitle' => '%%package%% 套裝程式詳情',
    'pumpackages.loading' => '請稍候...',
    'pumpackages.error' => '無法獲取套裝程式列表：%%message%%',
    'pumpackages.currentVersion' => '當前版本：%%version%%',
    'pumpackages.notInstalled' => '未安裝',
    'pumpackages.popupUpdateTitle' => '更新程式封裝',
    'pumpackages.popupUpdatePackagesListTitle' => '安裝以下更新：',
    'pumpackages.popupUpdateLockedPackagesListTitle' => '以下所需套裝程式已被鎖定不能更新：',
    'pumpackages.popupUpdateDependencies' => '%%count%% 個依賴套裝程式',
    'pumpackages.unlockPackagesForUpdateOnly' => '解除鎖定套裝程式僅允許此次更新',
    'pumpackages.lockedError' => '系統更新工具正在自動模式中安裝更新。請稍後再試。',
    'pumpackages.duplicatesError' => '錯誤：無法接收更新資訊，因為某些套裝軟體有副本。請移除以下套裝軟體的副本：%%duplicates%%',
    'pumpackages.updateInfoError' => '錯誤：無法檢索套裝程式的更新資訊',
    'pumpackages.selectedPackagesUpToDate' => '所有已選套裝程式已是最新版。',
    'pumpackages.taskUpdatingPackages' => '正在更新 %%count%% 套裝程式...',
    'pumpackages.popupLockTitle' => '鎖定套裝程式',
    'pumpackages.popupLockDescription' => '如果您鎖定一個套裝程式，系統更新工具將不會對其更新（除非您更新 Plesk 本身）。如果有其它的套裝程式需要該套裝程式到更新的版本才能實現其更新，那麼兩者都不會被更新。請注意您仍可以在控制台中以本機方式更新被鎖定的套裝程式。若要從 Plesk 介面更新被鎖定的套裝程式，請首先解除鎖定。',
    'pumpackages.popupLockPackagesListTitle' => '鎖定以下套裝程式：',
    'pumpackages.popupUnlockTitle' => '解除鎖定套裝程式',
    'pumpackages.popupUnlockDescription' => '無法更新這些套裝程式因為它們已被鎖定不能更新。請注意您仍可以在控制台中以本機方式或在更新 Plesk 本身時更新被鎖定的套裝程式。若要從 Plesk 介面更新被鎖定的套裝程式，請首先解除鎖定。',
    'pumpackages.popupUnlockPackagesListTitle' => '解除鎖定以下套裝程式：',
    'pumpackages.updatesAvailable' => '%%count%% 系統套裝程式有可用更新',
    'pumpackages.lastedChecked' => '（檢查時間：%%date%%）',
    'pumpackages.updateAll' => '更新全部',
    'pumpackages.packageManagerDbInconsistent' => '關於某些包的資訊可能不是實際資訊：在系統包管理器資料庫中已檢測到不一致的資訊。請手動解決該問題。',

    'resellers.filterResellerName' => '代理商名稱',
    'resellers.filterSubscription' => '訂閱',
    'resellers.filterOptionSubscriptionAny' => '任何',
    'resellers.filterOptionSubscriptionCustom' => '自訂',
    'resellers.filterResourceUsage' => '資源使用量',
    'resellers.filterOptionResourceUsageAny' => '任何',
    'resellers.filterOptionResourceUsageOveruse' => '超額使用資源',
    'resellers.filterOptionResourceUsageOk' => '在限制內',
    'resellers.filterStatus' => '狀態',
    'resellers.filterOptionStatusAny' => '任何',
    'resellers.filterOptionStatusSuspended' => '掛起',
    'resellers.filterOptionStatusActive' => '活動',
    'resellers.filterSubscriptionStatus' => '訂閱狀態',
    'resellers.filterOptionSubscriptionStatusAny' => '任何',
    'resellers.filterOptionSubscriptionStatusLocked' => '已鎖定',
    'resellers.filterOptionSubscriptionStatusUnsynchronized' => '未同步',
    'resellers.filterDescription' => '描述',
    'resellers.buttonAddNewReseller' => '添加代理商',
    'resellers.hintAddNewReseller' => '創建代理商帳戶。',
    'resellers.buttonRemove' => '移除',
    'resellers.hintRemove' => '移除所選代理商和其所有的服務方案、客戶和訂閱。',
    'resellers.confirmOnDelete' => '您確定要移除 {count, plural, =1 {{name} 代理商帳戶} other {# 選定的代理商帳戶}} 和所有的 {count, plural, other {其}} 服務方案、客戶和訂閱？',
    'resellers.buttonConvertToCustomer' => '轉換為客戶',
    'resellers.hintConvertToCustomer' => '轉換所選代理商為客戶。',
    'resellers.buttonChangeStatus' => '更改狀態',
    'resellers.hintChangeStatus' => 'Change the reseller\'s status to "Active" or "Suspended"',
    'resellers.buttonActivateResellers' => '啟動',
    'resellers.hintActivateResellers' => '啟動所選代理商帳戶。',
    'resellers.buttonSuspendResellers' => '掛起',
    'resellers.hintSuspendResellers' => '掛起所選代理商帳戶：代理商與其所有客戶將無法存取客戶面板；代理商與其客戶的域名也將被掛起，互聯網用戶則無法再存取其網站、FTP 和郵件等服務。',
    'resellers.resellerName' => '代理商名稱',
    'resellers.planName' => '服務方案',
    'resellers.setupDate' => '創建日期',
    'resellers.customers' => '客戶',
    'resellers.customPlanName' => '自訂',
    'resellers.buttonLogin' => '以代理商身份登入',
    'resellers.hintLogin' => '管理與代理商主機帳戶相關聯的主機服務。',
    'resellers.statusOk' => '該代理商帳戶的狀態良好：帳戶已被啟動，訂閱與方案同步。',
    'resellers.statusSuspended' => '該代理商帳戶已被掛起：會阻止該代理商與其所有客戶存取客戶面板；掛起該代理商的域名和其客戶，互聯網使用者無法存取他們的 Web、FTP 和郵件服務。',
    'resellers.statusLocked' => '此訂閱已鎖定同步: 因訂閱參數已自訂，導致從服務方案同步中排除。',
    'resellers.statusUnsynchronized' => '此訂閱未與代理商方案同步: 代理商方案提供的部分服務或資源訂閱不提供。',

    'resellerserviceplans.planName' => '方案名稱',
    'resellerserviceplans.planTraffic' => '流量',
    'resellerserviceplans.planDiskSpace' => '磁碟空間',
    'resellerserviceplans.planSubscriptions' => '代理商',
    'resellerserviceplans.unlimited' => '無限',
    'resellerserviceplans.buttonAddNewPlan' => '添加方案',
    'resellerserviceplans.hintAddNewPlan' => '創建代理商方案。',
    'resellerserviceplans.buttonDuplicatePlans' => '克隆方案',
    'resellerserviceplans.hintDuplicatePlans' => '克隆選定的代理商方案。',
    'resellerserviceplans.buttonRemove' => '移除',
    'resellerserviceplans.hintRemove' => '按一下移除所選代理商方案。',
    'resellerserviceplans.confirmOnDelete' => '您確定要移除所選代理商方案嗎？',
    'resellerserviceplans.disabledSelectHint' => '無法移除代理商方案及其訂閱。',

    'restricteddomains.name' => '域名',
    'restricteddomains.buttonAddNewDomain' => '添加域名',
    'restricteddomains.buttonEnableList' => '啟用',
    'restricteddomains.hintAddNewDomain' => '添加被禁的域名。',
    'restricteddomains.hintEnableList' => '在域名創建過程中檢查域名。',
    'restricteddomains.buttonDisableList' => '禁用',
    'restricteddomains.hintDisableList' => '關閉在域名創建過程中檢查域名。',
    'restricteddomains.buttonRemoveDomain' => '移除',
    'restricteddomains.hintRemoveDomain' => '移除選定的域名。',
    'restricteddomains.confirmOnRemove' => '移除選定的域名。',
    'restricteddomains.buttonMoreActions' => '更多',

    'servermailblacklist.groupAdd' => '添加',
    'servermailblacklist.buttonAdd' => '新增網域',
    'servermailblacklist.buttonAddHint' => '將域名添加到黑名單中',
    'servermailblacklist.groupActions' => '操作',
    'servermailblacklist.buttonRemove' => '移除',
    'servermailblacklist.entries' => '項目',
    'servermailblacklist.action' => '操作',
    'servermailblacklist.deleteAction' => '從伺服器刪除',
    'servermailblacklist.spamAction' => '標識為垃圾郵件',
    'servermailblacklist.spamAssassinDisabled' => '因未安裝Spamassassin或已關閉，則系統不會將這些條目標示為垃圾郵件',
    'servermailblacklist.removeEmptySelection' => '未選擇項目。',
    'servermailblacklist.removeConfirmation' => '要移除 {count, plural, =1 {{name} 條目} other {# 選定的條目}}？',
    'servermailblacklist.removeSuccess' => '選定條目已被移除。',

    'servermailwhitelist.groupAdd' => '添加',
    'servermailwhitelist.buttonAdd' => '添加網路',
    'servermailwhitelist.buttonAddHint' => '將網路添加到白名單',
    'servermailwhitelist.groupActions' => '操作',
    'servermailwhitelist.buttonRemove' => '移除',
    'servermailwhitelist.entries' => '項目',
    'servermailwhitelist.whiteListNotEmpty' => '對傳出郵件的限制將不適用於IP地址來自郵件伺服器白名單的寄件者。例如，如果在白名單中有 localhost (127.0.0.0 / 8, ::1 / 128)，不管該限制如何，所有本機伺服器的郵件將被成功發送。寄件者可以使用本地IP位址（在本機伺服器上託管的網站和自訂腳本）或外部IP位址（通過安裝在電腦或移動設備上的郵件用戶端發送郵件的客戶）。要實現該限制適用於所有寄件者（本地的和外部的），請移除所有來自白名單的IP位址和網路。請注意，移除來自白名單的 localhost (127.0.0.0 / 8, ::1 / 128) 可能干擾該伺服器發送郵件網站和腳本的操作。瞭解有關傳出郵件限制的詳情，請查看管理員指南，傳出垃圾郵件防護。',
    'servermailwhitelist.removeEmptySelection' => '未選擇項目.',
    'servermailwhitelist.removeConfirmation' => '移除 {count, plural, =1 {{name} 條目} other {# 選定的條目}}?',
    'servermailwhitelist.webmailAffected' => '移除以下 {count, plural, =1 {網路} other {網路}} 可能會導致無法從 web 郵箱發送郵件：%%list%%',
    'servermailwhitelist.webmailAffectedSingle' => '移除此網路可能會導致無法從 web 郵箱發送電子郵件。',
    'servermailwhitelist.removeSuccess' => '選定條目已被移除。',

    'serverprotection.bannedips.pageHint' => '您可在此查看被禁的 IP 地址，解除禁止，或移動到可信任的 IP 地址清單。',
    'serverprotection.bannedips.ip' => 'IP 地址',
    'serverprotection.bannedips.banDate' => '禁止',
    'serverprotection.bannedips.jail' => '已使用的 jail',
    'serverprotection.bannedips.buttonRemoveIp' => '解除禁止',
    'serverprotection.bannedips.hintRemoveIp' => '從被禁地址清單中移除所選 IP 地址。',
    'serverprotection.bannedips.buttonMoveToTrustedIp' => '移動到可信任的 IP 列表',
    'serverprotection.bannedips.hintMoveToTrustedIp' => '移動所選 IP 地址到可信任的地址清單。',
    'serverprotection.bannedips.buttonEnable' => '啟用 IP 地址禁止',
    'serverprotection.bannedips.hintEnable' => '自動禁止會對伺服器生成惡意流量的 IP 位址和網路。',
    'serverprotection.bannedips.buttonDisable' => '禁用 IP 地址禁止',
    'serverprotection.bannedips.hintDisable' => '關閉自動禁止對您的伺服器會生成惡意流量的 IP 位址和網路。',
    'serverprotection.bannedips.errorEnableFailed' => '無法啟用 IP 地址禁止：%%error%%.',
    'serverprotection.bannedips.errorDisableFailed' => '無法禁用 IP 地址禁止：%%error%%.',

    'serverprotection.filters.pageHint' => '在此處您可以管理 jails 篩檢程式。',
    'serverprotection.filters.buttonAddFilter' => '添加篩檢程式',
    'serverprotection.filters.hintAddFilter' => '添加一個篩檢程式。',
    'serverprotection.filters.buttonRemoveFilter' => '移除',
    'serverprotection.filters.hintRemoveFilter' => '移除選定的篩檢程式。',
    'serverprotection.filters.name' => '篩檢程式名稱',

    'serverprotection.jails.pageHint' => '您可在此查看可檢測濫用 IP 地址的 jail 列表。',
    'serverprotection.jails.buttonAddJail' => '添加 Jail',
    'serverprotection.jails.hintAddJail' => '添加一個 jail。',
    'serverprotection.jails.buttonDisableJails' => '關閉',
    'serverprotection.jails.hintDisableJails' => '關閉選定的 jail。',
    'serverprotection.jails.buttonActivateJails' => '打開',
    'serverprotection.jails.hintActivateJails' => '啟用選定的 jail。',
    'serverprotection.jails.buttonRemoveJail' => '移除',
    'serverprotection.jails.hintRemoveJail' => '移除選定的 jail。',
    'serverprotection.jails.buttonManageFilters' => '管理篩檢程式',
    'serverprotection.jails.hintManageFilters' => '在此處您可以管理 jail 篩檢程式。',
    'serverprotection.jails.name' => 'Jail 名稱',
    'serverprotection.jails.disabled' => '停用',
    'serverprotection.jails.active' => '啟用',
    'serverprotection.jails.status' => '狀態',
    'serverprotection.jails.confirmOnDelete' => '您確定要移除選定的 jail 嗎？',

    'serverprotection.logs.pageHint' => '您可以在此處查看 Fail2ba 日誌。',
    'serverprotection.logs.name' => '文件',
    'serverprotection.logs.viewHint' => '查看日誌檔。',
    'serverprotection.logs.buttonDownloadHint' => '下載日誌檔',

    'serverprotection.trustedips.pageHint' => '在此處您可以查看可信任的 IP 位址，添加 IP 位址到可信任的地址清單或從中移除。',
    'serverprotection.trustedips.ip' => 'IP 地址',
    'serverprotection.trustedips.ipDesc' => '描述',
    'serverprotection.trustedips.addDate' => '添加到可信任的',
    'serverprotection.trustedips.comment' => '注釋',
    'serverprotection.trustedips.buttonRemoveIp' => '移除',
    'serverprotection.trustedips.hintRemoveIp' => '從可信任的地址清單中移除所選 IP 地址。',
    'serverprotection.trustedips.buttonAddTrustedIp' => '添加可信任的 IP',
    'serverprotection.trustedips.hintAddTrustedIp' => '添加一個 IP 位址到可信任的地址清單。',
    'serverprotection.trustedips.buttonEditTrustedIp' => '編輯描述',
    'serverprotection.trustedips.buttonEditHint' => '編輯 IP 地址的描述。',

    'services.stateColumnHeader' => '狀態',
    'services.nameColumnHeader' => '服務',
    'services.startupTypeColumnHeader' => '啟動類型',
    'services.autoStartupType' => '自動',
    'services.manualStartupType' => '手動',
    'services.disabledStartupType' => '禁用',
    'services.changeStartupTypeTooltip' => '更改服務的啟動類型',
    'services.drwebName' => 'Plesk Premium Antivirus',
    'services.postgresqlName' => 'PostgreSQL',
    'services.tomcatName' => 'Tomcat Java',
    'services.imap-pop3Name' => 'Dovecot IMAP 和 POP3 伺服器',
    'services.pop3Name' => 'Courier POP3 伺服器',
    'services.pop3sName' => '帶有 SSL/TLS 支援的 Courier POP3 伺服器',
    'services.imapName' => 'Courier IMAP 伺服器',
    'services.imapsName' => '帶有 SSL/TLS 支援的 Courier IMAP 伺服器',
    'services.authdaemonName' => 'Courier IMAP 驗證守護進程',
    'services.dnsName' => 'DNS 伺服器 (%%displayName%%)',
    'services.fail2banName' => 'IP 地址禁止 (Fail2ban)',
    'services.kavName' => 'Kaspersky Antivirus',
    'services.milterName' => "Plesk 郵件篩檢程式（%%displayName%%）",
    'services.nginxName' => '反向代理伺服器（nginx）',
    'services.smtpName' => 'SMTP 伺服器 (%%displayName%%)',
    'services.spamassassinName' => "SpamAssassin",
    'services.webName' => "Web 伺服器 (%%displayName%%)",
    'services.resctrlName' => "資源調度控制器 (cgroups)",
    'services.activeState' => '啟用',
    'services.inActiveState' => '停用',
    'services.do-restart' => '重新啟動',
    'services.do-start' => '啟動',
    'services.do-stop' => '關閉',
    'services.do-changeStartup' => '處理中',
    'services.notConfiguredState' => '未配置',
    'services.notInstalledState' => '尚未安裝',
    'services.running-start' => '服務已啟動。',
    'services.notRunning-start' => '啟動服務。',
    'services.running-stop' => '停止服務。',
    'services.notRunning-stop' => '服務已被停止。',
    'services.running-restart' => '重新開機服務。',
    'services.notRunning-restart' => '服務已被停止。',
    'services.startServiceDrWeb' => '要啟用防病毒服務，您必須有至少一個郵箱啟用了防病毒檢查。',
    'services.serviceDisabled' => '由於您的許可證不支援，或服務尚未安裝或正確配置，此功能目前處於禁用狀態。',
    'services.serviceDisabledStartupType' => '服務已禁用。',
    'services.phpHandlerSettingsByOsVendor' => '作業系統供應商提供的 %%displayName%%',
    'services.phpFpm' => 'PHP-FPM %%displayName%%',
    'services.urlrewriteComponentName' => "URL 重寫",
    'services.dbconnectorComponentName' => "資料庫連接器",
    'services.tomcatComponentName' => 'Apache Tomcat',
    'services.mysqlserverComponentName' => 'MariaDB/MySQL 伺服器',
    'services.troubleshootingComponentName' => '故障排除',
    'services.wafComponentName' => 'Web 應用程式防火牆',
    'services.vcsComponentName' => '版本控制系統',
    'services.antivirusComponentName' => "防毒程式",
    'services.databaseComponentName' => "SQL 伺服器",
    'services.sqladminComponentName' => "MySQL Web Admin",
    'services.sqladminmysqlComponentName' => "MySQL Web Admin",
    'services.dnsserverComponentName' => "DNS 伺服器",
    'services.firewallComponentName' => "防火牆",
    'services.ftpserverComponentName' => "FTP 伺服器",
    'services.javaComponentName' => "Java",
    'services.mailserverComponentName' => "郵件伺服器",
    'services.pleskagentComponentName' => "Plesk 代理",
    'services.psaComponentName' => "Plesk",
    'services.scriptComponentName' => "Web 腳本",
    'services.spamfilterComponentName' => "垃圾郵件篩檢程式",
    'services.statsComponentName' => "網站統計",
    'services.stunnelComponentName' => "SSL/TLS Wrapper",
    'services.webmailComponentName' => "Web 郵箱",
    'services.webpublishComponentName' => "Web 發佈",
    'services.webserverComponentName' => "Web 伺服器",
    'services.backupsystemComponentName' => '備份系統',
    'services.networkComponentName' => '網路連接',
    'services.sitebuilderComponentName' => 'Presence Builder',
    'services.saviComponentName' => 'Sophos 防病毒介面',
    'services.waitMessage' => '請稍候',
    'services.buttonRefreshComponents' => '刷新',
    'services.searchTitle' => '查找服務......',
    'services.hintRefreshComponents' => '刷新組件清單',

    'sessions.searchTitle' => '搜尋活動會話',
    'sessions.buttonRefresh' => '刷新',
    'sessions.buttonRefreshDescription' => '同步會話列表與當前打開的會話。',
    'sessions.buttonRemove' => '關閉',
    'sessions.buttonRemoveDescription' => '結束所選的會話。',
    'sessions.removeConfirmMessage' => '您確定要結束所選會話嗎？',
    'sessions.buttonSettings' => '會話設定',
    'sessions.buttonSettingsDescription' => '更改會話參數。',
    'sessions.headerType' => 'T',
    'sessions.headerLogin' => '登入名',
    'sessions.headerIpAddress' => 'IP 地址',
    'sessions.headerLogonTime' => '登入時間',
    'sessions.headerIdleTime' => '閒置時間',
    'sessions.typeAdmin' => '管理會話。',
    'sessions.typeReseller' => '零售商會話。',
    'sessions.typeClient' => '客戶會話。',
    'sessions.altAdminIcon' => '管理',
    'sessions.altResellerIcon' => '代理商',
    'sessions.altClientIcon' => '客戶',

    'sslcertificates.name' => '名稱',
    'sslcertificates.used' => '已使用',
    'sslcertificates.csrHint' => '提供 CSR 元件。',
    'sslcertificates.noCsrHint' => '未提供 CSR 元件。',
    'sslcertificates.privateKeyHint' => '提供私密金鑰元件。',
    'sslcertificates.noPrivateKeyHint' => '未提供私密金鑰元件。',
    'sslcertificates.certificateHint' => '提供證書元件。',
    'sslcertificates.noCertificateHint' => '未提供證書元件。',
    'sslcertificates.caCertificateHint' => '提供 CA 證書元件。',
    'sslcertificates.noCaCertificateHint' => '未提供 CA 證書元件。',
    'sslcertificates.buttonDownloadHint' => '下載所有證書組件。',
    'sslcertificates.remove' => '移除',
    'sslcertificates.hintRemove' => '從域名 repository 移除所選 SSL/TLS 證書？',
    'sslcertificates.confirmOnDelete' => '移除選定的 SSL/TLS 證書？',
    'sslcertificates.addCertificate' => '添加',
    'sslcertificates.hintAddCertificate' => '添加 SSL/TLS 證書。',
    'sslcertificates.viewCertificates' => '查看',
    'sslcertificates.hintViewCertificates' => '查看從提供商購買的 SSL/TLS 證書列表。',
    'sslcertificates.unableSetupPanelCertificate' => '無法在 Plesk 中安裝證書：私密金鑰和證書內容丟失。',
    'sslcertificates.makeDefault' => '設為默認',
    'sslcertificates.hintMakeDefault' => '使用所選 SSL/TLS 證書來保障到新創建網站的連接安全。',
    'sslcertificates.unableMakeDefault' => '無法安裝默認的證書：未選定帶有私密金鑰的證書。',
    'sslcertificates.successMakeDefault' => '選定的 SSL/TLS 證書已被配置為預設的證書。可用于保護現有和新創建網站的安全。使用之前的默認證書的網站將繼續使用該證書。',
    'sslcertificates.selectOne' => '選擇一個 SSL/TLS 證書。',

    'subscriptions.filterDomainName' => '名稱',
    'subscriptions.filterSubscription' => '服務方案',
    'subscriptions.filterOptionSubscriptionAny' => '任何',
    'subscriptions.filterOptionSubscriptionMy' => '我的方案',
    'subscriptions.filterOptionSubscriptionReseller' => '%%planOwnerContactName%%的方案',
    'subscriptions.filterOptionSubscriptionCustom' => '自訂',
    'subscriptions.filterOptionSubscriptionAddonType' => '（附加方案）',
    'subscriptions.filterResourceUsage' => '資源使用量',
    'subscriptions.filterOptionResourceUsageAny' => '任何',
    'subscriptions.filterOptionResourceUsageOveruse' => '超額使用資源',
    'subscriptions.filterOptionResourceUsageOk' => '在限制內',
    'subscriptions.filterPlanItem' => '自訂方案項目',
    'subscriptions.filterOptionPlanItemAny' => '任何一個',
    'subscriptions.filterProvider' => '服務商',
    'subscriptions.filterOptionProviderAny' => '所有訂閱',
    'subscriptions.filterOptionProviderMy' => '我的訂閱',
    'subscriptions.filterProviderReseller' => '%%resellerContactName%%的訂閱',
    'subscriptions.filterStatus' => '狀態',
    'subscriptions.filterOptionStatusAny' => '任何',
    'subscriptions.filterOptionStatusSuspended' => '掛起',
    'subscriptions.filterOptionStatusActive' => '活動',
    'subscriptions.filterSubscriptionStatus' => '訂閱狀態',
    'subscriptions.filterOptionSubscriptionStatusAny' => '任何',
    'subscriptions.filterOptionSubscriptionStatusLocked' => '已鎖定',
    'subscriptions.filterOptionSubscriptionStatusUnsynchronized' => '未同步',
    'subscriptions.filterSubscriberName' => '訂戶',
    'subscriptions.filterDescription' => '描述',
    'subscriptions.subscriptionName' => '訂閱',
    'subscriptions.subscriberName' => '訂戶',
    'subscriptions.setupDate' => '創建日期',
    'subscriptions.expirationDate' => '到期日期',
    'subscriptions.description' => '描述',
    'subscriptions.resellerDescription' => '代理商',
    'subscriptions.ownerDescription' => '客戶',
    'subscriptions.manageInResellerPanel' => '在代理商面板中管理',
    'subscriptions.manageInCustomerPanel' => '在客戶面板中管理',
    'subscriptions.buttonAddNewOwnSubscription' => '添加自己的訂閱',
    'subscriptions.hintAddNewOwnSubscription' => '創建供個人的訂閱。',
    'subscriptions.buttonAddNewSubscription' => '添加訂閱',
    'subscriptions.hintAddNewSubscription' => '創建訂閱。',
    'subscriptions.buttonChangeSubscription' => '更改方案',
    'subscriptions.hintChangeSubscription' => '將所選訂閱與另一服務方案建立關聯，若訂閱提供商允許，則可添加或移除附加方案。',
    'subscriptions.buttonRemove' => '移除',
    'subscriptions.hintRemove' => '移除所選訂閱。',
    'subscriptions.confirmOnRemove' => '您確定要移除所選訂閱嗎？',
    'subscriptions.buttonSetStatus' => '設定狀態',
    'subscriptions.hintSetStatus' => 'Change the subscription\'s status to "Active" or "Suspended"',
    'subscriptions.buttonActivateSubscriptions' => '活動',
    'subscriptions.hintActivateSubscriptions' => '啟動所選訂閱。',
    'subscriptions.buttonSuspendSubscriptions' => '掛起',
    'subscriptions.hintSuspendSubscriptions' => '掛起所選訂閱。訂閱的所有服務都將被凍結，會導致互聯網用戶無法對其進行存取。',
    'subscriptions.buttonChangeOwner' => '更改訂戶',
    'subscriptions.hintChangeOwner' => '重新分配所選訂閱給另一訂戶。此操作還會更改訂閱的提供商，解除訂閱與其服務方案的綁定，並將其設定為\'自訂\'。',
    'subscriptions.customPlanName' => '自訂',
    'subscriptions.statusOk' => '訂閱狀態正常: 此訂閱處於活動狀態，且已於方案同步。',
    'subscriptions.statusSuspended' => '此訂閱已掛起：訂閱的所有服務都將被凍結，會導致互聯網用戶無法對其進行訪問',
    'subscriptions.statusSuspendedReasonExpired' => '該訂閱已掛起因為已到期：此訂閱提供的所有服務都已凍結，網路使用者也無法存取各個服務。',
    'subscriptions.statusLocked' => '此訂閱已鎖定同步: 因訂閱參數已自訂，導致從服務方案同步中排除。',
    'subscriptions.statusUnsynchronized' => '此訂閱未與服務方案同步: 存在方案提供但訂閱不提供的部分服務或資源。',
    'subscriptions.confirmOnDelete' => '您確定要移除 {count, plural, =1 {{name} 訂閱} other {# 選定的訂閱}}?',
    'subscriptions.hintInfo' => '(?)',
    'subscriptions.webserverConfigurationDomainHintAdmin' => "订阅域名的web服务器配置可能是不一致的。请在Apache的配置模板中修复错误，并重新生成配置文件。",
    'subscriptions.webserverConfigurationDomainHintReseller' => "订阅的域名的web服务器配置可能是不一致的。请联系服务器管理员解决该问题。",
    'subscriptions.unlinkedDomainHint' => '某些域名 IP 地址已失效而被排除在服务器配置之外。请检查域名 IP 的绑定情况，如果需要请更新。',
    'subscriptions.hintTitle' => '订阅概要',
    'subscriptions.hintWaitMessage' => '加载中......',
    'subscriptions.removeConfirmationSubscription' => "還將移除下列域名：%%domains%%",

    'summaryreportlayouts.delivery' => '發送',
    'summaryreportlayouts.name' => '名稱',
    'summaryreportlayouts.general' => '常用',
    'summaryreportlayouts.clients' => '客戶',
    'summaryreportlayouts.resellers' => '代理商',
    'summaryreportlayouts.personalClients' => '個人客戶端',
    'summaryreportlayouts.domains' => '域名',
    'summaryreportlayouts.personalDomains' => '個人域名',
    'summaryreportlayouts.section.FULL' => '全量',
    'summaryreportlayouts.section.NONE' => '無',
    'summaryreportlayouts.section.SUMMARY' => '匯總',
    'summaryreportlayouts.groupRemove' => '移除',
    'summaryreportlayouts.buttonRemove' => '移除',
    'summaryreportlayouts.buttonRemoveHint' => '移除選定的佈局。',
    'summaryreportlayouts.removeEmptySelection' => '選擇要移除的一個或多個配置',
    'summaryreportlayouts.removeConfirmation' => '是否移除 {count, plural, =1 {{name} 個配置} other {# 個配置}}？',
    'summaryreportlayouts.groupAdd' => '添加',
    'summaryreportlayouts.buttonAdd' => '添加佈局',
    'summaryreportlayouts.buttonAddHint' => '添加報告佈局',
    'summaryreportlayouts.autoDeliveryOn' => '此報告已列入發送計畫。',
    'summaryreportlayouts.autoDeliveryOff' => '此報告不自動發送。',
    'summaryreportlayouts.removeSuccess' => '選定的佈局已被移除。',

    'summaryreportschedules.status' => 'S',
    'summaryreportschedules.on' => '已啟用',
    'summaryreportschedules.off' => '禁用',
    'summaryreportschedules.period' => '頻率',
    'summaryreportschedules.lastSentDate' => '最後發送日期',
    'summaryreportschedules.email' => '發送到',
    'summaryreportschedules.disabled' => '已關閉',
    'summaryreportschedules.day' => '每日',
    'summaryreportschedules.week' => '每週',
    'summaryreportschedules.month' => '每月',
    'summaryreportschedules.groupAdd' => '添加',
    'summaryreportschedules.buttonAdd' => '添加時程',
    'summaryreportschedules.buttonAddHint' => '添加發送計畫',
    'summaryreportschedules.groupRemove' => '移除',
    'summaryreportschedules.buttonRemove' => '移除',
    'summaryreportschedules.buttonRemoveHint' => '移除所選計畫。',
    'summaryreportschedules.removeEmptySelection' => '選擇以移除一個或多個發送計畫。',
    'summaryreportschedules.removeConfirmation' => '是否移除 {count, plural, =1 {個所選的發送計畫} other {#個所選的發送計畫}}？',
    'summaryreportschedules.removeSuccess' => '所選發送計畫已刪除。',

    'traffichistory.year' => '年',
    'traffichistory.month' => '月',
    'traffichistory.trafficUsage' => '流量使用',
    'traffichistory.noData' => '沒有可用的歷史資料。',

    'webappfirewalllogfiles.name' => '名稱',
    'webappfirewalllogfiles.modificationDate' => '修改日期',
    'webappfirewalllogfiles.fileSize' => '大小',
    'webappfirewalllogfiles.remove' => '移除',
    'webappfirewalllogfiles.hintRemove' => '要移除選定的日誌檔。只能移除已處理的日誌檔。',
    'webappfirewalllogfiles.confirmOnDelete' => '要移除選定的日誌檔？',
    'webappfirewalllogfiles.viewHint' => '按一下查看日誌檔。',
    'webappfirewalllogfiles.buttonDownloadHint' => '按一下下載日誌檔。',

    'webmails.name' => '名稱',
    'webmails.url' => 'URL',
    'webmails.buttonAddNewWebmail' => '註冊 web 郵箱',
    'webmails.hintAddNewWebmail' => '在 Plesk 中註冊其它的 web 郵箱服務。',
    'webmails.buttonEnableWebmail' => '啟用',
    'webmails.hintEnableWebmail' => '設定客戶可使用所選 web 郵箱服務。',
    'webmails.buttonDisableWebmail' => '禁用',
    'webmails.hintDisableWebmail' => '設定客戶不可使用所選 web 郵箱服務。',
    'webmails.buttonRemoveWebmail' => '移除',
    'webmails.hintRemoveWebmail' => '取消註冊所選 web 郵箱服務。注意無法在此處移除使用 Plesk 安裝程式安裝的 web 郵箱，需進入 工具>  更新 才能移除。',
    'webmails.confirmOnDelete' => '您確定從 Plesk 取消註冊選定的 web 郵箱嗎？',
    'webmails.statusSuspended' => 'web 郵箱不可用。',
    'webmails.statusOk' => 'web 郵箱可用。',
];