<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Loggfiler",
    'action-log.fromDate' => "Fra:",
    'action-log.toDate' => "Til...",
    'action-log.clearLog' => "Tøm logg",
    'action-log.downloadLog' => "Last ned",
    'action-log.loggedActions' => "Loggførte handlinger",
    'action-log.storeLogsInDb' => "Lagre oppføringer i databasen",
    'action-log.storeNumber' => "Innlegg",
    'action-log.dontRemoveRecs' => "Ikke fjern oppføringer",
    'action-log.confirmCleanLog' => "Er du sikker på at du vil slette de valgte oppføringene i handlingsloggen?",
    'action-log.incorrectDate' => "Ugyldig dato angitt.",
    'action-log.incorrectNumPeriods' => "Ugyldig rotasjonsperiode spesifisert.",
    'action-log.incorrectNumRecords' => "Ugyldig antall oppføringer spesifisert.",
    'action-log.yes' => "Ja",
    'action-log.no' => "Nei",
    'action-log.mixed' => "(blandet)",
    'action-log.period' => "Periode",
    'action-log.invalidDatePeriod' => "Ugyldig datoperiode",
    'action-log.submitDone' => "Endringene i innstillingene for handlingsloggen ble lagret.",
    'action-log.clearDone' => "Handlingsloggen er klarert.",
    'action-log.periodDay' => "dager",
    'action-log.periodWeek' => "uker",
    'action-log.periodMonth' => "måned",

    'admin-info.adminInfoSection' => 'Informasjon for administratoren',
    'admin-info.description-admin' => 'Administratorens beskrivelse',
    'admin-info.description-reseller' => 'Forhandlerens beskrivelse',
    'admin-info.description-owner' => 'Eierens beskrivelse',
    'admin-info.description' => 'Beskrivelse',
    'admin-info.descriptionSuccess' => 'Beskrivelsen ble oppdatert.',
    'admin-info.longDescription' => 'Den angitte beskrivelsen er for lang. Den kan ikke være lenger enn %%max%% tegn.',
    'admin-info.add' => 'Legg til beskrivelse',
    'admin-info.edit' => 'Rediger',
    'admin-info.remove' => 'Slett',
    'admin-info.confirmOnRemove' => 'Ønsker du å fjerne denne beskrivelsen?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% av kunde %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% av forhandler %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% av abonnement %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% for %%name%%',
    'admin-info.popupHint-admin' => 'Denne beskrivelsen er bare synlig for administratoren.',
    'admin-info.popupHint-reseller' => 'Denne beskrivelsen er synlig for forhandleren og administratoren.',
    'admin-info.popupHint-owner' => 'Denne beskrivelsen er bare synlig for forfatteren og forfatterens hostingleverandør.',
    'admin-info.customerDescriptionHint' => 'Kundene kan ikke se denne beskrivelsen.',
    'admin-info.subscriptionDescriptionHint' => "Denne informasjonen er kun synlig for hostingleverandør (Plesk administrator eller forhandler).",

    'apache-settings.formGeneralHint' => 'Her du kan angi Apache webserverinnstillinger for dette nettsted. Brukerdefinert Apache-konfigurasjon er nyttig, for eksempel, når du ønsker å bruke en ny type indeksfiler på nettstedet ditt eller for å knytte en bestemt MIME-type til bestemte filtyper. Standardverdien betyr at Apache vil bruke det tilsvarende direktivet fra konfigurasjonen på serveren. Hvis Apache er kjører med nginx som frontend server, kan du angi nginx-innstillinger på denne siden også.',
    'apache-settings.general' => 'Vanlige Apache-innstillinger',
    'apache-settings.example' => "For eksempel:\n%%example%%",
    'apache-settings.settingOn' => 'Aktivert',
    'apache-settings.settingOff' => 'Av (standard)',
    'apache-settings.settingDefault' => 'Standard',
    'apache-settings.settingCustom' => 'Angi egendefinert verdi',
    'apache-settings.mimeTypes' => 'MIME-typer',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'MIME-typer assosierer filutvidelser med filtyper. Brukes vanligvis for å opprette en egendefinert filtutvidelse for vanlige filtyper.',
    'apache-settings.handlers' => 'Behandlinger',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Apache-behandlere definerer hvordan nettserveren prosesserer filer med visse utvidelser når de blir forespurt. For eksempel betyr strengen 'php-script .script' at Apache behandler .script-filer som php-skript.",
    'apache-settings.deny' => 'Nekte tilgang til nettstedet',
    'apache-settings.allow' => 'Utelater',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDe angitte vertene og nettverkene er nektet tilgang til området. Benytt '*' for å avvise alle forbindelser.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nDe angitte vertene og nettverkene har tilgang til området.",
    'apache-settings.directoryIndex' => 'Indekser filer',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache ser etter de spesifiserte filene når nettstedets hovedside blir forespurt.",
    'apache-settings.expires' => 'Expires (Utløper)',
    'apache-settings.expiresStaticOnly' => 'respons med Expires (Utløper) -meldingshoder bare for statiske filer',
    'apache-settings.expiresFullDescription' => 'Webserveren vil legge til “Expires” (Utløper) -meldingshoder til nettsider. Tidsstemplet for utløp fåes ved å addere tidsmengden spesifisert ovenfor til det tidspunktet hvor en nettside ble ønsket.',
    'apache-settings.expiresStaticOnlyDescription' => '“Expires” (Utløper) -meldingshodet vil bare adderes til statiske filer. Hvilke filer som behandles som statiske styres av alternativene “Smart prosessering av statiske filer” og “Betjen statiske filer direkte med nginx”.',
    'apache-settings.expiresUnitDays' => 'dager',
    'apache-settings.expiresUnitHours' => 'timer',
    'apache-settings.expiresUnitMinutes' => 'minutter',
    'apache-settings.expiresUnitSeconds' => 'sekunder',
    'apache-settings.headers' => 'Flere meldingshoder',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Nettserveren legger til de angitte HTTP-svaroverskriftene.",
    'apache-settings.restrictFollowSymLinks' => 'Begrens muligheten til å følge symbolske koblinger',
    'apache-settings.restrictFollowSymLinksDescription' => "Velg dette alternativet for å hindre brukere i å bruke FollowSymLink-direktivet i .htaccess og forbedre serverens sikkerhet.",
    'apache-settings.nginx' => 'nginx innstillinger',
    'apache-settings.nginxProxyMode' => 'Proxy-modus',
    'apache-settings.nginxProxyModeDescription' => 'Nginx proxy-forespørsler til Apache. Slå av for å slutte å bruke Apache.',
    'apache-settings.nginxTransparentMode' => 'Smart prosessering av statiske filer',
    'apache-settings.nginxTransparentModeDescription' => 'Dersom skrudd av, vil Apache behandle alle henvendelser om statiske filer. nginx vil kun videreformidle henvendelser og svar uten modifikasjoner. Slå av denne muligheten kun for feilsøking.',
    'apache-settings.nginxServeStatic' => 'Betjen statiske filer direkte med nginx',
    'apache-settings.nginxStaticExtensions' => 'Spesifiser filutvidelser separert med mellomrom eller med "|" symbolet. Henvendelser for disse filene vil behandles av nginx og vil aldri nå Apache. Forsiktig: Apache omskrivningsregler vil ikke benyttes.',
    'apache-settings.nginxServePhp' => 'Behandle PHP med nginx',
    'apache-settings.nginxServePhpDescription' => 'PHP filer (.php) vil bli behandlet av nginx og PHP-FPM. Dersom skrudd av, vil PHP filer bli prosessert av Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Maks tillatt størrelse på HTTP-forespørsel',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Forespørsler med brødtekst som overskrider grensen forkastes med HTTP 413 Payload Too Large (konfigurerer nginx-direktivverdien «client_max_body_size»). ',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'Alternativet deaktiveres globalt via en tom verdi / nullverdi for direktivet «clientMaxBodySize» i panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Aktiver nginx mellomlagring',
    'apache-settings.nginxCacheEnabledDescription' => 'Mellomlagring kan redusere nettstedets responstid og serverbelastning, men bør brukes med omtenksomhet.',
    'apache-settings.nginxCacheSize' => 'Mellomlagringsstørrelse',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Mellomlagringstidsavbrudd',
    'apache-settings.nginxCacheTimeoutDays' => 'dager',
    'apache-settings.nginxCacheTimeoutHours' => 'timer',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minutter',
    'apache-settings.nginxCacheTimeoutSeconds' => 'sekunder',
    'apache-settings.nginxCacheKey' => 'Mellomlagringsnøkkel',
    'apache-settings.nginxCacheCookies' => 'Mellomlagre forespørsler med informasjonskapsler',
    'apache-settings.nginxCacheBypassLocations' => 'Deaktiver mellomlagring for lokasjoner',
    'apache-settings.nginxCacheBypass' => 'Forbigå hurtigbuffer når',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'HTTP no-cache filhoder mottas i forespørslen',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'HTTP autorisasjons filhoder mottas i forespørslen',
    'apache-settings.nginxCacheBypassGetNocache' => 'GET nocache parameteren mottas i forespørselen',
    'apache-settings.nginxCacheUseStale' => 'Returner foreldede mellomlagrede oppføringer',
    'apache-settings.nginxCacheUseStale5xx' => 'Oppstrømmen returnerer 5xx serverfeil',
    'apache-settings.nginxCacheUseStale4xx' => 'Oppstrømmen returnerer 4xx klientfeil',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Mellomlagret oppdateres',
    'apache-settings.additional' => 'Ytterligere Apache-direktiver',
    'apache-settings.additionalSettingsDescription' => 'Hvis du kan ikke kan finne bestemte innstillinger, kan du legge dem til i feltene nedenfor. Disse innstillingene vil overstyre Apache-direktiver for hele serveren. Direktivene fra det første feltet brukes når en besøkende får tilgang til nettstedet over HTTP. Det andre feltet inneholder direktiver for HTTPS. Som regel bør du legge direktiver til begge felt. Bruk samme syntaks som du bruker for httpd.include. For eksempel, hvis du ønsker å sette en brukerdefinert feilside, legg til linjen: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Ytterligere direktiver for HTTP',
    'apache-settings.additionalSslSettings' => 'Ytterligere direktiver for HTTPS',
    'apache-settings.additionalSettingsError' => 'Ugyldig Apache konfigurering: %%error%%',
    'apache-settings.rollbackFailed' => 'Kan ikke bruke den nåværende Apache konfigurasjonsfilen og for å tilbakerulle til den tidligere versjonen av filen fordi de inneholder ugyldig konfigurering.',
    'apache-settings.additionalNginx' => 'Ytterligere nginx-direktiver',
    'apache-settings.additionalNginxSettingsDescription' => 'Her du kan angi innstillingene for nginx revers-proxyserver som kjører foran Apache. Direktivene dine vil overstyre nginx-konfigurasjon for hele serveren. For eksempel vil du endre tilkoblingsavbrudd eller å pakke forespørsler med gzip. Bruk samme syntaks som du bruker for nginx.conf. Hvis du for eksempel vil pakke alle forespørsler over proxy med gzip, legger du til linjen: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Ytterligere nginx-direktiver',
    'apache-settings.additionalNginxSettingsError' => 'Ugyldig nginx konfigurering: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Kan ikke bruke nåværende nginx konfigurasjonsfil og for å tilbakerulle til den tidligere versjonen av filen fordi de begge inneholder ugyldig konfigurering.',
    'apache-settings.clearCache' => 'Slett hurtigbuffer',
    'apache-settings.clearCacheHint' => 'Slett nginx-hurtigbuffer for %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'Hurtigbuffer er slettet',

    'backup.backup-password-protection.securitySettingsSection' => 'Sikkerhetsinnstillinger for sikkerhetskopi',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Hent frem passordet fra innstillingene for ekstern lagring',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Skriv inn passord manuelt',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Angi passord',
    'backup.backup-password-protection.backupPassword' => 'Passord',
    'backup.backup-password-protection.inputPasswordType' => 'Passordtype',
    'backup.backup-password-protection.confirmBackupPassword' => 'Gjenta passord',
    'backup.backup-password-protection.backupPasswordHint' => 'Fjern dette valget dersom du har glemt passordet. Legg merke til, at i dette tilfellet vil noen sensitive data ikke gjenopprettes ordentlig. For eksempel vil brukerpassord bli overskrevet med tilfeldige passord, informasjon om allerede installerte APS-apper vil forsvinne, og så videre.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Hvis du bruker passordbeskyttelse for denne sikkerhetskopien, må du legge inn passordet i feltet under. Vær oppmerksom på at dersom du legger inn feil passord, vil ikke Plesk gjenopprette sikkerhetskopien. I stedet, vil sikkerhetskopien bli kopiert til det lokale lageret.',

    'backup.conflict-database.dbMappingLegend' => 'Tilordning av databaseserver',
    'backup.conflict-database.serverType' => 'Servertype',
    'backup.conflict-database.hostName' => 'Vertsnavn',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Måldatabaseservere',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Databasen kan ikke gjenopprettes: Det finnes ingen passende databaseserver',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Last opp IP tilordningsfil',
    'backup.conflict-ip.ipMappingLegend' => 'IP tilordning',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Spar nåværende IP tilordning til fil',
    'backup.conflict-ip.ipAddressNotFound' => 'Det finnes ingen ledige IP-adresser av denne typen.',
    'backup.conflict-ip.sharedIp' => 'delt',
    'backup.conflict-ip.dedicatedIp' => 'dedikert',
    'backup.conflict-ip.fileNotFound' => 'Filen må ikke være tom.',
    'backup.conflict-ip.invalidIpToMap' => 'En ugyldig verdi for en gammel IP-adresse: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'En ugyldig verdi for en ny IP-adresse: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'IP-adressen %%ip%% ble ikke funnet i databasen.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Last opp en IP-tilordningsfil',
    'backup.conflict-ip.ipMappingFileHint' => 'En IP-tilordningsfil er en enkel tekstfil. Hver linje i denne filen inneholder IP tilordning i det formatet: <gammel IP adresse> <ny IP adresse>',
    'backup.conflict-ip.oldIp' => 'Gamle IP adresser',
    'backup.conflict-ip.newIp' => 'Nye IP adresser',

    'backup.copy-to-server.ignoreBackupSign' => 'Last opp sikkerhetskopi filer uten en gyldig signatur',
    'backup.copy-to-server.wrongPassword' => 'Den angitte passordet er feil. Plesk vil be deg legge inn passordet på nytt under gjenoppretting av sikkerhetskopien.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Den opplastede sikkerhetskopifilen %%fileName%% endret, skadet, opprettet på en annen server eller i en eldre versjon av Plesk som ikke støtter signering av sikkerhetskopier. Før du gjenoppretter data fra denne sikkerhetskopifilen, må du forsikre deg om at du kan stole på kilden til denne filen.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Kan ikke laste opp sikkerhetskopi filen %%fileName%%. Filen inneholder enten endrede eller korrupte data, eller den var opprettet på en annen server, eller i en eldre versjon av Plesk. For å gjenopprette data fra denne filen, ta kontakt med hostingleverandøren din.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Kan ikke laste opp sikkerhetskopi filen %%fileName%%. Filen var endret, skadet, opprettet på en annen server eller i en eldre versjon av Plesk som ikke støtter signering av sikkerhetskopier. Dersom du stoler på denne sikkerhetskopien, velger du «Last opp sikkerhetskopi uten gyldig signatur», og laster den opp på nytt.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Kunne ikke flytte valgt sikkerhetskopi %%fileName%% til serverlager. Feil: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Følgende deler av inkrementell sikkerhetskopiering ble ikke kopiert:%%endl%%%%missedParts%%%%endl%%Vennligst kopier de delene som mangler.",

    'backup.ftp-settings.isActive' => 'Bruk FTP(S)-lager',
    'backup.ftp-settings.host' => 'Vertsnavn eller IP for FTP-server',
    'backup.ftp-settings.directory' => 'Mappe for lagring av sikkerhetskopifiler',
    'backup.ftp-settings.directoryHint' => 'For eksempel, /minmappe/minesikkerhetskopier',
    'backup.ftp-settings.ftpLogin' => 'FTP brukernavn',
    'backup.ftp-settings.ftpPassword' => 'FTP-passord',
    'backup.ftp-settings.usePassiveMode' => 'Bruk passivt modus',
    'backup.ftp-settings.useFtps' => 'Bruk FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Bruk av den lokale Plesk FTP-serveren som eksternt lager er forbudt. Vennligst angi en ekstern lokasjon.',
    'backup.ftp-settings.warningHostIsLocal' => 'FTP(S) lagerinnstillinger ble konfigurert til å lagre sikkerhetskopier på serveren der filene til abonnementet ditt befinner seg. Denne konfigurasjonen anbefales ikke på grunn av fare for tap av data og overforbruk av diskplass.',
    'backup.ftp-settings.enterFtpLogin' => 'Skriv inn et korrekt brukernavn.',
    'backup.ftp-settings.enterFtpPassword' => 'Skriv inn et korrekt passord.',

    'backup.remote-settings.isActive' => 'Bruk lageret',
    'backup.remote-settings.initError' => 'Kan ikke initialisere %%extName%% settings page: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Sikkerhetsinnstillinger for sikkerhetskopi',

    'backup.restore.detailsSection' => 'Detaljer',
    'backup.restore.contentInfoSection' => 'Innhold i sikkerhetskopi',
    'backup.restore.restorationOptionsSection' => 'Gjenoppretting valgmuligheter',
    'backup.restore.emailNotification' => 'Når gjenopprettingen er fullført, send en varsling til',
    'backup.restore.comments' => 'Kommentarer',
    'backup.restore.creationDate' => 'Opprettelsesdato',
    'backup.restore.systemNotes' => 'Systemmerknader',
    'backup.restore.ownerAdmin' => 'Opprettet av administratoren.',
    'backup.restore.ownerReseller' => 'Opprettet av en forhandler.',
    'backup.restore.ownerCustomer' => 'Opprettet av en kunde.',
    'backup.restore.ownerServiceUser' => 'Opprettet av en ekstra bruker.',
    'backup.restore.partOfParentBackup' => 'Del av sikkerhetskopi %%type%%.',
    'backup.restore.server' => 'server',
    'backup.restore.reseller' => 'forhandler',
    'backup.restore.client' => 'kunde',
    'backup.restore.incremental' => 'Trinnvis.',
    'backup.restore.multiVolume' => 'Flere volumer.',
    'backup.restore.backupSize' => 'Størrelse på sikkerhetskopi',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (dette tillegget) + %%base%% (opprinnelig sikkerhetskopi) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (dette tillegget) + %%prev%% (tidligere tillegg) + %%base%% (opprinnelig sikkerhetskopi) = %%total%%',
    'backup.restore.download' => 'Last ned',
    'backup.restore.downloadHint' => 'Last ned sikkerhetskopi til din lokale datamaskin.',
    'backup.restore.downloadDisabled' => 'Nedlasting av sikkerhetskopier er midlertidig utilgjengelig. Vennligst prøv igjen eller ta kontakt med tjenestetilbyder.',
    'backup.restore.copy' => 'Kopier til serverlager',
    'backup.restore.copyHint' => 'Kopier de valgte sikkerhetskopiene til lageret på serveren.',
    'backup.restore.contentInfo' => 'Sikkerhetskopien inneholder',
    'backup.restore.restoreButton' => 'Gjenopprett',
    'backup.restore.mail' => 'E-post',
    'backup.restore.domainConfiguration' => 'Domenekonfigurasjon',
    'backup.restore.virtualHost' => 'Innhold på virtuell vert',
    'backup.restore.database' => 'Databaser',
    'backup.restore.serverConfiguration' => 'Serverinnstillinger',
    'backup.restore.serverConfigurationLicense' => 'Lisensnøkkel',
    'backup.restore.serverPersonalConfiguration' => 'Konfigurasjon av administratorkonto',
    'backup.restore.serverPersonalDomains' => 'Administratorens domener',
    'backup.restore.serverPersonalClients' => 'Administratorens kunder',
    'backup.restore.resellers' => 'Videreforhandler',
    'backup.restore.resellerPersonalConfiguration' => 'Konfigurasjon av forhandlerkonto',
    'backup.restore.resellerPersonalDomains' => 'Forhandlerens domener',
    'backup.restore.resellerPersonalClients' => 'Forhandlers kunder',
    'backup.restore.clientPersonalConfiguration' => 'Konfigurasjon av kundekonto',
    'backup.restore.clientPersonalDomains' => 'Kundens domener',
    'backup.restore.restoreModifiedSection' => 'Gjenopprett sikkerhetskopi filen til tross for en korrupt signatur.',
    'backup.restore.restoreModifiedDump' => 'Gjenopprett denne sikkerhetskopien til tross for at den ikke har en gyldig signatur',
    'backup.restore.resolutionPolicy' => 'Løsningspolicy',
    'backup.restore.resolutionPolicyDescription' => 'Konflikter i tidsmålingen oppstår enten når det gjenopprettede objektet allerede eksisterer i systemet med en nyere endringsdato, eller når det gjenopprettede objektet ikke finnes tilstede i systemet.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Den angitte passordet er feil. Sikkerhetskopifilen vil bli kopiert til serverens lokale lager.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Kan ikke gjenopprette reservekopiering. Den angitte passordet er feil.',
    'backup.restore.serverContentAndConfiguration' => 'Serverkonfigurasjon og innhold',
    'backup.restore.serverConfigurationOnly' => 'Serverkonfigurasjon',
    'backup.restore.resellerContentAndConfiguration' => 'Konfigurasjon og innhold av forhandlerkonto',
    'backup.restore.resellerConfigurationOnly' => 'Konfigurasjon av forhandlerkonto',
    'backup.restore.clientContentAndConfiguration' => 'Konfigurasjon og innhold av kundekonto',
    'backup.restore.clientConfigurationOnly' => 'Konfigurasjon av kundekonto',
    'backup.restore.domainContentAndConfiguration' => 'Konfigurasjon og innhold av domene',
    'backup.restore.domainConfigurationOnly' => 'Domenekonfigurasjon',
    'backup.restore.restoreType' => 'Hva ønsker du å gjenopprette?',
    'backup.restore.restoreTypeFull' => 'Alle objekter (hele systemet)',
    'backup.restore.restoreTypeGranular' => 'Valgte objekter',
    'backup.restore.restoreObjectType' => 'Type objekt som skal gjenopprettes',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Abonnement',
    'backup.restore.restoreObjectTypeCustomers' => 'Kunde',
    'backup.restore.restoreObjectTypeResellers' => 'Forhandler',
    'backup.restore.restoreObjectTypeMailUsers' => 'E-postkonto',
    'backup.restore.restoreObjectTypeDatabases' => 'Database',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS-sertifikater',
    'backup.restore.restoreObjectTypeSites' => 'Nettsteder',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS-sone',
    'backup.restore.restoreObjectTypeMailLists' => 'Adresselister',
    'backup.restore.restoreObjectTypeWebContent' => 'Domenefiler',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Valgte filer',
    'backup.restore.restoreSubscriptionLookup' => 'Abonnement',
    'backup.restore.restoreComponents' => 'Komponenter som skal gjenopprettes',
    'backup.restore.errorLog' => 'Feillogg',
    'backup.restore.backupDetailsLogDoesntExist' => 'Sikkerhetskopilogg er ikke tilgjengelig.',
    'backup.restore.dumpFailedSection' => 'Feillogg',
    'backup.restore.dumpFailed' => 'Kunne ikke gjenopprette data: Sikkerhetskopifilen er ugyldig.',
    'backup.restore.granularNotSupported' => 'Du kan kun velge objekter som skal gjenopprettes når du gjenoppretter fra sikkerhetskopier som ble opprettet i Plesk 12.0 eller nyere.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Gjenoppretting av alle data fra sikkerhetskopier støttes ikke i forhandlerens Power User-visning. Velg objekter som skal gjenopprettes. Du kan endre grensesnittvisning i %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Grensesnitt preferanser',
    'backup.restore.contentRestoreType' => 'Gjenopprett',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Kun konfigurasjon av valgte objekter',
    'backup.restore.contentRestoreTypeFull' => 'Konfigurasjon og innholdet av valgte objekter',
    'backup.restore.errorWrongFormat' => 'Kan ikke gjenopprette reservekopiering: filen inneholder feil formatering.',
    'backup.restore.errorContentError' => 'Kan ikke gjenopprette alle data: sikkerhetskopien inneholder feil.',
    'backup.restore.warningSignError' => 'Kan ikke validere sikkerhetskopi signaturen. Sikkerhetskopifilen kan ha blitt endret, skadet, opprettet på en annen server, eller i en tidligere Plesk versjon.',
    'backup.restore.warningSignErrorNotAdmin' => 'Denne sikkerhetskopien kan bare gjenopprettes av administrator for Plesk.',
    'backup.restore.warningPartial' => "Følgende deler av inkrementell sikkerhetskopi ble ikke funnet:%%endl%%%%missedParts%%%%endl%%Ikke alle filene kan gjenopprettes. Last opp de manglende delene og prøve å gjenopprette igjen.",
    'backup.restore.warningDeprecatedBackupVersion' => 'Sikkerhetskopien du prøver å gjenopprette ble opprettet med en versjon av Plesk som ikke støttes og den kan ikke gjenopprettes. Bruk utvidelsen Plesk Migrator for å overføre dine data fra gamle versjoner av Plesk.',
    'backup.restore.encryptionKeyError' => 'Passord for én eller flere kontoer i denne sikkerhetskopien kan ikke gjenopprettes og vil bli tilbakestilt. Sannsynligvis ble denne sikkerhetskopien opprettet på en annen Plesk-server og kryptert med krypteringsnøkkelen for den serveren.',
    'backup.restore.errorCorruptedContent' => 'Følgende filer finnes ikke eller er korrupte: ',
    'backup.restore.statusSection' => 'Sikkerhetskopieringsstatus',
    'backup.restore.statusDetails' => 'Statusdetaljer',
    'backup.restore.restoreBlocked' => 'Sikkerhetskopien kan ikke gjenopprettes.',
    'backup.restore.restoreBlockedDescription' => 'Sikkerhetskopi av type %%backupType%% kan ikke gjenopprettes nå. For å gjenopprette den, logg inn som eier av sikkerhetskopi og klikk på dette sikkerhetskopinavnet i Backup Manager.',

    'backup.schedule.scheduleSection' => 'Tidsplan',
    'backup.schedule.backupEnable' => 'Aktiver denne sikkerhetskopi oppgaven',
    'backup.schedule.backupPeriod' => 'Kjør denne sikkerhetskopieringsoppgaven',
    'backup.schedule.on' => 'på',
    'backup.schedule.at' => 'kl.',
    'backup.schedule.every' => 'hver(t)',
    'backup.schedule.hours' => '{period, plural, one {time} other {timer}}',
    'backup.schedule.retainHours' => 'timer',
    'backup.schedule.useIncremental' => 'Bruk inkrementell sikkerhetskopiering',
    'backup.schedule.useIncrementalDisableHint' => 'Det valgte innholdet for sikkerhetskopiering tillater kun opprettelse av en fullstendig sikkerhetskopi.',
    'backup.schedule.fullBackupPeriod' => 'Utfør full sikkerhetskopiering',
    'backup.schedule.hourly' => 'Per time',
    'backup.schedule.daily' => 'Hver dag',
    'backup.schedule.weekly' => 'Ukentlig',
    'backup.schedule.monthly' => 'Månedlig',
    'backup.schedule.yearly' => 'Årlig',
    'backup.schedule.days' => 'dager',
    'backup.schedule.weeks' => 'uker',
    'backup.schedule.months' => 'måned',
    'backup.schedule.years' => 'år',
    'backup.schedule.backupTimeDescription' => 'Tidssone: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Standardmessig systemtidssone',
    'backup.schedule.first' => 'først',
    'backup.schedule.last' => 'siste',
    'backup.schedule.dayOfMonth' => 'dag',
    'backup.schedule.email' => 'Dersom det oppstår feil under utførelsen av denne sikkerhetskopieringen, send e-postvarsel til',
    'backup.schedule.invalidFields' => 'Noen påkrevede felt er tomme eller inneholder en gal verdi: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Maksimalt antall fullstendige sikkerhetskopier som skal lagres (inkludert både planlagte og manuelle sikkerhetskopier)',
    'backup.schedule.retainDumpFilesFor' => 'Lagre fullstendig sikkerhetskopi i',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'La dette feltet være tomt hvis du ikke ønsker å fjerne fullstendige sikkerhetskopier automatisk.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Maksimumsgrensen for serverlageret som angis av hostingleverandøren er %%max%%: Grensen din må være lik eller lavere enn %%max%%.',
    'backup.schedule.retainLimitedDescription' => 'Grensen hostingleverandøren har angitt for serverlagring er {max, plural, one {# full sikkerhetskopi} other {# fulle sikkerhetskopier}} (inkludert alle planlagte og manuelle sikkerhetskopieringer).',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Lagring av planlagte sikkerhetskopier av abonnement på et eksternt lagringssted i skyen er en premiumfunksjon som må kjøpes i Plesk Online Store.',
    'backup.schedule.backupHourlyWarning' => 'Aktivering av sikkerhetskopiering hver time kan føre til økt bruk av serverressurser.',
    'backup.schedule.titleHourly' => 'Innstillinger for sikkerhetskopiering per time',
    'backup.schedule.titleDaily' => 'Innstillinger for daglig sikkerhetskopiering',
    'backup.schedule.titleWeekly' => 'Innstillinger for ukentlig sikkerhetskopiering',
    'backup.schedule.titleMonthly' => 'Innstillinger for månedlig sikkerhetskopiering',
    'backup.schedule.titleCustom' => 'Egenderfinerte innstillinger for sikkerhetskopiering',

    'backup.secure-backup.hint' => 'Du kan bruke et passord til å kryptere brukeres passord som ligger i Plesk-databasen i en sikkerhetskopi. Merk at gjenoppretting av en passordbeskyttet sikkerhetskopi uten å ha riktig passord vil resultere i tilfeldig genererte passord.',
    'backup.secure-backup.hintAdmin' => 'Du kan kryptere passord i Plesk-databaser som ligger i sikkerhetskopier med Plesks krypteringsnøkkel eller med et passord. Nøkkelen er unik for hver Plesk-installasjon. Sikkerhetskopier som er krypterte med denne nøkkelen kan kun gjenopprettes til samme Plesk-installasjon som de ble opprettet i, og kan ikke gjenopprettes til andre Plesk-installasjoner. Merk at Plesk ikke beskytter alle sensitive data i en sikkerhetskopi. Vi anbefaler at du lagrer sikkerhetskopier i ekstern skylagring og aktiverer kryptering av sikkerhetskopier gjennom skytjenesten.',
    'backup.secure-backup.usePasswordProtection' => 'Bruk passordbeskyttelse (anbefalt)',
    'backup.secure-backup.backupPasswordSource' => 'Passordtype',
    'backup.secure-backup.pleskKey' => 'Plesks krypteringsnøkkel',
    'backup.secure-backup.userPassword' => 'Angitt passord',
    'backup.secure-backup.password' => 'Passord',
    'backup.secure-backup.passwordConfirmation' => 'Gjenta passord',

    'backup.subform.settingsSection' => 'Innstillinger for sikkerhetskopiering',
    'backup.subform.prefix' => 'Legg et prefiks til navnet på sikkerhetskopien',
    'backup.subform.comment' => 'Kommentarer',
    'backup.subform.splitSize' => 'Opprett en sikkerhetskopi med flere volumer, volumstørrelse (MB)',
    'backup.subform.repository' => 'Lagre på',
    'backup.subform.repositoryDescription' => 'Innstillinger for FTP(S)-lager er ikke angitt. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Både serverlagring og %%name%%',
    'backup.subform.remoteRepositoryOption' => 'Ekstern lagring',
    'backup.subform.remoteRepository' => 'ekstern lagring',
    'backup.subform.remoteRepositoryText' => 'Velg ekstern lagring i skyen',
    'backup.subform.configureRemoteRepositories' => '<a href="%%url%%">Tilpass ekstern lagring</a> for å lagre sikkerhetskopiene dine i skyen.',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">Tilpass FTP-lagring</a> for å lagre sikkerhetskopiene dine offline.',
    'backup.subform.configureRemoteDesc' => '%%link%% for å lagre sikkerhetskopiene dine i skyen.',
    'backup.subform.configureRemoteLink' => 'Tilpass ekstern lagring',
    'backup.subform.configureFtpDesc' => '%%link%% for å lagre sikkerhetskopiene dine offline.',
    'backup.subform.configureFtpLink' => 'Tilpass FTP-lagring',
    'backup.subform.repositoryConfigure' => 'Konfigurer',
    'backup.subform.email' => 'Når sikkerhetskopieringen er fullført, send et e-postvarsel til',
    'backup.subform.contentSection' => 'Innhold i sikkerhetskopi',
    'backup.subform.domainConfiguration' => 'Configurasjon',
    'backup.subform.domainConfigurationVhost' => 'Brukerfiler og databaser',
    'backup.subform.domainConfigurationFile' => 'Brukerfiler',
    'backup.subform.domainConfigurationDatabase' => 'Databaser',
    'backup.subform.domainConfigurationMail' => 'E-postmeldinger',
    'backup.subform.content' => 'Sikkerhetskopier',
    'backup.subform.backupAll' => 'All konfigurasjon og innhold',
    'backup.subform.backupConfiguration' => 'Bare konfigurasjon',
    'backup.subform.backupVhost' => 'All konfigurasjon og alt innhold unntatt e-postmeldinger',
    'backup.subform.backupMailFile' => 'All konfigurasjon og alt innhold unntatt database',
    'backup.subform.backupMailDatabase' => 'All konfigurasjon og alt innhold unntatt brukerfiler',
    'backup.subform.backupMail' => 'Bare konfigurasjon og e-postmeldinger',
    'backup.subform.backupDatabase' => 'Kun konfigurasjon og brukerdatabaser',
    'backup.subform.backupFile' => 'Kun konfigurasjon og brukerfiler',
    'backup.subform.mssqlNativeBackup' => 'Bruk den medfølgende MS SQL sikkerhetskopieringsfunksjonen om mulig',
    'backup.subform.mssqlNativeBackupAdmin' => 'Bruk den medfølgende MS SQL-funksjonen for sikkerhetskopiering (For eksterne databaser må du sørge for at du har konfigurert innstillinger for sikkerhetskopiering for den eksterne MS SQL-serveren i Verktøy og innstillinger> Databaseservere)',
    'backup.subform.localRepository' => 'Serverlager',
    'backup.subform.localRepositoryPath' => 'Serverlager på %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP(S) lagring på %%uri%% <a href="%%link%%">Endre innstillinger</a>',
    'backup.subform.ftpRepositoryText' => 'FTP(S) lagring på %%uri%%',
    'backup.subform.type' => 'Type',
    'backup.subform.typeFullBackup' => 'Full',
    'backup.subform.typeIncremental' => 'Trinnvis',
    'backup.subform.typeIncrementalDescription' => 'Sikkerhetskopier hostingdata for nettbasert hosting og e-posthosting som er endret siden forrige sikkerhetskopiering (det foretas alltid fullstendig sikkerhetskopiering av databasedata).',
    'backup.subform.incrementalNotAvailable' => 'For å opprette inkrementelle sikkerhetskopier, ta først en komplett sikkerhetskopiering.',
    'backup.subform.excludeLogs' => 'Ekskluder loggfiler',
    'backup.subform.excludeFiles' => 'Ekskluder spesifikke filer fra sikkerhetskopien',
    'backup.subform.excludeFilesDescription' => 'Du kan bare ekskludere filer innenfor webområder. Angi filbane eller -baner relativt til rotkatalogen for webområdet. Skill individuelle filer med komma. Bruk av maskesymbolet er tillatt (f.eks. /enkatalog/log*).',

    'backup.upload.uploadHint' => 'Her kan du laste opp sikkerhetskopier til Plesk-lageret. Maksimal filstørrelse er begrenset til to gigabytes.',
    'backup.upload.backupFile' => 'Sikkerhetskopi',
    'backup.upload.removeLink' => 'Fjern',
    'backup.upload.addFileLink' => 'Last opp flere filer',
    'backup.upload.backupSecuritySettings' => 'Sikkerhetsinnstillinger for sikkerhetskopi',
    'backup.upload.signatureHint' => 'Plesk kontroller sikkerhetskopifiler for gyldig struktur og signatur. Filer som har blitt endret, skadet, eller opprettet på en annen server blir ikke klarert. Alternativet under gir deg tilgang til å gjenopprette data fra slike filer. Velg bare dette alternativet dersom du stoler på sikkerhetskopikilden, siden opplasting av en slik fil kan kompromittere sikkerheten eller forstyrre driften av serveren. Merk: Sikkerhetskopifiler som er laget i Plesk-versjoner før 11.5 er ansett som ikke klarerte fordi de mangler signaturer. Pass på at du bare gjenoppretter slike filer dersom du stoler på kilden.',
    'backup.upload.ignoreSign' => 'Last opp sikkerhetskopi filer uten en gyldig signatur',
    'backup.upload.passwordHint' => 'Hvis du bruker passordbeskyttelse for denne sikkerhetskopien, må du legge inn passordet i feltet under. Merk at dersom du angir et feil passord, vil Plesk varsle deg, men sikkerhetskopien vil bli lastet opp til serveren uansett. Under gjenoppretting av sikkerhetskopien vil du bli spurt om å legge inn passordet på nytt.',
    'backup.upload.alreadyExistsWarning' => 'Sikkerhetskopifilen %%fileName%% finnes allerede i serverens lokale lager.',
    'backup.upload.incorrectPasswordWarning' => 'Den angitte passordet er feil. Plesk vil be deg legge inn passordet på nytt under gjenoppretting av sikkerhetskopien.',
    'backup.upload.deprecatedDumpError' => 'Sikkerhetskopien du prøver å laste opp ble opprettet med en versjon av Plesk som ikke støttes og den kan ikke importeres. Bruk utvidelsen Plesk Migrator for å overføre dine data fra gamle versjoner av Plesk.',
    'backup.upload.mailFormatWarning' => 'Sikkerhetskopien %%fileName%% ble lastet opp til lageret. Viktig: Sikkerhetskopien %%fileName%% inneholder e-postinnhold som ikke vil bli gjenopprettet fordi formatet (Plesk 8.3 - 8.6) ikke støttes. For å kunne gjenopprette dette e-postinnholdet, sikkerhetskopier det ved hjelp av Plesk Backup Tool, velg alternativet Sikkerhetskopier innhold av postbokser og velg alternativet med dump gjenopprettet til e-postserver.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Den opplastede sikkerhetskopifilen (%%fileName%%) endret, skadet, opprettet på en annen server eller i en eldre versjon av Plesk som ikke støtter signering av sikkerhetskopier. Før du gjenoppretter data fra denne sikkerhetskopifilen, må du forsikre deg om at du kan stole på kilden til denne filen.',
    'backup.upload.corruptedSignatureAdminError' => 'Kan ikke laste opp sikkerhetskopi filen %%fileName%%). Filen var endret, skadet, opprettet på en annen server eller i en eldre versjon av Plesk som ikke støtter signering av sikkerhetskopier. Dersom du stoler på denne sikkerhetskopien, velger du "Last opp sikkerhetskopi uten gyldig signatur", og laster den opp på nytt.',
    'backup.upload.corruptedSignatureUserWarning' => 'Den opplastede sikkerhetskopifilen (%%fileName%%) inneholder enten endrede eller korrupte data, eller den var opprettet på en annen server, eller i en eldre versjon av Plesk.',
    'backup.upload.corruptedSignatureUserError' => 'Kan ikke laste opp sikkerhetskopi filen %%fileName%%). Filen inneholder enten endrede eller korrupte data, eller den var opprettet på en annen server, eller i en eldre versjon av Plesk. For å gjenopprette data fra denne filen, ta kontakt med hostingleverandøren din.',
    'backup.upload.uploadError' => 'Kunne ikke laste opp %%fileName%% til serverlager: %%error%%',
    'backup.upload.fileNotSelected' => 'Ingen filer ble valgt for opplasting. Velg minst én fil.',
    'backup.upload.missedPartsWarning' => "Følgende deler av inkrementell sikkerhetskopi ble ikke lastet opp:%%endl%%%%missedParts%%%%endl%%Vennligst last opp de manglende delene.",
    'backup.upload.unknownType' => 'Ukjent objekttype',
    'backup.upload.storageLink' => 'annet lager',
    'backup.upload.anotherStorage' => 'Dumpen ble lastet opp til %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Forhandleren %%name%% ble ikke funnet. Opprett først for å gjenopprette opplastet dump.',
    'backup.upload.clientNotFound' => 'Kunden %%name%% ble ikke funnet. Opprett først for å gjenopprette opplastet dump.',
    'backup.upload.domainNotFound' => 'Domenet %%name%% ble ikke funnet. Opprett først for å gjenopprette opplastet dump.',

    'backup.web-content-dynamic.addButtonTitle' => 'Legg til filer',
    'backup.web-content-dynamic.noItems' => 'Ingen fil er valgt',
    'backup.web-content-dynamic.hint' => 'Sett kryss for å velge filer og mapper.',
    'backup.web-content-dynamic.title' => 'Velg filer',
    'backup.web-content-dynamic.columnName' => 'Navn',
    'backup.web-content-dynamic.columnChangeDate' => 'Endret',
    'backup.web-content-dynamic.columnSize' => 'Størrelse',
    'backup.web-content-dynamic.columnPermissions' => 'Tillatelser',
    'backup.web-content-dynamic.columnUser' => 'Bruker',
    'backup.web-content-dynamic.columnGroup' => 'Gruppe',
    'backup.web-content-dynamic.waitButtonTitle' => 'Vent litt',
    'backup.web-content-dynamic.loadingTitle' => 'Vent litt. Laster inn...',

    'backup.invalidFields' => 'Noen felt er tomme eller inneholder en ugyldig verdi.',
    'backup.notEnoughDiskSpace' => 'Ikke nok diskplass på %%path%% til å sikkerhetskopiere. Minst %%required%% GB ledig plass kreves (%%available%% GB tilgjengelig)',

    'change-subscriptions-owner.infoTitle' => 'Info',
    'change-subscriptions-owner.infoDescription' => '%%total%% abonnementer, %%active%% aktive abonnementer, %%diskSpace%% diskplass brukt, %%traffic%% trafikk brukt',
    'change-subscriptions-owner.possibleOwnersTitle' => 'Mulige nye eiere av abonnementer',
    'change-subscriptions-owner.selectedSubscriptions' => 'Valgte abonnementer',
    'change-subscriptions-owner.subscriptionName' => 'Abonnementsnavn',
    'change-subscriptions-owner.ownerName' => 'Eierens navn',
    'change-subscriptions-owner.currentIpAddress' => 'Nåværende IP adresse',
    'change-subscriptions-owner.newIpAddress' => 'Ny IP-adresse',
    'change-subscriptions-owner.submit' => 'Tilordne på nytt',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, Disk I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Sett opp grenser for systemressurser som forbrukes av et abonnement. Plesk bruker en Linux-kjernefunksjon kalt kontrollgrupper (cgroups) for å sikre at grensene ikke overskrides.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Begrens individuelle abonnementer til spesifisert mengde CPU-forbruk.',
    'cgroups-settings.cpuPeriodLimit' => 'Periode for sjekk av CPU-bruk',
    'cgroups-settings.percentUsageDescription' => 'Den totale mengden CPU tid er lik  %%total%%%%units%% for din server',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Begrens individuelle abonnementer til en spesifisert mengde RAM-forbruk. Merk at hvis et abonnement overskrider denne grensen, vil prosessen som forbruker mest bli stoppet.',
    'cgroups-settings.ramPeriodLimit' => 'Periode for sjekk av RAM-bruk',
    'cgroups-settings.diskSettings' => 'Disk-I/U',
    'cgroups-settings.diskReadSettings' => 'Lese disk',
    'cgroups-settings.diskReadSettingsDescription' => 'La individuelle abonnementer kun bruke båndbredde for disklesing innenfor den angitte grensen.',
    'cgroups-settings.diskReadPeriodLimit' => 'Periode for sjekk av disklese-bruk',
    'cgroups-settings.diskWriteSettings' => 'Skrive til disk',
    'cgroups-settings.diskWriteSettingsDescription' => 'La individuelle abonnementer kun bruke båndbredde for skriving til disk innenfor den angitte grensen.',
    'cgroups-settings.diskWritePeriodLimit' => 'Periode for sjekk av diskskrive-bruk',
    'cgroups-settings.limit' => 'Grense',
    'cgroups-settings.threshold' => 'Varsle ved overskridelse',
    'cgroups-settings.limitNotificationEnabled' => 'Melding aktivert',
    'cgroups-settings.periodFiveMinutes' => '5 minutter',
    'cgroups-settings.periodHour' => '1 time',
    'cgroups-settings.periodDay' => '1 dag (24 timer)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/sek',

    'custom-button.privateLabel' => 'Vis kun for meg',
    'custom-button.textLabel' => 'Knappeetikett',
    'custom-button.tooltipLabel' => 'Verktøytipstekst',
    'custom-button.iconLabel' => 'Bakgrunnsbilde',
    'custom-button.priorityLabel' => 'Prioritet',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Legg parametere til URL',
    'custom-button.placeLabel' => 'Plassering',
    'custom-button.internalLabel' => 'Åpne URL-adresse i Plesk',
    'custom-button.internalDescription' => 'Angi om URL-adressen skal åpnes i en Plesk-side eller i et nytt lesevindu.',
    'custom-button.noFrameLabel' => 'Ikke bruk rammer',
    'custom-button.noFrameDescription' => 'Hvis du legger til en brukerdefinert knapp som fører til en Plesk-utvidelse eller en app på Kundepanelet, kan du angi hvordan denne utvidelsen/appen skal vises: i en ramme eller som en del av GUI for Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Inkluder abonnement-ID, domene-ID og domenealias-ID',
    'custom-button.urlParamLabel_dom_name' => 'Inkluder navn på primærdomene',
    'custom-button.urlParamLabel_ftp_user' => 'Inkluder FTP brukernavn',
    'custom-button.urlParamLabel_ftp_pass' => 'Inkluder FTP-passord',
    'custom-button.urlParamLabel_cl_id' => 'Inkluder kunde-ID',
    'custom-button.urlParamLabel_cname' => 'Inkluder kundens bedriftsnavn',
    'custom-button.urlParamLabel_pname' => 'Inkluder kundens kontaktnavn',
    'custom-button.urlParamLabel_email' => 'Inkluder kundens epostadresse',
    'custom-button.buttonPlace_navigation' => 'Felles tilgang',
    'custom-button.buttonPlace_admin' => 'Administrator-startside',
    'custom-button.buttonPlace_admin-settings' => 'Administratorside for verktøy og innstillinger',
    'custom-button.buttonPlace_reseller' => "Forhandlerens startside",
    'custom-button.buttonPlace_reseller-settings' => 'Forhandlerens Verktøy og tilbehør-side',
    'custom-button.buttonPlace_client' => 'Kundens startside',
    'custom-button.buttonPlace_domain' => "Siden Nettsteder og domener for et abonnement",
    'custom-button.buttonPlace_domain_powerUser' => "Siden Nettsteder og domener for et webområde",
    'custom-button.buttonPlace_domain-properties' => 'Nettstedsverktøy',

    'database-server-change-password.adminPassword' => 'Administrators passord',
    'database-server-change-password.success' => 'Administratorpassordet er oppdatert.',

    'database-server-create.general' => 'Generelt',
    'database-server-create.type' => 'Databaseservertype',
    'database-server-create.unixSocket' => '(lokal tilkobling)',
    'database-server-create.host' => 'Vertsnavn eller IP-adresse',
    'database-server-create.port' => 'Portnummer',
    'database-server-create.portDescription' => 'La være blank for standard port nummer',
    'database-server-create.version' => 'Databaseserver-versjon',
    'database-server-create.default' => 'Bruk denne serveren som standard for %%type%%.',
    'database-server-create.externalConnections' => 'Tillat den lokale MariaDB/MySQL serveren å akseptere eksterne forbindelser',
    'database-server-create.externalConnectionsDescription' => 'Å endre denne innstillingen vil resultere i at Local MariaDB/MySQL serveren startes om. For å muliggjøre ekstern aksess til andre MariaDB/MySQL servere registrert i Plesk, endre deres konfigurasjon manuelt.',
    'database-server-create.authentication' => 'Godkjenning',
    'database-server-create.authenticationAddDescription' => 'Angi påloggingsinformasjon for databaseadministratoren som Plesk skal bruke for å få tilgang til databaseserveren. Administratorkontoen med denne påloggingsinformasjonen må finnes på databaseserveren.',
    'database-server-create.authenticationEditDescription' => 'Her kan du endre påloggingsinformasjon for databaseadministratoren som Plesk skal bruke for å få tilgang til databaseserveren. Påloggingsinformasjonen må stemme overens med databaseadministratorens påloggingsinformasjon. For eksempel må du endre påloggingsinformasjonen i Plesk etter at du har endret de på databaseserveren.',
    'database-server-create.authenticationChangeDescription' => 'Her kan du endre påloggingsinformasjon for databaseadministratoren som Plesk skal bruke for å få tilgang til databaseserveren. Hvis du endrer brukernavnet eller passordet under, vil databasens brukerkonto med administrative rettigheter bli oppdatert både på databaseserveren og i Plesk.',
    'database-server-create.adminLogin' => 'Brukernavn',
    'database-server-create.adminPassword' => 'Passord',
    'database-server-create.createSuccess' => 'Databaseserveren er opprettet.',
    'database-server-create.createError' => 'Databaseserver ble opprettet med feil: %%error%%',
    'database-server-create.updateSuccess' => 'Databaseserveren ble oppdatert.',
    'database-server-create.updateError' => 'Databaseserver ble oppdatert med feil: %%error%%.',
    'database-server-create.backupSettings' => 'Sikkerhetskopi',
    'database-server-create.backupTempDir' => 'Midlertidig mappe',
    'database-server-create.backupTempDirDescription' => 'Banen til en fysisk mappe på den eksterne serveren der MS SQL-serveren befinner seg. MS SQL-serveren må ha tilgang til denne mappen for å lese og skrive midlertidige sikkerhetskopier. For eksempel, C:\\mappesti',
    'database-server-create.backupNetworkTempDir' => 'Midlertidig nettverksmappe.',
    'database-server-create.backupNetworkTempDirDescription' => 'Banen til nettverksdrevet for den fysiske mappen som er angitt over. Plesk vil få tilgang til den delte mappen for å laste ned og opp sikkerhetskopiene. For eksempel \\\\Servernavn\\Katalogbane',
    'database-server-create.backupNetworkUser' => 'Brukernavn',
    'database-server-create.backupNetworkUserDescription' => 'Brukernavnet til en nettverksbruker opprettet på den eksterne serveren. For eksempel, servernavn\\brukernavn. Brukeren må ha tilgang til den delte mappen som er angitt over.',
    'database-server-create.backupNetworkPassword' => 'Passord',

    'domain.connection-info.title' => 'Tilkoblingsinformasjon',
    'domain.connection-info.systemUserCredentials' => 'Systembrukerbevis',
    'domain.connection-info.systemUserCredentialsHint' => 'Tilgang via FTP er alltid aktivert, tilgang via SSH eller Remote Desktop — bare hvis %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'tillatelse er gitt',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Adgang til SSH eller Remote Desktop er aktivert og du kan ikke administrere statusen.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Tilgang til SSH eller Remote Desktop er deaktivert og du kan ikke administrere tilstanden.',
    'domain.connection-info.ipAddress' => 'IP-adresse',
    'domain.connection-info.username' => 'Brukernavn',
    'domain.connection-info.password' => 'Passord',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Endret systembrukerpassord',
    'domain.connection-info.changePasswordTooltip' => 'Endre passord',
    'domain.connection-info.newPassword' => 'Nytt passord',
    'domain.connection-info.manageAccess' => 'Administrer tilgang',
    'domain.connection-info.additionalFtpAccounts' => 'Ekstra FTP-kontoer',
    'domain.connection-info.database' => 'Database',
    'domain.connection-info.databaseHint' => '1 av %%number%% databaser som tilhører abonnementet.',
    'domain.connection-info.databaseNotCreatedHint' => 'Database ikke opprettet.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL-server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Vert',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Databasenavn',
    'domain.connection-info.addDatabase' => 'Legg til database',
    'domain.connection-info.manageDatabases' => 'Administrer databaser',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Endring i databasebrukerpassord',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Ikke glem å oppdatere passordet i konfigurasjonsfilene i applikasjonen etter at du har endret det her.',
    'domain.connection-info.buttonSave' => 'Lagre',
    'domain.connection-info.buttonSaving' => 'Lagrer ...',
    'domain.connection-info.buttonCancel' => 'Avbryt',

    'domain.move.title' => 'Flytt domenet %%name%%',
    'domain.move.hint' => 'Domenet kommer til å bli flyttet til et nytt abonnement med dets innhold, konfigurasjonsfiler, loggfiler og APS-applikasjoner.',
    'domain.move.hintMain' => 'Domenet kommer til å bli flyttet til et nytt abonnement med dets innhold, konfigurasjonsfiler, loggfiler, databaser, databasebrukere, ekstra FTP-brukere, skjemalagte oppgaver, smb-brukere og APS-applikasjoner.',
    'domain.move.hintSubdomains' => 'Underdomenet/underdomenene %%subdomains%% kommer til å bli flyttet sammen med det overordnede domenet.',
    'domain.move.hintAliases' => 'Domenealiaset/-aliasene %%aliases%% kommer til å bli flyttet sammen med det overordnede domenet.',
    'domain.move.hintSubdomainsAndAliases' => 'Underdomenet/underdomenene %%subdomains%% og domenealiaset/-aliasene %%aliases%% kommer til å bli flyttet sammen med det overordnede domenet.',
    'domain.move.labelDatabases' => 'Etter å ha flyttet domenet, åpne fliken "Databases" for å flytte assosierte databaser.',
    'domain.move.hintDatabases' => 'Om nødvendig, flytt databasene separat.',

    'domain.move.Form.submitButton' => 'Flytt',
    'domain.move.Form.cancelButton' => 'Avbryt',

    'domain.move.selectTarget' => 'Tilgjengelige abonnementer',
    'domain.move.nothingFound' => 'Ingenting funnet',
    'domain.move.targetIsRequred' => 'Velg det abonnementet domenet skal flyttes over til.',
    'domain.move.selectNewSubscription' => 'Opprett et nytt abonnement',
    'domain.move.ipv4Address' => 'IPv4-adresse',
    'domain.move.ipv4AddressHint' => 'IP-adressen som nettstedet hostes på er en nettverksadresse for nettstedets virtuelle host.',
    'domain.move.ipv6Address' => 'IPv6 adresse',
    'domain.move.ipv6AddressHint' => 'IP-adressen som nettstedet hostes på er en nettverksadresse for nettstedets virtuelle host.',
    'domain.move.ipAddressIsNotSelected' => 'Minst en IP adresse må velges.',
    'domain.move.username' => 'Brukernavn',
    'domain.move.usernameHint' => 'Systembrukerkontoen assosiert med nettområdet. Benyttet for å aksessere de vertsbaserte filene via FTP og SSH.',
    'domain.move.usernameIsRequred' => 'Du må angi et brukernavn.',
    'domain.move.password' => 'Passord',
    'domain.move.passwordIsRequred' => 'Du må angi et passord.',
    'domain.move.noAvailableSubscriptions' => 'Ingen tilgjengelige abonnementer',
    'domain.move.noWebHosting' => 'Det vil ikke skapes noen systembruker nå fordi domenet ikke har noen vertsfunksjonalitet.',

    'domain.rename.title' => 'Endre domenenavn',
    'domain.rename.titleAlias' => 'Endre domenealias',
    'domain.rename.hint' => 'Du endrer nå domenenavnet %%domainName%%',
    'domain.rename.hintAlias' => 'Du endrer nå domenealiaset %%domainName%%',
    'domain.rename.name' => 'Nytt domenenavn',
    'domain.rename.nameAlias' => 'Nytt domenealias',
    'domain.rename.domainNameIsRequired' => 'Feltet som kreves, er tomt. Du må angi en verdi.',
    'domain.rename.submitButton' => 'Endre',
    'domain.rename.submitButtonProgress' => 'Endrer',
    'domain.rename.successMessage' => 'Domenenavnet %%oldName%% ble endret til %%newName%%.',
    'domain.rename.successMessageAlias' => 'Domenealiaset %%oldName%% ble endret til %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Avbryt',

    'domain.outgoing-messages.hint' => 'Her kan du endre grensen på antall utgående meldinger for dette domenet. Det vil ikke være mulig å sende flere meldinger enn den angitte grensen.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Standard (%%domainOutgoingMessages%% meldinger pr time)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'meldinger pr time',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Grense for utgående meldinger',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Egendefinert verdi for dette domenet',

    'domain.tech-domain-name.title' => 'Velg domenenavn',
    'domain.tech-domain-name.techDomainTitle' => 'Midlertidig domenenavn',
    'domain.tech-domain-name.customDomainTitle' => 'Registrert domenenavn',
    'domain.tech-domain-name.techDomainText' => 'Jeg har ikke et registrert domenenavn ennå',
    'domain.tech-domain-name.customDomainText' => 'Jeg har allerede et registrert domenenavn',
    'domain.tech-domain-name.techDomain' => 'Ditt midlertidige domenenavn',
    'domain.tech-domain-name.customDomain' => 'Registrert domenenavn',
    'domain.tech-domain-name.domainName' => 'Domenenavn',
    'domain.tech-domain-name.techDomainDesc' => 'Midlertidige domenenavn brukes for tilgang til nettstedet ditt før du har registrert og kjøpt et ordentlig domenenavn. Midlertidige domenenavn er gratis, med følgende betingelser:',
    'domain.tech-domain-name.techDomainRandom' => 'Navnene genereres tilfeldig',
    'domain.tech-domain-name.techDomainDns' => 'De hostes i .plesk.page DNS-sonen',
    'domain.tech-domain-name.techDomainSwitch' => 'Du kan bytte til et registrert domenenavn når som helst, ved å gå til domeneinnstillinger og endre domenenavnet.',
    'domain.tech-domain-name.error' => 'Det oppstod en uventet feil.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Du må velge IP-adresse.',
    'domain.tech-domain-name.generating' => 'Genererer …',

    'get-password.label' => 'Tilbakestill passord',
    'get-password.text' => 'Skriv inn e-postadressen din, eller brukernavnet registrert i Plesk, så sender vi deg en e-post for å tilbakestille passordet.',
    'get-password.emailLabel' => 'E-postadresse',
    'get-password.loginLabel' => 'Brukernavn',
    'get-password.send' => 'Send',
    'get-password.cancel' => 'Avbryt',
    'get-password.errorInvalidEmail' => 'E-postadressen ble ikke gjenkjent. Kontroller på nytt og prøv igjen.',
    'get-password.messageSend' => "E-posten for å tilbakestille passordet ble sendt til den tilknyttede e-postadressen.\nHvis e-posten ikke kommer fram, bes du kontakte Plesk-administratoren din.",

    'iis-settings.formGeneralHint' => 'Her du kan angi innstillinger for IIS webserver for ditt nettsted ved å endre standardverdiene. Brukerdefinert IIS-konfigurasjon er nyttig, for eksempel når du ønsker å bruke en ny type indeksfiler på nettstedet ditt eller for å knytte en bestemt MIME-type til bestemte filtyper. Standardverdiene defineres av hostingleverandøren din.',
    'iis-settings.formGeneralHint_powerUser' => 'Her du kan angi innstillinger for IIS webserver for dette nettstedet. Brukerdefinert IIS-konfigurasjon er nyttig, for eksempel når du ønsker å bruke en ny type indeksfiler på nettstedet ditt eller for å knytte en bestemt MIME-type til bestemte filtyper. Standardverdier betyr at IIS vil bruke de tilsvarende direktivene fra standardkonfigurasjonen.',
    'iis-settings.virtualDirectoryLoadError' => 'Kan ikke hente egenskaper for oppgitt virtuell mappe : %%errorMessage%%',
    'iis-settings.general' => 'Vanlige innstillinger',
    'iis-settings.example' => "For eksempel:\n%%example%%",
    'iis-settings.settingOn' => 'Aktivert',
    'iis-settings.settingOff' => 'Av (standard)',
    'iis-settings.settingDefault' => 'Standard',
    'iis-settings.settingCustom' => 'Angi egendefinert verdi',
    'iis-settings.mimeTypes' => 'MIME-typer',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'MIME-typer assosierer filutvidelser med filtyper. Brukes vanligvis for å opprette en egendefinert filtutvidelse for vanlige filtyper.',
    'iis-settings.documents' => 'Standarddokumenter',
    'iis-settings.documentsOff' => 'Deaktivert',
    'iis-settings.documentsCustom' => 'Angi verdier',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Hvis nettlesere ikke oppgir navnet på et dokument på nettstedet, ser IIS etter spesifiserte standarddokumenter og viser første funn. Hvis du ikke spesifiserer standarddokumenter, men slår på mappevisning, vises mappelisten i nettleseren istedenfor hovedsiden.',
    'iis-settings.expires' => 'Utløper',
    'iis-settings.expiresFullDescription' => 'Webserveren vil legge til “Expires” (Utløper) -meldingshoder til nettsider. Tidsstemplet for utløp fåes ved å addere tidsmengden spesifisert ovenfor til det tidspunktet hvor en nettside ble ønsket.',
    'iis-settings.expiresUnitDays' => 'dager',
    'iis-settings.expiresUnitHours' => 'timer',
    'iis-settings.expiresUnitMinutes' => 'minutter',
    'iis-settings.expiresUnitSeconds' => 'sekunder',
    'iis-settings.headers' => 'Flere meldingshoder',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Nettserveren legger til de angitte HTTP-svaroverskriftene.',
    'iis-settings.directoryBrowsing' => 'Mappevisning',
    'iis-settings.directoryBrowsingDescription' => 'Tillat brukere å se områdets mappeliste i nettleseren, for eksempel når standard indekssiden ikke er tilgjengelig.',
    'iis-settings.securityTabDirectory' => 'Sikkerhetsinnstillinger for mappe',
    'iis-settings.allowAnonymous' => 'Anonym godkjenning',
    'iis-settings.allowAnonymousDescription' => 'Anonym godkjenning lar brukere gå inn på offentlig innhold på nettstedet ditt. Passordbeskyttet innhold på ditt område, samt innhold som er beskyttet på filsystem-nivå, vil ikke være tilgjengelig for anonyme brukere.',
    'iis-settings.allowWindows' => 'Windows-godkjenning',
    'iis-settings.allowWindowsDescription' => 'Windows-godkjenning (tidligere kalt NTLM) beskytter innhold på nettstedet ditt på filsystemnivå.',
    'iis-settings.requireSsl' => 'Krever SSL/TLS',
    'iis-settings.requireSslDescription' => 'Hvis du har aktivert SSL/TLS støtte for ditt område, vil dette alternativet tvinge webklienter (nettlesere) til å bare bruke sikker HTTPS-tilkobling.',
    'iis-settings.securityTabIpDeny' => 'Innstillinger for tilgangsbegrensninger',
    'iis-settings.deny' => 'Nekte tilgang til nettstedet',
    'iis-settings.denyOff' => 'Standard',
    'iis-settings.denyCustom' => 'Angi egendefinert verdi',
    'iis-settings.allow' => 'Utelater',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDe angitte vertene og nettverkene er nektet tilgang til området. Benytt '*' for å avvise alle forbindelser.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nDe angitte vertene og nettverkene har tilgang til området.",
    'iis-settings.dynamicIpSecurity' => 'Hindre DoS-angrep ved hjelp av IIS dynamisk IP-begrensning',
    'iis-settings.isDenyByConcurrentRequests' => 'Nekt IP-adresser basert på antall samtidige forespørsler fra en unik IP-adresse',
    'iis-settings.maxConcurrentRequests' => 'Maksimalt antall samtidige forespørsler',
    'iis-settings.isDenyByRequestRate' => 'Nekt IP-adresser basert på antall forespørsler over en tidsperiode',
    'iis-settings.maxRequests' => 'Maksimalt antall forespørsler',
    'iis-settings.requestInterval' => 'Tidsperiode (i millisekunder)',

    'ip-addresses-selector.ipAddress' => 'IP-adresse',
    'ip-addresses-selector.ipv4Address' => 'IPv4-adresse',
    'ip-addresses-selector.ipv4AddressHint' => "IP-adressen som nettstedet hostes på er en nettverksadresse for nettstedets virtuelle host.",
    'ip-addresses-selector.ipv6Address' => 'IPv6 adresse',
    'ip-addresses-selector.ipv6AddressHint' => "IP-adressen som nettstedet hostes på er en nettverksadresse for nettstedets virtuelle host.",
    'ip-addresses-selector.noIpAddressHint' => 'Ingen',
    'ip-addresses-selector.shared' => 'delt',
    'ip-addresses-selector.exclusive' => 'dedikert',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP-serveren støtter ikke Ipv6. Du må tildele minst én Ipv4-adresse, ellers vil ikke brukeren kunne fortsette å laste opp filer til serveren via FTP',

    'license-key-revert.description' => 'Lisensnøkkel med følgende egenskaper vil bli gjenopprettet:',
    'license-key-revert.submitButton' => 'Rull tilbake',

    'license-key-upload.description' => 'Installer lisensnøkkelen din ved å angi en aktiveringskode.',
    'license-key-upload.descriptionWithFileUpload' => 'Installer lisensnøkkelen din enten ved å angi aktiveringskoden eller ved å laste opp en lisensnøkkelfil.',
    'license-key-upload.type' => 'Velg en av følgende:',
    'license-key-upload.code' => 'Skriv inn en aktiveringskode',
    'license-key-upload.codeDescription' => 'Lim inn aktiveringskoden du har mottatt.',
    'license-key-upload.file' => 'Last opp en lisensnøkkelfil',
    'license-key-upload.fileDescription' => 'Angi banen til filen som inneholder lisensnøkkelen.',
    'license-key-upload.submitButton' => 'Installer',

    'log-rotation.customLogsDescription' => 'Merk at de brukerdefinerte loggene ikke roteres.',
    'log-rotation.logRotation' => 'Logg rotasjon',
    'log-rotation.logRotationCondition' => 'Logg rotasjonsbetingelse',
    'log-rotation.logRotationBySize' => 'på størrelse',
    'log-rotation.logRotationByTime' => 'Etter klokkeslett',
    'log-rotation.logRotationDaily' => 'Hver dag',
    'log-rotation.logRotationWeekly' => 'Ukentlig',
    'log-rotation.logRotationMonthly' => 'Månedlig',
    'log-rotation.logRotationSizeDescription' => 'Verdien for størrelse må være mellom %%min%% og %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Maksimalt antall loggfiler',
    'log-rotation.compress' => 'Komprimer loggfiler',
    'log-rotation.sendLogToEmail' => 'Etter Plesk henter data fra loggfiler for web- og FTP-server, send logfilene med e-post til denne adressen',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'Perioden kan ikke være større enn den generelle servergrensen på %%max%%.',

    'login.loginLabel' => 'Brukernavn',
    'login.passwdLabel' => 'Passord',
    'login.localeLabel' => 'Grensesnitt språk',
    'login.defaultLocale' => 'Standard',
    'login.loginButtonLabel' => 'Logg på',
    'login.enterUsername' => 'Angi brukernavn.',
    'login.enterPassword' => 'Angi passord.',
    'login.whatUsernamePassword' => 'Hvilket brukernavn og passord skal du bruke?',
    'login.forgotPasswordLabel' => 'Glemt passordet?',
    'login.cookies' => 'Retningslinjer for informasjonskapsler i Plesk',
    'login.avoidSSLWarningsMsg' => 'Bruk %%link%% for å unngå SSL-advarsler ved logging i Plesk',
    'login.digitalOceanMsg' => 'Er du ny på Plesk på DigitalOcean? Bruk "root" og passordet du anga da du opprettet denne dråpen for å logge inn. %%link%%',
    'login.amazonLightsailMsg' => 'Er du ny på Plesk på Lightsail? Logg inn på Plesk ved å gå til serveren via SSH og bruke kommandoen "plesk login". %%link%%',
    'login.readGuide' => 'Les den fullstendige veiledningen.',
    'login.mobileApplicationMessage' => 'For en bedre opplevelse, anbefaler vi at du installerer applikasjonen %%name%%.',
    'login.mobileApplicationInstall' => 'Installer nå',
    'login.mobileApplicationHide' => 'Nei takk',

    'force-reset-password.saveButton' => 'Lagre',
    'force-reset-password.title' => 'Endre passord',
    'force-reset-password.passwordLabel' => 'Nytt passord',

    'panel-access.title' => 'Egendefiner Plesk-nettadressen',
    'panel-access.hint' => 'Velg egendefinerte nettadresser for å logge på Plesk. Det vil fortsatt være mulig å logge på Plesk gjennom porten %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Ytterligere detaljer',
    'panel-access.proxyEnabled' => 'Alle domener eller under domener som er angitt for serverens IP-adresse men ikke brukes til hosting',
    'panel-access.proxyDomain' => 'Det spesifiserte domenet eller underdomenet som er angitt for serverens IP-adresse men ikke brukes til hosting',
    'panel-access.proxyDisabled' => 'Ingen egendefinerte nettadresser. Kun https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Lagre',
    'panel-access.Form.cancelButton' => 'Avbryt',

    'panel-access.domainNameIsRequired' => 'Du må angi et domenenavn.',
    'panel-access.successMessage' => 'Den valgte påloggingsmåten ble brukt.',
    'panel-access.notSupported' => 'Plesk støtter ikke den valgte påloggingsmåten.',
    'panel-access.notViaDomainName' => 'For å bruke denne måten å logge inn på må du elge det første alternativet ("Alle domener og underdomener ..."), logge på Plesk via https://%%domainName%% og deretter velge det andre alternativet.',
    'panel-access.notViaPort' => 'For å bruke denne påloggingsmåten må du logge på Plesk via https://<server-IP-or-hostname>:%%httpsPort%% først.',

    'php-settings.performance' => 'Innstillinger for ytelse og sikkerhet',
    'php-settings.settings' => 'Vanlige innstillinger',
    'php-settings.fastCgiSettings' => 'FastCGI-innstillinger',
    'php-settings.fpmSettings' => 'PHP-FPM-innstillinger',
    'php-settings.enableFastcgi' => 'Aktiver FastCGI-innstillinger',
    'php-settings.plainTextEditing' => 'Ytterligere direktiver',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Du kan definere valgfrie PHP parametere ved å skrive dem inn i feltet nedenfor. Direktivene kommer til å bli inkludert i PHP konfigurasjonen. Bruk den samme syntaksen som du ville brukt i php.ini. For å eksempelvis laste inn mSQL utvidelsen automatisk, legg til linjen: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Hvis du ikke kan finne bestemte PHP parametere, legger du dem til i feltet under. Disse ekstra direktivene vil slås sammen med direktivene for hovedtjenesteplanen. Bruk samme syntaks som du bruker for php.ini. Hvis du for eksempel vil laste mSQL-utvidelsen automatisk, legger du til linjen: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Du kan definere valgfrie PHP parametere ved å skrive dem inn i feltet nedenfor. Direktivene kommer til å bli inkludert i PHP konfigurasjonen. Bruk den samme syntaksen som du ville brukt i php.ini. For å eksempelvis laste inn mSQL utvidelsen automatisk, legg til linjen: extension=msql.so. For å skreddersy innstillingene for PHP-FPM utvalget, legg til [php-fpm-pool-settings] separatoren og skriv inn de ønskede innstillingene nedenfor.',
    'php-settings.additionalConfigurationDirectives' => 'Ytterligere konfigurasjonsdirektiver',
    'php-settings.defaultValue' => 'Standard',
    'php-settings.predefinedValue' => 'Velg verdi',
    'php-settings.customValue' => 'Angi egendefinert verdi',
    'php-settings.phpSettingDescription_memory_limit' => 'Den maksimale mengde minne i bytes et script tillates å allokere.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Den maksimale tiden i sekunder et script tillates å kjøre før det avbrytes.',
    'php-settings.phpSettingDescription_max_input_time' => 'Den maksimale tiden i sekunder et script tillates å analysere inngangsdata før det avbrytes.',
    'php-settings.phpSettingDescription_post_max_size' => 'Maksimal datastørrelse i bytes for data som kan bli lagt inn med POST metoden. Skulle typisk være større enn upload_max_filesize og mindre enn memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Maksimal størrelse i byte på en opplastet fil.',
    'php-settings.phpSettingDescription_safe_mode' => 'PHP sikker modus setter et antall begrensninger på kjøring av skript, hovedsakelig av sikkerhetsårsaker.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Du får tilgang til filene i den angitte katalogen ved hjelp av PHP-skript når safe_mode-direktivet er aktivt. Mappen må også være i include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Programmene i den angitte katalogen kan kjøres ved hjelp av PHP-skript når safe_mode-direktivet er aktivt.',
    'php-settings.phpSettingDescription_include_path' => 'Listen over mapper hvor skript søker etter filer (lik systemets PATH-variabel). For å skille mapper, bruk kolon (:) på Linux og semikolon (;) i Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'Katalog for lagring av PHP-øktfiler.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Ekstra parametere for mail() funksjonen.',
    'php-settings.phpSettingDescription_register_globals' => 'Registrer innholdet i EGPCS-variablene (Environment, GET, POST, Cookie, Server) som globale variabler.',
    'php-settings.phpSettingDescription_open_basedir' => 'Du får tilgang til filene i de angitte katalogene ved hjelp av PHP-skript. For å skille mapper, bruk kolon (:) på Linux og semikolon (;) i Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'Feilrapporterings nivå.',
    'php-settings.phpSettingDescription_display_errors' => 'Bestemmer hvilke feil som skal vises som en del av utdataene.',
    'php-settings.phpSettingDescription_log_errors' => 'Aktiver logging av PHP-feil.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Tillater PHP fil funksjoner å finne frem data fra eksterne plasser over FTP eller HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Tillater opplasting av filer over HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Tillater kortformen () av PHP\'s open tag.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Setter magic_quotes tilstand for GPC (Get/Post/Cookie) operasjoner. Når magic_quotes er på, er alle enkelt anførselstegn, dobbelt anførselstegn, omvendt skråstrek, and NULL spesialtegn automatisk mellom skilletegn med omvendt skråstrek.',
    'php-settings.phpSettingDescription_disable_functions' => 'Dette direktivet tillater deg å deaktivere visse funksjoner. Det utføres på en kommaseparert liste av funksjonsnavn',
    'php-settings.phpSupport' => 'støtte for PHP',
    'php-settings.phpRunAs' => 'kjør PHP som',
    'php-settings.phpVersion' => 'PHP-versjon',
    'php-settings.phpHandlerOutdated' => '(Utdatert)',
    'php-settings.phpHandlerDeprecated' => '(Avskrevet)',
    'php-settings.phpServedByApache' => 'betjent av Apache',
    'php-settings.phpServedByNginx' => 'betjent av ngnix',
    'php-settings.phpSettingsPhpVersion' => 'Din PHP versjn er %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP er slått av.',
    'php-settings.phpHandlerTypeHint' => 'Under finner du detaljer om nettstedets PHP-konfigurasjon. Du kan endre PHP-konfigurasjonen hvis hosting-leverandøren gir det tillatelse til dette.',
    'php-settings.fpmDedicatedHandlerHint' => 'Bruk av dette behandlingsprogrammet øker nettstedets stabilitet, men krever også ekstra minneforbruk.',
    'php-settings.phpHandlerChangeHint' => 'Du har endret innstillinger for PHP-behandlingsprogram. Hvis du lagrer endringene, kan PHP-skript på nettstedet ditt slutte å fungere i %%interval%% sekunder mens serveren konfigureres.',
    'php-settings.phpHandlerOutdatedHint' => 'For å sjekke om den nye PHP-versjonen er tilgjengelig, følg %%link%% og finn kategorien «Webhosting» for produktkomponentene.',
    'php-settings.phpHandlerOutdatedHintLink' => 'åpne Plesk Installer',
    'php-settings.phpHandlerTypeHelpLink' => 'Lær å velge de mest passende PHP-innstillingene',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'PHP støtte kan ikke aktiveres fordi den aktuelle hostingkonfigurasjonen ikke inkluderer noen PHP versjoner tilgjengelige for dette domenet.',
    'php-settings.phpHandlersNotAvailableHint' => 'PHP støtte kan ikke aktiveres fordi den aktuelle Plesk-konfigurasjonen ikke inkluderer noen PHP versjoner tilgjengelige.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Finn ut hvordan andre PHP versjoner aktiveres.',
    'php-settings.phpSupportEditable' => '(PHP-versjon %%version%%, kjør PHP som %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(versjon: %%version%%; behandlingsprogram: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(ikke registrert) %%link%%',
    'php-settings.showPhpInfo' => 'Vis side for phpinfo()',
    'php-settings.phpSettingsFormError' => 'Kan ikke hente PHP-innstillinger fordi ønskede data er borte.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Kan ikke innhente PHP-innstillinger fordi denne PHP-versjonen ikke er installert. Installer den valgte PHP-versjonen eller velg en annen for domenet for å fortsette.',
    'php-settings.showPhpInfoTitle' => 'Vis phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Enkelte av PHP-innstillingene dine ble endret, men endringene er ikke lagret enda. For å se de nye verdiene på siden phpinfo() må du bruke endringene først. Ellers vil du se de gjeldende verdiene.',
    'php-settings.showPhpInfoButton' => 'Vis phpinfo()',
    'php-settings.onState' => 'På',
    'php-settings.offState' => 'Av',

    'pmm.agent.sync.check' => 'Migration & Transfer Agent sjekker om oppdateringer finnes.',
    'pmm.agent.sync.updating' => 'Synkronisering og nedlastning av Migration & Transfer Agent',
    'pmm.agent.sync.done' => 'Migration & Transfer Agent ble vellykket synkronisert.',
    'pmm.agent.sync.downloadLink' => 'Klikk for å laste ned Migration & Transfer Agent-filen som skal installeres på kildeverten før migreringen startes.',
    'pmm.agent.sync.error' => 'Migration & Transfer Agent feilet i å hente oppdateringer. Prøv på nytt senere.',

    'restore-password.title' => 'Endre passord',
    'restore-password.passwordLabel' => 'Nytt passord',
    'restore-password.buttonRestore' => 'Lagre',
    'restore-password.buttonCancel' => 'Avbryt',
    'restore-password.isEmpty' => 'Det obligatoriske feltet er tomt. Du må angi en verdi.',
    'restore-password.errorInvalidSecret' => 'Ugyldig hemmelig kode',
    'restore-password.errorNotFoundSecret' => 'Vennligst be om en ny hemmelig kode',
    'restore-password.restoreSuccess' => 'Ditt passord ble oppdatert. Bruk det nye passordet til å logge inn på Plesk eller til din a-post adresse.',

    'scheduler.settings.schedulerNotification' => 'Tidsplanlegger melding',
    'scheduler.settings.notificationOff' => "Slått av",
    'scheduler.settings.notificationDefault' => "Send til standard e-post (%%email%%)",
    'scheduler.settings.notificationCustom' => "Send til den e-post jeg har angitt",
    'scheduler.settings.crontabSecureShell' => 'Crontab-skall',
    'scheduler.settings.schedulerTimezoneSelector' => 'Vis oppgaveplan med tidssone',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Bruk systemets standard tidssone (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Bruk systemets standard tidssone',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Bruk den tidssonen jeg angir',

    'scheduler.task.active' => 'Aktiv',
    'scheduler.task.subscription' => 'Abonnement',
    'scheduler.task.subscription_powerUser' => 'Webplass',
    'scheduler.task.type' => 'Oppgavetype',
    'scheduler.task.typeCommand' => 'Kjør en kommando',
    'scheduler.task.typeUrl' => 'Hent en URL',
    'scheduler.task.typeScript' => 'Kjør et PHP-skript',
    'scheduler.task.command' => 'Kommando',
    'scheduler.task.arguments' => 'med argumenter',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Angi en absolutt URL, for eksempel, http://example.com. Dersom respons-statuskoden er 2xx eller 3xx, betraktes oppgaven som vellykket utført.',
    'scheduler.task.script' => 'Skriptbane',
    'scheduler.task.scriptRelativePathDescription' => 'Eksempel: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Angi fullstendig bane til skriptet. Eksempel: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Bruk PHP-versjon',
    'scheduler.task.scriptPathPopupTitle' => 'Skriptbane',
    'scheduler.task.run' => 'Kjør',
    'scheduler.task.on' => 'på',
    'scheduler.task.at' => 'kl.',
    'scheduler.task.sysUser' => 'Systembruker',
    'scheduler.task.hourly' => 'Hver time',
    'scheduler.task.daily' => 'Hver dag',
    'scheduler.task.weekly' => 'Ukentlig',
    'scheduler.task.monthly' => 'Månedlig',
    'scheduler.task.yearly' => 'Årlig',
    'scheduler.task.cronStyle' => 'Cron-stil',
    'scheduler.task.cronStyleError' => 'Ugyldig crontab-syntaks.',
    'scheduler.task.cronStyleErrorWin' => 'Skråstrek (/) og bindestrek (-) er ikke tillatt.',
    'scheduler.task.cronStyleHint' => 'Bruk UNIX crontab-format &quot;minutt time dato måned ukedag&quot;. Eksempel "0 22 * * 1-5". Plesk vil bruke standard tidssone for systemet til å kjøre oppgaven.',
    'scheduler.task.cronStyleWinHint' => 'Bruk formatet &quot;minutt time dato måned ukedag&quot;, for eksempel "0 22 * * 6,7". Plesk vil bruke standard tidssone for systemet til å kjøre oppgaven.',
    'scheduler.task.notify' => 'Varsle',
    'scheduler.task.notifyIgnore' => 'Ikke varsle',
    'scheduler.task.notifyErrors' => 'Bare feil',
    'scheduler.task.notifyAlways' => 'Hver gang',
    'scheduler.task.notifyErrorsHint' => 'Varslinger inneholder standard feilstrøm for kommandoen. Hvis strømmen er tom, vil ingen varsling sendes.',
    'scheduler.task.notifyErrorsHintWin' => 'Varslinger inneholder utdata for kommando og sendes bare hvis utgangskoden er ikke-null.',
    'scheduler.task.notifyAlwaysHint' => 'Varslinger inneholder utdata for kommando. Hvis utdata er tomt, vil ingen varsling sendes.',
    'scheduler.task.notifyAlwaysHintWin' => 'Varslinger inneholder utdata for kommando og sendes uansett utgangskode.',
    'scheduler.task.emailType' => 'Send varslinger til',
    'scheduler.task.emailTypeDefault' => 'Standard systembruker (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Eier av abonnement (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrator (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Andre brukere',
    'scheduler.task.emailTypeCustomDescription' => 'Du kan angi flere adresser, skilt av komma.',
    'scheduler.task.minute' => 'minutt',
    'scheduler.task.shortMinute' => 'Min',
    'scheduler.task.dayOfMonth' => 'dag',
    'scheduler.task.description' => 'Beskrivelse',
    'scheduler.task.scheduleTimezoneHint' => 'Tidssone for kjøring av oppgaven er %%timezone%%',
    'scheduler.task.runTaskNow' => 'Kjør nå',
    'scheduler.task.runningTask' => 'Kjører oppgaven &quot;%%task%%&quot;...',

    'server-settings.submitDone' => "Innstillingene for serveren ble endret.",
    'server-settings.systemSettings' => "Systeminnstillinger",
    'server-settings.fullHostName' => "Fullstendig vertsnavn",
    'server-settings.trafficStatisticsPeriod' => "Behold web og trafikk statistikk for",
    'server-settings.trafficStatisticsPeriodUnit' => "måned",
    'server-settings.diskSpaceUsageCalculation' => "Inkluder i beregningen av diskforbruk",
    'server-settings.includeLogs' => "loggfiler",
    'server-settings.includeLogsAndStats' => "loggfiler og statistikkrapporter",
    'server-settings.includeMysqlDatabases' => "MariaDB/MySQL databaser",
    'server-settings.includeMssqlDatabases' => "Microsoft SQL databaser",
    'server-settings.includePgsqlDatabases' => "PostgreSQL-databaser",
    'server-settings.includeDatabases' => "databaser",
    'server-settings.includeRemoteDatabases' => "eksterne databaser",
    'server-settings.includeMailboxes' => "postbokser",
    'server-settings.includeMailLists' => "adresselister",
    'server-settings.includeDomainDumps' => "sikkerhetskopier av domene",
    'server-settings.includeAdminDumps' => "sikkerhetskopifiler opprettet av administratoren",
    'server-settings.calculatingDiskSpaceUsage' => "Når forbruk av diskplass beregnes, tell opp",
    'server-settings.typeByte' => "Filstørrelse",
    'server-settings.typeBlock' => "diskplass som er brukt",
    'server-settings.trafficCalculation' => "Inkluder i beregningen av trafikk",
    'server-settings.inboundAndOutbound' => "innkommende og utgående trafikk",
    'server-settings.onlyInbound' => "Kun innkommende trafikk",
    'server-settings.onlyOutbound' => "Kun utgående trafikk",
    'server-settings.forbidCreateDnsSubZone' => "Forby brukere å opprette DNS undersoner i andre brukeres DNS supersoner",
    'server-settings.webDeployIncludePassword' => "Inkluder brukerens passord i filen med Web Deploys publiseringsinnstillinger.",
    'server-settings.forbidSysUserRename' => "Kundene kan endre navnet på systembrukerne sine",
    'server-settings.alwaysAllowSysUserRename' => "alltid",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "bare hvis rettigheten Administrasjon av hosting er gitt",
    'server-settings.neverAllowSysUserRename' => "aldri",
    'server-settings.forbidSubscriptionRename' => "Forby kunder og videreforhandlere å endre hoveddomenenavnet sitt",
    'server-settings.preferredDomain' => "Foretrukket domene for nettsteder",
    'server-settings.preferredDomainNone' => "ingen",
    'server-settings.preferredDomainToLanding' => "domene.tld",
    'server-settings.preferredDomainToWww' => "www.domene.tld",
    'server-settings.ipLogging' => "IP-logging",
    'server-settings.disableIpLogging' => "Deaktiver IP-logging i IIS, FTP og e-postlogger",
    'server-settings.disableIpLoggingDescription' => "Når dette er valgt, vil IIS og MailEnable ikke lenger føre opp IP-adresser i loggfiler",
    'server-settings.anonymizeIps' => "Anonymiser IP-adresser",
    'server-settings.logrotateAnonymizeIps' => "Anonymiser IP-adresser under loggrotasjon og hent inn nettstatistikk",
    'server-settings.logrotateAnonymizeIpsDescription' => 'Skript for postrotasjon erstatter den siste oktetten av IPv4-adresser i roterte loggfiler med "0" før arkivering. I IPv6-adresser, erstatter skriptet den siste delen av adressen (to oktetter etter det siste kolonet) med "0000" (på fullstendig format) eller "0" (på kortformat).',
    'server-settings.logrotate' => "Loggrotasjon",
    'server-settings.logrotateForce' => "Tving daglig loggrotasjon for alle domener",
    'server-settings.allowToStoreLogs' => "Tillat lagring av nettstedslogger for",
    'server-settings.logrotatePeriod' => "dager",
    'server-settings.configureUpdatePolicy' => "Konfigurer policy for oppdatering",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Serverens standardverdi (%%default%% meldinger pr time)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Egendefinert verdi for planen',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Egendefinert verdi for abonnementet',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'meldinger',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Utgående meldinger fra en postboks (pr time)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Utgående meldinger fra et domene (pr time)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Utgående meldinger fra et abonnement (pr time)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Prosentandel av meldinger over timegrensen som skal sendes i løpet av den neste timen',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Hvis grensen for utgående meldinger fra en postboks pr time er 100 og prosentandelen er 10 %, har brukeren lov til å sende 110 meldinger pr time. 100 meldinger vil bli sendt i løpet av en time, og 10 meldinger vil bli satt i e-postkøen og planlegges sendt i løpet av den neste timen.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Retningslinjer for bruk av Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Standard serverinnstillinger (Sendmail er tillatt)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Standard serverinnstillinger (Sendmail er ikke tillatt)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Egendefinerte innstillinger for planen',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Egendefinerte innstillinger for abonnementet',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Tillat bruk av Sendmail for skript og brukere på dette abonnementet',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Skript og brukere vil kunne sende e-postmeldinger (på vegne av abonnementets systembruker) ved å bruke Sendmail, selv om grensene for en postboks og et domene er overskredet. Maksimalt antall meldinger som kan sendes ved hjelp av Sendmail vil bli definert av grensen for hele abonnementet.',

    'setup.hint' => 'Velkommen til Plesk, et kontrollpanel som hjelper deg å administrere serveren. Plesk leverer et miljø som er klart for koding og gir deg en rekke kraftige utvidelser for å hjelpe deg til å utvikle nettsteder og apper. Fullfør installasjonsprosessen for å begynne å bruke Plesk (det vil bare ta ett minutt).',
    'setup.contactInfoSection' => 'Kontaktinformasjon',
    'setup.contactInfoSectionHint' => 'Angi navn og e-postadresse for å identifisere deg som eieren av serveren og for å motta viktige varsler angående serveren. Hvis du er serveradministrator for en bedrift, ikke legg inn personlig navn eller e-postadresse. Bruk jobbtittel og bedriftens e-postadresse i stedet for å unngå overtredelse av personvernforordningen.',
    'setup.contactName' => 'Navn på kundekontakt',
    'setup.emptyContactName' => 'Vennligst angi et kontaktnavn.',
    'setup.contactNameTooLong' => 'Kontaktnavnet er for langt (maksimum %max% tegn er tillatt).',
    'setup.email' => 'E-post',
    'setup.emptyEmail' => 'Oppgi en e-postadresse.',
    'setup.passwordSection' => 'Passord',
    'setup.passwordSectionHint' => 'Neste gang du logger på Plesk, bruk brukernavnet \'admin\' og passordet som er angitt under.',
    'setup.password' => 'Passord',
    'setup.licenseSection' => 'Lisens',
    'setup.licenseSectionHint' => 'Du må installere en lisens for å kunne starte bruken av Plesk.',
    'setup.licenseType' => 'Velg din lisenstype',
    'setup.licenseTypePaid' => 'Fortsett med en innkjøpt lisens',
    'setup.onlineStoreLink' => 'Nettbutikk',
    'setup.licenseTypeTrial' => 'Fortsett med en testlisens med full funksjonalitet',
    'setup.activationCodeHint' => 'Om du allerede har kjøpt en Plesk lisens, kan du her klistre inn aktiveringskoden du mottok Hvis ikke, kan du kjøpe en ny lisens i vår %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'WebPros personvernerklæring',
    'setup.trialLicenseAgreement' => 'For å utstede en testlisens, vil WebPros International GmbH benytte og behandle den angitte informasjonen i henhold til %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Jeg bekrefter at jeg har lest og godtatt %%link%%',
    'setup.eula' => 'Sluttbrukerlisensavtale (EULA)',
    'setup.invalidEulaAgreementValue' => 'Du må godta lisensavtalen for sluttbrukere',
    'setup.sendButton' => 'Gå inn i Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Tilbakestill adminpassord ved neste innlogging',

    'spam-filter.add.titleBlack' => 'Legg til adresser i sortelisten',
    'spam-filter.add.titleWhite' => 'Legg til adresser i hvitelisten',
    'spam-filter.add.fileDescription' => 'Last opp en tekstfil i UTF-8-koding (for eksempel en *.txt- eller *.csv-fil).',
    'spam-filter.add.listDescription' => 'Formateringsregler: <ul><li>Skill individuelle adresser med komma, semikolon eller linjeskift, mellomrom eller tabulatortegn.</li><li>Ikke bruk annet enn ASCII-tegn til venstre for @-symbolet.</li> li><li>Du kan bruke jokertegn «*» og «?» (for eksempel <nobr>*@domene.com,</nobr> <nobr>bruker?@*.com</nobr>).</li><li>Ikke bruk jokertegn i annet enn ASCII-deler av domenenavn.</li></ul>',
    'spam-filter.add.fromFile' => 'Fra fil',
    'spam-filter.add.fromList' => 'Fra liste',
    'spam-filter.add.success' => 'Adresser ble lagt til',

    'ssl-certificate.add.name' => 'Sertifikatnavn',
    'ssl-certificate.add.longName' => 'Det angitte sertifikatnavnet er for langt (maksimum %max% tegn er tillatt).',
    'ssl-certificate.add.certificateNameUsed' => 'Et sertifikat med navnet %%name%% finnes allerede.',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS-sertifikat ble utstedt. For å få det til å fungere, tilordne sertifikatet for å sikre et domene, e-post eller nettbasert e-post.',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS-sertifikatet ble oppdatert.',
    'ssl-certificate.add.settings' => 'Innstillinger',
    'ssl-certificate.add.settingsHint' => 'Bruk dette skjemaet til å generere et sertifikat, til å kjøpe et sertifikat fra leverandøren din, eller til å generere et selvsignert sertifikat.',
    'ssl-certificate.add.settingsHint2' => 'Forespørselen er en CSR-fil som inneholder informasjon om domenet ditt som du spesifiserte i skjemaet. Du kan sende forespørselen til ønsket sertifikat-autoritet slik at de kan utstede et sertifikat til deg. Du kan deretter laste det opp ved hjelp av et av opplastingsskjemaene nedenfor.',
    'ssl-certificate.add.settingsHint3' => 'Et selvsignert sertifikat er et identitetssertifikat som er signert av oppretteren. Hvis du bruker et slikt sertifikat, betyr det at du selv verifiserer nettstedets\' identitet. Selv om egensignerte sertifikater tillater bruk av SSL/TLS, har de et lavere tillitsnivå, og er ansett som mindre sikre.',
    'ssl-certificate.add.bits' => 'Biter',
    'ssl-certificate.add.country' => 'Land',
    'ssl-certificate.add.state' => 'Delstat/område',
    'ssl-certificate.add.longState' => 'Det angitte navnet på delstaten eller området er for langt.',
    'ssl-certificate.add.city' => 'Sted (by)',
    'ssl-certificate.add.longCity' => 'Det angitte navnet på byen er for langt.',
    'ssl-certificate.add.shortCity' => 'Det angitte navnet på byen er for kort.',
    'ssl-certificate.add.companyName' => 'Organisasjonsnavn (firma)',
    'ssl-certificate.add.longCompanyName' => 'Det angitte navnet på firmaet er for langt.',
    'ssl-certificate.add.companyUnitName' => 'Avdeling eller divisjonsnavn',
    'ssl-certificate.add.longCompanyUnitName' => 'Det angitte navnet på organisasjonsavdelingen er for langt (maksimum %max% tegn er tillatt).',
    'ssl-certificate.add.domainName' => 'Domenenavn',
    'ssl-certificate.add.email' => 'E-post',
    'ssl-certificate.add.request' => 'Forespørsel',
    'ssl-certificate.add.buyCertificate' => 'Kjøp SSL/TLS-sertifikat',
    'ssl-certificate.add.selfSigned' => 'Selvsignert',
    'ssl-certificate.add.invalidCertificateParams' => 'Noen felt er tomme eller inneholder feil verdier. Verdiene skal begrenses til 64 tegn. Hvis du bruker et internasjonalisert domenenavn, pass på at ingen del av domenenavnet mellom punktumene overskrider 63 tegn når det konverteres til ASCII-format. Sjekk feltene:',
    'ssl-certificate.add.unableCreateCsr' => 'Kunne ikke opprette CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Kunne ikke opprette et selvsignert sertifikat: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Kunne ikke angi sertifikatdata: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Kunne ikke lagre sertifikatet i databasen: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Last opp sertifikatfiler',
    'ssl-certificate.add.uploadFilesHint' => 'Bruk dette skjemaet til å laste opp komponentene i et sertifikat som delfiler.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Privat Nøkkel (*.key)",
    'ssl-certificate.add.certificate' => "Sertifikat (*.crt)",
    'ssl-certificate.add.caCertificate' => "CA-sertifikat (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Last opp sertifikat",
    'ssl-certificate.add.fileNotUploaded' => 'Kunne ikke laste opp sertifikatfilen: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Kunne ikke sette den private nøkkelen: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Kan ikke sette sertifikat: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Kan ikke sette CA-sertifikat: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Kunne ikke kontrollere om CA-sertifikatet signerer sertifikatet: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Fjern',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Ønsker du å fjerne CA-sertifikatet?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Kunne ikke slette CA-sertifikat: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'CA-delen av sertifikatet ble fjernet.',
    'ssl-certificate.add.rename' => 'Gi nytt navn',
    'ssl-certificate.add.unableRenameCertificate' => 'Kunne ikke endre navn på sertifikat: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Navnet på sertifikatet ble endret til %%name%%.',
    'ssl-certificate.add.uploadText' => "Last opp sertifikat som tekst",
    'ssl-certificate.add.uploadTextHint' => 'Bruk dette skjemaet til å laste opp komponentene i et sertifikat som tekst. Kopier innholdet av en fil og lim inn i det tilsvarende feltet.',
    'ssl-certificate.add.sendText' => "Last opp sertifikat",
    'ssl-certificate.add.componentIsMissing' => 'Komponenten mangler.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Last opp sertifikatet her',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Hvis du opprettet en forespørsel om sertifikatsignering på denne serveren og mottok sertifikatfilen, kan du laste den opp her. Hvis du ønsker å laste opp et sertifikat og et privat nøkkelpar som er generert på en annen server, eller du vil generere et selvsignert sertifikat, klikk på <b>Legg til SSL/TLS- sertifikat</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Etter å ha lagt et SSL/TLS-sertifikat til et domene, må du aktivere SSL/TLS-support og velge dette sertifikatet i innstillinger for hosting av nettsted: <b>Nettsteder og domener</b>> <b>Hosting-innstillinger</b> for dette domenet> <b>Sikkerhet</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Sertifikat (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Last opp sertifikat',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Kunne ikke laste opp sertifikatfilen.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Ugyldig sertifikatformat.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Kunne ikke finne egnet privat nøkkel for sertifikatet.',

    'ssl-certificate.secure.certificate' => 'Velg sertifikat',
    'ssl-certificate.secure.serverPool' => 'serverutvalg',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Dato",
    'system-time.dateAndTime' => "Dato og tid",
    'system-time.daylight' => "Juster klokken automatisk for sommertid",
    'system-time.dayMonthYear' => "Dag-måned-år",
    'system-time.domainNameOrIp' => "Domenenavn eller IP",
    'system-time.hoursMinutesSeconds' => "Timer:minutter:sekunder",
    'system-time.networkTime' => "Nettverkstid",
    'system-time.submitDone' => "Systemets tidsinnstillinger ble endret.",
    'system-time.synchronizedSystemTime' => "Synkroniser systemtiden",
    'system-time.title' => "Systemdato og Tid",
    'system-time.timezone' => "Tidssone",
    'system-time.time' => "Tid",
    'system-time.updateSystemTime' => "Oppdater system tid",
    'system-time.yourTimezone' => "Din tidssone",

    'web-app-firewall.pageHint' => 'Brannmur for webprogrammer beskytter webprogrammer mot angrep ved å sjekke og filtrere innkomende HTTP-forespørsler etter brukerdefinerte regler.',
    'web-app-firewall.webSitePageHint' => 'Her kan du konfigurere brannmur for webprogram (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Brannmurmodus for webprogram',
    'web-app-firewall.ruleEngineOn' => 'Aktivert',
    'web-app-firewall.ruleEngineOnDescription' => 'Hver innkommende HTTP-forespørsel og relatert respons sjekkes mot et sett med regler. Hvis sjekken er vellykket, vil HTTP-forespørselen bli videresendt til nettstedets innhold. Hvis sjekken mislykkes, vil hendelsen bli logget, et varsel sendes og HTTP-responsen leveres med en feilkode.',
    'web-app-firewall.ruleEngineOff' => 'Av',
    'web-app-firewall.ruleEngineOffDescription' => 'Innkommende HTTP-forespørsler og relatert respons sjekkes ikke.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Bare detektering',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Hver innkommende HTTP-forespørsel og den relaterte responsen sjekkes mot et sett med regler. Hvis sjekken lykkes, sendes HTTP-forespørselen til nettsideinnhold. Hvis sjekken mislykkes, loggføres hendelsen og ModSecurity utfører ingen andre handlinger. Andre tjenester (som Fail2ban) kan fortsatt utføre sine egne handlinger på HTTP-forespørsler som ikke lyktes i sjekken.',
    'web-app-firewall.ruleSetsSection' => 'Regelsett',
    'web-app-firewall.ruleSetsSectionHint' => 'Velg hvilket regelsett (en filpakke med sikkerhetsregler) du vil bruke til kontroll av innkommende HTTP-forespørsler.',
    'web-app-firewall.ruleSet' => 'Regelsett',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratis)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Core Rule Set er svært restriktivt og kan blokkere enkelte funksjoner (for eksempel fildeling, nettbasert e-post) og enkelte funksjoner av nettbaserte applikasjoner (for eksempel, WordPress plugins).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Ta i bruk endringene?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'OWASP-regler kan være for strenge og dermed blokkere enkelte funksjoner, som fildeling, webmail og enkelte webprogrammer.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (gratis, kan oppgraderes til Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'En versjon av ModSecurity Rules man kan starte opp med, fra Atomicorp. De gir en grunnleggende beskyttelse og oppdateres på en månedlig basis.',
    'web-app-firewall.ruleSetTortixHowTo' => 'For å oppgradere dette regelsettet til Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Kjøp %%linkPleskStore%% fra Plesk-nettstedet og %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Advanced ModSecurity Rules fra Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'Installer den innkjøpte ekstra lisensnøkkelen',
    'web-app-firewall.ruleSetTortixSelect' => 'Velg dette regelsettet, som vil endre sitt navn til “Atomic Advanced (kjøpt fra Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (kjøpt fra Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Advanced ModSecurity Rules fra Atomicorp inkluderer Atomic Standard regler pluss et antall avanserte funksjoner.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (kjøpt fra Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Advanced ModSecurity Rules fra Atomicorp inkluderer Atomic Standard regler pluss et antall avanserte funksjoner.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Bytt til en annen Atomicorp-konto.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Regelsettet er aktivert.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Om du allerede har Atomicorp-kontoen med de kjøpte Atomic Avanserte Reglene, angi kontolegitimasjonen nedenfor for å aktivere dette regelsettet.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Hvis du allerede har en Atomicorp-konto og har kjøpt Atomic Advanced-reglene, kan du skrive inn informasjonen din nedenfor og bytte til denne kontoen.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Brukernavn',
    'web-app-firewall.ruleSetAtomicPassword' => 'Passord',
    'web-app-firewall.ruleSetComodo' => 'Comodo (gratis abonnement)',
    'web-app-firewall.ruleSetComodoDescription' => 'Free ModSecurity Rules fra Comodo. De gir en grunnleggende beskyttelse.',
    'web-app-firewall.ruleSetComodoInstall' => 'Bytt til en annen Comodo-konto.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Regelsettet er aktivert.',
    'web-app-firewall.ruleSetComodoHowTo' => 'For å aktivere dette regelsettet:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Bytt til en annen konto:',
    'web-app-firewall.ruleSetComodoRegister' => 'Registrer deg på Comodo nettstedet.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Angi ditt brukernavn og passord fra det nettstedet.',
    'web-app-firewall.ruleSetComodoLogin' => 'Brukernavn',
    'web-app-firewall.ruleSetComodoPassword' => 'Passord',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratis)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Free ModSecurity Rules fra Comodo. De gir en grunnleggende beskyttelse.',
    'web-app-firewall.ruleSetCustom' => 'Egendefinert regelsett',
    'web-app-firewall.ruleSetCustomDescription' => 'Last opp et egendefinert regelsett for brannmur for webprogram. Støttede formater: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Velg en annen fil',
    'web-app-firewall.ruleSetError' => 'Klarte ikke å installere regelsett for ModSecurity: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'OWASP-regelsettet mangler. Installer ModSecurity på nytt med Plesk-installasjonsprogrammet.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Det egendefinerte regelsettet mangler. Installer regelsettet på nytt.',
    'web-app-firewall.ruleSetAuthError' => 'Angitt brukernavn eller passord er ugyldig.',
    'web-app-firewall.ruleSetInvalid' => 'Det valgte regelsettet kan ikke kjøres på %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Det valgte regelsettet kan ikke kjøres på den valgte webserveren.',
    'web-app-firewall.webServer' => 'Kjør regler på',
    'web-app-firewall.webServerHint' => 'Velg den ønskede kombinasjonen av webserver- og ModSecurity-versjon for å se kompatible regelsett.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Omvendt proxyserver (nginx) er deaktivert og kan ikke brukes til å behandle forespørsler. Velg <a href="%%serverUrl%%">en annen webserver</a> eller aktiver omvendt proxyserver på siden <a href="%%servicesUrl%%">Tjenestebehandling</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Hvis du velger en annen ModSecurity-versjon, kan det føre til at noen av innstillingene ikke lenger er gyldige (for eksempel kan du ikke bruke vanlige uttrykk til å slå av sikkerhetsreglene med ModSecurity 3). Sørg for at innstillingene dine fungerer som forventet etter at du har utført endringene. Eventuelt kan du tilbakestille innstillingene som slår av sikkerhetsreglene til standardverdiene.',
    'web-app-firewall.nginxResetCustomizations' => 'Tilbakestill server- og domeneinnstillingene som slår av sikkerhetsreglene til standardverdiene.',
    'web-app-firewall.ruleSetUpdate' => 'Oppdater regelsett',
    'web-app-firewall.ruleSetUpdateDaily' => 'Hver dag',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Ukentlig',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Månedlig',
    'web-app-firewall.currentRuleSet' => 'Regelsett',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% kjører på %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Endre regelsett',
    'web-app-firewall.ruleSetRollbackFailed' => 'Kan ikke bruke gjeldende regelsett for ModSecurity og går tilbake til forrige versjon siden det inneholder ugyldige regler.',
    'web-app-firewall.configurationSection' => 'Configurasjon',
    'web-app-firewall.configurationSectionHint' => 'Konfigurer brannmuren for webprogrammer, enten ved hjelp av et forhåndsdefinert parametersett, eller ved hjelp av egendefinerte ModSecurity-direktiver.',
    'web-app-firewall.configPreset' => 'Forhåndsdefinert verdisett',
    'web-app-firewall.configPresetFast' => 'Rask',
    'web-app-firewall.configPresetFastDescription' => 'HTTP-forespørselens URI og deler av filhodene vil bli analysert.',
    'web-app-firewall.configPresetTradeOff' => 'Avveiing',
    'web-app-firewall.configPresetTradeOffDescription' => 'URI til HTTP-forespørselen, filhoder og forespørselens POST-data vil bli analysert.',
    'web-app-firewall.configPresetThrough' => 'Grundig',
    'web-app-firewall.configPresetThroughDescription' => 'Hele filhodet til HTTP-forespørselen, forespørselens POST-data og brødteksten i HTTP-responsen vil bli analysert.',
    'web-app-firewall.configCustom' => 'Egendefinerte direktiver',
    'web-app-firewall.configCustomDescription' => "Angi et ModSecurity-direktiv her. Det vil overskrive tidligere spesifiserte direktiver (regelsett, spesifikke regler, forhåndsdefinerte verdisett og så videre).\n For eksempel: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Ugyldig konfigurasjon av ModSecurity: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Kan ikke bruke aktiv konfigurasjonsfil for ModSecurity og gå tilbake til tidligere versjon av filen fordi de inneholder ugyldig konfigurasjon.',
    'web-app-firewall.rulesSection' => 'Slå av sikkerhetsregler',
    'web-app-firewall.rulesSectionHint' => 'Her kan du slå av sikkerhetsregler. Dette er nyttig hvis du finner ut at en sikkerhetsregel er for streng for enkelte nettsteder. Angi ID-en (for eksempel 340003 eller 340005-340007), tags (for eksempel CVE-2011-4898) eller uttrykk som brukes i regelmeldinger (for eksempel XSS), for å deaktivere sikkerhetsregler.',
    'web-app-firewall.rulesSectionNginxHint' => 'Her kan du slå av sikkerhetsregler. Dette er nyttig hvis du finner ut at en sikkerhetsregel er for streng for enkelte nettsteder. Angi ID-en (for eksempel 340003 eller 340005-340007), tags (for eksempel CVE-2011-4898) eller regelmeldinger (for eksempel "Found User-Agent associated with security scanner") for å deaktivere sikkerhetsregler.',
    'web-app-firewall.filterById' => 'Sikkerhetsregel-ID-er',
    'web-app-firewall.filterByIdInvalid' => 'De følgende verdiene er ikke gyldige: %%values%%. Regel-ID skal være et tall eller et tallområde, for eksempel 913100 eller 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Følgende områder er ikke gyldige: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Tags',
    'web-app-firewall.filterByTagActive' => 'Aktiv:',
    'web-app-firewall.filterByTagDeactivated' => 'Deaktivert:',
    'web-app-firewall.filterByTagInvalid' => 'Følgende valgte verdier er ikke gyldige: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Regulære uttrykk i regelmeldinger',
    'web-app-firewall.filterByRegexpInvalid' => 'Følgende verdier er ikke gyldige: %%values%%. De kan ikke inneholde tegnene \', "',
    'web-app-firewall.filterByRegexpNginx' => 'Regelmeldinger',
    'web-app-firewall.filterByRegexpNginxHint' => 'Kun nøyaktige treff støttes.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Følgende verdier er ikke gyldige: %%values%%. Regelmeldingen må bestå av bokstaver, tall, mellomrom eller tegnene -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'ModSecurity revisjonslogg',
    'web-app-firewall.auditLogHint1' => 'ModSecurity revisjonsloggfil er den nyttigste informasjonen i systemet. Når ModSecurity oppdager en hendelse, vil den generere en oppføring i revisjonsloggfilen.',
    'web-app-firewall.auditLogHint2' => 'Et nettsted kan slutte å fungere som forventet etter at du endrer brannmurmodus for webprogram til På fra Av eller Bare detektering. I dette tilfellet bør du analysere revisjonsloggen i ModSecurity for å finne ut hva som skjer. Du kan slå av sikkerhetsregler som er for strenge eller justere nettstedet.',
    'web-app-firewall.auditLogHint3' => 'For å finne ut hvorfor en HTTP-forespørsel ikke kan fullføres for et nettsted:',
    'web-app-firewall.auditLogPoint1' => 'Klikk på koblingen til ModSecurity-loggfilen under og åpne revisjonsloggen i et nytt nettleservindu.',
    'web-app-firewall.auditLogPoint2' => 'Bruk søk (Ctrl+F i de fleste nettlesere) for å finne hendelser for nettstedet (domenenavnet) som har problemer. For eksempel, ditt_domene.tld. Nettleseren vil fremheve oppføringer som HOST: ditt_domene.tld.',
    'web-app-firewall.auditLogPoint3' => 'I de tre linjene over den fremhevede oppføringen, finner du en streng lignende --eece5138-B--. De åtte symbolene mellom bindestrekene (i eksempelet, eece5138) er ID-en til en hendelse utløst av HTTP-forespørselen.',
    'web-app-firewall.auditLogPoint4' => 'Søk videre etter andre oppføringer med samme hendelses-ID. Se etter en oppføring med bokstaven H etter hendelses-ID-en (eece5138-H-- i vårt eksempel). Denne oppføringen inneholder ID-en og beskrivelse av sikkerhetsregelen som ble utløst under kontroll av HTTP-forespørselen. Sikkerhetsregelens ID er et heltall i anførselstegn med prefiks-ID i hakeparentes (for eksempel [id "340003"]).',
    'web-app-firewall.auditLogPoint5' => 'Finn en sikkerhetsregel-ID for hendelsen ved hjelp av en understreng (for eksempel [id "3).',
    'web-app-firewall.auditLogPoint6' => 'Slå av sikkerhetsregelen med denne ID-en i seksjonen Sikkerhetsregler under: angi sikkerhetsregel-ID (kun tall) i feltet sikkerhetsregel-ID og klikk på OK.',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity loggfil',
    'web-app-firewall.auditLogListLink' => 'Loggarkiv',
    'web-app-firewall.errorLogSection' => 'Feillogg',
    'web-app-firewall.errorLogSectionHint' => 'Et nettsted kan slutte å fungere som forventet etter at du endrer brannmurmodus for webprogram til På fra Av eller Bare detektering. I dette tilfellet bør du analysere feilloggen for å finne ut hva som skjer. Du kan slå av sikkerhetsregler som er for strenge eller justere nettstedet.',
    'web-app-firewall.errorLogViewLink' => 'Feillogg',
    'web-app-firewall.notificationStateEnabled' => 'Plesk UI-varsler for oppdateringer av regelsett er aktivert. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Plesk UI-varsler for oppdateringer av regelsett er deaktivert. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Administrer dem på varselsiden',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Hvis du velger alternativene «Tradeoff» eller «Thorough», kan dette forårsake at WordPress-nettsteder ikke fungerer som de skal, i tillegg til uønskede bieffekter på grunn av følgende <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity-problem</a>.',

    'ProtectedDirectory.pathLabel' => 'Mappenavn',
    'ProtectedDirectory.realmLabel' => 'Tittel på beskyttet område',
    'ProtectedDirectory.locationLabel' => 'Mappeplassering',
    'ProtectedDirectory.isNonSslLabel' => 'ikke-SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => 'Rapportnavn',
    'SummaryReport.Layout.isDefault' => 'Bruk som standardrapport',
    'SummaryReport.Layout.sections' => 'Seksjoner',
    'SummaryReport.Layout.general' => 'Generelt',
    'SummaryReport.Layout.resellers' => 'Videreforhandler',
    'SummaryReport.Layout.clients' => 'Kunder',
    'SummaryReport.Layout.personalClients' => 'Egne kunder',
    'SummaryReport.Layout.domains' => 'Domener',
    'SummaryReport.Layout.personalDomains' => 'Personlige domener',
    'SummaryReport.Layout.type.full' => 'Full',
    'SummaryReport.Layout.type.summary' => 'Sammendrag',

    'SummaryReport.Schedule.enable' => 'Aktiver',
    'SummaryReport.Schedule.period' => 'Leveringsfrekvens',
    'SummaryReport.Schedule.daily' => 'Hver dag',
    'SummaryReport.Schedule.weekly' => 'Ukentlig',
    'SummaryReport.Schedule.monthly' => 'Månedlig',
    'SummaryReport.Schedule.email' => 'Leveres til',
    'SummaryReport.Schedule.isEmpty' => 'Angi en gyldig e-postadresse.',
];