<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    '_shared.webstatDomainIsSuspended' => 'Le Site Web %%domainName%% est suspendu.',
    '_shared.webstatHostingNotConfigured' => 'Il n\'y a aucun hébergement configuré sur le %%domainName%%.',
    '_shared.webstatNotSelected' => 'Vous n\'avez pas sélectionné un programme de statistiques Web à utiliser pour le site Web sur %%domainName%%.',
    '_shared.domainDisabled' => 'Ce domaine (site Web) a été désactivé par l\'hébergeur.',
    '_shared.domainSuspended' => 'Ce domaine (site Web) a été suspendu par l\'hébergeur.',
    '_shared.operationSelectorHint' => 'Pour procéder à cette opération, veuillez sélectionner un espace Web.',
    '_shared.operationSelectorTitle' => 'Espace Web',

    'add-domain-alias.noDomains' => 'Impossible de créer un alias : il n\'y a aucun domaine disponible.',
    'add-domain.noDomains' => 'Impossible de créer un domaine supplémentaire : il n\'y a aucun domaine disponible.',
    'add-subdomain.noDomains' => 'Impossible de créer un sous-domaine : il n\'y a aucun domaine disponible.',

    'change-hosting.title' => 'Changer le type d\'hébergement',

    'change-status-alias.activated' => 'L\'alias de domaine %%domainAliasName%% a bien été activé.',
    'change-status-alias.deactivated' => 'L\'alias de domaine %%domainAliasName%% a été désactivé.',
    'change-status-alias.notActivated' => 'L\'alias de domaine Web %%domainAliasName%% ne peut pas être activé, car il a été désactivé par votre hébergeur.',

    'change-status.title' => 'Modifier le statut du site Web',

    'delete.sitesNotSpecified' => 'Aucun site indiqué pour la suppression',
    'delete.domainDeletionNotAllowed' => 'La suppression du domaine n\'est pas autorisée.',
    'delete.subdomainDeletionNotAllowed' => 'La suppression du sous-domaine n\'est pas autorisée.',
    'delete.aliasDeletionNotAllowed' => 'La suppression de l\'alias n\'est pas autorisée.',
    'delete.domainDeletedSuccessfully' => 'Le domaine a été supprimé.',
    'delete.subdomainDeletedSuccessfully' => 'Le sous-domaine a été supprimé.',
    'delete.aliasDeletedSuccessfully' => 'L\'alias a été supprimé.',

    'download-web-deploy-publish-settings.hostingNotConfigured' => 'Il n\'y a aucun hébergement configuré sur le %%domainName%%.',
    'download-web-deploy-publish-settings.webDeployNotSupported' => 'Web Deploy n\'est pas pris en charge.',
    'download-web-deploy-publish-settings.webDeployNotInstalled' => 'Web Deploy n\'est pas installé.',
    'download-web-deploy-publish-settings.webDeployNotConfigured' => 'Aucune publication Web Deploy n\'est configurée dans %%domainName%%.',

    'index.title' => 'Sites Web & Domaines',
    'index.home' => 'Accueil',

    'overview.title' => 'Aperçu du domaine',
    'overview.suspended' => 'Suspendu',
    'overview.disabled' => 'Désactivé',

    'php-settings.title' => 'Paramètres PHP pour %%domainName%%',
    'php-settings.updatedSuccessfully' => 'Les paramètres ont bien été mis à jour.',
    'php-settings.showPhpInfoError' => 'Impossible d\'obtenir les informations sur la configuration PHP.',
    'php-settings.phpHandlerNotFound' => 'Impossible de récupérer les informations sur la version PHP du domaine. Réinstallez-la ou sélectionnez une autre version de PHP pour le domaine.',
    'php-settings.phpHandlerNotRegistered' => "La version %%fullVersion%% de PHP n'est pas installée. Le script PHP pour le domaine \"%%domainName%%\" n'est pas disponible. Installez PHP <nobr>version %%fullVersion%%</nobr> ou sélectionnez une autre version de PHP pour le domaine.",

    'seo-settings.title' => 'Paramètres SEO',
    'seo-settings.description' => 'Définissez les paramètres spécifiques des moteurs de recherche pour votre site.',
    'seo-settings.successSaved' => 'Paramètres SEO enregistrés avec succès.',

    'settings.title' => 'Paramètres d\'hébergement',
    'settings.titleForObject' => 'Paramètres d\'hébergement pour %%name%%',
    'settings.updatedSuccessfully' => 'Les paramètres ont été mis à jour.',

    'site-copy.title' => 'Copier les fichiers %%siteName%%',
    'site-copy.description' => 'Copiez les fichiers du site Web vers un autre site qui vous appartient hébergé sous ce compte ou vers un stockage FTP. Une telle copie est utile s\'il s\'agit d\'un site Web de production et si vous planifiez d\'apporter d\'importants changements au site. Dans ce cas, vous pouvez cloner le site vers un environnement provisoire et laisser vos designers et programmateurs travailler sur le clone sans interrompre les actions sur le site de production. Copier les fichiers du site fait partie du clonage du site, vous devrez également copier les bases de données utilisées par le site pour terminer ce clonage. Si vous n\'avez pas d\'autre site à utiliser en tant qu\'environnement provisoire, vous pouvez ajouter un domaine ou sous-domaine à cette fin.',
    'site-copy.siteCopiedSuccessfully' => 'Les fichiers du site %%sourceName%% ne peuvent pas être copiés vers %%destinationName%%.',

    'statistics.show' => 'Afficher',
    'statistics.webStatistics' => 'Statistiques Web',
    'statistics.sslWebStatistics' => 'Statistiques Web SSL/TLS',
    'statistics.ftpStatistics' => 'Statistiques FTP',
    'statistics.anonymousFtpStatistics' => 'Statistiques du FTP anonyme',
    'statistics.hostingNotConfigured' => 'Il n\'y a aucun hébergement Web configuré sur le domaine %%domainName%%',
    'statistics.webstatNotSelected' => 'Vous n\'avez pas sélectionné de programme de statistiques Web à utiliser sur le domaine %%domainName%%',

    'subscription-delete.infoSubscriptionDeleted' => 'Les espaces Web sélectionnés ont été supprimés.',
    'subscription-delete.infoSubscriptionNotDeleted' => 'Certains espaces Web sélectionnés n\'ont pas été retirés.',

    'subscriptions.title' => 'Espace Web',
    'subscriptions.buttonRemove' => 'Supprimer',
    'subscriptions.buttonRemoveDescription' => 'Supprimez les espaces Web sélectionnés.',
    'subscriptions.confirmOnDelete' => 'Voulez-vous supprimer les espaces Web sélectionnés ?',
    'subscriptions.buttonAddNew' => 'Ajouter un espace Web',
    'subscriptions.buttonAddNewDescription' => 'Créez un espace Web.',
    'subscriptions.buttonMyResources' => 'Mes ressources',
    'subscriptions.buttonMyResourcesDescription' => 'Affichez les ressources disponibles.',
    'subscriptions.subscriptionsHintTitle' => 'Résumé de l\'espace Web',
    'subscriptions.subscriptionsHintWaitMessage' => 'Chargement en cours...',

    'view.title' => 'Sites Web & Domaines',
    'view.suspended' => 'Suspendu',
    'view.disabled' => 'Désactivé',
    'view.buttonDeleteDomain' => 'Supprimer le site Web',
    'view.buttonDeleteDomainHint' => 'La suppression de ce site web entrainera également la suppression de tous les fichiers, répertoires, mails et applications web associés du serveur.',
    'view.buttonDeleteSubdomain' => 'Supprimer le sous-domaine',
    'view.buttonDeleteSubdomainHint' => 'La suppression de ce site web entrainera également la suppression de tous les fichiers, répertoires, mails et applications web associés du serveur.',
    'view.buttonDeleteAlias' => 'Supprimer l\'alias de domaine',
    'view.buttonDeleteAliasHint' => 'Supprimez cet alias.',
    'view.warningSubscriptionUsesSNWithoutLicense' => 'Les opérations de gestion de l\'hébergement ne sont pas autorisées pour cet abonnement : %%reason%%. Veuillez contacter votre fournisseur de services.',
    'view.warningSubscriptionIsSuspended' => 'L\'abonnement a été suspendu. Tous vos sites ne sont pas disponibles.',
    'view.warningSubscriptionIsSuspendedByBackupRestore' => 'L\'abonnement est temporairement indisponible, car la sauvegarde ou la restauration des données est en cours. Veuillez réessayer ultérieurement.',
    'view.warningSubscriptionIsSuspended_powerUser' => 'L\'espace Web a été suspendu. Tous les sites hébergés dans l\'espace Web ne sont pas disponibles.',
    'view.buttonIssAppPoolHint_powerUser' => 'Configurez un pool d\'applications IIS dédié pour servir tous les sites Web associés avec l\'espace Web actuellement sélectionné.',
    'view.buttonSitebuilder' => 'Presence Builder',
    'view.buttonSitebuilderHint' => 'Créez des sites Web instantanés à partir des templates professionnels et personnels avec l\'éditeur intuitif Presence Builder.',
    'view.buttonMobileSites' => 'Sites Web mobiles',
    'view.buttonMobileSitesHint' => 'Créez des versions mobiles pour vos sites Web et éditez leur contenu.',
    'view.buttonApplications' => 'Applications',
    'view.buttonApplicationsHint' => 'Installez et gérez les applications Web sur vos sites Web. Les forums, galeries photo, outils de collaboration, etc. sont installés en quelques clics.',
    'view.buttonGoogleServicesForWebsites' => 'Solutions Google pour sites Web',
    'view.buttonGoogleServicesForWebsitesHint' => 'Configurez les services Google pour optimiser vos sites Web, accroître le trafic, fidéliser les internautes et générer des revenus.',
    'view.buttonConnectionInfo' => 'Infos de connexion',
    'view.buttonConnectionInfoDesc' => 'pour FTP, la base de données',
    'view.buttonConnectionInfoLabelNew' => 'NOUVEAU',
    'view.buttonFileManager' => 'Fichiers',
    'view.buttonFileManagerHint' => 'Envoyez les nouveaux fichiers et utilisez les fichiers et répertoires actuels de vos sites Web.',
    'view.buttonWebStatistics' => 'Statistiques Web',
    'view.buttonWebStatisticsHint' => 'Affichez le nombre d\'internautes qui consultent le site web, via HTTP, ainsi que les pages web vues.',
    'view.buttonWebStatisticsSsl' => 'Statistiques Web SSL/TLS',
    'view.buttonWebStatisticsSslHint' => 'Affichez le nombre d\'internautes qui consultent le site web, via HTTPS, ainsi que les pages web vues.',
    'view.buttonTransferStats' => 'Transfert de données',
    'view.buttonTransferStatsHint' => 'Affichez le trafic utilisé par les différents services.',
    'view.buttonTransferStatsComment' => 'HTTP, FTP, Mail',
    'view.buttonStatistics' => 'Espace disque et trafic',
    'view.buttonStatisticsHint' => 'Affichez l\'espace disque et le trafic utilisés par les différents services.',
    'view.buttonFTPStats' => 'Rapport de transfert FTP',
    'view.buttonFTPStatsHint' => 'Affichez le volume de données transférées depuis et vers votre site web via FTP.',
    'view.buttonAnonFTPStats' => 'Téléchargements FTP anonymes',
    'view.buttonAnonFTPStatsHint' => 'Téléchargements FTP depuis un répertoire qui ne requiert ni nom d\'utilisateur ni mot de passe.',
    'view.buttonFtpAccess' => 'FTP',
    'view.buttonFtpAccessHint' => 'Configurez l\'accès de vos sites Web via le protocole FTP.',
    'view.buttonDnsSettings' => 'DNS',
    'view.buttonDnsSettingsHint' => 'Gérez les zones DNS de vos noms de domaine.',
    'view.domainNotResolvedComment' => 'Impossible de résoudre le domaine',
    'view.buttonWhoisInfo' => 'Informations WHOIS',
    'view.buttonWhoisInfoHint' => 'Affichez les informations concernant votre nom de domaine enregistré.',
    'view.buttonSslCertificates' => 'Certificats SSL/TLS',
    'view.buttonSslCertificatesHint' => 'Protégez les connexions à vos sites Web à l\'aide des certificats SSL/TLS.',
    'view.buttonWebAppFirewall' => 'Pare-feu des applications Web',
    'view.buttonWebAppFirewallHint' => 'Configurez la protection contre de nombreuses attaques visant les applications Web utilisées sur votre site Web.',
    'view.buttonBackup' => 'Sauvegarder et restaurer',
    'view.buttonBackupHint' => 'Sauvegardez et restaurez vos domaines, dont les paramètres et le contenu de vos sites Web et des comptes mail.',
    'view.buttonHostingSettings' => 'Accès à l\'hébergement Web',
    'view.buttonHostingSettingsHint' => 'Changez les paramètres du compte utilisateur système pour accéder à distance à Plesk via SSH ou RDP et utiliser les fichiers et dossiers dans le Gestionnaire de fichiers.',
    'view.buttonHostingSettingsDesc' => 'Adresse IP, utilisateur système, accès à l\'espace Web via SSH ou RDP.',
    'view.buttonWebScripting' => 'Hébergement',
    'view.buttonWebScriptingHint' => 'Emplacement où vous configurez les paramètres de l\'hébergement du site Web et sélectionnez les fonctions disponibles pour votre site.',
    'view.buttonWebScriptingDesc' => 'Nom de domaine, racine du document, certificat SSL, scripts Web, etc.',
    'view.buttonHosting' => 'Hébergement',
    'view.buttonHostingDesc' => 'Configuration de l\'hébergement et accès à l\'hébergement web',
    'view.buttonEmailAddresses' => 'Comptes mail',
    'view.buttonEmailAddressesHint' => 'Créez et gérez les comptes mail associés à vos sites Web.',
    'view.buttonMailSettings' => 'Paramètres de la messagerie',
    'view.buttonMailSettingsHint' => 'Modifiez les paramètres de la messagerie de ce domaine.',
    'view.buttonMailLists' => 'Listes de diffusion',
    'view.buttonMailListsHint' => 'Créer et gérer des listes de diffusion - un moyen d\'envoyer un message électronique à plusieurs destinataires à la fois.',
    'view.buttonOutgoingSpamSettings' => 'Contrôle des mails sortants',
    'view.buttonOutgoingSpamSettingsHint' => 'Définissez la limite du nombre de messages sortants pour ce domaine. Le domaine est limité au nombre de messages que vous avez spécifié.',
    'view.buttonPhpSettings' => 'PHP',
    'view.buttonPhpSettingsVersion' => 'Version',
    'view.buttonPhpSettingsHint' => 'Modifiez les paramètres PHP pour ce site Web.',
    'view.buttonWebServerSettingsUnix' => 'Apache & nginx',
    'view.buttonWebServerSettingsUnixHint' => 'Modifiez les paramètres Apache et Nginx pour ce site Web.',
    'view.buttonWebServerSettingsWindows' => 'Paramètres IIS',
    'view.buttonWebServerSettingsWindowsHint' => 'Modifiez les paramètres IIS pour ce site Web.',
    'view.buttonProtectedDirectories' => 'Répertoires protégés par un mot de passe',
    'view.buttonProtectedDirectoriesHint' => 'Limitez l\'accès aux zones sélectionnées de vos sites Web avec la protection par mot de passe.',
    'view.buttonSeoSettings' => 'Paramètres SEO',
    'view.buttonSeoSettingsHint' => 'Définissez les paramètres spécifiques des moteurs de recherche pour votre site.',
    'view.buttonSheduledTasks' => 'Tâches planifiées',
    'view.buttonSheduledTasksHint' => 'Affichez et gérez des tâches planifiées.',
    'view.buttonDatabases' => 'Bases de données',
    'view.buttonDatabasesHint' => 'Créez et retirez les bases de données utilisées par vos sites Web et gérez-les à l\'aide de l\'application Web admin intégrée.',
    'view.buttonLogs' => 'Journaux',
    'view.buttonLogsDescProblem' => 'Problèmes détectés',
    'view.buttonLogsHint' => 'Affichez les journaux et configurez le recyclage des fichiers journaux.',
    'view.buttonFailedRequests' => 'Suivi des demandes ayant échoué',
    'view.buttonFailedRequestsHint' => 'Suivez les requêtes HTTP ayant échoué vers votre site Web.',
    'view.buttonHotlinkProtection' => 'Protection contre les hotlinks',
    'view.buttonHotlinkProtectionHint' => 'Protégez le contenu de vos sites Web contre le hotlinking.',
    'view.buttonVirtualFolder' => 'Répertoires virtuels',
    'view.buttonVirtualFolderHint' => 'Créez et gérez les répertoires virtuels pour vos sites Web.',
    'view.buttonBandwidthLimiting' => 'Limitation de la bande passante',
    'view.buttonBandwidthLimitingHint' => 'Ajustez la limite d\'utilisation de la bande passante et le nombre de connexions à votre site Web',
    'view.buttonDomainAliases' => 'Alias de domaines',
    'view.buttonDomainAliasesHint' => 'Affichez et gérez les noms de domaine alternatifs de vos sites Web.',
    'view.buttonIpAddresses' => 'Adresses IP',
    'view.buttonIpAddressesHint' => 'Gérez les adresses IP.',
    'view.buttonWebUsers' => 'Utilisateurs Web',
    'view.buttonWebUsersHint' => 'Configurez les comptes pour les utilisateurs qui peuvent héberger les pages Web personnelles sur vos sites Web.',
    'view.buttonJavaApps' => 'Applications Java',
    'view.buttonJavaAppsHint' => 'Installez puis gérez les applications Java.',
    'view.buttonOdbcDataSources' => 'Sources de données ODBC',
    'view.buttonOdbcDataSourcesHint' => 'Configurez les DSN ODBC.',
    'view.buttonAspNetSettings' => 'Paramètres ASP.NET',
    'view.buttonAspNetSettingsHint' => 'Configurez les paramètres du framework ASP.NET.',
    'view.buttonCustomerIisAppPool' => 'Pool d\'applications IIS dédié pour votre compte',
    'view.buttonCustomerIisAppPoolHint' => 'Configurez un pool d\'applications IIS dédié pour servir tous les sites Web hébergés sous votre compte.',
    'view.buttonIssAppPool' => 'Pool d\'applications IIS dédié pour ce site Web',
    'view.buttonIssAppPoolHint' => 'Configurez un pool d\'applications IIS dédié pour ce site Web.',
    'view.buttonSiteCopy' => 'Copie du site Web',
    'view.buttonSiteCopyHint' => 'Copiez les fichiers du site Web vers un autre site ou un stockage FTP externe.',
    'view.buttonWebDeploy' => 'Paramètres de publication Web Deploy',
    'view.buttonWebDeployHint' => 'Télécharger les paramètres de publication Web Deploy',
    'view.buttonSubscriptions' => 'Espaces Web',
    'view.buttonSubscriptionsHint' => 'Affichez et gérez les espaces Web.',
    'view.buttonOutgoingMailControl' => 'Contrôle des mails sortants',
    'view.buttonOutgoingMailControlHint' => 'Affichez et gérez les mails sortants.',
    'view.buttonInstallApsApplication' => 'Plus d\'apps',
    'view.buttonInstallApsApplicationHint' => 'Dans le Catalogue des applications',
    'view.buttonFilesUpload' => 'Envoyer les fichiers',
    'view.buttonFilesUploadHint' => 'Depuis une machine locale',
    'view.forceUpdateApplicationsNotification' => 'Désormais, toutes vos applications seront automatiquement mises à jour. Utilisez ce paramètre avec précaution, car il peut affecter significativement le fonctionnement de l\'application. Par exemple, les extensions de l\'application peuvent cesser de fonctionner avec une autre version de l\'application. %%link%%',
    'view.forceUpdateAllApplicationsNotificationLink' => 'Activer les mises à jour automatiques pour toutes les applications',
    'view.unnotifiedApplicationsUpdatesMessage' => 'Les mises à jour sont disponibles pour les applications suivantes :',
    'view.updatedAutomaticallyApplicationsMessage' => 'Les applications suivantes sont automatiquement mises à jour :',
    'view.activeStateComponentsWarning' => 'Les composants ActivePerl et/ou ActivePython sont installés sur le serveur. Ils ne sont plus sous licence Plesk via ActiveState. Pour éviter toute infraction au contrat de licence, %%link%%.',
    'view.activeStateComponentsWarningLink' => 'vous devez intervenir',
    'view.toSecurePasswordsGoTo' => 'Pour renforcer la sécurité de Plesk, nous vous conseillons d\'activer le mode de sécurité avancé via %%link%%.',
    'view.securePasswords' => 'page',
    'view.upgradeDnsSyncSkip' => 'Notez qu\'après la mise à niveau, toutes les zones DNS existantes sont considérées comme étant modifiées par l\'utilisateur. Autrement dit, vous pouvez appliquer les changements de templates DNS à de telles zones uniquement à l\'aide de l\'option \'Appliquer les changements dans toutes les zones\' lors de la %%link%%. %%learnMoreLink%%.',
    'view.serverDns' => 'synchro',
    'view.learnMore' => 'En savoir plus',
    'view.backEncryptionRequired' => 'Pour des raisons de sécurité, nous vous recommandons de protéger à l\'aide d\'un mot de passe les données confidentielles incluses dans la sauvegarde. Allez sous %%link%% et mettez à jour les paramètres de sécurité de la sauvegarde.',
    'view.backupSettingPage' => 'Paramètres de sauvegarde',
    'view.ipAddress' => 'Adresse IP : %%ipAddress%%',
    'view.ipv4Address' => 'Adresse IPv4 : %%ipAddress%%',
    'view.ipv6Address' => 'Adresse IPv6 : %%ipAddress%%',
    'view.subscriptionNotExist' => 'L\'abonnement n\'existe pas.',
    'view.ftpLogin' => 'Nom d\'utilisateur FTP : %%ftpLogin%%',
    'view.phpVersion' => 'Version de PHP : %%phpVersion%%',
    'view.phpHandlerOutdated' => '(Obsolète)',
    'view.resellerDescription' => 'Revendeur',
    'view.ownerDescription' => 'Client',
    'view.buttonDescriptionEdit' => 'Éditer la description',
    'view.buttonDescriptionRemove' => 'Supprimer la description',
    'view.popupDescriptionTitle' => '%%descriptionType%% de %%name%%',
    'view.confirmOnDeleteDescription' => 'Voulez-vous supprimer cette description ?',
    'view.buttonDescription' => 'Description',
    'view.updatesAvailable' => 'Des mises à jour sont disponibles',
    'view.apsInstall' => 'Installer',
    'view.apsApplicationInstall' => 'Installer %%app%%',
    'view.apsInstallAll' => 'Tout installer',
    'view.apsChangelog' => 'Journal des modifications',
    'view.apsApplicationChangelog' => 'Journal des modifications %%app%%',
    'view.apsInstances' => '%%total%% installations',
    'view.loading' => 'Chargement en cours...',
    'view.close' => 'Fermer',
    'view.viewMore' => 'Afficher %%number%% mises à jour en plus',
    'view.unableGetChangelog' => 'Impossible de récupérer le journal des modifications. Actualisez la page et réessayez.',

    'web-server-settings.titleUnix' => 'Modifier les paramètres d\'Apache et Nginx pour %%domainName%%',
    'web-server-settings.titleWindows' => 'Paramètres IIS pour %%domainName%%',
    'web-server-settings.updatedSuccessfully' => 'Les paramètres ont été mis à jour.',

    'setup.title' => 'Sites Web & Domaines',
    'setup.noDomainTitle' => 'Prêt à créer des sites Web',
    'setup.description' => 'Ajoutez un nouveau domaine pour commencer à créer votre site Web.',
    'setup.openTutorial' => 'Vous avez besoin d\'aide ? Lisez notre %%link%%.',
    'setup.openTutorialLink' => 'tutoriel de création de site Web',
    'setup.addDomain' => 'Ajouter un domaine',
];