<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    '_shared.webstatDomainIsSuspended' => 'Die Website %%domainName%% wurde angehalten.',
    '_shared.webstatHostingNotConfigured' => 'Für %%domainName%% wurde kein Hosting konfiguriert.',
    '_shared.webstatNotSelected' => 'Sie haben kein Webstatistik-Programm für die Website auf der Domain %%domainName%% ausgewählt.',
    '_shared.domainDisabled' => 'Diese Domain (Website) wurde vom Hosting-Provider deaktiviert.',
    '_shared.domainSuspended' => 'Diese Domain (Website) wurde von dem Hosting-Provider gesperrt.',
    '_shared.operationSelectorHint' => 'Um den Vorgang fortzusetzen, wählen Sie bitte zunächst einen Webspace aus.',
    '_shared.operationSelectorTitle' => 'Webspace',

    'add-domain-alias.noDomains' => 'Ein Alias kann nicht erstellt werden: Keine Domains verfügbar.',
    'add-domain.noDomains' => 'Eine Add-on-Domain kann nicht erstellt werden: Keine Domains verfügbar.',
    'add-subdomain.noDomains' => 'Eine Subdomain kann nicht erstellt werden: Keine Domains verfügbar.',

    'change-status-alias.activated' => 'Der Domain-Alias %%domainAliasName%% wurde erfolgreich aktiviert.',
    'change-status-alias.deactivated' => 'Der Domain-Alias %%domainAliasName%% wurde deaktiviert.',
    'change-status-alias.notActivated' => 'Der Domain-Alias %%domainAliasName%% kann nicht aktiviert werden, da er von Ihrem Hosting Provider deaktiviert wurde.',

    'delete.sitesNotSpecified' => 'Es wurden keine Sites zum Entfernen ausgewählt',
    'delete.domainDeletionNotAllowed' => 'Das Löschen von Domains ist nicht zulässig.',
    'delete.subdomainDeletionNotAllowed' => 'Das Löschen von Subdomains ist nicht zulässig.',
    'delete.aliasDeletionNotAllowed' => 'Das Löschen von Aliases ist nicht zulässig.',
    'delete.domainDeletedSuccessfully' => 'Die Domain wurde entfernt.',
    'delete.subdomainDeletedSuccessfully' => 'Die Subdomain wurde entfernt.',
    'delete.aliasDeletedSuccessfully' => 'Der Alias wurde entfernt.',

    'download-web-deploy-publish-settings.hostingNotConfigured' => 'Für %%domainName%% wurde kein Hosting konfiguriert.',
    'download-web-deploy-publish-settings.webDeployNotSupported' => 'Web Deploy wird nicht unterstützt.',
    'download-web-deploy-publish-settings.webDeployNotInstalled' => 'Web Deploy ist nicht installiert.',
    'download-web-deploy-publish-settings.webDeployNotConfigured' => 'Auf der Domain %%domainName%% ist kein Publizieren mit Web Deploy konfiguriert.',

    'index.title' => 'Websites & Domains',
    'index.home' => 'Start',

    'overview.title' => 'Domain-Übersicht',
    'overview.suspended' => 'Gesperrt',
    'overview.disabled' => 'Deaktiviert',

    'php-settings.title' => 'PHP-Einstellungen für %%domainName%%',
    'php-settings.updatedSuccessfully' => 'Die Einstellungen wurden aktualisiert.',
    'php-settings.showPhpInfoError' => 'Informationen über die PHP-Konfiguration können nicht abgerufen werden.',
    'php-settings.phpHandlerNotFound' => 'Es konnten keine Informationen über die PHP-Version der Domain abgerufen werden. Installieren Sie sie neu oder wählen Sie eine andere PHP-Version für die Domain.',
    'php-settings.phpHandlerNotRegistered' => "Die PHP-Version %%fullVersion%% ist nicht installiert. PHP-Scripting für die Domain '%%domainName%%' ist nicht verfügbar. Installieren Sie PHP <nobr>Version %%fullVersion%%</nobr> oder wählen Sie eine andere PHP-Version für die Domain.",

    'site-copy.title' => 'Dateien %%siteName%% kopieren',
    'site-copy.description' => 'Kopieren Sie die Website-Dateien auf eine andere Website, die Sie unter diesem Konto hosten, oder in ein FTP-Storage. Dieser Kopiervorgang ist nützlich, wenn dies eine Produktiv-Website ist und Sie planen, größere Änderungen an der Website vorzunehmen. In solch einem Fall können Sie die Website in eine Staging-Umgebung klonen und Ihre Webdesigner und Programmierer können an dem Klon arbeiten, ohne dass Unterbrechungen auf der Produktiv-Website nötig sind. Das Kopieren der Website-Dateien ist Bestandteil des Klonvorgangs der Website. Sie müssen auch die Datenbanken kopieren, die von der Website zur Fertigstellung des Klonvorgangs benötigt werden. Wenn Sie keine andere Website haben, die Sie als Staging-Umgebung verwenden wollen, dann können Sie für diesen Zweck eine Domain oder Subdomain hinzufügen.',
    'site-copy.siteCopiedSuccessfully' => 'Die Website-Dateien %%sourceName%% wurden nach %%destinationName%% kopiert.',

    'statistics.show' => 'Anzeigen',
    'statistics.webStatistics' => 'Webstatistiken',
    'statistics.sslWebStatistics' => 'SSL/TLS-Webstatistiken',
    'statistics.ftpStatistics' => 'FTP-Statistiken',
    'statistics.anonymousFtpStatistics' => 'Anonymous-FTP-Statistiken',
    'statistics.hostingNotConfigured' => 'Auf Domain %%domainName%% ist kein Webhosting konfiguriert',
    'statistics.webstatNotSelected' => 'Sie haben kein Webstatistik-Programm für die Domain %%domainName%% ausgewählt',

    'subscription-delete.infoSubscriptionDeleted' => 'Die ausgewählten Webspaces wurden entfernt.',
    'subscription-delete.infoSubscriptionNotDeleted' => 'Einige der ausgewählten Webspaces wurden nicht entfernt.',

    'subscriptions.title' => 'Webspace',
    'subscriptions.buttonRemove' => 'Entfernen',
    'subscriptions.buttonRemoveDescription' => 'Entfernen Sie die ausgewählten Webspaces.',
    'subscriptions.confirmOnDelete' => 'Möchten Sie die ausgewählten Webspaces entfernen?',
    'subscriptions.buttonAddNew' => 'Webspace hinzufügen',
    'subscriptions.buttonAddNewDescription' => 'Erstellen Sie einen Webspace.',
    'subscriptions.buttonMyResources' => 'Meine Ressourcen',
    'subscriptions.buttonMyResourcesDescription' => 'Lassen Sie sich die verfügbaren Ressourcen anzeigen.',
    'subscriptions.subscriptionsHintTitle' => 'Zusammenfassung zum Webspace',
    'subscriptions.subscriptionsHintWaitMessage' => 'Wird geladen...',

    'view.title' => 'Websites & Domains',
    'view.suspended' => 'Gesperrt',
    'view.disabled' => 'Deaktiviert',
    'view.buttonDeleteDomain' => 'Website entfernen',
    'view.buttonDeleteDomainHint' => 'Beim Entfernen dieser Website werden auch alle zugehörigen Dateien, Verzeichnisse, E-Mails und Webanwendungen auf dem Server gelöscht.',
    'view.buttonDeleteSubdomain' => 'Subdomain entfernen',
    'view.buttonDeleteSubdomainHint' => 'Beim Entfernen dieser Website werden auch alle zugehörigen Dateien, Verzeichnisse, E-Mails und Webanwendungen auf dem Server gelöscht.',
    'view.buttonDeleteAlias' => 'Domain-Alias entfernen',
    'view.buttonDeleteAliasHint' => 'Entfernen Sie diesen Alias.',
    'view.warningSubscriptionUsesSNWithoutLicense' => 'Für dieses Abonnement sind keine Hosting-Management-Aktionen erlaubt: %%reason%%. Bitte wenden Sie sich an Ihren Service-Provider.',
    'view.warningSubscriptionIsSuspended' => 'Das Abonnement wurde gesperrt. Alle Ihre Websites sind momentan nicht verfügbar.',
    'view.warningSubscriptionIsSuspendedByBackupRestore' => 'Das Abonnement ist vorübergehend nicht verfügbar, da ein Datenbackup- oder -wiederherstellungsprozess im Gang ist. Bitte versuchen Sie es später erneut.',
    'view.warningSubscriptionIsSuspended_powerUser' => 'Der Webspace wurde gesperrt. Die Websites, die in diesem Webspace gehostet werden, sind nicht verfügbar.',
    'view.buttonIssAppPoolHint_powerUser' => 'Richten Sie einen dedizierten IIS-Anwendungspool für Ihre Websites ein, die im aktuell ausgewählten Webspace gehostet werden.',
    'view.buttonSitebuilder' => 'Presence Builder',
    'view.buttonApplications' => 'Anwendungen',
    'view.buttonConnectionInfo' => 'Verbindungsdaten',
    'view.buttonConnectionInfoDesc' => 'für FTP, Datenbank',
    'view.buttonFileManager' => 'Dateien',
    'view.buttonWebStatistics' => 'Webstatistiken',
    'view.buttonWebStatisticsSsl' => 'Webstatistik für SSL/TLS',
    'view.buttonTransferStats' => 'Datenübertragung',
    'view.buttonTransferStatsComment' => 'HTTP, FTP, Mail',
    'view.buttonStatistics' => 'Speicherplatz und Traffic',
    'view.buttonFTPStats' => 'FTP-Transferbericht',
    'view.buttonAnonFTPStats' => 'Anonyme FTP-Downloads',
    'view.buttonFtpAccess' => 'FTP',
    'view.buttonDnsSettings' => 'DNS',
    'view.domainNotResolvedComment' => 'Domain kann nicht aufgelöst werden',
    'view.buttonWhoisInfo' => 'Whois-Informationen',
    'view.buttonSslCertificates' => 'SSL/TLS-Zertifikate',
    'view.buttonWebAppFirewall' => 'Web Application Firewall',
    'view.buttonBackup' => 'Backup und Wiederherstellen',
    'view.buttonBackupHint' => 'Sichern Sie Domains, inklusive Einstellungen und Website-Content, und stellen Sie sie wieder her.',
    'view.buttonHosting' => 'Hosting',
    'view.buttonHostingDesc' => 'Hosting-Einstellungen und Zugriff auf Webhosting',
    'view.buttonEmailAddresses' => 'E-Mail-Konten',
    'view.buttonMailSettings' => 'E-Mail-Einstellungen',
    'view.buttonMailLists' => 'Mailinglisten',
    'view.buttonOutgoingSpamSettings' => 'Ausgehende Nachrichten begrenzen',
    'view.buttonPhpSettings' => 'PHP',
    'view.buttonPhpSettingsVersion' => 'Version',
    'view.buttonWebServerSettingsUnix' => 'Apache und nginx',
    'view.buttonWebServerSettingsWindows' => 'IIS-Einstellungen',
    'view.buttonProtectedDirectories' => 'Passwortgeschützte Verzeichnisse',
    'view.buttonSheduledTasks' => 'Geplante Aufgaben',
    'view.buttonSheduledTasksHint' => 'Erstellen und verwalten Sie geplante Aufgaben.',
    'view.buttonDatabases' => 'Datenbanken',
    'view.buttonDatabasesHint' => 'Erstellen und entfernen Sie Datenbanken, die von Ihren Websites verwendet werden, und verwalten Sie sie über die integrierte administrative Webanwendung.',
    'view.buttonLogs' => 'Protokolle',
    'view.buttonLogsDescProblem' => 'Probleme erkannt',
    'view.buttonFailedRequests' => 'Ablaufverfolgung für Anforderungsfehler',
    'view.buttonHotlinkProtection' => 'Hotlink-Schutz',
    'view.buttonVirtualFolder' => 'Virtuelle Verzeichnisse',
    'view.buttonBandwidthLimiting' => 'Bandbreitenbegrenzung',
    'view.buttonWebUsers' => 'Webbenutzer',
    'view.buttonOdbcDataSources' => 'ODBC-Datenquellen',
    'view.buttonAspNetSettings' => 'ASP.NET-Einstellungen',
    'view.buttonCustomerIisAppPool' => 'Dedizierter IIS-Anwendungspool für Ihr Konto',
    'view.buttonCustomerIisAppPoolHint' => 'Dedizierter IIS-Anwendungspool für Ihr Konto einrichten, der alle Websites, die auf Ihrem Konto gehostet werden',
    'view.buttonIssAppPool' => 'Dedizierter IIS-Anwendungspool für die Website',
    'view.buttonSiteCopy' => 'Website kopieren',
    'view.buttonWebDeploy' => 'Web Deploy Veröffentlichungseinstellungen',
    'view.buttonSubscriptions' => 'Webspace',
    'view.buttonSubscriptionsHint' => 'Lassen Sie Webspaces anzeigen und verwalten Sie sie.',
    'view.buttonOutgoingMailControl' => 'Postausgangskontrolle',
    'view.buttonOutgoingMailControlHint' => 'Lassen Sie ausgehende E-Mails anzeigen und verwalten Sie sie.',
    'view.buttonInstallApsApplication' => 'Weitere Anwendungen',
    'view.buttonFilesUpload' => 'Dateien hochladen',
    'view.forceUpdateApplicationsNotification' => 'Jetzt können Ihre Anwendungen automatisch aktualisiert werden. Verwenden Sie diese Einstellung mit Vorsicht, denn Updates können die Funktionalität der Apps signifikant beeinträchtigen. Beispielsweise kann es vorkommen, dass App-Erweiterungen mit der Folgeversion einer App nicht mehr funktionieren. %%link%%.',
    'view.forceUpdateAllApplicationsNotificationLink' => 'Automatische Updates für alle Anwendungen einschalten',
    'view.unnotifiedApplicationsUpdatesMessage' => 'Es sind Updates für folgende Anwendungen verfügbar:',
    'view.updatedAutomaticallyApplicationsMessage' => 'Folgende Anwendungen wurden automatisch aktualisiert:',
    'view.activeStateComponentsWarning' => 'Sie haben ActivePython- bzw. ActivePerl-Komponenten auf Ihrem Server installiert. Plesk verfügt für diese Produkte von ActiveState über keine Lizenzen mehr. Um Verstöße gegen die Lizenzvereinbarung zu vermeiden, %%link%%.',
    'view.activeStateComponentsWarningLink' => 'treffen Sie entsprechende Maßnahmen',
    'view.toSecurePasswordsGoTo' => 'Zur Verbesserung der Sicherheit von Plesk empfehlen wir, den erweiterten Sicherheitsmodus auf dieser %%link%% einzuschalten.',
    'view.securePasswords' => 'Seite',
    'view.upgradeDnsSyncSkip' => 'Beachten Sie, dass nach dem Upgrade alle bestehenden DNS-Zonen als vom Nutzer modifiziert gelten. Dies bedeutet, dass Sie Änderungen am DNS-Template nur dann auf solche Zonen anwenden können, wenn Sie die Option \'Änderungen für alle Zonen übernehmen\' während der %%link%% auswählen. %%learnMoreLink%%',
    'view.serverDns' => 'Synchronisierung',
    'view.learnMore' => 'Weiterlesen',
    'view.backEncryptionRequired' => 'Aus Sicherheitsgründen empfehlen wir, die Daten, die in den Backups enthalten sind, zu schützen. Bitte gehen Sie zu %%link%% und aktualisieren Sie die Einstellungen zur Backupsicherheit.',
    'view.backupSettingPage' => 'Backup-Einstellungen',
    'view.subscriptionNotExist' => 'Das Abonnement existiert nicht',
    'view.phpHandlerOutdated' => '(Überholt)',
    'view.updatesAvailable' => 'Updates sind verfügbar',
    'view.apsInstall' => 'Installieren',
    'view.apsApplicationInstall' => '%%app%% installieren',
    'view.apsInstallAll' => 'Alle installieren',
    'view.apsChangelog' => 'Änderungslog',
    'view.apsApplicationChangelog' => '%%app%% Änderungsprotokoll',
    'view.apsInstances' => '%%total%% Installationen',
    'view.loading' => 'Lade...',
    'view.close' => 'Schließen',
    'view.viewMore' => '%%number%% weitere Updates ansehen',
    'view.unableGetChangelog' => 'Das Changelog kann nicht abgerufen werden. Bitte aktualisieren Sie die Seite und versuchen Sie es erneut.',

    'web-server-settings.titleUnix' => 'Einstellungen für Apache & nginx für %%domainName%%',
    'web-server-settings.titleWindows' => 'IIS-Einstellungen für %%domainName%%',
    'web-server-settings.updatedSuccessfully' => 'Die Einstellungen wurden aktualisiert.',

    'setup.title' => 'Websites & Domains',
    'setup.noDomainTitle' => 'Alles bereit für Ihre erste Website',
    'setup.description' => 'Fügen Sie eine neue Domain hinzu, um mit dem Erstellen Ihrer Website zu beginnen.',
    'setup.openTutorial' => 'Falls Sie Unterstützung benötigen, lesen Sie unsere %%link%%.',
    'setup.openTutorialLink' => 'Anleitung zur Website-Erstellung',
    'setup.addDomain' => 'Domain hinzufügen',
];