<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Jika situs Anda di-host pada alamat IP khusus (tidak berbagi dengan pengguna atau situs lainnya), maka Anda dapat membuat direktori di dalam situs tersebut yang memungkinkan pengguna lain mengunggah atau mengunduh file secara anonim melalui FTP. Setelah FTP anonim dihidupkan, pengguna dapat log masuk ke direktori pada alamat seperti ftp://ftp.your-domain.com dengan menggunakan nama pengguna "anonymous" dan kata sandi apa pun.',
    'anonymous-ftp.displayLogin' => 'Tampilkan pesan log masuk',
    'anonymous-ftp.loginText' => 'Teks pesan',
    'anonymous-ftp.incomingDir' => 'Izinkan mengunggah ke direktori masuk',
    'anonymous-ftp.incomingSubDir' => 'Izinkan membuat direktori di dalam direktori masuk',
    'anonymous-ftp.incomingReadable' => 'Izinkan mengunduh dari direktori masuk',
    'anonymous-ftp.quota' => 'Batasi ruang disk di dalam direktori masuk',
    'anonymous-ftp.maxConnections' => 'Batasi jumlah koneksi simultan',
    'anonymous-ftp.bandwidth' => 'Batasi lebar pita unduh untuk domain FTP virtual ini',
    'anonymous-ftp.unlimited' => 'Tidak terbatas',

    'aps.catalog.loading' => 'Memuat...',
    'aps.catalog.searchName' => 'Aplikasi',
    'aps.catalog.searchVendor' => 'Vendor',
    'aps.catalog.searchPackager' => 'Pengemas',
    'aps.catalog.searchLicenseType' => 'Tipe lisensi',
    'aps.catalog.searchLicenseTypeAny' => 'Apa saja',
    'aps.catalog.searchLicenseTypeFreeware' => 'Gratis',
    'aps.catalog.searchLicenseTypeCommercial' => 'Komersial',
    'aps.catalog.showSearch' => 'Tunjukkan Pencarian',
    'aps.catalog.hideSearch' => 'Sembunyikan Pencarian',
    'aps.catalog.buttonSearch' => 'Cari',
    'aps.catalog.buttonResetSearch' => 'Atur Ulang Pencarian',
    'aps.catalog.showCategories' => 'Pilih kategori di bawah atau cari aplikasi menggunakan kotak pencarian',
    'aps.catalog.searchResults' => 'Hasil pencarian',
    'aps.catalog.buttonInstall' => 'Pasang',
    'aps.catalog.buttonInstallTooltip' => 'Pasang versi terakhir dari aplikasi dengan cepat dengan parameter default optimal.',
    'aps.catalog.buttonAdvancedInstall' => 'Pasang (Suai)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Pasang versi terakhir dari aplikasi, dengan mengubahsuaikan semua parameter.',
    'aps.catalog.buttonInstallOldVersion' => 'Versi Pasang',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Pasang versi terakhir dari aplikasi terpilih, dengan mengubahsuaikan semua parameter.',
    'aps.catalog.buttonInstallDescription' => 'Pasang aplikasi pada situs jika Anda telah memiliki kode aktivasi, atau jika Anda ingin mencobanya terlebih dahulu.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Pasang aplikasi gratis ini di situs.',
    'aps.catalog.version' => 'Versi',
    'aps.catalog.moreVersions' => 'Versi lainnya',
    'aps.catalog.release' => 'Rilis',
    'aps.catalog.overview' => 'Tinjauan',
    'aps.catalog.noApplicationsInCategory' => 'Tidak ada aplikasi yang tersedia pada kategori ini. Pilih kategori yang lain.',
    'aps.catalog.noCategoriesSelected' => 'Pilih kategori untuk mencari seluruh aplikasi yang tersedia pada kategori ini.',
    'aps.catalog.noSearchResults' => 'Pencarian Anda tidak sesuai dengan aplikasi apa pun.',
    'aps.catalog.connectionFailed' => 'Gagal menghubung ke Katalog Aplikasi. %%retryLink%%.',
    'aps.catalog.retry' => 'Coba lagi',
    'aps.catalog.categoriesError' => 'Daftar kategori yang tidak dapat dimuat pada saat ini.',
    'aps.catalog.applicationsError' => 'Daftar aplikasi yang tidak dapat dimuat pada saat ini.',
    'aps.catalog.detailsError' => 'Perincian aplikasi tidak dapat dimuat pada saat ini.',
    'aps.catalog.searchError' => 'Hasil pencarian tidak dapat dimuat pada saat ini.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Rilis %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Riwayat perubahan',
    'aps.catalog.officialApplicationSite' => 'Informasi Vendor',
    'aps.catalog.returnToCategories' => '<< Kembali ke daftar aplikasi',
    'aps.catalog.buttonUninstall' => 'Hapus',
    'aps.catalog.gotoHome' => 'Beranda',
    'aps.catalog.all' => 'Semua',
    'aps.catalog.buttonDetails' => 'Pelajari lebih jauh',
    'aps.catalog.buttonBuy' => 'Beli sekarang',
    'aps.catalog.buttonBuyTooltip' => 'Beli aplikasi',
    'aps.catalog.buttonBuyDescription' => 'Kunjungi toko kami untuk membeli kode aktivasi aplikasi.',
    'aps.catalog.buttonDownload' => 'Unduh',
    'aps.catalog.buttonDownloadDescription' => 'Unduh aplikasi jika Anda telah memiliki kode aktivasi, atau jika Anda ingin mencobanya terlebih dahulu.',
    'aps.catalog.marketplaceMoreInfo' => 'Kunjungi %%link%% untuk informasi lebih lanjut.',
    'aps.catalog.marketplaceMoreInfoLink' => 'situs web vendor aplikasi',

    'aps.configure.installedAt' => "Terpasang di",
    'aps.configure.otherSettings' => "Lainnya",
    'aps.configure.globalSettings' => 'Pengaturan paket',
    'aps.configure.passwordConfirmation' => 'Konfirmasi kata sandi',
    'aps.configure.databaseParams' => 'Parameter basis data',
    'aps.configure.noInstallationUrlAvailable' => 'Tidak ada (aplikasi eksternal)',
    'aps.configure.updateSettingsSection' => 'Perbarui Pengaturan',
    'aps.configure.forceUpdates' => 'Perbarui aplikasi ini secara otomatis jika pembaruan telah tersedia',
    'aps.configure.forceUpdatesHint' => 'Aplikasi akan menerima pembaruan otomatis ke versi yang lebih baru. Peringatan: Gunakan opsi ini dengan hati-hati, karena pembaruan dapat berpengaruh secara signifikan terhadap fungsionalitas aplikasi. Sebagai contoh, ekstensi aplikasi dapat berhenti berfungsi jika menggunakan versi aplikasi yang berbeda.',

    'aps.install.showAllSettings' => 'Tunjukkan Seluruh Pengaturan',
    'aps.install.showLessSettings' => 'Tunjukkan Pengaturan Minimum',
    'aps.install.install' => 'Pasang',
    'aps.install.otherSettings' => 'Pengaturan lainnya',
    'aps.install.globalSettings' => 'Pengaturan paket',
    'aps.install.passwordConfirmation' => 'Konfirmasi kata sandi',
    'aps.install.provisionsSectionLabel' => 'Jalur pemasangan',
    'aps.install.context' => 'Tetapkan lokasi di mana Anda akan memasang aplikasi web ini',
    'aps.install.registerAsWebmailSection' => 'Registrasi webmail',
    'aps.install.registerAsWebmailDescription' => "Anda direkomendasikan untuk memilih opsi ini jika aplikasi adalah klien webmail. Opsi ini akan menjadikan aplikasi muncul di antara layanan webmail yang tersedia dalam pengaturan Surel langganan dan paket layanan. Administrator dapat mengonfigurasi URL akses publik webmail di Pengelolaan Server > Pengaturan > Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Daftarkan sebagai layanan webmail',
    'aps.install.addItem' => 'Tambah',
    'aps.install.removeItem' => 'Hapus',
    'aps.install.updateSettingsSection' => 'Perbarui Pengaturan',
    'aps.install.forceUpdates' => 'Perbarui aplikasi ini secara otomatis jika pembaruan telah tersedia',
    'aps.install.forceUpdatesHint' => 'Aplikasi akan menerima pembaruan otomatis ke versi yang lebih baru. Peringatan: Gunakan opsi ini dengan hati-hati, karena pembaruan dapat berpengaruh secara signifikan terhadap fungsionalitas aplikasi. Sebagai contoh, ekstensi aplikasi dapat berhenti berfungsi jika menggunakan versi aplikasi yang berbeda.',

    'aps.invalid-requirements.requirementsLegend' => 'Persyaratan',
    'aps.invalid-requirements.domainLegend' => 'Situs web',
    'aps.invalid-requirements.context' => 'Pilih situs web yang lain',
    'aps.invalid-requirements.backToApplicationList' => 'Kembali ke daftar aplikasi',

    'aps.license.title' => 'Pemasangan %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Agar dapat memasang aplikasi ini, Anda harus membaca isi perjanjian lisensi pengguna akhir dan menyetujui persyaratannya.',
    'aps.license.licenseAgree' => 'Saya menyetujui persyaratan Perjanjian Lisensi',

    'aps.services-list-customization.settings' => 'Pengaturan',

    'asp-dot-net.change-version.title' => 'Memilih Versi ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'Versi kerangka kerja ASP.NET',
    'asp-dot-net.change-version.success' => 'Versi ASP.NET telah diubah.',

    'asp-dot-net.settings.casSettingsSection' => "Keamanan akses kode",
    'asp-dot-net.settings.clientScriptsSection' => "Pengaturan pustaka skrip",
    'asp-dot-net.settings.connStringsSection' => "Pengelola Untai Koneksi",
    'asp-dot-net.settings.customErrorsSection' => "Pengaturan galat suai",
    'asp-dot-net.settings.frameworkVersionSection' => "Versi kerangka kerja",
    'asp-dot-net.settings.globalizationSection' => "Pengaturan globalisasi",
    'asp-dot-net.settings.otherSection' => "Pengaturan sesi",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Kompilasi dan pencarian galat",
    'asp-dot-net.settings.authMode' => "Mode Autentikasi",
    'asp-dot-net.settings.connStrings' => "Untai koneksi",
    'asp-dot-net.settings.connStringsInvalid' => "Beberapa bidang kosong atau berisi nilai yang tidak tepat.",
    'asp-dot-net.settings.connStringName' => "Nama",
    'asp-dot-net.settings.connStringValue' => "Parameter Koneksi",
    'asp-dot-net.settings.connStringsDescription' => "Nama/Parameter Koneksi",
    'asp-dot-net.settings.culture' => "Budaya",
    'asp-dot-net.settings.customErrMode' => "Mode galat suai",
    'asp-dot-net.settings.customErrorRedirect' => "Alihkan URL",
    'asp-dot-net.settings.customErrorStatus' => "Kode Status",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Kode status harus bilangan bulat.",
    'asp-dot-net.settings.customErrors' => "Galat suai",
    'asp-dot-net.settings.customErrorsDescription' => "Kode Status/URL Pengalihan",
    'asp-dot-net.settings.customErrorsInvalid' => "Beberapa bidang kosong atau berisi nilai yang tidak tepat.",
    'asp-dot-net.settings.debugMode' => "HIdupkan debugging",
    'asp-dot-net.settings.defLanguage' => "Bahasa halaman web default",
    'asp-dot-net.settings.tempDirectory' => "Direktori sementara",
    'asp-dot-net.settings.fileEnc' => "Penyandian file",
    'asp-dot-net.settings.fileEncInvalid' => "Nilai yang ditetapkan untuk parameter penyandian File tidak valid.",
    'asp-dot-net.settings.pathToLib' => "Jalur ke pustaka skrip Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Pasang",
    'asp-dot-net.settings.reqEnc' => "Penyandian permintaan",
    'asp-dot-net.settings.reqEncInvalid' => "Nilai yang ditetapkan untuk parameter penyandian Permintaan tidak valid.",
    'asp-dot-net.settings.resEnc' => "Penyandian respons",
    'asp-dot-net.settings.resEncInvalid' => "Nilai yang ditetapkan untuk parameter penyandian Respons tidak valid.",
    'asp-dot-net.settings.sessTimeout' => "Waktu habis sesi (menit)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Nilai yang ditetapkan untuk parameter penyandian waktu habis Sesi tidak valid. Masukkan bilangan bulat positif kurang dari atau sama dengan %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Nama string koneksi sudah digunakan.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Kode status harus di antara 100 dan 999",
    'asp-dot-net.settings.customErrorDuplicate' => "Kode status sudah digunakan.",
    'asp-dot-net.settings.trustLevel' => "Level kepercayaan CAS",
    'asp-dot-net.settings.uiCulture' => "Kultur UI",
    'asp-dot-net.settings.version' => "Versi",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Izinkan penggantian level kepercayaan CAS di situs web',
    'asp-dot-net.settings.updateSuccess' => 'Pembaruan berhasil',

    'database.clone.formDescription' => 'Salin isi basis data ke basis data yang baru atau yang sudah ada. Saat menyalin ke basis data yang sudah ada, tabel dari basis data sumber ditambahkan ke daftar tabel dalam basis data tujuan. Peringatan: Jika nama tabel sama, maka tabel dari sumber akan menggantikan tabel yang ada di basis data tujuan.',
    'database.clone.copyData' => 'Buat salinan lengkap',
    'database.clone.copyDataHint' => 'Jika dipilih, seluruh basis data (termasuk struktur dan data) akan disalin. Jika kosong, hanya struktur tabel yang akan disalin.',
    'database.clone.server' => 'Server basis data tujuan',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Lainnya...',
    'database.clone.database' => 'Basis data tujuan',
    'database.clone.newDatabase' => 'Buat basis data dengan nama',
    'database.clone.existingDatabase' => 'Salin ke basis data yang sudah ada',
    'database.clone.externalDbHost' => 'Nama host atau alamat IP',
    'database.clone.externalDbLogin' => 'Nama pengguna',
    'database.clone.externalDbPassword' => 'Kata sandi',
    'database.clone.subscription' => 'Langganan tujuan',
    'database.clone.subscription_powerUser' => 'Webspace tujuan',
    'database.clone.cloneInProgress' => 'Membuat klon basis data %%source%% ke basis data %%destination%%. Anda akan diberi tahu tentang kemajuannya melalui surel (%%email%%).',
    'database.clone.unableToClone' => 'Tidak dapat menyalin basis data: %%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Tidak dapat membuat basis data "%%destination%%" pada server yang ditetapkan.',
    'database.clone.databaseCloned' => 'Basis data "%%source%%" telah disalin.',
    'database.clone.emailSubjSuccess' => 'Basis data "%%sourceDatabase%%" telah disalin.',
    'database.clone.emailSubjFailure' => 'Gagal menyalin basis data "%%sourceDatabase%%".',
    'database.clone.emailBodySuccess' => 'Basis data "%%sourceDatabase%%" (%%sourceHost%%) telah disalin ke basis data "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Tidak dapat menyalin basis data "%%sourceDatabase%%" (%%sourceHost%%) ke basis data "%%destDatabase%%" (%%destHost%%). Prosedur penyalinan gagal.',
    'database.clone.localServer' => 'Server lokal',

    'database.repair-orphaned.formDescription' => 'Pengguna ini kehilangan induk setelah proses pemulihan. Harap sediakan kata sandi untuk pengguna ini untuk memecahkan masalah ini. Jika pengguna ini seharusnya pengguna sys tanpa kata sandi, jalankan utilitas perbaikan dengan mengosongkan bidang kata sandi.',
    'database.repair-orphaned.login' => 'Nama pengguna basis data',
    'database.repair-orphaned.pass' => 'Kata sandi',
    'database.repair-orphaned.pass2' => 'Konfirmasi kata sandi',
    'database.repair-orphaned.users' => 'Beberapa pengguna membutuhkan perhatian Anda. Terdapat beberapa pengguna tanpa induk yang harus diperbaiki agar dapat berfungsi dengan benar.',
    'database.repair-orphaned.orphaned' => 'Pengguna tidak memiliki induk. %%gui begin:link%%Perbaiki sekarang%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Perbaiki',

    'database.repair.fixSelected' => 'Perbaiki Pilihan',
    'database.repair.fix' => 'Perbaiki',

    'database.user.password' => 'Kata Sandi',
    'database.user.passwordConfirmation' => 'Konfirmasi kata sandi',
    'database.user.server' => 'Server basis data',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Basis data',
    'database.user.anyDatabase' => 'Apa saja',
    'database.user.dataAccess' => 'Akses Data',
    'database.user.structureAccess' => 'Akses Struktur',
    'database.user.globalAccess' => 'Hak Istimewa Global',
    'database.user.globalAccessHint' => 'Hak istimewa global berfungsi untuk seluruh basis data dalam akun hosting ini.',
    'database.user.aclRadio' => 'Kontrol akses',
    'database.user.aclLocalhost' => 'Izinkan koneksi lokal saja',
    'database.user.aclAny' => 'Izinkan koneksi jauh dari host mana pun',
    'database.user.aclCustom' => 'Izinkan koneksi jauh dari',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nHost yang ditentukan diizinkan untuk mengakses basis data mewakili pengguna ini.",
    'database.user.remoteAccess' => 'Akses jauh',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nAlamat IP yang ditentukan diizinkan untuk mengakses server basis data melalui peraturan firewall. Perubahan Anda dalam daftar ini akan dimoderasi terlebih dahulu oleh penyedia hosting Anda.",
    'database.user.example' => "Sebagai contoh:\n%%example%%",
    'database.user.denied' => 'Gunakan ketentuan firewall sistem',
    'database.user.allowed' => 'Izinkan koneksi jauh dari',
    'database.user.default' => 'Gunakan informasi akses pengguna ini secara default untuk mengakses %%webadmin%%',
    'database.user.remoteAccessHint' => 'Silakan hubungi penyedia hosting Anda dan pastikan opsi yang telah Anda tetapkan sesuai dengan ketentuan firewall saat ini untuk akses masuk ke MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Admin Web',
    'database.user.role' => 'Peran',
    'database.user.roleReadWrite' => 'Baca dan Tulis',
    'database.user.roleWriteOnly' => 'Tulis Saja',
    'database.user.roleReadOnly' => 'Baca Saja',
    'database.user.roleCustom' => 'Suai',

    'database.generalSection' => 'Umum',
    'database.name' => 'Nama basis data',
    'database.server' => 'Server basis data',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Situs terkait',
    'database.noDomainRelations' => 'Tidak ada situs terkait',
    'database.userSection' => 'Pengguna',
    'database.userSectionDescription' => 'Buat pengguna basis data default. Plesk akan mengakses basis data mewakili pengguna ini. Jika pengguna basis data belum ditetapkan, maka basis data tersebut tidak dapat diakses.',
    'database.createUser' => 'Buat pengguna basis data',
    'database.username' => 'Nama pengguna basis data',
    'database.password' => 'Kata Sandi',
    'database.passwordConfirmation' => 'Konfirmasi kata sandi',
    'database.allDbAccess' => 'Pengguna memiliki akses ke semua basis data dalam langganan terpilih',
    'database.aclRadio' => 'Kontrol akses',
    'database.aclLocalhost' => 'Izinkan koneksi lokal saja',
    'database.aclAny' => 'Izinkan koneksi jauh dari host mana pun',
    'database.aclCustom' => 'Izinkan koneksi jauh dari',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nHost yang ditentukan diizinkan untuk mengakses basis data mewakili pengguna ini.",
    'database.remoteAccess' => 'Akses jauh',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nAlamat IP yang ditentukan diizinkan untuk mengakses server basis data melalui peraturan firewall. Perubahan Anda dalam daftar ini akan dimoderasi terlebih dahulu oleh penyedia hosting Anda.",
    'database.example' => "Sebagai contoh:\n%%example%%",
    'database.denied' => 'Gunakan ketentuan firewall sistem',
    'database.allowed' => 'Izinkan koneksi jauh dari',

    'deployment-section.deploymentDisabledHint' => 'Mengunggah berkas dari repositori Git',
    'deployment-section.deploymentEnabledHint' => 'Aktifkan dukungan Git',
    'deployment-section.deploymentSectionLegend' => 'Berkas Anda untuk Disalin ke Hosting',
    'deployment-section.deploymentSectionDescriptionHint' => 'Jika Anda membiarkan dukungan Git dinonaktifkan, direktori root (root situs web/aplikasi dan root dokumen) akan dibuat kosong, dan situs akan menampilkan halaman default di dalam peramban. Anda akan perlu mengunggah berkas-berkas situs Anda ke root dokumen menggunakan FTP atau File Manager. Dengan cara lain, aktifkan Git sekarang atau nanti (dalam Situs Web & Domain) dan unggah berkas dari repositori Git.',

    'dns-zone.add-acl-record.description' => 'Tambah alamat IP server DNS untuk mengizinkan menerima salinan zona DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'Alamat IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'Alamat/masker IP',

    'dns-zone.record.add-title' => "Tambah catatan sumber daya ke template zona",
    'dns-zone.record.add-ns-title' => "Tambah nameserver",
    'dns-zone.record.edit-title' => "Sunting catatan sumber",
    'dns-zone.record.edit-success' => "Catatan DNS diperbarui.",
    'dns-zone.record.add-success' => "Catatan DNS dibuat.",
    'dns-zone.record.type' => "Jenis catatan",
    'dns-zone.record.domainName' => "Nama domain",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Server nama",
    'dns-zone.record.protocol' => "Protokol",
    'dns-zone.record.priority' => "Prioritas",
    'dns-zone.record.priorityLow' => "rendah (%%priority%%)",
    'dns-zone.record.priorityHigh' => "sangat tinggi (%%priority%%)",
    'dns-zone.record.weightLow' => "rendah (%%weight%%)",
    'dns-zone.record.weightHigh' => "sangat tinggi (%%weight%%)",
    'dns-zone.record.ipAddress' => "Alamat IP",
    'dns-zone.record.ipAddressDescription' => "Sebagai contoh, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Sebagai contoh, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Alamat IPv6",
    'dns-zone.record.ipAddressV6Description' => "Sebagai contoh, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Sebagai contoh, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Sebagai contoh, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Sebagai contoh, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Sebagai contoh, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Nama kanonis",
    'dns-zone.record.mailDomain' => "Domain surat",
    'dns-zone.record.mxServer' => "Server pertukaran surat",
    'dns-zone.record.mxServerPriority' => "Tetapkan prioritas server pertukaran surat",
    'dns-zone.record.txtRecord' => "Catatan TXT",
    'dns-zone.record.txtRecordString' => "Masukkan untai catatan",
    'dns-zone.record.txtSpfSyntax' => "Catatan SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Nilai catatan TXT yang salah telah ditetapkan.",
    'dns-zone.record.quotedTxtRecord' => "Nilai catatan TXT harus berupa string tunggal tanpa tanda kutip.",
    'dns-zone.record.dsRecord' => "Catatan DS",
    'dns-zone.record.dsRecordDescription' => "Sebagai contoh, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "Nilai catatan DS yang salah telah ditetapkan.",
    'dns-zone.record.serviceName' => "Nama layanan",
    'dns-zone.record.serviceNameDescription' => 'Contohnya, SIP (tanpa karakter garis bawah).',
    'dns-zone.record.protocolNameDescription' => 'Contohnya, tcp (tanpa karakter garis bawah).',
    'dns-zone.record.portDescription' => 'Contohnya, 25 (tanpa karakter garis bawah).',
    'dns-zone.record.srvWeight' => "Bobot relatif untuk catatan dengan prioritas yang sama",
    'dns-zone.record.targetHost' => "Host target",
    'dns-zone.record.targetHostDescription' => "Misalnya, contoh.com",
    'dns-zone.record.targetPort' => "Port target",
    'dns-zone.record.targetPortDescription' => 'Sebagai contoh, 8443.',
    'dns-zone.record.retrieveDataError' => "Data catatan tidak ditemukan.",
    'dns-zone.record.unknownTypeError' => "Tipe catatan DNS tidak dikenal.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Tidak dapat menetapkan rekaman data NULL MX ketika rekaman data MX ada.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Tidak dapat menetapkan rekaman data non-NULL MX ketika rekaman data NULL MX ada.',
    'dns-zone.record.masterShouldBeRemote' => "Anda harus memiliki dua server nama otoritatif yang berbeda pada host yang terpisah.",
    'dns-zone.record.caaTag' => "Label",
    'dns-zone.record.caaRecord' => "Nilai",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protokol',
    'dns-zone.record.tlsaUsage' => 'Penggunaan',
    'dns-zone.record.tlsaSelector' => 'Pemilih',
    'dns-zone.record.tlsaMatching' => 'Tipe yang cocok',
    'dns-zone.record.tlsaCertData' => 'Data asosiasi sertifikat',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Lihat %%link%% untuk detail',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, bagian 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, bagian 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, bagian 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, bagian 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "alias (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'Contohnya, example.com. Nilai yang kosong berarti host sama dengan nama domain.',
    'dns-zone.record.httpsProtocols' => 'Protokol',
    'dns-zone.record.httpsProtocolsDescription' => 'Daftar protokol yang dipisahkan koma yang didukung oleh target. Contohnya, h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Hanya menggunakan protokol tertentu secara paksa. Daftar protokol di atas tidak boleh kosong.',
    'dns-zone.record.httpsIpv4hint' => 'Petunjuk alamat IPv4',
    'dns-zone.record.httpsIpv4hintDescription' => 'Daftar alamat IPv4 yang dipisahkan koma yang bisa digunakan oleh klien untuk mencapai layanan.',
    'dns-zone.record.httpsIpv6hint' => 'Petunjuk alamat IPv6',
    'dns-zone.record.httpsIpv6hintDescription' => 'Daftar alamat IPv6 yang dipisahkan koma yang bisa digunakan oleh klien untuk mencapai layanan.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Detik",
    'dns-zone.record.invalidValue' => 'Nilai tidak valid. Nilainya bisa dari 1 detik sampai 2147483647 detik.',
    'dns-zone.record.ttlDefaultValue' => 'Nilai default: %%value%% detik',
    'dns-zone.record.invalidTTL' => 'Nilai TTL yang ditetapkan tidak valid.',
    'dns-zone.record.invalidIpAddress' => 'Alamat IP yang ditetapkan tidak valid.',
    'dns-zone.record.invalidIpMaskPair' => 'Alamat IP/netmask yang ditentukan tidak valid.',
    'dns-zone.record.invalidCName' => 'Nama kanonis yang ditetapkan tidak valid.',
    'dns-zone.record.invalidPort' => 'Port yang ditentukan tidak valid.',
    'dns-zone.record.invalidTLSACertData' => 'Data asosiasi sertifikat yang ditentukan tidak valid.',
    'dns-zone.record.invalidTLSAProtocol' => 'Protokol yang ditentukan tidak valid.',
    'dns-zone.record.invalidTLSAUsage' => 'Penggunaan yang ditetapkan invalid.',
    'dns-zone.record.invalidTLSASelector' => 'Pemilih yang ditentukan invalid.',
    'dns-zone.record.invalidTLSAMatching' => 'Tipe yang cocok yang ditentukan invalid.',

    'dns-zone.restore-default.formHint' => "Di sini Anda dapat memulihkan konfigurasi zona awal yang sesuai dengan pengaturan template DNS default yang digunakan di server. Pilih alamat IP yang akan Anda gunakan untuk memulihkan zona dan tetapkan apakah alias www dibutuhkan untuk domain.",
    'dns-zone.restore-default.ipv4' => "Alamat IPv4",
    'dns-zone.restore-default.ipv4Hint' => "Sebagai contoh, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Alamat IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Sebagai contoh, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Alamat IP yang ditetapkan tidak valid.',
    'dns-zone.restore-default.customIpHint' => "Catatan dengan alamat IP ini akan dianggap sebagai modifikasi-pengguna dan tidak akan disinkronkan dengan template DNS seluruh server.",
    'dns-zone.restore-default.wwwPrefix' => "awalan www",
    'dns-zone.restore-default.previewRecords' => "Pulihkan catatan yang digunakan untuk pratinjau situs",

    'dns-zone.soa-record.soaMnameSection' => 'Server Nama Utama',
    'dns-zone.soa-record.soaMname' => 'Server Nama',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Pilih otomatis)',
    'dns-zone.soa-record.soaRecordSection' => 'Catatan SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Segarkan',
    'dns-zone.soa-record.retry' => 'Coba lagi',
    'dns-zone.soa-record.expire' => 'Kedaluwarsa',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'Alamat surel (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'Alamat email penanggung jawab zona DNS domain. Jawaban server DNS dalam merespons kueri SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Alamat surel pemilik situs web',
    'dns-zone.soa-record.rnameTypeDomain' => 'Alamat surel domain',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Hanya masukkan bagian lokal (sebelum @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Alamat surel eksternal',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Larang perubahan alamat surel RNAME per domain',
    'dns-zone.soa-record.invalidValue' => 'Nilai tidak valid. Nilainya dari 1 detik sampai 68 tahun.',
    'dns-zone.soa-record.advancedSection' => 'Fitur DNS Lanjutan',
    'dns-zone.soa-record.serialNumberFormat' => 'Gunakan format nomor seri yang direkomendasikan oleh IETF dan RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Pilih opsi jika domain Anda ada masalah dengan pemeriksaan SOA dari pendaftar. Banyak pendaftar domain memerlukan format nomor serial ini.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Gunakan Pengaturan Default',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Zona default',
    'dns-zone.soa-record.unitSeconds' => 'detik',
    'dns-zone.soa-record.unitMinutes' => 'menit',
    'dns-zone.soa-record.unitHours' => 'jam',
    'dns-zone.soa-record.unitDays' => 'hari',
    'dns-zone.soa-record.unitWeeks' => 'minggu',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Nilai Interval Penyegaran kurang dari satu jam, yang akan meningkatkan lalu-lintas server dan penggunaan sumber secara kritis.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Pengaturan nilai TTL Minimum yang lebih dari 3 jam dapat membuat domain Anda tidak dapat diakses oleh beberapa administrator domain. Direkomendasikan untuk menetapkan nilai tersebut hanya bila registrar nama domain Anda memaksa hal tersebut.',
    'dns-zone.soa-record.success' => 'Properti catatan SOA telah diperbarui.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Catatan SOA default telah dipulihkan.',

    'domain-info-section.domainName' => 'Nama domain',
    'domain-info-section.emptyDomainName' => 'Harap memberikan nama domain.',
    'domain-info-section.ipAddress' => 'Alamat IP',
    'domain-info-section.shared' => 'berbagi',
    'domain-info-section.exclusive' => 'khusus',
    'domain-info-section.ipAddressHint' => "Alamat IP host situs web adalah alamat jaringan host virtual situs web. Alamat IP ini akan digunakan untuk seluruh situs web yang dibuat di dalam langganan ini.",
    'domain-info-section.ipAddressHint_powerUser' => "Alamat IP host situs web adalah alamat jaringan host virtual situs web. Alamat IP ini akan digunakan untuk seluruh situs web yang dibuat di dalam webspace.",
    'domain-info-section.userName' => 'Nama pengguna',
    'domain-info-section.userNameHint' => 'Akun pengguna sistem terasosiasi dengan webspace, digunakan untuk mengakses berkas melalui FTP dan SSH.',
    'domain-info-section.emptyLogin' => 'Harap memberikan nama pengguna.',
    'domain-info-section.password' => 'Kata sandi',
    'domain-info-section.emptyPassword' => 'Harap memberikan kata sandi.',
    'domain-info-section.passwordConfirmation' => 'Ulang kata sandi',

    'email-address.generalTab' => 'Umum',
    'email-address.generalHint' => 'Jika akun surel ini terkait dengan pengguna tambahan (Akses ke Panel Pelanggan diaktifkan), perubahan yang Anda buat pada halaman ini akan berpengaruh pada pengaturan pengguna ini. Khususnya, jika Anda mengubah alamat surel dan kata sandi, maka nama dan kata sandi pengguna tambahan ini juga akan berubah ke nilai yang baru.',
    'email-address.redirectTab' => 'Penerusan',
    'email-address.redirectHint' => 'Menyiapkan penerusan pesan email ke satu atau beberapa alamat email.',
    'email-address.aliasesTab' => 'Alias Surel',
    'email-address.autoResponderTab' => 'Balasan Otomatis',
    'email-address.antispamTab' => 'Filter Spam',
    'email-address.autoResponderHint' => 'Atur respon otomatis untuk seluruh pesan surat yang masuk ke alamat surel Anda. Balas-otomatis standar adalah cara standar untuk memberi tahu koresponden jika Anda sedang berada di luar kantor atau sedang berlibur.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'Alamat surel',
    'email-address.externalEmail' => 'Alamat surel eksternal',
    'email-address.externalEmailHint' => 'Akan digunakan untuk mereset kata sandi Anda jika Anda kehilangan akses ke alamat surel utama.',
    'email-address.user' => 'Tetapkan kepada',
    'email-address.password' => 'Kata sandi',
    'email-address.passwordConfirmation' => 'Konfirmasi kata sandi',
    'email-address.responderEnable' => 'Hidupkan balas-otomatis',
    'email-address.responderSubject' => 'Subjek pesan balas-otomatis',
    'email-address.responderContentType' => 'Format pesan',
    'email-address.responderContentTypeHint' => 'Format teks biasa didukung oleh seluruh program klien surat, oleh karena itu, seluruh penerima surat akan melihat pesan sebagaimana Anda melihatnya. Pesan HTML akan terlihat lebih baik karena pesan HTML akan memungkinkan Anda untuk menggunakan teks terformat dengan beragam tipe font. Akan tetapi, beberapa klien surat tidak mendukung pesan HTML dan beberapa penerima surat tidak akan dapat melihat teks terformat tersebut.',
    'email-address.responderContentTypeTextPlain' => 'Teks biasa',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Penyandian',
    'email-address.responderCodepageHint' => 'Penyandian menetapkan bagaimana karakter teks ditampilkan. Penyandian yang direkomendasikan adalah UTF-8.',
    'email-address.responderReplyTo' => 'Teruskan ke',
    'email-address.responderReplyToHint' => 'Ketika respons otomatis dikirimkan, pesan asli akan diteruskan juga ke alamat surel yang ditetapkan.',
    'email-address.responderForwardAddress' => 'Teruskan ke',
    'email-address.responderForwardAddressHint' => 'Ketika respons otomatis dikirimkan, pesan asli akan diteruskan juga ke alamat surel yang ditetapkan.',
    'email-address.responderMessage' => 'Teks pesan balas-otomatis',
    'email-address.responderReplyToEqualsEmail' => 'Alamat penerusan yang ditetapkan sama dengan alamat surel ini.',
    'email-address.responderForwardAddressEqualsEmail' => 'Alamat penerusan yang ditetapkan sama dengan alamat surel ini.',
    'email-address.responderReplyLimit' => 'Kirimkan respons otomatis ke alamat surel unik tidak lebih dari (kali sehari)',
    'email-address.buttonAddResponderAttachment' => 'Tambah lampiran',
    'email-address.buttonRemoveResponderAttachment' => 'Hapus',
    'email-address.responderAttachment' => 'Lampirkan file',
    'email-address.redirectEnable' => 'Hidupkan penerusan surat',
    'email-address.redirectRemoveEnable' => 'Jangan mengirimkan salinan email penerusan ke kotak surat Plesk',
    'email-address.redirectAddress' => 'Teruskan pesan masuk ke alamat surel berikut',
    'email-address.redirectAddressHint' => 'Tetapkan alamat surel. Anda dapat mengetik setiap alamat di baris baru, atau pisahkan setiap alamat dengan spasi, koma, atau titik koma.',
    'email-address.role' => 'Peran pengguna',
    'email-address.roleHint' => 'Peran pengguna memberi pengguna hak administratif dan akses ke aplikasi yang Anda pilih untuk peran tersebut.',
    'email-address.errorRedirectAddress' => 'Anda menentukan alamat email yang tidak valid : %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Anda menentukan alamat email yang tidak valid : %value%.',
    'email-address.mailAlias' => "Alias surel",
    'email-address.mailAliasNone' => 'Tidak ada',
    'email-address.mailAliasHint' => "Alias surel adalah alamat surel alternatif yang berasosiasi dengan alamat surel utama. Seluruh surat yang dikirimkan ke alias surel akan diterima oleh alamat surel utama.",
    'email-address.buttonAddMailAlias' => 'Tambah alias surel',
    'email-address.buttonRemoveMailAlias' => 'Hapus',
    'email-address.emptyEmail' => 'Tetapkan alamat surel tujuan di mana seluruh pesan masuk akan diteruskan.',
    'email-address.emailsIsEqual' => 'Alamat email eksternal cocok dengan yang utama. Tentukan alamat email eksternal yang berbeda.',
    'email-address.emptyPassword' => 'Anda harus memberikan kata sandi.',
    'email-address.emptyPasswordConfirmation' => 'Anda harus mengonfirmasi kata sandi.',
    'email-address.emptyAlias' => "Tetapkan alias surel alamat surel ini.",
    'email-address.aliasEqualsEmail' => 'Alias surel yang ditetapkan sama dengan alamat surel.',
    'email-address.passwordHint' => 'Akan digunakan untuk mengakses kotak surat dan masuk ke Plesk (jika opsi terkait diaktifkan).',
    'email-address.cyclicRedirect' => 'Alamat surel tidak dapat diatur untuk meneruskan pesan surat ke dirinya sendiri.',
    'email-address.errorMailnameReserved' => 'Alamat surel yang diberikan telah digunakan.',
    'email-address.antivirusEnable' => 'Hidupkan perlindungan antivirus untuk alamat surel ini',
    'email-address.antivirusHint' => 'Layanan antivirus akan memblokir pesan surel yang berisi virus dan layanan juga akan mengirimkan notifikasi kepada pengirim dan penerima.',
    'email-address.antivirusSettings' => 'Pemeriksaan virus',
    'email-address.antivirusSettingOnlyIncomingMail' => 'hanya surat masuk',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'hanya surat keluar',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'surat masuk dan keluar',
    'email-address.antispamHint' => 'Layanan filter spam mendeteksi pesan spam yang dikirim ke alamat surel. Anda dapat mengatur filter spam untuk menghapus pesan spam tersebut, menandainya sebagai spam dengan mengganti subjek pesan, atau memindahkannya ke folder spam khusus yang dapat diakses oleh klien surat melalui IMAP. Filter spam menggunakan beragam tes lokal dan jaringan untuk mengidentifikasi tanda-tanda spam.',
    'email-address.antispamEnable' => 'Hidupkan filter spam untuk alamat surel ini',
    'email-address.antispamSettings' => 'Apa yang harus dilakukan pada pesan yang diklasifikasikan sebagai spam',
    'email-address.antispamSettingsMark' => 'Tandai pesan spam dengan menambahkan teks berikut pada subjek pesan',
    'email-address.antispamSettingsMarkHint' => 'Biarkan kolom ini kosong jika Anda tidak ingin menambahkan teks. Ketik _SCORE_ jika Anda akan menyertakan nilai ke subjek pesan.',
    'email-address.antispamReportTextHint' => 'Ketik teks yang akan Anda tambahkan ke badan pesan surel spam.',
    'email-address.antispamSettingsDelete' => 'Hapus seluruh pesan spam',
    'email-address.antispamSettingsDeleteHint' => 'Pesan spam akan dihapus dari kotak surat Anda.',
    'email-address.antispamSettingsMove' => 'Pindahkan spam ke folder Spam',
    'email-address.antispamSettingsMoveHint' => 'Pindahkan seluruh pesan spam ke folder bernama Spam. Folder ini dapat diakses dari program atau webmail klien surat Anda. Jika Anda menggunakan akun surat IMAP, maka Anda dapat menggunakan folder Spam untuk melatih filter spam.',
    'email-address.antispamSettingsMoveWarning' => '"Pindahkan spam ke folder Spam" tidak berfungsi kecuali Anda menonaktifkan pilihan "Jangan mengirim salinan email penerusan" di tab "Meneruskan".',
    'email-address.antispamSettingsMoveJunk' => 'Pindahkan spam ke folder “Junk E-mail”',
    'email-address.antispamSettingsMoveJunkHint' => 'Pindahkan seluruh pesan spam ke folder bernama “Junk E-mail”. Folder ini dapat diakses dari program atau webmail klien surat Anda. Jika Anda menggunakan akun surat IMAP, maka Anda dapat menggunakan folder “Junk E-mail” untuk melatih filter spam.',
    'email-address.antispamShowAdvancedSection' => 'Tampilkan Pengaturan Lanjutan',
    'email-address.antispamHideAdvancedSection' => 'Sembunyikan Pengaturan Lanjutan',
    'email-address.antispamLearnMore' => 'Pelajari cara melatih filter spam.',
    'email-address.antispamFilterScoreTitle' => 'Sensitivitas Filter',
    'email-address.antispamFilterScoreHint' => 'Filter spam akan menjalankan sejumlah test yang berbeda pada isi dan baris subjek setiap pesan. Hasilnya, setiap pesan mendapatkan nilai. Semakin tinggi nilainya, semakin besar kemungkinan pesan tersebut adalah spam. Secara default, sensitivitas filter diatur agar seluruh pesan yang mendapatkan nilai 7 atau lebih akan ditetapkan sebagai spam. Jika Anda menerima banyak pesan spam dengan pengaturan saat ini, Anda dapat mengurangi sensitivitas filter dengan menetapkan nilai yang kecil, sebagai contoh, 6. Jika Anda kehilangan surel karena filter spam Anda menganggap surel tersebut adalah sampah, cobalah untuk mengurangi sensitivitas filter dengan menaikkan nilai sensitivitas di pengaturan, sebagai contoh, 8.',
    'email-address.antispamFilterScore' => 'Sensitivitas filter spam',
    'email-address.antispamWhiteListTitle' => 'Daftar Putih',
    'email-address.antispamWhiteListHint' => 'Surel dari pengirim yang tercantum dalam daftar putih tidak akan diperiksa filter spam.',
    'email-address.antispamWhiteListField' => 'Daftar putih',
    'email-address.antispamWhiteListFieldHint' => 'Ketik nama domain, satu nama domain per baris. Alamat dapat berisi karakter wildcard "*" dan "?", sebagai contoh, *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Daftar Hitam',
    'email-address.antispamBlackListHint' => 'Surel dari pengirim yang tercantum dalam daftar hitam akan dianggap spam.',
    'email-address.antispamBlackListField' => 'Daftar hitam',
    'email-address.antispamBlackListFieldHint' => 'Ketik nama domain, satu domain per baris. Alamat dapat berisi karakter wildcard "*" dan "?", sebagai contoh, *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Bahasa Tepercaya',
    'email-address.antispamTrustedLanguagesHint' => 'Pesan surel yang ditulis dalam bahasa berikut akan selalu lolos filter.',
    'email-address.antispamTrustedLocalesTitle' => 'Bahasa Lokal Tepercaya',
    'email-address.antispamTrustedLocalesHint' => 'Pesan surel yang menggunakan kelompok daerah tertentu akan selalu lolos filter. Kelompok istilah lokal termasuk karakter-karakter yang sudah umum digunakan. Sebagai contoh, set karakter Western menyertakan penyandian untuk huruf yang digunakan dalam bahasa Inggris dan Eropa Barat.',
    'email-address.antispamTrustedNetworksTitle' => 'Jaringan Tepercaya',
    'email-address.antispamTrustedNetworksHint' => 'Relai yang di-host di jaringan tepercaya dianggap tidak berpotensi untuk dioperasikan oleh penyebar spam, dan relai tersebut bukan relai terbuka, atau proxi terbuka.',
    'email-address.antispamIpAddressesField' => 'Alamat IP',
    'email-address.antispamIpAddressesFieldHint' => 'Tetapkan alamat IP dan masker jaringan.',
    'email-address.mailBoxQuotaDomainDefault' => 'Ukuran default (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Ukuran default',
    'email-address.mailBoxOutgoingMessages' => 'Jumlah maksimum pesan surel keluar',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Default (%%domainOutgoingMessages%% pesan per jam)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Nilai suai untuk kotak surat',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'pesan',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Default',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Ukuran default',
    'email-address.mailBoxQuotaDomainSpecific' => 'Ukuran lainnya',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Ukuran kotak surat',
    'email-address.mailBoxQuotaUnlimited' => 'Tidak terbatas',
    'email-address.mailBoxLimitReached' => 'Batas jumlah kotak surat telah tercapai.',
    'email-address.postboxEnabled' => 'Kotak surat',
    'email-address.postboxEnabledYes' => 'Hidup',
    'email-address.postboxEnabledNo' => 'Mati',
    'email-address.description' => 'Deskripsi di Plesk',
    'email-address.descriptionHint' => 'Deskripsi dapat dilihat oleh siapa pun yang memiliki akses ke akun surel ini.',
    'email-address.longDescription' => 'Deskripsi yang ditentukan terlalu panjang. Tidak boleh lebih panjang dari %%max%% simbol.',
    'email-address.loginAsUser' => 'Dapat digunakan untuk masuk ke Plesk',
    'email-address.loginAsUserDescription' => '(nama pengguna: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Ukuran kotak surat tidak dapat melebihi ukuran default.',
    'email-address.endDateEnable' => 'Matikan balasan otomatis pada',

    'failed-request.enable-tracing.description' => 'Pelacakan permintaan gagal merupakan operasi yang intensif sumber daya. Pelacakan akan dihentikan secara otomatis dalam %%days%% hari. Anda dapat menghentikannya secara manual kapan pun.',
    'failed-request.enable-tracing.statusCodes' => 'Kode status',
    'failed-request.enable-tracing.statusCodesDescription' => 'Contoh: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Penyedia',

    'file-manager.show.buttonReload' => 'Muat ulang',
    'file-manager.show.buttonSave' => 'Simpan',
    'file-manager.show.buttonSaveAs' => 'Simpan Sebagai',
    'file-manager.show.buttonReset' => 'Set ulang',
    'file-manager.show.buttonTextCodeEditor' => 'Sunting di Penyunting Kode',
    'file-manager.show.buttonTextEdit' => 'Sunting di Penyunting Teks',
    'file-manager.show.buttonWysiwygEdit' => 'Sunting di Penyunting HTML',
    'file-manager.show.eolLabel' => 'Tipe pemisah baris:',
    'file-manager.show.saveAs' => 'Simpan sebagai:',
    'file-manager.show.saveCodepage' => 'Simpan di penyandian berikut:',
    'file-manager.show.loadCodepage' => 'Lihat file asli dengan menggunakan penyandian berikut:',
    'file-manager.show.loadCodepageHint' => 'Peringatan: Perubahan yang belum tersimpan akan hilang jika Anda memuat ulang file.',
    'file-manager.show.fileExists' => "File atau folder %%fileName%% sudah ada. Anda tidak dapat membuat folder atau file dengan nama yang sama.",
    'file-manager.show.popupTitle' => 'Simpan Sebagai',
    'file-manager.show.popupFilename' => 'Nama file:',

    'file-manager.permissions.filePermissions' => 'Izin file',
    'file-manager.permissions.directoryPermissions' => 'Izin direktori',
    'file-manager.permissions.buttonSubmit' => 'Simpan',
    'file-manager.permissions.buttonApply' => 'Simpan dan lanjutkan',
    'file-manager.permissions.buttonCancel' => 'Batalkan',
    'file-manager.permissions.buttonAdvanced' => 'Lanjutan',

    'file-manager.unix-file-permissions.group' => 'Kelompok',
    'file-manager.unix-file-permissions.owner' => 'Pemilik',
    'file-manager.unix-file-permissions.others' => 'Lainnya',
    'file-manager.unix-file-permissions.readMode' => 'Baca',
    'file-manager.unix-file-permissions.writeMode' => 'Tulis',
    'file-manager.unix-file-permissions.execMode' => 'Jalankan/cari',
    'file-manager.unix-file-permissions.changeRecursive' => 'Ubah izin secara berulang',

    'file-manager.windows-permissions.allow' => 'Izinkan',
    'file-manager.windows-permissions.deny' => 'Tolak',
    'file-manager.windows-permissions.inheritFromParent' => 'Izinkan pewarisan izin dari induk diteruskan ke objek ini dan seluruh objek turunan. Sertakan ini dengan entri yang dijelaskan secara eksplisit di sini',
    'file-manager.windows-permissions.replaceOnChildren' => 'Ganti entri izin di semua objek turunan dengan entri yang ditunjukkan di sini',
    'file-manager.windows-permissions.buttonAdvanced' => 'Lanjutan',
    'file-manager.windows-permissions.applyTo' => 'Terapkan pada:',
    'file-manager.windows-permissions.folderOnly' => 'Hanya folder ini',
    'file-manager.windows-permissions.subfolderOnly' => 'Hanya subfolder',
    'file-manager.windows-permissions.filesOnly' => 'Hanya file',
    'file-manager.windows-permissions.permissionsFor' => 'Izin untuk',
    'file-manager.windows-permissions.applyOnto1' => 'Hanya folder ini',
    'file-manager.windows-permissions.applyOnto2' => 'Hanya subfolder',
    'file-manager.windows-permissions.applyOnto3' => 'Folder dan subfolder ini',
    'file-manager.windows-permissions.applyOnto4' => 'Hanya file',
    'file-manager.windows-permissions.applyOnto5' => 'Folder dan file ini',
    'file-manager.windows-permissions.applyOnto6' => 'Hanya folder dan file',
    'file-manager.windows-permissions.applyOnto7' => 'Folder, subfolder, dan file ini',
    'file-manager.windows-permissions.notInherited' => '<not inherited>',

    'file-manager.editor.titleTextEditor' => 'Editor Teks',
    'file-manager.editor.titleCodeEditor' => 'Editor Kode',
    'file-manager.editor.titleCodeViewer' => 'Lihat',
    'file-manager.editor.buttonSubmit' => 'Simpan',
    'file-manager.editor.buttonApply' => 'Simpan dan lanjutkan',
    'file-manager.editor.buttonSaveAs' => 'Simpan sebagai ...',
    'file-manager.editor.buttonCancel' => 'Batalkan',
    'file-manager.editor.exitConfirmationYes' => 'Ya',
    'file-manager.editor.exitConfirmationNo' => 'Tidak',
    'file-manager.editor.fileOverwrite' => 'File sudah ada.',
    'file-manager.editor.fileOverwriteDescription' => 'File dengan nama yang sama sudah ada. Apakah Anda ingin menimpanya?',
    'file-manager.editor.exitConfirmation' => 'Apakah Anda yakin ingin menutup berkas dan membuang perubahan yang belum disimpan?',
    'file-manager.editor.buttonCodeEditor' => 'Sunting di Penyunting Kode',
    'file-manager.editor.buttonTextEditor' => 'Sunting di Penyunting Teks',
    'file-manager.editor.buttonHtmlEditor' => 'Sunting di Penyunting HTML',

    'file-manager.import-file.buttonSubmit' => 'Impor',
    'file-manager.import-file.fieldUrl' => 'URL untuk file',
    'file-manager.import-file.fieldUrlDescription' => 'Tentukan URL sumber, contohnya, 
\'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Pola URL lengkapnya adalah sebagai berikut:
\'https://user:password@example.com/example.tgz\'. Nama pengguna dan kata sandi adalah opsional. Protokol yang didukung adalah http, https, ftp, ftps. Gunakan pengkodean URL untuk bagian URL yang berisi karakter atau spasi khusus.',
    'file-manager.import-file.failure' => 'Tidak dapat mengimpor file.',

    'file-manager.rotation-settings.title' => 'Pengaturan Rotasi Tempat Sampah',
    'file-manager.rotation-settings.rotationBySize' => 'Rotasi berdasarkan ukuran',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Pilihan tersebut menghapus file baru selama batas yang ditentukan untuk tong sampah terlampaui.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotasi berdasarkan tanggal',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Hari',
    'file-manager.rotation-settings.rotationByDateHint' => 'Pilihan ini menghapus file yang disimpan di tempat sampah selama lebih dari jumlah hari yang ditentukan.',
    'file-manager.rotation-settings.save' => 'Simpan',
    'file-manager.rotation-settings.cancel' => 'Batalkan',

    'ftp-user.description' => 'Jika Anda mengerjakan situs web Anda dengan orang lain atau menghost subdomain untuk pengguna yang lain, Anda harus membuat akun FTP terpisah untuk mereka.',
    'ftp-user.generalSection' => 'Umum',
    'ftp-user.login' => 'Nama akun FTP',
    'ftp-user.home' => 'Direktori beranda',
    'ftp-user.systemArea' => 'Buat akun FTP yang dapat mengakses file di luar direktori beranda',
    'ftp-user.password' => 'Kata Sandi',
    'ftp-user.passwordConfirmation' => 'Konfirmasi kata sandi',
    'ftp-user.hardQuotaSection' => 'Kuota hard disk',
    'ftp-user.hardQuota' => 'Kuota hard disk',
    'ftp-user.hardQuotaUnlimited' => 'Tidak terbatas',
    'ftp-user.permissionsSection' => 'Izin',
    'ftp-user.permissionRead' => 'Baca izin',
    'ftp-user.permissionWrite' => 'Izin menulis',
    'ftp-user.popupTitle' => 'Pilih Direktori',

    'mail-list.listName' => 'Alamat milis',
    'mail-list.enabled' => 'Dihidupkan',
    'mail-list.administratorEmail' => 'Surel administrator milis',
    'mail-list.password' => 'Kata sandi',
    'mail-list.passwordConfirmation' => 'Konfirmasi kata sandi',
    'mail-list.subscribers' => 'Pemilik langganan',
    'mail-list.subscribersHint' => 'Tetapkan alamat surel. Anda dapat mengetik setiap alamat di baris baru, atau pisahkan setiap alamat dengan spasi, koma, atau titik koma.',
    'mail-list.notify' => 'Kirimkan notifikasi kepada administrator mengenai pembuatan milis',
    'mail-list.emptyPassword' => 'Masukan kata sandi.',
    'mail-list.emptyPasswordConfirmation' => 'Harap konfirmasi kata sandi.',
    'mail-list.errorSubscribers' => 'Alamat surel tidak valid: %value%.',
    'mail-list.errorMaillistReserved' => 'Alamat milis yang ditetapkan telah digunakan.',

    'mail-settings.hint' => 'Di sini Anda dapat mengubah pengaturan layanan surat untuk domain ini.',
    'mail-settings.service' => 'Layanan surat di domain ini',
    'mail-settings.nonExist' => 'Apa yang dilakukan dengan surat untuk pengguna yang tidak ada',
    'mail-settings.nonExistBounceWithMessage' => 'Pantulkan dengan pesan',
    'mail-settings.nonExistBounce' => 'Pantulkan',
    'mail-settings.nonExistCatch' => 'Teruskan ke alamat',
    'mail-settings.nonExistCatchDescription' => 'Alamat seharusnya dimiliki oleh domain terpilih. Hanya administrator yang dapat menentukan alamat eksternal atau satu alamat untuk beberapa domain.',
    'mail-settings.nonExistExternal' => 'Alihkan ke server surat eksternal dengan alamat IP',
    'mail-settings.nonExistReject' => 'Tolak',
    'mail-settings.nonExistDiscard' => 'Tolak',
    'mail-settings.webmail' => 'Webmail',
    'mail-settings.webmailNone' => 'Tidak ada',
    'mail-settings.webmailComponentNotInstalled' => 'Komponen webmail belum terpasang.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Subdomain dengan nama %%subdomain%% sudah ada.',
    'mail-settings.webmailCertificate' => 'Sertifikat SSL/TLS untuk webmail',
    'mail-settings.webmailCertificateNone' => 'Tidak dipilih',
    'mail-settings.mailCertificate' => 'Sertifikat SSL/TLS untuk surat',
    'mail-settings.mailCertificateNone' => 'Tidak dipilih',
    'mail-settings.serverCertificateNotSelected' => 'Sertifikat ditugaskan, tetapi email untuk domain tersebut tidak diamankan. Untuk menyelesaikan pengamanan email dari domain, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'amankan server email',
    'mail-settings.mailLists' => 'Aktifkan milis',
    'mail-settings.mailAutodiscovery' => 'Aktifkan penemuan otomatis surat',
    'mail-settings.mailAutodiscoveryDescription' => 'Lihat cara kerjanya di %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'basis pengetahuan',
    'mail-settings.domainKeys' => 'Gunakan sistem perlindungan spam DKIM untuk menandai pesan surel keluar',
    'mail-settings.activeDkimSelector' => 'Pemilih DKIM Aktif',
    'mail-settings.defaultDkimSelector' => ' (Plesk Default)',
    'mail-settings.dkimSelectorName' => 'Nama Pemilih',
    'mail-settings.buttonCreateSelector' => 'Buat Pemilih DKIM Baru',
    'mail-settings.createSelectorDialogTitle' => 'Buat Pemilih DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'Menghapus Pemilih DKIM',
    'mail-settings.removeSelectorConfirmation' => "Hapus pemilih '%%selector%%' bersama dengan kode dan catatan DNS terasosiasi?",
    'mail-settings.buttonConfirm' => 'OKE',
    'mail-settings.buttonCreate' => 'Buat',
    'mail-settings.buttonCancel' => 'Batalkan',
    'mail-settings.labelRemoveSelector' => 'Hapus',
    'mail-settings.labelActiveSelector' => 'Aktif',
    'mail-settings.greyListing' => 'Hidupkan perlindungan spam greylisting untuk seluruh akun surat di bawah domain ini',
    'mail-settings.howToConfigureExternalDns' => 'Bagaimana cara mengonfigurasi DNS eksternal',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Untuk mengaktifkan penandatanganan DKIM jika Anda menggunakan server DNS eksternal, Anda perlu mengonfigurasi catatan DNS DKIM di server DNS sendiri.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Untuk melakukannya, gunakan catatan DNS DKIM di bawah ini:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Jika Anda memiliki alias domain yang Anda gunakan untuk mengirim surat, tambahkan catatan DNS DKIM juga. Gunakan catatan yang sama untuk domain utama namun dengan nama alias domain.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Untuk melihat catatan DNS DKIM yang Anda gunakan untuk mengonfigurasi, pilih kotak centang "%%option%%", terapkan dan buka pop-up ini lagi.',
    'mail-settings.mailServiceDisabled' => 'Dinonaktifkan',
    'mail-settings.mailServiceDisabledIncoming' => 'Nonaktifkan untuk surat yang masuk',
    'mail-settings.mailServiceDisabledHint' => 'Plesk tidak akan menyediakan layanan surat apa pun di domain ini.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Domain ini hanya dapat mengirim email, dan hanya menggunakan Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Diaktifkan',
    'mail-settings.mailServiceEnabledHint' => 'Domain ini dapat mengirim dan menerima email.',
    'mail-settings.mailServiceNotConfigured' => 'Tidak dikonfigurasi',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk tidak akan menyediakan layanan surat apa pun di domain ini.',
    'mail-settings.warning' => 'Ini akan secara permanen menghapus kotak surat domain dengan semua email yang diterima dan dikirim.',
    'mail-settings.show.title' => 'Hapus semua kotak surat dan email %%domain%%',
    'mail-settings.show.checkbox' => 'Hapus semua kotak surat selamanya dari <b>%%domain%%</b>, termasuk email yang diterima dan dikirim.',

    'role.roleSection' => 'Umum',
    'role.name' => 'Nama peran pengguna',
    'role.description' => 'Deskripsi',
    'role.generalPermissionsSection' => 'Akses ke layanan Plesk',
    'role.applicationsAccessSection' => 'Akses ke aplikasi',
    'role.permissionAllow' => 'Diberikan',
    'role.permissionDeny' => 'Ditolak',
    'role.emptyRoleName' => 'Silakan masukkan nama peran.',
    'role.installedAt' => 'Terpasang di',
    'role.noInstallationUrlAvailable' => 'Aplikasi eksternal',
    'role.invalidRoleName' => 'Nama peran pengguna yang ditetapkan tidak valid. Tanda tanya dan tanda petik tidak dapat digunakan dalam nama peran.',
    'role.longRoleName' => 'Nama peran pengguna yang ditetapkan terlalu panjang.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Beberapa operasi tidak tersedia karena alasan berikut: izin untuk menjalankan operasi tidak diberikan di dalam langganan terpilih, atau jumlah sumber daya yang dialokasikan tidak mencukupi untuk menjalankan operasi.',
    'role.servicesPermissionsDescription' => 'Tetapkan akses ke aplikasi terpasang atau layanan Plesk untuk seluruh pengguna dengan peran ini. Jika Anda memberikan pelanggan akses ke aplikasi, maka aplikasi tersebut akan tersedia bagi mereka dalam Panel Pelanggan.',
    'role.emailActivation' => 'Aktivasi akun peran ini melalui surel',

    'service.admin-access.adminAccess' => 'Akses administratif',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Informasi akses berikut akan digunakan untuk akses administratif ke aplikasi ini.',
    'service.admin-access.login' => 'Nama pengguna administratif',
    'service.admin-access.password' => 'Kata sandi administratif',
    'service.admin-access.passwordConfirmation' => 'Konfirmasi kata sandi',

    'service.info.service-entry-point.availableAt' => 'Tersedia di',
    'service.info.service-entry-point.customize' => 'Ubah suaikan pintasan',
    'service.info.service-entry-point.displayNameLabel' => 'Nama pintasan',
    'service.info.service-entry-point.displayNameDescription' => 'Berikan nama untuk pintasan ini. Nama pintasan akan ditampilkan di bawah ikon pintasan. Pintasan diletakkan di halaman My Services pengguna yang memiliki akses ke aplikasi ini.',
    'service.info.service-entry-point.descriptionLabel' => 'Deskripsi pintasan',
    'service.info.service-entry-point.descriptionDescription' => 'Berikan deskripsi untuk pintasan ini. Deskripsi akan ditampilkan sebagai tooltip ketika kursor mouse mengambang di atas pintasan.',
    'service.info.service-entry-point.iconLabel' => 'Klik untuk memilih ikon pintasan',
    'service.info.service-entry-point.iconCurrent' => 'Ikon saat ini',
    'service.info.service-entry-point.errorEmptyName' => 'Anda harus memberikan nama pintasan',
    'service.info.service-entry-point.errorLongName' => 'Nama pintasan harus antara 1 sampai 255 karakter.',
    'service.info.service-entry-point.errorLongDescription' => 'Panjang deskripsi pintasan harus antara 0 sampai 255 karakter.',
    'service.info.service-entry-point.hiddenLabel' => 'Sembunyikan pintasan',
    'service.info.service-entry-point.hiddenDescription' => 'Jangan menampilkan pintasan ini kepada pengguna.',

    'service.info.service-permission.assignedUser' => "Berikan akses administrator kepada pengguna ini",
    'service.info.service-permission.assignedUserNone' => 'Tidak ada pengguna yang ditunjuk',

    'shared-ssl.master-ssl.switchedOn' => 'Hidupkan SSL/TLS bersama',
    'shared-ssl.master-ssl.domainName' => 'Nama domain dari situs dengan sertifikat SSL/TLS yang akan digunakan bersama di antara situs lainnya',
    'shared-ssl.master-ssl.none' => 'Tidak ada',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'SSL/TLS bersama tidak dapat dihidupkan karena tidak ada domain dengan dukungan SSL/TLS yang diaktifkan.',

    'user.email.email' => 'Alamat surel',
    'user.email.emptyEmail' => 'Anda harus memberikan alamat surel.',
    'user.email.internalEmailHint' => 'Buat alamat surel baru di Plesk atau gunakan alamat surel eksternal.',
    'user.email.longInternalEmail' => 'Alamat surel terlalu panjang.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Bagian nama pengguna alamat surel terlalu panjang untuk server surat ini. Harap tentukan nama pengguna yang tidak lebih panjang dari %%max%% simbol.',
    'user.email.longInternalEmailFullAddressMailServer' => 'Alamat surel terlalu panjang untuk server surat ini. Harap tentukan alamat yang tidak lebih panjang dari %%max%% simbol.',
    'user.email.externalEmail' => 'Alamat surel eksternal',
    'user.email.externalEmailHint' => 'Akan digunakan untuk mereset kata sandi Anda jika Anda kehilangan akses ke alamat surel utama.',
    'user.email.emailsIsEqual' => 'Alamat surel eksternal cocok dengan yang utama. Tentukan alamat surel eksternal yang berbeda.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Harap tentukan alamat email internal dan eksternal.',

    'user.profileSection' => 'Informasi Umum',
    'user.contactName' => 'Nama kontak',
    'user.email' => 'Alamat surel',
    'user.role' => 'Peran pengguna',
    'user.accountSection' => 'Preferensi Plesk',
    'user.login' => 'Nama pengguna',
    'user.password' => 'Kata sandi',
    'user.oldPassword' => 'Kata sandi lama',
    'user.buttonBack' => 'Kembali',
    'user.generalTab' => 'Umum',
    'user.applicationsAccessSection' => 'Layanan',
    'user.generalPermissionsSection' => 'Keuntungan',
    'user.contactsTab' => 'Rincian Kontak',
    'user.passwordConfirmation' => 'Konfirmasi kata sandi',
    'user.internalEmailPasswordChanged' => 'Mengubah kata sandi juga akan mengubah kata sandi alamat email internal.',
    'user.emailName' => 'Alamat surel',
    'user.emailType' => 'Tipe surel',
    'user.companyName' => 'Nama perusahaan',
    'user.phone' => 'Nomor telepon',
    'user.imNumber' => 'Pengirim pesan instan',
    'user.fax' => 'Nomor faks',
    'user.address' => 'Alamat',
    'user.city' => 'Kota',
    'user.state' => 'Negara bagian atau propinsi',
    'user.zip' => 'Kode Pos',
    'user.country' => 'Negara',
    'user.additionalInfo' => 'Informasi tambahan',
    'user.additionalInfoHint' => 'Teks biasa saja: Seluruh tag HTML akan diabaikan.',
    'user.language' => 'Bahasa Plesk',
    'user.buttonChangePassword' => 'Ubah Kata Sandi',
    'user.permissionAllow' => 'Diberikan',
    'user.permissionDeny' => 'Ditolak',
    'user.permissionInherited' => 'Ditentukan berdasarkan peran',
    'user.emptyContactName' => 'Anda harus memberikan nama kontak.',
    'user.emptyLogin' => 'Anda harus memberikan nama pengguna.',
    'user.emptyPassword' => 'Anda harus memberikan kata sandi.',
    'user.emptyPasswordConfirmation' => 'Anda harus mengonfirmasi kata sandi.',
    'user.oldPasswordIsIncorrect' => 'Kata sandi lama salah. Silakan coba lagi.',
    'user.chooseDomainBoxTitle' => 'Pilih domain yang lain:',
    'user.userIsActive' => 'Pengguna aktif',
    'user.userIsActiveHint' => 'Pengguna aktif dapat mengakses Plesk.',
    'user.emailActivation' => 'Aktivasi akun melalui surel',
    'user.emailHint' => 'Untuk menyediakan alamat surel yang di-host di server ini kepada pengguna, pergi ke tab Surat, buat alamat surel dan asosiasikan alamat tersebut dengan pengguna ini.',
    'user.emailContactHint' => 'Hubungi penyedia layanan Anda jika Anda ingin menggunakan alamat surel yang di-host di server ini.',
    'user.personalEmailHint' => "Alamat surel pengguna ini dapat diubah di tab Surat.",
    'user.externalMailRedirectHint' => 'Penerusan hanya dapat diaktifkan untuk alamat surel yang di-host di server ini. Untuk membuat alamat surel, pergi ke tab Surat.',
    'user.externalMailRedirectHint2' => 'Penerusan hanya dapat diaktifkan untuk alamat surel yang di-host di server ini.',
    'user.externalMailAutoResponderHint' => 'Balas-otomatis hanya dapat diaktifkan untuk alamat surel yang di-host di server ini. Untuk membuat alamat surel, pergi ke tab Surat.',
    'user.externalMailAutoResponderHint2' => 'Balas-otomatis hanya dapat diaktifkan untuk alamat surel yang di-host di server ini.',
    'user.roleHint' => 'Peran pengguna memberi pengguna hak administratif dan akses ke aplikasi yang Anda pilih untuk peran tersebut.',
    'user.cannotManageMail' => "Anda tidak memiliki izin untuk mengelola pengaturan dan layanan surat.",
    'user.longCompanyName' => 'Nama perusahaan yang ditentukan terlalu panjang.',
    'user.longPhone' => 'Nomor telepon yang ditentukan terlalu panjang.',
    'user.longFax' => 'Nomor faks yang ditentukan terlalu panjang.',
    'user.longAddress' => 'Alamat yang ditentukan terlalu panjang.',
    'user.longCity' => 'Nama kota yang ditentukan terlalu panjang.',
    'user.phoneRegexNotMatch' => 'Nomor telepon yang ditentukan tidak valid.',
    'user.faxRegexNotMatch' => 'Nomor Faks yang ditetapkan tidak valid.',
    'user.shortCity' => 'Nama kota yang ditentukan terlalu pendek.',
    'user.limitSubscription' => 'Akses ke langganan',
    'user.limitSubscriptionHint' => 'Izinkan pengguna untuk mengakses langganan tertentu saja. Nilai "All" akan memberikan akses kepada seluruh langganan di dalam akun hosting Anda.',
    'user.limitSubscriptionAll' => 'Semua',
    'user.deletedSubscription' => 'Langganan yang dihapus',

    'web.add-domain-alias.title' => 'Tambah Alias Domain',
    'web.add-domain-alias.createdSuccessfully' => "Alias domain %%name%% telah dibuat.",
    'web.add-domain-alias.domainAliasName' => 'Nama alias domain',
    'web.add-domain-alias.domainAliasNameHint' => 'Misalnya, contoh.net',
    'web.add-domain-alias.forDomain' => 'untuk domain',
    'web.add-domain-alias.settingsSectionLegend' => 'Pengaturan',
    'web.add-domain-alias.settingsDns' => 'Sinkronkan zona DNS dengan domain utama',
    'web.add-domain-alias.settingsMail' => 'Layanan surat',
    'web.add-domain-alias.settingsWeb' => 'Layanan web',
    'web.add-domain-alias.settingsSeoRedirect' => 'Alihkan dengan kode HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Ketika pengunjung membuka URL alias, mereka akan diarahkan ke URL domain utama. Plesk menggunakan pengalihan HTTP 301 yang ramah mesin pencari, yang berarti peringkat mesin pencari tidak akan dipisah di antara URL.',
    'web.add-domain-alias.settingsTomcat' => 'Aplikasi web Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Domain Tidak Valid',

    'web.add-domain.formTitle' => 'Menambahkan Domain Baru',
    'web.add-domain.portalLink' => 'Portal layanan',
    'web.add-domain.domainName' => 'Nama domain',
    'web.add-domain.domainNameHint' => "Misalnya, contoh.com",
    'web.add-domain.assignToCustomer' => 'Tunjuk domain ini untuk pelanggan',
    'web.add-domain.customer' => 'Pilih pelanggan',
    'web.add-domain.createNewCustomer' => 'Buat pelanggan baru',
    'web.add-domain.selectExistingCustomer' => 'Pilih pelanggan yang ada:',
    'web.add-domain.customerContactInfoHint' => 'Masukkan informasi kontak pelanggan. Anda dapat menentukan semua informasi lain seperti nomor telepon dan alamat kemudian.',
    'web.add-domain.customerLoginInfoHint' => 'Kredensial untuk panel pelanggan',
    'web.add-domain.target' => 'Webspace',
    'web.add-domain.createNewTarget' => 'Buat langganan baru',
    'web.add-domain.createNewTarget_powerUser' => 'Buat webspace baru',
    'web.add-domain.selectExistingTarget' => 'Pilih langganan yang ada:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Pilih webspace yang ada:',
    'web.add-domain.dns' => 'Aktivasi layanan DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Aktivasi layanan surat',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Berfungsi jika pengaturan langganan memungkinkan mengelola izin email per domain. Jika tidak mengizinkan, status layanan email yang sebenarnya akan dicabut dari langganan.',
    'web.add-domain.hostingManagementOptions' => 'Tipe hosting',
    'web.add-domain.websiteHosting' => 'Hosting situs web',
    'web.add-domain.websiteForwarding' => 'Penerusan',
    'web.add-domain.websiteNoHosting' => 'Hosting tidak tersedia',
    'web.add-domain.hostingSettingsSectionLegend' => 'Pengaturan Hosting',
    'web.add-domain.domainCreatedSuccessfully' => 'Domain %%domainName%% berhasil dibuat.',
    'web.add-domain.webspaceLegend' => 'Pengaturan webspace',
    'web.add-domain.addWhmWebsiteTitle' => 'Menambahkan Situs Web Baru',
    'web.add-domain.addWhmWebsiteHint' => "Anda dapat memilih untuk meng-host situs web di server.",
    'web.add-domain.selectWhmDomain' => 'Pilih domain',
    'web.add-domain.customerLegend' => 'Info Pelanggan',
    'web.add-domain.credentials' => 'Kredensial pengguna sistem',
    'web.add-domain.credentialsHint' => 'untuk mengakses file yang dihosting melalui FTP dan SSH',
    'web.add-domain.credentialsHintWin' => 'untuk mengakses file yang dihosting melalui FTP dan RDP',
    'web.add-domain.buttonAddDomain' => 'Tambah Domain',

    'web.add-subdomain.formTitle' => 'Tambah Subdomain',
    'web.add-subdomain.formGeneralHint' => 'Subdomain adalah alamat Internet untuk bagian berbeda situs web Anda. Subdomain menggunakan nama domain utama Anda dan prefiks. Sebagai contoh, Jika nama domain Anda adalah domain.com, maka nama subdomain Anda dapat berupa store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Anda juga dapat membuat subdomain wildcard dengan memasukkan simbol * sebagai ganti nama. Pengunjung situs akan dialihkan ke subdomain ini tanpa memperhatikan nama subdomain yang dimasukkan ke peramban.',
    'web.add-subdomain.subdomainName' => 'Nama subdomain',
    'web.add-subdomain.subdomainNameHint' => 'Masukkan * untuk membuat subdomain wildcard.',
    'web.add-subdomain.forDomain' => 'Domain induk',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Subdomain telah dibuat.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Pengaturan Hosting',

    'web.settings.phpSettingsDescription' => 'Halaman ini menampilkan konfigurasi PHP untuk situs web. Pengaturan ini spesifik untuk situs web dan tidak memengaruhi situs web lain dalam langganan. Anda dapat mengubah konfigurasi PHP jika penyedia hosting memberi Anda izin yang terkait. Konfigurasi PHP suai dapat digunakan, misalnya, untuk membatasi konsumsi sumber daya sistem oleh skrip PHP, atau memenuhi persyaratan beberapa aplikasi web. Ketika Anda mengatur nilai parameter ke Default, PHP akan menggunakan nilai parameter dari konfigurasi PHP seluruh server.',
    'web.settings.phpSettingsAvailableVariables' => 'Anda dapat menggunakan penampung berikut dalam nilai parameter:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} untuk direktori root dokumen situs web. Nilai saat ini adalah %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'Direktori root dokumen HTTPS sama dengan untuk http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'Direktori root dokumen HTTPS adalah %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} untuk direktori root dokumen dari situs web primer.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} untuk direktori yang menyimpan file sementara.',
    'web.settings.phpSettingsNote' => 'Perhatian: Pengaturan di bawah bisa ditimpa oleh parameter yang ditentukan di file .htaccess, php.ini, atau .user.ini.',

    'web.change-status.changed' => 'Status situs web untuk %%domainName%% telah diganti.',

    'web.setupService.formTitle' => 'Atur layanan: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Layanan \'%%serviceReference%%\' berhasil diperbarui.',

    'web.site-copy.subdomainsGroup' => 'Subdomain %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Salin Tujuan',
    'web.site-copy.destinationType' => 'Pilih di mana file situs akan disalin',
    'web.site-copy.destinationTypeSite' => 'situs web di Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Salin file situs ke situs Anda yang lain yang juga di-host di bawah akun ini. Jika Anda memiliki akses FTP ke akun lain di server ini, gunakan opsi Penyimpanan FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Salin file situs ke situs lain yang juga di-host di server ini.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nama situs',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "File situs %%source%% tidak dapat disalin ke %%destination%% karena %%destination%% merupakan bagian dari file tersebut dan root dokumennya merupakan subdirektori root dokumen %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "File situs %%destination%% tidak dapat dihapus karena file %%source%% merupakan bagian file tersebut root dokumen %%source%% merupakan subdirektori dari %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Penyimpanan FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Salin file situs web ke akun FTP di server ini atau di server eksternal.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Salin file situs web ke akun FTP di server eksternal.',
    'web.site-copy.destinationTypeFtpHost' => "Nama host server",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Direktori',
    'web.site-copy.destinationTypeFtpUser' => 'Nama pengguna',
    'web.site-copy.destinationTypeFtpPassword' => 'Kata sandi',
    'web.site-copy.destinationTypeFtpMode' => 'Metode koneksi FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Mode aktif',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'Di mode aktif, Plesk akan mengirim alamat IP dan nomor port-nya di mana Plesk akan memantau server eksternal, dan server akan memulai koneksi TCP. Mode ini disarankan jika server yang dikelola Plesk tidak diproteksi dengan firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Mode pasif',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Mode pasif dapat digunakan jika server yang dikelola Plesk bekerja di balik firewall dan tidak dapat menerima koneksi TCP masuk.',
    'web.site-copy.existingFiles' => 'Apa yang harus dilakukan dengan file yang ada',
    'web.site-copy.existingFilesKeep' => 'Biarkan file yang ada di situs tujuan',
    'web.site-copy.existingFilesKeepDescription' => 'Timpa file yang ada dengan nama yang sama di situs tujuan.',
    'web.site-copy.existingFilesDelete' => 'Hapus seluruh file yang ada',
    'web.site-copy.existingFilesDeleteDescription' => 'Hapus seluruh file di situs tujuan sebelum menyalin.',
    'web.site-copy.emptyLogin' => 'Tetapkan nama pengguna akun FTP.',
    'web.site-copy.emptyHost' => 'Tetapkan nama host server.',
    'web.site-copy.emptyPort' => 'Tetapkan port host server.',
    'web.site-copy.copyInProgress' => 'Menyalin situs web %%sourceName%% ke %%destinationName%%. Anda akan diberi tahu tentang kemajuannya melalui surel (%%email%%).',
    'web.site-copy.unableToCopy' => 'Menyalin file situs web gagal.',
    'web.site-copy.siteCopied' => 'File situs web telah disalin.',
    'web.site-copy.emailSubjSuccess' => 'File "%%source%%" situs web telah disalin.',
    'web.site-copy.emailSubjFailure' => 'Menyalin file "%%source%%" situs web gagal.',
    'web.site-copy.emailBodySuccess' => 'File "%%source%%" situs web telah disalin ke "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Menyalin file %%source%%" situs web ke "%%destination%%" gagal: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Pengaturan Penerusan',
    'web._shared.forwardDestination' => 'Alamat tujuan',
    'web._shared.forwardDestinationHint' => 'URL situs web target.',
    'web._shared.forwardingTypeOptions' => 'Tipe penerusan',
    'web._shared.forwardingFrame' => 'Penerusan bingkai',
    'web._shared.forwardingFrameHint' => 'Alihkan pengunjung situs web ke situs lain, tetapi jangan menunjukkan alamat tujuan, agar mereka tidak tahu tentang pengalihan tersebut.',
    'web._shared.forwardingHttpCode301' => 'Dipindahkan secara permanen (kode 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Mengalihkan pengunjung situs web ke situs lain dan tunjukkan alamat tujuan kepada mereka. Pengalihan semacam itu akan menjaga peringkat mesin pencari situs.',
    'web._shared.forwardingHttpCode302' => 'Dipindahkan secara sementara (kode 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Mengalihkan pengunjung situs web ke salinan situs sementara, jika Anda tidak ingin mesin pencari mengindeks situs sementara ini.',
    'web._shared.documentRoot' => 'Root dokumen',
    'web._shared.documentRootHint' => 'Jalur ke direktori beranda situs web.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Tidak mungkin mengubah root dokumen karena terdapat aplikasi web yang terpasang di situs web ini.',
    'web._shared.ipAddress' => 'Alamat IP',
    'web._shared.shared' => 'berbagi',
    'web._shared.exclusive' => 'khusus',
    'web._shared.ipAddressHint' => "Alamat IP di mana situs web di-host adalah alamat jaringan dari host virtual situs web.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (repositori yang lain)',
    'web._shared.certificate' => 'Sertifikat',
    'web._shared.sameCertificatesHint' => 'Sertifikat yang dipilih akan digunakan untuk seluruh situs yang di-host di alamat IP khusus yang sama.',
    'web._shared.differentCertificatesHint' => 'Langganan ini terkait dengan dua alamat IP khusus dengan dua sertifikat yang berbeda. Sertifikat yang dipilih akan menggantikan sertifikat apa pun yang terpasang di situs yang di-host pada dua alamat IP ini.',
    'web._shared.differentIpTypesCertificateHint' => 'Langganan ini terkait dengan satu alamat IP bersama dan satu alamat IP khusus. Sertifikat yang dipilih juga akan digunakan untuk seluruh situs lain yang di-host pada alamat IP khusus.',
    'web._shared.certificateNotSelected' => 'Tidak dipilih',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Tidak ada sertifikat SSL/TLS di dalam repositori Anda. Untuk menambah sertifikat, pergi ke %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'halaman ini',

    'web-user.settings.allowScripts' => 'Izinkan pengguna web untuk menggunakan skrip',

    'web-user.name' => 'Nama pengguna untuk terhubung ke server melalui FTP',
    'web-user.longName' => 'Nama pengguna ini terlalu panjang (diizinkan %max% simbol maksimum).',
    'web-user.password' => 'Kata Sandi',
    'web-user.passwordConfirmation' => 'Konfirmasi kata sandi',
    'web-user.hardDiskQuota' => 'Kuota hard disk',
    'web-user.hardDiskQuotaUnlimited' => 'Tidak terbatas',
    'web-user.hardDiskQuotaIsNotSupported' => '(kuota hard disk tidak didukung karena konfigurasi sistem file server)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Kolom yang dibutuhkan',
];