<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    //===============Button conhelp================//

    'b_disabled' => 'Cette fonction n\'est pas disponible actuellement.',
    'b_disabled_by_key' => 'Cette fonction n\'est pas disponible avec votre licence.',
    'b_disabled_by_permissions' => 'Vous n\'avez pas les droits nécessaires pour procéder à des sauvegardes.',
    'b_accept' => "Vous devez accepter les conditions de cet accord de licence afin de pouvoir utiliser {$PROD_NAME}.",
    'b_action_log' => 'Configuration du journal des actions.',
    'b_add_ip' => "Ajoutez des adresses IP au pool d'adresses IP du client.",
    'b_database_server_add' => 'Ajoutez un serveur de bases de données.',
    'b_adm_skeleton' => 'Gérez le template de l\'hôte virtuel.',

    'b_auto-updates' => "Mettez à jour Plesk ou ses composants.",

    'b_codepage_change' => 'Cliquez pour modifier l\'encodage',
    'b_configure_maillists' => 'Configuration post-installation de la liste de diffusion.',
    'b_comp_info' => 'Information des composants.',
    'b_decline' => "Si vous refusez cette licence, vous ne pourrez pas utiliser {$PROD_NAME}.",
    'b_dumps_list' => 'Accédez aux fonctions de sauvegarde et de restauration et gérez le stockage des fichiers de sauvegarde.',
    'b_dumps_list_disabled' => 'Le service n\'est pas disponible actuellement, car l\'utilitaire de sauvegarde n\'était pas installé.',
    'b_add_services' => 'Page de gestion des services additionnels.',
    'b_add_ip_for_clients' => "Ajoutez un propriétaire pour cette adresse IP.",
    'b_anonymous_ftp' => 'Configurez le FTP anonyme pour ce domaine.',
    'b_attach_add' => 'Ajoutez une pièce jointe.',
    'b_attach_remove' => 'Supprimez la pièce jointe.',
    'b_backup_ok' => 'La sauvegarde s\'est bien terminée. Cliquez pour aller dans le stockage des fichiers de sauvegarde.',
    'b_restore_ok' => 'La restauration s\'est terminée. Cliquez pour aller dans le stockage des fichiers de sauvegarde.',
    'b_cancel' => 'Ignorez toutes les modifications et retournez à la page précédente.',
    'b_card' => 'Éditez le profil.',
    'b_clean_log' => 'Effacez le journal.',
    'b_cl_skeleton' => 'Gérez le template de l\'hôte virtuel.',
    'b_dashboard' => 'Allez à la page d\'accueil.',
    'b_dashboard_shortcut_remove' => 'Supprimez le raccourci de la page d\'accueil.',
    'b_domain_restore' => 'Restaurer le domaine à l\'aide de cette sauvegarde.',
    'b_domain_user' => 'Autorisez et configurez l\'accès de l\'administrateur de domaine.',
    'b_do_backup' => 'Sauvegardez le domaine. Lors de cette procédure, les fonctions de gestion des domaines dans le Panneau Client ne seront pas accessibles.',
    'b_do_upload' => 'Envoyez le dump vers le stockage.',
    'b_backup_configure' => 'Configuration du Gestionnaire de sauvegardes',
    'b_domain_alias_add' => 'Configurez un nom de domaine supplémentaire pour votre site Web.',
    'b_domain_aliases_limit_reached' => 'La limite du nombre d\'alias de domaines a été atteinte.',
    'b_create_client_back' => 'Annuler les paramètres suggérés et retourner à la page précédente.',
    'b_create_client_update' => 'Appliquez les paramètres suggérés et poursuivez avec la création du client.',
    'b_create_domain_back' => 'Annuler les paramètres suggérés et retourner à la page précédente.',
    'b_create_domain_update' => 'Confirmez les paramètres et créez le domaine.',
    'b_create_domain_client_select' => 'Sélectionnez les clients et cliquez sur OK pour créer le domaine.',
    'b_crontab_unix' => 'Gérez les tâches du planificateur.',
    'b_crontab_win' => 'Gérez les tâches du planificateur.',
    'b_crontab_unix_turn_on' => 'Cliquez pour activer la tâche programmée.',
    'b_crontab_win_turn_on' => 'Cliquez pour activer la tâche programmée.',
    'b_crontab_unix_turn_off' => 'Cliquez pour désactiver la tâche programmée.',
    'b_crontab_win_turn_off' => 'Cliquez pour désactiver la tâche programmée.',
    'b_extcert_send_file' => 'Envoyer le nouveau certificat acheté à partir du fichier indiqué.',
    'b_extras_admin' => 'Outils serveur supplémentaires.',
    'b_extras_client' => 'Outils supplémentaires pour le domaine.',
    'b_cl_ed' => "Cliquez pour modifier les informations du client.",
    'b_cl_ed_update' => "Cliquez pour mettre à jour les informations du client.",
    'b_cl_limits' => 'Affichez ou définissez les limites du compte client.',
    'b_cl_new_update' => 'Cliquez pour créer le compte client.',
    'b_cl_not_cr_dom' => 'Le client n\'est pas autorisé à créer des domaines.',
    'b_cl_on' => "Activez le compte client et tous les sites Web du client.",
    'b_cl_off' => "Suspendez le compte client et tous les sites Web du client.",
    'b_cl_permissions' => 'Affichez ou définissez les droits pour les ressources allouées au client.',
    'b_cl_pref_up_level' => "Cliquez pour retourner à la page des paramètres du client sans mettre à jour.",
    'b_default_db_user' => "Utilisez les données d'accès de l'utilisateur de base de données sélectionnés pour vous connecter à l'interface d'administration de la base de données.",
    'b_edit_tpl__add_ip' => 'Cliquer pour ajouter l\'adresse IP.',
    'b_edit_tpl__cancel_ip' => 'Cliquer pour annuler.',
    'b_icf' => 'Configurez le pare-feu.',
    'b_ip_clients__add' => 'Cliquer pour ajouter.',
    'b_ip_clients__cancel' => 'Cliquer pour annuler.',
    'b_client_templates' => 'Gestion des templates du client.',
    'b_create_login' => 'Cliquez pour créer un compte MyPlesk.com.',
    'b_skins_managment' => 'Cliquez pour gérer les Skins.',
    'b_skin_add' => 'Envoyez un nouveau thème vers Plesk.',
    'b_skin_manual' => "Ouvrez le guide de l'utilisateur sur la création de thèmes personnalisés pour Plesk.",
    'b_skin_manual_not_installed' => "Le guide de l'utilisateur expliquant comment créer des thèmes de Plesk personnalisés n'est pas installé.",
    'b_skin_download' => 'Cliquez pour télécharger un Skin.',
    'b_skin_replace' => 'Cliquez pour remplacer le Skin actuel par le nouveau.',
    'b_spamassassin' => 'Configuration du serveur SpamAssassin.',

    'b_subdom_update' => 'Cliquez pour soumettre les réglages.',
    'b_subdom_create' => 'Cliquer pour créer un sous-domaine.',
    'b_switch_user' => 'Connectez-vous sous un autre compte.',
    'b_clients' => 'Gérer les comptes client.',
    'b_client_traffic' => "Trafic chez le client.",
    'b_change_passwd' => "Cliquer pour changer le mot de passe de l'administrateur.",
    'b_change_cert_name' => 'Changez le nom du certificat.',
    'b_databases' => 'Créez et gérez les bases de données/utilisateurs.',
    'b_databases__change_server_passwd' => 'Cliquez pour aller à la page permettant de changer le mot de passe.',
    'b_directories' => 'Créez des répertoires SSL/TLS ou non-SSL/TLS protégés par mot de passe.',
    'b_db_access' => "Paramétrer les données d'accès de l'administrateur de la base de données.",
    'b_pgsql_access' => "Paramétrer les données d'accès de l'administrateur PostgreSQL.",
    'b_pgsql_not_access' => 'PostgreSQL n\'est pas installé.',
    'b_db_add' => 'Ajoutez une base de données.',
    'b_db_add__lim' => 'Vous ne pouvez pas ajouter de base de données à ce domaine : vous avez atteint le nombre maximum autorisé de bases de données.',
    'b_db_add_update' => 'Inscrire le nom de la base de données et cliquez sur ajouter.',
    'b_db_del' => 'Supprimez la base de données.',
    'b_db_admin_not_installed' => 'Webadmin n\'est pas installé. Veuillez contacter votre fournisseur de services d\'hébergement pour être aidé.',
    'b_db_no_default_user' => 'Impossible d\'accéder au Webadmin : L\'utilisateur Webadmin par défaut n\'est pas indiqué.',
    'b_db_dbserver_not_configured' => 'Impossible d\'accéder au Webadmin : le serveur de base de données n\'est pas configuré.',
    'b_db_usr_add' => 'Ajoutez un utilisateur de base de données.',
    'b_db_user_del' => 'Supprimez l\'utilisateur de la base de données.',
    'b_db_usr_update' => 'Changez le mot de passe.',
    'b_db_rm_submit' => 'Supprimez les bases de données sélectionnées.',
    'b_db_not_started' => 'Le serveur de base de données n\'a pas été mis en route',
    'b_db_not_configured' => 'Le serveur de base de données n\'est pas configuré',
    'b_db_not_installed' => 'Le serveur de base de données n\'est pas installé',
    'b_default_text' => 'Configurez le texte de notification par défaut.',
    'b_du_rm_submit' => 'Supprimez les utilisateurs de la base de données.',
    'b_dns' => 'Administrez les paramètres DNS pour le domaine.',
    'b_dns_soa_set' => 'Appliquez toutes les modifications.',
    'b_dns_acl_add' => 'Cliquez pour ajouter une adresse IP ou un masque de sous-réseau.',
    'b_dns_rec_del' => 'Supprimez cet enregistrement de la zone DNS.', //to remove
    'b_dns_rec_new' => 'Sélectionnez un nouvel enregistrement et cliquez sur ajouter.', //to remove
    'b_dnsrecord_add' => 'Cliquez pour enregistrer une nouvelle ressource dans la zone DNS.',
    'b_dns_soa' => 'Cliquez pour faire la configuration SOA',
    'b_dns_soa_default' => 'Cliquez pour restaurer la configuration SOA par défaut.',
    'b_dns_default' => 'Cliquez pour restaurer la zone DNS',

    'b_dns_master_add' => 'Ajoutez un serveur DNS principal.', //to remove
    'b_dns_new_ns' => 'Ajoutez un serveur de noms.', //to remove
    'b_dns_on' => 'Activez le service DNS local pour la zone.',
    'b_dns_off' => 'Désactivez le service DNS local pour la zone.',
    'b_dns_not_perm' => 'Vous n\'avez pas la permission de gérer les zones DNS pour ce domaine.',

    'b_dom_deact' => 'Pas disponible pour les domaines suspendus.',
    'b_dom_del' => 'Supprimez toutes les informations du domaine',
    'b_log_manager' => 'Gérez les fichiers journaux et les options de traitement des journaux.',
    'b_dom_new' => 'Cliquez pour créer un domaine.',
    'b_dom_new_no_clients' => 'Impossible de créer un domaine. Vous n\'avez pas de comptes client.',
    'b_dom_new_update' => 'Cliquez pour créer un domaine.',
    'b_dom_on' => 'Activez le domaine.',
    'b_dom_off' => 'Désactivez le domaine.',
    'b_dom_pref' => 'Configurez les paramètres d\'hébergement pour le domaine.',
    'b_dom_limits' => 'Configurer les limites du domaine.',
    'b_domain_traffic' => 'Trafic du domaine.',
    'b_dom_reg' => 'Enregistrer ce domaine.',
    'b_dom_usr_del' => 'Supprimez l\'accès de l\'utilisateur au niveau de domaine.',
    'b_doms_mng' => 'Gérez les domaines enregistrés via Plesk.',
    'b_doms_reg' => 'Déposer un nom de domaine.',
    'b_report' => 'Voir et/ou envoyer par mail le rapport.',
    'b_report_saem' => 'Envoyer le rapport des statuts à l\'adresse spécifiée.',
    'b_domains' => 'Gérez les domaines.',
    'b_domain_templates' => 'Créez, éditez et supprimez les templates de domaine',
    'b_download_log' => 'Téléchargez le fichier journal sur votre PC.',
    'b_dumps_rm_submit' => 'Cliquez pour supprimer les fichiers de sauvegarde.',
    'b_edit_adm' => 'Cliquez pour éditer le profil de l\'administrateur.',
    'b_custom_buttons' => 'Gestion de boutons personnalisés.',
    'b_custom_button_add' => 'Cliquez pour ajouter un bouton personnalisé.',
    'b_custom_buttons_rm_submit' => 'Cliquez pour supprimer les boutons personnalisés sélectionnés.',
    'b_hide_aliases' => 'Masquez les alias.',
    'b_hide_domainaliases' => 'Masquez les alias de domaines.',
    'b_hide_subdomains' => 'Masquez les sous-domaines.',
    'b_home' => 'Retourner à la page d\'accueil.',
    'b_hosting' => 'Gérez et configurez l\'hébergement web pour le domaine.',
    'b_hst_del' => 'Supprimez la configuration de l\'hébergement.',
    'b_hst_not_set' => 'L\'hébergement n\'est pas installé.',
    'b_hst_wo_ip' => 'L\'hébergement n\'est pas basé sur une IP fixe.',
    'b_hst_wo_ip_or_not_ssl' => 'L\'hébergement n\'est pas basé sur une IP ou la prise en charge SSL/TLS n\'est pas activée.',
    'b_not_phys_hst' => 'L\'hébergement n\'est pas physique.',
    'b_web_stat_not_set' => "Les statistiques Web ne sont pas conservées. Si vous voulez qu'elles le soient, allez dans les propriétés du compte d'hébergement (Domaines > Nom de domaine > Configuration > Menu Statistiques Web) puis sélectionnez le programme de statistiques dont vous avez besoin.",
    'b_white_list' => 'Gérer la liste blanche.',
    'b_white_list_add' => 'Ajoutez un domaine à la liste blanche.',
    'b_hst_sel_next' => 'Configurer le type d\'hébergement.',
    'b_hst_update' => 'Appliquez toutes les modifications.',
    'b_int_ip_del' => 'Sélect. une adresse IP dans la liste et cliquez pour l\'enlever de l\'interface.',
    'b_ip_new' => 'Cliquez pour ajouter une adresse IP.',
    'b_ip_new_virtuozzo' => 'Impossible d\'ajouter une adresse IP dans les conteneurs Virtuozzo.',
    'b_ip_new_lycos' => 'Impossible d\'ajouter une adresse IP dans Lycos.',
    'b_ip_aliasing' => 'Gérez les adresses IP sur le serveur.',
    'b_ip_del' => 'Sélectionnez les adresses IP/masques dans la liste et cliquez pour les supprimer.',
    'b_ip_rm_submit' => 'Cliquez pour supprimer les adresses IP.',
    'b_ip_cl_rm_submit' => 'Cliquez pour supprimer l\'adresse IP du pool d\'IP.',
    'b_ip_pool' => "Gestion du pool d'IP du client.",
    'b_language' => 'Configurer la langue par défaut.',
    'b_login' => 'Connectez-vous à Plesk.',
    'b_logo' => 'Personnaliser le logo situé dans la bannière principale de l\'interface.',
    'b_logo_default' => 'Cliquez pour restaurer le logo par défaut.',
    'b_logo_send_file' => 'Entrez le nouveau nom du fichier du logo et confirmez pour l\'envoyer.',
    'b_logo_send_link' => 'Entrez le lien vers le nouveau logo et cliquez pour l\'attacher.',
    'b_logo_send_logo' => 'Entrez le nouveau nom du fichier du logo et confirmez pour l\'envoyer.',
    'b_log_rm_submit' => 'Cliquez ici pour supprimer les fichiers journaux.',
    'b_ma_rm_submit' => 'Cliquez pour supprimer les alias de messagerie.',

    'b_mail' => 'Configurer les paramètres de la messagerie pour l\'ensemble du serveur.',
    'b_mail_disabled_by_admin' => 'Le service de messagerie pour ce domaine est désactivé par l\'administrateur du serveur.',

    'b_mail_resp_on' => 'Activez la réponse automatique.',
    'b_mail_resp_off' => 'Désactivez la réponse automatique.',
    'b_mail_resp_add' => 'Créez une réponse automatique.',
    'b_mail_resp_files' => 'Gérer le référentiel des pièces jointes.',
    'b_mail_resp_files_no_mailbox' => 'Cette fonction est actuellement indisponible car vous n\'avez pas configuré une boîte mail sous ce compte mail.',
    'b_mail_resp_upload' => 'Envoyez le fichier dans le répertoire des pièces jointes.',
    'b_mail_resp_attach_add' => 'Créez une pièce jointe.',

    'b_mail_names' => 'Gérez les services de messagerie : boîtes mail POP3, outils de redirection, groupes et réponses automatiques.',
    'b_mail_name_resp_attach_selected' => 'Cliquez pour joindre les fichiers sélectionnés à la réponse automatique.',

    'b_mail_on' => 'Activez les services de messagerie pour ce domaine.',
    'b_mail_off' => 'Désactivez les services de messagerie pour ce domaine.',
    'b_mail_preferences' => 'Configurez les paramètres de réception des mails pour les utilisateurs inexistants.',

    'b_mn_alias_new' => 'Ajoutez un alias de messagerie.',
    'b_mn_mail_group' => 'Gérez le groupe de messagerie.',
    'b_mn_mailbox' => 'Gérez la boîte mail.',
    'b_mn_preferences' => 'Configurez le compte mail.',
    'b_mn_responders' => 'Gérez les réponses automatiques.',
    'b_mn_resp_rm_submit' => 'Supprimez les réponses automatiques.',
    'b_mn_redir_rm_submit' => 'Supprimez les outils de redirection de mails.',
    'b_mn_redirect' => 'Gérez les outils de redirection de mails.',
    'b_mn_files_rm_submit' => 'Cliquez pour supprimer les fichiers.',
    'b_mn_attach_rm_submit' => 'Cliquez pour supprimer les pièces jointes.',
    'b_mn_groups' => 'Cliquez pour gérer les groupes de messagerie.',
    'b_mn_spamfilter_on' => 'Cliquez pour gérer le filtre anti-spam.',
    'b_mn_spamfilter_off' => 'Le filtrage de spams n\'est pas disponible pour le moment. Pour l\'activer, vous devez avoir installé le logiciel du filtre anti-spam et avoir activé la prise en charge du filtre anti-spam au niveau de l\'utilisateur sur la page Boîte mail -> Filtre anti-spam.',
    'b_mn_spamfilter_srv' => 'L\'administrateur a retiré aux utilisateurs le droit de configurer le filtre anti-spam.',

    'b_make_dump' => 'Sauvegardez le domaine.',
    'b_ftp_account_for_dumps_repository' => 'Pour pouvoir utiliser un serveur FTP distant afin d\'y stocker les sauvegardes du domaine, vous devez renseigner les propriétés du compte FTP nécessaires pour se connecter au serveur.',
    'b_cron_task_backup' => 'Éditer les préférences des tâches cron pour les sauvegardes de domaines.',

    'b_mg_mem_del' => 'Sélectionnez les membres du groupe mail à partir de la liste et cliquez sur Supprimer.',
    'b_mg_add' => 'Ajoutez le compte mail aux groupes de messagerie sélectionnés.',
    'b_mg_cancel' => 'Cliquer pour annuler.',
    'b_mg_del' => 'Enlevez le compte mail des groupes de messagerie sélectionnés.',
    'b_mg_mem_new' => 'Cliquez pour ajouter un membre du groupe de messagerie.',
    'b_mg_turn_on' => 'Cliquez pour activer le groupe de messagerie.',
    'b_mg_turn_off' => 'Cliquez pour désactiver le groupe de messagerie.',
    'b_mg_update' => 'Cliquer pour mettre à jour les changements.',
    'b_mn_rm_submit' => 'Cliquez pour supprimer les comptes mail.',
    'b_mn_webmail_on' => 'Cliquez pour ouvrir la messagerie Web.',
    'b_mn_webmail_off' => 'Cette fonction n\'est pas actuellement disponible, car la prise en charge de la messagerie Web n\'est pas activée dans les paramètres de la messagerie ou la boîte mail n\'est pas activée.',

    'b_modules_manage' => 'Gérez les modules installés dans Plesk et accédez aux fonctions fournies par ces modules.',
    'b_notifications' => 'Éditer les notifications.',
    'b_permissions' => 'Affichez ou définissez les droits du client.',
    'b_performance' => 'Gérer la performance des domaines.',
    'b_first_page' => 'Vous êtes déjà sur la première page.',
    'b_anonftp_stats' => 'Statistiques des transactions FTP anonyme.',
    'b_ftp_stats' => 'Statistiques sur les transactions du serveur FTP.',
    'b_ftp_stats_disable' => 'Les statistiques Web ne sont pas conservées ou le serveur FTP anonyme est désactivé ou l\'hébergement n\'est pas physique.',
    'b_last_page' => 'Vous êtes déjà sur la dernière page.',
    'b_next_page' => 'Allez à la page suivante.',
    'b_prs_rm_submit' => 'Cliquez pour supprimer des priorités.',
    'b_preferences' => "Configurez les préférences de l'interface.",
    'b_prev_page' => 'Allez à la page précédente.',
    'b_preview' => 'Prévisualiser le site avant la propagation DNS.',
    'b_qus_rm_submit' => 'Cliquez pour supprimer des priorités.',
    'b_repair_ip' => 'Cliquer pour ajouter l\'adresse IP.',
    'b_repair_ip_status_ok' => 'Cette adresse IP n\'a pas besoin d\'être réparée.',
    'b_reboot' => 'Redémarrer le serveur.',
    'b_refresh' => 'Actualisez les données sur l\'écran.',
    'b_key_buyonline_addons' => 'Commandez les add-ons de Plesk.',
    'b_key_buyonline_upgrades' => 'Commandez les mises à niveau de Plesk.',
    'b_key_buyonline_new' => 'Commandez une nouvelle clé de licence.',
    'b_quick_search' => 'Afficher la liste des objets répondant aux critères de recherche.',
    'b_remove_ip' => "Sélectionnez les adresses IP dans la liste et cliquez pour les supprimer du pool d'IP du client.",
    'b_restart_services' => "Gérez les services {$PROD_NAME}.",
    'b_send_passwd' => 'Cliquez pour obtenir le mot de passe par mail.',
    'b_server' => 'Configurer les paramètres pour tout le serveur.',
    'b_database_servers' => 'Gérer les serveurs de bases de données',
    'b_server_pref' => 'Paramètres du système et de l\'interface.',
    'b_sessions' => 'Gérer les sessions.',
    'b_sess_rm_submit' => 'Cliquez pour supprimer des sessions.',
    'b_set_time' => 'Configurez la date et l\'heure du système.',
    'b_set_time_virtuozzo' => 'Impossible de paramétrer la date et l\'heure dans les conteneurs Virtuozzo.',
    'b_site_apps' => 'Gestion des packs d\'applications Web.',
    'b_site_apppkgs' => 'Gestion des packs d\'applications Web.',
    'b_site_apppkgs_pool' => 'Gestion des packs d\'applications Web.',
    'b_site_apps_rm_submit' => 'Cliquez pour supprimer les applications Web sélectionnées.',
    'b_additional_key_is_active' => 'La licence est déjà active.',
    'b_additional_key_activate' => 'Cliquez pour activer la licence.',
    'b_site_builder' => 'Cliquez pour autoriser l\'intégration avec Presence Builder.',
    'b_dom_site_builder' => 'Cliquez pour ouvrir l\'assistant Presence Builder.',
    'site_builder_no_permission' => 'Vous n\'êtes pas autorisé à utiliser Mambo CMS.',
    'b_site_builder_no_package' => 'Mambo CMS n\'est pas installé.',
    'b_site_builder_no_requires' => 'Impossible d\'exécuter Mambo CMS car les pré-requis d\'hébergement ne conviennent pas.',
    'b_site_builder_no_vrt_hst' => 'L\'hébergement physique doit être configuré pour ce domaine pour que vous puissiez utiliser Mambo CMS.',
    'b_site_builder_setup' => 'Exécutez Mambo CMS (si c\'est la première fois - l\'application sera configurée)',
    'b_show_aliases' => 'Afficher les alias.',
    'b_show_domainaliases' => 'Afficher les alias de domaines.',
    'b_show_subdomains' => 'Voir les sous-domaines.',
    'b_shutdown' => 'Éteindre le serveur.',
    'b_statistics' => 'Vérifiez les statistiques du serveur.',
    'b_system_time' => 'Gérer la date et l\'heure du système.',
    'b_support' => 'Remplissez une demande d\'aide pour l\'Assistance Technique',
    'b_summary_report' => 'Cliquez pour voir le rapport récapitulatif du domaine.',
    'b_subdom_hosting' => 'Administrer et configurer l\'hébergement du sous-domaine.',
    'b_subdomains' => 'Créer et gérer les sous-domaines.',
    'b_traffic_history' => 'Affichez l\'historique du trafic.',
    'b_set_timezone' => 'Cliquez pour paramétrer le fuseau horaire.',
    'b_set_timezone_virtuozzo' => 'Impossible de paramétrer le fuseau horaire dans les conteneurs Virtuozzo.',
    'b_uninst_submit' => "Cliquez pour désinstaller {$PROD_NAME}.",
    'b_uninst_cancel' => 'Cliquer pour annuler la désinstallation.',
    'b_upload_from_ftp' => 'Cliquer pour voir la liste des sauvegardes stockées sur le serveur FTP.',
    'b_ok' => 'Appliquez toutes les modifications.',
    'b_update' => 'Appliquez toutes les modifications.',
    'b_update_db_access' => 'Enregistrez les changements apportés aux données d\'accès de la base de données.',
    'b_updtntp' => 'Activer/désactiver la synchronisation horaire avec le serveur NTP.',
    'b_updtntp_virtuozzo' => 'Impossible de synchroniser la date et l\'heure avec un serveur NTP dans les conteneurs Virtuozzo.',
    'b_updtpswd' => "Changer le mot de passe de l'administrateur.",
    'b_upload_dump' => 'Chargez un fichier dans le stockage des sauvegardes.',
    'b_no_dumps_on_ftp' => 'Le stockage distant est vide.',
    'b_web_stats' => 'Statistiques sur les transactions du serveur web.',
    'b_web_stats_disable' => 'Les statistiques web ne sont pas activées ou l\'hébergement n\'est pas physique.',
    'b_web_stats_ssl' => 'Statistiques des transactions sur le serveur web sécurisé.',
    'b_web_stats_ssl_disable' => 'Les statistiques web ne sont pas activées ou le serveur web sécurisé n\'est pas configuré ou l\'hébergement n\'est pas physique.',
    'b_web_users' => 'Configurer des utilisateurs Web pour le domaine.',
    'b_vhost_app_add' => 'Installez l\'application Web dans le domaine.',
    'b_vhost_app_add_no_domains' => 'D\'autres applications Web sont déjà installées dans les répertoires root de ces hôtes virtuels.',
    'b_interface_management' => 'Masquez ou affichez divers éléments de Plesk.',
    'b_virtualdirs' => 'Gérer les répertoires virtuels.',
    'b_virtualdir_add' => 'Ajoutez un répertoire virtuel.',
    'b_zone_switch_master' => 'Basculez vers le type de zone de DNS principal.',
    'b_zone_switch_slave' => 'Basculez vers le type de zone de DNS secondaire.',

    'b_logrotation_update' => 'Changez les paramètres de rotation des journaux.',
    'b_logrotation_on' => 'Activez la rotation des journaux.',
    'b_logrotation_off' => 'Désactivez la rotation des journaux.',

    'b_dom_tmpl_add' => 'Créez un template de domaine.',
    'b_cl_tmpl_add' => 'Créez un template de client.',
    'b_tmpl_update' => 'Mettre à jour les propriétés du template.',
    'b_tmpl_rm_subm' => 'Cliquer pour effacer le(s) template(s).',

    'b_defaultcomponents' => 'Sélection des Services Tiers.',
    'b_defaultcomponents__update' => 'Confirmer la sélection et procéder au paramétrage des services tiers.',
    'b_defaultcomponents__cancel' => 'Ignorez toutes les modifications et retournez à la page précédente.',

    'b_locale_add' => 'Cliquez pour envoyer un nouveau pack de langues.',
    'b_locales_managment' => 'Cliquez pour gérer les langues d\'interface.',

    'b_subdom_performance' => 'Gérer la performance du sous-domaine.',

    'b_anon_on' => 'Activez le FTP anonyme pour le domaine.',
    'b_anon_off' => 'Désactivez le FTP anonyme pour le domaine.',

    'b_maillists' => 'Cliquez pour gérer les listes de diffusion.',
    'b_maillist_new' => 'Cliquez pour créer la liste de diffusion.',
    'b_maillist_edit' => 'Cliquez pour accéder aux fonctions d\'administration de listes de diffusion.',
    'b_maillist_turn_on_off' => 'Cliquez pour changer le statut de la liste de diffusion.',
    'b_maillists_on' => 'Activer le service Listes de diffusion.',
    'b_maillists_off' => 'Désactivez le service de Listes de diffusion.',
    'b_maillist_off_disabled' => 'Le serveur de messagerie actuel ne prend pas en charge la désactivation de listes de diffusion.',
    'b_maillists_invert_on_off' => 'Cliquez pour changer le statut des listes de diffusion sélectionnées.',

    'b_dom_performance_edit' => 'Gérer la performance des domaines.',
    'b_dom_performance_readonly' => 'Voir les paramètres de performance des domaines.',
    'b_dom_performance_disabled' => 'Fonction non disponible s\'il n\'y a pas de QoS pour le dispositif réseau.',
    'b_subdom_performance_disabled' => 'Fonction non disponible s\'il n\'y a pas de QoS pour le dispositif réseau.',

    //=============return to up level conhelp =====================

    'b_to_admin' => "Retourner à la gestion du Help Desk.",
    'b_to_aliases' => 'Revenir à la page de gestion des alias de messagerie.',
    'b_to_autoinstaller_components' => 'Retourner à la page de sélection des composants.',
    'b_to_autoinstaller_releases' => 'Retourner à la page de sélection des releases.',
    'b_to_custom_buttons' => 'Retourner à la page de gestion des boutons personnalisés.',
    'b_to_cl_traffic' => "Revenez à la page de trafic du client.",
    'b_to_cl_templates' => "Revenez à la liste de templates du client.",
    'b_to_cl_pref' => 'Revenez aux paramètres du client.',
    'b_to_comp_info' => "Revenez à la gestion des composants de Plesk.",
    'b_to_dom_rep' => 'Retourner à la page des informations du domaine.',
    'b_to_filemanager' => 'Retour à la page de gestion des fichiers.',
    'b_to_subdomains' => 'Revenir à la liste des sous-domaines.',
    'b_to_sessions' => 'Retourner aux sessions.',
    'b_to_databases_db' => "Retour à la page des données d'accès et des outils de l'administrateur de la base de données.",
    'b_to_dumps_list' => 'Revenir au stockage de fichiers de sauvegarde du domaine.',
    'b_to_backup_manager' => 'Revenir à la page de gestion des sauvegardes.',
    'b_to_log_files' => 'Revenir à la liste des fichiers journaux.',
    'b_to_domains' => 'Retourner à la liste des domaines.',
    'to_domain_aliases' => 'Retourner à la page des alias de domaine',
    'b_to_clients' => 'Revenez à la liste des utilisateurs.',
    'b_to_client_home' => "Revenez à la page d'accueil du client.",
    'b_to_cp_access' => 'Retourner vers la gestion des restrictions d\'accès.',
    'b_to_crontab_unix' => 'Revenir à la page de gestion de Crontab.',
    'b_to_crontab_win' => 'Retournez à la page de gestion du planificateur.',
    'b_to_dns' => 'Retourner à la zone de DNS.',
    'b_to_dom_ctrl' => 'Retourner à la page d\'administration du domaine.',
    'b_to_license_management' => 'Revenir aux informations sur la licence.',
    'b_to_mail' => 'Revenez à la configuration des paramètres de messagerie valables pour l\'ensemble du serveur.',
    'b_to_maillists' => 'Revenir à la gestion des listes de diffusion.',
    'b_to_maillist_members' => 'Revenir à la gestion des membres de la liste de diffusion.',
    'b_to_mail_names' => 'Retournez à la gestion des comptes mail.',
    'b_to_mail_name_responders' => 'Revenez à la gestion des réponses automatiques.',
    'b_to_mail_name_resp_edit' => 'Revenez à l\'édition des propriétés des réponses automatiques.',
    'b_to_mail_name_resp_attach_add' => 'Retourner à la création d\'une nouvelle pièce jointe.',
    'b_to_mail_name_redirects' => 'Revenez à la gestion des outils de redirection de mails.',
    'b_to_mail_name_files' => 'Retournez au référentiel des pièces jointes du compte mail.',
    'b_to_mail_white_list' => 'Retourner à la gestion des entrées de la liste blanche.',
    'b_to_notifications' => 'Retourner à l\'édition des notifications.',
    'b_to_server' => 'Retourner à la page d\'administration du serveur.',
    'b_to_spamassassin' => 'Revenir à config. du filtre anti-spam.',
    'b_to_skins' => 'Retourner à la gestion des Skins.',
    'b_to_skin_info' => 'Retourner aux propriétés de visualisation des skins.',
    'b_to_scheduler' => 'Retour à la page de gestion du Scheduler.',
    'b_to_subdom_ctrl' => 'Retour à la page d\'administration des sous-domaines.',
    'b_to_prs' => 'Retourner aux priorités.',
    'b_to_responders' => 'Revenez à la gestion des réponses automatiques.',
    'b_to_virtualdirs' => 'Retourner à la gestion des répertoires virtuels.',
    'b_to_virtualdir_edit' => 'Revenir au répertoire virtuel précédent.',
    'b_to_virtualdir_root' => 'Revenir à la liste des répertoires virtuels.',
    'b_to_web_users' => 'Revenir à la liste des utilisateurs web.',
    'b_to_cert' => 'Retourner à la gestion du certificat.',
    'b_to_cl_rep' => "Revenir aux informations sur le client.",
    'b_to_report' => 'Retourner au rapport.',
    'b_to_report_list' => 'Retourner aux styles de rapports personnalisés.',
    'b_to_db_list' => 'Retourner à la liste des bases de données.',
    'b_to_db_usr_lst' => 'Retourner à la liste des utilisateurs de la DB.',
    'b_to_db_servers' => 'Revenir à la liste des serveurs de bases de données.',
    'b_to_dns_template' => 'Revenir à la liste des enregistrements de templates DNS.', //to remove
    'b_to_log_files_list' => 'Retour à la gestion des journaux.',
    'b_to_log_rotation' => 'Revenez aux paramètres de rotation des journaux.',
    'b_to_locales' => 'Revenez à la gestion des langues de Plesk.',
    'b_to_modules' => 'Retourner aux modules de gestion.',
    'b_to_modules_management' => 'Retourner aux modules de gestion.',
    'b_to_cl_pool' => 'Retourner à la gestion du pool d\'IP.',
    'b_to_db' => 'Retourner à la gestion de base de données.',
    'b_to_db_edit' => 'Retourner à la gestion de la DB utilisateur.',
    'b_to_dom_templates' => 'Retourner à la gestion des templates de domaine.',
    'b_to_dom_sum_report' => 'Revenez au rapport récapitulatif du domaine.',
    'b_to_statistics' => 'Retourner aux statistiques de trafic.',
    'b_to_ip_aliasing' => 'Retourner à la gestion des adresses IP.',
    'b_to_qus' => 'Retourner à la liste des files d\'attente.',
    'b_to_site_apps' => 'Retournez à la liste des applications Web.',
    'b_to_site_app_pkgs' => 'Revenir au référentiel d\'applications.',
    'b_to_siteapp_install' => 'Retournez à l\'assistant d\'installation des applications Web.',
    'b_to_siteapppackage_info' => 'Retournez aux propriétés du pack d\'applications Web.',
    'b_to_additional_key_info' => 'Retourner aux propriétés de licence.',
    'b_to_additional_key_properties' => 'Retourner aux propriétés de licence.',


    //===============Href conhelp==================//
    'b_components_choice_default' => 'Changez le composant par défaut pour cette fonctionnalité.',
    'b_components_configure' => "Réglez les paramètres de configuration pour ce composant.",


    //===============Icon conhelp==================//

    'i_db_conn_none' => 'Cette option est désactivée car votre clé de licence ne la prend pas en charge ou le service n\'est pas installé.',
    'i_db_conn_ok' => 'La connexion à la base de données est établie.',
    'i_db_conn_att' => 'Le serveur de base de données est inactif ou le mot de passe/nom d\'utilisateur est incorrect.',
    'i_db_conn_stopped' => 'La base de données n\'est pas démarrée.',
    'i_db_conn_login_failed' => 'Le nom d\'utilisateur ou le mot de passe fourni pour la base de données est incorrect.',

    'i_drweb_off' => "La vérification antivirus n'est pas activée pour le compte mail.",
    'i_drweb_any' => 'Le contrôle antivirus est activé pour les mails entrants et sortants.',
    'i_drweb_from' => 'Le contrôle antivirus est activé pour les mails sortants.',
    'i_drweb_to' => 'Le contrôle antivirus est activé pour les mails entrants.',
    'i_drweb_turn_key' => 'La licence ne prend pas en charge l\'antivirus.',
    'i_drweb_turn_perm' => 'Vous n\'avez pas les droits requis pour gérer l\'antivirus.',
    'i_drweb_turn_install' => 'L\'antivirus n\'est pas installé.',
    'i_drweb_turn_pref' => 'Cliquez pour gérer les paramètres antivirus.',

    'i_client_ok' => 'Les ressources utilisées par le client sont comprises dans les limites.',
    'i_cl_ok' => 'Les ressources utilisées par le client sont comprises dans les limites.',
    'i_cl_!' => "Les ressources utilisées par le client dépassent les limites.",
    'i_client_on' => 'Ce compte utilisateur est actif.',

    'i_client_cp_access_on' => 'L\'accès au Panneau Client est autorisé pour le client.',
    'i_client_cp_access_off' => 'L\'accès au Panneau Client n\'est pas autorisé pour le client.',
    'i_click_to_cl_cp_access_on_off' => "Cliquez pour autoriser ou interdire au client l'accès au Panneau Client.",

    'i_custom_errors_del' => 'Cliquez pour supprimer l\'élément de la liste.',
    'i_custom_errors_del_disabled' => 'Fonction pour supprimer les documents d\'erreur personnalisés par défaut du serveur pas disponible.',

    'i_open_subdomain' => 'Cliquer pour voir le site dans le navigateur Web',
    'i_open_domain' => 'Cliquer pour voir le site dans le navigateur Web',
    'i_open_domain_disabled' => 'Le domaine n\'a pas d\'hébergement configuré.',

    'i_dom_ok' => 'Les ressources utilisées par ce domaine sont comprises dans les limites allouées.',

    'i_dom_tmpl__owner_admin' => 'Ce template est créé par l\'administrateur.',
    'i_dom_tmpl__owner_client' => 'Ce template est créé par un client.',

    'i_dns_on' => 'Cette zone DNS est servie par le serveur DNS local.',
    'i_dns_off' => 'Cette zone DNS est servie par un serveur DNS externe.',
    'i_click_to_dom_on_off' => 'Cliquez pour activer/désactiver le domaine.',
    'i_click_to_cl_on_off' => "Cliquez pour activer/désactiver le compte client et tous les domaines du client.",
    'i_dom_!' => 'Les limites d\'utilisation de ressources sont dépassées par ce domaine.',
    'i_dom_on' => 'Le domaine est actif.',
    'i_dom_off' => 'Le domaine est inactif.',
    'i_dom_off_by_admin' => 'Le domaine a été suspendu par l\'administrateur.',
    'i_dom_off_by_reseller' => 'Le domaine a été suspendu par le revendeur.',
    'i_dom_off_by_client' => 'Le domaine a été suspendu par le client.',
    'i_dom_off_expired' => 'Le domaine est expiré.',
    'i_dom_off_with_parent' => "Ce compte utilisateur et les domaines de l'utilisateur ont été suspendus.",
    'i_dom_off_backup_restore' => 'Le domaine est suspendu momentanément pour cause de sauvegarde/restauration.',

    'i_locale_active_true' => 'Cette langue n\'est pas disponible pour les utilisateurs de Plesk.',
    'i_locale_active_att' => 'Cette langue n\'est pas à disposition des utilisateurs car vous dépassez le nombre limite des packs de langues autorisés.',
    'i_locale_active_false' => 'Cette langue n\'est pas à la disposition des utilisateurs.',
    'i_locale_set_active_true' => 'Cliquez sur l\'icône pour rendre la langue disponible pour les utilisateurs.',
    'i_locale_set_active_false' => 'Cliquez sur l\'icône pour rendre la langue indisponible pour les utilisateurs.',
    'i_locale_default_locale' => 'Il s\'agit de la langue par défaut, il est impossible de l\'interdire aux utilisateurs.',

    'i_log_rot_enabled' => 'Rotation des journaux activée.',
    'i_log_rot_disabled' => 'Rotation des journaux désactivée.',
    'i_log_rot_disabled_by_parent' => 'La rotation des journaux est désactivée car le site Web est désactivé.',

    'i_spamfilter_on' => 'Le filtre anti-spam est activé.',
    'i_spamfilter_off' => 'Le filtre anti-spam est désactivé.',
    'i_spamfilter_turn_srv' => 'L\'utilisation des paramètres individuels de protection conte les spams n\'est pas autorisée par la politique du serveur.',
    'i_spamfilter_turn_key' => 'SpamAssassin n\'est pas supporté par la licence actuelle.',
    'i_spamfilter_turn_component' => 'Le composant SpamAssassin n\'est pas installé.',
    'i_spamfilter_service_off' => 'Le service SpamAssassin n\'est pas opérationnel.',
    'i_spamfilter_turn_is_disabled_system_wide' => "La protection anti-spam a été désactivée par votre hébergeur.",
    'i_spamfilter_turn_permission' => 'Vous n\'avez pas le droit de gérer le filtre anti-spam.',

    'i_additional_key_free' => 'Distribué gratuitement. Aucune clé de licence requise.',
    'i_additional_key_ok' => 'La licence nécessaire est installée.',
    'i_additional_key_problem' => 'La licence nécessaire n\'est pas installée.',
    'i_additional_key_info' => 'Cliquez sur l\'icône pour accéder aux fonctions de gestion des licences.',
    'i_additional_key_download' => 'Cliquez pour télécharger la licence.',

    'i_vcard' => 'Ajouter un contact à votre carnet d\'adresses.',

    'i_autoinstaller_component_action_error' => 'Pas de mise à jour disponible.',

    'i_autoinstaller_release_action_upgrade' => 'Mise à niveau vers la nouvelle version de Plesk.',
    'i_autoinstaller_release_action_update' => 'Mettre à jour ou ajouter de nouveaux composants.',
    'i_autoinstaller_release_action_up2date' => 'Votre version correspond à la dernière mise à jour.',
    'i_autoinstaller_release_action_error' => 'Erreur lors de la récupération des informations sur la version.',

    'i_autoinstaller_component_action_install' => 'Ne pas installer',
    'i_autoinstaller_component_action_update' => 'Des mises à jour sont disponibles',
    'i_autoinstaller_component_action_upgrade' => 'Des mises à jour sont disponibles',
    'i_autoinstaller_component_action_up2date' => 'Vous avez la version la plus récente',

    'i_mail_resp_on' => 'La réponse automatique est activée.',
    'i_mail_resp_turn_off' => 'Cliquez sur cette icône pour la désactiver.',
    'i_mail_resp_off' => 'La réponse automatique est désactivée.',
    'i_mail_resp_turn_on' => 'Cliquez sur cette icône pour l\'activer.',
    'i_mail_resp_att' => 'Toutes les réponses automatiques sont désactivées pour ce compte mail.',

    'i_anonftp_on' => 'Le compte FTP anonyme du domaine est activé.',
    'i_anonftp_off' => 'Le compte FTP anonyme du domaine est désactivé.',

    'i_sapp_ssl' => 'L\'application Web est installée dans un répertoire SSL/TLS.',
    'i_sapp_non_ssl' => 'L\'application Web est installée dans un répertoire non-SSL/TLS.',
    'i_serv_drweb_up_dis' => "Démarrer le service.",
    'i_serv_none' => 'Service non installé.',
    'i_serv_not_configured' => 'Service non configuré.',
    'i_serv_on' => 'Le service est actif.',
    'i_serv_off' => 'Service inactif.',
    'i_serv_up' => 'Démarrer le service.',
    'i_serv_up_dis' => 'Le service est actif.',
    'i_serv_down' => 'Arrêter le service.',
    'i_serv_down_dis' => 'Le service est déjà arrêté.',
    'i_serv_up_n_down' => 'Redémarrer le service.',
    'i_serv_up_n_down_dis' => 'Service arrêté.',
    'i_serv_key_dsbld_not_inst' => 'Cette fonction n\'est pas disponible soit parce que votre clé de licence ne la prend pas en charge soit parce que le service n\'est pas installé ou configuré correctement.',

    'i_skin_download' => 'Cliquez pour télécharger le Skin.',

    'i_virtualdirs_read_enabled' => 'Le droit de lire le répertoire virtuel est activé.',
    'i_virtualdirs_read_disabled' => 'Le droit de lire le répertoire virtuel est désactivé.',
    'i_virtualdirs_write_enabled' => 'Le droit d\'écrire dans le répertoire virtuel est activé.',
    'i_virtualdirs_write_disabled' => 'Le droit d\'écrire dans le répertoire virtuel est désactivé.',
    'i_virtualdirs_source_enabled' => 'Le droit d\'accéder aux sources du script du répertoire virtuel est activé.',
    'i_virtualdirs_source_disabled' => 'Le droit d\'accéder aux sources du script du répertoire virtuel est désactivé.',
    'i_virtualdirs_browse_enabled' => 'Le droit de parcourir le répertoire virtuel est activé.',
    'i_virtualdirs_browse_disabled' => 'Le droit de parcourir le répertoire virtuel est désactivé.',
    'i_virtualdirs_change_status' => 'Cliquez pour activer/désactiver le droit.',

    'b_show_additional_users' => 'Développe la liste des utilisateurs/groupes d\'utilisateurs montrant les utilisateurs dont les droits ne sont pas définis.',
    'b_hide_additional_users' => 'Réduit la liste des utilisateurs/groupes d\'utilisateurs cachant les utilisateurs dont les droits ne sont pas définis.',

    'i_prtd_ssl' => 'Le répertoire SSL/TLS est protégé par un mot de passe.',
    'i_prtd_no_ssl' => 'Le répertoire SSL/TLS n\'est pas protégé par un mot de passe.',
    'i_prtd_nonssl' => 'Le répertoire Non-SSL/TLS est protégé par un mot de passe.',
    'i_prtd_no_nonssl' => 'Le répertoire Non-SSL/TLS n\'est pas protégé par un mot de passe.',
    'i_prtd_cgi_bin' => 'Le répertoire cgi-bin est protégé par un mot de passe.',
    'i_prtd_no_cgi_bin' => 'Le répertoire cgi-bin n\'est pas protégé par un mot de passe.',

    'i_htype_none' => 'L\'hébergement n\'est pas installé.',
    'i_htype_vrt_hst' => 'Hébergement physique.',
    'i_htype_frm_fwd' => 'Redirection par cadre.',
    'i_htype_std_fwd' => 'Redirection standard.',

    'i_click_to_hosting' => 'Cliquer pour configurer l\'hébergement.',

    'i_ftp_ses_domain' => 'Session de l\'administrateur de domaine',
    'i_ftp_ses_sub_domain' => 'Session de l\'utilisateur de sous-domaine',
    'i_ftp_ses_web_user' => 'Session de l\'utilisateur Web',
    'i_ftp_ses_anonymous' => 'Session de l\'utilisateur FTP anonyme.',
    'i_ftp_ses_not_plesk' => 'Utilisateur FTP non enregistré dans Plesk.',
    'i_ftp_ses_idle' => 'Inactif (pas de transaction).',
    'i_ftp_ses_upload' => 'Envoi en cours.',
    'i_ftp_ses_download' => 'Téléchargement en cours.',
    'i_ftp_ses_list' => 'Téléchargement d\'une liste de répertoires.',
    'i_ftp_ses_not_know' => 'Type d\'activité inconnue pour l\'utilisateur FTP.',


    //===============Page conhelp==================//

    'admin_ed' => 'Page du profil de l\'administrateur.',
    'anonftp' => 'Configurez les options du FTP anonyme.',
    'actionlog' => 'Gérez les paramètres du journal des actions.',
    'auto_updates' => "Mises à jour {$PROD_NAME} disponibles.",
    'autoinstaller_releases' => 'Sélectionnez le nom de la release souhaitée pour accéder à la liste des composants disponibles.',
    'autoinstaller_components' => 'Sélectionnez les composants requis et cliquez sur Installer.',
    'autoinstaller_install' => 'Veuillez confirmer l\'installation puis cliquez sur OK pour commencer.',
    'autoinstaller_configure' => 'Paramètres de l\'Updater.',
    'backup_dialog' => 'Sur cette page, vous pouvez sauvegarder le domaine. Le fichier créé peut être mis dans le dossier de fichiers de sauvegarde de votre stockage local ou distant, ou téléchargé sur votre disque local.',
    'backup_configure' => 'Page de configuration du Gestionnaire de sauvegardes.',
    'card' => 'Éditez le profil.',
    'cat_edit' => 'Page de configuration des catégories.',
    'cert' => 'Répertoire des certificats.',
    'cert_dom' => 'Répertoire des certificats.',
    'cert_add' => 'Ajoutez un certificat.',
    'cert_add_dom' => 'Ajoutez un certificat.',
    'cert_edit' => 'Page d\'édition de certificat.',
    'cl_ed' => "Éditez les données client puis cliquez sur OK.",
    'cl_home' => 'Page d\'accueil du client.',
    'cl_new' => "Entrez les informations du client et cliquez sur OK pour créer un compte client.",
    'cl_perm' => "Définissez les droits du client.",
    'cl_limits' => "Définissez les limites du client.",
    'cl_logo' => "Configurez un logo pour le Panneau Client du client.",
    'cl_pool' => 'Le panel d\'adresses IP allouées au client.',
    'cl_pool_add' => "Allocation des adresses IP au client.",
    'cl_pool_first_time' => 'Allocation des adresses IP au client.',
    'cl_pool_ctrl' => 'Voir/changer les propriétés de l\'adresse IP.',
    'cl_pref' => "Paramètres du client.",
    'cl_traffic_history' => 'Page d\'historique de trafic du client.',
    'cl_templates' => 'Cette page liste les templates du client.',
    'cl_traffic' => "Trafic du client",
    'clients' => 'Cette page liste tous les comptes clients enregistrés dans le système.',
    'component_conf' => "Configuration des paramètres des composants.",
    'custom_buttons_admin' => 'Créer et gérer vos boutons personnalisés.',
    'custom_buttons_domain' => 'Créer et gérer vos boutons personnalisés.',
    'custom_buttons_client' => 'Créer et gérer vos boutons personnalisés.',
    'custom_buttons_reseller' => 'Créer et gérer vos boutons personnalisés.',
    'custom_buttons_remove' => 'Supprimer les boutons personnalisés.',
    'custom_button_admin_edit' => 'Éditer le bouton personnalisé.',
    'custom_button_domain_edit' => 'Éditer le bouton personnalisé.',
    'custom_button_client_edit' => 'Éditer le bouton personnalisé.',
    'custom_button_reseller_edit' => 'Éditer le bouton personnalisé.',
    'configure' => 'Page de configuration de la Post-installation.',
    'comp_info' => 'Information des composants.',
    'common_acl' => 'Cette page affiche une liste de toutes les IP et adresses du réseau pour lesquelles le transfert de zone est autorisé.',
    'to_common_acl' => 'Retourner à la liste de contrôle d\'accès commune.',
    'common_acl_add' => 'Sur cette page, vous pouvez ajouter un nouvel enregistrement aux ACL communs d\'autorisations de transfert de zones.',
    'common_acl_remove' => 'Suppression des enregistrements ACL sélectionnés.',
    'cp_access' => 'Gestion de l\'accès à Plesk.',
    'cp_access_add_edit' => 'Propriétés du réseau',
    'cp_access_remove' => 'Enlever un réseau de la liste de restriction d\'accès.',
    'crontab_unix' => 'Cette page donne la liste de toutes les tâches planifiées dans le système.',
    'crontab_win' => 'Cette page donne la liste de toutes les tâches planifiées dans le système.',
    'crontab_unix_add_edit' => 'Complétez les champs requis et cliquez sur OK pour planifier la tâche.',
    'crontab_win_add_edit' => 'Complétez les champs requis et cliquez sur OK pour planifier la tâche.',
    'crontab_unix_remove' => 'Suppression des tâches sélectionnées.',
    'crontab_win_remove' => 'Suppression des tâches sélectionnées.',
    'scheduler' => 'Cette page contient la liste des tâches planifiées dans le système.',
    'scheduler_edit' => 'Complétez les champs requis et cliquez sur OK pour ajouter la tâche au Scheduler.',
    'scheduler_remove' => 'Suppression des tâches planifiées sélectionnées.',
    'b_databases_access' => 'Configurez les données d\'accès aux serveurs de bases de données externes.',
    'databases_db' =>  'Configuration de l\'accès à la base de données et utilitaires de gestion.',
    'databases_server' =>  'Cette page autorise le changement de mot de passe utilisé pour l\'accès au serveur de base de données.',
    'db' => 'Toutes les bases de données gérées par Plesk sont listées sur cette page.',
    'db_add' => 'Ajouter une nouvelle base de données.',
    'db_edit' => 'Liste des utilisateurs de la Base de données.',
    'db_usr_edit' => 'Configurer le mot de passe pour l\'utilisateur de la base de données.',
    'defaultcomponents' => 'Sélection des composants par défaut pour les services.',
    'dl_usr_ed' => "Gérer le compte de l'administrateur du domaine.",
    'dns_add' => 'Ajoutez un enregistrement pour une nouvelle zone DNS pour le domaine.',
    'dns_soa' => 'Configuration SOA.',
    'dns_check' => 'Résultat des tests sur la zone DNS.',
    'dns_rec_edit' => 'Éditer un enregistrement concernant une ressource.',
    'dns_default' => 'Restaurez la zone DNS.',
    'mail_name_drweb' => 'Configuration des paramètres antivirus.',
    'dom_ctrl' => 'Administration du domaine.',
    'dom_traffic' => 'Trafic du domaine.',
    'dom_templates' => 'Un template de domaine est un ensemble de restrictions, d\'options et de paramètres d\'hébergement spécifiques aux domaines, dont le but est de simplifier la création de domaines en permettant de les configurer automatiquement via ces templates.',
    'create_domain' => 'Saisissez un nouveau nom de domaine pour créer un domaine pour le client.',
    'create_domain_client_select' => 'Sélectionnez les clients pour lequels vous souhaitez créer le domaine.',
    'dom_pref' => 'Paramètres du domaine.',
    'dom_lim' => 'Limites du domaine.',
    'domain_report' => 'Informations du domaine.',
    'domain_aliases' => 'Gérez des alias de domaines.',
    'client_app_item_info' => 'Informations sur l\'application Web.',
    'client_report' => 'Informations sur le client.',
    'cl_rpt_list' => 'Styles de rapports personnalisés.',
    'dom_rpt_list' => 'Styles de rapports personnalisés.',
    'dom_rpt_edit' => 'Éditer le rapport.',
    'dom_sum_report' => 'Cette page affiche le rapport récapitulatif de tous les domaines servis par le système.',
    'domains' => 'Cette page affiche une liste de tous les domaines enregistrés sur le système.',
    'dumps_list' => 'Servez-vous des fonctions de sauvegarde de domaines et gérez le stockage de fichiers de sauvegarde.',
    'download_dialog' => 'Création d\'un fichier de sauvegarde.',
    'extras' => 'Page de gestion des services additionnels.',
    'edit_dom_tmpl' => 'Éditer le template du domaine sur cette page.',
    'edit_cl_tmpl' => 'Éditez un nouveau template client sur cette page.',

    'interface_templates' => 'Gestion des templates d\'interface.',
    'interface_templates_remove' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",

    'b_to_interface_templates' => 'Revenir à la liste des templates d\'interface.',
    'b_interface_template_make_default' => 'Sélectionnez un template d\'interface puis cliquez pour le définir comme template par défaut.',
    'interface_template_upload' => 'Chargez votre template d\'interface.',
    'interface_clients' => 'Liste des clients utilisant ce template d\'interface.',
    'b_to_interface_clients' => 'Revenir à la liste des clients qui utilisent ce template d\'interface.',
    'interface_clients_add' => 'Indiquer les clients qui doivent utiliser ce template d\'interface.',
    'interface_clients_remove' => 'Indiquez les clients qui ne doivent pas utiliser le template d\'interface.',

    'ftp_account' => 'Cette page vous permet d\'administrer le compte FTP du référentiel de fichiers de sauvegarde.',
    'ftp_dumps_list' => "La liste indique le contenu du stockage de fichiers de sauvegarde sur le serveur FTP. Vous pouvez sélectionner un fichier de sauvegarde pour l'envoyer dans le stockage du domaine.",

    'filemanager' => 'Gérez vos fichiers et répertoires sur cette page.',
    'filemanager_rename_file' => 'Renommer un fichier.',
    'filemanager_rename_dir' => 'Renommer un répertoire.',
    'filemanager_chmod' => 'Changer les droits d\'accès du fichier.',
    'filemanager_copy_move' => 'Copie du fichier (déplacement).',
    'filemanager_create_file' => 'Création d\'un fichier.',
    'filemanager_show' => 'Affichage du fichier.',
    'filemanager_edit' => 'Édition d\'un fichier.',
    'filemanager_remove' => 'Effacement de fichiers.',
    'filemanager_owner_row' => 'Propriétaire du fichier.',
    'filemanager_new_file' => 'Création d\'un fichier.',
    'filemanager_new_dir' => 'Création d\'un répertoire.',

    'gl_list' => 'Help Desk global.',
    'groups' => 'Gestion des groupes de messagerie.',
    'icf' => 'Configuration du pare-feu.',
    'ip_clients' => 'La liste des utilisateurs qui ont cette adresse IP dans le pool.',
    'ip_clients_add' => 'Sélectionnez les clients et cliquez sur OK pour ajouter cette adresse IP dans leurs pools.',

    'frm_fwd' => 'Inscrire l\'URL de destination pour la redirection.',
    'std_fwd' => 'Inscrire l\'URL de destination pour la redirection.',
    'performance' => 'Configuration de la performance du domaine.',
    'phosting_setup' => 'Config. compte d\'hébergement. Choisissez le type d\'adresse IP (dédiée ou partagée), le nom d\'utilisateur et mot de passe du compte FTP, et d\'autres paramètres relatifs à l\'hébergement.',
    'phosting_setup_dom_usr' => 'Config. compte d\'hébergement.',
    'webusers' => 'Cette page liste les utilisateurs web de ce domaine.',
    'hst_type_sel' => 'Sélectionner le type d\'hébergement à configurer.',
    'key_update' => 'Statut de mise à jour de la licence.',
    'key_revert' => 'Restauration de la licence.',
    'interface_management' => 'Cette page vous permet de définir quels éléments de l\'interface utilisateur seront visibles/invisibles.',
    'ip_aliasing' => 'Ajouter des adresses IP aux interfaces réseau et les en supprimer.',
    'ip_aliasing_clients' => 'Affichez la liste des utilisateurs qui ont cette adresse IP dans leurs pools d\'IP.',
    'ip_aliasing_hosting' => 'Voir les domaines hébergés ou transférés à partir de cette adresse IP',
    'ip_add' => 'Ajout d\'une adresse IP.',
    'ip_ctrl' => 'Changez les paramètres de l\'adresse IP.',
    'license' => 'Lisez le contrat de licence avec soin.',
    'logo' => 'Changer le logo et le l\'URL du logo.',
    'log_files' => 'Cette page donne la liste de tous les fichiers journaux pour ce domaine.',
    'log_rotation' => 'Paramètres de rotation des journaux.',

    'locale_upload' => 'Envoi du pack de langues.',
    'locales' => 'Gérez les langues de Plesk.',
    'locales_remove' => 'Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.',
    'mail_blocked_domains' => 'Gérez la liste noire.',

    'mail_white_list' => 'Gérer la liste blanche.',
    'mail_white_list_edit' => 'Ajouter des domaines à la liste blanche.',
    'mail_white_list_remove' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",

    'mail_name_alias_edit' => 'Créez ou éditez un alias de messagerie.',
    'mail_name_groups' => 'Gestion des membres du groupe de messagerie.',
    'mail_name_mailbox' => 'Gestion de boîtes aux lettres.',
    'mail_name_preferences' => 'Paramètres du compte mail.',
    'mail_name_redirects' => 'Gestion de l\'outil de redirection de la messagerie.',
    'mail_name_redirects_add' => 'Ajouter un membre au groupe de messagerie.',
    'mail_name_redirects_remove' => 'Supprimer des membres du groupe de messagerie.',
    'mail_name_resp_edit' => 'Configurez la réponse automatique.',
    'mail_name_resp_attach_add' => 'Sélectionner les fichiers à joindre.',
    'mail_name_resp_attach_del' => 'Supprimez les pièces jointes de la réponse automatique.',
    'mail_name_resp_remove' => 'Supprimez les réponses automatiques.',
    'mail_name_responders' => 'Gestion des réponses automatiques.',
    'mail_name_files' => 'Référentiel des pièces jointes du compte mail.',
    'mail_name_files_remove' => 'Effacement de fichiers.',
    'mail_names' => 'compte mail (boîtes mail, outils de redirection, groupes de messagerie et réponses automatiques).',
    'mail_preferences' => 'Paramètres de la messagerie.',

    'maillists' => 'Cette page affiche toutes les listes de diffusion de ce domaine.',
    'maillists_conf' => 'Page principale pour la création de listes de diffusion.',
    'maillist_edit' => 'Paramètres de la liste de diffusion.',
    'maillist_new' => 'Ajout liste de diffusion.',
    'maillist_del' => 'Suppression d\'une liste de diffusion.',

    'maillist_members' => 'Abonnés de la liste de diffusion.',
    'maillist_members_remove' => 'Suppression d\'abonnés de la liste de diffusion.',
    'maillist_member_edit' => 'Ajout de membres de la liste de diffusion.',

    'upload_module' => 'Envoi de l\'extension.',
    'modules_management' => 'Gestion des extensions.',

    'b_modules_add' => 'Ajoutez une extension.',
    'modules_manaege' => 'Ajoutez et supprimez les extensions.',
    'modules' => 'Depuis cette page, vous pouvez accéder aux fonctions fournies par les extensions installées dans votre version de Plesk.',

    'notifications' => 'Gérer le système de notification.',
    'notification_text' => 'Éditer le texte du message.',
    'pg_manage' => 'Renseigner/modifier le profil de l\'administrateur PostgreSQL.',
    'prtd_dirs' => 'Répertoires protégés par mot de passe.',
    'reboot' => 'Le système est sur le point d\'être redémarré.',
    'responders' => 'Réponses automatiques de la messagerie.',
    'redirects' => 'Outil de redirection de mails.',
    'restart_services' => 'Gestion des services.',
    'server' => 'Administration du serveur.',
    'sessions' => 'Changez les paramètres de la session.',
    'sessions_list' => 'Cette page affiche la liste de toutes les sessions.',
    'ftp_sessions_list' => 'Cette page affiche une liste de toutes les sessions FTP.',
    'cl_skeleton' => 'Gérez le template de l\'hôte virtuel.',
    'skeleton' => 'Gérez le template de l\'hôte virtuel.',
    'skins' => 'Gérez les thèmes de Plesk.',
    'skin_info' => 'Information du Skin.',
    'skin_download' => 'Téléchargement de Skin.',
    'skin_download_now' => 'Téléchargement de Skin en cours.',
    'skin_upload' => 'Envoi de Skin.',
    'skins_remove' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'shutdown' => 'Le système est en train de s\'éteindre.',
    'site_app_pkgs_add' => 'Ajoutez un pack d\'applications Web.',
    'site_app_pkgs_list' => 'Packs d\'applications Web disponibles.',
    'site_app_pkgs_instances' => 'Installations des Applications.',
    'siteapp_install' => 'Installation de l\'application Web.',
    'siteapp_reconfigure' => 'Reconfiguration de l\'application Web.',
    'sitepackage_install_config' => 'Paramètres d\'installation de l\'application Web.',
    'sitepackage_install_agreement' => 'Contrat de licence de l\'application Web.',
    'siteapp_extra_files' => 'Veuillez indiquer que faire de ces fichiers.',
    'siteapppackage_info_server' => 'Propriétés du pack d\'applications.',
    'siteapppackage_info_domain' => 'Propriétés du pack d\'applications.',

    'statistics' => 'Statistique du système.',
    'sys_time' => 'Configurer l\'heure/date système et la synchro avec le serveur NTP.',
    'subdomains' => 'Gestion des sous-domaines. Vous pouvez ajouter, éditer, supprimer des sous-domaines depuis cette page.',
    'subdom_ctrl' => 'Page d\'administration du sous-domaine.',
    'subdom_edit' => 'Configuration des propriétés de sous-domaine.',
    'subdom_create' => 'Création de sous-domaines.',
    'subdom_remove' => 'Suppression des sous-domaines sélectionnés.',
    'templates' => 'Cette page donne la liste de tous les templates de domaine qui peuvent être utilisés pour créer un nouveau domaine.',
    'view_info' => 'Sur cette page, vous pouvez consulter les propriétés du fichier de sauvegarde et restaurer cette sauvegarde.',

    'visibility_adminonly' => 'Rendre cette commande visible pour l\'administrateur uniquement.',
    'visibility_cancel' => 'Annulez la personnalisation des commandes de cet écran.',
    'visibility_control' => 'Cliquez pour personnaliser cette commande.',
    'visibility_customize' => 'Personnaliser des commandes individuelles de cet écran.',
    'visibility_default' => 'Appliquer les paramètres par défaut à cette commande.',
    'visibility_export' => 'Exportez les paramétrages faits sur cet écran sous forme d\'un script shell. Exécutez ce script sur un serveur géré par Plesk pour importer les paramètres.',
    'visibility_hide' => 'Masquez cette commande.',
    'visibility_hide_toolbar' => 'Masquez cette barre d\'outils.',
    'visibility_ok' => 'Sauvegardez les personnalisations des commandes de cet écran.',
    'visibility_reset_all' => 'Rétablir les paramètres par défaut pour toutes les commandes de tous les écrans.',
    'visibility_reset_screen' => 'Rétablir les paramètres par défaut de toutes les commandes de cet écran.',
    'visibility_show' => 'Afficher cette commande.',

    'virtualdirs' => 'Gestion des répertoires virtuels.',
    'virtualdir_create' => 'Création d\'un répertoire virtuel.',
    'virtualdir_edit' => 'Édition du répertoire virtuel.',
    'virtualdirs_remove' => 'Suppression des répertoires virtuels.',
    'web_users' => 'Gestion des utilisateurs Web du domaine.',
    'web_users_preferences' => "Paramètres de l'utilisateur Web supplémentaires.",
    'wu_edit' => 'Config. mot de passe FTP pour l\'utilisateur Web.',
    'lang' => 'Configuration de la langue de l\'interface par défaut sur cette page.',
    'ch_pass' => "Changer le mot de passe de l'administrateur sur cette page.",
    'dns_template' => 'Gestion des templates des zones DNS.', //to remove
    'dns_template_add' => 'Ajoutez un enregistrement au template de zone DNS.', //to remove

    'dns_t' => 'Cette fenêtre montre les enregistrements de ressources existants dans le template de zone DNS pour tout le serveur.',
    'dns_t_add' => 'Ajoutez un enregistrement au template de zone DNS.',
    'dns_t_soa' => 'Configuration SOA.',
    'dns_t_rec_edit' => 'Éditer un enregistrement concernant une ressource.',
    'dns_t_rec_remove' => 'Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.',
    'dns_t_default' => 'Restaurer le template de zone DNS.',
    'b_to_dns_t' => 'Revenir à la liste des enregistrements de templates DNS.',

    'web_app_add' => 'Ajoutez une application Java.',

    'qu_edit' => 'Page config. file d\'attente.',
    'qus' => 'Cette page affiche la liste des files d\'attente.',

    'remove_modules' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeServers' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeCerts' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeMailAliases' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeDataBases' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeDataBaseUsers' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeCrontabTask' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeDomains' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeDNS' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeClients' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeLogFiles' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeDumps' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeMailNames' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeWebUsers' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeSessions' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeTemplates' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeIPAddress' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'removeClientsIP' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",

    'cat_remove' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'pr_remove' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'qu_remove' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",

    'pr_edit' => 'Config. priorités',
    'prs' => 'Cette page affiche les priorités.',

    'spamassassin' => 'Config. de SpamAssassin.',
    'spamassassin_train' => 'Apprentissage des bases de données statistiques utilisées pour le filtre Bayesien. Triez le contenu de votre boîte aux lettres en spams et non-spams.',
    'spamassassin_train_view_message_source' => 'Cliquez pour voir la source du message.',
    'spamassassin_user_conf' => 'Config. Personnel de SpamAssassin.',
    'spaw' => 'Éditeur HTML.',
    'upload_dump' => "Choisissez un fichier de sauvegarde, puis cliquez sur 'Charger' pour envoyer le fichier dans le stockage. Pour charger une sauvegarde multi-volumes, indiquez la première partie du volume puis cliquez sur le lien 'Préciser le prochain volume' et indiquez le volume suivant. Répétez ces étapes jusqu'à ce que vous ayez indiqué tous les volumes de la sauvegarde. Quand vous avez fini, cliquez sur 'Charger'.",
    'subdom_performance' => 'Configuration de la performance du sous-domaine.',

    'dom_performance_edit' => 'Configuration de la performance du domaine.',
    'dom_performance_readonly' => 'Consultation de la configuration de la performance du domaine.',

    //===============List table header conhelp==================//

    'l_inv' => 'Inversez la sélection des cases à cocher.',
    'l_rad' => 'Sélect. le bouton radio.',

    'b_wizard_prev' => 'Revenir à l\'étape précédente de l\'assistant.',
    'b_wizard_next' => 'Aller à l\'étape suivante de l\'assistant.',
    'b_finish' => 'Appliquez les modifications faites dans cet écran et quittez l\'assistant.',

    // pacif add

    'b_backup_ftp_settings' => 'Cliquez ici pour spécifier les paramètres du compte FTP.',
    'b_backup_scheduled_settings' => 'Cliquez pour programmer le back-up.',
    'b_backup_ftp_not_configured' => 'Le compte FTP n\'est pas configuré.',
    'backup_client_front' => 'Sauvegarder et restaurer les comptes utilisateur et configurer la sauvegarde à temps.',
    'backup_domain_front' => 'Sauvegarder et restaurer les sites Web et configurer la sauvegarde à temps.',
    'backup_client_new' => 'Sauvegardez un compte utilisateur.',
    'backup_domain_new' => 'Sauvegardez un site Web.',
    'backup_ftp_settings' => 'Définissez les paramètres du compte FTP qui sera utilisé comme stockage distant.',

    'backup_overwrite' => 'Cochez la case pour confirmer le remplacement et cliquez sur OK pour remplacer le fichier.',
    'b_backup_file_overwrite' => 'Cliquez pour remplacer l\'actuel fichier de sauvegarde par un autre fichier.',
    'b_backup_file_overwrite_cancel' => 'Cliquez pour annuler l\'écrasement du fichier et revenir à la configuration des propriétés de la sauvegarde.',
    'b_backup_cancel' => 'Cliquez pour arrêter la sauvegarde.',

    'b_backup_cancel_creating' => 'Cliquez pour annuler la création de la sauvegarde et revenir à la page précédente.',
    'b_backup_cancel_ftp_settings' => 'Cliquez ici pour supprimer les paramètres du compte FTP et retourner dans la fenêtre précédente.',
    'b_restore_cancel' => 'Stoppez la restauration.',
    'backup_progress' => 'Suivi de la sauvegarde en cours. Cliquez sur Annuler pour arrêter le processus.',
    'restore_progress' => 'Affichage de la progression de la restauration. Cliquez sur Annuler pour stopper la restauration.',
    'b_backup_new_restore' => 'Lancer la restauration.',
    'b_restore_cancel_creating' => 'Cliquez pour annuler la restauration et pour revenir à la page précédente.',
    'b_backup_file_delete' => 'Cliquez pour supprimer le fichier de sauvegarde.',
    'backup_delete' => 'Cochez la case pour confirmer la suppression des fichiers de sauvegarde et cliquez sur OK.',
    'backup_result' => 'Après avoir consulté les résultats de la sauvegarde, cliquez sur OK pour mettre fin à l\'opération et pour revenir au Gestionnaire de sauvegardes.',
    'backup_restore_results' => 'Après avoir affiché les résultats de restauration, cliquez sur OK pour revenir au Gestionnaire de sauvegardes.',

    'i_backup_domain_can_restore' => 'Il est possible de restaurer ce domaine.',
    'i_backup_domain_exist_other_client' => 'Impossible de restaurer ce domaine car il n\'y a pas d\'autre domaine portant un tel nom qui appartient à un autre utilisateur.',
    'backup_failed' => 'La sauvegarde a échoué.',
    'backup_stop' => 'Cliquez sur OK pour arrêter le processus de sauvegarde. Cliquez sur Annuler pour continuer la sauvegarde.',
    'restore_stop' => 'Cliquez sur OK pour stopper la restauration. Cliquez sur Annuler pour continuer la restauration.',
    'backup_info_domain' => 'Pour restaurer des données à partir de ce fichier de sauvegarde, cliquez sur Suivant >>.',
    'backup_info_domain_restore' => 'Pour restaurer les données à partir de ce fichier de sauvegarde, cliquez sur Restaurer.',
    'backup_info_client' => 'Pour restaurer des données à partir de ce fichier de sauvegarde, choisissez les objets à restaurer puis cliquez sur Suivant >>.',
    'backup_ip_mapping_domain' => 'Mapper l\'adresse IP enregistrée dans le fichier de sauvegarde avec une autre adresse IP existante.',
    'backup_ip_mapping_client' => 'Mapper les adresses IP enregistrées dans le fichier de sauvegarde avec des adresses existantes.',
    'backup__db_server_mapping' => 'Sélectionnez le serveur de base de données configuré dans Plesk auquel vous voulez mapper le serveur de base de données à partir de la sauvegarde.',

    'b_restore_ip_mapping' => 'Cliquez pour configurer le mappage d\'adresses IP en vue de la restauration.',
    'learn_more' => 'Plus d\'infos sur cette nouvelle fonctionnalité.',
    'try_new_feature' => 'Testez cette nouvelle fonctionnalité !',
    'whats_new_full' => 'Une description détaillée des nouvelles fonctionnalités et des modifications dans cette release.',
    'b_migration_dump_all' => 'Migrez tous les comptes depuis l\'hôte distant.',
    'i_migration_not_exist_account' => 'Vous pouvez transférer ce compte.',
    'i_migration_exist_account' => "Vous ne pouvez pas transférer ce compte : il est déjà dans {$PROD_NAME}",
    'i_migration_not_exist_domain' => 'Vous pouvez transférer ce domaine.',
    'i_migration_exist_domain' => "Vous ne pouvez pas transférer ce domaine : il est déjà dans {$PROD_NAME}",
    'i_migration_bad_domain' => 'Impossible de migrer ce domaine : le nom du domaine est incorrect',
    'i_migration_con_exist_domain' => 'Certains des domaines ont déjà été migrés vers ce compte.',
    'i_migration_all_domain_exist' => "La migration portera seulement sur les informations du compte : tous les domaines liés à ce compte sont déjà dans {$PROD_NAME}",
    'migration_upload' => 'Sélectionnez la plate-forme source, indiquez le nom d\'hôte source et les identifiants d\'accès. Cliquez sur Suivant pour envoyer l\'Agent de transfert & de migration vers l\'hôte.',
    'migration_progress' => 'Voir la progression de la migration et l\'arrêter si nécessaire.',
    'b_migration_host_info' => 'Affichez les informations sur l\'hôte distant et sélectionnez les objets à migrer.',
    'b_migration_single_info' => 'Vous avez une option, celle d\'importer les données à partir du dump ou de sélectionner les objets à importer. À partir de cette page, vous pouvez également définir les paramètres de déploiement.',
    'migration_content_download' => 'Voir la progression du téléchargement du contenu et l\'arrêter si nécessaire.',
    'migration_content_download_not_space' => 'Espace disque insuffisant pour télécharger le contenu depuis l\'hôte distant.',
    'migration_objects_select' => 'Sélectionnez les comptes et les domaines à migrer.',
    'migration_account_select' => 'Sélectionnez le compte utilisateur dans Plesk vers lequel vous voulez migrer les domaines sélectionnés.',
    'migration_ip_mapping' => 'Sélectionnez l\'adresse IP dans Plesk à laquelle vous voulez mapper les adresses IP hôtes distantes.',
    'migration_stop' => 'Cochez la case pour confirmer que vous voulez arrêter la migration et supprimer l\'Agent de transfert & de migration à partir de l\'hôte distant, et cliquez sur OK.',
    'migration_result' => 'Après avoir consulté le résultat de la migration, cliquez sur \'Terminer\' pour y mettre fin.',
    'migration_failed' => 'Échec de la migration.',
    'b_migrate' => 'Démarrer la migration.',
    'b_migrate_cancel' => 'Stopper la migration.',
    'b_migration_reload' => 'Cliquez pour actualiser les données.',
    'b_migrate_domains' => 'Cliquez pour migrer les domaines sélectionnés.',
    'b_migrate_accounts' => 'Cliquez pour migrer les comptes sélectionnés',
    'b_migrate_set_accounts' => 'Cliquez pour définir les comptes pour migrer l\'objet',
    'b_migrate_set_ip_map' => 'Cliquez pour définir le mappage d\'adresses IP pour migrer l\'objet',
    'b_migrate_set_db_server_map' => 'Cliquez pour configurer le mappage des bases de données migrées.',
    'b_migration_begin' => 'Cliquez pour démarrer une nouvelle migration.',
    'b_migration_more' => 'Cliquez pour recommencer la migration.',
    'b_migration_retry' => 'Cliquez pour poursuivre la migration après avoir libéré de l\'espace disque.',
    'b_migration_ignore' => 'Cliquez pour poursuivre la migration quoi qu\'il en soit.',
    'b_migrate_single' => 'Migration avec un seul serveur.',

    'b_migration_session_add' => 'Cliquez pour créer une session de migration.',
    'b_to_migration_manager' => 'Revenir à la liste des sessions de migration.',
    'b_to_ip_map_page' => 'Revenir au mappage des adresses IP.',
    'migration_upload_ipmap_file' => 'Envoyer le fichier de la carte IP.',
    'b_ipmap_download' => 'Télécharger le fichier de la carte IP.',
    'b_ipmap_upload' => 'Envoyer le fichier de la carte IP.',

    'b_install' => 'Installer l\'application Web',

    'b_sb_menu_desktop' => "Allez sur la page d'accueil de l'administrateur système de Presence Builder.",
    'b_sb_menu_users' => "Ajoutez et gérez les comptes utilisateur et les Packs pour vos clients.",
    'b_sb_menu_sites' => "Ajoutez et gérez les sites Web.",
    'b_sb_menu_server' => "Configurez le système Presence Builder.",
    'b_sb_menu_logs' => "Affichez les journaux de sécurité et du système de Presence Builder.",
    'b_sb_server_configure' => "Configurez l'intégration avec Presence Builder.",
    'sb_server_configure_page_description' => "Précisez le nom d'utilisateur et le mot de passe que Plesk doit utiliser pour être identifié dans Presence Builder. Ces nom d'utilisateur et mot de passe doivent d'abord être définis dans Presence Builder.",
    'b_sb_site_wizard' => "Allez dans Presence Builder pour créer et gérer les sites Web.",

    'b_connect' => 'Connectez votre compte local à un compte global.',
    'b_disconnect' => 'Déconnectez votre compte local d\'un compte global.',
    'b_fi_change_passwd' => 'Modifiez le mot de passe du compte global.',
    'connect' => 'Connectez votre compte local à votre compte global.',
    'disconnect' => 'Déconnectez votre compte local de votre compte global.',
    'fi_change_passwd' => 'Modifiez le mot de passe de votre compte global.',

    'sapp__no_license_key' => 'Impossible de créer des packs d\'applications tant que vous n\'avez pas ajouté de clé de licence dans le répertoire des clés de licence.',

    'b_dns__tabs_general' => 'Page des paramètres de DNS généraux',
    'sessions__tabs_soa_record' => 'Personnalisation de l\'enregistrement SOA.',

    'packages_preinstall' => 'Paramètres d\'installation de l\'application Web.',

    'packages_info_server' => 'Affichage des informations sur le pack d\'applications.',
    'packages_info_domain' => 'Affichage des informations sur le pack d\'applications.',
    'b_to_packages_info' => 'Revenez à la page d\'informations du pack.',
    'packages_install' => 'Installation du pack d\'applications.',

    'b_server_app_add' => 'Cliquez pour accéder à la page d\'installation de la nouvelle application pour serveur.',
    'b_help_install' => 'Lancez l\'installation de l\'application.',
    'b_help_cancel' => 'Annulez l\'installation de l\'application.',
    'packages_reconfigure' => 'Reconfiguration de l\'application serveur.',
    'packages_remove' => 'Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.',

    'b_packages_management' => 'Gestion des applications pour serveur.',
    'packages_management' => 'Cette page permet d\'installer et de supprimer des applications pour serveur depuis le serveur.',
    'b_to_packages_management' => 'Revenir à la page de gestion des applications pour serveur.',

    'i_ftp_ses_type' => 'La dernière commande envoyée par le client est TYPE.',
    'i_ftp_ses_pass' => 'La dernière commande envoyée par le client est PASS.',
    'i_ftp_ses_noop' => 'La dernière commande envoyée par le client est NOOP.',

    'virtualdirs__remove_submit' => 'Cliquez pour supprimer les répertoires virtuels sélectionnés. Les répertoires physiques actuels ne sont pas supprimés.',

    'b_set_skin' => 'Cliquez pour définir le thème actuel comme thème par défaut de Plesk.',
    'set_skin__already_default' => 'Le thème actuel est déjà défini comme thème de Plesk par défaut.',

    'i_custom_errors_add' => 'Entrez les informations nécessaires et cliquez pour ajouter un nouveau message d\'erreur personnalisé.',

    'i_antivirus_off' => 'La protection antivirus n\'est pas activée pour cette boîte mail.',
    'i_antivirus_on' => 'La protection antivirus est désactivée pour la boîte mail.',
    'i_antivirus_turn_pref' => 'Cliquez pour configurer les paramètres de protection antivirus.',
    'i_antivirus_turn_key' => 'La clé de licence actuelle ne prend pas en charge la protection antivirus.',
    'i_antivirus_turn_perm' => 'Vous n\'êtes pas autorisé à gérer la fonction antivirus.',

    'b_acl_add' => 'Cliquez pour ajouter une adresse aux ACL d\'autorisations de transfert de zones.',
    'dns_acl' => 'Cette page affiche une liste de toutes les IP et adresses du réseau pour lesquelles le transfert de zone est autorisé.',

    'i_antivirus_any' => 'La protection antivirus est paramétrée pour les mails entrants et sortants.',
    'i_antivirus_from' => 'La protection antivirus est paramétrée pour les mails sortants.',
    'i_antivirus_to' => 'La protection antivirus est paramétrée pour les mails entrants.',

    'i_ip_fail_no_interface' => 'L\'interface associée à l\'adresse IP manque.',

    'b_test' => 'Tester la connexion.',

    'b_language_groups_add' => 'Ajoutez le groupe de langues à la liste des langues de confiance.',
    'b_language_groups_del' => 'Supprimez le groupe de langues de la liste des langues de confiance.',
    'b_locale_groups_add' => 'Ajoutez le groupe de fichiers localisés à la liste des fichiers localisés de confiance.',
    'b_locale_groups_del' => 'Supprimez le groupe de fichiers localisés de la liste des fichiers localisés de confiance.',
    'spam_trustednetworks_new' => 'Ajouter ce réseau à la liste des réseaux sûrs.',
    'spam_trustednetworks_remove' => 'Supprimer un réseau de la liste des réseaux sûrs.',


    'i_i_client_on' => 'Le compte client est actif.',
    'i_i_client_off_by_admin' => 'Le compte client est désactivé par l\'administrateur.',


    'b_virtualdir_add_disabled' => 'La fonction Création de répertoire virtuel n\'est pas disponible.',

    'b_db_add_disabled' => 'La connexion à votre serveur de bases de données n\'est pas configurée. Vous pouvez la configurer sur la page Serveur > Base de données.',

    'b_databases__change_server_passwd_disabled' => "Vous utilisez le serveur de base de données interne de Plesk, car vous avez configuré la connexion avec le port 8306. Par conséquent, le mot de passe doit être changé sur la page Paramètres > Changer le mot de passe.",

    'b_traffic_at_domains' => 'Consultation des statistiques du trafic sur les domaines du serveur.',
    'traffic_at_domains' => 'Statistiques du trafic sur tous les domaines enregistrés dans le système.',

    'b_rdp_session__open_new' => 'Ouvrir une nouvelle session du terminal.',

    'removeDNS_acl' => 'Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.',

    'i_additional_key_installed' => 'La clé est installée pour l\'application.',
    'i_additional_key_not_installed' => 'La clé n\'est pas installée pour l\'application.',

    'b_unhandlederror_showinfo' => 'Cliquez pour voir les informations détaillées sur l\'erreur.',
    'b_unhandlederror_hideinfo' => 'Cliquez pour masquer les informations supplémentaires sur l\'erreur.',
    'b_unhandlederror_submitticket' => 'Cliquez pour signaler l\'erreur au service Assistance technique.',
    'unhandlederror' => 'L\'opération a échoué.',

    'permissions' => 'Configurez les droits pour le fichier ou le dossier.',

    'permissions_advanced' => 'Configurez les droits avancés pour les fichiers ou dossiers.',

    'i_conn_strings_add' => 'Cliquez pour ajouter la chaîne de connexion.',
    'i_conn_strings_add_disabled' => 'Fonction pour ajouter des chaînes de connexion non disponible.',
    'i_conn_strings_del' => 'Cliquez pour supprimer la chaîne de connexion.',
    'i_conn_strings_del_disabled' => 'Fonction pour supprimer les chaînes de connexion non disponible.',

    'dns_acl_remove' => 'Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.',

    'to_interface_management' => "Revenir à la page de gestion de l'interface.",
    't_locales' => "Cliquez pour gérer les langues d'interface.",
    't_skins' => "Cliquez pour gérer les Skins.",
    't_interface_templates' => "Cliquez pour gérer le template d'interface.",
    'b_locale_make_default' => "Sélectionnez un pack de langue et faites de ce dernier le pack par défaut.",
    'b_skin_make_default' => "Sélectionnez un skin et cliquez dessus pour la définir comme skin par défaut.",

    'wu_limits_exceeding' => "Le nombre maximum d'utilisateurs Web autorisés pour ce domaine est déjà atteint. Vous ne pouvez pas en créer de nouveaux.",

    'mail_setenable_off' => 'Le serveur de messagerie ne prend pas en charge cette fonctionnalité.',
    'domain_aliases__status_ok' => 'L\'alias de domaine fonctionne correctement.',

    'i_htype_sub_hst' => 'Sous-domaine sur un sous-dossier.',
    'mail_antivirus' => 'Paramètres antivirus.',

    'dom_new_no_clients' => 'Vous devez créer un nouveau compte client avant de pouvoir ajouter des domaines.',

    'dns_t_acl' => 'Paramètres de la liste des contrôles d\'accès (ACL).',

    'dns_t_acl_remove' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",

    'b_sapp_make_default' => "Faire de l'application Web sélectionnée celle par défaut",

    'b_ftp_ctrl' => "Gérez des comptes FTP supplémentaires sous un domaine.",
    'ftp_ctrl' => "Gestion des comptes FTP supplémentaires sous un domaine.",
    'b_ftp_user_add' => "Cliquez pour ajouter un compte FTP.",
    'b_ftp_users_limit_reached' => "La limite du nombre des comptes FTP a été atteinte.",
    'ftp_user_edit' => "Paramètres du compte FTP.",
    'ftp_users' => "Gérez des comptes FTP supplémentaires sous un domaine.",
    'removeFtpUsers' => "Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.",
    'to_ftp_ctrl' => "Revenir à la page de gestion des comptes FTP.",

    'b_sb_desktop' => "Aperçu des principales fonctionnalités de Presence Builder.",
    'b_sb_users' => "Gérez les comptes utilisateur enregistrés dans Presence Builder.",
    'b_sb_sites' => "Ajoutez et gérez différents types de sites Presence Builder.",
    'b_sb_server' => "Administration de Presence Builder.",
    'b_sb_logs' => "Affichez les enregistrements des journaux de sécurité et du système de Presence Builder.",

    'dns_recursion' => "Gestion de la récursivité des serveurs DNS.",

    'subdom_hst_type_sel' => "Choisissez le type d'hébergement à configurer pour le sous-domaine.",

    'i_wu_open_help' => "Cliquez pour ouvrir la page de l'utilisateur Web dans le navigateur.",

    'i_i_client_off_expired' => "La période de validité pour ce compte client a expiré.",

    'i_antivirus_turn_install' => 'L\'antivirus n\'est pas installé ou n\'est pas configuré correctement.',

    'b_ftp_users_no_permission' => "Vous n'avez pas les droits requis pour gérer les comptes FTP.",

    // Plesk 8 keys

    'b_search' => "Recherchez les clients, domaines et compte mail.",

    // services management
    'b_service_showall' => 'Affichez tous les services.',
    'b_service_hideall' => "Masquez tous les services.",
    'b_service_start' => "Démarrez les services sélectionnés.",
    'b_service_stop' => "Arrêtez les services sélectionnés.",
    'b_service_restart' => "Redémarrez les services sélectionnés.",
    'b_service_disable' => "Désactivez les services sélectionnés.",
    'b_service_manual' => "Choisissez le type de démarrage manuel pour les services sélectionnés.",
    'b_service_auto' => "Choisissez le type de démarrage automatique pour les services sélectionnés.",
    'i_serv_group_on' => 'Tous les services du groupe fonctionnent.',
    'i_serv_group_none' => 'Certains services du groupe sont désactivés ou arrêtés.',
    'i_serv_group_off' => 'Tous les services du groupe sont désactivés ou sont arrêtés.',
    'i_serv_key_disabled' => 'Service désactivé.',

    // php4v5
    'php' => "Impossible de modifier les paramètres PHP du répertoire virtuel actuel.",
    'php_changeversion' => "Configuration de PHP pour le répertoire virtuel courant.",
    'php_dom' => "Modifier la configuration PHP d'un domaine.",
    'php_subdom' => "Modifier la configuration PHP d'un sous-domaine.",
    'php_changeversion_dom' => "Configuration de PHP pour le domaine.",
    'php_changeversion_subdom' => "Configuration PHP d'un sous-domaine.",

    // mass mail
    'b_new_mass_mail_template' => 'Ajouter un template de mail de publipostage',
    'b_massmail_send' => "Envoyer le mail à tous les destinataires sélectionnés",

    // Other
    'b_additional_key_is_install' => 'Installez une clé supplémentaire.',
    'i_domain_sitebuilder_disabled' => "La prise en charge de Presence Builder est désactivée pour ce domaine.",
    'i_subdomain_sitebuilder_disabled' => "La prise en charge de Presence Builder est désactivée pour ce sous-domaine.",
    'i_subdomain_sitebuilder_wizard' => "Allez dans l'assistant Presence Builder pour ce sous-domaine.",
    'i_domain_sitebuilder_wizard' => "Allez dans l'assistant Presence Builder pour ce domaine.",
    'sitebuilder_page' => 'Vous êtes actuellement dans une fenêtre Presence Builder. Consultez la documentation Presence Builder pour en savoir plus.',
    'removeFpseUsers' => 'Cochez la case pour confirmer la suppression et cliquez sur OK pour supprimer. Cliquez sur Annuler pour annuler la suppression.',
    'b_insert' => 'Cliquez pour insérer les données du template sélectionné dans votre mail de publipostage.',
    'i_spamfilter_turn_install' => 'Le filtre anti-spam n\'est pas installé.',

    // help desk

    // 8.2

    // other

    'b_db_preferences' => 'Modifier les paramètres de connexion de la base de données',
    'b_disabled_hosting' => 'Cette fonction est indisponible car l\'hébergement physique n\'est pas configuré.',
    'net_apps' => 'Gérez les applications Web ASP.NET 1.1.',
    'site_apps' => "Gérer les applications Web standards",

    'b_default_cert' => 'Utilisez le certificat sélectionné pour sécuriser les connexions aux sites Web nouvellement hébergés.',
    'b_setup_cp' => 'Utiliser le certificat sélectionné pour sécuriser les connexions à Plesk',
    'b_to_actionlog' => 'Revenir au journal des actions',

    // 8.3

    'additional_key_update' => 'Statut de la mise à jour ou de la récupération de la clé supplémentaire',
    'admin_alias_password_update' => 'Confirmer la modification du mot de passe',
    'removeTasks' => "Confirmer la suppression des tâches sélectionnées puis cliquer sur OK",

    'b_license_key_remove' => 'Cliquez pour supprimer la clé de licence.',
    'fi-attach' => 'Indiquer les paramètres du compte global auquel vous voulez vous connecter.',
    'fi-detach' => 'Confirmez la déconnexion du compte local actuel d\'un compte global, puis cliquez pour déconnecter.',
    'fi-update' => 'Mettez à jour les paramètres du compte global.',

    // 8.4
    // RESELLERS
    'b_resellers' => 'Gérer les comptes revendeur',
    'i_reseller_on' => "Ce compte utilisateur est actif.",
    'i_reseller_off_by_parent' => "Ce compte utilisateur a été suspendu par le fournisseur de services.",
    'i_reseller_off_by_expired' => "Cette condition d'abonnement pour ce compte utilisateur a expiré.",
    'i_reseller_off_backup_restore' => "Ce compte utilisateur a été temporairement suspendu pour sauvegarder ou restaurer les données.",
    'i_reseller_ok' => "Les ressources utilisées par le revendeur sont comprises dans les limites.",
    'i_reseller_cp_access_on' => "Le revendeur est autorisé à accéder à Plesk.",
    'i_reseller_cp_access_off' => "Le revendeur n'est pas autorisé à accéder à Plesk.",
    'i_click_to_reseller_cp_access_on_off' => "Cliquez pour autoriser ou interdire l'accès à Plesk au revendeur.",

    // CLIENTS (upgraded for resellers)

    // 'upgradeclients__submit_update' => 'Click',
    'b_upgradeClients__cancel_upgrade' => 'Ignorez toutes les modifications et retournez à la page précédente.',
    'b_upgradeClients__submit_upgrade' => 'Cliquez pour convertir les comptes client éligibles en comptes revendeur.',
    'b_upgradeDomainUser__cancel_upgrade' => 'Ignorez toutes les modifications et retournez à la page précédente.',
    'b_upgradeDomainUser__submit_upgrade' => 'Cliquez pour convertir les comptes administrateur de domaines éligibles en comptes client.',

    //APS Catalog
    'b_hide_updates' => "Masquez les mises à jour.",
    'b_show_updates' => "Affichez les mises à jour.",
    'b_add_to_vault' => "Ajouter les applications sélectionnées dans le référentiel d'applications.",

    // new and unsorted
    'b_to_server_interface' => "Revenez à la liste des skins disponibles.",
    'b_skin_edit' => "Éditez la description du skin.",
    'b_to_phosting_setup' => "Revenez aux paramètres d'hébergement.",
    // Hosting setup redesign
    'b_dom_hosting_update' => "Enregistrez les paramètres d'hébergement.",
    'b_downgradeResellers__submit_downgrade' => "Cliquez pour terminer l'opération.",
    'b_rs_pool_add' => "Affectez des adresses IP au revendeur.",
    'b_cl_pool_add' => "Affectez des adresses IP au client.",
    'b_ippoolManager__no_available_ips' => "Il n'y a aucune adresse IP vacante dans le pool d'IP.",
    'b_ip_already_added_to_all_clients' => "Cette adresse IP est déjà dans les pools d'IP de tous les utilisateurs.",

    // SERVER/SETTINGS
    'b_change_hostname_conhelp' => 'Changez le nom d\'hôte du serveur.',
    'b_setup_firewall_conhelp' => 'Configurez le pare-feu pour protéger le serveur.',
    'b_setup_firewall_none_available_conhelp' => 'La fonctionnalité de pare-feu est indisponible : le pare-feu n\'est pas installé.',
    'b_manage_firewall_rules_conhelp' => 'Créez, éditez et supprimez les règles de pare-feu.',
    'b_manage_firewall_rules_none_available_conhelp' => 'La fonctionnalité de pare-feu est indisponible : le pare-feu n\'est pas installé.',
    'b_select_dns_server_conhelp' => 'Sélectionnez le logiciel de serveur DNS qui doit être utilisé par le serveur et géré par Plesk.',
    'b_select_dns_server_none_available_conhelp' => 'Aucun autre programme de serveur DNS n\'est disponible.',
    'b_soa_records_template_conhelp' => 'Configurez les enregistrements DNS qui seront utilisés en tant que template lors de la création de la zone DNS pour les domaines.',
    'b_dns_recursion_conhelp' => 'Configurez les paramètres de récursivité des serveurs DNS qui seront utilisés en tant que template lors de la création de la zone DNS pour les domaines.',
    'b_restrict_creation_of_subzones_conhelp' => "Limiter la création des sous-zones DNS dans les superzones DNS des autres utilisateurs",
    'b_select_mailserver_conhelp' => 'Sélectionnez le logiciel de serveur de messagerie qui doit être utilisé par le serveur et géré par Plesk.',
    'b_select_mailserver_none_available_conhelp' => 'Aucun autre serveur de messagerie n\'est disponible.',
    'b_select_antivirus_conhelp' => 'Sélectionnez le logiciel antivirus qui doit être utilisé par le serveur et géré par Plesk.',
    'b_select_antivirus_none_available_conhelp' => 'Aucun autre programme antivirus n\'est disponible.',
    'b_virus_protection_settings_conhelp' => 'Configurez les paramètres de protection anti-virus valables pour l\'ensemble du serveur.',
    'b_select_spamfilter_conhelp' => 'Sélectionnez le logiciel de filtre antispam qui doit être utilisé par le serveur et géré par Plesk.',
    'b_select_spamfilter_none_available_conhelp' => 'Aucun autre programme de filtre anti-spam n\'est disponible.',
    'b_select_webmail_conhelp' => 'Sélectionnez le logiciel de messagerie Web qui doit être disponible pour les utilisateurs de messagerie.',
    'b_select_webmail_none_available_conhelp' => 'Aucun autre programme de messagerie Web n\'est disponible.',
    'b_server_statistics_settings_conhelp' => 'Sélectionnez ce qui doit être inclus dans les calculs des statistiques pour l\'ensemble du serveur.',
    'b_select_ssl_certificate_conhelp' => 'Sélectionnez le certificat SSL/TLS à utiliser pour protéger votre domaine.',
    'b_select_ssl_certificate_none_available_conhelp' => 'L\'hébergement Web est requis pour avoir accès à cette fonction.',
    'b_select_web_statistics_conhelp' => 'Sélectionnez le logiciel de statistiques Web qui doit être disponible pour les propriétaires de domaines.',
    'b_select_web_statistics_none_available_conhelp' => 'Aucun autre programme de statistiques Web n\'est disponible.',
    'b_interface_management_conhelp' => 'Configurez diverses options de l\'interface Plesk.',
    'b_setup_watchdog_conhelp' => 'Configurez le module de surveillance du serveur Watchdog.',
    'b_setup_watchdog_none_available_conhelp' => 'Le module Watchdog n\'est pas installé.',
    'b_setup_vpn_conhelp' => 'Configurez l\'accès VPN sur le serveur.',
    'b_setup_vpn_none_available_conhelp' => 'L\'extension d\'accès VPN n\'est pas installée.',
    'b_setup_samba_conhelp' => 'Configurez l\'accès Samba sur le serveur.',
    'b_setup_samba_none_available_conhelp' => 'L\'extension d\'accès Samba n\'est pas installée.',

    // DOMAIN/SETTINGS
    'b_account_settings_conhelp' => 'Affichez et gérez vos paramètres de compte.',
    'b_dns_soa_records_conhelp' => 'Affichez et gérez les enregistrements SOA DNS pour votre domaine.',
    'b_task_scheduler_settings_conhelp' => 'Configurez le planificateur de tâches pour votre domaine.',
    'b_task_scheduler_settings_none_available_conhelp' => 'L\'hébergement Web est requis pour avoir accès à cette fonction.',
    'b_web_users_scripting_conhelp' => 'Autorisez ou interdisez les utilisateurs Web d\'utiliser les scripts.',
    'b_web_statistics_conhelp' => 'Affichez les statistiques de visites de votre domaine.',
    'b_log_rotation_settings_conhelp' => 'Configurez la rotation des journaux sur votre domaine.',

    // navbar
    'b_mailnames' => 'Accédez à la liste des comptes mail.',
    'b_applications' => 'Accédez à la liste des applications Web.',
    'b_settings' => 'Configurez une variété des paramètres.',

    // templates
    'i_tmpl__shared_template' => 'Votre hébergeur a créé ce template. Vous pouvez l\'utiliser, car votre hébergeur le partage.',
    'i_tmpl__owned_template' => 'Vous avez créé ce template. Il peut être utilisé par vous-même ou vos utilisateurs, si vous le permettez.',

    'b_load' => 'Envoyez le message du template précédemment enregistré.',

    'b_sh_ip_add' => 'Ajouter une adresse IP à la liste des adresses IP partagées',
    'b_sh_ip_del' => 'Supprimer une adresse IP de la liste des adresses IP partagées',
];