<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Wenn Sie Ihre Website auf einer dedizierten IP-Adresse (die nicht gemeinsam mit anderen Benutzern oder Websites genutzt wird) hosten, können Sie innerhalb der Website ein Verzeichnis einrichten, mit dem andere Benutzer Dateien anonym über eine FTP-Verbindung austauschen können, indem Sie sie hoch- oder herunterladen. Wenn Anonymous FTP aktiviert ist, können sich Benutzer über eine Adresse wie z.B. ftp://ftp.ihre-domain.com mit dem Benutzernamen "anonymous" und einem beliebigen Passwort am Verzeichnis anmelden.',
    'anonymous-ftp.displayLogin' => 'Anmeldenachricht anzeigen',
    'anonymous-ftp.loginText' => 'Nachrichtentext',
    'anonymous-ftp.incomingDir' => 'Upload in das Eingangsverzeichnis zulassen',
    'anonymous-ftp.incomingSubDir' => 'Erstellen von Ordnern im Eingangsverzeichnis zulassen',
    'anonymous-ftp.incomingReadable' => 'Download aus dem Eingangsverzeichnis zulassen',
    'anonymous-ftp.quota' => 'Speicherplatz im Eingangsverzeichnis begrenzen',
    'anonymous-ftp.maxConnections' => 'Anzahl gleichzeitiger Verbindungen begrenzen',
    'anonymous-ftp.bandwidth' => 'Download-Bandbreite für diese virtuelle FTP-Domain begrenzen',
    'anonymous-ftp.unlimited' => 'Unbegrenzt',

    'aps.catalog.loading' => 'Laden...',
    'aps.catalog.searchName' => 'Anwendung',
    'aps.catalog.searchVendor' => 'Verkäufer',
    'aps.catalog.searchPackager' => 'Packager',
    'aps.catalog.searchLicenseType' => 'Lizenztyp',
    'aps.catalog.searchLicenseTypeAny' => 'Beliebig',
    'aps.catalog.searchLicenseTypeFreeware' => 'Kostenlos',
    'aps.catalog.searchLicenseTypeCommercial' => 'Kommerziell',
    'aps.catalog.showSearch' => 'Suche anzeigen',
    'aps.catalog.hideSearch' => 'Suche ausblenden',
    'aps.catalog.buttonSearch' => 'Suchen',
    'aps.catalog.buttonResetSearch' => 'Suche zurücksetzen',
    'aps.catalog.showCategories' => 'Wählen Sie unten eine Kategorie aus oder suchen Sie mithilfe des Suchfeldes nach Anwendungen',
    'aps.catalog.searchResults' => 'Suchergebnisse',
    'aps.catalog.buttonInstall' => 'Installieren',
    'aps.catalog.buttonInstallTooltip' => 'Führen Sie eine Schnellinstallation der neuesten Version der App mit den optimalen Standardparametern durch.',
    'aps.catalog.buttonAdvancedInstall' => 'Installieren (benutzerdefiniert)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Installieren Sie die neueste Version der App und passen Sie alle Parameter an.',
    'aps.catalog.buttonInstallOldVersion' => 'Version installieren',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Installieren Sie die ausgewählte Version der App und passen Sie alle Parameter an.',
    'aps.catalog.buttonInstallDescription' => 'Installieren Sie die Anwendung auf Ihrer Domain, wenn Sie schon einen Aktivierungsschlüssel besitzen oder wenn Sie sie nur testen wollen.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Installieren Sie diese kostenlose Anwendung auf einer Website.',
    'aps.catalog.version' => 'Version',
    'aps.catalog.moreVersions' => 'Weitere Versionen',
    'aps.catalog.release' => 'Release',
    'aps.catalog.overview' => 'Überblick',
    'aps.catalog.noApplicationsInCategory' => 'Keine Anwendungen in dieser Kategorie verfügbar. Andere Kategorie auswählen.',
    'aps.catalog.noCategoriesSelected' => 'Wählen Sie eine Kategorie aus, um alle verfügbaren Anwendungen in dieser Kategorie zu durchsuchen.',
    'aps.catalog.noSearchResults' => 'Ihre Suche stimmt keiner Anwendung überein.',
    'aps.catalog.connectionFailed' => 'Verbindung zum Anwendungskatalog konnte nicht hergestellt werden. %%retryLink%%.',
    'aps.catalog.retry' => 'Erneut versuchen',
    'aps.catalog.categoriesError' => 'Die Liste mit den Kategorien kann im Moment nicht geladen werden.',
    'aps.catalog.applicationsError' => 'Anwendungsliste kann im Moment nicht geladen werden.',
    'aps.catalog.detailsError' => 'Anwendungsdetails können im Moment nicht geladen werden.',
    'aps.catalog.searchError' => 'Suchergebnisse können im Moment nicht geladen werden.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Release %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Changelog',
    'aps.catalog.officialApplicationSite' => 'Verkäuferinformationen',
    'aps.catalog.returnToCategories' => '<< Zurück zur Liste',
    'aps.catalog.buttonUninstall' => 'Entfernen',
    'aps.catalog.gotoHome' => 'Start',
    'aps.catalog.all' => 'Alle',
    'aps.catalog.buttonDetails' => 'Mehr Informationen',
    'aps.catalog.buttonBuy' => 'Jetzt kaufen',
    'aps.catalog.buttonBuyTooltip' => 'Die App kaufen',
    'aps.catalog.buttonBuyDescription' => 'Besuchen Sie unseren Store, um den Aktivierungscode für die Anwendung zu kaufen.',
    'aps.catalog.buttonDownload' => 'Herunterladen',
    'aps.catalog.buttonDownloadDescription' => 'Laden Sie sich die Anwendung herunter, wenn Sie einen Aktivierungscode besitzen oder wenn Sie sie nur testen wollen.',
    'aps.catalog.marketplaceMoreInfo' => 'Weitere Informationen finden Sie unter %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'Website des Anwendungs-Anbieters',

    'aps.configure.installedAt' => "Installiert auf",
    'aps.configure.otherSettings' => "Andere",
    'aps.configure.globalSettings' => 'Paketeinstellungen',
    'aps.configure.passwordConfirmation' => 'Passwort bestätigen',
    'aps.configure.databaseParams' => 'Datenbankparameter',
    'aps.configure.noInstallationUrlAvailable' => 'Keine (externe Anwendung)',
    'aps.configure.updateSettingsSection' => 'Update-Einstellungen',
    'aps.configure.forceUpdates' => 'Diese App automatisch aktualisieren, wenn Updates verfügbar sind',
    'aps.configure.forceUpdatesHint' => 'Die App erhält automatische Updates auf neuere Versionen. Achtung: Verwenden Sie diese Option mit Vorsicht, denn Updates können die Funktionalität der Apps signifikant beeinträchtigen. Beispielsweise kann es vorkommen, dass App-Erweiterungen mit der Folgeversion einer App nicht mehr funktionieren.',

    'aps.install.showAllSettings' => 'Alle Einstellungen anzeigen',
    'aps.install.showLessSettings' => 'Minimaleinstellungen anzeigen',
    'aps.install.install' => 'Installieren',
    'aps.install.otherSettings' => 'Andere Einstellungen',
    'aps.install.globalSettings' => 'Paketeinstellungen',
    'aps.install.passwordConfirmation' => 'Passwort bestätigen',
    'aps.install.provisionsSectionLabel' => 'Installationspfad',
    'aps.install.context' => 'Geben Sie den Installationsort für diese Webanwendung an',
    'aps.install.registerAsWebmailSection' => 'Webmail-Registrierung',
    'aps.install.registerAsWebmailDescription' => "Wählen Sie diese Option aus, wenn die Anwendung ein Webmail-Client ist. Hierdurch wird die Anwendung unter den verfügbaren Webmail-Services in den Mail-Einstellungen der Abonnement- und Serverpakete angezeigt. Der Administrator kann die URL für den öffentlichen Zugriff auf die Webmail unter \"Serververwaltung\" > \"Einstellungen\" > \"Webmail\" konfigurieren.",
    'aps.install.registerAsWebmailLabel' => 'Als Webmail-Service registrieren',
    'aps.install.addItem' => 'Hinzufügen',
    'aps.install.removeItem' => 'Entfernen',
    'aps.install.updateSettingsSection' => 'Update-Einstellungen',
    'aps.install.forceUpdates' => 'Diese App automatisch aktualisieren, wenn Updates verfügbar sind',
    'aps.install.forceUpdatesHint' => 'Die App erhält automatische Updates auf neuere Versionen. Achtung: Verwenden Sie diese Option mit Vorsicht, denn Updates können die Funktionalität der Apps signifikant beeinträchtigen. Beispielsweise kann es vorkommen, dass App-Erweiterungen mit der Folgeversion einer App nicht mehr funktionieren.',

    'aps.invalid-requirements.requirementsLegend' => 'Anforderungen',
    'aps.invalid-requirements.domainLegend' => 'Webseite',
    'aps.invalid-requirements.context' => 'Andere Website auswählen',
    'aps.invalid-requirements.backToApplicationList' => 'Zurück zur Anwendungsliste',

    'aps.license.title' => 'Installation von %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Zum Installieren dieser Anwendung müssen Sie den Endbenutzer-Lizenzvertrag lesen und den Lizenzbedingungen zustimmen.',
    'aps.license.licenseAgree' => 'Ich akzeptiere die Lizenzbedingungen',

    'aps.services-list-customization.settings' => 'Einstellungen',

    'asp-dot-net.change-version.title' => 'Auswahl der ASP.NET-Version',
    'asp-dot-net.change-version.frameworkVersion' => 'ASP.NET-Framework-Version',
    'asp-dot-net.change-version.success' => 'Die ASP.NET-Version wurde geändert.',

    'asp-dot-net.settings.casSettingsSection' => "Codezugriffssicherheit",
    'asp-dot-net.settings.clientScriptsSection' => "Einstellungen für die Skriptbibliothek",
    'asp-dot-net.settings.connStringsSection' => "Verbindungszeichenfolgen-Manager",
    'asp-dot-net.settings.customErrorsSection' => "Benutzerdefinierte Fehlereinstellungen",
    'asp-dot-net.settings.frameworkVersionSection' => "Framework-Version",
    'asp-dot-net.settings.globalizationSection' => "Globalisierungseinstellungen",
    'asp-dot-net.settings.otherSection' => "Sitzungseinstellungen",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Kompilierung und Debugging",
    'asp-dot-net.settings.authMode' => "Authentifizierungsmodus",
    'asp-dot-net.settings.connStrings' => "Verbindungszeichenfolgen",
    'asp-dot-net.settings.connStringsInvalid' => "Einige Felder sind leer oder enthalten einen ungültigen Wert.",
    'asp-dot-net.settings.connStringName' => "Name",
    'asp-dot-net.settings.connStringValue' => "Verbindungsparameter",
    'asp-dot-net.settings.connStringsDescription' => "Name/Verbindungsparameter",
    'asp-dot-net.settings.culture' => "Sprache und Region",
    'asp-dot-net.settings.customErrMode' => "Benutzerdefinierter Fehlermodus",
    'asp-dot-net.settings.customErrorRedirect' => "URL zur Weiterleitung",
    'asp-dot-net.settings.customErrorStatus' => "Statuscode",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Der Statuscode muss eine ganze Zahl sein.",
    'asp-dot-net.settings.customErrors' => "Benutzerdefinierte Fehler",
    'asp-dot-net.settings.customErrorsDescription' => "Statuscode/Weiterleitungs-URL",
    'asp-dot-net.settings.customErrorsInvalid' => "Einige Felder sind leer oder enthalten einen ungültigen Wert.",
    'asp-dot-net.settings.debugMode' => "Debugging aktivieren",
    'asp-dot-net.settings.defLanguage' => "Standardsprache der Webpage",
    'asp-dot-net.settings.tempDirectory' => "Temporäres Verzeichnis",
    'asp-dot-net.settings.fileEnc' => "Dateikodierung",
    'asp-dot-net.settings.fileEncInvalid' => "Der angegebene Wert für den Parameter Dateikodierung ist ungültig.",
    'asp-dot-net.settings.pathToLib' => "Pfad zur Microsoft Skriptbibliothek",
    'asp-dot-net.settings.pathToLibInstall' => "Installieren",
    'asp-dot-net.settings.reqEnc' => "Anforderungskodierung",
    'asp-dot-net.settings.reqEncInvalid' => "Der angegebene Wert für den Parameter Anfragenkodierung ist ungültig.",
    'asp-dot-net.settings.resEnc' => "Antwortkodierung",
    'asp-dot-net.settings.resEncInvalid' => "Der angegebene Wert für den Parameter Antwortkodierung ist ungültig.",
    'asp-dot-net.settings.sessTimeout' => "Sitzungstimeout (Minuten)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Der angegebene Wert für den Parameter Sitzungstimeout ist ungültig. Geben Sie eine positive ganze Zahl ein, die kleiner oder gleich %%max%% ist.",
    'asp-dot-net.settings.connStringDuplicate' => "Der Name der Verbindungszeichenfolge wird bereits verwendet.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Der Statuscode muss zwischen 100 und 999 liegen",
    'asp-dot-net.settings.customErrorDuplicate' => "Der Statuscode wird bereits verwendet.",
    'asp-dot-net.settings.trustLevel' => "CAS-Vertrauensebene",
    'asp-dot-net.settings.uiCulture' => "UI-Sprache und -Region",
    'asp-dot-net.settings.version' => "Version",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Außerkraftsetzen der CAS-Vertrauensebene auf der Website zulassen',
    'asp-dot-net.settings.updateSuccess' => 'Update war erfolgreich',

    'database.clone.formDescription' => 'Kopieren Sie die Datenbankinhalte in eine neue oder eine bestehende Datenbank. Werden sie in eine bestehende Datenbank kopiert, werden die Tabellen der Quelldatenbank zur Liste der Tabellen in der Zieldatenbank hinzugefügt. Achtung: Wenn es gleiche Tabellennamen gibt, überschreibt die Tabelle aus der Quelle die Tabelle in der Zieldatenbank.',
    'database.clone.copyData' => 'Vollständige Kopie erstellen',
    'database.clone.copyDataHint' => 'Ist diese Option ausgewählt, wird die gesamte Datenbank (einschl. Struktur und Daten) kopiert. Wenn diese Option nicht ausgewählt ist, wird nur die Struktur der Tabellen kopiert.',
    'database.clone.server' => 'Zieldatenbankserver',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Sonstige...',
    'database.clone.database' => 'Zieldatenbank',
    'database.clone.newDatabase' => 'Datenbank mit folgendem Namen erstellen',
    'database.clone.existingDatabase' => 'In vorhandene Datenbank kopieren',
    'database.clone.externalDbHost' => 'Host-Name oder IP-Adresse',
    'database.clone.externalDbLogin' => 'Benutzername',
    'database.clone.externalDbPassword' => 'Passwort',
    'database.clone.subscription' => 'Ziel-Abonnement',
    'database.clone.subscription_powerUser' => 'Ziel-Webspace',
    'database.clone.cloneInProgress' => 'Datenbank %%source%% wird in die Datenbank %%destination%% geklont. Sie werden per E-Mail (%%email%%) über den Fortschritt benachrichtigt.',
    'database.clone.unableToClone' => 'Datenbank "%%source%%" kann nicht kopiert werden.',
    'database.clone.unableToCreateExternalDatabase' => 'Die Datenbank "%%destination%%" kann auf dem angegebenen Server nicht erstellt werden.',
    'database.clone.databaseCloned' => 'Die Datenbank "%%source%%" wurde kopiert.',
    'database.clone.emailSubjSuccess' => 'Die Datenbank "%%sourceDatabase%%" wurde kopiert.',
    'database.clone.emailSubjFailure' => 'Das Kopieren der Datenbank "%%sourceDatabase%%" ist fehlgeschlagen.',
    'database.clone.emailBodySuccess' => 'Die Datenbank "%%sourceDatabase%%" (%%sourceHost%%) wurde in die Datenbank "%%destDatabase%%" (%%destHost%%) kopiert.',
    'database.clone.emailBodyFailure' => 'Die Datenbank "%%sourceDatabase%%" (%%sourceHost%%) kann nicht in die Datenbank "%%destDatabase%%" (%%destHost%%) kopiert werden. Der Kopiervorgang wurde abgebrochen.',
    'database.clone.localServer' => 'lokaler Server',

    'database.repair-orphaned.formDescription' => 'Dieser Benutzer ist nach dem Wiederherstellungsvorgang verwaist. Bitte geben Sie zur Behebung des Problems ein Passwort für den Benutzer an. Wenn dieser Benutzer ein Systembenutzer ohne Passwort sein soll, müssen Sie das Reparaturdienstprogramm ausführen und das Passwortfeld leer lassen.',
    'database.repair-orphaned.login' => 'Datenbankbenutzername',
    'database.repair-orphaned.pass' => 'Passwort',
    'database.repair-orphaned.pass2' => 'Passwort bestätigen',
    'database.repair-orphaned.users' => 'Bei einigen Benutzern sind Probleme aufgetreten. Einige Benutzer sind verwaist und müssen repariert werden, um wieder ordnungsgemäß zu funktionieren.',
    'database.repair-orphaned.orphaned' => 'Der Benutzer ist verwaist. %%gui begin:link%%Reparieren Sie ihn jetzt%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Reparieren',

    'database.repair.fixSelected' => 'Ausgewähltes reparieren',
    'database.repair.fix' => 'Reparieren',

    'database.user.password' => 'Passwort',
    'database.user.passwordConfirmation' => 'Passwort bestätigen',
    'database.user.server' => 'Datenbankserver',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Datenbank',
    'database.user.anyDatabase' => 'Beliebig',
    'database.user.dataAccess' => 'Datenzugriff',
    'database.user.structureAccess' => 'Zugriff auf Struktur',
    'database.user.globalAccess' => 'Übergreifende Berechtigungen',
    'database.user.globalAccessHint' => 'Übergreifende Berechtigungen gelten für alle Datenbanken innerhalb dieses Hosting-Kontos.',
    'database.user.aclRadio' => 'Zugriffssteuerung',
    'database.user.aclLocalhost' => 'Nur lokale Verbindungen zulassen',
    'database.user.aclAny' => 'Remoteverbindungen von beliebigem Host zulassen',
    'database.user.aclCustom' => 'Remoteverbindungen zulassen von',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDie angegebenen Hosts dürfen im Namen dieses Benutzers auf die Datenbank zugreifen.",
    'database.user.remoteAccess' => 'Remotezugriff',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDie angegebenen IP-Adressen dürfen durch eine Firewall-Regel auf den Datenbankserver zugreifen. Ihre Änderungen an dieser Liste werden vorab von Ihrem Hosting-Provider moderiert.",
    'database.user.example' => "Zum Beispiel:\n%%example%%",
    'database.user.denied' => 'Firewallregeln des Systems verwenden',
    'database.user.allowed' => 'Remoteverbindungen zulassen von',
    'database.user.default' => 'Standardmäßig die Benutzerzugangsdaten für den Zugriff auf %%webadmin%% verwenden',
    'database.user.remoteAccessHint' => 'Bitte wenden Sie sich an Ihren Hosting-Provider und stellen Sie sicher, dass die oben gewählte Option den aktuell geltenden Firewallregeln für externe Zugriffe auf MariaDB/MySQL entspricht.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Web Admin',
    'database.user.role' => 'Rolle',
    'database.user.roleReadWrite' => 'Lesen und schreiben',
    'database.user.roleWriteOnly' => 'Nur schreiben',
    'database.user.roleReadOnly' => 'Nur lesen',
    'database.user.roleCustom' => 'Benutzerdefiniert',

    'database.generalSection' => 'Allgemein',
    'database.name' => 'Datenbankname',
    'database.server' => 'Datenbankserver',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Zugehörige Website',
    'database.noDomainRelations' => 'Keine zugehörigen Websites',
    'database.userSection' => 'Benutzer',
    'database.userSectionDescription' => 'Erstellen Sie einen Standard-Datenbankbenutzer. Plesk greift im Namen dieses Benutzers auf die Datenbank zu. Sollten dieser Datenbank keine Datenbankbenutzer zugewiesen sein, kann nicht darauf zugegriffen werden.',
    'database.createUser' => 'Datenbankbenutzer erstellen',
    'database.username' => 'Datenbankbenutzername',
    'database.password' => 'Passwort',
    'database.passwordConfirmation' => 'Passwort bestätigen',
    'database.allDbAccess' => 'Der Benutzer hat Zugriff auf alle Datenbanken innerhalb des ausgewählten Abonnements',
    'database.aclRadio' => 'Zugriffssteuerung',
    'database.aclLocalhost' => 'Nur lokale Verbindungen zulassen',
    'database.aclAny' => 'Remoteverbindungen von beliebigem Host zulassen',
    'database.aclCustom' => 'Remoteverbindungen zulassen von',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDie angegebenen Hosts dürfen im Namen dieses Benutzers auf die Datenbank zugreifen.",
    'database.remoteAccess' => 'Remotezugriff',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDie angegebenen IP-Adressen dürfen durch eine Firewall-Regel auf den Datenbankserver zugreifen. Ihre Änderungen an dieser Liste werden vorab von Ihrem Hosting-Provider moderiert.",
    'database.example' => "Zum Beispiel:\n%%example%%",
    'database.denied' => 'Firewallregeln des Systems verwenden',
    'database.allowed' => 'Remoteverbindungen zulassen von',

    'deployment-section.deploymentDisabledHint' => 'Dateien aus einem Git Repository hochladen',
    'deployment-section.deploymentEnabledHint' => 'Unterstützung von Git aktivieren',
    'deployment-section.deploymentSectionLegend' => 'Zu kopierende Dateien für das Hosting',
    'deployment-section.deploymentSectionDescriptionHint' => 'Wenn Sie den Git-Support deaktiviert lassen, werden die Stammverzeichnisse (Website-/Anwendungs- und Dokumentstamm) leer erstellt. Für die Website wird die Standardseite im Browser angezeigt. Sie müssen die Dateien Ihrer Website mithilfe eines FTPs oder des Dateimanagers in den Dokumentstamm hochladen. Als Alternative können Sie Git jetzt oder später aktivieren (unter Websites & Domains) und die Dateien von einem Git-Repository hochladen.',

    'dns-zone.add-acl-record.description' => 'Fügen Sie eine IP-Adresse eines DNS-Servers hinzu, für den es zulässig ist, eine Kopie der DNS-Zone zu erhalten.',
    'dns-zone.add-acl-record.ipAddress' => 'IP-Adresse',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP-Adresse/Netzwerkmaske',

    'dns-zone.record.add-title' => "Fügen Sie einen Ressourceneintrag zum Zonen-Template hinzu.",
    'dns-zone.record.add-ns-title' => "Fügen Sie einen Nameserver hinzu.",
    'dns-zone.record.edit-title' => "Ressourceneintrag bearbeiten",
    'dns-zone.record.edit-success' => "Der DNS-Eintrag wurde aktualisiert.",
    'dns-zone.record.add-success' => "Der DNS-Eintrag wurde erstellt.",
    'dns-zone.record.type' => "Eintragstyp",
    'dns-zone.record.domainName' => "Domainname",
    'dns-zone.record.domainNamePostfix' => ".<Domain>",
    'dns-zone.record.nameServer' => "Nameserver",
    'dns-zone.record.optionOff' => 'Aus',
    'dns-zone.record.optionOn' => 'Ein',
    'dns-zone.record.protocol' => "Protokoll",
    'dns-zone.record.priority' => "Priorität",
    'dns-zone.record.priorityLow' => "niedrig (%%priority%%)",
    'dns-zone.record.priorityHigh' => "sehr hoch (%%priority%%)",
    'dns-zone.record.weightLow' => "niedrig (%%weight%%)",
    'dns-zone.record.weightHigh' => "sehr hoch (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP-Adresse",
    'dns-zone.record.ipAddressDescription' => "Zum Beispiel 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Zum Beispiel <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6-Adresse",
    'dns-zone.record.ipAddressV6Description' => "Zum Beispiel 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Zum Beispiel <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Zum Beispiel 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Zum Beispiel <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Zum Beispiel 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Kanonischer Name",
    'dns-zone.record.mailDomain' => "E-Mail-Domain",
    'dns-zone.record.mxServer' => "Mail-Exchange-Server",
    'dns-zone.record.mxServerPriority' => "Geben Sie die Priorität des Mail-Exchange-Servers an",
    'dns-zone.record.txtRecord' => "TXT-Eintrag",
    'dns-zone.record.txtRecordString' => "Geben Sie die Eintragszeichenfolge ein",
    'dns-zone.record.txtSpfSyntax' => "SPF-Eintrag",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Für den TXT-Eintrag wurden falsche Werte angegeben.",
    'dns-zone.record.quotedTxtRecord' => "Der Wert des TXT-Eintrags muss eine einzelne Zeichenfolge ohne Anführungszeichen sein.",
    'dns-zone.record.dsRecord' => "DS-Eintrag",
    'dns-zone.record.dsRecordDescription' => "Zum Beispiel 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "Für den DS-Eintrag wurde ein falscher Wert angegeben.",
    'dns-zone.record.serviceName' => "Service-Name",
    'dns-zone.record.serviceNameDescription' => 'Beispiel: SIP (ohne Unterstrich).',
    'dns-zone.record.protocolNameDescription' => 'Beispiel: tcp (ohne Unterstrich).',
    'dns-zone.record.portDescription' => 'Beispiel: 25 (ohne Unterstrich).',
    'dns-zone.record.srvWeight' => "Relative Gewichtung für Einträge mit gleicher Priorität",
    'dns-zone.record.targetHost' => "Zielhost",
    'dns-zone.record.targetHostDescription' => "Zum Beispiel example.com",
    'dns-zone.record.targetPort' => "Zielport",
    'dns-zone.record.targetPortDescription' => 'Zum Beispiel 8443.',
    'dns-zone.record.retrieveDataError' => "Die Eintragsdaten wurden nicht gefunden.",
    'dns-zone.record.unknownTypeError' => "Unbekannter DNS-Eintragstyp.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Es kann kein MX-Eintrag des Typs NULL eingerichtet werden, solange ein anderer MX-Eintrag vorhanden ist.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Es kann kein MX-Eintrag eines anderen Typs als NULL eingerichtet werden, solange ein solcher Eintrag vorhanden ist.',
    'dns-zone.record.masterShouldBeRemote' => "Sie müssen zwei verschiedene autoritative Name Server auf separaten Hosts haben.",
    'dns-zone.record.caaTag' => "Tag",
    'dns-zone.record.caaRecord' => "Wert",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protokoll',
    'dns-zone.record.tlsaUsage' => 'Belegung',
    'dns-zone.record.tlsaSelector' => 'Selektor',
    'dns-zone.record.tlsaMatching' => 'Zuordnungsart',
    'dns-zone.record.tlsaCertData' => 'Daten der Zertifikatszuordnung',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Weitere Details finden Sie in %%link%%',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, Abschnitt 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, Abschnitt 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, Abschnitt 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, Abschnitt 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "Alias (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'Zum Beispiel example.com. Ein leerer Wert bedeutet, dass der Host und der Domainname übereinstimmen.',
    'dns-zone.record.httpsProtocols' => 'Protokolle',
    'dns-zone.record.httpsProtocolsDescription' => 'Eine durch Kommas getrennte Liste von Protokollen, die vom Ziel unterstützt werden. Zum Beispiel: h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Ausschließliche Verwendung der angegebenen Protokolle erzwingen. Die Liste der Protokolle oben darf nicht leer sein.',
    'dns-zone.record.httpsIpv4hint' => 'Hinweis auf IPv4-Adressen',
    'dns-zone.record.httpsIpv4hintDescription' => 'Eine durch Kommas getrennte Liste von IPv4-Adressen, die von einem Client verwendet werden können, um den Dienst zu erreichen.',
    'dns-zone.record.httpsIpv6hint' => 'Hinweis auf IPv6-Adressen',
    'dns-zone.record.httpsIpv6hintDescription' => 'Eine durch Kommas getrennte Liste von IPv6-Adressen, die von einem Client verwendet werden können, um den Dienst zu erreichen.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Sekunden",
    'dns-zone.record.invalidValue' => 'Der Wert ist ungültig. Er muss zwischen 1 und 2147483647 Sekunden liegen.',
    'dns-zone.record.ttlDefaultValue' => 'Standardwert: %%value%% Sekunden',
    'dns-zone.record.invalidTTL' => 'Der angegebene TTL-Wert ist ungültig.',
    'dns-zone.record.invalidIpAddress' => 'Die angegebene IP-Adresse ist ungültig.',
    'dns-zone.record.invalidIpMaskPair' => 'Das angegebene Paar aus IP-Adresse und Netzmaske ist ungültig.',
    'dns-zone.record.invalidCName' => 'Der angegebene kanonische Name ist ungültig.',
    'dns-zone.record.invalidPort' => 'Der angegebene Port ist ungültig.',
    'dns-zone.record.invalidTLSACertData' => 'Die angegebenen Zertifikatszuordnungsdaten sind ungültig.',
    'dns-zone.record.invalidTLSAProtocol' => 'Das angegebene Protokoll ist ungültig.',
    'dns-zone.record.invalidTLSAUsage' => 'Die angegebene Verwendung ist ungültig.',
    'dns-zone.record.invalidTLSASelector' => 'Der angegebene Selektor ist ungültig.',
    'dns-zone.record.invalidTLSAMatching' => 'Die angegebene Zuordnungsart ist ungültig.',

    'dns-zone.restore-default.formHint' => "Hier können Sie die ursprüngliche Zonenkonfiguration gemäß den auf dem Server verwendeten DNS-Template-Standardeinstellungen wiederherstellen. Wählen Sie die IP-Adresse aus, die zum Wiederherstellen der Zone verwendet werden soll und geben Sie an, ob für die Domain ein www-Alias erforderlich ist.",
    'dns-zone.restore-default.ipv4' => "IPv4-Adresse",
    'dns-zone.restore-default.ipv4Hint' => "Zum Beispiel 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6-Adresse",
    'dns-zone.restore-default.ipv6Hint' => "Zum Beispiel 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Die angegebene IP-Adresse ist ungültig.',
    'dns-zone.restore-default.customIpHint' => "Einträge mit dieser IP-Adresse werden als vom Benutzer modifiziert angesehen und nicht mit dem serverweiten DNS-Template synchronisiert.",
    'dns-zone.restore-default.wwwPrefix' => "www-Präfix",
    'dns-zone.restore-default.previewRecords' => "Datensätze, die für die Website-Vorschau verwendet werden, wiederherstellen",

    'dns-zone.soa-record.soaMnameSection' => 'Primärer Nameserver',
    'dns-zone.soa-record.soaMname' => 'Nameserver',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Automatische Auswahl)',
    'dns-zone.soa-record.soaRecordSection' => 'SOA-Eintrag',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Aktualisieren',
    'dns-zone.soa-record.retry' => 'Erneut versuchen',
    'dns-zone.soa-record.expire' => 'Ablauf',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'E-Mail (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'E-Mail-Adresse des Verantwortlichen für die DNS-Zone der Domain. Vom DNS-Server als Antwort auf SOA-Abfragen zurückgegeben.',
    'dns-zone.soa-record.rnameTypeOwner' => 'E-Mail-Adresse des Website-Betreibers',
    'dns-zone.soa-record.rnameTypeDomain' => 'E-Mail-Adresse der Domain',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Nur den lokalen Teil eingeben (den Teil vor @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Externe E-Mail-Adresse',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Ändern der RNAME-E-Mail-Adresse auf Domainbasis verbieten',
    'dns-zone.soa-record.invalidValue' => 'Der Wert ist ungültig. Er muss zwischen 1 Sekunde und 68 Jahren liegen.',
    'dns-zone.soa-record.advancedSection' => 'Erweiterte DNS-Funktionen',
    'dns-zone.soa-record.serialNumberFormat' => 'Von IETF und RIPE empfohlenes Seriennummernformat verwenden',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Wählen Sie diese Option aus, wenn Ihre Domain die SOA-Prüfung des Registrars nicht besteht. Viele Domain-Registrare verlangen dieses Format für die Seriennummer.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Standardeinstellungen verwenden',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Standardeinstellungen der Zone',
    'dns-zone.soa-record.unitSeconds' => 'Sekunden',
    'dns-zone.soa-record.unitMinutes' => 'Minuten',
    'dns-zone.soa-record.unitHours' => 'Stunden',
    'dns-zone.soa-record.unitDays' => 'Tage',
    'dns-zone.soa-record.unitWeeks' => 'Wochen',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Der Wert für den Nachladeintervall ist weniger als eine Stunde. Dadurch kann der Server-Traffic und der Ressourcenverbrauch drastisch erhöht werden.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Wenn Sie den Minimum-TTL-Wert auf über 3 Stunden einstellen, können möglicherweise einige Domainadministratoren nicht auf Ihre Domains zugreifen. Es wird empfohlen, diesen Wert nur dann zu einzustellen, wenn Ihr Domain-Registrar darauf besteht.',
    'dns-zone.soa-record.success' => 'Die Eigenschaften des SOA-Datensatzes wurden aktualisiert.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Der Standard-SOA-Eintrag wurde wiederhergestellt.',

    'domain-info-section.domainName' => 'Domainname',
    'domain-info-section.emptyDomainName' => 'Bitte geben Sie einen Domainnamen an.',
    'domain-info-section.ipAddress' => 'IP-Adresse',
    'domain-info-section.shared' => 'gemeinsam genutzt',
    'domain-info-section.exclusive' => 'dediziert',
    'domain-info-section.ipAddressHint' => "Die IP-Adresse, auf der die Website gehostet wird, ist eine Netzwerkadresse des virtuellen Hosts der Website. Diese IP-Adresse wird für alle innerhalb des Abonnements erstellten Websites verwendet werden.",
    'domain-info-section.ipAddressHint_powerUser' => "Die IP-Adresse auf der die Website gehostet wird, ist eine Netzwerkadresse der Website des virtuellen Hosts. Diese IP-Adresse wird für alle Websites verwendet, die innerhalb des Webspaces erstellt wurden.",
    'domain-info-section.userName' => 'Benutzername',
    'domain-info-section.userNameHint' => 'Systembenutzerkonto, das mit dem Webspace verknüpft ist und über das auf gehostete Dateien über FTP und SSH zugegriffen werden kann',
    'domain-info-section.emptyLogin' => 'Bitte geben Sie einen Benutzernamen an.',
    'domain-info-section.password' => 'Passwort',
    'domain-info-section.emptyPassword' => 'Bitte geben Sie ein Passwort an.',
    'domain-info-section.passwordConfirmation' => 'Passwort wiederholen',

    'email-address.generalTab' => 'Allgemein',
    'email-address.generalHint' => 'Wenn dieses E-Mail-Konto mit einem zusätzlichen Benutzer verbunden ist (Zugang zum Kunden-Panel ist aktiviert), dann beeinflussen die Änderungen, die Sie auf dieser Seite vornehmen, die Einstellungen jenes Benutzers. Das heißt im Besonderen, wenn Sie die E-Mail-Adresse und das Passwort ändern, werden auch der Benutzername und das Passwort des zusätzlichen Benutzers entsprechend geändert.',
    'email-address.redirectTab' => 'Weiterleitung',
    'email-address.redirectHint' => 'Weiterleitung von E-Mail-Nachrichten an eine oder mehrere E-Mail-Adressen einrichten.',
    'email-address.aliasesTab' => 'E-Mail-Aliase',
    'email-address.autoResponderTab' => 'Autom. Antwort',
    'email-address.antispamTab' => 'Spamfilter',
    'email-address.autoResponderHint' => 'Erstellen Sie eine automatische Antwortnachricht für jede E-Mail, die an Ihre E-Mail-Adresse versendet wird. Der Autoresponder ist eine Standardmethode, um Absender zu benachrichtigen, dass Sie abwesend oder verreist sind.',
    'email-address.antivirusTab' => 'Virenschutz',
    'email-address.name' => 'E-Mail-Adresse',
    'email-address.externalEmail' => 'Externe E-Mail-Adresse',
    'email-address.externalEmailHint' => 'Wird zum Zurücksetzen Ihres Passworts verwendet, falls Sie den Zugriff auf Ihre primäre E-Mail-Adresse verlieren.',
    'email-address.user' => 'Wem zugewiesen',
    'email-address.password' => 'Passwort',
    'email-address.passwordConfirmation' => 'Passwort bestätigen',
    'email-address.clientConfigurationLink' => 'Link zur E-Mail-Konfiguration',
    'email-address.responderEnable' => 'Automatische Antwort einschalten',
    'email-address.responderSubject' => 'Betreff der autom. Antwort',
    'email-address.responderContentType' => 'Nachrichtenformat',
    'email-address.responderContentTypeHint' => 'Das Nur-Text-Format wird von allen E-Mail-Client-Programmen unterstützt, dabei sehen alle Empfänger die Nachricht auf dieselbe Weise wie Sie. HTML-Nachrichten sehen besser aus, da formatierter Text mit unterschiedlichen Schrifttypen eingegeben werden kann. Jedoch unterstützen einige E-Mail-Clients HTML-Nachrichten nicht, weswegen einige Empfänger den formatierten Text möglicherweise nicht sehen.',
    'email-address.responderContentTypeTextPlain' => 'Nur-Text-Format',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Kodierung',
    'email-address.responderCodepageHint' => 'Die Kodierung definiert, wie Textzeichen angezeigt werden. Die empfohlene Kodierung ist UTF-8.',
    'email-address.responderReplyTo' => 'Weiterleiten an',
    'email-address.responderReplyToHint' => 'Wenn die automatische Nachricht versendet wird, dann wird die originale Nachricht an die angegebene E-Mail-Adresse weitergeleitet.',
    'email-address.responderForwardAddress' => 'Weiterleiten an',
    'email-address.responderForwardAddressHint' => 'Wenn die automatische Nachricht versendet wird, dann wird die originale Nachricht an die angegebene E-Mail-Adresse weitergeleitet.',
    'email-address.responderMessage' => 'Nachrichtentext der automatischen Antwort',
    'email-address.responderReplyToEqualsEmail' => 'Die angegebene E-Mail-Adresse zur Weiterleitung ist dieselbe wie diese E-Mail-Adresse.',
    'email-address.responderForwardAddressEqualsEmail' => 'Die angegebene E-Mail-Adresse zur Weiterleitung ist dieselbe wie diese E-Mail-Adresse.',
    'email-address.responderReplyLimit' => 'Automatische Antwort an dieselbe E-Mail-Adresse nicht mehr als x Male pro Tag senden',
    'email-address.buttonAddResponderAttachment' => 'Anhang hinzufügen',
    'email-address.buttonRemoveResponderAttachment' => 'Entfernen',
    'email-address.responderAttachment' => 'Datei anhängen',
    'email-address.redirectEnable' => 'E-Mail-Weiterleitung aktivieren',
    'email-address.redirectRemoveEnable' => 'Keine Kopien der weitergeleiteten E-Mails im Posteingang von Plesk speichern',
    'email-address.redirectAddress' => 'Eingehende Nachrichten an folgende E-Mail-Adresse weiterleiten',
    'email-address.redirectAddressHint' => 'Geben Sie E-Mail-Adressen an. Geben Sie jede Adresse in eine neue Zeile ein oder trennen Sie diese durch Leerzeichen, Kommas oder Semikolons.',
    'email-address.role' => 'Benutzerrolle',
    'email-address.roleHint' => 'Benutzerrollen gewähren Benutzern Administrationsrechte und Zugriff auf Anwendungen, die Sie für die jeweilige Rolle ausgewählt haben.',
    'email-address.errorRedirectAddress' => 'Sie haben eine ungültige E-Mail-Adresse angegeben: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Sie haben ungültige E-Mail-Adressen angegeben: %value%.',
    'email-address.mailAlias' => "E-Mail-Alias",
    'email-address.mailAliasNone' => 'Ohne',
    'email-address.mailAliasHint' => "E-Mail-Aliases sind alternative E-Mail-Adressen, die primären E-Mail-Adressen zugeordnet sind. Alle an E-Mail-Aliases gesendeten E-Mails gehen an die primäre E-Mail-Adresse.",
    'email-address.buttonAddMailAlias' => 'E-Mail-Alias hinzufügen',
    'email-address.buttonRemoveMailAlias' => 'Entfernen',
    'email-address.emptyEmail' => 'Geben Sie eine E-Mail-Adresse für die Weiterleitung von allen eingehenden E-Mails an.',
    'email-address.emailsIsEqual' => 'Die externe E-Mail-Adresse stimmt mit der primären überein. Geben Sie bitte eine andere externe E-Mail-Adresse an.',
    'email-address.emptyPassword' => 'Sie müssen ein Passwort angeben.',
    'email-address.emptyPasswordConfirmation' => 'Sie müssen das Passwort bestätigen.',
    'email-address.emptyAlias' => "Geben Sie einen E-Mail-Alias für diese E-Mail-Adresse an.",
    'email-address.aliasEqualsEmail' => 'Der angegebene E-Mail-Alias weist denselben Namen wie die E-Mail-Adresse auf.',
    'email-address.passwordHint' => 'Wird für den Zugriff auf das Postfach und zum Anmelden in Plesk verwendet (wenn die entsprechende Option aktiviert ist).',
    'email-address.cyclicRedirect' => 'E-Mail-Adresse kann nicht für die Weiterleitung von E-Mail-Nachrichten an sich selbst eingerichtet werden.',
    'email-address.errorMailnameReserved' => 'Die angegebene E-Mail-Adresse wird bereits verwendet.',
    'email-address.antivirusEnable' => 'Virenschutz für diese E-Mail-Adresse einschalten',
    'email-address.antivirusHint' => 'Der Virenschutz blockiert E-Mails, die Viren enthalten, und benachrichtigt sowohl Sender als auch Empfänger.',
    'email-address.antivirusSettings' => 'Auf Viren prüfen',
    'email-address.antivirusSettingOnlyIncomingMail' => 'nur eingehende E-Mails',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'nur ausgehende E-Mails',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'Eingehende und ausgehende E-Mails',
    'email-address.antispamHint' => 'Der Spamfilter-Service erkennt Spam-Mails, die an die E-Mail-Adresse versendet werden. Sie können den Spamfilter so einrichten, dass Spamnachrichten gelöscht werden, sie durch eine geänderte Betreffzeile hervorgehoben werden oder in einen besonderen Spamordner verschoben werden, der E-Mail-Kunden über IMAP zur Verfügung steht. Der Spamfilter verwendet eine Vielzahl von lokalen Tests und Netzwerktests, um Spamsignaturen zu erkennen.',
    'email-address.antispamEnable' => 'Spamfilter für diese E-Mail-Adresse einschalten',
    'email-address.antispamSettings' => 'Was mit Nachrichten geschehen soll, die als Spam eingestuft werden',
    'email-address.antispamSettingsMark' => 'Spamnachrichten durch folgenden Text in der Betreffzeile kennzeichnen',
    'email-address.antispamSettingsMarkHint' => 'Lassen Sie dieses Feld leer, wenn Sie keinen Text hinzufügen möchten. Geben Sie "_SCORE_" ein, wenn die Punktzahl im Nachrichtenbetreff enthalten sein soll.',
    'email-address.antispamReportTextHint' => 'Geben Sie den Text ein, der zu dem Text in Spamnachrichten hinzugefügt werden soll.',
    'email-address.antispamSettingsDelete' => 'Alle Spamnachrichten löschen',
    'email-address.antispamSettingsDeleteHint' => 'Spamnachrichten werden aus Ihrem Postfach gelöscht.',
    'email-address.antispamSettingsMove' => 'Spam in den Spamordner verschieben',
    'email-address.antispamSettingsMoveHint' => 'Alle Spamnachrichten in den Spamordner verschieben. Dieser Ordner ist über Ihr E-Mail-Client-Programm oder Webmail zugänglich. Wenn Sie ein IMAP-Mail-Konto benutzen, können Sie den Spamordner zum Trainieren des Spamfilters verwenden.',
    'email-address.antispamSettingsMoveWarning' => '"Spam in den Spamordner verschieben" funktioniert nur, wenn die Option "Keine Kopien der weitergeleiteten E-Mails im Posteingang von Plesk speichern" auf dem Tab "Weiterleitung" deaktiviert ist.',
    'email-address.antispamSettingsMoveJunk' => 'Spam in den Junk-E-Mail-Ordner verschieben',
    'email-address.antispamSettingsMoveJunkHint' => 'Alle Spamnachrichten in den Junk-E-Mail-Ordner verschieben. Dieser Ordner ist über Ihr E-Mail-Client-Programm oder Webmail zugänglich. Wenn Sie ein IMAP-E-Mail-Konto verwenden, können Sie den Junk-E-Mail-Ordner zum Trainieren des Spamfilters verwenden.',
    'email-address.antispamShowAdvancedSection' => 'Erweiterte Einstellungen einblenden',
    'email-address.antispamHideAdvancedSection' => 'Erweiterte Einstellungen ausblenden',
    'email-address.antispamLearnMore' => 'Erfahren Sie, wie Sie den Spamfilter trainieren',
    'email-address.antispamFilterScoreTitle' => 'Filter-Empfindlichkeit',
    'email-address.antispamFilterScoreHint' => 'Der Spamfilter führt eine Vielzahl von unterschiedlichen Tests zu Inhalt und Betreffzeile jeder Nachricht durch. Im Ergebnis erhält jede Nachricht eine Punktzahl. Je höher die Punktzahl desto höher ist die Wahrscheinlichkeit, dass es sich um eine Spamnachricht handelt. Standardmäßig wird die Spamfilter-Empfindlichkeit so eingestellt, dass Nachrichten mit 7 oder mehr Punkten als Spam klassifiziert werden. Wenn Sie viele Spamnachrichten mit der aktuellen Einstellung erhalten, können Sie den Filter anders einstellen und einen niedrigeren Wert festlegen, z. B. 6. Wenn Sie E-Mails nicht erhalten, da Ihr Spamfilter diese als Spam einstuft, dann können Sie die Spamfilter-Empfindlichkeit reduzieren, indem Sie einen höheren Wert festlegen, z. B. 8.',
    'email-address.antispamFilterScore' => 'Spamfilter-Empfindlichkeit',
    'email-address.antispamWhiteListTitle' => 'Whitelist',
    'email-address.antispamWhiteListHint' => 'E-Mails von Absendern in der weißen Liste werden nicht vom Spamfilter überprüft.',
    'email-address.antispamWhiteListField' => 'Whitelist',
    'email-address.antispamWhiteListFieldHint' => 'Geben Sie Domainnamen ein, ein Domainname pro Zeile. Adressen dürfen die folgenden Platzhalterzeichen enthalten: "*" und "?" (zum Beispiel: *@domain.com, user?@*.com)',
    'email-address.antispamBlackListTitle' => 'Schwarze Liste',
    'email-address.antispamBlackListHint' => 'E-Mails von Absendern in der schwarzen Liste werden als Spam eingestuft.',
    'email-address.antispamBlackListField' => 'Schwarze Liste',
    'email-address.antispamBlackListFieldHint' => 'Geben Sie Domainnamen ein, eine Domain pro Zeile. Adressen dürfen die folgenden Platzhalterzeichen enthalten: "*" und "?" (zum Beispiel: *@domain.com, user?@*.com)',
    'email-address.antispamTrustedLanguagesTitle' => 'Vertrauenswürdige Gebietsschemas',
    'email-address.antispamTrustedLanguagesHint' => 'E-Mail-Nachrichten in diesen Sprachen werden immer den Filter passieren .',
    'email-address.antispamTrustedLocalesTitle' => 'Vertrauenswürdige Gebietsschemas',
    'email-address.antispamTrustedLocalesHint' => 'E-Mail-Nachrichten, die die angegebenen Sprachgruppen verwenden, werden immer den Filter passieren . Sprachgruppen enthalten die am häufigsten genutzten Zeichensätze. Zum Beispiel enthält der westliche Zeichensatz Kodierungen für Buchstaben, die in der englischen und in westeuropäischen Sprachen benutzt werden.',
    'email-address.antispamTrustedNetworksTitle' => 'Vertrauenswürdige Netzwerke',
    'email-address.antispamTrustedNetworksHint' => 'Die Relay-Hosts auf vertrauenswürdigen Netzwerken werden für gewöhnlich nicht von Spammern verwendet und sie sind keine offenen Relays oder offenen Proxys.',
    'email-address.antispamIpAddressesField' => 'IP-Adressen',
    'email-address.antispamIpAddressesFieldHint' => 'Geben Sie die Netzwerk-IP-Adresse und Maske an.',
    'email-address.mailBoxQuotaDomainDefault' => 'Standardgröße (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Standardgröße',
    'email-address.mailBoxOutgoingMessages' => 'Maximale Anzahl an ausgehenden E-Mails',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Standard (%%domainOutgoingMessages%% Nachrichten pro Stunde)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Benutzerdefinierter Wert für das Postfach',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'Nachrichten',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Standard',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Standardgröße',
    'email-address.mailBoxQuotaDomainSpecific' => 'Andere Größe',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Postfachgröße',
    'email-address.mailBoxQuotaUnlimited' => 'Unbegrenzt',
    'email-address.mailBoxLimitReached' => 'Sie haben die Grenze für die Anzahl an Postfächern erreicht.',
    'email-address.postboxEnabled' => 'E-Mail-Postfach',
    'email-address.postboxEnabledYes' => 'Ja',
    'email-address.postboxEnabledNo' => 'Nein',
    'email-address.description' => 'Beschreibung in Plesk',
    'email-address.descriptionHint' => 'Die Beschreibung ist für jeden sichtbar, der Zugriff auf dieses E-Mail-Konto hat.',
    'email-address.longDescription' => 'Die angegebene Beschreibung ist zu lang. Es dürfen höchstens %%max%% Zeichen verwendet werden.',
    'email-address.loginAsUser' => 'Kann zur Anmeldung in Plesk verwendet werden.',
    'email-address.loginAsUserDescription' => '(Benutzername: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Die Postfachgröße darf die Standardgröße nicht überschreiten.',
    'email-address.endDateEnable' => 'Automatische Antwort ausschalten am',

    'failed-request.enable-tracing.description' => 'Die Ablaufverfolgung für Anforderungsfehler ist eine ressourcenintensive Operation. Die Ablaufverfolgung wird automatisch in %%days%% Tag(en) beendet. Sie können sie jedoch jederzeit manuell beenden.',
    'failed-request.enable-tracing.statusCodes' => 'Statuscodes',
    'failed-request.enable-tracing.statusCodesDescription' => 'Beispiel: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Anbieter',

    'file-manager.show.buttonReload' => 'Neu laden',
    'file-manager.show.buttonSave' => 'Speichern',
    'file-manager.show.buttonSaveAs' => 'Speichern als',
    'file-manager.show.buttonReset' => 'Zurücksetzen',
    'file-manager.show.buttonTextCodeEditor' => 'In Code-Editor bearbeiten',
    'file-manager.show.buttonTextEdit' => 'In Texteditor bearbeiten',
    'file-manager.show.buttonWysiwygEdit' => 'In HTML-Editor bearbeiten',
    'file-manager.show.eolLabel' => 'Art des Zeilenumbruchs:',
    'file-manager.show.saveAs' => 'Speichern als:',
    'file-manager.show.saveCodepage' => 'In der folgenden Kodierung speichern:',
    'file-manager.show.loadCodepage' => 'Originaldatei in der folgenden Kodierung anzeigen:',
    'file-manager.show.loadCodepageHint' => 'Warnung: Alle nicht gespeicherten Änderungen gehen beim Neuladen der Datei verloren.',
    'file-manager.show.fileExists' => "Die Datei oder der Ordner %%fileName%% ist bereits vorhanden. Ordner und Dateien mit gleichen Namen sind unzulässig.",
    'file-manager.show.popupTitle' => 'Speichern als',
    'file-manager.show.popupFilename' => 'Dateiname:',

    'file-manager.permissions.filePermissions' => 'Dateiberechtigungen',
    'file-manager.permissions.directoryPermissions' => 'Verzeichnisberechtigungen',
    'file-manager.permissions.buttonSubmit' => 'Speichern',
    'file-manager.permissions.buttonApply' => 'Speichern und fortsetzen',
    'file-manager.permissions.buttonCancel' => 'Abbrechen',
    'file-manager.permissions.buttonAdvanced' => 'Erweitert',

    'file-manager.unix-file-permissions.group' => 'Gruppe',
    'file-manager.unix-file-permissions.owner' => 'Eigentümer',
    'file-manager.unix-file-permissions.others' => 'Andere',
    'file-manager.unix-file-permissions.readMode' => 'Lesen',
    'file-manager.unix-file-permissions.writeMode' => 'Schreiben',
    'file-manager.unix-file-permissions.execMode' => 'Ausführen/Suchen',
    'file-manager.unix-file-permissions.changeRecursive' => 'Berechtigungen rekursiv ändern',

    'file-manager.windows-permissions.allow' => 'Zulassen',
    'file-manager.windows-permissions.deny' => 'Verweigern',
    'file-manager.windows-permissions.inheritFromParent' => 'Vererbbare Berechtigungen von übergeordneten Objekten dürfen an dieses und alle untergeordneten Objekte weitergegeben werden. Diese Berechtigungen sollen mit den hier explizit definierten Einträgen kombiniert werden',
    'file-manager.windows-permissions.replaceOnChildren' => 'Berechtigungseinträge für alle untergeordneten Objekte mit den hier angezeigten Einträgen ersetzen',
    'file-manager.windows-permissions.buttonAdvanced' => 'Erweitert',
    'file-manager.windows-permissions.applyTo' => 'Anwenden auf:',
    'file-manager.windows-permissions.folderOnly' => 'Nur dieser Ordner',
    'file-manager.windows-permissions.subfolderOnly' => 'Nur Unterordner',
    'file-manager.windows-permissions.filesOnly' => 'Nur Dateien',
    'file-manager.windows-permissions.permissionsFor' => 'Berechtigungen für',
    'file-manager.windows-permissions.applyOnto1' => 'Nur dieser Ordner',
    'file-manager.windows-permissions.applyOnto2' => 'Nur Unterordner',
    'file-manager.windows-permissions.applyOnto3' => 'Dieser Ordner und Unterordner',
    'file-manager.windows-permissions.applyOnto4' => 'Nur Dateien',
    'file-manager.windows-permissions.applyOnto5' => 'Dieser Ordner und Dateien',
    'file-manager.windows-permissions.applyOnto6' => 'Nur Unterordner und Dateien',
    'file-manager.windows-permissions.applyOnto7' => 'Dieser Ordner, Unterordner und Dateien',
    'file-manager.windows-permissions.notInherited' => '<nicht vererbt>',

    'file-manager.editor.titleTextEditor' => 'Texteditor',
    'file-manager.editor.titleCodeEditor' => 'Code-Editor',
    'file-manager.editor.titleCodeViewer' => 'Anzeigen',
    'file-manager.editor.buttonSubmit' => 'Speichern',
    'file-manager.editor.buttonApply' => 'Speichern und fortsetzen',
    'file-manager.editor.buttonSaveAs' => 'Speichern als...',
    'file-manager.editor.buttonCancel' => 'Abbrechen',
    'file-manager.editor.exitConfirmationYes' => 'Ja',
    'file-manager.editor.exitConfirmationNo' => 'Nein',
    'file-manager.editor.fileOverwrite' => 'Datei ist bereits vorhanden.',
    'file-manager.editor.fileOverwriteDescription' => 'Eine Datei mit demselben Namen ist bereits vorhanden. Möchten Sie sie überschreiben?',
    'file-manager.editor.exitConfirmation' => 'Möchten Sie die Datei wirklich schließen und die nicht gespeicherten Änderungen verwerfen?',
    'file-manager.editor.buttonCodeEditor' => 'Im Code-Editor bearbeiten',
    'file-manager.editor.buttonTextEditor' => 'Im Texteditor bearbeiten',
    'file-manager.editor.buttonHtmlEditor' => 'Im HTML-Editor bearbeiten',

    'file-manager.import-file.buttonSubmit' => 'Importieren',
    'file-manager.import-file.fieldUrl' => 'URL für die Datei',
    'file-manager.import-file.fieldUrlDescription' => 'Geben Sie die Quell-URL an, z. B. https://example.com/example.tgz.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Das vollständige URL-Muster lautet: https://benutzer:passwort@example.com/example.tgz. Der Benutzername und das Passwort sind optional. Die unterstützten Protokolle sind http, https, ftp und ftps. Verwenden Sie die URL-Codierung für Abschnitte der URL, die Sonderzeichen oder Leerzeichen enthalten.',
    'file-manager.import-file.failure' => 'Datei kann nicht importiert werden.',

    'file-manager.rotation-settings.title' => 'Einstellungen zur Rotation im Papierkorb',
    'file-manager.rotation-settings.rotationBySize' => 'Nach Größe rotieren',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Mit dieser Option werden neue Dateien gelöscht, solange das angegebene Limit für den Papierkorb überschritten wird.',
    'file-manager.rotation-settings.rotationByDate' => 'Nach Datum rotieren',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Tage',
    'file-manager.rotation-settings.rotationByDateHint' => 'Mit dieser Option werden Dateien gelöscht, die länger als eine bestimmte Anzahl von Tagen im Papierkorb gespeichert sind.',
    'file-manager.rotation-settings.save' => 'Speichern',
    'file-manager.rotation-settings.cancel' => 'Abbrechen',

    'ftp-user.description' => 'Wenn Sie zusammen mit anderen Personen an Ihrer Website arbeiten oder Subdomains für andere Benutzer hosten, möchten Sie möglicherweise separate FTP-Konten erstellen.',
    'ftp-user.generalSection' => 'Allgemein',
    'ftp-user.login' => 'FTP-Kontoname',
    'ftp-user.home' => 'Basisverzeichnis',
    'ftp-user.systemArea' => 'FTP-Konto mit Zugriff auf Dateien außerhalb des Basisverzeichnisses erstellen',
    'ftp-user.password' => 'Passwort',
    'ftp-user.passwordConfirmation' => 'Passwort bestätigen',
    'ftp-user.hardQuotaSection' => 'Speicherplatzkontingent',
    'ftp-user.hardQuota' => 'Speicherplatzkontingent',
    'ftp-user.hardQuotaUnlimited' => 'Unbegrenzt',
    'ftp-user.permissionsSection' => 'Berechtigungen',
    'ftp-user.permissionRead' => 'Leseberechtigung',
    'ftp-user.permissionWrite' => 'Schreibberechtigung',
    'ftp-user.popupTitle' => 'Verzeichnis auswählen',
    'ftp-user.limitMbUnits' => 'MB',

    'mail-list.listName' => 'Mailinglistenadresse',
    'mail-list.enabled' => 'Eingeschaltet',
    'mail-list.administratorEmail' => 'E-Mail-Adresse des Mailinglisten-Administrators',
    'mail-list.password' => 'Passwort',
    'mail-list.passwordConfirmation' => 'Passwort bestätigen',
    'mail-list.subscribers' => 'Mitglieder',
    'mail-list.subscribersHint' => 'Geben Sie E-Mail-Adressen an. Geben Sie jede Adresse in eine neue Zeile ein oder trennen Sie die Adressen durch ein Leerzeichen, Komma oder Semikolon.',
    'mail-list.notify' => 'Administrator über die Erstellung der Mailingliste benachrichtigen',
    'mail-list.emptyPassword' => 'Geben Sie ein Passwort an.',
    'mail-list.emptyPasswordConfirmation' => 'Bitte bestätigen Sie das Passwort.',
    'mail-list.errorSubscribers' => 'Ungültige E-Mail-Adressen: %value%.',
    'mail-list.errorMaillistReserved' => 'Die angegebene Mailingliste wird bereits verwendet.',

    'mail-settings.copyToClipboard' => 'DNS-Eintrag in Zwischenablage kopieren.',
    'mail-settings.copySuccess' => 'Der DNS-Eintrag wurde in die Zwischenablage kopiert.',
    'mail-settings.hint' => 'Hier können Sie die Einstellungen des E-Mail-Services für diese Domain ändern.',
    'mail-settings.service' => 'E-Mail-Dienst in dieser Domain',
    'mail-settings.nonExist' => 'Vorgehensweise bei E-Mails an nicht vorhandene Benutzer',
    'mail-settings.nonExistBounceWithMessage' => 'Zurücksenden mit Nachricht',
    'mail-settings.nonExistBounce' => 'Bounce (Zurücksenden)',
    'mail-settings.nonExistCatch' => 'Weiterleitung an Adresse',
    'mail-settings.nonExistCatchDescription' => 'Die Adresse muss zur ausgewählten Domain gehören. Nur der Administrator kann eine externe Adresse oder eine gemeinsame Adresse für mehrere Domains angeben.',
    'mail-settings.nonExistExternal' => 'Umleitung an externen Mailserver mit der IP-Adresse',
    'mail-settings.nonExistReject' => 'Abweisen',
    'mail-settings.nonExistDiscard' => 'Abweisen',
    'mail-settings.webmail' => 'WebMail',
    'mail-settings.webmailNone' => 'Ohne',
    'mail-settings.webmailComponentNotInstalled' => 'Die Webmail-Komponente wurde nicht installiert.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Es besteht eine Subdomain mit dem Namen %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'SSL/TLS-Zertifikat für Webmail',
    'mail-settings.webmailCertificateNone' => 'Nicht ausgewählt',
    'mail-settings.mailCertificate' => 'SSL/TLS-Zertifikat für E-Mail',
    'mail-settings.mailCertificateNone' => 'Nicht ausgewählt',
    'mail-settings.serverCertificateNotSelected' => 'Das Zertifikat wurde zugewiesen, die E-Mail-Funktion für die Domain wurde jedoch nicht geschützt. Wenn Sie auch E-Mails für die Domain schützen möchten, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'schützen Sie den Mailserver',
    'mail-settings.mailLists' => 'Mailinglisten aktivieren',
    'mail-settings.mailAutodiscovery' => 'Automatische E-Mail-Erkennung aktivieren',
    'mail-settings.mailAutodiscoveryDescription' => 'Weitere Informationen dazu finden Sie in der %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'Knowledge Base',
    'mail-settings.domainKeys' => 'DKIM-Spamschutzsystem zum Signieren ausgehender E-Mail-Nachrichten verwenden',
    'mail-settings.activeDkimSelector' => 'Aktiver DKIM-Selektor',
    'mail-settings.defaultDkimSelector' => ' (Plesk als Standard)',
    'mail-settings.dkimSelectorName' => 'Name des Selektors',
    'mail-settings.buttonCreateSelector' => 'Neuen DKIM-Selektor erstellen',
    'mail-settings.createSelectorDialogTitle' => 'DKIM-Selektor erstellen',
    'mail-settings.removeSelectorDialogTitle' => 'DKIM-Selektor entfernen',
    'mail-settings.removeSelectorConfirmation' => "Sollen der Selektor \"%%selector%%\" sowie die verknüpften Schlüssel und DNS-Einträge entfernt werden?",
    'mail-settings.buttonConfirm' => 'OK',
    'mail-settings.buttonCreate' => 'Erstellen',
    'mail-settings.buttonCancel' => 'Abbrechen',
    'mail-settings.labelRemoveSelector' => 'Entfernen',
    'mail-settings.labelActiveSelector' => 'Aktiv',
    'mail-settings.greyListing' => 'Greylisting-Spamschutz für alle E-Mail-Konten dieser Domain aktivieren',
    'mail-settings.howToConfigureExternalDns' => 'Konfiguration des externen DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Um die DKIM-Signierung zu aktivieren, wenn Sie einen externen DNS-Server verwenden, müssen Sie DKIM-DNS-Einträge auf dem DNS-Server konfigurieren.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Verwenden Sie dazu die DKIM-DNS-Einträge unten:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Wenn Sie Domain-Aliasse zum Senden von E-Mails verwenden, fügen Sie die DKIM-DNS-Einträge auch für diese hinzu. Verwenden Sie die gleichen Einträge wie für die Hauptdomain, aber mit dem Domain-Aliasnamen.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Um die DKIM-DNS-Einträge abzurufen, die Sie konfigurieren müssen, aktivieren Sie das Kontrollkästchen "%%option%%", wenden Sie die Auswahl an und öffnen Sie dieses Pop-up-Fenster erneut.',
    'mail-settings.mailServiceDisabled' => 'Deaktiviert',
    'mail-settings.mailServiceDisabledIncoming' => 'Für eingehende E-Mails deaktiviert',
    'mail-settings.mailServiceDisabledHint' => 'Plesk stellt für diese Domain keine Maildienste zur Verfügung.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Auf dieser Domain können E-Mails nur gesendet werden, und zwar ausschließlich via Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Aktiviert',
    'mail-settings.mailServiceEnabledHint' => 'Auf dieser Domain können E-Mails gesendet und empfangen werden.',
    'mail-settings.mailServiceNotConfigured' => 'Nicht konfiguriert',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk stellt für diese Domain keine Maildienste zur Verfügung.',
    'mail-settings.warning' => 'Damit werden die Postfächer der Domain mit allen empfangenen und gesendeten E-Mails dauerhaft entfernt.',
    'mail-settings.show.title' => 'Alle Postfächer und E-Mails von %%domain%% entfernen',
    'mail-settings.show.checkbox' => 'Alle Postfächer von <b>%%domain%%</b> dauerhaft entfernen, einschließlich empfangener und gesendeter E-Mails.',

    'role.roleSection' => 'Allgemein',
    'role.name' => 'Name der Benutzerrolle',
    'role.description' => 'Beschreibung',
    'role.generalPermissionsSection' => 'Zugriff auf Plesk Services',
    'role.applicationsAccessSection' => 'Zugriff auf Anwendungen',
    'role.permissionAllow' => 'Gewährt',
    'role.permissionDeny' => 'Nicht gewährt',
    'role.emptyRoleName' => 'Bitte geben Sie einen Rollennamen an',
    'role.installedAt' => 'Installiert auf',
    'role.noInstallationUrlAvailable' => 'Externe Anwendung',
    'role.invalidRoleName' => 'Der angegebene Benutzerrollenname ist nicht gültig. Der Rollenname darf keine Fragezeichen oder Anführungszeichen enthalten.',
    'role.longRoleName' => 'Der angegebene Name der Benutzerrolle ist zu lang.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Einige Vorgänge sind unter Umständen nicht verfügbar: Eine Berechtigung für einen Vorgang wird nicht mit dem ausgewählten Abonnement gewährt oder die zur Verfügung stehenden Ressourcen reichen nicht aus.',
    'role.servicesPermissionsDescription' => 'Definieren Sie den Zugriff auf installierte Anwendungen oder Plesk Services für alle Benutzer mit dieser Rolle. Wenn Sie einem Benutzer Zugriff auf eine Anwendung gewähren, wird diese für den Benutzer über das Kunden-Panel zugänglich.',
    'role.emailActivation' => 'Accounts dieser Rolle per E-Mail aktivieren',

    'service.admin-access.adminAccess' => 'Administratorzugang',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Diese Zugangsdaten werden für den Admin-Zugang zur Anwendung genutzt.',
    'service.admin-access.login' => 'Administrator-Benutzername',
    'service.admin-access.password' => 'Administrator-Passwort',
    'service.admin-access.passwordConfirmation' => 'Passwort bestätigen',

    'service.info.service-entry-point.availableAt' => 'Verfügbar unter',
    'service.info.service-entry-point.customize' => 'Verknüpfung anpassen',
    'service.info.service-entry-point.displayNameLabel' => 'Name der Verknüpfung',
    'service.info.service-entry-point.displayNameDescription' => 'Geben Sie einen Namen für diese Verknüpfung an. Der Name wird unter dem Verknüpfungssymbol angezeigt. Verknüpfungen werden auf dem Desktop der Benutzer platziert, denen Zugriff auf diese Anwendung gewährt wurde.',
    'service.info.service-entry-point.descriptionLabel' => 'Beschreibung der Verknüpfung',
    'service.info.service-entry-point.descriptionDescription' => 'Geben Sie eine Beschreibung für diese Verknüpfung an. Die Beschreibung wird als Tooltip angezeigt, wenn Sie mit der Maus auf die Verknüpfung zeigen.',
    'service.info.service-entry-point.iconLabel' => 'Klicken Sie auf das Verknüpfungssymbol',
    'service.info.service-entry-point.iconCurrent' => 'Aktuelles Symbol',
    'service.info.service-entry-point.errorEmptyName' => 'Sie müssen einen Verknüpfungsnamen angeben',
    'service.info.service-entry-point.errorLongName' => 'Verknüpfungsname muss zwischen 1 und 255 Zeichen enthalten.',
    'service.info.service-entry-point.errorLongDescription' => 'Verknüpfungsbeschreibung muss zwischen 0 und 255 Zeichen enthalten.',
    'service.info.service-entry-point.hiddenLabel' => 'Verknüpfung ausblenden',
    'service.info.service-entry-point.hiddenDescription' => 'Diese Verknüpfung für Benutzer nicht anzeigen.',

    'service.info.service-permission.assignedUser' => "Diesem Benutzer Administratorzugriff gewähren",
    'service.info.service-permission.assignedUserNone' => 'Kein Benutzer zugewiesen',

    'shared-ssl.master-ssl.switchedOn' => 'Shared SSL/TLS aktivieren',
    'shared-ssl.master-ssl.domainName' => 'Domainname einer Website, deren SSL/TLS-Zertifikat mit anderen Websites gemeinsam genutzt wird',
    'shared-ssl.master-ssl.none' => 'Keines',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Shared SSL/TLS kann nicht aktiviert werden, da keine Domains mit aktivierter SSL/TLS-Unterstützung vorhanden sind.',

    'user.email.email' => 'E-Mail-Adresse',
    'user.email.emptyEmail' => 'Sie müssen eine E-Mail-Adresse angeben.',
    'user.email.internalEmailHint' => 'Erstellen Sie eine neue E-Mail-Adresse in Plesk oder verwenden Sie eine externe E-Mail-Adresse.',
    'user.email.longInternalEmail' => 'Die E-Mail-Adresse ist zu lang.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Der Benutzernamenteil der E-Mail-Adresse ist zu lang für diesen Mailserver. Bitte geben Sie einen Benutzernamen an, der nicht mehr als %%max%% Zeichen enthält.',
    'user.email.longInternalEmailFullAddressMailServer' => 'Die E-Mail-Adresse ist zu lang für diesen Mailserver. Bitte geben Sie eine Adresse an, die nicht mehr als %%max%% Zeichen enthält.',
    'user.email.externalEmail' => 'Externe E-Mail-Adresse',
    'user.email.externalEmailHint' => 'Wird zum Zurücksetzen Ihres Passworts verwendet, falls Sie den Zugriff auf Ihre primäre E-Mail-Adresse verlieren.',
    'user.email.emailsIsEqual' => 'Die externe E-Mail-Adresse stimmt mit der primären überein. Geben Sie bitte eine andere externe E-Mail-Adresse an.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Geben Sie eine interne oder externe E-Mail-Adresse an.',

    'user.profileSection' => 'Allgemeine Informationen',
    'user.contactName' => 'Name des Kontakts',
    'user.email' => 'E-Mail-Adresse',
    'user.role' => 'Benutzerrolle',
    'user.accountSection' => 'Plesk Voreinstellungen',
    'user.login' => 'Benutzername',
    'user.password' => 'Passwort',
    'user.oldPassword' => 'Altes Passwort',
    'user.buttonBack' => 'Zurück',
    'user.generalTab' => 'Allgemein',
    'user.applicationsAccessSection' => 'Dienstleistungen',
    'user.generalPermissionsSection' => 'Rechte',
    'user.contactsTab' => 'Kontaktdaten',
    'user.passwordConfirmation' => 'Passwort bestätigen',
    'user.internalEmailPasswordChanged' => 'Wenn Sie das Passwort ändern, wird auch das interne Passwort der E-Mail-Adresse geändert.',
    'user.emailName' => 'E-Mail-Adresse',
    'user.emailType' => 'E-Mail-Typ',
    'user.companyName' => 'Firmenname',
    'user.phone' => 'Telefonnummer',
    'user.imNumber' => 'Instant Messenger',
    'user.fax' => 'Faxnummer',
    'user.address' => 'Adresse',
    'user.city' => 'Stadt',
    'user.state' => 'US-Staat/Provinz/Region',
    'user.zip' => 'Postleitzahl',
    'user.country' => 'Land',
    'user.additionalInfo' => 'Zusätzliche Informationen',
    'user.additionalInfoHint' => 'Nur Klartext: Alle HTML-Tags werden ignoriert.',
    'user.language' => 'Plesk Sprache',
    'user.buttonChangePassword' => 'Passwort ändern',
    'user.permissionAllow' => 'Gewährt',
    'user.permissionDeny' => 'Nicht gewährt',
    'user.permissionInherited' => 'Definiert durch Rolle',
    'user.emptyContactName' => 'Sie müssen einen Namen für den Kontakt angeben.',
    'user.emptyLogin' => 'Sie müssen einen Benutzernamen angeben.',
    'user.emptyPassword' => 'Sie müssen ein Passwort angeben.',
    'user.emptyPasswordConfirmation' => 'Sie müssen das Passwort bestätigen.',
    'user.oldPasswordIsIncorrect' => 'Das alte Passwort ist falsch. Bitte versuchen Sie es erneut.',
    'user.chooseDomainBoxTitle' => 'Andere Domain auswählen:',
    'user.userIsActive' => 'Benutzer ist aktiv',
    'user.userIsActiveHint' => 'Aktive Benutzer können auf Plesk zugreifen.',
    'user.emailActivation' => 'Account per E-Mail aktivieren',
    'user.emailHint' => 'Wenn Sie einem Nutzer eine auf diesem Server gehostete E-Mail-Adresse bereitstellen wollen, gehen Sie zur Registerkarte E-Mail, erstellen Sie die E-Mail-Adresse und weisen Sie sie diesem Nutzer zu.',
    'user.emailContactHint' => 'Wenden Sie sich an Ihren Administrator, wenn Sie eine auf diesem Server gehostete E-Mail-Adresse verwenden möchten.',
    'user.personalEmailHint' => "Die E-Mail-Adresse dieses Nutzers kann auf der Registerkarte 'E-Mail' geändert werden.",
    'user.externalMailRedirectHint' => 'Die Weiterleitung kann nur für auf diesem Server gehostete E-Mail-Adressen aktiviert werden. Zum Erstellen einer E-Mail-Adresse müssen Sie zur Registerkarte E-Mail wechseln.',
    'user.externalMailRedirectHint2' => 'Die Weiterleitung kann nur für auf diesem Server gehostete E-Mail-Adressen aktiviert werden.',
    'user.externalMailAutoResponderHint' => 'Die automatische Antwort kann nur für auf diesem Server gehostete E-Mail-Adressen aktiviert werden. Zum Erstellen einer E-Mail-Adresse müssen Sie zur Registerkarte E-Mail wechseln.',
    'user.externalMailAutoResponderHint2' => 'Die automatische Antwort kann nur für auf diesem Server gehostete E-Mail-Adressen aktiviert werden.',
    'user.roleHint' => 'Benutzerrollen gewähren Benutzern Administrationsrechte und Zugriff auf Anwendungen, die Sie für die jeweilige Rolle ausgewählt haben.',
    'user.cannotManageMail' => "Sie haben die Berechtigung E-Mail-Einstellungen und Services zu verwalten.",
    'user.longCompanyName' => 'Der angegebene Firmenname ist zu lang.',
    'user.longPhone' => 'Die angegebene Telefonnummer ist zu lang.',
    'user.longFax' => 'Die angegebene Faxnummer ist zu lang.',
    'user.longAddress' => 'Die angegebene Adresse ist zu lang.',
    'user.longCity' => 'Der angegebene Städtename ist zu lang.',
    'user.phoneRegexNotMatch' => 'Die angegebene Telefonnummer ist nicht gültig.',
    'user.faxRegexNotMatch' => 'Die eingegebene Faxnummer ist nicht gültig.',
    'user.shortCity' => 'Der angegebene Städtename ist zu kurz.',
    'user.limitSubscription' => 'Zugriff auf Abonnements',
    'user.limitSubscriptionHint' => 'Hier können Sie Nutzern den Zugriff auf nur ein bestimmtes Abonnement gewähren. Der Wert "Alle" gewährt den Nutzern Zugriff auf alle Abonnements innerhalb Ihres Hosting-Kontos.',
    'user.limitSubscriptionAll' => 'Alle',
    'user.deletedSubscription' => 'Entferntes Abonnement',

    'web.add-domain-alias.title' => 'Domain-Alias hinzufügen',
    'web.add-domain-alias.createdSuccessfully' => "Der Domain-Alias %%name%% wurde erstellt.",
    'web.add-domain-alias.domainAliasName' => 'Domain-Alias-Name',
    'web.add-domain-alias.domainAliasNameHint' => 'Zum Beispiel example.net',
    'web.add-domain-alias.forDomain' => 'für die Domain',
    'web.add-domain-alias.settingsSectionLegend' => 'Einstellungen',
    'web.add-domain-alias.settingsDns' => 'DNS-Zone mit der primären Domain synchronisieren',
    'web.add-domain-alias.settingsMail' => 'E-Mail-Service',
    'web.add-domain-alias.settingsWeb' => 'Webservice',
    'web.add-domain-alias.settingsSeoRedirect' => 'Weiterleiten mit HTTP-Code 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Wenn Besucher die URL des Alias öffnen, werden sie zur URL der primären Domain weitergeleitet. Plesk verwendet die suchmaschinenfreundliche HTTP-301-Weiterleitung, d. h. das Suchmaschinen-Ranking wird nicht zwischen den URLs aufgeteilt.',
    'web.add-domain-alias.settingsTomcat' => 'Java-Webanwendungen',
    'web.add-domain-alias.invalidDomainGuid' => 'Ungültige Domain',

    'web.add-domain.formTitle' => 'Neue Domain hinzufügen',
    'web.add-domain.portalLink' => 'Services-Portal',
    'web.add-domain.domainName' => 'Domainname',
    'web.add-domain.domainNameHint' => "Zum Beispiel example.com",
    'web.add-domain.assignToCustomer' => 'Domain einem Kunden zuweisen',
    'web.add-domain.customer' => 'Kunden auswählen',
    'web.add-domain.createNewCustomer' => 'Neuen Kunden erstellen',
    'web.add-domain.selectExistingCustomer' => 'Bestehenden Kunden auswählen:',
    'web.add-domain.customerContactInfoHint' => 'Geben Sie die Kontaktdaten des Kunden ein. Sie können alle anderen Informationen, wie Telefonnummer und Adresse, später angeben.',
    'web.add-domain.customerLoginInfoHint' => 'Anmeldedaten für das Kunden-Panel',
    'web.add-domain.target' => 'Webspace',
    'web.add-domain.createNewTarget' => 'Neues Abonnement',
    'web.add-domain.createNewTarget_powerUser' => 'Neuer Webspace',
    'web.add-domain.selectExistingTarget' => 'Bestehendes Abonnement auswählen:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Bestehenden Webspace auswählen:',
    'web.add-domain.dns' => 'DNS-Service aktivieren',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'E-Mail-Service aktivieren',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Dies funktioniert, wenn in den Einstellungen für das Abonnement festgelegt wurde, dass die E-Mail-Berechtigungen domainspezifisch verwaltet werden dürfen. Falls dies nicht zugelassen wird, wird der Status des E-Mail-Service vom Abonnement abgerufen.',
    'web.add-domain.hostingManagementOptions' => 'Hosting-Typ',
    'web.add-domain.websiteHosting' => 'Website-Hosting',
    'web.add-domain.websiteForwarding' => 'Weiterleitung',
    'web.add-domain.websiteNoHosting' => 'Kein Hosting',
    'web.add-domain.hostingSettingsSectionLegend' => 'Hosting-Einstellungen',
    'web.add-domain.domainCreatedSuccessfully' => 'Die Domain %%domainName%% wurde erfolgreich erstellt.',
    'web.add-domain.webspaceLegend' => 'Webspace-Einstellungen',
    'web.add-domain.addWhmWebsiteTitle' => 'Hinzufügen einer neuen Website',
    'web.add-domain.addWhmWebsiteHint' => "Sie haben die Wahl, eine Website auf dem Server zu hosten.",
    'web.add-domain.selectWhmDomain' => 'Domain auswählen',
    'web.add-domain.customerLegend' => 'Kundendaten',
    'web.add-domain.credentials' => 'Anmeldedaten für Systembenutzer',
    'web.add-domain.credentialsHint' => 'für den Zugriff auf gehostete Dateien via FTP und SSH',
    'web.add-domain.credentialsHintWin' => 'für den Zugriff auf gehostete Dateien via FTP und RDP',
    'web.add-domain.buttonAddDomain' => 'Domain hinzufügen',

    'web.add-subdomain.formTitle' => 'Subdomain hinzufügen',
    'web.add-subdomain.formGeneralHint' => 'Subdomains sind Internetadressen für verschiedene Bereiche Ihrer Website. Sie bestehen aus Ihrem Domainnamen und einem Präfix. Zum Beispiel: Ihre Domain heißt domain.com, eine Subdomain wäre dann z.B. store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Sie können auch eine Wildcard Subdomain erstellen, indem Sie das Sternchensymbol * anstatt des Namens eingeben. Besucher der Site werden auf diese Subdomain weitergeleitet, ungeachtet des Subdomainnamens, den sie in den Browser eingeben.',
    'web.add-subdomain.subdomainName' => 'Name der Subdomain',
    'web.add-subdomain.subdomainNameHint' => 'Geben Sie * ein, um eine Wildcard Subdomain zu erstellen.',
    'web.add-subdomain.forDomain' => 'Übergeordnete Domain',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Die Subdomain wurde erstellt.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Hosting-Einstellungen',

    'web.setupService.formTitle' => 'Einrichtungsservice: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Der Service \'%%serviceReference%%\' wurde erfolgreich aktualisiert.',

    'web.site-copy.subdomainsGroup' => '%%siteName%%-Subdomains:',
    'web.site-copy.destinationTypeSection' => 'Ziel kopieren',
    'web.site-copy.destinationType' => 'Wählen Sie aus, wohin die Website-Dateien kopiert werden sollen',
    'web.site-copy.destinationTypeSite' => 'Website in Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Kopieren Sie die Website-Dateien auf eine andere Website, die Sie unter diesem Konto hosten. Wenn Sie einen FTP-Zugang zu einem anderen Konto auf diesem Server haben, dann verwenden Sie die FTP-Speicher-Option.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Kopieren Sie die Website-Dateien auf eine andere Website, die Sie auf diesem Server hosten.',
    'web.site-copy.destinationTypeSiteSelect' => 'Name der Website',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Die Dateien der Website %%source%% können nicht nach %%destination%% kopiert werden, da %%destination%% auch ein Bestandteil dieser Dateien ist -- dessen Dokumentstamm ist ein Unterverzeichnis des Dokumentstamms von %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Die Dateien der Website %%destination%% können nicht entfernt werden, da die Dateien aus %%source%% ein Bestandteil dieser Dateien sind -- der Dokumentstamm von %%source%% ist ein Unterverzeichnis von %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'FTP-Speicher',
    'web.site-copy.destinationTypeFtpDescription' => 'Website-Dateien auf ein FTP-Konto auf diesem oder auf einem externen Server kopieren.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Website-Dateien auf ein FTP-Konto auf einen externen Server kopieren.',
    'web.site-copy.destinationTypeFtpHost' => "Hostname des Servers",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Verzeichnis',
    'web.site-copy.destinationTypeFtpUser' => 'Benutzername',
    'web.site-copy.destinationTypeFtpPassword' => 'Passwort',
    'web.site-copy.destinationTypeFtpMode' => 'FTPVerbindungsmethode',
    'web.site-copy.destinationTypeFtpModeActive' => 'Aktiver Modus',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'Im Aktivmodus versendet Plesk seine IP-Adresse und Portnummer zur Kommunikation mit dem externen Server und der Server startet die TCP-Verbindung. Dieser Modus wird für den von Plesk verwalteten Server empfohlen, der nicht durch eine Firewall geschützt wird.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Passiver Modus',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Der Passivmodus kann verwendet werden, wenn sich der von Plesk verwaltete Server hinter einer Firewall befindet und keine eingehenden TCP-Verbindungen annehmen kann.',
    'web.site-copy.existingFiles' => 'Was soll mit vorhandenen Dateien geschehen?',
    'web.site-copy.existingFilesKeep' => 'Vorhandene Dateien auf der Ziel-Site behalten',
    'web.site-copy.existingFilesKeepDescription' => 'Vorhandene Dateien auf der Ziel-Site mit übereinstimmenden Dateinamen überschreiben',
    'web.site-copy.existingFilesDelete' => 'Alle vorhandenen Dateien löschen',
    'web.site-copy.existingFilesDeleteDescription' => 'Alle Site-Dateien auf der Ziel-Site vor dem Kopieren löschen.',
    'web.site-copy.emptyLogin' => 'Geben Sie einen FTP-Konto-Benutzernamen an.',
    'web.site-copy.emptyHost' => 'Geben Sie einen Serverhostnamen an.',
    'web.site-copy.emptyPort' => 'Geben Sie einen Server-Host-Port an.',
    'web.site-copy.copyInProgress' => 'Website %%sourceName%% wird nach %%destinationName%% kopiert. Sie werden per E-Mail (%%email%%) über den Fortschritt benachrichtigt.',
    'web.site-copy.unableToCopy' => 'Das Kopieren der Website-Dateien ist fehlgeschlagen.',
    'web.site-copy.siteCopied' => 'Die Website-Dateien wurden kopiert.',
    'web.site-copy.emailSubjSuccess' => 'Die Website-Dateien "%%source%%" wurden kopiert.',
    'web.site-copy.emailSubjFailure' => 'Das Kopieren der Website-Dateien "%%source%%" ist fehlgeschlagen.',
    'web.site-copy.emailBodySuccess' => 'Die Website-Dateien "%%source%%" wurden nach "%%destination%%" kopiert.',
    'web.site-copy.emailBodyFailure' => 'Der Kopiervorgang der Website-Dateien von "%%source%%" nach "%%destination%%" ist fehlgeschlagen: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Weiterleitungseinstellungen',
    'web._shared.forwardDestination' => 'Zieladresse',
    'web._shared.forwardDestinationHint' => 'URL der Ziel-Website.',
    'web._shared.forwardingTypeOptions' => 'Weiterleitungsart',
    'web._shared.forwardingFrame' => 'Frame-Weiterleitung',
    'web._shared.forwardingFrameHint' => 'Leiten Sie Besucher auf eine andere Website weiter, aber lassen Sie ihnen nicht die Zieladresse anzeigen, damit sie die Weiterleitung nicht bemerken.',
    'web._shared.forwardingHttpCode301' => 'Dauerhaft verschoben (Code 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Leiten Sie Website-Besucher auf eine andere Website weiter und lassen Sie sie die Zieladresse sehen. Eine derartige Weiterleitung sorgt für den Erhalt der Suchmaschinen-Rankings der Website.',
    'web._shared.forwardingHttpCode302' => 'Temporär verschoben (Code 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Leiten Sie Besucher auf eine temporäre Kopie der Website weiter, wenn Sie nicht wollen, dass Suchmaschinen die temporäre Website indexieren.',
    'web._shared.documentRoot' => 'Dokumentstamm',
    'web._shared.documentRootHint' => 'Der Pfad zum Basisverzeichnis der Website.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Der Dokumentstamm kann nicht geändert werden, da Webanwendungen auf dieser Website installiert sind.',
    'web._shared.ipAddress' => 'IP-Adresse',
    'web._shared.shared' => 'gemeinsam genutzt',
    'web._shared.exclusive' => 'dediziert',
    'web._shared.ipAddressHint' => "Die IP-Adresse, auf der die Website gehostet wird, ist eine Netzwerkadresse des virtuellen Hosts der Website.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (anderes Repository)',
    'web._shared.certificate' => 'Zertifikat',
    'web._shared.sameCertificatesHint' => 'Das ausgewählte Zertifikat wird für alle Sites verwendet werden, die auf derselben dedizierten IP-Adresse gehostet werden.',
    'web._shared.differentCertificatesHint' => 'Dieses Abonnement ist mit zwei dedizierten IP-Adressen verlinkt, die über zwei unterschiedliche Zertifikate verfügen. Das ausgewählte Zertifikat wird jedes Zertifikat ersetzen, dass auf den Sites installiert ist, die auf diesen zwei IP-Adressen gehostet werden.',
    'web._shared.differentIpTypesCertificateHint' => 'Das Abonnement ist mit einer gemeinsam verwendeten und einer dedizierten IP-Adresse verlinkt. Das ausgewählte Zertifikat wird für alle anderen Sites verwendet werden, die auf der dedizierten IP-Adresse gehostet werden.',
    'web._shared.certificateNotSelected' => 'Nicht ausgewählt',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Sie haben keine SSL/TLS-Zertifikate in Ihrem Repository. Um ein Zertifikat hinzuzufügen, gehen Sie zu %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'dieser Seite',
    'web._shared.seoRedirectDirection' => 'Bevorzugte Domain',
    'web._shared.seoRedirectDirectionHint' => 'Wählen Sie die URL aus (entweder mit oder ohne Präfix "www."), an die Website-Besucher via SEO-sicherer HTTP-301-Weiterleitung weitergeleitet werden sollen.',
    'web._shared.seoRedirectDirectionNone' => 'Keiner',
    'web._shared.limitMbUnits' => 'MB',

    'web-user.settings.allowScripts' => 'Webbenutzer dürfen Skripte nutzen',

    'web-user.name' => 'Nutzername zur Herstellung einer FTP-Verbindung zum Server',
    'web-user.longName' => 'Dieser Nutzername ist zu lang (maximal erlaubte Zeichen: %max%).',
    'web-user.password' => 'Passwort',
    'web-user.passwordConfirmation' => 'Passwort bestätigen',
    'web-user.hardDiskQuota' => 'Speicherplatzkontingent',
    'web-user.hardDiskQuotaUnlimited' => 'Unbegrenzt',
    'web-user.hardDiskQuotaIsNotSupported' => '(Speicherkontingent wird aufgrund der Konfiguration des Server-Dateisystems nicht unterstützt)',
    'web-user.megabytes' => 'MB',

    'web-user.__asp_win_support' => 'Microsoft ASP-Unterstützung',
    'web-user.__asp_dot_net_support' => 'Microsoft ASP.NET-Unterstützung',
    'web-user.__ssi_support' => 'SSI-Unterstützung',
    'web-user.__php_support' => 'PHP-Unterstützung',
    'web-user.__cgi_support' => 'CGI-Unterstützung',
    'web-user.__perl_unix_support' => 'Perl-Unterstützung',
    'web-user.__perl_win_support' => 'Perl-Unterstützung',
    'web-user.__python_unix_support' => 'Python-Unterstützung',
    'web-user.__python_win_support' => 'Python-Unterstützung',
    'web-user.__fastcgi_unix_support' => 'FastCGI-Unterstützung',
    'web-user.__webstat_support' => 'Webstatistiken',
    'web-user.__apache_errdocs' => 'Benutzerdefinierte Fehlerdokumente',
    'web-user.__hosting_write_modify' => 'Zusätzliche Schreib-/ Änderungsrechte',
    'web-user.__hosting_webdeploy' => 'Veröffentlichen mit Web Deploy',


    'requiredFields' => 'Erforderliche Felder',
];